# R code to dump fair test dataset to
# checking compatibility.
#
# Usage:
#   Rscript test_get_R_tweedie_var_weight.R > res_R_var_weight.py
cat("# This file auto-generated by test_get_R_tweedie_var_weight.R\n")
cat(sprintf("# Using: %s\n", R.Version()$version.string))
cat("import numpy as np\n")
cat("import os\n")
cat("path = os.path.abspath(__file__)\n")
cat("dir_path = os.path.dirname(path)\n")

require(tweedie)
require(statmod)

options(digits=20)
x <- (1.5)^(0:19)

MISSING <- "MISSING"

is.missing <- function(obj) {
  length(obj) == 1 && obj == MISSING
}

pyprint <- function(arr, prefix=NULL, suffix=NULL) {
  if (!is.null(prefix)) {
    cat(prefix)
  }
  if (is.missing(arr)) {
    cat("None\n")
  } else {
    cat("np.array([")
    i <- 1

    # for (val in arr) {
    #   cat(val)
    #   if (i %% 3 == 0) {
    #     cat(",\n ")
    #   }
    #   else {
    #     cat(", ")
    #   }
    #   i <- 1 + i
    # }
    for (val in arr) cat(sprintf('%s, ', val))
    cat("])")
    if (!is.null(dim(arr))) {
      cat(".reshape((")
      for (size in dim(arr)) {
        cat(sprintf("%s, ", size))
      }
      cat("), order=\"F\")")
    }
  }
  if (!is.null(suffix)) {
    cat(sprintf("%s\n", suffix))
  }
  else {
    cat("\n")
  }
}

ys = 0:10
powers = c(1., 1.5, 1.6, 2, 2.5, 3.)
mus = c(0.5, 1., 1.5)
phis = c(0.75, 1., 1.3)

vars <- expand.grid(power=powers, mu=mus, phi=phis)

cat('test_ys=')
pyprint(ys)

cat('test_results=\"\"\"\n')
test_count = 0
for (i in 1:nrow(vars)) {
  test_count = 1 + test_count
  power = vars[i, 'power']
  mu = vars[i, 'mu']
  phi = vars[i, 'phi']
  cat("--BEGIN TEST CASE--\n")
  cat(sprintf("power=%s\n", power))
  cat(sprintf("mu=%s\n", mu))
  cat(sprintf("phi=%s\n", phi))
  cat('density=')
  if (((1 < power) & (power < 2)) | (power > 2)) {
    pyprint(dtweedie.series(ys, power=power, mu=mu, phi=phi))
  } else {
    pyprint(dtweedie(ys, power=power, mu=mu, phi=phi))
  }
  if ((1 < power) & (power < 2)) {
    cat('cdf=')
    pyprint(ptweedie.series(ys, power=power, mu=mu, phi=phi))
  }
  if ((power == 1) | (power == 2) | (power == 3)) {
    cat('cdf=')
    pyprint(ptweedie(ys, power=power, mu=mu, phi=phi))
  }
  cat("--END TEST CASE--\n")
}
cat('\"\"\"\n')

cat(sprintf('num_tests=%s',test_count))
