#!/bin/bash

set -e

# called when DISTRIB=="conda"
source activate $VIRTUALENV
conda remove -y py pytest || pip uninstall -y py pytest

if [[ "$COVERAGE" == "true" ]]; then
    # conda may remove coverage when uninstall pytest and py
    pip install coverage
    # Need to append the coverage to the existing .coverage generated by
    # running the tests. Make sure to reuse the same coverage
    # configuration as the one used by the main pytest run to be
    # able to combine the results.
    CMD="coverage run --rcfile=$BUILD_SOURCESDIRECTORY/.coveragerc"
else
    CMD="python"
fi

# .coverage from running the tests is in TEST_DIR
pushd $TEST_DIR
$CMD -m sklearn.utils.tests.test_estimator_checks
popd
