# Generated by Django 5.1.3 on 2024-12-04 12:37

import lamindb.base.fields
import lamindb.base.ids
import lamindb.base.users
import lamindb.models
from django.db import migrations, models
from django.db.models import CASCADE, PROTECT


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0069_squashed"),
        ("wetlab", "0026_alter_biosample_artifacts_alter_techsample_artifacts"),
    ]

    operations = [
        # Rename Treatment to Perturbation models
        migrations.RenameModel(
            old_name="TreatmentTarget",
            new_name="PerturbationTarget",
        ),
        migrations.RenameModel(
            old_name="GeneticTreatment",
            new_name="GeneticPerturbation",
        ),
        migrations.RenameModel(
            old_name="CompoundTreatment",
            new_name="CompoundPerturbation",
        ),
        migrations.RenameModel(
            old_name="EnvironmentalTreatment",
            new_name="EnvironmentalPerturbation",
        ),
        migrations.RenameModel(
            old_name="CombinationTreatment",
            new_name="CombinationPerturbation",
        ),
        migrations.RenameModel(
            old_name="ArtifactTreatmentTarget",
            new_name="ArtifactPerturbationTarget",
        ),
        migrations.RenameModel(
            old_name="ArtifactGeneticTreatment",
            new_name="ArtifactGeneticPerturbation",
        ),
        migrations.RenameModel(
            old_name="ArtifactCompoundTreatment",
            new_name="ArtifactCompoundPerturbation",
        ),
        migrations.RenameModel(
            old_name="ArtifactEnvironmentalTreatment",
            new_name="ArtifactEnvironmentalPerturbation",
        ),
        migrations.RenameModel(
            old_name="ArtifactCombinationTreatment",
            new_name="ArtifactCombinationPerturbation",
        ),
        # Rename fields in Artifact link models
        migrations.RenameField(
            model_name="ArtifactPerturbationTarget",
            old_name="treatmenttarget",
            new_name="perturbationtarget",
        ),
        migrations.RenameField(
            model_name="ArtifactGeneticPerturbation",
            old_name="genetictreatment",
            new_name="geneticperturbation",
        ),
        migrations.RenameField(
            model_name="ArtifactCompoundPerturbation",
            old_name="compoundtreatment",
            new_name="compoundperturbation",
        ),
        migrations.RenameField(
            model_name="ArtifactEnvironmentalPerturbation",
            old_name="environmentaltreatment",
            new_name="environmentalperturbation",
        ),
        migrations.RenameField(
            model_name="ArtifactCombinationPerturbation",
            old_name="combinationtreatment",
            new_name="combinationperturbation",
        ),
        # Create new Donor model
        migrations.CreateModel(
            name="ArtifactDonor",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=CASCADE,
                        related_name="links_donor",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=PROTECT,
                        related_name="links_artifactdonor",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.CreateModel(
            name="Donor",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        default=lamindb.base.ids.base62_12,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=255
                    ),
                ),
                (
                    "batch",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=60
                    ),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "age",
                    lamindb.base.fields.IntegerField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
                (
                    "bmi",
                    lamindb.base.fields.FloatField(blank=True, default=None, null=True),
                ),
                (
                    "_previous_runs",
                    models.ManyToManyField(related_name="+", to="lamindb.run"),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="donors",
                        through="wetlab.ArtifactDonor",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "diseases",
                    models.ManyToManyField(related_name="donors", to="bionty.disease"),
                ),
                (
                    "ethnicity",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=PROTECT,
                        related_name="donors",
                        to="bionty.ethnicity",
                    ),
                ),
                (
                    "organism",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=PROTECT,
                        related_name="donors",
                        to="bionty.organism",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "sex",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=PROTECT,
                        related_name="donors",
                        to="bionty.phenotype",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.CanCurate, models.Model),
        ),
        migrations.AddField(
            model_name="artifactdonor",
            name="donor",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=PROTECT,
                related_name="links_artifact",
                to="wetlab.donor",
            ),
        ),
        # Add related_name changes for perturbation targets
        migrations.AlterField(
            model_name="PerturbationTarget",
            name="genes",
            field=models.ManyToManyField(
                "bionty.Gene", related_name="perturbation_targets"
            ),
        ),
        migrations.AlterField(
            model_name="PerturbationTarget",
            name="pathways",
            field=models.ManyToManyField(
                "bionty.Pathway", related_name="perturbation_targets"
            ),
        ),
        migrations.AlterField(
            model_name="PerturbationTarget",
            name="proteins",
            field=models.ManyToManyField(
                "bionty.Protein", related_name="perturbation_targets"
            ),
        ),
        migrations.AlterField(
            model_name="geneticperturbation",
            name="sequence",
            field=models.TextField(db_index=True, default=None, null=True),
        ),
        migrations.AlterField(
            model_name="geneticperturbation",
            name="system",
            field=models.CharField(db_index=True, default=None, max_length=32),
        ),
        migrations.AlterField(
            model_name="artifactcombinationperturbation",
            name="artifact",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=CASCADE,
                related_name="links_combination_perturbation",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="artifactcombinationperturbation",
            name="feature",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=PROTECT,
                related_name="links_artifactcombinationperturbation",
                to="lamindb.feature",
            ),
        ),
        migrations.AlterField(
            model_name="artifactcompoundperturbation",
            name="artifact",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=CASCADE,
                related_name="links_compound_perturbation",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="artifactcompoundperturbation",
            name="feature",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=PROTECT,
                related_name="links_artifactcompoundperturbation",
                to="lamindb.feature",
            ),
        ),
        migrations.AlterField(
            model_name="artifactenvironmentalperturbation",
            name="artifact",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=CASCADE,
                related_name="links_environmental_perturbation",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="artifactenvironmentalperturbation",
            name="feature",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=PROTECT,
                related_name="links_artifactenvironmentalperturbation",
                to="lamindb.feature",
            ),
        ),
        migrations.AlterField(
            model_name="artifactgeneticperturbation",
            name="artifact",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=CASCADE,
                related_name="links_genetic_perturbation",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="artifactgeneticperturbation",
            name="feature",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=PROTECT,
                related_name="links_artifactgeneticperturbation",
                to="lamindb.feature",
            ),
        ),
        migrations.AlterField(
            model_name="artifactperturbationtarget",
            name="artifact",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=CASCADE,
                related_name="links_perturbation_target",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="artifactperturbationtarget",
            name="feature",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=PROTECT,
                related_name="links_artifactperturbationtarget",
                to="lamindb.feature",
            ),
        ),
        migrations.AlterField(
            model_name="combinationperturbation",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="combination_perturbations",
                through="wetlab.ArtifactCombinationPerturbation",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="combinationperturbation",
            name="compounds",
            field=models.ManyToManyField(
                related_name="compound_perturbations", to="wetlab.compoundperturbation"
            ),
        ),
        migrations.AlterField(
            model_name="combinationperturbation",
            name="environmentals",
            field=models.ManyToManyField(
                related_name="environmental_perturbations",
                to="wetlab.environmentalperturbation",
            ),
        ),
        migrations.AlterField(
            model_name="combinationperturbation",
            name="genetics",
            field=models.ManyToManyField(
                related_name="genetic_perturbations", to="wetlab.geneticperturbation"
            ),
        ),
        migrations.AlterField(
            model_name="compoundperturbation",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="compound_perturbations",
                through="wetlab.ArtifactCompoundPerturbation",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="environmentalperturbation",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="environmental_perturbations",
                through="wetlab.ArtifactEnvironmentalPerturbation",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="geneticperturbation",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="genetic_perturbations",
                through="wetlab.ArtifactGeneticPerturbation",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="perturbationtarget",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="perturbation_targets",
                through="wetlab.ArtifactPerturbationTarget",
                to="lamindb.artifact",
            ),
        ),
    ]
