from collections.abc import Mapping
from typing import List
from boto3.resources.collection import ResourceCollection
from botocore.waiter import Waiter
from botocore.paginate import Paginator
from botocore.client import BaseClient


class AccessAnalyzer(BaseClient):
    r"""AWS IAM Access Analyzer helps identify potential resource-access risks by enabling you to identify any policies that grant access to an external principal. It does this by using logic-based reasoning to analyze resource-based policies in your AWS environment. An external principal can be another AWS account, a root user, an IAM user or role, a federated user, an AWS service, or an anonymous user. This guide describes the AWS IAM Access Analyzer operations that you can call programmatically. For general information about Access Analyzer, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html">AWS IAM Access Analyzer section of the IAM User Guide</a>. To start using Access Analyzer, you first need to create an analyzer."""


    class ListAnalyzedResourcesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_analyzed_resources` for valid parameters"""
            pass
    class ListAnalyzersPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_analyzers` for valid parameters"""
            pass
    class ListArchiveRulesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_archive_rules` for valid parameters"""
            pass
    class ListFindingsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_findings` for valid parameters"""
            pass


    class CreateAnalyzerRequest(Mapping):
        pass
    
    class CreateAnalyzerResponse(Mapping):
        pass
    
    class InlineArchiveRule(Mapping):
        pass
    
    class TagsMap(object):
        pass
    
    class CreateArchiveRuleRequest(Mapping):
        pass
    
    class FilterCriteriaMap(object):
        pass
    
    class DeleteAnalyzerRequest(Mapping):
        pass
    
    class DeleteArchiveRuleRequest(Mapping):
        pass
    
    class GetAnalyzedResourceRequest(Mapping):
        pass
    
    class GetAnalyzedResourceResponse(Mapping):
        pass
    
    class GetAnalyzerRequest(Mapping):
        pass
    
    class GetAnalyzerResponse(Mapping):
        pass
    
    class GetArchiveRuleRequest(Mapping):
        pass
    
    class GetArchiveRuleResponse(Mapping):
        pass
    
    class GetFindingRequest(Mapping):
        pass
    
    class GetFindingResponse(Mapping):
        pass
    
    class ListAnalyzedResourcesRequest(Mapping):
        pass
    
    class ListAnalyzedResourcesResponse(Mapping):
        pass
    
    class ListAnalyzersRequest(Mapping):
        pass
    
    class ListAnalyzersResponse(Mapping):
        pass
    
    class ListArchiveRulesRequest(Mapping):
        pass
    
    class ListArchiveRulesResponse(Mapping):
        pass
    
    class ListFindingsRequest(Mapping):
        pass
    
    class ListFindingsResponse(Mapping):
        pass
    
    class SortCriteria(Mapping):
        pass
    
    class ListTagsForResourceRequest(Mapping):
        pass
    
    class ListTagsForResourceResponse(Mapping):
        pass
    
    class StartResourceScanRequest(Mapping):
        pass
    
    class TagResourceRequest(Mapping):
        pass
    
    class TagResourceResponse(Mapping):
        pass
    
    class UntagResourceRequest(Mapping):
        pass
    
    class UntagResourceResponse(Mapping):
        pass
    
    class String(object):
        pass
    
    class UpdateArchiveRuleRequest(Mapping):
        pass
    
    class UpdateFindingsRequest(Mapping):
        pass
    
    class FindingId(object):
        pass
    
    def create_analyzer(self, type: str, analyzerName: str, archiveRules: List[InlineArchiveRule]=None, clientToken: str=None, tags: TagsMap=None) -> CreateAnalyzerResponse:
        r"""Creates an analyzer for your account.

        :param self:
        :param type:  The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer per account per Region.<br/>tags:  The tags to apply to the analyzer.<br/>clientToken:  A client token.<br/>archiveRules:  Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.<br/>analyzerName:  The name of the analyzer to create.<br/>
        :return: arn:  The ARN of the analyzer that was created by the request.<br/>        """
        pass

    def create_archive_rule(self, ruleName: str, filter: FilterCriteriaMap, analyzerName: str, clientToken: str=None):
        r"""Creates an archive rule for the specified analyzer. Archive rules automatically archive findings that meet the criteria you define when you create the rule.

        :param self:
        :param ruleName:  The name of the rule to create.<br/>filter:  The criteria for the rule.<br/>clientToken:  A client token.<br/>analyzerName:  The name of the created analyzer.<br/>
        :return:         """
        pass

    def delete_analyzer(self, analyzerName: str, clientToken: str=None):
        r"""Deletes the specified analyzer. When you delete an analyzer, Access Analyzer is disabled for the account in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.

        :param self:
        :param clientToken:  A client token.<br/>analyzerName:  The name of the analyzer to delete.<br/>
        :return:         """
        pass

    def delete_archive_rule(self, ruleName: str, analyzerName: str, clientToken: str=None):
        r"""Deletes the specified archive rule.

        :param self:
        :param ruleName:  The name of the rule to delete.<br/>clientToken:  A client token.<br/>analyzerName:  The name of the analyzer that associated with the archive rule to delete.<br/>
        :return:         """
        pass

    def get_analyzed_resource(self, resourceArn: str, analyzerArn: str) -> GetAnalyzedResourceResponse:
        r"""Retrieves information about a resource that was analyzed.

        :param self:
        :param resourceArn:  The ARN of the resource to retrieve information about.<br/>analyzerArn:  The ARN of the analyzer to retrieve information from.<br/>
        :return: resource:  An <code>AnalyedResource</code> object that contains information that Access Analyzer found when it analyzed the resource.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updatedAt</i> The time at which the finding was updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the finding generated from the analyzed resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>sharedVia</i> Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceType</i> The type of the resource that was analyzed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwnerAccount</i> The AWS account ID that owns the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceArn</i> The ARN of the resource that was analyzed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>isPublic</i> Indicates whether the policy that generated the finding grants public access to the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>error</i> An error message.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The time at which the finding was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>analyzedAt</i> The time at which the resource was analyzed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>actions</i> The actions that an external principal is granted permission to use by the policy that generated the finding.<br/>        """
        pass

    def get_analyzer(self, analyzerName: str) -> GetAnalyzerResponse:
        r"""Retrieves information about the specified analyzer.

        :param self:
        :param analyzerName:  The name of the analyzer retrieved.<br/>
        :return: analyzer:  An <code>AnalyzerSummary</code> object that contains information about the analyzer.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i> The tags added to the analyzer.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusReason</i> The <code>statusReason</code> provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status is displayed. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the AWS organization.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>statusReason</b>: The <code>statusReason</code> provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status is displayed. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the AWS organization.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the analyzer. An <code>Active</code> analyzer successfully monitors supported resources and generates new findings. The analyzer is <code>Disabled</code> when a user action, such as removing trusted access for IAM Access Analyzer from AWS Organizations, causes the analyzer to stop generating new findings. The status is <code>Creating</code> when the analyzer creation is in progress and <code>Failed</code> when the analyzer creation has failed. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i> The name of the analyzer.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>lastResourceAnalyzedAt</i> The time at which the most recently analyzed resource was analyzed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>lastResourceAnalyzed</i> The resource that was most recently analyzed by the analyzer.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> A timestamp for the time at which the analyzer was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The ARN of the analyzer.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>code</i> The reason code for the current status of the analyzer.<br/>        """
        pass

    def get_archive_rule(self, ruleName: str, analyzerName: str) -> GetArchiveRuleResponse:
        r"""Retrieves information about an archive rule.

        :param self:
        :param ruleName:  The name of the rule to retrieve.<br/>analyzerName:  The name of the analyzer to retrieve rules from.<br/>
        :return: archiveRule:  Contains information about an archive rule.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updatedAt</i> The time at which the archive rule was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ruleName</i> The name of the archive rule.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>filter</i> A filter used to define the archive rule.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The time at which the archive rule was created.<br/>        """
        pass

    def get_finding(self, id: str, analyzerArn: str) -> GetFindingResponse:
        r"""Retrieves information about the specified finding.

        :param self:
        :param id:  The ID of the finding to retrieve.<br/>analyzerArn:  The ARN of the analyzer that generated the finding.<br/>
        :return: finding:  A <code>finding</code> object that contains finding details.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updatedAt</i> The time at which the finding was updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the finding.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>sources</i> The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceType</i> The type of the resource reported in the finding.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwnerAccount</i> The AWS account ID that owns the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>resource</i> The resource that an external principal has access to.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>principal</i> The external principal that access to a resource within the zone of trust.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>isPublic</i> Indicates whether the policy that generated the finding allows public access to the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>id</i> The ID of the finding.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>error</i> An error.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The time at which the finding was generated.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>condition</i> The condition in the analyzed policy statement that resulted in a finding.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>analyzedAt</i> The time at which the resource was analyzed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>action</i> The action in the analyzed policy statement that an external principal has permission to use.<br/>        """
        pass

    def list_analyzed_resources(self, analyzerArn: str, maxResults: int=None, nextToken: str=None, resourceType: str=None) -> ListAnalyzedResourcesResponse:
        r"""Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..

        :param self:
        :param resourceType:  The type of resource.<br/>nextToken:  A token used for pagination of results returned.<br/>maxResults:  The maximum number of results to return in the response.<br/>analyzerArn:  The ARN of the analyzer to retrieve a list of analyzed resources from.<br/>
        :return: nextToken:  A token used for pagination of results returned.<br/>analyzedResources:  A list of resources that were analyzed.<br/>        """
        pass

    def list_analyzers(self, maxResults: int=None, nextToken: str=None, type: str=None) -> ListAnalyzersResponse:
        r"""Retrieves a list of analyzers.

        :param self:
        :param type:  The type of analyzer.<br/>nextToken:  A token used for pagination of results returned.<br/>maxResults:  The maximum number of results to return in the response.<br/>
        :return: nextToken:  A token used for pagination of results returned.<br/>analyzers:  The analyzers retrieved.<br/>        """
        pass

    def list_archive_rules(self, analyzerName: str, maxResults: int=None, nextToken: str=None) -> ListArchiveRulesResponse:
        r"""Retrieves a list of archive rules created for the specified analyzer.

        :param self:
        :param nextToken:  A token used for pagination of results returned.<br/>maxResults:  The maximum number of results to return in the request.<br/>analyzerName:  The name of the analyzer to retrieve rules from.<br/>
        :return: nextToken:  A token used for pagination of results returned.<br/>archiveRules:  A list of archive rules created for the specified analyzer.<br/>        """
        pass

    def list_findings(self, analyzerArn: str, filter: FilterCriteriaMap=None, maxResults: int=None, nextToken: str=None, sort: SortCriteria=None) -> ListFindingsResponse:
        r"""Retrieves a list of findings generated by the specified analyzer.

        :param self:
        :param sort:  The sort order for the findings returned.:<br/>nextToken:  A token used for pagination of results returned.<br/>maxResults:  The maximum number of results to return in the response.<br/>filter:  A filter to match for the findings to return.<br/>analyzerArn:  The ARN of the analyzer to retrieve findings from.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>orderBy</i> The sort order, ascending or descending.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>attributeName</i> The name of the attribute to sort on.<br/>
        :return: nextToken:  A token used for pagination of results returned.<br/>findings:  A list of findings retrieved from the analyzer that match the filter criteria specified, if any.<br/>        """
        pass

    def list_tags_for_resource(self, resourceArn: str) -> ListTagsForResourceResponse:
        r"""Retrieves a list of tags applied to the specified resource.

        :param self:
        :param resourceArn:  The ARN of the resource to retrieve tags from.<br/>
        :return: tags:  The tags that are applied to the specified resource.<br/>        """
        pass

    def start_resource_scan(self, resourceArn: str, analyzerArn: str):
        r"""Immediately starts a scan of the policies applied to the specified resource.

        :param self:
        :param resourceArn:  The ARN of the resource to scan.<br/>analyzerArn:  The ARN of the analyzer to use to scan the policies applied to the specified resource.<br/>
        :return:         """
        pass

    def tag_resource(self, tags: TagsMap, resourceArn: str) -> TagResourceResponse:
        r"""Adds a tag to the specified resource.

        :param self:
        :param tags:  The tags to add to the resource.<br/>resourceArn:  The ARN of the resource to add the tag to.<br/>
        :return:         """
        pass

    def untag_resource(self, tagKeys: List[String], resourceArn: str) -> UntagResourceResponse:
        r"""Removes a tag from the specified resource.

        :param self:
        :param tagKeys:  The key for the tag to add.<br/>resourceArn:  The ARN of the resource to remove the tag from.<br/>
        :return:         """
        pass

    def update_archive_rule(self, ruleName: str, filter: FilterCriteriaMap, analyzerName: str, clientToken: str=None):
        r"""Updates the criteria and values for the specified archive rule.

        :param self:
        :param ruleName:  The name of the rule to update.<br/>filter:  A filter to match for the rules to update. Only rules that match the filter are updated.<br/>clientToken:  A client token.<br/>analyzerName:  The name of the analyzer to update the archive rules for.<br/>
        :return:         """
        pass

    def update_findings(self, status: str, analyzerArn: str, clientToken: str=None, ids: List[FindingId]=None, resourceArn: str=None):
        r"""Updates the status for the specified findings.

        :param self:
        :param status:  The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.<br/>resourceArn:  The ARN of the resource identified in the finding.<br/>ids:  The IDs of the findings to update.<br/>clientToken:  A client token.<br/>analyzerArn:  The ARN of the analyzer that generated the findings to update.<br/>
        :return:         """
        pass



class ACM(BaseClient):
    r"""<fullname>AWS Certificate Manager</fullname> Welcome to the AWS Certificate Manager (ACM) API documentation. You can use ACM to manage SSL/TLS certificates for your AWS-based websites and applications. For general information about using ACM, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/"> <i>AWS Certificate Manager User Guide</i> </a>."""

    class CertificateValidatedWaiter(Waiter):
        def wait(self, **kwargs):
            r"""see function `describe_certificate` for valid parameters"""
            pass


    class ListCertificatesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_certificates` for valid parameters"""
            pass


    class AddTagsToCertificateRequest(Mapping):
        pass
    
    class Tag(Mapping):
        pass
    
    class DeleteCertificateRequest(Mapping):
        pass
    
    class DescribeCertificateRequest(Mapping):
        pass
    
    class DescribeCertificateResponse(Mapping):
        pass
    
    class ExportCertificateRequest(Mapping):
        pass
    
    class ExportCertificateResponse(Mapping):
        pass
    
    class PassphraseBlob(object):
        pass
    
    class GetCertificateRequest(Mapping):
        pass
    
    class GetCertificateResponse(Mapping):
        pass
    
    class ImportCertificateRequest(Mapping):
        pass
    
    class ImportCertificateResponse(Mapping):
        pass
    
    class CertificateBodyBlob(object):
        pass
    
    class PrivateKeyBlob(object):
        pass
    
    class CertificateChainBlob(object):
        pass
    
    class ListCertificatesRequest(Mapping):
        pass
    
    class ListCertificatesResponse(Mapping):
        pass
    
    class CertificateStatus(object):
        pass
    
    class Filters(Mapping):
        pass
    
    class ListTagsForCertificateRequest(Mapping):
        pass
    
    class ListTagsForCertificateResponse(Mapping):
        pass
    
    class RemoveTagsFromCertificateRequest(Mapping):
        pass
    
    class RenewCertificateRequest(Mapping):
        pass
    
    class RequestCertificateRequest(Mapping):
        pass
    
    class RequestCertificateResponse(Mapping):
        pass
    
    class DomainNameString(object):
        pass
    
    class DomainValidationOption(Mapping):
        pass
    
    class CertificateOptions(Mapping):
        pass
    
    class ResendValidationEmailRequest(Mapping):
        pass
    
    class UpdateCertificateOptionsRequest(Mapping):
        pass
    
    def add_tags_to_certificate(self, Tags: List[Tag], CertificateArn: str):
        r"""Adds one or more tags to an ACM certificate. Tags are labels that you can use to identify and organize your AWS resources. Each tag consists of a <code>key</code> and an optional <code>value</code>. You specify the certificate on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair.  You can apply a tag to just one certificate if you want to identify a specific characteristic of that certificate, or you can apply the same tag to multiple certificates if you want to filter for a common relationship among those certificates. Similarly, you can apply the same tag to multiple resources if you want to specify a relationship among those resources. For example, you can add the same tag to an ACM certificate and an Elastic Load Balancing load balancer to indicate that they are both used by the same website. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/tags.html">Tagging ACM certificates</a>.  To remove one or more tags, use the <a>RemoveTagsFromCertificate</a> action. To view all of the tags that have been applied to the certificate, use the <a>ListTagsForCertificate</a> action. 

        :param self:
        :param Tags:  The key-value pair that defines the tag. The tag value is optional.<br/>CertificateArn:  String that contains the ARN of the ACM certificate to which the tag is to be applied. This must be of the form:  <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code>  For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>. <br/>
        :return:         """
        pass

    def delete_certificate(self, CertificateArn: str):
        r"""Deletes a certificate and its associated private key. If this action succeeds, the certificate no longer appears in the list that can be displayed by calling the <a>ListCertificates</a> action or be retrieved by calling the <a>GetCertificate</a> action. The certificate will not be available for use by AWS services integrated with ACM.  <note> You cannot delete an ACM certificate that is being used by another AWS service. To delete a certificate that is in use, the certificate association must first be removed. </note>

        :param self:
        :param CertificateArn:  String that contains the ARN of the ACM certificate to be deleted. This must be of the form:  <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code>  For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.<br/>
        :return:         """
        pass

    def describe_certificate(self, CertificateArn: str) -> DescribeCertificateResponse:
        r"""Returns detailed metadata about the specified ACM certificate.

        :param self:
        :param CertificateArn:  The Amazon Resource Name (ARN) of the ACM certificate. The ARN must have the following form:  <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code>  For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.<br/>
        :return: Certificate:  Metadata about an ACM certificate.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Options</i> Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Options</b>: Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RenewalEligibility</i> Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the <a>RenewCertificate</a> command.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateAuthorityArn</i> The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued the certificate. This has the following format:   <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ExtendedKeyUsages</i> Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID). <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>KeyUsages</i> A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RenewalSummary</i> Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>RenewalSummary</b>: Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Type</i> The source of the certificate. For certificates provided by ACM, this value is <code>AMAZON_ISSUED</code>. For certificates that you imported with <a>ImportCertificate</a>, this value is <code>IMPORTED</code>. ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>AWS Certificate Manager User Guide</i>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>FailureReason</i> The reason the certificate request failed. This value exists only when the certificate status is <code>FAILED</code>. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request Failed</a> in the <i>AWS Certificate Manager User Guide</i>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>InUseBy</i> A list of ARNs for the AWS resources that are using the certificate. A certificate can be used by multiple AWS resources. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SignatureAlgorithm</i> The algorithm that was used to sign the certificate.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>KeyAlgorithm</i> The algorithm that was used to generate the public-private key pair.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>NotAfter</i> The time after which the certificate is not valid.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>NotBefore</i> The time before which the certificate is not valid.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RevocationReason</i> The reason the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RevokedAt</i> The time at which the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Status</i> The status of the certificate.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ImportedAt</i> The date and time at which the certificate was imported. This value exists only when the certificate type is <code>IMPORTED</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>IssuedAt</i> The time at which the certificate was issued. This value exists only when the certificate type is <code>AMAZON_ISSUED</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CreatedAt</i> The time at which the certificate was requested. This value exists only when the certificate type is <code>AMAZON_ISSUED</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Issuer</i> The name of the certificate authority that issued and signed the certificate.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Subject</i> The name of the entity that is associated with the public key contained in the certificate.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Serial</i> The serial number of the certificate.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DomainValidationOptions</i> Contains information about the initial validation of each domain name that occurs as a result of the <a>RequestCertificate</a> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SubjectAlternativeNames</i> One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DomainName</i> The fully qualified domain name for the certificate, such as www.example.com or example.com.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateArn</i> The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>UpdatedAt</i> The time at which the renewal summary was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>RenewalStatusReason</i> The reason that a renewal request was unsuccessful.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>DomainValidationOptions</i> Contains information about the validation of each domain name in the certificate, as it pertains to ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a>. This is different from the initial validation that occurs as a result of the <a>RequestCertificate</a> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>RenewalStatus</i> The status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> of the certificate.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateTransparencyLoggingPreference</i> You can opt out of certificate transparency logging by specifying the <code>DISABLED</code> option. Opt in by specifying <code>ENABLED</code>. <br/>        """
        pass

    def export_certificate(self, Passphrase: PassphraseBlob, CertificateArn: str) -> ExportCertificateResponse:
        r"""Exports a private certificate issued by a private certificate authority (CA) for use anywhere. The exported file contains the certificate, the certificate chain, and the encrypted private 2048-bit RSA key associated with the public key that is embedded in the certificate. For security, you must assign a passphrase for the private key when exporting it.  For information about exporting and formatting a certificate using the ACM console or CLI, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html">Export a Private Certificate</a>.

        :param self:
        :param Passphrase:  Passphrase to associate with the encrypted exported private key. If you want to later decrypt the private key, you must have the passphrase. You can use the following OpenSSL command to decrypt a private key:   <code>openssl rsa -in encrypted_key.pem -out decrypted_key.pem</code> <br/>CertificateArn:  An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:  <code>arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012</code> <br/>
        :return: PrivateKey:  The encrypted private key associated with the public key in the certificate. The key is output in PKCS #8 format and is base64 PEM-encoded. <br/>CertificateChain:  The base64 PEM-encoded certificate chain. This does not include the certificate that you are exporting.<br/>Certificate:  The base64 PEM-encoded certificate.<br/>        """
        pass

    def get_certificate(self, CertificateArn: str) -> GetCertificateResponse:
        r"""Retrieves an Amazon-issued certificate and its certificate chain. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs. All of the certificates are base64 encoded. You can use <a href="https://wiki.openssl.org/index.php/Command_Line_Utilities">OpenSSL</a> to decode the certificates and inspect individual fields.

        :param self:
        :param CertificateArn:  String that contains a certificate ARN in the following format:  <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code>  For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.<br/>
        :return: CertificateChain:  Certificates forming the requested certificate's chain of trust. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs. <br/>Certificate:  The ACM-issued certificate corresponding to the ARN specified as input.<br/>        """
        pass

    def import_certificate(self, PrivateKey: PrivateKeyBlob, Certificate: CertificateBodyBlob, CertificateArn: str=None, CertificateChain: CertificateChainBlob=None, Tags: List[Tag]=None) -> ImportCertificateResponse:
        r"""Imports a certificate into AWS Certificate Manager (ACM) to use with services that are integrated with ACM. Note that <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html">integrated services</a> allow only certificate types and keys they support to be associated with their resources. Further, their support differs depending on whether the certificate is imported into IAM or into ACM. For more information, see the documentation for each service. For more information about importing certificates into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>AWS Certificate Manager User Guide</i>.  <note> ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for certificates that you import. </note> Note the following guidelines when importing third party certificates: <ul> <li> You must enter the private key that matches the certificate you are importing. </li> <li> The private key must be unencrypted. You cannot import a private key that is protected by a password or a passphrase. </li> <li> If the certificate you are importing is not self-signed, you must enter its certificate chain. </li> <li> If a certificate chain is included, the issuer must be the subject of one of the certificates in the chain. </li> <li> The certificate, private key, and certificate chain must be PEM-encoded. </li> <li> The current time must be between the <code>Not Before</code> and <code>Not After</code> certificate fields. </li> <li> The <code>Issuer</code> field must not be empty. </li> <li> The OCSP authority URL, if present, must not exceed 1000 characters. </li> <li> To import a new certificate, omit the <code>CertificateArn</code> argument. Include this argument only when you want to replace a previously imported certifica </li> <li> When you import a certificate by using the CLI, you must specify the certificate, the certificate chain, and the private key by their file names preceded by <code>file://</code>. For example, you can specify a certificate saved in the <code>C:\temp</code> folder as <code>file://C:\temp\certificate_to_import.pem</code>. If you are making an HTTP or HTTPS Query request, include these arguments as BLOBs.  </li> <li> When you import a certificate by using an SDK, you must specify the certificate, the certificate chain, and the private key files in the manner required by the programming language you're using.  </li> <li> The cryptographic algorithm of an imported certificate must match the algorithm of the signing CA. For example, if the signing CA key type is RSA, then the certificate key type must also be RSA. </li> </ul> This operation returns the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the imported certificate.

        :param self:
        :param Tags:  One or more resource tags to associate with the imported certificate.  Note: You cannot apply tags when reimporting a certificate.<br/>CertificateChain:  The PEM encoded certificate chain.<br/>PrivateKey:  The private key that matches the public key in the certificate.<br/>Certificate:  The certificate to import.<br/>CertificateArn:  The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an imported certificate to replace. To import a new certificate, omit this field. <br/>
        :return: CertificateArn:  The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the imported certificate.<br/>        """
        pass

    def list_certificates(self, CertificateStatuses: List[CertificateStatus]=None, Includes: Filters=None, NextToken: str=None, MaxItems: int=None) -> ListCertificatesResponse:
        r"""Retrieves a list of certificate ARNs and domain names. You can request that only certificates that match a specific status be listed. You can also filter by specific attributes of the certificate. Default filtering returns only <code>RSA_2048</code> certificates. For more information, see <a>Filters</a>.

        :param self:
        :param MaxItems:  Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.<br/>NextToken:  Use this parameter only when paginating results and only in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextToken</code> from the response you just received.<br/>Includes:  Filter the certificate list. For more information, see the <a>Filters</a> structure.:<br/>CertificateStatuses:  Filter the certificate list by status value.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>keyTypes</i> Specify one or more algorithms that can be used to generate key pairs. Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types, provide the desired type signatures in a comma-separated list. For example, <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code> certificates.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>keyUsage</i> Specify one or more <a>KeyUsage</a> extension values.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>extendedKeyUsage</i> Specify one or more <a>ExtendedKeyUsage</a> extension values.<br/>
        :return: CertificateSummaryList:  A list of ACM certificates.<br/>NextToken:  When the list is truncated, this value is present and contains the value to use for the <code>NextToken</code> parameter in a subsequent pagination request.<br/>        """
        pass

    def list_tags_for_certificate(self, CertificateArn: str) -> ListTagsForCertificateResponse:
        r"""Lists the tags that have been applied to the ACM certificate. Use the certificate's Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate, use the <a>AddTagsToCertificate</a> action. To delete a tag, use the <a>RemoveTagsFromCertificate</a> action. 

        :param self:
        :param CertificateArn:  String that contains the ARN of the ACM certificate for which you want to list the tags. This must have the following form:  <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code>  For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>. <br/>
        :return: Tags:  The key-value pairs that define the applied tags.<br/>        """
        pass

    def remove_tags_from_certificate(self, Tags: List[Tag], CertificateArn: str):
        r"""Remove one or more tags from an ACM certificate. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this function, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value.  To add tags to a certificate, use the <a>AddTagsToCertificate</a> action. To view all of the tags that have been applied to a specific ACM certificate, use the <a>ListTagsForCertificate</a> action. 

        :param self:
        :param Tags:  The key-value pair that defines the tag to remove.<br/>CertificateArn:  String that contains the ARN of the ACM Certificate with one or more tags that you want to remove. This must be of the form:  <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code>  For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>. <br/>
        :return:         """
        pass

    def renew_certificate(self, CertificateArn: str):
        r"""Renews an eligable ACM certificate. At this time, only exported private certificates can be renewed with this operation. In order to renew your ACM PCA certificates with ACM, you must first <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaPermissions.html">grant the ACM service principal permission to do so</a>. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/manual-renewal.html">Testing Managed Renewal</a> in the ACM User Guide.

        :param self:
        :param CertificateArn:  String that contains the ARN of the ACM certificate to be renewed. This must be of the form:  <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code>  For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.<br/>
        :return:         """
        pass

    def request_certificate(self, DomainName: str, ValidationMethod: str=None, SubjectAlternativeNames: List[DomainNameString]=None, IdempotencyToken: str=None, DomainValidationOptions: List[DomainValidationOption]=None, Options: CertificateOptions=None, CertificateAuthorityArn: str=None, Tags: List[Tag]=None) -> RequestCertificateResponse:
        r"""Requests an ACM certificate for use with other AWS services. To request an ACM certificate, you must specify a fully qualified domain name (FQDN) in the <code>DomainName</code> parameter. You can also specify additional FQDNs in the <code>SubjectAlternativeNames</code> parameter.  If you are requesting a private certificate, domain validation is not required. If you are requesting a public certificate, each domain name that you specify must be validated to verify that you own or control the domain. You can use <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">DNS validation</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">email validation</a>. We recommend that you use DNS validation. ACM issues public certificates after receiving approval from the domain owner. 

        :param self:
        :param Tags:  One or more resource tags to associate with the certificate.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate. If you do not provide an ARN and you are trying to request a private certificate, ACM will attempt to issue a public certificate. For more information about private CAs, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html">AWS Certificate Manager Private Certificate Authority (PCA)</a> user guide. The ARN must have the following form:   <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> <br/>Options:  Currently, you can use this parameter to specify whether to add the certificate to a certificate transparency log. Certificate transparency makes it possible to detect SSL/TLS certificates that have been mistakenly or maliciously issued. Certificates that have not been logged typically produce an error message in a browser. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency">Opting Out of Certificate Transparency Logging</a>.:<br/>DomainValidationOptions:  The domain name that you want ACM to use to send you emails so that you can validate domain ownership.<br/>IdempotencyToken:  Customer chosen string that can be used to distinguish between calls to <code>RequestCertificate</code>. Idempotency tokens time out after one hour. Therefore, if you call <code>RequestCertificate</code> multiple times with the same idempotency token within one hour, ACM recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, ACM recognizes that you are requesting multiple certificates.<br/>SubjectAlternativeNames:  Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate. For example, add the name www.example.net to a certificate for which the <code>DomainName</code> field is www.example.com if users can reach your site by using either name. The maximum number of domain names that you can add to an ACM certificate is 100. However, the initial quota is 10 domain names. If you need more than 10 names, you must request a quota increase. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Quotas</a>.  The maximum length of a SAN DNS name is 253 octets. The name is made up of multiple labels separated by periods. No label can be longer than 63 octets. Consider the following examples:  <ul> <li>  <code>(63 octets).(63 octets).(63 octets).(61 octets)</code> is legal because the total length is 253 octets (63+1+63+1+63+1+61) and no label exceeds 63 octets. </li> <li>  <code>(64 octets).(63 octets).(63 octets).(61 octets)</code> is not legal because the total length exceeds 253 octets (64+1+63+1+63+1+61) and the first label exceeds 63 octets. </li> <li>  <code>(63 octets).(63 octets).(63 octets).(62 octets)</code> is not legal because the total length of the DNS name (63+1+63+1+63+1+62) exceeds 253 octets. </li> </ul><br/>ValidationMethod:  The method you want to use if you are requesting a public certificate to validate that you own or control domain. You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with email</a>. We recommend that you use DNS validation. <br/>DomainName:   Fully qualified domain name (FQDN), such as www.example.com, that you want to secure with an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, *.example.com protects www.example.com, site.example.com, and images.example.com.   The first domain name you enter cannot exceed 64 octets, including periods. Each subsequent Subject Alternative Name (SAN), however, can be up to 253 octets in length. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateTransparencyLoggingPreference</i> You can opt out of certificate transparency logging by specifying the <code>DISABLED</code> option. Opt in by specifying <code>ENABLED</code>. <br/>
        :return: CertificateArn:  String that contains the ARN of the issued certificate. This must be of the form:  <code>arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> <br/>        """
        pass

    def resend_validation_email(self, ValidationDomain: str, Domain: str, CertificateArn: str):
        r"""Resends the email that requests domain ownership validation. The domain owner or an authorized representative must approve the ACM certificate before it can be issued. The certificate can be approved by clicking a link in the mail to navigate to the Amazon certificate approval website and then clicking <b>I Approve</b>. However, the validation email can be blocked by spam filters. Therefore, if you do not receive the original mail, you can request that the mail be resent within 72 hours of requesting the ACM certificate. If more than 72 hours have elapsed since your original request or since your last attempt to resend validation mail, you must request a new certificate. For more information about setting up your contact email addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html">Configure Email for your Domain</a>. 

        :param self:
        :param ValidationDomain:  The base validation domain that will act as the suffix of the email addresses that are used to send the emails. This must be the same as the <code>Domain</code> value or a superdomain of the <code>Domain</code> value. For example, if you requested a certificate for <code>site.subdomain.example.com</code> and specify a <b>ValidationDomain</b> of <code>subdomain.example.com</code>, ACM sends email to the domain registrant, technical contact, and administrative contact in WHOIS and the following five addresses: <ul> <li> admin@subdomain.example.com </li> <li> administrator@subdomain.example.com </li> <li> hostmaster@subdomain.example.com </li> <li> postmaster@subdomain.example.com </li> <li> webmaster@subdomain.example.com </li> </ul><br/>Domain:  The fully qualified domain name (FQDN) of the certificate that needs to be validated.<br/>CertificateArn:  String that contains the ARN of the requested certificate. The certificate ARN is generated and returned by the <a>RequestCertificate</a> action as soon as the request is made. By default, using this parameter causes email to be sent to all top-level domains you specified in the certificate request. The ARN must be of the form:   <code>arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> <br/>
        :return:         """
        pass

    def update_certificate_options(self, Options: CertificateOptions, CertificateArn: str):
        r"""Updates a certificate. Currently, you can use this function to specify whether to opt in to or out of recording your certificate in a certificate transparency log. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency"> Opting Out of Certificate Transparency Logging</a>. 

        :param self:
        :param Options:  Use to update the options for your certificate. Currently, you can specify whether to add your certificate to a transparency log. Certificate transparency makes it possible to detect SSL/TLS certificates that have been mistakenly or maliciously issued. Certificates that have not been logged typically produce an error message in a browser. :<br/>CertificateArn:  ARN of the requested certificate to update. This must be of the form:  <code>arn:aws:acm:us-east-1:<i>account</i>:certificate/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateTransparencyLoggingPreference</i> You can opt out of certificate transparency logging by specifying the <code>DISABLED</code> option. Opt in by specifying <code>ENABLED</code>. <br/>
        :return:         """
        pass



class ACMPCA(BaseClient):
    r"""This is the <i>ACM Private CA API Reference</i>. It provides descriptions, syntax, and usage examples for each of the actions and data types involved in creating and managing private certificate authorities (CA) for your organization. The documentation for each action shows the Query API request parameters and the XML response. Alternatively, you can use one of the AWS SDKs to access an API that's tailored to the programming language or platform that you're using. For more information, see <a href="https://aws.amazon.com/tools/#SDKs">AWS SDKs</a>. <note> Each ACM Private CA API action has a throttling limit which determines the number of times the action can be called per second. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaLimits.html#PcaLimits-api">API Rate Limits in ACM Private CA</a> in the ACM Private CA user guide. </note>"""

    class AuditReportCreatedWaiter(Waiter):
        def wait(self, **kwargs):
            r"""see function `describe_certificate_authority_audit_report` for valid parameters"""
            pass
    class CertificateAuthorityCSRCreatedWaiter(Waiter):
        def wait(self, **kwargs):
            r"""see function `get_certificate_authority_csr` for valid parameters"""
            pass
    class CertificateIssuedWaiter(Waiter):
        def wait(self, **kwargs):
            r"""see function `get_certificate` for valid parameters"""
            pass


    class ListCertificateAuthoritiesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_certificate_authorities` for valid parameters"""
            pass
    class ListTagsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_tags` for valid parameters"""
            pass
    class ListPermissionsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_permissions` for valid parameters"""
            pass


    class CreateCertificateAuthorityRequest(Mapping):
        pass
    
    class CreateCertificateAuthorityResponse(Mapping):
        pass
    
    class CertificateAuthorityConfiguration(Mapping):
        pass
    
    class RevocationConfiguration(Mapping):
        pass
    
    class Tag(Mapping):
        pass
    
    class CreateCertificateAuthorityAuditReportRequest(Mapping):
        pass
    
    class CreateCertificateAuthorityAuditReportResponse(Mapping):
        pass
    
    class CreatePermissionRequest(Mapping):
        pass
    
    class ActionType(object):
        pass
    
    class DeleteCertificateAuthorityRequest(Mapping):
        pass
    
    class DeletePermissionRequest(Mapping):
        pass
    
    class DescribeCertificateAuthorityRequest(Mapping):
        pass
    
    class DescribeCertificateAuthorityResponse(Mapping):
        pass
    
    class DescribeCertificateAuthorityAuditReportRequest(Mapping):
        pass
    
    class DescribeCertificateAuthorityAuditReportResponse(Mapping):
        pass
    
    class GetCertificateRequest(Mapping):
        pass
    
    class GetCertificateResponse(Mapping):
        pass
    
    class GetCertificateAuthorityCertificateRequest(Mapping):
        pass
    
    class GetCertificateAuthorityCertificateResponse(Mapping):
        pass
    
    class GetCertificateAuthorityCsrRequest(Mapping):
        pass
    
    class GetCertificateAuthorityCsrResponse(Mapping):
        pass
    
    class ImportCertificateAuthorityCertificateRequest(Mapping):
        pass
    
    class CertificateBodyBlob(object):
        pass
    
    class CertificateChainBlob(object):
        pass
    
    class IssueCertificateRequest(Mapping):
        pass
    
    class IssueCertificateResponse(Mapping):
        pass
    
    class CsrBlob(object):
        pass
    
    class Validity(Mapping):
        pass
    
    class ListCertificateAuthoritiesRequest(Mapping):
        pass
    
    class ListCertificateAuthoritiesResponse(Mapping):
        pass
    
    class ListPermissionsRequest(Mapping):
        pass
    
    class ListPermissionsResponse(Mapping):
        pass
    
    class ListTagsRequest(Mapping):
        pass
    
    class ListTagsResponse(Mapping):
        pass
    
    class RestoreCertificateAuthorityRequest(Mapping):
        pass
    
    class RevokeCertificateRequest(Mapping):
        pass
    
    class TagCertificateAuthorityRequest(Mapping):
        pass
    
    class UntagCertificateAuthorityRequest(Mapping):
        pass
    
    class UpdateCertificateAuthorityRequest(Mapping):
        pass
    
    def create_certificate_authority(self, CertificateAuthorityType: str, CertificateAuthorityConfiguration: CertificateAuthorityConfiguration, RevocationConfiguration: RevocationConfiguration=None, IdempotencyToken: str=None, Tags: List[Tag]=None) -> CreateCertificateAuthorityResponse:
        r"""Creates a root or subordinate private certificate authority (CA). You must specify the CA configuration, the certificate revocation list (CRL) configuration, the CA type, and an optional idempotency token to avoid accidental creation of multiple CAs. The CA configuration specifies the name of the algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses, and X.500 subject information. The CRL configuration specifies the CRL expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this action returns the Amazon Resource Name (ARN) of the CA.

        :param self:
        :param Tags:  Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with  IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.<br/>IdempotencyToken:  Alphanumeric string that can be used to distinguish between calls to <b>CreateCertificateAuthority</b>. Idempotency tokens time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency token within a five minute period, ACM Private CA recognizes that you are requesting only one certificate. As a result, ACM Private CA issues only one. If you change the idempotency token for each call, however, ACM Private CA recognizes that you are requesting multiple certificates.<br/>CertificateAuthorityType:  The type of the certificate authority.<br/>RevocationConfiguration:  Contains a Boolean value that you can use to enable a certification revocation list (CRL) for the CA, the name of the S3 bucket to which ACM Private CA will write the CRL, and an optional CNAME alias that you can use to hide the name of your bucket in the <b>CRL Distribution Points</b> extension of your CA certificate. For more information, see the <a>CrlConfiguration</a> structure. :<br/>CertificateAuthorityConfiguration:  Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject information.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Subject</i> Structure that contains X.500 distinguished name information for your private CA.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Subject</b>: Structure that contains X.500 distinguished name information for your private CA.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SigningAlgorithm</i> Name of the algorithm your private CA uses to sign certificate requests.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>KeyAlgorithm</i> Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate. When you create a subordinate CA, you must use a key algorithm supported by the parent CA.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>GenerationQualifier</i> Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Pseudonym</i> Typically a shortened version of a longer <b>GivenName</b>. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Initials</i> Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the middle name if one exists, and the first letter of the <b>SurName</b>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>GivenName</i> First name.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Surname</i> Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Title</i> A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Locality</i> The locality (such as a city or town) in which the certificate subject is located.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>SerialNumber</i> The certificate serial number.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>CommonName</i> Fully qualified domain name (FQDN) associated with the certificate subject.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>State</i> State in which the subject of the certificate is located.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>DistinguishedNameQualifier</i> Disambiguating information for the certificate subject.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>OrganizationalUnit</i> A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Organization</i> Legal name of the organization with which the certificate subject is affiliated. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Country</i> Two-digit code that specifies the country in which the certificate subject located.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CrlConfiguration</i> Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>CrlConfiguration</b>: Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>S3BucketName</i> Name of the S3 bucket that contains the CRL. If you do not provide a value for the <b>CustomCname</b> argument, the name of your S3 bucket is placed into the <b>CRL Distribution Points</b> extension of the issued certificate. You can change the name of your bucket by calling the <a>UpdateCertificateAuthority</a> action. You must specify a bucket policy that allows ACM Private CA to write the CRL to your bucket.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>CustomCname</i> Name inserted into the certificate <b>CRL Distribution Points</b> extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ExpirationInDays</i> Number of days until a certificate expires.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Enabled</i> Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the <a>CreateCertificateAuthority</a> action or for an existing CA when you call the <a>UpdateCertificateAuthority</a> action. <br/>
        :return: CertificateAuthorityArn:  If successful, the Amazon Resource Name (ARN) of the certificate authority (CA). This is of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. <br/>        """
        pass

    def create_certificate_authority_audit_report(self, AuditReportResponseFormat: str, S3BucketName: str, CertificateAuthorityArn: str) -> CreateCertificateAuthorityAuditReportResponse:
        r"""Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon S3 bucket that you specify on input. The <a>IssueCertificate</a> and <a>RevokeCertificate</a> actions use the private key.

        :param self:
        :param AuditReportResponseFormat:  The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.<br/>S3BucketName:  The name of the S3 bucket that will contain the audit report.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:  <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.<br/>
        :return: S3Key:  The <b>key</b> that uniquely identifies the report file in your S3 bucket.<br/>AuditReportId:  An alphanumeric string that contains a report identifier.<br/>        """
        pass

    def create_permission(self, Actions: List[ActionType], Principal: str, CertificateAuthorityArn: str, SourceAccount: str=None):
        r"""Assigns permissions from a private CA to a designated AWS service. Services are specified by their service principals and can be given permission to create and retrieve certificates on a private CA. Services can also be given permission to list the active permissions that the private CA has granted. For ACM to automatically renew your private CA's certificates, you must assign all possible permissions from the CA to the ACM service principal. At this time, you can only assign permissions to ACM (<code>acm.amazonaws.com</code>). Permissions can be revoked with the <a>DeletePermission</a> action and listed with the <a>ListPermissions</a> action.

        :param self:
        :param Actions:  The actions that the specified AWS service principal can use. These include <code>IssueCertificate</code>, <code>GetCertificate</code>, and <code>ListPermissions</code>.<br/>SourceAccount:  The ID of the calling account.<br/>Principal:  The AWS service or identity that receives the permission. At this time, the only valid principal is <code>acm.amazonaws.com</code>.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the <a>ListCertificateAuthorities</a> action. This must have the following form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. <br/>
        :return:         """
        pass

    def delete_certificate_authority(self, CertificateAuthorityArn: str, PermanentDeletionTimeInDays: int=None):
        r"""Deletes a private certificate authority (CA). You must provide the Amazon Resource Name (ARN) of the private CA that you want to delete. You can find the ARN by calling the <a>ListCertificateAuthorities</a> action.  <note> Deleting a CA will invalidate other CAs and certificates below it in your CA hierarchy. </note> Before you can delete a CA that you have created and activated, you must disable it. To do this, call the <a>UpdateCertificateAuthority</a> action and set the <b>CertificateAuthorityStatus</b> parameter to <code>DISABLED</code>.  Additionally, you can delete a CA if you are waiting for it to be created (that is, the status of the CA is <code>CREATING</code>). You can also delete it if the CA has been created but you haven't yet imported the signed certificate into ACM Private CA (that is, the status of the CA is <code>PENDING_CERTIFICATE</code>).  When you successfully call <a>DeleteCertificateAuthority</a>, the CA's status changes to <code>DELETED</code>. However, the CA won't be permanently deleted until the restoration period has passed. By default, if you do not set the <code>PermanentDeletionTimeInDays</code> parameter, the CA remains restorable for 30 days. You can set the parameter from 7 to 30 days. The <a>DescribeCertificateAuthority</a> action returns the time remaining in the restoration window of a private CA in the <code>DELETED</code> state. To restore an eligible CA, call the <a>RestoreCertificateAuthority</a> action.

        :param self:
        :param PermanentDeletionTimeInDays:  The number of days to make a CA restorable after it has been deleted. This can be anywhere from 7 to 30 days, with 30 being the default.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must have the following form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. <br/>
        :return:         """
        pass

    def delete_permission(self, Principal: str, CertificateAuthorityArn: str, SourceAccount: str=None):
        r"""Revokes permissions that a private CA assigned to a designated AWS service. Permissions can be created with the <a>CreatePermission</a> action and listed with the <a>ListPermissions</a> action. 

        :param self:
        :param SourceAccount:  The AWS account that calls this action.<br/>Principal:  The AWS service or identity that will have its CA permissions revoked. At this time, the only valid service principal is <code>acm.amazonaws.com</code> <br/>CertificateAuthorityArn:  The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's ARN by calling the <a>ListCertificateAuthorities</a> action. This must have the following form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. <br/>
        :return:         """
        pass

    def describe_certificate_authority(self, CertificateAuthorityArn: str) -> DescribeCertificateAuthorityResponse:
        r"""Lists information about your private certificate authority (CA). You specify the private CA on input by its ARN (Amazon Resource Name). The output contains the status of your CA. This can be any of the following:  <ul> <li>  <code>CREATING</code> - ACM Private CA is creating your private certificate authority. </li> <li>  <code>PENDING_CERTIFICATE</code> - The certificate is pending. You must use your ACM Private CA-hosted or on-premises root or subordinate CA to sign your private CA CSR and then import it into PCA.  </li> <li>  <code>ACTIVE</code> - Your private CA is active. </li> <li>  <code>DISABLED</code> - Your private CA has been disabled. </li> <li>  <code>EXPIRED</code> - Your private CA certificate has expired. </li> <li>  <code>FAILED</code> - Your private CA has failed. Your CA can fail because of problems such a network outage or backend AWS failure or other errors. A failed CA can never return to the pending state. You must create a new CA.  </li> <li>  <code>DELETED</code> - Your private CA is within the restoration period, after which it is permanently deleted. The length of time remaining in the CA's restoration period is also included in this action's output. </li> </ul>

        :param self:
        :param CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. <br/>
        :return: CertificateAuthority:  A <a>CertificateAuthority</a> structure that contains information about your private CA.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RestorableUntil</i> The period during which a deleted CA can be restored. For more information, see the <code>PermanentDeletionTimeInDays</code> parameter of the <a>DeleteCertificateAuthorityRequest</a> action. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RevocationConfiguration</i> Information about the certificate revocation list (CRL) created and maintained by your private CA. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>RevocationConfiguration</b>: Information about the certificate revocation list (CRL) created and maintained by your private CA. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateAuthorityConfiguration</i> Your private CA configuration.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>CertificateAuthorityConfiguration</b>: Your private CA configuration.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>FailureReason</i> Reason the request to create your private CA failed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>NotAfter</i> Date and time after which your private CA certificate is not valid.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>NotBefore</i> Date and time before which your private CA certificate is not valid.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Status</i> Status of your private CA.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Serial</i> Serial number of your private CA.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Type</i> Type of your private CA.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LastStateChangeAt</i> Date and time at which your private CA was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CreatedAt</i> Date and time at which your private CA was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Arn</i> Amazon Resource Name (ARN) for your private certificate authority (CA). The format is <code> <i>12345678-1234-1234-1234-123456789012</i> </code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>SigningAlgorithm</i> Name of the algorithm your private CA uses to sign certificate requests.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>KeyAlgorithm</i> Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate. When you create a subordinate CA, you must use a key algorithm supported by the parent CA.<br/>Structure that contains X.500 distinguished name information for your private CA.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Subject</b>: Structure that contains X.500 distinguished name information for your private CA.Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>CrlConfiguration</b>: Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.        """
        pass

    def describe_certificate_authority_audit_report(self, AuditReportId: str, CertificateAuthorityArn: str) -> DescribeCertificateAuthorityAuditReportResponse:
        r"""Lists information about a specific audit report created by calling the <a>CreateCertificateAuthorityAuditReport</a> action. Audit information is created every time the certificate authority (CA) private key is used. The private key is used when you call the <a>IssueCertificate</a> action or the <a>RevokeCertificate</a> action. 

        :param self:
        :param AuditReportId:  The report ID returned by calling the <a>CreateCertificateAuthorityAuditReport</a> action.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) of the private CA. This must be of the form:  <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. <br/>
        :return: CreatedAt:  The date and time at which the report was created.<br/>S3Key:  S3 <b>key</b> that uniquely identifies the report file in your S3 bucket.<br/>S3BucketName:  Name of the S3 bucket that contains the report.<br/>AuditReportStatus:  Specifies whether report creation is in progress, has succeeded, or has failed.<br/>        """
        pass

    def get_certificate(self, CertificateArn: str, CertificateAuthorityArn: str) -> GetCertificateResponse:
        r"""Retrieves a certificate from your private CA. The ARN of the certificate is returned when you call the <a>IssueCertificate</a> action. You must specify both the ARN of your private CA and the ARN of the issued certificate when calling the <b>GetCertificate</b> action. You can retrieve the certificate if it is in the <b>ISSUED</b> state. You can call the <a>CreateCertificateAuthorityAuditReport</a> action to create a report that contains information about all of the certificates issued and revoked by your private CA. 

        :param self:
        :param CertificateArn:  The ARN of the issued certificate. The ARN contains the certificate serial number and must be in the following form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> <br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. <br/>
        :return: CertificateChain:  The base64 PEM-encoded certificate chain that chains up to the on-premises root CA certificate that you used to sign your private CA certificate. <br/>Certificate:  The base64 PEM-encoded certificate specified by the <code>CertificateArn</code> parameter.<br/>        """
        pass

    def get_certificate_authority_certificate(self, CertificateAuthorityArn: str) -> GetCertificateAuthorityCertificateResponse:
        r"""Retrieves the certificate and certificate chain for your private certificate authority (CA). Both the certificate and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the chain signs the one before it. 

        :param self:
        :param CertificateAuthorityArn:  The Amazon Resource Name (ARN) of your private CA. This is of the form:  <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. <br/>
        :return: CertificateChain:  Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. If this is a root CA, the value will be null.<br/>Certificate:  Base64-encoded certificate authority (CA) certificate.<br/>        """
        pass

    def get_certificate_authority_csr(self, CertificateAuthorityArn: str) -> GetCertificateAuthorityCsrResponse:
        r"""Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the <a>CreateCertificateAuthority</a> action. Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA by calling the <a>ImportCertificateAuthorityCertificate</a> action. The CSR is returned as a base64 PEM-encoded string. 

        :param self:
        :param CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called the <a>CreateCertificateAuthority</a> action. This must be of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>
        :return: Csr:  The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.<br/>        """
        pass

    def import_certificate_authority_certificate(self, Certificate: CertificateBodyBlob, CertificateAuthorityArn: str, CertificateChain: CertificateChainBlob=None):
        r"""Imports a signed private CA certificate into ACM Private CA. This action is used when you are using a chain of trust whose root is located outside ACM Private CA. Before you can call this action, the following preparations must in place: <ol> <li> In ACM Private CA, call the <a>CreateCertificateAuthority</a> action to create the private CA that that you plan to back with the imported certificate. </li> <li> Call the <a>GetCertificateAuthorityCsr</a> action to generate a certificate signing request (CSR). </li> <li> Sign the CSR using a root or intermediate CA hosted either by an on-premises PKI hierarchy or a commercial CA.. </li> <li> Create a certificate chain and copy the signed certificate and the certificate chain to your working directory. </li> </ol> The following requirements apply when you import a CA certificate. <ul> <li> You cannot import a non-self-signed certificate for use as a root CA. </li> <li> You cannot import a self-signed certificate for use as a subordinate CA. </li> <li> Your certificate chain must not include the private CA certificate that you are importing. </li> <li> Your ACM Private CA-hosted or on-premises CA certificate must be the last certificate in your chain. The subordinate certificate, if any, that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA must come next, and so on until your chain is built.  </li> <li> The chain must be PEM-encoded. </li> </ul>

        :param self:
        :param CertificateChain:  A PEM-encoded file that contains all of your certificates, other than the certificate you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding.  This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.<br/>Certificate:  The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>
        :return:         """
        pass

    def issue_certificate(self, Validity: Validity, SigningAlgorithm: str, Csr: CsrBlob, CertificateAuthorityArn: str, TemplateArn: str=None, IdempotencyToken: str=None) -> IssueCertificateResponse:
        r"""Uses your private certificate authority (CA) to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the <a>GetCertificate</a> action and specifying the ARN.  <note> You cannot use the ACM <b>ListCertificateAuthorities</b> action to retrieve the ARNs of the certificates that you issue by using ACM Private CA. </note>

        :param self:
        :param IdempotencyToken:  Custom string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens time out after one hour. Therefore, if you call <b>IssueCertificate</b> multiple times with the same idempotency token within 5 minutes, ACM Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificates.<br/>Validity:  The type of the validity period.:<br/>TemplateArn:  Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. The following service-owned <code>TemplateArn</code> values are supported by ACM Private CA:  <ul> <li> arn:aws:acm-pca:::template/EndEntityCertificate/V1 </li> <li> arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen0/V1 </li> <li> arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen1/V1 </li> <li> arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen2/V1 </li> <li> arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen3/V1 </li> <li> arn:aws:acm-pca:::template/RootCACertificate/V1 </li> </ul> For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a>.<br/>SigningAlgorithm:  The name of the algorithm that will be used to sign the certificate to be issued.<br/>Csr:  The certificate signing request (CSR) for the certificate you want to issue. You can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key.   <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code>  If you have a configuration file, you can use the following OpenSSL command. The <code>usr_cert</code> block in the configuration file contains your X509 version 3 extensions.   <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> <br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form:  <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Type</i> Specifies whether the <code>Value</code> parameter represents days, months, or years.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Value</i> Time period.<br/>
        :return: CertificateArn:  The Amazon Resource Name (ARN) of the issued certificate and the certificate serial number. This is of the form:  <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> <br/>        """
        pass

    def list_certificate_authorities(self, NextToken: str=None, MaxResults: int=None) -> ListCertificateAuthoritiesResponse:
        r"""Lists the private certificate authorities that you created by using the <a>CreateCertificateAuthority</a> action.

        :param self:
        :param MaxResults:  Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.<br/>NextToken:  Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.<br/>
        :return: NextToken:  When the list is truncated, this value is present and should be used for the <code>NextToken</code> parameter in a subsequent pagination request.<br/>CertificateAuthorities:  Summary information about each certificate authority you have created.<br/>        """
        pass

    def list_permissions(self, CertificateAuthorityArn: str, NextToken: str=None, MaxResults: int=None) -> ListPermissionsResponse:
        r"""Lists all the permissions, if any, that have been assigned by a private CA. Permissions can be granted with the <a>CreatePermission</a> action and revoked with the <a>DeletePermission</a> action.

        :param self:
        :param MaxResults:  When paginating results, use this parameter to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.<br/>NextToken:  When paginating results, use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.<br/>CertificateAuthorityArn:  The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by calling the <a>ListCertificateAuthorities</a> action. This must be of the form: <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> You can get a private CA's ARN by running the <a>ListCertificateAuthorities</a> action.<br/>
        :return: NextToken:  When the list is truncated, this value is present and should be used for the <b>NextToken</b> parameter in a subsequent pagination request. <br/>Permissions:  Summary information about each permission assigned by the specified private CA, including the action enabled, the policy provided, and the time of creation.<br/>        """
        pass

    def list_tags(self, CertificateAuthorityArn: str, NextToken: str=None, MaxResults: int=None) -> ListTagsResponse:
        r"""Lists the tags, if any, that are associated with your private CA. Tags are labels that you can use to identify and organize your CAs. Each tag consists of a key and an optional value. Call the <a>TagCertificateAuthority</a> action to add one or more tags to your CA. Call the <a>UntagCertificateAuthority</a> action to remove tags. 

        :param self:
        :param MaxResults:  Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.<br/>NextToken:  Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called the <a>CreateCertificateAuthority</a> action. This must be of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>
        :return: NextToken:  When the list is truncated, this value is present and should be used for the <b>NextToken</b> parameter in a subsequent pagination request. <br/>Tags:  The tags associated with your private CA.<br/>        """
        pass

    def restore_certificate_authority(self, CertificateAuthorityArn: str):
        r"""Restores a certificate authority (CA) that is in the <code>DELETED</code> state. You can restore a CA during the period that you defined in the <b>PermanentDeletionTimeInDays</b> parameter of the <a>DeleteCertificateAuthority</a> action. Currently, you can specify 7 to 30 days. If you did not specify a <b>PermanentDeletionTimeInDays</b> value, by default you can restore the CA at any time in a 30 day period. You can check the time remaining in the restoration period of a private CA in the <code>DELETED</code> state by calling the <a>DescribeCertificateAuthority</a> or <a>ListCertificateAuthorities</a> actions. The status of a restored CA is set to its pre-deletion status when the <b>RestoreCertificateAuthority</b> action returns. To change its status to <code>ACTIVE</code>, call the <a>UpdateCertificateAuthority</a> action. If the private CA was in the <code>PENDING_CERTIFICATE</code> state at deletion, you must use the <a>ImportCertificateAuthorityCertificate</a> action to import a certificate authority into the private CA before it can be activated. You cannot restore a CA after the restoration period has ended.

        :param self:
        :param CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called the <a>CreateCertificateAuthority</a> action. This must be of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>
        :return:         """
        pass

    def revoke_certificate(self, RevocationReason: str, CertificateSerial: str, CertificateAuthorityArn: str):
        r"""Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket that you specify. For more information about revocation, see the <a>CrlConfiguration</a> structure. ACM Private CA also writes revocation information to the audit report. For more information, see <a>CreateCertificateAuthorityAuditReport</a>.  <note> You cannot revoke a root CA self-signed certificate. </note>

        :param self:
        :param RevocationReason:  Specifies why you revoked the certificate.<br/>CertificateSerial:  Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling <a>GetCertificate</a> with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number.   <code>openssl x509 -in <i>file_path</i> -text -noout</code>  You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>AWS Certificate Manager API Reference</i>. <br/>CertificateAuthorityArn:  Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:  <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>
        :return:         """
        pass

    def tag_certificate_authority(self, Tags: List[Tag], CertificateAuthorityArn: str):
        r"""Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your AWS resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs if you want to filter for a common relationship among those CAs. To remove one or more tags, use the <a>UntagCertificateAuthority</a> action. Call the <a>ListTags</a> action to see what tags are associated with your CA. 

        :param self:
        :param Tags:  List of tags to be associated with the CA.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>
        :return:         """
        pass

    def untag_certificate_authority(self, Tags: List[Tag], CertificateAuthorityArn: str):
        r"""Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this action, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the <a>TagCertificateAuthority</a>. Call the <a>ListTags</a> action to see what tags are associated with your CA. 

        :param self:
        :param Tags:  List of tags to be removed from the CA.<br/>CertificateAuthorityArn:  The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form:   <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>
        :return:         """
        pass

    def update_certificate_authority(self, CertificateAuthorityArn: str, RevocationConfiguration: RevocationConfiguration=None, Status: str=None):
        r"""Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the <code>ACTIVE</code> or <code>DISABLED</code> state before you can update it. You can disable a private CA that is in the <code>ACTIVE</code> state or make a CA that is in the <code>DISABLED</code> state active again.

        :param self:
        :param Status:  Status of your private CA.<br/>RevocationConfiguration:  Revocation information for your private CA.:<br/>CertificateAuthorityArn:  Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:  <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CrlConfiguration</i> Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>CrlConfiguration</b>: Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>S3BucketName</i> Name of the S3 bucket that contains the CRL. If you do not provide a value for the <b>CustomCname</b> argument, the name of your S3 bucket is placed into the <b>CRL Distribution Points</b> extension of the issued certificate. You can change the name of your bucket by calling the <a>UpdateCertificateAuthority</a> action. You must specify a bucket policy that allows ACM Private CA to write the CRL to your bucket.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>CustomCname</i> Name inserted into the certificate <b>CRL Distribution Points</b> extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ExpirationInDays</i> Number of days until a certificate expires.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Enabled</i> Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the <a>CreateCertificateAuthority</a> action or for an existing CA when you call the <a>UpdateCertificateAuthority</a> action. <br/>
        :return:         """
        pass



class AlexaForBusiness(BaseClient):
    r"""Alexa for Business helps you use Alexa in your organization. Alexa for Business provides you with the tools to manage Alexa devices, enroll your users, and assign skills, at scale. You can build your own context-aware voice skills using the Alexa Skills Kit and the Alexa for Business API operations. You can also make these available as private skills for your organization. Alexa for Business makes it efficient to voice-enable your products and services, thus providing context-aware voice experiences for your customers. Device makers building with the Alexa Voice Service (AVS) can create fully integrated solutions, register their products with Alexa for Business, and manage them as shared devices in their organization. """


    class ListSkillsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_skills` for valid parameters"""
            pass
    class SearchUsersPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `search_users` for valid parameters"""
            pass
    class ListTagsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_tags` for valid parameters"""
            pass
    class SearchProfilesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `search_profiles` for valid parameters"""
            pass
    class SearchSkillGroupsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `search_skill_groups` for valid parameters"""
            pass
    class SearchDevicesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `search_devices` for valid parameters"""
            pass
    class SearchRoomsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `search_rooms` for valid parameters"""
            pass
    class ListBusinessReportSchedulesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_business_report_schedules` for valid parameters"""
            pass
    class ListConferenceProvidersPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_conference_providers` for valid parameters"""
            pass
    class ListDeviceEventsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_device_events` for valid parameters"""
            pass
    class ListSkillsStoreCategoriesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_skills_store_categories` for valid parameters"""
            pass
    class ListSkillsStoreSkillsByCategoryPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_skills_store_skills_by_category` for valid parameters"""
            pass
    class ListSmartHomeAppliancesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_smart_home_appliances` for valid parameters"""
            pass


    class ApproveSkillRequest(Mapping):
        pass
    
    class ApproveSkillResponse(Mapping):
        pass
    
    class AssociateContactWithAddressBookRequest(Mapping):
        pass
    
    class AssociateContactWithAddressBookResponse(Mapping):
        pass
    
    class AssociateDeviceWithNetworkProfileRequest(Mapping):
        pass
    
    class AssociateDeviceWithNetworkProfileResponse(Mapping):
        pass
    
    class AssociateDeviceWithRoomRequest(Mapping):
        pass
    
    class AssociateDeviceWithRoomResponse(Mapping):
        pass
    
    class AssociateSkillGroupWithRoomRequest(Mapping):
        pass
    
    class AssociateSkillGroupWithRoomResponse(Mapping):
        pass
    
    class AssociateSkillWithSkillGroupRequest(Mapping):
        pass
    
    class AssociateSkillWithSkillGroupResponse(Mapping):
        pass
    
    class AssociateSkillWithUsersRequest(Mapping):
        pass
    
    class AssociateSkillWithUsersResponse(Mapping):
        pass
    
    class CreateAddressBookRequest(Mapping):
        pass
    
    class CreateAddressBookResponse(Mapping):
        pass
    
    class CreateBusinessReportScheduleRequest(Mapping):
        pass
    
    class CreateBusinessReportScheduleResponse(Mapping):
        pass
    
    class BusinessReportContentRange(Mapping):
        pass
    
    class BusinessReportRecurrence(Mapping):
        pass
    
    class CreateConferenceProviderRequest(Mapping):
        pass
    
    class CreateConferenceProviderResponse(Mapping):
        pass
    
    class IPDialIn(Mapping):
        pass
    
    class PSTNDialIn(Mapping):
        pass
    
    class MeetingSetting(Mapping):
        pass
    
    class CreateContactRequest(Mapping):
        pass
    
    class CreateContactResponse(Mapping):
        pass
    
    class PhoneNumber(Mapping):
        pass
    
    class SipAddress(Mapping):
        pass
    
    class CreateGatewayGroupRequest(Mapping):
        pass
    
    class CreateGatewayGroupResponse(Mapping):
        pass
    
    class CreateNetworkProfileRequest(Mapping):
        pass
    
    class CreateNetworkProfileResponse(Mapping):
        pass
    
    class TrustAnchor(object):
        pass
    
    class CreateProfileRequest(Mapping):
        pass
    
    class CreateProfileResponse(Mapping):
        pass
    
    class Boolean(object):
        pass
    
    class CreateMeetingRoomConfiguration(Mapping):
        pass
    
    class CreateRoomRequest(Mapping):
        pass
    
    class CreateRoomResponse(Mapping):
        pass
    
    class Tag(Mapping):
        pass
    
    class CreateSkillGroupRequest(Mapping):
        pass
    
    class CreateSkillGroupResponse(Mapping):
        pass
    
    class CreateUserRequest(Mapping):
        pass
    
    class CreateUserResponse(Mapping):
        pass
    
    class DeleteAddressBookRequest(Mapping):
        pass
    
    class DeleteAddressBookResponse(Mapping):
        pass
    
    class DeleteBusinessReportScheduleRequest(Mapping):
        pass
    
    class DeleteBusinessReportScheduleResponse(Mapping):
        pass
    
    class DeleteConferenceProviderRequest(Mapping):
        pass
    
    class DeleteConferenceProviderResponse(Mapping):
        pass
    
    class DeleteContactRequest(Mapping):
        pass
    
    class DeleteContactResponse(Mapping):
        pass
    
    class DeleteDeviceRequest(Mapping):
        pass
    
    class DeleteDeviceResponse(Mapping):
        pass
    
    class DeleteDeviceUsageDataRequest(Mapping):
        pass
    
    class DeleteDeviceUsageDataResponse(Mapping):
        pass
    
    class DeleteGatewayGroupRequest(Mapping):
        pass
    
    class DeleteGatewayGroupResponse(Mapping):
        pass
    
    class DeleteNetworkProfileRequest(Mapping):
        pass
    
    class DeleteNetworkProfileResponse(Mapping):
        pass
    
    class DeleteProfileRequest(Mapping):
        pass
    
    class DeleteProfileResponse(Mapping):
        pass
    
    class DeleteRoomRequest(Mapping):
        pass
    
    class DeleteRoomResponse(Mapping):
        pass
    
    class DeleteRoomSkillParameterRequest(Mapping):
        pass
    
    class DeleteRoomSkillParameterResponse(Mapping):
        pass
    
    class DeleteSkillAuthorizationRequest(Mapping):
        pass
    
    class DeleteSkillAuthorizationResponse(Mapping):
        pass
    
    class DeleteSkillGroupRequest(Mapping):
        pass
    
    class DeleteSkillGroupResponse(Mapping):
        pass
    
    class DeleteUserRequest(Mapping):
        pass
    
    class DeleteUserResponse(Mapping):
        pass
    
    class DisassociateContactFromAddressBookRequest(Mapping):
        pass
    
    class DisassociateContactFromAddressBookResponse(Mapping):
        pass
    
    class DisassociateDeviceFromRoomRequest(Mapping):
        pass
    
    class DisassociateDeviceFromRoomResponse(Mapping):
        pass
    
    class DisassociateSkillFromSkillGroupRequest(Mapping):
        pass
    
    class DisassociateSkillFromSkillGroupResponse(Mapping):
        pass
    
    class DisassociateSkillFromUsersRequest(Mapping):
        pass
    
    class DisassociateSkillFromUsersResponse(Mapping):
        pass
    
    class DisassociateSkillGroupFromRoomRequest(Mapping):
        pass
    
    class DisassociateSkillGroupFromRoomResponse(Mapping):
        pass
    
    class ForgetSmartHomeAppliancesRequest(Mapping):
        pass
    
    class ForgetSmartHomeAppliancesResponse(Mapping):
        pass
    
    class GetAddressBookRequest(Mapping):
        pass
    
    class GetAddressBookResponse(Mapping):
        pass
    
    class GetConferencePreferenceRequest(Mapping):
        pass
    
    class GetConferencePreferenceResponse(Mapping):
        pass
    
    class GetConferenceProviderRequest(Mapping):
        pass
    
    class GetConferenceProviderResponse(Mapping):
        pass
    
    class GetContactRequest(Mapping):
        pass
    
    class GetContactResponse(Mapping):
        pass
    
    class GetDeviceRequest(Mapping):
        pass
    
    class GetDeviceResponse(Mapping):
        pass
    
    class GetGatewayRequest(Mapping):
        pass
    
    class GetGatewayResponse(Mapping):
        pass
    
    class GetGatewayGroupRequest(Mapping):
        pass
    
    class GetGatewayGroupResponse(Mapping):
        pass
    
    class GetInvitationConfigurationRequest(Mapping):
        pass
    
    class GetInvitationConfigurationResponse(Mapping):
        pass
    
    class GetNetworkProfileRequest(Mapping):
        pass
    
    class GetNetworkProfileResponse(Mapping):
        pass
    
    class GetProfileRequest(Mapping):
        pass
    
    class GetProfileResponse(Mapping):
        pass
    
    class GetRoomRequest(Mapping):
        pass
    
    class GetRoomResponse(Mapping):
        pass
    
    class GetRoomSkillParameterRequest(Mapping):
        pass
    
    class GetRoomSkillParameterResponse(Mapping):
        pass
    
    class GetSkillGroupRequest(Mapping):
        pass
    
    class GetSkillGroupResponse(Mapping):
        pass
    
    class ListBusinessReportSchedulesRequest(Mapping):
        pass
    
    class ListBusinessReportSchedulesResponse(Mapping):
        pass
    
    class ListConferenceProvidersRequest(Mapping):
        pass
    
    class ListConferenceProvidersResponse(Mapping):
        pass
    
    class ListDeviceEventsRequest(Mapping):
        pass
    
    class ListDeviceEventsResponse(Mapping):
        pass
    
    class ListGatewayGroupsRequest(Mapping):
        pass
    
    class ListGatewayGroupsResponse(Mapping):
        pass
    
    class ListGatewaysRequest(Mapping):
        pass
    
    class ListGatewaysResponse(Mapping):
        pass
    
    class ListSkillsRequest(Mapping):
        pass
    
    class ListSkillsResponse(Mapping):
        pass
    
    class ListSkillsStoreCategoriesRequest(Mapping):
        pass
    
    class ListSkillsStoreCategoriesResponse(Mapping):
        pass
    
    class ListSkillsStoreSkillsByCategoryRequest(Mapping):
        pass
    
    class ListSkillsStoreSkillsByCategoryResponse(Mapping):
        pass
    
    class CategoryId(object):
        pass
    
    class ListSmartHomeAppliancesRequest(Mapping):
        pass
    
    class ListSmartHomeAppliancesResponse(Mapping):
        pass
    
    class ListTagsRequest(Mapping):
        pass
    
    class ListTagsResponse(Mapping):
        pass
    
    class PutConferencePreferenceRequest(Mapping):
        pass
    
    class PutConferencePreferenceResponse(Mapping):
        pass
    
    class ConferencePreference(Mapping):
        pass
    
    class PutInvitationConfigurationRequest(Mapping):
        pass
    
    class PutInvitationConfigurationResponse(Mapping):
        pass
    
    class SkillId(object):
        pass
    
    class PutRoomSkillParameterRequest(Mapping):
        pass
    
    class PutRoomSkillParameterResponse(Mapping):
        pass
    
    class RoomSkillParameter(Mapping):
        pass
    
    class PutSkillAuthorizationRequest(Mapping):
        pass
    
    class PutSkillAuthorizationResponse(Mapping):
        pass
    
    class AuthorizationResult(object):
        pass
    
    class RegisterAVSDeviceRequest(Mapping):
        pass
    
    class RegisterAVSDeviceResponse(Mapping):
        pass
    
    class RejectSkillRequest(Mapping):
        pass
    
    class RejectSkillResponse(Mapping):
        pass
    
    class ResolveRoomRequest(Mapping):
        pass
    
    class ResolveRoomResponse(Mapping):
        pass
    
    class RevokeInvitationRequest(Mapping):
        pass
    
    class RevokeInvitationResponse(Mapping):
        pass
    
    class SearchAddressBooksRequest(Mapping):
        pass
    
    class SearchAddressBooksResponse(Mapping):
        pass
    
    class Filter(Mapping):
        pass
    
    class Sort(Mapping):
        pass
    
    class SearchContactsRequest(Mapping):
        pass
    
    class SearchContactsResponse(Mapping):
        pass
    
    class SearchDevicesRequest(Mapping):
        pass
    
    class SearchDevicesResponse(Mapping):
        pass
    
    class SearchNetworkProfilesRequest(Mapping):
        pass
    
    class SearchNetworkProfilesResponse(Mapping):
        pass
    
    class SearchProfilesRequest(Mapping):
        pass
    
    class SearchProfilesResponse(Mapping):
        pass
    
    class SearchRoomsRequest(Mapping):
        pass
    
    class SearchRoomsResponse(Mapping):
        pass
    
    class SearchSkillGroupsRequest(Mapping):
        pass
    
    class SearchSkillGroupsResponse(Mapping):
        pass
    
    class SearchUsersRequest(Mapping):
        pass
    
    class SearchUsersResponse(Mapping):
        pass
    
    class SendAnnouncementRequest(Mapping):
        pass
    
    class SendAnnouncementResponse(Mapping):
        pass
    
    class Content(Mapping):
        pass
    
    class SendInvitationRequest(Mapping):
        pass
    
    class SendInvitationResponse(Mapping):
        pass
    
    class StartDeviceSyncRequest(Mapping):
        pass
    
    class StartDeviceSyncResponse(Mapping):
        pass
    
    class Feature(object):
        pass
    
    class StartSmartHomeApplianceDiscoveryRequest(Mapping):
        pass
    
    class StartSmartHomeApplianceDiscoveryResponse(Mapping):
        pass
    
    class TagResourceRequest(Mapping):
        pass
    
    class TagResourceResponse(Mapping):
        pass
    
    class UntagResourceRequest(Mapping):
        pass
    
    class UntagResourceResponse(Mapping):
        pass
    
    class TagKey(object):
        pass
    
    class UpdateAddressBookRequest(Mapping):
        pass
    
    class UpdateAddressBookResponse(Mapping):
        pass
    
    class UpdateBusinessReportScheduleRequest(Mapping):
        pass
    
    class UpdateBusinessReportScheduleResponse(Mapping):
        pass
    
    class UpdateConferenceProviderRequest(Mapping):
        pass
    
    class UpdateConferenceProviderResponse(Mapping):
        pass
    
    class UpdateContactRequest(Mapping):
        pass
    
    class UpdateContactResponse(Mapping):
        pass
    
    class UpdateDeviceRequest(Mapping):
        pass
    
    class UpdateDeviceResponse(Mapping):
        pass
    
    class UpdateGatewayRequest(Mapping):
        pass
    
    class UpdateGatewayResponse(Mapping):
        pass
    
    class UpdateGatewayGroupRequest(Mapping):
        pass
    
    class UpdateGatewayGroupResponse(Mapping):
        pass
    
    class UpdateNetworkProfileRequest(Mapping):
        pass
    
    class UpdateNetworkProfileResponse(Mapping):
        pass
    
    class UpdateProfileRequest(Mapping):
        pass
    
    class UpdateProfileResponse(Mapping):
        pass
    
    class UpdateMeetingRoomConfiguration(Mapping):
        pass
    
    class UpdateRoomRequest(Mapping):
        pass
    
    class UpdateRoomResponse(Mapping):
        pass
    
    class UpdateSkillGroupRequest(Mapping):
        pass
    
    class UpdateSkillGroupResponse(Mapping):
        pass
    
    def approve_skill(self, SkillId: str) -> ApproveSkillResponse:
        r"""Associates a skill with the organization under the customer's AWS account. If a skill is private, the user implicitly accepts access to this skill during enablement.

        :param self:
        :param SkillId:  The unique identifier of the skill.<br/>
        :return:         """
        pass

    def associate_contact_with_address_book(self, AddressBookArn: str, ContactArn: str) -> AssociateContactWithAddressBookResponse:
        r"""Associates a contact with a given address book.

        :param self:
        :param AddressBookArn:  The ARN of the address book with which to associate the contact.<br/>ContactArn:  The ARN of the contact to associate with an address book.<br/>
        :return:         """
        pass

    def associate_device_with_network_profile(self, NetworkProfileArn: str, DeviceArn: str) -> AssociateDeviceWithNetworkProfileResponse:
        r"""Associates a device with the specified network profile.

        :param self:
        :param NetworkProfileArn:  The ARN of the network profile to associate with a device.<br/>DeviceArn:  The device ARN.<br/>
        :return:         """
        pass

    def associate_device_with_room(self, DeviceArn: str=None, RoomArn: str=None) -> AssociateDeviceWithRoomResponse:
        r"""Associates a device with a given room. This applies all the settings from the room profile to the device, and all the skills in any skill groups added to that room. This operation requires the device to be online, or else a manual sync is required. 

        :param self:
        :param RoomArn:  The ARN of the room with which to associate the device. Required.<br/>DeviceArn:  The ARN of the device to associate to a room. Required.<br/>
        :return:         """
        pass

    def associate_skill_group_with_room(self, SkillGroupArn: str=None, RoomArn: str=None) -> AssociateSkillGroupWithRoomResponse:
        r"""Associates a skill group with a given room. This enables all skills in the associated skill group on all devices in the room.

        :param self:
        :param RoomArn:  The ARN of the room with which to associate the skill group. Required.<br/>SkillGroupArn:  The ARN of the skill group to associate with a room. Required.<br/>
        :return:         """
        pass

    def associate_skill_with_skill_group(self, SkillId: str, SkillGroupArn: str=None) -> AssociateSkillWithSkillGroupResponse:
        r"""Associates a skill with a skill group.

        :param self:
        :param SkillId:  The unique identifier of the skill.<br/>SkillGroupArn:  The ARN of the skill group to associate the skill to. Required.<br/>
        :return:         """
        pass

    def associate_skill_with_users(self, SkillId: str) -> AssociateSkillWithUsersResponse:
        r"""Makes a private skill available for enrolled users to enable on their devices.

        :param self:
        :param SkillId:  The private skill ID you want to make available to enrolled users.<br/>
        :return:         """
        pass

    def create_address_book(self, Name: str, Description: str=None, ClientRequestToken: str=None) -> CreateAddressBookResponse:
        r"""Creates an address book with the specified details.

        :param self:
        :param ClientRequestToken:  A unique, user-specified identifier for the request that ensures idempotency.<br/>Description:  The description of the address book.<br/>Name:  The name of the address book.<br/>
        :return: AddressBookArn:  The ARN of the newly created address book.<br/>        """
        pass

    def create_business_report_schedule(self, ContentRange: BusinessReportContentRange, Format: str, ScheduleName: str=None, S3BucketName: str=None, S3KeyPrefix: str=None, Recurrence: BusinessReportRecurrence=None, ClientRequestToken: str=None) -> CreateBusinessReportScheduleResponse:
        r"""Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or weekly interval.

        :param self:
        :param ClientRequestToken:  The client request token.<br/>Recurrence:  The recurrence of the reports. If this isn't specified, the report will only be delivered one time when the API is called. :<br/>ContentRange:  The content range of the reports.:<br/>Format:  The format of the generated report (individual CSV files or zipped files of individual files).<br/>S3KeyPrefix:  The S3 key where the report is delivered.<br/>S3BucketName:  The S3 bucket name of the output reports. If this isn't specified, the report can be retrieved from a download link by calling ListBusinessReportSchedule. <br/>ScheduleName:  The name identifier of the schedule.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Interval</i> The interval of the content range.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>StartDate</i> The start date.<br/>
        :return: ScheduleArn:  The ARN of the business report schedule.<br/>        """
        pass

    def create_conference_provider(self, MeetingSetting: MeetingSetting, ConferenceProviderType: str, ConferenceProviderName: str, IPDialIn: IPDialIn=None, PSTNDialIn: PSTNDialIn=None, ClientRequestToken: str=None) -> CreateConferenceProviderResponse:
        r"""Adds a new conference provider under the user's AWS account.

        :param self:
        :param ClientRequestToken:  The request token of the client.<br/>MeetingSetting:  The meeting settings for the conference provider.:<br/>PSTNDialIn:  The information for PSTN conferencing.:<br/>IPDialIn:  The IP endpoint and protocol for calling.:<br/>ConferenceProviderType:  Represents a type within a list of predefined types.<br/>ConferenceProviderName:  The name of the conference provider.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CommsProtocol</i> The protocol, including SIP, SIPS, and H323.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Endpoint</i> The IP address.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OneClickPinDelay</i> The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OneClickIdDelay</i> The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PhoneNumber</i> The phone number to call to join the conference.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CountryCode</i> The zip code.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RequirePin</i> The values that indicate whether the pin is always required.<br/>
        :return: ConferenceProviderArn:  The ARN of the newly-created conference provider.<br/>        """
        pass

    def create_contact(self, FirstName: str, DisplayName: str=None, LastName: str=None, PhoneNumber: str=None, PhoneNumbers: List[PhoneNumber]=None, SipAddresses: List[SipAddress]=None, ClientRequestToken: str=None) -> CreateContactResponse:
        r"""Creates a contact with the specified details.

        :param self:
        :param ClientRequestToken:  A unique, user-specified identifier for this request that ensures idempotency.<br/>SipAddresses:  The list of SIP addresses for the contact.<br/>PhoneNumbers:  The list of phone numbers for the contact.<br/>PhoneNumber:  The phone number of the contact in E.164 format. The phone number type defaults to WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers.<br/>LastName:  The last name of the contact that is used to call the contact on the device.<br/>FirstName:  The first name of the contact that is used to call the contact on the device.<br/>DisplayName:  The name of the contact to display on the console.<br/>
        :return: ContactArn:  The ARN of the newly created address book.<br/>        """
        pass

    def create_gateway_group(self, ClientRequestToken: str, Name: str, Description: str=None) -> CreateGatewayGroupResponse:
        r"""Creates a gateway group with the specified details.

        :param self:
        :param ClientRequestToken:   A unique, user-specified identifier for the request that ensures idempotency.<br/>Description:  The description of the gateway group.<br/>Name:  The name of the gateway group.<br/>
        :return: GatewayGroupArn:  The ARN of the created gateway group.<br/>        """
        pass

    def create_network_profile(self, ClientRequestToken: str, SecurityType: str, Ssid: str, NetworkProfileName: str, Description: str=None, EapMethod: str=None, CurrentPassword: str=None, NextPassword: str=None, CertificateAuthorityArn: str=None, TrustAnchors: List[TrustAnchor]=None) -> CreateNetworkProfileResponse:
        r"""Creates a network profile with the specified details.

        :param self:
        :param ClientRequestToken:  A unique, user-specified identifier for the request that ensures idempotency.<br/>TrustAnchors:  The root certificates of your authentication server that is installed on your devices and used to trust your authentication server during EAP negotiation. <br/>CertificateAuthorityArn:  The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices. <br/>NextPassword:  The next, or subsequent, password of the Wi-Fi network. This password is asynchronously transmitted to the device and is used when the password of the network changes to NextPassword. <br/>CurrentPassword:  The current password of the Wi-Fi network.<br/>EapMethod:  The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.<br/>SecurityType:  The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.<br/>Ssid:  The SSID of the Wi-Fi network.<br/>Description:  Detailed information about a device's network profile.<br/>NetworkProfileName:  The name of the network profile associated with a device.<br/>
        :return: NetworkProfileArn:  The ARN of the network profile associated with a device.<br/>        """
        pass

    def create_profile(self, WakeWord: str, TemperatureUnit: str, DistanceUnit: str, Address: str, Timezone: str, ProfileName: str, Locale: str=None, ClientRequestToken: str=None, SetupModeDisabled: Boolean=None, MaxVolumeLimit: int=None, PSTNEnabled: Boolean=None, MeetingRoomConfiguration: CreateMeetingRoomConfiguration=None) -> CreateProfileResponse:
        r"""Creates a new room profile with the specified details.

        :param self:
        :param MeetingRoomConfiguration:  The meeting room settings of a room profile.:<br/>PSTNEnabled:  Whether PSTN calling is enabled.<br/>MaxVolumeLimit:  The maximum volume limit for a room profile.<br/>SetupModeDisabled:  Whether room profile setup is enabled.<br/>ClientRequestToken:  The user-specified token that is used during the creation of a profile.<br/>Locale:  The locale of the room profile. (This is currently only available to a limited preview audience.)<br/>WakeWord:  A wake word for Alexa, Echo, Amazon, or a computer.<br/>TemperatureUnit:  The temperature unit to be used by devices in the profile.<br/>DistanceUnit:  The distance unit to be used by devices in the profile.<br/>Address:  The valid address for the room.<br/>Timezone:  The time zone used by a room profile.<br/>ProfileName:  The name of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RequireCheckIn</i> Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.”&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>RequireCheckIn</b>: Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.”<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>InstantBooking</i> Settings to automatically book a room for a configured duration if it's free when joining a meeting with Alexa.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>InstantBooking</b>: Settings to automatically book a room for a configured duration if it's free when joining a meeting with Alexa.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>EndOfMeetingReminder</i> Creates settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>EndOfMeetingReminder</b>: Creates settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RoomUtilizationMetricsEnabled</i> Whether room utilization metrics are enabled or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Enabled</i> Whether an end of meeting reminder is enabled or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ReminderType</i> The type of sound that users hear during the end of meeting reminder. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ReminderAtMinutes</i>  A range of 3 to 15 minutes that determines when the reminder begins.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Enabled</i> Whether instant booking is enabled or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>DurationInMinutes</i> Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room when a meeting is started with Alexa.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Enabled</i> Whether require check in is enabled or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ReleaseAfterMinutes</i> Duration between 5 and 20 minutes to determine when to release the room if it's not checked into.<br/>
        :return: ProfileArn:  The ARN of the newly created room profile in the response.<br/>        """
        pass

    def create_room(self, RoomName: str, Description: str=None, ProfileArn: str=None, ProviderCalendarId: str=None, ClientRequestToken: str=None, Tags: List[Tag]=None) -> CreateRoomResponse:
        r"""Creates a room with the specified details.

        :param self:
        :param Tags:  The tags for the room.<br/>ClientRequestToken:  A unique, user-specified identifier for this request that ensures idempotency. <br/>ProviderCalendarId:  The calendar ARN for the room.<br/>ProfileArn:  The profile ARN for the room.<br/>Description:  The description for the room.<br/>RoomName:  The name for the room.<br/>
        :return: RoomArn:  The ARN of the newly created room in the response.<br/>        """
        pass

    def create_skill_group(self, SkillGroupName: str, Description: str=None, ClientRequestToken: str=None) -> CreateSkillGroupResponse:
        r"""Creates a skill group with a specified name and description.

        :param self:
        :param ClientRequestToken:  A unique, user-specified identifier for this request that ensures idempotency. <br/>Description:  The description for the skill group.<br/>SkillGroupName:  The name for the skill group.<br/>
        :return: SkillGroupArn:  The ARN of the newly created skill group in the response.<br/>        """
        pass

    def create_user(self, UserId: str, FirstName: str=None, LastName: str=None, Email: str=None, ClientRequestToken: str=None, Tags: List[Tag]=None) -> CreateUserResponse:
        r"""Creates a user.

        :param self:
        :param Tags:  The tags for the user.<br/>ClientRequestToken:  A unique, user-specified identifier for this request that ensures idempotency. <br/>Email:  The email address for the user.<br/>LastName:  The last name for the user.<br/>FirstName:  The first name for the user.<br/>UserId:  The ARN for the user.<br/>
        :return: UserArn:  The ARN of the newly created user in the response.<br/>        """
        pass

    def delete_address_book(self, AddressBookArn: str) -> DeleteAddressBookResponse:
        r"""Deletes an address book by the address book ARN.

        :param self:
        :param AddressBookArn:  The ARN of the address book to delete.<br/>
        :return:         """
        pass

    def delete_business_report_schedule(self, ScheduleArn: str) -> DeleteBusinessReportScheduleResponse:
        r"""Deletes the recurring report delivery schedule with the specified schedule ARN.

        :param self:
        :param ScheduleArn:  The ARN of the business report schedule.<br/>
        :return:         """
        pass

    def delete_conference_provider(self, ConferenceProviderArn: str) -> DeleteConferenceProviderResponse:
        r"""Deletes a conference provider.

        :param self:
        :param ConferenceProviderArn:  The ARN of the conference provider.<br/>
        :return:         """
        pass

    def delete_contact(self, ContactArn: str) -> DeleteContactResponse:
        r"""Deletes a contact by the contact ARN.

        :param self:
        :param ContactArn:  The ARN of the contact to delete.<br/>
        :return:         """
        pass

    def delete_device(self, DeviceArn: str) -> DeleteDeviceResponse:
        r"""Removes a device from Alexa For Business.

        :param self:
        :param DeviceArn:  The ARN of the device for which to request details.<br/>
        :return:         """
        pass

    def delete_device_usage_data(self, DeviceUsageType: str, DeviceArn: str) -> DeleteDeviceUsageDataResponse:
        r"""When this action is called for a specified shared device, it allows authorized users to delete the device's entire previous history of voice input data and associated response data. This action can be called once every 24 hours for a specific shared device.

        :param self:
        :param DeviceUsageType:  The type of usage data to delete.<br/>DeviceArn:  The ARN of the device.<br/>
        :return:         """
        pass

    def delete_gateway_group(self, GatewayGroupArn: str) -> DeleteGatewayGroupResponse:
        r"""Deletes a gateway group.

        :param self:
        :param GatewayGroupArn:  The ARN of the gateway group to delete.<br/>
        :return:         """
        pass

    def delete_network_profile(self, NetworkProfileArn: str) -> DeleteNetworkProfileResponse:
        r"""Deletes a network profile by the network profile ARN.

        :param self:
        :param NetworkProfileArn:  The ARN of the network profile associated with a device.<br/>
        :return:         """
        pass

    def delete_profile(self, ProfileArn: str=None) -> DeleteProfileResponse:
        r"""Deletes a room profile by the profile ARN.

        :param self:
        :param ProfileArn:  The ARN of the room profile to delete. Required.<br/>
        :return:         """
        pass

    def delete_room(self, RoomArn: str=None) -> DeleteRoomResponse:
        r"""Deletes a room by the room ARN.

        :param self:
        :param RoomArn:  The ARN of the room to delete. Required.<br/>
        :return:         """
        pass

    def delete_room_skill_parameter(self, ParameterKey: str, SkillId: str, RoomArn: str=None) -> DeleteRoomSkillParameterResponse:
        r"""Deletes room skill parameter details by room, skill, and parameter key ID.

        :param self:
        :param ParameterKey:  The room skill parameter key for which to remove details.<br/>SkillId:  The ID of the skill from which to remove the room skill parameter details.<br/>RoomArn:  The ARN of the room from which to remove the room skill parameter details.<br/>
        :return:         """
        pass

    def delete_skill_authorization(self, SkillId: str, RoomArn: str=None) -> DeleteSkillAuthorizationResponse:
        r"""Unlinks a third-party account from a skill.

        :param self:
        :param RoomArn:  The room that the skill is authorized for.<br/>SkillId:  The unique identifier of a skill.<br/>
        :return:         """
        pass

    def delete_skill_group(self, SkillGroupArn: str=None) -> DeleteSkillGroupResponse:
        r"""Deletes a skill group by skill group ARN.

        :param self:
        :param SkillGroupArn:  The ARN of the skill group to delete. Required.<br/>
        :return:         """
        pass

    def delete_user(self, EnrollmentId: str, UserArn: str=None) -> DeleteUserResponse:
        r"""Deletes a specified user by user ARN and enrollment ARN.

        :param self:
        :param EnrollmentId:  The ARN of the user's enrollment in the organization. Required.<br/>UserArn:  The ARN of the user to delete in the organization. Required.<br/>
        :return:         """
        pass

    def disassociate_contact_from_address_book(self, AddressBookArn: str, ContactArn: str) -> DisassociateContactFromAddressBookResponse:
        r"""Disassociates a contact from a given address book.

        :param self:
        :param AddressBookArn:  The ARN of the address from which to disassociate the contact.<br/>ContactArn:  The ARN of the contact to disassociate from an address book.<br/>
        :return:         """
        pass

    def disassociate_device_from_room(self, DeviceArn: str=None) -> DisassociateDeviceFromRoomResponse:
        r"""Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is still registered to the account. The device settings and skills are removed from the room.

        :param self:
        :param DeviceArn:  The ARN of the device to disassociate from a room. Required.<br/>
        :return:         """
        pass

    def disassociate_skill_from_skill_group(self, SkillId: str, SkillGroupArn: str=None) -> DisassociateSkillFromSkillGroupResponse:
        r"""Disassociates a skill from a skill group.

        :param self:
        :param SkillId:  The ARN of a skill group to associate to a skill.<br/>SkillGroupArn:  The unique identifier of a skill. Required.<br/>
        :return:         """
        pass

    def disassociate_skill_from_users(self, SkillId: str) -> DisassociateSkillFromUsersResponse:
        r"""Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.

        :param self:
        :param SkillId:   The private skill ID you want to make unavailable for enrolled users.<br/>
        :return:         """
        pass

    def disassociate_skill_group_from_room(self, SkillGroupArn: str=None, RoomArn: str=None) -> DisassociateSkillGroupFromRoomResponse:
        r"""Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in the room.

        :param self:
        :param RoomArn:  The ARN of the room from which the skill group is to be disassociated. Required.<br/>SkillGroupArn:  The ARN of the skill group to disassociate from a room. Required.<br/>
        :return:         """
        pass

    def forget_smart_home_appliances(self, RoomArn: str) -> ForgetSmartHomeAppliancesResponse:
        r"""Forgets smart home appliances associated to a room.

        :param self:
        :param RoomArn:  The room that the appliances are associated with.<br/>
        :return:         """
        pass

    def get_address_book(self, AddressBookArn: str) -> GetAddressBookResponse:
        r"""Gets address the book details by the address book ARN.

        :param self:
        :param AddressBookArn:  The ARN of the address book for which to request details.<br/>
        :return: AddressBook:  The details of the requested address book.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Description</i> The description of the address book.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Name</i> The name of the address book.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AddressBookArn</i> The ARN of the address book.<br/>        """
        pass

    def get_conference_preference(self) -> GetConferencePreferenceResponse:
        r"""Retrieves the existing conference preferences.

        :param self:
        :param 
        :return: Preference:  The conference preference.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DefaultConferenceProviderArn</i> The ARN of the default conference provider.<br/>        """
        pass

    def get_conference_provider(self, ConferenceProviderArn: str) -> GetConferenceProviderResponse:
        r"""Gets details about a specific conference provider.

        :param self:
        :param ConferenceProviderArn:  The ARN of the newly created conference provider.<br/>
        :return: ConferenceProvider:  The conference provider.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MeetingSetting</i> The meeting settings for the conference provider.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>MeetingSetting</b>: The meeting settings for the conference provider.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PSTNDialIn</i> The information for PSTN conferencing.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PSTNDialIn</b>: The information for PSTN conferencing.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>IPDialIn</i> The IP endpoint and protocol for calling.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>IPDialIn</b>: The IP endpoint and protocol for calling.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Type</i> The type of conference providers.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Name</i> The name of the conference provider.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Arn</i> The ARN of the newly created conference provider.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>CommsProtocol</i> The protocol, including SIP, SIPS, and H323.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Endpoint</i> The IP address.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>OneClickPinDelay</i> The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>OneClickIdDelay</i> The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>PhoneNumber</i> The phone number to call to join the conference.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>CountryCode</i> The zip code.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>RequirePin</i> The values that indicate whether the pin is always required.<br/>        """
        pass

    def get_contact(self, ContactArn: str) -> GetContactResponse:
        r"""Gets the contact details by the contact ARN.

        :param self:
        :param ContactArn:  The ARN of the contact for which to request details.<br/>
        :return: Contact:  The details of the requested contact.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SipAddresses</i> The list of SIP addresses for the contact.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PhoneNumbers</i> The list of phone numbers for the contact.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PhoneNumber</i> The phone number of the contact. The phone number type defaults to WORK. You can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LastName</i> The last name of the contact, used to call the contact on the device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>FirstName</i> The first name of the contact, used to call the contact on the device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DisplayName</i> The name of the contact to display on the console.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ContactArn</i> The ARN of the contact.<br/>        """
        pass

    def get_device(self, DeviceArn: str=None) -> GetDeviceResponse:
        r"""Gets the details of a device by device ARN.

        :param self:
        :param DeviceArn:  The ARN of the device for which to request details. Required.<br/>
        :return: Device:  The details of the device requested. Required.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>NetworkProfileInfo</i> Detailed information about a device's network profile.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>NetworkProfileInfo</b>: Detailed information about a device's network profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DeviceStatusInfo</i> Detailed information about a device's status.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>DeviceStatusInfo</b>: Detailed information about a device's status.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DeviceStatus</i> The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RoomArn</i> The room ARN of a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MacAddress</i> The MAC address of a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SoftwareVersion</i> The software version of a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DeviceName</i> The name of a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DeviceType</i> The type of a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DeviceSerialNumber</i> The serial number of a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DeviceArn</i> The ARN of a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ConnectionStatusUpdatedTime</i> The time (in epoch) when the device connection status changed.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ConnectionStatus</i> The latest available information about the connection status of a device. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>DeviceStatusDetails</i> One or more device status detail descriptions.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateExpirationTime</i> The time (in epoch) when the certificate expires.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateArn</i> The ARN of the certificate associated with a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>NetworkProfileArn</i> The ARN of the network profile associated with a device.<br/>        """
        pass

    def get_gateway(self, GatewayArn: str) -> GetGatewayResponse:
        r"""Retrieves the details of a gateway.

        :param self:
        :param GatewayArn:  The ARN of the gateway to get.<br/>
        :return: Gateway:  The details of the gateway.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SoftwareVersion</i> The software version of the gateway. The gateway automatically updates its software version during normal operation.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>GatewayGroupArn</i> The ARN of the gateway group that the gateway is associated to.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Description</i> The description of the gateway.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Name</i> The name of the gateway.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Arn</i> The ARN of the gateway.<br/>        """
        pass

    def get_gateway_group(self, GatewayGroupArn: str) -> GetGatewayGroupResponse:
        r"""Retrieves the details of a gateway group.

        :param self:
        :param GatewayGroupArn:  The ARN of the gateway group to get.<br/>
        :return: GatewayGroup:  The details of the gateway group.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Description</i> The description of the gateway group.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Name</i> The name of the gateway group.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Arn</i> The ARN of the gateway group.<br/>        """
        pass

    def get_invitation_configuration(self) -> GetInvitationConfigurationResponse:
        r"""Retrieves the configured values for the user enrollment invitation email template.

        :param self:
        :param 
        :return: PrivateSkillIds:  The list of private skill IDs that you want to recommend to the user to enable in the invitation.<br/>ContactEmail:  The email ID of the organization or individual contact that the enrolled user can use. <br/>OrganizationName:  The name of the organization sending the enrollment invite to a user.<br/>        """
        pass

    def get_network_profile(self, NetworkProfileArn: str) -> GetNetworkProfileResponse:
        r"""Gets the network profile details by the network profile ARN.

        :param self:
        :param NetworkProfileArn:  The ARN of the network profile associated with a device.<br/>
        :return: NetworkProfile:  The network profile associated with a device.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>TrustAnchors</i> The root certificates of your authentication server, which is installed on your devices and used to trust your authentication server during EAP negotiation.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CertificateAuthorityArn</i> The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>NextPassword</i> The next, or subsequent, password of the Wi-Fi network. This password is asynchronously transmitted to the device and is used when the password of the network changes to NextPassword. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CurrentPassword</i> The current password of the Wi-Fi network.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>EapMethod</i> The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SecurityType</i> The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Ssid</i> The SSID of the Wi-Fi network.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Description</i> Detailed information about a device's network profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>NetworkProfileName</i> The name of the network profile associated with a device.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>NetworkProfileArn</i> The ARN of the network profile associated with a device.<br/>        """
        pass

    def get_profile(self, ProfileArn: str=None) -> GetProfileResponse:
        r"""Gets the details of a room profile by profile ARN.

        :param self:
        :param ProfileArn:  The ARN of the room profile for which to request details. Required.<br/>
        :return: Profile:  The details of the room profile requested. Required.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MeetingRoomConfiguration</i> Meeting room settings of a room profile.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>MeetingRoomConfiguration</b>: Meeting room settings of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AddressBookArn</i> The ARN of the address book.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PSTNEnabled</i> The PSTN setting of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxVolumeLimit</i> The max volume limit of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SetupModeDisabled</i> The setup mode of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Locale</i> The locale of a room profile. (This is currently available only to a limited preview audience.)<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>WakeWord</i> The wake word of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>TemperatureUnit</i> The temperature unit of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DistanceUnit</i> The distance unit of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Timezone</i> The time zone of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Address</i> The address of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>IsDefault</i> Retrieves if the profile is default or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ProfileName</i> The name of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ProfileArn</i> The ARN of a room profile.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>RoomUtilizationMetricsEnabled</i> Whether room utilization metrics are enabled or not.<br/>Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>EndOfMeetingReminder</b>: Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending.         """
        pass

    def get_room(self, RoomArn: str=None) -> GetRoomResponse:
        r"""Gets room details by room ARN.

        :param self:
        :param RoomArn:  The ARN of the room for which to request details. Required.<br/>
        :return: Room:  The details of the room requested.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ProfileArn</i> The profile ARN of a room.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ProviderCalendarId</i> The provider calendar ARN of a room.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Description</i> The description of a room.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RoomName</i> The name of a room.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RoomArn</i> The ARN of a room.<br/>        """
        pass

    def get_room_skill_parameter(self, ParameterKey: str, SkillId: str, RoomArn: str=None) -> GetRoomSkillParameterResponse:
        r"""Gets room skill parameter details by room, skill, and parameter key ARN.

        :param self:
        :param ParameterKey:  The room skill parameter key for which to get details. Required.<br/>SkillId:  The ARN of the skill from which to get the room skill parameter details. Required.<br/>RoomArn:  The ARN of the room from which to get the room skill parameter details. <br/>
        :return: RoomSkillParameter:  The details of the room skill parameter requested. Required.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ParameterValue</i> The parameter value of a room skill parameter.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ParameterKey</i> The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT” or “SCOPE” as valid values.<br/>        """
        pass

    def get_skill_group(self, SkillGroupArn: str=None) -> GetSkillGroupResponse:
        r"""Gets skill group details by skill group ARN.

        :param self:
        :param SkillGroupArn:  The ARN of the skill group for which to get details. Required.<br/>
        :return: SkillGroup:  The details of the skill group requested. Required.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Description</i> The description of a skill group.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SkillGroupName</i> The name of a skill group.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SkillGroupArn</i> The ARN of a skill group.<br/>        """
        pass

    def list_business_report_schedules(self, NextToken: str=None, MaxResults: int=None) -> ListBusinessReportSchedulesResponse:
        r"""Lists the details of the schedules that a user configured. A download URL of the report associated with each schedule is returned every time this action is called. A new download URL is returned each time, and is valid for 24 hours.

        :param self:
        :param MaxResults:  The maximum number of schedules listed in the call.<br/>NextToken:  The token used to list the remaining schedules from the previous API call.<br/>
        :return: NextToken:  The token used to list the remaining schedules from the previous API call.<br/>BusinessReportSchedules:  The schedule of the reports.<br/>        """
        pass

    def list_conference_providers(self, NextToken: str=None, MaxResults: int=None) -> ListConferenceProvidersResponse:
        r"""Lists conference providers under a specific AWS account.

        :param self:
        :param MaxResults:  The maximum number of conference providers to be returned, per paginated calls.<br/>NextToken:  The tokens used for pagination.<br/>
        :return: NextToken:  The tokens used for pagination.<br/>ConferenceProviders:  The conference providers.<br/>        """
        pass

    def list_device_events(self, DeviceArn: str, EventType: str=None, NextToken: str=None, MaxResults: int=None) -> ListDeviceEventsResponse:
        r"""Lists the device event history, including device connection status, for up to 30 days.

        :param self:
        :param MaxResults:  The maximum number of results to include in the response. The default value is 50. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. <br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response only includes results beyond the token, up to the value specified by MaxResults. When the end of results is reached, the response has a value of null.<br/>EventType:  The event type to filter device events. If EventType isn't specified, this returns a list of all device events in reverse chronological order. If EventType is specified, this returns a list of device events for that EventType in reverse chronological order. <br/>DeviceArn:  The ARN of a device.<br/>
        :return: NextToken:  The token returned to indicate that there is more data available.<br/>DeviceEvents:  The device events requested for the device ARN.<br/>        """
        pass

    def list_gateway_groups(self, NextToken: str=None, MaxResults: int=None) -> ListGatewayGroupsResponse:
        r"""Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.

        :param self:
        :param MaxResults:  The maximum number of gateway group summaries to return. The default is 50.<br/>NextToken:  The token used to paginate though multiple pages of gateway group summaries.<br/>
        :return: NextToken:  The token used to paginate though multiple pages of gateway group summaries.<br/>GatewayGroups:  The gateway groups in the list.<br/>        """
        pass

    def list_gateways(self, GatewayGroupArn: str=None, NextToken: str=None, MaxResults: int=None) -> ListGatewaysResponse:
        r"""Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that gateway group ARN.

        :param self:
        :param MaxResults:  The maximum number of gateway summaries to return. The default is 50.<br/>NextToken:  The token used to paginate though multiple pages of gateway summaries.<br/>GatewayGroupArn:  The gateway group ARN for which to list gateways.<br/>
        :return: NextToken:  The token used to paginate though multiple pages of gateway summaries.<br/>Gateways:  The gateways in the list.<br/>        """
        pass

    def list_skills(self, SkillGroupArn: str=None, EnablementType: str=None, SkillType: str=None, NextToken: str=None, MaxResults: int=None) -> ListSkillsResponse:
        r"""Lists all enabled skills in a specific skill group.

        :param self:
        :param MaxResults:  The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.<br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.<br/>SkillType:  Whether the skill is publicly available or is a private skill.<br/>EnablementType:  Whether the skill is enabled under the user's account.<br/>SkillGroupArn:  The ARN of the skill group for which to list enabled skills.<br/>
        :return: NextToken:  The token returned to indicate that there is more data available.<br/>SkillSummaries:  The list of enabled skills requested. Required.<br/>        """
        pass

    def list_skills_store_categories(self, NextToken: str=None, MaxResults: int=None) -> ListSkillsStoreCategoriesResponse:
        r"""Lists all categories in the Alexa skill store.

        :param self:
        :param MaxResults:  The maximum number of categories returned, per paginated calls.<br/>NextToken:  The tokens used for pagination.<br/>
        :return: NextToken:  The tokens used for pagination.<br/>CategoryList:  The list of categories.<br/>        """
        pass

    def list_skills_store_skills_by_category(self, CategoryId: CategoryId, NextToken: str=None, MaxResults: int=None) -> ListSkillsStoreSkillsByCategoryResponse:
        r"""Lists all skills in the Alexa skill store by category.

        :param self:
        :param MaxResults:  The maximum number of skills returned per paginated calls.<br/>NextToken:  The tokens used for pagination.<br/>CategoryId:  The category ID for which the skills are being retrieved from the skill store.<br/>
        :return: NextToken:  The tokens used for pagination.<br/>SkillsStoreSkills:  The skill store skills.<br/>        """
        pass

    def list_smart_home_appliances(self, RoomArn: str, MaxResults: int=None, NextToken: str=None) -> ListSmartHomeAppliancesResponse:
        r"""Lists all of the smart home appliances associated with a room.

        :param self:
        :param NextToken:  The tokens used for pagination.<br/>MaxResults:  The maximum number of appliances to be returned, per paginated calls.<br/>RoomArn:  The room that the appliances are associated with.<br/>
        :return: NextToken:  The tokens used for pagination.<br/>SmartHomeAppliances:  The smart home appliances.<br/>        """
        pass

    def list_tags(self, Arn: str, NextToken: str=None, MaxResults: int=None) -> ListTagsResponse:
        r"""Lists all tags for the specified resource.

        :param self:
        :param MaxResults:  The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.<br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>. <br/>Arn:  The ARN of the specified resource for which to list tags.<br/>
        :return: NextToken:  The token returned to indicate that there is more data available.<br/>Tags:  The tags requested for the specified resource.<br/>        """
        pass

    def put_conference_preference(self, ConferencePreference: ConferencePreference) -> PutConferencePreferenceResponse:
        r"""Sets the conference preferences on a specific conference provider at the account level.

        :param self:
        :param ConferencePreference:  The conference preference of a specific conference provider.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DefaultConferenceProviderArn</i> The ARN of the default conference provider.<br/>
        :return:         """
        pass

    def put_invitation_configuration(self, OrganizationName: str, ContactEmail: str=None, PrivateSkillIds: List[SkillId]=None) -> PutInvitationConfigurationResponse:
        r"""Configures the email template for the user enrollment invitation with the specified attributes.

        :param self:
        :param PrivateSkillIds:  The list of private skill IDs that you want to recommend to the user to enable in the invitation.<br/>ContactEmail:  The email ID of the organization or individual contact that the enrolled user can use. <br/>OrganizationName:  The name of the organization sending the enrollment invite to a user.<br/>
        :return:         """
        pass

    def put_room_skill_parameter(self, RoomSkillParameter: RoomSkillParameter, SkillId: str, RoomArn: str=None) -> PutRoomSkillParameterResponse:
        r"""Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill parameter.

        :param self:
        :param RoomSkillParameter:  The updated room skill parameter. Required.:<br/>SkillId:  The ARN of the skill associated with the room skill parameter. Required.<br/>RoomArn:  The ARN of the room associated with the room skill parameter. Required.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ParameterValue</i> The parameter value of a room skill parameter.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ParameterKey</i> The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT” or “SCOPE” as valid values.<br/>
        :return:         """
        pass

    def put_skill_authorization(self, SkillId: str, AuthorizationResult: AuthorizationResult, RoomArn: str=None) -> PutSkillAuthorizationResponse:
        r"""Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role, the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the IAM role.

        :param self:
        :param RoomArn:  The room that the skill is authorized for.<br/>SkillId:  The unique identifier of a skill.<br/>AuthorizationResult:  The authorization result specific to OAUTH code grant output. "Code” must be populated in the AuthorizationResult map to establish the authorization.<br/>
        :return:         """
        pass

    def register_avs_device(self, AmazonId: str, DeviceSerialNumber: str, ProductId: str, UserCode: str, ClientId: str) -> RegisterAVSDeviceResponse:
        r"""Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service (AVS).

        :param self:
        :param AmazonId:  The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's Developer Console.<br/>DeviceSerialNumber:  The key generated by the OEM that uniquely identifies a specified instance of your AVS device.<br/>ProductId:  The product ID used to identify your AVS device during authorization.<br/>UserCode:  The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device Authorization Request component of the OAuth code-based linking specification.<br/>ClientId:  The client ID of the OEM used for code-based linking authorization on an AVS device.<br/>
        :return: DeviceArn:  The ARN of the device.<br/>        """
        pass

    def reject_skill(self, SkillId: str) -> RejectSkillResponse:
        r"""Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the ApproveSkill API. 

        :param self:
        :param SkillId:  The unique identifier of the skill.<br/>
        :return:         """
        pass

    def resolve_room(self, SkillId: str, UserId: str) -> ResolveRoomResponse:
        r"""Determines the details for the room from which a skill request was invoked. This operation is used by skill developers.

        :param self:
        :param SkillId:  The ARN of the skill that was requested. Required.<br/>UserId:  The ARN of the user. Required.<br/>
        :return: RoomSkillParameters:  Response to get the room profile request. Required.<br/>RoomName:  The name of the room from which the skill request was invoked.<br/>RoomArn:  The ARN of the room from which the skill request was invoked.<br/>        """
        pass

    def revoke_invitation(self, UserArn: str=None, EnrollmentId: str=None) -> RevokeInvitationResponse:
        r"""Revokes an invitation and invalidates the enrollment URL.

        :param self:
        :param EnrollmentId:  The ARN of the enrollment invitation to revoke. Required.<br/>UserArn:  The ARN of the user for whom to revoke an enrollment invitation. Required.<br/>
        :return:         """
        pass

    def search_address_books(self, Filters: List[Filter]=None, SortCriteria: List[Sort]=None, NextToken: str=None, MaxResults: int=None) -> SearchAddressBooksResponse:
        r"""Searches address books and lists the ones that meet a set of filter and sort criteria.

        :param self:
        :param MaxResults:  The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.<br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response only includes results beyond the token, up to the value specified by MaxResults.<br/>SortCriteria:  The sort order to use in listing the specified set of address books. The supported sort key is AddressBookName.<br/>Filters:  The filters to use to list a specified set of address books. The supported filter key is AddressBookName.<br/>
        :return: TotalCount:  The total number of address books returned.<br/>NextToken:  The token returned to indicate that there is more data available.<br/>AddressBooks:  The address books that meet the specified set of filter criteria, in sort order.<br/>        """
        pass

    def search_contacts(self, Filters: List[Filter]=None, SortCriteria: List[Sort]=None, NextToken: str=None, MaxResults: int=None) -> SearchContactsResponse:
        r"""Searches contacts and lists the ones that meet a set of filter and sort criteria.

        :param self:
        :param MaxResults:  The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.<br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response only includes results beyond the token, up to the value specified by MaxResults.<br/>SortCriteria:  The sort order to use in listing the specified set of contacts. The supported sort keys are DisplayName, FirstName, and LastName.<br/>Filters:  The filters to use to list a specified set of address books. The supported filter keys are DisplayName, FirstName, LastName, and AddressBookArns.<br/>
        :return: TotalCount:  The total number of contacts returned.<br/>NextToken:  The token returned to indicate that there is more data available.<br/>Contacts:  The contacts that meet the specified set of filter criteria, in sort order.<br/>        """
        pass

    def search_devices(self, NextToken: str=None, MaxResults: int=None, Filters: List[Filter]=None, SortCriteria: List[Sort]=None) -> SearchDevicesResponse:
        r"""Searches devices and lists the ones that meet a set of filter criteria.

        :param self:
        :param SortCriteria:  The sort order to use in listing the specified set of devices. Supported sort keys are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber, ConnectionStatus, NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.<br/>Filters:  The filters to use to list a specified set of devices. Supported filter keys are DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType, DeviceSerialNumber, UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE), NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.<br/>MaxResults:  The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.<br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.<br/>
        :return: TotalCount:  The total number of devices returned.<br/>NextToken:  The token returned to indicate that there is more data available.<br/>Devices:  The devices that meet the specified set of filter criteria, in sort order.<br/>        """
        pass

    def search_network_profiles(self, NextToken: str=None, MaxResults: int=None, Filters: List[Filter]=None, SortCriteria: List[Sort]=None) -> SearchNetworkProfilesResponse:
        r"""Searches network profiles and lists the ones that meet a set of filter and sort criteria.

        :param self:
        :param SortCriteria:  The sort order to use to list the specified set of network profiles. Valid sort criteria includes NetworkProfileName, Ssid, and SecurityType.<br/>Filters:  The filters to use to list a specified set of network profiles. Valid filters are NetworkProfileName, Ssid, and SecurityType.<br/>MaxResults:  The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. <br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. <br/>
        :return: TotalCount:  The total number of network profiles returned.<br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults.<br/>NetworkProfiles:  The network profiles that meet the specified set of filter criteria, in sort order. It is a list of NetworkProfileData objects. <br/>        """
        pass

    def search_profiles(self, NextToken: str=None, MaxResults: int=None, Filters: List[Filter]=None, SortCriteria: List[Sort]=None) -> SearchProfilesResponse:
        r"""Searches room profiles and lists the ones that meet a set of filter criteria.

        :param self:
        :param SortCriteria:  The sort order to use in listing the specified set of room profiles. Supported sort keys are ProfileName and Address.<br/>Filters:  The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and Address. Required. <br/>MaxResults:  The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.<br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.<br/>
        :return: TotalCount:  The total number of room profiles returned.<br/>NextToken:  The token returned to indicate that there is more data available.<br/>Profiles:  The profiles that meet the specified set of filter criteria, in sort order.<br/>        """
        pass

    def search_rooms(self, NextToken: str=None, MaxResults: int=None, Filters: List[Filter]=None, SortCriteria: List[Sort]=None) -> SearchRoomsResponse:
        r"""Searches rooms and lists the ones that meet a set of filter and sort criteria.

        :param self:
        :param SortCriteria:  The sort order to use in listing the specified set of rooms. The supported sort keys are RoomName and ProfileName.<br/>Filters:  The filters to use to list a specified set of rooms. The supported filter keys are RoomName and ProfileName.<br/>MaxResults:  The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved. <br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.<br/>
        :return: TotalCount:  The total number of rooms returned.<br/>NextToken:  The token returned to indicate that there is more data available.<br/>Rooms:  The rooms that meet the specified set of filter criteria, in sort order.<br/>        """
        pass

    def search_skill_groups(self, NextToken: str=None, MaxResults: int=None, Filters: List[Filter]=None, SortCriteria: List[Sort]=None) -> SearchSkillGroupsResponse:
        r"""Searches skill groups and lists the ones that meet a set of filter and sort criteria.

        :param self:
        :param SortCriteria:  The sort order to use in listing the specified set of skill groups. The supported sort key is SkillGroupName. <br/>Filters:  The filters to use to list a specified set of skill groups. The supported filter key is SkillGroupName. <br/>MaxResults:  The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved. <br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>. Required.<br/>
        :return: TotalCount:  The total number of skill groups returned.<br/>NextToken:  The token returned to indicate that there is more data available.<br/>SkillGroups:  The skill groups that meet the filter criteria, in sort order.<br/>        """
        pass

    def search_users(self, NextToken: str=None, MaxResults: int=None, Filters: List[Filter]=None, SortCriteria: List[Sort]=None) -> SearchUsersResponse:
        r"""Searches users and lists the ones that meet a set of filter and sort criteria.

        :param self:
        :param SortCriteria:  The sort order to use in listing the filtered set of users. Required. Supported sort keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.<br/>Filters:  The filters to use for listing a specific set of users. Required. Supported filter keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.<br/>MaxResults:  The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved. Required.<br/>NextToken:  An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>. Required.<br/>
        :return: TotalCount:  The total number of users returned.<br/>NextToken:  The token returned to indicate that there is more data available.<br/>Users:  The users that meet the specified set of filter criteria, in sort order.<br/>        """
        pass

    def send_announcement(self, ClientRequestToken: str, Content: Content, RoomFilters: List[Filter], TimeToLiveInSeconds: int=None) -> SendAnnouncementResponse:
        r"""Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search or filter. 

        :param self:
        :param ClientRequestToken:  The unique, user-specified identifier for the request that ensures idempotency.<br/>TimeToLiveInSeconds:  The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the announcement is not delivered.<br/>Content:  The announcement content. This can contain only one of the three possible announcement types (text, SSML or audio).:<br/>RoomFilters:  The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AudioList</i> The list of audio messages.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SsmlList</i> The list of SSML messages.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>TextList</i> The list of text messages.<br/>
        :return: AnnouncementArn:  The identifier of the announcement.<br/>        """
        pass

    def send_invitation(self, UserArn: str=None) -> SendInvitationResponse:
        r"""Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this operation again, whichever comes first. 

        :param self:
        :param UserArn:  The ARN of the user to whom to send an invitation. Required.<br/>
        :return:         """
        pass

    def start_device_sync(self, Features: List[Feature], RoomArn: str=None, DeviceArn: str=None) -> StartDeviceSyncResponse:
        r"""Resets a device and its account to the known default settings. This clears all information and settings set by previous users in the following ways: <ul> <li> Bluetooth - This unpairs all bluetooth devices paired with your echo device. </li> <li> Volume - This resets the echo device's volume to the default value. </li> <li> Notifications - This clears all notifications from your echo device. </li> <li> Lists - This clears all to-do items from your echo device. </li> <li> Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address books, delegation access for account linking, and communications (if enabled on the room profile). </li> </ul>

        :param self:
        :param Features:  Request structure to start the device sync. Required.<br/>DeviceArn:  The ARN of the device to sync. Required.<br/>RoomArn:  The ARN of the room with which the device to sync is associated. Required.<br/>
        :return:         """
        pass

    def start_smart_home_appliance_discovery(self, RoomArn: str) -> StartSmartHomeApplianceDiscoveryResponse:
        r"""Initiates the discovery of any smart home appliances associated with the room.

        :param self:
        :param RoomArn:  The room where smart home appliance discovery was initiated.<br/>
        :return:         """
        pass

    def tag_resource(self, Tags: List[Tag], Arn: str) -> TagResourceResponse:
        r"""Adds metadata tags to a specified resource.

        :param self:
        :param Tags:  The tags to be added to the specified resource. Do not provide system tags. Required. <br/>Arn:  The ARN of the resource to which to add metadata tags. Required. <br/>
        :return:         """
        pass

    def untag_resource(self, TagKeys: List[TagKey], Arn: str) -> UntagResourceResponse:
        r"""Removes metadata tags from a specified resource.

        :param self:
        :param TagKeys:  The tags to be removed from the specified resource. Do not provide system tags. Required. <br/>Arn:  The ARN of the resource from which to remove metadata tags. Required. <br/>
        :return:         """
        pass

    def update_address_book(self, AddressBookArn: str, Name: str=None, Description: str=None) -> UpdateAddressBookResponse:
        r"""Updates address book details by the address book ARN.

        :param self:
        :param Description:  The updated description of the room.<br/>Name:  The updated name of the room.<br/>AddressBookArn:  The ARN of the room to update.<br/>
        :return:         """
        pass

    def update_business_report_schedule(self, ScheduleArn: str, S3BucketName: str=None, S3KeyPrefix: str=None, Format: str=None, ScheduleName: str=None, Recurrence: BusinessReportRecurrence=None) -> UpdateBusinessReportScheduleResponse:
        r"""Updates the configuration of the report delivery schedule with the specified schedule ARN.

        :param self:
        :param Recurrence:  The recurrence of the reports.:<br/>ScheduleName:  The name identifier of the schedule.<br/>Format:  The format of the generated report (individual CSV files or zipped files of individual files).<br/>S3KeyPrefix:  The S3 key where the report is delivered.<br/>S3BucketName:  The S3 location of the output reports.<br/>ScheduleArn:  The ARN of the business report schedule.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>StartDate</i> The start date.<br/>
        :return:         """
        pass

    def update_conference_provider(self, MeetingSetting: MeetingSetting, ConferenceProviderType: str, ConferenceProviderArn: str, IPDialIn: IPDialIn=None, PSTNDialIn: PSTNDialIn=None) -> UpdateConferenceProviderResponse:
        r"""Updates an existing conference provider's settings.

        :param self:
        :param MeetingSetting:  The meeting settings for the conference provider.:<br/>PSTNDialIn:  The information for PSTN conferencing.:<br/>IPDialIn:  The IP endpoint and protocol for calling.:<br/>ConferenceProviderType:  The type of the conference provider.<br/>ConferenceProviderArn:  The ARN of the conference provider.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CommsProtocol</i> The protocol, including SIP, SIPS, and H323.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Endpoint</i> The IP address.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OneClickPinDelay</i> The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OneClickIdDelay</i> The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PhoneNumber</i> The phone number to call to join the conference.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CountryCode</i> The zip code.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RequirePin</i> The values that indicate whether the pin is always required.<br/>
        :return:         """
        pass

    def update_contact(self, ContactArn: str, DisplayName: str=None, FirstName: str=None, LastName: str=None, PhoneNumber: str=None, PhoneNumbers: List[PhoneNumber]=None, SipAddresses: List[SipAddress]=None) -> UpdateContactResponse:
        r"""Updates the contact details by the contact ARN.

        :param self:
        :param SipAddresses:  The list of SIP addresses for the contact.<br/>PhoneNumbers:  The list of phone numbers for the contact.<br/>PhoneNumber:  The updated phone number of the contact. The phone number type defaults to WORK. You can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers.<br/>LastName:  The updated last name of the contact.<br/>FirstName:  The updated first name of the contact.<br/>DisplayName:  The updated display name of the contact.<br/>ContactArn:  The ARN of the contact to update.<br/>
        :return:         """
        pass

    def update_device(self, DeviceArn: str=None, DeviceName: str=None) -> UpdateDeviceResponse:
        r"""Updates the device name by device ARN.

        :param self:
        :param DeviceName:  The updated device name. Required.<br/>DeviceArn:  The ARN of the device to update. Required.<br/>
        :return:         """
        pass

    def update_gateway(self, GatewayArn: str, Name: str=None, Description: str=None, SoftwareVersion: str=None) -> UpdateGatewayResponse:
        r"""Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left unmodified.

        :param self:
        :param SoftwareVersion:  The updated software version of the gateway. The gateway automatically updates its software version during normal operation.<br/>Description:  The updated description of the gateway.<br/>Name:  The updated name of the gateway.<br/>GatewayArn:  The ARN of the gateway to update.<br/>
        :return:         """
        pass

    def update_gateway_group(self, GatewayGroupArn: str, Name: str=None, Description: str=None) -> UpdateGatewayGroupResponse:
        r"""Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value is left unmodified.

        :param self:
        :param Description:  The updated description of the gateway group.<br/>Name:  The updated name of the gateway group.<br/>GatewayGroupArn:  The ARN of the gateway group to update.<br/>
        :return:         """
        pass

    def update_network_profile(self, NetworkProfileArn: str, NetworkProfileName: str=None, Description: str=None, CurrentPassword: str=None, NextPassword: str=None, CertificateAuthorityArn: str=None, TrustAnchors: List[TrustAnchor]=None) -> UpdateNetworkProfileResponse:
        r"""Updates a network profile by the network profile ARN.

        :param self:
        :param TrustAnchors:  The root certificate(s) of your authentication server that will be installed on your devices and used to trust your authentication server during EAP negotiation. <br/>CertificateAuthorityArn:  The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices. <br/>NextPassword:  The next, or subsequent, password of the Wi-Fi network. This password is asynchronously transmitted to the device and is used when the password of the network changes to NextPassword. <br/>CurrentPassword:  The current password of the Wi-Fi network.<br/>Description:  Detailed information about a device's network profile.<br/>NetworkProfileName:  The name of the network profile associated with a device.<br/>NetworkProfileArn:  The ARN of the network profile associated with a device.<br/>
        :return:         """
        pass

    def update_profile(self, ProfileArn: str=None, ProfileName: str=None, IsDefault: Boolean=None, Timezone: str=None, Address: str=None, DistanceUnit: str=None, TemperatureUnit: str=None, WakeWord: str=None, Locale: str=None, SetupModeDisabled: Boolean=None, MaxVolumeLimit: int=None, PSTNEnabled: Boolean=None, MeetingRoomConfiguration: UpdateMeetingRoomConfiguration=None) -> UpdateProfileResponse:
        r"""Updates an existing room profile by room profile ARN.

        :param self:
        :param MeetingRoomConfiguration:  The updated meeting room settings of a room profile.:<br/>PSTNEnabled:  Whether the PSTN setting of the room profile is enabled.<br/>MaxVolumeLimit:  The updated maximum volume limit for the room profile.<br/>SetupModeDisabled:  Whether the setup mode of the profile is enabled.<br/>Locale:  The updated locale for the room profile. (This is currently only available to a limited preview audience.)<br/>WakeWord:  The updated wake word for the room profile.<br/>TemperatureUnit:  The updated temperature unit for the room profile.<br/>DistanceUnit:  The updated distance unit for the room profile.<br/>Address:  The updated address for the room profile.<br/>Timezone:  The updated timezone for the room profile.<br/>IsDefault:  Sets the profile as default if selected. If this is missing, no update is done to the default status.<br/>ProfileName:  The updated name for the room profile.<br/>ProfileArn:  The ARN of the room profile to update. Required.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RequireCheckIn</i> Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.” &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>RequireCheckIn</b>: Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.” <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>InstantBooking</i> Settings to automatically book an available room available for a configured duration when joining a meeting with Alexa.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>InstantBooking</b>: Settings to automatically book an available room available for a configured duration when joining a meeting with Alexa.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>EndOfMeetingReminder</i> Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>EndOfMeetingReminder</b>: Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>RoomUtilizationMetricsEnabled</i> Whether room utilization metrics are enabled or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Enabled</i> Whether an end of meeting reminder is enabled or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ReminderType</i> The type of sound that users hear during the end of meeting reminder. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ReminderAtMinutes</i> Updates settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Enabled</i> Whether instant booking is enabled or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>DurationInMinutes</i> Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room when a meeting is started with Alexa.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Enabled</i> Whether require check in is enabled or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ReleaseAfterMinutes</i> Duration between 5 and 20 minutes to determine when to release the room if it's not checked into. <br/>
        :return:         """
        pass

    def update_room(self, RoomArn: str=None, RoomName: str=None, Description: str=None, ProviderCalendarId: str=None, ProfileArn: str=None) -> UpdateRoomResponse:
        r"""Updates room details by room ARN.

        :param self:
        :param ProfileArn:  The updated profile ARN for the room.<br/>ProviderCalendarId:  The updated provider calendar ARN for the room.<br/>Description:  The updated description for the room.<br/>RoomName:  The updated name for the room.<br/>RoomArn:  The ARN of the room to update. <br/>
        :return:         """
        pass

    def update_skill_group(self, SkillGroupArn: str=None, SkillGroupName: str=None, Description: str=None) -> UpdateSkillGroupResponse:
        r"""Updates skill group details by skill group ARN.

        :param self:
        :param Description:  The updated description for the skill group.<br/>SkillGroupName:  The updated name for the skill group.<br/>SkillGroupArn:  The ARN of the skill group to update. <br/>
        :return:         """
        pass



class Amplify(BaseClient):
    r""" Amplify is a fully managed continuous deployment and hosting service for modern web apps. """


    class ListAppsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_apps` for valid parameters"""
            pass
    class ListBranchesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_branches` for valid parameters"""
            pass
    class ListDomainAssociationsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_domain_associations` for valid parameters"""
            pass
    class ListJobsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_jobs` for valid parameters"""
            pass


    class CreateAppRequest(Mapping):
        pass
    
    class CreateAppResult(Mapping):
        pass
    
    class EnvironmentVariables(object):
        pass
    
    class EnableBranchAutoBuild(object):
        pass
    
    class EnableBasicAuth(object):
        pass
    
    class CustomRule(Mapping):
        pass
    
    class TagMap(object):
        pass
    
    class EnableAutoBranchCreation(object):
        pass
    
    class AutoBranchCreationPattern(object):
        pass
    
    class AutoBranchCreationConfig(Mapping):
        pass
    
    class CreateBackendEnvironmentRequest(Mapping):
        pass
    
    class CreateBackendEnvironmentResult(Mapping):
        pass
    
    class CreateBranchRequest(Mapping):
        pass
    
    class CreateBranchResult(Mapping):
        pass
    
    class EnableNotification(object):
        pass
    
    class EnableAutoBuild(object):
        pass
    
    class EnablePullRequestPreview(object):
        pass
    
    class CreateDeploymentRequest(Mapping):
        pass
    
    class CreateDeploymentResult(Mapping):
        pass
    
    class FileMap(object):
        pass
    
    class CreateDomainAssociationRequest(Mapping):
        pass
    
    class CreateDomainAssociationResult(Mapping):
        pass
    
    class EnableAutoSubDomain(object):
        pass
    
    class SubDomainSetting(Mapping):
        pass
    
    class CreateWebhookRequest(Mapping):
        pass
    
    class CreateWebhookResult(Mapping):
        pass
    
    class DeleteAppRequest(Mapping):
        pass
    
    class DeleteAppResult(Mapping):
        pass
    
    class DeleteBackendEnvironmentRequest(Mapping):
        pass
    
    class DeleteBackendEnvironmentResult(Mapping):
        pass
    
    class DeleteBranchRequest(Mapping):
        pass
    
    class DeleteBranchResult(Mapping):
        pass
    
    class DeleteDomainAssociationRequest(Mapping):
        pass
    
    class DeleteDomainAssociationResult(Mapping):
        pass
    
    class DeleteJobRequest(Mapping):
        pass
    
    class DeleteJobResult(Mapping):
        pass
    
    class DeleteWebhookRequest(Mapping):
        pass
    
    class DeleteWebhookResult(Mapping):
        pass
    
    class GenerateAccessLogsRequest(Mapping):
        pass
    
    class GenerateAccessLogsResult(Mapping):
        pass
    
    class StartTime(object):
        pass
    
    class EndTime(object):
        pass
    
    class GetAppRequest(Mapping):
        pass
    
    class GetAppResult(Mapping):
        pass
    
    class GetArtifactUrlRequest(Mapping):
        pass
    
    class GetArtifactUrlResult(Mapping):
        pass
    
    class GetBackendEnvironmentRequest(Mapping):
        pass
    
    class GetBackendEnvironmentResult(Mapping):
        pass
    
    class GetBranchRequest(Mapping):
        pass
    
    class GetBranchResult(Mapping):
        pass
    
    class GetDomainAssociationRequest(Mapping):
        pass
    
    class GetDomainAssociationResult(Mapping):
        pass
    
    class GetJobRequest(Mapping):
        pass
    
    class GetJobResult(Mapping):
        pass
    
    class GetWebhookRequest(Mapping):
        pass
    
    class GetWebhookResult(Mapping):
        pass
    
    class ListAppsRequest(Mapping):
        pass
    
    class ListAppsResult(Mapping):
        pass
    
    class ListArtifactsRequest(Mapping):
        pass
    
    class ListArtifactsResult(Mapping):
        pass
    
    class ListBackendEnvironmentsRequest(Mapping):
        pass
    
    class ListBackendEnvironmentsResult(Mapping):
        pass
    
    class ListBranchesRequest(Mapping):
        pass
    
    class ListBranchesResult(Mapping):
        pass
    
    class ListDomainAssociationsRequest(Mapping):
        pass
    
    class ListDomainAssociationsResult(Mapping):
        pass
    
    class ListJobsRequest(Mapping):
        pass
    
    class ListJobsResult(Mapping):
        pass
    
    class ListTagsForResourceRequest(Mapping):
        pass
    
    class ListTagsForResourceResponse(Mapping):
        pass
    
    class ListWebhooksRequest(Mapping):
        pass
    
    class ListWebhooksResult(Mapping):
        pass
    
    class StartDeploymentRequest(Mapping):
        pass
    
    class StartDeploymentResult(Mapping):
        pass
    
    class StartJobRequest(Mapping):
        pass
    
    class StartJobResult(Mapping):
        pass
    
    class CommitTime(object):
        pass
    
    class StopJobRequest(Mapping):
        pass
    
    class StopJobResult(Mapping):
        pass
    
    class TagResourceRequest(Mapping):
        pass
    
    class TagResourceResponse(Mapping):
        pass
    
    class UntagResourceRequest(Mapping):
        pass
    
    class UntagResourceResponse(Mapping):
        pass
    
    class TagKey(object):
        pass
    
    class UpdateAppRequest(Mapping):
        pass
    
    class UpdateAppResult(Mapping):
        pass
    
    class UpdateBranchRequest(Mapping):
        pass
    
    class UpdateBranchResult(Mapping):
        pass
    
    class UpdateDomainAssociationRequest(Mapping):
        pass
    
    class UpdateDomainAssociationResult(Mapping):
        pass
    
    class UpdateWebhookRequest(Mapping):
        pass
    
    class UpdateWebhookResult(Mapping):
        pass
    
    def create_app(self, name: str, description: str=None, repository: str=None, platform: str=None, iamServiceRoleArn: str=None, oauthToken: str=None, accessToken: str=None, environmentVariables: EnvironmentVariables=None, enableBranchAutoBuild: EnableBranchAutoBuild=None, enableBasicAuth: EnableBasicAuth=None, basicAuthCredentials: str=None, customRules: List[CustomRule]=None, tags: TagMap=None, buildSpec: str=None, enableAutoBranchCreation: EnableAutoBranchCreation=None, autoBranchCreationPatterns: List[AutoBranchCreationPattern]=None, autoBranchCreationConfig: AutoBranchCreationConfig=None) -> CreateAppResult:
        r""" Creates a new Amplify App. 

        :param self:
        :param autoBranchCreationConfig:   Automated branch creation config for the Amplify App. :<br/>autoBranchCreationPatterns:   Automated branch creation glob patterns for the Amplify App. <br/>enableAutoBranchCreation:   Enables automated branch creation for the Amplify App. <br/>buildSpec:   BuildSpec for an Amplify App <br/>tags:   Tag for an Amplify App <br/>customRules:   Custom rewrite / redirect rules for an Amplify App. <br/>basicAuthCredentials:   Credentials for Basic Authorization for an Amplify App. <br/>enableBasicAuth:   Enable Basic Authorization for an Amplify App, this will apply to all branches part of this App. <br/>enableBranchAutoBuild:   Enable the auto building of branches for an Amplify App. <br/>environmentVariables:   Environment variables map for an Amplify App. <br/>accessToken:   Personal Access token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key. Token is not stored. <br/>oauthToken:   OAuth token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key. OAuth token is not stored. <br/>iamServiceRoleArn:   AWS IAM service role for an Amplify App <br/>platform:   Platform / framework for an Amplify App <br/>repository:   Repository for an Amplify App <br/>description:   Description for an Amplify App <br/>name:   Name for the Amplify App <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Auth for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto building for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for the auto created branch. <br/>
        :return: app:   Amplify App represents different branches of a repository for building, deploying, and hosting. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>autoBranchCreationConfig</i>  Automated branch creation config for the Amplify App. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>autoBranchCreationConfig</b>:  Automated branch creation config for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>autoBranchCreationPatterns</i>  Automated branch creation glob patterns for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBranchCreation</i>  Enables automated branch creation for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec content for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>productionBranch</i>  Structure with Production Branch information. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>productionBranch</b>:  Structure with Production Branch information. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>customRules</i>  Custom redirect / rewrite rules for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Authorization for branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBranchAutoBuild</i>  Enables auto-building of branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>defaultDomain</i>  Default domain for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>iamServiceRoleArn</i>  IAM service role ARN for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Update date / time for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Create date / time for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>platform</i>  Platform for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>repository</i>  Repository for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i>  Tag for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i>  Name for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>appArn</i>  ARN for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>appId</i>  Unique Id for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Branch Name for Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>thumbnailUrl</i>  Thumbnail URL for Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status of Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastDeployTime</i>  Last Deploy Time of Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Auth for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto building for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for the auto created branch. <br/>        """
        pass

    def create_backend_environment(self, environmentName: str, appId: str, stackName: str=None, deploymentArtifacts: str=None) -> CreateBackendEnvironmentResult:
        r""" Creates a new backend environment for an Amplify App. 

        :param self:
        :param deploymentArtifacts:   Name of deployment artifacts. <br/>stackName:   CloudFormation stack name of backend environment. <br/>environmentName:   Name for the backend environment. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: backendEnvironment:   Backend environment structure for an amplify App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Last updated date and time for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Creation date and time for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>deploymentArtifacts</i>  Name of deployment artifacts. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stackName</i>  CloudFormation stack name of backend environment. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentName</i>  Name for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendEnvironmentArn</i>  Arn for a backend environment, part of an Amplify App. <br/>        """
        pass

    def create_branch(self, branchName: str, appId: str, description: str=None, stage: str=None, framework: str=None, enableNotification: EnableNotification=None, enableAutoBuild: EnableAutoBuild=None, environmentVariables: EnvironmentVariables=None, basicAuthCredentials: str=None, enableBasicAuth: EnableBasicAuth=None, tags: TagMap=None, buildSpec: str=None, ttl: str=None, displayName: str=None, enablePullRequestPreview: EnablePullRequestPreview=None, pullRequestEnvironmentName: str=None, backendEnvironmentArn: str=None) -> CreateBranchResult:
        r""" Creates a new Branch for an Amplify App. 

        :param self:
        :param backendEnvironmentArn:   ARN for a Backend Environment, part of an Amplify App. <br/>pullRequestEnvironmentName:   The Amplify Environment name for the pull request. <br/>enablePullRequestPreview:   Enables Pull Request Preview for this branch. <br/>displayName:   Display name for a branch, will use as the default domain prefix. <br/>ttl:   The content TTL for the website in seconds. <br/>buildSpec:   BuildSpec for the branch. <br/>tags:   Tag for the branch. <br/>enableBasicAuth:   Enables Basic Auth for the branch. <br/>basicAuthCredentials:   Basic Authorization credentials for the branch. <br/>environmentVariables:   Environment Variables for the branch. <br/>enableAutoBuild:   Enables auto building for the branch. <br/>enableNotification:   Enables notifications for the branch. <br/>framework:   Framework for the branch. <br/>stage:   Stage for the branch. <br/>description:   Description for the branch. <br/>branchName:   Name for the branch. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: branch:   Branch structure for an Amplify App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendEnvironmentArn</i>  ARN for a Backend Environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>sourceBranch</i>  The source branch if the branch is a pull request branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>destinationBranch</i>  The destination branch if the branch is a pull request branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for this branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>associatedResources</i>  List of custom resources that are linked to this branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ttl</i>  The content TTL for the website in seconds. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec content for branch for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>thumbnailUrl</i>  Thumbnail URL for the branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Authorization for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>totalNumberOfJobs</i>  Total number of Jobs part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>activeJobId</i>  Id of the active job for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>customDomains</i>  Custom domains for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto-building on push for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables specific to a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Last updated date and time for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Creation date and time for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableNotification</i>  Enables notifications for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>displayName</i>  Display name for a branch, will use as the default domain prefix. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i>  Tag for branch for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Name for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchArn</i>  ARN for a branch, part of an Amplify App. <br/>        """
        pass

    def create_deployment(self, branchName: str, appId: str, fileMap: FileMap=None) -> CreateDeploymentResult:
        r""" Create a deployment for manual deploy apps. (Apps are not connected to repository) 

        :param self:
        :param fileMap:   Optional file map that contains file name as the key and file content md5 hash as the value. If this argument is provided, the service will generate different upload url per file. Otherwise, the service will only generate a single upload url for the zipped files. <br/>branchName:   Name for the branch, for the Job. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: zipUploadUrl:   When the fileMap argument is NOT provided. This zipUploadUrl will be returned. <br/>fileUploadUrls:   When the fileMap argument is provided in the request, the fileUploadUrls will contain a map of file names to upload url. <br/>jobId:   The jobId for this deployment, will supply to start deployment api. <br/>        """
        pass

    def create_domain_association(self, subDomainSettings: List[SubDomainSetting], domainName: str, appId: str, enableAutoSubDomain: EnableAutoSubDomain=None) -> CreateDomainAssociationResult:
        r""" Create a new DomainAssociation on an App 

        :param self:
        :param subDomainSettings:   Setting structure for the Subdomain. <br/>enableAutoSubDomain:   Enables automated creation of Subdomains for branches. (Currently not supported) <br/>domainName:   Domain name for the Domain Association. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: domainAssociation:   Domain Association structure. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>subDomains</i>  Subdomains for the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>certificateVerificationDNSRecord</i>  DNS Record for certificate verification. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusReason</i>  Reason for the current status of the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainStatus</i>  Status fo the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoSubDomain</i>  Enables automated creation of Subdomains for branches. (Currently not supported) <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainName</i>  Name of the domain. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainAssociationArn</i>  ARN for the Domain Association. <br/>        """
        pass

    def create_webhook(self, branchName: str, appId: str, description: str=None) -> CreateWebhookResult:
        r""" Create a new webhook on an App. 

        :param self:
        :param description:   Description for a webhook. <br/>branchName:   Name for a branch, part of an Amplify App. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: webhook:   Webhook structure. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Update date / time for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Create date / time for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Name for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookUrl</i>  Url of the webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookId</i>  Id of the webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookArn</i>  ARN for the webhook. <br/>        """
        pass

    def delete_app(self, appId: str) -> DeleteAppResult:
        r""" Delete an existing Amplify App by appId. 

        :param self:
        :param appId:   Unique Id for an Amplify App. <br/>
        :return: app:   Amplify App represents different branches of a repository for building, deploying, and hosting. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>autoBranchCreationConfig</i>  Automated branch creation config for the Amplify App. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>autoBranchCreationConfig</b>:  Automated branch creation config for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>autoBranchCreationPatterns</i>  Automated branch creation glob patterns for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBranchCreation</i>  Enables automated branch creation for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec content for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>productionBranch</i>  Structure with Production Branch information. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>productionBranch</b>:  Structure with Production Branch information. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>customRules</i>  Custom redirect / rewrite rules for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Authorization for branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBranchAutoBuild</i>  Enables auto-building of branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>defaultDomain</i>  Default domain for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>iamServiceRoleArn</i>  IAM service role ARN for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Update date / time for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Create date / time for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>platform</i>  Platform for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>repository</i>  Repository for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i>  Tag for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i>  Name for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>appArn</i>  ARN for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>appId</i>  Unique Id for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Branch Name for Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>thumbnailUrl</i>  Thumbnail URL for Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status of Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastDeployTime</i>  Last Deploy Time of Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Auth for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto building for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for the auto created branch. <br/>        """
        pass

    def delete_backend_environment(self, environmentName: str, appId: str) -> DeleteBackendEnvironmentResult:
        r""" Delete backend environment for an Amplify App. 

        :param self:
        :param environmentName:   Name of a backend environment of an Amplify App. <br/>appId:   Unique Id of an Amplify App. <br/>
        :return: backendEnvironment:   Backend environment structure for an Amplify App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Last updated date and time for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Creation date and time for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>deploymentArtifacts</i>  Name of deployment artifacts. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stackName</i>  CloudFormation stack name of backend environment. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentName</i>  Name for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendEnvironmentArn</i>  Arn for a backend environment, part of an Amplify App. <br/>        """
        pass

    def delete_branch(self, branchName: str, appId: str) -> DeleteBranchResult:
        r""" Deletes a branch for an Amplify App. 

        :param self:
        :param branchName:   Name for the branch. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: branch:   Branch structure for an Amplify App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendEnvironmentArn</i>  ARN for a Backend Environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>sourceBranch</i>  The source branch if the branch is a pull request branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>destinationBranch</i>  The destination branch if the branch is a pull request branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for this branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>associatedResources</i>  List of custom resources that are linked to this branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ttl</i>  The content TTL for the website in seconds. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec content for branch for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>thumbnailUrl</i>  Thumbnail URL for the branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Authorization for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>totalNumberOfJobs</i>  Total number of Jobs part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>activeJobId</i>  Id of the active job for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>customDomains</i>  Custom domains for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto-building on push for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables specific to a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Last updated date and time for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Creation date and time for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableNotification</i>  Enables notifications for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>displayName</i>  Display name for a branch, will use as the default domain prefix. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i>  Tag for branch for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Name for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchArn</i>  ARN for a branch, part of an Amplify App. <br/>        """
        pass

    def delete_domain_association(self, domainName: str, appId: str) -> DeleteDomainAssociationResult:
        r""" Deletes a DomainAssociation. 

        :param self:
        :param domainName:   Name of the domain. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: domainAssociation:   Structure for Domain Association, which associates a custom domain with an Amplify App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>subDomains</i>  Subdomains for the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>certificateVerificationDNSRecord</i>  DNS Record for certificate verification. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusReason</i>  Reason for the current status of the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainStatus</i>  Status fo the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoSubDomain</i>  Enables automated creation of Subdomains for branches. (Currently not supported) <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainName</i>  Name of the domain. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainAssociationArn</i>  ARN for the Domain Association. <br/>        """
        pass

    def delete_job(self, jobId: str, branchName: str, appId: str) -> DeleteJobResult:
        r""" Delete a job, for an Amplify branch, part of Amplify App. 

        :param self:
        :param jobId:   Unique Id for the Job. <br/>branchName:   Name for the branch, for the Job. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: jobSummary:   Structure for the summary of a Job. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobType</i>  Type for the Job. \n "RELEASE": Manually released from source by using StartJob API. "RETRY": Manually retried by using StartJob API. "WEB_HOOK": Automatically triggered by WebHooks. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>endTime</i>  End date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>startTime</i>  Start date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitTime</i>  Commit date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitMessage</i>  Commit message from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitId</i>  Commit Id from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobId</i>  Unique Id for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobArn</i>  Arn for the Job. <br/>        """
        pass

    def delete_webhook(self, webhookId: str) -> DeleteWebhookResult:
        r""" Deletes a webhook. 

        :param self:
        :param webhookId:   Unique Id for a webhook. <br/>
        :return: webhook:   Webhook structure. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Update date / time for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Create date / time for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Name for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookUrl</i>  Url of the webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookId</i>  Id of the webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookArn</i>  ARN for the webhook. <br/>        """
        pass

    def generate_access_logs(self, appId: str, domainName: str, startTime: StartTime=None, endTime: EndTime=None) -> GenerateAccessLogsResult:
        r""" Retrieve website access logs for a specific time range via a pre-signed URL. 

        :param self:
        :param appId:   Unique Id for an Amplify App. <br/>domainName:   Name of the domain. <br/>endTime:   The time at which the logs should end, inclusive. <br/>startTime:   The time at which the logs should start, inclusive. <br/>
        :return: logUrl:   Pre-signed URL for the requested access logs. <br/>        """
        pass

    def get_app(self, appId: str) -> GetAppResult:
        r""" Retrieves an existing Amplify App by appId. 

        :param self:
        :param appId:   Unique Id for an Amplify App. <br/>
        :return: app:   Amplify App represents different branches of a repository for building, deploying, and hosting. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>autoBranchCreationConfig</i>  Automated branch creation config for the Amplify App. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>autoBranchCreationConfig</b>:  Automated branch creation config for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>autoBranchCreationPatterns</i>  Automated branch creation glob patterns for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBranchCreation</i>  Enables automated branch creation for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec content for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>productionBranch</i>  Structure with Production Branch information. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>productionBranch</b>:  Structure with Production Branch information. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>customRules</i>  Custom redirect / rewrite rules for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Authorization for branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBranchAutoBuild</i>  Enables auto-building of branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>defaultDomain</i>  Default domain for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>iamServiceRoleArn</i>  IAM service role ARN for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Update date / time for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Create date / time for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>platform</i>  Platform for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>repository</i>  Repository for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i>  Tag for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i>  Name for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>appArn</i>  ARN for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>appId</i>  Unique Id for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Branch Name for Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>thumbnailUrl</i>  Thumbnail URL for Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status of Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastDeployTime</i>  Last Deploy Time of Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Auth for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto building for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for the auto created branch. <br/>        """
        pass

    def get_artifact_url(self, artifactId: str) -> GetArtifactUrlResult:
        r""" Retrieves artifact info that corresponds to a artifactId. 

        :param self:
        :param artifactId:   Unique Id for a artifact. <br/>
        :return: artifactUrl:   Presigned url for the artifact. <br/>artifactId:   Unique Id for a artifact. <br/>        """
        pass

    def get_backend_environment(self, environmentName: str, appId: str) -> GetBackendEnvironmentResult:
        r""" Retrieves a backend environment for an Amplify App. 

        :param self:
        :param environmentName:   Name for the backend environment. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: backendEnvironment:   Backend environment structure for an an Amplify App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Last updated date and time for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Creation date and time for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>deploymentArtifacts</i>  Name of deployment artifacts. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stackName</i>  CloudFormation stack name of backend environment. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentName</i>  Name for a backend environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendEnvironmentArn</i>  Arn for a backend environment, part of an Amplify App. <br/>        """
        pass

    def get_branch(self, branchName: str, appId: str) -> GetBranchResult:
        r""" Retrieves a branch for an Amplify App. 

        :param self:
        :param branchName:   Name for the branch. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: branch:   Branch for an Amplify App, which maps to a 3rd party repository branch. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendEnvironmentArn</i>  ARN for a Backend Environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>sourceBranch</i>  The source branch if the branch is a pull request branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>destinationBranch</i>  The destination branch if the branch is a pull request branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for this branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>associatedResources</i>  List of custom resources that are linked to this branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ttl</i>  The content TTL for the website in seconds. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec content for branch for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>thumbnailUrl</i>  Thumbnail URL for the branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Authorization for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>totalNumberOfJobs</i>  Total number of Jobs part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>activeJobId</i>  Id of the active job for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>customDomains</i>  Custom domains for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto-building on push for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables specific to a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Last updated date and time for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Creation date and time for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableNotification</i>  Enables notifications for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>displayName</i>  Display name for a branch, will use as the default domain prefix. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i>  Tag for branch for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Name for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchArn</i>  ARN for a branch, part of an Amplify App. <br/>        """
        pass

    def get_domain_association(self, domainName: str, appId: str) -> GetDomainAssociationResult:
        r""" Retrieves domain info that corresponds to an appId and domainName. 

        :param self:
        :param domainName:   Name of the domain. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: domainAssociation:   Domain Association structure. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>subDomains</i>  Subdomains for the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>certificateVerificationDNSRecord</i>  DNS Record for certificate verification. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusReason</i>  Reason for the current status of the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainStatus</i>  Status fo the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoSubDomain</i>  Enables automated creation of Subdomains for branches. (Currently not supported) <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainName</i>  Name of the domain. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainAssociationArn</i>  ARN for the Domain Association. <br/>        """
        pass

    def get_job(self, jobId: str, branchName: str, appId: str) -> GetJobResult:
        r""" Get a job for a branch, part of an Amplify App. 

        :param self:
        :param jobId:   Unique Id for the Job. <br/>branchName:   Name for the branch, for the Job. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: job:   Structure for an execution job for an Amplify App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>steps</i>  Execution steps for an execution job, for an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>summary</i>  Summary for an execution job for an Amplify App. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>summary</b>:  Summary for an execution job for an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>jobType</i>  Type for the Job. \n "RELEASE": Manually released from source by using StartJob API. "RETRY": Manually retried by using StartJob API. "WEB_HOOK": Automatically triggered by WebHooks. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>endTime</i>  End date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>startTime</i>  Start date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>commitTime</i>  Commit date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>commitMessage</i>  Commit message from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>commitId</i>  Commit Id from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>jobId</i>  Unique Id for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>jobArn</i>  Arn for the Job. <br/>        """
        pass

    def get_webhook(self, webhookId: str) -> GetWebhookResult:
        r""" Retrieves webhook info that corresponds to a webhookId. 

        :param self:
        :param webhookId:   Unique Id for a webhook. <br/>
        :return: webhook:   Webhook structure. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Update date / time for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Create date / time for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Name for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookUrl</i>  Url of the webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookId</i>  Id of the webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookArn</i>  ARN for the webhook. <br/>        """
        pass

    def list_apps(self, nextToken: str=None, maxResults: int=None) -> ListAppsResult:
        r""" Lists existing Amplify Apps. 

        :param self:
        :param maxResults:   Maximum number of records to list in a single response. <br/>nextToken:   Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to fetch more entries. <br/>
        :return: nextToken:   Pagination token. Set to null to start listing Apps from start. If non-null pagination token is returned in a result, then pass its value in here to list more projects. <br/>apps:   List of Amplify Apps. <br/>        """
        pass

    def list_artifacts(self, jobId: str, branchName: str, appId: str, nextToken: str=None, maxResults: int=None) -> ListArtifactsResult:
        r""" List artifacts with an app, a branch, a job and an artifact type. 

        :param self:
        :param maxResults:   Maximum number of records to list in a single response. <br/>nextToken:   Pagination token. Set to null to start listing artifacts from start. If non-null pagination token is returned in a result, then pass its value in here to list more artifacts. <br/>jobId:   Unique Id for an Job. <br/>branchName:   Name for a branch, part of an Amplify App. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: nextToken:   Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to fetch more entries. <br/>artifacts:   List of artifacts. <br/>        """
        pass

    def list_backend_environments(self, appId: str, environmentName: str=None, nextToken: str=None, maxResults: int=None) -> ListBackendEnvironmentsResult:
        r""" Lists backend environments for an Amplify App. 

        :param self:
        :param maxResults:   Maximum number of records to list in a single response. <br/>nextToken:   Pagination token. Set to null to start listing backen environments from start. If a non-null pagination token is returned in a result, then pass its value in here to list more backend environments. <br/>environmentName:   Name of the backend environment <br/>appId:   Unique Id for an amplify App. <br/>
        :return: nextToken:   Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to fetch more entries. <br/>backendEnvironments:   List of backend environments for an Amplify App. <br/>        """
        pass

    def list_branches(self, appId: str, nextToken: str=None, maxResults: int=None) -> ListBranchesResult:
        r""" Lists branches for an Amplify App. 

        :param self:
        :param maxResults:   Maximum number of records to list in a single response. <br/>nextToken:   Pagination token. Set to null to start listing branches from start. If a non-null pagination token is returned in a result, then pass its value in here to list more branches. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: nextToken:   Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to fetch more entries. <br/>branches:   List of branches for an Amplify App. <br/>        """
        pass

    def list_domain_associations(self, appId: str, nextToken: str=None, maxResults: int=None) -> ListDomainAssociationsResult:
        r""" List domains with an app 

        :param self:
        :param maxResults:   Maximum number of records to list in a single response. <br/>nextToken:   Pagination token. Set to null to start listing Apps from start. If non-null pagination token is returned in a result, then pass its value in here to list more projects. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: nextToken:   Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to fetch more entries. <br/>domainAssociations:   List of Domain Associations. <br/>        """
        pass

    def list_jobs(self, branchName: str, appId: str, nextToken: str=None, maxResults: int=None) -> ListJobsResult:
        r""" List Jobs for a branch, part of an Amplify App. 

        :param self:
        :param maxResults:   Maximum number of records to list in a single response. <br/>nextToken:   Pagination token. Set to null to start listing steps from start. If a non-null pagination token is returned in a result, then pass its value in here to list more steps. <br/>branchName:   Name for a branch. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: nextToken:   Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to fetch more entries. <br/>jobSummaries:   Result structure for list job result request. <br/>        """
        pass

    def list_tags_for_resource(self, resourceArn: str) -> ListTagsForResourceResponse:
        r""" List tags for resource. 

        :param self:
        :param resourceArn:   Resource arn used to list tags. <br/>
        :return: tags:   Tags result for response. <br/>        """
        pass

    def list_webhooks(self, appId: str, nextToken: str=None, maxResults: int=None) -> ListWebhooksResult:
        r""" List webhooks with an app. 

        :param self:
        :param maxResults:   Maximum number of records to list in a single response. <br/>nextToken:   Pagination token. Set to null to start listing webhooks from start. If non-null pagination token is returned in a result, then pass its value in here to list more webhooks. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: nextToken:   Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to fetch more entries. <br/>webhooks:   List of webhooks. <br/>        """
        pass

    def start_deployment(self, branchName: str, appId: str, jobId: str=None, sourceUrl: str=None) -> StartDeploymentResult:
        r""" Start a deployment for manual deploy apps. (Apps are not connected to repository) 

        :param self:
        :param sourceUrl:   The sourceUrl for this deployment, used when calling start deployment without create deployment. SourceUrl can be any HTTP GET url that is public accessible and downloads a single zip. <br/>jobId:   The job id for this deployment, generated by create deployment request. <br/>branchName:   Name for the branch, for the Job. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: jobSummary:   Summary for the Job. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobType</i>  Type for the Job. \n "RELEASE": Manually released from source by using StartJob API. "RETRY": Manually retried by using StartJob API. "WEB_HOOK": Automatically triggered by WebHooks. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>endTime</i>  End date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>startTime</i>  Start date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitTime</i>  Commit date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitMessage</i>  Commit message from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitId</i>  Commit Id from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobId</i>  Unique Id for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobArn</i>  Arn for the Job. <br/>        """
        pass

    def start_job(self, jobType: str, branchName: str, appId: str, jobId: str=None, jobReason: str=None, commitId: str=None, commitMessage: str=None, commitTime: CommitTime=None) -> StartJobResult:
        r""" Starts a new job for a branch, part of an Amplify App. 

        :param self:
        :param commitTime:   Commit date / time for the Job. <br/>commitMessage:   Commit message from 3rd party repository provider for the Job. <br/>commitId:   Commit Id from 3rd party repository provider for the Job. <br/>jobReason:   Descriptive reason for starting this job. <br/>jobType:   Type for the Job. Available JobTypes are: \n "RELEASE": Start a new job with the latest change from the specified branch. Only available for apps that have connected to a repository. "RETRY": Retry an existing job. JobId is required for this type of job. <br/>jobId:   Unique Id for an existing job. Required for "RETRY" JobType. <br/>branchName:   Name for the branch, for the Job. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: jobSummary:   Summary for the Job. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobType</i>  Type for the Job. \n "RELEASE": Manually released from source by using StartJob API. "RETRY": Manually retried by using StartJob API. "WEB_HOOK": Automatically triggered by WebHooks. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>endTime</i>  End date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>startTime</i>  Start date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitTime</i>  Commit date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitMessage</i>  Commit message from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitId</i>  Commit Id from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobId</i>  Unique Id for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobArn</i>  Arn for the Job. <br/>        """
        pass

    def stop_job(self, jobId: str, branchName: str, appId: str) -> StopJobResult:
        r""" Stop a job that is in progress, for an Amplify branch, part of Amplify App. 

        :param self:
        :param jobId:   Unique Id for the Job. <br/>branchName:   Name for the branch, for the Job. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: jobSummary:   Summary for the Job. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobType</i>  Type for the Job. \n "RELEASE": Manually released from source by using StartJob API. "RETRY": Manually retried by using StartJob API. "WEB_HOOK": Automatically triggered by WebHooks. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>endTime</i>  End date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>startTime</i>  Start date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitTime</i>  Commit date / time for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitMessage</i>  Commit message from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>commitId</i>  Commit Id from 3rd party repository provider for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobId</i>  Unique Id for the Job. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>jobArn</i>  Arn for the Job. <br/>        """
        pass

    def tag_resource(self, tags: TagMap, resourceArn: str) -> TagResourceResponse:
        r""" Tag resource with tag key and value. 

        :param self:
        :param tags:   Tags used to tag resource. <br/>resourceArn:   Resource arn used to tag resource. <br/>
        :return:         """
        pass

    def untag_resource(self, tagKeys: List[TagKey], resourceArn: str) -> UntagResourceResponse:
        r""" Untag resource with resourceArn. 

        :param self:
        :param tagKeys:   Tag keys used to untag resource. <br/>resourceArn:   Resource arn used to untag resource. <br/>
        :return:         """
        pass

    def update_app(self, appId: str, name: str=None, description: str=None, platform: str=None, iamServiceRoleArn: str=None, environmentVariables: EnvironmentVariables=None, enableBranchAutoBuild: EnableAutoBuild=None, enableBasicAuth: EnableBasicAuth=None, basicAuthCredentials: str=None, customRules: List[CustomRule]=None, buildSpec: str=None, enableAutoBranchCreation: EnableAutoBranchCreation=None, autoBranchCreationPatterns: List[AutoBranchCreationPattern]=None, autoBranchCreationConfig: AutoBranchCreationConfig=None, repository: str=None, oauthToken: str=None, accessToken: str=None) -> UpdateAppResult:
        r""" Updates an existing Amplify App. 

        :param self:
        :param accessToken:   Personal Access token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key. Token is not stored. <br/>oauthToken:   OAuth token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key. OAuth token is not stored. <br/>repository:   Repository for an Amplify App <br/>autoBranchCreationConfig:   Automated branch creation branchConfig for the Amplify App. :<br/>autoBranchCreationPatterns:   Automated branch creation glob patterns for the Amplify App. <br/>enableAutoBranchCreation:   Enables automated branch creation for the Amplify App. <br/>buildSpec:   BuildSpec for an Amplify App. <br/>customRules:   Custom redirect / rewrite rules for an Amplify App. <br/>basicAuthCredentials:   Basic Authorization credentials for an Amplify App. <br/>enableBasicAuth:   Enables Basic Authorization for an Amplify App. <br/>enableBranchAutoBuild:   Enables branch auto-building for an Amplify App. <br/>environmentVariables:   Environment Variables for an Amplify App. <br/>iamServiceRoleArn:   IAM service role for an Amplify App. <br/>platform:   Platform for an Amplify App. <br/>description:   Description for an Amplify App. <br/>name:   Name for an Amplify App. <br/>appId:   Unique Id for an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Auth for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto building for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for the auto created branch. <br/>
        :return: app:   App structure for the updated App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>autoBranchCreationConfig</i>  Automated branch creation config for the Amplify App. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>autoBranchCreationConfig</b>:  Automated branch creation config for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>autoBranchCreationPatterns</i>  Automated branch creation glob patterns for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBranchCreation</i>  Enables automated branch creation for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec content for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>productionBranch</i>  Structure with Production Branch information. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>productionBranch</b>:  Structure with Production Branch information. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>customRules</i>  Custom redirect / rewrite rules for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Authorization for branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBranchAutoBuild</i>  Enables auto-building of branches for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>defaultDomain</i>  Default domain for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>iamServiceRoleArn</i>  IAM service role ARN for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Update date / time for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Create date / time for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>platform</i>  Platform for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>repository</i>  Repository for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i>  Tag for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i>  Name for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>appArn</i>  ARN for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>appId</i>  Unique Id for the Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Branch Name for Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>thumbnailUrl</i>  Thumbnail URL for Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i>  Status of Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastDeployTime</i>  Last Deploy Time of Production Branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Auth for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto building for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for the auto created branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for the auto created branch. <br/>        """
        pass

    def update_branch(self, branchName: str, appId: str, description: str=None, framework: str=None, stage: str=None, enableNotification: EnableNotification=None, enableAutoBuild: EnableAutoBuild=None, environmentVariables: EnvironmentVariables=None, basicAuthCredentials: str=None, enableBasicAuth: EnableBasicAuth=None, buildSpec: str=None, ttl: str=None, displayName: str=None, enablePullRequestPreview: EnablePullRequestPreview=None, pullRequestEnvironmentName: str=None, backendEnvironmentArn: str=None) -> UpdateBranchResult:
        r""" Updates a branch for an Amplify App. 

        :param self:
        :param backendEnvironmentArn:   ARN for a Backend Environment, part of an Amplify App. <br/>pullRequestEnvironmentName:   The Amplify Environment name for the pull request. <br/>enablePullRequestPreview:   Enables Pull Request Preview for this branch. <br/>displayName:   Display name for a branch, will use as the default domain prefix. <br/>ttl:   The content TTL for the website in seconds. <br/>buildSpec:   BuildSpec for the branch. <br/>enableBasicAuth:   Enables Basic Auth for the branch. <br/>basicAuthCredentials:   Basic Authorization credentials for the branch. <br/>environmentVariables:   Environment Variables for the branch. <br/>enableAutoBuild:   Enables auto building for the branch. <br/>enableNotification:   Enables notifications for the branch. <br/>stage:   Stage for the branch. <br/>framework:   Framework for the branch. <br/>description:   Description for the branch. <br/>branchName:   Name for the branch. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: branch:   Branch structure for an Amplify App. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendEnvironmentArn</i>  ARN for a Backend Environment, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>sourceBranch</i>  The source branch if the branch is a pull request branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>destinationBranch</i>  The destination branch if the branch is a pull request branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>pullRequestEnvironmentName</i>  The Amplify Environment name for the pull request. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enablePullRequestPreview</i>  Enables Pull Request Preview for this branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>associatedResources</i>  List of custom resources that are linked to this branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ttl</i>  The content TTL for the website in seconds. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>buildSpec</i>  BuildSpec content for branch for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>basicAuthCredentials</i>  Basic Authorization credentials for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>thumbnailUrl</i>  Thumbnail URL for the branch. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableBasicAuth</i>  Enables Basic Authorization for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>totalNumberOfJobs</i>  Total number of Jobs part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>activeJobId</i>  Id of the active job for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>framework</i>  Framework for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>customDomains</i>  Custom domains for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoBuild</i>  Enables auto-building on push for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>environmentVariables</i>  Environment Variables specific to a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Last updated date and time for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Creation date and time for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableNotification</i>  Enables notifications for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>displayName</i>  Display name for a branch, will use as the default domain prefix. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stage</i>  Stage for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tags</i>  Tag for branch for Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Name for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchArn</i>  ARN for a branch, part of an Amplify App. <br/>        """
        pass

    def update_domain_association(self, subDomainSettings: List[SubDomainSetting], domainName: str, appId: str, enableAutoSubDomain: EnableAutoSubDomain=None) -> UpdateDomainAssociationResult:
        r""" Create a new DomainAssociation on an App 

        :param self:
        :param subDomainSettings:   Setting structure for the Subdomain. <br/>enableAutoSubDomain:   Enables automated creation of Subdomains for branches. (Currently not supported) <br/>domainName:   Name of the domain. <br/>appId:   Unique Id for an Amplify App. <br/>
        :return: domainAssociation:   Domain Association structure. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>subDomains</i>  Subdomains for the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>certificateVerificationDNSRecord</i>  DNS Record for certificate verification. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusReason</i>  Reason for the current status of the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainStatus</i>  Status fo the Domain Association. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>enableAutoSubDomain</i>  Enables automated creation of Subdomains for branches. (Currently not supported) <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainName</i>  Name of the domain. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>domainAssociationArn</i>  ARN for the Domain Association. <br/>        """
        pass

    def update_webhook(self, webhookId: str, branchName: str=None, description: str=None) -> UpdateWebhookResult:
        r""" Update a webhook. 

        :param self:
        :param description:   Description for a webhook. <br/>branchName:   Name for a branch, part of an Amplify App. <br/>webhookId:   Unique Id for a webhook. <br/>
        :return: webhook:   Webhook structure. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>updateTime</i>  Update date / time for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>createTime</i>  Create date / time for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>description</i>  Description for a webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>branchName</i>  Name for a branch, part of an Amplify App. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookUrl</i>  Url of the webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookId</i>  Id of the webhook. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>webhookArn</i>  ARN for the webhook. <br/>        """
        pass



class APIGateway(BaseClient):
    r"""<fullname>Amazon API Gateway</fullname> Amazon API Gateway helps developers deliver robust, secure, and scalable mobile and web application back ends. API Gateway allows developers to securely connect mobile and web applications to APIs that run on AWS Lambda, Amazon EC2, or other publicly addressable web services that are hosted outside of AWS."""


    class GetApiKeysPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_api_keys` for valid parameters"""
            pass
    class GetBasePathMappingsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_base_path_mappings` for valid parameters"""
            pass
    class GetClientCertificatesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_client_certificates` for valid parameters"""
            pass
    class GetDeploymentsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_deployments` for valid parameters"""
            pass
    class GetDomainNamesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_domain_names` for valid parameters"""
            pass
    class GetModelsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_models` for valid parameters"""
            pass
    class GetResourcesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_resources` for valid parameters"""
            pass
    class GetRestApisPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_rest_apis` for valid parameters"""
            pass
    class GetUsagePaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_usage` for valid parameters"""
            pass
    class GetUsagePlansPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_usage_plans` for valid parameters"""
            pass
    class GetUsagePlanKeysPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_usage_plan_keys` for valid parameters"""
            pass
    class GetVpcLinksPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_vpc_links` for valid parameters"""
            pass
    class GetAuthorizersPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_authorizers` for valid parameters"""
            pass
    class GetDocumentationPartsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_documentation_parts` for valid parameters"""
            pass
    class GetDocumentationVersionsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_documentation_versions` for valid parameters"""
            pass
    class GetGatewayResponsesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_gateway_responses` for valid parameters"""
            pass
    class GetRequestValidatorsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_request_validators` for valid parameters"""
            pass
    class GetSdkTypesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_sdk_types` for valid parameters"""
            pass


    class CreateApiKeyRequest(Mapping):
        pass
    
    class ApiKey(Mapping):
        pass
    
    class Boolean(object):
        pass
    
    class StageKey(Mapping):
        pass
    
    class MapOfStringToString(object):
        pass
    
    class CreateAuthorizerRequest(Mapping):
        pass
    
    class Authorizer(Mapping):
        pass
    
    class ProviderARN(object):
        pass
    
    class CreateBasePathMappingRequest(Mapping):
        pass
    
    class BasePathMapping(Mapping):
        pass
    
    class CreateDeploymentRequest(Mapping):
        pass
    
    class Deployment(Mapping):
        pass
    
    class NullableBoolean(object):
        pass
    
    class DeploymentCanarySettings(Mapping):
        pass
    
    class CreateDocumentationPartRequest(Mapping):
        pass
    
    class DocumentationPart(Mapping):
        pass
    
    class DocumentationPartLocation(Mapping):
        pass
    
    class CreateDocumentationVersionRequest(Mapping):
        pass
    
    class DocumentationVersion(Mapping):
        pass
    
    class CreateDomainNameRequest(Mapping):
        pass
    
    class DomainName(Mapping):
        pass
    
    class EndpointConfiguration(Mapping):
        pass
    
    class CreateModelRequest(Mapping):
        pass
    
    class Model(Mapping):
        pass
    
    class CreateRequestValidatorRequest(Mapping):
        pass
    
    class RequestValidator(Mapping):
        pass
    
    class CreateResourceRequest(Mapping):
        pass
    
    class Resource(Mapping):
        pass
    
    class CreateRestApiRequest(Mapping):
        pass
    
    class RestApi(Mapping):
        pass
    
    class String(object):
        pass
    
    class CreateStageRequest(Mapping):
        pass
    
    class Stage(Mapping):
        pass
    
    class CanarySettings(Mapping):
        pass
    
    class CreateUsagePlanRequest(Mapping):
        pass
    
    class UsagePlan(Mapping):
        pass
    
    class ApiStage(Mapping):
        pass
    
    class ThrottleSettings(Mapping):
        pass
    
    class QuotaSettings(Mapping):
        pass
    
    class CreateUsagePlanKeyRequest(Mapping):
        pass
    
    class UsagePlanKey(Mapping):
        pass
    
    class CreateVpcLinkRequest(Mapping):
        pass
    
    class VpcLink(Mapping):
        pass
    
    class DeleteApiKeyRequest(Mapping):
        pass
    
    class DeleteAuthorizerRequest(Mapping):
        pass
    
    class DeleteBasePathMappingRequest(Mapping):
        pass
    
    class DeleteClientCertificateRequest(Mapping):
        pass
    
    class DeleteDeploymentRequest(Mapping):
        pass
    
    class DeleteDocumentationPartRequest(Mapping):
        pass
    
    class DeleteDocumentationVersionRequest(Mapping):
        pass
    
    class DeleteDomainNameRequest(Mapping):
        pass
    
    class DeleteGatewayResponseRequest(Mapping):
        pass
    
    class DeleteIntegrationRequest(Mapping):
        pass
    
    class DeleteIntegrationResponseRequest(Mapping):
        pass
    
    class DeleteMethodRequest(Mapping):
        pass
    
    class DeleteMethodResponseRequest(Mapping):
        pass
    
    class DeleteModelRequest(Mapping):
        pass
    
    class DeleteRequestValidatorRequest(Mapping):
        pass
    
    class DeleteResourceRequest(Mapping):
        pass
    
    class DeleteRestApiRequest(Mapping):
        pass
    
    class DeleteStageRequest(Mapping):
        pass
    
    class DeleteUsagePlanRequest(Mapping):
        pass
    
    class DeleteUsagePlanKeyRequest(Mapping):
        pass
    
    class DeleteVpcLinkRequest(Mapping):
        pass
    
    class FlushStageAuthorizersCacheRequest(Mapping):
        pass
    
    class FlushStageCacheRequest(Mapping):
        pass
    
    class GenerateClientCertificateRequest(Mapping):
        pass
    
    class ClientCertificate(Mapping):
        pass
    
    class GetAccountRequest(Mapping):
        pass
    
    class Account(Mapping):
        pass
    
    class GetApiKeyRequest(Mapping):
        pass
    
    class GetApiKeysRequest(Mapping):
        pass
    
    class ApiKeys(Mapping):
        pass
    
    class GetAuthorizerRequest(Mapping):
        pass
    
    class GetAuthorizersRequest(Mapping):
        pass
    
    class Authorizers(Mapping):
        pass
    
    class GetBasePathMappingRequest(Mapping):
        pass
    
    class GetBasePathMappingsRequest(Mapping):
        pass
    
    class BasePathMappings(Mapping):
        pass
    
    class GetClientCertificateRequest(Mapping):
        pass
    
    class GetClientCertificatesRequest(Mapping):
        pass
    
    class ClientCertificates(Mapping):
        pass
    
    class GetDeploymentRequest(Mapping):
        pass
    
    class GetDeploymentsRequest(Mapping):
        pass
    
    class Deployments(Mapping):
        pass
    
    class GetDocumentationPartRequest(Mapping):
        pass
    
    class GetDocumentationPartsRequest(Mapping):
        pass
    
    class DocumentationParts(Mapping):
        pass
    
    class GetDocumentationVersionRequest(Mapping):
        pass
    
    class GetDocumentationVersionsRequest(Mapping):
        pass
    
    class DocumentationVersions(Mapping):
        pass
    
    class GetDomainNameRequest(Mapping):
        pass
    
    class GetDomainNamesRequest(Mapping):
        pass
    
    class DomainNames(Mapping):
        pass
    
    class GetExportRequest(Mapping):
        pass
    
    class ExportResponse(Mapping):
        pass
    
    class GetGatewayResponseRequest(Mapping):
        pass
    
    class GatewayResponse(Mapping):
        pass
    
    class GetGatewayResponsesRequest(Mapping):
        pass
    
    class GatewayResponses(Mapping):
        pass
    
    class GetIntegrationRequest(Mapping):
        pass
    
    class Integration(Mapping):
        pass
    
    class GetIntegrationResponseRequest(Mapping):
        pass
    
    class IntegrationResponse(Mapping):
        pass
    
    class GetMethodRequest(Mapping):
        pass
    
    class Method(Mapping):
        pass
    
    class GetMethodResponseRequest(Mapping):
        pass
    
    class MethodResponse(Mapping):
        pass
    
    class GetModelRequest(Mapping):
        pass
    
    class GetModelTemplateRequest(Mapping):
        pass
    
    class Template(Mapping):
        pass
    
    class GetModelsRequest(Mapping):
        pass
    
    class Models(Mapping):
        pass
    
    class GetRequestValidatorRequest(Mapping):
        pass
    
    class GetRequestValidatorsRequest(Mapping):
        pass
    
    class RequestValidators(Mapping):
        pass
    
    class GetResourceRequest(Mapping):
        pass
    
    class GetResourcesRequest(Mapping):
        pass
    
    class Resources(Mapping):
        pass
    
    class GetRestApiRequest(Mapping):
        pass
    
    class GetRestApisRequest(Mapping):
        pass
    
    class RestApis(Mapping):
        pass
    
    class GetSdkRequest(Mapping):
        pass
    
    class SdkResponse(Mapping):
        pass
    
    class GetSdkTypeRequest(Mapping):
        pass
    
    class SdkType(Mapping):
        pass
    
    class GetSdkTypesRequest(Mapping):
        pass
    
    class SdkTypes(Mapping):
        pass
    
    class GetStageRequest(Mapping):
        pass
    
    class GetStagesRequest(Mapping):
        pass
    
    class Stages(Mapping):
        pass
    
    class GetTagsRequest(Mapping):
        pass
    
    class Tags(Mapping):
        pass
    
    class GetUsageRequest(Mapping):
        pass
    
    class Usage(Mapping):
        pass
    
    class GetUsagePlanRequest(Mapping):
        pass
    
    class GetUsagePlanKeyRequest(Mapping):
        pass
    
    class GetUsagePlanKeysRequest(Mapping):
        pass
    
    class UsagePlanKeys(Mapping):
        pass
    
    class GetUsagePlansRequest(Mapping):
        pass
    
    class UsagePlans(Mapping):
        pass
    
    class GetVpcLinkRequest(Mapping):
        pass
    
    class GetVpcLinksRequest(Mapping):
        pass
    
    class VpcLinks(Mapping):
        pass
    
    class ImportApiKeysRequest(Mapping):
        pass
    
    class ApiKeyIds(Mapping):
        pass
    
    class Blob(object):
        pass
    
    class ImportDocumentationPartsRequest(Mapping):
        pass
    
    class DocumentationPartIds(Mapping):
        pass
    
    class ImportRestApiRequest(Mapping):
        pass
    
    class PutGatewayResponseRequest(Mapping):
        pass
    
    class PutIntegrationRequest(Mapping):
        pass
    
    class PutIntegrationResponseRequest(Mapping):
        pass
    
    class PutMethodRequest(Mapping):
        pass
    
    class MapOfStringToBoolean(object):
        pass
    
    class PutMethodResponseRequest(Mapping):
        pass
    
    class PutRestApiRequest(Mapping):
        pass
    
    class TagResourceRequest(Mapping):
        pass
    
    class TestInvokeAuthorizerRequest(Mapping):
        pass
    
    class TestInvokeAuthorizerResponse(Mapping):
        pass
    
    class MapOfStringToList(object):
        pass
    
    class TestInvokeMethodRequest(Mapping):
        pass
    
    class TestInvokeMethodResponse(Mapping):
        pass
    
    class UntagResourceRequest(Mapping):
        pass
    
    class UpdateAccountRequest(Mapping):
        pass
    
    class PatchOperation(Mapping):
        pass
    
    class UpdateApiKeyRequest(Mapping):
        pass
    
    class UpdateAuthorizerRequest(Mapping):
        pass
    
    class UpdateBasePathMappingRequest(Mapping):
        pass
    
    class UpdateClientCertificateRequest(Mapping):
        pass
    
    class UpdateDeploymentRequest(Mapping):
        pass
    
    class UpdateDocumentationPartRequest(Mapping):
        pass
    
    class UpdateDocumentationVersionRequest(Mapping):
        pass
    
    class UpdateDomainNameRequest(Mapping):
        pass
    
    class UpdateGatewayResponseRequest(Mapping):
        pass
    
    class UpdateIntegrationRequest(Mapping):
        pass
    
    class UpdateIntegrationResponseRequest(Mapping):
        pass
    
    class UpdateMethodRequest(Mapping):
        pass
    
    class UpdateMethodResponseRequest(Mapping):
        pass
    
    class UpdateModelRequest(Mapping):
        pass
    
    class UpdateRequestValidatorRequest(Mapping):
        pass
    
    class UpdateResourceRequest(Mapping):
        pass
    
    class UpdateRestApiRequest(Mapping):
        pass
    
    class UpdateStageRequest(Mapping):
        pass
    
    class UpdateUsageRequest(Mapping):
        pass
    
    class UpdateUsagePlanRequest(Mapping):
        pass
    
    class UpdateVpcLinkRequest(Mapping):
        pass
    
    def create_api_key(self, name: str=None, description: str=None, enabled: Boolean=None, generateDistinctId: Boolean=None, value: str=None, stageKeys: List[StageKey]=None, customerId: str=None, tags: MapOfStringToString=None) -> ApiKey:
        r"""Create an <a>ApiKey</a> resource.  <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</a></div>

        :param self:
        :param tags:  The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>customerId:  An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.<br/>stageKeys:  DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.<br/>value:  Specifies a value of the API key.<br/>generateDistinctId:  Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.<br/>enabled:  Specifies whether the <a>ApiKey</a> can be used by callers.<br/>description:  The description of the <a>ApiKey</a>.<br/>name:  The name of the <a>ApiKey</a>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>stageKeys:  A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.<br/>lastUpdatedDate:  The timestamp when the API Key was last updated.<br/>createdDate:  The timestamp when the API Key was created.<br/>enabled:  Specifies whether the API Key can be used by callers.<br/>description:  The description of the API Key.<br/>customerId:  An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.<br/>name:  The name of the API Key.<br/>value:  The value of the API Key.<br/>id:  The identifier of the API Key.<br/>        """
        pass

    def create_authorizer(self, type: str, name: str, restApiId: str, providerARNs: List[ProviderARN]=None, authType: str=None, authorizerUri: str=None, authorizerCredentials: str=None, identitySource: str=None, identityValidationExpression: str=None, authorizerResultTtlInSeconds: int=None) -> Authorizer:
        r"""Adds a new <a>Authorizer</a> resource to an existing <a>RestApi</a> resource. <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a></div>

        :param self:
        :param authorizerResultTtlInSeconds:  The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.<br/>identityValidationExpression:  A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.<br/>identitySource:  The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul><br/>authorizerCredentials:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.<br/>authorizerUri:  Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.<br/>authType:  Optional customer-defined field, used in OpenAPI imports and exports without functional impact.<br/>providerARNs:  A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined. <br/>type:  [Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.<br/>name:  [Required] The name of the authorizer.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: authorizerResultTtlInSeconds:  The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.<br/>identityValidationExpression:  A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.<br/>identitySource:  The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul><br/>authorizerCredentials:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.<br/>authorizerUri:  Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.<br/>authType:  Optional customer-defined field, used in OpenAPI imports and exports without functional impact.<br/>providerARNs:  A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined. <br/>type:  The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.<br/>name:  [Required] The name of the authorizer.<br/>id:  The identifier for the authorizer resource.<br/>        """
        pass

    def create_base_path_mapping(self, restApiId: str, domainName: str, basePath: str=None, stage: str=None) -> BasePathMapping:
        r"""Creates a new <a>BasePathMapping</a> resource.

        :param self:
        :param stage:  The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>basePath:  The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.<br/>domainName:  [Required] The domain name of the <a>BasePathMapping</a> resource to create.<br/>
        :return: stage:  The name of the associated stage.<br/>restApiId:  The string identifier of the associated <a>RestApi</a>.<br/>basePath:  The base path name that callers of the API must provide as part of the URL after the domain name.<br/>        """
        pass

    def create_deployment(self, restApiId: str, stageName: str=None, stageDescription: str=None, description: str=None, cacheClusterEnabled: NullableBoolean=None, cacheClusterSize: str=None, variables: MapOfStringToString=None, canarySettings: DeploymentCanarySettings=None, tracingEnabled: NullableBoolean=None) -> Deployment:
        r"""Creates a <a>Deployment</a> resource, which makes a specified <a>RestApi</a> callable over the internet.

        :param self:
        :param tracingEnabled:  Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.<br/>canarySettings:  The input configuration for the canary deployment when the deployment is a canary release deployment. :<br/>variables:  A map that defines the stage variables for the <a>Stage</a> resource that is associated with the new deployment. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.<br/>cacheClusterSize:  Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster is enabled.<br/>cacheClusterEnabled:  Enables a cache cluster for the <a>Stage</a> resource specified in the input.<br/>description:  The description for the <a>Deployment</a> resource to create.<br/>stageDescription:  The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.<br/>stageName:  The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>useStageCache</i> A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stageVariableOverrides</i> A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>percentTraffic</i> The percentage (0.0-100.0) of traffic routed to the canary deployment.<br/>
        :return: apiSummary:  A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.<br/>createdDate:  The date and time that the deployment resource was created.<br/>description:  The description for the deployment resource.<br/>id:  The identifier for the deployment resource.<br/>        """
        pass

    def create_documentation_part(self, properties: str, location: DocumentationPartLocation, restApiId: str) -> DocumentationPart:
        r"""

        :param self:
        :param properties:  [Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.<br/>location:  [Required] The location of the targeted API entity of the to-be-created documentation part.:<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i> The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusCode</i> The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>method</i> The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>method</code> attribute must match that of the parent entity exactly.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>path</i> The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> [Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.<br/>
        :return: properties:  A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.<br/>location:  The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.:<br/>id:  The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i> The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusCode</i> The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>method</i> The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>method</code> attribute must match that of the parent entity exactly.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>path</i> The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> [Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.<br/>        """
        pass

    def create_documentation_version(self, documentationVersion: str, restApiId: str, stageName: str=None, description: str=None) -> DocumentationVersion:
        r"""

        :param self:
        :param description:  A description about the new documentation snapshot.<br/>stageName:  The stage name to be associated with the new documentation snapshot.<br/>documentationVersion:  [Required] The version identifier of the new snapshot.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: description:  The description of the API documentation snapshot.<br/>createdDate:  The date when the API documentation snapshot is created.<br/>version:  The version identifier of the API documentation snapshot.<br/>        """
        pass

    def create_domain_name(self, domainName: str, certificateName: str=None, certificateBody: str=None, certificatePrivateKey: str=None, certificateChain: str=None, certificateArn: str=None, regionalCertificateName: str=None, regionalCertificateArn: str=None, endpointConfiguration: EndpointConfiguration=None, tags: MapOfStringToString=None, securityPolicy: str=None) -> DomainName:
        r"""Creates a new domain name.

        :param self:
        :param securityPolicy:  The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.<br/>tags:  The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>endpointConfiguration:  The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name. :<br/>regionalCertificateArn:  The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.<br/>regionalCertificateName:  The user-friendly name of the certificate that will be used by regional endpoint for this domain name.<br/>certificateArn:  The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.<br/>certificateChain:  [Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.<br/>certificatePrivateKey:  [Deprecated] Your edge-optimized endpoint's domain name certificate's private key.<br/>certificateBody:  [Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.<br/>certificateName:  The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.<br/>domainName:  [Required] The name of the <a>DomainName</a> resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>securityPolicy:  The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.<br/>domainNameStatusMessage:  An optional text message containing detailed information about status of the <a>DomainName</a> migration.<br/>domainNameStatus:  The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code> and <code>UPDATING</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.<br/>endpointConfiguration:  The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name. :<br/>distributionHostedZoneId:  The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>. <br/>distributionDomainName:  The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a href="https://aws.amazon.com/documentation/cloudfront/" target="_blank">Amazon CloudFront documentation</a>.<br/>regionalCertificateArn:  The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.<br/>regionalCertificateName:  The name of the certificate that will be used for validating the regional domain name.<br/>regionalHostedZoneId:  The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>. <br/>regionalDomainName:  The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.<br/>certificateUploadDate:  The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.<br/>certificateArn:  The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.<br/>certificateName:  The name of the certificate that will be used by edge-optimized endpoint for this domain name.<br/>domainName:  The custom domain name as an API host name, for example, <code>my-api.example.com</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>        """
        pass

    def create_model(self, contentType: str, name: str, restApiId: str, description: str=None, schema: str=None) -> Model:
        r"""Adds a new <a>Model</a> resource to an existing <a>RestApi</a> resource.

        :param self:
        :param contentType:  [Required] The content-type for the model.<br/>schema:  The schema for the model. For <code>application/json</code> models, this should be <a href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a> model.<br/>description:  The description of the model.<br/>name:  [Required] The name of the model. Must be alphanumeric.<br/>restApiId:  [Required] The <a>RestApi</a> identifier under which the <a>Model</a> will be created.<br/>
        :return: contentType:  The content-type for the model.<br/>schema:  The schema for the model. For <code>application/json</code> models, this should be <a href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.<br/>description:  The description of the model.<br/>name:  The name of the model. Must be an alphanumeric string.<br/>id:  The identifier for the model resource.<br/>        """
        pass

    def create_request_validator(self, restApiId: str, name: str=None, validateRequestBody: Boolean=None, validateRequestParameters: Boolean=None) -> RequestValidator:
        r"""Creates a <a>ReqeustValidator</a> of a given <a>RestApi</a>.

        :param self:
        :param validateRequestParameters:  A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.<br/>validateRequestBody:  A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).<br/>name:  The name of the to-be-created <a>RequestValidator</a>.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: validateRequestParameters:  A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).<br/>validateRequestBody:  A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.<br/>name:  The name of this <a>RequestValidator</a><br/>id:  The identifier of this <a>RequestValidator</a>.<br/>        """
        pass

    def create_resource(self, pathPart: str, parentId: str, restApiId: str) -> Resource:
        r"""Creates a <a>Resource</a> resource.

        :param self:
        :param pathPart:  The last path segment for this resource.<br/>parentId:  [Required] The parent resource's identifier.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: resourceMethods:  Gets an API resource's method of a given HTTP verb. <div class="remarks"> The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request. <h4>Example: Get the GET method of an API resource</h4> <h5>Request</h5> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html", "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET", "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}", "templated": true } }, "apiKeyRequired": false, "authorizationType": "NONE", "httpMethod": "GET", "_embedded": { "method:integration": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type": "'application/x-amz-json-1.1'" }, "requestTemplates": { "application/json": "{\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" } } }, "method:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.Content-Type": false }, "statusCode": "200" } } }</code></pre> If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>. </div> <div class="seeAlso"> </div><br/>path:  The full path for this resource.<br/>pathPart:  The last path segment for this resource.<br/>parentId:  The parent resource's identifier.<br/>id:  The resource's identifier.<br/>        """
        pass

    def create_rest_api(self, name: str, description: str=None, version: str=None, cloneFrom: str=None, binaryMediaTypes: List[String]=None, minimumCompressionSize: int=None, apiKeySource: str=None, endpointConfiguration: EndpointConfiguration=None, policy: str=None, tags: MapOfStringToString=None) -> RestApi:
        r"""Creates a new <a>RestApi</a> resource.

        :param self:
        :param tags:  The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>policy:  A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.<br/>endpointConfiguration:  The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API. :<br/>apiKeySource:  The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul> <br/>minimumCompressionSize:  A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.<br/>binaryMediaTypes:  The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.<br/>cloneFrom:  The ID of the <a>RestApi</a> that you want to clone from.<br/>version:  A version identifier for the API.<br/>description:  The description of the <a>RestApi</a>.<br/>name:  [Required] The name of the <a>RestApi</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>policy:  A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.<br/>endpointConfiguration:  The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API. :<br/>apiKeySource:  The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul> <br/>minimumCompressionSize:  A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.<br/>binaryMediaTypes:  The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.<br/>warnings:  The warning messages reported when <code>failonwarnings</code> is turned on during API import.<br/>version:  A version identifier for the API.<br/>createdDate:  The timestamp when the API was created.<br/>description:  The API's description.<br/>name:  The API's name.<br/>id:  The API's identifier. This identifier is unique across all of your APIs in API Gateway.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>        """
        pass

    def create_stage(self, deploymentId: str, stageName: str, restApiId: str, description: str=None, cacheClusterEnabled: Boolean=None, cacheClusterSize: str=None, variables: MapOfStringToString=None, documentationVersion: str=None, canarySettings: CanarySettings=None, tracingEnabled: Boolean=None, tags: MapOfStringToString=None) -> Stage:
        r"""Creates a new <a>Stage</a> resource that references a pre-existing <a>Deployment</a> for the API. 

        :param self:
        :param tags:  The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>tracingEnabled:  Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.<br/>canarySettings:  The canary deployment settings of this stage.:<br/>documentationVersion:  The version of the associated API documentation.<br/>variables:  A map that defines the stage variables for the new <a>Stage</a> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.<br/>cacheClusterSize:  The stage's cache cluster size.<br/>cacheClusterEnabled:  Whether cache clustering is enabled for the stage.<br/>description:  The description of the <a>Stage</a> resource.<br/>deploymentId:  [Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.<br/>stageName:  [Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>useStageCache</i> A Boolean flag to indicate whether the canary deployment uses the stage cache or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stageVariableOverrides</i> Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>deploymentId</i> The ID of the canary deployment.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>percentTraffic</i> The percent (0-100) of traffic diverted to a canary deployment.<br/>
        :return: lastUpdatedDate:  The timestamp when the stage last updated.<br/>createdDate:  The timestamp when the stage was created.<br/>tags:  The collection of tags. Each tag element is associated with a given resource.<br/>webAclArn:  The ARN of the WebAcl associated with the <a>Stage</a>.<br/>tracingEnabled:  Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.<br/>canarySettings:  Settings for the canary deployment in this stage.:<br/>accessLogSettings:  Settings for logging access in this stage.:<br/>documentationVersion:  The version of the associated API documentation.<br/>variables:  A map that defines the stage variables for a <a>Stage</a> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.<br/>methodSettings:  A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage. <br/>cacheClusterStatus:  The status of the cache cluster for the stage, if enabled.<br/>cacheClusterSize:  The size of the cache cluster for the stage, if enabled.<br/>cacheClusterEnabled:  Specifies whether a cache cluster is enabled for the stage.<br/>description:  The stage's description.<br/>stageName:  The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>clientCertificateId:  The identifier of a client certificate for an API stage.<br/>deploymentId:  The identifier of the <a>Deployment</a> that the stage points to.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>destinationArn</i> The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>format</i> A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables</a>. The format must include at least <code>$context.requestId</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>useStageCache</i> A Boolean flag to indicate whether the canary deployment uses the stage cache or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stageVariableOverrides</i> Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>deploymentId</i> The ID of the canary deployment.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>percentTraffic</i> The percent (0-100) of traffic diverted to a canary deployment.<br/>        """
        pass

    def create_usage_plan(self, name: str, description: str=None, apiStages: List[ApiStage]=None, throttle: ThrottleSettings=None, quota: QuotaSettings=None, tags: MapOfStringToString=None) -> UsagePlan:
        r"""Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload. 

        :param self:
        :param tags:  The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>quota:  The quota of the usage plan.:<br/>throttle:  The throttling limits of the usage plan.:<br/>apiStages:  The associated API stages of the usage plan.<br/>description:  The description of the usage plan.<br/>name:  [Required] The name of the usage plan.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>rateLimit</i> The API request steady-state rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>burstLimit</i> The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>period</i> The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>offset</i> The number of requests subtracted from the given limit in the initial time period.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>limit</i> The maximum number of requests that can be made in a given time period.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>productCode:  The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.<br/>quota:  The maximum number of permitted requests per a given unit time interval.:<br/>throttle:  The request throttle limits of a usage plan.:<br/>apiStages:  The associated API stages of a usage plan.<br/>description:  The description of a usage plan.<br/>name:  The name of a usage plan.<br/>id:  The identifier of a <a>UsagePlan</a> resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>rateLimit</i> The API request steady-state rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>burstLimit</i> The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>period</i> The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>offset</i> The number of requests subtracted from the given limit in the initial time period.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>limit</i> The maximum number of requests that can be made in a given time period.<br/>        """
        pass

    def create_usage_plan_key(self, keyType: str, keyId: str, usagePlanId: str) -> UsagePlanKey:
        r"""Creates a usage plan key for adding an existing API key to a usage plan.

        :param self:
        :param keyType:  [Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.<br/>keyId:  [Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.<br/>usagePlanId:  [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-created <a>UsagePlanKey</a> resource representing a plan customer.<br/>
        :return: name:  The name of a usage plan key.<br/>value:  The value of a usage plan key.<br/>type:  The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.<br/>id:  The Id of a usage plan key.<br/>        """
        pass

    def create_vpc_link(self, targetArns: List[String], name: str, description: str=None, tags: MapOfStringToString=None) -> VpcLink:
        r"""Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.

        :param self:
        :param tags:  The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>targetArns:  [Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.<br/>description:  The description of the VPC link.<br/>name:  [Required] The name used to label and identify the VPC link.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>statusMessage:  A description about the VPC link status.<br/>status:  The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>. <br/>targetArns:  The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.<br/>description:  The description of the VPC link.<br/>name:  The name used to label and identify the VPC link.<br/>id:  The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.<br/>        """
        pass

    def delete_api_key(self, apiKey: str):
        r"""Deletes the <a>ApiKey</a> resource.

        :param self:
        :param apiKey:  [Required] The identifier of the <a>ApiKey</a> resource to be deleted.<br/>
        :return:         """
        pass

    def delete_authorizer(self, authorizerId: str, restApiId: str):
        r"""Deletes an existing <a>Authorizer</a> resource. <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a></div>

        :param self:
        :param authorizerId:  [Required] The identifier of the <a>Authorizer</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_base_path_mapping(self, basePath: str, domainName: str):
        r"""Deletes the <a>BasePathMapping</a> resource.

        :param self:
        :param basePath:  [Required] The base path name of the <a>BasePathMapping</a> resource to delete. To specify an empty base path, set this parameter to <code>'(none)'</code>.<br/>domainName:  [Required] The domain name of the <a>BasePathMapping</a> resource to delete.<br/>
        :return:         """
        pass

    def delete_client_certificate(self, clientCertificateId: str):
        r"""Deletes the <a>ClientCertificate</a> resource.

        :param self:
        :param clientCertificateId:  [Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.<br/>
        :return:         """
        pass

    def delete_deployment(self, deploymentId: str, restApiId: str):
        r"""Deletes a <a>Deployment</a> resource. Deleting a deployment will only succeed if there are no <a>Stage</a> resources associated with it.

        :param self:
        :param deploymentId:  [Required] The identifier of the <a>Deployment</a> resource to delete.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_documentation_part(self, documentationPartId: str, restApiId: str):
        r"""

        :param self:
        :param documentationPartId:  [Required] The identifier of the to-be-deleted documentation part.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_documentation_version(self, documentationVersion: str, restApiId: str):
        r"""

        :param self:
        :param documentationVersion:  [Required] The version identifier of a to-be-deleted documentation snapshot.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_domain_name(self, domainName: str):
        r"""Deletes the <a>DomainName</a> resource.

        :param self:
        :param domainName:  [Required] The name of the <a>DomainName</a> resource to be deleted.<br/>
        :return:         """
        pass

    def delete_gateway_response(self, responseType: str, restApiId: str):
        r"""Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and resets it with the default settings.

        :param self:
        :param responseType:  [Required] The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> <br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_integration(self, httpMethod: str, resourceId: str, restApiId: str):
        r"""Represents a delete integration.

        :param self:
        :param httpMethod:  [Required] Specifies a delete integration request's HTTP method.<br/>resourceId:  [Required] Specifies a delete integration request's resource identifier.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_integration_response(self, statusCode: str, httpMethod: str, resourceId: str, restApiId: str):
        r"""Represents a delete integration response.

        :param self:
        :param statusCode:  [Required] Specifies a delete integration response request's status code.<br/>httpMethod:  [Required] Specifies a delete integration response request's HTTP method.<br/>resourceId:  [Required] Specifies a delete integration response request's resource identifier.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_method(self, httpMethod: str, resourceId: str, restApiId: str):
        r"""Deletes an existing <a>Method</a> resource.

        :param self:
        :param httpMethod:  [Required] The HTTP verb of the <a>Method</a> resource.<br/>resourceId:  [Required] The <a>Resource</a> identifier for the <a>Method</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_method_response(self, statusCode: str, httpMethod: str, resourceId: str, restApiId: str):
        r"""Deletes an existing <a>MethodResponse</a> resource.

        :param self:
        :param statusCode:  [Required] The status code identifier for the <a>MethodResponse</a> resource.<br/>httpMethod:  [Required] The HTTP verb of the <a>Method</a> resource.<br/>resourceId:  [Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_model(self, modelName: str, restApiId: str):
        r"""Deletes a model.

        :param self:
        :param modelName:  [Required] The name of the model to delete.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_request_validator(self, requestValidatorId: str, restApiId: str):
        r"""Deletes a <a>RequestValidator</a> of a given <a>RestApi</a>.

        :param self:
        :param requestValidatorId:  [Required] The identifier of the <a>RequestValidator</a> to be deleted.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_resource(self, resourceId: str, restApiId: str):
        r"""Deletes a <a>Resource</a> resource.

        :param self:
        :param resourceId:  [Required] The identifier of the <a>Resource</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_rest_api(self, restApiId: str):
        r"""Deletes the specified API.

        :param self:
        :param restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_stage(self, stageName: str, restApiId: str):
        r"""Deletes a <a>Stage</a> resource.

        :param self:
        :param stageName:  [Required] The name of the <a>Stage</a> resource to delete.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def delete_usage_plan(self, usagePlanId: str):
        r"""Deletes a usage plan of a given plan Id.

        :param self:
        :param usagePlanId:  [Required] The Id of the to-be-deleted usage plan.<br/>
        :return:         """
        pass

    def delete_usage_plan_key(self, keyId: str, usagePlanId: str):
        r"""Deletes a usage plan key and remove the underlying API key from the associated usage plan.

        :param self:
        :param keyId:  [Required] The Id of the <a>UsagePlanKey</a> resource to be deleted.<br/>usagePlanId:  [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-deleted <a>UsagePlanKey</a> resource representing a plan customer.<br/>
        :return:         """
        pass

    def delete_vpc_link(self, vpcLinkId: str):
        r"""Deletes an existing <a>VpcLink</a> of a specified identifier.

        :param self:
        :param vpcLinkId:  [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.<br/>
        :return:         """
        pass

    def flush_stage_authorizers_cache(self, stageName: str, restApiId: str):
        r"""Flushes all authorizer cache entries on a stage.

        :param self:
        :param stageName:  The name of the stage to flush.<br/>restApiId:  The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def flush_stage_cache(self, stageName: str, restApiId: str):
        r"""Flushes a stage's cache.

        :param self:
        :param stageName:  [Required] The name of the stage to flush its cache.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return:         """
        pass

    def generate_client_certificate(self, description: str=None, tags: MapOfStringToString=None) -> ClientCertificate:
        r"""Generates a <a>ClientCertificate</a> resource.

        :param self:
        :param tags:  The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>description:  The description of the <a>ClientCertificate</a>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>expirationDate:  The timestamp when the client certificate will expire.<br/>createdDate:  The timestamp when the client certificate was created.<br/>pemEncodedCertificate:  The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .<br/>description:  The description of the client certificate.<br/>clientCertificateId:  The identifier of the client certificate.<br/>        """
        pass

    def get_account(self) -> Account:
        r"""Gets information about the current <a>Account</a> resource.

        :param self:
        :param 
        :return: apiKeyVersion:  The version of the API keys used for the account.<br/>features:  A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.<br/>throttleSettings:  Specifies the API request limits configured for the current <a>Account</a>.:<br/>cloudwatchRoleArn:  The ARN of an Amazon CloudWatch role for the current <a>Account</a>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>rateLimit</i> The API request steady-state rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>burstLimit</i> The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.<br/>        """
        pass

    def get_api_key(self, apiKey: str, includeValue: NullableBoolean=None) -> ApiKey:
        r"""Gets information about the current <a>ApiKey</a> resource.

        :param self:
        :param includeValue:  A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.<br/>apiKey:  [Required] The identifier of the <a>ApiKey</a> resource.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>stageKeys:  A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.<br/>lastUpdatedDate:  The timestamp when the API Key was last updated.<br/>createdDate:  The timestamp when the API Key was created.<br/>enabled:  Specifies whether the API Key can be used by callers.<br/>description:  The description of the API Key.<br/>customerId:  An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.<br/>name:  The name of the API Key.<br/>value:  The value of the API Key.<br/>id:  The identifier of the API Key.<br/>        """
        pass

    def get_api_keys(self, position: str=None, limit: int=None, nameQuery: str=None, customerId: str=None, includeValues: NullableBoolean=None) -> ApiKeys:
        r"""Gets information about the current <a>ApiKeys</a> resource.

        :param self:
        :param includeValues:  A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.<br/>customerId:  The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.<br/>nameQuery:  The name of queried API keys.<br/>limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>warnings:  A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code> option is set to true.<br/>        """
        pass

    def get_authorizer(self, authorizerId: str, restApiId: str) -> Authorizer:
        r"""Describe an existing <a>Authorizer</a> resource. <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</a></div>

        :param self:
        :param authorizerId:  [Required] The identifier of the <a>Authorizer</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: authorizerResultTtlInSeconds:  The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.<br/>identityValidationExpression:  A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.<br/>identitySource:  The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul><br/>authorizerCredentials:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.<br/>authorizerUri:  Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.<br/>authType:  Optional customer-defined field, used in OpenAPI imports and exports without functional impact.<br/>providerARNs:  A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined. <br/>type:  The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.<br/>name:  [Required] The name of the authorizer.<br/>id:  The identifier for the authorizer resource.<br/>        """
        pass

    def get_authorizers(self, restApiId: str, position: str=None, limit: int=None) -> Authorizers:
        r"""Describe an existing <a>Authorizers</a> resource. <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a></div>

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_base_path_mapping(self, basePath: str, domainName: str) -> BasePathMapping:
        r"""Describe a <a>BasePathMapping</a> resource.

        :param self:
        :param basePath:  [Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.<br/>domainName:  [Required] The domain name of the <a>BasePathMapping</a> resource to be described.<br/>
        :return: stage:  The name of the associated stage.<br/>restApiId:  The string identifier of the associated <a>RestApi</a>.<br/>basePath:  The base path name that callers of the API must provide as part of the URL after the domain name.<br/>        """
        pass

    def get_base_path_mappings(self, domainName: str, position: str=None, limit: int=None) -> BasePathMappings:
        r"""Represents a collection of <a>BasePathMapping</a> resources.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>domainName:  [Required] The domain name of a <a>BasePathMapping</a> resource.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_client_certificate(self, clientCertificateId: str) -> ClientCertificate:
        r"""Gets information about the current <a>ClientCertificate</a> resource.

        :param self:
        :param clientCertificateId:  [Required] The identifier of the <a>ClientCertificate</a> resource to be described.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>expirationDate:  The timestamp when the client certificate will expire.<br/>createdDate:  The timestamp when the client certificate was created.<br/>pemEncodedCertificate:  The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .<br/>description:  The description of the client certificate.<br/>clientCertificateId:  The identifier of the client certificate.<br/>        """
        pass

    def get_client_certificates(self, position: str=None, limit: int=None) -> ClientCertificates:
        r"""Gets a collection of <a>ClientCertificate</a> resources.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_deployment(self, deploymentId: str, restApiId: str, embed: List[String]=None) -> Deployment:
        r"""Gets information about a <a>Deployment</a> resource.

        :param self:
        :param embed:  A query parameter to retrieve the specified embedded resources of the returned <a>Deployment</a> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string. For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.<br/>deploymentId:  [Required] The identifier of the <a>Deployment</a> resource to get information about.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: apiSummary:  A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.<br/>createdDate:  The date and time that the deployment resource was created.<br/>description:  The description for the deployment resource.<br/>id:  The identifier for the deployment resource.<br/>        """
        pass

    def get_deployments(self, restApiId: str, position: str=None, limit: int=None) -> Deployments:
        r"""Gets information about a <a>Deployments</a> collection.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_documentation_part(self, documentationPartId: str, restApiId: str) -> DocumentationPart:
        r"""

        :param self:
        :param documentationPartId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: properties:  A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.<br/>location:  The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.:<br/>id:  The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i> The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusCode</i> The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>method</i> The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>method</code> attribute must match that of the parent entity exactly.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>path</i> The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> [Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.<br/>        """
        pass

    def get_documentation_parts(self, restApiId: str, type: str=None, nameQuery: str=None, path: str=None, position: str=None, limit: int=None, locationStatus: str=None) -> DocumentationParts:
        r"""

        :param self:
        :param locationStatus:  The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <a>DocumentationPart</a> resources with content and <code>UNDOCUMENTED</code> for <a>DocumentationPart</a> resources without content.<br/>limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>path:  The path of API entities of the to-be-retrieved documentation parts.<br/>nameQuery:  The name of API entities of the to-be-retrieved documentation parts.<br/>type:  The type of API entities of the to-be-retrieved documentation parts. <br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_documentation_version(self, documentationVersion: str, restApiId: str) -> DocumentationVersion:
        r"""

        :param self:
        :param documentationVersion:  [Required] The version identifier of the to-be-retrieved documentation snapshot.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: description:  The description of the API documentation snapshot.<br/>createdDate:  The date when the API documentation snapshot is created.<br/>version:  The version identifier of the API documentation snapshot.<br/>        """
        pass

    def get_documentation_versions(self, restApiId: str, position: str=None, limit: int=None) -> DocumentationVersions:
        r"""

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_domain_name(self, domainName: str) -> DomainName:
        r"""Represents a domain name that is contained in a simpler, more intuitive URL that can be called.

        :param self:
        :param domainName:  [Required] The name of the <a>DomainName</a> resource.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>securityPolicy:  The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.<br/>domainNameStatusMessage:  An optional text message containing detailed information about status of the <a>DomainName</a> migration.<br/>domainNameStatus:  The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code> and <code>UPDATING</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.<br/>endpointConfiguration:  The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name. :<br/>distributionHostedZoneId:  The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>. <br/>distributionDomainName:  The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a href="https://aws.amazon.com/documentation/cloudfront/" target="_blank">Amazon CloudFront documentation</a>.<br/>regionalCertificateArn:  The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.<br/>regionalCertificateName:  The name of the certificate that will be used for validating the regional domain name.<br/>regionalHostedZoneId:  The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>. <br/>regionalDomainName:  The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.<br/>certificateUploadDate:  The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.<br/>certificateArn:  The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.<br/>certificateName:  The name of the certificate that will be used by edge-optimized endpoint for this domain name.<br/>domainName:  The custom domain name as an API host name, for example, <code>my-api.example.com</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>        """
        pass

    def get_domain_names(self, position: str=None, limit: int=None) -> DomainNames:
        r"""Represents a collection of <a>DomainName</a> resources.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_export(self, exportType: str, stageName: str, restApiId: str, parameters: MapOfStringToString=None, accepts: str=None) -> ExportResponse:
        r"""Exports a deployed version of a <a>RestApi</a> in a specified format.

        :param self:
        :param accepts:  The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.<br/>parameters:  A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool<br/>exportType:  [Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.<br/>stageName:  [Required] The name of the <a>Stage</a> that will be exported.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: body:  The binary blob response to <a>GetExport</a>, which contains the export.<br/>contentDisposition:  The content-disposition header value in the HTTP response.<br/>contentType:  The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the request.<br/>        """
        pass

    def get_gateway_response(self, responseType: str, restApiId: str) -> GatewayResponse:
        r"""Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.

        :param self:
        :param responseType:  [Required] The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> <br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: defaultResponse:  A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. <br/>responseTemplates:  Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.<br/>responseParameters:  Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.<br/>statusCode:  The HTTP status code for this <a>GatewayResponse</a>.<br/>responseType:  The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> <br/>        """
        pass

    def get_gateway_responses(self, restApiId: str, position: str=None, limit: int=None) -> GatewayResponses:
        r"""Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a> collection for the supported response types.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <a>GatewayResponses</a> collection does not support pagination and the limit does not apply here.<br/>position:  The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: items:  Returns the entire collection, because of no pagination support.<br/>position:  <br/>        """
        pass

    def get_integration(self, httpMethod: str, resourceId: str, restApiId: str) -> Integration:
        r"""Get the integration settings.

        :param self:
        :param httpMethod:  [Required] Specifies a get integration request's HTTP method.<br/>resourceId:  [Required] Specifies a get integration request's resource identifier<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: integrationResponses:  Specifies the integration's responses. <div class="remarks"> <p/> <h4>Example: Get integration responses of a method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre> <h5>Response</h5> The successful response returns <code>200 OK</code> status and a payload as follows: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div><br/>cacheKeyParameters:  A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>cacheNamespace:  An API-specific tag group of related cached parameters. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>timeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.<br/>contentHandling:  Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.<br/>passthroughBehavior:  <div>  Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following:  <ul> <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li> <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li> <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li> </ul> </div><br/>requestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.<br/>requestParameters:  A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.<br/>credentials:  Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.<br/>connectionId:  The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.<br/>connectionType:  The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.<br/>uri:  Specifies Uniform Resource Identifier (URI) of the integration endpoint. <ul> <li> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing.  </li> <li> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code> </li></ul><br/>httpMethod:  Specifies the integration's HTTP method type.<br/>type:  Specifies an API method integration type. The valid value is one of the following: <ul> <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li> <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li> <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li> <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li> <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li> </ul> For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.<br/>        """
        pass

    def get_integration_response(self, statusCode: str, httpMethod: str, resourceId: str, restApiId: str) -> IntegrationResponse:
        r"""Represents a get integration response.

        :param self:
        :param statusCode:  [Required] Specifies a get integration response request's status code.<br/>httpMethod:  [Required] Specifies a get integration response request's HTTP method.<br/>resourceId:  [Required] Specifies a get integration response request's resource identifier.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: contentHandling:  Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.<br/>responseTemplates:  Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.<br/>responseParameters:  A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.<br/>selectionPattern:  Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.<br/>statusCode:  Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.<br/>        """
        pass

    def get_method(self, httpMethod: str, resourceId: str, restApiId: str) -> Method:
        r"""Describe an existing <a>Method</a> resource.

        :param self:
        :param httpMethod:  [Required] Specifies the method request's HTTP method type.<br/>resourceId:  [Required] The <a>Resource</a> identifier for the <a>Method</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: authorizationScopes:  A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.<br/>methodIntegration:  Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end. <div class="remarks"> <p/> <h4>Example: </h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> The successful response returns a <code>200 OK</code> status code and a payload similar to the following: <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true } ], "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:responses": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "0cjtch", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestTemplates": { "application/json": "{\n \"a\": \"$input.params('operand1')\",\n \"b\": \"$input.params('operand2')\", \n \"op\": \"$input.params('operator')\" \n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.operator": "integration.response.body.op", "method.response.header.operand_2": "integration.response.body.b", "method.response.header.operand_1": "integration.response.body.a" }, "responseTemplates": { "application/json": "#set($res = $input.path('$'))\n{\n \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n \"a\" : \"$res.a\",\n \"b\" : \"$res.b\",\n \"op\" : \"$res.op\",\n \"c\" : \"$res.c\"\n}" }, "selectionPattern": "", "statusCode": "200" } } }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a> </div>:<br/>methodResponses:  Gets a method response associated with a given HTTP status code.  <div class="remarks"> The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response. <h4>Example: Get a 200 OK response of a GET method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> The successful response returns a <code>200 OK</code> status code and a payload similar to the following: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.operator": false, "method.response.header.operand_2": false, "method.response.header.operand_1": false }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a> </div><br/>requestModels:  A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).<br/>requestParameters:  A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.<br/>operationName:  A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.<br/>requestValidatorId:  The identifier of a <a>RequestValidator</a> for request validation.<br/>apiKeyRequired:  A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.<br/>authorizerId:  The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.<br/>authorizationType:  The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.<br/>httpMethod:  The method's HTTP verb.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>integrationResponses</i> Specifies the integration's responses. <div class="remarks"> <p/> <h4>Example: Get integration responses of a method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre> <h5>Response</h5> The successful response returns <code>200 OK</code> status and a payload as follows: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>cacheKeyParameters</i> A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>cacheNamespace</i> An API-specific tag group of related cached parameters. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>timeoutInMillis</i> Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>contentHandling</i> Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>passthroughBehavior</i> <div>  Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following:  <ul> <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li> <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li> <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li> </ul> </div><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>requestTemplates</i> Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>requestParameters</i> A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>credentials</i> Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>connectionId</i> The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>connectionType</i> The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>uri</i> Specifies Uniform Resource Identifier (URI) of the integration endpoint. <ul> <li> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing.  </li> <li> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code> </li></ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>httpMethod</i> Specifies the integration's HTTP method type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> Specifies an API method integration type. The valid value is one of the following: <ul> <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li> <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li> <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li> <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li> <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li> </ul> For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.<br/>        """
        pass

    def get_method_response(self, statusCode: str, httpMethod: str, resourceId: str, restApiId: str) -> MethodResponse:
        r"""Describes a <a>MethodResponse</a> resource.

        :param self:
        :param statusCode:  [Required] The status code for the <a>MethodResponse</a> resource.<br/>httpMethod:  [Required] The HTTP verb of the <a>Method</a> resource.<br/>resourceId:  [Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: responseModels:  Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.<br/>responseParameters:  A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)<br/>statusCode:  The method response's status code.<br/>        """
        pass

    def get_model(self, modelName: str, restApiId: str, flatten: Boolean=None) -> Model:
        r"""Describes an existing model defined for a <a>RestApi</a> resource.

        :param self:
        :param flatten:  A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.<br/>modelName:  [Required] The name of the model as an identifier.<br/>restApiId:  [Required] The <a>RestApi</a> identifier under which the <a>Model</a> exists.<br/>
        :return: contentType:  The content-type for the model.<br/>schema:  The schema for the model. For <code>application/json</code> models, this should be <a href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.<br/>description:  The description of the model.<br/>name:  The name of the model. Must be an alphanumeric string.<br/>id:  The identifier for the model resource.<br/>        """
        pass

    def get_model_template(self, modelName: str, restApiId: str) -> Template:
        r"""Generates a sample mapping template that can be used to transform a payload into the structure of a model.

        :param self:
        :param modelName:  [Required] The name of the model for which to generate a template.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: value:  The Apache <a href="https://velocity.apache.org/engine/devel/vtl-reference.html" target="_blank">Velocity Template Language (VTL)</a> template content used for the template resource.<br/>        """
        pass

    def get_models(self, restApiId: str, position: str=None, limit: int=None) -> Models:
        r"""Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_request_validator(self, requestValidatorId: str, restApiId: str) -> RequestValidator:
        r"""Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.

        :param self:
        :param requestValidatorId:  [Required] The identifier of the <a>RequestValidator</a> to be retrieved.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: validateRequestParameters:  A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).<br/>validateRequestBody:  A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.<br/>name:  The name of this <a>RequestValidator</a><br/>id:  The identifier of this <a>RequestValidator</a>.<br/>        """
        pass

    def get_request_validators(self, restApiId: str, position: str=None, limit: int=None) -> RequestValidators:
        r"""Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_resource(self, resourceId: str, restApiId: str, embed: List[String]=None) -> Resource:
        r"""Lists information about a resource.

        :param self:
        :param embed:  A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.<br/>resourceId:  [Required] The identifier for the <a>Resource</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: resourceMethods:  Gets an API resource's method of a given HTTP verb. <div class="remarks"> The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request. <h4>Example: Get the GET method of an API resource</h4> <h5>Request</h5> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html", "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET", "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}", "templated": true } }, "apiKeyRequired": false, "authorizationType": "NONE", "httpMethod": "GET", "_embedded": { "method:integration": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type": "'application/x-amz-json-1.1'" }, "requestTemplates": { "application/json": "{\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" } } }, "method:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.Content-Type": false }, "statusCode": "200" } } }</code></pre> If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>. </div> <div class="seeAlso"> </div><br/>path:  The full path for this resource.<br/>pathPart:  The last path segment for this resource.<br/>parentId:  The parent resource's identifier.<br/>id:  The resource's identifier.<br/>        """
        pass

    def get_resources(self, restApiId: str, position: str=None, limit: int=None, embed: List[String]=None) -> Resources:
        r"""Lists information about a collection of <a>Resource</a> resources.

        :param self:
        :param embed:  A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.<br/>limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_rest_api(self, restApiId: str) -> RestApi:
        r"""Lists the <a>RestApi</a> resource in the collection.

        :param self:
        :param restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>policy:  A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.<br/>endpointConfiguration:  The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API. :<br/>apiKeySource:  The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul> <br/>minimumCompressionSize:  A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.<br/>binaryMediaTypes:  The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.<br/>warnings:  The warning messages reported when <code>failonwarnings</code> is turned on during API import.<br/>version:  A version identifier for the API.<br/>createdDate:  The timestamp when the API was created.<br/>description:  The API's description.<br/>name:  The API's name.<br/>id:  The API's identifier. This identifier is unique across all of your APIs in API Gateway.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>        """
        pass

    def get_rest_apis(self, position: str=None, limit: int=None) -> RestApis:
        r"""Lists the <a>RestApis</a> resources for your collection.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_sdk(self, sdkType: str, stageName: str, restApiId: str, parameters: MapOfStringToString=None) -> SdkResponse:
        r"""Generates a client SDK for a <a>RestApi</a> and <a>Stage</a>.

        :param self:
        :param parameters:  A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. <br/>sdkType:  [Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code> are supported.<br/>stageName:  [Required] The name of the <a>Stage</a> that the SDK will use.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: body:  The binary blob response to <a>GetSdk</a>, which contains the generated SDK.<br/>contentDisposition:  The content-disposition header value in the HTTP response.<br/>contentType:  The content-type header value in the HTTP response.<br/>        """
        pass

    def get_sdk_type(self, id: str) -> SdkType:
        r"""

        :param self:
        :param id:  [Required] The identifier of the queried <a>SdkType</a> instance.<br/>
        :return: configurationProperties:  A list of configuration properties of an <a>SdkType</a>.<br/>description:  The description of an <a>SdkType</a>.<br/>friendlyName:  The user-friendly name of an <a>SdkType</a> instance.<br/>id:  The identifier of an <a>SdkType</a> instance.<br/>        """
        pass

    def get_sdk_types(self, position: str=None, limit: int=None) -> SdkTypes:
        r"""

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_stage(self, stageName: str, restApiId: str) -> Stage:
        r"""Gets information about a <a>Stage</a> resource.

        :param self:
        :param stageName:  [Required] The name of the <a>Stage</a> resource to get information about.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: lastUpdatedDate:  The timestamp when the stage last updated.<br/>createdDate:  The timestamp when the stage was created.<br/>tags:  The collection of tags. Each tag element is associated with a given resource.<br/>webAclArn:  The ARN of the WebAcl associated with the <a>Stage</a>.<br/>tracingEnabled:  Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.<br/>canarySettings:  Settings for the canary deployment in this stage.:<br/>accessLogSettings:  Settings for logging access in this stage.:<br/>documentationVersion:  The version of the associated API documentation.<br/>variables:  A map that defines the stage variables for a <a>Stage</a> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.<br/>methodSettings:  A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage. <br/>cacheClusterStatus:  The status of the cache cluster for the stage, if enabled.<br/>cacheClusterSize:  The size of the cache cluster for the stage, if enabled.<br/>cacheClusterEnabled:  Specifies whether a cache cluster is enabled for the stage.<br/>description:  The stage's description.<br/>stageName:  The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>clientCertificateId:  The identifier of a client certificate for an API stage.<br/>deploymentId:  The identifier of the <a>Deployment</a> that the stage points to.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>destinationArn</i> The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>format</i> A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables</a>. The format must include at least <code>$context.requestId</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>useStageCache</i> A Boolean flag to indicate whether the canary deployment uses the stage cache or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stageVariableOverrides</i> Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>deploymentId</i> The ID of the canary deployment.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>percentTraffic</i> The percent (0-100) of traffic diverted to a canary deployment.<br/>        """
        pass

    def get_stages(self, restApiId: str, deploymentId: str=None) -> Stages:
        r"""Gets information about one or more <a>Stage</a> resources.

        :param self:
        :param deploymentId:  The stages' deployment identifiers.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: item:  The current page of elements from this collection.<br/>        """
        pass

    def get_tags(self, resourceArn: str, position: str=None, limit: int=None) -> Tags:
        r"""Gets the <a>Tags</a> collection for a given resource.

        :param self:
        :param limit:  (Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  (Not currently supported) The current pagination position in the paged result set.<br/>resourceArn:  [Required] The ARN of a resource that can be tagged.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>        """
        pass

    def get_usage(self, endDate: str, startDate: str, usagePlanId: str, keyId: str=None, position: str=None, limit: int=None) -> Usage:
        r"""Gets the usage data of a usage plan in a specified time interval.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>endDate:  [Required] The ending date (e.g., 2016-12-31) of the usage data.<br/>startDate:  [Required] The starting date (e.g., 2016-01-01) of the usage data.<br/>keyId:  The Id of the API key associated with the resultant usage data.<br/>usagePlanId:  [Required] The Id of the usage plan associated with the usage data.<br/>
        :return: items:  The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.<br/>position:  <br/>endDate:  The ending date of the usage data.<br/>startDate:  The starting date of the usage data.<br/>usagePlanId:  The plan Id associated with this usage data.<br/>        """
        pass

    def get_usage_plan(self, usagePlanId: str) -> UsagePlan:
        r"""Gets a usage plan of a given plan identifier.

        :param self:
        :param usagePlanId:  [Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>productCode:  The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.<br/>quota:  The maximum number of permitted requests per a given unit time interval.:<br/>throttle:  The request throttle limits of a usage plan.:<br/>apiStages:  The associated API stages of a usage plan.<br/>description:  The description of a usage plan.<br/>name:  The name of a usage plan.<br/>id:  The identifier of a <a>UsagePlan</a> resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>rateLimit</i> The API request steady-state rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>burstLimit</i> The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>period</i> The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>offset</i> The number of requests subtracted from the given limit in the initial time period.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>limit</i> The maximum number of requests that can be made in a given time period.<br/>        """
        pass

    def get_usage_plan_key(self, keyId: str, usagePlanId: str) -> UsagePlanKey:
        r"""Gets a usage plan key of a given key identifier.

        :param self:
        :param keyId:  [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.<br/>usagePlanId:  [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.<br/>
        :return: name:  The name of a usage plan key.<br/>value:  The value of a usage plan key.<br/>type:  The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.<br/>id:  The Id of a usage plan key.<br/>        """
        pass

    def get_usage_plan_keys(self, usagePlanId: str, position: str=None, limit: int=None, nameQuery: str=None) -> UsagePlanKeys:
        r"""Gets all the usage plan keys representing the API keys added to a specified usage plan.

        :param self:
        :param nameQuery:  A query parameter specifying the name of the to-be-returned usage plan keys.<br/>limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>usagePlanId:  [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_usage_plans(self, position: str=None, keyId: str=None, limit: int=None) -> UsagePlans:
        r"""Gets all the usage plans of the caller's account.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>keyId:  The identifier of the API key associated with the usage plans.<br/>position:  The current pagination position in the paged result set.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def get_vpc_link(self, vpcLinkId: str) -> VpcLink:
        r"""Gets a specified VPC link under the caller's account in a region.

        :param self:
        :param vpcLinkId:  [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>statusMessage:  A description about the VPC link status.<br/>status:  The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>. <br/>targetArns:  The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.<br/>description:  The description of the VPC link.<br/>name:  The name used to label and identify the VPC link.<br/>id:  The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.<br/>        """
        pass

    def get_vpc_links(self, position: str=None, limit: int=None) -> VpcLinks:
        r"""Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.

        :param self:
        :param limit:  The maximum number of returned results per page. The default value is 25 and the maximum value is 500.<br/>position:  The current pagination position in the paged result set.<br/>
        :return: items:  The current page of elements from this collection.<br/>position:  <br/>        """
        pass

    def import_api_keys(self, format: str, body: Blob, failOnWarnings: Boolean=None) -> ApiKeyIds:
        r"""Import API keys from an external source, such as a CSV-formatted file.

        :param self:
        :param failOnWarnings:  A query parameter to indicate whether to rollback <a>ApiKey</a> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.<br/>format:  A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.<br/>body:  The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.<br/>
        :return: warnings:  A list of warning messages.<br/>ids:  A list of all the <a>ApiKey</a> identifiers.<br/>        """
        pass

    def import_documentation_parts(self, body: Blob, restApiId: str, mode: str=None, failOnWarnings: Boolean=None) -> DocumentationPartIds:
        r"""

        :param self:
        :param body:  [Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.<br/>failOnWarnings:  A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.<br/>mode:  A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: warnings:  A list of warning messages reported during import of documentation parts.<br/>ids:  A list of the returned documentation part identifiers.<br/>        """
        pass

    def import_rest_api(self, body: Blob, failOnWarnings: Boolean=None, parameters: MapOfStringToString=None) -> RestApi:
        r"""A feature of the API Gateway control service for creating a new API from an external API definition file.

        :param self:
        :param body:  [Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 2MB.<br/>parameters:  A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.  To exclude <a>DocumentationParts</a> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.  To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.  To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>. For example, the AWS CLI command to exclude documentation from the imported API is: <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code></pre> The AWS CLI command to set the regional endpoint on the imported API is: <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code></pre><br/>failOnWarnings:  A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>policy:  A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.<br/>endpointConfiguration:  The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API. :<br/>apiKeySource:  The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul> <br/>minimumCompressionSize:  A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.<br/>binaryMediaTypes:  The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.<br/>warnings:  The warning messages reported when <code>failonwarnings</code> is turned on during API import.<br/>version:  A version identifier for the API.<br/>createdDate:  The timestamp when the API was created.<br/>description:  The API's description.<br/>name:  The API's name.<br/>id:  The API's identifier. This identifier is unique across all of your APIs in API Gateway.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>        """
        pass

    def put_gateway_response(self, responseType: str, restApiId: str, statusCode: str=None, responseParameters: MapOfStringToString=None, responseTemplates: MapOfStringToString=None) -> GatewayResponse:
        r"""Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given <a>RestApi</a>.

        :param self:
        :param responseTemplates:  Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.<br/>responseParameters:  Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.<br/>statusCode:  The HTTP status code of the <a>GatewayResponse</a>.<br/>responseType:  [Required] The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> <br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: defaultResponse:  A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. <br/>responseTemplates:  Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.<br/>responseParameters:  Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.<br/>statusCode:  The HTTP status code for this <a>GatewayResponse</a>.<br/>responseType:  The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> <br/>        """
        pass

    def put_integration(self, type: str, httpMethod: str, resourceId: str, restApiId: str, integrationHttpMethod: str=None, uri: str=None, connectionType: str=None, connectionId: str=None, credentials: str=None, requestParameters: MapOfStringToString=None, requestTemplates: MapOfStringToString=None, passthroughBehavior: str=None, cacheNamespace: str=None, cacheKeyParameters: List[String]=None, contentHandling: str=None, timeoutInMillis: int=None) -> Integration:
        r"""Sets up a method's integration.

        :param self:
        :param timeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.<br/>contentHandling:  Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.<br/>cacheKeyParameters:  An API-specific tag group of related cached parameters.<br/>cacheNamespace:  A list of request parameters whose values are to be cached.<br/>passthroughBehavior:  Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values: <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>.  <ul> <li><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</li> <li><code>NEVER</code> rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.</li> <li><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</li> </ul><br/>requestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.<br/>requestParameters:  A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.<br/>credentials:  Specifies whether credentials are required for a put integration.<br/>connectionId:  The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.<br/>connectionType:  The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.<br/>uri:  Specifies Uniform Resource Identifier (URI) of the integration endpoint. <ul> <li> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing.  </li> <li> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code> </li></ul><br/>integrationHttpMethod:  Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.<br/>type:  [Required] Specifies a put integration input's type.<br/>httpMethod:  [Required] Specifies a put integration request's HTTP method.<br/>resourceId:  [Required] Specifies a put integration request's resource ID.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: integrationResponses:  Specifies the integration's responses. <div class="remarks"> <p/> <h4>Example: Get integration responses of a method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre> <h5>Response</h5> The successful response returns <code>200 OK</code> status and a payload as follows: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div><br/>cacheKeyParameters:  A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>cacheNamespace:  An API-specific tag group of related cached parameters. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>timeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.<br/>contentHandling:  Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.<br/>passthroughBehavior:  <div>  Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following:  <ul> <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li> <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li> <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li> </ul> </div><br/>requestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.<br/>requestParameters:  A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.<br/>credentials:  Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.<br/>connectionId:  The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.<br/>connectionType:  The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.<br/>uri:  Specifies Uniform Resource Identifier (URI) of the integration endpoint. <ul> <li> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing.  </li> <li> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code> </li></ul><br/>httpMethod:  Specifies the integration's HTTP method type.<br/>type:  Specifies an API method integration type. The valid value is one of the following: <ul> <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li> <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li> <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li> <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li> <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li> </ul> For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.<br/>        """
        pass

    def put_integration_response(self, statusCode: str, httpMethod: str, resourceId: str, restApiId: str, selectionPattern: str=None, responseParameters: MapOfStringToString=None, responseTemplates: MapOfStringToString=None, contentHandling: str=None) -> IntegrationResponse:
        r"""Represents a put integration.

        :param self:
        :param contentHandling:  Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.<br/>responseTemplates:  Specifies a put integration response's templates.<br/>responseParameters:  A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.<br/>selectionPattern:  Specifies the selection pattern of a put integration response.<br/>statusCode:  [Required] Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.<br/>httpMethod:  [Required] Specifies a put integration response request's HTTP method.<br/>resourceId:  [Required] Specifies a put integration response request's resource identifier.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: contentHandling:  Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.<br/>responseTemplates:  Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.<br/>responseParameters:  A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.<br/>selectionPattern:  Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.<br/>statusCode:  Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.<br/>        """
        pass

    def put_method(self, authorizationType: str, httpMethod: str, resourceId: str, restApiId: str, authorizerId: str=None, apiKeyRequired: Boolean=None, operationName: str=None, requestParameters: MapOfStringToBoolean=None, requestModels: MapOfStringToString=None, requestValidatorId: str=None, authorizationScopes: List[String]=None) -> Method:
        r"""Add a method to an existing <a>Resource</a> resource.

        :param self:
        :param authorizationScopes:  A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.<br/>requestValidatorId:  The identifier of a <a>RequestValidator</a> for validating the method request.<br/>requestModels:  Specifies the <a>Model</a> resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.<br/>requestParameters:  A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or body-mapping templates.<br/>operationName:  A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.<br/>apiKeyRequired:  Specifies whether the method required a valid <a>ApiKey</a>.<br/>authorizerId:  Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.<br/>authorizationType:  [Required] The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.<br/>httpMethod:  [Required] Specifies the method request's HTTP method type.<br/>resourceId:  [Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: authorizationScopes:  A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.<br/>methodIntegration:  Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end. <div class="remarks"> <p/> <h4>Example: </h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> The successful response returns a <code>200 OK</code> status code and a payload similar to the following: <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true } ], "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:responses": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "0cjtch", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestTemplates": { "application/json": "{\n \"a\": \"$input.params('operand1')\",\n \"b\": \"$input.params('operand2')\", \n \"op\": \"$input.params('operator')\" \n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.operator": "integration.response.body.op", "method.response.header.operand_2": "integration.response.body.b", "method.response.header.operand_1": "integration.response.body.a" }, "responseTemplates": { "application/json": "#set($res = $input.path('$'))\n{\n \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n \"a\" : \"$res.a\",\n \"b\" : \"$res.b\",\n \"op\" : \"$res.op\",\n \"c\" : \"$res.c\"\n}" }, "selectionPattern": "", "statusCode": "200" } } }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a> </div>:<br/>methodResponses:  Gets a method response associated with a given HTTP status code.  <div class="remarks"> The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response. <h4>Example: Get a 200 OK response of a GET method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> The successful response returns a <code>200 OK</code> status code and a payload similar to the following: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.operator": false, "method.response.header.operand_2": false, "method.response.header.operand_1": false }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a> </div><br/>requestModels:  A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).<br/>requestParameters:  A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.<br/>operationName:  A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.<br/>requestValidatorId:  The identifier of a <a>RequestValidator</a> for request validation.<br/>apiKeyRequired:  A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.<br/>authorizerId:  The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.<br/>authorizationType:  The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.<br/>httpMethod:  The method's HTTP verb.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>integrationResponses</i> Specifies the integration's responses. <div class="remarks"> <p/> <h4>Example: Get integration responses of a method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre> <h5>Response</h5> The successful response returns <code>200 OK</code> status and a payload as follows: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>cacheKeyParameters</i> A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>cacheNamespace</i> An API-specific tag group of related cached parameters. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>timeoutInMillis</i> Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>contentHandling</i> Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>passthroughBehavior</i> <div>  Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following:  <ul> <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li> <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li> <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li> </ul> </div><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>requestTemplates</i> Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>requestParameters</i> A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>credentials</i> Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>connectionId</i> The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>connectionType</i> The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>uri</i> Specifies Uniform Resource Identifier (URI) of the integration endpoint. <ul> <li> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing.  </li> <li> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code> </li></ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>httpMethod</i> Specifies the integration's HTTP method type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> Specifies an API method integration type. The valid value is one of the following: <ul> <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li> <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li> <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li> <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li> <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li> </ul> For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.<br/>        """
        pass

    def put_method_response(self, statusCode: str, httpMethod: str, resourceId: str, restApiId: str, responseParameters: MapOfStringToBoolean=None, responseModels: MapOfStringToString=None) -> MethodResponse:
        r"""Adds a <a>MethodResponse</a> to an existing <a>Method</a> resource.

        :param self:
        :param responseModels:  Specifies the <a>Model</a> resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.<br/>responseParameters:  A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)<br/>statusCode:  [Required] The method response's status code.<br/>httpMethod:  [Required] The HTTP verb of the <a>Method</a> resource.<br/>resourceId:  [Required] The <a>Resource</a> identifier for the <a>Method</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: responseModels:  Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.<br/>responseParameters:  A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)<br/>statusCode:  The method response's status code.<br/>        """
        pass

    def put_rest_api(self, body: Blob, restApiId: str, mode: str=None, failOnWarnings: Boolean=None, parameters: MapOfStringToString=None) -> RestApi:
        r"""A feature of the API Gateway control service for updating an existing API with an input of external API definitions. The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.

        :param self:
        :param body:  [Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 2MB.<br/>parameters:  Custom header parameters as part of the request. For example, to exclude <a>DocumentationParts</a> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>.<br/>failOnWarnings:  A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.<br/>mode:  The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge".<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>policy:  A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.<br/>endpointConfiguration:  The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API. :<br/>apiKeySource:  The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul> <br/>minimumCompressionSize:  A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.<br/>binaryMediaTypes:  The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.<br/>warnings:  The warning messages reported when <code>failonwarnings</code> is turned on during API import.<br/>version:  A version identifier for the API.<br/>createdDate:  The timestamp when the API was created.<br/>description:  The API's description.<br/>name:  The API's name.<br/>id:  The API's identifier. This identifier is unique across all of your APIs in API Gateway.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>        """
        pass

    def tag_resource(self, tags: MapOfStringToString, resourceArn: str):
        r"""Adds or updates a tag on a given resource.

        :param self:
        :param tags:  [Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>resourceArn:  [Required] The ARN of a resource that can be tagged.<br/>
        :return:         """
        pass

    def test_invoke_authorizer(self, authorizerId: str, restApiId: str, headers: MapOfStringToString=None, multiValueHeaders: MapOfStringToList=None, pathWithQueryString: str=None, body: str=None, stageVariables: MapOfStringToString=None, additionalContext: MapOfStringToString=None) -> TestInvokeAuthorizerResponse:
        r"""Simulate the execution of an <a>Authorizer</a> in your <a>RestApi</a> with headers, parameters, and an incoming request body. <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer</a> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer</a> </div>

        :param self:
        :param additionalContext:  [Optional] A key-value map of additional context variables.<br/>stageVariables:  A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.<br/>body:  [Optional] The simulated request body of an incoming invocation request.<br/>pathWithQueryString:  [Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.<br/>multiValueHeaders:  [Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.<br/>headers:  [Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.<br/>authorizerId:  [Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: claims:  The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.<br/>authorization:  <br/>policy:  The JSON policy document returned by the <a>Authorizer</a><br/>principalId:  The principal identity returned by the <a>Authorizer</a><br/>latency:  The execution latency of the test authorizer request.<br/>log:  The API Gateway execution log for the test authorizer request.<br/>clientStatus:  The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.<br/>        """
        pass

    def test_invoke_method(self, httpMethod: str, resourceId: str, restApiId: str, pathWithQueryString: str=None, body: str=None, headers: MapOfStringToString=None, multiValueHeaders: MapOfStringToList=None, clientCertificateId: str=None, stageVariables: MapOfStringToString=None) -> TestInvokeMethodResponse:
        r"""Simulate the execution of a <a>Method</a> in your <a>RestApi</a> with headers, parameters, and an incoming request body.

        :param self:
        :param stageVariables:  A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.<br/>clientCertificateId:  A <a>ClientCertificate</a> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.<br/>multiValueHeaders:  The headers as a map from string to list of values to simulate an incoming invocation request.<br/>headers:  A key-value map of headers to simulate an incoming invocation request.<br/>body:  The simulated request body of an incoming invocation request.<br/>pathWithQueryString:  The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.<br/>httpMethod:  [Required] Specifies a test invoke method request's HTTP method.<br/>resourceId:  [Required] Specifies a test invoke method request's resource ID.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: latency:  The execution latency of the test invoke request.<br/>log:  The API Gateway execution log for the test invoke request.<br/>multiValueHeaders:  The headers of the HTTP response as a map from string to list of values.<br/>headers:  The headers of the HTTP response.<br/>body:  The body of the HTTP response.<br/>status:  The HTTP status code.<br/>        """
        pass

    def untag_resource(self, tagKeys: List[String], resourceArn: str):
        r"""Removes a tag from a given resource.

        :param self:
        :param tagKeys:  [Required] The Tag keys to delete.<br/>resourceArn:  [Required] The ARN of a resource that can be tagged.<br/>
        :return:         """
        pass

    def update_account(self, patchOperations: List[PatchOperation]=None) -> Account:
        r"""Changes information about the current <a>Account</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>
        :return: apiKeyVersion:  The version of the API keys used for the account.<br/>features:  A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.<br/>throttleSettings:  Specifies the API request limits configured for the current <a>Account</a>.:<br/>cloudwatchRoleArn:  The ARN of an Amazon CloudWatch role for the current <a>Account</a>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>rateLimit</i> The API request steady-state rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>burstLimit</i> The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.<br/>        """
        pass

    def update_api_key(self, apiKey: str, patchOperations: List[PatchOperation]=None) -> ApiKey:
        r"""Changes information about an <a>ApiKey</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>apiKey:  [Required] The identifier of the <a>ApiKey</a> resource to be updated.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>stageKeys:  A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.<br/>lastUpdatedDate:  The timestamp when the API Key was last updated.<br/>createdDate:  The timestamp when the API Key was created.<br/>enabled:  Specifies whether the API Key can be used by callers.<br/>description:  The description of the API Key.<br/>customerId:  An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.<br/>name:  The name of the API Key.<br/>value:  The value of the API Key.<br/>id:  The identifier of the API Key.<br/>        """
        pass

    def update_authorizer(self, authorizerId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> Authorizer:
        r"""Updates an existing <a>Authorizer</a> resource. <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a></div>

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>authorizerId:  [Required] The identifier of the <a>Authorizer</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: authorizerResultTtlInSeconds:  The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.<br/>identityValidationExpression:  A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.<br/>identitySource:  The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul><br/>authorizerCredentials:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.<br/>authorizerUri:  Specifies the authorizer's Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.<br/>authType:  Optional customer-defined field, used in OpenAPI imports and exports without functional impact.<br/>providerARNs:  A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined. <br/>type:  The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.<br/>name:  [Required] The name of the authorizer.<br/>id:  The identifier for the authorizer resource.<br/>        """
        pass

    def update_base_path_mapping(self, basePath: str, domainName: str, patchOperations: List[PatchOperation]=None) -> BasePathMapping:
        r"""Changes information about the <a>BasePathMapping</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>basePath:  [Required] The base path of the <a>BasePathMapping</a> resource to change. To specify an empty base path, set this parameter to <code>'(none)'</code>.<br/>domainName:  [Required] The domain name of the <a>BasePathMapping</a> resource to change.<br/>
        :return: stage:  The name of the associated stage.<br/>restApiId:  The string identifier of the associated <a>RestApi</a>.<br/>basePath:  The base path name that callers of the API must provide as part of the URL after the domain name.<br/>        """
        pass

    def update_client_certificate(self, clientCertificateId: str, patchOperations: List[PatchOperation]=None) -> ClientCertificate:
        r"""Changes information about an <a>ClientCertificate</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>clientCertificateId:  [Required] The identifier of the <a>ClientCertificate</a> resource to be updated.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>expirationDate:  The timestamp when the client certificate will expire.<br/>createdDate:  The timestamp when the client certificate was created.<br/>pemEncodedCertificate:  The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .<br/>description:  The description of the client certificate.<br/>clientCertificateId:  The identifier of the client certificate.<br/>        """
        pass

    def update_deployment(self, deploymentId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> Deployment:
        r"""Changes information about a <a>Deployment</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>deploymentId:  The replacement identifier for the <a>Deployment</a> resource to change information about.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: apiSummary:  A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.<br/>createdDate:  The date and time that the deployment resource was created.<br/>description:  The description for the deployment resource.<br/>id:  The identifier for the deployment resource.<br/>        """
        pass

    def update_documentation_part(self, documentationPartId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> DocumentationPart:
        r"""

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>documentationPartId:  [Required] The identifier of the to-be-updated documentation part.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: properties:  A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.<br/>location:  The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.:<br/>id:  The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>name</i> The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>statusCode</i> The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity exactly.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>method</i> The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>method</code> attribute must match that of the parent entity exactly.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>path</i> The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> [Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.<br/>        """
        pass

    def update_documentation_version(self, documentationVersion: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> DocumentationVersion:
        r"""

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>documentationVersion:  [Required] The version identifier of the to-be-updated documentation version.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>..<br/>
        :return: description:  The description of the API documentation snapshot.<br/>createdDate:  The date when the API documentation snapshot is created.<br/>version:  The version identifier of the API documentation snapshot.<br/>        """
        pass

    def update_domain_name(self, domainName: str, patchOperations: List[PatchOperation]=None) -> DomainName:
        r"""Changes information about the <a>DomainName</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>domainName:  [Required] The name of the <a>DomainName</a> resource to be changed.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>securityPolicy:  The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.<br/>domainNameStatusMessage:  An optional text message containing detailed information about status of the <a>DomainName</a> migration.<br/>domainNameStatus:  The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code> and <code>UPDATING</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.<br/>endpointConfiguration:  The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name. :<br/>distributionHostedZoneId:  The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>. <br/>distributionDomainName:  The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a href="https://aws.amazon.com/documentation/cloudfront/" target="_blank">Amazon CloudFront documentation</a>.<br/>regionalCertificateArn:  The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.<br/>regionalCertificateName:  The name of the certificate that will be used for validating the regional domain name.<br/>regionalHostedZoneId:  The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>. <br/>regionalDomainName:  The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.<br/>certificateUploadDate:  The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.<br/>certificateArn:  The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.<br/>certificateName:  The name of the certificate that will be used by edge-optimized endpoint for this domain name.<br/>domainName:  The custom domain name as an API host name, for example, <code>my-api.example.com</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>        """
        pass

    def update_gateway_response(self, responseType: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> GatewayResponse:
        r"""Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>responseType:  [Required] The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> <br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: defaultResponse:  A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. <br/>responseTemplates:  Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.<br/>responseParameters:  Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.<br/>statusCode:  The HTTP status code for this <a>GatewayResponse</a>.<br/>responseType:  The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> <br/>        """
        pass

    def update_integration(self, httpMethod: str, resourceId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> Integration:
        r"""Represents an update integration.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>httpMethod:  [Required] Represents an update integration request's HTTP method.<br/>resourceId:  [Required] Represents an update integration request's resource identifier.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: integrationResponses:  Specifies the integration's responses. <div class="remarks"> <p/> <h4>Example: Get integration responses of a method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre> <h5>Response</h5> The successful response returns <code>200 OK</code> status and a payload as follows: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div><br/>cacheKeyParameters:  A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>cacheNamespace:  An API-specific tag group of related cached parameters. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>timeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.<br/>contentHandling:  Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.<br/>passthroughBehavior:  <div>  Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following:  <ul> <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li> <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li> <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li> </ul> </div><br/>requestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.<br/>requestParameters:  A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.<br/>credentials:  Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.<br/>connectionId:  The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.<br/>connectionType:  The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.<br/>uri:  Specifies Uniform Resource Identifier (URI) of the integration endpoint. <ul> <li> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing.  </li> <li> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code> </li></ul><br/>httpMethod:  Specifies the integration's HTTP method type.<br/>type:  Specifies an API method integration type. The valid value is one of the following: <ul> <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li> <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li> <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li> <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li> <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li> </ul> For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.<br/>        """
        pass

    def update_integration_response(self, statusCode: str, httpMethod: str, resourceId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> IntegrationResponse:
        r"""Represents an update integration response.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>statusCode:  [Required] Specifies an update integration response request's status code.<br/>httpMethod:  [Required] Specifies an update integration response request's HTTP method.<br/>resourceId:  [Required] Specifies an update integration response request's resource identifier.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: contentHandling:  Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.<br/>responseTemplates:  Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.<br/>responseParameters:  A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.<br/>selectionPattern:  Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.<br/>statusCode:  Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.<br/>        """
        pass

    def update_method(self, httpMethod: str, resourceId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> Method:
        r"""Updates an existing <a>Method</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>httpMethod:  [Required] The HTTP verb of the <a>Method</a> resource.<br/>resourceId:  [Required] The <a>Resource</a> identifier for the <a>Method</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: authorizationScopes:  A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.<br/>methodIntegration:  Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end. <div class="remarks"> <p/> <h4>Example: </h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> The successful response returns a <code>200 OK</code> status code and a payload similar to the following: <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true } ], "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:responses": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "0cjtch", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestTemplates": { "application/json": "{\n \"a\": \"$input.params('operand1')\",\n \"b\": \"$input.params('operand2')\", \n \"op\": \"$input.params('operator')\" \n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.operator": "integration.response.body.op", "method.response.header.operand_2": "integration.response.body.b", "method.response.header.operand_1": "integration.response.body.a" }, "responseTemplates": { "application/json": "#set($res = $input.path('$'))\n{\n \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n \"a\" : \"$res.a\",\n \"b\" : \"$res.b\",\n \"op\" : \"$res.op\",\n \"c\" : \"$res.c\"\n}" }, "selectionPattern": "", "statusCode": "200" } } }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a> </div>:<br/>methodResponses:  Gets a method response associated with a given HTTP status code.  <div class="remarks"> The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response. <h4>Example: Get a 200 OK response of a GET method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> The successful response returns a <code>200 OK</code> status code and a payload similar to the following: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.operator": false, "method.response.header.operand_2": false, "method.response.header.operand_1": false }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a> </div><br/>requestModels:  A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).<br/>requestParameters:  A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.<br/>operationName:  A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.<br/>requestValidatorId:  The identifier of a <a>RequestValidator</a> for request validation.<br/>apiKeyRequired:  A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.<br/>authorizerId:  The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.<br/>authorizationType:  The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.<br/>httpMethod:  The method's HTTP verb.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>integrationResponses</i> Specifies the integration's responses. <div class="remarks"> <p/> <h4>Example: Get integration responses of a method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre> <h5>Response</h5> The successful response returns <code>200 OK</code> status and a payload as follows: <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>cacheKeyParameters</i> A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>cacheNamespace</i> An API-specific tag group of related cached parameters. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>timeoutInMillis</i> Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>contentHandling</i> Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors: <ul> <li><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</li> <li><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</li> </ul> If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>passthroughBehavior</i> <div>  Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following:  <ul> <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li> <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li> <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li> </ul> </div><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>requestTemplates</i> Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>requestParameters</i> A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>credentials</i> Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::\*:user/\*</code>. To use resource-based permissions on supported AWS services, specify null.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>connectionId</i> The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>connectionType</i> The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>uri</i> Specifies Uniform Resource Identifier (URI) of the integration endpoint. <ul> <li> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing.  </li> <li> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code> </li></ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>httpMethod</i> Specifies the integration's HTTP method type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> Specifies an API method integration type. The valid value is one of the following: <ul> <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li> <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li> <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li> <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li> <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li> </ul> For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.<br/>        """
        pass

    def update_method_response(self, statusCode: str, httpMethod: str, resourceId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> MethodResponse:
        r"""Updates an existing <a>MethodResponse</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>statusCode:  [Required] The status code for the <a>MethodResponse</a> resource.<br/>httpMethod:  [Required] The HTTP verb of the <a>Method</a> resource.<br/>resourceId:  [Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: responseModels:  Specifies the <a>Model</a> resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.<br/>responseParameters:  A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)<br/>statusCode:  The method response's status code.<br/>        """
        pass

    def update_model(self, modelName: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> Model:
        r"""Changes information about a model.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>modelName:  [Required] The name of the model to update.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: contentType:  The content-type for the model.<br/>schema:  The schema for the model. For <code>application/json</code> models, this should be <a href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a> model. Do not include "\*/" characters in the description of any properties because such "\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.<br/>description:  The description of the model.<br/>name:  The name of the model. Must be an alphanumeric string.<br/>id:  The identifier for the model resource.<br/>        """
        pass

    def update_request_validator(self, requestValidatorId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> RequestValidator:
        r"""Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>requestValidatorId:  [Required] The identifier of <a>RequestValidator</a> to be updated.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: validateRequestParameters:  A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).<br/>validateRequestBody:  A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.<br/>name:  The name of this <a>RequestValidator</a><br/>id:  The identifier of this <a>RequestValidator</a>.<br/>        """
        pass

    def update_resource(self, resourceId: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> Resource:
        r"""Changes information about a <a>Resource</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>resourceId:  [Required] The identifier of the <a>Resource</a> resource.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: resourceMethods:  Gets an API resource's method of a given HTTP verb. <div class="remarks"> The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request. <h4>Example: Get the GET method of an API resource</h4> <h5>Request</h5> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html", "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET", "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}", "templated": true } }, "apiKeyRequired": false, "authorizationType": "NONE", "httpMethod": "GET", "_embedded": { "method:integration": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type": "'application/x-amz-json-1.1'" }, "requestTemplates": { "application/json": "{\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'" }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n" }, "statusCode": "200" } } }, "method:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.Content-Type": false }, "statusCode": "200" } } }</code></pre> If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>. </div> <div class="seeAlso"> </div><br/>path:  The full path for this resource.<br/>pathPart:  The last path segment for this resource.<br/>parentId:  The parent resource's identifier.<br/>id:  The resource's identifier.<br/>        """
        pass

    def update_rest_api(self, restApiId: str, patchOperations: List[PatchOperation]=None) -> RestApi:
        r"""Changes information about the specified API.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>policy:  A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.<br/>endpointConfiguration:  The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API. :<br/>apiKeySource:  The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul> <br/>minimumCompressionSize:  A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.<br/>binaryMediaTypes:  The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.<br/>warnings:  The warning messages reported when <code>failonwarnings</code> is turned on during API import.<br/>version:  A version identifier for the API.<br/>createdDate:  The timestamp when the API was created.<br/>description:  The API's description.<br/>name:  The API's name.<br/>id:  The API's identifier. This identifier is unique across all of your APIs in API Gateway.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>vpcEndpointIds</i> A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>types</i> A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.<br/>        """
        pass

    def update_stage(self, stageName: str, restApiId: str, patchOperations: List[PatchOperation]=None) -> Stage:
        r"""Changes information about a <a>Stage</a> resource.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>stageName:  [Required] The name of the <a>Stage</a> resource to change information about.<br/>restApiId:  [Required] The string identifier of the associated <a>RestApi</a>.<br/>
        :return: lastUpdatedDate:  The timestamp when the stage last updated.<br/>createdDate:  The timestamp when the stage was created.<br/>tags:  The collection of tags. Each tag element is associated with a given resource.<br/>webAclArn:  The ARN of the WebAcl associated with the <a>Stage</a>.<br/>tracingEnabled:  Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.<br/>canarySettings:  Settings for the canary deployment in this stage.:<br/>accessLogSettings:  Settings for logging access in this stage.:<br/>documentationVersion:  The version of the associated API documentation.<br/>variables:  A map that defines the stage variables for a <a>Stage</a> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.<br/>methodSettings:  A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*/\*</code> for overriding all methods in the stage. <br/>cacheClusterStatus:  The status of the cache cluster for the stage, if enabled.<br/>cacheClusterSize:  The size of the cache cluster for the stage, if enabled.<br/>cacheClusterEnabled:  Specifies whether a cache cluster is enabled for the stage.<br/>description:  The stage's description.<br/>stageName:  The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>clientCertificateId:  The identifier of a client certificate for an API stage.<br/>deploymentId:  The identifier of the <a>Deployment</a> that the stage points to.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>destinationArn</i> The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>format</i> A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables</a>. The format must include at least <code>$context.requestId</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>useStageCache</i> A Boolean flag to indicate whether the canary deployment uses the stage cache or not.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>stageVariableOverrides</i> Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>deploymentId</i> The ID of the canary deployment.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>percentTraffic</i> The percent (0-100) of traffic diverted to a canary deployment.<br/>        """
        pass

    def update_usage(self, keyId: str, usagePlanId: str, patchOperations: List[PatchOperation]=None) -> Usage:
        r"""Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>keyId:  [Required] The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.<br/>usagePlanId:  [Required] The Id of the usage plan associated with the usage data.<br/>
        :return: items:  The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.<br/>position:  <br/>endDate:  The ending date of the usage data.<br/>startDate:  The starting date of the usage data.<br/>usagePlanId:  The plan Id associated with this usage data.<br/>        """
        pass

    def update_usage_plan(self, usagePlanId: str, patchOperations: List[PatchOperation]=None) -> UsagePlan:
        r"""Updates a usage plan of a given plan Id.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>usagePlanId:  [Required] The Id of the to-be-updated usage plan.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>productCode:  The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.<br/>quota:  The maximum number of permitted requests per a given unit time interval.:<br/>throttle:  The request throttle limits of a usage plan.:<br/>apiStages:  The associated API stages of a usage plan.<br/>description:  The description of a usage plan.<br/>name:  The name of a usage plan.<br/>id:  The identifier of a <a>UsagePlan</a> resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>rateLimit</i> The API request steady-state rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>burstLimit</i> The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>period</i> The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>offset</i> The number of requests subtracted from the given limit in the initial time period.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>limit</i> The maximum number of requests that can be made in a given time period.<br/>        """
        pass

    def update_vpc_link(self, vpcLinkId: str, patchOperations: List[PatchOperation]=None) -> VpcLink:
        r"""Updates an existing <a>VpcLink</a> of a specified identifier.

        :param self:
        :param patchOperations:  A list of update operations to be applied to the specified resource and in the order specified in this list.<br/>vpcLinkId:  [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.<br/>
        :return: tags:  The collection of tags. Each tag element is associated with a given resource.<br/>statusMessage:  A description about the VPC link status.<br/>status:  The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>. <br/>targetArns:  The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.<br/>description:  The description of the VPC link.<br/>name:  The name used to label and identify the VPC link.<br/>id:  The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.<br/>        """
        pass



class ApiGatewayManagementApi(BaseClient):
    r"""The Amazon API Gateway Management API allows you to directly manage runtime aspects of your deployed APIs. To use it, you must explicitly set the SDK's endpoint to point to the endpoint of your deployed API. The endpoint will be of the form https://{api-id}.execute-api.{region}.amazonaws.com/{stage}, or will be the endpoint corresponding to your API's custom domain and base path, if applicable."""




    class DeleteConnectionRequest(Mapping):
        pass
    
    class GetConnectionRequest(Mapping):
        pass
    
    class GetConnectionResponse(Mapping):
        pass
    
    class PostToConnectionRequest(Mapping):
        pass
    
    class Data(object):
        pass
    
    def delete_connection(self, ConnectionId: str):
        r"""Delete the connection with the provided id.

        :param self:
        :param ConnectionId:  <br/>
        :return:         """
        pass

    def get_connection(self, ConnectionId: str) -> GetConnectionResponse:
        r"""Get information about the connection with the provided id.

        :param self:
        :param ConnectionId:  <br/>
        :return: LastActiveAt:  The time in ISO 8601 format for when the connection was last active.<br/>Identity:  :<br/>ConnectedAt:  The time in ISO 8601 format for when the connection was established.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>UserAgent</i> The User Agent of the API caller.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SourceIp</i> The source IP address of the TCP connection making the request to API Gateway.<br/>        """
        pass

    def post_to_connection(self, ConnectionId: str, Data: Data):
        r"""Sends the provided data to the specified connection.

        :param self:
        :param ConnectionId:  The identifier of the connection that a specific client is using.<br/>Data:  The data to be sent to the client specified by its connection id.<br/>
        :return:         """
        pass



class ApiGatewayV2(BaseClient):
    r"""Amazon API Gateway V2"""


    class GetApisPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_apis` for valid parameters"""
            pass
    class GetAuthorizersPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_authorizers` for valid parameters"""
            pass
    class GetDeploymentsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_deployments` for valid parameters"""
            pass
    class GetDomainNamesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_domain_names` for valid parameters"""
            pass
    class GetIntegrationResponsesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_integration_responses` for valid parameters"""
            pass
    class GetIntegrationsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_integrations` for valid parameters"""
            pass
    class GetModelsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_models` for valid parameters"""
            pass
    class GetRouteResponsesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_route_responses` for valid parameters"""
            pass
    class GetRoutesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_routes` for valid parameters"""
            pass
    class GetStagesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `get_stages` for valid parameters"""
            pass


    class CreateApiRequest(Mapping):
        pass
    
    class CreateApiResponse(Mapping):
        pass
    
    class Cors(Mapping):
        pass
    
    class __boolean(object):
        pass
    
    class Tags(object):
        pass
    
    class CreateApiMappingRequest(Mapping):
        pass
    
    class CreateApiMappingResponse(Mapping):
        pass
    
    class CreateAuthorizerRequest(Mapping):
        pass
    
    class CreateAuthorizerResponse(Mapping):
        pass
    
    class __string(object):
        pass
    
    class JWTConfiguration(Mapping):
        pass
    
    class CreateDeploymentRequest(Mapping):
        pass
    
    class CreateDeploymentResponse(Mapping):
        pass
    
    class CreateDomainNameRequest(Mapping):
        pass
    
    class CreateDomainNameResponse(Mapping):
        pass
    
    class DomainNameConfiguration(Mapping):
        pass
    
    class CreateIntegrationRequest(Mapping):
        pass
    
    class CreateIntegrationResult(Mapping):
        pass
    
    class IntegrationParameters(object):
        pass
    
    class TemplateMap(object):
        pass
    
    class TlsConfigInput(Mapping):
        pass
    
    class CreateIntegrationResponseRequest(Mapping):
        pass
    
    class CreateIntegrationResponseResponse(Mapping):
        pass
    
    class CreateModelRequest(Mapping):
        pass
    
    class CreateModelResponse(Mapping):
        pass
    
    class CreateRouteRequest(Mapping):
        pass
    
    class CreateRouteResult(Mapping):
        pass
    
    class StringWithLengthBetween1And64(object):
        pass
    
    class RouteModels(object):
        pass
    
    class RouteParameters(object):
        pass
    
    class CreateRouteResponseRequest(Mapping):
        pass
    
    class CreateRouteResponseResponse(Mapping):
        pass
    
    class CreateStageRequest(Mapping):
        pass
    
    class CreateStageResponse(Mapping):
        pass
    
    class AccessLogSettings(Mapping):
        pass
    
    class RouteSettings(Mapping):
        pass
    
    class RouteSettingsMap(object):
        pass
    
    class StageVariablesMap(object):
        pass
    
    class CreateVpcLinkRequest(Mapping):
        pass
    
    class CreateVpcLinkResponse(Mapping):
        pass
    
    class DeleteAccessLogSettingsRequest(Mapping):
        pass
    
    class DeleteApiRequest(Mapping):
        pass
    
    class DeleteApiMappingRequest(Mapping):
        pass
    
    class DeleteAuthorizerRequest(Mapping):
        pass
    
    class DeleteCorsConfigurationRequest(Mapping):
        pass
    
    class DeleteDeploymentRequest(Mapping):
        pass
    
    class DeleteDomainNameRequest(Mapping):
        pass
    
    class DeleteIntegrationRequest(Mapping):
        pass
    
    class DeleteIntegrationResponseRequest(Mapping):
        pass
    
    class DeleteModelRequest(Mapping):
        pass
    
    class DeleteRouteRequest(Mapping):
        pass
    
    class DeleteRouteRequestParameterRequest(Mapping):
        pass
    
    class DeleteRouteResponseRequest(Mapping):
        pass
    
    class DeleteRouteSettingsRequest(Mapping):
        pass
    
    class DeleteStageRequest(Mapping):
        pass
    
    class DeleteVpcLinkRequest(Mapping):
        pass
    
    class DeleteVpcLinkResponse(Mapping):
        pass
    
    class ExportApiRequest(Mapping):
        pass
    
    class ExportApiResponse(Mapping):
        pass
    
    class GetApiRequest(Mapping):
        pass
    
    class GetApiResponse(Mapping):
        pass
    
    class GetApiMappingRequest(Mapping):
        pass
    
    class GetApiMappingResponse(Mapping):
        pass
    
    class GetApiMappingsRequest(Mapping):
        pass
    
    class GetApiMappingsResponse(Mapping):
        pass
    
    class GetApisRequest(Mapping):
        pass
    
    class GetApisResponse(Mapping):
        pass
    
    class GetAuthorizerRequest(Mapping):
        pass
    
    class GetAuthorizerResponse(Mapping):
        pass
    
    class GetAuthorizersRequest(Mapping):
        pass
    
    class GetAuthorizersResponse(Mapping):
        pass
    
    class GetDeploymentRequest(Mapping):
        pass
    
    class GetDeploymentResponse(Mapping):
        pass
    
    class GetDeploymentsRequest(Mapping):
        pass
    
    class GetDeploymentsResponse(Mapping):
        pass
    
    class GetDomainNameRequest(Mapping):
        pass
    
    class GetDomainNameResponse(Mapping):
        pass
    
    class GetDomainNamesRequest(Mapping):
        pass
    
    class GetDomainNamesResponse(Mapping):
        pass
    
    class GetIntegrationRequest(Mapping):
        pass
    
    class GetIntegrationResult(Mapping):
        pass
    
    class GetIntegrationResponseRequest(Mapping):
        pass
    
    class GetIntegrationResponseResponse(Mapping):
        pass
    
    class GetIntegrationResponsesRequest(Mapping):
        pass
    
    class GetIntegrationResponsesResponse(Mapping):
        pass
    
    class GetIntegrationsRequest(Mapping):
        pass
    
    class GetIntegrationsResponse(Mapping):
        pass
    
    class GetModelRequest(Mapping):
        pass
    
    class GetModelResponse(Mapping):
        pass
    
    class GetModelTemplateRequest(Mapping):
        pass
    
    class GetModelTemplateResponse(Mapping):
        pass
    
    class GetModelsRequest(Mapping):
        pass
    
    class GetModelsResponse(Mapping):
        pass
    
    class GetRouteRequest(Mapping):
        pass
    
    class GetRouteResult(Mapping):
        pass
    
    class GetRouteResponseRequest(Mapping):
        pass
    
    class GetRouteResponseResponse(Mapping):
        pass
    
    class GetRouteResponsesRequest(Mapping):
        pass
    
    class GetRouteResponsesResponse(Mapping):
        pass
    
    class GetRoutesRequest(Mapping):
        pass
    
    class GetRoutesResponse(Mapping):
        pass
    
    class GetStageRequest(Mapping):
        pass
    
    class GetStageResponse(Mapping):
        pass
    
    class GetStagesRequest(Mapping):
        pass
    
    class GetStagesResponse(Mapping):
        pass
    
    class GetTagsRequest(Mapping):
        pass
    
    class GetTagsResponse(Mapping):
        pass
    
    class GetVpcLinkRequest(Mapping):
        pass
    
    class GetVpcLinkResponse(Mapping):
        pass
    
    class GetVpcLinksRequest(Mapping):
        pass
    
    class GetVpcLinksResponse(Mapping):
        pass
    
    class ImportApiRequest(Mapping):
        pass
    
    class ImportApiResponse(Mapping):
        pass
    
    class ReimportApiRequest(Mapping):
        pass
    
    class ReimportApiResponse(Mapping):
        pass
    
    class TagResourceRequest(Mapping):
        pass
    
    class TagResourceResponse(Mapping):
        pass
    
    class UntagResourceRequest(Mapping):
        pass
    
    class UpdateApiRequest(Mapping):
        pass
    
    class UpdateApiResponse(Mapping):
        pass
    
    class UpdateApiMappingRequest(Mapping):
        pass
    
    class UpdateApiMappingResponse(Mapping):
        pass
    
    class UpdateAuthorizerRequest(Mapping):
        pass
    
    class UpdateAuthorizerResponse(Mapping):
        pass
    
    class UpdateDeploymentRequest(Mapping):
        pass
    
    class UpdateDeploymentResponse(Mapping):
        pass
    
    class UpdateDomainNameRequest(Mapping):
        pass
    
    class UpdateDomainNameResponse(Mapping):
        pass
    
    class UpdateIntegrationRequest(Mapping):
        pass
    
    class UpdateIntegrationResult(Mapping):
        pass
    
    class UpdateIntegrationResponseRequest(Mapping):
        pass
    
    class UpdateIntegrationResponseResponse(Mapping):
        pass
    
    class UpdateModelRequest(Mapping):
        pass
    
    class UpdateModelResponse(Mapping):
        pass
    
    class UpdateRouteRequest(Mapping):
        pass
    
    class UpdateRouteResult(Mapping):
        pass
    
    class UpdateRouteResponseRequest(Mapping):
        pass
    
    class UpdateRouteResponseResponse(Mapping):
        pass
    
    class UpdateStageRequest(Mapping):
        pass
    
    class UpdateStageResponse(Mapping):
        pass
    
    class UpdateVpcLinkRequest(Mapping):
        pass
    
    class UpdateVpcLinkResponse(Mapping):
        pass
    
    def create_api(self, ProtocolType: str, Name: str, ApiKeySelectionExpression: str=None, CorsConfiguration: Cors=None, CredentialsArn: str=None, Description: str=None, DisableSchemaValidation: __boolean=None, RouteKey: str=None, RouteSelectionExpression: str=None, Tags: Tags=None, Target: str=None, Version: str=None) -> CreateApiResponse:
        r"""Creates an Api resource.

        :param self:
        :param Version:  A version identifier for the API.<br/>Target:  This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.<br/>Tags:  The collection of tags. Each tag element is associated with a given resource.<br/>RouteSelectionExpression:  The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.<br/>RouteKey:  This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.<br/>ProtocolType:  The API protocol.<br/>Name:  The name of the API.<br/>DisableSchemaValidation:  Avoid validating models when creating a deployment. Supported only for WebSocket APIs.<br/>Description:  The description of the API.<br/>CredentialsArn:  This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.<br/>CorsConfiguration:  A CORS configuration. Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.:<br/>ApiKeySelectionExpression:  An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxAge</i> The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ExposeHeaders</i> Represents a collection of exposed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowOrigins</i> Represents a collection of allowed origins. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowMethods</i> Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowHeaders</i> Represents a collection of allowed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowCredentials</i> Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.<br/>
        :return: Warnings:  The warning messages reported when failonwarnings is turned on during API import.<br/>Version:  A version identifier for the API.<br/>Tags:  A collection of tags associated with the API.<br/>RouteSelectionExpression:  The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.<br/>ProtocolType:  The API protocol.<br/>Name:  The name of the API.<br/>ImportInfo:  The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.<br/>DisableSchemaValidation:  Avoid validating models when creating a deployment. Supported only for WebSocket APIs.<br/>Description:  The description of the API.<br/>CreatedDate:  The timestamp when the API was created.<br/>CorsConfiguration:  A CORS configuration. Supported only for HTTP APIs.:<br/>ApiKeySelectionExpression:  An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.<br/>ApiId:  The API ID.<br/>ApiEndpoint:  The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxAge</i> The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ExposeHeaders</i> Represents a collection of exposed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowOrigins</i> Represents a collection of allowed origins. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowMethods</i> Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowHeaders</i> Represents a collection of allowed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowCredentials</i> Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.<br/>        """
        pass

    def create_api_mapping(self, Stage: str, DomainName: str, ApiId: str, ApiMappingKey: str=None) -> CreateApiMappingResponse:
        r"""Creates an API mapping.

        :param self:
        :param Stage:  The API stage.<br/>DomainName:  The domain name.<br/>ApiMappingKey:  The API mapping key.<br/>ApiId:  The API identifier.<br/>
        :return: Stage:  The API stage.<br/>ApiMappingKey:  The API mapping key.<br/>ApiMappingId:  The API mapping identifier.<br/>ApiId:  The API identifier.<br/>        """
        pass

    def create_authorizer(self, Name: str, IdentitySource: List[__string], AuthorizerType: str, ApiId: str, AuthorizerCredentialsArn: str=None, AuthorizerResultTtlInSeconds: int=None, AuthorizerUri: str=None, IdentityValidationExpression: str=None, JwtConfiguration: JWTConfiguration=None) -> CreateAuthorizerResponse:
        r"""Creates an Authorizer for an API.

        :param self:
        :param Name:  The name of the authorizer.<br/>JwtConfiguration:  Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.:<br/>IdentityValidationExpression:  This parameter is not used.<br/>IdentitySource:  The identity source for which authorization is requested. For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. Currently, the identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name. These parameters will be used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For JWT, a single entry that specifies where to extract the JSON Web Token (JWT )from inbound requests. Currently only header-based and query parameter-based selections are supported, for example "$request.header.Authorization".<br/>AuthorizerUri:  The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
               , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.<br/>AuthorizerType:  The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function using incoming request parameters. For HTTP APIs, specify JWT to use JSON Web Tokens.<br/>AuthorizerResultTtlInSeconds:  Authorizer caching is not currently supported. Don't specify this value for authorizers.<br/>AuthorizerCredentialsArn:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null. Supported only for REQUEST authorizers.<br/>ApiId:  The API identifier.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Issuer</i> The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
               . Required for the JWT authorizer type. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Audience</i> A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.<br/>
        :return: Name:  The name of the authorizer.<br/>JwtConfiguration:  Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.:<br/>IdentityValidationExpression:  The validation expression does not apply to the REQUEST authorizer.<br/>IdentitySource:  The identity source for which authorization is requested. For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. Currently, the identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name. These parameters will be used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example "$request.header.Authorization".<br/>AuthorizerUri:  The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
               , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.<br/>AuthorizerType:  The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function using incoming request parameters. For HTTP APIs, specify JWT to use JSON Web Tokens.<br/>AuthorizerResultTtlInSeconds:  Authorizer caching is not currently supported. Don't specify this value for authorizers.<br/>AuthorizerId:  The authorizer identifier.<br/>AuthorizerCredentialsArn:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null. Supported only for REQUEST authorizers.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Issuer</i> The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
               . Required for the JWT authorizer type. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Audience</i> A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.<br/>        """
        pass

    def create_deployment(self, ApiId: str, Description: str=None, StageName: str=None) -> CreateDeploymentResponse:
        r"""Creates a Deployment for an API.

        :param self:
        :param StageName:  The name of the Stage resource for the Deployment resource to create.<br/>Description:  The description for the deployment resource.<br/>ApiId:  The API identifier.<br/>
        :return: Description:  The description for the deployment.<br/>DeploymentStatusMessage:  May contain additional feedback on the status of an API deployment.<br/>DeploymentStatus:  The status of the deployment: PENDING, FAILED, or SUCCEEDED.<br/>DeploymentId:  The identifier for the deployment.<br/>CreatedDate:  The date and time when the Deployment resource was created.<br/>AutoDeployed:  Specifies whether a deployment was automatically released.<br/>        """
        pass

    def create_domain_name(self, DomainName: str, DomainNameConfigurations: List[DomainNameConfiguration]=None, Tags: Tags=None) -> CreateDomainNameResponse:
        r"""Creates a domain name.

        :param self:
        :param Tags:  The collection of tags associated with a domain name.<br/>DomainNameConfigurations:  The domain name configurations.<br/>DomainName:  The domain name.<br/>
        :return: Tags:  The collection of tags associated with a domain name.<br/>DomainNameConfigurations:  The domain name configurations.<br/>DomainName:  The name of the DomainName resource.<br/>ApiMappingSelectionExpression:  The API mapping selection expression.<br/>        """
        pass

    def create_integration(self, IntegrationType: str, ApiId: str, ConnectionId: str=None, ConnectionType: str=None, ContentHandlingStrategy: str=None, CredentialsArn: str=None, Description: str=None, IntegrationMethod: str=None, IntegrationUri: str=None, PassthroughBehavior: str=None, PayloadFormatVersion: str=None, RequestParameters: IntegrationParameters=None, RequestTemplates: TemplateMap=None, TemplateSelectionExpression: str=None, TimeoutInMillis: int=None, TlsConfig: TlsConfigInput=None) -> CreateIntegrationResult:
        r"""Creates an Integration.

        :param self:
        :param TlsConfig:  The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.:<br/>TimeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.<br/>TemplateSelectionExpression:  The template selection expression for the integration.<br/>RequestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.<br/>RequestParameters:  A key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
               , where 
                  <replaceable>{location}</replaceable>
                is querystring, path, or header; and 
                  <replaceable>{name}</replaceable>
                must be a valid and unique method request parameter name. Supported only for WebSocket APIs.<br/>PayloadFormatVersion:  Specifies the format of the payload sent to an integration. Required for HTTP APIs.<br/>PassthroughBehavior:  Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs. WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation. NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response. WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.<br/>IntegrationUri:  For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.<br/>IntegrationType:  The integration type of an integration. One of the following: AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs. AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as Lambda proxy integration. HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs. HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration. MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.<br/>IntegrationMethod:  Specifies the integration's HTTP method type.<br/>Description:  The description of the integration.<br/>CredentialsArn:  Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>ConnectionType:  The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.<br/>ConnectionId:  The ID of the VPC link for a private integration. Supported only for HTTP APIs.<br/>ApiId:  The API identifier.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ServerNameToVerify</i> If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.<br/>
        :return: TlsConfig:  The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.:<br/>TimeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.<br/>TemplateSelectionExpression:  The template selection expression for the integration. Supported only for WebSocket APIs.<br/>RequestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.<br/>RequestParameters:  A key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
               , where 
                  <replaceable>{location}</replaceable>
                is querystring, path, or header; and 
                  <replaceable>{name}</replaceable>
                must be a valid and unique method request parameter name. Supported only for WebSocket APIs.<br/>PayloadFormatVersion:  Specifies the format of the payload sent to an integration. Required for HTTP APIs.<br/>PassthroughBehavior:  Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs. WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation. NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response. WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.<br/>IntegrationUri:  For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.<br/>IntegrationType:  The integration type of an integration. One of the following: AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs. AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as Lambda proxy integration. HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs. HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.<br/>IntegrationResponseSelectionExpression:  The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.<br/>IntegrationMethod:  Specifies the integration's HTTP method type.<br/>IntegrationId:  Represents the identifier of an integration.<br/>Description:  Represents the description of an integration.<br/>CredentialsArn:  Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>ConnectionType:  The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.<br/>ConnectionId:  The ID of the VPC link for a private integration. Supported only for HTTP APIs.<br/>ApiGatewayManaged:  Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ServerNameToVerify</i> If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.<br/>        """
        pass

    def create_integration_response(self, IntegrationResponseKey: str, IntegrationId: str, ApiId: str, ContentHandlingStrategy: str=None, ResponseParameters: IntegrationParameters=None, ResponseTemplates: TemplateMap=None, TemplateSelectionExpression: str=None) -> CreateIntegrationResponseResponse:
        r"""Creates an IntegrationResponses.

        :param self:
        :param TemplateSelectionExpression:  The template selection expression for the integration response. Supported only for WebSocket APIs.<br/>ResponseTemplates:  The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.<br/>ResponseParameters:  A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix.<br/>IntegrationResponseKey:  The integration response key.<br/>IntegrationId:  The integration ID.<br/>ContentHandlingStrategy:  Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>ApiId:  The API identifier.<br/>
        :return: TemplateSelectionExpression:  The template selection expressions for the integration response.<br/>ResponseTemplates:  The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.<br/>ResponseParameters:  A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.<br/>IntegrationResponseKey:  The integration response key.<br/>IntegrationResponseId:  The integration response ID.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>        """
        pass

    def create_model(self, Schema: str, Name: str, ApiId: str, ContentType: str=None, Description: str=None) -> CreateModelResponse:
        r"""Creates a Model for an API.

        :param self:
        :param Schema:  The schema for the model. For application/json models, this should be JSON schema draft 4 model.<br/>Name:  The name of the model. Must be alphanumeric.<br/>Description:  The description of the model.<br/>ContentType:  The content-type for the model, for example, "application/json".<br/>ApiId:  The API identifier.<br/>
        :return: Schema:  The schema for the model. For application/json models, this should be JSON schema draft 4 model.<br/>Name:  The name of the model. Must be alphanumeric.<br/>ModelId:  The model identifier.<br/>Description:  The description of the model.<br/>ContentType:  The content-type for the model, for example, "application/json".<br/>        """
        pass

    def create_route(self, RouteKey: str, ApiId: str, ApiKeyRequired: __boolean=None, AuthorizationScopes: List[StringWithLengthBetween1And64]=None, AuthorizationType: str=None, AuthorizerId: str=None, ModelSelectionExpression: str=None, OperationName: str=None, RequestModels: RouteModels=None, RequestParameters: RouteParameters=None, RouteResponseSelectionExpression: str=None, Target: str=None) -> CreateRouteResult:
        r"""Creates a Route for an API.

        :param self:
        :param Target:  The target for the route.<br/>RouteResponseSelectionExpression:  The route response selection expression for the route. Supported only for WebSocket APIs.<br/>RouteKey:  The route key for the route.<br/>RequestParameters:  The request parameters for the route. Supported only for WebSocket APIs.<br/>RequestModels:  The request models for the route. Supported only for WebSocket APIs.<br/>OperationName:  The operation name for the route.<br/>ModelSelectionExpression:  The model selection expression for the route. Supported only for WebSocket APIs.<br/>AuthorizerId:  The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.<br/>AuthorizationType:  The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, or JWT for using JSON Web Tokens.<br/>AuthorizationScopes:  The authorization scopes supported by this route.<br/>ApiKeyRequired:  Specifies whether an API key is required for the route. Supported only for WebSocket APIs.<br/>ApiId:  The API identifier.<br/>
        :return: Target:  The target for the route.<br/>RouteResponseSelectionExpression:  The route response selection expression for the route. Supported only for WebSocket APIs.<br/>RouteKey:  The route key for the route.<br/>RouteId:  The route ID.<br/>RequestParameters:  The request parameters for the route. Supported only for WebSocket APIs.<br/>RequestModels:  The request models for the route. Supported only for WebSocket APIs.<br/>OperationName:  The operation name for the route.<br/>ModelSelectionExpression:  The model selection expression for the route. Supported only for WebSocket APIs.<br/>AuthorizerId:  The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.<br/>AuthorizationType:  The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, or JWT for using JSON Web Tokens.<br/>AuthorizationScopes:  A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.<br/>ApiKeyRequired:  Specifies whether an API key is required for this route. Supported only for WebSocket APIs.<br/>ApiGatewayManaged:  Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.<br/>        """
        pass

    def create_route_response(self, RouteResponseKey: str, RouteId: str, ApiId: str, ModelSelectionExpression: str=None, ResponseModels: RouteModels=None, ResponseParameters: RouteParameters=None) -> CreateRouteResponseResponse:
        r"""Creates a RouteResponse for a Route.

        :param self:
        :param RouteResponseKey:  The route response key.<br/>RouteId:  The route ID.<br/>ResponseParameters:  The route response parameters.<br/>ResponseModels:  The response models for the route response.<br/>ModelSelectionExpression:  The model selection expression for the route response. Supported only for WebSocket APIs.<br/>ApiId:  The API identifier.<br/>
        :return: RouteResponseKey:  Represents the route response key of a route response.<br/>RouteResponseId:  Represents the identifier of a route response.<br/>ResponseParameters:  Represents the response parameters of a route response.<br/>ResponseModels:  Represents the response models of a route response.<br/>ModelSelectionExpression:  Represents the model selection expression of a route response. Supported only for WebSocket APIs.<br/>        """
        pass

    def create_stage(self, StageName: str, ApiId: str, AccessLogSettings: AccessLogSettings=None, AutoDeploy: __boolean=None, ClientCertificateId: str=None, DefaultRouteSettings: RouteSettings=None, DeploymentId: str=None, Description: str=None, RouteSettings: RouteSettingsMap=None, StageVariables: StageVariablesMap=None, Tags: Tags=None) -> CreateStageResponse:
        r"""Creates a Stage for an API.

        :param self:
        :param Tags:  The collection of tags. Each tag element is associated with a given resource.<br/>StageVariables:  A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.<br/>StageName:  The name of the stage.<br/>RouteSettings:  Route settings for the stage, by routeKey.<br/>Description:  The description for the API stage.<br/>DeploymentId:  The deployment identifier of the API stage.<br/>DefaultRouteSettings:  The default route settings for the stage.:<br/>ClientCertificateId:  The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.<br/>AutoDeploy:  Specifies whether updates to an API automatically trigger a new deployment. The default value is false.<br/>ApiId:  The API identifier.<br/>AccessLogSettings:  Settings for logging access in this stage.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Format</i> A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DestinationArn</i> The ARN of the CloudWatch Logs log group to receive access logs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingRateLimit</i> Specifies the throttling rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingBurstLimit</i> Specifies the throttling burst limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LoggingLevel</i> Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DetailedMetricsEnabled</i> Specifies whether detailed metrics are enabled.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DataTraceEnabled</i> Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>
        :return: Tags:  The collection of tags. Each tag element is associated with a given resource.<br/>StageVariables:  A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.<br/>StageName:  The name of the stage.<br/>RouteSettings:  Route settings for the stage, by routeKey.<br/>LastUpdatedDate:  The timestamp when the stage was last updated.<br/>LastDeploymentStatusMessage:  Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.<br/>Description:  The description of the stage.<br/>DeploymentId:  The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.<br/>DefaultRouteSettings:  Default route settings for the stage.:<br/>CreatedDate:  The timestamp when the stage was created.<br/>ClientCertificateId:  The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.<br/>AutoDeploy:  Specifies whether updates to an API automatically trigger a new deployment. The default value is false.<br/>ApiGatewayManaged:  Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.<br/>AccessLogSettings:  Settings for logging access in this stage.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Format</i> A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DestinationArn</i> The ARN of the CloudWatch Logs log group to receive access logs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingRateLimit</i> Specifies the throttling rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingBurstLimit</i> Specifies the throttling burst limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LoggingLevel</i> Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DetailedMetricsEnabled</i> Specifies whether detailed metrics are enabled.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DataTraceEnabled</i> Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>        """
        pass

    def create_vpc_link(self, SubnetIds: List[__string], Name: str, SecurityGroupIds: List[__string]=None, Tags: Tags=None) -> CreateVpcLinkResponse:
        r"""Creates a VPC link.

        :param self:
        :param Tags:  A list of tags.<br/>SubnetIds:  A list of subnet IDs to include in the VPC link.<br/>SecurityGroupIds:  A list of security group IDs for the VPC link.<br/>Name:  The name of the VPC link.<br/>
        :return: VpcLinkVersion:  The version of the VPC link.<br/>VpcLinkStatusMessage:  A message summarizing the cause of the status of the VPC link.<br/>VpcLinkStatus:  The status of the VPC link.<br/>VpcLinkId:  The ID of the VPC link.<br/>Tags:  Tags for the VPC link.<br/>SubnetIds:  A list of subnet IDs to include in the VPC link.<br/>SecurityGroupIds:  A list of security group IDs for the VPC link.<br/>Name:  The name of the VPC link.<br/>CreatedDate:  The timestamp when the VPC link was created.<br/>        """
        pass

    def delete_access_log_settings(self, StageName: str, ApiId: str):
        r"""Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.

        :param self:
        :param StageName:  The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_api(self, ApiId: str):
        r"""Deletes an Api resource.

        :param self:
        :param ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_api_mapping(self, DomainName: str, ApiMappingId: str):
        r"""Deletes an API mapping.

        :param self:
        :param DomainName:  The domain name.<br/>ApiMappingId:  The API mapping identifier.<br/>
        :return:         """
        pass

    def delete_authorizer(self, AuthorizerId: str, ApiId: str):
        r"""Deletes an Authorizer.

        :param self:
        :param AuthorizerId:  The authorizer identifier.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_cors_configuration(self, ApiId: str):
        r"""Deletes a CORS configuration.

        :param self:
        :param ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_deployment(self, DeploymentId: str, ApiId: str):
        r"""Deletes a Deployment.

        :param self:
        :param DeploymentId:  The deployment ID.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_domain_name(self, DomainName: str):
        r"""Deletes a domain name.

        :param self:
        :param DomainName:  The domain name.<br/>
        :return:         """
        pass

    def delete_integration(self, IntegrationId: str, ApiId: str):
        r"""Deletes an Integration.

        :param self:
        :param IntegrationId:  The integration ID.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_integration_response(self, IntegrationResponseId: str, IntegrationId: str, ApiId: str):
        r"""Deletes an IntegrationResponses.

        :param self:
        :param IntegrationResponseId:  The integration response ID.<br/>IntegrationId:  The integration ID.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_model(self, ModelId: str, ApiId: str):
        r"""Deletes a Model.

        :param self:
        :param ModelId:  The model ID.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_route(self, RouteId: str, ApiId: str):
        r"""Deletes a Route.

        :param self:
        :param RouteId:  The route ID.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_route_request_parameter(self, RouteId: str, RequestParameterKey: str, ApiId: str):
        r"""Deletes a route request parameter.

        :param self:
        :param RouteId:  The route ID.<br/>RequestParameterKey:  The route request parameter key.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_route_response(self, RouteResponseId: str, RouteId: str, ApiId: str):
        r"""Deletes a RouteResponse.

        :param self:
        :param RouteResponseId:  The route response ID.<br/>RouteId:  The route ID.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_route_settings(self, StageName: str, RouteKey: str, ApiId: str):
        r"""Deletes the RouteSettings for a stage.

        :param self:
        :param StageName:  The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>RouteKey:  The route key.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_stage(self, StageName: str, ApiId: str):
        r"""Deletes a Stage.

        :param self:
        :param StageName:  The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>ApiId:  The API identifier.<br/>
        :return:         """
        pass

    def delete_vpc_link(self, VpcLinkId: str) -> DeleteVpcLinkResponse:
        r"""Deletes a VPC link.

        :param self:
        :param VpcLinkId:  The ID of the VPC link.<br/>
        :return:         """
        pass

    def export_api(self, Specification: str, OutputType: str, ApiId: str, ExportVersion: str=None, IncludeExtensions: __boolean=None, StageName: str=None) -> ExportApiResponse:
        r"""

        :param self:
        :param StageName:  The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.<br/>Specification:  The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.<br/>OutputType:  The output type of the exported definition file. Valid values are JSON and YAML.<br/>IncludeExtensions:  Specifies whether to include <a href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.<br/>ExportVersion:  The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.<br/>ApiId:  The API identifier.<br/>
        :return: body:  Represents an exported definition of an API in a particular output format, for example, YAML. The API is serialized to the requested specification, for example, OpenAPI 3.0.<br/>        """
        pass

    def get_api(self, ApiId: str) -> GetApiResponse:
        r"""Gets an Api resource.

        :param self:
        :param ApiId:  The API identifier.<br/>
        :return: Warnings:  The warning messages reported when failonwarnings is turned on during API import.<br/>Version:  A version identifier for the API.<br/>Tags:  A collection of tags associated with the API.<br/>RouteSelectionExpression:  The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.<br/>ProtocolType:  The API protocol.<br/>Name:  The name of the API.<br/>ImportInfo:  The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.<br/>DisableSchemaValidation:  Avoid validating models when creating a deployment. Supported only for WebSocket APIs.<br/>Description:  The description of the API.<br/>CreatedDate:  The timestamp when the API was created.<br/>CorsConfiguration:  A CORS configuration. Supported only for HTTP APIs.:<br/>ApiKeySelectionExpression:  An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.<br/>ApiId:  The API ID.<br/>ApiEndpoint:  The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxAge</i> The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ExposeHeaders</i> Represents a collection of exposed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowOrigins</i> Represents a collection of allowed origins. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowMethods</i> Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowHeaders</i> Represents a collection of allowed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowCredentials</i> Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.<br/>        """
        pass

    def get_api_mapping(self, DomainName: str, ApiMappingId: str) -> GetApiMappingResponse:
        r"""Gets an API mapping.

        :param self:
        :param DomainName:  The domain name.<br/>ApiMappingId:  The API mapping identifier.<br/>
        :return: Stage:  The API stage.<br/>ApiMappingKey:  The API mapping key.<br/>ApiMappingId:  The API mapping identifier.<br/>ApiId:  The API identifier.<br/>        """
        pass

    def get_api_mappings(self, DomainName: str, MaxResults: str=None, NextToken: str=None) -> GetApiMappingsResponse:
        r"""Gets API mappings.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>DomainName:  The domain name.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_apis(self, MaxResults: str=None, NextToken: str=None) -> GetApisResponse:
        r"""Gets a collection of Api resources.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_authorizer(self, AuthorizerId: str, ApiId: str) -> GetAuthorizerResponse:
        r"""Gets an Authorizer.

        :param self:
        :param AuthorizerId:  The authorizer identifier.<br/>ApiId:  The API identifier.<br/>
        :return: Name:  The name of the authorizer.<br/>JwtConfiguration:  Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.:<br/>IdentityValidationExpression:  The validation expression does not apply to the REQUEST authorizer.<br/>IdentitySource:  The identity source for which authorization is requested. For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. Currently, the identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name. These parameters will be used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example "$request.header.Authorization".<br/>AuthorizerUri:  The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
               , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.<br/>AuthorizerType:  The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function using incoming request parameters. For HTTP APIs, specify JWT to use JSON Web Tokens.<br/>AuthorizerResultTtlInSeconds:  Authorizer caching is not currently supported. Don't specify this value for authorizers.<br/>AuthorizerId:  The authorizer identifier.<br/>AuthorizerCredentialsArn:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null. Supported only for REQUEST authorizers.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Issuer</i> The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
               . Required for the JWT authorizer type. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Audience</i> A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.<br/>        """
        pass

    def get_authorizers(self, ApiId: str, MaxResults: str=None, NextToken: str=None) -> GetAuthorizersResponse:
        r"""Gets the Authorizers for an API.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>ApiId:  The API identifier.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_deployment(self, DeploymentId: str, ApiId: str) -> GetDeploymentResponse:
        r"""Gets a Deployment.

        :param self:
        :param DeploymentId:  The deployment ID.<br/>ApiId:  The API identifier.<br/>
        :return: Description:  The description for the deployment.<br/>DeploymentStatusMessage:  May contain additional feedback on the status of an API deployment.<br/>DeploymentStatus:  The status of the deployment: PENDING, FAILED, or SUCCEEDED.<br/>DeploymentId:  The identifier for the deployment.<br/>CreatedDate:  The date and time when the Deployment resource was created.<br/>AutoDeployed:  Specifies whether a deployment was automatically released.<br/>        """
        pass

    def get_deployments(self, ApiId: str, MaxResults: str=None, NextToken: str=None) -> GetDeploymentsResponse:
        r"""Gets the Deployments for an API.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>ApiId:  The API identifier.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_domain_name(self, DomainName: str) -> GetDomainNameResponse:
        r"""Gets a domain name.

        :param self:
        :param DomainName:  The domain name.<br/>
        :return: Tags:  The collection of tags associated with a domain name.<br/>DomainNameConfigurations:  The domain name configurations.<br/>DomainName:  The name of the DomainName resource.<br/>ApiMappingSelectionExpression:  The API mapping selection expression.<br/>        """
        pass

    def get_domain_names(self, MaxResults: str=None, NextToken: str=None) -> GetDomainNamesResponse:
        r"""Gets the domain names for an AWS account.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_integration(self, IntegrationId: str, ApiId: str) -> GetIntegrationResult:
        r"""Gets an Integration.

        :param self:
        :param IntegrationId:  The integration ID.<br/>ApiId:  The API identifier.<br/>
        :return: TlsConfig:  The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.:<br/>TimeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.<br/>TemplateSelectionExpression:  The template selection expression for the integration. Supported only for WebSocket APIs.<br/>RequestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.<br/>RequestParameters:  A key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
               , where 
                  <replaceable>{location}</replaceable>
                is querystring, path, or header; and 
                  <replaceable>{name}</replaceable>
                must be a valid and unique method request parameter name. Supported only for WebSocket APIs.<br/>PayloadFormatVersion:  Specifies the format of the payload sent to an integration. Required for HTTP APIs.<br/>PassthroughBehavior:  Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs. WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation. NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response. WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.<br/>IntegrationUri:  For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.<br/>IntegrationType:  The integration type of an integration. One of the following: AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs. AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as Lambda proxy integration. HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs. HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.<br/>IntegrationResponseSelectionExpression:  The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.<br/>IntegrationMethod:  Specifies the integration's HTTP method type.<br/>IntegrationId:  Represents the identifier of an integration.<br/>Description:  Represents the description of an integration.<br/>CredentialsArn:  Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>ConnectionType:  The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.<br/>ConnectionId:  The ID of the VPC link for a private integration. Supported only for HTTP APIs.<br/>ApiGatewayManaged:  Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ServerNameToVerify</i> If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.<br/>        """
        pass

    def get_integration_response(self, IntegrationResponseId: str, IntegrationId: str, ApiId: str) -> GetIntegrationResponseResponse:
        r"""Gets an IntegrationResponses.

        :param self:
        :param IntegrationResponseId:  The integration response ID.<br/>IntegrationId:  The integration ID.<br/>ApiId:  The API identifier.<br/>
        :return: TemplateSelectionExpression:  The template selection expressions for the integration response.<br/>ResponseTemplates:  The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.<br/>ResponseParameters:  A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.<br/>IntegrationResponseKey:  The integration response key.<br/>IntegrationResponseId:  The integration response ID.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>        """
        pass

    def get_integration_responses(self, IntegrationId: str, ApiId: str, MaxResults: str=None, NextToken: str=None) -> GetIntegrationResponsesResponse:
        r"""Gets the IntegrationResponses for an Integration.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>IntegrationId:  The integration ID.<br/>ApiId:  The API identifier.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_integrations(self, ApiId: str, MaxResults: str=None, NextToken: str=None) -> GetIntegrationsResponse:
        r"""Gets the Integrations for an API.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>ApiId:  The API identifier.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_model(self, ModelId: str, ApiId: str) -> GetModelResponse:
        r"""Gets a Model.

        :param self:
        :param ModelId:  The model ID.<br/>ApiId:  The API identifier.<br/>
        :return: Schema:  The schema for the model. For application/json models, this should be JSON schema draft 4 model.<br/>Name:  The name of the model. Must be alphanumeric.<br/>ModelId:  The model identifier.<br/>Description:  The description of the model.<br/>ContentType:  The content-type for the model, for example, "application/json".<br/>        """
        pass

    def get_model_template(self, ModelId: str, ApiId: str) -> GetModelTemplateResponse:
        r"""Gets a model template.

        :param self:
        :param ModelId:  The model ID.<br/>ApiId:  The API identifier.<br/>
        :return: Value:  The template value.<br/>        """
        pass

    def get_models(self, ApiId: str, MaxResults: str=None, NextToken: str=None) -> GetModelsResponse:
        r"""Gets the Models for an API.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>ApiId:  The API identifier.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_route(self, RouteId: str, ApiId: str) -> GetRouteResult:
        r"""Gets a Route.

        :param self:
        :param RouteId:  The route ID.<br/>ApiId:  The API identifier.<br/>
        :return: Target:  The target for the route.<br/>RouteResponseSelectionExpression:  The route response selection expression for the route. Supported only for WebSocket APIs.<br/>RouteKey:  The route key for the route.<br/>RouteId:  The route ID.<br/>RequestParameters:  The request parameters for the route. Supported only for WebSocket APIs.<br/>RequestModels:  The request models for the route. Supported only for WebSocket APIs.<br/>OperationName:  The operation name for the route.<br/>ModelSelectionExpression:  The model selection expression for the route. Supported only for WebSocket APIs.<br/>AuthorizerId:  The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.<br/>AuthorizationType:  The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, or JWT for using JSON Web Tokens.<br/>AuthorizationScopes:  A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.<br/>ApiKeyRequired:  Specifies whether an API key is required for this route. Supported only for WebSocket APIs.<br/>ApiGatewayManaged:  Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.<br/>        """
        pass

    def get_route_response(self, RouteResponseId: str, RouteId: str, ApiId: str) -> GetRouteResponseResponse:
        r"""Gets a RouteResponse.

        :param self:
        :param RouteResponseId:  The route response ID.<br/>RouteId:  The route ID.<br/>ApiId:  The API identifier.<br/>
        :return: RouteResponseKey:  Represents the route response key of a route response.<br/>RouteResponseId:  Represents the identifier of a route response.<br/>ResponseParameters:  Represents the response parameters of a route response.<br/>ResponseModels:  Represents the response models of a route response.<br/>ModelSelectionExpression:  Represents the model selection expression of a route response. Supported only for WebSocket APIs.<br/>        """
        pass

    def get_route_responses(self, RouteId: str, ApiId: str, MaxResults: str=None, NextToken: str=None) -> GetRouteResponsesResponse:
        r"""Gets the RouteResponses for a Route.

        :param self:
        :param RouteId:  The route ID.<br/>NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>ApiId:  The API identifier.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_routes(self, ApiId: str, MaxResults: str=None, NextToken: str=None) -> GetRoutesResponse:
        r"""Gets the Routes for an API.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>ApiId:  The API identifier.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_stage(self, StageName: str, ApiId: str) -> GetStageResponse:
        r"""Gets a Stage.

        :param self:
        :param StageName:  The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>ApiId:  The API identifier.<br/>
        :return: Tags:  The collection of tags. Each tag element is associated with a given resource.<br/>StageVariables:  A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.<br/>StageName:  The name of the stage.<br/>RouteSettings:  Route settings for the stage, by routeKey.<br/>LastUpdatedDate:  The timestamp when the stage was last updated.<br/>LastDeploymentStatusMessage:  Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.<br/>Description:  The description of the stage.<br/>DeploymentId:  The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.<br/>DefaultRouteSettings:  Default route settings for the stage.:<br/>CreatedDate:  The timestamp when the stage was created.<br/>ClientCertificateId:  The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.<br/>AutoDeploy:  Specifies whether updates to an API automatically trigger a new deployment. The default value is false.<br/>ApiGatewayManaged:  Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.<br/>AccessLogSettings:  Settings for logging access in this stage.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Format</i> A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DestinationArn</i> The ARN of the CloudWatch Logs log group to receive access logs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingRateLimit</i> Specifies the throttling rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingBurstLimit</i> Specifies the throttling burst limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LoggingLevel</i> Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DetailedMetricsEnabled</i> Specifies whether detailed metrics are enabled.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DataTraceEnabled</i> Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>        """
        pass

    def get_stages(self, ApiId: str, MaxResults: str=None, NextToken: str=None) -> GetStagesResponse:
        r"""Gets the Stages for an API.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>ApiId:  The API identifier.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def get_tags(self, ResourceArn: str) -> GetTagsResponse:
        r"""Gets a collection of Tag resources.

        :param self:
        :param ResourceArn:  The resource ARN for the tag.<br/>
        :return: Tags:  Represents a collection of tags associated with the resource.<br/>        """
        pass

    def get_vpc_link(self, VpcLinkId: str) -> GetVpcLinkResponse:
        r"""Gets a VPC link.

        :param self:
        :param VpcLinkId:  The ID of the VPC link.<br/>
        :return: VpcLinkVersion:  The version of the VPC link.<br/>VpcLinkStatusMessage:  A message summarizing the cause of the status of the VPC link.<br/>VpcLinkStatus:  The status of the VPC link.<br/>VpcLinkId:  The ID of the VPC link.<br/>Tags:  Tags for the VPC link.<br/>SubnetIds:  A list of subnet IDs to include in the VPC link.<br/>SecurityGroupIds:  A list of security group IDs for the VPC link.<br/>Name:  The name of the VPC link.<br/>CreatedDate:  The timestamp when the VPC link was created.<br/>        """
        pass

    def get_vpc_links(self, MaxResults: str=None, NextToken: str=None) -> GetVpcLinksResponse:
        r"""Gets a collection of VPC links.

        :param self:
        :param NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>MaxResults:  The maximum number of elements to be returned for this resource.<br/>
        :return: NextToken:  The next page of elements from this collection. Not valid for the last element of the collection.<br/>Items:  A collection of VPC links.<br/>        """
        pass

    def import_api(self, Body: str, Basepath: str=None, FailOnWarnings: __boolean=None) -> ImportApiResponse:
        r"""Imports an API.

        :param self:
        :param FailOnWarnings:  Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.<br/>Body:  The OpenAPI definition. Supported only for HTTP APIs.<br/>Basepath:  Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.<br/>
        :return: Warnings:  The warning messages reported when failonwarnings is turned on during API import.<br/>Version:  A version identifier for the API.<br/>Tags:  A collection of tags associated with the API.<br/>RouteSelectionExpression:  The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.<br/>ProtocolType:  The API protocol.<br/>Name:  The name of the API.<br/>ImportInfo:  The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.<br/>DisableSchemaValidation:  Avoid validating models when creating a deployment. Supported only for WebSocket APIs.<br/>Description:  The description of the API.<br/>CreatedDate:  The timestamp when the API was created.<br/>CorsConfiguration:  A CORS configuration. Supported only for HTTP APIs.:<br/>ApiKeySelectionExpression:  An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.<br/>ApiId:  The API ID.<br/>ApiEndpoint:  The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxAge</i> The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ExposeHeaders</i> Represents a collection of exposed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowOrigins</i> Represents a collection of allowed origins. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowMethods</i> Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowHeaders</i> Represents a collection of allowed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowCredentials</i> Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.<br/>        """
        pass

    def reimport_api(self, Body: str, ApiId: str, Basepath: str=None, FailOnWarnings: __boolean=None) -> ReimportApiResponse:
        r"""Puts an Api resource.

        :param self:
        :param FailOnWarnings:  Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered.<br/>Body:  The OpenAPI definition. Supported only for HTTP APIs.<br/>Basepath:  Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.<br/>ApiId:  The API identifier.<br/>
        :return: Warnings:  The warning messages reported when failonwarnings is turned on during API import.<br/>Version:  A version identifier for the API.<br/>Tags:  A collection of tags associated with the API.<br/>RouteSelectionExpression:  The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.<br/>ProtocolType:  The API protocol.<br/>Name:  The name of the API.<br/>ImportInfo:  The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.<br/>DisableSchemaValidation:  Avoid validating models when creating a deployment. Supported only for WebSocket APIs.<br/>Description:  The description of the API.<br/>CreatedDate:  The timestamp when the API was created.<br/>CorsConfiguration:  A CORS configuration. Supported only for HTTP APIs.:<br/>ApiKeySelectionExpression:  An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.<br/>ApiId:  The API ID.<br/>ApiEndpoint:  The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxAge</i> The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ExposeHeaders</i> Represents a collection of exposed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowOrigins</i> Represents a collection of allowed origins. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowMethods</i> Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowHeaders</i> Represents a collection of allowed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowCredentials</i> Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.<br/>        """
        pass

    def tag_resource(self, ResourceArn: str, Tags: Tags=None) -> TagResourceResponse:
        r"""Creates a new Tag resource to represent a tag.

        :param self:
        :param Tags:  The collection of tags. Each tag element is associated with a given resource.<br/>ResourceArn:  The resource ARN for the tag.<br/>
        :return:         """
        pass

    def untag_resource(self, TagKeys: List[__string], ResourceArn: str):
        r"""Deletes a Tag.

        :param self:
        :param TagKeys:  The Tag keys to delete<br/>ResourceArn:  The resource ARN for the tag.<br/>
        :return:         """
        pass

    def update_api(self, ApiId: str, ApiKeySelectionExpression: str=None, CorsConfiguration: Cors=None, CredentialsArn: str=None, Description: str=None, DisableSchemaValidation: __boolean=None, Name: str=None, RouteKey: str=None, RouteSelectionExpression: str=None, Target: str=None, Version: str=None) -> UpdateApiResponse:
        r"""Updates an Api resource.

        :param self:
        :param Version:  A version identifier for the API.<br/>Target:  This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.<br/>RouteSelectionExpression:  The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.<br/>RouteKey:  This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.<br/>Name:  The name of the API.<br/>DisableSchemaValidation:  Avoid validating models when creating a deployment. Supported only for WebSocket APIs.<br/>Description:  The description of the API.<br/>CredentialsArn:  This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.<br/>CorsConfiguration:  A CORS configuration. Supported only for HTTP APIs.:<br/>ApiKeySelectionExpression:  An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.<br/>ApiId:  The API identifier.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxAge</i> The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ExposeHeaders</i> Represents a collection of exposed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowOrigins</i> Represents a collection of allowed origins. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowMethods</i> Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowHeaders</i> Represents a collection of allowed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowCredentials</i> Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.<br/>
        :return: Warnings:  The warning messages reported when failonwarnings is turned on during API import.<br/>Version:  A version identifier for the API.<br/>Tags:  A collection of tags associated with the API.<br/>RouteSelectionExpression:  The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.<br/>ProtocolType:  The API protocol.<br/>Name:  The name of the API.<br/>ImportInfo:  The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.<br/>DisableSchemaValidation:  Avoid validating models when creating a deployment. Supported only for WebSocket APIs.<br/>Description:  The description of the API.<br/>CreatedDate:  The timestamp when the API was created.<br/>CorsConfiguration:  A CORS configuration. Supported only for HTTP APIs.:<br/>ApiKeySelectionExpression:  An API key selection expression. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a>.<br/>ApiId:  The API ID.<br/>ApiEndpoint:  The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxAge</i> The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ExposeHeaders</i> Represents a collection of exposed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowOrigins</i> Represents a collection of allowed origins. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowMethods</i> Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowHeaders</i> Represents a collection of allowed headers. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AllowCredentials</i> Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.<br/>        """
        pass

    def update_api_mapping(self, DomainName: str, ApiMappingId: str, ApiId: str, ApiMappingKey: str=None, Stage: str=None) -> UpdateApiMappingResponse:
        r"""The API mapping.

        :param self:
        :param Stage:  The API stage.<br/>DomainName:  The domain name.<br/>ApiMappingKey:  The API mapping key.<br/>ApiMappingId:  The API mapping identifier.<br/>ApiId:  The API identifier.<br/>
        :return: Stage:  The API stage.<br/>ApiMappingKey:  The API mapping key.<br/>ApiMappingId:  The API mapping identifier.<br/>ApiId:  The API identifier.<br/>        """
        pass

    def update_authorizer(self, AuthorizerId: str, ApiId: str, AuthorizerCredentialsArn: str=None, AuthorizerResultTtlInSeconds: int=None, AuthorizerType: str=None, AuthorizerUri: str=None, IdentitySource: List[__string]=None, IdentityValidationExpression: str=None, JwtConfiguration: JWTConfiguration=None, Name: str=None) -> UpdateAuthorizerResponse:
        r"""Updates an Authorizer.

        :param self:
        :param Name:  The name of the authorizer.<br/>JwtConfiguration:  Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.:<br/>IdentityValidationExpression:  This parameter is not used.<br/>IdentitySource:  The identity source for which authorization is requested. For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. Currently, the identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name. These parameters will be used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example "$request.header.Authorization".<br/>AuthorizerUri:  The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
               , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.<br/>AuthorizerType:  The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function using incoming request parameters. For HTTP APIs, specify JWT to use JSON Web Tokens.<br/>AuthorizerResultTtlInSeconds:  Authorizer caching is not currently supported. Don't specify this value for authorizers.<br/>AuthorizerId:  The authorizer identifier.<br/>AuthorizerCredentialsArn:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.<br/>ApiId:  The API identifier.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Issuer</i> The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
               . Required for the JWT authorizer type. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Audience</i> A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.<br/>
        :return: Name:  The name of the authorizer.<br/>JwtConfiguration:  Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.:<br/>IdentityValidationExpression:  The validation expression does not apply to the REQUEST authorizer.<br/>IdentitySource:  The identity source for which authorization is requested. For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. Currently, the identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name. These parameters will be used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example "$request.header.Authorization".<br/>AuthorizerUri:  The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}</replaceable>:function:<replaceable>{lambda_function_name}</replaceable>/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}</replaceable>:lambda:path/<replaceable>{service_api}</replaceable>
               , where <replaceable></replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers.<br/>AuthorizerType:  The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function using incoming request parameters. For HTTP APIs, specify JWT to use JSON Web Tokens.<br/>AuthorizerResultTtlInSeconds:  Authorizer caching is not currently supported. Don't specify this value for authorizers.<br/>AuthorizerId:  The authorizer identifier.<br/>AuthorizerCredentialsArn:  Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null. Supported only for REQUEST authorizers.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Issuer</i> The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}</replaceable>.amazonaws.com/<replaceable>{userPoolId}</replaceable>
               . Required for the JWT authorizer type. Supported only for HTTP APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Audience</i> A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See <a href="https://tools.ietf.org/html/rfc7519#section-4.1.3">RFC 7519</a>. Supported only for HTTP APIs.<br/>        """
        pass

    def update_deployment(self, DeploymentId: str, ApiId: str, Description: str=None) -> UpdateDeploymentResponse:
        r"""Updates a Deployment.

        :param self:
        :param Description:  The description for the deployment resource.<br/>DeploymentId:  The deployment ID.<br/>ApiId:  The API identifier.<br/>
        :return: Description:  The description for the deployment.<br/>DeploymentStatusMessage:  May contain additional feedback on the status of an API deployment.<br/>DeploymentStatus:  The status of the deployment: PENDING, FAILED, or SUCCEEDED.<br/>DeploymentId:  The identifier for the deployment.<br/>CreatedDate:  The date and time when the Deployment resource was created.<br/>AutoDeployed:  Specifies whether a deployment was automatically released.<br/>        """
        pass

    def update_domain_name(self, DomainName: str, DomainNameConfigurations: List[DomainNameConfiguration]=None) -> UpdateDomainNameResponse:
        r"""Updates a domain name.

        :param self:
        :param DomainNameConfigurations:  The domain name configurations.<br/>DomainName:  The domain name.<br/>
        :return: Tags:  The collection of tags associated with a domain name.<br/>DomainNameConfigurations:  The domain name configurations.<br/>DomainName:  The name of the DomainName resource.<br/>ApiMappingSelectionExpression:  The API mapping selection expression.<br/>        """
        pass

    def update_integration(self, IntegrationId: str, ApiId: str, ConnectionId: str=None, ConnectionType: str=None, ContentHandlingStrategy: str=None, CredentialsArn: str=None, Description: str=None, IntegrationMethod: str=None, IntegrationType: str=None, IntegrationUri: str=None, PassthroughBehavior: str=None, PayloadFormatVersion: str=None, RequestParameters: IntegrationParameters=None, RequestTemplates: TemplateMap=None, TemplateSelectionExpression: str=None, TimeoutInMillis: int=None, TlsConfig: TlsConfigInput=None) -> UpdateIntegrationResult:
        r"""Updates an Integration.

        :param self:
        :param TlsConfig:  The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.:<br/>TimeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.<br/>TemplateSelectionExpression:  The template selection expression for the integration.<br/>RequestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.<br/>RequestParameters:  A key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
               , where 
                  <replaceable>{location}</replaceable>
                is querystring, path, or header; and 
                  <replaceable>{name}</replaceable>
                must be a valid and unique method request parameter name. Supported only for WebSocket APIs.<br/>PayloadFormatVersion:  Specifies the format of the payload sent to an integration. Required for HTTP APIs.<br/>PassthroughBehavior:  Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs. WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation. NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response. WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.<br/>IntegrationUri:  For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.<br/>IntegrationType:  The integration type of an integration. One of the following: AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs. AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as Lambda proxy integration. HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs. HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration. MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.<br/>IntegrationMethod:  Specifies the integration's HTTP method type.<br/>IntegrationId:  The integration ID.<br/>Description:  The description of the integration<br/>CredentialsArn:  Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>ConnectionType:  The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.<br/>ConnectionId:  The ID of the VPC link for a private integration. Supported only for HTTP APIs.<br/>ApiId:  The API identifier.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ServerNameToVerify</i> If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.<br/>
        :return: TlsConfig:  The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.:<br/>TimeoutInMillis:  Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.<br/>TemplateSelectionExpression:  The template selection expression for the integration. Supported only for WebSocket APIs.<br/>RequestTemplates:  Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.<br/>RequestParameters:  A key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable>
               , where 
                  <replaceable>{location}</replaceable>
                is querystring, path, or header; and 
                  <replaceable>{name}</replaceable>
                must be a valid and unique method request parameter name. Supported only for WebSocket APIs.<br/>PayloadFormatVersion:  Specifies the format of the payload sent to an integration. Required for HTTP APIs.<br/>PassthroughBehavior:  Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs. WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation. NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response. WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.<br/>IntegrationUri:  For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.<br/>IntegrationType:  The integration type of an integration. One of the following: AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs. AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as Lambda proxy integration. HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs. HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.<br/>IntegrationResponseSelectionExpression:  The integration response selection expression for the integration. Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions">Integration Response Selection Expressions</a>.<br/>IntegrationMethod:  Specifies the integration's HTTP method type.<br/>IntegrationId:  Represents the identifier of an integration.<br/>Description:  Represents the description of an integration.<br/>CredentialsArn:  Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>ConnectionType:  The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.<br/>ConnectionId:  The ID of the VPC link for a private integration. Supported only for HTTP APIs.<br/>ApiGatewayManaged:  Specifies whether an integration is managed by API Gateway. If you created an API using using quick create, the resulting integration is managed by API Gateway. You can update a managed integration, but you can't delete it.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ServerNameToVerify</i> If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.<br/>        """
        pass

    def update_integration_response(self, IntegrationResponseId: str, IntegrationId: str, ApiId: str, ContentHandlingStrategy: str=None, IntegrationResponseKey: str=None, ResponseParameters: IntegrationParameters=None, ResponseTemplates: TemplateMap=None, TemplateSelectionExpression: str=None) -> UpdateIntegrationResponseResponse:
        r"""Updates an IntegrationResponses.

        :param self:
        :param TemplateSelectionExpression:  The template selection expression for the integration response. Supported only for WebSocket APIs.<br/>ResponseTemplates:  The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.<br/>ResponseParameters:  A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>{name}</replaceable>
               , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>{name}</replaceable>
                or integration.response.body.<replaceable>{JSON-expression}</replaceable>
               , where 
                  <replaceable>{name}</replaceable>
                is a valid and unique response header name and 
                  <replaceable>{JSON-expression}</replaceable>
                is a valid JSON expression without the $ prefix.<br/>IntegrationResponseKey:  The integration response key.<br/>IntegrationResponseId:  The integration response ID.<br/>IntegrationId:  The integration ID.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>ApiId:  The API identifier.<br/>
        :return: TemplateSelectionExpression:  The template selection expressions for the integration response.<br/>ResponseTemplates:  The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.<br/>ResponseParameters:  A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.<br/>IntegrationResponseKey:  The integration response key.<br/>IntegrationResponseId:  The integration response ID.<br/>ContentHandlingStrategy:  Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.<br/>        """
        pass

    def update_model(self, ModelId: str, ApiId: str, ContentType: str=None, Description: str=None, Name: str=None, Schema: str=None) -> UpdateModelResponse:
        r"""Updates a Model.

        :param self:
        :param Schema:  The schema for the model. For application/json models, this should be JSON schema draft 4 model.<br/>Name:  The name of the model.<br/>ModelId:  The model ID.<br/>Description:  The description of the model.<br/>ContentType:  The content-type for the model, for example, "application/json".<br/>ApiId:  The API identifier.<br/>
        :return: Schema:  The schema for the model. For application/json models, this should be JSON schema draft 4 model.<br/>Name:  The name of the model. Must be alphanumeric.<br/>ModelId:  The model identifier.<br/>Description:  The description of the model.<br/>ContentType:  The content-type for the model, for example, "application/json".<br/>        """
        pass

    def update_route(self, RouteId: str, ApiId: str, ApiKeyRequired: __boolean=None, AuthorizationScopes: List[StringWithLengthBetween1And64]=None, AuthorizationType: str=None, AuthorizerId: str=None, ModelSelectionExpression: str=None, OperationName: str=None, RequestModels: RouteModels=None, RequestParameters: RouteParameters=None, RouteKey: str=None, RouteResponseSelectionExpression: str=None, Target: str=None) -> UpdateRouteResult:
        r"""Updates a Route.

        :param self:
        :param Target:  The target for the route.<br/>RouteResponseSelectionExpression:  The route response selection expression for the route. Supported only for WebSocket APIs.<br/>RouteKey:  The route key for the route.<br/>RouteId:  The route ID.<br/>RequestParameters:  The request parameters for the route. Supported only for WebSocket APIs.<br/>RequestModels:  The request models for the route. Supported only for WebSocket APIs.<br/>OperationName:  The operation name for the route.<br/>ModelSelectionExpression:  The model selection expression for the route. Supported only for WebSocket APIs.<br/>AuthorizerId:  The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.<br/>AuthorizationType:  The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, or JWT for using JSON Web Tokens.<br/>AuthorizationScopes:  The authorization scopes supported by this route.<br/>ApiKeyRequired:  Specifies whether an API key is required for the route. Supported only for WebSocket APIs.<br/>ApiId:  The API identifier.<br/>
        :return: Target:  The target for the route.<br/>RouteResponseSelectionExpression:  The route response selection expression for the route. Supported only for WebSocket APIs.<br/>RouteKey:  The route key for the route.<br/>RouteId:  The route ID.<br/>RequestParameters:  The request parameters for the route. Supported only for WebSocket APIs.<br/>RequestModels:  The request models for the route. Supported only for WebSocket APIs.<br/>OperationName:  The operation name for the route.<br/>ModelSelectionExpression:  The model selection expression for the route. Supported only for WebSocket APIs.<br/>AuthorizerId:  The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.<br/>AuthorizationType:  The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, or JWT for using JSON Web Tokens.<br/>AuthorizationScopes:  A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.<br/>ApiKeyRequired:  Specifies whether an API key is required for this route. Supported only for WebSocket APIs.<br/>ApiGatewayManaged:  Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.<br/>        """
        pass

    def update_route_response(self, RouteResponseId: str, RouteId: str, ApiId: str, ModelSelectionExpression: str=None, ResponseModels: RouteModels=None, ResponseParameters: RouteParameters=None, RouteResponseKey: str=None) -> UpdateRouteResponseResponse:
        r"""Updates a RouteResponse.

        :param self:
        :param RouteResponseKey:  The route response key.<br/>RouteResponseId:  The route response ID.<br/>RouteId:  The route ID.<br/>ResponseParameters:  The route response parameters.<br/>ResponseModels:  The response models for the route response.<br/>ModelSelectionExpression:  The model selection expression for the route response. Supported only for WebSocket APIs.<br/>ApiId:  The API identifier.<br/>
        :return: RouteResponseKey:  Represents the route response key of a route response.<br/>RouteResponseId:  Represents the identifier of a route response.<br/>ResponseParameters:  Represents the response parameters of a route response.<br/>ResponseModels:  Represents the response models of a route response.<br/>ModelSelectionExpression:  Represents the model selection expression of a route response. Supported only for WebSocket APIs.<br/>        """
        pass

    def update_stage(self, StageName: str, ApiId: str, AccessLogSettings: AccessLogSettings=None, AutoDeploy: __boolean=None, ClientCertificateId: str=None, DefaultRouteSettings: RouteSettings=None, DeploymentId: str=None, Description: str=None, RouteSettings: RouteSettingsMap=None, StageVariables: StageVariablesMap=None) -> UpdateStageResponse:
        r"""Updates a Stage.

        :param self:
        :param StageVariables:  A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.<br/>StageName:  The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.<br/>RouteSettings:  Route settings for the stage.<br/>Description:  The description for the API stage.<br/>DeploymentId:  The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.<br/>DefaultRouteSettings:  The default route settings for the stage.:<br/>ClientCertificateId:  The identifier of a client certificate for a Stage.<br/>AutoDeploy:  Specifies whether updates to an API automatically trigger a new deployment. The default value is false.<br/>ApiId:  The API identifier.<br/>AccessLogSettings:  Settings for logging access in this stage.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Format</i> A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DestinationArn</i> The ARN of the CloudWatch Logs log group to receive access logs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingRateLimit</i> Specifies the throttling rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingBurstLimit</i> Specifies the throttling burst limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LoggingLevel</i> Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DetailedMetricsEnabled</i> Specifies whether detailed metrics are enabled.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DataTraceEnabled</i> Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>
        :return: Tags:  The collection of tags. Each tag element is associated with a given resource.<br/>StageVariables:  A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.<br/>StageName:  The name of the stage.<br/>RouteSettings:  Route settings for the stage, by routeKey.<br/>LastUpdatedDate:  The timestamp when the stage was last updated.<br/>LastDeploymentStatusMessage:  Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.<br/>Description:  The description of the stage.<br/>DeploymentId:  The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.<br/>DefaultRouteSettings:  Default route settings for the stage.:<br/>CreatedDate:  The timestamp when the stage was created.<br/>ClientCertificateId:  The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.<br/>AutoDeploy:  Specifies whether updates to an API automatically trigger a new deployment. The default value is false.<br/>ApiGatewayManaged:  Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.<br/>AccessLogSettings:  Settings for logging access in this stage.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Format</i> A single line format of the access logs of data, as specified by selected $context variables. The format must include at least $context.requestId.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DestinationArn</i> The ARN of the CloudWatch Logs log group to receive access logs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingRateLimit</i> Specifies the throttling rate limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ThrottlingBurstLimit</i> Specifies the throttling burst limit.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LoggingLevel</i> Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DetailedMetricsEnabled</i> Specifies whether detailed metrics are enabled.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DataTraceEnabled</i> Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.<br/>        """
        pass

    def update_vpc_link(self, VpcLinkId: str, Name: str=None) -> UpdateVpcLinkResponse:
        r"""Updates a VPC link.

        :param self:
        :param VpcLinkId:  The ID of the VPC link.<br/>Name:  The name of the VPC link.<br/>
        :return: VpcLinkVersion:  The version of the VPC link.<br/>VpcLinkStatusMessage:  A message summarizing the cause of the status of the VPC link.<br/>VpcLinkStatus:  The status of the VPC link.<br/>VpcLinkId:  The ID of the VPC link.<br/>Tags:  Tags for the VPC link.<br/>SubnetIds:  A list of subnet IDs to include in the VPC link.<br/>SecurityGroupIds:  A list of security group IDs for the VPC link.<br/>Name:  The name of the VPC link.<br/>CreatedDate:  The timestamp when the VPC link was created.<br/>        """
        pass



class AppConfig(BaseClient):
    r"""<fullname>AWS AppConfig</fullname> Use AWS AppConfig, a capability of AWS Systems Manager, to create, manage, and quickly deploy application configurations. AppConfig supports controlled deployments to applications of any size and includes built-in validation checks and monitoring. You can use AppConfig with applications hosted on Amazon EC2 instances, AWS Lambda, containers, mobile applications, or IoT devices. To prevent errors when deploying application configurations, especially for production systems where a simple typo could cause an unexpected outage, AppConfig includes validators. A validator provides a syntactic or semantic check to ensure that the configuration you want to deploy works as intended. To validate your application configuration data, you provide a schema or a Lambda function that runs against the configuration. The configuration deployment or update can only proceed when the configuration data is valid. During a configuration deployment, AppConfig monitors the application to ensure that the deployment is successful. If the system encounters an error, AppConfig rolls back the change to minimize impact for your application users. You can configure a deployment strategy for each application or environment that includes deployment criteria, including velocity, bake time, and alarms to monitor. Similar to error monitoring, if a deployment triggers an alarm, AppConfig automatically rolls back to the previous version.  AppConfig supports multiple use cases. Here are some examples. <ul> <li>  <b>Application tuning</b>: Use AppConfig to carefully introduce changes to your application that can only be tested with production traffic. </li> <li>  <b>Feature toggle</b>: Use AppConfig to turn on new features that require a timely deployment, such as a product launch or announcement.  </li> <li>  <b>User membership</b>: Use AppConfig to allow premium subscribers to access paid content.  </li> <li>  <b>Operational issues</b>: Use AppConfig to reduce stress on your application when a dependency or other external factor impacts the system. </li> </ul> This reference is intended to be used with the <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig User Guide</a>."""




    class CreateApplicationRequest(Mapping):
        pass
    
    class Application(Mapping):
        pass
    
    class TagMap(object):
        pass
    
    class CreateConfigurationProfileRequest(Mapping):
        pass
    
    class ConfigurationProfile(Mapping):
        pass
    
    class Validator(Mapping):
        pass
    
    class CreateDeploymentStrategyRequest(Mapping):
        pass
    
    class DeploymentStrategy(Mapping):
        pass
    
    class GrowthFactor(object):
        pass
    
    class CreateEnvironmentRequest(Mapping):
        pass
    
    class Environment(Mapping):
        pass
    
    class Monitor(Mapping):
        pass
    
    class DeleteApplicationRequest(Mapping):
        pass
    
    class DeleteConfigurationProfileRequest(Mapping):
        pass
    
    class DeleteDeploymentStrategyRequest(Mapping):
        pass
    
    class DeleteEnvironmentRequest(Mapping):
        pass
    
    class GetApplicationRequest(Mapping):
        pass
    
    class GetConfigurationRequest(Mapping):
        pass
    
    class Configuration(Mapping):
        pass
    
    class GetConfigurationProfileRequest(Mapping):
        pass
    
    class GetDeploymentRequest(Mapping):
        pass
    
    class Deployment(Mapping):
        pass
    
    class GetDeploymentStrategyRequest(Mapping):
        pass
    
    class GetEnvironmentRequest(Mapping):
        pass
    
    class ListApplicationsRequest(Mapping):
        pass
    
    class Applications(Mapping):
        pass
    
    class ListConfigurationProfilesRequest(Mapping):
        pass
    
    class ConfigurationProfiles(Mapping):
        pass
    
    class ListDeploymentStrategiesRequest(Mapping):
        pass
    
    class DeploymentStrategies(Mapping):
        pass
    
    class ListDeploymentsRequest(Mapping):
        pass
    
    class Deployments(Mapping):
        pass
    
    class ListEnvironmentsRequest(Mapping):
        pass
    
    class Environments(Mapping):
        pass
    
    class ListTagsForResourceRequest(Mapping):
        pass
    
    class ResourceTags(Mapping):
        pass
    
    class StartDeploymentRequest(Mapping):
        pass
    
    class StopDeploymentRequest(Mapping):
        pass
    
    class TagResourceRequest(Mapping):
        pass
    
    class UntagResourceRequest(Mapping):
        pass
    
    class TagKey(object):
        pass
    
    class UpdateApplicationRequest(Mapping):
        pass
    
    class UpdateConfigurationProfileRequest(Mapping):
        pass
    
    class UpdateDeploymentStrategyRequest(Mapping):
        pass
    
    class UpdateEnvironmentRequest(Mapping):
        pass
    
    class ValidateConfigurationRequest(Mapping):
        pass
    
    def create_application(self, Name: str, Description: str=None, Tags: TagMap=None) -> Application:
        r"""An application in AppConfig is a logical unit of code that provides capabilities for your customers. For example, an application can be a microservice that runs on Amazon EC2 instances, a mobile application installed by your users, a serverless application using Amazon API Gateway and AWS Lambda, or any system you run on behalf of others.

        :param self:
        :param Tags:  Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.<br/>Description:  A description of the application.<br/>Name:  A name for the application.<br/>
        :return: Description:  The description of the application.<br/>Name:  The application name.<br/>Id:  The application ID.<br/>        """
        pass

    def create_configuration_profile(self, RetrievalRoleArn: str, LocationUri: str, Name: str, ApplicationId: str, Description: str=None, Validators: List[Validator]=None, Tags: TagMap=None) -> ConfigurationProfile:
        r"""Information that enables AppConfig to access the configuration source. Valid configuration sources include Systems Manager (SSM) documents, SSM Parameter Store parameters, and Amazon S3 objects. A configuration profile includes the following information. <ul> <li> The Uri location of the configuration data. </li> <li> The AWS Identity and Access Management (IAM) role that provides access to the configuration data. </li> <li> A validator for the configuration data. Available validators include either a JSON Schema or an AWS Lambda function. </li> </ul> For more information, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig-creating-configuration-and-profile.html">Create a Configuration and a Configuration Profile</a> in the <i>AWS AppConfig User Guide</i>.

        :param self:
        :param Tags:  Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.<br/>Validators:  A list of methods for validating the configuration.<br/>RetrievalRoleArn:  The ARN of an IAM role with permission to access the configuration at the specified LocationUri.<br/>LocationUri:  A URI to locate the configuration. You can specify a Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For an SSM document, specify either the document name in the format <code>ssm-document://&lt;Document_name&gt;</code> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format <code>ssm-parameter://&lt;Parameter_name&gt;</code> or the ARN. For an Amazon S3 object, specify the URI in the following format: <code>s3://&lt;bucket&gt;/&lt;objectKey&gt; </code>. Here is an example: s3://my-bucket/my-app/us-east-1/my-config.json<br/>Description:  A description of the configuration profile.<br/>Name:  A name for the configuration profile.<br/>ApplicationId:  The application ID.<br/>
        :return: Validators:  A list of methods for validating the configuration.<br/>RetrievalRoleArn:  The ARN of an IAM role with permission to access the configuration at the specified LocationUri.<br/>LocationUri:  The URI location of the configuration.<br/>Description:  The configuration profile description.<br/>Name:  The name of the configuration profile.<br/>Id:  The configuration profile ID.<br/>ApplicationId:  The application ID.<br/>        """
        pass

    def create_deployment_strategy(self, ReplicateTo: str, GrowthFactor: GrowthFactor, DeploymentDurationInMinutes: int, Name: str, Description: str=None, FinalBakeTimeInMinutes: int=None, GrowthType: str=None, Tags: TagMap=None) -> DeploymentStrategy:
        r"""A deployment strategy defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes: the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.

        :param self:
        :param Tags:  Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.<br/>ReplicateTo:  Save the deployment strategy to a Systems Manager (SSM) document.<br/>GrowthType:  The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:  <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.  <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:  <code>2*(2^0)</code>   <code>2*(2^1)</code>   <code>2*(2^2)</code>  Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.<br/>GrowthFactor:  The percentage of targets to receive a deployed configuration during each interval.<br/>FinalBakeTimeInMinutes:  The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.<br/>DeploymentDurationInMinutes:  Total amount of time for a deployment to last.<br/>Description:  A description of the deployment strategy.<br/>Name:  A name for the deployment strategy.<br/>
        :return: ReplicateTo:  Save the deployment strategy to a Systems Manager (SSM) document.<br/>FinalBakeTimeInMinutes:  The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.<br/>GrowthFactor:  The percentage of targets that received a deployed configuration during each interval.<br/>GrowthType:  The algorithm used to define how percentage grew over time.<br/>DeploymentDurationInMinutes:  Total amount of time the deployment lasted.<br/>Description:  The description of the deployment strategy.<br/>Name:  The name of the deployment strategy.<br/>Id:  The deployment strategy ID.<br/>        """
        pass

    def create_environment(self, Name: str, ApplicationId: str, Description: str=None, Monitors: List[Monitor]=None, Tags: TagMap=None) -> Environment:
        r"""For each application, you define one or more environments. An environment is a logical deployment group of AppConfig targets, such as applications in a <code>Beta</code> or <code>Production</code> environment. You can also define environments for application subcomponents such as the <code>Web</code>, <code>Mobile</code> and <code>Back-end</code> components for your application. You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system rolls back the configuration.

        :param self:
        :param Tags:  Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.<br/>Monitors:  Amazon CloudWatch alarms to monitor during the deployment process.<br/>Description:  A description of the environment.<br/>Name:  A name for the environment.<br/>ApplicationId:  The application ID.<br/>
        :return: Monitors:  Amazon CloudWatch alarms monitored during the deployment.<br/>State:  The state of the environment. An environment can be in one of the following states: <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or <code>ROLLED_BACK</code> <br/>Description:  The description of the environment.<br/>Name:  The name of the environment.<br/>Id:  The environment ID.<br/>ApplicationId:  The application ID.<br/>        """
        pass

    def delete_application(self, ApplicationId: str):
        r"""Delete an application. Deleting an application does not delete a configuration from a host.

        :param self:
        :param ApplicationId:  The ID of the application to delete.<br/>
        :return:         """
        pass

    def delete_configuration_profile(self, ConfigurationProfileId: str, ApplicationId: str):
        r"""Delete a configuration profile. Deleting a configuration profile does not delete a configuration from a host.

        :param self:
        :param ConfigurationProfileId:  The ID of the configuration profile you want to delete.<br/>ApplicationId:  The application ID that includes the configuration profile you want to delete.<br/>
        :return:         """
        pass

    def delete_deployment_strategy(self, DeploymentStrategyId: str):
        r"""Delete a deployment strategy. Deleting a deployment strategy does not delete a configuration from a host.

        :param self:
        :param DeploymentStrategyId:  The ID of the deployment strategy you want to delete.<br/>
        :return:         """
        pass

    def delete_environment(self, EnvironmentId: str, ApplicationId: str):
        r"""Delete an environment. Deleting an environment does not delete a configuration from a host.

        :param self:
        :param EnvironmentId:  The ID of the environment you want to delete.<br/>ApplicationId:  The application ID that includes the environment you want to delete.<br/>
        :return:         """
        pass

    def get_application(self, ApplicationId: str) -> Application:
        r"""Retrieve information about an application.

        :param self:
        :param ApplicationId:  The ID of the application you want to get.<br/>
        :return: Description:  The description of the application.<br/>Name:  The application name.<br/>Id:  The application ID.<br/>        """
        pass

    def get_configuration(self, ClientId: str, Configuration: str, Environment: str, Application: str, ClientConfigurationVersion: str=None) -> Configuration:
        r"""Receive information about a configuration. <important> AWS AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration. To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter.  </important>

        :param self:
        :param ClientConfigurationVersion:  The configuration version returned in the most recent <code>GetConfiguration</code> response. <important> AWS AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration. To avoid excess charges, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. This value must be saved on your client. Subsequent calls to <code>GetConfiguration</code> must pass this value by using the <code>ClientConfigurationVersion</code> parameter.  </important> For more information about working with configurations, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AWS AppConfig User Guide</i>.<br/>ClientId:  A unique ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy.<br/>Configuration:  The configuration to get. Specify either the configuration name or the configuration ID.<br/>Environment:  The environment to get. Specify either the environment name or the environment ID.<br/>Application:  The application to get. Specify either the application name or the application ID.<br/>
        :return: ContentType:  A standard MIME type describing the format of the configuration content. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.<br/>ConfigurationVersion:  The configuration version.<br/>Content:  The content of the configuration or the configuration data.<br/>        """
        pass

    def get_configuration_profile(self, ConfigurationProfileId: str, ApplicationId: str) -> ConfigurationProfile:
        r"""Retrieve information about a configuration profile.

        :param self:
        :param ConfigurationProfileId:  The ID of the configuration profile you want to get.<br/>ApplicationId:  The ID of the application that includes the configuration profile you want to get.<br/>
        :return: Validators:  A list of methods for validating the configuration.<br/>RetrievalRoleArn:  The ARN of an IAM role with permission to access the configuration at the specified LocationUri.<br/>LocationUri:  The URI location of the configuration.<br/>Description:  The configuration profile description.<br/>Name:  The name of the configuration profile.<br/>Id:  The configuration profile ID.<br/>ApplicationId:  The application ID.<br/>        """
        pass

    def get_deployment(self, DeploymentNumber: int, EnvironmentId: str, ApplicationId: str) -> Deployment:
        r"""Retrieve information about a configuration deployment.

        :param self:
        :param DeploymentNumber:  The sequence number of the deployment.<br/>EnvironmentId:  The ID of the environment that includes the deployment you want to get. <br/>ApplicationId:  The ID of the application that includes the deployment you want to get. <br/>
        :return: CompletedAt:  The time the deployment completed. <br/>StartedAt:  The time the deployment started.<br/>PercentageComplete:  The percentage of targets for which the deployment is available.<br/>EventLog:  A list containing all events related to a deployment. The most recent events are displayed first.<br/>State:  The state of the deployment.<br/>FinalBakeTimeInMinutes:  The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.<br/>GrowthFactor:  The percentage of targets to receive a deployed configuration during each interval.<br/>GrowthType:  The algorithm used to define how percentage grew over time.<br/>DeploymentDurationInMinutes:  Total amount of time the deployment lasted.<br/>Description:  The description of the deployment.<br/>ConfigurationVersion:  The configuration version that was deployed.<br/>ConfigurationLocationUri:  Information about the source location of the configuration.<br/>ConfigurationName:  The name of the configuration.<br/>DeploymentNumber:  The sequence number of the deployment.<br/>ConfigurationProfileId:  The ID of the configuration profile that was deployed.<br/>DeploymentStrategyId:  The ID of the deployment strategy that was deployed.<br/>EnvironmentId:  The ID of the environment that was deployed.<br/>ApplicationId:  The ID of the application that was deployed.<br/>        """
        pass

    def get_deployment_strategy(self, DeploymentStrategyId: str) -> DeploymentStrategy:
        r"""Retrieve information about a deployment strategy. A deployment strategy defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes: the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.

        :param self:
        :param DeploymentStrategyId:  The ID of the deployment strategy to get.<br/>
        :return: ReplicateTo:  Save the deployment strategy to a Systems Manager (SSM) document.<br/>FinalBakeTimeInMinutes:  The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.<br/>GrowthFactor:  The percentage of targets that received a deployed configuration during each interval.<br/>GrowthType:  The algorithm used to define how percentage grew over time.<br/>DeploymentDurationInMinutes:  Total amount of time the deployment lasted.<br/>Description:  The description of the deployment strategy.<br/>Name:  The name of the deployment strategy.<br/>Id:  The deployment strategy ID.<br/>        """
        pass

    def get_environment(self, EnvironmentId: str, ApplicationId: str) -> Environment:
        r"""Retrieve information about an environment. An environment is a logical deployment group of AppConfig applications, such as applications in a <code>Production</code> environment or in an <code>EU_Region</code> environment. Each configuration deployment targets an environment. You can enable one or more Amazon CloudWatch alarms for an environment. If an alarm is triggered during a deployment, AppConfig roles back the configuration.

        :param self:
        :param EnvironmentId:  The ID of the environment you wnat to get.<br/>ApplicationId:  The ID of the application that includes the environment you want to get.<br/>
        :return: Monitors:  Amazon CloudWatch alarms monitored during the deployment.<br/>State:  The state of the environment. An environment can be in one of the following states: <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or <code>ROLLED_BACK</code> <br/>Description:  The description of the environment.<br/>Name:  The name of the environment.<br/>Id:  The environment ID.<br/>ApplicationId:  The application ID.<br/>        """
        pass

    def list_applications(self, MaxResults: int=None, NextToken: str=None) -> Applications:
        r"""List all applications in your AWS account.

        :param self:
        :param NextToken:  A token to start the list. Use this token to get the next set of results.<br/>MaxResults:  The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.<br/>
        :return: NextToken:  The token for the next set of items to return. Use this token to get the next set of results.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def list_configuration_profiles(self, ApplicationId: str, MaxResults: int=None, NextToken: str=None) -> ConfigurationProfiles:
        r"""Lists the configuration profiles for an application.

        :param self:
        :param NextToken:  A token to start the list. Use this token to get the next set of results.<br/>MaxResults:  The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.<br/>ApplicationId:  The application ID.<br/>
        :return: NextToken:  The token for the next set of items to return. Use this token to get the next set of results.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def list_deployment_strategies(self, MaxResults: int=None, NextToken: str=None) -> DeploymentStrategies:
        r"""List deployment strategies.

        :param self:
        :param NextToken:  A token to start the list. Use this token to get the next set of results.<br/>MaxResults:  The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.<br/>
        :return: NextToken:  The token for the next set of items to return. Use this token to get the next set of results.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def list_deployments(self, EnvironmentId: str, ApplicationId: str, MaxResults: int=None, NextToken: str=None) -> Deployments:
        r"""Lists the deployments for an environment.

        :param self:
        :param NextToken:  A token to start the list. Use this token to get the next set of results.<br/>MaxResults:  The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.<br/>EnvironmentId:  The environment ID.<br/>ApplicationId:  The application ID.<br/>
        :return: NextToken:  The token for the next set of items to return. Use this token to get the next set of results.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def list_environments(self, ApplicationId: str, MaxResults: int=None, NextToken: str=None) -> Environments:
        r"""List the environments for an application.

        :param self:
        :param NextToken:  A token to start the list. Use this token to get the next set of results.<br/>MaxResults:  The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.<br/>ApplicationId:  The application ID.<br/>
        :return: NextToken:  The token for the next set of items to return. Use this token to get the next set of results.<br/>Items:  The elements from this collection.<br/>        """
        pass

    def list_tags_for_resource(self, ResourceArn: str) -> ResourceTags:
        r"""Retrieves the list of key-value tags assigned to the resource.

        :param self:
        :param ResourceArn:  The resource ARN.<br/>
        :return: Tags:  Metadata to assign to AppConfig resources. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.<br/>        """
        pass

    def start_deployment(self, ConfigurationVersion: str, ConfigurationProfileId: str, DeploymentStrategyId: str, EnvironmentId: str, ApplicationId: str, Description: str=None, Tags: TagMap=None) -> Deployment:
        r"""Starts a deployment.

        :param self:
        :param Tags:  Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.<br/>Description:  A description of the deployment.<br/>ConfigurationVersion:  The configuration version to deploy.<br/>ConfigurationProfileId:  The configuration profile ID.<br/>DeploymentStrategyId:  The deployment strategy ID.<br/>EnvironmentId:  The environment ID.<br/>ApplicationId:  The application ID.<br/>
        :return: CompletedAt:  The time the deployment completed. <br/>StartedAt:  The time the deployment started.<br/>PercentageComplete:  The percentage of targets for which the deployment is available.<br/>EventLog:  A list containing all events related to a deployment. The most recent events are displayed first.<br/>State:  The state of the deployment.<br/>FinalBakeTimeInMinutes:  The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.<br/>GrowthFactor:  The percentage of targets to receive a deployed configuration during each interval.<br/>GrowthType:  The algorithm used to define how percentage grew over time.<br/>DeploymentDurationInMinutes:  Total amount of time the deployment lasted.<br/>Description:  The description of the deployment.<br/>ConfigurationVersion:  The configuration version that was deployed.<br/>ConfigurationLocationUri:  Information about the source location of the configuration.<br/>ConfigurationName:  The name of the configuration.<br/>DeploymentNumber:  The sequence number of the deployment.<br/>ConfigurationProfileId:  The ID of the configuration profile that was deployed.<br/>DeploymentStrategyId:  The ID of the deployment strategy that was deployed.<br/>EnvironmentId:  The ID of the environment that was deployed.<br/>ApplicationId:  The ID of the application that was deployed.<br/>        """
        pass

    def stop_deployment(self, DeploymentNumber: int, EnvironmentId: str, ApplicationId: str) -> Deployment:
        r"""Stops a deployment. This API action works only on deployments that have a status of <code>DEPLOYING</code>. This action moves the deployment to a status of <code>ROLLED_BACK</code>.

        :param self:
        :param DeploymentNumber:  The sequence number of the deployment.<br/>EnvironmentId:  The environment ID.<br/>ApplicationId:  The application ID.<br/>
        :return: CompletedAt:  The time the deployment completed. <br/>StartedAt:  The time the deployment started.<br/>PercentageComplete:  The percentage of targets for which the deployment is available.<br/>EventLog:  A list containing all events related to a deployment. The most recent events are displayed first.<br/>State:  The state of the deployment.<br/>FinalBakeTimeInMinutes:  The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.<br/>GrowthFactor:  The percentage of targets to receive a deployed configuration during each interval.<br/>GrowthType:  The algorithm used to define how percentage grew over time.<br/>DeploymentDurationInMinutes:  Total amount of time the deployment lasted.<br/>Description:  The description of the deployment.<br/>ConfigurationVersion:  The configuration version that was deployed.<br/>ConfigurationLocationUri:  Information about the source location of the configuration.<br/>ConfigurationName:  The name of the configuration.<br/>DeploymentNumber:  The sequence number of the deployment.<br/>ConfigurationProfileId:  The ID of the configuration profile that was deployed.<br/>DeploymentStrategyId:  The ID of the deployment strategy that was deployed.<br/>EnvironmentId:  The ID of the environment that was deployed.<br/>ApplicationId:  The ID of the application that was deployed.<br/>        """
        pass

    def tag_resource(self, Tags: TagMap, ResourceArn: str):
        r"""Metadata to assign to an AppConfig resource. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.

        :param self:
        :param Tags:  The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.<br/>ResourceArn:  The ARN of the resource for which to retrieve tags.<br/>
        :return:         """
        pass

    def untag_resource(self, TagKeys: List[TagKey], ResourceArn: str):
        r"""Deletes a tag key and value from an AppConfig resource.

        :param self:
        :param TagKeys:  The tag keys to delete.<br/>ResourceArn:  The ARN of the resource for which to remove tags.<br/>
        :return:         """
        pass

    def update_application(self, ApplicationId: str, Name: str=None, Description: str=None) -> Application:
        r"""Updates an application.

        :param self:
        :param Description:  A description of the application.<br/>Name:  The name of the application.<br/>ApplicationId:  The application ID.<br/>
        :return: Description:  The description of the application.<br/>Name:  The application name.<br/>Id:  The application ID.<br/>        """
        pass

    def update_configuration_profile(self, ConfigurationProfileId: str, ApplicationId: str, Name: str=None, Description: str=None, RetrievalRoleArn: str=None, Validators: List[Validator]=None) -> ConfigurationProfile:
        r"""Updates a configuration profile.

        :param self:
        :param Validators:  A list of methods for validating the configuration.<br/>RetrievalRoleArn:  The ARN of an IAM role with permission to access the configuration at the specified LocationUri.<br/>Description:  A description of the configuration profile.<br/>Name:  The name of the configuration profile.<br/>ConfigurationProfileId:  The ID of the configuration profile.<br/>ApplicationId:  The application ID.<br/>
        :return: Validators:  A list of methods for validating the configuration.<br/>RetrievalRoleArn:  The ARN of an IAM role with permission to access the configuration at the specified LocationUri.<br/>LocationUri:  The URI location of the configuration.<br/>Description:  The configuration profile description.<br/>Name:  The name of the configuration profile.<br/>Id:  The configuration profile ID.<br/>ApplicationId:  The application ID.<br/>        """
        pass

    def update_deployment_strategy(self, DeploymentStrategyId: str, Description: str=None, DeploymentDurationInMinutes: int=None, FinalBakeTimeInMinutes: int=None, GrowthFactor: GrowthFactor=None, GrowthType: str=None) -> DeploymentStrategy:
        r"""Updates a deployment strategy.

        :param self:
        :param GrowthType:  The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:  <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.  <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:  <code>2*(2^0)</code>   <code>2*(2^1)</code>   <code>2*(2^2)</code>  Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.<br/>GrowthFactor:  The percentage of targets to receive a deployed configuration during each interval.<br/>FinalBakeTimeInMinutes:  The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.<br/>DeploymentDurationInMinutes:  Total amount of time for a deployment to last.<br/>Description:  A description of the deployment strategy.<br/>DeploymentStrategyId:  The deployment strategy ID.<br/>
        :return: ReplicateTo:  Save the deployment strategy to a Systems Manager (SSM) document.<br/>FinalBakeTimeInMinutes:  The amount of time AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic roll back.<br/>GrowthFactor:  The percentage of targets that received a deployed configuration during each interval.<br/>GrowthType:  The algorithm used to define how percentage grew over time.<br/>DeploymentDurationInMinutes:  Total amount of time the deployment lasted.<br/>Description:  The description of the deployment strategy.<br/>Name:  The name of the deployment strategy.<br/>Id:  The deployment strategy ID.<br/>        """
        pass

    def update_environment(self, EnvironmentId: str, ApplicationId: str, Name: str=None, Description: str=None, Monitors: List[Monitor]=None) -> Environment:
        r"""Updates an environment.

        :param self:
        :param Monitors:  Amazon CloudWatch alarms to monitor during the deployment process.<br/>Description:  A description of the environment.<br/>Name:  The name of the environment.<br/>EnvironmentId:  The environment ID.<br/>ApplicationId:  The application ID.<br/>
        :return: Monitors:  Amazon CloudWatch alarms monitored during the deployment.<br/>State:  The state of the environment. An environment can be in one of the following states: <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or <code>ROLLED_BACK</code> <br/>Description:  The description of the environment.<br/>Name:  The name of the environment.<br/>Id:  The environment ID.<br/>ApplicationId:  The application ID.<br/>        """
        pass

    def validate_configuration(self, ConfigurationVersion: str, ConfigurationProfileId: str, ApplicationId: str):
        r"""Uses the validators in a configuration profile to validate a configuration.

        :param self:
        :param ConfigurationVersion:  The version of the configuration to validate.<br/>ConfigurationProfileId:  The configuration profile ID.<br/>ApplicationId:  The application ID.<br/>
        :return:         """
        pass



class ApplicationAutoScaling(BaseClient):
    r"""With Application Auto Scaling, you can configure automatic scaling for the following resources: <ul> <li> Amazon ECS services </li> <li> Amazon EC2 Spot Fleet requests </li> <li> Amazon EMR clusters </li> <li> Amazon AppStream 2.0 fleets </li> <li> Amazon DynamoDB tables and global secondary indexes throughput capacity </li> <li> Amazon Aurora Replicas </li> <li> Amazon SageMaker endpoint variants </li> <li> Custom resources provided by your own applications or services </li> <li> Amazon Comprehend document classification endpoints </li> <li> AWS Lambda function provisioned concurrency </li> <li> Amazon Keyspaces (for Apache Cassandra) tables </li> </ul>  <b>API Summary</b>  The Application Auto Scaling service API includes three key sets of actions:  <ul> <li> Register and manage scalable targets - Register AWS or custom resources as scalable targets (a resource that Application Auto Scaling can scale), set minimum and maximum capacity limits, and retrieve information on existing scalable targets. </li> <li> Configure and manage automatic scaling - Define scaling policies to dynamically scale your resources in response to CloudWatch alarms, schedule one-time or recurring scaling actions, and retrieve your recent scaling activity history. </li> <li> Suspend and resume scaling - Temporarily suspend and later resume automatic scaling by calling the <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html">RegisterScalableTarget</a> API action for any Application Auto Scaling scalable target. You can suspend and resume (individually or in combination) scale-out activities that are triggered by a scaling policy, scale-in activities that are triggered by a scaling policy, and scheduled scaling. </li> </ul> To learn more about Application Auto Scaling, including information about granting IAM users required permissions for Application Auto Scaling actions, see the <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html">Application Auto Scaling User Guide</a>."""


    class DescribeScalableTargetsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_scalable_targets` for valid parameters"""
            pass
    class DescribeScalingActivitiesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_scaling_activities` for valid parameters"""
            pass
    class DescribeScalingPoliciesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_scaling_policies` for valid parameters"""
            pass
    class DescribeScheduledActionsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_scheduled_actions` for valid parameters"""
            pass


    class DeleteScalingPolicyRequest(Mapping):
        pass
    
    class DeleteScalingPolicyResponse(Mapping):
        pass
    
    class DeleteScheduledActionRequest(Mapping):
        pass
    
    class DeleteScheduledActionResponse(Mapping):
        pass
    
    class DeregisterScalableTargetRequest(Mapping):
        pass
    
    class DeregisterScalableTargetResponse(Mapping):
        pass
    
    class DescribeScalableTargetsRequest(Mapping):
        pass
    
    class DescribeScalableTargetsResponse(Mapping):
        pass
    
    class ResourceIdMaxLen1600(object):
        pass
    
    class DescribeScalingActivitiesRequest(Mapping):
        pass
    
    class DescribeScalingActivitiesResponse(Mapping):
        pass
    
    class DescribeScalingPoliciesRequest(Mapping):
        pass
    
    class DescribeScalingPoliciesResponse(Mapping):
        pass
    
    class DescribeScheduledActionsRequest(Mapping):
        pass
    
    class DescribeScheduledActionsResponse(Mapping):
        pass
    
    class PutScalingPolicyRequest(Mapping):
        pass
    
    class PutScalingPolicyResponse(Mapping):
        pass
    
    class StepScalingPolicyConfiguration(Mapping):
        pass
    
    class TargetTrackingScalingPolicyConfiguration(Mapping):
        pass
    
    class PutScheduledActionRequest(Mapping):
        pass
    
    class PutScheduledActionResponse(Mapping):
        pass
    
    class TimestampType(object):
        pass
    
    class ScalableTargetAction(Mapping):
        pass
    
    class RegisterScalableTargetRequest(Mapping):
        pass
    
    class RegisterScalableTargetResponse(Mapping):
        pass
    
    class SuspendedState(Mapping):
        pass
    
    def delete_scaling_policy(self, ScalableDimension: str, ResourceId: str, ServiceNamespace: str, PolicyName: str) -> DeleteScalingPolicyResponse:
        r"""Deletes the specified scaling policy for an Application Auto Scaling scalable target. Deleting a step scaling policy deletes the underlying alarm action, but does not delete the CloudWatch alarm associated with the scaling policy, even if it no longer has an associated action. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#delete-step-scaling-policy">Delete a Step Scaling Policy</a> and <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#delete-target-tracking-policy">Delete a Target Tracking Scaling Policy</a> in the <i>Application Auto Scaling User Guide</i>.

        :param self:
        :param ScalableDimension:  The scalable dimension. This string consists of the service namespace, resource type, and scaling property. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>PolicyName:  The name of the scaling policy.<br/>
        :return:         """
        pass

    def delete_scheduled_action(self, ScalableDimension: str, ResourceId: str, ScheduledActionName: str, ServiceNamespace: str) -> DeleteScheduledActionResponse:
        r"""Deletes the specified scheduled action for an Application Auto Scaling scalable target. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html#delete-scheduled-action">Delete a Scheduled Action</a> in the <i>Application Auto Scaling User Guide</i>.

        :param self:
        :param ScalableDimension:  The scalable dimension. This string consists of the service namespace, resource type, and scaling property. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource associated with the scheduled action. This string consists of the resource type and unique identifier. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ScheduledActionName:  The name of the scheduled action.<br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>
        :return:         """
        pass

    def deregister_scalable_target(self, ScalableDimension: str, ResourceId: str, ServiceNamespace: str) -> DeregisterScalableTargetResponse:
        r"""Deregisters an Application Auto Scaling scalable target when you have finished using it. To see which resources have been registered, use <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html">DescribeScalableTargets</a>.  <note> Deregistering a scalable target deletes the scaling policies and the scheduled actions that are associated with it. </note>

        :param self:
        :param ScalableDimension:  The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>
        :return:         """
        pass

    def describe_scalable_targets(self, ServiceNamespace: str, ResourceIds: List[ResourceIdMaxLen1600]=None, ScalableDimension: str=None, MaxResults: int=None, NextToken: str=None) -> DescribeScalableTargetsResponse:
        r"""Gets information about the scalable targets in the specified namespace. You can filter the results using <code>ResourceIds</code> and <code>ScalableDimension</code>.

        :param self:
        :param NextToken:  The token for the next set of results.<br/>MaxResults:  The maximum number of scalable targets. This value can be between 1 and 50. The default value is 50. If this parameter is used, the operation returns up to <code>MaxResults</code> results at a time, along with a <code>NextToken</code> value. To get the next set of results, include the <code>NextToken</code> value in a subsequent call. If this parameter is not used, the operation returns up to 50 results and a <code>NextToken</code> value, if applicable.<br/>ScalableDimension:  The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource ID. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceIds:  The identifier of the resource associated with the scalable target. This string consists of the resource type and unique identifier. If you specify a scalable dimension, you must also specify a resource ID. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>
        :return: NextToken:  The token required to get the next set of results. This value is <code>null</code> if there are no more results to return.<br/>ScalableTargets:  The scalable targets that match the request parameters.<br/>        """
        pass

    def describe_scaling_activities(self, ServiceNamespace: str, ResourceId: str=None, ScalableDimension: str=None, MaxResults: int=None, NextToken: str=None) -> DescribeScalingActivitiesResponse:
        r"""Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks. You can filter the results using <code>ResourceId</code> and <code>ScalableDimension</code>.

        :param self:
        :param NextToken:  The token for the next set of results.<br/>MaxResults:  The maximum number of scalable targets. This value can be between 1 and 50. The default value is 50. If this parameter is used, the operation returns up to <code>MaxResults</code> results at a time, along with a <code>NextToken</code> value. To get the next set of results, include the <code>NextToken</code> value in a subsequent call. If this parameter is not used, the operation returns up to 50 results and a <code>NextToken</code> value, if applicable.<br/>ScalableDimension:  The scalable dimension. This string consists of the service namespace, resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource ID. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource associated with the scaling activity. This string consists of the resource type and unique identifier. If you specify a scalable dimension, you must also specify a resource ID. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>
        :return: NextToken:  The token required to get the next set of results. This value is <code>null</code> if there are no more results to return.<br/>ScalingActivities:  A list of scaling activity objects.<br/>        """
        pass

    def describe_scaling_policies(self, ServiceNamespace: str, PolicyNames: List[ResourceIdMaxLen1600]=None, ResourceId: str=None, ScalableDimension: str=None, MaxResults: int=None, NextToken: str=None) -> DescribeScalingPoliciesResponse:
        r"""Describes the Application Auto Scaling scaling policies for the specified service namespace. You can filter the results using <code>ResourceId</code>, <code>ScalableDimension</code>, and <code>PolicyNames</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">Target Tracking Scaling Policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html">Step Scaling Policies</a> in the <i>Application Auto Scaling User Guide</i>.

        :param self:
        :param NextToken:  The token for the next set of results.<br/>MaxResults:  The maximum number of scalable targets. This value can be between 1 and 50. The default value is 50. If this parameter is used, the operation returns up to <code>MaxResults</code> results at a time, along with a <code>NextToken</code> value. To get the next set of results, include the <code>NextToken</code> value in a subsequent call. If this parameter is not used, the operation returns up to 50 results and a <code>NextToken</code> value, if applicable.<br/>ScalableDimension:  The scalable dimension. This string consists of the service namespace, resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource ID. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier. If you specify a scalable dimension, you must also specify a resource ID. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>PolicyNames:  The names of the scaling policies to describe.<br/>
        :return: NextToken:  The token required to get the next set of results. This value is <code>null</code> if there are no more results to return.<br/>ScalingPolicies:  Information about the scaling policies.<br/>        """
        pass

    def describe_scheduled_actions(self, ServiceNamespace: str, ScheduledActionNames: List[ResourceIdMaxLen1600]=None, ResourceId: str=None, ScalableDimension: str=None, MaxResults: int=None, NextToken: str=None) -> DescribeScheduledActionsResponse:
        r"""Describes the Application Auto Scaling scheduled actions for the specified service namespace. You can filter the results using the <code>ResourceId</code>, <code>ScalableDimension</code>, and <code>ScheduledActionNames</code> parameters. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html">Scheduled Scaling</a> in the <i>Application Auto Scaling User Guide</i>.

        :param self:
        :param NextToken:  The token for the next set of results.<br/>MaxResults:  The maximum number of scheduled action results. This value can be between 1 and 50. The default value is 50. If this parameter is used, the operation returns up to <code>MaxResults</code> results at a time, along with a <code>NextToken</code> value. To get the next set of results, include the <code>NextToken</code> value in a subsequent call. If this parameter is not used, the operation returns up to 50 results and a <code>NextToken</code> value, if applicable.<br/>ScalableDimension:  The scalable dimension. This string consists of the service namespace, resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource ID. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource associated with the scheduled action. This string consists of the resource type and unique identifier. If you specify a scalable dimension, you must also specify a resource ID. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>ScheduledActionNames:  The names of the scheduled actions to describe.<br/>
        :return: NextToken:  The token required to get the next set of results. This value is <code>null</code> if there are no more results to return.<br/>ScheduledActions:  Information about the scheduled actions.<br/>        """
        pass

    def put_scaling_policy(self, ScalableDimension: str, ResourceId: str, ServiceNamespace: str, PolicyName: str, PolicyType: str=None, StepScalingPolicyConfiguration: StepScalingPolicyConfiguration=None, TargetTrackingScalingPolicyConfiguration: TargetTrackingScalingPolicyConfiguration=None) -> PutScalingPolicyResponse:
        r"""Creates or updates a scaling policy for an Application Auto Scaling scalable target. Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scaling policy applies to the scalable target identified by those three attributes. You cannot create a scaling policy until you have registered the resource as a scalable target. Multiple scaling policies can be in force at the same time for the same scalable target. You can have one or more target tracking scaling policies, one or more step scaling policies, or both. However, there is a chance that multiple policies could conflict, instructing the scalable target to scale out or in at the same time. Application Auto Scaling gives precedence to the policy that provides the largest capacity for both scale out and scale in. For example, if one policy increases capacity by 3, another policy increases capacity by 200 percent, and the current capacity is 10, Application Auto Scaling uses the policy with the highest calculated capacity (200% of 10 = 20) and scales out to 30.  We recommend caution, however, when using target tracking scaling policies with step scaling policies because conflicts between these policies can cause undesirable behavior. For example, if the step scaling policy initiates a scale-in activity before the target tracking policy is ready to scale in, the scale-in activity will not be blocked. After the scale-in activity completes, the target tracking policy could instruct the scalable target to scale out again.  For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">Target Tracking Scaling Policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html">Step Scaling Policies</a> in the <i>Application Auto Scaling User Guide</i>. <note> If a scalable target is deregistered, the scalable target is no longer available to execute scaling policies. Any scaling policies that were specified for the scalable target are deleted. </note>

        :param self:
        :param TargetTrackingScalingPolicyConfiguration:  A target tracking scaling policy. Includes support for predefined or customized metrics. This parameter is required if you are creating a policy and the policy type is <code>TargetTrackingScaling</code>.:<br/>StepScalingPolicyConfiguration:  A step scaling policy. This parameter is required if you are creating a policy and the policy type is <code>StepScaling</code>.:<br/>PolicyType:  The policy type. This parameter is required if you are creating a scaling policy. The following policy types are supported:   <code>TargetTrackingScaling</code>—Not supported for Amazon EMR  <code>StepScaling</code>—Not supported for DynamoDB, Amazon Comprehend, Lambda, or Amazon Keyspaces (for Apache Cassandra). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">Target Tracking Scaling Policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html">Step Scaling Policies</a> in the <i>Application Auto Scaling User Guide</i>.<br/>ScalableDimension:  The scalable dimension. This string consists of the service namespace, resource type, and scaling property. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource associated with the scaling policy. This string consists of the resource type and unique identifier. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>PolicyName:  The name of the scaling policy.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MetricAggregationType</i> The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Cooldown</i> The amount of time, in seconds, to wait for a previous scaling activity to take effect. With scale-out policies, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a step scaling policy, it starts to calculate the cooldown time. While the cooldown period is in effect, capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity. For example, when an alarm triggers a step scaling policy to increase the capacity by 2, the scaling activity completes successfully, and a cooldown period starts. If the alarm triggers again during the cooldown period but at a more aggressive step adjustment of 3, the previous increase of 2 is considered part of the current capacity. Therefore, only 1 is added to the capacity. With scale-in policies, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the cooldown period after a scale-in activity, Application Auto Scaling scales out the target immediately. In this case, the cooldown period for the scale-in activity stops and doesn't complete. Application Auto Scaling provides a default value of 300 for the following scalable targets: <ul> <li> ECS services </li> <li> Spot Fleet requests </li> <li> EMR clusters </li> <li> AppStream 2.0 fleets </li> <li> Aurora DB clusters </li> <li> Amazon SageMaker endpoint variants </li> <li> Custom resources </li> </ul> For all other scalable targets, the default value is 0: <ul> <li> DynamoDB tables </li> <li> DynamoDB global secondary indexes </li> <li> Amazon Comprehend document classification endpoints </li> <li> Lambda provisioned concurrency </li> <li> Amazon Keyspaces tables </li> </ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MinAdjustmentMagnitude</i> The minimum value to scale by when scaling by percentages. For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks. Valid only if the adjustment type is <code>PercentChangeInCapacity</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>StepAdjustments</i> A set of adjustments that enable you to scale based on the size of the alarm breach. At least one step adjustment is required if you are adding a new step scaling policy configuration.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AdjustmentType</i> Specifies whether the <code>ScalingAdjustment</code> value in a <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html">StepAdjustment</a> is an absolute number or a percentage of the current capacity.   <code>AdjustmentType</code> is required if you are adding a new step scaling policy configuration.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DisableScaleIn</i> Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code>.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ScaleInCooldown</i> The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Application Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete. Application Auto Scaling provides a default value of 300 for the following scalable targets: <ul> <li> ECS services </li> <li> Spot Fleet requests </li> <li> EMR clusters </li> <li> AppStream 2.0 fleets </li> <li> Aurora DB clusters </li> <li> Amazon SageMaker endpoint variants </li> <li> Custom resources </li> </ul> For all other scalable targets, the default value is 0: <ul> <li> DynamoDB tables </li> <li> DynamoDB global secondary indexes </li> <li> Amazon Comprehend document classification endpoints </li> <li> Lambda provisioned concurrency </li> <li> Amazon Keyspaces tables </li> </ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ScaleOutCooldown</i> The amount of time, in seconds, to wait for a previous scale-out activity to take effect. With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Application Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. While the scale-out cooldown period is in effect, the capacity added by the initiating scale-out activity is calculated as part of the desired capacity for the next scale-out activity. Application Auto Scaling provides a default value of 300 for the following scalable targets: <ul> <li> ECS services </li> <li> Spot Fleet requests </li> <li> EMR clusters </li> <li> AppStream 2.0 fleets </li> <li> Aurora DB clusters </li> <li> Amazon SageMaker endpoint variants </li> <li> Custom resources </li> </ul> For all other scalable targets, the default value is 0: <ul> <li> DynamoDB tables </li> <li> DynamoDB global secondary indexes </li> <li> Amazon Comprehend document classification endpoints </li> <li> Lambda provisioned concurrency </li> <li> Amazon Keyspaces tables </li> </ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CustomizedMetricSpecification</i> A customized metric. You can specify either a predefined metric or a customized metric.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>CustomizedMetricSpecification</b>: A customized metric. You can specify either a predefined metric or a customized metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PredefinedMetricSpecification</i> A predefined metric. You can specify either a predefined metric or a customized metric.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PredefinedMetricSpecification</b>: A predefined metric. You can specify either a predefined metric or a customized metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>TargetValue</i> The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>ResourceLabel</i> Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet request or ECS service. The format is app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt;, where: <ul> <li> app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN </li> <li> targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN. </li> </ul><br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>PredefinedMetricType</i> The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleet requests and ECS services.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Unit</i> The unit of the metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Statistic</i> The statistic of the metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Dimensions</i> The dimensions of the metric.  Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Namespace</i> The namespace of the metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>MetricName</i> The name of the metric. <br/>
        :return: Alarms:  The CloudWatch alarms created for the target tracking scaling policy.<br/>PolicyARN:  The Amazon Resource Name (ARN) of the resulting scaling policy.<br/>        """
        pass

    def put_scheduled_action(self, ScalableDimension: str, ResourceId: str, ScheduledActionName: str, ServiceNamespace: str, Schedule: str=None, StartTime: TimestampType=None, EndTime: TimestampType=None, ScalableTargetAction: ScalableTargetAction=None) -> PutScheduledActionResponse:
        r"""Creates or updates a scheduled action for an Application Auto Scaling scalable target. Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scheduled action applies to the scalable target identified by those three attributes. You cannot create a scheduled action until you have registered the resource as a scalable target. When start and end times are specified with a recurring schedule using a cron expression or rates, they form the boundaries of when the recurring action starts and stops. To update a scheduled action, specify the parameters that you want to change. If you don't specify start and end times, the old values are deleted. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html">Scheduled Scaling</a> in the <i>Application Auto Scaling User Guide</i>. <note> If a scalable target is deregistered, the scalable target is no longer available to run scheduled actions. Any scheduled actions that were specified for the scalable target are deleted. </note>

        :param self:
        :param ScalableTargetAction:  The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.:<br/>EndTime:  The date and time for the recurring schedule to end.<br/>StartTime:  The date and time for this scheduled action to start.<br/>ScalableDimension:  The scalable dimension. This string consists of the service namespace, resource type, and scaling property. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource associated with the scheduled action. This string consists of the resource type and unique identifier. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ScheduledActionName:  The name of the scheduled action. This name must be unique among all other scheduled actions on the specified scalable target. <br/>Schedule:  The schedule for this action. The following formats are supported: <ul> <li> At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>" </li> <li> Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>" </li> <li> Cron expressions - "<code>cron(<i>fields</i>)</code>" </li> </ul> At expressions are useful for one-time schedules. Specify the time in UTC. For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>. For more information about cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>. For examples of using these expressions, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html">Scheduled Scaling</a> in the <i>Application Auto Scaling User Guide</i>.<br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MaxCapacity</i> The maximum capacity.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MinCapacity</i> The minimum capacity. For Lambda provisioned concurrency, the minimum value allowed is 0. For all other resources, the minimum value allowed is 1.<br/>
        :return:         """
        pass

    def register_scalable_target(self, ScalableDimension: str, ResourceId: str, ServiceNamespace: str, MinCapacity: int=None, MaxCapacity: int=None, RoleARN: str=None, SuspendedState: SuspendedState=None) -> RegisterScalableTargetResponse:
        r"""Registers or updates a scalable target.  A scalable target is a resource that Application Auto Scaling can scale out and scale in. Scalable targets are uniquely identified by the combination of resource ID, scalable dimension, and namespace.  When you register a new scalable target, you must specify values for minimum and maximum capacity. Application Auto Scaling scaling policies will not scale capacity to values that are outside of this range. After you register a scalable target, you do not need to register it again to use other Application Auto Scaling operations. To see which resources have been registered, use <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html">DescribeScalableTargets</a>. You can also view the scaling policies for a service namespace by using <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html">DescribeScalableTargets</a>. If you no longer need a scalable target, you can deregister it by using <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html">DeregisterScalableTarget</a>. To update a scalable target, specify the parameters that you want to change. Include the parameters that identify the scalable target: resource ID, scalable dimension, and namespace. Any parameters that you don't specify are not changed by this update request. 

        :param self:
        :param SuspendedState:  An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling. Setting the value of an attribute to <code>true</code> suspends the specified scaling activities. Setting it to <code>false</code> (default) resumes the specified scaling activities.   <b>Suspension Outcomes</b>  <ul> <li> For <code>DynamicScalingInSuspended</code>, while a suspension is in effect, all scale-in activities that are triggered by a scaling policy are suspended. </li> <li> For <code>DynamicScalingOutSuspended</code>, while a suspension is in effect, all scale-out activities that are triggered by a scaling policy are suspended. </li> <li> For <code>ScheduledScalingSuspended</code>, while a suspension is in effect, all scaling activities that involve scheduled actions are suspended.  </li> </ul> For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html">Suspending and Resuming Scaling</a> in the <i>Application Auto Scaling User Guide</i>.:<br/>RoleARN:  This parameter is required for services that do not support service-linked roles (such as Amazon EMR), and it must specify the ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on your behalf.  If the service supports service-linked roles, Application Auto Scaling uses a service-linked role, which it creates if it does not yet exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles">Application Auto Scaling IAM Roles</a>.<br/>MaxCapacity:  The maximum value that you plan to scale out to. When a scaling policy is in effect, Application Auto Scaling can scale out (expand) as needed to the maximum capacity limit in response to changing demand.  This parameter is required if you are registering a scalable target.<br/>MinCapacity:  The minimum value that you plan to scale in to. When a scaling policy is in effect, Application Auto Scaling can scale in (contract) as needed to the minimum capacity limit in response to changing demand.  This parameter is required if you are registering a scalable target. For Lambda provisioned concurrency, the minimum value allowed is 0. For all other resources, the minimum value allowed is 1.<br/>ScalableDimension:  The scalable dimension associated with the scalable target. This string consists of the service namespace, resource type, and scaling property. <ul> <li>  <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service. </li> <li>  <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request. </li> <li>  <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group. </li> <li>  <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet. </li> <li>  <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table. </li> <li>  <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table. </li> <li>  <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index. </li> <li>  <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index. </li> <li>  <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition. </li> <li>  <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model endpoint variant. </li> <li>  <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service. </li> <li>  <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint. </li> <li>  <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function. </li> <li>  <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table. </li> <li>  <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table. </li> </ul><br/>ResourceId:  The identifier of the resource that is associated with the scalable target. This string consists of the resource type and unique identifier. <ul> <li> ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>. </li> <li> Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>. </li> <li> EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>. </li> <li> AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code>. </li> <li> DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code>. </li> <li> DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code>. </li> <li> Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>. </li> <li> Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>. </li> <li> Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>. </li> <li> Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>. </li> <li> Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>. </li> <li> Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code>. </li> </ul><br/>ServiceNamespace:  The namespace of the AWS service that provides the resource. For a resource provided by your own application or service, use <code>custom-resource</code> instead.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ScheduledScalingSuspended</i> Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DynamicScalingOutSuspended</i> Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is <code>false</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>DynamicScalingInSuspended</i> Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is <code>false</code>. <br/>
        :return:         """
        pass



class ApplicationInsights(BaseClient):
    r"""<fullname>Amazon CloudWatch Application Insights for .NET and SQL Server</fullname>  Amazon CloudWatch Application Insights for .NET and SQL Server is a service that helps you detect common problems with your .NET and SQL Server-based applications. It enables you to pinpoint the source of issues in your applications (built with technologies such as Microsoft IIS, .NET, and Microsoft SQL Server), by providing key insights into detected problems. After you onboard your application, CloudWatch Application Insights for .NET and SQL Server identifies, recommends, and sets up metrics and logs. It continuously analyzes and correlates your metrics and logs for unusual behavior to surface actionable problems with your application. For example, if your application is slow and unresponsive and leading to HTTP 500 errors in your Application Load Balancer (ALB), Application Insights informs you that a memory pressure problem with your SQL Server database is occurring. It bases this analysis on impactful metrics and log errors. """




    class CreateApplicationRequest(Mapping):
        pass
    
    class CreateApplicationResponse(Mapping):
        pass
    
    class OpsCenterEnabled(object):
        pass
    
    class CWEMonitorEnabled(object):
        pass
    
    class Tag(Mapping):
        pass
    
    class CreateComponentRequest(Mapping):
        pass
    
    class CreateComponentResponse(Mapping):
        pass
    
    class ResourceARN(object):
        pass
    
    class CreateLogPatternRequest(Mapping):
        pass
    
    class CreateLogPatternResponse(Mapping):
        pass
    
    class DeleteApplicationRequest(Mapping):
        pass
    
    class DeleteApplicationResponse(Mapping):
        pass
    
    class DeleteComponentRequest(Mapping):
        pass
    
    class DeleteComponentResponse(Mapping):
        pass
    
    class DeleteLogPatternRequest(Mapping):
        pass
    
    class DeleteLogPatternResponse(Mapping):
        pass
    
    class DescribeApplicationRequest(Mapping):
        pass
    
    class DescribeApplicationResponse(Mapping):
        pass
    
    class DescribeComponentRequest(Mapping):
        pass
    
    class DescribeComponentResponse(Mapping):
        pass
    
    class DescribeComponentConfigurationRequest(Mapping):
        pass
    
    class DescribeComponentConfigurationResponse(Mapping):
        pass
    
    class DescribeComponentConfigurationRecommendationRequest(Mapping):
        pass
    
    class DescribeComponentConfigurationRecommendationResponse(Mapping):
        pass
    
    class DescribeLogPatternRequest(Mapping):
        pass
    
    class DescribeLogPatternResponse(Mapping):
        pass
    
    class DescribeObservationRequest(Mapping):
        pass
    
    class DescribeObservationResponse(Mapping):
        pass
    
    class DescribeProblemRequest(Mapping):
        pass
    
    class DescribeProblemResponse(Mapping):
        pass
    
    class DescribeProblemObservationsRequest(Mapping):
        pass
    
    class DescribeProblemObservationsResponse(Mapping):
        pass
    
    class ListApplicationsRequest(Mapping):
        pass
    
    class ListApplicationsResponse(Mapping):
        pass
    
    class ListComponentsRequest(Mapping):
        pass
    
    class ListComponentsResponse(Mapping):
        pass
    
    class ListConfigurationHistoryRequest(Mapping):
        pass
    
    class ListConfigurationHistoryResponse(Mapping):
        pass
    
    class StartTime(object):
        pass
    
    class EndTime(object):
        pass
    
    class ListLogPatternSetsRequest(Mapping):
        pass
    
    class ListLogPatternSetsResponse(Mapping):
        pass
    
    class ListLogPatternsRequest(Mapping):
        pass
    
    class ListLogPatternsResponse(Mapping):
        pass
    
    class ListProblemsRequest(Mapping):
        pass
    
    class ListProblemsResponse(Mapping):
        pass
    
    class ListTagsForResourceRequest(Mapping):
        pass
    
    class ListTagsForResourceResponse(Mapping):
        pass
    
    class TagResourceRequest(Mapping):
        pass
    
    class TagResourceResponse(Mapping):
        pass
    
    class UntagResourceRequest(Mapping):
        pass
    
    class UntagResourceResponse(Mapping):
        pass
    
    class TagKey(object):
        pass
    
    class UpdateApplicationRequest(Mapping):
        pass
    
    class UpdateApplicationResponse(Mapping):
        pass
    
    class RemoveSNSTopic(object):
        pass
    
    class UpdateComponentRequest(Mapping):
        pass
    
    class UpdateComponentResponse(Mapping):
        pass
    
    class UpdateComponentConfigurationRequest(Mapping):
        pass
    
    class UpdateComponentConfigurationResponse(Mapping):
        pass
    
    class Monitor(object):
        pass
    
    class UpdateLogPatternRequest(Mapping):
        pass
    
    class UpdateLogPatternResponse(Mapping):
        pass
    
    def create_application(self, ResourceGroupName: str, OpsCenterEnabled: OpsCenterEnabled=None, CWEMonitorEnabled: CWEMonitorEnabled=None, OpsItemSNSTopicArn: str=None, Tags: List[Tag]=None) -> CreateApplicationResponse:
        r"""Adds an application that is created from a resource group.

        :param self:
        :param Tags:  List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.<br/>OpsItemSNSTopicArn:   The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem. <br/>CWEMonitorEnabled:   Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. <br/>OpsCenterEnabled:   When set to <code>true</code>, creates opsItems for any problems detected on an application. <br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: ApplicationInfo:  Information about the application.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Remarks</i> The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include: <ul> <li> “Configuring application, detected 1 Errors, 3 Warnings” </li> <li> “Configuring application, detected 1 Unconfigured Components” </li> </ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CWEMonitorEnabled</i>  Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OpsCenterEnabled</i>  Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OpsItemSNSTopicArn</i>  The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LifeCycle</i> The lifecycle of the application. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ResourceGroupName</i> The name of the resource group used for the application.<br/>        """
        pass

    def create_component(self, ResourceList: List[ResourceARN], ComponentName: str, ResourceGroupName: str) -> CreateComponentResponse:
        r"""Creates a custom component by grouping similar standalone instances to monitor.

        :param self:
        :param ResourceList:  The list of resource ARNs that belong to the component.<br/>ComponentName:  The name of the component.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return:         """
        pass

    def create_log_pattern(self, Rank: int, Pattern: str, PatternName: str, PatternSetName: str, ResourceGroupName: str) -> CreateLogPatternResponse:
        r"""Adds an log pattern to a <code>LogPatternSet</code>.

        :param self:
        :param Rank:  Rank of the log pattern.<br/>Pattern:  The log pattern.<br/>PatternName:  The name of the log pattern.<br/>PatternSetName:  The name of the log pattern set.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: ResourceGroupName:  The name of the resource group.<br/>LogPattern:  The successfully created log pattern.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Rank</i> Rank of the log pattern.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Pattern</i> A regular expression that defines the log pattern. A log pattern can contains at many as 50 characters, and it cannot be empty.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PatternName</i> The name of the log pattern. A log pattern name can contains at many as 50 characters, and it cannot be empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash, underscore.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PatternSetName</i> The name of the log pattern. A log pattern name can contains at many as 30 characters, and it cannot be empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash, underscore.<br/>        """
        pass

    def delete_application(self, ResourceGroupName: str) -> DeleteApplicationResponse:
        r"""Removes the specified application from monitoring. Does not delete the application.

        :param self:
        :param ResourceGroupName:  The name of the resource group.<br/>
        :return:         """
        pass

    def delete_component(self, ComponentName: str, ResourceGroupName: str) -> DeleteComponentResponse:
        r"""Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.

        :param self:
        :param ComponentName:  The name of the component.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return:         """
        pass

    def delete_log_pattern(self, PatternName: str, PatternSetName: str, ResourceGroupName: str) -> DeleteLogPatternResponse:
        r"""Removes the specified log pattern from a <code>LogPatternSet</code>.

        :param self:
        :param PatternName:  The name of the log pattern.<br/>PatternSetName:  The name of the log pattern set.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return:         """
        pass

    def describe_application(self, ResourceGroupName: str) -> DescribeApplicationResponse:
        r"""Describes the application.

        :param self:
        :param ResourceGroupName:  The name of the resource group.<br/>
        :return: ApplicationInfo:  Information about the application.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Remarks</i> The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include: <ul> <li> “Configuring application, detected 1 Errors, 3 Warnings” </li> <li> “Configuring application, detected 1 Unconfigured Components” </li> </ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CWEMonitorEnabled</i>  Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OpsCenterEnabled</i>  Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OpsItemSNSTopicArn</i>  The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LifeCycle</i> The lifecycle of the application. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ResourceGroupName</i> The name of the resource group used for the application.<br/>        """
        pass

    def describe_component(self, ComponentName: str, ResourceGroupName: str) -> DescribeComponentResponse:
        r"""Describes a component and lists the resources that are grouped together in a component.

        :param self:
        :param ComponentName:  The name of the component.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: ResourceList:  The list of resource ARNs that belong to the component.<br/>ApplicationComponent:  Describes a standalone resource or similarly grouped resources that the application is made up of.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Monitor</i> Indicates whether the application component is monitored. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Tier</i> The stack tier of the application component.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ResourceType</i> The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ComponentName</i> The name of the component.<br/>        """
        pass

    def describe_component_configuration(self, ComponentName: str, ResourceGroupName: str) -> DescribeComponentConfigurationResponse:
        r"""Describes the monitoring configuration of the component.

        :param self:
        :param ComponentName:  The name of the component.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: ComponentConfiguration:  The configuration settings of the component. The value is the escaped JSON of the configuration.<br/>Tier:  The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code> <br/>Monitor:  Indicates whether the application component is monitored.<br/>        """
        pass

    def describe_component_configuration_recommendation(self, Tier: str, ComponentName: str, ResourceGroupName: str) -> DescribeComponentConfigurationRecommendationResponse:
        r"""Describes the recommended monitoring configuration of the component.

        :param self:
        :param Tier:  The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.<br/>ComponentName:  The name of the component.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: ComponentConfiguration:  The recommended configuration settings of the component. The value is the escaped JSON of the configuration.<br/>        """
        pass

    def describe_log_pattern(self, PatternName: str, PatternSetName: str, ResourceGroupName: str) -> DescribeLogPatternResponse:
        r"""Describe a specific log pattern from a <code>LogPatternSet</code>.

        :param self:
        :param PatternName:  The name of the log pattern.<br/>PatternSetName:  The name of the log pattern set.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: LogPattern:  The successfully created log pattern.:<br/>ResourceGroupName:  The name of the resource group.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Rank</i> Rank of the log pattern.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Pattern</i> A regular expression that defines the log pattern. A log pattern can contains at many as 50 characters, and it cannot be empty.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PatternName</i> The name of the log pattern. A log pattern name can contains at many as 50 characters, and it cannot be empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash, underscore.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PatternSetName</i> The name of the log pattern. A log pattern name can contains at many as 30 characters, and it cannot be empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash, underscore.<br/>        """
        pass

    def describe_observation(self, ObservationId: str) -> DescribeObservationResponse:
        r"""Describes an anomaly or error with the application.

        :param self:
        :param ObservationId:  The ID of the observation.<br/>
        :return: Observation:  Information about the observation.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>XRayNodeType</i>  The type of the X-Ray node. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>XRayNodeName</i>  The name of the X-Ray node. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>XRayRequestAverageLatency</i>  The X-Ray node request average latency for this node. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>XRayRequestCount</i>  The X-Ray request count for this node. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>XRayErrorPercent</i>  The X-Ray request error percentage for this node. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>XRayThrottlePercent</i>  The X-Ray request throttle percentage for this node. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>XRayFaultPercent</i>  The X-Ray request fault percentage for this node. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Ec2State</i>  The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CodeDeployInstanceGroupId</i>  The instance group to which the CodeDeploy instance belongs. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CodeDeployApplication</i>  The CodeDeploy application to which the deployment belongs. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CodeDeployState</i>  The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CodeDeployDeploymentGroup</i>  The deployment group to which the CodeDeploy deployment belongs. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CodeDeployDeploymentId</i>  The deployment ID of the CodeDeploy-based observation related to the detected problem. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>HealthEventDescription</i>  The description of the AWS Health event provided by the service, such as Amazon EC2. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>HealthEventTypeCategory</i>  The category of the AWS Health event, such as <code>issue</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>HealthEventTypeCode</i>  The type of the AWS Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>HealthService</i>  The service to which the AWS Health Event belongs, such as EC2. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>HealthEventArn</i>  The Amazon Resource Name (ARN) of the AWS Health Event-based observation.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CloudWatchEventDetailType</i>  The detail type of the CloudWatch Event-based observation, for example, <code>EC2 Instance State-change Notification</code>. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CloudWatchEventSource</i>  The source of the CloudWatch Event. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CloudWatchEventId</i>  The ID of the CloudWatch Event-based observation related to the detected problem. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Value</i> The value of the source observation metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Unit</i> The unit of the source observation metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MetricName</i> The name of the observation metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>MetricNamespace</i> The namespace of the observation metric.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LogFilter</i> The log filter of the observation.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LogText</i> The log text of the observation.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LineTime</i> The timestamp in the CloudWatch Logs that specifies when the matched line occurred.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LogGroup</i> The log group name.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SourceARN</i> The source resource ARN of the observation.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SourceType</i> The source type of the observation.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>EndTime</i> The time when the observation ended, in epoch seconds.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>StartTime</i> The time when the observation was first detected, in epoch seconds.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Id</i> The ID of the observation type.<br/>        """
        pass

    def describe_problem(self, ProblemId: str) -> DescribeProblemResponse:
        r"""Describes an application problem.

        :param self:
        :param ProblemId:  The ID of the problem.<br/>
        :return: Problem:  Information about the problem. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Feedback</i> Feedback provided by the user about the problem.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ResourceGroupName</i> The name of the resource group affected by the problem.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>SeverityLevel</i> A measure of the level of impact of the problem.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>EndTime</i> The time when the problem ended, in epoch seconds.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>StartTime</i> The time when the problem started, in epoch seconds.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>AffectedResource</i> The resource affected by the problem.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Status</i> The status of the problem.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Insights</i> A detailed analysis of the problem using machine learning.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Title</i> The name of the problem.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Id</i> The ID of the problem.<br/>        """
        pass

    def describe_problem_observations(self, ProblemId: str) -> DescribeProblemObservationsResponse:
        r"""Describes the anomalies or errors associated with the problem.

        :param self:
        :param ProblemId:  The ID of the problem.<br/>
        :return: RelatedObservations:  Observations related to the problem.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ObservationList</i> The list of observations related to the problem.<br/>        """
        pass

    def list_applications(self, MaxResults: int=None, NextToken: str=None) -> ListApplicationsResponse:
        r"""Lists the IDs of the applications that you are monitoring. 

        :param self:
        :param NextToken:  The token to request the next page of results.<br/>MaxResults:  The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.<br/>
        :return: NextToken:  The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. <br/>ApplicationInfoList:  The list of applications.<br/>        """
        pass

    def list_components(self, ResourceGroupName: str, MaxResults: int=None, NextToken: str=None) -> ListComponentsResponse:
        r"""Lists the auto-grouped, standalone, and custom components of the application.

        :param self:
        :param NextToken:  The token to request the next page of results.<br/>MaxResults:  The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: NextToken:  The token to request the next page of results.<br/>ApplicationComponentList:  The list of application components.<br/>        """
        pass

    def list_configuration_history(self, ResourceGroupName: str=None, StartTime: StartTime=None, EndTime: EndTime=None, EventStatus: str=None, MaxResults: int=None, NextToken: str=None) -> ListConfigurationHistoryResponse:
        r""" Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:  <ul> <li> INFO: creating a new alarm or updating an alarm threshold. </li> <li> WARN: alarm not created due to insufficient data points used to predict thresholds. </li> <li> ERROR: alarm not created due to permission errors or exceeding quotas.  </li> </ul>

        :param self:
        :param NextToken:  The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.<br/>MaxResults:   The maximum number of results returned by <code>ListConfigurationHistory</code> in paginated output. When this parameter is used, <code>ListConfigurationHistory</code> returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListConfigurationHistory</code> request with the returned <code>NextToken</code> value. If this parameter is not used, then <code>ListConfigurationHistory</code> returns all results. <br/>EventStatus:  The status of the configuration update event. Possible values include INFO, WARN, and ERROR.<br/>EndTime:  The end time of the event.<br/>StartTime:  The start time of the event. <br/>ResourceGroupName:  Resource group to which the application belongs. <br/>
        :return: NextToken:  The <code>NextToken</code> value to include in a future <code>ListConfigurationHistory</code> request. When the results of a <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.<br/>EventList:   The list of configuration events and their corresponding details. <br/>        """
        pass

    def list_log_pattern_sets(self, ResourceGroupName: str, MaxResults: int=None, NextToken: str=None) -> ListLogPatternSetsResponse:
        r"""Lists the log pattern sets in the specific application.

        :param self:
        :param NextToken:  The token to request the next page of results.<br/>MaxResults:  The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: NextToken:  The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. <br/>LogPatternSets:  The list of log pattern sets.<br/>ResourceGroupName:  The name of the resource group.<br/>        """
        pass

    def list_log_patterns(self, ResourceGroupName: str, PatternSetName: str=None, MaxResults: int=None, NextToken: str=None) -> ListLogPatternsResponse:
        r"""Lists the log patterns in the specific log <code>LogPatternSet</code>.

        :param self:
        :param NextToken:  The token to request the next page of results.<br/>MaxResults:  The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.<br/>PatternSetName:  The name of the log pattern set.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: NextToken:  The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. <br/>LogPatterns:  The list of log patterns.<br/>ResourceGroupName:  The name of the resource group.<br/>        """
        pass

    def list_problems(self, ResourceGroupName: str=None, StartTime: StartTime=None, EndTime: EndTime=None, MaxResults: int=None, NextToken: str=None) -> ListProblemsResponse:
        r"""Lists the problems with your application.

        :param self:
        :param NextToken:  The token to request the next page of results.<br/>MaxResults:  The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.<br/>EndTime:  The time when the problem ended, in epoch seconds. If not specified, problems within the past seven days are returned.<br/>StartTime:  The time when the problem was detected, in epoch seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: NextToken:  The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. <br/>ProblemList:  The list of problems. <br/>        """
        pass

    def list_tags_for_resource(self, ResourceARN: str) -> ListTagsForResourceResponse:
        r"""Retrieve a list of the tags (keys and values) that are associated with a specified application. A <i>tag</i> is a label that you optionally define and associate with an application. Each tag consists of a required <i>tag key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.

        :param self:
        :param ResourceARN:  The Amazon Resource Name (ARN) of the application that you want to retrieve tag information for.<br/>
        :return: Tags:  An array that lists all the tags that are associated with the application. Each tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>).<br/>        """
        pass

    def tag_resource(self, Tags: List[Tag], ResourceARN: str) -> TagResourceResponse:
        r"""Add one or more tags (keys and values) to a specified application. A <i>tag</i> is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria.  Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.

        :param self:
        :param Tags:  A list of tags that to add to the application. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.<br/>ResourceARN:  The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.<br/>
        :return:         """
        pass

    def untag_resource(self, TagKeys: List[TagKey], ResourceARN: str) -> UntagResourceResponse:
        r"""Remove one or more tags (keys and values) from a specified application.

        :param self:
        :param TagKeys:  The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value. To remove more than one tag from the application, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. <br/>ResourceARN:  The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.<br/>
        :return:         """
        pass

    def update_application(self, ResourceGroupName: str, OpsCenterEnabled: OpsCenterEnabled=None, CWEMonitorEnabled: CWEMonitorEnabled=None, OpsItemSNSTopicArn: str=None, RemoveSNSTopic: RemoveSNSTopic=None) -> UpdateApplicationResponse:
        r"""Updates the application.

        :param self:
        :param RemoveSNSTopic:   Disassociates the SNS topic from the opsItem created for detected problems.<br/>OpsItemSNSTopicArn:   The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.<br/>CWEMonitorEnabled:   Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. <br/>OpsCenterEnabled:   When set to <code>true</code>, creates opsItems for any problems detected on an application. <br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: ApplicationInfo:  Information about the application. :<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Remarks</i> The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include: <ul> <li> “Configuring application, detected 1 Errors, 3 Warnings” </li> <li> “Configuring application, detected 1 Unconfigured Components” </li> </ul><br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>CWEMonitorEnabled</i>  Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OpsCenterEnabled</i>  Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>OpsItemSNSTopicArn</i>  The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>LifeCycle</i> The lifecycle of the application. <br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>ResourceGroupName</i> The name of the resource group used for the application.<br/>        """
        pass

    def update_component(self, ComponentName: str, ResourceGroupName: str, NewComponentName: str=None, ResourceList: List[ResourceARN]=None) -> UpdateComponentResponse:
        r"""Updates the custom component name and/or the list of resources that make up the component.

        :param self:
        :param ResourceList:  The list of resource ARNs that belong to the component.<br/>NewComponentName:  The new name of the component.<br/>ComponentName:  The name of the component.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return:         """
        pass

    def update_component_configuration(self, ComponentName: str, ResourceGroupName: str, Monitor: Monitor=None, Tier: str=None, ComponentConfiguration: str=None) -> UpdateComponentConfigurationResponse:
        r"""Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by <code>DescribeComponentConfigurationRecommendation</code>. 

        :param self:
        :param ComponentConfiguration:  The configuration settings of the component. The value is the escaped JSON of the configuration. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>. You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.<br/>Tier:  The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.<br/>Monitor:  Indicates whether the application component is monitored.<br/>ComponentName:  The name of the component.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return:         """
        pass

    def update_log_pattern(self, PatternName: str, PatternSetName: str, ResourceGroupName: str, Pattern: str=None, Rank: int=None) -> UpdateLogPatternResponse:
        r"""Adds a log pattern to a <code>LogPatternSet</code>.

        :param self:
        :param Rank:  Rank of the log pattern.<br/>Pattern:  The log pattern.<br/>PatternName:  The name of the log pattern.<br/>PatternSetName:  The name of the log pattern set.<br/>ResourceGroupName:  The name of the resource group.<br/>
        :return: LogPattern:  The successfully created log pattern.:<br/>ResourceGroupName:  The name of the resource group.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Rank</i> Rank of the log pattern.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>Pattern</i> A regular expression that defines the log pattern. A log pattern can contains at many as 50 characters, and it cannot be empty.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PatternName</i> The name of the log pattern. A log pattern name can contains at many as 50 characters, and it cannot be empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash, underscore.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>PatternSetName</i> The name of the log pattern. A log pattern name can contains at many as 30 characters, and it cannot be empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash, underscore.<br/>        """
        pass



class AppMesh(BaseClient):
    r"""AWS App Mesh is a service mesh based on the Envoy proxy that makes it easy to monitor and
         control microservices. App Mesh standardizes how your microservices communicate, giving you
         end-to-end visibility and helping to ensure high availability for your applications.
         App Mesh gives you consistent visibility and network traffic controls for every
         microservice in an application. You can use App Mesh with AWS Fargate, Amazon ECS, Amazon EKS,
         Kubernetes on AWS, and Amazon EC2.
         <note>
            App Mesh supports microservice applications that use service discovery naming for their
            components. For more information about service discovery on Amazon ECS, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. Kubernetes
               <code>kube-dns</code> and <code>coredns</code> are supported. For more information,
            see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/">DNS
               for Services and Pods</a> in the Kubernetes documentation.
         </note>"""


    class ListMeshesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_meshes` for valid parameters"""
            pass
    class ListRoutesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_routes` for valid parameters"""
            pass
    class ListVirtualNodesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_virtual_nodes` for valid parameters"""
            pass
    class ListVirtualRoutersPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_virtual_routers` for valid parameters"""
            pass
    class ListVirtualServicesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_virtual_services` for valid parameters"""
            pass
    class ListTagsForResourcePaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_tags_for_resource` for valid parameters"""
            pass


    class CreateMeshInput(Mapping):
        pass
    
    class CreateMeshOutput(Mapping):
        pass
    
    class MeshSpec(Mapping):
        pass
    
    class TagRef(Mapping):
        pass
    
    class CreateRouteInput(Mapping):
        pass
    
    class CreateRouteOutput(Mapping):
        pass
    
    class RouteSpec(Mapping):
        pass
    
    class CreateVirtualNodeInput(Mapping):
        pass
    
    class CreateVirtualNodeOutput(Mapping):
        pass
    
    class VirtualNodeSpec(Mapping):
        pass
    
    class CreateVirtualRouterInput(Mapping):
        pass
    
    class CreateVirtualRouterOutput(Mapping):
        pass
    
    class VirtualRouterSpec(Mapping):
        pass
    
    class CreateVirtualServiceInput(Mapping):
        pass
    
    class CreateVirtualServiceOutput(Mapping):
        pass
    
    class VirtualServiceSpec(Mapping):
        pass
    
    class DeleteMeshInput(Mapping):
        pass
    
    class DeleteMeshOutput(Mapping):
        pass
    
    class DeleteRouteInput(Mapping):
        pass
    
    class DeleteRouteOutput(Mapping):
        pass
    
    class DeleteVirtualNodeInput(Mapping):
        pass
    
    class DeleteVirtualNodeOutput(Mapping):
        pass
    
    class DeleteVirtualRouterInput(Mapping):
        pass
    
    class DeleteVirtualRouterOutput(Mapping):
        pass
    
    class DeleteVirtualServiceInput(Mapping):
        pass
    
    class DeleteVirtualServiceOutput(Mapping):
        pass
    
    class DescribeMeshInput(Mapping):
        pass
    
    class DescribeMeshOutput(Mapping):
        pass
    
    class DescribeRouteInput(Mapping):
        pass
    
    class DescribeRouteOutput(Mapping):
        pass
    
    class DescribeVirtualNodeInput(Mapping):
        pass
    
    class DescribeVirtualNodeOutput(Mapping):
        pass
    
    class DescribeVirtualRouterInput(Mapping):
        pass
    
    class DescribeVirtualRouterOutput(Mapping):
        pass
    
    class DescribeVirtualServiceInput(Mapping):
        pass
    
    class DescribeVirtualServiceOutput(Mapping):
        pass
    
    class ListMeshesInput(Mapping):
        pass
    
    class ListMeshesOutput(Mapping):
        pass
    
    class ListRoutesInput(Mapping):
        pass
    
    class ListRoutesOutput(Mapping):
        pass
    
    class ListTagsForResourceInput(Mapping):
        pass
    
    class ListTagsForResourceOutput(Mapping):
        pass
    
    class ListVirtualNodesInput(Mapping):
        pass
    
    class ListVirtualNodesOutput(Mapping):
        pass
    
    class ListVirtualRoutersInput(Mapping):
        pass
    
    class ListVirtualRoutersOutput(Mapping):
        pass
    
    class ListVirtualServicesInput(Mapping):
        pass
    
    class ListVirtualServicesOutput(Mapping):
        pass
    
    class TagResourceInput(Mapping):
        pass
    
    class TagResourceOutput(Mapping):
        pass
    
    class UntagResourceInput(Mapping):
        pass
    
    class UntagResourceOutput(Mapping):
        pass
    
    class TagKey(object):
        pass
    
    class UpdateMeshInput(Mapping):
        pass
    
    class UpdateMeshOutput(Mapping):
        pass
    
    class UpdateRouteInput(Mapping):
        pass
    
    class UpdateRouteOutput(Mapping):
        pass
    
    class UpdateVirtualNodeInput(Mapping):
        pass
    
    class UpdateVirtualNodeOutput(Mapping):
        pass
    
    class UpdateVirtualRouterInput(Mapping):
        pass
    
    class UpdateVirtualRouterOutput(Mapping):
        pass
    
    class UpdateVirtualServiceInput(Mapping):
        pass
    
    class UpdateVirtualServiceOutput(Mapping):
        pass
    
    def create_mesh(self, meshName: str, clientToken: str=None, spec: MeshSpec=None, tags: List[TagRef]=None) -> CreateMeshOutput:
        r"""Creates a service mesh.
          A service mesh is a logical boundary for network traffic between services that are
         represented by resources within the mesh. After you create your service mesh, you can
         create virtual services, virtual nodes, virtual routers, and routes to distribute traffic
         between the applications in your mesh.
         For more information about service meshes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">Service meshes</a>.

        :param self:
        :param tags:  Optional metadata that you can apply to the service mesh to assist with categorization
         and organization. Each tag consists of a key and an optional value, both of which you
         define. Tag keys can have a maximum character length of 128 characters, and tag values can have
            a maximum length of 256 characters.<br/>spec:  The service mesh specification to apply.:<br/>meshName:  The name to use for the service mesh.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>egressFilter</i> The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>egressFilter</b>: The egress filter rules for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows
         egress only from virtual nodes to other defined resources in the service mesh (and any
         traffic to <code>*.amazonaws.com</code> for AWS API calls). You can set the egress filter
         type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the
         service mesh.<br/>
        :return: mesh:  The full description of your service mesh following the create call.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The status of the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The associated specification for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The associated specification for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>egressFilter</b>: The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current mesh status.<br/>        """
        pass

    def create_route(self, virtualRouterName: str, spec: RouteSpec, routeName: str, meshName: str, clientToken: str=None, meshOwner: str=None, tags: List[TagRef]=None) -> CreateRouteOutput:
        r"""Creates a route that is associated with a virtual router.
          You can route several different protocols and define a retry policy for a route.
         Traffic can be routed to one or more virtual nodes.
         For more information about routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes</a>.

        :param self:
        :param virtualRouterName:  The name of the virtual router in which to create the route. If the virtual router is in
         a shared mesh, then you must be the owner of the virtual router resource.<br/>tags:  Optional metadata that you can apply to the route to assist with categorization and
         organization. Each tag consists of a key and an optional value, both of which you define.
         Tag keys can have a maximum character length of 128 characters, and tag values can have
            a maximum length of 256 characters.<br/>spec:  The route specification to apply.:<br/>routeName:  The name to use for the route.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
               the account that you specify must share the mesh with your account before you can create 
             the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to create the route in.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tcpRoute</i> An object that represents the specification of a TCP route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>tcpRoute</b>: An object that represents the specification of a TCP route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>priority</i> The priority for the route. Routes are matched based on the specified value, where 0 is
         the highest priority.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>httpRoute</i> An object that represents the specification of an HTTP route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>httpRoute</b>: An object that represents the specification of an HTTP route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>http2Route</i> An object that represents the specification of an HTTP/2 route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>http2Route</b>: An object that represents the specification of an HTTP/2 route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>grpcRoute</i> An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>grpcRoute</b>: An object that represents the specification of a gRPC route.<br/>An object that represents the action to take if a match is determined.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>action</b>: An object that represents the action to take if a match is determined.An object that represents the action to take if a match is determined.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>action</b>: An object that represents the action to take if a match is determined.An object that represents the action to take if a match is determined.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>action</b>: An object that represents the action to take if a match is determined.The action to take if a match is determined.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>action</b>: The action to take if a match is determined.
        :return: route:  The full description of your mesh following the create call.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualRouterName</i> The virtual router that the route is associated with.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The status of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>routeName</i> The name of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the route resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>grpcRoute</b>: An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status for the route.<br/>        """
        pass

    def create_virtual_node(self, virtualNodeName: str, spec: VirtualNodeSpec, meshName: str, clientToken: str=None, meshOwner: str=None, tags: List[TagRef]=None) -> CreateVirtualNodeOutput:
        r"""Creates a virtual node within a service mesh.
          A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS
         service or a Kubernetes deployment. When you create a virtual node, you can specify the
         service discovery information for your task group, and whether the proxy running in a task
         group will communicate with other proxies using Transport Layer Security (TLS).
         You define a <code>listener</code> for any inbound traffic that your virtual node
         expects. Any virtual service that your virtual node expects to communicate to is specified
         as a <code>backend</code>.
         The response metadata for your new virtual node contains the <code>arn</code> that is
         associated with the virtual node. Set this value (either the full ARN or the truncated
         resource name: for example, <code>mesh/default/virtualNode/simpleapp</code>) as the
            <code>APPMESH_VIRTUAL_NODE_NAME</code> environment variable for your task group's Envoy
         proxy container in your task definition or pod spec. This is then mapped to the
            <code>node.id</code> and <code>node.cluster</code> Envoy parameters.
         <note>
            If you require your Envoy stats or tracing to use a different name, you can override
            the <code>node.cluster</code> value that is set by
               <code>APPMESH_VIRTUAL_NODE_NAME</code> with the
               <code>APPMESH_VIRTUAL_NODE_CLUSTER</code> environment variable.
         </note>
         For more information about virtual nodes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes</a>.

        :param self:
        :param virtualNodeName:  The name to use for the virtual node.<br/>tags:  Optional metadata that you can apply to the virtual node to assist with categorization
         and organization. Each tag consists of a key and an optional value, both of which you
         define. Tag keys can have a maximum character length of 128 characters, and tag values can have
            a maximum length of 256 characters.<br/>spec:  The virtual node specification to apply.:<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
               the account that you specify must share the mesh with your account before you can create 
             the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to create the virtual node in.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>serviceDiscovery</i> The service discovery information for the virtual node. If your virtual node does not
         expect ingress traffic, you can omit this parameter. If you specify a
         <code>listener</code>, then you must specify service discovery information.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>serviceDiscovery</b>: The service discovery information for the virtual node. If your virtual node does not
         expect ingress traffic, you can omit this parameter. If you specify a
         <code>listener</code>, then you must specify service discovery information.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>logging</i> The inbound and outbound access logging information for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>logging</b>: The inbound and outbound access logging information for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>listeners</i> The listener that the virtual node is expected to receive inbound traffic from. You can
         specify one listener.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backends</i> The backends that the virtual node is expected to send outbound traffic to.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendDefaults</i> A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>backendDefaults</b>: A reference to an object that represents the defaults for backends.<br/>A reference to an object that represents a client policy.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>clientPolicy</b>: A reference to an object that represents a client policy.The access log configuration for a virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>accessLog</b>: The access log configuration for a virtual node.Specifies any AWS Cloud Map information for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>awsCloudMap</b>: Specifies any AWS Cloud Map information for the virtual node.
        :return: virtualNode:  The full description of your virtual node following the create call.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualNodeName</i> The name of the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual node resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>backendDefaults</b>: A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual node.<br/>        """
        pass

    def create_virtual_router(self, virtualRouterName: str, spec: VirtualRouterSpec, meshName: str, clientToken: str=None, meshOwner: str=None, tags: List[TagRef]=None) -> CreateVirtualRouterOutput:
        r"""Creates a virtual router within a service mesh.
         Specify a <code>listener</code> for any inbound traffic that your virtual router
         receives. Create a virtual router for each protocol and port that you need to route.
         Virtual routers handle traffic for one or more virtual services within your mesh. After you
         create your virtual router, create and associate routes for your virtual router that direct
         incoming requests to different virtual nodes.
         For more information about virtual routers, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html">Virtual routers</a>.

        :param self:
        :param virtualRouterName:  The name to use for the virtual router.<br/>tags:  Optional metadata that you can apply to the virtual router to assist with categorization
         and organization. Each tag consists of a key and an optional value, both of which you
         define. Tag keys can have a maximum character length of 128 characters, and tag values can have
            a maximum length of 256 characters.<br/>spec:  The virtual router specification to apply.:<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
               the account that you specify must share the mesh with your account before you can create 
             the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to create the virtual router in.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>listeners</i> The listeners that the virtual router is expected to receive inbound traffic from. You
         can specify one listener.<br/>
        :return: virtualRouter:  The full description of your virtual router following the create call.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualRouterName</i> The name of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual router resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>listeners</i> The listeners that the virtual router is expected to receive inbound traffic from. You
         can specify one listener.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual router.<br/>        """
        pass

    def create_virtual_service(self, virtualServiceName: str, spec: VirtualServiceSpec, meshName: str, clientToken: str=None, meshOwner: str=None, tags: List[TagRef]=None) -> CreateVirtualServiceOutput:
        r"""Creates a virtual service within a service mesh.
         A virtual service is an abstraction of a real service that is provided by a virtual node
         directly or indirectly by means of a virtual router. Dependent services call your virtual
         service by its <code>virtualServiceName</code>, and those requests are routed to the
         virtual node or virtual router that is specified as the provider for the virtual
         service.
         For more information about virtual services, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html">Virtual services</a>.

        :param self:
        :param virtualServiceName:  The name to use for the virtual service.<br/>tags:  Optional metadata that you can apply to the virtual service to assist with
         categorization and organization. Each tag consists of a key and an optional value, both of
         which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have
            a maximum length of 256 characters.<br/>spec:  The virtual service specification to apply.:<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
               the account that you specify must share the mesh with your account before you can create 
             the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to create the virtual service in.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>provider</i> The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>provider</b>: The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.<br/>The virtual node associated with a virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>virtualNode</b>: The virtual node associated with a virtual service.
        :return: virtualService:  The full description of your virtual service following the create call.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualServiceName</i> The name of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> An object that represents metadata for a resource.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: An object that represents metadata for a resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual service resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>provider</b>: The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual service.<br/>        """
        pass

    def delete_mesh(self, meshName: str) -> DeleteMeshOutput:
        r"""Deletes an existing service mesh.
         You must delete all resources (virtual services, routes, virtual routers, and virtual
         nodes) in the service mesh before you can delete the mesh itself.

        :param self:
        :param meshName:  The name of the service mesh to delete.<br/>
        :return: mesh:  The service mesh that was deleted.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The status of the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The associated specification for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The associated specification for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>egressFilter</b>: The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current mesh status.<br/>        """
        pass

    def delete_route(self, virtualRouterName: str, routeName: str, meshName: str, meshOwner: str=None) -> DeleteRouteOutput:
        r"""Deletes an existing route.

        :param self:
        :param virtualRouterName:  The name of the virtual router to delete the route in.<br/>routeName:  The name of the route to delete.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to delete the route in.<br/>
        :return: route:  The route that was deleted.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualRouterName</i> The virtual router that the route is associated with.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The status of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>routeName</i> The name of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the route resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>grpcRoute</b>: An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status for the route.<br/>        """
        pass

    def delete_virtual_node(self, virtualNodeName: str, meshName: str, meshOwner: str=None) -> DeleteVirtualNodeOutput:
        r"""Deletes an existing virtual node.
         You must delete any virtual services that list a virtual node as a service provider
         before you can delete the virtual node itself.

        :param self:
        :param virtualNodeName:  The name of the virtual node to delete.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to delete the virtual node in.<br/>
        :return: virtualNode:  The virtual node that was deleted.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualNodeName</i> The name of the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual node resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>backendDefaults</b>: A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual node.<br/>        """
        pass

    def delete_virtual_router(self, virtualRouterName: str, meshName: str, meshOwner: str=None) -> DeleteVirtualRouterOutput:
        r"""Deletes an existing virtual router.
         You must delete any routes associated with the virtual router before you can delete the
         router itself.

        :param self:
        :param virtualRouterName:  The name of the virtual router to delete.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to delete the virtual router in.<br/>
        :return: virtualRouter:  The virtual router that was deleted.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualRouterName</i> The name of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual router resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>listeners</i> The listeners that the virtual router is expected to receive inbound traffic from. You
         can specify one listener.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual router.<br/>        """
        pass

    def delete_virtual_service(self, virtualServiceName: str, meshName: str, meshOwner: str=None) -> DeleteVirtualServiceOutput:
        r"""Deletes an existing virtual service.

        :param self:
        :param virtualServiceName:  The name of the virtual service to delete.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to delete the virtual service in.<br/>
        :return: virtualService:  The virtual service that was deleted.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualServiceName</i> The name of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> An object that represents metadata for a resource.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: An object that represents metadata for a resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual service resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>provider</b>: The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual service.<br/>        """
        pass

    def describe_mesh(self, meshName: str, meshOwner: str=None) -> DescribeMeshOutput:
        r"""Describes an existing service mesh.

        :param self:
        :param meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to describe.<br/>
        :return: mesh:  The full description of your service mesh.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The status of the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The associated specification for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The associated specification for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>egressFilter</b>: The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current mesh status.<br/>        """
        pass

    def describe_route(self, virtualRouterName: str, routeName: str, meshName: str, meshOwner: str=None) -> DescribeRouteOutput:
        r"""Describes an existing route.

        :param self:
        :param virtualRouterName:  The name of the virtual router that the route is associated with.<br/>routeName:  The name of the route to describe.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh that the route resides in.<br/>
        :return: route:  The full description of your route.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualRouterName</i> The virtual router that the route is associated with.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The status of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>routeName</i> The name of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the route resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>grpcRoute</b>: An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status for the route.<br/>        """
        pass

    def describe_virtual_node(self, virtualNodeName: str, meshName: str, meshOwner: str=None) -> DescribeVirtualNodeOutput:
        r"""Describes an existing virtual node.

        :param self:
        :param virtualNodeName:  The name of the virtual node to describe.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh that the virtual node resides in.<br/>
        :return: virtualNode:  The full description of your virtual node.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualNodeName</i> The name of the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual node resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>backendDefaults</b>: A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual node.<br/>        """
        pass

    def describe_virtual_router(self, virtualRouterName: str, meshName: str, meshOwner: str=None) -> DescribeVirtualRouterOutput:
        r"""Describes an existing virtual router.

        :param self:
        :param virtualRouterName:  The name of the virtual router to describe.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh that the virtual router resides in.<br/>
        :return: virtualRouter:  The full description of your virtual router.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualRouterName</i> The name of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual router resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>listeners</i> The listeners that the virtual router is expected to receive inbound traffic from. You
         can specify one listener.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual router.<br/>        """
        pass

    def describe_virtual_service(self, virtualServiceName: str, meshName: str, meshOwner: str=None) -> DescribeVirtualServiceOutput:
        r"""Describes an existing virtual service.

        :param self:
        :param virtualServiceName:  The name of the virtual service to describe.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh that the virtual service resides in.<br/>
        :return: virtualService:  The full description of your virtual service.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualServiceName</i> The name of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> An object that represents metadata for a resource.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: An object that represents metadata for a resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual service resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>provider</b>: The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual service.<br/>        """
        pass

    def list_meshes(self, limit: int=None, nextToken: str=None) -> ListMeshesOutput:
        r"""Returns a list of existing service meshes.

        :param self:
        :param nextToken:  The <code>nextToken</code> value returned from a previous paginated
            <code>ListMeshes</code> request where <code>limit</code> was used and the results
         exceeded the value of that parameter. Pagination continues from the end of the previous
         results that returned the <code>nextToken</code> value. 
         <note>
            This token should be treated as an opaque identifier that is used only to
                retrieve the next items in a list and not for other programmatic purposes.
        </note><br/>limit:  The maximum number of results returned by <code>ListMeshes</code> in paginated output.
         When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code>
         results in a single page along with a <code>nextToken</code> response element. You can see
         the remaining results of the initial request by sending another <code>ListMeshes</code>
         request with the returned <code>nextToken</code> value. This value can be between
         1 and 100. If you don't use this parameter,
            <code>ListMeshes</code> returns up to 100 results and a
            <code>nextToken</code> value if applicable.<br/>
        :return: nextToken:  The <code>nextToken</code> value to include in a future <code>ListMeshes</code> request.
         When the results of a <code>ListMeshes</code> request exceed <code>limit</code>, you can
         use this value to retrieve the next page of results. This value is <code>null</code> when
         there are no more results to return.<br/>meshes:  The list of existing service meshes.<br/>        """
        pass

    def list_routes(self, virtualRouterName: str, meshName: str, limit: int=None, meshOwner: str=None, nextToken: str=None) -> ListRoutesOutput:
        r"""Returns a list of existing routes in a service mesh.

        :param self:
        :param virtualRouterName:  The name of the virtual router to list routes in.<br/>nextToken:  The <code>nextToken</code> value returned from a previous paginated
            <code>ListRoutes</code> request where <code>limit</code> was used and the results
         exceeded the value of that parameter. Pagination continues from the end of the previous
         results that returned the <code>nextToken</code> value.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to list routes in.<br/>limit:  The maximum number of results returned by <code>ListRoutes</code> in paginated output.
         When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code>
         results in a single page along with a <code>nextToken</code> response element. You can see
         the remaining results of the initial request by sending another <code>ListRoutes</code>
         request with the returned <code>nextToken</code> value. This value can be between
         1 and 100. If you don't use this parameter,
            <code>ListRoutes</code> returns up to 100 results and a
            <code>nextToken</code> value if applicable.<br/>
        :return: routes:  The list of existing routes for the specified service mesh and virtual router.<br/>nextToken:  The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request.
         When the results of a <code>ListRoutes</code> request exceed <code>limit</code>, you can
         use this value to retrieve the next page of results. This value is <code>null</code> when
         there are no more results to return.<br/>        """
        pass

    def list_tags_for_resource(self, resourceArn: str, limit: int=None, nextToken: str=None) -> ListTagsForResourceOutput:
        r"""List the tags for an App Mesh resource.

        :param self:
        :param resourceArn:  The Amazon Resource Name (ARN) that identifies the resource to list the tags for.<br/>nextToken:  The <code>nextToken</code> value returned from a previous paginated
            <code>ListTagsForResource</code> request where <code>limit</code> was used and the
         results exceeded the value of that parameter. Pagination continues from the end of the
         previous results that returned the <code>nextToken</code> value.<br/>limit:  The maximum number of tag results returned by <code>ListTagsForResource</code> in
         paginated output. When this parameter is used, <code>ListTagsForResource</code> returns
         only <code>limit</code> results in a single page along with a <code>nextToken</code>
         response element. You can see the remaining results of the initial request by sending
         another <code>ListTagsForResource</code> request with the returned <code>nextToken</code>
         value. This value can be between 1 and 100. If you don't use
         this parameter, <code>ListTagsForResource</code> returns up to 100
         results and a <code>nextToken</code> value if applicable.<br/>
        :return: tags:  The tags for the resource.<br/>nextToken:  The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code>
         request. When the results of a <code>ListTagsForResource</code> request exceed
            <code>limit</code>, you can use this value to retrieve the next page of results. This
         value is <code>null</code> when there are no more results to return.<br/>        """
        pass

    def list_virtual_nodes(self, meshName: str, limit: int=None, meshOwner: str=None, nextToken: str=None) -> ListVirtualNodesOutput:
        r"""Returns a list of existing virtual nodes.

        :param self:
        :param nextToken:  The <code>nextToken</code> value returned from a previous paginated
            <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results
         exceeded the value of that parameter. Pagination continues from the end of the previous
         results that returned the <code>nextToken</code> value.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to list virtual nodes in.<br/>limit:  The maximum number of results returned by <code>ListVirtualNodes</code> in paginated
         output. When you use this parameter, <code>ListVirtualNodes</code> returns only
            <code>limit</code> results in a single page along with a <code>nextToken</code> response
         element. You can see the remaining results of the initial request by sending another
            <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value.
         This value can be between 1 and 100. If you don't use this
         parameter, <code>ListVirtualNodes</code> returns up to 100 results and a
            <code>nextToken</code> value if applicable.<br/>
        :return: virtualNodes:  The list of existing virtual nodes for the specified service mesh.<br/>nextToken:  The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code>
         request. When the results of a <code>ListVirtualNodes</code> request exceed
            <code>limit</code>, you can use this value to retrieve the next page of results. This
         value is <code>null</code> when there are no more results to return.<br/>        """
        pass

    def list_virtual_routers(self, meshName: str, limit: int=None, meshOwner: str=None, nextToken: str=None) -> ListVirtualRoutersOutput:
        r"""Returns a list of existing virtual routers in a service mesh.

        :param self:
        :param nextToken:  The <code>nextToken</code> value returned from a previous paginated
            <code>ListVirtualRouters</code> request where <code>limit</code> was used and the
         results exceeded the value of that parameter. Pagination continues from the end of the
         previous results that returned the <code>nextToken</code> value.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to list virtual routers in.<br/>limit:  The maximum number of results returned by <code>ListVirtualRouters</code> in paginated
         output. When you use this parameter, <code>ListVirtualRouters</code> returns only
            <code>limit</code> results in a single page along with a <code>nextToken</code> response
         element. You can see the remaining results of the initial request by sending another
            <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value.
         This value can be between 1 and 100. If you don't use this
         parameter, <code>ListVirtualRouters</code> returns up to 100 results and
         a <code>nextToken</code> value if applicable.<br/>
        :return: virtualRouters:  The list of existing virtual routers for the specified service mesh.<br/>nextToken:  The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code>
         request. When the results of a <code>ListVirtualRouters</code> request exceed
            <code>limit</code>, you can use this value to retrieve the next page of results. This
         value is <code>null</code> when there are no more results to return.<br/>        """
        pass

    def list_virtual_services(self, meshName: str, limit: int=None, meshOwner: str=None, nextToken: str=None) -> ListVirtualServicesOutput:
        r"""Returns a list of existing virtual services in a service mesh.

        :param self:
        :param nextToken:  The <code>nextToken</code> value returned from a previous paginated
            <code>ListVirtualServices</code> request where <code>limit</code> was used and the
         results exceeded the value of that parameter. Pagination continues from the end of the
         previous results that returned the <code>nextToken</code> value.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh to list virtual services in.<br/>limit:  The maximum number of results returned by <code>ListVirtualServices</code> in paginated
         output. When you use this parameter, <code>ListVirtualServices</code> returns only
            <code>limit</code> results in a single page along with a <code>nextToken</code> response
         element. You can see the remaining results of the initial request by sending another
            <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value.
         This value can be between 1 and 100. If you don't use this
         parameter, <code>ListVirtualServices</code> returns up to 100 results and
         a <code>nextToken</code> value if applicable.<br/>
        :return: virtualServices:  The list of existing virtual services for the specified service mesh.<br/>nextToken:  The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code>
         request. When the results of a <code>ListVirtualServices</code> request exceed
            <code>limit</code>, you can use this value to retrieve the next page of results. This
         value is <code>null</code> when there are no more results to return.<br/>        """
        pass

    def tag_resource(self, tags: List[TagRef], resourceArn: str) -> TagResourceOutput:
        r"""Associates the specified tags to a resource with the specified <code>resourceArn</code>.
         If existing tags on a resource aren't specified in the request parameters, they aren't
         changed. When a resource is deleted, the tags associated with that resource are also
         deleted.

        :param self:
        :param tags:  The tags to add to the resource. A tag is an array of key-value pairs.
         Tag keys can have a maximum character length of 128 characters, and tag values can have
            a maximum length of 256 characters.<br/>resourceArn:  The Amazon Resource Name (ARN) of the resource to add tags to.<br/>
        :return:         """
        pass

    def untag_resource(self, tagKeys: List[TagKey], resourceArn: str) -> UntagResourceOutput:
        r"""Deletes specified tags from a resource.

        :param self:
        :param tagKeys:  The keys of the tags to be removed.<br/>resourceArn:  The Amazon Resource Name (ARN) of the resource to delete tags from.<br/>
        :return:         """
        pass

    def update_mesh(self, meshName: str, clientToken: str=None, spec: MeshSpec=None) -> UpdateMeshOutput:
        r"""Updates an existing service mesh.

        :param self:
        :param spec:  The service mesh specification to apply.:<br/>meshName:  The name of the service mesh to update.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>egressFilter</i> The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>egressFilter</b>: The egress filter rules for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>type</i> The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows
         egress only from virtual nodes to other defined resources in the service mesh (and any
         traffic to <code>*.amazonaws.com</code> for AWS API calls). You can set the egress filter
         type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the
         service mesh.<br/>
        :return: mesh:  An object that represents a service mesh returned by a describe operation.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The status of the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The associated specification for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The associated specification for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>egressFilter</b>: The egress filter rules for the service mesh.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current mesh status.<br/>        """
        pass

    def update_route(self, virtualRouterName: str, spec: RouteSpec, routeName: str, meshName: str, clientToken: str=None, meshOwner: str=None) -> UpdateRouteOutput:
        r"""Updates an existing route for a specified service mesh and virtual router.

        :param self:
        :param virtualRouterName:  The name of the virtual router that the route is associated with.<br/>spec:  The new route specification to apply. This overwrites the existing data.:<br/>routeName:  The name of the route to update.<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh that the route resides in.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>tcpRoute</i> An object that represents the specification of a TCP route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>tcpRoute</b>: An object that represents the specification of a TCP route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>priority</i> The priority for the route. Routes are matched based on the specified value, where 0 is
         the highest priority.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>httpRoute</i> An object that represents the specification of an HTTP route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>httpRoute</b>: An object that represents the specification of an HTTP route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>http2Route</i> An object that represents the specification of an HTTP/2 route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>http2Route</b>: An object that represents the specification of an HTTP/2 route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>grpcRoute</i> An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>grpcRoute</b>: An object that represents the specification of a gRPC route.<br/>An object that represents the action to take if a match is determined.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>action</b>: An object that represents the action to take if a match is determined.An object that represents the action to take if a match is determined.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>action</b>: An object that represents the action to take if a match is determined.An object that represents the action to take if a match is determined.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>action</b>: An object that represents the action to take if a match is determined.The action to take if a match is determined.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>action</b>: The action to take if a match is determined.
        :return: route:  A full description of the route that was updated.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualRouterName</i> The virtual router that the route is associated with.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The status of the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The status of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>routeName</i> The name of the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the route.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the route resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>grpcRoute</b>: An object that represents the specification of a gRPC route.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status for the route.<br/>        """
        pass

    def update_virtual_node(self, virtualNodeName: str, spec: VirtualNodeSpec, meshName: str, clientToken: str=None, meshOwner: str=None) -> UpdateVirtualNodeOutput:
        r"""Updates an existing virtual node in a specified service mesh.

        :param self:
        :param virtualNodeName:  The name of the virtual node to update.<br/>spec:  The new virtual node specification to apply. This overwrites the existing data.:<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh that the virtual node resides in.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>serviceDiscovery</i> The service discovery information for the virtual node. If your virtual node does not
         expect ingress traffic, you can omit this parameter. If you specify a
         <code>listener</code>, then you must specify service discovery information.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>serviceDiscovery</b>: The service discovery information for the virtual node. If your virtual node does not
         expect ingress traffic, you can omit this parameter. If you specify a
         <code>listener</code>, then you must specify service discovery information.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>logging</i> The inbound and outbound access logging information for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>logging</b>: The inbound and outbound access logging information for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>listeners</i> The listener that the virtual node is expected to receive inbound traffic from. You can
         specify one listener.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backends</i> The backends that the virtual node is expected to send outbound traffic to.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>backendDefaults</i> A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>backendDefaults</b>: A reference to an object that represents the defaults for backends.<br/>A reference to an object that represents a client policy.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>clientPolicy</b>: A reference to an object that represents a client policy.The access log configuration for a virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>accessLog</b>: The access log configuration for a virtual node.Specifies any AWS Cloud Map information for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>awsCloudMap</b>: Specifies any AWS Cloud Map information for the virtual node.
        :return: virtualNode:  A full description of the virtual node that was updated.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualNodeName</i> The name of the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the virtual node.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the virtual node.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual node resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>backendDefaults</b>: A reference to an object that represents the defaults for backends.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual node.<br/>        """
        pass

    def update_virtual_router(self, virtualRouterName: str, spec: VirtualRouterSpec, meshName: str, clientToken: str=None, meshOwner: str=None) -> UpdateVirtualRouterOutput:
        r"""Updates an existing virtual router in a specified service mesh.

        :param self:
        :param virtualRouterName:  The name of the virtual router to update.<br/>spec:  The new virtual router specification to apply. This overwrites the existing data.:<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh that the virtual router resides in.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>listeners</i> The listeners that the virtual router is expected to receive inbound traffic from. You
         can specify one listener.<br/>
        :return: virtualRouter:  A full description of the virtual router that was updated.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualRouterName</i> The name of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> The associated metadata for the virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: The associated metadata for the virtual router.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual router resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>listeners</i> The listeners that the virtual router is expected to receive inbound traffic from. You
         can specify one listener.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual router.<br/>        """
        pass

    def update_virtual_service(self, virtualServiceName: str, spec: VirtualServiceSpec, meshName: str, clientToken: str=None, meshOwner: str=None) -> UpdateVirtualServiceOutput:
        r"""Updates an existing virtual service in a specified service mesh.

        :param self:
        :param virtualServiceName:  The name of the virtual service to update.<br/>spec:  The new virtual service specification to apply. This overwrites the existing
         data.:<br/>meshOwner:  The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>meshName:  The name of the service mesh that the virtual service resides in.<br/>clientToken:  Unique, case-sensitive identifier that you provide to ensure the idempotency of the
request. Up to 36 letters, numbers, hyphens, and underscores are allowed.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>provider</i> The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>provider</b>: The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.<br/>The virtual node associated with a virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>virtualNode</b>: The virtual node associated with a virtual service.
        :return: virtualService:  A full description of the virtual service that was updated.:<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>virtualServiceName</i> The name of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>status</b>: The current status of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>spec</i> The specifications of the virtual service.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>spec</b>: The specifications of the virtual service.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>metadata</i> An object that represents metadata for a resource.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>metadata</b>: An object that represents metadata for a resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp; <i>meshName</i> The name of the service mesh that the virtual service resides in.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>version</i> The version of the resource. Resources are created at version 1, and this version is
         incremented each time that they're updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>uid</i> The unique identifier for the resource.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>resourceOwner</i> The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
               the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>meshOwner</i> The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
               the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a>.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>lastUpdatedAt</i> The Unix epoch timestamp in seconds for when the resource was last updated.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>createdAt</i> The Unix epoch timestamp in seconds for when the resource was created.<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>arn</i> The full Amazon Resource Name (ARN) for the resource.<br/>The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>provider</b>: The App Mesh object that is acting as the provider for a virtual service. You can specify
         a single virtual node or virtual router.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>status</i> The current status of the virtual service.<br/>        """
        pass



class AppStream(BaseClient):
    r"""<fullname>Amazon AppStream 2.0</fullname> This is the <i>Amazon AppStream 2.0 API Reference</i>. This documentation provides descriptions and syntax for each of the actions and data types in AppStream 2.0. AppStream 2.0 is a fully managed, secure application streaming service that lets you stream desktop applications to users without rewriting applications. AppStream 2.0 manages the AWS resources that are required to host and run your applications, scales automatically, and provides access to your users on demand.  <note> You can call the AppStream 2.0 API operations by using an interface VPC endpoint (interface endpoint). For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/access-api-cli-through-interface-vpc-endpoint.html">Access AppStream 2.0 API Operations and CLI Commands Through an Interface VPC Endpoint</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>. </note> To learn more about AppStream 2.0, see the following resources: <ul> <li>  <a href="http://aws.amazon.com/appstream2">Amazon AppStream 2.0 product page</a>  </li> <li>  <a href="http://aws.amazon.com/documentation/appstream2">Amazon AppStream 2.0 documentation</a>  </li> </ul>"""

    class FleetStartedWaiter(Waiter):
        def wait(self, **kwargs):
            r"""see function `describe_fleets` for valid parameters"""
            pass
    class FleetStoppedWaiter(Waiter):
        def wait(self, **kwargs):
            r"""see function `describe_fleets` for valid parameters"""
            pass


    class DescribeDirectoryConfigsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_directory_configs` for valid parameters"""
            pass
    class DescribeFleetsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_fleets` for valid parameters"""
            pass
    class DescribeImageBuildersPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_image_builders` for valid parameters"""
            pass
    class DescribeImagesPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_images` for valid parameters"""
            pass
    class DescribeSessionsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_sessions` for valid parameters"""
            pass
    class DescribeStacksPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_stacks` for valid parameters"""
            pass
    class DescribeUserStackAssociationsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_user_stack_associations` for valid parameters"""
            pass
    class DescribeUsersPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `describe_users` for valid parameters"""
            pass
    class ListAssociatedFleetsPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_associated_fleets` for valid parameters"""
            pass
    class ListAssociatedStacksPaginator(Paginator):
        def wait(self, **kwargs):
            r"""see function `list_associated_stacks` for valid parameters"""
            pass


    class AssociateFleetRequest(Mapping):
        pass
    
    class AssociateFleetResult(Mapping):
        pass
    
    class BatchAssociateUserStackRequest(Mapping):
        pass
    
    class BatchAssociateUserStackResult(Mapping):
        pass
    
    class UserStackAssociation(Mapping):
        pass
    
    class BatchDisassociateUserStackRequest(Mapping):
        pass
    
    class BatchDisassociateUserStackResult(Mapping):
        pass
    
    class CopyImageRequest(Mapping):
        pass
    
    class CopyImageResponse(Mapping):
        pass
    
    class CreateDirectoryConfigRequest(Mapping):
        pass
    
    class CreateDirectoryConfigResult(Mapping):
        pass
    
    class OrganizationalUnitDistinguishedName(object):
        pass
    
    class ServiceAccountCredentials(Mapping):
        pass
    
    class CreateFleetRequest(Mapping):
        pass
    
    class CreateFleetResult(Mapping):
        pass
    
    class ComputeCapacity(Mapping):
        pass
    
    class VpcConfig(Mapping):
        pass
    
    class BooleanObject(object):
        pass
    
    class DomainJoinInfo(Mapping):
        pass
    
    class Tags(object):
        pass
    
    class CreateImageBuilderRequest(Mapping):
        pass
    
    class CreateImageBuilderResult(Mapping):
        pass
    
    class AccessEndpoint(Mapping):
        pass
    
    class CreateImageBuilderStreamingURLRequest(Mapping):
        pass
    
    class CreateImageBuilderStreamingURLResult(Mapping):
        pass
    
    class Long(object):
        pass
    
    class CreateStackRequest(Mapping):
        pass
    
    class CreateStackResult(Mapping):
        pass
    
    class StorageConnector(Mapping):
        pass
    
    class UserSetting(Mapping):
        pass
    
    class ApplicationSettings(Mapping):
        pass
    
    class EmbedHostDomain(object):
        pass
    
    class CreateStreamingURLRequest(Mapping):
        pass
    
    class CreateStreamingURLResult(Mapping):
        pass
    
    class CreateUsageReportSubscriptionRequest(Mapping):
        pass
    
    class CreateUsageReportSubscriptionResult(Mapping):
        pass
    
    class CreateUserRequest(Mapping):
        pass
    
    class CreateUserResult(Mapping):
        pass
    
    class DeleteDirectoryConfigRequest(Mapping):
        pass
    
    class DeleteDirectoryConfigResult(Mapping):
        pass
    
    class DeleteFleetRequest(Mapping):
        pass
    
    class DeleteFleetResult(Mapping):
        pass
    
    class DeleteImageRequest(Mapping):
        pass
    
    class DeleteImageResult(Mapping):
        pass
    
    class DeleteImageBuilderRequest(Mapping):
        pass
    
    class DeleteImageBuilderResult(Mapping):
        pass
    
    class DeleteImagePermissionsRequest(Mapping):
        pass
    
    class DeleteImagePermissionsResult(Mapping):
        pass
    
    class DeleteStackRequest(Mapping):
        pass
    
    class DeleteStackResult(Mapping):
        pass
    
    class DeleteUsageReportSubscriptionRequest(Mapping):
        pass
    
    class DeleteUsageReportSubscriptionResult(Mapping):
        pass
    
    class DeleteUserRequest(Mapping):
        pass
    
    class DeleteUserResult(Mapping):
        pass
    
    class DescribeDirectoryConfigsRequest(Mapping):
        pass
    
    class DescribeDirectoryConfigsResult(Mapping):
        pass
    
    class DirectoryName(object):
        pass
    
    class DescribeFleetsRequest(Mapping):
        pass
    
    class DescribeFleetsResult(Mapping):
        pass
    
    class String(object):
        pass
    
    class DescribeImageBuildersRequest(Mapping):
        pass
    
    class DescribeImageBuildersResult(Mapping):
        pass
    
    class DescribeImagePermissionsRequest(Mapping):
        pass
    
    class DescribeImagePermissionsResult(Mapping):
        pass
    
    class AwsAccountId(object):
        pass
    
    class DescribeImagesRequest(Mapping):
        pass
    
    class DescribeImagesResult(Mapping):
        pass
    
    class Arn(object):
        pass
    
    class Describ