/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.overlay;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.overlay.OverlayHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;

public class OverlayChecker
implements ContentChecker,
DocumentValidator {
    private final ValidationContext context;
    private final Report report;
    private final String path;

    public OverlayChecker(ValidationContext context) {
        Preconditions.checkState((boolean)"application/smil+xml".equals(context.mimeType));
        this.context = context;
        this.report = context.report;
        this.path = context.path;
    }

    @Override
    public void runChecks() {
        OCFPackage ocf = (OCFPackage)this.context.ocf.get();
        if (!ocf.hasEntry(this.path)) {
            this.report.message(MessageId.RSC_001, EPUBLocation.create(ocf.getName()), this.path);
        } else if (!ocf.canDecrypt(this.path)) {
            this.report.message(MessageId.RSC_004, EPUBLocation.create(ocf.getName()), this.path);
        } else {
            this.validate();
        }
    }

    @Override
    public boolean validate() {
        int fatalErrorsSoFar = this.report.getFatalErrorCount();
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        XMLParser overlayParser = new XMLParser(this.context);
        OverlayHandler overlayHandler = new OverlayHandler(this.context, overlayParser);
        overlayParser.addValidator(XMLValidators.MO_30_RNC.get());
        overlayParser.addValidator(XMLValidators.MO_30_SCH.get());
        overlayParser.addXMLHandler(overlayHandler);
        overlayParser.process();
        return fatalErrorsSoFar == this.report.getFatalErrorCount() && errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }
}

