import datetime
from http import HTTPStatus
from typing import Any, Optional, Union

import requests

from ...client import AuthenticatedClient, Client
from ...models.exploits_api_v1_report_date_retrieve_response_200 import (
    ExploitsApiV1ReportDateRetrieveResponse200,
)
from ...types import UNSET, Response, Unset

QUERY_PARAMS = {}


def _get_kwargs(
    date: datetime.date,
    *,
    client: AuthenticatedClient,
) -> dict[str, Any]:
    headers: dict[str, Any] = client.get_headers()

    _kwargs: dict[str, Any] = {
        "url": f"{client.base_url}/exploits/api/v1/report/date/{date}".format(
            date=date,
        ),
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: requests.Response
) -> Optional[ExploitsApiV1ReportDateRetrieveResponse200]:
    if response.status_code == 200:
        _response_200 = response.json()
        response_200: ExploitsApiV1ReportDateRetrieveResponse200
        if isinstance(_response_200, Unset):
            response_200 = UNSET
        else:
            response_200 = ExploitsApiV1ReportDateRetrieveResponse200.from_dict(
                _response_200
            )

        return response_200


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: requests.Response
) -> Response[ExploitsApiV1ReportDateRetrieveResponse200]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    date: datetime.date,
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV1ReportDateRetrieveResponse200]:
    r"""API endpoint for getting date based report for Incident Response.

    Format of results:
    ```
    {
      \"cutoff_date\": <Date>,
      \"evaluated_cves\": <Number of new CVEs with exploits>,
      \"action_required\": [<List of affects requiring action>],
      \"no_action\": [<List of CVEs not requiring action with reason>],
      \"not_relevant\": [<List of CVEs which are not in the database with reason>],
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as data is limited by date and is expected
              to be fairly small. Also, because data is broken into three categories it is not
              exactly obvious how to create pages.

    Args:
        date (datetime.date):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ExploitsApiV1ReportDateRetrieveResponse200]
    """

    kwargs = _get_kwargs(
        date=date,
        client=client,
    )

    response = requests.get(
        verify=client.verify_ssl,
        auth=client.auth,
        timeout=client.timeout,
        **kwargs,
    )
    response.raise_for_status()

    return _build_response(client=client, response=response)


def sync(
    date: datetime.date,
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV1ReportDateRetrieveResponse200]:
    r"""API endpoint for getting date based report for Incident Response.

    Format of results:
    ```
    {
      \"cutoff_date\": <Date>,
      \"evaluated_cves\": <Number of new CVEs with exploits>,
      \"action_required\": [<List of affects requiring action>],
      \"no_action\": [<List of CVEs not requiring action with reason>],
      \"not_relevant\": [<List of CVEs which are not in the database with reason>],
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as data is limited by date and is expected
              to be fairly small. Also, because data is broken into three categories it is not
              exactly obvious how to create pages.

    Args:
        date (datetime.date):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ExploitsApiV1ReportDateRetrieveResponse200
    """

    return sync_detailed(
        date=date,
        client=client,
    ).parsed


async def asyncio_detailed(
    date: datetime.date,
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV1ReportDateRetrieveResponse200]:
    r"""API endpoint for getting date based report for Incident Response.

    Format of results:
    ```
    {
      \"cutoff_date\": <Date>,
      \"evaluated_cves\": <Number of new CVEs with exploits>,
      \"action_required\": [<List of affects requiring action>],
      \"no_action\": [<List of CVEs not requiring action with reason>],
      \"not_relevant\": [<List of CVEs which are not in the database with reason>],
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as data is limited by date and is expected
              to be fairly small. Also, because data is broken into three categories it is not
              exactly obvious how to create pages.

    Args:
        date (datetime.date):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ExploitsApiV1ReportDateRetrieveResponse200]
    """

    kwargs = _get_kwargs(
        date=date,
        client=client,
    )

    async with client.get_async_session().get(
        verify_ssl=client.verify_ssl, raise_for_status=True, **kwargs
    ) as response:
        content = await response.read()
        resp = requests.Response()
        resp.status_code = response.status
        resp._content = content

    return _build_response(client=client, response=resp)


async def asyncio(
    date: datetime.date,
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV1ReportDateRetrieveResponse200]:
    r"""API endpoint for getting date based report for Incident Response.

    Format of results:
    ```
    {
      \"cutoff_date\": <Date>,
      \"evaluated_cves\": <Number of new CVEs with exploits>,
      \"action_required\": [<List of affects requiring action>],
      \"no_action\": [<List of CVEs not requiring action with reason>],
      \"not_relevant\": [<List of CVEs which are not in the database with reason>],
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as data is limited by date and is expected
              to be fairly small. Also, because data is broken into three categories it is not
              exactly obvious how to create pages.

    Args:
        date (datetime.date):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ExploitsApiV1ReportDateRetrieveResponse200
    """

    return (
        await asyncio_detailed(
            date=date,
            client=client,
        )
    ).parsed
