from http import HTTPStatus
from typing import Any, Optional, Union

import requests

from ...client import AuthenticatedClient, Client
from ...models.exploits_api_v2_report_pending_retrieve_response_200 import (
    ExploitsApiV2ReportPendingRetrieveResponse200,
)
from ...types import UNSET, Response, Unset

QUERY_PARAMS = {}


def _get_kwargs(
    *,
    client: AuthenticatedClient,
) -> dict[str, Any]:
    headers: dict[str, Any] = client.get_headers()

    _kwargs: dict[str, Any] = {
        "url": f"{client.base_url}/exploits/api/v2/report/pending",
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: requests.Response
) -> Optional[ExploitsApiV2ReportPendingRetrieveResponse200]:
    if response.status_code == 200:
        _response_200 = response.json()
        response_200: ExploitsApiV2ReportPendingRetrieveResponse200
        if isinstance(_response_200, Unset):
            response_200 = UNSET
        else:
            response_200 = ExploitsApiV2ReportPendingRetrieveResponse200.from_dict(
                _response_200
            )

        return response_200


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: requests.Response
) -> Response[ExploitsApiV2ReportPendingRetrieveResponse200]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV2ReportPendingRetrieveResponse200]:
    r"""API endpoint for getting a report of pending actions for Incident Response.

    Format of results:
    ```
    {
      \"pending_actions\": [<List of affects requiring action>],
      \"pending_actions_count\": <Number of affects requiring action>,
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as it is expected that the size of
              the list of pending actions will be mostly stable. Also, the paging cannot be done on
              the query level, as additional analysis of every exploit is required before a decision
              to include it in this report is done.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ExploitsApiV2ReportPendingRetrieveResponse200]
    """

    kwargs = _get_kwargs(
        client=client,
    )

    response = requests.get(
        verify=client.verify_ssl,
        auth=client.auth,
        timeout=client.timeout,
        **kwargs,
    )
    response.raise_for_status()

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV2ReportPendingRetrieveResponse200]:
    r"""API endpoint for getting a report of pending actions for Incident Response.

    Format of results:
    ```
    {
      \"pending_actions\": [<List of affects requiring action>],
      \"pending_actions_count\": <Number of affects requiring action>,
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as it is expected that the size of
              the list of pending actions will be mostly stable. Also, the paging cannot be done on
              the query level, as additional analysis of every exploit is required before a decision
              to include it in this report is done.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ExploitsApiV2ReportPendingRetrieveResponse200
    """

    return sync_detailed(
        client=client,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV2ReportPendingRetrieveResponse200]:
    r"""API endpoint for getting a report of pending actions for Incident Response.

    Format of results:
    ```
    {
      \"pending_actions\": [<List of affects requiring action>],
      \"pending_actions_count\": <Number of affects requiring action>,
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as it is expected that the size of
              the list of pending actions will be mostly stable. Also, the paging cannot be done on
              the query level, as additional analysis of every exploit is required before a decision
              to include it in this report is done.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ExploitsApiV2ReportPendingRetrieveResponse200]
    """

    kwargs = _get_kwargs(
        client=client,
    )

    async with client.get_async_session().get(
        verify_ssl=client.verify_ssl, raise_for_status=True, **kwargs
    ) as response:
        content = await response.read()
        resp = requests.Response()
        resp.status_code = response.status
        resp._content = content

    return _build_response(client=client, response=resp)


async def asyncio(
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV2ReportPendingRetrieveResponse200]:
    r"""API endpoint for getting a report of pending actions for Incident Response.

    Format of results:
    ```
    {
      \"pending_actions\": [<List of affects requiring action>],
      \"pending_actions_count\": <Number of affects requiring action>,
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as it is expected that the size of
              the list of pending actions will be mostly stable. Also, the paging cannot be done on
              the query level, as additional analysis of every exploit is required before a decision
              to include it in this report is done.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ExploitsApiV2ReportPendingRetrieveResponse200
    """

    return (
        await asyncio_detailed(
            client=client,
        )
    ).parsed
