import datetime
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from attrs import fields as _attrs_fields
from dateutil.parser import isoparse

from ..types import UNSET, OSIDBModel, Unset

T = TypeVar("T", bound="ExploitsApiV1StatusRetrieveResponse200")


@_attrs_define
class ExploitsApiV1StatusRetrieveResponse200(OSIDBModel):
    """
    Attributes:
        dt (Union[Unset, datetime.datetime]):
        env (Union[Unset, str]):
        exploits_count (Union[Unset, int]):
        exploits_count_relevant (Union[Unset, int]):
        last_exploit (Union[Unset, int]):
        revision (Union[Unset, str]):
        version (Union[Unset, str]):
    """

    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    exploits_count: Union[Unset, int] = UNSET
    exploits_count_relevant: Union[Unset, int] = UNSET
    last_exploit: Union[Unset, int] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env

        exploits_count = self.exploits_count

        exploits_count_relevant = self.exploits_count_relevant

        last_exploit = self.last_exploit

        revision = self.revision

        version = self.version

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if not isinstance(dt, Unset):
            field_dict["dt"] = dt
        if not isinstance(env, Unset):
            field_dict["env"] = env
        if not isinstance(exploits_count, Unset):
            field_dict["exploits_count"] = exploits_count
        if not isinstance(exploits_count_relevant, Unset):
            field_dict["exploits_count_relevant"] = exploits_count_relevant
        if not isinstance(last_exploit, Unset):
            field_dict["last_exploit"] = last_exploit
        if not isinstance(revision, Unset):
            field_dict["revision"] = revision
        if not isinstance(version, Unset):
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        exploits_count = d.pop("exploits_count", UNSET)

        exploits_count_relevant = d.pop("exploits_count_relevant", UNSET)

        last_exploit = d.pop("last_exploit", UNSET)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_status_retrieve_response_200 = cls(
            dt=dt,
            env=env,
            exploits_count=exploits_count,
            exploits_count_relevant=exploits_count_relevant,
            last_exploit=last_exploit,
            revision=revision,
            version=version,
        )

        exploits_api_v1_status_retrieve_response_200.additional_properties = d
        return exploits_api_v1_status_retrieve_response_200

    @classmethod
    def get_fields(cls):
        return {f.name: f.type for f in _attrs_fields(cls)}

    @classmethod
    def new(cls):
        return cls.from_dict({})

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
