# Generated by Django 2.2.3 on 2019-09-12 20:19

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("core", "0002_auto_20190909_1707"),
    ]

    operations = [
        migrations.CreateModel(
            name="ArchivedPlaylist",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("list_id", models.CharField(max_length=200, unique=True)),
                ("title", models.CharField(max_length=1000)),
                ("counter", models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name="PlaylistEntry",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("index", models.IntegerField()),
                ("url", models.CharField(max_length=200)),
                (
                    "playlist",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="entries",
                        to="core.ArchivedPlaylist",
                    ),
                ),
                (
                    "song",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="playlist_entries",
                        to="core.ArchivedSong",
                    ),
                ),
            ],
            options={"ordering": ["playlist", "index"],},
        ),
        migrations.CreateModel(
            name="ArchivedPlaylistQuery",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("query", models.CharField(max_length=1000)),
                (
                    "playlist",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="queries",
                        to="core.ArchivedPlaylist",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="requestlog",
            name="playlist",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.ArchivedPlaylist",
            ),
        ),
    ]
