exports.id = 726;
exports.ids = [726];
exports.modules = {

/***/ 94378:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

try {
  var util = __webpack_require__(73837);
  /* istanbul ignore next */
  if (typeof util.inherits !== 'function') throw '';
  module.exports = util.inherits;
} catch (e) {
  /* istanbul ignore next */
  module.exports = __webpack_require__(35717);
}


/***/ }),

/***/ 35717:
/***/ ((module) => {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      })
    }
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      var TempCtor = function () {}
      TempCtor.prototype = superCtor.prototype
      ctor.prototype = new TempCtor()
      ctor.prototype.constructor = ctor
    }
  }
}


/***/ }),

/***/ 70919:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FlagError = void 0;
const process_command_args_1 = __webpack_require__(52369);
const legacyError = __webpack_require__(79407);
const drift_1 = __webpack_require__(26445);
const errors_1 = __webpack_require__(55191);
const get_iac_org_settings_1 = __webpack_require__(11693);
const assert_iac_options_flag_1 = __webpack_require__(33111);
const config_1 = __webpack_require__(25425);
const analytics_1 = __webpack_require__(41519);
const analytics = __webpack_require__(82744);
const policy_1 = __webpack_require__(32615);
const driftctl_1 = __webpack_require__(3659);
const types_1 = __webpack_require__(94820);
const error_utils_1 = __webpack_require__(36401);
const error_catalog_nodejs_public_1 = __webpack_require__(88404);
class FlagError extends errors_1.CustomError {
    constructor(flag) {
        const msg = `Unsupported flag "${flag}" provided. Run snyk iac describe --help for supported flags`;
        super(msg);
        this.code = types_1.IaCErrorCodes.FlagError;
        this.strCode = (0, error_utils_1.getErrorStringCode)(this.code);
        this.userMessage = msg;
        this.errorCatalog = new error_catalog_nodejs_public_1.CLI.InvalidFlagOptionError('');
    }
}
exports.FlagError = FlagError;
exports["default"] = async (...args) => {
    var _a, _b;
    const { options } = (0, process_command_args_1.processCommandArgs)(...args);
    // Ensure that this describe command can only be runned when using `snyk iac describe`
    // Avoid `snyk describe` direct usage
    if (options.iac != true) {
        return legacyError('describe');
    }
    if (options['only-managed']) {
        return Promise.reject(new FlagError('only-managed'));
    }
    // Ensure that we are allowed to run that command
    // by checking the entitlement
    const orgPublicId = (_a = options.org) !== null && _a !== void 0 ? _a : config_1.default.org;
    const iacOrgSettings = await (0, get_iac_org_settings_1.getIacOrgSettings)(orgPublicId);
    if (!((_b = iacOrgSettings.entitlements) === null || _b === void 0 ? void 0 : _b.iacDrift)) {
        throw new assert_iac_options_flag_1.UnsupportedEntitlementCommandError('drift', 'iacDrift');
    }
    const policy = await (0, policy_1.findAndLoadPolicy)(process.cwd(), 'iac', options);
    const driftIgnore = (0, drift_1.driftignoreFromPolicy)(policy);
    try {
        const describe = await (0, driftctl_1.runDriftCTL)({
            options: { ...options, kind: 'describe' },
            driftIgnore: driftIgnore,
        });
        process.exitCode = describe.code;
        analytics.add('is-iac-drift', true);
        analytics.add('iac-drift-exit-code', describe.code);
        if (describe.code === driftctl_1.DCTL_EXIT_CODES.EXIT_ERROR) {
            throw new Error();
        }
        // Parse analysis JSON and add to analytics
        const analysis = (0, drift_1.parseDriftAnalysisResults)(describe.stdout);
        (0, analytics_1.addIacDriftAnalytics)(analysis, options);
        const output = await (0, drift_1.processAnalysis)(options, describe);
        process.stdout.write(output);
    }
    catch (e) {
        return Promise.reject(e);
    }
};


/***/ }),

/***/ 8820:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.findAndLoadPolicy = void 0;
const snykPolicyLib = __webpack_require__(13284);
const debugModule = __webpack_require__(15158);
const _1 = __webpack_require__(32615);
const analytics = __webpack_require__(82744);
const debug = debugModule('snyk');
async function findAndLoadPolicy(root, scanType, options, pkg, scannedProjectFolder) {
    const isDocker = scanType === 'docker';
    const isNodeProject = ['npm', 'yarn', 'pnpm'].includes(scanType);
    // monitor
    let policyLocations = [
        options['policy-path'] || scannedProjectFolder || root,
    ];
    if (isDocker) {
        policyLocations = policyLocations.filter((loc) => loc !== root);
    }
    else if (isNodeProject) {
        // TODO: pluckPolicies expects a package.json object to
        // find and apply policies in node_modules
        // TODO: fix these types, this is a hack and is not correct
        policyLocations = policyLocations.concat((0, _1.pluckPolicies)(pkg));
    }
    debug('Potential policy locations found:', policyLocations);
    analytics.add('policies', policyLocations.length);
    analytics.add('policyLocations', policyLocations);
    if (policyLocations.length === 0) {
        return;
    }
    let policy;
    try {
        policy = await snykPolicyLib.load(policyLocations, options);
    }
    catch (err) {
        // note: inline catch, to handle error from .load
        // if the .snyk file wasn't found, it is fine
        if (err.code !== 'ENOENT' && err.code !== 'ENOTDIR') {
            throw err;
        }
    }
    return policy;
}
exports.findAndLoadPolicy = findAndLoadPolicy;


/***/ }),

/***/ 32615:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.findAndLoadPolicy = exports.pluckPolicies = void 0;
var pluck_policies_1 = __webpack_require__(68247);
Object.defineProperty(exports, "pluckPolicies", ({ enumerable: true, get: function () { return pluck_policies_1.pluckPolicies; } }));
var find_and_load_policy_1 = __webpack_require__(8820);
Object.defineProperty(exports, "findAndLoadPolicy", ({ enumerable: true, get: function () { return find_and_load_policy_1.findAndLoadPolicy; } }));


/***/ }),

/***/ 68247:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.pluckPolicies = void 0;
const flatten = __webpack_require__(5800);
function pluckPolicies(pkg) {
    if (!pkg) {
        return [];
    }
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore: broken type
    if (pkg.snyk) {
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore: broken type
        return pkg.snyk;
    }
    if (!pkg.dependencies) {
        return [];
    }
    return flatten(Object.keys(pkg.dependencies)
        .map((name) => pluckPolicies(pkg.dependencies[name]))
        .filter(Boolean));
}
exports.pluckPolicies = pluckPolicies;


/***/ })

};
;
//# sourceMappingURL=726.index.js.map