/// <reference types="node" />
import { Writable } from 'stream';
import { DepGraphData } from '@snyk/dep-graph';
import { Options } from '../types';
export declare function assembleQueryString(options: any): {
    org: string;
    severityThreshold?: boolean | undefined;
    ignorePolicy?: boolean | undefined;
} | null;
export declare enum SEVERITY {
    LOW = "low",
    MEDIUM = "medium",
    HIGH = "high",
    CRITICAL = "critical"
}
export declare const SEVERITIES: Array<{
    verboseName: SEVERITY;
    value: number;
}>;
export declare function colorTextBySeverity(severity: string, textToColor: string): string;
export declare enum FAIL_ON {
    all = "all",
    upgradable = "upgradable",
    patchable = "patchable"
}
export type FailOn = 'all' | 'upgradable' | 'patchable';
export declare const RETRY_ATTEMPTS = 3;
export declare const RETRY_DELAY = 500;
/**
 * printDepGraph writes the given dep-graph and target name to the destination
 * stream as expected by the `depgraph` CLI workflow.
 */
export declare function printDepGraph(depGraph: DepGraphData, targetName: string, destination: Writable): Promise<void>;
export declare function shouldPrintDepGraph(opts: Options): boolean;
