var t={name:"mermaid",version:"11.9.0",description:"Markdown-ish syntax for generating flowcharts, mindmaps, sequence diagrams, class diagrams, gantt charts, git graphs and more.",type:"module",module:"./dist/mermaid.core.mjs",types:"./dist/mermaid.d.ts",exports:{".":{types:"./dist/mermaid.d.ts",import:"./dist/mermaid.core.mjs",default:"./dist/mermaid.core.mjs"},"./*":"./*"},keywords:["diagram","markdown","flowchart","sequence diagram","gantt","class diagram","git graph","mindmap","packet diagram","c4 diagram","er diagram","pie chart","pie diagram","quadrant chart","requirement diagram","graph"],scripts:{clean:"rimraf dist",dev:"pnpm -w dev","docs:code":"typedoc src/defaultConfig.ts src/config.ts src/mermaid.ts && prettier --write ./src/docs/config/setup","docs:build":"rimraf ../../docs && pnpm docs:code && pnpm docs:spellcheck && tsx scripts/docs.cli.mts","docs:verify":"pnpm docs:code && pnpm docs:spellcheck && tsx scripts/docs.cli.mts --verify","docs:pre:vitepress":"pnpm --filter ./src/docs prefetch && rimraf src/vitepress && pnpm docs:code && tsx scripts/docs.cli.mts --vitepress && pnpm --filter ./src/vitepress install --no-frozen-lockfile --ignore-scripts","docs:build:vitepress":"pnpm docs:pre:vitepress && (cd src/vitepress && pnpm run build) && cpy --flat src/docs/landing/ ./src/vitepress/.vitepress/dist/landing","docs:dev":'pnpm docs:pre:vitepress && concurrently "pnpm --filter ./src/vitepress dev" "tsx scripts/docs.cli.mts --watch --vitepress"',"docs:dev:docker":'pnpm docs:pre:vitepress && concurrently "pnpm --filter ./src/vitepress dev:docker" "tsx scripts/docs.cli.mts --watch --vitepress"',"docs:serve":"pnpm docs:build:vitepress && vitepress serve src/vitepress","docs:spellcheck":'cspell "src/docs/**/*.md"',"docs:release-version":"tsx scripts/update-release-version.mts","docs:verify-version":"tsx scripts/update-release-version.mts --verify","types:build-config":"tsx scripts/create-types-from-json-schema.mts","types:verify-config":"tsx scripts/create-types-from-json-schema.mts --verify",checkCircle:"npx madge --circular ./src",prepublishOnly:"pnpm docs:verify-version"},repository:{type:"git",url:"https://github.com/mermaid-js/mermaid"},author:"Knut Sveidqvist",license:"MIT",standard:{ignore:["**/parser/*.js","dist/**/*.js","cypress/**/*.js"],globals:["page"]},dependencies:{"@braintree/sanitize-url":"^7.0.4","@iconify/utils":"^2.1.33","@mermaid-js/parser":"workspace:^","@types/d3":"^7.4.3",cytoscape:"^3.29.3","cytoscape-cose-bilkent":"^4.1.0","cytoscape-fcose":"^2.2.0",d3:"^7.9.0","d3-sankey":"^0.12.3","dagre-d3-es":"7.0.11",dayjs:"^1.11.13",dompurify:"^3.2.5",katex:"^0.16.22",khroma:"^2.1.0","lodash-es":"^4.17.21",marked:"^16.0.0",roughjs:"^4.6.6",stylis:"^4.3.6","ts-dedent":"^2.2.0",uuid:"^11.1.0"},devDependencies:{"@adobe/jsonschema2md":"^8.0.2","@iconify/types":"^2.0.0","@types/cytoscape":"^3.21.9","@types/cytoscape-fcose":"^2.2.4","@types/d3-sankey":"^0.12.4","@types/d3-scale":"^4.0.9","@types/d3-scale-chromatic":"^3.1.0","@types/d3-selection":"^3.0.11","@types/d3-shape":"^3.1.7","@types/jsdom":"^21.1.7","@types/katex":"^0.16.7","@types/lodash-es":"^4.17.12","@types/micromatch":"^4.0.9","@types/stylis":"^4.2.7","@types/uuid":"^10.0.0",ajv:"^8.17.1",canvas:"^3.1.0",chokidar:"3.6.0",concurrently:"^9.1.2","csstree-validator":"^4.0.1",globby:"^14.0.2",jison:"^0.4.18","js-base64":"^3.7.7",jsdom:"^26.1.0","json-schema-to-typescript":"^15.0.4",micromatch:"^4.0.8","path-browserify":"^1.0.1",prettier:"^3.5.2",remark:"^15.0.1","remark-frontmatter":"^5.0.0","remark-gfm":"^4.0.1",rimraf:"^6.0.1","start-server-and-test":"^2.0.10","type-fest":"^4.35.0",typedoc:"^0.27.8","typedoc-plugin-markdown":"^4.4.2",typescript:"~5.7.3","unist-util-flatmap":"^1.0.0","unist-util-visit":"^5.0.0",vitepress:"^1.0.2","vitepress-plugin-search":"1.0.4-alpha.22"},files:["dist/","README.md"],publishConfig:{access:"public"}},e=Object.create,r=Object.defineProperty,i=Object.getOwnPropertyDescriptor,n=Object.getOwnPropertyNames,a=Object.getPrototypeOf,o=Object.prototype.hasOwnProperty,s=(t,e)=>r(t,"name",{value:e,configurable:!0}),l=(t,e)=>()=>(e||t((e={exports:{}}).exports,e),e.exports),h=(t,e)=>{for(var i in e)r(t,i,{get:e[i],enumerable:!0})},c=(t,e,a,s)=>{if(e&&"object"==typeof e||"function"==typeof e)for(let l of n(e))!o.call(t,l)&&l!==a&&r(t,l,{get:()=>e[l],enumerable:!(s=i(e,l))||s.enumerable});return t},u=(t,e,r)=>(c(t,e,"default"),r),d=(t,i,n)=>(n=null!=t?e(a(t)):{},c(r(n,"default",{value:t,enumerable:!0}),t)),p=l((t,e)=>{!function(r,i){"object"==typeof t&&typeof e<"u"?e.exports=i():"function"==typeof define&&define.amd?define(i):(r=typeof globalThis<"u"?globalThis:r||self).dayjs=i()}(t,function(){var t=6e4,e=36e5,r="millisecond",i="second",n="minute",a="hour",o="day",l="week",h="month",c="quarter",u="year",d="date",p="Invalid Date",f=/^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/,g=/\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g,y={name:"en",weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),ordinal:s(function(t){var e=["th","st","nd","rd"],r=t%100;return"["+t+(e[(r-20)%10]||e[r]||e[0])+"]"},"ordinal")},m=s(function(t,e,r){var i=String(t);return!i||i.length>=e?t:""+Array(e+1-i.length).join(r)+t},"m"),x={s:m,z:s(function(t){var e=-t.utcOffset(),r=Math.abs(e),i=Math.floor(r/60),n=r%60;return(e<=0?"+":"-")+m(i,2,"0")+":"+m(n,2,"0")},"z"),m:s(function t(e,r){if(e.date()<r.date())return-t(r,e);var i=12*(r.year()-e.year())+(r.month()-e.month()),n=e.clone().add(i,h),a=r-n<0,o=e.clone().add(i+(a?-1:1),h);return+(-(i+(r-n)/(a?n-o:o-n))||0)},"t"),a:s(function(t){return t<0?Math.ceil(t)||0:Math.floor(t)},"a"),p:s(function(t){return{M:h,y:u,w:l,d:o,D:d,h:a,m:n,s:i,ms:r,Q:c}[t]||String(t||"").toLowerCase().replace(/s$/,"")},"p"),u:s(function(t){return void 0===t},"u")},b="en",C={};C[b]=y;var k="$isDayjsObject",w=s(function(t){return t instanceof T||!(!t||!t[k])},"S"),_=s(function t(e,r,i){var n;if(!e)return b;if("string"==typeof e){var a=e.toLowerCase();C[a]&&(n=a),r&&(C[a]=r,n=a);var o=e.split("-");if(!n&&o.length>1)return t(o[0])}else{var s=e.name;C[s]=e,n=s}return!i&&n&&(b=n),n||!i&&b},"t"),v=s(function(t,e){if(w(t))return t.clone();var r="object"==typeof e?e:{};return r.date=t,r.args=arguments,new T(r)},"O"),S=x;S.l=_,S.i=w,S.w=function(t,e){return v(t,{locale:e.$L,utc:e.$u,x:e.$x,$offset:e.$offset})};var T=function(){function y(t){this.$L=_(t.locale,null,!0),this.parse(t),this.$x=this.$x||t.x||{},this[k]=!0}s(y,"M");var m=y.prototype;return m.parse=function(t){this.$d=function(t){var e=t.date,r=t.utc;if(null===e)return new Date(NaN);if(S.u(e))return new Date;if(e instanceof Date)return new Date(e);if("string"==typeof e&&!/Z$/i.test(e)){var i=e.match(f);if(i){var n=i[2]-1||0,a=(i[7]||"0").substring(0,3);return r?new Date(Date.UTC(i[1],n,i[3]||1,i[4]||0,i[5]||0,i[6]||0,a)):new Date(i[1],n,i[3]||1,i[4]||0,i[5]||0,i[6]||0,a)}}return new Date(e)}(t),this.init()},m.init=function(){var t=this.$d;this.$y=t.getFullYear(),this.$M=t.getMonth(),this.$D=t.getDate(),this.$W=t.getDay(),this.$H=t.getHours(),this.$m=t.getMinutes(),this.$s=t.getSeconds(),this.$ms=t.getMilliseconds()},m.$utils=function(){return S},m.isValid=function(){return this.$d.toString()!==p},m.isSame=function(t,e){var r=v(t);return this.startOf(e)<=r&&r<=this.endOf(e)},m.isAfter=function(t,e){return v(t)<this.startOf(e)},m.isBefore=function(t,e){return this.endOf(e)<v(t)},m.$g=function(t,e,r){return S.u(t)?this[e]:this.set(r,t)},m.unix=function(){return Math.floor(this.valueOf()/1e3)},m.valueOf=function(){return this.$d.getTime()},m.startOf=function(t,e){var r=this,c=!!S.u(e)||e,p=S.p(t),f=s(function(t,e){var i=S.w(r.$u?Date.UTC(r.$y,e,t):new Date(r.$y,e,t),r);return c?i:i.endOf(o)},"l"),g=s(function(t,e){return S.w(r.toDate()[t].apply(r.toDate("s"),(c?[0,0,0,0]:[23,59,59,999]).slice(e)),r)},"$"),y=this.$W,m=this.$M,x=this.$D,b="set"+(this.$u?"UTC":"");switch(p){case u:return c?f(1,0):f(31,11);case h:return c?f(1,m):f(0,m+1);case l:var C=this.$locale().weekStart||0,k=(y<C?y+7:y)-C;return f(c?x-k:x+(6-k),m);case o:case d:return g(b+"Hours",0);case a:return g(b+"Minutes",1);case n:return g(b+"Seconds",2);case i:return g(b+"Milliseconds",3);default:return this.clone()}},m.endOf=function(t){return this.startOf(t,!1)},m.$set=function(t,e){var s,l=S.p(t),c="set"+(this.$u?"UTC":""),p=(s={},s[o]=c+"Date",s[d]=c+"Date",s[h]=c+"Month",s[u]=c+"FullYear",s[a]=c+"Hours",s[n]=c+"Minutes",s[i]=c+"Seconds",s[r]=c+"Milliseconds",s)[l],f=l===o?this.$D+(e-this.$W):e;if(l===h||l===u){var g=this.clone().set(d,1);g.$d[p](f),g.init(),this.$d=g.set(d,Math.min(this.$D,g.daysInMonth())).$d}else p&&this.$d[p](f);return this.init(),this},m.set=function(t,e){return this.clone().$set(t,e)},m.get=function(t){return this[S.p(t)]()},m.add=function(r,c){var d,p=this;r=Number(r);var f=S.p(c),g=s(function(t){var e=v(p);return S.w(e.date(e.date()+Math.round(t*r)),p)},"y");if(f===h)return this.set(h,this.$M+r);if(f===u)return this.set(u,this.$y+r);if(f===o)return g(1);if(f===l)return g(7);var y=(d={},d[n]=t,d[a]=e,d[i]=1e3,d)[f]||1,m=this.$d.getTime()+r*y;return S.w(m,this)},m.subtract=function(t,e){return this.add(-1*t,e)},m.format=function(t){var e=this,r=this.$locale();if(!this.isValid())return r.invalidDate||p;var i=t||"YYYY-MM-DDTHH:mm:ssZ",n=S.z(this),a=this.$H,o=this.$m,l=this.$M,h=r.weekdays,c=r.months,u=r.meridiem,d=s(function(t,r,n,a){return t&&(t[r]||t(e,i))||n[r].slice(0,a)},"h"),f=s(function(t){return S.s(a%12||12,t,"0")},"d"),y=u||function(t,e,r){var i=t<12?"AM":"PM";return r?i.toLowerCase():i};return i.replace(g,function(t,i){return i||function(t){switch(t){case"YY":return String(e.$y).slice(-2);case"YYYY":return S.s(e.$y,4,"0");case"M":return l+1;case"MM":return S.s(l+1,2,"0");case"MMM":return d(r.monthsShort,l,c,3);case"MMMM":return d(c,l);case"D":return e.$D;case"DD":return S.s(e.$D,2,"0");case"d":return String(e.$W);case"dd":return d(r.weekdaysMin,e.$W,h,2);case"ddd":return d(r.weekdaysShort,e.$W,h,3);case"dddd":return h[e.$W];case"H":return String(a);case"HH":return S.s(a,2,"0");case"h":return f(1);case"hh":return f(2);case"a":return y(a,o,!0);case"A":return y(a,o,!1);case"m":return String(o);case"mm":return S.s(o,2,"0");case"s":return String(e.$s);case"ss":return S.s(e.$s,2,"0");case"SSS":return S.s(e.$ms,3,"0");case"Z":return n}return null}(t)||n.replace(":","")})},m.utcOffset=function(){return 15*-Math.round(this.$d.getTimezoneOffset()/15)},m.diff=function(r,d,p){var f,g=this,y=S.p(d),m=v(r),x=(m.utcOffset()-this.utcOffset())*t,b=this-m,C=s(function(){return S.m(g,m)},"D");switch(y){case u:f=C()/12;break;case h:f=C();break;case c:f=C()/3;break;case l:f=(b-x)/6048e5;break;case o:f=(b-x)/864e5;break;case a:f=b/e;break;case n:f=b/t;break;case i:f=b/1e3;break;default:f=b}return p?f:S.a(f)},m.daysInMonth=function(){return this.endOf(h).$D},m.$locale=function(){return C[this.$L]},m.locale=function(t,e){if(!t)return this.$L;var r=this.clone(),i=_(t,e,!0);return i&&(r.$L=i),r},m.clone=function(){return S.w(this.$d,this)},m.toDate=function(){return new Date(this.valueOf())},m.toJSON=function(){return this.isValid()?this.toISOString():null},m.toISOString=function(){return this.$d.toISOString()},m.toString=function(){return this.$d.toUTCString()},y}(),M=T.prototype;return v.prototype=M,[["$ms",r],["$s",i],["$m",n],["$H",a],["$W",o],["$M",h],["$y",u],["$D",d]].forEach(function(t){M[t[1]]=function(e){return this.$g(e,t[0],t[1])}}),v.extend=function(t,e){return t.$i||(t(e,T,v),t.$i=!0),v},v.locale=_,v.isDayjs=w,v.unix=function(t){return v(1e3*t)},v.en=C[b],v.Ls=C,v.p={},v})}),f=d(p()),g={trace:0,debug:1,info:2,warn:3,error:4,fatal:5},y={trace:s((...t)=>{},"trace"),debug:s((...t)=>{},"debug"),info:s((...t)=>{},"info"),warn:s((...t)=>{},"warn"),error:s((...t)=>{},"error"),fatal:s((...t)=>{},"fatal")},m=s(function(t="fatal"){let e=g.fatal;"string"==typeof t?t.toLowerCase()in g&&(e=g[t]):"number"==typeof t&&(e=t),y.trace=()=>{},y.debug=()=>{},y.info=()=>{},y.warn=()=>{},y.error=()=>{},y.fatal=()=>{},e<=g.fatal&&(y.fatal=console.error?console.error.bind(console,x("FATAL"),"color: orange"):console.log.bind(console,"[35m",x("FATAL"))),e<=g.error&&(y.error=console.error?console.error.bind(console,x("ERROR"),"color: orange"):console.log.bind(console,"[31m",x("ERROR"))),e<=g.warn&&(y.warn=console.warn?console.warn.bind(console,x("WARN"),"color: orange"):console.log.bind(console,"[33m",x("WARN"))),e<=g.info&&(y.info=console.info?console.info.bind(console,x("INFO"),"color: lightblue"):console.log.bind(console,"[34m",x("INFO"))),e<=g.debug&&(y.debug=console.debug?console.debug.bind(console,x("DEBUG"),"color: lightgreen"):console.log.bind(console,"[32m",x("DEBUG"))),e<=g.trace&&(y.trace=console.debug?console.debug.bind(console,x("TRACE"),"color: lightgreen"):console.log.bind(console,"[32m",x("TRACE")))},"setLogLevel"),x=s(t=>`%c${(0,f.default)().format("ss.SSS")} : ${t} : `,"format"),b=/^-{3}\s*[\n\r](.*?)[\n\r]-{3}\s*[\n\r]+/s,C=/%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi,k=/\s*%%.*\n/gm,w=class extends Error{static{s(this,"UnknownDiagramError")}constructor(t){super(t),this.name="UnknownDiagramError"}},_={},v=s(function(t,e){t=t.replace(b,"").replace(C,"").replace(k,"\n");for(let[r,{detector:i}]of Object.entries(_))if(i(t,e))return r;throw new w(`No diagram type detected matching given configuration for text: ${t}`)},"detectType"),S=s((...t)=>{for(let{id:e,detector:r,loader:i}of t)T(e,r,i)},"registerLazyLoadedDiagrams"),T=s((t,e,r)=>{_[t]&&y.warn(`Detector with key ${t} already exists. Overwriting.`),_[t]={detector:e,loader:r},y.debug(`Detector with key ${t} added${r?" with loader":""}`)},"addDetector"),M=s(t=>_[t].loader,"getDiagramLoader"),B=s((t,e,{depth:r=2,clobber:i=!1}={})=>{let n={depth:r,clobber:i};return Array.isArray(e)&&!Array.isArray(t)?(e.forEach(e=>B(t,e,n)),t):Array.isArray(e)&&Array.isArray(t)?(e.forEach(e=>{t.includes(e)||t.push(e)}),t):void 0===t||r<=0?null!=t&&"object"==typeof t&&"object"==typeof e?Object.assign(t,e):e:(void 0!==e&&"object"==typeof t&&"object"==typeof e&&Object.keys(e).forEach(n=>{"object"!=typeof e[n]||void 0!==t[n]&&"object"!=typeof t[n]?(i||"object"!=typeof t[n]&&"object"!=typeof e[n])&&(t[n]=e[n]):(void 0===t[n]&&(t[n]=Array.isArray(e[n])?[]:{}),t[n]=B(t[n],e[n],{depth:r-1,clobber:i}))}),t)},"assignWithDepth"),A=B,F={min:{r:0,g:0,b:0,s:0,l:0,a:0},max:{r:255,g:255,b:255,h:360,s:100,l:100,a:1},clamp:{r:s(t=>t>=255?255:t<0?0:t,"r"),g:s(t=>t>=255?255:t<0?0:t,"g"),b:s(t=>t>=255?255:t<0?0:t,"b"),h:s(t=>t%360,"h"),s:s(t=>t>=100?100:t<0?0:t,"s"),l:s(t=>t>=100?100:t<0?0:t,"l"),a:s(t=>t>=1?1:t<0?0:t,"a")},toLinear:s(t=>{let e=t/255;return t>.03928?Math.pow((e+.055)/1.055,2.4):e/12.92},"toLinear"),hue2rgb:s((t,e,r)=>(r<0&&(r+=1),r>1&&(r-=1),r<.16666666666666666?t+6*(e-t)*r:r<.5?e:r<.6666666666666666?t+(e-t)*(.6666666666666666-r)*6:t),"hue2rgb"),hsl2rgb:s(({h:t,s:e,l:r},i)=>{if(!e)return 2.55*r;t/=360,e/=100;let n=(r/=100)<.5?r*(1+e):r+e-r*e,a=2*r-n;switch(i){case"r":return 255*F.hue2rgb(a,n,t+.3333333333333333);case"g":return 255*F.hue2rgb(a,n,t);case"b":return 255*F.hue2rgb(a,n,t-.3333333333333333)}},"hsl2rgb"),rgb2hsl:s(({r:t,g:e,b:r},i)=>{t/=255,e/=255,r/=255;let n=Math.max(t,e,r),a=Math.min(t,e,r),o=(n+a)/2;if("l"===i)return 100*o;if(n===a)return 0;let s=n-a;if("s"===i)return 100*(o>.5?s/(2-n-a):s/(n+a));switch(n){case t:return 60*((e-r)/s+(e<r?6:0));case e:return 60*((r-t)/s+2);case r:return 60*((t-e)/s+4);default:return-1}},"rgb2hsl")},L=F,$={clamp:s((t,e,r)=>e>r?Math.min(e,Math.max(r,t)):Math.min(r,Math.max(e,t)),"clamp"),round:s(t=>Math.round(1e10*t)/1e10,"round")},E=$,D={dec2hex:s(t=>{let e=Math.round(t).toString(16);return e.length>1?e:`0${e}`},"dec2hex")},O={channel:L,lang:E,unit:D},I={};for(let t=0;t<=255;t++)I[t]=O.unit.dec2hex(t);var N,R=0,P=1,z=2,q=class{static{s(this,"Type")}constructor(){this.type=R}get(){return this.type}set(t){if(this.type&&this.type!==t)throw new Error("Cannot change both RGB and HSL channels at the same time");this.type=t}reset(){this.type=R}is(t){return this.type===t}},j=q,W=class{static{s(this,"Channels")}constructor(t,e){this.color=e,this.changed=!1,this.data=t,this.type=new j}set(t,e){return this.color=e,this.changed=!1,this.data=t,this.type.type=R,this}_ensureHSL(){let t=this.data,{h:e,s:r,l:i}=t;void 0===e&&(t.h=O.channel.rgb2hsl(t,"h")),void 0===r&&(t.s=O.channel.rgb2hsl(t,"s")),void 0===i&&(t.l=O.channel.rgb2hsl(t,"l"))}_ensureRGB(){let t=this.data,{r:e,g:r,b:i}=t;void 0===e&&(t.r=O.channel.hsl2rgb(t,"r")),void 0===r&&(t.g=O.channel.hsl2rgb(t,"g")),void 0===i&&(t.b=O.channel.hsl2rgb(t,"b"))}get r(){let t=this.data,e=t.r;return this.type.is(z)||void 0===e?(this._ensureHSL(),O.channel.hsl2rgb(t,"r")):e}get g(){let t=this.data,e=t.g;return this.type.is(z)||void 0===e?(this._ensureHSL(),O.channel.hsl2rgb(t,"g")):e}get b(){let t=this.data,e=t.b;return this.type.is(z)||void 0===e?(this._ensureHSL(),O.channel.hsl2rgb(t,"b")):e}get h(){let t=this.data,e=t.h;return this.type.is(P)||void 0===e?(this._ensureRGB(),O.channel.rgb2hsl(t,"h")):e}get s(){let t=this.data,e=t.s;return this.type.is(P)||void 0===e?(this._ensureRGB(),O.channel.rgb2hsl(t,"s")):e}get l(){let t=this.data,e=t.l;return this.type.is(P)||void 0===e?(this._ensureRGB(),O.channel.rgb2hsl(t,"l")):e}get a(){return this.data.a}set r(t){this.type.set(P),this.changed=!0,this.data.r=t}set g(t){this.type.set(P),this.changed=!0,this.data.g=t}set b(t){this.type.set(P),this.changed=!0,this.data.b=t}set h(t){this.type.set(z),this.changed=!0,this.data.h=t}set s(t){this.type.set(z),this.changed=!0,this.data.s=t}set l(t){this.type.set(z),this.changed=!0,this.data.l=t}set a(t){this.changed=!0,this.data.a=t}},H=new W({r:0,g:0,b:0,a:0},"transparent"),U={re:/^#((?:[a-f0-9]{2}){2,4}|[a-f0-9]{3})$/i,parse:s(t=>{if(35!==t.charCodeAt(0))return;let e=t.match(U.re);if(!e)return;let r=e[1],i=parseInt(r,16),n=r.length,a=n%4==0,o=n>4,s=o?1:17,l=o?8:4,h=a?0:-1,c=o?255:15;return H.set({r:(i>>l*(h+3)&c)*s,g:(i>>l*(h+2)&c)*s,b:(i>>l*(h+1)&c)*s,a:a?(i&c)*s/255:1},t)},"parse"),stringify:s(t=>{let{r:e,g:r,b:i,a:n}=t;return n<1?`#${I[Math.round(e)]}${I[Math.round(r)]}${I[Math.round(i)]}${I[Math.round(255*n)]}`:`#${I[Math.round(e)]}${I[Math.round(r)]}${I[Math.round(i)]}`},"stringify")},Y=U,V={re:/^hsla?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(?:deg|grad|rad|turn)?)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(%)?))?\s*?\)$/i,hueRe:/^(.+?)(deg|grad|rad|turn)$/i,_hue2deg:s(t=>{let e=t.match(V.hueRe);if(e){let[,t,r]=e;switch(r){case"grad":return O.channel.clamp.h(.9*parseFloat(t));case"rad":return O.channel.clamp.h(180*parseFloat(t)/Math.PI);case"turn":return O.channel.clamp.h(360*parseFloat(t))}}return O.channel.clamp.h(parseFloat(t))},"_hue2deg"),parse:s(t=>{let e=t.charCodeAt(0);if(104!==e&&72!==e)return;let r=t.match(V.re);if(!r)return;let[,i,n,a,o,s]=r;return H.set({h:V._hue2deg(i),s:O.channel.clamp.s(parseFloat(n)),l:O.channel.clamp.l(parseFloat(a)),a:o?O.channel.clamp.a(s?parseFloat(o)/100:parseFloat(o)):1},t)},"parse"),stringify:s(t=>{let{h:e,s:r,l:i,a:n}=t;return n<1?`hsla(${O.lang.round(e)}, ${O.lang.round(r)}%, ${O.lang.round(i)}%, ${n})`:`hsl(${O.lang.round(e)}, ${O.lang.round(r)}%, ${O.lang.round(i)}%)`},"stringify")},G=V,X={colors:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyanaqua:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",transparent:"#00000000",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},parse:s(t=>{t=t.toLowerCase();let e=X.colors[t];if(e)return Y.parse(e)},"parse"),stringify:s(t=>{let e=Y.stringify(t);for(let t in X.colors)if(X.colors[t]===e)return t},"stringify")},Z=X,Q={re:/^rgba?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?)))?\s*?\)$/i,parse:s(t=>{let e=t.charCodeAt(0);if(114!==e&&82!==e)return;let r=t.match(Q.re);if(!r)return;let[,i,n,a,o,s,l,h,c]=r;return H.set({r:O.channel.clamp.r(n?2.55*parseFloat(i):parseFloat(i)),g:O.channel.clamp.g(o?2.55*parseFloat(a):parseFloat(a)),b:O.channel.clamp.b(l?2.55*parseFloat(s):parseFloat(s)),a:h?O.channel.clamp.a(c?parseFloat(h)/100:parseFloat(h)):1},t)},"parse"),stringify:s(t=>{let{r:e,g:r,b:i,a:n}=t;return n<1?`rgba(${O.lang.round(e)}, ${O.lang.round(r)}, ${O.lang.round(i)}, ${O.lang.round(n)})`:`rgb(${O.lang.round(e)}, ${O.lang.round(r)}, ${O.lang.round(i)})`},"stringify")},K=Q,J={format:{keyword:Z,hex:Y,rgb:K,rgba:K,hsl:G,hsla:G},parse:s(t=>{if("string"!=typeof t)return t;let e=Y.parse(t)||K.parse(t)||G.parse(t)||Z.parse(t);if(e)return e;throw new Error(`Unsupported color format: "${t}"`)},"parse"),stringify:s(t=>!t.changed&&t.color?t.color:t.type.is(z)||void 0===t.data.r?G.stringify(t):t.a<1||!Number.isInteger(t.r)||!Number.isInteger(t.g)||!Number.isInteger(t.b)?K.stringify(t):Y.stringify(t),"stringify")},tt=J,et=s((t,e)=>{let r=tt.parse(t);for(let t in e)r[t]=O.channel.clamp[t](e[t]);return tt.stringify(r)},"change"),rt=et,it=s((t,e,r=0,i=1)=>{if("number"!=typeof t)return rt(t,{a:e});let n=H.set({r:O.channel.clamp.r(t),g:O.channel.clamp.g(e),b:O.channel.clamp.b(r),a:O.channel.clamp.a(i)});return tt.stringify(n)},"rgba"),nt=it,at=s((t,e)=>O.lang.round(tt.parse(t)[e]),"channel"),ot=at,st=s(t=>{let{r:e,g:r,b:i}=tt.parse(t),n=.2126*O.channel.toLinear(e)+.7152*O.channel.toLinear(r)+.0722*O.channel.toLinear(i);return O.lang.round(n)},"luminance"),lt=st,ht=s(t=>lt(t)>=.5,"isLight"),ct=ht,ut=s(t=>!ct(t),"isDark"),dt=ut,pt=s((t,e,r)=>{let i=tt.parse(t),n=i[e],a=O.channel.clamp[e](n+r);return n!==a&&(i[e]=a),tt.stringify(i)},"adjustChannel"),ft=pt,gt=s((t,e)=>ft(t,"l",e),"lighten"),yt=gt,mt=s((t,e)=>ft(t,"l",-e),"darken"),xt=mt,bt=s((t,e)=>{let r=tt.parse(t),i={};for(let t in e)e[t]&&(i[t]=r[t]+e[t]);return rt(t,i)},"adjust"),Ct=bt,kt=s((t,e,r=50)=>{let{r:i,g:n,b:a,a:o}=tt.parse(t),{r:s,g:l,b:h,a:c}=tt.parse(e),u=r/100,d=2*u-1,p=o-c,f=((d*p===-1?d:(d+p)/(1+d*p))+1)/2,g=1-f;return nt(i*f+s*g,n*f+l*g,a*f+h*g,o*u+c*(1-u))},"mix"),wt=kt,_t=s((t,e=100)=>{let r=tt.parse(t);return r.r=255-r.r,r.g=255-r.g,r.b=255-r.b,wt(r,t,e)},"invert"),vt=_t,St="#ffffff",Tt="#f2f2f2",Mt=s((t,e)=>Ct(t,e?{s:-40,l:10}:{s:-40,l:-10}),"mkBorder"),Bt=class{static{s(this,"Theme")}constructor(){this.background="#f4f4f4",this.primaryColor="#fff4dd",this.noteBkgColor="#fff5ad",this.noteTextColor="#333",this.THEME_COLOR_LIMIT=12,this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px"}updateColors(){if(this.primaryTextColor=this.primaryTextColor||(this.darkMode?"#eee":"#333"),this.secondaryColor=this.secondaryColor||Ct(this.primaryColor,{h:-120}),this.tertiaryColor=this.tertiaryColor||Ct(this.primaryColor,{h:180,l:5}),this.primaryBorderColor=this.primaryBorderColor||Mt(this.primaryColor,this.darkMode),this.secondaryBorderColor=this.secondaryBorderColor||Mt(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=this.tertiaryBorderColor||Mt(this.tertiaryColor,this.darkMode),this.noteBorderColor=this.noteBorderColor||Mt(this.noteBkgColor,this.darkMode),this.noteBkgColor=this.noteBkgColor||"#fff5ad",this.noteTextColor=this.noteTextColor||"#333",this.secondaryTextColor=this.secondaryTextColor||vt(this.secondaryColor),this.tertiaryTextColor=this.tertiaryTextColor||vt(this.tertiaryColor),this.lineColor=this.lineColor||vt(this.background),this.arrowheadColor=this.arrowheadColor||vt(this.background),this.textColor=this.textColor||this.primaryTextColor,this.border2=this.border2||this.tertiaryBorderColor,this.nodeBkg=this.nodeBkg||this.primaryColor,this.mainBkg=this.mainBkg||this.primaryColor,this.nodeBorder=this.nodeBorder||this.primaryBorderColor,this.clusterBkg=this.clusterBkg||this.tertiaryColor,this.clusterBorder=this.clusterBorder||this.tertiaryBorderColor,this.defaultLinkColor=this.defaultLinkColor||this.lineColor,this.titleColor=this.titleColor||this.tertiaryTextColor,this.edgeLabelBackground=this.edgeLabelBackground||(this.darkMode?xt(this.secondaryColor,30):this.secondaryColor),this.nodeTextColor=this.nodeTextColor||this.primaryTextColor,this.actorBorder=this.actorBorder||this.primaryBorderColor,this.actorBkg=this.actorBkg||this.mainBkg,this.actorTextColor=this.actorTextColor||this.primaryTextColor,this.actorLineColor=this.actorLineColor||this.actorBorder,this.labelBoxBkgColor=this.labelBoxBkgColor||this.actorBkg,this.signalColor=this.signalColor||this.textColor,this.signalTextColor=this.signalTextColor||this.textColor,this.labelBoxBorderColor=this.labelBoxBorderColor||this.actorBorder,this.labelTextColor=this.labelTextColor||this.actorTextColor,this.loopTextColor=this.loopTextColor||this.actorTextColor,this.activationBorderColor=this.activationBorderColor||xt(this.secondaryColor,10),this.activationBkgColor=this.activationBkgColor||this.secondaryColor,this.sequenceNumberColor=this.sequenceNumberColor||vt(this.lineColor),this.sectionBkgColor=this.sectionBkgColor||this.tertiaryColor,this.altSectionBkgColor=this.altSectionBkgColor||"white",this.sectionBkgColor=this.sectionBkgColor||this.secondaryColor,this.sectionBkgColor2=this.sectionBkgColor2||this.primaryColor,this.excludeBkgColor=this.excludeBkgColor||"#eeeeee",this.taskBorderColor=this.taskBorderColor||this.primaryBorderColor,this.taskBkgColor=this.taskBkgColor||this.primaryColor,this.activeTaskBorderColor=this.activeTaskBorderColor||this.primaryColor,this.activeTaskBkgColor=this.activeTaskBkgColor||yt(this.primaryColor,23),this.gridColor=this.gridColor||"lightgrey",this.doneTaskBkgColor=this.doneTaskBkgColor||"lightgrey",this.doneTaskBorderColor=this.doneTaskBorderColor||"grey",this.critBorderColor=this.critBorderColor||"#ff8888",this.critBkgColor=this.critBkgColor||"red",this.todayLineColor=this.todayLineColor||"red",this.vertLineColor=this.vertLineColor||"navy",this.taskTextColor=this.taskTextColor||this.textColor,this.taskTextOutsideColor=this.taskTextOutsideColor||this.textColor,this.taskTextLightColor=this.taskTextLightColor||this.textColor,this.taskTextColor=this.taskTextColor||this.primaryTextColor,this.taskTextDarkColor=this.taskTextDarkColor||this.textColor,this.taskTextClickableColor=this.taskTextClickableColor||"#003163",this.personBorder=this.personBorder||this.primaryBorderColor,this.personBkg=this.personBkg||this.mainBkg,this.darkMode?(this.rowOdd=this.rowOdd||xt(this.mainBkg,5)||"#ffffff",this.rowEven=this.rowEven||xt(this.mainBkg,10)):(this.rowOdd=this.rowOdd||yt(this.mainBkg,75)||"#ffffff",this.rowEven=this.rowEven||yt(this.mainBkg,5)),this.transitionColor=this.transitionColor||this.lineColor,this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||this.tertiaryColor,this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.compositeBorder=this.compositeBorder||this.nodeBorder,this.innerEndBackground=this.nodeBorder,this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.transitionColor=this.transitionColor||this.lineColor,this.specialStateColor=this.lineColor,this.cScale0=this.cScale0||this.primaryColor,this.cScale1=this.cScale1||this.secondaryColor,this.cScale2=this.cScale2||this.tertiaryColor,this.cScale3=this.cScale3||Ct(this.primaryColor,{h:30}),this.cScale4=this.cScale4||Ct(this.primaryColor,{h:60}),this.cScale5=this.cScale5||Ct(this.primaryColor,{h:90}),this.cScale6=this.cScale6||Ct(this.primaryColor,{h:120}),this.cScale7=this.cScale7||Ct(this.primaryColor,{h:150}),this.cScale8=this.cScale8||Ct(this.primaryColor,{h:210,l:150}),this.cScale9=this.cScale9||Ct(this.primaryColor,{h:270}),this.cScale10=this.cScale10||Ct(this.primaryColor,{h:300}),this.cScale11=this.cScale11||Ct(this.primaryColor,{h:330}),this.darkMode)for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScale"+t]=xt(this["cScale"+t],75);else for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScale"+t]=xt(this["cScale"+t],25);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||vt(this["cScale"+t]);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this.darkMode?this["cScalePeer"+t]=this["cScalePeer"+t]||yt(this["cScale"+t],10):this["cScalePeer"+t]=this["cScalePeer"+t]||xt(this["cScale"+t],10);this.scaleLabelColor=this.scaleLabelColor||this.labelTextColor;for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.scaleLabelColor;let t=this.darkMode?-4:-1;for(let e=0;e<5;e++)this["surface"+e]=this["surface"+e]||Ct(this.mainBkg,{h:180,s:-15,l:t*(5+3*e)}),this["surfacePeer"+e]=this["surfacePeer"+e]||Ct(this.mainBkg,{h:180,s:-15,l:t*(8+3*e)});this.classText=this.classText||this.textColor,this.fillType0=this.fillType0||this.primaryColor,this.fillType1=this.fillType1||this.secondaryColor,this.fillType2=this.fillType2||Ct(this.primaryColor,{h:64}),this.fillType3=this.fillType3||Ct(this.secondaryColor,{h:64}),this.fillType4=this.fillType4||Ct(this.primaryColor,{h:-64}),this.fillType5=this.fillType5||Ct(this.secondaryColor,{h:-64}),this.fillType6=this.fillType6||Ct(this.primaryColor,{h:128}),this.fillType7=this.fillType7||Ct(this.secondaryColor,{h:128}),this.pie1=this.pie1||this.primaryColor,this.pie2=this.pie2||this.secondaryColor,this.pie3=this.pie3||this.tertiaryColor,this.pie4=this.pie4||Ct(this.primaryColor,{l:-10}),this.pie5=this.pie5||Ct(this.secondaryColor,{l:-10}),this.pie6=this.pie6||Ct(this.tertiaryColor,{l:-10}),this.pie7=this.pie7||Ct(this.primaryColor,{h:60,l:-10}),this.pie8=this.pie8||Ct(this.primaryColor,{h:-60,l:-10}),this.pie9=this.pie9||Ct(this.primaryColor,{h:120,l:0}),this.pie10=this.pie10||Ct(this.primaryColor,{h:60,l:-20}),this.pie11=this.pie11||Ct(this.primaryColor,{h:-60,l:-20}),this.pie12=this.pie12||Ct(this.primaryColor,{h:120,l:-10}),this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.archEdgeColor=this.archEdgeColor||"#777",this.archEdgeArrowColor=this.archEdgeArrowColor||"#777",this.archEdgeWidth=this.archEdgeWidth||"3",this.archGroupBorderColor=this.archGroupBorderColor||"#000",this.archGroupBorderWidth=this.archGroupBorderWidth||"2px",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Ct(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Ct(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Ct(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Ct(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Ct(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Ct(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||dt(this.quadrant1Fill)?yt(this.quadrant1Fill):xt(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#FFF4DD,#FFD8B1,#FFA07A,#ECEFF1,#D6DBDF,#C3E0A8,#FFB6A4,#FFD74D,#738FA7,#FFFFF0"},this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||(this.darkMode?xt(this.secondaryColor,30):this.secondaryColor),this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=this.git0||this.primaryColor,this.git1=this.git1||this.secondaryColor,this.git2=this.git2||this.tertiaryColor,this.git3=this.git3||Ct(this.primaryColor,{h:-30}),this.git4=this.git4||Ct(this.primaryColor,{h:-60}),this.git5=this.git5||Ct(this.primaryColor,{h:-90}),this.git6=this.git6||Ct(this.primaryColor,{h:60}),this.git7=this.git7||Ct(this.primaryColor,{h:120}),this.darkMode?(this.git0=yt(this.git0,25),this.git1=yt(this.git1,25),this.git2=yt(this.git2,25),this.git3=yt(this.git3,25),this.git4=yt(this.git4,25),this.git5=yt(this.git5,25),this.git6=yt(this.git6,25),this.git7=yt(this.git7,25)):(this.git0=xt(this.git0,25),this.git1=xt(this.git1,25),this.git2=xt(this.git2,25),this.git3=xt(this.git3,25),this.git4=xt(this.git4,25),this.git5=xt(this.git5,25),this.git6=xt(this.git6,25),this.git7=xt(this.git7,25)),this.gitInv0=this.gitInv0||vt(this.git0),this.gitInv1=this.gitInv1||vt(this.git1),this.gitInv2=this.gitInv2||vt(this.git2),this.gitInv3=this.gitInv3||vt(this.git3),this.gitInv4=this.gitInv4||vt(this.git4),this.gitInv5=this.gitInv5||vt(this.git5),this.gitInv6=this.gitInv6||vt(this.git6),this.gitInv7=this.gitInv7||vt(this.git7),this.branchLabelColor=this.branchLabelColor||(this.darkMode?"black":this.labelTextColor),this.gitBranchLabel0=this.gitBranchLabel0||this.branchLabelColor,this.gitBranchLabel1=this.gitBranchLabel1||this.branchLabelColor,this.gitBranchLabel2=this.gitBranchLabel2||this.branchLabelColor,this.gitBranchLabel3=this.gitBranchLabel3||this.branchLabelColor,this.gitBranchLabel4=this.gitBranchLabel4||this.branchLabelColor,this.gitBranchLabel5=this.gitBranchLabel5||this.branchLabelColor,this.gitBranchLabel6=this.gitBranchLabel6||this.branchLabelColor,this.gitBranchLabel7=this.gitBranchLabel7||this.branchLabelColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||St,this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||Tt}calculate(t){if("object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},At=s(t=>{let e=new Bt;return e.calculate(t),e},"getThemeVariables"),Ft=class{static{s(this,"Theme")}constructor(){this.background="#333",this.primaryColor="#1f2020",this.secondaryColor=yt(this.primaryColor,16),this.tertiaryColor=Ct(this.primaryColor,{h:-160}),this.primaryBorderColor=vt(this.background),this.secondaryBorderColor=Mt(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=Mt(this.tertiaryColor,this.darkMode),this.primaryTextColor=vt(this.primaryColor),this.secondaryTextColor=vt(this.secondaryColor),this.tertiaryTextColor=vt(this.tertiaryColor),this.lineColor=vt(this.background),this.textColor=vt(this.background),this.mainBkg="#1f2020",this.secondBkg="calculated",this.mainContrastColor="lightgrey",this.darkTextColor=yt(vt("#323D47"),10),this.lineColor="calculated",this.border1="#ccc",this.border2=nt(255,255,255,.25),this.arrowheadColor="calculated",this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px",this.labelBackground="#181818",this.textColor="#ccc",this.THEME_COLOR_LIMIT=12,this.nodeBkg="calculated",this.nodeBorder="calculated",this.clusterBkg="calculated",this.clusterBorder="calculated",this.defaultLinkColor="calculated",this.titleColor="#F9FFFE",this.edgeLabelBackground="calculated",this.actorBorder="calculated",this.actorBkg="calculated",this.actorTextColor="calculated",this.actorLineColor="calculated",this.signalColor="calculated",this.signalTextColor="calculated",this.labelBoxBkgColor="calculated",this.labelBoxBorderColor="calculated",this.labelTextColor="calculated",this.loopTextColor="calculated",this.noteBorderColor="calculated",this.noteBkgColor="#fff5ad",this.noteTextColor="calculated",this.activationBorderColor="calculated",this.activationBkgColor="calculated",this.sequenceNumberColor="black",this.sectionBkgColor=xt("#EAE8D9",30),this.altSectionBkgColor="calculated",this.sectionBkgColor2="#EAE8D9",this.excludeBkgColor=xt(this.sectionBkgColor,10),this.taskBorderColor=nt(255,255,255,70),this.taskBkgColor="calculated",this.taskTextColor="calculated",this.taskTextLightColor="calculated",this.taskTextOutsideColor="calculated",this.taskTextClickableColor="#003163",this.activeTaskBorderColor=nt(255,255,255,50),this.activeTaskBkgColor="#81B1DB",this.gridColor="calculated",this.doneTaskBkgColor="calculated",this.doneTaskBorderColor="grey",this.critBorderColor="#E83737",this.critBkgColor="#E83737",this.taskTextDarkColor="calculated",this.todayLineColor="#DB5757",this.vertLineColor="#00BFFF",this.personBorder=this.primaryBorderColor,this.personBkg=this.mainBkg,this.archEdgeColor="calculated",this.archEdgeArrowColor="calculated",this.archEdgeWidth="3",this.archGroupBorderColor=this.primaryBorderColor,this.archGroupBorderWidth="2px",this.rowOdd=this.rowOdd||yt(this.mainBkg,5)||"#ffffff",this.rowEven=this.rowEven||xt(this.mainBkg,10),this.labelColor="calculated",this.errorBkgColor="#a44141",this.errorTextColor="#ddd"}updateColors(){this.secondBkg=yt(this.mainBkg,16),this.lineColor=this.mainContrastColor,this.arrowheadColor=this.mainContrastColor,this.nodeBkg=this.mainBkg,this.nodeBorder=this.border1,this.clusterBkg=this.secondBkg,this.clusterBorder=this.border2,this.defaultLinkColor=this.lineColor,this.edgeLabelBackground=yt(this.labelBackground,25),this.actorBorder=this.border1,this.actorBkg=this.mainBkg,this.actorTextColor=this.mainContrastColor,this.actorLineColor=this.actorBorder,this.signalColor=this.mainContrastColor,this.signalTextColor=this.mainContrastColor,this.labelBoxBkgColor=this.actorBkg,this.labelBoxBorderColor=this.actorBorder,this.labelTextColor=this.mainContrastColor,this.loopTextColor=this.mainContrastColor,this.noteBorderColor=this.secondaryBorderColor,this.noteBkgColor=this.secondBkg,this.noteTextColor=this.secondaryTextColor,this.activationBorderColor=this.border1,this.activationBkgColor=this.secondBkg,this.altSectionBkgColor=this.background,this.taskBkgColor=yt(this.mainBkg,23),this.taskTextColor=this.darkTextColor,this.taskTextLightColor=this.mainContrastColor,this.taskTextOutsideColor=this.taskTextLightColor,this.gridColor=this.mainContrastColor,this.doneTaskBkgColor=this.mainContrastColor,this.taskTextDarkColor=this.darkTextColor,this.archEdgeColor=this.lineColor,this.archEdgeArrowColor=this.lineColor,this.transitionColor=this.transitionColor||this.lineColor,this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||"#555",this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.compositeBorder=this.compositeBorder||this.nodeBorder,this.innerEndBackground=this.primaryBorderColor,this.specialStateColor="#f4f4f4",this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.fillType0=this.primaryColor,this.fillType1=this.secondaryColor,this.fillType2=Ct(this.primaryColor,{h:64}),this.fillType3=Ct(this.secondaryColor,{h:64}),this.fillType4=Ct(this.primaryColor,{h:-64}),this.fillType5=Ct(this.secondaryColor,{h:-64}),this.fillType6=Ct(this.primaryColor,{h:128}),this.fillType7=Ct(this.secondaryColor,{h:128}),this.cScale1=this.cScale1||"#0b0000",this.cScale2=this.cScale2||"#4d1037",this.cScale3=this.cScale3||"#3f5258",this.cScale4=this.cScale4||"#4f2f1b",this.cScale5=this.cScale5||"#6e0a0a",this.cScale6=this.cScale6||"#3b0048",this.cScale7=this.cScale7||"#995a01",this.cScale8=this.cScale8||"#154706",this.cScale9=this.cScale9||"#161722",this.cScale10=this.cScale10||"#00296f",this.cScale11=this.cScale11||"#01629c",this.cScale12=this.cScale12||"#010029",this.cScale0=this.cScale0||this.primaryColor,this.cScale1=this.cScale1||this.secondaryColor,this.cScale2=this.cScale2||this.tertiaryColor,this.cScale3=this.cScale3||Ct(this.primaryColor,{h:30}),this.cScale4=this.cScale4||Ct(this.primaryColor,{h:60}),this.cScale5=this.cScale5||Ct(this.primaryColor,{h:90}),this.cScale6=this.cScale6||Ct(this.primaryColor,{h:120}),this.cScale7=this.cScale7||Ct(this.primaryColor,{h:150}),this.cScale8=this.cScale8||Ct(this.primaryColor,{h:210}),this.cScale9=this.cScale9||Ct(this.primaryColor,{h:270}),this.cScale10=this.cScale10||Ct(this.primaryColor,{h:300}),this.cScale11=this.cScale11||Ct(this.primaryColor,{h:330});for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||vt(this["cScale"+t]);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScalePeer"+t]=this["cScalePeer"+t]||yt(this["cScale"+t],10);for(let t=0;t<5;t++)this["surface"+t]=this["surface"+t]||Ct(this.mainBkg,{h:30,s:-30,l:-(4*t-10)}),this["surfacePeer"+t]=this["surfacePeer"+t]||Ct(this.mainBkg,{h:30,s:-30,l:-(4*t-7)});this.scaleLabelColor=this.scaleLabelColor||(this.darkMode?"black":this.labelTextColor);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.scaleLabelColor;for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["pie"+t]=this["cScale"+t];this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Ct(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Ct(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Ct(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Ct(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Ct(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Ct(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||dt(this.quadrant1Fill)?yt(this.quadrant1Fill):xt(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#3498db,#2ecc71,#e74c3c,#f1c40f,#bdc3c7,#ffffff,#34495e,#9b59b6,#1abc9c,#e67e22"},this.packet={startByteColor:this.primaryTextColor,endByteColor:this.primaryTextColor,labelColor:this.primaryTextColor,titleColor:this.primaryTextColor,blockStrokeColor:this.primaryTextColor,blockFillColor:this.background},this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.classText=this.primaryTextColor,this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||(this.darkMode?xt(this.secondaryColor,30):this.secondaryColor),this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=yt(this.secondaryColor,20),this.git1=yt(this.pie2||this.secondaryColor,20),this.git2=yt(this.pie3||this.tertiaryColor,20),this.git3=yt(this.pie4||Ct(this.primaryColor,{h:-30}),20),this.git4=yt(this.pie5||Ct(this.primaryColor,{h:-60}),20),this.git5=yt(this.pie6||Ct(this.primaryColor,{h:-90}),10),this.git6=yt(this.pie7||Ct(this.primaryColor,{h:60}),10),this.git7=yt(this.pie8||Ct(this.primaryColor,{h:120}),20),this.gitInv0=this.gitInv0||vt(this.git0),this.gitInv1=this.gitInv1||vt(this.git1),this.gitInv2=this.gitInv2||vt(this.git2),this.gitInv3=this.gitInv3||vt(this.git3),this.gitInv4=this.gitInv4||vt(this.git4),this.gitInv5=this.gitInv5||vt(this.git5),this.gitInv6=this.gitInv6||vt(this.git6),this.gitInv7=this.gitInv7||vt(this.git7),this.gitBranchLabel0=this.gitBranchLabel0||vt(this.labelTextColor),this.gitBranchLabel1=this.gitBranchLabel1||this.labelTextColor,this.gitBranchLabel2=this.gitBranchLabel2||this.labelTextColor,this.gitBranchLabel3=this.gitBranchLabel3||vt(this.labelTextColor),this.gitBranchLabel4=this.gitBranchLabel4||this.labelTextColor,this.gitBranchLabel5=this.gitBranchLabel5||this.labelTextColor,this.gitBranchLabel6=this.gitBranchLabel6||this.labelTextColor,this.gitBranchLabel7=this.gitBranchLabel7||this.labelTextColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||yt(this.background,12),this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||yt(this.background,2),this.nodeBorder=this.nodeBorder||"#999"}calculate(t){if("object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},Lt=s(t=>{let e=new Ft;return e.calculate(t),e},"getThemeVariables"),$t=class{static{s(this,"Theme")}constructor(){this.background="#f4f4f4",this.primaryColor="#ECECFF",this.secondaryColor=Ct(this.primaryColor,{h:120}),this.secondaryColor="#ffffde",this.tertiaryColor=Ct(this.primaryColor,{h:-160}),this.primaryBorderColor=Mt(this.primaryColor,this.darkMode),this.secondaryBorderColor=Mt(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=Mt(this.tertiaryColor,this.darkMode),this.primaryTextColor=vt(this.primaryColor),this.secondaryTextColor=vt(this.secondaryColor),this.tertiaryTextColor=vt(this.tertiaryColor),this.lineColor=vt(this.background),this.textColor=vt(this.background),this.background="white",this.mainBkg="#ECECFF",this.secondBkg="#ffffde",this.lineColor="#333333",this.border1="#9370DB",this.border2="#aaaa33",this.arrowheadColor="#333333",this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px",this.labelBackground="rgba(232,232,232, 0.8)",this.textColor="#333",this.THEME_COLOR_LIMIT=12,this.nodeBkg="calculated",this.nodeBorder="calculated",this.clusterBkg="calculated",this.clusterBorder="calculated",this.defaultLinkColor="calculated",this.titleColor="calculated",this.edgeLabelBackground="calculated",this.actorBorder="calculated",this.actorBkg="calculated",this.actorTextColor="black",this.actorLineColor="calculated",this.signalColor="calculated",this.signalTextColor="calculated",this.labelBoxBkgColor="calculated",this.labelBoxBorderColor="calculated",this.labelTextColor="calculated",this.loopTextColor="calculated",this.noteBorderColor="calculated",this.noteBkgColor="#fff5ad",this.noteTextColor="calculated",this.activationBorderColor="#666",this.activationBkgColor="#f4f4f4",this.sequenceNumberColor="white",this.sectionBkgColor="calculated",this.altSectionBkgColor="calculated",this.sectionBkgColor2="calculated",this.excludeBkgColor="#eeeeee",this.taskBorderColor="calculated",this.taskBkgColor="calculated",this.taskTextLightColor="calculated",this.taskTextColor=this.taskTextLightColor,this.taskTextDarkColor="calculated",this.taskTextOutsideColor=this.taskTextDarkColor,this.taskTextClickableColor="calculated",this.activeTaskBorderColor="calculated",this.activeTaskBkgColor="calculated",this.gridColor="calculated",this.doneTaskBkgColor="calculated",this.doneTaskBorderColor="calculated",this.critBorderColor="calculated",this.critBkgColor="calculated",this.todayLineColor="calculated",this.vertLineColor="calculated",this.sectionBkgColor=nt(102,102,255,.49),this.altSectionBkgColor="white",this.sectionBkgColor2="#fff400",this.taskBorderColor="#534fbc",this.taskBkgColor="#8a90dd",this.taskTextLightColor="white",this.taskTextColor="calculated",this.taskTextDarkColor="black",this.taskTextOutsideColor="calculated",this.taskTextClickableColor="#003163",this.activeTaskBorderColor="#534fbc",this.activeTaskBkgColor="#bfc7ff",this.gridColor="lightgrey",this.doneTaskBkgColor="lightgrey",this.doneTaskBorderColor="grey",this.critBorderColor="#ff8888",this.critBkgColor="red",this.todayLineColor="red",this.vertLineColor="navy",this.personBorder=this.primaryBorderColor,this.personBkg=this.mainBkg,this.archEdgeColor="calculated",this.archEdgeArrowColor="calculated",this.archEdgeWidth="3",this.archGroupBorderColor=this.primaryBorderColor,this.archGroupBorderWidth="2px",this.rowOdd="calculated",this.rowEven="calculated",this.labelColor="black",this.errorBkgColor="#552222",this.errorTextColor="#552222",this.updateColors()}updateColors(){this.cScale0=this.cScale0||this.primaryColor,this.cScale1=this.cScale1||this.secondaryColor,this.cScale2=this.cScale2||this.tertiaryColor,this.cScale3=this.cScale3||Ct(this.primaryColor,{h:30}),this.cScale4=this.cScale4||Ct(this.primaryColor,{h:60}),this.cScale5=this.cScale5||Ct(this.primaryColor,{h:90}),this.cScale6=this.cScale6||Ct(this.primaryColor,{h:120}),this.cScale7=this.cScale7||Ct(this.primaryColor,{h:150}),this.cScale8=this.cScale8||Ct(this.primaryColor,{h:210}),this.cScale9=this.cScale9||Ct(this.primaryColor,{h:270}),this.cScale10=this.cScale10||Ct(this.primaryColor,{h:300}),this.cScale11=this.cScale11||Ct(this.primaryColor,{h:330}),this.cScalePeer1=this.cScalePeer1||xt(this.secondaryColor,45),this.cScalePeer2=this.cScalePeer2||xt(this.tertiaryColor,40);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScale"+t]=xt(this["cScale"+t],10),this["cScalePeer"+t]=this["cScalePeer"+t]||xt(this["cScale"+t],25);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||Ct(this["cScale"+t],{h:180});for(let t=0;t<5;t++)this["surface"+t]=this["surface"+t]||Ct(this.mainBkg,{h:30,l:-(5+5*t)}),this["surfacePeer"+t]=this["surfacePeer"+t]||Ct(this.mainBkg,{h:30,l:-(7+5*t)});if(this.scaleLabelColor="calculated"!==this.scaleLabelColor&&this.scaleLabelColor?this.scaleLabelColor:this.labelTextColor,"calculated"!==this.labelTextColor){this.cScaleLabel0=this.cScaleLabel0||vt(this.labelTextColor),this.cScaleLabel3=this.cScaleLabel3||vt(this.labelTextColor);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.labelTextColor}this.nodeBkg=this.mainBkg,this.nodeBorder=this.border1,this.clusterBkg=this.secondBkg,this.clusterBorder=this.border2,this.defaultLinkColor=this.lineColor,this.titleColor=this.textColor,this.edgeLabelBackground=this.labelBackground,this.actorBorder=yt(this.border1,23),this.actorBkg=this.mainBkg,this.labelBoxBkgColor=this.actorBkg,this.signalColor=this.textColor,this.signalTextColor=this.textColor,this.labelBoxBorderColor=this.actorBorder,this.labelTextColor=this.actorTextColor,this.loopTextColor=this.actorTextColor,this.noteBorderColor=this.border2,this.noteTextColor=this.actorTextColor,this.actorLineColor=this.actorBorder,this.taskTextColor=this.taskTextLightColor,this.taskTextOutsideColor=this.taskTextDarkColor,this.archEdgeColor=this.lineColor,this.archEdgeArrowColor=this.lineColor,this.rowOdd=this.rowOdd||yt(this.primaryColor,75)||"#ffffff",this.rowEven=this.rowEven||yt(this.primaryColor,1),this.transitionColor=this.transitionColor||this.lineColor,this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||"#f0f0f0",this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.compositeBorder=this.compositeBorder||this.nodeBorder,this.innerEndBackground=this.nodeBorder,this.specialStateColor=this.lineColor,this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.transitionColor=this.transitionColor||this.lineColor,this.classText=this.primaryTextColor,this.fillType0=this.primaryColor,this.fillType1=this.secondaryColor,this.fillType2=Ct(this.primaryColor,{h:64}),this.fillType3=Ct(this.secondaryColor,{h:64}),this.fillType4=Ct(this.primaryColor,{h:-64}),this.fillType5=Ct(this.secondaryColor,{h:-64}),this.fillType6=Ct(this.primaryColor,{h:128}),this.fillType7=Ct(this.secondaryColor,{h:128}),this.pie1=this.pie1||this.primaryColor,this.pie2=this.pie2||this.secondaryColor,this.pie3=this.pie3||Ct(this.tertiaryColor,{l:-40}),this.pie4=this.pie4||Ct(this.primaryColor,{l:-10}),this.pie5=this.pie5||Ct(this.secondaryColor,{l:-30}),this.pie6=this.pie6||Ct(this.tertiaryColor,{l:-20}),this.pie7=this.pie7||Ct(this.primaryColor,{h:60,l:-20}),this.pie8=this.pie8||Ct(this.primaryColor,{h:-60,l:-40}),this.pie9=this.pie9||Ct(this.primaryColor,{h:120,l:-40}),this.pie10=this.pie10||Ct(this.primaryColor,{h:60,l:-40}),this.pie11=this.pie11||Ct(this.primaryColor,{h:-90,l:-40}),this.pie12=this.pie12||Ct(this.primaryColor,{h:120,l:-30}),this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Ct(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Ct(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Ct(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Ct(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Ct(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Ct(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||dt(this.quadrant1Fill)?yt(this.quadrant1Fill):xt(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#ECECFF,#8493A6,#FFC3A0,#DCDDE1,#B8E994,#D1A36F,#C3CDE6,#FFB6C1,#496078,#F8F3E3"},this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||this.labelBackground,this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=this.git0||this.primaryColor,this.git1=this.git1||this.secondaryColor,this.git2=this.git2||this.tertiaryColor,this.git3=this.git3||Ct(this.primaryColor,{h:-30}),this.git4=this.git4||Ct(this.primaryColor,{h:-60}),this.git5=this.git5||Ct(this.primaryColor,{h:-90}),this.git6=this.git6||Ct(this.primaryColor,{h:60}),this.git7=this.git7||Ct(this.primaryColor,{h:120}),this.darkMode?(this.git0=yt(this.git0,25),this.git1=yt(this.git1,25),this.git2=yt(this.git2,25),this.git3=yt(this.git3,25),this.git4=yt(this.git4,25),this.git5=yt(this.git5,25),this.git6=yt(this.git6,25),this.git7=yt(this.git7,25)):(this.git0=xt(this.git0,25),this.git1=xt(this.git1,25),this.git2=xt(this.git2,25),this.git3=xt(this.git3,25),this.git4=xt(this.git4,25),this.git5=xt(this.git5,25),this.git6=xt(this.git6,25),this.git7=xt(this.git7,25)),this.gitInv0=this.gitInv0||xt(vt(this.git0),25),this.gitInv1=this.gitInv1||vt(this.git1),this.gitInv2=this.gitInv2||vt(this.git2),this.gitInv3=this.gitInv3||vt(this.git3),this.gitInv4=this.gitInv4||vt(this.git4),this.gitInv5=this.gitInv5||vt(this.git5),this.gitInv6=this.gitInv6||vt(this.git6),this.gitInv7=this.gitInv7||vt(this.git7),this.gitBranchLabel0=this.gitBranchLabel0||vt(this.labelTextColor),this.gitBranchLabel1=this.gitBranchLabel1||this.labelTextColor,this.gitBranchLabel2=this.gitBranchLabel2||this.labelTextColor,this.gitBranchLabel3=this.gitBranchLabel3||vt(this.labelTextColor),this.gitBranchLabel4=this.gitBranchLabel4||this.labelTextColor,this.gitBranchLabel5=this.gitBranchLabel5||this.labelTextColor,this.gitBranchLabel6=this.gitBranchLabel6||this.labelTextColor,this.gitBranchLabel7=this.gitBranchLabel7||this.labelTextColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||St,this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||Tt}calculate(t){if(Object.keys(this).forEach(t=>{"calculated"===this[t]&&(this[t]=void 0)}),"object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},Et=s(t=>{let e=new $t;return e.calculate(t),e},"getThemeVariables"),Dt=class{static{s(this,"Theme")}constructor(){this.background="#f4f4f4",this.primaryColor="#cde498",this.secondaryColor="#cdffb2",this.background="white",this.mainBkg="#cde498",this.secondBkg="#cdffb2",this.lineColor="green",this.border1="#13540c",this.border2="#6eaa49",this.arrowheadColor="green",this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px",this.tertiaryColor=yt("#cde498",10),this.primaryBorderColor=Mt(this.primaryColor,this.darkMode),this.secondaryBorderColor=Mt(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=Mt(this.tertiaryColor,this.darkMode),this.primaryTextColor=vt(this.primaryColor),this.secondaryTextColor=vt(this.secondaryColor),this.tertiaryTextColor=vt(this.primaryColor),this.lineColor=vt(this.background),this.textColor=vt(this.background),this.THEME_COLOR_LIMIT=12,this.nodeBkg="calculated",this.nodeBorder="calculated",this.clusterBkg="calculated",this.clusterBorder="calculated",this.defaultLinkColor="calculated",this.titleColor="#333",this.edgeLabelBackground="#e8e8e8",this.actorBorder="calculated",this.actorBkg="calculated",this.actorTextColor="black",this.actorLineColor="calculated",this.signalColor="#333",this.signalTextColor="#333",this.labelBoxBkgColor="calculated",this.labelBoxBorderColor="#326932",this.labelTextColor="calculated",this.loopTextColor="calculated",this.noteBorderColor="calculated",this.noteBkgColor="#fff5ad",this.noteTextColor="calculated",this.activationBorderColor="#666",this.activationBkgColor="#f4f4f4",this.sequenceNumberColor="white",this.sectionBkgColor="#6eaa49",this.altSectionBkgColor="white",this.sectionBkgColor2="#6eaa49",this.excludeBkgColor="#eeeeee",this.taskBorderColor="calculated",this.taskBkgColor="#487e3a",this.taskTextLightColor="white",this.taskTextColor="calculated",this.taskTextDarkColor="black",this.taskTextOutsideColor="calculated",this.taskTextClickableColor="#003163",this.activeTaskBorderColor="calculated",this.activeTaskBkgColor="calculated",this.gridColor="lightgrey",this.doneTaskBkgColor="lightgrey",this.doneTaskBorderColor="grey",this.critBorderColor="#ff8888",this.critBkgColor="red",this.todayLineColor="red",this.vertLineColor="#00BFFF",this.personBorder=this.primaryBorderColor,this.personBkg=this.mainBkg,this.archEdgeColor="calculated",this.archEdgeArrowColor="calculated",this.archEdgeWidth="3",this.archGroupBorderColor=this.primaryBorderColor,this.archGroupBorderWidth="2px",this.labelColor="black",this.errorBkgColor="#552222",this.errorTextColor="#552222"}updateColors(){this.actorBorder=xt(this.mainBkg,20),this.actorBkg=this.mainBkg,this.labelBoxBkgColor=this.actorBkg,this.labelTextColor=this.actorTextColor,this.loopTextColor=this.actorTextColor,this.noteBorderColor=this.border2,this.noteTextColor=this.actorTextColor,this.actorLineColor=this.actorBorder,this.cScale0=this.cScale0||this.primaryColor,this.cScale1=this.cScale1||this.secondaryColor,this.cScale2=this.cScale2||this.tertiaryColor,this.cScale3=this.cScale3||Ct(this.primaryColor,{h:30}),this.cScale4=this.cScale4||Ct(this.primaryColor,{h:60}),this.cScale5=this.cScale5||Ct(this.primaryColor,{h:90}),this.cScale6=this.cScale6||Ct(this.primaryColor,{h:120}),this.cScale7=this.cScale7||Ct(this.primaryColor,{h:150}),this.cScale8=this.cScale8||Ct(this.primaryColor,{h:210}),this.cScale9=this.cScale9||Ct(this.primaryColor,{h:270}),this.cScale10=this.cScale10||Ct(this.primaryColor,{h:300}),this.cScale11=this.cScale11||Ct(this.primaryColor,{h:330}),this.cScalePeer1=this.cScalePeer1||xt(this.secondaryColor,45),this.cScalePeer2=this.cScalePeer2||xt(this.tertiaryColor,40);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScale"+t]=xt(this["cScale"+t],10),this["cScalePeer"+t]=this["cScalePeer"+t]||xt(this["cScale"+t],25);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||Ct(this["cScale"+t],{h:180});this.scaleLabelColor="calculated"!==this.scaleLabelColor&&this.scaleLabelColor?this.scaleLabelColor:this.labelTextColor;for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.scaleLabelColor;for(let t=0;t<5;t++)this["surface"+t]=this["surface"+t]||Ct(this.mainBkg,{h:30,s:-30,l:-(5+5*t)}),this["surfacePeer"+t]=this["surfacePeer"+t]||Ct(this.mainBkg,{h:30,s:-30,l:-(8+5*t)});this.nodeBkg=this.mainBkg,this.nodeBorder=this.border1,this.clusterBkg=this.secondBkg,this.clusterBorder=this.border2,this.defaultLinkColor=this.lineColor,this.taskBorderColor=this.border1,this.taskTextColor=this.taskTextLightColor,this.taskTextOutsideColor=this.taskTextDarkColor,this.activeTaskBorderColor=this.taskBorderColor,this.activeTaskBkgColor=this.mainBkg,this.archEdgeColor=this.lineColor,this.archEdgeArrowColor=this.lineColor,this.rowOdd=this.rowOdd||yt(this.mainBkg,75)||"#ffffff",this.rowEven=this.rowEven||yt(this.mainBkg,20),this.transitionColor=this.transitionColor||this.lineColor,this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||"#f0f0f0",this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.compositeBorder=this.compositeBorder||this.nodeBorder,this.innerEndBackground=this.primaryBorderColor,this.specialStateColor=this.lineColor,this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.transitionColor=this.transitionColor||this.lineColor,this.classText=this.primaryTextColor,this.fillType0=this.primaryColor,this.fillType1=this.secondaryColor,this.fillType2=Ct(this.primaryColor,{h:64}),this.fillType3=Ct(this.secondaryColor,{h:64}),this.fillType4=Ct(this.primaryColor,{h:-64}),this.fillType5=Ct(this.secondaryColor,{h:-64}),this.fillType6=Ct(this.primaryColor,{h:128}),this.fillType7=Ct(this.secondaryColor,{h:128}),this.pie1=this.pie1||this.primaryColor,this.pie2=this.pie2||this.secondaryColor,this.pie3=this.pie3||this.tertiaryColor,this.pie4=this.pie4||Ct(this.primaryColor,{l:-30}),this.pie5=this.pie5||Ct(this.secondaryColor,{l:-30}),this.pie6=this.pie6||Ct(this.tertiaryColor,{h:40,l:-40}),this.pie7=this.pie7||Ct(this.primaryColor,{h:60,l:-10}),this.pie8=this.pie8||Ct(this.primaryColor,{h:-60,l:-10}),this.pie9=this.pie9||Ct(this.primaryColor,{h:120,l:0}),this.pie10=this.pie10||Ct(this.primaryColor,{h:60,l:-50}),this.pie11=this.pie11||Ct(this.primaryColor,{h:-60,l:-50}),this.pie12=this.pie12||Ct(this.primaryColor,{h:120,l:-50}),this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Ct(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Ct(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Ct(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Ct(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Ct(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Ct(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||dt(this.quadrant1Fill)?yt(this.quadrant1Fill):xt(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.packet={startByteColor:this.primaryTextColor,endByteColor:this.primaryTextColor,labelColor:this.primaryTextColor,titleColor:this.primaryTextColor,blockStrokeColor:this.primaryTextColor,blockFillColor:this.mainBkg},this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#CDE498,#FF6B6B,#A0D2DB,#D7BDE2,#F0F0F0,#FFC3A0,#7FD8BE,#FF9A8B,#FAF3E0,#FFF176"},this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||this.edgeLabelBackground,this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=this.git0||this.primaryColor,this.git1=this.git1||this.secondaryColor,this.git2=this.git2||this.tertiaryColor,this.git3=this.git3||Ct(this.primaryColor,{h:-30}),this.git4=this.git4||Ct(this.primaryColor,{h:-60}),this.git5=this.git5||Ct(this.primaryColor,{h:-90}),this.git6=this.git6||Ct(this.primaryColor,{h:60}),this.git7=this.git7||Ct(this.primaryColor,{h:120}),this.darkMode?(this.git0=yt(this.git0,25),this.git1=yt(this.git1,25),this.git2=yt(this.git2,25),this.git3=yt(this.git3,25),this.git4=yt(this.git4,25),this.git5=yt(this.git5,25),this.git6=yt(this.git6,25),this.git7=yt(this.git7,25)):(this.git0=xt(this.git0,25),this.git1=xt(this.git1,25),this.git2=xt(this.git2,25),this.git3=xt(this.git3,25),this.git4=xt(this.git4,25),this.git5=xt(this.git5,25),this.git6=xt(this.git6,25),this.git7=xt(this.git7,25)),this.gitInv0=this.gitInv0||vt(this.git0),this.gitInv1=this.gitInv1||vt(this.git1),this.gitInv2=this.gitInv2||vt(this.git2),this.gitInv3=this.gitInv3||vt(this.git3),this.gitInv4=this.gitInv4||vt(this.git4),this.gitInv5=this.gitInv5||vt(this.git5),this.gitInv6=this.gitInv6||vt(this.git6),this.gitInv7=this.gitInv7||vt(this.git7),this.gitBranchLabel0=this.gitBranchLabel0||vt(this.labelTextColor),this.gitBranchLabel1=this.gitBranchLabel1||this.labelTextColor,this.gitBranchLabel2=this.gitBranchLabel2||this.labelTextColor,this.gitBranchLabel3=this.gitBranchLabel3||vt(this.labelTextColor),this.gitBranchLabel4=this.gitBranchLabel4||this.labelTextColor,this.gitBranchLabel5=this.gitBranchLabel5||this.labelTextColor,this.gitBranchLabel6=this.gitBranchLabel6||this.labelTextColor,this.gitBranchLabel7=this.gitBranchLabel7||this.labelTextColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||St,this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||Tt}calculate(t){if("object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},Ot=s(t=>{let e=new Dt;return e.calculate(t),e},"getThemeVariables"),It=class{static{s(this,"Theme")}constructor(){this.primaryColor="#eee",this.contrast="#707070",this.secondaryColor=yt(this.contrast,55),this.background="#ffffff",this.tertiaryColor=Ct(this.primaryColor,{h:-160}),this.primaryBorderColor=Mt(this.primaryColor,this.darkMode),this.secondaryBorderColor=Mt(this.secondaryColor,this.darkMode),this.tertiaryBorderColor=Mt(this.tertiaryColor,this.darkMode),this.primaryTextColor=vt(this.primaryColor),this.secondaryTextColor=vt(this.secondaryColor),this.tertiaryTextColor=vt(this.tertiaryColor),this.lineColor=vt(this.background),this.textColor=vt(this.background),this.mainBkg="#eee",this.secondBkg="calculated",this.lineColor="#666",this.border1="#999",this.border2="calculated",this.note="#ffa",this.text="#333",this.critical="#d42",this.done="#bbb",this.arrowheadColor="#333333",this.fontFamily='"trebuchet ms", verdana, arial, sans-serif',this.fontSize="16px",this.THEME_COLOR_LIMIT=12,this.nodeBkg="calculated",this.nodeBorder="calculated",this.clusterBkg="calculated",this.clusterBorder="calculated",this.defaultLinkColor="calculated",this.titleColor="calculated",this.edgeLabelBackground="white",this.actorBorder="calculated",this.actorBkg="calculated",this.actorTextColor="calculated",this.actorLineColor=this.actorBorder,this.signalColor="calculated",this.signalTextColor="calculated",this.labelBoxBkgColor="calculated",this.labelBoxBorderColor="calculated",this.labelTextColor="calculated",this.loopTextColor="calculated",this.noteBorderColor="calculated",this.noteBkgColor="calculated",this.noteTextColor="calculated",this.activationBorderColor="#666",this.activationBkgColor="#f4f4f4",this.sequenceNumberColor="white",this.sectionBkgColor="calculated",this.altSectionBkgColor="white",this.sectionBkgColor2="calculated",this.excludeBkgColor="#eeeeee",this.taskBorderColor="calculated",this.taskBkgColor="calculated",this.taskTextLightColor="white",this.taskTextColor="calculated",this.taskTextDarkColor="calculated",this.taskTextOutsideColor="calculated",this.taskTextClickableColor="#003163",this.activeTaskBorderColor="calculated",this.activeTaskBkgColor="calculated",this.gridColor="calculated",this.doneTaskBkgColor="calculated",this.doneTaskBorderColor="calculated",this.critBkgColor="calculated",this.critBorderColor="calculated",this.todayLineColor="calculated",this.vertLineColor="calculated",this.personBorder=this.primaryBorderColor,this.personBkg=this.mainBkg,this.archEdgeColor="calculated",this.archEdgeArrowColor="calculated",this.archEdgeWidth="3",this.archGroupBorderColor=this.primaryBorderColor,this.archGroupBorderWidth="2px",this.rowOdd=this.rowOdd||yt(this.mainBkg,75)||"#ffffff",this.rowEven=this.rowEven||"#f4f4f4",this.labelColor="black",this.errorBkgColor="#552222",this.errorTextColor="#552222"}updateColors(){this.secondBkg=yt(this.contrast,55),this.border2=this.contrast,this.actorBorder=yt(this.border1,23),this.actorBkg=this.mainBkg,this.actorTextColor=this.text,this.actorLineColor=this.actorBorder,this.signalColor=this.text,this.signalTextColor=this.text,this.labelBoxBkgColor=this.actorBkg,this.labelBoxBorderColor=this.actorBorder,this.labelTextColor=this.text,this.loopTextColor=this.text,this.noteBorderColor="#999",this.noteBkgColor="#666",this.noteTextColor="#fff",this.cScale0=this.cScale0||"#555",this.cScale1=this.cScale1||"#F4F4F4",this.cScale2=this.cScale2||"#555",this.cScale3=this.cScale3||"#BBB",this.cScale4=this.cScale4||"#777",this.cScale5=this.cScale5||"#999",this.cScale6=this.cScale6||"#DDD",this.cScale7=this.cScale7||"#FFF",this.cScale8=this.cScale8||"#DDD",this.cScale9=this.cScale9||"#BBB",this.cScale10=this.cScale10||"#999",this.cScale11=this.cScale11||"#777";for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleInv"+t]=this["cScaleInv"+t]||vt(this["cScale"+t]);for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this.darkMode?this["cScalePeer"+t]=this["cScalePeer"+t]||yt(this["cScale"+t],10):this["cScalePeer"+t]=this["cScalePeer"+t]||xt(this["cScale"+t],10);this.scaleLabelColor=this.scaleLabelColor||(this.darkMode?"black":this.labelTextColor),this.cScaleLabel0=this.cScaleLabel0||this.cScale1,this.cScaleLabel2=this.cScaleLabel2||this.cScale1;for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["cScaleLabel"+t]=this["cScaleLabel"+t]||this.scaleLabelColor;for(let t=0;t<5;t++)this["surface"+t]=this["surface"+t]||Ct(this.mainBkg,{l:-(5+5*t)}),this["surfacePeer"+t]=this["surfacePeer"+t]||Ct(this.mainBkg,{l:-(8+5*t)});this.nodeBkg=this.mainBkg,this.nodeBorder=this.border1,this.clusterBkg=this.secondBkg,this.clusterBorder=this.border2,this.defaultLinkColor=this.lineColor,this.titleColor=this.text,this.sectionBkgColor=yt(this.contrast,30),this.sectionBkgColor2=yt(this.contrast,30),this.taskBorderColor=xt(this.contrast,10),this.taskBkgColor=this.contrast,this.taskTextColor=this.taskTextLightColor,this.taskTextDarkColor=this.text,this.taskTextOutsideColor=this.taskTextDarkColor,this.activeTaskBorderColor=this.taskBorderColor,this.activeTaskBkgColor=this.mainBkg,this.gridColor=yt(this.border1,30),this.doneTaskBkgColor=this.done,this.doneTaskBorderColor=this.lineColor,this.critBkgColor=this.critical,this.critBorderColor=xt(this.critBkgColor,10),this.todayLineColor=this.critBkgColor,this.vertLineColor=this.critBkgColor,this.archEdgeColor=this.lineColor,this.archEdgeArrowColor=this.lineColor,this.transitionColor=this.transitionColor||"#000",this.transitionLabelColor=this.transitionLabelColor||this.textColor,this.stateLabelColor=this.stateLabelColor||this.stateBkg||this.primaryTextColor,this.stateBkg=this.stateBkg||this.mainBkg,this.labelBackgroundColor=this.labelBackgroundColor||this.stateBkg,this.compositeBackground=this.compositeBackground||this.background||this.tertiaryColor,this.altBackground=this.altBackground||"#f4f4f4",this.compositeTitleBackground=this.compositeTitleBackground||this.mainBkg,this.stateBorder=this.stateBorder||"#000",this.innerEndBackground=this.primaryBorderColor,this.specialStateColor="#222",this.errorBkgColor=this.errorBkgColor||this.tertiaryColor,this.errorTextColor=this.errorTextColor||this.tertiaryTextColor,this.classText=this.primaryTextColor,this.fillType0=this.primaryColor,this.fillType1=this.secondaryColor,this.fillType2=Ct(this.primaryColor,{h:64}),this.fillType3=Ct(this.secondaryColor,{h:64}),this.fillType4=Ct(this.primaryColor,{h:-64}),this.fillType5=Ct(this.secondaryColor,{h:-64}),this.fillType6=Ct(this.primaryColor,{h:128}),this.fillType7=Ct(this.secondaryColor,{h:128});for(let t=0;t<this.THEME_COLOR_LIMIT;t++)this["pie"+t]=this["cScale"+t];this.pie12=this.pie0,this.pieTitleTextSize=this.pieTitleTextSize||"25px",this.pieTitleTextColor=this.pieTitleTextColor||this.taskTextDarkColor,this.pieSectionTextSize=this.pieSectionTextSize||"17px",this.pieSectionTextColor=this.pieSectionTextColor||this.textColor,this.pieLegendTextSize=this.pieLegendTextSize||"17px",this.pieLegendTextColor=this.pieLegendTextColor||this.taskTextDarkColor,this.pieStrokeColor=this.pieStrokeColor||"black",this.pieStrokeWidth=this.pieStrokeWidth||"2px",this.pieOuterStrokeWidth=this.pieOuterStrokeWidth||"2px",this.pieOuterStrokeColor=this.pieOuterStrokeColor||"black",this.pieOpacity=this.pieOpacity||"0.7",this.quadrant1Fill=this.quadrant1Fill||this.primaryColor,this.quadrant2Fill=this.quadrant2Fill||Ct(this.primaryColor,{r:5,g:5,b:5}),this.quadrant3Fill=this.quadrant3Fill||Ct(this.primaryColor,{r:10,g:10,b:10}),this.quadrant4Fill=this.quadrant4Fill||Ct(this.primaryColor,{r:15,g:15,b:15}),this.quadrant1TextFill=this.quadrant1TextFill||this.primaryTextColor,this.quadrant2TextFill=this.quadrant2TextFill||Ct(this.primaryTextColor,{r:-5,g:-5,b:-5}),this.quadrant3TextFill=this.quadrant3TextFill||Ct(this.primaryTextColor,{r:-10,g:-10,b:-10}),this.quadrant4TextFill=this.quadrant4TextFill||Ct(this.primaryTextColor,{r:-15,g:-15,b:-15}),this.quadrantPointFill=this.quadrantPointFill||dt(this.quadrant1Fill)?yt(this.quadrant1Fill):xt(this.quadrant1Fill),this.quadrantPointTextFill=this.quadrantPointTextFill||this.primaryTextColor,this.quadrantXAxisTextFill=this.quadrantXAxisTextFill||this.primaryTextColor,this.quadrantYAxisTextFill=this.quadrantYAxisTextFill||this.primaryTextColor,this.quadrantInternalBorderStrokeFill=this.quadrantInternalBorderStrokeFill||this.primaryBorderColor,this.quadrantExternalBorderStrokeFill=this.quadrantExternalBorderStrokeFill||this.primaryBorderColor,this.quadrantTitleFill=this.quadrantTitleFill||this.primaryTextColor,this.xyChart={backgroundColor:this.xyChart?.backgroundColor||this.background,titleColor:this.xyChart?.titleColor||this.primaryTextColor,xAxisTitleColor:this.xyChart?.xAxisTitleColor||this.primaryTextColor,xAxisLabelColor:this.xyChart?.xAxisLabelColor||this.primaryTextColor,xAxisTickColor:this.xyChart?.xAxisTickColor||this.primaryTextColor,xAxisLineColor:this.xyChart?.xAxisLineColor||this.primaryTextColor,yAxisTitleColor:this.xyChart?.yAxisTitleColor||this.primaryTextColor,yAxisLabelColor:this.xyChart?.yAxisLabelColor||this.primaryTextColor,yAxisTickColor:this.xyChart?.yAxisTickColor||this.primaryTextColor,yAxisLineColor:this.xyChart?.yAxisLineColor||this.primaryTextColor,plotColorPalette:this.xyChart?.plotColorPalette||"#EEE,#6BB8E4,#8ACB88,#C7ACD6,#E8DCC2,#FFB2A8,#FFF380,#7E8D91,#FFD8B1,#FAF3E0"},this.radar={axisColor:this.radar?.axisColor||this.lineColor,axisStrokeWidth:this.radar?.axisStrokeWidth||2,axisLabelFontSize:this.radar?.axisLabelFontSize||12,curveOpacity:this.radar?.curveOpacity||.5,curveStrokeWidth:this.radar?.curveStrokeWidth||2,graticuleColor:this.radar?.graticuleColor||"#DEDEDE",graticuleStrokeWidth:this.radar?.graticuleStrokeWidth||1,graticuleOpacity:this.radar?.graticuleOpacity||.3,legendBoxSize:this.radar?.legendBoxSize||12,legendFontSize:this.radar?.legendFontSize||12},this.requirementBackground=this.requirementBackground||this.primaryColor,this.requirementBorderColor=this.requirementBorderColor||this.primaryBorderColor,this.requirementBorderSize=this.requirementBorderSize||"1",this.requirementTextColor=this.requirementTextColor||this.primaryTextColor,this.relationColor=this.relationColor||this.lineColor,this.relationLabelBackground=this.relationLabelBackground||this.edgeLabelBackground,this.relationLabelColor=this.relationLabelColor||this.actorTextColor,this.git0=xt(this.pie1,25)||this.primaryColor,this.git1=this.pie2||this.secondaryColor,this.git2=this.pie3||this.tertiaryColor,this.git3=this.pie4||Ct(this.primaryColor,{h:-30}),this.git4=this.pie5||Ct(this.primaryColor,{h:-60}),this.git5=this.pie6||Ct(this.primaryColor,{h:-90}),this.git6=this.pie7||Ct(this.primaryColor,{h:60}),this.git7=this.pie8||Ct(this.primaryColor,{h:120}),this.gitInv0=this.gitInv0||vt(this.git0),this.gitInv1=this.gitInv1||vt(this.git1),this.gitInv2=this.gitInv2||vt(this.git2),this.gitInv3=this.gitInv3||vt(this.git3),this.gitInv4=this.gitInv4||vt(this.git4),this.gitInv5=this.gitInv5||vt(this.git5),this.gitInv6=this.gitInv6||vt(this.git6),this.gitInv7=this.gitInv7||vt(this.git7),this.branchLabelColor=this.branchLabelColor||this.labelTextColor,this.gitBranchLabel0=this.branchLabelColor,this.gitBranchLabel1="white",this.gitBranchLabel2=this.branchLabelColor,this.gitBranchLabel3="white",this.gitBranchLabel4=this.branchLabelColor,this.gitBranchLabel5=this.branchLabelColor,this.gitBranchLabel6=this.branchLabelColor,this.gitBranchLabel7=this.branchLabelColor,this.tagLabelColor=this.tagLabelColor||this.primaryTextColor,this.tagLabelBackground=this.tagLabelBackground||this.primaryColor,this.tagLabelBorder=this.tagBorder||this.primaryBorderColor,this.tagLabelFontSize=this.tagLabelFontSize||"10px",this.commitLabelColor=this.commitLabelColor||this.secondaryTextColor,this.commitLabelBackground=this.commitLabelBackground||this.secondaryColor,this.commitLabelFontSize=this.commitLabelFontSize||"10px",this.attributeBackgroundColorOdd=this.attributeBackgroundColorOdd||St,this.attributeBackgroundColorEven=this.attributeBackgroundColorEven||Tt}calculate(t){if("object"!=typeof t)return void this.updateColors();let e=Object.keys(t);e.forEach(e=>{this[e]=t[e]}),this.updateColors(),e.forEach(e=>{this[e]=t[e]})}},Nt=s(t=>{let e=new It;return e.calculate(t),e},"getThemeVariables"),Rt={base:{getThemeVariables:At},dark:{getThemeVariables:Lt},default:{getThemeVariables:Et},forest:{getThemeVariables:Ot},neutral:{getThemeVariables:Nt}},Pt={flowchart:{useMaxWidth:!0,titleTopMargin:25,subGraphTitleMargin:{top:0,bottom:0},diagramPadding:8,htmlLabels:!0,nodeSpacing:50,rankSpacing:50,curve:"basis",padding:15,defaultRenderer:"dagre-wrapper",wrappingWidth:200,inheritDir:!1},sequence:{useMaxWidth:!0,hideUnusedParticipants:!1,activationWidth:10,diagramMarginX:50,diagramMarginY:10,actorMargin:50,width:150,height:65,boxMargin:10,boxTextMargin:5,noteMargin:10,messageMargin:35,messageAlign:"center",mirrorActors:!0,forceMenus:!1,bottomMarginAdj:1,rightAngles:!1,showSequenceNumbers:!1,actorFontSize:14,actorFontFamily:'"Open Sans", sans-serif',actorFontWeight:400,noteFontSize:14,noteFontFamily:'"trebuchet ms", verdana, arial, sans-serif',noteFontWeight:400,noteAlign:"center",messageFontSize:16,messageFontFamily:'"trebuchet ms", verdana, arial, sans-serif',messageFontWeight:400,wrap:!1,wrapPadding:10,labelBoxWidth:50,labelBoxHeight:20},gantt:{useMaxWidth:!0,titleTopMargin:25,barHeight:20,barGap:4,topPadding:50,rightPadding:75,leftPadding:75,gridLineStartPadding:35,fontSize:11,sectionFontSize:11,numberSectionStyles:4,axisFormat:"%Y-%m-%d",topAxis:!1,displayMode:"",weekday:"sunday"},journey:{useMaxWidth:!0,diagramMarginX:50,diagramMarginY:10,leftMargin:150,maxLabelWidth:360,width:150,height:50,boxMargin:10,boxTextMargin:5,noteMargin:10,messageMargin:35,messageAlign:"center",bottomMarginAdj:1,rightAngles:!1,taskFontSize:14,taskFontFamily:'"Open Sans", sans-serif',taskMargin:50,activationWidth:10,textPlacement:"fo",actorColours:["#8FBC8F","#7CFC00","#00FFFF","#20B2AA","#B0E0E6","#FFFFE0"],sectionFills:["#191970","#8B008B","#4B0082","#2F4F4F","#800000","#8B4513","#00008B"],sectionColours:["#fff"],titleColor:"",titleFontFamily:'"trebuchet ms", verdana, arial, sans-serif',titleFontSize:"4ex"},class:{useMaxWidth:!0,titleTopMargin:25,arrowMarkerAbsolute:!1,dividerMargin:10,padding:5,textHeight:10,defaultRenderer:"dagre-wrapper",htmlLabels:!1,hideEmptyMembersBox:!1},state:{useMaxWidth:!0,titleTopMargin:25,dividerMargin:10,sizeUnit:5,padding:8,textHeight:10,titleShift:-15,noteMargin:10,forkWidth:70,forkHeight:7,miniPadding:2,fontSizeFactor:5.02,fontSize:24,labelHeight:16,edgeLengthFactor:"20",compositTitleSize:35,radius:5,defaultRenderer:"dagre-wrapper"},er:{useMaxWidth:!0,titleTopMargin:25,diagramPadding:20,layoutDirection:"TB",minEntityWidth:100,minEntityHeight:75,entityPadding:15,nodeSpacing:140,rankSpacing:80,stroke:"gray",fill:"honeydew",fontSize:12},pie:{useMaxWidth:!0,textPosition:.75},quadrantChart:{useMaxWidth:!0,chartWidth:500,chartHeight:500,titleFontSize:20,titlePadding:10,quadrantPadding:5,xAxisLabelPadding:5,yAxisLabelPadding:5,xAxisLabelFontSize:16,yAxisLabelFontSize:16,quadrantLabelFontSize:16,quadrantTextTopPadding:5,pointTextPadding:5,pointLabelFontSize:12,pointRadius:5,xAxisPosition:"top",yAxisPosition:"left",quadrantInternalBorderStrokeWidth:1,quadrantExternalBorderStrokeWidth:2},xyChart:{useMaxWidth:!0,width:700,height:500,titleFontSize:20,titlePadding:10,showDataLabel:!1,showTitle:!0,xAxis:{$ref:"#/$defs/XYChartAxisConfig",showLabel:!0,labelFontSize:14,labelPadding:5,showTitle:!0,titleFontSize:16,titlePadding:5,showTick:!0,tickLength:5,tickWidth:2,showAxisLine:!0,axisLineWidth:2},yAxis:{$ref:"#/$defs/XYChartAxisConfig",showLabel:!0,labelFontSize:14,labelPadding:5,showTitle:!0,titleFontSize:16,titlePadding:5,showTick:!0,tickLength:5,tickWidth:2,showAxisLine:!0,axisLineWidth:2},chartOrientation:"vertical",plotReservedSpacePercent:50},requirement:{useMaxWidth:!0,rect_fill:"#f9f9f9",text_color:"#333",rect_border_size:"0.5px",rect_border_color:"#bbb",rect_min_width:200,rect_min_height:200,fontSize:14,rect_padding:10,line_height:20},mindmap:{useMaxWidth:!0,padding:10,maxNodeWidth:200},kanban:{useMaxWidth:!0,padding:8,sectionWidth:200,ticketBaseUrl:""},timeline:{useMaxWidth:!0,diagramMarginX:50,diagramMarginY:10,leftMargin:150,width:150,height:50,boxMargin:10,boxTextMargin:5,noteMargin:10,messageMargin:35,messageAlign:"center",bottomMarginAdj:1,rightAngles:!1,taskFontSize:14,taskFontFamily:'"Open Sans", sans-serif',taskMargin:50,activationWidth:10,textPlacement:"fo",actorColours:["#8FBC8F","#7CFC00","#00FFFF","#20B2AA","#B0E0E6","#FFFFE0"],sectionFills:["#191970","#8B008B","#4B0082","#2F4F4F","#800000","#8B4513","#00008B"],sectionColours:["#fff"],disableMulticolor:!1},gitGraph:{useMaxWidth:!0,titleTopMargin:25,diagramPadding:8,nodeLabel:{width:75,height:100,x:-25,y:0},mainBranchName:"main",mainBranchOrder:0,showCommitLabel:!0,showBranches:!0,rotateCommitLabel:!0,parallelCommits:!1,arrowMarkerAbsolute:!1},c4:{useMaxWidth:!0,diagramMarginX:50,diagramMarginY:10,c4ShapeMargin:50,c4ShapePadding:20,width:216,height:60,boxMargin:10,c4ShapeInRow:4,nextLinePaddingX:0,c4BoundaryInRow:2,personFontSize:14,personFontFamily:'"Open Sans", sans-serif',personFontWeight:"normal",external_personFontSize:14,external_personFontFamily:'"Open Sans", sans-serif',external_personFontWeight:"normal",systemFontSize:14,systemFontFamily:'"Open Sans", sans-serif',systemFontWeight:"normal",external_systemFontSize:14,external_systemFontFamily:'"Open Sans", sans-serif',external_systemFontWeight:"normal",system_dbFontSize:14,system_dbFontFamily:'"Open Sans", sans-serif',system_dbFontWeight:"normal",external_system_dbFontSize:14,external_system_dbFontFamily:'"Open Sans", sans-serif',external_system_dbFontWeight:"normal",system_queueFontSize:14,system_queueFontFamily:'"Open Sans", sans-serif',system_queueFontWeight:"normal",external_system_queueFontSize:14,external_system_queueFontFamily:'"Open Sans", sans-serif',external_system_queueFontWeight:"normal",boundaryFontSize:14,boundaryFontFamily:'"Open Sans", sans-serif',boundaryFontWeight:"normal",messageFontSize:12,messageFontFamily:'"Open Sans", sans-serif',messageFontWeight:"normal",containerFontSize:14,containerFontFamily:'"Open Sans", sans-serif',containerFontWeight:"normal",external_containerFontSize:14,external_containerFontFamily:'"Open Sans", sans-serif',external_containerFontWeight:"normal",container_dbFontSize:14,container_dbFontFamily:'"Open Sans", sans-serif',container_dbFontWeight:"normal",external_container_dbFontSize:14,external_container_dbFontFamily:'"Open Sans", sans-serif',external_container_dbFontWeight:"normal",container_queueFontSize:14,container_queueFontFamily:'"Open Sans", sans-serif',container_queueFontWeight:"normal",external_container_queueFontSize:14,external_container_queueFontFamily:'"Open Sans", sans-serif',external_container_queueFontWeight:"normal",componentFontSize:14,componentFontFamily:'"Open Sans", sans-serif',componentFontWeight:"normal",external_componentFontSize:14,external_componentFontFamily:'"Open Sans", sans-serif',external_componentFontWeight:"normal",component_dbFontSize:14,component_dbFontFamily:'"Open Sans", sans-serif',component_dbFontWeight:"normal",external_component_dbFontSize:14,external_component_dbFontFamily:'"Open Sans", sans-serif',external_component_dbFontWeight:"normal",component_queueFontSize:14,component_queueFontFamily:'"Open Sans", sans-serif',component_queueFontWeight:"normal",external_component_queueFontSize:14,external_component_queueFontFamily:'"Open Sans", sans-serif',external_component_queueFontWeight:"normal",wrap:!0,wrapPadding:10,person_bg_color:"#08427B",person_border_color:"#073B6F",external_person_bg_color:"#686868",external_person_border_color:"#8A8A8A",system_bg_color:"#1168BD",system_border_color:"#3C7FC0",system_db_bg_color:"#1168BD",system_db_border_color:"#3C7FC0",system_queue_bg_color:"#1168BD",system_queue_border_color:"#3C7FC0",external_system_bg_color:"#999999",external_system_border_color:"#8A8A8A",external_system_db_bg_color:"#999999",external_system_db_border_color:"#8A8A8A",external_system_queue_bg_color:"#999999",external_system_queue_border_color:"#8A8A8A",container_bg_color:"#438DD5",container_border_color:"#3C7FC0",container_db_bg_color:"#438DD5",container_db_border_color:"#3C7FC0",container_queue_bg_color:"#438DD5",container_queue_border_color:"#3C7FC0",external_container_bg_color:"#B3B3B3",external_container_border_color:"#A6A6A6",external_container_db_bg_color:"#B3B3B3",external_container_db_border_color:"#A6A6A6",external_container_queue_bg_color:"#B3B3B3",external_container_queue_border_color:"#A6A6A6",component_bg_color:"#85BBF0",component_border_color:"#78A8D8",component_db_bg_color:"#85BBF0",component_db_border_color:"#78A8D8",component_queue_bg_color:"#85BBF0",component_queue_border_color:"#78A8D8",external_component_bg_color:"#CCCCCC",external_component_border_color:"#BFBFBF",external_component_db_bg_color:"#CCCCCC",external_component_db_border_color:"#BFBFBF",external_component_queue_bg_color:"#CCCCCC",external_component_queue_border_color:"#BFBFBF"},sankey:{useMaxWidth:!0,width:600,height:400,linkColor:"gradient",nodeAlignment:"justify",showValues:!0,prefix:"",suffix:""},block:{useMaxWidth:!0,padding:8},packet:{useMaxWidth:!0,rowHeight:32,bitWidth:32,bitsPerRow:32,showBits:!0,paddingX:5,paddingY:5},architecture:{useMaxWidth:!0,padding:40,iconSize:80,fontSize:16},radar:{useMaxWidth:!0,width:600,height:600,marginTop:50,marginRight:50,marginBottom:50,marginLeft:50,axisScaleFactor:1,axisLabelFactor:1.05,curveTension:.17},theme:"default",look:"classic",handDrawnSeed:0,layout:"dagre",maxTextSize:5e4,maxEdges:500,darkMode:!1,fontFamily:'"trebuchet ms", verdana, arial, sans-serif;',logLevel:5,securityLevel:"strict",startOnLoad:!0,arrowMarkerAbsolute:!1,secure:["secure","securityLevel","startOnLoad","maxTextSize","suppressErrorRendering","maxEdges"],legacyMathML:!1,forceLegacyMathML:!1,deterministicIds:!1,fontSize:16,markdownAutoWrap:!0,suppressErrorRendering:!1},zt={...Pt,deterministicIDSeed:void 0,elk:{mergeEdges:!1,nodePlacementStrategy:"BRANDES_KOEPF"},themeCSS:void 0,themeVariables:Rt.default.getThemeVariables(),sequence:{...Pt.sequence,messageFont:s(function(){return{fontFamily:this.messageFontFamily,fontSize:this.messageFontSize,fontWeight:this.messageFontWeight}},"messageFont"),noteFont:s(function(){return{fontFamily:this.noteFontFamily,fontSize:this.noteFontSize,fontWeight:this.noteFontWeight}},"noteFont"),actorFont:s(function(){return{fontFamily:this.actorFontFamily,fontSize:this.actorFontSize,fontWeight:this.actorFontWeight}},"actorFont")},class:{hideEmptyMembersBox:!1},gantt:{...Pt.gantt,tickInterval:void 0,useWidth:void 0},c4:{...Pt.c4,useWidth:void 0,personFont:s(function(){return{fontFamily:this.personFontFamily,fontSize:this.personFontSize,fontWeight:this.personFontWeight}},"personFont"),flowchart:{...Pt.flowchart,inheritDir:!1},external_personFont:s(function(){return{fontFamily:this.external_personFontFamily,fontSize:this.external_personFontSize,fontWeight:this.external_personFontWeight}},"external_personFont"),systemFont:s(function(){return{fontFamily:this.systemFontFamily,fontSize:this.systemFontSize,fontWeight:this.systemFontWeight}},"systemFont"),external_systemFont:s(function(){return{fontFamily:this.external_systemFontFamily,fontSize:this.external_systemFontSize,fontWeight:this.external_systemFontWeight}},"external_systemFont"),system_dbFont:s(function(){return{fontFamily:this.system_dbFontFamily,fontSize:this.system_dbFontSize,fontWeight:this.system_dbFontWeight}},"system_dbFont"),external_system_dbFont:s(function(){return{fontFamily:this.external_system_dbFontFamily,fontSize:this.external_system_dbFontSize,fontWeight:this.external_system_dbFontWeight}},"external_system_dbFont"),system_queueFont:s(function(){return{fontFamily:this.system_queueFontFamily,fontSize:this.system_queueFontSize,fontWeight:this.system_queueFontWeight}},"system_queueFont"),external_system_queueFont:s(function(){return{fontFamily:this.external_system_queueFontFamily,fontSize:this.external_system_queueFontSize,fontWeight:this.external_system_queueFontWeight}},"external_system_queueFont"),containerFont:s(function(){return{fontFamily:this.containerFontFamily,fontSize:this.containerFontSize,fontWeight:this.containerFontWeight}},"containerFont"),external_containerFont:s(function(){return{fontFamily:this.external_containerFontFamily,fontSize:this.external_containerFontSize,fontWeight:this.external_containerFontWeight}},"external_containerFont"),container_dbFont:s(function(){return{fontFamily:this.container_dbFontFamily,fontSize:this.container_dbFontSize,fontWeight:this.container_dbFontWeight}},"container_dbFont"),external_container_dbFont:s(function(){return{fontFamily:this.external_container_dbFontFamily,fontSize:this.external_container_dbFontSize,fontWeight:this.external_container_dbFontWeight}},"external_container_dbFont"),container_queueFont:s(function(){return{fontFamily:this.container_queueFontFamily,fontSize:this.container_queueFontSize,fontWeight:this.container_queueFontWeight}},"container_queueFont"),external_container_queueFont:s(function(){return{fontFamily:this.external_container_queueFontFamily,fontSize:this.external_container_queueFontSize,fontWeight:this.external_container_queueFontWeight}},"external_container_queueFont"),componentFont:s(function(){return{fontFamily:this.componentFontFamily,fontSize:this.componentFontSize,fontWeight:this.componentFontWeight}},"componentFont"),external_componentFont:s(function(){return{fontFamily:this.external_componentFontFamily,fontSize:this.external_componentFontSize,fontWeight:this.external_componentFontWeight}},"external_componentFont"),component_dbFont:s(function(){return{fontFamily:this.component_dbFontFamily,fontSize:this.component_dbFontSize,fontWeight:this.component_dbFontWeight}},"component_dbFont"),external_component_dbFont:s(function(){return{fontFamily:this.external_component_dbFontFamily,fontSize:this.external_component_dbFontSize,fontWeight:this.external_component_dbFontWeight}},"external_component_dbFont"),component_queueFont:s(function(){return{fontFamily:this.component_queueFontFamily,fontSize:this.component_queueFontSize,fontWeight:this.component_queueFontWeight}},"component_queueFont"),external_component_queueFont:s(function(){return{fontFamily:this.external_component_queueFontFamily,fontSize:this.external_component_queueFontSize,fontWeight:this.external_component_queueFontWeight}},"external_component_queueFont"),boundaryFont:s(function(){return{fontFamily:this.boundaryFontFamily,fontSize:this.boundaryFontSize,fontWeight:this.boundaryFontWeight}},"boundaryFont"),messageFont:s(function(){return{fontFamily:this.messageFontFamily,fontSize:this.messageFontSize,fontWeight:this.messageFontWeight}},"messageFont")},pie:{...Pt.pie,useWidth:984},xyChart:{...Pt.xyChart,useWidth:void 0},requirement:{...Pt.requirement,useWidth:void 0},packet:{...Pt.packet},radar:{...Pt.radar},treemap:{useMaxWidth:!0,padding:10,diagramPadding:8,showValues:!0,nodeWidth:100,nodeHeight:40,borderWidth:1,valueFontSize:12,labelFontSize:14,valueFormat:","}},qt=s((t,e="")=>Object.keys(t).reduce((r,i)=>Array.isArray(t[i])?r:"object"==typeof t[i]&&null!==t[i]?[...r,e+i,...qt(t[i],"")]:[...r,e+i],[]),"keyify"),jt=new Set(qt(zt,"")),Wt=zt,Ht=s(t=>{if(y.debug("sanitizeDirective called with",t),"object"==typeof t&&null!=t){if(Array.isArray(t))return void t.forEach(t=>Ht(t));for(let e of Object.keys(t)){if(y.debug("Checking key",e),e.startsWith("__")||e.includes("proto")||e.includes("constr")||!jt.has(e)||null==t[e]){y.debug("sanitize deleting key: ",e),delete t[e];continue}if("object"==typeof t[e]){y.debug("sanitizing object",e),Ht(t[e]);continue}let r=["themeCSS","fontFamily","altFontFamily"];for(let i of r)e.includes(i)&&(y.debug("sanitizing css option",e),t[e]=Ut(t[e]))}if(t.themeVariables)for(let e of Object.keys(t.themeVariables)){let r=t.themeVariables[e];r?.match&&!r.match(/^[\d "#%(),.;A-Za-z]+$/)&&(t.themeVariables[e]="")}y.debug("After sanitization",t)}},"sanitizeDirective"),Ut=s(t=>{let e=0,r=0;for(let i of t){if(e<r)return"{ /* ERROR: Unbalanced CSS */ }";"{"===i?e++:"}"===i&&r++}return e!==r?"{ /* ERROR: Unbalanced CSS */ }":t},"sanitizeCss"),Yt=Object.freeze(Wt),Vt=A({},Yt),Gt=[],Xt=A({},Yt),Zt=s((t,e)=>{let r=A({},t),i={};for(let t of e)ie(t),i=A(i,t);if(r=A(r,i),i.theme&&i.theme in Rt){let t=A({},N),e=A(t.themeVariables||{},i.themeVariables);r.theme&&r.theme in Rt&&(r.themeVariables=Rt[r.theme].getThemeVariables(e))}return he(Xt=r),Xt},"updateCurrentConfig"),Qt=s(t=>(Vt=A({},Yt),Vt=A(Vt,t),t.theme&&Rt[t.theme]&&(Vt.themeVariables=Rt[t.theme].getThemeVariables(t.themeVariables)),Zt(Vt,Gt),Vt),"setSiteConfig"),Kt=s(t=>{N=A({},t)},"saveConfigFromInitialize"),Jt=s(t=>(Vt=A(Vt,t),Zt(Vt,Gt),Vt),"updateSiteConfig"),te=s(()=>A({},Vt),"getSiteConfig"),ee=s(t=>(he(t),A(Xt,t),re()),"setConfig"),re=s(()=>A({},Xt),"getConfig"),ie=s(t=>{t&&(["secure",...Vt.secure??[]].forEach(e=>{Object.hasOwn(t,e)&&(y.debug(`Denied attempt to modify a secure key ${e}`,t[e]),delete t[e])}),Object.keys(t).forEach(e=>{e.startsWith("__")&&delete t[e]}),Object.keys(t).forEach(e=>{"string"==typeof t[e]&&(t[e].includes("<")||t[e].includes(">")||t[e].includes("url(data:"))&&delete t[e],"object"==typeof t[e]&&ie(t[e])}))},"sanitize"),ne=s(t=>{Ht(t),t.fontFamily&&!t.themeVariables?.fontFamily&&(t.themeVariables={...t.themeVariables,fontFamily:t.fontFamily}),Gt.push(t),Zt(Vt,Gt)},"addDirective"),ae=s((t=Vt)=>{Zt(t,Gt=[])},"reset"),oe={LAZY_LOAD_DEPRECATED:"The configuration options lazyLoadedDiagrams and loadExternalDiagramsAtStartup are deprecated. Please use registerExternalDiagrams instead."},se={},le=s(t=>{se[t]||(y.warn(oe[t]),se[t]=!0)},"issueWarning"),he=s(t=>{t&&(t.lazyLoadedDiagrams||t.loadExternalDiagramsAtStartup)&&le("LAZY_LOAD_DEPRECATED")},"checkConfig"),{entries:ce,setPrototypeOf:ue,isFrozen:de,getPrototypeOf:pe,getOwnPropertyDescriptor:fe}=Object,{freeze:ge,seal:ye,create:me}=Object,{apply:xe,construct:be}=typeof Reflect<"u"&&Reflect;ge||(ge=s(function(t){return t},"freeze")),ye||(ye=s(function(t){return t},"seal")),xe||(xe=s(function(t,e,r){return t.apply(e,r)},"apply")),be||(be=s(function(t,e){return new t(...e)},"construct"));var Ce=De(Array.prototype.forEach),ke=De(Array.prototype.lastIndexOf),we=De(Array.prototype.pop),_e=De(Array.prototype.push),ve=De(Array.prototype.splice),Se=De(String.prototype.toLowerCase),Te=De(String.prototype.toString),Me=De(String.prototype.match),Be=De(String.prototype.replace),Ae=De(String.prototype.indexOf),Fe=De(String.prototype.trim),Le=De(Object.prototype.hasOwnProperty),$e=De(RegExp.prototype.test),Ee=Oe(TypeError);function De(t){return function(e){e instanceof RegExp&&(e.lastIndex=0);for(var r=arguments.length,i=new Array(r>1?r-1:0),n=1;n<r;n++)i[n-1]=arguments[n];return xe(t,e,i)}}function Oe(t){return function(){for(var e=arguments.length,r=new Array(e),i=0;i<e;i++)r[i]=arguments[i];return be(t,r)}}function Ie(t,e){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:Se;ue&&ue(t,null);let i=e.length;for(;i--;){let n=e[i];if("string"==typeof n){let t=r(n);t!==n&&(de(e)||(e[i]=t),n=t)}t[n]=!0}return t}function Ne(t){for(let e=0;e<t.length;e++)Le(t,e)||(t[e]=null);return t}function Re(t){let e=me(null);for(let[r,i]of ce(t))Le(t,r)&&(Array.isArray(i)?e[r]=Ne(i):i&&"object"==typeof i&&i.constructor===Object?e[r]=Re(i):e[r]=i);return e}function Pe(t,e){for(;null!==t;){let r=fe(t,e);if(r){if(r.get)return De(r.get);if("function"==typeof r.value)return De(r.value)}t=pe(t)}function r(){return null}return s(r,"fallbackValue"),r}s(De,"unapply"),s(Oe,"unconstruct"),s(Ie,"addToSet"),s(Ne,"cleanArray"),s(Re,"clone"),s(Pe,"lookupGetter");var ze=ge(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),qe=ge(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),je=ge(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),We=ge(["animate","color-profile","cursor","discard","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),He=ge(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover","mprescripts"]),Ue=ge(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),Ye=ge(["#text"]),Ve=ge(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","nonce","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","popover","popovertarget","popovertargetaction","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","wrap","xmlns","slot"]),Ge=ge(["accent-height","accumulate","additive","alignment-baseline","amplitude","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","exponent","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","intercept","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","slope","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","tablevalues","targetx","targety","transform","transform-origin","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),Xe=ge(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),Ze=ge(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),Qe=ye(/\{\{[\w\W]*|[\w\W]*\}\}/gm),Ke=ye(/<%[\w\W]*|[\w\W]*%>/gm),Je=ye(/\$\{[\w\W]*/gm),tr=ye(/^data-[\-\w.\u00B7-\uFFFF]+$/),er=ye(/^aria-[\-\w]+$/),rr=ye(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),ir=ye(/^(?:\w+script|data):/i),nr=ye(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),ar=ye(/^html$/i),or=ye(/^[a-z][.\w]*(-[.\w]+)+$/i),sr=Object.freeze({__proto__:null,ARIA_ATTR:er,ATTR_WHITESPACE:nr,CUSTOM_ELEMENT:or,DATA_ATTR:tr,DOCTYPE_NAME:ar,ERB_EXPR:Ke,IS_ALLOWED_URI:rr,IS_SCRIPT_OR_DATA:ir,MUSTACHE_EXPR:Qe,TMPLIT_EXPR:Je}),lr=1,hr=3,cr=7,ur=8,dr=9,pr=s(function(){return typeof window>"u"?null:window},"getGlobal"),fr=s(function(t,e){if("object"!=typeof t||"function"!=typeof t.createPolicy)return null;let r=null,i="data-tt-policy-suffix";e&&e.hasAttribute(i)&&(r=e.getAttribute(i));let n="dompurify"+(r?"#"+r:"");try{return t.createPolicy(n,{createHTML:t=>t,createScriptURL:t=>t})}catch{return console.warn("TrustedTypes policy "+n+" could not be created."),null}},"_createTrustedTypesPolicy"),gr=s(function(){return{afterSanitizeAttributes:[],afterSanitizeElements:[],afterSanitizeShadowDOM:[],beforeSanitizeAttributes:[],beforeSanitizeElements:[],beforeSanitizeShadowDOM:[],uponSanitizeAttribute:[],uponSanitizeElement:[],uponSanitizeShadowNode:[]}},"_createHooksMap");function yr(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:pr(),e=s(t=>yr(t),"DOMPurify");if(e.version="3.2.5",e.removed=[],!t||!t.document||t.document.nodeType!==dr||!t.Element)return e.isSupported=!1,e;let{document:r}=t,i=r,n=i.currentScript,{DocumentFragment:a,HTMLTemplateElement:o,Node:l,Element:h,NodeFilter:c,NamedNodeMap:u=t.NamedNodeMap||t.MozNamedAttrMap,HTMLFormElement:d,DOMParser:p,trustedTypes:f}=t,g=h.prototype,y=Pe(g,"cloneNode"),m=Pe(g,"remove"),x=Pe(g,"nextSibling"),b=Pe(g,"childNodes"),C=Pe(g,"parentNode");if("function"==typeof o){let t=r.createElement("template");t.content&&t.content.ownerDocument&&(r=t.content.ownerDocument)}let k,w="",{implementation:_,createNodeIterator:v,createDocumentFragment:S,getElementsByTagName:T}=r,{importNode:M}=i,B=gr();e.isSupported="function"==typeof ce&&"function"==typeof C&&_&&void 0!==_.createHTMLDocument;let{MUSTACHE_EXPR:A,ERB_EXPR:F,TMPLIT_EXPR:L,DATA_ATTR:$,ARIA_ATTR:E,IS_SCRIPT_OR_DATA:D,ATTR_WHITESPACE:O,CUSTOM_ELEMENT:I}=sr,{IS_ALLOWED_URI:N}=sr,R=null,P=Ie({},[...ze,...qe,...je,...He,...Ye]),z=null,q=Ie({},[...Ve,...Ge,...Xe,...Ze]),j=Object.seal(me(null,{tagNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},allowCustomizedBuiltInElements:{writable:!0,configurable:!1,enumerable:!0,value:!1}})),W=null,H=null,U=!0,Y=!0,V=!1,G=!0,X=!1,Z=!0,Q=!1,K=!1,J=!1,tt=!1,et=!1,rt=!1,it=!0,nt=!1,at=!0,ot=!1,st={},lt=null,ht=Ie({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),ct=null,ut=Ie({},["audio","video","img","source","image","track"]),dt=null,pt=Ie({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),ft="http://www.w3.org/1998/Math/MathML",gt="http://www.w3.org/2000/svg",yt="http://www.w3.org/1999/xhtml",mt=yt,xt=!1,bt=null,Ct=Ie({},[ft,gt,yt],Te),kt=Ie({},["mi","mo","mn","ms","mtext"]),wt=Ie({},["annotation-xml"]),_t=Ie({},["title","style","font","a","script"]),vt=null,St=["application/xhtml+xml","text/html"],Tt=null,Mt=null,Bt=r.createElement("form"),At=s(function(t){return t instanceof RegExp||t instanceof Function},"isRegexOrFunction"),Ft=s(function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(!Mt||Mt!==t){if((!t||"object"!=typeof t)&&(t={}),t=Re(t),vt=-1===St.indexOf(t.PARSER_MEDIA_TYPE)?"text/html":t.PARSER_MEDIA_TYPE,Tt="application/xhtml+xml"===vt?Te:Se,R=Le(t,"ALLOWED_TAGS")?Ie({},t.ALLOWED_TAGS,Tt):P,z=Le(t,"ALLOWED_ATTR")?Ie({},t.ALLOWED_ATTR,Tt):q,bt=Le(t,"ALLOWED_NAMESPACES")?Ie({},t.ALLOWED_NAMESPACES,Te):Ct,dt=Le(t,"ADD_URI_SAFE_ATTR")?Ie(Re(pt),t.ADD_URI_SAFE_ATTR,Tt):pt,ct=Le(t,"ADD_DATA_URI_TAGS")?Ie(Re(ut),t.ADD_DATA_URI_TAGS,Tt):ut,lt=Le(t,"FORBID_CONTENTS")?Ie({},t.FORBID_CONTENTS,Tt):ht,W=Le(t,"FORBID_TAGS")?Ie({},t.FORBID_TAGS,Tt):{},H=Le(t,"FORBID_ATTR")?Ie({},t.FORBID_ATTR,Tt):{},st=!!Le(t,"USE_PROFILES")&&t.USE_PROFILES,U=!1!==t.ALLOW_ARIA_ATTR,Y=!1!==t.ALLOW_DATA_ATTR,V=t.ALLOW_UNKNOWN_PROTOCOLS||!1,G=!1!==t.ALLOW_SELF_CLOSE_IN_ATTR,X=t.SAFE_FOR_TEMPLATES||!1,Z=!1!==t.SAFE_FOR_XML,Q=t.WHOLE_DOCUMENT||!1,tt=t.RETURN_DOM||!1,et=t.RETURN_DOM_FRAGMENT||!1,rt=t.RETURN_TRUSTED_TYPE||!1,J=t.FORCE_BODY||!1,it=!1!==t.SANITIZE_DOM,nt=t.SANITIZE_NAMED_PROPS||!1,at=!1!==t.KEEP_CONTENT,ot=t.IN_PLACE||!1,N=t.ALLOWED_URI_REGEXP||rr,mt=t.NAMESPACE||yt,kt=t.MATHML_TEXT_INTEGRATION_POINTS||kt,wt=t.HTML_INTEGRATION_POINTS||wt,j=t.CUSTOM_ELEMENT_HANDLING||{},t.CUSTOM_ELEMENT_HANDLING&&At(t.CUSTOM_ELEMENT_HANDLING.tagNameCheck)&&(j.tagNameCheck=t.CUSTOM_ELEMENT_HANDLING.tagNameCheck),t.CUSTOM_ELEMENT_HANDLING&&At(t.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)&&(j.attributeNameCheck=t.CUSTOM_ELEMENT_HANDLING.attributeNameCheck),t.CUSTOM_ELEMENT_HANDLING&&"boolean"==typeof t.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements&&(j.allowCustomizedBuiltInElements=t.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements),X&&(Y=!1),et&&(tt=!0),st&&(R=Ie({},Ye),z=[],!0===st.html&&(Ie(R,ze),Ie(z,Ve)),!0===st.svg&&(Ie(R,qe),Ie(z,Ge),Ie(z,Ze)),!0===st.svgFilters&&(Ie(R,je),Ie(z,Ge),Ie(z,Ze)),!0===st.mathMl&&(Ie(R,He),Ie(z,Xe),Ie(z,Ze))),t.ADD_TAGS&&(R===P&&(R=Re(R)),Ie(R,t.ADD_TAGS,Tt)),t.ADD_ATTR&&(z===q&&(z=Re(z)),Ie(z,t.ADD_ATTR,Tt)),t.ADD_URI_SAFE_ATTR&&Ie(dt,t.ADD_URI_SAFE_ATTR,Tt),t.FORBID_CONTENTS&&(lt===ht&&(lt=Re(lt)),Ie(lt,t.FORBID_CONTENTS,Tt)),at&&(R["#text"]=!0),Q&&Ie(R,["html","head","body"]),R.table&&(Ie(R,["tbody"]),delete W.tbody),t.TRUSTED_TYPES_POLICY){if("function"!=typeof t.TRUSTED_TYPES_POLICY.createHTML)throw Ee('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');if("function"!=typeof t.TRUSTED_TYPES_POLICY.createScriptURL)throw Ee('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');k=t.TRUSTED_TYPES_POLICY,w=k.createHTML("")}else void 0===k&&(k=fr(f,n)),null!==k&&"string"==typeof w&&(w=k.createHTML(""));ge&&ge(t),Mt=t}},"_parseConfig"),Lt=Ie({},[...qe,...je,...We]),$t=Ie({},[...He,...Ue]),Et=s(function(t){let e=C(t);(!e||!e.tagName)&&(e={namespaceURI:mt,tagName:"template"});let r=Se(t.tagName),i=Se(e.tagName);return!!bt[t.namespaceURI]&&(t.namespaceURI===gt?e.namespaceURI===yt?"svg"===r:e.namespaceURI===ft?"svg"===r&&("annotation-xml"===i||kt[i]):!!Lt[r]:t.namespaceURI===ft?e.namespaceURI===yt?"math"===r:e.namespaceURI===gt?"math"===r&&wt[i]:!!$t[r]:t.namespaceURI===yt?!(e.namespaceURI===gt&&!wt[i]||e.namespaceURI===ft&&!kt[i])&&(!$t[r]&&(_t[r]||!Lt[r])):!("application/xhtml+xml"!==vt||!bt[t.namespaceURI]))},"_checkValidNamespace"),Dt=s(function(t){_e(e.removed,{element:t});try{C(t).removeChild(t)}catch{m(t)}},"_forceRemove"),Ot=s(function(t,r){try{_e(e.removed,{attribute:r.getAttributeNode(t),from:r})}catch{_e(e.removed,{attribute:null,from:r})}if(r.removeAttribute(t),"is"===t)if(tt||et)try{Dt(r)}catch{}else try{r.setAttribute(t,"")}catch{}},"_removeAttribute"),It=s(function(t){let e=null,i=null;if(J)t="<remove></remove>"+t;else{let e=Me(t,/^[\r\n\t ]+/);i=e&&e[0]}"application/xhtml+xml"===vt&&mt===yt&&(t='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+t+"</body></html>");let n=k?k.createHTML(t):t;if(mt===yt)try{e=(new p).parseFromString(n,vt)}catch{}if(!e||!e.documentElement){e=_.createDocument(mt,"template",null);try{e.documentElement.innerHTML=xt?w:n}catch{}}let a=e.body||e.documentElement;return t&&i&&a.insertBefore(r.createTextNode(i),a.childNodes[0]||null),mt===yt?T.call(e,Q?"html":"body")[0]:Q?e.documentElement:a},"_initDocument"),Nt=s(function(t){return v.call(t.ownerDocument||t,t,c.SHOW_ELEMENT|c.SHOW_COMMENT|c.SHOW_TEXT|c.SHOW_PROCESSING_INSTRUCTION|c.SHOW_CDATA_SECTION,null)},"_createNodeIterator"),Rt=s(function(t){return t instanceof d&&("string"!=typeof t.nodeName||"string"!=typeof t.textContent||"function"!=typeof t.removeChild||!(t.attributes instanceof u)||"function"!=typeof t.removeAttribute||"function"!=typeof t.setAttribute||"string"!=typeof t.namespaceURI||"function"!=typeof t.insertBefore||"function"!=typeof t.hasChildNodes)},"_isClobbered"),Pt=s(function(t){return"function"==typeof l&&t instanceof l},"_isNode");function zt(t,r,i){Ce(t,t=>{t.call(e,r,i,Mt)})}s(zt,"_executeHooks");let qt=s(function(t){let r=null;if(zt(B.beforeSanitizeElements,t,null),Rt(t))return Dt(t),!0;let i=Tt(t.nodeName);if(zt(B.uponSanitizeElement,t,{tagName:i,allowedTags:R}),t.hasChildNodes()&&!Pt(t.firstElementChild)&&$e(/<[/\w!]/g,t.innerHTML)&&$e(/<[/\w!]/g,t.textContent)||t.nodeType===cr||Z&&t.nodeType===ur&&$e(/<[/\w]/g,t.data))return Dt(t),!0;if(!R[i]||W[i]){if(!W[i]&&Wt(i)&&(j.tagNameCheck instanceof RegExp&&$e(j.tagNameCheck,i)||j.tagNameCheck instanceof Function&&j.tagNameCheck(i)))return!1;if(at&&!lt[i]){let e=C(t)||t.parentNode,r=b(t)||t.childNodes;if(r&&e){for(let i=r.length-1;i>=0;--i){let n=y(r[i],!0);n.__removalCount=(t.__removalCount||0)+1,e.insertBefore(n,x(t))}}}return Dt(t),!0}return t instanceof h&&!Et(t)||("noscript"===i||"noembed"===i||"noframes"===i)&&$e(/<\/no(script|embed|frames)/i,t.innerHTML)?(Dt(t),!0):(X&&t.nodeType===hr&&(r=t.textContent,Ce([A,F,L],t=>{r=Be(r,t," ")}),t.textContent!==r&&(_e(e.removed,{element:t.cloneNode()}),t.textContent=r)),zt(B.afterSanitizeElements,t,null),!1)},"_sanitizeElements"),jt=s(function(t,e,i){if(it&&("id"===e||"name"===e)&&(i in r||i in Bt))return!1;if((!Y||H[e]||!$e($,e))&&(!U||!$e(E,e)))if(!z[e]||H[e]){if(!(Wt(t)&&(j.tagNameCheck instanceof RegExp&&$e(j.tagNameCheck,t)||j.tagNameCheck instanceof Function&&j.tagNameCheck(t))&&(j.attributeNameCheck instanceof RegExp&&$e(j.attributeNameCheck,e)||j.attributeNameCheck instanceof Function&&j.attributeNameCheck(e))||"is"===e&&j.allowCustomizedBuiltInElements&&(j.tagNameCheck instanceof RegExp&&$e(j.tagNameCheck,i)||j.tagNameCheck instanceof Function&&j.tagNameCheck(i))))return!1}else if(!dt[e]&&!$e(N,Be(i,O,""))&&("src"!==e&&"xlink:href"!==e&&"href"!==e||"script"===t||0!==Ae(i,"data:")||!ct[t])&&(!V||$e(D,Be(i,O,"")))&&i)return!1;return!0},"_isValidAttribute"),Wt=s(function(t){return"annotation-xml"!==t&&Me(t,I)},"_isBasicCustomElement"),Ht=s(function(t){zt(B.beforeSanitizeAttributes,t,null);let{attributes:r}=t;if(!r||Rt(t))return;let i={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:z,forceKeepAttr:void 0},n=r.length;for(;n--;){let a=r[n],{name:o,namespaceURI:s,value:l}=a,h=Tt(o),c="value"===o?l:Fe(l);if(i.attrName=h,i.attrValue=c,i.keepAttr=!0,i.forceKeepAttr=void 0,zt(B.uponSanitizeAttribute,t,i),c=i.attrValue,nt&&("id"===h||"name"===h)&&(Ot(o,t),c="user-content-"+c),Z&&$e(/((--!?|])>)|<\/(style|title)/i,c)){Ot(o,t);continue}if(i.forceKeepAttr||(Ot(o,t),!i.keepAttr))continue;if(!G&&$e(/\/>/i,c)){Ot(o,t);continue}X&&Ce([A,F,L],t=>{c=Be(c,t," ")});let u=Tt(t.nodeName);if(jt(u,h,c)){if(k&&"object"==typeof f&&"function"==typeof f.getAttributeType&&!s)switch(f.getAttributeType(u,h)){case"TrustedHTML":c=k.createHTML(c);break;case"TrustedScriptURL":c=k.createScriptURL(c)}try{s?t.setAttributeNS(s,o,c):t.setAttribute(o,c),Rt(t)?Dt(t):we(e.removed)}catch{}}}zt(B.afterSanitizeAttributes,t,null)},"_sanitizeAttributes"),Ut=s(function t(e){let r=null,i=Nt(e);for(zt(B.beforeSanitizeShadowDOM,e,null);r=i.nextNode();)zt(B.uponSanitizeShadowNode,r,null),qt(r),Ht(r),r.content instanceof a&&t(r.content);zt(B.afterSanitizeShadowDOM,e,null)},"_sanitizeShadowDOM");return e.sanitize=function(t){let r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=null,o=null,s=null,h=null;if(xt=!t,xt&&(t="\x3c!--\x3e"),"string"!=typeof t&&!Pt(t)){if("function"!=typeof t.toString)throw Ee("toString is not a function");if("string"!=typeof(t=t.toString()))throw Ee("dirty is not a string, aborting")}if(!e.isSupported)return t;if(K||Ft(r),e.removed=[],"string"==typeof t&&(ot=!1),ot){if(t.nodeName){let e=Tt(t.nodeName);if(!R[e]||W[e])throw Ee("root node is forbidden and cannot be sanitized in-place")}}else if(t instanceof l)n=It("\x3c!----\x3e"),o=n.ownerDocument.importNode(t,!0),o.nodeType===lr&&"BODY"===o.nodeName||"HTML"===o.nodeName?n=o:n.appendChild(o);else{if(!tt&&!X&&!Q&&-1===t.indexOf("<"))return k&&rt?k.createHTML(t):t;if(n=It(t),!n)return tt?null:rt?w:""}n&&J&&Dt(n.firstChild);let c=Nt(ot?t:n);for(;s=c.nextNode();)qt(s),Ht(s),s.content instanceof a&&Ut(s.content);if(ot)return t;if(tt){if(et)for(h=S.call(n.ownerDocument);n.firstChild;)h.appendChild(n.firstChild);else h=n;return(z.shadowroot||z.shadowrootmode)&&(h=M.call(i,h,!0)),h}let u=Q?n.outerHTML:n.innerHTML;return Q&&R["!doctype"]&&n.ownerDocument&&n.ownerDocument.doctype&&n.ownerDocument.doctype.name&&$e(ar,n.ownerDocument.doctype.name)&&(u="<!DOCTYPE "+n.ownerDocument.doctype.name+">\n"+u),X&&Ce([A,F,L],t=>{u=Be(u,t," ")}),k&&rt?k.createHTML(u):u},e.setConfig=function(){Ft(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{}),K=!0},e.clearConfig=function(){Mt=null,K=!1},e.isValidAttribute=function(t,e,r){Mt||Ft({});let i=Tt(t),n=Tt(e);return jt(i,n,r)},e.addHook=function(t,e){"function"==typeof e&&_e(B[t],e)},e.removeHook=function(t,e){if(void 0!==e){let r=ke(B[t],e);return-1===r?void 0:ve(B[t],r,1)[0]}return we(B[t])},e.removeHooks=function(t){B[t]=[]},e.removeAllHooks=function(){B=gr()},e}s(yr,"createDOMPurify");var mr=yr(),xr=/<br\s*\/?>/gi,br=s(t=>t?Ar(t).replace(/\\n/g,"#br#").split("#br#"):[""],"getRows"),Cr=(()=>{let t=!1;return()=>{t||(kr(),t=!0)}})();function kr(){let t="data-temp-href-target";mr.addHook("beforeSanitizeAttributes",e=>{e instanceof Element&&"A"===e.tagName&&e.hasAttribute("target")&&e.setAttribute(t,e.getAttribute("target")??"")}),mr.addHook("afterSanitizeAttributes",e=>{e instanceof Element&&"A"===e.tagName&&e.hasAttribute(t)&&(e.setAttribute("target",e.getAttribute(t)??""),e.removeAttribute(t),"_blank"===e.getAttribute("target")&&e.setAttribute("rel","noopener"))})}s(kr,"setupDompurifyHooks");var wr=s(t=>(Cr(),mr.sanitize(t)),"removeScript"),_r=s((t,e)=>{if(!1!==e.flowchart?.htmlLabels){let r=e.securityLevel;"antiscript"===r||"strict"===r?t=wr(t):"loose"!==r&&(t=(t=(t=Ar(t)).replace(/</g,"&lt;").replace(/>/g,"&gt;")).replace(/=/g,"&equals;"),t=Br(t))}return t},"sanitizeMore"),vr=s((t,e)=>t&&(t=e.dompurifyConfig?mr.sanitize(_r(t,e),e.dompurifyConfig).toString():mr.sanitize(_r(t,e),{FORBID_TAGS:["style"]}).toString()),"sanitizeText"),Sr=s((t,e)=>"string"==typeof t?vr(t,e):t.flat().map(t=>vr(t,e)),"sanitizeTextOrArray"),Tr=s(t=>xr.test(t),"hasBreaks"),Mr=s(t=>t.split(xr),"splitBreaks"),Br=s(t=>t.replace(/#br#/g,"<br/>"),"placeholderToBreak"),Ar=s(t=>t.replace(xr,"#br#"),"breakToPlaceholder"),Fr=s(t=>{let e="";return t&&(e=window.location.protocol+"//"+window.location.host+window.location.pathname+window.location.search,e=CSS.escape(e)),e},"getUrl"),Lr=s(t=>!(!1===t||["false","null","0"].includes(String(t).trim().toLowerCase())),"evaluate"),$r=s(function(...t){let e=t.filter(t=>!isNaN(t));return Math.max(...e)},"getMax"),Er=s(function(...t){let e=t.filter(t=>!isNaN(t));return Math.min(...e)},"getMin"),Dr=s(function(t){let e=t.split(/(,)/),r=[];for(let t=0;t<e.length;t++){let i=e[t];if(","===i&&t>0&&t+1<e.length){let n=e[t-1],a=e[t+1];Ir(n,a)&&(i=n+","+a,t++,r.pop())}r.push(Nr(i))}return r.join("")},"parseGenericTypes"),Or=s((t,e)=>Math.max(0,t.split(e).length-1),"countOccurrence"),Ir=s((t,e)=>{let r=Or(t,"~"),i=Or(e,"~");return 1===r&&1===i},"shouldCombineSets"),Nr=s(t=>{let e=Or(t,"~"),r=!1;if(e<=1)return t;e%2!=0&&t.startsWith("~")&&(t=t.substring(1),r=!0);let i=[...t],n=i.indexOf("~"),a=i.lastIndexOf("~");for(;-1!==n&&-1!==a&&n!==a;)i[n]="<",i[a]=">",n=i.indexOf("~"),a=i.lastIndexOf("~");return r&&i.unshift("~"),i.join("")},"processSet"),Rr=s(()=>void 0!==window.MathMLElement,"isMathMLSupported"),Pr=/\$\$(.*)\$\$/g,zr=s(t=>(t.match(Pr)?.length??0)>0,"hasKatex"),qr=s(async(t,e)=>{t=await jr(t,e);let r=document.createElement("div");r.innerHTML=t,r.id="katex-temp",r.style.visibility="hidden",r.style.position="absolute",r.style.top="0",document.querySelector("body")?.insertAdjacentElement("beforeend",r);let i={width:r.clientWidth,height:r.clientHeight};return r.remove(),i},"calculateMathMLDimensions"),jr=s(async(t,e)=>{if(!zr(t))return t;if(!(Rr()||e.legacyMathML||e.forceLegacyMathML))return t.replace(Pr,"MathML is unsupported in this environment.");{let{default:r}=await import("./katex-RV2QPRKB-Cc_k8laR.js"),i=e.forceLegacyMathML||!Rr()&&e.legacyMathML?"htmlAndMathml":"mathml";return t.split(xr).map(t=>zr(t)?`<div style="display: flex; align-items: center; justify-content: center; white-space: nowrap;">${t}</div>`:`<div>${t}</div>`).join("").replace(Pr,(t,e)=>r.renderToString(e,{throwOnError:!0,displayMode:!0,output:i}).replace(/\n/g," ").replace(/<annotation.*<\/annotation>/g,""))}},"renderKatex"),Wr={getRows:br,sanitizeText:vr,sanitizeTextOrArray:Sr,hasBreaks:Tr,splitBreaks:Mr,lineBreakRegex:xr,removeScript:wr,getUrl:Fr,evaluate:Lr,getMax:$r,getMin:Er},Hr=s(function(t,e){for(let r of e)t.attr(r[0],r[1])},"d3Attrs"),Ur=s(function(t,e,r){let i=new Map;return r?(i.set("width","100%"),i.set("style",`max-width: ${e}px;`)):(i.set("height",t),i.set("width",e)),i},"calculateSvgSizeAttrs"),Yr=s(function(t,e,r,i){let n=Ur(e,r,i);Hr(t,n)},"configureSvgSize"),Vr=s(function(t,e,r,i){let n=e.node().getBBox(),a=n.width,o=n.height;y.info(`SVG bounds: ${a}x${o}`,n);let s=0,l=0;y.info(`Graph bounds: ${s}x${l}`,t),s=a+2*r,l=o+2*r,y.info(`Calculated bounds: ${s}x${l}`),Yr(e,l,s,i);let h=`${n.x-r} ${n.y-r} ${n.width+2*r} ${n.height+2*r}`;e.attr("viewBox",h)},"setupGraphViewbox"),Gr={},Xr=s((t,e,r)=>{let i="";return t in Gr&&Gr[t]?i=Gr[t](r):y.warn(`No theme found for ${t}`),` & {\n    font-family: ${r.fontFamily};\n    font-size: ${r.fontSize};\n    fill: ${r.textColor}\n  }\n  @keyframes edge-animation-frame {\n    from {\n      stroke-dashoffset: 0;\n    }\n  }\n  @keyframes dash {\n    to {\n      stroke-dashoffset: 0;\n    }\n  }\n  & .edge-animation-slow {\n    stroke-dasharray: 9,5 !important;\n    stroke-dashoffset: 900;\n    animation: dash 50s linear infinite;\n    stroke-linecap: round;\n  }\n  & .edge-animation-fast {\n    stroke-dasharray: 9,5 !important;\n    stroke-dashoffset: 900;\n    animation: dash 20s linear infinite;\n    stroke-linecap: round;\n  }\n  /* Classes common for multiple diagrams */\n\n  & .error-icon {\n    fill: ${r.errorBkgColor};\n  }\n  & .error-text {\n    fill: ${r.errorTextColor};\n    stroke: ${r.errorTextColor};\n  }\n\n  & .edge-thickness-normal {\n    stroke-width: 1px;\n  }\n  & .edge-thickness-thick {\n    stroke-width: 3.5px\n  }\n  & .edge-pattern-solid {\n    stroke-dasharray: 0;\n  }\n  & .edge-thickness-invisible {\n    stroke-width: 0;\n    fill: none;\n  }\n  & .edge-pattern-dashed{\n    stroke-dasharray: 3;\n  }\n  .edge-pattern-dotted {\n    stroke-dasharray: 2;\n  }\n\n  & .marker {\n    fill: ${r.lineColor};\n    stroke: ${r.lineColor};\n  }\n  & .marker.cross {\n    stroke: ${r.lineColor};\n  }\n\n  & svg {\n    font-family: ${r.fontFamily};\n    font-size: ${r.fontSize};\n  }\n   & p {\n    margin: 0\n   }\n\n  ${i}\n\n  ${e}\n`},"getStyles"),Zr=s((t,e)=>{void 0!==e&&(Gr[t]=e)},"addStylesForDiagram"),Qr=Xr,Kr={};h(Kr,{clear:()=>ii,getAccDescription:()=>si,getAccTitle:()=>ai,getDiagramTitle:()=>hi,setAccDescription:()=>oi,setAccTitle:()=>ni,setDiagramTitle:()=>li});var Jr="",ti="",ei="",ri=s(t=>vr(t,re()),"sanitizeText"),ii=s(()=>{Jr="",ei="",ti=""},"clear"),ni=s(t=>{Jr=ri(t).replace(/^\s+/g,"")},"setAccTitle"),ai=s(()=>Jr,"getAccTitle"),oi=s(t=>{ei=ri(t).replace(/\n\s+/g,"\n")},"setAccDescription"),si=s(()=>ei,"getAccDescription"),li=s(t=>{ti=ri(t)},"setDiagramTitle"),hi=s(()=>ti,"getDiagramTitle"),ci=y,ui=m,di=re,pi=ee,fi=Yt,gi=s(t=>vr(t,di()),"sanitizeText"),yi=Vr,mi=s(()=>Kr,"getCommonDb"),xi={},bi=s((t,e,r)=>{xi[t]&&ci.warn(`Diagram with id ${t} already registered. Overwriting.`),xi[t]=e,r&&T(t,r),Zr(t,e.styles),e.injectUtils?.(ci,ui,di,gi,yi,mi(),()=>{})},"registerDiagram"),Ci=s(t=>{if(t in xi)return xi[t];throw new ki(t)},"getDiagram"),ki=class extends Error{static{s(this,"DiagramNotFoundError")}constructor(t){super(`Diagram ${t} not found.`)}};function wi(t,e){let r;if(void 0===e)for(let e of t)null!=e&&(r<e||void 0===r&&e>=e)&&(r=e);else{let i=-1;for(let n of t)null!=(n=e(n,++i,t))&&(r<n||void 0===r&&n>=n)&&(r=n)}return r}function _i(t,e){let r;if(void 0===e)for(let e of t)null!=e&&(r>e||void 0===r&&e>=e)&&(r=e);else{let i=-1;for(let n of t)null!=(n=e(n,++i,t))&&(r>n||void 0===r&&n>=n)&&(r=n)}return r}function vi(t,e){return null==t||null==e?NaN:t<e?-1:t>e?1:t>=e?0:NaN}function Si(t,e){return null==t||null==e?NaN:e<t?-1:e>t?1:e>=t?0:NaN}function Ti(t){let e,r,i;function n(t,i,n=0,a=t.length){if(n<a){if(0!==e(i,i))return a;do{let e=n+a>>>1;r(t[e],i)<0?n=e+1:a=e}while(n<a)}return n}function a(t,i,n=0,a=t.length){if(n<a){if(0!==e(i,i))return a;do{let e=n+a>>>1;r(t[e],i)<=0?n=e+1:a=e}while(n<a)}return n}function o(t,e,r=0,a=t.length){let o=n(t,e,r,a-1);return o>r&&i(t[o-1],e)>-i(t[o],e)?o-1:o}return 2!==t.length?(e=vi,r=s((e,r)=>vi(t(e),r),"compare2"),i=s((e,r)=>t(e)-r,"delta")):(e=t===vi||t===Si?t:Mi,r=t,i=t),s(n,"left"),s(a,"right"),s(o,"center"),{left:n,center:o,right:a}}function Mi(){return 0}function Bi(t){return null===t?NaN:+t}s(wi,"max"),s(_i,"min"),s(vi,"ascending"),s(Si,"descending"),s(Ti,"bisector"),s(Mi,"zero"),s(Bi,"number");var Ai=Ti(vi),Fi=Ai.right;Ai.left,Ti(Bi).center;var Li=Fi,$i=class extends Map{static{s(this,"InternMap")}constructor(t,e=Ii){if(super(),Object.defineProperties(this,{_intern:{value:new Map},_key:{value:e}}),null!=t)for(let[e,r]of t)this.set(e,r)}get(t){return super.get(Ei(this,t))}has(t){return super.has(Ei(this,t))}set(t,e){return super.set(Di(this,t),e)}delete(t){return super.delete(Oi(this,t))}};function Ei({_intern:t,_key:e},r){let i=e(r);return t.has(i)?t.get(i):r}function Di({_intern:t,_key:e},r){let i=e(r);return t.has(i)?t.get(i):(t.set(i,r),r)}function Oi({_intern:t,_key:e},r){let i=e(r);return t.has(i)&&(r=t.get(i),t.delete(i)),r}function Ii(t){return null!==t&&"object"==typeof t?t.valueOf():t}s(Ei,"intern_get"),s(Di,"intern_set"),s(Oi,"intern_delete"),s(Ii,"keyof");var Ni=Math.sqrt(50),Ri=Math.sqrt(10),Pi=Math.sqrt(2);function zi(t,e,r){let i,n,a,o=(e-t)/Math.max(0,r),s=Math.floor(Math.log10(o)),l=o/Math.pow(10,s),h=l>=Ni?10:l>=Ri?5:l>=Pi?2:1;return s<0?(a=Math.pow(10,-s)/h,i=Math.round(t*a),n=Math.round(e*a),i/a<t&&++i,n/a>e&&--n,a=-a):(a=Math.pow(10,s)*h,i=Math.round(t/a),n=Math.round(e/a),i*a<t&&++i,n*a>e&&--n),n<i&&.5<=r&&r<2?zi(t,e,2*r):[i,n,a]}function qi(t,e,r){if(!((r=+r)>0))return[];if((t=+t)===(e=+e))return[t];let i=e<t,[n,a,o]=i?zi(e,t,r):zi(t,e,r);if(!(a>=n))return[];let s=a-n+1,l=new Array(s);if(i)if(o<0)for(let t=0;t<s;++t)l[t]=(a-t)/-o;else for(let t=0;t<s;++t)l[t]=(a-t)*o;else if(o<0)for(let t=0;t<s;++t)l[t]=(n+t)/-o;else for(let t=0;t<s;++t)l[t]=(n+t)*o;return l}function ji(t,e,r){return zi(t=+t,e=+e,r=+r)[2]}function Wi(t,e,r){r=+r;let i=(e=+e)<(t=+t),n=i?ji(e,t,r):ji(t,e,r);return(i?-1:1)*(n<0?1/-n:n)}function Hi(t,e,r){t=+t,e=+e,r=(n=arguments.length)<2?(e=t,t=0,1):n<3?1:+r;for(var i=-1,n=0|Math.max(0,Math.ceil((e-t)/r)),a=new Array(n);++i<n;)a[i]=t+i*r;return a}function Ui(t){return t}s(zi,"tickSpec"),s(qi,"ticks"),s(ji,"tickIncrement"),s(Wi,"tickStep"),s(Hi,"range"),s(Ui,"default");var Yi=1e-6;function Vi(t){return"translate("+t+",0)"}function Gi(t){return"translate(0,"+t+")"}function Xi(t){return e=>+t(e)}function Zi(t,e){return e=Math.max(0,t.bandwidth()-2*e)/2,t.round()&&(e=Math.round(e)),r=>+t(r)+e}function Qi(){return!this.__axis}function Ki(t,e){var r=[],i=null,n=null,a=6,o=6,l=3,h=typeof window<"u"&&window.devicePixelRatio>1?0:.5,c=1===t||4===t?-1:1,u=4===t||2===t?"x":"y",d=1===t||3===t?Vi:Gi;function p(s){var p=i??(e.ticks?e.ticks.apply(e,r):e.domain()),f=n??(e.tickFormat?e.tickFormat.apply(e,r):Ui),g=Math.max(a,0)+l,y=e.range(),m=+y[0]+h,x=+y[y.length-1]+h,b=(e.bandwidth?Zi:Xi)(e.copy(),h),C=s.selection?s.selection():s,k=C.selectAll(".domain").data([null]),w=C.selectAll(".tick").data(p,e).order(),_=w.exit(),v=w.enter().append("g").attr("class","tick"),S=w.select("line"),T=w.select("text");k=k.merge(k.enter().insert("path",".tick").attr("class","domain").attr("stroke","currentColor")),w=w.merge(v),S=S.merge(v.append("line").attr("stroke","currentColor").attr(u+"2",c*a)),T=T.merge(v.append("text").attr("fill","currentColor").attr(u,c*g).attr("dy",1===t?"0em":3===t?"0.71em":"0.32em")),s!==C&&(k=k.transition(s),w=w.transition(s),S=S.transition(s),T=T.transition(s),_=_.transition(s).attr("opacity",Yi).attr("transform",function(t){return isFinite(t=b(t))?d(t+h):this.getAttribute("transform")}),v.attr("opacity",Yi).attr("transform",function(t){var e=this.parentNode.__axis;return d((e&&isFinite(e=e(t))?e:b(t))+h)})),_.remove(),k.attr("d",4===t||2===t?o?"M"+c*o+","+m+"H"+h+"V"+x+"H"+c*o:"M"+h+","+m+"V"+x:o?"M"+m+","+c*o+"V"+h+"H"+x+"V"+c*o:"M"+m+","+h+"H"+x),w.attr("opacity",1).attr("transform",function(t){return d(b(t)+h)}),S.attr(u+"2",c*a),T.attr(u,c*g).text(f),C.filter(Qi).attr("fill","none").attr("font-size",10).attr("font-family","sans-serif").attr("text-anchor",2===t?"start":4===t?"end":"middle"),C.each(function(){this.__axis=b})}return s(p,"axis"),p.scale=function(t){return arguments.length?(e=t,p):e},p.ticks=function(){return r=Array.from(arguments),p},p.tickArguments=function(t){return arguments.length?(r=null==t?[]:Array.from(t),p):r.slice()},p.tickValues=function(t){return arguments.length?(i=null==t?null:Array.from(t),p):i&&i.slice()},p.tickFormat=function(t){return arguments.length?(n=t,p):n},p.tickSize=function(t){return arguments.length?(a=o=+t,p):a},p.tickSizeInner=function(t){return arguments.length?(a=+t,p):a},p.tickSizeOuter=function(t){return arguments.length?(o=+t,p):o},p.tickPadding=function(t){return arguments.length?(l=+t,p):l},p.offset=function(t){return arguments.length?(h=+t,p):h},p}function Ji(t){return Ki(1,t)}function tn(t){return Ki(3,t)}function en(){}function rn(t){return null==t?en:function(){return this.querySelector(t)}}function nn(t){"function"!=typeof t&&(t=rn(t));for(var e=this._groups,r=e.length,i=new Array(r),n=0;n<r;++n)for(var a,o,s=e[n],l=s.length,h=i[n]=new Array(l),c=0;c<l;++c)(a=s[c])&&(o=t.call(a,a.__data__,c,s))&&("__data__"in a&&(o.__data__=a.__data__),h[c]=o);return new Ka(i,this._parents)}function an(t){return null==t?[]:Array.isArray(t)?t:Array.from(t)}function on(){return[]}function sn(t){return null==t?on:function(){return this.querySelectorAll(t)}}function ln(t){return function(){return an(t.apply(this,arguments))}}function hn(t){t="function"==typeof t?ln(t):sn(t);for(var e=this._groups,r=e.length,i=[],n=[],a=0;a<r;++a)for(var o,s=e[a],l=s.length,h=0;h<l;++h)(o=s[h])&&(i.push(t.call(o,o.__data__,h,s)),n.push(o));return new Ka(i,n)}function cn(t){return function(){return this.matches(t)}}function un(t){return function(e){return e.matches(t)}}s(Vi,"translateX"),s(Gi,"translateY"),s(Xi,"number"),s(Zi,"center"),s(Qi,"entering"),s(Ki,"axis"),s(Ji,"axisTop"),s(tn,"axisBottom"),s(en,"none"),s(rn,"default"),s(nn,"default"),s(an,"array"),s(on,"empty"),s(sn,"default"),s(ln,"arrayAll"),s(hn,"default"),s(cn,"default"),s(un,"childMatcher");var dn=Array.prototype.find;function pn(t){return function(){return dn.call(this.children,t)}}function fn(){return this.firstElementChild}function gn(t){return this.select(null==t?fn:pn("function"==typeof t?t:un(t)))}s(pn,"childFind"),s(fn,"childFirst"),s(gn,"default");var yn=Array.prototype.filter;function mn(){return Array.from(this.children)}function xn(t){return function(){return yn.call(this.children,t)}}function bn(t){return this.selectAll(null==t?mn:xn("function"==typeof t?t:un(t)))}function Cn(t){"function"!=typeof t&&(t=cn(t));for(var e=this._groups,r=e.length,i=new Array(r),n=0;n<r;++n)for(var a,o=e[n],s=o.length,l=i[n]=[],h=0;h<s;++h)(a=o[h])&&t.call(a,a.__data__,h,o)&&l.push(a);return new Ka(i,this._parents)}function kn(t){return new Array(t.length)}function wn(){return new Ka(this._enter||this._groups.map(kn),this._parents)}function _n(t,e){this.ownerDocument=t.ownerDocument,this.namespaceURI=t.namespaceURI,this._next=null,this._parent=t,this.__data__=e}function vn(t){return function(){return t}}function Sn(t,e,r,i,n,a){for(var o,s=0,l=e.length,h=a.length;s<h;++s)(o=e[s])?(o.__data__=a[s],i[s]=o):r[s]=new _n(t,a[s]);for(;s<l;++s)(o=e[s])&&(n[s]=o)}function Tn(t,e,r,i,n,a,o){var s,l,h,c=new Map,u=e.length,d=a.length,p=new Array(u);for(s=0;s<u;++s)(l=e[s])&&(p[s]=h=o.call(l,l.__data__,s,e)+"",c.has(h)?n[s]=l:c.set(h,l));for(s=0;s<d;++s)h=o.call(t,a[s],s,a)+"",(l=c.get(h))?(i[s]=l,l.__data__=a[s],c.delete(h)):r[s]=new _n(t,a[s]);for(s=0;s<u;++s)(l=e[s])&&c.get(p[s])===l&&(n[s]=l)}function Mn(t){return t.__data__}function Bn(t,e){if(!arguments.length)return Array.from(this,Mn);var r=e?Tn:Sn,i=this._parents,n=this._groups;"function"!=typeof t&&(t=vn(t));for(var a=n.length,o=new Array(a),s=new Array(a),l=new Array(a),h=0;h<a;++h){var c=i[h],u=n[h],d=u.length,p=An(t.call(c,c&&c.__data__,h,i)),f=p.length,g=s[h]=new Array(f),y=o[h]=new Array(f);r(c,u,g,y,l[h]=new Array(d),p,e);for(var m,x,b=0,C=0;b<f;++b)if(m=g[b]){for(b>=C&&(C=b+1);!(x=y[C])&&++C<f;);m._next=x||null}}return(o=new Ka(o,i))._enter=s,o._exit=l,o}function An(t){return"object"==typeof t&&"length"in t?t:Array.from(t)}function Fn(){return new Ka(this._exit||this._groups.map(kn),this._parents)}function Ln(t,e,r){var i=this.enter(),n=this,a=this.exit();return"function"==typeof t?(i=t(i))&&(i=i.selection()):i=i.append(t+""),null!=e&&((n=e(n))&&(n=n.selection())),null==r?a.remove():r(a),i&&n?i.merge(n).order():n}function $n(t){for(var e=t.selection?t.selection():t,r=this._groups,i=e._groups,n=r.length,a=i.length,o=Math.min(n,a),s=new Array(n),l=0;l<o;++l)for(var h,c=r[l],u=i[l],d=c.length,p=s[l]=new Array(d),f=0;f<d;++f)(h=c[f]||u[f])&&(p[f]=h);for(;l<n;++l)s[l]=r[l];return new Ka(s,this._parents)}function En(){for(var t=this._groups,e=-1,r=t.length;++e<r;)for(var i,n=t[e],a=n.length-1,o=n[a];--a>=0;)(i=n[a])&&(o&&4^i.compareDocumentPosition(o)&&o.parentNode.insertBefore(i,o),o=i);return this}function Dn(t){function e(e,r){return e&&r?t(e.__data__,r.__data__):!e-!r}t||(t=On),s(e,"compareNode");for(var r=this._groups,i=r.length,n=new Array(i),a=0;a<i;++a){for(var o,l=r[a],h=l.length,c=n[a]=new Array(h),u=0;u<h;++u)(o=l[u])&&(c[u]=o);c.sort(e)}return new Ka(n,this._parents).order()}function On(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function In(){var t=arguments[0];return arguments[0]=this,t.apply(null,arguments),this}function Nn(){return Array.from(this)}function Rn(){for(var t=this._groups,e=0,r=t.length;e<r;++e)for(var i=t[e],n=0,a=i.length;n<a;++n){var o=i[n];if(o)return o}return null}function Pn(){let t=0;for(let e of this)++t;return t}function zn(){return!this.node()}function qn(t){for(var e=this._groups,r=0,i=e.length;r<i;++r)for(var n,a=e[r],o=0,s=a.length;o<s;++o)(n=a[o])&&t.call(n,n.__data__,o,a);return this}s(mn,"children"),s(xn,"childrenFilter"),s(bn,"default"),s(Cn,"default"),s(kn,"default"),s(wn,"default"),s(_n,"EnterNode"),_n.prototype={constructor:_n,appendChild:s(function(t){return this._parent.insertBefore(t,this._next)},"appendChild"),insertBefore:s(function(t,e){return this._parent.insertBefore(t,e)},"insertBefore"),querySelector:s(function(t){return this._parent.querySelector(t)},"querySelector"),querySelectorAll:s(function(t){return this._parent.querySelectorAll(t)},"querySelectorAll")},s(vn,"default"),s(Sn,"bindIndex"),s(Tn,"bindKey"),s(Mn,"datum"),s(Bn,"default"),s(An,"arraylike"),s(Fn,"default"),s(Ln,"default"),s($n,"default"),s(En,"default"),s(Dn,"default"),s(On,"ascending"),s(In,"default"),s(Nn,"default"),s(Rn,"default"),s(Pn,"default"),s(zn,"default"),s(qn,"default");var jn="http://www.w3.org/1999/xhtml",Wn={svg:"http://www.w3.org/2000/svg",xhtml:jn,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};function Hn(t){var e=t+="",r=e.indexOf(":");return r>=0&&"xmlns"!==(e=t.slice(0,r))&&(t=t.slice(r+1)),Wn.hasOwnProperty(e)?{space:Wn[e],local:t}:t}function Un(t){return function(){this.removeAttribute(t)}}function Yn(t){return function(){this.removeAttributeNS(t.space,t.local)}}function Vn(t,e){return function(){this.setAttribute(t,e)}}function Gn(t,e){return function(){this.setAttributeNS(t.space,t.local,e)}}function Xn(t,e){return function(){var r=e.apply(this,arguments);null==r?this.removeAttribute(t):this.setAttribute(t,r)}}function Zn(t,e){return function(){var r=e.apply(this,arguments);null==r?this.removeAttributeNS(t.space,t.local):this.setAttributeNS(t.space,t.local,r)}}function Qn(t,e){var r=Hn(t);if(arguments.length<2){var i=this.node();return r.local?i.getAttributeNS(r.space,r.local):i.getAttribute(r)}return this.each((null==e?r.local?Yn:Un:"function"==typeof e?r.local?Zn:Xn:r.local?Gn:Vn)(r,e))}function Kn(t){return t.ownerDocument&&t.ownerDocument.defaultView||t.document&&t||t.defaultView}function Jn(t){return function(){this.style.removeProperty(t)}}function ta(t,e,r){return function(){this.style.setProperty(t,e,r)}}function ea(t,e,r){return function(){var i=e.apply(this,arguments);null==i?this.style.removeProperty(t):this.style.setProperty(t,i,r)}}function ra(t,e,r){return arguments.length>1?this.each((null==e?Jn:"function"==typeof e?ea:ta)(t,e,r??"")):ia(this.node(),t)}function ia(t,e){return t.style.getPropertyValue(e)||Kn(t).getComputedStyle(t,null).getPropertyValue(e)}function na(t){return function(){delete this[t]}}function aa(t,e){return function(){this[t]=e}}function oa(t,e){return function(){var r=e.apply(this,arguments);null==r?delete this[t]:this[t]=r}}function sa(t,e){return arguments.length>1?this.each((null==e?na:"function"==typeof e?oa:aa)(t,e)):this.node()[t]}function la(t){return t.trim().split(/^|\s+/)}function ha(t){return t.classList||new ca(t)}function ca(t){this._node=t,this._names=la(t.getAttribute("class")||"")}function ua(t,e){for(var r=ha(t),i=-1,n=e.length;++i<n;)r.add(e[i])}function da(t,e){for(var r=ha(t),i=-1,n=e.length;++i<n;)r.remove(e[i])}function pa(t){return function(){ua(this,t)}}function fa(t){return function(){da(this,t)}}function ga(t,e){return function(){(e.apply(this,arguments)?ua:da)(this,t)}}function ya(t,e){var r=la(t+"");if(arguments.length<2){for(var i=ha(this.node()),n=-1,a=r.length;++n<a;)if(!i.contains(r[n]))return!1;return!0}return this.each(("function"==typeof e?ga:e?pa:fa)(r,e))}function ma(){this.textContent=""}function xa(t){return function(){this.textContent=t}}function ba(t){return function(){var e=t.apply(this,arguments);this.textContent=e??""}}function Ca(t){return arguments.length?this.each(null==t?ma:("function"==typeof t?ba:xa)(t)):this.node().textContent}function ka(){this.innerHTML=""}function wa(t){return function(){this.innerHTML=t}}function _a(t){return function(){var e=t.apply(this,arguments);this.innerHTML=e??""}}function va(t){return arguments.length?this.each(null==t?ka:("function"==typeof t?_a:wa)(t)):this.node().innerHTML}function Sa(){this.nextSibling&&this.parentNode.appendChild(this)}function Ta(){return this.each(Sa)}function Ma(){this.previousSibling&&this.parentNode.insertBefore(this,this.parentNode.firstChild)}function Ba(){return this.each(Ma)}function Aa(t){return function(){var e=this.ownerDocument,r=this.namespaceURI;return r===jn&&e.documentElement.namespaceURI===jn?e.createElement(t):e.createElementNS(r,t)}}function Fa(t){return function(){return this.ownerDocument.createElementNS(t.space,t.local)}}function La(t){var e=Hn(t);return(e.local?Fa:Aa)(e)}function $a(t){var e="function"==typeof t?t:La(t);return this.select(function(){return this.appendChild(e.apply(this,arguments))})}function Ea(){return null}function Da(t,e){var r="function"==typeof t?t:La(t),i=null==e?Ea:"function"==typeof e?e:rn(e);return this.select(function(){return this.insertBefore(r.apply(this,arguments),i.apply(this,arguments)||null)})}function Oa(){var t=this.parentNode;t&&t.removeChild(this)}function Ia(){return this.each(Oa)}function Na(){var t=this.cloneNode(!1),e=this.parentNode;return e?e.insertBefore(t,this.nextSibling):t}function Ra(){var t=this.cloneNode(!0),e=this.parentNode;return e?e.insertBefore(t,this.nextSibling):t}function Pa(t){return this.select(t?Ra:Na)}function za(t){return arguments.length?this.property("__data__",t):this.node().__data__}function qa(t){return function(e){t.call(this,e,this.__data__)}}function ja(t){return t.trim().split(/^|\s+/).map(function(t){var e="",r=t.indexOf(".");return r>=0&&(e=t.slice(r+1),t=t.slice(0,r)),{type:t,name:e}})}function Wa(t){return function(){var e=this.__on;if(e){for(var r,i=0,n=-1,a=e.length;i<a;++i)r=e[i],t.type&&r.type!==t.type||r.name!==t.name?e[++n]=r:this.removeEventListener(r.type,r.listener,r.options);++n?e.length=n:delete this.__on}}}function Ha(t,e,r){return function(){var i,n=this.__on,a=qa(e);if(n)for(var o=0,s=n.length;o<s;++o)if((i=n[o]).type===t.type&&i.name===t.name)return this.removeEventListener(i.type,i.listener,i.options),this.addEventListener(i.type,i.listener=a,i.options=r),void(i.value=e);this.addEventListener(t.type,a,r),i={type:t.type,name:t.name,value:e,listener:a,options:r},n?n.push(i):this.__on=[i]}}function Ua(t,e,r){var i,n,a=ja(t+""),o=a.length;if(!(arguments.length<2)){for(s=e?Ha:Wa,i=0;i<o;++i)this.each(s(a[i],e,r));return this}var s=this.node().__on;if(s)for(var l,h=0,c=s.length;h<c;++h)for(i=0,l=s[h];i<o;++i)if((n=a[i]).type===l.type&&n.name===l.name)return l.value}function Ya(t,e,r){var i=Kn(t),n=i.CustomEvent;"function"==typeof n?n=new n(e,r):(n=i.document.createEvent("Event"),r?(n.initEvent(e,r.bubbles,r.cancelable),n.detail=r.detail):n.initEvent(e,!1,!1)),t.dispatchEvent(n)}function Va(t,e){return function(){return Ya(this,t,e)}}function Ga(t,e){return function(){return Ya(this,t,e.apply(this,arguments))}}function Xa(t,e){return this.each(("function"==typeof e?Ga:Va)(t,e))}function*Za(){for(var t=this._groups,e=0,r=t.length;e<r;++e)for(var i,n=t[e],a=0,o=n.length;a<o;++a)(i=n[a])&&(yield i)}s(Hn,"default"),s(Un,"attrRemove"),s(Yn,"attrRemoveNS"),s(Vn,"attrConstant"),s(Gn,"attrConstantNS"),s(Xn,"attrFunction"),s(Zn,"attrFunctionNS"),s(Qn,"default"),s(Kn,"default"),s(Jn,"styleRemove"),s(ta,"styleConstant"),s(ea,"styleFunction"),s(ra,"default"),s(ia,"styleValue"),s(na,"propertyRemove"),s(aa,"propertyConstant"),s(oa,"propertyFunction"),s(sa,"default"),s(la,"classArray"),s(ha,"classList"),s(ca,"ClassList"),ca.prototype={add:s(function(t){this._names.indexOf(t)<0&&(this._names.push(t),this._node.setAttribute("class",this._names.join(" ")))},"add"),remove:s(function(t){var e=this._names.indexOf(t);e>=0&&(this._names.splice(e,1),this._node.setAttribute("class",this._names.join(" ")))},"remove"),contains:s(function(t){return this._names.indexOf(t)>=0},"contains")},s(ua,"classedAdd"),s(da,"classedRemove"),s(pa,"classedTrue"),s(fa,"classedFalse"),s(ga,"classedFunction"),s(ya,"default"),s(ma,"textRemove"),s(xa,"textConstant"),s(ba,"textFunction"),s(Ca,"default"),s(ka,"htmlRemove"),s(wa,"htmlConstant"),s(_a,"htmlFunction"),s(va,"default"),s(Sa,"raise"),s(Ta,"default"),s(Ma,"lower"),s(Ba,"default"),s(Aa,"creatorInherit"),s(Fa,"creatorFixed"),s(La,"default"),s($a,"default"),s(Ea,"constantNull"),s(Da,"default"),s(Oa,"remove"),s(Ia,"default"),s(Na,"selection_cloneShallow"),s(Ra,"selection_cloneDeep"),s(Pa,"default"),s(za,"default"),s(qa,"contextListener"),s(ja,"parseTypenames"),s(Wa,"onRemove"),s(Ha,"onAdd"),s(Ua,"default"),s(Ya,"dispatchEvent"),s(Va,"dispatchConstant"),s(Ga,"dispatchFunction"),s(Xa,"default"),s(Za,"default");var Qa=[null];function Ka(t,e){this._groups=t,this._parents=e}function Ja(){return new Ka([[document.documentElement]],Qa)}function to(){return this}s(Ka,"Selection"),s(Ja,"selection"),s(to,"selection_selection"),Ka.prototype=Ja.prototype={constructor:Ka,select:nn,selectAll:hn,selectChild:gn,selectChildren:bn,filter:Cn,data:Bn,enter:wn,exit:Fn,join:Ln,merge:$n,selection:to,order:En,sort:Dn,call:In,nodes:Nn,node:Rn,size:Pn,empty:zn,each:qn,attr:Qn,style:ra,property:sa,classed:ya,text:Ca,html:va,raise:Ta,lower:Ba,append:$a,insert:Da,remove:Ia,clone:Pa,datum:za,on:Ua,dispatch:Xa,[Symbol.iterator]:Za};var eo=Ja;function ro(t){return"string"==typeof t?new Ka([[document.querySelector(t)]],[document.documentElement]):new Ka([[t]],Qa)}function io(t,e,r){t.prototype=e.prototype=r,r.constructor=t}function no(t,e){var r=Object.create(t.prototype);for(var i in e)r[i]=e[i];return r}function ao(){}s(ro,"default"),s(io,"default"),s(no,"extend"),s(ao,"Color");var oo=.7,so=1/oo,lo="\\s*([+-]?\\d+)\\s*",ho="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*",co="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*",uo=/^#([0-9a-f]{3,8})$/,po=new RegExp(`^rgb\\(${lo},${lo},${lo}\\)$`),fo=new RegExp(`^rgb\\(${co},${co},${co}\\)$`),go=new RegExp(`^rgba\\(${lo},${lo},${lo},${ho}\\)$`),yo=new RegExp(`^rgba\\(${co},${co},${co},${ho}\\)$`),mo=new RegExp(`^hsl\\(${ho},${co},${co}\\)$`),xo=new RegExp(`^hsla\\(${ho},${co},${co},${ho}\\)$`),bo={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};function Co(){return this.rgb().formatHex()}function ko(){return this.rgb().formatHex8()}function wo(){return No(this).formatHsl()}function _o(){return this.rgb().formatRgb()}function vo(t){var e,r;return t=(t+"").trim().toLowerCase(),(e=uo.exec(t))?(r=e[1].length,e=parseInt(e[1],16),6===r?So(e):3===r?new Ao(e>>8&15|e>>4&240,e>>4&15|240&e,(15&e)<<4|15&e,1):8===r?To(e>>24&255,e>>16&255,e>>8&255,(255&e)/255):4===r?To(e>>12&15|e>>8&240,e>>8&15|e>>4&240,e>>4&15|240&e,((15&e)<<4|15&e)/255):null):(e=po.exec(t))?new Ao(e[1],e[2],e[3],1):(e=fo.exec(t))?new Ao(255*e[1]/100,255*e[2]/100,255*e[3]/100,1):(e=go.exec(t))?To(e[1],e[2],e[3],e[4]):(e=yo.exec(t))?To(255*e[1]/100,255*e[2]/100,255*e[3]/100,e[4]):(e=mo.exec(t))?Io(e[1],e[2]/100,e[3]/100,1):(e=xo.exec(t))?Io(e[1],e[2]/100,e[3]/100,e[4]):bo.hasOwnProperty(t)?So(bo[t]):"transparent"===t?new Ao(NaN,NaN,NaN,0):null}function So(t){return new Ao(t>>16&255,t>>8&255,255&t,1)}function To(t,e,r,i){return i<=0&&(t=e=r=NaN),new Ao(t,e,r,i)}function Mo(t){return t instanceof ao||(t=vo(t)),t?new Ao((t=t.rgb()).r,t.g,t.b,t.opacity):new Ao}function Bo(t,e,r,i){return 1===arguments.length?Mo(t):new Ao(t,e,r,i??1)}function Ao(t,e,r,i){this.r=+t,this.g=+e,this.b=+r,this.opacity=+i}function Fo(){return`#${Oo(this.r)}${Oo(this.g)}${Oo(this.b)}`}function Lo(){return`#${Oo(this.r)}${Oo(this.g)}${Oo(this.b)}${Oo(255*(isNaN(this.opacity)?1:this.opacity))}`}function $o(){let t=Eo(this.opacity);return`${1===t?"rgb(":"rgba("}${Do(this.r)}, ${Do(this.g)}, ${Do(this.b)}${1===t?")":`, ${t})`}`}function Eo(t){return isNaN(t)?1:Math.max(0,Math.min(1,t))}function Do(t){return Math.max(0,Math.min(255,Math.round(t)||0))}function Oo(t){return((t=Do(t))<16?"0":"")+t.toString(16)}function Io(t,e,r,i){return i<=0?t=e=r=NaN:r<=0||r>=1?t=e=NaN:e<=0&&(t=NaN),new Po(t,e,r,i)}function No(t){if(t instanceof Po)return new Po(t.h,t.s,t.l,t.opacity);if(t instanceof ao||(t=vo(t)),!t)return new Po;if(t instanceof Po)return t;var e=(t=t.rgb()).r/255,r=t.g/255,i=t.b/255,n=Math.min(e,r,i),a=Math.max(e,r,i),o=NaN,s=a-n,l=(a+n)/2;return s?(o=e===a?(r-i)/s+6*(r<i):r===a?(i-e)/s+2:(e-r)/s+4,s/=l<.5?a+n:2-a-n,o*=60):s=l>0&&l<1?0:o,new Po(o,s,l,t.opacity)}function Ro(t,e,r,i){return 1===arguments.length?No(t):new Po(t,e,r,i??1)}function Po(t,e,r,i){this.h=+t,this.s=+e,this.l=+r,this.opacity=+i}function zo(t){return(t=(t||0)%360)<0?t+360:t}function qo(t){return Math.max(0,Math.min(1,t||0))}function jo(t,e,r){return 255*(t<60?e+(r-e)*t/60:t<180?r:t<240?e+(r-e)*(240-t)/60:e)}io(ao,vo,{copy(t){return Object.assign(new this.constructor,this,t)},displayable(){return this.rgb().displayable()},hex:Co,formatHex:Co,formatHex8:ko,formatHsl:wo,formatRgb:_o,toString:_o}),s(Co,"color_formatHex"),s(ko,"color_formatHex8"),s(wo,"color_formatHsl"),s(_o,"color_formatRgb"),s(vo,"color"),s(So,"rgbn"),s(To,"rgba"),s(Mo,"rgbConvert"),s(Bo,"rgb"),s(Ao,"Rgb"),io(Ao,Bo,no(ao,{brighter(t){return t=null==t?so:Math.pow(so,t),new Ao(this.r*t,this.g*t,this.b*t,this.opacity)},darker(t){return t=null==t?oo:Math.pow(oo,t),new Ao(this.r*t,this.g*t,this.b*t,this.opacity)},rgb(){return this},clamp(){return new Ao(Do(this.r),Do(this.g),Do(this.b),Eo(this.opacity))},displayable(){return-.5<=this.r&&this.r<255.5&&-.5<=this.g&&this.g<255.5&&-.5<=this.b&&this.b<255.5&&0<=this.opacity&&this.opacity<=1},hex:Fo,formatHex:Fo,formatHex8:Lo,formatRgb:$o,toString:$o})),s(Fo,"rgb_formatHex"),s(Lo,"rgb_formatHex8"),s($o,"rgb_formatRgb"),s(Eo,"clampa"),s(Do,"clampi"),s(Oo,"hex"),s(Io,"hsla"),s(No,"hslConvert"),s(Ro,"hsl"),s(Po,"Hsl"),io(Po,Ro,no(ao,{brighter(t){return t=null==t?so:Math.pow(so,t),new Po(this.h,this.s,this.l*t,this.opacity)},darker(t){return t=null==t?oo:Math.pow(oo,t),new Po(this.h,this.s,this.l*t,this.opacity)},rgb(){var t=this.h%360+360*(this.h<0),e=isNaN(t)||isNaN(this.s)?0:this.s,r=this.l,i=r+(r<.5?r:1-r)*e,n=2*r-i;return new Ao(jo(t>=240?t-240:t+120,n,i),jo(t,n,i),jo(t<120?t+240:t-120,n,i),this.opacity)},clamp(){return new Po(zo(this.h),qo(this.s),qo(this.l),Eo(this.opacity))},displayable(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&0<=this.l&&this.l<=1&&0<=this.opacity&&this.opacity<=1},formatHsl(){let t=Eo(this.opacity);return`${1===t?"hsl(":"hsla("}${zo(this.h)}, ${100*qo(this.s)}%, ${100*qo(this.l)}%${1===t?")":`, ${t})`}`}})),s(zo,"clamph"),s(qo,"clampt"),s(jo,"hsl2rgb");var Wo=Math.PI/180,Ho=180/Math.PI,Uo=.96422,Yo=.82521,Vo=4/29,Go=6/29,Xo=3*Go*Go,Zo=Go*Go*Go;function Qo(t){if(t instanceof Jo)return new Jo(t.l,t.a,t.b,t.opacity);if(t instanceof os)return ss(t);t instanceof Ao||(t=Mo(t));var e,r,i=is(t.r),n=is(t.g),a=is(t.b),o=ts((.2225045*i+.7168786*n+.0606169*a)/1);return i===n&&n===a?e=r=o:(e=ts((.4360747*i+.3850649*n+.1430804*a)/Uo),r=ts((.0139322*i+.0971045*n+.7141733*a)/Yo)),new Jo(116*o-16,500*(e-o),200*(o-r),t.opacity)}function Ko(t,e,r,i){return 1===arguments.length?Qo(t):new Jo(t,e,r,i??1)}function Jo(t,e,r,i){this.l=+t,this.a=+e,this.b=+r,this.opacity=+i}function ts(t){return t>Zo?Math.pow(t,1/3):t/Xo+Vo}function es(t){return t>Go?t*t*t:Xo*(t-Vo)}function rs(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function is(t){return(t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function ns(t){if(t instanceof os)return new os(t.h,t.c,t.l,t.opacity);if(t instanceof Jo||(t=Qo(t)),0===t.a&&0===t.b)return new os(NaN,0<t.l&&t.l<100?0:NaN,t.l,t.opacity);var e=Math.atan2(t.b,t.a)*Ho;return new os(e<0?e+360:e,Math.sqrt(t.a*t.a+t.b*t.b),t.l,t.opacity)}function as(t,e,r,i){return 1===arguments.length?ns(t):new os(t,e,r,i??1)}function os(t,e,r,i){this.h=+t,this.c=+e,this.l=+r,this.opacity=+i}function ss(t){if(isNaN(t.h))return new Jo(t.l,0,0,t.opacity);var e=t.h*Wo;return new Jo(t.l,Math.cos(e)*t.c,Math.sin(e)*t.c,t.opacity)}s(Qo,"labConvert"),s(Ko,"lab"),s(Jo,"Lab"),io(Jo,Ko,no(ao,{brighter(t){return new Jo(this.l+18*(t??1),this.a,this.b,this.opacity)},darker(t){return new Jo(this.l-18*(t??1),this.a,this.b,this.opacity)},rgb(){var t=(this.l+16)/116,e=isNaN(this.a)?t:t+this.a/500,r=isNaN(this.b)?t:t-this.b/200;return new Ao(rs(3.1338561*(e=Uo*es(e))-1.6168667*(t=1*es(t))-.4906146*(r=Yo*es(r))),rs(-.9787684*e+1.9161415*t+.033454*r),rs(.0719453*e-.2289914*t+1.4052427*r),this.opacity)}})),s(ts,"xyz2lab"),s(es,"lab2xyz"),s(rs,"lrgb2rgb"),s(is,"rgb2lrgb"),s(ns,"hclConvert"),s(as,"hcl"),s(os,"Hcl"),s(ss,"hcl2lab"),io(os,as,no(ao,{brighter(t){return new os(this.h,this.c,this.l+18*(t??1),this.opacity)},darker(t){return new os(this.h,this.c,this.l-18*(t??1),this.opacity)},rgb(){return ss(this).rgb()}}));var ls=s(t=>()=>t,"default");function hs(t,e){return function(r){return t+r*e}}function cs(t,e,r){return t=Math.pow(t,r),e=Math.pow(e,r)-t,r=1/r,function(i){return Math.pow(t+i*e,r)}}function us(t,e){var r=e-t;return r?hs(t,r>180||r<-180?r-360*Math.round(r/360):r):ls(isNaN(t)?e:t)}function ds(t){return 1==(t=+t)?ps:function(e,r){return r-e?cs(e,r,t):ls(isNaN(e)?r:e)}}function ps(t,e){var r=e-t;return r?hs(t,r):ls(isNaN(t)?e:t)}function fs(t){return function(e,r){var i=t((e=as(e)).h,(r=as(r)).h),n=ps(e.c,r.c),a=ps(e.l,r.l),o=ps(e.opacity,r.opacity);return function(t){return e.h=i(t),e.c=n(t),e.l=a(t),e.opacity=o(t),e+""}}}s(hs,"linear"),s(cs,"exponential"),s(us,"hue"),s(ds,"gamma"),s(ps,"nogamma"),s(fs,"hcl");var gs=fs(us);function ys(t,e,r,i,n){var a=t*t,o=a*t;return((1-3*t+3*a-o)*e+(4-6*a+3*o)*r+(1+3*t+3*a-3*o)*i+o*n)/6}s(ys,"basis"),s(function(t){var e=t.length-1;return function(r){var i=r<=0?r=0:r>=1?(r=1,e-1):Math.floor(r*e),n=t[i],a=t[i+1],o=i>0?t[i-1]:2*n-a,s=i<e-1?t[i+2]:2*a-n;return ys((r-i/e)*e,o,n,a,s)}},"default"),s(function(t){var e=t.length;return function(r){var i=Math.floor(((r%=1)<0?++r:r)*e),n=t[(i+e-1)%e],a=t[i%e],o=t[(i+1)%e],s=t[(i+2)%e];return ys((r-i/e)*e,n,a,o,s)}},"default");var ms=s(function t(e){var r=ds(e);function i(t,e){var i=r((t=Bo(t)).r,(e=Bo(e)).r),n=r(t.g,e.g),a=r(t.b,e.b),o=ps(t.opacity,e.opacity);return function(e){return t.r=i(e),t.g=n(e),t.b=a(e),t.opacity=o(e),t+""}}return s(i,"rgb"),i.gamma=t,i},"rgbGamma")(1);function xs(t,e){e||(e=[]);var r,i=t?Math.min(e.length,t.length):0,n=e.slice();return function(a){for(r=0;r<i;++r)n[r]=t[r]*(1-a)+e[r]*a;return n}}function bs(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)}function Cs(t,e){var r,i=e?e.length:0,n=t?Math.min(i,t.length):0,a=new Array(n),o=new Array(i);for(r=0;r<n;++r)a[r]=As(t[r],e[r]);for(;r<i;++r)o[r]=e[r];return function(t){for(r=0;r<n;++r)o[r]=a[r](t);return o}}function ks(t,e){var r=new Date;return t=+t,e=+e,function(i){return r.setTime(t*(1-i)+e*i),r}}function ws(t,e){return t=+t,e=+e,function(r){return t*(1-r)+e*r}}function _s(t,e){var r,i={},n={};for(r in(null===t||"object"!=typeof t)&&(t={}),(null===e||"object"!=typeof e)&&(e={}),e)r in t?i[r]=As(t[r],e[r]):n[r]=e[r];return function(t){for(r in i)n[r]=i[r](t);return n}}s(function(t){return function(e){var r,i,n=e.length,a=new Array(n),o=new Array(n),s=new Array(n);for(r=0;r<n;++r)i=Bo(e[r]),a[r]=i.r||0,o[r]=i.g||0,s[r]=i.b||0;return a=t(a),o=t(o),s=t(s),i.opacity=1,function(t){return i.r=a(t),i.g=o(t),i.b=s(t),i+""}}},"rgbSpline"),s(xs,"default"),s(bs,"isNumberArray"),s(Cs,"genericArray"),s(ks,"default"),s(ws,"default"),s(_s,"default");var vs=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,Ss=new RegExp(vs.source,"g");function Ts(t){return function(){return t}}function Ms(t){return function(e){return t(e)+""}}function Bs(t,e){var r,i,n,a=vs.lastIndex=Ss.lastIndex=0,o=-1,s=[],l=[];for(t+="",e+="";(r=vs.exec(t))&&(i=Ss.exec(e));)(n=i.index)>a&&(n=e.slice(a,n),s[o]?s[o]+=n:s[++o]=n),(r=r[0])===(i=i[0])?s[o]?s[o]+=i:s[++o]=i:(s[++o]=null,l.push({i:o,x:ws(r,i)})),a=Ss.lastIndex;return a<e.length&&(n=e.slice(a),s[o]?s[o]+=n:s[++o]=n),s.length<2?l[0]?Ms(l[0].x):Ts(e):(e=l.length,function(t){for(var r,i=0;i<e;++i)s[(r=l[i]).i]=r.x(t);return s.join("")})}function As(t,e){var r,i=typeof e;return null==e||"boolean"===i?ls(e):("number"===i?ws:"string"===i?(r=vo(e))?(e=r,ms):Bs:e instanceof vo?ms:e instanceof Date?ks:bs(e)?xs:Array.isArray(e)?Cs:"function"!=typeof e.valueOf&&"function"!=typeof e.toString||isNaN(e)?_s:ws)(t,e)}function Fs(t,e){return t=+t,e=+e,function(r){return Math.round(t*(1-r)+e*r)}}s(Ts,"zero"),s(Ms,"one"),s(Bs,"default"),s(As,"default"),s(Fs,"default");var Ls,$s=180/Math.PI,Es={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function Ds(t,e,r,i,n,a){var o,s,l;return(o=Math.sqrt(t*t+e*e))&&(t/=o,e/=o),(l=t*r+e*i)&&(r-=t*l,i-=e*l),(s=Math.sqrt(r*r+i*i))&&(r/=s,i/=s,l/=s),t*i<e*r&&(t=-t,e=-e,l=-l,o=-o),{translateX:n,translateY:a,rotate:Math.atan2(e,t)*$s,skewX:Math.atan(l)*$s,scaleX:o,scaleY:s}}function Os(t){let e=new("function"==typeof DOMMatrix?DOMMatrix:WebKitCSSMatrix)(t+"");return e.isIdentity?Es:Ds(e.a,e.b,e.c,e.d,e.e,e.f)}function Is(t){return null==t?Es:(Ls||(Ls=document.createElementNS("http://www.w3.org/2000/svg","g")),Ls.setAttribute("transform",t),(t=Ls.transform.baseVal.consolidate())?Ds((t=t.matrix).a,t.b,t.c,t.d,t.e,t.f):Es)}function Ns(t,e,r,i){function n(t){return t.length?t.pop()+" ":""}function a(t,i,n,a,o,s){if(t!==n||i!==a){var l=o.push("translate(",null,e,null,r);s.push({i:l-4,x:ws(t,n)},{i:l-2,x:ws(i,a)})}else(n||a)&&o.push("translate("+n+e+a+r)}function o(t,e,r,a){t!==e?(t-e>180?e+=360:e-t>180&&(t+=360),a.push({i:r.push(n(r)+"rotate(",null,i)-2,x:ws(t,e)})):e&&r.push(n(r)+"rotate("+e+i)}function l(t,e,r,a){t!==e?a.push({i:r.push(n(r)+"skewX(",null,i)-2,x:ws(t,e)}):e&&r.push(n(r)+"skewX("+e+i)}function h(t,e,r,i,a,o){if(t!==r||e!==i){var s=a.push(n(a)+"scale(",null,",",null,")");o.push({i:s-4,x:ws(t,r)},{i:s-2,x:ws(e,i)})}else(1!==r||1!==i)&&a.push(n(a)+"scale("+r+","+i+")")}return s(n,"pop"),s(a,"translate"),s(o,"rotate"),s(l,"skewX"),s(h,"scale"),function(e,r){var i=[],n=[];return e=t(e),r=t(r),a(e.translateX,e.translateY,r.translateX,r.translateY,i,n),o(e.rotate,r.rotate,i,n),l(e.skewX,r.skewX,i,n),h(e.scaleX,e.scaleY,r.scaleX,r.scaleY,i,n),e=r=null,function(t){for(var e,r=-1,a=n.length;++r<a;)i[(e=n[r]).i]=e.x(t);return i.join("")}}}s(Ds,"default"),s(Os,"parseCss"),s(Is,"parseSvg"),s(Ns,"interpolateTransform");var Rs=Ns(Os,"px, ","px)","deg)"),Ps=Ns(Is,", ",")",")");function zs(t){return Math.abs(t=Math.round(t))>=1e21?t.toLocaleString("en").replace(/,/g,""):t.toString(10)}function qs(t,e){if((r=(t=e?t.toExponential(e-1):t.toExponential()).indexOf("e"))<0)return null;var r,i=t.slice(0,r);return[i.length>1?i[0]+i.slice(2):i,+t.slice(r+1)]}function js(t){return(t=qs(Math.abs(t)))?t[1]:NaN}function Ws(t,e){return function(r,i){for(var n=r.length,a=[],o=0,s=t[0],l=0;n>0&&s>0&&(l+s+1>i&&(s=Math.max(1,i-l)),a.push(r.substring(n-=s,n+s)),!((l+=s+1)>i));)s=t[o=(o+1)%t.length];return a.reverse().join(e)}}function Hs(t){return function(e){return e.replace(/[0-9]/g,function(e){return t[+e]})}}s(zs,"default"),s(qs,"formatDecimalParts"),s(js,"default"),s(Ws,"default"),s(Hs,"default");var Us,Ys=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function Vs(t){if(!(e=Ys.exec(t)))throw new Error("invalid format: "+t);var e;return new Gs({fill:e[1],align:e[2],sign:e[3],symbol:e[4],zero:e[5],width:e[6],comma:e[7],precision:e[8]&&e[8].slice(1),trim:e[9],type:e[10]})}function Gs(t){this.fill=void 0===t.fill?" ":t.fill+"",this.align=void 0===t.align?">":t.align+"",this.sign=void 0===t.sign?"-":t.sign+"",this.symbol=void 0===t.symbol?"":t.symbol+"",this.zero=!!t.zero,this.width=void 0===t.width?void 0:+t.width,this.comma=!!t.comma,this.precision=void 0===t.precision?void 0:+t.precision,this.trim=!!t.trim,this.type=void 0===t.type?"":t.type+""}function Xs(t){t:for(var e,r=t.length,i=1,n=-1;i<r;++i)switch(t[i]){case".":n=e=i;break;case"0":0===n&&(n=i),e=i;break;default:if(!+t[i])break t;n>0&&(n=0)}return n>0?t.slice(0,n)+t.slice(e+1):t}function Zs(t,e){var r=qs(t,e);if(!r)return t+"";var i=r[0],n=r[1],a=n-(Us=3*Math.max(-8,Math.min(8,Math.floor(n/3))))+1,o=i.length;return a===o?i:a>o?i+new Array(a-o+1).join("0"):a>0?i.slice(0,a)+"."+i.slice(a):"0."+new Array(1-a).join("0")+qs(t,Math.max(0,e+a-1))[0]}function Qs(t,e){var r=qs(t,e);if(!r)return t+"";var i=r[0],n=r[1];return n<0?"0."+new Array(-n).join("0")+i:i.length>n+1?i.slice(0,n+1)+"."+i.slice(n+1):i+new Array(n-i.length+2).join("0")}s(Vs,"formatSpecifier"),Vs.prototype=Gs.prototype,s(Gs,"FormatSpecifier"),Gs.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(void 0===this.width?"":Math.max(1,0|this.width))+(this.comma?",":"")+(void 0===this.precision?"":"."+Math.max(0,0|this.precision))+(this.trim?"~":"")+this.type},s(Xs,"default"),s(Zs,"default"),s(Qs,"default");var Ks={"%":s((t,e)=>(100*t).toFixed(e),"%"),b:s(t=>Math.round(t).toString(2),"b"),c:s(t=>t+"","c"),d:zs,e:s((t,e)=>t.toExponential(e),"e"),f:s((t,e)=>t.toFixed(e),"f"),g:s((t,e)=>t.toPrecision(e),"g"),o:s(t=>Math.round(t).toString(8),"o"),p:s((t,e)=>Qs(100*t,e),"p"),r:Qs,s:Zs,X:s(t=>Math.round(t).toString(16).toUpperCase(),"X"),x:s(t=>Math.round(t).toString(16),"x")};function Js(t){return t}s(Js,"default");var tl,el,rl,il=Array.prototype.map,nl=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function al(t){var e=void 0===t.grouping||void 0===t.thousands?Js:Ws(il.call(t.grouping,Number),t.thousands+""),r=void 0===t.currency?"":t.currency[0]+"",i=void 0===t.currency?"":t.currency[1]+"",n=void 0===t.decimal?".":t.decimal+"",a=void 0===t.numerals?Js:Hs(il.call(t.numerals,String)),o=void 0===t.percent?"%":t.percent+"",l=void 0===t.minus?"−":t.minus+"",h=void 0===t.nan?"NaN":t.nan+"";function c(t){var c=(t=Vs(t)).fill,u=t.align,d=t.sign,p=t.symbol,f=t.zero,g=t.width,y=t.comma,m=t.precision,x=t.trim,b=t.type;"n"===b?(y=!0,b="g"):Ks[b]||(void 0===m&&(m=12),x=!0,b="g"),(f||"0"===c&&"="===u)&&(f=!0,c="0",u="=");var C="$"===p?r:"#"===p&&/[boxX]/.test(b)?"0"+b.toLowerCase():"",k="$"===p?i:/[%p]/.test(b)?o:"",w=Ks[b],_=/[defgprs%]/.test(b);function v(t){var r,i,o,s=C,p=k;if("c"===b)p=w(t)+p,t="";else{var v=(t=+t)<0||1/t<0;if(t=isNaN(t)?h:w(Math.abs(t),m),x&&(t=Xs(t)),v&&0==+t&&"+"!==d&&(v=!1),s=(v?"("===d?d:l:"-"===d||"("===d?"":d)+s,p=("s"===b?nl[8+Us/3]:"")+p+(v&&"("===d?")":""),_)for(r=-1,i=t.length;++r<i;)if(48>(o=t.charCodeAt(r))||o>57){p=(46===o?n+t.slice(r+1):t.slice(r))+p,t=t.slice(0,r);break}}y&&!f&&(t=e(t,1/0));var S=s.length+t.length+p.length,T=S<g?new Array(g-S+1).join(c):"";switch(y&&f&&(t=e(T+t,T.length?g-p.length:1/0),T=""),u){case"<":t=s+t+p+T;break;case"=":t=s+T+t+p;break;case"^":t=T.slice(0,S=T.length>>1)+s+t+p+T.slice(S);break;default:t=T+s+t+p}return a(t)}return m=void 0===m?6:/[gprs]/.test(b)?Math.max(1,Math.min(21,m)):Math.max(0,Math.min(20,m)),s(v,"format"),v.toString=function(){return t+""},v}function u(t,e){var r=c(((t=Vs(t)).type="f",t)),i=3*Math.max(-8,Math.min(8,Math.floor(js(e)/3))),n=Math.pow(10,-i),a=nl[8+i/3];return function(t){return r(n*t)+a}}return s(c,"newFormat"),s(u,"formatPrefix"),{format:c,formatPrefix:u}}function ol(t){return tl=al(t),el=tl.format,rl=tl.formatPrefix,tl}function sl(t){return Math.max(0,-js(Math.abs(t)))}function ll(t,e){return Math.max(0,3*Math.max(-8,Math.min(8,Math.floor(js(e)/3)))-js(Math.abs(t)))}function hl(t,e){return t=Math.abs(t),e=Math.abs(e)-t,Math.max(0,js(e)-js(t))+1}function cl(t){var e=0,r=t.children,i=r&&r.length;if(i)for(;--i>=0;)e+=r[i].value;else e=1;t.value=e}function ul(){return this.eachAfter(cl)}function dl(t,e){let r=-1;for(let i of this)t.call(e,i,++r,this);return this}function pl(t,e){for(var r,i,n=this,a=[n],o=-1;n=a.pop();)if(t.call(e,n,++o,this),r=n.children)for(i=r.length-1;i>=0;--i)a.push(r[i]);return this}function fl(t,e){for(var r,i,n,a=this,o=[a],s=[],l=-1;a=o.pop();)if(s.push(a),r=a.children)for(i=0,n=r.length;i<n;++i)o.push(r[i]);for(;a=s.pop();)t.call(e,a,++l,this);return this}function gl(t,e){let r=-1;for(let i of this)if(t.call(e,i,++r,this))return i}function yl(t){return this.eachAfter(function(e){for(var r=+t(e.data)||0,i=e.children,n=i&&i.length;--n>=0;)r+=i[n].value;e.value=r})}function ml(t){return this.eachBefore(function(e){e.children&&e.children.sort(t)})}function xl(t){for(var e=this,r=bl(e,t),i=[e];e!==r;)e=e.parent,i.push(e);for(var n=i.length;t!==r;)i.splice(n,0,t),t=t.parent;return i}function bl(t,e){if(t===e)return t;var r=t.ancestors(),i=e.ancestors(),n=null;for(t=r.pop(),e=i.pop();t===e;)n=t,t=r.pop(),e=i.pop();return n}function Cl(){for(var t=this,e=[t];t=t.parent;)e.push(t);return e}function kl(){return Array.from(this)}function wl(){var t=[];return this.eachBefore(function(e){e.children||t.push(e)}),t}function _l(){var t=this,e=[];return t.each(function(r){r!==t&&e.push({source:r.parent,target:r})}),e}function*vl(){var t,e,r,i,n=this,a=[n];do{for(t=a.reverse(),a=[];n=t.pop();)if(yield n,e=n.children)for(r=0,i=e.length;r<i;++r)a.push(e[r])}while(a.length)}function Sl(t,e){t instanceof Map?(t=[void 0,t],void 0===e&&(e=Bl)):void 0===e&&(e=Ml);for(var r,i,n,a,o,s=new Ll(t),l=[s];r=l.pop();)if((n=e(r.data))&&(o=(n=Array.from(n)).length))for(r.children=n,a=o-1;a>=0;--a)l.push(i=n[a]=new Ll(n[a])),i.parent=r,i.depth=r.depth+1;return s.eachBefore(Fl)}function Tl(){return Sl(this).eachBefore(Al)}function Ml(t){return t.children}function Bl(t){return Array.isArray(t)?t[1]:null}function Al(t){void 0!==t.data.value&&(t.value=t.data.value),t.data=t.data.data}function Fl(t){var e=0;do{t.height=e}while((t=t.parent)&&t.height<++e)}function Ll(t){this.data=t,this.depth=this.height=0,this.parent=null}function $l(t){t.x0=Math.round(t.x0),t.y0=Math.round(t.y0),t.x1=Math.round(t.x1),t.y1=Math.round(t.y1)}function El(t,e,r,i,n){for(var a,o=t.children,s=-1,l=o.length,h=t.value&&(i-e)/t.value;++s<l;)(a=o[s]).y0=r,a.y1=n,a.x0=e,a.x1=e+=a.value*h}function Dl(t,e,r,i,n){for(var a,o=t.children,s=-1,l=o.length,h=t.value&&(n-r)/t.value;++s<l;)(a=o[s]).x0=e,a.x1=i,a.y0=r,a.y1=r+=a.value*h}s(al,"default"),ol({thousands:",",grouping:[3],currency:["$",""]}),s(ol,"defaultLocale"),s(sl,"default"),s(ll,"default"),s(hl,"default"),s(cl,"count"),s(ul,"default"),s(dl,"default"),s(pl,"default"),s(fl,"default"),s(gl,"default"),s(yl,"default"),s(ml,"default"),s(xl,"default"),s(bl,"leastCommonAncestor"),s(Cl,"default"),s(kl,"default"),s(wl,"default"),s(_l,"default"),s(vl,"default"),s(Sl,"hierarchy"),s(Tl,"node_copy"),s(Ml,"objectChildren"),s(Bl,"mapChildren"),s(Al,"copyData"),s(Fl,"computeHeight"),s(Ll,"Node"),Ll.prototype=Sl.prototype={constructor:Ll,count:ul,each:dl,eachAfter:fl,eachBefore:pl,find:gl,sum:yl,sort:ml,path:xl,ancestors:Cl,descendants:kl,leaves:wl,links:_l,copy:Tl,[Symbol.iterator]:vl},s($l,"default"),s(El,"default"),s(Dl,"default");var Ol=(1+Math.sqrt(5))/2;function Il(t,e,r,i,n,a){for(var o,s,l,h,c,u,d,p,f,g,y,m=[],x=e.children,b=0,C=0,k=x.length,w=e.value;b<k;){l=n-r,h=a-i;do{c=x[C++].value}while(!c&&C<k);for(u=d=c,y=c*c*(g=Math.max(h/l,l/h)/(w*t)),f=Math.max(d/y,y/u);C<k;++C){if(c+=s=x[C].value,s<u&&(u=s),s>d&&(d=s),y=c*c*g,(p=Math.max(d/y,y/u))>f){c-=s;break}f=p}m.push(o={value:c,dice:l<h,children:x.slice(b,C)}),o.dice?El(o,r,i,n,w?i+=h*c/w:a):Dl(o,r,i,w?r+=l*c/w:n,a),w-=c,b=C}return m}s(Il,"squarifyRatio");var Nl=s(function t(e){function r(t,r,i,n,a){Il(e,t,r,i,n,a)}return s(r,"squarify"),r.ratio=function(e){return t((e=+e)>1?e:1)},r},"custom")(Ol);function Rl(t){if("function"!=typeof t)throw new Error;return t}function Pl(){return 0}function zl(t){return function(){return t}}function ql(){var t=Nl,e=!1,r=1,i=1,n=[0],a=Pl,o=Pl,l=Pl,h=Pl,c=Pl;function u(t){return t.x0=t.y0=0,t.x1=r,t.y1=i,t.eachBefore(d),n=[0],e&&t.eachBefore($l),t}function d(e){var r=n[e.depth],i=e.x0+r,s=e.y0+r,u=e.x1-r,d=e.y1-r;u<i&&(i=u=(i+u)/2),d<s&&(s=d=(s+d)/2),e.x0=i,e.y0=s,e.x1=u,e.y1=d,e.children&&(r=n[e.depth+1]=a(e)/2,i+=c(e)-r,s+=o(e)-r,(u-=l(e)-r)<i&&(i=u=(i+u)/2),(d-=h(e)-r)<s&&(s=d=(s+d)/2),t(e,i,s,u,d))}return s(u,"treemap"),s(d,"positionNode"),u.round=function(t){return arguments.length?(e=!!t,u):e},u.size=function(t){return arguments.length?(r=+t[0],i=+t[1],u):[r,i]},u.tile=function(e){return arguments.length?(t=Rl(e),u):t},u.padding=function(t){return arguments.length?u.paddingInner(t).paddingOuter(t):u.paddingInner()},u.paddingInner=function(t){return arguments.length?(a="function"==typeof t?t:zl(+t),u):a},u.paddingOuter=function(t){return arguments.length?u.paddingTop(t).paddingRight(t).paddingBottom(t).paddingLeft(t):u.paddingTop()},u.paddingTop=function(t){return arguments.length?(o="function"==typeof t?t:zl(+t),u):o},u.paddingRight=function(t){return arguments.length?(l="function"==typeof t?t:zl(+t),u):l},u.paddingBottom=function(t){return arguments.length?(h="function"==typeof t?t:zl(+t),u):h},u.paddingLeft=function(t){return arguments.length?(c="function"==typeof t?t:zl(+t),u):c},u}function jl(t,e){switch(arguments.length){case 0:break;case 1:this.range(t);break;default:this.range(e).domain(t)}return this}s(Rl,"required"),s(Pl,"constantZero"),s(zl,"default"),s(ql,"default"),s(jl,"initRange");var Wl=Symbol("implicit");function Hl(){var t=new $i,e=[],r=[],i=Wl;function n(n){let a=t.get(n);if(void 0===a){if(i!==Wl)return i;t.set(n,a=e.push(n)-1)}return r[a%r.length]}return s(n,"scale"),n.domain=function(r){if(!arguments.length)return e.slice();e=[],t=new $i;for(let i of r)t.has(i)||t.set(i,e.push(i)-1);return n},n.range=function(t){return arguments.length?(r=Array.from(t),n):r.slice()},n.unknown=function(t){return arguments.length?(i=t,n):i},n.copy=function(){return Hl(e,r).unknown(i)},jl.apply(n,arguments),n}function Ul(t){return function(){return t}}function Yl(t){return+t}s(Hl,"ordinal"),s(Ul,"constants"),s(Yl,"number");var Vl=[0,1];function Gl(t){return t}function Xl(t,e){return(e-=t=+t)?function(r){return(r-t)/e}:Ul(isNaN(e)?NaN:.5)}function Zl(t,e){var r;return t>e&&(r=t,t=e,e=r),function(r){return Math.max(t,Math.min(e,r))}}function Ql(t,e,r){var i=t[0],n=t[1],a=e[0],o=e[1];return n<i?(i=Xl(n,i),a=r(o,a)):(i=Xl(i,n),a=r(a,o)),function(t){return a(i(t))}}function Kl(t,e,r){var i=Math.min(t.length,e.length)-1,n=new Array(i),a=new Array(i),o=-1;for(t[i]<t[0]&&(t=t.slice().reverse(),e=e.slice().reverse());++o<i;)n[o]=Xl(t[o],t[o+1]),a[o]=r(e[o],e[o+1]);return function(e){var r=Li(t,e,1,i)-1;return a[r](n[r](e))}}function Jl(t,e){return e.domain(t.domain()).range(t.range()).interpolate(t.interpolate()).clamp(t.clamp()).unknown(t.unknown())}function th(){var t,e,r,i,n,a,o=Vl,l=Vl,h=As,c=Gl;function u(){var t=Math.min(o.length,l.length);return c!==Gl&&(c=Zl(o[0],o[t-1])),i=t>2?Kl:Ql,n=a=null,d}function d(e){return null==e||isNaN(e=+e)?r:(n||(n=i(o.map(t),l,h)))(t(c(e)))}return s(u,"rescale"),s(d,"scale"),d.invert=function(r){return c(e((a||(a=i(l,o.map(t),ws)))(r)))},d.domain=function(t){return arguments.length?(o=Array.from(t,Yl),u()):o.slice()},d.range=function(t){return arguments.length?(l=Array.from(t),u()):l.slice()},d.rangeRound=function(t){return l=Array.from(t),h=Fs,u()},d.clamp=function(t){return arguments.length?(c=!!t||Gl,u()):c!==Gl},d.interpolate=function(t){return arguments.length?(h=t,u()):h},d.unknown=function(t){return arguments.length?(r=t,d):r},function(r,i){return t=r,e=i,u()}}function eh(){return th()(Gl,Gl)}function rh(t,e,r,i){var n,a=Wi(t,e,r);switch((i=Vs(i??",f")).type){case"s":var o=Math.max(Math.abs(t),Math.abs(e));return null==i.precision&&!isNaN(n=ll(a,o))&&(i.precision=n),rl(i,o);case"":case"e":case"g":case"p":case"r":null==i.precision&&!isNaN(n=hl(a,Math.max(Math.abs(t),Math.abs(e))))&&(i.precision=n-("e"===i.type));break;case"f":case"%":null==i.precision&&!isNaN(n=sl(a))&&(i.precision=n-2*("%"===i.type))}return el(i)}function ih(t){var e=t.domain;return t.ticks=function(t){var r=e();return qi(r[0],r[r.length-1],t??10)},t.tickFormat=function(t,r){var i=e();return rh(i[0],i[i.length-1],t??10,r)},t.nice=function(r){null==r&&(r=10);var i,n,a=e(),o=0,s=a.length-1,l=a[o],h=a[s],c=10;for(h<l&&(n=l,l=h,h=n,n=o,o=s,s=n);c-- >0;){if((n=ji(l,h,r))===i)return a[o]=l,a[s]=h,e(a);if(n>0)l=Math.floor(l/n)*n,h=Math.ceil(h/n)*n;else{if(!(n<0))break;l=Math.ceil(l*n)/n,h=Math.floor(h*n)/n}i=n}return t},t}function nh(){var t=eh();return t.copy=function(){return Jl(t,nh())},jl.apply(t,arguments),ih(t)}s(Gl,"identity"),s(Xl,"normalize"),s(Zl,"clamper"),s(Ql,"bimap"),s(Kl,"polymap"),s(Jl,"copy"),s(th,"transformer"),s(eh,"continuous"),s(rh,"tickFormat"),s(ih,"linearish"),s(nh,"linear");var ah=new Date,oh=new Date;function sh(t,e,r,i){function n(e){return t(e=0===arguments.length?new Date:new Date(+e)),e}return s(n,"interval"),n.floor=e=>(t(e=new Date(+e)),e),n.ceil=r=>(t(r=new Date(r-1)),e(r,1),t(r),r),n.round=t=>{let e=n(t),r=n.ceil(t);return t-e<r-t?e:r},n.offset=(t,r)=>(e(t=new Date(+t),null==r?1:Math.floor(r)),t),n.range=(r,i,a)=>{let o,s=[];if(r=n.ceil(r),a=null==a?1:Math.floor(a),!(r<i&&a>0))return s;do{s.push(o=new Date(+r)),e(r,a),t(r)}while(o<r&&r<i);return s},n.filter=r=>sh(e=>{if(e>=e)for(;t(e),!r(e);)e.setTime(e-1)},(t,i)=>{if(t>=t)if(i<0)for(;++i<=0;)for(;e(t,-1),!r(t););else for(;--i>=0;)for(;e(t,1),!r(t););}),r&&(n.count=(e,i)=>(ah.setTime(+e),oh.setTime(+i),t(ah),t(oh),Math.floor(r(ah,oh))),n.every=t=>(t=Math.floor(t),isFinite(t)&&t>0?t>1?n.filter(i?e=>i(e)%t===0:e=>n.count(0,e)%t===0):n:null)),n}s(sh,"timeInterval");var lh=sh(()=>{},(t,e)=>{t.setTime(+t+e)},(t,e)=>e-t);lh.every=t=>(t=Math.floor(t),isFinite(t)&&t>0?t>1?sh(e=>{e.setTime(Math.floor(e/t)*t)},(e,r)=>{e.setTime(+e+r*t)},(e,r)=>(r-e)/t):lh:null),lh.range;var hh=sh(t=>{t.setTime(t-t.getMilliseconds())},(t,e)=>{t.setTime(+t+1e3*e)},(t,e)=>(e-t)/1e3,t=>t.getUTCSeconds());hh.range;var ch=sh(t=>{t.setTime(t-t.getMilliseconds()-1e3*t.getSeconds())},(t,e)=>{t.setTime(+t+6e4*e)},(t,e)=>(e-t)/6e4,t=>t.getMinutes());ch.range;var uh=sh(t=>{t.setUTCSeconds(0,0)},(t,e)=>{t.setTime(+t+6e4*e)},(t,e)=>(e-t)/6e4,t=>t.getUTCMinutes());uh.range;var dh=sh(t=>{t.setTime(t-t.getMilliseconds()-1e3*t.getSeconds()-6e4*t.getMinutes())},(t,e)=>{t.setTime(+t+36e5*e)},(t,e)=>(e-t)/36e5,t=>t.getHours());dh.range;var ph=sh(t=>{t.setUTCMinutes(0,0,0)},(t,e)=>{t.setTime(+t+36e5*e)},(t,e)=>(e-t)/36e5,t=>t.getUTCHours());ph.range;var fh=sh(t=>t.setHours(0,0,0,0),(t,e)=>t.setDate(t.getDate()+e),(t,e)=>(e-t-6e4*(e.getTimezoneOffset()-t.getTimezoneOffset()))/864e5,t=>t.getDate()-1);fh.range;var gh=sh(t=>{t.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCDate(t.getUTCDate()+e)},(t,e)=>(e-t)/864e5,t=>t.getUTCDate()-1);gh.range;var yh=sh(t=>{t.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCDate(t.getUTCDate()+e)},(t,e)=>(e-t)/864e5,t=>Math.floor(t/864e5));function mh(t){return sh(e=>{e.setDate(e.getDate()-(e.getDay()+7-t)%7),e.setHours(0,0,0,0)},(t,e)=>{t.setDate(t.getDate()+7*e)},(t,e)=>(e-t-6e4*(e.getTimezoneOffset()-t.getTimezoneOffset()))/6048e5)}yh.range,s(mh,"timeWeekday");var xh=mh(0),bh=mh(1),Ch=mh(2),kh=mh(3),wh=mh(4),_h=mh(5),vh=mh(6);function Sh(t){return sh(e=>{e.setUTCDate(e.getUTCDate()-(e.getUTCDay()+7-t)%7),e.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCDate(t.getUTCDate()+7*e)},(t,e)=>(e-t)/6048e5)}xh.range,bh.range,Ch.range,kh.range,wh.range,_h.range,vh.range,s(Sh,"utcWeekday");var Th=Sh(0),Mh=Sh(1),Bh=Sh(2),Ah=Sh(3),Fh=Sh(4),Lh=Sh(5),$h=Sh(6);Th.range,Mh.range,Bh.range,Ah.range,Fh.range,Lh.range,$h.range;var Eh=sh(t=>{t.setDate(1),t.setHours(0,0,0,0)},(t,e)=>{t.setMonth(t.getMonth()+e)},(t,e)=>e.getMonth()-t.getMonth()+12*(e.getFullYear()-t.getFullYear()),t=>t.getMonth());Eh.range;var Dh=sh(t=>{t.setUTCDate(1),t.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCMonth(t.getUTCMonth()+e)},(t,e)=>e.getUTCMonth()-t.getUTCMonth()+12*(e.getUTCFullYear()-t.getUTCFullYear()),t=>t.getUTCMonth());Dh.range;var Oh=sh(t=>{t.setMonth(0,1),t.setHours(0,0,0,0)},(t,e)=>{t.setFullYear(t.getFullYear()+e)},(t,e)=>e.getFullYear()-t.getFullYear(),t=>t.getFullYear());Oh.every=t=>isFinite(t=Math.floor(t))&&t>0?sh(e=>{e.setFullYear(Math.floor(e.getFullYear()/t)*t),e.setMonth(0,1),e.setHours(0,0,0,0)},(e,r)=>{e.setFullYear(e.getFullYear()+r*t)}):null,Oh.range;var Ih=sh(t=>{t.setUTCMonth(0,1),t.setUTCHours(0,0,0,0)},(t,e)=>{t.setUTCFullYear(t.getUTCFullYear()+e)},(t,e)=>e.getUTCFullYear()-t.getUTCFullYear(),t=>t.getUTCFullYear());function Nh(t,e,r,i,n,a){let o=[[hh,1,1e3],[hh,5,5e3],[hh,15,15e3],[hh,30,3e4],[a,1,6e4],[a,5,3e5],[a,15,9e5],[a,30,18e5],[n,1,36e5],[n,3,108e5],[n,6,216e5],[n,12,432e5],[i,1,864e5],[i,2,1728e5],[r,1,6048e5],[e,1,2592e6],[e,3,7776e6],[t,1,31536e6]];function l(t,e,r){let i=e<t;i&&([t,e]=[e,t]);let n=r&&"function"==typeof r.range?r:h(t,e,r),a=n?n.range(t,+e+1):[];return i?a.reverse():a}function h(e,r,i){let n=Math.abs(r-e)/i,a=Ti(([,,t])=>t).right(o,n);if(a===o.length)return t.every(Wi(e/31536e6,r/31536e6,i));if(0===a)return lh.every(Math.max(Wi(e,r,i),1));let[s,l]=o[n/o[a-1][2]<o[a][2]/n?a-1:a];return s.every(l)}return s(l,"ticks"),s(h,"tickInterval"),[l,h]}Ih.every=t=>isFinite(t=Math.floor(t))&&t>0?sh(e=>{e.setUTCFullYear(Math.floor(e.getUTCFullYear()/t)*t),e.setUTCMonth(0,1),e.setUTCHours(0,0,0,0)},(e,r)=>{e.setUTCFullYear(e.getUTCFullYear()+r*t)}):null,Ih.range,s(Nh,"ticker");var[Rh,Ph]=Nh(Ih,Dh,Th,yh,ph,uh),[zh,qh]=Nh(Oh,Eh,xh,fh,dh,ch);function jh(t){if(0<=t.y&&t.y<100){var e=new Date(-1,t.m,t.d,t.H,t.M,t.S,t.L);return e.setFullYear(t.y),e}return new Date(t.y,t.m,t.d,t.H,t.M,t.S,t.L)}function Wh(t){if(0<=t.y&&t.y<100){var e=new Date(Date.UTC(-1,t.m,t.d,t.H,t.M,t.S,t.L));return e.setUTCFullYear(t.y),e}return new Date(Date.UTC(t.y,t.m,t.d,t.H,t.M,t.S,t.L))}function Hh(t,e,r){return{y:t,m:e,d:r,H:0,M:0,S:0,L:0}}function Uh(t){var e=t.dateTime,r=t.date,i=t.time,n=t.periods,a=t.days,o=t.shortDays,l=t.months,h=t.shortMonths,c=tc(n),u=ec(n),d=tc(a),p=ec(a),f=tc(o),g=ec(o),y=tc(l),m=ec(l),x=tc(h),b=ec(h),C={a:D,A:O,b:I,B:N,c:null,d:wc,e:wc,f:Mc,g:Rc,G:zc,H:_c,I:vc,j:Sc,L:Tc,m:Bc,M:Ac,p:R,q:P,Q:hu,s:cu,S:Fc,u:Lc,U:$c,V:Dc,w:Oc,W:Ic,x:null,X:null,y:Nc,Y:Pc,Z:qc,"%":lu},k={a:z,A:q,b:j,B:W,c:null,d:jc,e:jc,f:Vc,g:nu,G:ou,H:Wc,I:Hc,j:Uc,L:Yc,m:Gc,M:Xc,p:H,q:U,Q:hu,s:cu,S:Zc,u:Qc,U:Kc,V:tu,w:eu,W:ru,x:null,X:null,y:iu,Y:au,Z:su,"%":lu},w={a:M,A:B,b:A,B:F,c:L,d:dc,e:dc,f:xc,g:lc,G:sc,H:fc,I:fc,j:pc,L:mc,m:uc,M:gc,p:T,q:cc,Q:Cc,s:kc,S:yc,u:ic,U:nc,V:ac,w:rc,W:oc,x:$,X:E,y:lc,Y:sc,Z:hc,"%":bc};function _(t,e){return function(r){var i,n,a,o=[],s=-1,l=0,h=t.length;for(r instanceof Date||(r=new Date(+r));++s<h;)37===t.charCodeAt(s)&&(o.push(t.slice(l,s)),null!=(n=Gh[i=t.charAt(++s)])?i=t.charAt(++s):n="e"===i?" ":"0",(a=e[i])&&(i=a(r,n)),o.push(i),l=s+1);return o.push(t.slice(l,s)),o.join("")}}function v(t,e){return function(r){var i,n,a=Hh(1900,void 0,1);if(S(a,t,r+="",0)!=r.length)return null;if("Q"in a)return new Date(a.Q);if("s"in a)return new Date(1e3*a.s+("L"in a?a.L:0));if(e&&!("Z"in a)&&(a.Z=0),"p"in a&&(a.H=a.H%12+12*a.p),void 0===a.m&&(a.m="q"in a?a.q:0),"V"in a){if(a.V<1||a.V>53)return null;"w"in a||(a.w=1),"Z"in a?(n=(i=Wh(Hh(a.y,0,1))).getUTCDay(),i=n>4||0===n?Mh.ceil(i):Mh(i),i=gh.offset(i,7*(a.V-1)),a.y=i.getUTCFullYear(),a.m=i.getUTCMonth(),a.d=i.getUTCDate()+(a.w+6)%7):(n=(i=jh(Hh(a.y,0,1))).getDay(),i=n>4||0===n?bh.ceil(i):bh(i),i=fh.offset(i,7*(a.V-1)),a.y=i.getFullYear(),a.m=i.getMonth(),a.d=i.getDate()+(a.w+6)%7)}else("W"in a||"U"in a)&&("w"in a||(a.w="u"in a?a.u%7:"W"in a?1:0),n="Z"in a?Wh(Hh(a.y,0,1)).getUTCDay():jh(Hh(a.y,0,1)).getDay(),a.m=0,a.d="W"in a?(a.w+6)%7+7*a.W-(n+5)%7:a.w+7*a.U-(n+6)%7);return"Z"in a?(a.H+=a.Z/100|0,a.M+=a.Z%100,Wh(a)):jh(a)}}function S(t,e,r,i){for(var n,a,o=0,s=e.length,l=r.length;o<s;){if(i>=l)return-1;if(37===(n=e.charCodeAt(o++))){if(n=e.charAt(o++),!(a=w[n in Gh?e.charAt(o++):n])||(i=a(t,r,i))<0)return-1}else if(n!=r.charCodeAt(i++))return-1}return i}function T(t,e,r){var i=c.exec(e.slice(r));return i?(t.p=u.get(i[0].toLowerCase()),r+i[0].length):-1}function M(t,e,r){var i=f.exec(e.slice(r));return i?(t.w=g.get(i[0].toLowerCase()),r+i[0].length):-1}function B(t,e,r){var i=d.exec(e.slice(r));return i?(t.w=p.get(i[0].toLowerCase()),r+i[0].length):-1}function A(t,e,r){var i=x.exec(e.slice(r));return i?(t.m=b.get(i[0].toLowerCase()),r+i[0].length):-1}function F(t,e,r){var i=y.exec(e.slice(r));return i?(t.m=m.get(i[0].toLowerCase()),r+i[0].length):-1}function L(t,r,i){return S(t,e,r,i)}function $(t,e,i){return S(t,r,e,i)}function E(t,e,r){return S(t,i,e,r)}function D(t){return o[t.getDay()]}function O(t){return a[t.getDay()]}function I(t){return h[t.getMonth()]}function N(t){return l[t.getMonth()]}function R(t){return n[+(t.getHours()>=12)]}function P(t){return 1+~~(t.getMonth()/3)}function z(t){return o[t.getUTCDay()]}function q(t){return a[t.getUTCDay()]}function j(t){return h[t.getUTCMonth()]}function W(t){return l[t.getUTCMonth()]}function H(t){return n[+(t.getUTCHours()>=12)]}function U(t){return 1+~~(t.getUTCMonth()/3)}return C.x=_(r,C),C.X=_(i,C),C.c=_(e,C),k.x=_(r,k),k.X=_(i,k),k.c=_(e,k),s(_,"newFormat"),s(v,"newParse"),s(S,"parseSpecifier"),s(T,"parsePeriod"),s(M,"parseShortWeekday"),s(B,"parseWeekday"),s(A,"parseShortMonth"),s(F,"parseMonth"),s(L,"parseLocaleDateTime"),s($,"parseLocaleDate"),s(E,"parseLocaleTime"),s(D,"formatShortWeekday"),s(O,"formatWeekday"),s(I,"formatShortMonth"),s(N,"formatMonth"),s(R,"formatPeriod"),s(P,"formatQuarter"),s(z,"formatUTCShortWeekday"),s(q,"formatUTCWeekday"),s(j,"formatUTCShortMonth"),s(W,"formatUTCMonth"),s(H,"formatUTCPeriod"),s(U,"formatUTCQuarter"),{format:s(function(t){var e=_(t+="",C);return e.toString=function(){return t},e},"format"),parse:s(function(t){var e=v(t+="",!1);return e.toString=function(){return t},e},"parse"),utcFormat:s(function(t){var e=_(t+="",k);return e.toString=function(){return t},e},"utcFormat"),utcParse:s(function(t){var e=v(t+="",!0);return e.toString=function(){return t},e},"utcParse")}}s(jh,"localDate"),s(Wh,"utcDate"),s(Hh,"newDate"),s(Uh,"formatLocale");var Yh,Vh,Gh={"-":"",_:" ",0:"0"},Xh=/^\s*\d+/,Zh=/^%/,Qh=/[\\^$*+?|[\]().{}]/g;function Kh(t,e,r){var i=t<0?"-":"",n=(i?-t:t)+"",a=n.length;return i+(a<r?new Array(r-a+1).join(e)+n:n)}function Jh(t){return t.replace(Qh,"\\$&")}function tc(t){return new RegExp("^(?:"+t.map(Jh).join("|")+")","i")}function ec(t){return new Map(t.map((t,e)=>[t.toLowerCase(),e]))}function rc(t,e,r){var i=Xh.exec(e.slice(r,r+1));return i?(t.w=+i[0],r+i[0].length):-1}function ic(t,e,r){var i=Xh.exec(e.slice(r,r+1));return i?(t.u=+i[0],r+i[0].length):-1}function nc(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.U=+i[0],r+i[0].length):-1}function ac(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.V=+i[0],r+i[0].length):-1}function oc(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.W=+i[0],r+i[0].length):-1}function sc(t,e,r){var i=Xh.exec(e.slice(r,r+4));return i?(t.y=+i[0],r+i[0].length):-1}function lc(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.y=+i[0]+(+i[0]>68?1900:2e3),r+i[0].length):-1}function hc(t,e,r){var i=/^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(e.slice(r,r+6));return i?(t.Z=i[1]?0:-(i[2]+(i[3]||"00")),r+i[0].length):-1}function cc(t,e,r){var i=Xh.exec(e.slice(r,r+1));return i?(t.q=3*i[0]-3,r+i[0].length):-1}function uc(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.m=i[0]-1,r+i[0].length):-1}function dc(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.d=+i[0],r+i[0].length):-1}function pc(t,e,r){var i=Xh.exec(e.slice(r,r+3));return i?(t.m=0,t.d=+i[0],r+i[0].length):-1}function fc(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.H=+i[0],r+i[0].length):-1}function gc(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.M=+i[0],r+i[0].length):-1}function yc(t,e,r){var i=Xh.exec(e.slice(r,r+2));return i?(t.S=+i[0],r+i[0].length):-1}function mc(t,e,r){var i=Xh.exec(e.slice(r,r+3));return i?(t.L=+i[0],r+i[0].length):-1}function xc(t,e,r){var i=Xh.exec(e.slice(r,r+6));return i?(t.L=Math.floor(i[0]/1e3),r+i[0].length):-1}function bc(t,e,r){var i=Zh.exec(e.slice(r,r+1));return i?r+i[0].length:-1}function Cc(t,e,r){var i=Xh.exec(e.slice(r));return i?(t.Q=+i[0],r+i[0].length):-1}function kc(t,e,r){var i=Xh.exec(e.slice(r));return i?(t.s=+i[0],r+i[0].length):-1}function wc(t,e){return Kh(t.getDate(),e,2)}function _c(t,e){return Kh(t.getHours(),e,2)}function vc(t,e){return Kh(t.getHours()%12||12,e,2)}function Sc(t,e){return Kh(1+fh.count(Oh(t),t),e,3)}function Tc(t,e){return Kh(t.getMilliseconds(),e,3)}function Mc(t,e){return Tc(t,e)+"000"}function Bc(t,e){return Kh(t.getMonth()+1,e,2)}function Ac(t,e){return Kh(t.getMinutes(),e,2)}function Fc(t,e){return Kh(t.getSeconds(),e,2)}function Lc(t){var e=t.getDay();return 0===e?7:e}function $c(t,e){return Kh(xh.count(Oh(t)-1,t),e,2)}function Ec(t){var e=t.getDay();return e>=4||0===e?wh(t):wh.ceil(t)}function Dc(t,e){return t=Ec(t),Kh(wh.count(Oh(t),t)+(4===Oh(t).getDay()),e,2)}function Oc(t){return t.getDay()}function Ic(t,e){return Kh(bh.count(Oh(t)-1,t),e,2)}function Nc(t,e){return Kh(t.getFullYear()%100,e,2)}function Rc(t,e){return Kh((t=Ec(t)).getFullYear()%100,e,2)}function Pc(t,e){return Kh(t.getFullYear()%1e4,e,4)}function zc(t,e){var r=t.getDay();return Kh((t=r>=4||0===r?wh(t):wh.ceil(t)).getFullYear()%1e4,e,4)}function qc(t){var e=t.getTimezoneOffset();return(e>0?"-":(e*=-1,"+"))+Kh(e/60|0,"0",2)+Kh(e%60,"0",2)}function jc(t,e){return Kh(t.getUTCDate(),e,2)}function Wc(t,e){return Kh(t.getUTCHours(),e,2)}function Hc(t,e){return Kh(t.getUTCHours()%12||12,e,2)}function Uc(t,e){return Kh(1+gh.count(Ih(t),t),e,3)}function Yc(t,e){return Kh(t.getUTCMilliseconds(),e,3)}function Vc(t,e){return Yc(t,e)+"000"}function Gc(t,e){return Kh(t.getUTCMonth()+1,e,2)}function Xc(t,e){return Kh(t.getUTCMinutes(),e,2)}function Zc(t,e){return Kh(t.getUTCSeconds(),e,2)}function Qc(t){var e=t.getUTCDay();return 0===e?7:e}function Kc(t,e){return Kh(Th.count(Ih(t)-1,t),e,2)}function Jc(t){var e=t.getUTCDay();return e>=4||0===e?Fh(t):Fh.ceil(t)}function tu(t,e){return t=Jc(t),Kh(Fh.count(Ih(t),t)+(4===Ih(t).getUTCDay()),e,2)}function eu(t){return t.getUTCDay()}function ru(t,e){return Kh(Mh.count(Ih(t)-1,t),e,2)}function iu(t,e){return Kh(t.getUTCFullYear()%100,e,2)}function nu(t,e){return Kh((t=Jc(t)).getUTCFullYear()%100,e,2)}function au(t,e){return Kh(t.getUTCFullYear()%1e4,e,4)}function ou(t,e){var r=t.getUTCDay();return Kh((t=r>=4||0===r?Fh(t):Fh.ceil(t)).getUTCFullYear()%1e4,e,4)}function su(){return"+0000"}function lu(){return"%"}function hu(t){return+t}function cu(t){return Math.floor(+t/1e3)}function uu(t){return Yh=Uh(t),Vh=Yh.format,Yh.parse,Yh.utcFormat,Yh.utcParse,Yh}function du(t,e){var r,i=0,n=(t=t.slice()).length-1,a=t[i],o=t[n];return o<a&&(r=i,i=n,n=r,r=a,a=o,o=r),t[i]=e.floor(a),t[n]=e.ceil(o),t}function pu(t){return new Date(t)}function fu(t){return t instanceof Date?+t:+new Date(+t)}function gu(t,e,r,i,n,a,o,l,h,c){var u=eh(),d=u.invert,p=u.domain,f=c(".%L"),g=c(":%S"),y=c("%I:%M"),m=c("%I %p"),x=c("%a %d"),b=c("%b %d"),C=c("%B"),k=c("%Y");function w(t){return(h(t)<t?f:l(t)<t?g:o(t)<t?y:a(t)<t?m:i(t)<t?n(t)<t?x:b:r(t)<t?C:k)(t)}return s(w,"tickFormat"),u.invert=function(t){return new Date(d(t))},u.domain=function(t){return arguments.length?p(Array.from(t,fu)):p().map(pu)},u.ticks=function(e){var r=p();return t(r[0],r[r.length-1],e??10)},u.tickFormat=function(t,e){return null==e?w:c(e)},u.nice=function(t){var r=p();return(!t||"function"!=typeof t.range)&&(t=e(r[0],r[r.length-1],t??10)),t?p(du(r,t)):u},u.copy=function(){return Jl(u,gu(t,e,r,i,n,a,o,l,h,c))},u}function yu(){return jl.apply(gu(zh,qh,Oh,Eh,xh,fh,dh,ch,hh,Vh).domain([new Date(2e3,0,1),new Date(2e3,0,2)]),arguments)}function mu(){var t,e,r=Hl().unknown(void 0),i=r.domain,n=r.range,a=0,o=1,l=!1,h=0,c=0,u=.5;function d(){var r=i().length,s=o<a,d=s?o:a,p=s?a:o;t=(p-d)/Math.max(1,r-h+2*c),l&&(t=Math.floor(t)),d+=(p-d-t*(r-h))*u,e=t*(1-h),l&&(d=Math.round(d),e=Math.round(e));var f=Hi(r).map(function(e){return d+t*e});return n(s?f.reverse():f)}return delete r.unknown,s(d,"rescale"),r.domain=function(t){return arguments.length?(i(t),d()):i()},r.range=function(t){return arguments.length?([a,o]=t,a=+a,o=+o,d()):[a,o]},r.rangeRound=function(t){return[a,o]=t,a=+a,o=+o,l=!0,d()},r.bandwidth=function(){return e},r.step=function(){return t},r.round=function(t){return arguments.length?(l=!!t,d()):l},r.padding=function(t){return arguments.length?(h=Math.min(1,c=+t),d()):h},r.paddingInner=function(t){return arguments.length?(h=Math.min(1,t),d()):h},r.paddingOuter=function(t){return arguments.length?(c=+t,d()):c},r.align=function(t){return arguments.length?(u=Math.max(0,Math.min(1,t)),d()):u},r.copy=function(){return mu(i(),[a,o]).round(l).paddingInner(h).paddingOuter(c).align(u)},jl.apply(d(),arguments)}function xu(t){for(var e=t.length/6|0,r=new Array(e),i=0;i<e;)r[i]="#"+t.slice(6*i,6*++i);return r}s(Kh,"pad"),s(Jh,"requote"),s(tc,"formatRe"),s(ec,"formatLookup"),s(rc,"parseWeekdayNumberSunday"),s(ic,"parseWeekdayNumberMonday"),s(nc,"parseWeekNumberSunday"),s(ac,"parseWeekNumberISO"),s(oc,"parseWeekNumberMonday"),s(sc,"parseFullYear"),s(lc,"parseYear"),s(hc,"parseZone"),s(cc,"parseQuarter"),s(uc,"parseMonthNumber"),s(dc,"parseDayOfMonth"),s(pc,"parseDayOfYear"),s(fc,"parseHour24"),s(gc,"parseMinutes"),s(yc,"parseSeconds"),s(mc,"parseMilliseconds"),s(xc,"parseMicroseconds"),s(bc,"parseLiteralPercent"),s(Cc,"parseUnixTimestamp"),s(kc,"parseUnixTimestampSeconds"),s(wc,"formatDayOfMonth"),s(_c,"formatHour24"),s(vc,"formatHour12"),s(Sc,"formatDayOfYear"),s(Tc,"formatMilliseconds"),s(Mc,"formatMicroseconds"),s(Bc,"formatMonthNumber"),s(Ac,"formatMinutes"),s(Fc,"formatSeconds"),s(Lc,"formatWeekdayNumberMonday"),s($c,"formatWeekNumberSunday"),s(Ec,"dISO"),s(Dc,"formatWeekNumberISO"),s(Oc,"formatWeekdayNumberSunday"),s(Ic,"formatWeekNumberMonday"),s(Nc,"formatYear"),s(Rc,"formatYearISO"),s(Pc,"formatFullYear"),s(zc,"formatFullYearISO"),s(qc,"formatZone"),s(jc,"formatUTCDayOfMonth"),s(Wc,"formatUTCHour24"),s(Hc,"formatUTCHour12"),s(Uc,"formatUTCDayOfYear"),s(Yc,"formatUTCMilliseconds"),s(Vc,"formatUTCMicroseconds"),s(Gc,"formatUTCMonthNumber"),s(Xc,"formatUTCMinutes"),s(Zc,"formatUTCSeconds"),s(Qc,"formatUTCWeekdayNumberMonday"),s(Kc,"formatUTCWeekNumberSunday"),s(Jc,"UTCdISO"),s(tu,"formatUTCWeekNumberISO"),s(eu,"formatUTCWeekdayNumberSunday"),s(ru,"formatUTCWeekNumberMonday"),s(iu,"formatUTCYear"),s(nu,"formatUTCYearISO"),s(au,"formatUTCFullYear"),s(ou,"formatUTCFullYearISO"),s(su,"formatUTCZone"),s(lu,"formatLiteralPercent"),s(hu,"formatUnixTimestamp"),s(cu,"formatUnixTimestampSeconds"),uu({dateTime:"%x, %X",date:"%-m/%-d/%Y",time:"%-I:%M:%S %p",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}),s(uu,"defaultLocale"),s(du,"nice"),s(pu,"date"),s(fu,"number"),s(gu,"calendar"),s(yu,"time"),s(mu,"band"),s(xu,"default");var bu=xu("4e79a7f28e2ce1575976b7b259a14fedc949af7aa1ff9da79c755fbab0ab");function Cu(t){return s(function(){return t},"constant")}s(Cu,"default");var ku=Math.abs,wu=Math.atan2,_u=Math.cos,vu=Math.max,Su=Math.min,Tu=Math.sin,Mu=Math.sqrt,Bu=1e-12,Au=Math.PI,Fu=Au/2,Lu=2*Au;function $u(t){return t>1?0:t<-1?Au:Math.acos(t)}function Eu(t){return t>=1?Fu:t<=-1?-Fu:Math.asin(t)}s($u,"acos"),s(Eu,"asin");var Du=Math.PI,Ou=2*Du,Iu=1e-6,Nu=Ou-Iu;function Ru(t){this._+=t[0];for(let e=1,r=t.length;e<r;++e)this._+=arguments[e]+t[e]}function Pu(t){let e=Math.floor(t);if(!(e>=0))throw new Error(`invalid digits: ${t}`);if(e>15)return Ru;let r=10**e;return function(t){this._+=t[0];for(let e=1,i=t.length;e<i;++e)this._+=Math.round(arguments[e]*r)/r+t[e]}}s(Ru,"append"),s(Pu,"appendRound");var zu=class{static{s(this,"Path")}constructor(t){this._x0=this._y0=this._x1=this._y1=null,this._="",this._append=null==t?Ru:Pu(t)}moveTo(t,e){this._append`M${this._x0=this._x1=+t},${this._y0=this._y1=+e}`}closePath(){null!==this._x1&&(this._x1=this._x0,this._y1=this._y0,this._append`Z`)}lineTo(t,e){this._append`L${this._x1=+t},${this._y1=+e}`}quadraticCurveTo(t,e,r,i){this._append`Q${+t},${+e},${this._x1=+r},${this._y1=+i}`}bezierCurveTo(t,e,r,i,n,a){this._append`C${+t},${+e},${+r},${+i},${this._x1=+n},${this._y1=+a}`}arcTo(t,e,r,i,n){if(t=+t,e=+e,r=+r,i=+i,(n=+n)<0)throw new Error(`negative radius: ${n}`);let a=this._x1,o=this._y1,s=r-t,l=i-e,h=a-t,c=o-e,u=h*h+c*c;if(null===this._x1)this._append`M${this._x1=t},${this._y1=e}`;else if(u>Iu)if(Math.abs(c*s-l*h)>Iu&&n){let d=r-a,p=i-o,f=s*s+l*l,g=d*d+p*p,y=Math.sqrt(f),m=Math.sqrt(u),x=n*Math.tan((Du-Math.acos((f+u-g)/(2*y*m)))/2),b=x/m,C=x/y;Math.abs(b-1)>Iu&&this._append`L${t+b*h},${e+b*c}`,this._append`A${n},${n},0,0,${+(c*d>h*p)},${this._x1=t+C*s},${this._y1=e+C*l}`}else this._append`L${this._x1=t},${this._y1=e}`}arc(t,e,r,i,n,a){if(t=+t,e=+e,a=!!a,(r=+r)<0)throw new Error(`negative radius: ${r}`);let o=r*Math.cos(i),s=r*Math.sin(i),l=t+o,h=e+s,c=1^a,u=a?i-n:n-i;null===this._x1?this._append`M${l},${h}`:(Math.abs(this._x1-l)>Iu||Math.abs(this._y1-h)>Iu)&&this._append`L${l},${h}`,r&&(u<0&&(u=u%Ou+Ou),u>Nu?this._append`A${r},${r},0,1,${c},${t-o},${e-s}A${r},${r},0,1,${c},${this._x1=l},${this._y1=h}`:u>Iu&&this._append`A${r},${r},0,${+(u>=Du)},${c},${this._x1=t+r*Math.cos(n)},${this._y1=e+r*Math.sin(n)}`)}rect(t,e,r,i){this._append`M${this._x0=this._x1=+t},${this._y0=this._y1=+e}h${r=+r}v${+i}h${-r}Z`}toString(){return this._}};function qu(){return new zu}function ju(t){let e=3;return t.digits=function(r){if(!arguments.length)return e;if(null==r)e=null;else{let t=Math.floor(r);if(!(t>=0))throw new RangeError(`invalid digits: ${r}`);e=t}return t},()=>new zu(e)}function Wu(t){return t.innerRadius}function Hu(t){return t.outerRadius}function Uu(t){return t.startAngle}function Yu(t){return t.endAngle}function Vu(t){return t&&t.padAngle}function Gu(t,e,r,i,n,a,o,s){var l=r-t,h=i-e,c=o-n,u=s-a,d=u*l-c*h;if(!(d*d<Bu))return[t+(d=(c*(e-a)-u*(t-n))/d)*l,e+d*h]}function Xu(t,e,r,i,n,a,o){var s=t-r,l=e-i,h=(o?a:-a)/Mu(s*s+l*l),c=h*l,u=-h*s,d=t+c,p=e+u,f=r+c,g=i+u,y=(d+f)/2,m=(p+g)/2,x=f-d,b=g-p,C=x*x+b*b,k=n-a,w=d*g-f*p,_=(b<0?-1:1)*Mu(vu(0,k*k*C-w*w)),v=(w*b-x*_)/C,S=(-w*x-b*_)/C,T=(w*b+x*_)/C,M=(-w*x+b*_)/C,B=v-y,A=S-m,F=T-y,L=M-m;return B*B+A*A>F*F+L*L&&(v=T,S=M),{cx:v,cy:S,x01:-c,y01:-u,x11:v*(n/k-1),y11:S*(n/k-1)}}function Zu(){var t=Wu,e=Hu,r=Cu(0),i=null,n=Uu,a=Yu,o=Vu,l=null,h=ju(c);function c(){var s,c,u=+t.apply(this,arguments),d=+e.apply(this,arguments),p=n.apply(this,arguments)-Fu,f=a.apply(this,arguments)-Fu,g=ku(f-p),y=f>p;if(l||(l=s=h()),d<u&&(c=d,d=u,u=c),d>Bu)if(g>Lu-Bu)l.moveTo(d*_u(p),d*Tu(p)),l.arc(0,0,d,p,f,!y),u>Bu&&(l.moveTo(u*_u(f),u*Tu(f)),l.arc(0,0,u,f,p,y));else{var m,x,b=p,C=f,k=p,w=f,_=g,v=g,S=o.apply(this,arguments)/2,T=S>Bu&&(i?+i.apply(this,arguments):Mu(u*u+d*d)),M=Su(ku(d-u)/2,+r.apply(this,arguments)),B=M,A=M;if(T>Bu){var F=Eu(T/u*Tu(S)),L=Eu(T/d*Tu(S));(_-=2*F)>Bu?(k+=F*=y?1:-1,w-=F):(_=0,k=w=(p+f)/2),(v-=2*L)>Bu?(b+=L*=y?1:-1,C-=L):(v=0,b=C=(p+f)/2)}var $=d*_u(b),E=d*Tu(b),D=u*_u(w),O=u*Tu(w);if(M>Bu){var I,N=d*_u(C),R=d*Tu(C),P=u*_u(k),z=u*Tu(k);if(g<Au)if(I=Gu($,E,P,z,N,R,D,O)){var q=$-I[0],j=E-I[1],W=N-I[0],H=R-I[1],U=1/Tu($u((q*W+j*H)/(Mu(q*q+j*j)*Mu(W*W+H*H)))/2),Y=Mu(I[0]*I[0]+I[1]*I[1]);B=Su(M,(u-Y)/(U-1)),A=Su(M,(d-Y)/(U+1))}else B=A=0}v>Bu?A>Bu?(m=Xu(P,z,$,E,d,A,y),x=Xu(N,R,D,O,d,A,y),l.moveTo(m.cx+m.x01,m.cy+m.y01),A<M?l.arc(m.cx,m.cy,A,wu(m.y01,m.x01),wu(x.y01,x.x01),!y):(l.arc(m.cx,m.cy,A,wu(m.y01,m.x01),wu(m.y11,m.x11),!y),l.arc(0,0,d,wu(m.cy+m.y11,m.cx+m.x11),wu(x.cy+x.y11,x.cx+x.x11),!y),l.arc(x.cx,x.cy,A,wu(x.y11,x.x11),wu(x.y01,x.x01),!y))):(l.moveTo($,E),l.arc(0,0,d,b,C,!y)):l.moveTo($,E),u>Bu&&_>Bu?B>Bu?(m=Xu(D,O,N,R,u,-B,y),x=Xu($,E,P,z,u,-B,y),l.lineTo(m.cx+m.x01,m.cy+m.y01),B<M?l.arc(m.cx,m.cy,B,wu(m.y01,m.x01),wu(x.y01,x.x01),!y):(l.arc(m.cx,m.cy,B,wu(m.y01,m.x01),wu(m.y11,m.x11),!y),l.arc(0,0,u,wu(m.cy+m.y11,m.cx+m.x11),wu(x.cy+x.y11,x.cx+x.x11),y),l.arc(x.cx,x.cy,B,wu(x.y11,x.x11),wu(x.y01,x.x01),!y))):l.arc(0,0,u,w,k,y):l.lineTo(D,O)}else l.moveTo(0,0);if(l.closePath(),s)return l=null,s+""||null}return s(c,"arc"),c.centroid=function(){var r=(+t.apply(this,arguments)+ +e.apply(this,arguments))/2,i=(+n.apply(this,arguments)+ +a.apply(this,arguments))/2-Au/2;return[_u(i)*r,Tu(i)*r]},c.innerRadius=function(e){return arguments.length?(t="function"==typeof e?e:Cu(+e),c):t},c.outerRadius=function(t){return arguments.length?(e="function"==typeof t?t:Cu(+t),c):e},c.cornerRadius=function(t){return arguments.length?(r="function"==typeof t?t:Cu(+t),c):r},c.padRadius=function(t){return arguments.length?(i=null==t?null:"function"==typeof t?t:Cu(+t),c):i},c.startAngle=function(t){return arguments.length?(n="function"==typeof t?t:Cu(+t),c):n},c.endAngle=function(t){return arguments.length?(a="function"==typeof t?t:Cu(+t),c):a},c.padAngle=function(t){return arguments.length?(o="function"==typeof t?t:Cu(+t),c):o},c.context=function(t){return arguments.length?(l=t??null,c):l},c}function Qu(t){this._context=t}function Ku(t){return new Qu(t)}function Ju(t){return"object"==typeof t&&"length"in t?t:Array.from(t)}function td(t){return t[0]}function ed(t){return t[1]}function rd(t,e){var r=Cu(!0),i=null,n=Ku,a=null,o=ju(l);function l(s){var l,h,c,u=(s=Ju(s)).length,d=!1;for(null==i&&(a=n(c=o())),l=0;l<=u;++l)!(l<u&&r(h=s[l],l,s))===d&&((d=!d)?a.lineStart():a.lineEnd()),d&&a.point(+t(h,l,s),+e(h,l,s));if(c)return a=null,c+""||null}return t="function"==typeof t?t:void 0===t?td:Cu(t),e="function"==typeof e?e:void 0===e?ed:Cu(e),s(l,"line"),l.x=function(e){return arguments.length?(t="function"==typeof e?e:Cu(+e),l):t},l.y=function(t){return arguments.length?(e="function"==typeof t?t:Cu(+t),l):e},l.defined=function(t){return arguments.length?(r="function"==typeof t?t:Cu(!!t),l):r},l.curve=function(t){return arguments.length?(n=t,null!=i&&(a=n(i)),l):n},l.context=function(t){return arguments.length?(null==t?i=a=null:a=n(i=t),l):i},l}function id(t,e){return e<t?-1:e>t?1:e>=t?0:NaN}function nd(t){return t}function ad(){var t=nd,e=id,r=null,i=Cu(0),n=Cu(Lu),a=Cu(0);function o(o){var s,l,h,c,u,d=(o=Ju(o)).length,p=0,f=new Array(d),g=new Array(d),y=+i.apply(this,arguments),m=Math.min(Lu,Math.max(-Lu,n.apply(this,arguments)-y)),x=Math.min(Math.abs(m)/d,a.apply(this,arguments)),b=x*(m<0?-1:1);for(s=0;s<d;++s)(u=g[f[s]=s]=+t(o[s],s,o))>0&&(p+=u);for(null!=e?f.sort(function(t,r){return e(g[t],g[r])}):null!=r&&f.sort(function(t,e){return r(o[t],o[e])}),s=0,h=p?(m-d*b)/p:0;s<d;++s,y=c)l=f[s],c=y+((u=g[l])>0?u*h:0)+b,g[l]={data:o[l],index:s,value:u,startAngle:y,endAngle:c,padAngle:x};return g}return s(o,"pie"),o.value=function(e){return arguments.length?(t="function"==typeof e?e:Cu(+e),o):t},o.sortValues=function(t){return arguments.length?(e=t,r=null,o):e},o.sort=function(t){return arguments.length?(r=t,e=null,o):r},o.startAngle=function(t){return arguments.length?(i="function"==typeof t?t:Cu(+t),o):i},o.endAngle=function(t){return arguments.length?(n="function"==typeof t?t:Cu(+t),o):n},o.padAngle=function(t){return arguments.length?(a="function"==typeof t?t:Cu(+t),o):a},o}s(qu,"path"),qu.prototype=zu.prototype,s(ju,"withPath"),s(Wu,"arcInnerRadius"),s(Hu,"arcOuterRadius"),s(Uu,"arcStartAngle"),s(Yu,"arcEndAngle"),s(Vu,"arcPadAngle"),s(Gu,"intersect"),s(Xu,"cornerTangents"),s(Zu,"default"),s(Qu,"Linear"),Qu.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._point=0},"lineStart"),lineEnd:s(function(){(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;default:this._context.lineTo(t,e)}},"point")},s(Ku,"default"),s(Ju,"default"),s(td,"x"),s(ed,"y"),s(rd,"default"),s(id,"default"),s(nd,"default"),s(ad,"default");var od=class{static{s(this,"Bump")}constructor(t,e){this._context=t,this._x=e}areaStart(){this._line=0}areaEnd(){this._line=NaN}lineStart(){this._point=0}lineEnd(){(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line}point(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;default:this._x?this._context.bezierCurveTo(this._x0=(this._x0+t)/2,this._y0,this._x0,e,t,e):this._context.bezierCurveTo(this._x0,this._y0=(this._y0+e)/2,t,this._y0,t,e)}this._x0=t,this._y0=e}};function sd(t){return new od(t,!0)}function ld(t){return new od(t,!1)}function hd(t,e,r){t._context.bezierCurveTo((2*t._x0+t._x1)/3,(2*t._y0+t._y1)/3,(t._x0+2*t._x1)/3,(t._y0+2*t._y1)/3,(t._x0+4*t._x1+e)/6,(t._y0+4*t._y1+r)/6)}function cd(t){this._context=t}function ud(t){return new cd(t)}function dd(){}function pd(t){this._context=t}function fd(t){return new pd(t)}function gd(t){this._context=t}function yd(t){return new gd(t)}function md(t,e){this._basis=new cd(t),this._beta=e}s(sd,"bumpX"),s(ld,"bumpY"),s(hd,"point"),s(cd,"Basis"),cd.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._y0=this._y1=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 3:hd(this,this._x1,this._y1);case 2:this._context.lineTo(this._x1,this._y1)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3,this._context.lineTo((5*this._x0+this._x1)/6,(5*this._y0+this._y1)/6);default:hd(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e},"point")},s(ud,"default"),s(dd,"default"),s(pd,"BasisClosed"),pd.prototype={areaStart:dd,areaEnd:dd,lineStart:s(function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._y0=this._y1=this._y2=this._y3=this._y4=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 1:this._context.moveTo(this._x2,this._y2),this._context.closePath();break;case 2:this._context.moveTo((this._x2+2*this._x3)/3,(this._y2+2*this._y3)/3),this._context.lineTo((this._x3+2*this._x2)/3,(this._y3+2*this._y2)/3),this._context.closePath();break;case 3:this.point(this._x2,this._y2),this.point(this._x3,this._y3),this.point(this._x4,this._y4)}},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._x2=t,this._y2=e;break;case 1:this._point=2,this._x3=t,this._y3=e;break;case 2:this._point=3,this._x4=t,this._y4=e,this._context.moveTo((this._x0+4*this._x1+t)/6,(this._y0+4*this._y1+e)/6);break;default:hd(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e},"point")},s(fd,"default"),s(gd,"BasisOpen"),gd.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._y0=this._y1=NaN,this._point=0},"lineStart"),lineEnd:s(function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;var r=(this._x0+4*this._x1+t)/6,i=(this._y0+4*this._y1+e)/6;this._line?this._context.lineTo(r,i):this._context.moveTo(r,i);break;case 3:this._point=4;default:hd(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e},"point")},s(yd,"default"),s(md,"Bundle"),md.prototype={lineStart:s(function(){this._x=[],this._y=[],this._basis.lineStart()},"lineStart"),lineEnd:s(function(){var t=this._x,e=this._y,r=t.length-1;if(r>0)for(var i,n=t[0],a=e[0],o=t[r]-n,s=e[r]-a,l=-1;++l<=r;)i=l/r,this._basis.point(this._beta*t[l]+(1-this._beta)*(n+i*o),this._beta*e[l]+(1-this._beta)*(a+i*s));this._x=this._y=null,this._basis.lineEnd()},"lineEnd"),point:s(function(t,e){this._x.push(+t),this._y.push(+e)},"point")};var xd=s(function t(e){function r(t){return 1===e?new cd(t):new md(t,e)}return s(r,"bundle"),r.beta=function(e){return t(+e)},r},"custom")(.85);function bd(t,e,r){t._context.bezierCurveTo(t._x1+t._k*(t._x2-t._x0),t._y1+t._k*(t._y2-t._y0),t._x2+t._k*(t._x1-e),t._y2+t._k*(t._y1-r),t._x2,t._y2)}function Cd(t,e){this._context=t,this._k=(1-e)/6}s(bd,"point"),s(Cd,"Cardinal"),Cd.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:bd(this,this._x1,this._y1)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2,this._x1=t,this._y1=e;break;case 2:this._point=3;default:bd(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var kd=s(function t(e){function r(t){return new Cd(t,e)}return s(r,"cardinal"),r.tension=function(e){return t(+e)},r},"custom")(0);function wd(t,e){this._context=t,this._k=(1-e)/6}s(wd,"CardinalClosed"),wd.prototype={areaStart:dd,areaEnd:dd,lineStart:s(function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 1:this._context.moveTo(this._x3,this._y3),this._context.closePath();break;case 2:this._context.lineTo(this._x3,this._y3),this._context.closePath();break;case 3:this.point(this._x3,this._y3),this.point(this._x4,this._y4),this.point(this._x5,this._y5)}},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._x3=t,this._y3=e;break;case 1:this._point=2,this._context.moveTo(this._x4=t,this._y4=e);break;case 2:this._point=3,this._x5=t,this._y5=e;break;default:bd(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var _d=s(function t(e){function r(t){return new wd(t,e)}return s(r,"cardinal"),r.tension=function(e){return t(+e)},r},"custom")(0);function vd(t,e){this._context=t,this._k=(1-e)/6}s(vd,"CardinalOpen"),vd.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._point=0},"lineStart"),lineEnd:s(function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3,this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:bd(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var Sd=s(function t(e){function r(t){return new vd(t,e)}return s(r,"cardinal"),r.tension=function(e){return t(+e)},r},"custom")(0);function Td(t,e,r){var i=t._x1,n=t._y1,a=t._x2,o=t._y2;if(t._l01_a>Bu){var s=2*t._l01_2a+3*t._l01_a*t._l12_a+t._l12_2a,l=3*t._l01_a*(t._l01_a+t._l12_a);i=(i*s-t._x0*t._l12_2a+t._x2*t._l01_2a)/l,n=(n*s-t._y0*t._l12_2a+t._y2*t._l01_2a)/l}if(t._l23_a>Bu){var h=2*t._l23_2a+3*t._l23_a*t._l12_a+t._l12_2a,c=3*t._l23_a*(t._l23_a+t._l12_a);a=(a*h+t._x1*t._l23_2a-e*t._l12_2a)/c,o=(o*h+t._y1*t._l23_2a-r*t._l12_2a)/c}t._context.bezierCurveTo(i,n,a,o,t._x2,t._y2)}function Md(t,e){this._context=t,this._alpha=e}s(Td,"point"),s(Md,"CatmullRom"),Md.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:this.point(this._x2,this._y2)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,i=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+i*i,this._alpha))}switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3;default:Td(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var Bd=s(function t(e){function r(t){return e?new Md(t,e):new Cd(t,0)}return s(r,"catmullRom"),r.alpha=function(e){return t(+e)},r},"custom")(.5);function Ad(t,e){this._context=t,this._alpha=e}s(Ad,"CatmullRomClosed"),Ad.prototype={areaStart:dd,areaEnd:dd,lineStart:s(function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 1:this._context.moveTo(this._x3,this._y3),this._context.closePath();break;case 2:this._context.lineTo(this._x3,this._y3),this._context.closePath();break;case 3:this.point(this._x3,this._y3),this.point(this._x4,this._y4),this.point(this._x5,this._y5)}},"lineEnd"),point:s(function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,i=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+i*i,this._alpha))}switch(this._point){case 0:this._point=1,this._x3=t,this._y3=e;break;case 1:this._point=2,this._context.moveTo(this._x4=t,this._y4=e);break;case 2:this._point=3,this._x5=t,this._y5=e;break;default:Td(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var Fd=s(function t(e){function r(t){return e?new Ad(t,e):new wd(t,0)}return s(r,"catmullRom"),r.alpha=function(e){return t(+e)},r},"custom")(.5);function Ld(t,e){this._context=t,this._alpha=e}s(Ld,"CatmullRomOpen"),Ld.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},"lineStart"),lineEnd:s(function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,i=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+i*i,this._alpha))}switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3,this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:Td(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e},"point")};var $d=s(function t(e){function r(t){return e?new Ld(t,e):new vd(t,0)}return s(r,"catmullRom"),r.alpha=function(e){return t(+e)},r},"custom")(.5);function Ed(t){this._context=t}function Dd(t){return new Ed(t)}function Od(t){return t<0?-1:1}function Id(t,e,r){var i=t._x1-t._x0,n=e-t._x1,a=(t._y1-t._y0)/(i||n<0&&-0),o=(r-t._y1)/(n||i<0&&-0),s=(a*n+o*i)/(i+n);return(Od(a)+Od(o))*Math.min(Math.abs(a),Math.abs(o),.5*Math.abs(s))||0}function Nd(t,e){var r=t._x1-t._x0;return r?(3*(t._y1-t._y0)/r-e)/2:e}function Rd(t,e,r){var i=t._x0,n=t._y0,a=t._x1,o=t._y1,s=(a-i)/3;t._context.bezierCurveTo(i+s,n+s*e,a-s,o-s*r,a,o)}function Pd(t){this._context=t}function zd(t){this._context=new qd(t)}function qd(t){this._context=t}function jd(t){return new Pd(t)}function Wd(t){return new zd(t)}function Hd(t){this._context=t}function Ud(t){var e,r,i=t.length-1,n=new Array(i),a=new Array(i),o=new Array(i);for(n[0]=0,a[0]=2,o[0]=t[0]+2*t[1],e=1;e<i-1;++e)n[e]=1,a[e]=4,o[e]=4*t[e]+2*t[e+1];for(n[i-1]=2,a[i-1]=7,o[i-1]=8*t[i-1]+t[i],e=1;e<i;++e)r=n[e]/a[e-1],a[e]-=r,o[e]-=r*o[e-1];for(n[i-1]=o[i-1]/a[i-1],e=i-2;e>=0;--e)n[e]=(o[e]-n[e+1])/a[e];for(a[i-1]=(t[i]+n[i-1])/2,e=0;e<i-1;++e)a[e]=2*t[e+1]-n[e+1];return[n,a]}function Yd(t){return new Hd(t)}function Vd(t,e){this._context=t,this._t=e}function Gd(t){return new Vd(t,.5)}function Xd(t){return new Vd(t,0)}function Zd(t){return new Vd(t,1)}s(Ed,"LinearClosed"),Ed.prototype={areaStart:dd,areaEnd:dd,lineStart:s(function(){this._point=0},"lineStart"),lineEnd:s(function(){this._point&&this._context.closePath()},"lineEnd"),point:s(function(t,e){t=+t,e=+e,this._point?this._context.lineTo(t,e):(this._point=1,this._context.moveTo(t,e))},"point")},s(Dd,"default"),s(Od,"sign"),s(Id,"slope3"),s(Nd,"slope2"),s(Rd,"point"),s(Pd,"MonotoneX"),Pd.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x0=this._x1=this._y0=this._y1=this._t0=NaN,this._point=0},"lineStart"),lineEnd:s(function(){switch(this._point){case 2:this._context.lineTo(this._x1,this._y1);break;case 3:Rd(this,this._t0,Nd(this,this._t0))}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},"lineEnd"),point:s(function(t,e){var r=NaN;if(e=+e,(t=+t)!==this._x1||e!==this._y1){switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3,Rd(this,Nd(this,r=Id(this,t,e)),r);break;default:Rd(this,this._t0,r=Id(this,t,e))}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e,this._t0=r}},"point")},s(zd,"MonotoneY"),(zd.prototype=Object.create(Pd.prototype)).point=function(t,e){Pd.prototype.point.call(this,e,t)},s(qd,"ReflectContext"),qd.prototype={moveTo:s(function(t,e){this._context.moveTo(e,t)},"moveTo"),closePath:s(function(){this._context.closePath()},"closePath"),lineTo:s(function(t,e){this._context.lineTo(e,t)},"lineTo"),bezierCurveTo:s(function(t,e,r,i,n,a){this._context.bezierCurveTo(e,t,i,r,a,n)},"bezierCurveTo")},s(jd,"monotoneX"),s(Wd,"monotoneY"),s(Hd,"Natural"),Hd.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x=[],this._y=[]},"lineStart"),lineEnd:s(function(){var t=this._x,e=this._y,r=t.length;if(r)if(this._line?this._context.lineTo(t[0],e[0]):this._context.moveTo(t[0],e[0]),2===r)this._context.lineTo(t[1],e[1]);else for(var i=Ud(t),n=Ud(e),a=0,o=1;o<r;++a,++o)this._context.bezierCurveTo(i[0][a],n[0][a],i[1][a],n[1][a],t[o],e[o]);(this._line||0!==this._line&&1===r)&&this._context.closePath(),this._line=1-this._line,this._x=this._y=null},"lineEnd"),point:s(function(t,e){this._x.push(+t),this._y.push(+e)},"point")},s(Ud,"controlPoints"),s(Yd,"default"),s(Vd,"Step"),Vd.prototype={areaStart:s(function(){this._line=0},"areaStart"),areaEnd:s(function(){this._line=NaN},"areaEnd"),lineStart:s(function(){this._x=this._y=NaN,this._point=0},"lineStart"),lineEnd:s(function(){0<this._t&&this._t<1&&2===this._point&&this._context.lineTo(this._x,this._y),(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line>=0&&(this._t=1-this._t,this._line=1-this._line)},"lineEnd"),point:s(function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;default:if(this._t<=0)this._context.lineTo(this._x,e),this._context.lineTo(t,e);else{var r=this._x*(1-this._t)+t*this._t;this._context.lineTo(r,this._y),this._context.lineTo(r,e)}}this._x=t,this._y=e},"point")},s(Gd,"default"),s(Xd,"stepBefore"),s(Zd,"stepAfter");var Qd={value:s(()=>{},"value")};function Kd(){for(var t,e=0,r=arguments.length,i={};e<r;++e){if(!(t=arguments[e]+"")||t in i||/[\s.]/.test(t))throw new Error("illegal type: "+t);i[t]=[]}return new Jd(i)}function Jd(t){this._=t}function tp(t,e){return t.trim().split(/^|\s+/).map(function(t){var r="",i=t.indexOf(".");if(i>=0&&(r=t.slice(i+1),t=t.slice(0,i)),t&&!e.hasOwnProperty(t))throw new Error("unknown type: "+t);return{type:t,name:r}})}function ep(t,e){for(var r,i=0,n=t.length;i<n;++i)if((r=t[i]).name===e)return r.value}function rp(t,e,r){for(var i=0,n=t.length;i<n;++i)if(t[i].name===e){t[i]=Qd,t=t.slice(0,i).concat(t.slice(i+1));break}return null!=r&&t.push({name:e,value:r}),t}s(Kd,"dispatch"),s(Jd,"Dispatch"),s(tp,"parseTypenames"),Jd.prototype=Kd.prototype={constructor:Jd,on:s(function(t,e){var r,i=this._,n=tp(t+"",i),a=-1,o=n.length;if(!(arguments.length<2)){if(null!=e&&"function"!=typeof e)throw new Error("invalid callback: "+e);for(;++a<o;)if(r=(t=n[a]).type)i[r]=rp(i[r],t.name,e);else if(null==e)for(r in i)i[r]=rp(i[r],t.name,null);return this}for(;++a<o;)if((r=(t=n[a]).type)&&(r=ep(i[r],t.name)))return r},"on"),copy:s(function(){var t={},e=this._;for(var r in e)t[r]=e[r].slice();return new Jd(t)},"copy"),call:s(function(t,e){if((r=arguments.length-2)>0)for(var r,i,n=new Array(r),a=0;a<r;++a)n[a]=arguments[a+2];if(!this._.hasOwnProperty(t))throw new Error("unknown type: "+t);for(a=0,r=(i=this._[t]).length;a<r;++a)i[a].value.apply(e,n)},"call"),apply:s(function(t,e,r){if(!this._.hasOwnProperty(t))throw new Error("unknown type: "+t);for(var i=this._[t],n=0,a=i.length;n<a;++n)i[n].value.apply(e,r)},"apply")},s(ep,"get"),s(rp,"set");var ip,np,ap=Kd,op=0,sp=0,lp=0,hp=0,cp=0,up=0,dp="object"==typeof performance&&performance.now?performance:Date,pp="object"==typeof window&&window.requestAnimationFrame?window.requestAnimationFrame.bind(window):function(t){setTimeout(t,17)};function fp(){return cp||(pp(gp),cp=dp.now()+up)}function gp(){cp=0}function yp(){this._call=this._time=this._next=null}function mp(t,e,r){var i=new yp;return i.restart(t,e,r),i}function xp(){fp(),++op;for(var t,e=ip;e;)(t=cp-e._time)>=0&&e._call.call(void 0,t),e=e._next;--op}function bp(){cp=(hp=dp.now())+up,op=sp=0;try{xp()}finally{op=0,kp(),cp=0}}function Cp(){var t=dp.now(),e=t-hp;e>1e3&&(up-=e,hp=t)}function kp(){for(var t,e,r=ip,i=1/0;r;)r._call?(i>r._time&&(i=r._time),t=r,r=r._next):(e=r._next,r._next=null,r=t?t._next=e:ip=e);np=t,wp(i)}function wp(t){op||(sp&&(sp=clearTimeout(sp)),t-cp>24?(t<1/0&&(sp=setTimeout(bp,t-dp.now()-up)),lp&&(lp=clearInterval(lp))):(lp||(hp=dp.now(),lp=setInterval(Cp,1e3)),op=1,pp(bp)))}function _p(t,e,r){var i=new yp;return e=null==e?0:+e,i.restart(r=>{i.stop(),t(r+e)},e,r),i}s(fp,"now"),s(gp,"clearNow"),s(yp,"Timer"),yp.prototype=mp.prototype={constructor:yp,restart:s(function(t,e,r){if("function"!=typeof t)throw new TypeError("callback is not a function");r=(null==r?fp():+r)+(null==e?0:+e),!this._next&&np!==this&&(np?np._next=this:ip=this,np=this),this._call=t,this._time=r,wp()},"restart"),stop:s(function(){this._call&&(this._call=null,this._time=1/0,wp())},"stop")},s(mp,"timer"),s(xp,"timerFlush"),s(bp,"wake"),s(Cp,"poke"),s(kp,"nap"),s(wp,"sleep"),s(_p,"default");var vp=ap("start","end","cancel","interrupt"),Sp=[];function Tp(t,e,r,i,n,a){var o=t.__transition;if(o){if(r in o)return}else t.__transition={};Fp(t,r,{name:e,index:i,group:n,on:vp,tween:Sp,time:a.time,delay:a.delay,duration:a.duration,ease:a.ease,timer:null,state:0})}function Mp(t,e){var r=Ap(t,e);if(r.state>0)throw new Error("too late; already scheduled");return r}function Bp(t,e){var r=Ap(t,e);if(r.state>3)throw new Error("too late; already running");return r}function Ap(t,e){var r=t.__transition;if(!r||!(r=r[e]))throw new Error("transition not found");return r}function Fp(t,e,r){var i,n=t.__transition;function a(t){r.state=1,r.timer.restart(o,r.delay,r.time),r.delay<=t&&o(t-r.delay)}function o(a){var s,c,u,d;if(1!==r.state)return h();for(s in n)if((d=n[s]).name===r.name){if(3===d.state)return _p(o);4===d.state?(d.state=6,d.timer.stop(),d.on.call("interrupt",t,t.__data__,d.index,d.group),delete n[s]):+s<e&&(d.state=6,d.timer.stop(),d.on.call("cancel",t,t.__data__,d.index,d.group),delete n[s])}if(_p(function(){3===r.state&&(r.state=4,r.timer.restart(l,r.delay,r.time),l(a))}),r.state=2,r.on.call("start",t,t.__data__,r.index,r.group),2===r.state){for(r.state=3,i=new Array(u=r.tween.length),s=0,c=-1;s<u;++s)(d=r.tween[s].value.call(t,t.__data__,r.index,r.group))&&(i[++c]=d);i.length=c+1}}function l(e){for(var n=e<r.duration?r.ease.call(null,e/r.duration):(r.timer.restart(h),r.state=5,1),a=-1,o=i.length;++a<o;)i[a].call(t,n);5===r.state&&(r.on.call("end",t,t.__data__,r.index,r.group),h())}function h(){for(var i in r.state=6,r.timer.stop(),delete n[e],n)return;delete t.__transition}n[e]=r,r.timer=mp(a,0,r.time),s(a,"schedule"),s(o,"start"),s(l,"tick"),s(h,"stop")}function Lp(t,e){var r,i,n,a=t.__transition,o=!0;if(a){for(n in e=null==e?null:e+"",a)(r=a[n]).name===e?(i=r.state>2&&r.state<5,r.state=6,r.timer.stop(),r.on.call(i?"interrupt":"cancel",t,t.__data__,r.index,r.group),delete a[n]):o=!1;o&&delete t.__transition}}function $p(t){return this.each(function(){Lp(this,t)})}function Ep(t,e){var r,i;return function(){var n=Bp(this,t),a=n.tween;if(a!==r)for(var o=0,s=(i=r=a).length;o<s;++o)if(i[o].name===e){(i=i.slice()).splice(o,1);break}n.tween=i}}function Dp(t,e,r){var i,n;if("function"!=typeof r)throw new Error;return function(){var a=Bp(this,t),o=a.tween;if(o!==i){n=(i=o).slice();for(var s={name:e,value:r},l=0,h=n.length;l<h;++l)if(n[l].name===e){n[l]=s;break}l===h&&n.push(s)}a.tween=n}}function Op(t,e){var r=this._id;if(t+="",arguments.length<2){for(var i,n=Ap(this.node(),r).tween,a=0,o=n.length;a<o;++a)if((i=n[a]).name===t)return i.value;return null}return this.each((null==e?Ep:Dp)(r,t,e))}function Ip(t,e,r){var i=t._id;return t.each(function(){var t=Bp(this,i);(t.value||(t.value={}))[e]=r.apply(this,arguments)}),function(t){return Ap(t,i).value[e]}}function Np(t,e){var r;return("number"==typeof e?ws:e instanceof vo?ms:(r=vo(e))?(e=r,ms):Bs)(t,e)}function Rp(t){return function(){this.removeAttribute(t)}}function Pp(t){return function(){this.removeAttributeNS(t.space,t.local)}}function zp(t,e,r){var i,n,a=r+"";return function(){var o=this.getAttribute(t);return o===a?null:o===i?n:n=e(i=o,r)}}function qp(t,e,r){var i,n,a=r+"";return function(){var o=this.getAttributeNS(t.space,t.local);return o===a?null:o===i?n:n=e(i=o,r)}}function jp(t,e,r){var i,n,a;return function(){var o,s,l=r(this);return null==l?void this.removeAttribute(t):(o=this.getAttribute(t))===(s=l+"")?null:o===i&&s===n?a:(n=s,a=e(i=o,l))}}function Wp(t,e,r){var i,n,a;return function(){var o,s,l=r(this);return null==l?void this.removeAttributeNS(t.space,t.local):(o=this.getAttributeNS(t.space,t.local))===(s=l+"")?null:o===i&&s===n?a:(n=s,a=e(i=o,l))}}function Hp(t,e){var r=Hn(t),i="transform"===r?Ps:Np;return this.attrTween(t,"function"==typeof e?(r.local?Wp:jp)(r,i,Ip(this,"attr."+t,e)):null==e?(r.local?Pp:Rp)(r):(r.local?qp:zp)(r,i,e))}function Up(t,e){return function(r){this.setAttribute(t,e.call(this,r))}}function Yp(t,e){return function(r){this.setAttributeNS(t.space,t.local,e.call(this,r))}}function Vp(t,e){var r,i;function n(){var n=e.apply(this,arguments);return n!==i&&(r=(i=n)&&Yp(t,n)),r}return s(n,"tween"),n._value=e,n}function Gp(t,e){var r,i;function n(){var n=e.apply(this,arguments);return n!==i&&(r=(i=n)&&Up(t,n)),r}return s(n,"tween"),n._value=e,n}function Xp(t,e){var r="attr."+t;if(arguments.length<2)return(r=this.tween(r))&&r._value;if(null==e)return this.tween(r,null);if("function"!=typeof e)throw new Error;var i=Hn(t);return this.tween(r,(i.local?Vp:Gp)(i,e))}function Zp(t,e){return function(){Mp(this,t).delay=+e.apply(this,arguments)}}function Qp(t,e){return e=+e,function(){Mp(this,t).delay=e}}function Kp(t){var e=this._id;return arguments.length?this.each(("function"==typeof t?Zp:Qp)(e,t)):Ap(this.node(),e).delay}function Jp(t,e){return function(){Bp(this,t).duration=+e.apply(this,arguments)}}function tf(t,e){return e=+e,function(){Bp(this,t).duration=e}}function ef(t){var e=this._id;return arguments.length?this.each(("function"==typeof t?Jp:tf)(e,t)):Ap(this.node(),e).duration}function rf(t,e){if("function"!=typeof e)throw new Error;return function(){Bp(this,t).ease=e}}function nf(t){var e=this._id;return arguments.length?this.each(rf(e,t)):Ap(this.node(),e).ease}function af(t,e){return function(){var r=e.apply(this,arguments);if("function"!=typeof r)throw new Error;Bp(this,t).ease=r}}function of(t){if("function"!=typeof t)throw new Error;return this.each(af(this._id,t))}function sf(t){"function"!=typeof t&&(t=cn(t));for(var e=this._groups,r=e.length,i=new Array(r),n=0;n<r;++n)for(var a,o=e[n],s=o.length,l=i[n]=[],h=0;h<s;++h)(a=o[h])&&t.call(a,a.__data__,h,o)&&l.push(a);return new If(i,this._parents,this._name,this._id)}function lf(t){if(t._id!==this._id)throw new Error;for(var e=this._groups,r=t._groups,i=e.length,n=r.length,a=Math.min(i,n),o=new Array(i),s=0;s<a;++s)for(var l,h=e[s],c=r[s],u=h.length,d=o[s]=new Array(u),p=0;p<u;++p)(l=h[p]||c[p])&&(d[p]=l);for(;s<i;++s)o[s]=e[s];return new If(o,this._parents,this._name,this._id)}function hf(t){return(t+"").trim().split(/^|\s+/).every(function(t){var e=t.indexOf(".");return e>=0&&(t=t.slice(0,e)),!t||"start"===t})}function cf(t,e,r){var i,n,a=hf(e)?Mp:Bp;return function(){var o=a(this,t),s=o.on;s!==i&&(n=(i=s).copy()).on(e,r),o.on=n}}function uf(t,e){var r=this._id;return arguments.length<2?Ap(this.node(),r).on.on(t):this.each(cf(r,t,e))}function df(t){return function(){var e=this.parentNode;for(var r in this.__transition)if(+r!==t)return;e&&e.removeChild(this)}}function pf(){return this.on("end.remove",df(this._id))}function ff(t){var e=this._name,r=this._id;"function"!=typeof t&&(t=rn(t));for(var i=this._groups,n=i.length,a=new Array(n),o=0;o<n;++o)for(var s,l,h=i[o],c=h.length,u=a[o]=new Array(c),d=0;d<c;++d)(s=h[d])&&(l=t.call(s,s.__data__,d,h))&&("__data__"in s&&(l.__data__=s.__data__),u[d]=l,Tp(u[d],e,r,d,u,Ap(s,r)));return new If(a,this._parents,e,r)}function gf(t){var e=this._name,r=this._id;"function"!=typeof t&&(t=sn(t));for(var i=this._groups,n=i.length,a=[],o=[],s=0;s<n;++s)for(var l,h=i[s],c=h.length,u=0;u<c;++u)if(l=h[u]){for(var d,p=t.call(l,l.__data__,u,h),f=Ap(l,r),g=0,y=p.length;g<y;++g)(d=p[g])&&Tp(d,e,r,g,p,f);a.push(p),o.push(l)}return new If(a,o,e,r)}s(Tp,"default"),s(Mp,"init"),s(Bp,"set"),s(Ap,"get"),s(Fp,"create"),s(Lp,"default"),s($p,"default"),s(Ep,"tweenRemove"),s(Dp,"tweenFunction"),s(Op,"default"),s(Ip,"tweenValue"),s(Np,"default"),s(Rp,"attrRemove"),s(Pp,"attrRemoveNS"),s(zp,"attrConstant"),s(qp,"attrConstantNS"),s(jp,"attrFunction"),s(Wp,"attrFunctionNS"),s(Hp,"default"),s(Up,"attrInterpolate"),s(Yp,"attrInterpolateNS"),s(Vp,"attrTweenNS"),s(Gp,"attrTween"),s(Xp,"default"),s(Zp,"delayFunction"),s(Qp,"delayConstant"),s(Kp,"default"),s(Jp,"durationFunction"),s(tf,"durationConstant"),s(ef,"default"),s(rf,"easeConstant"),s(nf,"default"),s(af,"easeVarying"),s(of,"default"),s(sf,"default"),s(lf,"default"),s(hf,"start"),s(cf,"onFunction"),s(uf,"default"),s(df,"removeFunction"),s(pf,"default"),s(ff,"default"),s(gf,"default");var yf=eo.prototype.constructor;function mf(){return new yf(this._groups,this._parents)}function xf(t,e){var r,i,n;return function(){var a=ia(this,t),o=(this.style.removeProperty(t),ia(this,t));return a===o?null:a===r&&o===i?n:n=e(r=a,i=o)}}function bf(t){return function(){this.style.removeProperty(t)}}function Cf(t,e,r){var i,n,a=r+"";return function(){var o=ia(this,t);return o===a?null:o===i?n:n=e(i=o,r)}}function kf(t,e,r){var i,n,a;return function(){var o=ia(this,t),s=r(this),l=s+"";return null==s&&(this.style.removeProperty(t),l=s=ia(this,t)),o===l?null:o===i&&l===n?a:(n=l,a=e(i=o,s))}}function wf(t,e){var r,i,n,a,o="style."+e,s="end."+o;return function(){var l=Bp(this,t),h=l.on,c=null==l.value[o]?a||(a=bf(e)):void 0;(h!==r||n!==c)&&(i=(r=h).copy()).on(s,n=c),l.on=i}}function _f(t,e,r){var i="transform"==(t+="")?Rs:Np;return null==e?this.styleTween(t,xf(t,i)).on("end.style."+t,bf(t)):"function"==typeof e?this.styleTween(t,kf(t,i,Ip(this,"style."+t,e))).each(wf(this._id,t)):this.styleTween(t,Cf(t,i,e),r).on("end.style."+t,null)}function vf(t,e,r){return function(i){this.style.setProperty(t,e.call(this,i),r)}}function Sf(t,e,r){var i,n;function a(){var a=e.apply(this,arguments);return a!==n&&(i=(n=a)&&vf(t,a,r)),i}return s(a,"tween"),a._value=e,a}function Tf(t,e,r){var i="style."+(t+="");if(arguments.length<2)return(i=this.tween(i))&&i._value;if(null==e)return this.tween(i,null);if("function"!=typeof e)throw new Error;return this.tween(i,Sf(t,e,r??""))}function Mf(t){return function(){this.textContent=t}}function Bf(t){return function(){var e=t(this);this.textContent=e??""}}function Af(t){return this.tween("text","function"==typeof t?Bf(Ip(this,"text",t)):Mf(null==t?"":t+""))}function Ff(t){return function(e){this.textContent=t.call(this,e)}}function Lf(t){var e,r;function i(){var i=t.apply(this,arguments);return i!==r&&(e=(r=i)&&Ff(i)),e}return s(i,"tween"),i._value=t,i}function $f(t){var e="text";if(arguments.length<1)return(e=this.tween(e))&&e._value;if(null==t)return this.tween(e,null);if("function"!=typeof t)throw new Error;return this.tween(e,Lf(t))}function Ef(){for(var t=this._name,e=this._id,r=Rf(),i=this._groups,n=i.length,a=0;a<n;++a)for(var o,s=i[a],l=s.length,h=0;h<l;++h)if(o=s[h]){var c=Ap(o,e);Tp(o,t,r,h,s,{time:c.time+c.delay+c.duration,delay:0,duration:c.duration,ease:c.ease})}return new If(i,this._parents,t,r)}function Df(){var t,e,r=this,i=r._id,n=r.size();return new Promise(function(a,o){var l={value:o},h={value:s(function(){0===--n&&a()},"value")};r.each(function(){var r=Bp(this,i),n=r.on;n!==t&&((e=(t=n).copy())._.cancel.push(l),e._.interrupt.push(l),e._.end.push(h)),r.on=e}),0===n&&a()})}s(mf,"default"),s(xf,"styleNull"),s(bf,"styleRemove"),s(Cf,"styleConstant"),s(kf,"styleFunction"),s(wf,"styleMaybeRemove"),s(_f,"default"),s(vf,"styleInterpolate"),s(Sf,"styleTween"),s(Tf,"default"),s(Mf,"textConstant"),s(Bf,"textFunction"),s(Af,"default"),s(Ff,"textInterpolate"),s(Lf,"textTween"),s($f,"default"),s(Ef,"default"),s(Df,"default");var Of=0;function If(t,e,r,i){this._groups=t,this._parents=e,this._name=r,this._id=i}function Nf(t){return eo().transition(t)}function Rf(){return++Of}s(If,"Transition"),s(Nf,"transition"),s(Rf,"newId");var Pf=eo.prototype;function zf(t){return((t*=2)<=1?t*t*t:(t-=2)*t*t+2)/2}If.prototype=Nf.prototype={constructor:If,select:ff,selectAll:gf,selectChild:Pf.selectChild,selectChildren:Pf.selectChildren,filter:sf,merge:lf,selection:mf,transition:Ef,call:Pf.call,nodes:Pf.nodes,node:Pf.node,size:Pf.size,empty:Pf.empty,each:Pf.each,on:uf,attr:Hp,attrTween:Xp,style:_f,styleTween:Tf,text:Af,textTween:$f,remove:pf,tween:Op,delay:Kp,duration:ef,ease:nf,easeVarying:of,end:Df,[Symbol.iterator]:Pf[Symbol.iterator]},s(zf,"cubicInOut");var qf={time:null,delay:0,duration:250,ease:zf};function jf(t,e){for(var r;!(r=t.__transition)||!(r=r[e]);)if(!(t=t.parentNode))throw new Error(`transition ${e} not found`);return r}function Wf(t){var e,r;t instanceof If?(e=t._id,t=t._name):(e=Rf(),(r=qf).time=fp(),t=null==t?null:t+"");for(var i=this._groups,n=i.length,a=0;a<n;++a)for(var o,s=i[a],l=s.length,h=0;h<l;++h)(o=s[h])&&Tp(o,t,e,h,s,r||jf(o,e));return new If(i,this._parents,t,e)}function Hf(t){return[+t[0],+t[1]]}function Uf(t){return[Hf(t[0]),Hf(t[1])]}function Yf(t,e,r){this.k=t,this.x=e,this.y=r}s(jf,"inherit"),s(Wf,"default"),eo.prototype.interrupt=$p,eo.prototype.transition=Wf,s(Hf,"number1"),s(Uf,"number2"),s(function(t,e){return null==t?null:[[+t[0],e[0][1]],[+t[1],e[1][1]]]},"input"),s(function(t){return t&&[t[0][0],t[1][0]]},"output"),s(function(t,e){return null==t?null:[[e[0][0],+t[0]],[e[1][0],+t[1]]]},"input"),s(function(t){return t&&[t[0][1],t[1][1]]},"output"),s(function(t){return null==t?null:Uf(t)},"input"),s(function(t){return t},"output"),s(function(t){return{type:t}},"type"),s(Yf,"Transform"),Yf.prototype={constructor:Yf,scale:s(function(t){return 1===t?this:new Yf(this.k*t,this.x,this.y)},"scale"),translate:s(function(t,e){return 0===t&0===e?this:new Yf(this.k,this.x+this.k*t,this.y+this.k*e)},"translate"),apply:s(function(t){return[t[0]*this.k+this.x,t[1]*this.k+this.y]},"apply"),applyX:s(function(t){return t*this.k+this.x},"applyX"),applyY:s(function(t){return t*this.k+this.y},"applyY"),invert:s(function(t){return[(t[0]-this.x)/this.k,(t[1]-this.y)/this.k]},"invert"),invertX:s(function(t){return(t-this.x)/this.k},"invertX"),invertY:s(function(t){return(t-this.y)/this.k},"invertY"),rescaleX:s(function(t){return t.copy().domain(t.range().map(this.invertX,this).map(t.invert,t))},"rescaleX"),rescaleY:s(function(t){return t.copy().domain(t.range().map(this.invertY,this).map(t.invert,t))},"rescaleY"),toString:s(function(){return"translate("+this.x+","+this.y+") scale("+this.k+")"},"toString")};var Vf=new Yf(1,0,0);function Gf(t){for(;!t.__zoom;)if(!(t=t.parentNode))return Vf;return t.__zoom}Gf.prototype=Yf.prototype,s(Gf,"transform");
/*! Bundled license information:

dompurify/dist/purify.es.mjs:
  (*! @license DOMPurify 3.2.5 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.2.5/LICENSE *)
*/
var Xf=s(t=>{let{securityLevel:e}=di(),r=ro("body");if("sandbox"===e){let e=ro(`#i${t}`).node()?.contentDocument??document;r=ro(e.body)}return r.select(`#${t}`)},"selectSvgElement");function Zf(t){return typeof t>"u"||null===t}function Qf(t){return"object"==typeof t&&null!==t}function Kf(t){return Array.isArray(t)?t:Zf(t)?[]:[t]}function Jf(t,e){var r,i,n,a;if(e)for(r=0,i=(a=Object.keys(e)).length;r<i;r+=1)t[n=a[r]]=e[n];return t}function tg(t,e){var r,i="";for(r=0;r<e;r+=1)i+=t;return i}function eg(t){return 0===t&&Number.NEGATIVE_INFINITY===1/t}s(Zf,"isNothing"),s(Qf,"isObject"),s(Kf,"toArray"),s(Jf,"extend"),s(tg,"repeat"),s(eg,"isNegativeZero");var rg={isNothing:Zf,isObject:Qf,toArray:Kf,repeat:tg,isNegativeZero:eg,extend:Jf};function ig(t,e){var r="",i=t.reason||"(unknown reason)";return t.mark?(t.mark.name&&(r+='in "'+t.mark.name+'" '),r+="("+(t.mark.line+1)+":"+(t.mark.column+1)+")",!e&&t.mark.snippet&&(r+="\n\n"+t.mark.snippet),i+" "+r):i}function ng(t,e){Error.call(this),this.name="YAMLException",this.reason=t,this.mark=e,this.message=ig(this,!1),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=(new Error).stack||""}s(ig,"formatError"),s(ng,"YAMLException$1"),ng.prototype=Object.create(Error.prototype),ng.prototype.constructor=ng,ng.prototype.toString=s(function(t){return this.name+": "+ig(this,t)},"toString");var ag=ng;function og(t,e,r,i,n){var a="",o="",s=Math.floor(n/2)-1;return i-e>s&&(e=i-s+(a=" ... ").length),r-i>s&&(r=i+s-(o=" ...").length),{str:a+t.slice(e,r).replace(/\t/g,"→")+o,pos:i-e+a.length}}function sg(t,e){return rg.repeat(" ",e-t.length)+t}function lg(t,e){if(e=Object.create(e||null),!t.buffer)return null;e.maxLength||(e.maxLength=79),"number"!=typeof e.indent&&(e.indent=1),"number"!=typeof e.linesBefore&&(e.linesBefore=3),"number"!=typeof e.linesAfter&&(e.linesAfter=2);for(var r,i=/\r?\n|\r|\0/g,n=[0],a=[],o=-1;r=i.exec(t.buffer);)a.push(r.index),n.push(r.index+r[0].length),t.position<=r.index&&o<0&&(o=n.length-2);o<0&&(o=n.length-1);var s,l,h="",c=Math.min(t.line+e.linesAfter,a.length).toString().length,u=e.maxLength-(e.indent+c+3);for(s=1;s<=e.linesBefore&&!(o-s<0);s++)l=og(t.buffer,n[o-s],a[o-s],t.position-(n[o]-n[o-s]),u),h=rg.repeat(" ",e.indent)+sg((t.line-s+1).toString(),c)+" | "+l.str+"\n"+h;for(l=og(t.buffer,n[o],a[o],t.position,u),h+=rg.repeat(" ",e.indent)+sg((t.line+1).toString(),c)+" | "+l.str+"\n",h+=rg.repeat("-",e.indent+c+3+l.pos)+"^\n",s=1;s<=e.linesAfter&&!(o+s>=a.length);s++)l=og(t.buffer,n[o+s],a[o+s],t.position-(n[o]-n[o+s]),u),h+=rg.repeat(" ",e.indent)+sg((t.line+s+1).toString(),c)+" | "+l.str+"\n";return h.replace(/\n$/,"")}s(og,"getLine"),s(sg,"padStart"),s(lg,"makeSnippet");var hg=lg,cg=["kind","multi","resolve","construct","instanceOf","predicate","represent","representName","defaultStyle","styleAliases"],ug=["scalar","sequence","mapping"];function dg(t){var e={};return null!==t&&Object.keys(t).forEach(function(r){t[r].forEach(function(t){e[String(t)]=r})}),e}function pg(t,e){if(e=e||{},Object.keys(e).forEach(function(e){if(-1===cg.indexOf(e))throw new ag('Unknown option "'+e+'" is met in definition of "'+t+'" YAML type.')}),this.options=e,this.tag=t,this.kind=e.kind||null,this.resolve=e.resolve||function(){return!0},this.construct=e.construct||function(t){return t},this.instanceOf=e.instanceOf||null,this.predicate=e.predicate||null,this.represent=e.represent||null,this.representName=e.representName||null,this.defaultStyle=e.defaultStyle||null,this.multi=e.multi||!1,this.styleAliases=dg(e.styleAliases||null),-1===ug.indexOf(this.kind))throw new ag('Unknown kind "'+this.kind+'" is specified for "'+t+'" YAML type.')}s(dg,"compileStyleAliases"),s(pg,"Type$1");var fg=pg;function gg(t,e){var r=[];return t[e].forEach(function(t){var e=r.length;r.forEach(function(r,i){r.tag===t.tag&&r.kind===t.kind&&r.multi===t.multi&&(e=i)}),r[e]=t}),r}function yg(){var t,e,r={scalar:{},sequence:{},mapping:{},fallback:{},multi:{scalar:[],sequence:[],mapping:[],fallback:[]}};function i(t){t.multi?(r.multi[t.kind].push(t),r.multi.fallback.push(t)):r[t.kind][t.tag]=r.fallback[t.tag]=t}for(s(i,"collectType"),t=0,e=arguments.length;t<e;t+=1)arguments[t].forEach(i);return r}function mg(t){return this.extend(t)}s(gg,"compileList"),s(yg,"compileMap"),s(mg,"Schema$1"),mg.prototype.extend=s(function(t){var e=[],r=[];if(t instanceof fg)r.push(t);else if(Array.isArray(t))r=r.concat(t);else{if(!t||!Array.isArray(t.implicit)&&!Array.isArray(t.explicit))throw new ag("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");t.implicit&&(e=e.concat(t.implicit)),t.explicit&&(r=r.concat(t.explicit))}e.forEach(function(t){if(!(t instanceof fg))throw new ag("Specified list of YAML types (or a single Type object) contains a non-Type object.");if(t.loadKind&&"scalar"!==t.loadKind)throw new ag("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");if(t.multi)throw new ag("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.")}),r.forEach(function(t){if(!(t instanceof fg))throw new ag("Specified list of YAML types (or a single Type object) contains a non-Type object.")});var i=Object.create(mg.prototype);return i.implicit=(this.implicit||[]).concat(e),i.explicit=(this.explicit||[]).concat(r),i.compiledImplicit=gg(i,"implicit"),i.compiledExplicit=gg(i,"explicit"),i.compiledTypeMap=yg(i.compiledImplicit,i.compiledExplicit),i},"extend");var xg=mg,bg=new fg("tag:yaml.org,2002:str",{kind:"scalar",construct:s(function(t){return null!==t?t:""},"construct")}),Cg=new fg("tag:yaml.org,2002:seq",{kind:"sequence",construct:s(function(t){return null!==t?t:[]},"construct")}),kg=new fg("tag:yaml.org,2002:map",{kind:"mapping",construct:s(function(t){return null!==t?t:{}},"construct")}),wg=new xg({explicit:[bg,Cg,kg]});function _g(t){if(null===t)return!0;var e=t.length;return 1===e&&"~"===t||4===e&&("null"===t||"Null"===t||"NULL"===t)}function vg(){return null}function Sg(t){return null===t}s(_g,"resolveYamlNull"),s(vg,"constructYamlNull"),s(Sg,"isNull");var Tg=new fg("tag:yaml.org,2002:null",{kind:"scalar",resolve:_g,construct:vg,predicate:Sg,represent:{canonical:s(function(){return"~"},"canonical"),lowercase:s(function(){return"null"},"lowercase"),uppercase:s(function(){return"NULL"},"uppercase"),camelcase:s(function(){return"Null"},"camelcase"),empty:s(function(){return""},"empty")},defaultStyle:"lowercase"});function Mg(t){if(null===t)return!1;var e=t.length;return 4===e&&("true"===t||"True"===t||"TRUE"===t)||5===e&&("false"===t||"False"===t||"FALSE"===t)}function Bg(t){return"true"===t||"True"===t||"TRUE"===t}function Ag(t){return"[object Boolean]"===Object.prototype.toString.call(t)}s(Mg,"resolveYamlBoolean"),s(Bg,"constructYamlBoolean"),s(Ag,"isBoolean");var Fg=new fg("tag:yaml.org,2002:bool",{kind:"scalar",resolve:Mg,construct:Bg,predicate:Ag,represent:{lowercase:s(function(t){return t?"true":"false"},"lowercase"),uppercase:s(function(t){return t?"TRUE":"FALSE"},"uppercase"),camelcase:s(function(t){return t?"True":"False"},"camelcase")},defaultStyle:"lowercase"});function Lg(t){return 48<=t&&t<=57||65<=t&&t<=70||97<=t&&t<=102}function $g(t){return 48<=t&&t<=55}function Eg(t){return 48<=t&&t<=57}function Dg(t){if(null===t)return!1;var e,r=t.length,i=0,n=!1;if(!r)return!1;if(("-"===(e=t[i])||"+"===e)&&(e=t[++i]),"0"===e){if(i+1===r)return!0;if("b"===(e=t[++i])){for(i++;i<r;i++)if("_"!==(e=t[i])){if("0"!==e&&"1"!==e)return!1;n=!0}return n&&"_"!==e}if("x"===e){for(i++;i<r;i++)if("_"!==(e=t[i])){if(!Lg(t.charCodeAt(i)))return!1;n=!0}return n&&"_"!==e}if("o"===e){for(i++;i<r;i++)if("_"!==(e=t[i])){if(!$g(t.charCodeAt(i)))return!1;n=!0}return n&&"_"!==e}}if("_"===e)return!1;for(;i<r;i++)if("_"!==(e=t[i])){if(!Eg(t.charCodeAt(i)))return!1;n=!0}return!(!n||"_"===e)}function Og(t){var e,r=t,i=1;if(-1!==r.indexOf("_")&&(r=r.replace(/_/g,"")),("-"===(e=r[0])||"+"===e)&&("-"===e&&(i=-1),e=(r=r.slice(1))[0]),"0"===r)return 0;if("0"===e){if("b"===r[1])return i*parseInt(r.slice(2),2);if("x"===r[1])return i*parseInt(r.slice(2),16);if("o"===r[1])return i*parseInt(r.slice(2),8)}return i*parseInt(r,10)}function Ig(t){return"[object Number]"===Object.prototype.toString.call(t)&&t%1==0&&!rg.isNegativeZero(t)}s(Lg,"isHexCode"),s($g,"isOctCode"),s(Eg,"isDecCode"),s(Dg,"resolveYamlInteger"),s(Og,"constructYamlInteger"),s(Ig,"isInteger");var Ng=new fg("tag:yaml.org,2002:int",{kind:"scalar",resolve:Dg,construct:Og,predicate:Ig,represent:{binary:s(function(t){return t>=0?"0b"+t.toString(2):"-0b"+t.toString(2).slice(1)},"binary"),octal:s(function(t){return t>=0?"0o"+t.toString(8):"-0o"+t.toString(8).slice(1)},"octal"),decimal:s(function(t){return t.toString(10)},"decimal"),hexadecimal:s(function(t){return t>=0?"0x"+t.toString(16).toUpperCase():"-0x"+t.toString(16).toUpperCase().slice(1)},"hexadecimal")},defaultStyle:"decimal",styleAliases:{binary:[2,"bin"],octal:[8,"oct"],decimal:[10,"dec"],hexadecimal:[16,"hex"]}}),Rg=new RegExp("^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");function Pg(t){return!(null===t||!Rg.test(t)||"_"===t[t.length-1])}function zg(t){var e,r;return r="-"===(e=t.replace(/_/g,"").toLowerCase())[0]?-1:1,"+-".indexOf(e[0])>=0&&(e=e.slice(1)),".inf"===e?1===r?Number.POSITIVE_INFINITY:Number.NEGATIVE_INFINITY:".nan"===e?NaN:r*parseFloat(e,10)}s(Pg,"resolveYamlFloat"),s(zg,"constructYamlFloat");var qg=/^[-+]?[0-9]+e/;function jg(t,e){var r;if(isNaN(t))switch(e){case"lowercase":return".nan";case"uppercase":return".NAN";case"camelcase":return".NaN"}else if(Number.POSITIVE_INFINITY===t)switch(e){case"lowercase":return".inf";case"uppercase":return".INF";case"camelcase":return".Inf"}else if(Number.NEGATIVE_INFINITY===t)switch(e){case"lowercase":return"-.inf";case"uppercase":return"-.INF";case"camelcase":return"-.Inf"}else if(rg.isNegativeZero(t))return"-0.0";return r=t.toString(10),qg.test(r)?r.replace("e",".e"):r}function Wg(t){return"[object Number]"===Object.prototype.toString.call(t)&&(t%1!=0||rg.isNegativeZero(t))}s(jg,"representYamlFloat"),s(Wg,"isFloat");var Hg=new fg("tag:yaml.org,2002:float",{kind:"scalar",resolve:Pg,construct:zg,predicate:Wg,represent:jg,defaultStyle:"lowercase"}),Ug=wg.extend({implicit:[Tg,Fg,Ng,Hg]}),Yg=Ug,Vg=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"),Gg=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$");function Xg(t){return null!==t&&(null!==Vg.exec(t)||null!==Gg.exec(t))}function Zg(t){var e,r,i,n,a,o,s,l,h=0,c=null;if(null===(e=Vg.exec(t))&&(e=Gg.exec(t)),null===e)throw new Error("Date resolve error");if(r=+e[1],i=+e[2]-1,n=+e[3],!e[4])return new Date(Date.UTC(r,i,n));if(a=+e[4],o=+e[5],s=+e[6],e[7]){for(h=e[7].slice(0,3);h.length<3;)h+="0";h=+h}return e[9]&&(c=6e4*(60*+e[10]+ +(e[11]||0)),"-"===e[9]&&(c=-c)),l=new Date(Date.UTC(r,i,n,a,o,s,h)),c&&l.setTime(l.getTime()-c),l}function Qg(t){return t.toISOString()}s(Xg,"resolveYamlTimestamp"),s(Zg,"constructYamlTimestamp"),s(Qg,"representYamlTimestamp");var Kg=new fg("tag:yaml.org,2002:timestamp",{kind:"scalar",resolve:Xg,construct:Zg,instanceOf:Date,represent:Qg});function Jg(t){return"<<"===t||null===t}s(Jg,"resolveYamlMerge");var ty=new fg("tag:yaml.org,2002:merge",{kind:"scalar",resolve:Jg}),ey="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";function ry(t){if(null===t)return!1;var e,r,i=0,n=t.length,a=ey;for(r=0;r<n;r++)if(!((e=a.indexOf(t.charAt(r)))>64)){if(e<0)return!1;i+=6}return i%8==0}function iy(t){var e,r,i=t.replace(/[\r\n=]/g,""),n=i.length,a=ey,o=0,s=[];for(e=0;e<n;e++)e%4==0&&e&&(s.push(o>>16&255),s.push(o>>8&255),s.push(255&o)),o=o<<6|a.indexOf(i.charAt(e));return 0===(r=n%4*6)?(s.push(o>>16&255),s.push(o>>8&255),s.push(255&o)):18===r?(s.push(o>>10&255),s.push(o>>2&255)):12===r&&s.push(o>>4&255),new Uint8Array(s)}function ny(t){var e,r,i="",n=0,a=t.length,o=ey;for(e=0;e<a;e++)e%3==0&&e&&(i+=o[n>>18&63],i+=o[n>>12&63],i+=o[n>>6&63],i+=o[63&n]),n=(n<<8)+t[e];return 0===(r=a%3)?(i+=o[n>>18&63],i+=o[n>>12&63],i+=o[n>>6&63],i+=o[63&n]):2===r?(i+=o[n>>10&63],i+=o[n>>4&63],i+=o[n<<2&63],i+=o[64]):1===r&&(i+=o[n>>2&63],i+=o[n<<4&63],i+=o[64],i+=o[64]),i}function ay(t){return"[object Uint8Array]"===Object.prototype.toString.call(t)}s(ry,"resolveYamlBinary"),s(iy,"constructYamlBinary"),s(ny,"representYamlBinary"),s(ay,"isBinary");var oy=new fg("tag:yaml.org,2002:binary",{kind:"scalar",resolve:ry,construct:iy,predicate:ay,represent:ny}),sy=Object.prototype.hasOwnProperty,ly=Object.prototype.toString;function hy(t){if(null===t)return!0;var e,r,i,n,a,o=[],s=t;for(e=0,r=s.length;e<r;e+=1){if(i=s[e],a=!1,"[object Object]"!==ly.call(i))return!1;for(n in i)if(sy.call(i,n)){if(a)return!1;a=!0}if(!a)return!1;if(-1!==o.indexOf(n))return!1;o.push(n)}return!0}function cy(t){return null!==t?t:[]}s(hy,"resolveYamlOmap"),s(cy,"constructYamlOmap");var uy=new fg("tag:yaml.org,2002:omap",{kind:"sequence",resolve:hy,construct:cy}),dy=Object.prototype.toString;function py(t){if(null===t)return!0;var e,r,i,n,a,o=t;for(a=new Array(o.length),e=0,r=o.length;e<r;e+=1){if(i=o[e],"[object Object]"!==dy.call(i)||1!==(n=Object.keys(i)).length)return!1;a[e]=[n[0],i[n[0]]]}return!0}function fy(t){if(null===t)return[];var e,r,i,n,a,o=t;for(a=new Array(o.length),e=0,r=o.length;e<r;e+=1)i=o[e],n=Object.keys(i),a[e]=[n[0],i[n[0]]];return a}s(py,"resolveYamlPairs"),s(fy,"constructYamlPairs");var gy=new fg("tag:yaml.org,2002:pairs",{kind:"sequence",resolve:py,construct:fy}),yy=Object.prototype.hasOwnProperty;function my(t){if(null===t)return!0;var e,r=t;for(e in r)if(yy.call(r,e)&&null!==r[e])return!1;return!0}function xy(t){return null!==t?t:{}}s(my,"resolveYamlSet"),s(xy,"constructYamlSet");var by=new fg("tag:yaml.org,2002:set",{kind:"mapping",resolve:my,construct:xy}),Cy=Yg.extend({implicit:[Kg,ty],explicit:[oy,uy,gy,by]}),ky=Object.prototype.hasOwnProperty,wy=/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/,_y=/[\x85\u2028\u2029]/,vy=/[,\[\]\{\}]/,Sy=/^(?:!|!!|![a-z\-]+!)$/i,Ty=/^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;function My(t){return Object.prototype.toString.call(t)}function By(t){return 10===t||13===t}function Ay(t){return 9===t||32===t}function Fy(t){return 9===t||32===t||10===t||13===t}function Ly(t){return 44===t||91===t||93===t||123===t||125===t}function $y(t){var e;return 48<=t&&t<=57?t-48:97<=(e=32|t)&&e<=102?e-97+10:-1}function Ey(t){return 120===t?2:117===t?4:85===t?8:0}function Dy(t){return 48<=t&&t<=57?t-48:-1}function Oy(t){return 48===t?"\0":97===t?"":98===t?"\b":116===t||9===t?"\t":110===t?"\n":118===t?"\v":102===t?"\f":114===t?"\r":101===t?"":32===t?" ":34===t?'"':47===t?"/":92===t?"\\":78===t?"":95===t?" ":76===t?"\u2028":80===t?"\u2029":""}function Iy(t){return t<=65535?String.fromCharCode(t):String.fromCharCode(55296+(t-65536>>10),56320+(t-65536&1023))}s(My,"_class"),s(By,"is_EOL"),s(Ay,"is_WHITE_SPACE"),s(Fy,"is_WS_OR_EOL"),s(Ly,"is_FLOW_INDICATOR"),s($y,"fromHexCode"),s(Ey,"escapedHexLen"),s(Dy,"fromDecimalCode"),s(Oy,"simpleEscapeSequence"),s(Iy,"charFromCodepoint");var Ny,Ry=new Array(256),Py=new Array(256);for(Ny=0;Ny<256;Ny++)Ry[Ny]=Oy(Ny)?1:0,Py[Ny]=Oy(Ny);function zy(t,e){this.input=t,this.filename=e.filename||null,this.schema=e.schema||Cy,this.onWarning=e.onWarning||null,this.legacy=e.legacy||!1,this.json=e.json||!1,this.listener=e.listener||null,this.implicitTypes=this.schema.compiledImplicit,this.typeMap=this.schema.compiledTypeMap,this.length=t.length,this.position=0,this.line=0,this.lineStart=0,this.lineIndent=0,this.firstTabInLine=-1,this.documents=[]}function qy(t,e){var r={name:t.filename,buffer:t.input.slice(0,-1),position:t.position,line:t.line,column:t.position-t.lineStart};return r.snippet=hg(r),new ag(e,r)}function jy(t,e){throw qy(t,e)}function Wy(t,e){t.onWarning&&t.onWarning.call(null,qy(t,e))}s(zy,"State$1"),s(qy,"generateError"),s(jy,"throwError"),s(Wy,"throwWarning");var Hy={YAML:s(function(t,e,r){var i,n,a;null!==t.version&&jy(t,"duplication of %YAML directive"),1!==r.length&&jy(t,"YAML directive accepts exactly one argument"),null===(i=/^([0-9]+)\.([0-9]+)$/.exec(r[0]))&&jy(t,"ill-formed argument of the YAML directive"),n=parseInt(i[1],10),a=parseInt(i[2],10),1!==n&&jy(t,"unacceptable YAML version of the document"),t.version=r[0],t.checkLineBreaks=a<2,1!==a&&2!==a&&Wy(t,"unsupported YAML version of the document")},"handleYamlDirective"),TAG:s(function(t,e,r){var i,n;2!==r.length&&jy(t,"TAG directive accepts exactly two arguments"),i=r[0],n=r[1],Sy.test(i)||jy(t,"ill-formed tag handle (first argument) of the TAG directive"),ky.call(t.tagMap,i)&&jy(t,'there is a previously declared suffix for "'+i+'" tag handle'),Ty.test(n)||jy(t,"ill-formed tag prefix (second argument) of the TAG directive");try{n=decodeURIComponent(n)}catch{jy(t,"tag prefix is malformed: "+n)}t.tagMap[i]=n},"handleTagDirective")};function Uy(t,e,r,i){var n,a,o,s;if(e<r){if(s=t.input.slice(e,r),i)for(n=0,a=s.length;n<a;n+=1)9===(o=s.charCodeAt(n))||32<=o&&o<=1114111||jy(t,"expected valid JSON character");else wy.test(s)&&jy(t,"the stream contains non-printable characters");t.result+=s}}function Yy(t,e,r,i){var n,a,o,s;for(rg.isObject(r)||jy(t,"cannot merge mappings; the provided source object is unacceptable"),o=0,s=(n=Object.keys(r)).length;o<s;o+=1)a=n[o],ky.call(e,a)||(e[a]=r[a],i[a]=!0)}function Vy(t,e,r,i,n,a,o,s,l){var h,c;if(Array.isArray(n))for(h=0,c=(n=Array.prototype.slice.call(n)).length;h<c;h+=1)Array.isArray(n[h])&&jy(t,"nested arrays are not supported inside keys"),"object"==typeof n&&"[object Object]"===My(n[h])&&(n[h]="[object Object]");if("object"==typeof n&&"[object Object]"===My(n)&&(n="[object Object]"),n=String(n),null===e&&(e={}),"tag:yaml.org,2002:merge"===i)if(Array.isArray(a))for(h=0,c=a.length;h<c;h+=1)Yy(t,e,a[h],r);else Yy(t,e,a,r);else!t.json&&!ky.call(r,n)&&ky.call(e,n)&&(t.line=o||t.line,t.lineStart=s||t.lineStart,t.position=l||t.position,jy(t,"duplicated mapping key")),"__proto__"===n?Object.defineProperty(e,n,{configurable:!0,enumerable:!0,writable:!0,value:a}):e[n]=a,delete r[n];return e}function Gy(t){var e;10===(e=t.input.charCodeAt(t.position))?t.position++:13===e?(t.position++,10===t.input.charCodeAt(t.position)&&t.position++):jy(t,"a line break is expected"),t.line+=1,t.lineStart=t.position,t.firstTabInLine=-1}function Xy(t,e,r){for(var i=0,n=t.input.charCodeAt(t.position);0!==n;){for(;Ay(n);)9===n&&-1===t.firstTabInLine&&(t.firstTabInLine=t.position),n=t.input.charCodeAt(++t.position);if(e&&35===n)do{n=t.input.charCodeAt(++t.position)}while(10!==n&&13!==n&&0!==n);if(!By(n))break;for(Gy(t),n=t.input.charCodeAt(t.position),i++,t.lineIndent=0;32===n;)t.lineIndent++,n=t.input.charCodeAt(++t.position)}return-1!==r&&0!==i&&t.lineIndent<r&&Wy(t,"deficient indentation"),i}function Zy(t){var e,r=t.position;return!(45!==(e=t.input.charCodeAt(r))&&46!==e||e!==t.input.charCodeAt(r+1)||e!==t.input.charCodeAt(r+2)||(r+=3,e=t.input.charCodeAt(r),0!==e&&!Fy(e)))}function Qy(t,e){1===e?t.result+=" ":e>1&&(t.result+=rg.repeat("\n",e-1))}function Ky(t,e,r){var i,n,a,o,s,l,h,c,u=t.kind,d=t.result;if(Fy(c=t.input.charCodeAt(t.position))||Ly(c)||35===c||38===c||42===c||33===c||124===c||62===c||39===c||34===c||37===c||64===c||96===c||(63===c||45===c)&&(Fy(i=t.input.charCodeAt(t.position+1))||r&&Ly(i)))return!1;for(t.kind="scalar",t.result="",n=a=t.position,o=!1;0!==c;){if(58===c){if(Fy(i=t.input.charCodeAt(t.position+1))||r&&Ly(i))break}else if(35===c){if(Fy(t.input.charCodeAt(t.position-1)))break}else{if(t.position===t.lineStart&&Zy(t)||r&&Ly(c))break;if(By(c)){if(s=t.line,l=t.lineStart,h=t.lineIndent,Xy(t,!1,-1),t.lineIndent>=e){o=!0,c=t.input.charCodeAt(t.position);continue}t.position=a,t.line=s,t.lineStart=l,t.lineIndent=h;break}}o&&(Uy(t,n,a,!1),Qy(t,t.line-s),n=a=t.position,o=!1),Ay(c)||(a=t.position+1),c=t.input.charCodeAt(++t.position)}return Uy(t,n,a,!1),!!t.result||(t.kind=u,t.result=d,!1)}function Jy(t,e){var r,i,n;if(39!==(r=t.input.charCodeAt(t.position)))return!1;for(t.kind="scalar",t.result="",t.position++,i=n=t.position;0!==(r=t.input.charCodeAt(t.position));)if(39===r){if(Uy(t,i,t.position,!0),39!==(r=t.input.charCodeAt(++t.position)))return!0;i=t.position,t.position++,n=t.position}else By(r)?(Uy(t,i,n,!0),Qy(t,Xy(t,!1,e)),i=n=t.position):t.position===t.lineStart&&Zy(t)?jy(t,"unexpected end of the document within a single quoted scalar"):(t.position++,n=t.position);jy(t,"unexpected end of the stream within a single quoted scalar")}function tm(t,e){var r,i,n,a,o,s;if(34!==(s=t.input.charCodeAt(t.position)))return!1;for(t.kind="scalar",t.result="",t.position++,r=i=t.position;0!==(s=t.input.charCodeAt(t.position));){if(34===s)return Uy(t,r,t.position,!0),t.position++,!0;if(92===s){if(Uy(t,r,t.position,!0),By(s=t.input.charCodeAt(++t.position)))Xy(t,!1,e);else if(s<256&&Ry[s])t.result+=Py[s],t.position++;else if((o=Ey(s))>0){for(n=o,a=0;n>0;n--)(o=$y(s=t.input.charCodeAt(++t.position)))>=0?a=(a<<4)+o:jy(t,"expected hexadecimal character");t.result+=Iy(a),t.position++}else jy(t,"unknown escape sequence");r=i=t.position}else By(s)?(Uy(t,r,i,!0),Qy(t,Xy(t,!1,e)),r=i=t.position):t.position===t.lineStart&&Zy(t)?jy(t,"unexpected end of the document within a double quoted scalar"):(t.position++,i=t.position)}jy(t,"unexpected end of the stream within a double quoted scalar")}function em(t,e){var r,i,n,a,o,s,l,h,c,u,d,p,f=!0,g=t.tag,y=t.anchor,m=Object.create(null);if(91===(p=t.input.charCodeAt(t.position)))o=93,h=!1,a=[];else{if(123!==p)return!1;o=125,h=!0,a={}}for(null!==t.anchor&&(t.anchorMap[t.anchor]=a),p=t.input.charCodeAt(++t.position);0!==p;){if(Xy(t,!0,e),(p=t.input.charCodeAt(t.position))===o)return t.position++,t.tag=g,t.anchor=y,t.kind=h?"mapping":"sequence",t.result=a,!0;f?44===p&&jy(t,"expected the node content, but found ','"):jy(t,"missed comma between flow collection entries"),d=null,s=l=!1,63===p&&(Fy(t.input.charCodeAt(t.position+1))&&(s=l=!0,t.position++,Xy(t,!0,e))),r=t.line,i=t.lineStart,n=t.position,lm(t,e,1,!1,!0),u=t.tag,c=t.result,Xy(t,!0,e),p=t.input.charCodeAt(t.position),(l||t.line===r)&&58===p&&(s=!0,p=t.input.charCodeAt(++t.position),Xy(t,!0,e),lm(t,e,1,!1,!0),d=t.result),h?Vy(t,a,m,u,c,d,r,i,n):s?a.push(Vy(t,null,m,u,c,d,r,i,n)):a.push(c),Xy(t,!0,e),44===(p=t.input.charCodeAt(t.position))?(f=!0,p=t.input.charCodeAt(++t.position)):f=!1}jy(t,"unexpected end of the stream within a flow collection")}function rm(t,e){var r,i,n,a,o=1,s=!1,l=!1,h=e,c=0,u=!1;if(124===(a=t.input.charCodeAt(t.position)))i=!1;else{if(62!==a)return!1;i=!0}for(t.kind="scalar",t.result="";0!==a;)if(43===(a=t.input.charCodeAt(++t.position))||45===a)1===o?o=43===a?3:2:jy(t,"repeat of a chomping mode identifier");else{if(!((n=Dy(a))>=0))break;0===n?jy(t,"bad explicit indentation width of a block scalar; it cannot be less than one"):l?jy(t,"repeat of an indentation width identifier"):(h=e+n-1,l=!0)}if(Ay(a)){do{a=t.input.charCodeAt(++t.position)}while(Ay(a));if(35===a)do{a=t.input.charCodeAt(++t.position)}while(!By(a)&&0!==a)}for(;0!==a;){for(Gy(t),t.lineIndent=0,a=t.input.charCodeAt(t.position);(!l||t.lineIndent<h)&&32===a;)t.lineIndent++,a=t.input.charCodeAt(++t.position);if(!l&&t.lineIndent>h&&(h=t.lineIndent),By(a))c++;else{if(t.lineIndent<h){3===o?t.result+=rg.repeat("\n",s?1+c:c):1===o&&s&&(t.result+="\n");break}for(i?Ay(a)?(u=!0,t.result+=rg.repeat("\n",s?1+c:c)):u?(u=!1,t.result+=rg.repeat("\n",c+1)):0===c?s&&(t.result+=" "):t.result+=rg.repeat("\n",c):t.result+=rg.repeat("\n",s?1+c:c),s=!0,l=!0,c=0,r=t.position;!By(a)&&0!==a;)a=t.input.charCodeAt(++t.position);Uy(t,r,t.position,!1)}}return!0}function im(t,e){var r,i,n=t.tag,a=t.anchor,o=[],s=!1;if(-1!==t.firstTabInLine)return!1;for(null!==t.anchor&&(t.anchorMap[t.anchor]=o),i=t.input.charCodeAt(t.position);0!==i&&(-1!==t.firstTabInLine&&(t.position=t.firstTabInLine,jy(t,"tab characters must not be used in indentation")),45===i&&Fy(t.input.charCodeAt(t.position+1)));)if(s=!0,t.position++,Xy(t,!0,-1)&&t.lineIndent<=e)o.push(null),i=t.input.charCodeAt(t.position);else if(r=t.line,lm(t,e,3,!1,!0),o.push(t.result),Xy(t,!0,-1),i=t.input.charCodeAt(t.position),(t.line===r||t.lineIndent>e)&&0!==i)jy(t,"bad indentation of a sequence entry");else if(t.lineIndent<e)break;return!!s&&(t.tag=n,t.anchor=a,t.kind="sequence",t.result=o,!0)}function nm(t,e,r){var i,n,a,o,s,l,h,c=t.tag,u=t.anchor,d={},p=Object.create(null),f=null,g=null,y=null,m=!1,x=!1;if(-1!==t.firstTabInLine)return!1;for(null!==t.anchor&&(t.anchorMap[t.anchor]=d),h=t.input.charCodeAt(t.position);0!==h;){if(!m&&-1!==t.firstTabInLine&&(t.position=t.firstTabInLine,jy(t,"tab characters must not be used in indentation")),i=t.input.charCodeAt(t.position+1),a=t.line,63!==h&&58!==h||!Fy(i)){if(o=t.line,s=t.lineStart,l=t.position,!lm(t,r,2,!1,!0))break;if(t.line===a){for(h=t.input.charCodeAt(t.position);Ay(h);)h=t.input.charCodeAt(++t.position);if(58===h)Fy(h=t.input.charCodeAt(++t.position))||jy(t,"a whitespace character is expected after the key-value separator within a block mapping"),m&&(Vy(t,d,p,f,g,null,o,s,l),f=g=y=null),x=!0,m=!1,n=!1,f=t.tag,g=t.result;else{if(!x)return t.tag=c,t.anchor=u,!0;jy(t,"can not read an implicit mapping pair; a colon is missed")}}else{if(!x)return t.tag=c,t.anchor=u,!0;jy(t,"can not read a block mapping entry; a multiline key may not be an implicit key")}}else 63===h?(m&&(Vy(t,d,p,f,g,null,o,s,l),f=g=y=null),x=!0,m=!0,n=!0):m?(m=!1,n=!0):jy(t,"incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line"),t.position+=1,h=i;if((t.line===a||t.lineIndent>e)&&(m&&(o=t.line,s=t.lineStart,l=t.position),lm(t,e,4,!0,n)&&(m?g=t.result:y=t.result),m||(Vy(t,d,p,f,g,y,o,s,l),f=g=y=null),Xy(t,!0,-1),h=t.input.charCodeAt(t.position)),(t.line===a||t.lineIndent>e)&&0!==h)jy(t,"bad indentation of a mapping entry");else if(t.lineIndent<e)break}return m&&Vy(t,d,p,f,g,null,o,s,l),x&&(t.tag=c,t.anchor=u,t.kind="mapping",t.result=d),x}function am(t){var e,r,i,n,a=!1,o=!1;if(33!==(n=t.input.charCodeAt(t.position)))return!1;if(null!==t.tag&&jy(t,"duplication of a tag property"),60===(n=t.input.charCodeAt(++t.position))?(a=!0,n=t.input.charCodeAt(++t.position)):33===n?(o=!0,r="!!",n=t.input.charCodeAt(++t.position)):r="!",e=t.position,a){do{n=t.input.charCodeAt(++t.position)}while(0!==n&&62!==n);t.position<t.length?(i=t.input.slice(e,t.position),n=t.input.charCodeAt(++t.position)):jy(t,"unexpected end of the stream within a verbatim tag")}else{for(;0!==n&&!Fy(n);)33===n&&(o?jy(t,"tag suffix cannot contain exclamation marks"):(r=t.input.slice(e-1,t.position+1),Sy.test(r)||jy(t,"named tag handle cannot contain such characters"),o=!0,e=t.position+1)),n=t.input.charCodeAt(++t.position);i=t.input.slice(e,t.position),vy.test(i)&&jy(t,"tag suffix cannot contain flow indicator characters")}i&&!Ty.test(i)&&jy(t,"tag name cannot contain such characters: "+i);try{i=decodeURIComponent(i)}catch{jy(t,"tag name is malformed: "+i)}return a?t.tag=i:ky.call(t.tagMap,r)?t.tag=t.tagMap[r]+i:"!"===r?t.tag="!"+i:"!!"===r?t.tag="tag:yaml.org,2002:"+i:jy(t,'undeclared tag handle "'+r+'"'),!0}function om(t){var e,r;if(38!==(r=t.input.charCodeAt(t.position)))return!1;for(null!==t.anchor&&jy(t,"duplication of an anchor property"),r=t.input.charCodeAt(++t.position),e=t.position;0!==r&&!Fy(r)&&!Ly(r);)r=t.input.charCodeAt(++t.position);return t.position===e&&jy(t,"name of an anchor node must contain at least one character"),t.anchor=t.input.slice(e,t.position),!0}function sm(t){var e,r,i;if(42!==(i=t.input.charCodeAt(t.position)))return!1;for(i=t.input.charCodeAt(++t.position),e=t.position;0!==i&&!Fy(i)&&!Ly(i);)i=t.input.charCodeAt(++t.position);return t.position===e&&jy(t,"name of an alias node must contain at least one character"),r=t.input.slice(e,t.position),ky.call(t.anchorMap,r)||jy(t,'unidentified alias "'+r+'"'),t.result=t.anchorMap[r],Xy(t,!0,-1),!0}function lm(t,e,r,i,n){var a,o,s,l,h,c,u,d,p,f=1,g=!1,y=!1;if(null!==t.listener&&t.listener("open",t),t.tag=null,t.anchor=null,t.kind=null,t.result=null,a=o=s=4===r||3===r,i&&Xy(t,!0,-1)&&(g=!0,t.lineIndent>e?f=1:t.lineIndent===e?f=0:t.lineIndent<e&&(f=-1)),1===f)for(;am(t)||om(t);)Xy(t,!0,-1)?(g=!0,s=a,t.lineIndent>e?f=1:t.lineIndent===e?f=0:t.lineIndent<e&&(f=-1)):s=!1;if(s&&(s=g||n),(1===f||4===r)&&(d=1===r||2===r?e:e+1,p=t.position-t.lineStart,1===f?s&&(im(t,p)||nm(t,p,d))||em(t,d)?y=!0:(o&&rm(t,d)||Jy(t,d)||tm(t,d)?y=!0:sm(t)?(y=!0,(null!==t.tag||null!==t.anchor)&&jy(t,"alias node should not have any properties")):Ky(t,d,1===r)&&(y=!0,null===t.tag&&(t.tag="?")),null!==t.anchor&&(t.anchorMap[t.anchor]=t.result)):0===f&&(y=s&&im(t,p))),null===t.tag)null!==t.anchor&&(t.anchorMap[t.anchor]=t.result);else if("?"===t.tag){for(null!==t.result&&"scalar"!==t.kind&&jy(t,'unacceptable node kind for !<?> tag; it should be "scalar", not "'+t.kind+'"'),l=0,h=t.implicitTypes.length;l<h;l+=1)if((u=t.implicitTypes[l]).resolve(t.result)){t.result=u.construct(t.result),t.tag=u.tag,null!==t.anchor&&(t.anchorMap[t.anchor]=t.result);break}}else if("!"!==t.tag){if(ky.call(t.typeMap[t.kind||"fallback"],t.tag))u=t.typeMap[t.kind||"fallback"][t.tag];else for(u=null,l=0,h=(c=t.typeMap.multi[t.kind||"fallback"]).length;l<h;l+=1)if(t.tag.slice(0,c[l].tag.length)===c[l].tag){u=c[l];break}u||jy(t,"unknown tag !<"+t.tag+">"),null!==t.result&&u.kind!==t.kind&&jy(t,"unacceptable node kind for !<"+t.tag+'> tag; it should be "'+u.kind+'", not "'+t.kind+'"'),u.resolve(t.result,t.tag)?(t.result=u.construct(t.result,t.tag),null!==t.anchor&&(t.anchorMap[t.anchor]=t.result)):jy(t,"cannot resolve a node with !<"+t.tag+"> explicit tag")}return null!==t.listener&&t.listener("close",t),null!==t.tag||null!==t.anchor||y}function hm(t){var e,r,i,n,a=t.position,o=!1;for(t.version=null,t.checkLineBreaks=t.legacy,t.tagMap=Object.create(null),t.anchorMap=Object.create(null);0!==(n=t.input.charCodeAt(t.position))&&(Xy(t,!0,-1),n=t.input.charCodeAt(t.position),!(t.lineIndent>0||37!==n));){for(o=!0,n=t.input.charCodeAt(++t.position),e=t.position;0!==n&&!Fy(n);)n=t.input.charCodeAt(++t.position);for(i=[],(r=t.input.slice(e,t.position)).length<1&&jy(t,"directive name must not be less than one character in length");0!==n;){for(;Ay(n);)n=t.input.charCodeAt(++t.position);if(35===n){do{n=t.input.charCodeAt(++t.position)}while(0!==n&&!By(n));break}if(By(n))break;for(e=t.position;0!==n&&!Fy(n);)n=t.input.charCodeAt(++t.position);i.push(t.input.slice(e,t.position))}0!==n&&Gy(t),ky.call(Hy,r)?Hy[r](t,r,i):Wy(t,'unknown document directive "'+r+'"')}Xy(t,!0,-1),0===t.lineIndent&&45===t.input.charCodeAt(t.position)&&45===t.input.charCodeAt(t.position+1)&&45===t.input.charCodeAt(t.position+2)?(t.position+=3,Xy(t,!0,-1)):o&&jy(t,"directives end mark is expected"),lm(t,t.lineIndent-1,4,!1,!0),Xy(t,!0,-1),t.checkLineBreaks&&_y.test(t.input.slice(a,t.position))&&Wy(t,"non-ASCII line breaks are interpreted as content"),t.documents.push(t.result),t.position===t.lineStart&&Zy(t)?46===t.input.charCodeAt(t.position)&&(t.position+=3,Xy(t,!0,-1)):t.position<t.length-1&&jy(t,"end of the stream or a document separator is expected")}function cm(t,e){e=e||{},0!==(t=String(t)).length&&(10!==t.charCodeAt(t.length-1)&&13!==t.charCodeAt(t.length-1)&&(t+="\n"),65279===t.charCodeAt(0)&&(t=t.slice(1)));var r=new zy(t,e),i=t.indexOf("\0");for(-1!==i&&(r.position=i,jy(r,"null byte is not allowed in input")),r.input+="\0";32===r.input.charCodeAt(r.position);)r.lineIndent+=1,r.position+=1;for(;r.position<r.length-1;)hm(r);return r.documents}function um(t,e){var r=cm(t,e);if(0!==r.length){if(1===r.length)return r[0];throw new ag("expected a single document in the stream, but found more")}}s(Uy,"captureSegment"),s(Yy,"mergeMappings"),s(Vy,"storeMappingPair"),s(Gy,"readLineBreak"),s(Xy,"skipSeparationSpace"),s(Zy,"testDocumentSeparator"),s(Qy,"writeFoldedLines"),s(Ky,"readPlainScalar"),s(Jy,"readSingleQuotedScalar"),s(tm,"readDoubleQuotedScalar"),s(em,"readFlowCollection"),s(rm,"readBlockScalar"),s(im,"readBlockSequence"),s(nm,"readBlockMapping"),s(am,"readTagProperty"),s(om,"readAnchorProperty"),s(sm,"readAlias"),s(lm,"composeNode"),s(hm,"readDocument"),s(cm,"loadDocuments"),s(function(t,e,r){null!==e&&"object"==typeof e&&typeof r>"u"&&(r=e,e=null);var i=cm(t,r);if("function"!=typeof e)return i;for(var n=0,a=i.length;n<a;n+=1)e(i[n])},"loadAll$1"),s(um,"load$1");var dm={load:um},pm=Object.prototype.toString,fm=Object.prototype.hasOwnProperty,gm=65279,ym={0:"\\0",7:"\\a",8:"\\b",9:"\\t",10:"\\n",11:"\\v",12:"\\f",13:"\\r",27:"\\e",34:'\\"',92:"\\\\",133:"\\N",160:"\\_",8232:"\\L",8233:"\\P"},mm=["y","Y","yes","Yes","YES","on","On","ON","n","N","no","No","NO","off","Off","OFF"],xm=/^[-+]?[0-9_]+(?::[0-9_]+)+(?:\.[0-9_]*)?$/;function bm(t,e){var r,i,n,a,o,s,l;if(null===e)return{};for(r={},n=0,a=(i=Object.keys(e)).length;n<a;n+=1)o=i[n],s=String(e[o]),"!!"===o.slice(0,2)&&(o="tag:yaml.org,2002:"+o.slice(2)),(l=t.compiledTypeMap.fallback[o])&&fm.call(l.styleAliases,s)&&(s=l.styleAliases[s]),r[o]=s;return r}function Cm(t){var e,r,i;if(e=t.toString(16).toUpperCase(),t<=255)r="x",i=2;else if(t<=65535)r="u",i=4;else{if(!(t<=4294967295))throw new ag("code point within a string may not be greater than 0xFFFFFFFF");r="U",i=8}return"\\"+r+rg.repeat("0",i-e.length)+e}s(bm,"compileStyleMap"),s(Cm,"encodeHex");function km(t){this.schema=t.schema||Cy,this.indent=Math.max(1,t.indent||2),this.noArrayIndent=t.noArrayIndent||!1,this.skipInvalid=t.skipInvalid||!1,this.flowLevel=rg.isNothing(t.flowLevel)?-1:t.flowLevel,this.styleMap=bm(this.schema,t.styles||null),this.sortKeys=t.sortKeys||!1,this.lineWidth=t.lineWidth||80,this.noRefs=t.noRefs||!1,this.noCompatMode=t.noCompatMode||!1,this.condenseFlow=t.condenseFlow||!1,this.quotingType='"'===t.quotingType?2:1,this.forceQuotes=t.forceQuotes||!1,this.replacer="function"==typeof t.replacer?t.replacer:null,this.implicitTypes=this.schema.compiledImplicit,this.explicitTypes=this.schema.compiledExplicit,this.tag=null,this.result="",this.duplicates=[],this.usedDuplicates=null}function wm(t,e){for(var r,i=rg.repeat(" ",e),n=0,a=-1,o="",s=t.length;n<s;)-1===(a=t.indexOf("\n",n))?(r=t.slice(n),n=s):(r=t.slice(n,a+1),n=a+1),r.length&&"\n"!==r&&(o+=i),o+=r;return o}function _m(t,e){return"\n"+rg.repeat(" ",t.indent*e)}function vm(t,e){var r,i;for(r=0,i=t.implicitTypes.length;r<i;r+=1)if(t.implicitTypes[r].resolve(e))return!0;return!1}function Sm(t){return 32===t||9===t}function Tm(t){return 32<=t&&t<=126||161<=t&&t<=55295&&8232!==t&&8233!==t||57344<=t&&t<=65533&&t!==gm||65536<=t&&t<=1114111}function Mm(t){return Tm(t)&&t!==gm&&13!==t&&10!==t}function Bm(t,e,r){var i=Mm(t),n=i&&!Sm(t);return(r?i:i&&44!==t&&91!==t&&93!==t&&123!==t&&125!==t)&&35!==t&&!(58===e&&!n)||Mm(e)&&!Sm(e)&&35===t||58===e&&n}function Am(t){return Tm(t)&&t!==gm&&!Sm(t)&&45!==t&&63!==t&&58!==t&&44!==t&&91!==t&&93!==t&&123!==t&&125!==t&&35!==t&&38!==t&&42!==t&&33!==t&&124!==t&&61!==t&&62!==t&&39!==t&&34!==t&&37!==t&&64!==t&&96!==t}function Fm(t){return!Sm(t)&&58!==t}function Lm(t,e){var r,i=t.charCodeAt(e);return i>=55296&&i<=56319&&e+1<t.length&&((r=t.charCodeAt(e+1))>=56320&&r<=57343)?1024*(i-55296)+r-56320+65536:i}function $m(t){return/^\n* /.test(t)}s(km,"State"),s(wm,"indentString"),s(_m,"generateNextLine"),s(vm,"testImplicitResolving"),s(Sm,"isWhitespace"),s(Tm,"isPrintable"),s(Mm,"isNsCharOrWhitespace"),s(Bm,"isPlainSafe"),s(Am,"isPlainSafeFirst"),s(Fm,"isPlainSafeLast"),s(Lm,"codePointAt"),s($m,"needIndentIndicator");function Em(t,e,r,i,n,a,o,s){var l,h=0,c=null,u=!1,d=!1,p=-1!==i,f=-1,g=Am(Lm(t,0))&&Fm(Lm(t,t.length-1));if(e||o)for(l=0;l<t.length;h>=65536?l+=2:l++){if(!Tm(h=Lm(t,l)))return 5;g=g&&Bm(h,c,s),c=h}else{for(l=0;l<t.length;h>=65536?l+=2:l++){if(10===(h=Lm(t,l)))u=!0,p&&(d=d||l-f-1>i&&" "!==t[f+1],f=l);else if(!Tm(h))return 5;g=g&&Bm(h,c,s),c=h}d=d||p&&l-f-1>i&&" "!==t[f+1]}return u||d?r>9&&$m(t)?5:o?2===a?5:2:d?4:3:!g||o||n(t)?2===a?5:2:1}function Dm(t,e,r,i,n){t.dump=function(){if(0===e.length)return 2===t.quotingType?'""':"''";if(!t.noCompatMode&&(-1!==mm.indexOf(e)||xm.test(e)))return 2===t.quotingType?'"'+e+'"':"'"+e+"'";var a=t.indent*Math.max(1,r),o=-1===t.lineWidth?-1:Math.max(Math.min(t.lineWidth,40),t.lineWidth-a),l=i||t.flowLevel>-1&&r>=t.flowLevel;function h(e){return vm(t,e)}switch(s(h,"testAmbiguity"),Em(e,l,t.indent,o,h,t.quotingType,t.forceQuotes&&!i,n)){case 1:return e;case 2:return"'"+e.replace(/'/g,"''")+"'";case 3:return"|"+Om(e,t.indent)+Im(wm(e,a));case 4:return">"+Om(e,t.indent)+Im(wm(Nm(e,o),a));case 5:return'"'+Pm(e)+'"';default:throw new ag("impossible error: invalid scalar style")}}()}function Om(t,e){var r=$m(t)?String(e):"",i="\n"===t[t.length-1];return r+(i&&("\n"===t[t.length-2]||"\n"===t)?"+":i?"":"-")+"\n"}function Im(t){return"\n"===t[t.length-1]?t.slice(0,-1):t}function Nm(t,e){for(var r,i,n=/(\n+)([^\n]*)/g,a=function(){var r=t.indexOf("\n");return r=-1!==r?r:t.length,n.lastIndex=r,Rm(t.slice(0,r),e)}(),o="\n"===t[0]||" "===t[0];i=n.exec(t);){var s=i[1],l=i[2];r=" "===l[0],a+=s+(o||r||""===l?"":"\n")+Rm(l,e),o=r}return a}function Rm(t,e){if(""===t||" "===t[0])return t;for(var r,i,n=/ [^ ]/g,a=0,o=0,s=0,l="";r=n.exec(t);)(s=r.index)-a>e&&(i=o>a?o:s,l+="\n"+t.slice(a,i),a=i+1),o=s;return l+="\n",t.length-a>e&&o>a?l+=t.slice(a,o)+"\n"+t.slice(o+1):l+=t.slice(a),l.slice(1)}function Pm(t){for(var e,r="",i=0,n=0;n<t.length;i>=65536?n+=2:n++)i=Lm(t,n),!(e=ym[i])&&Tm(i)?(r+=t[n],i>=65536&&(r+=t[n+1])):r+=e||Cm(i);return r}function zm(t,e,r){var i,n,a,o="",s=t.tag;for(i=0,n=r.length;i<n;i+=1)a=r[i],t.replacer&&(a=t.replacer.call(r,String(i),a)),(Um(t,e,a,!1,!1)||typeof a>"u"&&Um(t,e,null,!1,!1))&&(""!==o&&(o+=","+(t.condenseFlow?"":" ")),o+=t.dump);t.tag=s,t.dump="["+o+"]"}function qm(t,e,r,i){var n,a,o,s="",l=t.tag;for(n=0,a=r.length;n<a;n+=1)o=r[n],t.replacer&&(o=t.replacer.call(r,String(n),o)),(Um(t,e+1,o,!0,!0,!1,!0)||typeof o>"u"&&Um(t,e+1,null,!0,!0,!1,!0))&&((!i||""!==s)&&(s+=_m(t,e)),t.dump&&10===t.dump.charCodeAt(0)?s+="-":s+="- ",s+=t.dump);t.tag=l,t.dump=s||"[]"}function jm(t,e,r){var i,n,a,o,s,l="",h=t.tag,c=Object.keys(r);for(i=0,n=c.length;i<n;i+=1)s="",""!==l&&(s+=", "),t.condenseFlow&&(s+='"'),o=r[a=c[i]],t.replacer&&(o=t.replacer.call(r,a,o)),Um(t,e,a,!1,!1)&&(t.dump.length>1024&&(s+="? "),s+=t.dump+(t.condenseFlow?'"':"")+":"+(t.condenseFlow?"":" "),Um(t,e,o,!1,!1)&&(l+=s+=t.dump));t.tag=h,t.dump="{"+l+"}"}function Wm(t,e,r,i){var n,a,o,s,l,h,c="",u=t.tag,d=Object.keys(r);if(!0===t.sortKeys)d.sort();else if("function"==typeof t.sortKeys)d.sort(t.sortKeys);else if(t.sortKeys)throw new ag("sortKeys must be a boolean or a function");for(n=0,a=d.length;n<a;n+=1)h="",(!i||""!==c)&&(h+=_m(t,e)),s=r[o=d[n]],t.replacer&&(s=t.replacer.call(r,o,s)),Um(t,e+1,o,!0,!0,!0)&&((l=null!==t.tag&&"?"!==t.tag||t.dump&&t.dump.length>1024)&&(t.dump&&10===t.dump.charCodeAt(0)?h+="?":h+="? "),h+=t.dump,l&&(h+=_m(t,e)),Um(t,e+1,s,!0,l)&&(t.dump&&10===t.dump.charCodeAt(0)?h+=":":h+=": ",c+=h+=t.dump));t.tag=u,t.dump=c||"{}"}function Hm(t,e,r){var i,n,a,o,s,l;for(a=0,o=(n=r?t.explicitTypes:t.implicitTypes).length;a<o;a+=1)if(((s=n[a]).instanceOf||s.predicate)&&(!s.instanceOf||"object"==typeof e&&e instanceof s.instanceOf)&&(!s.predicate||s.predicate(e))){if(r?s.multi&&s.representName?t.tag=s.representName(e):t.tag=s.tag:t.tag="?",s.represent){if(l=t.styleMap[s.tag]||s.defaultStyle,"[object Function]"===pm.call(s.represent))i=s.represent(e,l);else{if(!fm.call(s.represent,l))throw new ag("!<"+s.tag+'> tag resolver accepts not "'+l+'" style');i=s.represent[l](e,l)}t.dump=i}return!0}return!1}function Um(t,e,r,i,n,a,o){t.tag=null,t.dump=r,Hm(t,r,!1)||Hm(t,r,!0);var s,l=pm.call(t.dump),h=i;i&&(i=t.flowLevel<0||t.flowLevel>e);var c,u,d="[object Object]"===l||"[object Array]"===l;if(d&&(u=-1!==(c=t.duplicates.indexOf(r))),(null!==t.tag&&"?"!==t.tag||u||2!==t.indent&&e>0)&&(n=!1),u&&t.usedDuplicates[c])t.dump="*ref_"+c;else{if(d&&u&&!t.usedDuplicates[c]&&(t.usedDuplicates[c]=!0),"[object Object]"===l)i&&0!==Object.keys(t.dump).length?(Wm(t,e,t.dump,n),u&&(t.dump="&ref_"+c+t.dump)):(jm(t,e,t.dump),u&&(t.dump="&ref_"+c+" "+t.dump));else if("[object Array]"===l)i&&0!==t.dump.length?(t.noArrayIndent&&!o&&e>0?qm(t,e-1,t.dump,n):qm(t,e,t.dump,n),u&&(t.dump="&ref_"+c+t.dump)):(zm(t,e,t.dump),u&&(t.dump="&ref_"+c+" "+t.dump));else{if("[object String]"!==l){if("[object Undefined]"===l)return!1;if(t.skipInvalid)return!1;throw new ag("unacceptable kind of an object to dump "+l)}"?"!==t.tag&&Dm(t,t.dump,e,a,h)}null!==t.tag&&"?"!==t.tag&&(s=encodeURI("!"===t.tag[0]?t.tag.slice(1):t.tag).replace(/!/g,"%21"),s="!"===t.tag[0]?"!"+s:"tag:yaml.org,2002:"===s.slice(0,18)?"!!"+s.slice(18):"!<"+s+">",t.dump=s+" "+t.dump)}return!0}function Ym(t,e){var r,i,n=[],a=[];for(Vm(t,n,a),r=0,i=a.length;r<i;r+=1)e.duplicates.push(n[a[r]]);e.usedDuplicates=new Array(i)}function Vm(t,e,r){var i,n,a;if(null!==t&&"object"==typeof t)if(-1!==(n=e.indexOf(t)))-1===r.indexOf(n)&&r.push(n);else if(e.push(t),Array.isArray(t))for(n=0,a=t.length;n<a;n+=1)Vm(t[n],e,r);else for(n=0,a=(i=Object.keys(t)).length;n<a;n+=1)Vm(t[i[n]],e,r)}s(Em,"chooseScalarStyle"),s(Dm,"writeScalar"),s(Om,"blockHeader"),s(Im,"dropEndingNewline"),s(Nm,"foldString"),s(Rm,"foldLine"),s(Pm,"escapeString"),s(zm,"writeFlowSequence"),s(qm,"writeBlockSequence"),s(jm,"writeFlowMapping"),s(Wm,"writeBlockMapping"),s(Hm,"detectType"),s(Um,"writeNode"),s(Ym,"getDuplicateReferences"),s(Vm,"inspectNode"),s(function(t,e){var r=new km(e=e||{});r.noRefs||Ym(t,r);var i=t;return r.replacer&&(i=r.replacer.call({"":i},"",i)),Um(r,0,i,!0,!0)?r.dump+"\n":""},"dump$1"),s(function(t,e){return function(){throw new Error("Function yaml."+t+" is removed in js-yaml 4. Use yaml."+e+" instead, which is now safe by default.")}},"renamed");var Gm=Ug,Xm=dm.load,Zm={aggregation:18,extension:18,composition:18,dependency:6,lollipop:13.5,arrow_point:4};function Qm(t,e){if(void 0===t||void 0===e)return{angle:0,deltaX:0,deltaY:0};t=Km(t),e=Km(e);let[r,i]=[t.x,t.y],[n,a]=[e.x,e.y],o=n-r,s=a-i;return{angle:Math.atan(s/o),deltaX:o,deltaY:s}}s(Qm,"calculateDeltaAndAngle");var Km=s(t=>Array.isArray(t)?{x:t[0],y:t[1]}:t,"pointTransformer"),Jm=s(t=>({x:s(function(e,r,i){let n=0,a=Km(i[0]).x<Km(i[i.length-1]).x?"left":"right";if(0===r&&Object.hasOwn(Zm,t.arrowTypeStart)){let{angle:e,deltaX:r}=Qm(i[0],i[1]);n=Zm[t.arrowTypeStart]*Math.cos(e)*(r>=0?1:-1)}else if(r===i.length-1&&Object.hasOwn(Zm,t.arrowTypeEnd)){let{angle:e,deltaX:r}=Qm(i[i.length-1],i[i.length-2]);n=Zm[t.arrowTypeEnd]*Math.cos(e)*(r>=0?1:-1)}let o=Math.abs(Km(e).x-Km(i[i.length-1]).x),s=Math.abs(Km(e).y-Km(i[i.length-1]).y),l=Math.abs(Km(e).x-Km(i[0]).x),h=Math.abs(Km(e).y-Km(i[0]).y),c=Zm[t.arrowTypeStart],u=Zm[t.arrowTypeEnd];if(o<u&&o>0&&s<u){let t=u+1-o;t*="right"===a?-1:1,n-=t}if(l<c&&l>0&&h<c){let t=c+1-l;t*="right"===a?-1:1,n+=t}return Km(e).x+n},"x"),y:s(function(e,r,i){let n=0,a=Km(i[0]).y<Km(i[i.length-1]).y?"down":"up";if(0===r&&Object.hasOwn(Zm,t.arrowTypeStart)){let{angle:e,deltaY:r}=Qm(i[0],i[1]);n=Zm[t.arrowTypeStart]*Math.abs(Math.sin(e))*(r>=0?1:-1)}else if(r===i.length-1&&Object.hasOwn(Zm,t.arrowTypeEnd)){let{angle:e,deltaY:r}=Qm(i[i.length-1],i[i.length-2]);n=Zm[t.arrowTypeEnd]*Math.abs(Math.sin(e))*(r>=0?1:-1)}let o=Math.abs(Km(e).y-Km(i[i.length-1]).y),s=Math.abs(Km(e).x-Km(i[i.length-1]).x),l=Math.abs(Km(e).y-Km(i[0]).y),h=Math.abs(Km(e).x-Km(i[0]).x),c=Zm[t.arrowTypeStart],u=Zm[t.arrowTypeEnd];if(o<u&&o>0&&s<u){let t=u+1-o;t*="up"===a?-1:1,n-=t}if(l<c&&l>0&&h<c){let t=c+1-l;t*="up"===a?-1:1,n+=t}return Km(e).y+n},"y")}),"getLineFunctionsWithOffset"),tx=s(({flowchart:t})=>{let e=t?.subGraphTitleMargin?.top??0,r=t?.subGraphTitleMargin?.bottom??0;return{subGraphTitleTopMargin:e,subGraphTitleBottomMargin:r,subGraphTitleTotalMargin:e+r}},"getSubGraphTitleMargins"),ex=s(t=>{let{handDrawnSeed:e}=di();return{fill:t,hachureAngle:120,hachureGap:4,fillWeight:2,roughness:.7,stroke:t,seed:e}},"solidStateFill"),rx=s(t=>{let e=ix([...t.cssCompiledStyles||[],...t.cssStyles||[]]);return{stylesMap:e,stylesArray:[...e]}},"compileStyles"),ix=s(t=>{let e=new Map;return t.forEach(t=>{let[r,i]=t.split(":");e.set(r.trim(),i?.trim())}),e},"styles2Map"),nx=s(t=>"color"===t||"font-size"===t||"font-family"===t||"font-weight"===t||"font-style"===t||"text-decoration"===t||"text-align"===t||"text-transform"===t||"line-height"===t||"letter-spacing"===t||"word-spacing"===t||"text-shadow"===t||"text-overflow"===t||"white-space"===t||"word-wrap"===t||"word-break"===t||"overflow-wrap"===t||"hyphens"===t,"isLabelStyle"),ax=s(t=>{let{stylesArray:e}=rx(t),r=[],i=[],n=[],a=[];return e.forEach(t=>{let e=t[0];nx(e)?r.push(t.join(":")+" !important"):(i.push(t.join(":")+" !important"),e.includes("stroke")&&n.push(t.join(":")+" !important"),"fill"===e&&a.push(t.join(":")+" !important"))}),{labelStyles:r.join(";"),nodeStyles:i.join(";"),stylesArray:e,borderStyles:n,backgroundStyles:a}},"styles2String"),ox=s((t,e)=>{let{themeVariables:r,handDrawnSeed:i}=di(),{nodeBorder:n,mainBkg:a}=r,{stylesMap:o}=rx(t);return Object.assign({roughness:.7,fill:o.get("fill")||a,fillStyle:"hachure",fillWeight:4,hachureGap:5.2,stroke:o.get("stroke")||n,seed:i,strokeWidth:o.get("stroke-width")?.replace("px","")||1.3,fillLineDash:[0,0]},e)},"userNodeOverrides"),sx=l(t=>{Object.defineProperty(t,"__esModule",{value:!0}),t.BLANK_URL=t.relativeFirstCharacters=t.whitespaceEscapeCharsRegex=t.urlSchemeRegex=t.ctrlCharactersRegex=t.htmlCtrlEntityRegex=t.htmlEntitiesRegex=t.invalidProtocolRegex=void 0,t.invalidProtocolRegex=/^([^\w]*)(javascript|data|vbscript)/im,t.htmlEntitiesRegex=/&#(\w+)(^\w|;)?/g,t.htmlCtrlEntityRegex=/&(newline|tab);/gi,t.ctrlCharactersRegex=/[\u0000-\u001F\u007F-\u009F\u2000-\u200D\uFEFF]/gim,t.urlSchemeRegex=/^.+(:|&colon;)/gim,t.whitespaceEscapeCharsRegex=/(\\|%5[cC])((%(6[eE]|72|74))|[nrt])/g,t.relativeFirstCharacters=[".","/"],t.BLANK_URL="about:blank"}),lx=l(t=>{Object.defineProperty(t,"__esModule",{value:!0}),t.sanitizeUrl=void 0;var e=sx();function r(t){return e.relativeFirstCharacters.indexOf(t[0])>-1}function i(t){return t.replace(e.ctrlCharactersRegex,"").replace(e.htmlEntitiesRegex,function(t,e){return String.fromCharCode(e)})}function n(t){return URL.canParse(t)}function a(t){try{return decodeURIComponent(t)}catch{return t}}function o(t){if(!t)return e.BLANK_URL;var o,s=a(t.trim());do{o=(s=a(s=i(s).replace(e.htmlCtrlEntityRegex,"").replace(e.ctrlCharactersRegex,"").replace(e.whitespaceEscapeCharsRegex,"").trim())).match(e.ctrlCharactersRegex)||s.match(e.htmlEntitiesRegex)||s.match(e.htmlCtrlEntityRegex)||s.match(e.whitespaceEscapeCharsRegex)}while(o&&o.length>0);var l=s;if(!l)return e.BLANK_URL;if(r(l))return l;var h=l.trimStart(),c=h.match(e.urlSchemeRegex);if(!c)return l;var u=c[0].toLowerCase().trim();if(e.invalidProtocolRegex.test(u))return e.BLANK_URL;var d=h.replace(/\\/g,"/");if("mailto:"===u||u.includes("://"))return d;if("http:"===u||"https:"===u){if(!n(d))return e.BLANK_URL;var p=new URL(d);return p.protocol=p.protocol.toLowerCase(),p.hostname=p.hostname.toLowerCase(),p.toString()}return d}s(r,"isRelativeUrlWithoutProtocol"),s(i,"decodeHtmlCharacters"),s(n,"isValidUrl"),s(a,"decodeURI"),s(o,"sanitizeUrl"),t.sanitizeUrl=o}),hx="object"==typeof global&&global&&global.Object===Object&&global,cx="object"==typeof self&&self&&self.Object===Object&&self,ux=hx||cx||Function("return this")(),dx=ux.Symbol,px=Object.prototype,fx=px.hasOwnProperty,gx=px.toString,yx=dx?dx.toStringTag:void 0;function mx(t){var e=fx.call(t,yx),r=t[yx];try{t[yx]=void 0;var i=!0}catch{}var n=gx.call(t);return i&&(e?t[yx]=r:delete t[yx]),n}s(mx,"getRawTag");var xx=mx,bx=Object.prototype.toString;function Cx(t){return bx.call(t)}s(Cx,"objectToString");var kx=Cx,wx=dx?dx.toStringTag:void 0;function _x(t){return null==t?void 0===t?"[object Undefined]":"[object Null]":wx&&wx in Object(t)?xx(t):kx(t)}s(_x,"baseGetTag");var vx=_x;function Sx(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}s(Sx,"isObject");var Tx=Sx;function Mx(t){if(!Tx(t))return!1;var e=vx(t);return"[object Function]"==e||"[object GeneratorFunction]"==e||"[object AsyncFunction]"==e||"[object Proxy]"==e}s(Mx,"isFunction");var Bx=Mx,Ax=ux["__core-js_shared__"],Fx=function(){var t=/[^.]+$/.exec(Ax&&Ax.keys&&Ax.keys.IE_PROTO||"");return t?"Symbol(src)_1."+t:""}();function Lx(t){return!!Fx&&Fx in t}s(Lx,"isMasked");var $x=Lx,Ex=Function.prototype.toString;function Dx(t){if(null!=t){try{return Ex.call(t)}catch{}try{return t+""}catch{}}return""}s(Dx,"toSource");var Ox=Dx,Ix=/^\[object .+?Constructor\]$/,Nx=Function.prototype,Rx=Object.prototype,Px=Nx.toString,zx=Rx.hasOwnProperty,qx=RegExp("^"+Px.call(zx).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function jx(t){return!(!Tx(t)||$x(t))&&(Bx(t)?qx:Ix).test(Ox(t))}s(jx,"baseIsNative");var Wx=jx;function Hx(t,e){return t?.[e]}s(Hx,"getValue");var Ux=Hx;function Yx(t,e){var r=Ux(t,e);return Wx(r)?r:void 0}s(Yx,"getNative");var Vx=Yx,Gx=Vx(Object,"create");function Xx(){this.__data__=Gx?Gx(null):{},this.size=0}s(Xx,"hashClear");var Zx=Xx;function Qx(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e}s(Qx,"hashDelete");var Kx=Qx,Jx=Object.prototype.hasOwnProperty;function tb(t){var e=this.__data__;if(Gx){var r=e[t];return"__lodash_hash_undefined__"===r?void 0:r}return Jx.call(e,t)?e[t]:void 0}s(tb,"hashGet");var eb=tb,rb=Object.prototype.hasOwnProperty;function ib(t){var e=this.__data__;return Gx?void 0!==e[t]:rb.call(e,t)}s(ib,"hashHas");var nb=ib;function ab(t,e){var r=this.__data__;return this.size+=this.has(t)?0:1,r[t]=Gx&&void 0===e?"__lodash_hash_undefined__":e,this}s(ab,"hashSet");var ob=ab;function sb(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var i=t[e];this.set(i[0],i[1])}}s(sb,"Hash"),sb.prototype.clear=Zx,sb.prototype.delete=Kx,sb.prototype.get=eb,sb.prototype.has=nb,sb.prototype.set=ob;var lb=sb;function hb(){this.__data__=[],this.size=0}s(hb,"listCacheClear");var cb=hb;function ub(t,e){return t===e||t!=t&&e!=e}s(ub,"eq");var db=ub;function pb(t,e){for(var r=t.length;r--;)if(db(t[r][0],e))return r;return-1}s(pb,"assocIndexOf");var fb=pb,gb=Array.prototype.splice;function yb(t){var e=this.__data__,r=fb(e,t);return!(r<0)&&(r==e.length-1?e.pop():gb.call(e,r,1),--this.size,!0)}s(yb,"listCacheDelete");var mb=yb;function xb(t){var e=this.__data__,r=fb(e,t);return r<0?void 0:e[r][1]}s(xb,"listCacheGet");var bb=xb;function Cb(t){return fb(this.__data__,t)>-1}s(Cb,"listCacheHas");var kb=Cb;function wb(t,e){var r=this.__data__,i=fb(r,t);return i<0?(++this.size,r.push([t,e])):r[i][1]=e,this}s(wb,"listCacheSet");var _b=wb;function vb(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var i=t[e];this.set(i[0],i[1])}}s(vb,"ListCache"),vb.prototype.clear=cb,vb.prototype.delete=mb,vb.prototype.get=bb,vb.prototype.has=kb,vb.prototype.set=_b;var Sb=vb,Tb=Vx(ux,"Map");function Mb(){this.size=0,this.__data__={hash:new lb,map:new(Tb||Sb),string:new lb}}s(Mb,"mapCacheClear");var Bb=Mb;function Ab(t){var e=typeof t;return"string"==e||"number"==e||"symbol"==e||"boolean"==e?"__proto__"!==t:null===t}s(Ab,"isKeyable");var Fb=Ab;function Lb(t,e){var r=t.__data__;return Fb(e)?r["string"==typeof e?"string":"hash"]:r.map}s(Lb,"getMapData");var $b=Lb;function Eb(t){var e=$b(this,t).delete(t);return this.size-=e?1:0,e}s(Eb,"mapCacheDelete");var Db=Eb;function Ob(t){return $b(this,t).get(t)}s(Ob,"mapCacheGet");var Ib=Ob;function Nb(t){return $b(this,t).has(t)}s(Nb,"mapCacheHas");var Rb=Nb;function Pb(t,e){var r=$b(this,t),i=r.size;return r.set(t,e),this.size+=r.size==i?0:1,this}s(Pb,"mapCacheSet");var zb=Pb;function qb(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var i=t[e];this.set(i[0],i[1])}}s(qb,"MapCache"),qb.prototype.clear=Bb,qb.prototype.delete=Db,qb.prototype.get=Ib,qb.prototype.has=Rb,qb.prototype.set=zb;var jb=qb;function Wb(t,e){if("function"!=typeof t||null!=e&&"function"!=typeof e)throw new TypeError("Expected a function");var r=s(function(){var i=arguments,n=e?e.apply(this,i):i[0],a=r.cache;if(a.has(n))return a.get(n);var o=t.apply(this,i);return r.cache=a.set(n,o)||a,o},"memoized");return r.cache=new(Wb.Cache||jb),r}s(Wb,"memoize"),Wb.Cache=jb;var Hb=Wb;function Ub(t){return function(){return t}}s(Ub,"constant");var Yb=Ub;function Vb(){this.__data__=new Sb,this.size=0}s(Vb,"stackClear");var Gb=Vb;function Xb(t){var e=this.__data__,r=e.delete(t);return this.size=e.size,r}s(Xb,"stackDelete");var Zb=Xb;function Qb(t){return this.__data__.get(t)}s(Qb,"stackGet");var Kb=Qb;function Jb(t){return this.__data__.has(t)}s(Jb,"stackHas");var tC=Jb;function eC(t,e){var r=this.__data__;if(r instanceof Sb){var i=r.__data__;if(!Tb||i.length<199)return i.push([t,e]),this.size=++r.size,this;r=this.__data__=new jb(i)}return r.set(t,e),this.size=r.size,this}s(eC,"stackSet");var rC=eC;function iC(t){var e=this.__data__=new Sb(t);this.size=e.size}s(iC,"Stack"),iC.prototype.clear=Gb,iC.prototype.delete=Zb,iC.prototype.get=Kb,iC.prototype.has=tC,iC.prototype.set=rC;var nC=iC,aC=function(){try{var t=Vx(Object,"defineProperty");return t({},"",{}),t}catch{}}(),oC=aC;function sC(t,e,r){"__proto__"==e&&oC?oC(t,e,{configurable:!0,enumerable:!0,value:r,writable:!0}):t[e]=r}s(sC,"baseAssignValue");var lC=sC;function hC(t,e,r){(void 0!==r&&!db(t[e],r)||void 0===r&&!(e in t))&&lC(t,e,r)}s(hC,"assignMergeValue");var cC=hC;function uC(t){return function(e,r,i){for(var n=-1,a=Object(e),o=i(e),s=o.length;s--;){var l=o[t?s:++n];if(!1===r(a[l],l,a))break}return e}}s(uC,"createBaseFor");var dC=uC(),pC="object"==typeof exports&&exports&&!exports.nodeType&&exports,fC=pC&&"object"==typeof module&&module&&!module.nodeType&&module,gC=fC&&fC.exports===pC?ux.Buffer:void 0,yC=gC?gC.allocUnsafe:void 0;function mC(t,e){if(e)return t.slice();var r=t.length,i=yC?yC(r):new t.constructor(r);return t.copy(i),i}s(mC,"cloneBuffer");var xC=mC,bC=ux.Uint8Array;function CC(t){var e=new t.constructor(t.byteLength);return new bC(e).set(new bC(t)),e}s(CC,"cloneArrayBuffer");var kC=CC;function wC(t,e){var r=e?kC(t.buffer):t.buffer;return new t.constructor(r,t.byteOffset,t.length)}s(wC,"cloneTypedArray");var _C=wC;function vC(t,e){var r=-1,i=t.length;for(e||(e=Array(i));++r<i;)e[r]=t[r];return e}s(vC,"copyArray");var SC=vC,TC=Object.create,MC=function(){function t(){}return s(t,"object"),function(e){if(!Tx(e))return{};if(TC)return TC(e);t.prototype=e;var r=new t;return t.prototype=void 0,r}}(),BC=MC;function AC(t,e){return function(r){return t(e(r))}}s(AC,"overArg");var FC=AC,LC=FC(Object.getPrototypeOf,Object),$C=Object.prototype;function EC(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||$C)}s(EC,"isPrototype");var DC=EC;function OC(t){return"function"!=typeof t.constructor||DC(t)?{}:BC(LC(t))}s(OC,"initCloneObject");var IC=OC;function NC(t){return null!=t&&"object"==typeof t}s(NC,"isObjectLike");var RC=NC;function PC(t){return RC(t)&&"[object Arguments]"==vx(t)}s(PC,"baseIsArguments");var zC=PC,qC=Object.prototype,jC=qC.hasOwnProperty,WC=qC.propertyIsEnumerable,HC=zC(function(){return arguments}())?zC:function(t){return RC(t)&&jC.call(t,"callee")&&!WC.call(t,"callee")},UC=HC,YC=Array.isArray;function VC(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=9007199254740991}s(VC,"isLength");var GC=VC;function XC(t){return null!=t&&GC(t.length)&&!Bx(t)}s(XC,"isArrayLike");var ZC=XC;function QC(t){return RC(t)&&ZC(t)}s(QC,"isArrayLikeObject");var KC=QC;function JC(){return!1}s(JC,"stubFalse");var tk=JC,ek="object"==typeof exports&&exports&&!exports.nodeType&&exports,rk=ek&&"object"==typeof module&&module&&!module.nodeType&&module,ik=rk&&rk.exports===ek?ux.Buffer:void 0,nk=(ik?ik.isBuffer:void 0)||tk,ak=Function.prototype,ok=Object.prototype,sk=ak.toString,lk=ok.hasOwnProperty,hk=sk.call(Object);function ck(t){if(!RC(t)||"[object Object]"!=vx(t))return!1;var e=LC(t);if(null===e)return!0;var r=lk.call(e,"constructor")&&e.constructor;return"function"==typeof r&&r instanceof r&&sk.call(r)==hk}s(ck,"isPlainObject");var uk=ck,dk={};function pk(t){return RC(t)&&GC(t.length)&&!!dk[vx(t)]}dk["[object Float32Array]"]=dk["[object Float64Array]"]=dk["[object Int8Array]"]=dk["[object Int16Array]"]=dk["[object Int32Array]"]=dk["[object Uint8Array]"]=dk["[object Uint8ClampedArray]"]=dk["[object Uint16Array]"]=dk["[object Uint32Array]"]=!0,dk["[object Arguments]"]=dk["[object Array]"]=dk["[object ArrayBuffer]"]=dk["[object Boolean]"]=dk["[object DataView]"]=dk["[object Date]"]=dk["[object Error]"]=dk["[object Function]"]=dk["[object Map]"]=dk["[object Number]"]=dk["[object Object]"]=dk["[object RegExp]"]=dk["[object Set]"]=dk["[object String]"]=dk["[object WeakMap]"]=!1,s(pk,"baseIsTypedArray");var fk=pk;function gk(t){return function(e){return t(e)}}s(gk,"baseUnary");var yk=gk,mk="object"==typeof exports&&exports&&!exports.nodeType&&exports,xk=mk&&"object"==typeof module&&module&&!module.nodeType&&module,bk=xk&&xk.exports===mk&&hx.process,Ck=function(){try{return xk&&xk.require&&xk.require("util").types||bk&&bk.binding&&bk.binding("util")}catch{}}(),kk=Ck&&Ck.isTypedArray,wk=kk?yk(kk):fk;function _k(t,e){if(("constructor"!==e||"function"!=typeof t[e])&&"__proto__"!=e)return t[e]}s(_k,"safeGet");var vk=_k,Sk=Object.prototype.hasOwnProperty;function Tk(t,e,r){var i=t[e];(!Sk.call(t,e)||!db(i,r)||void 0===r&&!(e in t))&&lC(t,e,r)}s(Tk,"assignValue");var Mk=Tk;function Bk(t,e,r,i){var n=!r;r||(r={});for(var a=-1,o=e.length;++a<o;){var s=e[a],l=i?i(r[s],t[s],s,r,t):void 0;void 0===l&&(l=t[s]),n?lC(r,s,l):Mk(r,s,l)}return r}s(Bk,"copyObject");var Ak=Bk;function Fk(t,e){for(var r=-1,i=Array(t);++r<t;)i[r]=e(r);return i}s(Fk,"baseTimes");var Lk=Fk,$k=/^(?:0|[1-9]\d*)$/;function Ek(t,e){var r=typeof t;return!!(e=e??9007199254740991)&&("number"==r||"symbol"!=r&&$k.test(t))&&t>-1&&t%1==0&&t<e}s(Ek,"isIndex");var Dk=Ek,Ok=Object.prototype.hasOwnProperty;function Ik(t,e){var r=YC(t),i=!r&&UC(t),n=!r&&!i&&nk(t),a=!r&&!i&&!n&&wk(t),o=r||i||n||a,s=o?Lk(t.length,String):[],l=s.length;for(var h in t)(e||Ok.call(t,h))&&(!o||!("length"==h||n&&("offset"==h||"parent"==h)||a&&("buffer"==h||"byteLength"==h||"byteOffset"==h)||Dk(h,l)))&&s.push(h);return s}s(Ik,"arrayLikeKeys");var Nk=Ik;function Rk(t){var e=[];if(null!=t)for(var r in Object(t))e.push(r);return e}s(Rk,"nativeKeysIn");var Pk=Rk,zk=Object.prototype.hasOwnProperty;function qk(t){if(!Tx(t))return Pk(t);var e=DC(t),r=[];for(var i in t)"constructor"==i&&(e||!zk.call(t,i))||r.push(i);return r}s(qk,"baseKeysIn");var jk=qk;function Wk(t){return ZC(t)?Nk(t,!0):jk(t)}s(Wk,"keysIn");var Hk=Wk;function Uk(t){return Ak(t,Hk(t))}s(Uk,"toPlainObject");var Yk=Uk;function Vk(t,e,r,i,n,a,o){var s=vk(t,r),l=vk(e,r),h=o.get(l);if(h)cC(t,r,h);else{var c=a?a(s,l,r+"",t,e,o):void 0,u=void 0===c;if(u){var d=YC(l),p=!d&&nk(l),f=!d&&!p&&wk(l);c=l,d||p||f?YC(s)?c=s:KC(s)?c=SC(s):p?(u=!1,c=xC(l,!0)):f?(u=!1,c=_C(l,!0)):c=[]:uk(l)||UC(l)?(c=s,UC(s)?c=Yk(s):(!Tx(s)||Bx(s))&&(c=IC(l))):u=!1}u&&(o.set(l,c),n(c,l,i,a,o),o.delete(l)),cC(t,r,c)}}s(Vk,"baseMergeDeep");var Gk=Vk;function Xk(t,e,r,i,n){t!==e&&dC(e,function(a,o){if(n||(n=new nC),Tx(a))Gk(t,e,o,r,Xk,i,n);else{var s=i?i(vk(t,o),a,o+"",t,e,n):void 0;void 0===s&&(s=a),cC(t,o,s)}},Hk)}s(Xk,"baseMerge");var Zk=Xk;function Qk(t){return t}s(Qk,"identity");var Kk=Qk;function Jk(t,e,r){switch(r.length){case 0:return t.call(e);case 1:return t.call(e,r[0]);case 2:return t.call(e,r[0],r[1]);case 3:return t.call(e,r[0],r[1],r[2])}return t.apply(e,r)}s(Jk,"apply");var tw=Jk,ew=Math.max;function rw(t,e,r){return e=ew(void 0===e?t.length-1:e,0),function(){for(var i=arguments,n=-1,a=ew(i.length-e,0),o=Array(a);++n<a;)o[n]=i[e+n];n=-1;for(var s=Array(e+1);++n<e;)s[n]=i[n];return s[e]=r(o),tw(t,this,s)}}s(rw,"overRest");var iw=rw,nw=oC?function(t,e){return oC(t,"toString",{configurable:!0,enumerable:!1,value:Yb(e),writable:!0})}:Kk,aw=nw,ow=Date.now;function sw(t){var e=0,r=0;return function(){var i=ow(),n=16-(i-r);if(r=i,n>0){if(++e>=800)return arguments[0]}else e=0;return t.apply(void 0,arguments)}}s(sw,"shortOut");var lw=sw(aw);function hw(t,e){return lw(iw(t,e,Kk),t+"")}s(hw,"baseRest");var cw=hw;function uw(t,e,r){if(!Tx(r))return!1;var i=typeof e;return!!("number"==i?ZC(r)&&Dk(e,r.length):"string"==i&&e in r)&&db(r[e],t)}s(uw,"isIterateeCall");var dw=uw;function pw(t){return cw(function(e,r){var i=-1,n=r.length,a=n>1?r[n-1]:void 0,o=n>2?r[2]:void 0;for(a=t.length>3&&"function"==typeof a?(n--,a):void 0,o&&dw(r[0],r[1],o)&&(a=n<3?void 0:a,n=1),e=Object(e);++i<n;){var s=r[i];s&&t(e,s,i,a)}return e})}s(pw,"createAssigner");var fw=pw,gw=fw(function(t,e,r){Zk(t,e,r)}),yw=gw,mw=d(lx()),xw="​",bw={curveBasis:ud,curveBasisClosed:fd,curveBasisOpen:yd,curveBumpX:sd,curveBumpY:ld,curveBundle:xd,curveCardinalClosed:_d,curveCardinalOpen:Sd,curveCardinal:kd,curveCatmullRomClosed:Fd,curveCatmullRomOpen:$d,curveCatmullRom:Bd,curveLinear:Ku,curveLinearClosed:Dd,curveMonotoneX:jd,curveMonotoneY:Wd,curveNatural:Yd,curveStep:Gd,curveStepAfter:Zd,curveStepBefore:Xd},Cw=/\s*(?:(\w+)(?=:):|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi,kw=s(function(t,e){let r=ww(t,/(?:init\b)|(?:initialize\b)/),i={};if(Array.isArray(r)){let t=r.map(t=>t.args);Ht(t),i=A(i,[...t])}else i=r.args;if(!i)return;let n=v(t,e),a="config";return void 0!==i[a]&&("flowchart-v2"===n&&(n="flowchart"),i[n]=i[a],delete i[a]),i},"detectInit"),ww=s(function(t,e=null){try{let r=new RegExp(`[%]{2}(?![{]${Cw.source})(?=[}][%]{2}).*\n`,"ig");t=t.trim().replace(r,"").replace(/'/gm,'"'),y.debug(`Detecting diagram directive${null!==e?" type:"+e:""} based on the text:${t}`);let i,n=[];for(;null!==(i=C.exec(t));)if(i.index===C.lastIndex&&C.lastIndex++,i&&!e||e&&i[1]?.match(e)||e&&i[2]?.match(e)){let t=i[1]?i[1]:i[2],e=i[3]?i[3].trim():i[4]?JSON.parse(i[4].trim()):null;n.push({type:t,args:e})}return 0===n.length?{type:t,args:null}:1===n.length?n[0]:n}catch(r){return y.error(`ERROR: ${r.message} - Unable to parse directive type: '${e}' based on the text: '${t}'`),{type:void 0,args:null}}},"detectDirective"),_w=s(function(t){return t.replace(C,"")},"removeDirectives"),vw=s(function(t,e){for(let[r,i]of e.entries())if(i.match(t))return r;return-1},"isSubstringInArray");function Sw(t,e){if(!t)return e;let r=`curve${t.charAt(0).toUpperCase()+t.slice(1)}`;return bw[r]??e}function Tw(t,e){let r=t.trim();if(r)return"loose"!==e.securityLevel?(0,mw.sanitizeUrl)(r):r}s(Sw,"interpolateToCurve"),s(Tw,"formatUrl");var Mw=s((t,...e)=>{let r=t.split("."),i=r.length-1,n=r[i],a=window;for(let e=0;e<i;e++)if(a=a[r[e]],!a)return void y.error(`Function name: ${t} not found in window`);a[n](...e)},"runFunc");function Bw(t,e){return t&&e?Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2)):0}function Aw(t){let e,r=0;return t.forEach(t=>{r+=Bw(t,e),e=t}),$w(t,r/2)}function Fw(t){return 1===t.length?t[0]:Aw(t)}s(Bw,"distance"),s(Aw,"traverseEdge"),s(Fw,"calcLabelPosition");var Lw=s((t,e=2)=>{let r=Math.pow(10,e);return Math.round(t*r)/r},"roundNumber"),$w=s((t,e)=>{let r,i=e;for(let e of t){if(r){let t=Bw(e,r);if(0===t)return r;if(t<i)i-=t;else{let n=i/t;if(n<=0)return r;if(n>=1)return{x:e.x,y:e.y};if(n>0&&n<1)return{x:Lw((1-n)*r.x+n*e.x,5),y:Lw((1-n)*r.y+n*e.y,5)}}}r=e}throw new Error("Could not find a suitable point for the given distance")},"calculatePoint"),Ew=s((t,e,r)=>{y.info(`our points ${JSON.stringify(e)}`),e[0]!==r&&(e=e.reverse());let i=$w(e,25),n=t?10:5,a=Math.atan2(e[0].y-i.y,e[0].x-i.x),o={x:0,y:0};return o.x=Math.sin(a)*n+(e[0].x+i.x)/2,o.y=-Math.cos(a)*n+(e[0].y+i.y)/2,o},"calcCardinalityPosition");function Dw(t,e,r){let i=structuredClone(r);y.info("our points",i),"start_left"!==e&&"start_right"!==e&&i.reverse();let n=$w(i,25+t),a=10+.5*t,o=Math.atan2(i[0].y-n.y,i[0].x-n.x),s={x:0,y:0};return"start_left"===e?(s.x=Math.sin(o+Math.PI)*a+(i[0].x+n.x)/2,s.y=-Math.cos(o+Math.PI)*a+(i[0].y+n.y)/2):"end_right"===e?(s.x=Math.sin(o-Math.PI)*a+(i[0].x+n.x)/2-5,s.y=-Math.cos(o-Math.PI)*a+(i[0].y+n.y)/2-5):"end_left"===e?(s.x=Math.sin(o)*a+(i[0].x+n.x)/2-5,s.y=-Math.cos(o)*a+(i[0].y+n.y)/2-5):(s.x=Math.sin(o)*a+(i[0].x+n.x)/2,s.y=-Math.cos(o)*a+(i[0].y+n.y)/2),s}function Ow(t){let e="",r="";for(let i of t)void 0!==i&&(i.startsWith("color:")||i.startsWith("text-align:")?r=r+i+";":e=e+i+";");return{style:e,labelStyle:r}}s(Dw,"calcTerminalLabelPosition"),s(Ow,"getStylesFromArray");var Iw=0,Nw=s(()=>(Iw++,"id-"+Math.random().toString(36).substr(2,12)+"-"+Iw),"generateId");function Rw(t){let e="",r="0123456789abcdef";for(let i=0;i<t;i++)e+=r.charAt(Math.floor(16*Math.random()));return e}s(Rw,"makeRandomHex");var Pw=s(t=>Rw(t.length),"random"),zw=s(function(){return{x:0,y:0,fill:void 0,anchor:"start",style:"#666",width:100,height:100,textMargin:0,rx:0,ry:0,valign:void 0,text:""}},"getTextObj"),qw=s(function(t,e){let r=e.text.replace(Wr.lineBreakRegex," "),[,i]=Kw(e.fontSize),n=t.append("text");n.attr("x",e.x),n.attr("y",e.y),n.style("text-anchor",e.anchor),n.style("font-family",e.fontFamily),n.style("font-size",i),n.style("font-weight",e.fontWeight),n.attr("fill",e.fill),void 0!==e.class&&n.attr("class",e.class);let a=n.append("tspan");return a.attr("x",e.x+2*e.textMargin),a.attr("fill",e.fill),a.text(r),n},"drawSimpleText"),jw=Hb((t,e,r)=>{if(!t||(r=Object.assign({fontSize:12,fontWeight:400,fontFamily:"Arial",joinWith:"<br/>"},r),Wr.lineBreakRegex.test(t)))return t;let i=t.split(" ").filter(Boolean),n=[],a="";return i.forEach((t,o)=>{let s=Uw(`${t} `,r),l=Uw(a,r);if(s>e){let{hyphenatedStrings:i,remainingWord:o}=Ww(t,e,"-",r);n.push(a,...i),a=o}else l+s>=e?(n.push(a),a=t):a=[a,t].filter(Boolean).join(" ");o+1===i.length&&n.push(a)}),n.filter(t=>""!==t).join(r.joinWith)},(t,e,r)=>`${t}${e}${r.fontSize}${r.fontWeight}${r.fontFamily}${r.joinWith}`),Ww=Hb((t,e,r="-",i)=>{i=Object.assign({fontSize:12,fontWeight:400,fontFamily:"Arial",margin:0},i);let n=[...t],a=[],o="";return n.forEach((t,s)=>{let l=`${o}${t}`;if(Uw(l,i)>=e){let t=s+1,e=n.length===t,i=`${l}${r}`;a.push(e?l:i),o=""}else o=l}),{hyphenatedStrings:a,remainingWord:o}},(t,e,r="-",i)=>`${t}${e}${r}${i.fontSize}${i.fontWeight}${i.fontFamily}`);function Hw(t,e){return Vw(t,e).height}function Uw(t,e){return Vw(t,e).width}s(Hw,"calculateTextHeight"),s(Uw,"calculateTextWidth");var Yw,Vw=Hb((t,e)=>{let{fontSize:r=12,fontFamily:i="Arial",fontWeight:n=400}=e;if(!t)return{width:0,height:0};let[,a]=Kw(r),o=["sans-serif",i],s=t.split(Wr.lineBreakRegex),l=[],h=ro("body");if(!h.remove)return{width:0,height:0,lineHeight:0};let c=h.append("svg");for(let t of o){let e=0,r={width:0,height:0,lineHeight:0};for(let i of s){let o=zw();o.text=i||"​";let s=qw(c,o).style("font-size",a).style("font-weight",n).style("font-family",t),l=(s._groups||s)[0][0].getBBox();if(0===l.width&&0===l.height)throw new Error("svg element not in render tree");r.width=Math.round(Math.max(r.width,l.width)),e=Math.round(l.height),r.height+=e,r.lineHeight=Math.round(Math.max(r.lineHeight,e))}l.push(r)}return c.remove(),l[isNaN(l[1].height)||isNaN(l[1].width)||isNaN(l[1].lineHeight)||l[0].height>l[1].height&&l[0].width>l[1].width&&l[0].lineHeight>l[1].lineHeight?0:1]},(t,e)=>`${t}${e.fontSize}${e.fontWeight}${e.fontFamily}`),Gw=class{constructor(t=!1,e){this.count=0,this.count=e?e.length:0,this.next=t?()=>this.count++:()=>Date.now()}static{s(this,"InitIDGenerator")}},Xw=s(function(t){return Yw=Yw||document.createElement("div"),t=escape(t).replace(/%26/g,"&").replace(/%23/g,"#").replace(/%3B/g,";"),Yw.innerHTML=t,unescape(Yw.textContent)},"entityDecode");function Zw(t){return"str"in t}s(Zw,"isDetailedError");var Qw=s((t,e,r,i)=>{if(!i)return;let n=t.node()?.getBBox();n&&t.append("text").text(i).attr("text-anchor","middle").attr("x",n.x+n.width/2).attr("y",-r).attr("class",e)},"insertTitle"),Kw=s(t=>{if("number"==typeof t)return[t,t+"px"];let e=parseInt(t??"",10);return Number.isNaN(e)?[void 0,void 0]:t===String(e)?[e,t+"px"]:[e,t]},"parseFontSize");function Jw(t,e){return yw({},t,e)}s(Jw,"cleanAndMerge");var t_={assignWithDepth:A,wrapLabel:jw,calculateTextHeight:Hw,calculateTextWidth:Uw,calculateTextDimensions:Vw,cleanAndMerge:Jw,detectInit:kw,detectDirective:ww,isSubstringInArray:vw,interpolateToCurve:Sw,calcLabelPosition:Fw,calcCardinalityPosition:Ew,calcTerminalLabelPosition:Dw,formatUrl:Tw,getStylesFromArray:Ow,generateId:Nw,random:Pw,runFunc:Mw,entityDecode:Xw,insertTitle:Qw,parseFontSize:Kw,InitIDGenerator:Gw},e_=s(function(t){let e=t;return e=e.replace(/style.*:\S*#.*;/g,function(t){return t.substring(0,t.length-1)}),e=e.replace(/classDef.*:\S*#.*;/g,function(t){return t.substring(0,t.length-1)}),e=e.replace(/#\w+;/g,function(t){let e=t.substring(1,t.length-1);return/^\+?\d+$/.test(e)?"ﬂ°°"+e+"¶ß":"ﬂ°"+e+"¶ß"}),e},"encodeEntities"),r_=s(function(t){return t.replace(/ﬂ°°/g,"&#").replace(/ﬂ°/g,"&").replace(/¶ß/g,";")},"decodeEntities"),i_=s((t,e,{counter:r=0,prefix:i,suffix:n},a)=>a||`${i?`${i}_`:""}${t}_${e}_${r}${n?`_${n}`:""}`,"getEdgeId");function n_(t){return t??null}s(n_,"handleUndefinedAttr");var a_=l((t,e)=>{var r=1e3,i=60*r,n=60*i,a=24*n,o=7*a;function l(t){if(!((t=String(t)).length>100)){var e=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(t);if(e){var s=parseFloat(e[1]);switch((e[2]||"ms").toLowerCase()){case"years":case"year":case"yrs":case"yr":case"y":return 315576e5*s;case"weeks":case"week":case"w":return s*o;case"days":case"day":case"d":return s*a;case"hours":case"hour":case"hrs":case"hr":case"h":return s*n;case"minutes":case"minute":case"mins":case"min":case"m":return s*i;case"seconds":case"second":case"secs":case"sec":case"s":return s*r;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return s;default:return}}}}function h(t){var e=Math.abs(t);return e>=a?Math.round(t/a)+"d":e>=n?Math.round(t/n)+"h":e>=i?Math.round(t/i)+"m":e>=r?Math.round(t/r)+"s":t+"ms"}function c(t){var e=Math.abs(t);return e>=a?u(t,e,a,"day"):e>=n?u(t,e,n,"hour"):e>=i?u(t,e,i,"minute"):e>=r?u(t,e,r,"second"):t+" ms"}function u(t,e,r,i){var n=e>=1.5*r;return Math.round(t/r)+" "+i+(n?"s":"")}e.exports=function(t,e){e=e||{};var r=typeof t;if("string"===r&&t.length>0)return l(t);if("number"===r&&isFinite(t))return e.long?c(t):h(t);throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(t))},s(l,"parse"),s(h,"fmtShort"),s(c,"fmtLong"),s(u,"plural")}),o_=l((t,e)=>{function r(t){function e(t){let e=0;for(let r=0;r<t.length;r++)e=(e<<5)-e+t.charCodeAt(r),e|=0;return r.colors[Math.abs(e)%r.colors.length]}function r(t){let e,n,a,o=null;function l(...t){if(!l.enabled)return;let i=l,n=Number(new Date),a=n-(e||n);i.diff=a,i.prev=e,i.curr=n,e=n,t[0]=r.coerce(t[0]),"string"!=typeof t[0]&&t.unshift("%O");let o=0;t[0]=t[0].replace(/%([a-zA-Z%])/g,(e,n)=>{if("%%"===e)return"%";o++;let a=r.formatters[n];if("function"==typeof a){let r=t[o];e=a.call(i,r),t.splice(o,1),o--}return e}),r.formatArgs.call(i,t),(i.log||r.log).apply(i,t)}return s(l,"debug"),l.namespace=t,l.useColors=r.useColors(),l.color=r.selectColor(t),l.extend=i,l.destroy=r.destroy,Object.defineProperty(l,"enabled",{enumerable:!0,configurable:!1,get:s(()=>null!==o?o:(n!==r.namespaces&&(n=r.namespaces,a=r.enabled(t)),a),"get"),set:s(t=>{o=t},"set")}),"function"==typeof r.init&&r.init(l),l}function i(t,e){let i=r(this.namespace+(typeof e>"u"?":":e)+t);return i.log=this.log,i}function n(t){r.save(t),r.namespaces=t,r.names=[],r.skips=[];let e=("string"==typeof t?t:"").trim().replace(" ",",").split(",").filter(Boolean);for(let t of e)"-"===t[0]?r.skips.push(t.slice(1)):r.names.push(t)}function a(t,e){let r=0,i=0,n=-1,a=0;for(;r<t.length;)if(i<e.length&&(e[i]===t[r]||"*"===e[i]))"*"===e[i]?(n=i,a=r,i++):(r++,i++);else{if(-1===n)return!1;i=n+1,a++,r=a}for(;i<e.length&&"*"===e[i];)i++;return i===e.length}function o(){let t=[...r.names,...r.skips.map(t=>"-"+t)].join(",");return r.enable(""),t}function l(t){for(let e of r.skips)if(a(t,e))return!1;for(let e of r.names)if(a(t,e))return!0;return!1}function h(t){return t instanceof Error?t.stack||t.message:t}function c(){console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.")}return r.debug=r,r.default=r,r.coerce=h,r.disable=o,r.enable=n,r.enabled=l,r.humanize=a_(),r.destroy=c,Object.keys(t).forEach(e=>{r[e]=t[e]}),r.names=[],r.skips=[],r.formatters={},s(e,"selectColor"),r.selectColor=e,s(r,"createDebug"),s(i,"extend"),s(n,"enable"),s(a,"matchesTemplate"),s(o,"disable"),s(l,"enabled"),s(h,"coerce"),s(c,"destroy"),r.enable(r.load()),r}s(r,"setup"),e.exports=r}),s_=l((t,e)=>{function r(){if(typeof window<"u"&&window.process&&("renderer"===window.process.type||window.process.__nwjs))return!0;if(typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/))return!1;let t;return typeof document<"u"&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||typeof window<"u"&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||typeof navigator<"u"&&navigator.userAgent&&(t=navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/))&&parseInt(t[1],10)>=31||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)}function i(t){if(t[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+t[0]+(this.useColors?"%c ":" ")+"+"+e.exports.humanize(this.diff),!this.useColors)return;let r="color: "+this.color;t.splice(1,0,r,"color: inherit");let i=0,n=0;t[0].replace(/%[a-zA-Z%]/g,t=>{"%%"!==t&&(i++,"%c"===t&&(n=i))}),t.splice(n,0,r)}function n(e){try{e?t.storage.setItem("debug",e):t.storage.removeItem("debug")}catch{}}function a(){let e;try{e=t.storage.getItem("debug")}catch{}return!e&&typeof process<"u"&&"env"in process&&(e=process.env.DEBUG),e}function o(){try{return localStorage}catch{}}t.formatArgs=i,t.save=n,t.load=a,t.useColors=r,t.storage=o(),t.destroy=(()=>{let t=!1;return()=>{t||(t=!0,console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."))}})(),t.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#FF33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"],s(r,"useColors"),s(i,"formatArgs"),t.log=console.debug||console.log||(()=>{}),s(n,"save"),s(a,"load"),s(o,"localstorage"),e.exports=o_()(t);var{formatters:l}=e.exports;l.j=function(t){try{return JSON.stringify(t)}catch(t){return"[UnexpectedJSONParseError]: "+t.message}}}),l_=Object.freeze({left:0,top:0,width:16,height:16}),h_=Object.freeze({rotate:0,vFlip:!1,hFlip:!1}),c_=Object.freeze({...l_,...h_}),u_=Object.freeze({...c_,body:"",hidden:!1}),d_=Object.freeze({width:null,height:null}),p_=Object.freeze({...d_,...h_}),f_=s((t,e,r,i="")=>{let n=t.split(":");if("@"===t.slice(0,1)){if(n.length<2||n.length>3)return null;i=n.shift().slice(1)}if(n.length>3||!n.length)return null;if(n.length>1){let t=n.pop(),r=n.pop(),a={provider:n.length>0?n[0]:i,prefix:r,name:t};return e&&!g_(a)?null:a}let a=n[0],o=a.split("-");if(o.length>1){let t={provider:i,prefix:o.shift(),name:o.join("-")};return e&&!g_(t)?null:t}if(r&&""===i){let t={provider:i,prefix:"",name:a};return e&&!g_(t,r)?null:t}return null},"stringToIcon"),g_=s((t,e)=>!!t&&!(!(e&&""===t.prefix||t.prefix)||!t.name),"validateIconName");function y_(t,e){let r={};!t.hFlip!=!e.hFlip&&(r.hFlip=!0),!t.vFlip!=!e.vFlip&&(r.vFlip=!0);let i=((t.rotate||0)+(e.rotate||0))%4;return i&&(r.rotate=i),r}function m_(t,e){let r=y_(t,e);for(let i in u_)i in h_?i in t&&!(i in r)&&(r[i]=h_[i]):i in e?r[i]=e[i]:i in t&&(r[i]=t[i]);return r}function x_(t,e){let r=t.icons,i=t.aliases||Object.create(null),n=Object.create(null);function a(t){if(r[t])return n[t]=[];if(!(t in n)){n[t]=null;let e=i[t]&&i[t].parent,r=e&&a(e);r&&(n[t]=[e].concat(r))}return n[t]}return s(a,"resolve"),(e||Object.keys(r).concat(Object.keys(i))).forEach(a),n}function b_(t,e,r){let i=t.icons,n=t.aliases||Object.create(null),a={};function o(t){a=m_(i[t]||n[t],a)}return s(o,"parse"),o(e),r.forEach(o),m_(t,a)}function C_(t,e){if(t.icons[e])return b_(t,e,[]);let r=x_(t,[e])[e];return r?b_(t,e,r):null}s(y_,"mergeIconTransformations"),s(m_,"mergeIconData"),s(x_,"getIconsTree"),s(b_,"internalGetIconData"),s(C_,"getIconData");var k_=/(-?[0-9.]*[0-9]+[0-9.]*)/g,w_=/^-?[0-9.]*[0-9]+[0-9.]*$/g;function __(t,e,r){if(1===e)return t;if(r=r||100,"number"==typeof t)return Math.ceil(t*e*r)/r;if("string"!=typeof t)return t;let i=t.split(k_);if(null===i||!i.length)return t;let n=[],a=i.shift(),o=w_.test(a);for(;;){if(o){let t=parseFloat(a);isNaN(t)?n.push(a):n.push(Math.ceil(t*e*r)/r)}else n.push(a);if(a=i.shift(),void 0===a)return n.join("");o=!o}}function v_(t,e="defs"){let r="",i=t.indexOf("<"+e);for(;i>=0;){let n=t.indexOf(">",i),a=t.indexOf("</"+e);if(-1===n||-1===a)break;let o=t.indexOf(">",a);if(-1===o)break;r+=t.slice(n+1,a).trim(),t=t.slice(0,i).trim()+t.slice(o+1)}return{defs:r,content:t}}function S_(t,e){return t?"<defs>"+t+"</defs>"+e:e}function T_(t,e,r){let i=v_(t);return S_(i.defs,e+i.content+r)}s(__,"calculateSize"),s(v_,"splitSVGDefs"),s(S_,"mergeDefsAndContent"),s(T_,"wrapSVGContent");var M_=s(t=>"unset"===t||"undefined"===t||"none"===t,"isUnsetKeyword");function B_(t,e){let r={...c_,...t},i={...p_,...e},n={left:r.left,top:r.top,width:r.width,height:r.height},a=r.body;[r,i].forEach(t=>{let e,r=[],i=t.hFlip,o=t.vFlip,s=t.rotate;switch(i?o?s+=2:(r.push("translate("+(n.width+n.left).toString()+" "+(0-n.top).toString()+")"),r.push("scale(-1 1)"),n.top=n.left=0):o&&(r.push("translate("+(0-n.left).toString()+" "+(n.height+n.top).toString()+")"),r.push("scale(1 -1)"),n.top=n.left=0),s<0&&(s-=4*Math.floor(s/4)),s%=4,s){case 1:e=n.height/2+n.top,r.unshift("rotate(90 "+e.toString()+" "+e.toString()+")");break;case 2:r.unshift("rotate(180 "+(n.width/2+n.left).toString()+" "+(n.height/2+n.top).toString()+")");break;case 3:e=n.width/2+n.left,r.unshift("rotate(-90 "+e.toString()+" "+e.toString()+")")}s%2==1&&(n.left!==n.top&&(e=n.left,n.left=n.top,n.top=e),n.width!==n.height&&(e=n.width,n.width=n.height,n.height=e)),r.length&&(a=T_(a,'<g transform="'+r.join(" ")+'">',"</g>"))});let o,l,h=i.width,c=i.height,u=n.width,d=n.height;null===h?(l=null===c?"1em":"auto"===c?d:c,o=__(l,u/d)):(o="auto"===h?u:h,l=null===c?__(o,d/u):"auto"===c?d:c);let p={},f=s((t,e)=>{M_(e)||(p[t]=e.toString())},"setAttr");f("width",o),f("height",l);let g=[n.left,n.top,u,d];return p.viewBox=g.join(" "),{attributes:p,viewBox:g,body:a}}s(B_,"iconToSVG");var A_=/\sid="(\S+)"/g,F_="IconifyId"+Date.now().toString(16)+(16777216*Math.random()|0).toString(16),L_=0;function $_(t,e=F_){let r,i=[];for(;r=A_.exec(t);)i.push(r[1]);if(!i.length)return t;let n="suffix"+(16777216*Math.random()|Date.now()).toString(16);return i.forEach(r=>{let i="function"==typeof e?e(r):e+(L_++).toString(),a=r.replace(/[.*+?^${}()|[\]\\]/g,"\\$&");t=t.replace(new RegExp('([#;"])('+a+')([")]|\\.[a-z])',"g"),"$1"+i+n+"$3")}),t=t.replace(new RegExp(n,"g"),"")}function E_(t,e){let r=-1===t.indexOf("xlink:")?"":' xmlns:xlink="http://www.w3.org/1999/xlink"';for(let t in e)r+=" "+t+'="'+e[t]+'"';return'<svg xmlns="http://www.w3.org/2000/svg"'+r+">"+t+"</svg>"}s($_,"replaceIDs"),s(E_,"iconToHTML"),d(s_());var D_={body:'<g><rect width="80" height="80" style="fill: #087ebf; stroke-width: 0px;"/><text transform="translate(21.16 64.67)" style="fill: #fff; font-family: ArialMT, Arial; font-size: 67.75px;"><tspan x="0" y="0">?</tspan></text></g>',height:80,width:80},O_=new Map,I_=new Map,N_=s(t=>{for(let e of t){if(!e.name)throw new Error('Invalid icon loader. Must have a "name" property with non-empty string value.');if(y.debug("Registering icon pack:",e.name),"loader"in e)I_.set(e.name,e.loader);else{if(!("icons"in e))throw y.error("Invalid icon loader:",e),new Error('Invalid icon loader. Must have either "icons" or "loader" property.');O_.set(e.name,e.icons)}}},"registerIconPacks"),R_=s(async(t,e)=>{let r=f_(t,!0,void 0!==e);if(!r)throw new Error(`Invalid icon name: ${t}`);let i=r.prefix||e;if(!i)throw new Error(`Icon name must contain a prefix: ${t}`);let n=O_.get(i);if(!n){let t=I_.get(i);if(!t)throw new Error(`Icon set not found: ${r.prefix}`);try{n={...await t(),prefix:i},O_.set(i,n)}catch(t){throw y.error(t),new Error(`Failed to load icon set: ${r.prefix}`)}}let a=C_(n,r.name);if(!a)throw new Error(`Icon not found: ${t}`);return a},"getRegisteredIconData"),P_=s(async t=>{try{return await R_(t),!0}catch{return!1}},"isIconAvailable"),z_=s(async(t,e,r)=>{let i;try{i=await R_(t,e?.fallbackPrefix)}catch(t){y.error(t),i=D_}let n=B_(i,e);return E_($_(n.body),{...n.attributes,...r})},"getIconSVG");function q_(t){for(var e=[],r=1;r<arguments.length;r++)e[r-1]=arguments[r];var i=Array.from("string"==typeof t?[t]:t);i[i.length-1]=i[i.length-1].replace(/\r?\n([\t ]*)$/,"");var n=i.reduce(function(t,e){var r=e.match(/\n([\t ]+|(?!\s).)/g);return r?t.concat(r.map(function(t){var e,r;return null!==(r=null===(e=t.match(/[\t ]/g))||void 0===e?void 0:e.length)&&void 0!==r?r:0})):t},[]);if(n.length){var a=new RegExp("\n[\t ]{"+Math.min.apply(Math,n)+"}","g");i=i.map(function(t){return t.replace(a,"\n")})}i[0]=i[0].replace(/^\r?\n/,"");var o=i[0];return e.forEach(function(t,e){var r=o.match(/(?:^|\n)( *)$/),n=r?r[1]:"",a=t;"string"==typeof t&&t.includes("\n")&&(a=String(t).split("\n").map(function(t,e){return 0===e?t:""+n+t}).join("\n")),o+=a+i[e+1]}),o}function j_(){return{async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null}}s(q_,"dedent"),s(j_,"M");var W_={async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null};function H_(t){W_=t}s(H_,"H");var U_={exec:s(()=>null,"exec")};function Y_(t,e=""){let r="string"==typeof t?t:t.source,i={replace:s((t,e)=>{let n="string"==typeof e?e:e.source;return n=n.replace(V_.caret,"$1"),r=r.replace(t,n),i},"replace"),getRegex:s(()=>new RegExp(r,e),"getRegex")};return i}s(Y_,"h");var V_={codeRemoveIndent:/^(?: {1,4}| {0,3}\t)/gm,outputLinkReplace:/\\([\[\]])/g,indentCodeCompensation:/^(\s+)(?:```)/,beginningSpace:/^\s+/,endingHash:/#$/,startingSpaceChar:/^ /,endingSpaceChar:/ $/,nonSpaceChar:/[^ ]/,newLineCharGlobal:/\n/g,tabCharGlobal:/\t/g,multipleSpaceGlobal:/\s+/g,blankLine:/^[ \t]*$/,doubleBlankLine:/\n[ \t]*\n[ \t]*$/,blockquoteStart:/^ {0,3}>/,blockquoteSetextReplace:/\n {0,3}((?:=+|-+) *)(?=\n|$)/g,blockquoteSetextReplace2:/^ {0,3}>[ \t]?/gm,listReplaceTabs:/^\t+/,listReplaceNesting:/^ {1,4}(?=( {4})*[^ ])/g,listIsTask:/^\[[ xX]\] /,listReplaceTask:/^\[[ xX]\] +/,anyLine:/\n.*\n/,hrefBrackets:/^<(.*)>$/,tableDelimiter:/[:|]/,tableAlignChars:/^\||\| *$/g,tableRowBlankLine:/\n[ \t]*$/,tableAlignRight:/^ *-+: *$/,tableAlignCenter:/^ *:-+: *$/,tableAlignLeft:/^ *:-+ *$/,startATag:/^<a /i,endATag:/^<\/a>/i,startPreScriptTag:/^<(pre|code|kbd|script)(\s|>)/i,endPreScriptTag:/^<\/(pre|code|kbd|script)(\s|>)/i,startAngleBracket:/^</,endAngleBracket:/>$/,pedanticHrefTitle:/^([^'"]*[^\s])\s+(['"])(.*)\2/,unicodeAlphaNumeric:/[\p{L}\p{N}]/u,escapeTest:/[&<>"']/,escapeReplace:/[&<>"']/g,escapeTestNoEncode:/[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/,escapeReplaceNoEncode:/[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/g,unescapeTest:/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi,caret:/(^|[^\[])\^/g,percentDecode:/%25/g,findPipe:/\|/g,splitPipe:/ \|/,slashPipe:/\\\|/g,carriageReturn:/\r\n|\r/g,spaceLine:/^ +$/gm,notSpaceStart:/^\S*/,endingNewline:/\n$/,listItemRegex:s(t=>new RegExp(`^( {0,3}${t})((?:[\t ][^\\n]*)?(?:\\n|$))`),"listItemRegex"),nextBulletRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}(?:[*+-]|\\d{1,9}[.)])((?:[ \t][^\\n]*)?(?:\\n|$))`),"nextBulletRegex"),hrRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)`),"hrRegex"),fencesBeginRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}(?:\`\`\`|~~~)`),"fencesBeginRegex"),headingBeginRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}#`),"headingBeginRegex"),htmlBeginRegex:s(t=>new RegExp(`^ {0,${Math.min(3,t-1)}}<(?:[a-z].*>|!--)`,"i"),"htmlBeginRegex")},G_=/^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/,X_=/(?:[*+-]|\d{1,9}[.)])/,Z_=/^(?!bull |blockCode|fences|blockquote|heading|html|table)((?:.|\n(?!\s*?\n|bull |blockCode|fences|blockquote|heading|html|table))+?)\n {0,3}(=+|-+) *(?:\n+|$)/,Q_=Y_(Z_).replace(/bull/g,X_).replace(/blockCode/g,/(?: {4}| {0,3}\t)/).replace(/fences/g,/ {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g,/ {0,3}>/).replace(/heading/g,/ {0,3}#{1,6}/).replace(/html/g,/ {0,3}<[^\n>]+>\n/).replace(/\|table/g,"").getRegex(),K_=Y_(Z_).replace(/bull/g,X_).replace(/blockCode/g,/(?: {4}| {0,3}\t)/).replace(/fences/g,/ {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g,/ {0,3}>/).replace(/heading/g,/ {0,3}#{1,6}/).replace(/html/g,/ {0,3}<[^\n>]+>\n/).replace(/table/g,/ {0,3}\|?(?:[:\- ]*\|)+[\:\- ]*\n/).getRegex(),J_=/^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/,tv=/(?!\s*\])(?:\\.|[^\[\]\\])+/,ev=Y_(/^ {0,3}\[(label)\]: *(?:\n[ \t]*)?([^<\s][^\s]*|<.*?>)(?:(?: +(?:\n[ \t]*)?| *\n[ \t]*)(title))? *(?:\n+|$)/).replace("label",tv).replace("title",/(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/).getRegex(),rv=Y_(/^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/).replace(/bull/g,X_).getRegex(),iv="address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|search|section|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul",nv=/<!--(?:-?>|[\s\S]*?(?:-->|$))/,av=Y_("^ {0,3}(?:<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n[ \t]*)+\\n|$)|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n[ \t]*)+\\n|$)|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n[ \t]*)+\\n|$))","i").replace("comment",nv).replace("tag",iv).replace("attribute",/ +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(),ov=Y_(J_).replace("hr",G_).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("|lheading","").replace("|table","").replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",iv).getRegex(),sv={blockquote:Y_(/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/).replace("paragraph",ov).getRegex(),code:/^((?: {4}| {0,3}\t)[^\n]+(?:\n(?:[ \t]*(?:\n|$))*)?)+/,def:ev,fences:/^ {0,3}(`{3,}(?=[^`\n]*(?:\n|$))|~{3,})([^\n]*)(?:\n|$)(?:|([\s\S]*?)(?:\n|$))(?: {0,3}\1[~`]* *(?=\n|$)|$)/,heading:/^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,hr:G_,html:av,lheading:Q_,list:rv,newline:/^(?:[ \t]*(?:\n|$))+/,paragraph:ov,table:U_,text:/^[^\n]+/},lv=Y_("^ *([^\\n ].*)\\n {0,3}((?:\\| *)?:?-+:? *(?:\\| *:?-+:? *)*(?:\\| *)?)(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)").replace("hr",G_).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("blockquote"," {0,3}>").replace("code","(?: {4}| {0,3}\t)[^\\n]").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",iv).getRegex(),hv={...sv,lheading:K_,table:lv,paragraph:Y_(J_).replace("hr",G_).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("|lheading","").replace("table",lv).replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",iv).getRegex()},cv={...sv,html:Y_("^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:\"[^\"]*\"|'[^']*'|\\s[^'\"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))").replace("comment",nv).replace(/tag/g,"(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(),def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,heading:/^(#{1,6})(.*)(?:\n+|$)/,fences:U_,lheading:/^(.+?)\n {0,3}(=+|-+) *(?:\n+|$)/,paragraph:Y_(J_).replace("hr",G_).replace("heading"," *#{1,6} *[^\n]").replace("lheading",Q_).replace("|table","").replace("blockquote"," {0,3}>").replace("|fences","").replace("|list","").replace("|html","").replace("|tag","").getRegex()},uv=/^( {2,}|\\)\n(?!\s*$)/,dv=/[\p{P}\p{S}]/u,pv=/[\s\p{P}\p{S}]/u,fv=/[^\s\p{P}\p{S}]/u,gv=Y_(/^((?![*_])punctSpace)/,"u").replace(/punctSpace/g,pv).getRegex(),yv=/(?!~)[\p{P}\p{S}]/u,mv=/^(?:\*+(?:((?!\*)punct)|[^\s*]))|^_+(?:((?!_)punct)|([^\s_]))/,xv=Y_(mv,"u").replace(/punct/g,dv).getRegex(),bv=Y_(mv,"u").replace(/punct/g,yv).getRegex(),Cv="^[^_*]*?__[^_*]*?\\*[^_*]*?(?=__)|[^*]+(?=[^*])|(?!\\*)punct(\\*+)(?=[\\s]|$)|notPunctSpace(\\*+)(?!\\*)(?=punctSpace|$)|(?!\\*)punctSpace(\\*+)(?=notPunctSpace)|[\\s](\\*+)(?!\\*)(?=punct)|(?!\\*)punct(\\*+)(?!\\*)(?=punct)|notPunctSpace(\\*+)(?=notPunctSpace)",kv=Y_(Cv,"gu").replace(/notPunctSpace/g,fv).replace(/punctSpace/g,pv).replace(/punct/g,dv).getRegex(),wv=Y_(Cv,"gu").replace(/notPunctSpace/g,/(?:[^\s\p{P}\p{S}]|~)/u).replace(/punctSpace/g,/(?!~)[\s\p{P}\p{S}]/u).replace(/punct/g,yv).getRegex(),_v=Y_("^[^_*]*?\\*\\*[^_*]*?_[^_*]*?(?=\\*\\*)|[^_]+(?=[^_])|(?!_)punct(_+)(?=[\\s]|$)|notPunctSpace(_+)(?!_)(?=punctSpace|$)|(?!_)punctSpace(_+)(?=notPunctSpace)|[\\s](_+)(?!_)(?=punct)|(?!_)punct(_+)(?!_)(?=punct)","gu").replace(/notPunctSpace/g,fv).replace(/punctSpace/g,pv).replace(/punct/g,dv).getRegex(),vv=Y_(/\\(punct)/,"gu").replace(/punct/g,dv).getRegex(),Sv=Y_(/^<(scheme:[^\s\x00-\x1f<>]*|email)>/).replace("scheme",/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/).replace("email",/[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/).getRegex(),Tv=Y_(nv).replace("(?:--\x3e|$)","--\x3e").getRegex(),Mv=Y_("^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>").replace("comment",Tv).replace("attribute",/\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/).getRegex(),Bv=/(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/,Av=Y_(/^!?\[(label)\]\(\s*(href)(?:(?:[ \t]*(?:\n[ \t]*)?)(title))?\s*\)/).replace("label",Bv).replace("href",/<(?:\\.|[^\n<>\\])+>|[^ \t\n\x00-\x1f]*/).replace("title",/"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/).getRegex(),Fv=Y_(/^!?\[(label)\]\[(ref)\]/).replace("label",Bv).replace("ref",tv).getRegex(),Lv=Y_(/^!?\[(ref)\](?:\[\])?/).replace("ref",tv).getRegex(),$v={_backpedal:U_,anyPunctuation:vv,autolink:Sv,blockSkip:/\[[^[\]]*?\]\((?:\\.|[^\\\(\)]|\((?:\\.|[^\\\(\)])*\))*\)|`[^`]*?`|<[^<>]*?>/g,br:uv,code:/^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,del:U_,emStrongLDelim:xv,emStrongRDelimAst:kv,emStrongRDelimUnd:_v,escape:/^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,link:Av,nolink:Lv,punctuation:gv,reflink:Fv,reflinkSearch:Y_("reflink|nolink(?!\\()","g").replace("reflink",Fv).replace("nolink",Lv).getRegex(),tag:Mv,text:/^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,url:U_},Ev={...$v,link:Y_(/^!?\[(label)\]\((.*?)\)/).replace("label",Bv).getRegex(),reflink:Y_(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label",Bv).getRegex()},Dv={...$v,emStrongRDelimAst:wv,emStrongLDelim:bv,url:Y_(/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,"i").replace("email",/[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/).getRegex(),_backpedal:/(?:[^?!.,:;*_'"~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_'"~)]+(?!$))+/,del:/^(~~?)(?=[^\s~])((?:\\.|[^\\])*?(?:\\.|[^\s~\\]))\1(?=[^~]|$)/,text:/^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/},Ov={...Dv,br:Y_(uv).replace("{2,}","*").getRegex(),text:Y_(Dv.text).replace("\\b_","\\b_| {2,}\\n").replace(/\{2,\}/g,"*").getRegex()},Iv={normal:sv,gfm:hv,pedantic:cv},Nv={normal:$v,gfm:Dv,breaks:Ov,pedantic:Ev},Rv={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"},Pv=s(t=>Rv[t],"ge");function zv(t,e){if(e){if(V_.escapeTest.test(t))return t.replace(V_.escapeReplace,Pv)}else if(V_.escapeTestNoEncode.test(t))return t.replace(V_.escapeReplaceNoEncode,Pv);return t}function qv(t){try{t=encodeURI(t).replace(V_.percentDecode,"%")}catch{return null}return t}function jv(t,e){let r=t.replace(V_.findPipe,(t,e,r)=>{let i=!1,n=e;for(;--n>=0&&"\\"===r[n];)i=!i;return i?"|":" |"}),i=r.split(V_.splitPipe),n=0;if(i[0].trim()||i.shift(),i.length>0&&!i.at(-1)?.trim()&&i.pop(),e)if(i.length>e)i.splice(e);else for(;i.length<e;)i.push("");for(;n<i.length;n++)i[n]=i[n].trim().replace(V_.slashPipe,"|");return i}function Wv(t,e,r){let i=t.length;if(0===i)return"";let n=0;for(;n<i;){let a=t.charAt(i-n-1);if(a!==e||r){if(a===e||!r)break;n++}else n++}return t.slice(0,i-n)}function Hv(t,e){if(-1===t.indexOf(e[1]))return-1;let r=0;for(let i=0;i<t.length;i++)if("\\"===t[i])i++;else if(t[i]===e[0])r++;else if(t[i]===e[1]&&(r--,r<0))return i;return r>0?-2:-1}function Uv(t,e,r,i,n){let a=e.href,o=e.title||null,s=t[1].replace(n.other.outputLinkReplace,"$1");i.state.inLink=!0;let l={type:"!"===t[0].charAt(0)?"image":"link",raw:r,href:a,title:o,text:s,tokens:i.inlineTokens(s)};return i.state.inLink=!1,l}function Yv(t,e,r){let i=t.match(r.other.indentCodeCompensation);if(null===i)return e;let n=i[1];return e.split("\n").map(t=>{let e=t.match(r.other.beginningSpace);if(null===e)return t;let[i]=e;return i.length>=n.length?t.slice(n.length):t}).join("\n")}s(zv,"R"),s(qv,"J"),s(jv,"V"),s(Wv,"A"),s(Hv,"fe"),s(Uv,"de"),s(Yv,"Je");var Vv=class{static{s(this,"S")}options;rules;lexer;constructor(t){this.options=t||W_}space(t){let e=this.rules.block.newline.exec(t);if(e&&e[0].length>0)return{type:"space",raw:e[0]}}code(t){let e=this.rules.block.code.exec(t);if(e){let t=e[0].replace(this.rules.other.codeRemoveIndent,"");return{type:"code",raw:e[0],codeBlockStyle:"indented",text:this.options.pedantic?t:Wv(t,"\n")}}}fences(t){let e=this.rules.block.fences.exec(t);if(e){let t=e[0],r=Yv(t,e[3]||"",this.rules);return{type:"code",raw:t,lang:e[2]?e[2].trim().replace(this.rules.inline.anyPunctuation,"$1"):e[2],text:r}}}heading(t){let e=this.rules.block.heading.exec(t);if(e){let t=e[2].trim();if(this.rules.other.endingHash.test(t)){let e=Wv(t,"#");(this.options.pedantic||!e||this.rules.other.endingSpaceChar.test(e))&&(t=e.trim())}return{type:"heading",raw:e[0],depth:e[1].length,text:t,tokens:this.lexer.inline(t)}}}hr(t){let e=this.rules.block.hr.exec(t);if(e)return{type:"hr",raw:Wv(e[0],"\n")}}blockquote(t){let e=this.rules.block.blockquote.exec(t);if(e){let t=Wv(e[0],"\n").split("\n"),r="",i="",n=[];for(;t.length>0;){let e,a=!1,o=[];for(e=0;e<t.length;e++)if(this.rules.other.blockquoteStart.test(t[e]))o.push(t[e]),a=!0;else{if(a)break;o.push(t[e])}t=t.slice(e);let s=o.join("\n"),l=s.replace(this.rules.other.blockquoteSetextReplace,"\n    $1").replace(this.rules.other.blockquoteSetextReplace2,"");r=r?`${r}\n${s}`:s,i=i?`${i}\n${l}`:l;let h=this.lexer.state.top;if(this.lexer.state.top=!0,this.lexer.blockTokens(l,n,!0),this.lexer.state.top=h,0===t.length)break;let c=n.at(-1);if("code"===c?.type)break;if("blockquote"===c?.type){let e=c,a=e.raw+"\n"+t.join("\n"),o=this.blockquote(a);n[n.length-1]=o,r=r.substring(0,r.length-e.raw.length)+o.raw,i=i.substring(0,i.length-e.text.length)+o.text;break}if("list"===c?.type){let e=c,a=e.raw+"\n"+t.join("\n"),o=this.list(a);n[n.length-1]=o,r=r.substring(0,r.length-c.raw.length)+o.raw,i=i.substring(0,i.length-e.raw.length)+o.raw,t=a.substring(n.at(-1).raw.length).split("\n");continue}}return{type:"blockquote",raw:r,tokens:n,text:i}}}list(t){let e=this.rules.block.list.exec(t);if(e){let r=e[1].trim(),i=r.length>1,n={type:"list",raw:"",ordered:i,start:i?+r.slice(0,-1):"",loose:!1,items:[]};r=i?`\\d{1,9}\\${r.slice(-1)}`:`\\${r}`,this.options.pedantic&&(r=i?r:"[*+-]");let a=this.rules.other.listItemRegex(r),o=!1;for(;t;){let r=!1,i="",s="";if(!(e=a.exec(t))||this.rules.block.hr.test(t))break;i=e[0],t=t.substring(i.length);let l=e[2].split("\n",1)[0].replace(this.rules.other.listReplaceTabs,t=>" ".repeat(3*t.length)),h=t.split("\n",1)[0],c=!l.trim(),u=0;if(this.options.pedantic?(u=2,s=l.trimStart()):c?u=e[1].length+1:(u=e[2].search(this.rules.other.nonSpaceChar),u=u>4?1:u,s=l.slice(u),u+=e[1].length),c&&this.rules.other.blankLine.test(h)&&(i+=h+"\n",t=t.substring(h.length+1),r=!0),!r){let e=this.rules.other.nextBulletRegex(u),r=this.rules.other.hrRegex(u),n=this.rules.other.fencesBeginRegex(u),a=this.rules.other.headingBeginRegex(u),o=this.rules.other.htmlBeginRegex(u);for(;t;){let d,p=t.split("\n",1)[0];if(h=p,this.options.pedantic?(h=h.replace(this.rules.other.listReplaceNesting,"  "),d=h):d=h.replace(this.rules.other.tabCharGlobal,"    "),n.test(h)||a.test(h)||o.test(h)||e.test(h)||r.test(h))break;if(d.search(this.rules.other.nonSpaceChar)>=u||!h.trim())s+="\n"+d.slice(u);else{if(c||l.replace(this.rules.other.tabCharGlobal,"    ").search(this.rules.other.nonSpaceChar)>=4||n.test(l)||a.test(l)||r.test(l))break;s+="\n"+h}!c&&!h.trim()&&(c=!0),i+=p+"\n",t=t.substring(p.length+1),l=d.slice(u)}}n.loose||(o?n.loose=!0:this.rules.other.doubleBlankLine.test(i)&&(o=!0));let d,p=null;this.options.gfm&&(p=this.rules.other.listIsTask.exec(s),p&&(d="[ ] "!==p[0],s=s.replace(this.rules.other.listReplaceTask,""))),n.items.push({type:"list_item",raw:i,task:!!p,checked:d,loose:!1,text:s,tokens:[]}),n.raw+=i}let s=n.items.at(-1);if(!s)return;s.raw=s.raw.trimEnd(),s.text=s.text.trimEnd(),n.raw=n.raw.trimEnd();for(let t=0;t<n.items.length;t++)if(this.lexer.state.top=!1,n.items[t].tokens=this.lexer.blockTokens(n.items[t].text,[]),!n.loose){let e=n.items[t].tokens.filter(t=>"space"===t.type),r=e.length>0&&e.some(t=>this.rules.other.anyLine.test(t.raw));n.loose=r}if(n.loose)for(let t=0;t<n.items.length;t++)n.items[t].loose=!0;return n}}html(t){let e=this.rules.block.html.exec(t);if(e)return{type:"html",block:!0,raw:e[0],pre:"pre"===e[1]||"script"===e[1]||"style"===e[1],text:e[0]}}def(t){let e=this.rules.block.def.exec(t);if(e){let t=e[1].toLowerCase().replace(this.rules.other.multipleSpaceGlobal," "),r=e[2]?e[2].replace(this.rules.other.hrefBrackets,"$1").replace(this.rules.inline.anyPunctuation,"$1"):"",i=e[3]?e[3].substring(1,e[3].length-1).replace(this.rules.inline.anyPunctuation,"$1"):e[3];return{type:"def",tag:t,raw:e[0],href:r,title:i}}}table(t){let e=this.rules.block.table.exec(t);if(!e||!this.rules.other.tableDelimiter.test(e[2]))return;let r=jv(e[1]),i=e[2].replace(this.rules.other.tableAlignChars,"").split("|"),n=e[3]?.trim()?e[3].replace(this.rules.other.tableRowBlankLine,"").split("\n"):[],a={type:"table",raw:e[0],header:[],align:[],rows:[]};if(r.length===i.length){for(let t of i)this.rules.other.tableAlignRight.test(t)?a.align.push("right"):this.rules.other.tableAlignCenter.test(t)?a.align.push("center"):this.rules.other.tableAlignLeft.test(t)?a.align.push("left"):a.align.push(null);for(let t=0;t<r.length;t++)a.header.push({text:r[t],tokens:this.lexer.inline(r[t]),header:!0,align:a.align[t]});for(let t of n)a.rows.push(jv(t,a.header.length).map((t,e)=>({text:t,tokens:this.lexer.inline(t),header:!1,align:a.align[e]})));return a}}lheading(t){let e=this.rules.block.lheading.exec(t);if(e)return{type:"heading",raw:e[0],depth:"="===e[2].charAt(0)?1:2,text:e[1],tokens:this.lexer.inline(e[1])}}paragraph(t){let e=this.rules.block.paragraph.exec(t);if(e){let t="\n"===e[1].charAt(e[1].length-1)?e[1].slice(0,-1):e[1];return{type:"paragraph",raw:e[0],text:t,tokens:this.lexer.inline(t)}}}text(t){let e=this.rules.block.text.exec(t);if(e)return{type:"text",raw:e[0],text:e[0],tokens:this.lexer.inline(e[0])}}escape(t){let e=this.rules.inline.escape.exec(t);if(e)return{type:"escape",raw:e[0],text:e[1]}}tag(t){let e=this.rules.inline.tag.exec(t);if(e)return!this.lexer.state.inLink&&this.rules.other.startATag.test(e[0])?this.lexer.state.inLink=!0:this.lexer.state.inLink&&this.rules.other.endATag.test(e[0])&&(this.lexer.state.inLink=!1),!this.lexer.state.inRawBlock&&this.rules.other.startPreScriptTag.test(e[0])?this.lexer.state.inRawBlock=!0:this.lexer.state.inRawBlock&&this.rules.other.endPreScriptTag.test(e[0])&&(this.lexer.state.inRawBlock=!1),{type:"html",raw:e[0],inLink:this.lexer.state.inLink,inRawBlock:this.lexer.state.inRawBlock,block:!1,text:e[0]}}link(t){let e=this.rules.inline.link.exec(t);if(e){let t=e[2].trim();if(!this.options.pedantic&&this.rules.other.startAngleBracket.test(t)){if(!this.rules.other.endAngleBracket.test(t))return;let e=Wv(t.slice(0,-1),"\\");if((t.length-e.length)%2==0)return}else{let t=Hv(e[2],"()");if(-2===t)return;if(t>-1){let r=(0===e[0].indexOf("!")?5:4)+e[1].length+t;e[2]=e[2].substring(0,t),e[0]=e[0].substring(0,r).trim(),e[3]=""}}let r=e[2],i="";if(this.options.pedantic){let t=this.rules.other.pedanticHrefTitle.exec(r);t&&(r=t[1],i=t[3])}else i=e[3]?e[3].slice(1,-1):"";return r=r.trim(),this.rules.other.startAngleBracket.test(r)&&(r=this.options.pedantic&&!this.rules.other.endAngleBracket.test(t)?r.slice(1):r.slice(1,-1)),Uv(e,{href:r&&r.replace(this.rules.inline.anyPunctuation,"$1"),title:i&&i.replace(this.rules.inline.anyPunctuation,"$1")},e[0],this.lexer,this.rules)}}reflink(t,e){let r;if((r=this.rules.inline.reflink.exec(t))||(r=this.rules.inline.nolink.exec(t))){let t=e[(r[2]||r[1]).replace(this.rules.other.multipleSpaceGlobal," ").toLowerCase()];if(!t){let t=r[0].charAt(0);return{type:"text",raw:t,text:t}}return Uv(r,t,r[0],this.lexer,this.rules)}}emStrong(t,e,r=""){let i=this.rules.inline.emStrongLDelim.exec(t);if(!(!i||i[3]&&r.match(this.rules.other.unicodeAlphaNumeric))&&(!i[1]&&!i[2]||!r||this.rules.inline.punctuation.exec(r))){let r,n,a=[...i[0]].length-1,o=a,s=0,l="*"===i[0][0]?this.rules.inline.emStrongRDelimAst:this.rules.inline.emStrongRDelimUnd;for(l.lastIndex=0,e=e.slice(-1*t.length+a);null!=(i=l.exec(e));){if(r=i[1]||i[2]||i[3]||i[4]||i[5]||i[6],!r)continue;if(n=[...r].length,i[3]||i[4]){o+=n;continue}if((i[5]||i[6])&&a%3&&!((a+n)%3)){s+=n;continue}if(o-=n,o>0)continue;n=Math.min(n,n+o+s);let e=[...i[0]][0].length,l=t.slice(0,a+i.index+e+n);if(Math.min(a,n)%2){let t=l.slice(1,-1);return{type:"em",raw:l,text:t,tokens:this.lexer.inlineTokens(t)}}let h=l.slice(2,-2);return{type:"strong",raw:l,text:h,tokens:this.lexer.inlineTokens(h)}}}}codespan(t){let e=this.rules.inline.code.exec(t);if(e){let t=e[2].replace(this.rules.other.newLineCharGlobal," "),r=this.rules.other.nonSpaceChar.test(t),i=this.rules.other.startingSpaceChar.test(t)&&this.rules.other.endingSpaceChar.test(t);return r&&i&&(t=t.substring(1,t.length-1)),{type:"codespan",raw:e[0],text:t}}}br(t){let e=this.rules.inline.br.exec(t);if(e)return{type:"br",raw:e[0]}}del(t){let e=this.rules.inline.del.exec(t);if(e)return{type:"del",raw:e[0],text:e[2],tokens:this.lexer.inlineTokens(e[2])}}autolink(t){let e=this.rules.inline.autolink.exec(t);if(e){let t,r;return"@"===e[2]?(t=e[1],r="mailto:"+t):(t=e[1],r=t),{type:"link",raw:e[0],text:t,href:r,tokens:[{type:"text",raw:t,text:t}]}}}url(t){let e;if(e=this.rules.inline.url.exec(t)){let t,r;if("@"===e[2])t=e[0],r="mailto:"+t;else{let i;do{i=e[0],e[0]=this.rules.inline._backpedal.exec(e[0])?.[0]??""}while(i!==e[0]);t=e[0],r="www."===e[1]?"http://"+e[0]:e[0]}return{type:"link",raw:e[0],text:t,href:r,tokens:[{type:"text",raw:t,text:t}]}}}inlineText(t){let e=this.rules.inline.text.exec(t);if(e){let t=this.lexer.state.inRawBlock;return{type:"text",raw:e[0],text:e[0],escaped:t}}}},Gv=class t{static{s(this,"a")}tokens;options;state;tokenizer;inlineQueue;constructor(t){this.tokens=[],this.tokens.links=Object.create(null),this.options=t||W_,this.options.tokenizer=this.options.tokenizer||new Vv,this.tokenizer=this.options.tokenizer,this.tokenizer.options=this.options,this.tokenizer.lexer=this,this.inlineQueue=[],this.state={inLink:!1,inRawBlock:!1,top:!0};let e={other:V_,block:Iv.normal,inline:Nv.normal};this.options.pedantic?(e.block=Iv.pedantic,e.inline=Nv.pedantic):this.options.gfm&&(e.block=Iv.gfm,this.options.breaks?e.inline=Nv.breaks:e.inline=Nv.gfm),this.tokenizer.rules=e}static get rules(){return{block:Iv,inline:Nv}}static lex(e,r){return new t(r).lex(e)}static lexInline(e,r){return new t(r).inlineTokens(e)}lex(t){t=t.replace(V_.carriageReturn,"\n"),this.blockTokens(t,this.tokens);for(let t=0;t<this.inlineQueue.length;t++){let e=this.inlineQueue[t];this.inlineTokens(e.src,e.tokens)}return this.inlineQueue=[],this.tokens}blockTokens(t,e=[],r=!1){for(this.options.pedantic&&(t=t.replace(V_.tabCharGlobal,"    ").replace(V_.spaceLine,""));t;){let i;if(this.options.extensions?.block?.some(r=>!!(i=r.call({lexer:this},t,e))&&(t=t.substring(i.raw.length),e.push(i),!0)))continue;if(i=this.tokenizer.space(t)){t=t.substring(i.raw.length);let r=e.at(-1);1===i.raw.length&&void 0!==r?r.raw+="\n":e.push(i);continue}if(i=this.tokenizer.code(t)){t=t.substring(i.raw.length);let r=e.at(-1);"paragraph"===r?.type||"text"===r?.type?(r.raw+="\n"+i.raw,r.text+="\n"+i.text,this.inlineQueue.at(-1).src=r.text):e.push(i);continue}if(i=this.tokenizer.fences(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.heading(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.hr(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.blockquote(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.list(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.html(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.def(t)){t=t.substring(i.raw.length);let r=e.at(-1);"paragraph"===r?.type||"text"===r?.type?(r.raw+="\n"+i.raw,r.text+="\n"+i.raw,this.inlineQueue.at(-1).src=r.text):this.tokens.links[i.tag]||(this.tokens.links[i.tag]={href:i.href,title:i.title});continue}if(i=this.tokenizer.table(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.lheading(t)){t=t.substring(i.raw.length),e.push(i);continue}let n=t;if(this.options.extensions?.startBlock){let e,r=1/0,i=t.slice(1);this.options.extensions.startBlock.forEach(t=>{e=t.call({lexer:this},i),"number"==typeof e&&e>=0&&(r=Math.min(r,e))}),r<1/0&&r>=0&&(n=t.substring(0,r+1))}if(this.state.top&&(i=this.tokenizer.paragraph(n))){let a=e.at(-1);r&&"paragraph"===a?.type?(a.raw+="\n"+i.raw,a.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue.at(-1).src=a.text):e.push(i),r=n.length!==t.length,t=t.substring(i.raw.length);continue}if(i=this.tokenizer.text(t)){t=t.substring(i.raw.length);let r=e.at(-1);"text"===r?.type?(r.raw+="\n"+i.raw,r.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue.at(-1).src=r.text):e.push(i);continue}if(t){let e="Infinite loop on byte: "+t.charCodeAt(0);if(this.options.silent){console.error(e);break}throw new Error(e)}}return this.state.top=!0,e}inline(t,e=[]){return this.inlineQueue.push({src:t,tokens:e}),e}inlineTokens(t,e=[]){let r=t,i=null;if(this.tokens.links){let t=Object.keys(this.tokens.links);if(t.length>0)for(;null!=(i=this.tokenizer.rules.inline.reflinkSearch.exec(r));)t.includes(i[0].slice(i[0].lastIndexOf("[")+1,-1))&&(r=r.slice(0,i.index)+"["+"a".repeat(i[0].length-2)+"]"+r.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex))}for(;null!=(i=this.tokenizer.rules.inline.anyPunctuation.exec(r));)r=r.slice(0,i.index)+"++"+r.slice(this.tokenizer.rules.inline.anyPunctuation.lastIndex);for(;null!=(i=this.tokenizer.rules.inline.blockSkip.exec(r));)r=r.slice(0,i.index)+"["+"a".repeat(i[0].length-2)+"]"+r.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);let n=!1,a="";for(;t;){let i;if(n||(a=""),n=!1,this.options.extensions?.inline?.some(r=>!!(i=r.call({lexer:this},t,e))&&(t=t.substring(i.raw.length),e.push(i),!0)))continue;if(i=this.tokenizer.escape(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.tag(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.link(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.reflink(t,this.tokens.links)){t=t.substring(i.raw.length);let r=e.at(-1);"text"===i.type&&"text"===r?.type?(r.raw+=i.raw,r.text+=i.text):e.push(i);continue}if(i=this.tokenizer.emStrong(t,r,a)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.codespan(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.br(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.del(t)){t=t.substring(i.raw.length),e.push(i);continue}if(i=this.tokenizer.autolink(t)){t=t.substring(i.raw.length),e.push(i);continue}if(!this.state.inLink&&(i=this.tokenizer.url(t))){t=t.substring(i.raw.length),e.push(i);continue}let o=t;if(this.options.extensions?.startInline){let e,r=1/0,i=t.slice(1);this.options.extensions.startInline.forEach(t=>{e=t.call({lexer:this},i),"number"==typeof e&&e>=0&&(r=Math.min(r,e))}),r<1/0&&r>=0&&(o=t.substring(0,r+1))}if(i=this.tokenizer.inlineText(o)){t=t.substring(i.raw.length),"_"!==i.raw.slice(-1)&&(a=i.raw.slice(-1)),n=!0;let r=e.at(-1);"text"===r?.type?(r.raw+=i.raw,r.text+=i.text):e.push(i);continue}if(t){let e="Infinite loop on byte: "+t.charCodeAt(0);if(this.options.silent){console.error(e);break}throw new Error(e)}}return e}},Xv=class{static{s(this,"$")}options;parser;constructor(t){this.options=t||W_}space(t){return""}code({text:t,lang:e,escaped:r}){let i=(e||"").match(V_.notSpaceStart)?.[0],n=t.replace(V_.endingNewline,"")+"\n";return i?'<pre><code class="language-'+zv(i)+'">'+(r?n:zv(n,!0))+"</code></pre>\n":"<pre><code>"+(r?n:zv(n,!0))+"</code></pre>\n"}blockquote({tokens:t}){return`<blockquote>\n${this.parser.parse(t)}</blockquote>\n`}html({text:t}){return t}heading({tokens:t,depth:e}){return`<h${e}>${this.parser.parseInline(t)}</h${e}>\n`}hr(t){return"<hr>\n"}list(t){let e=t.ordered,r=t.start,i="";for(let e=0;e<t.items.length;e++){let r=t.items[e];i+=this.listitem(r)}let n=e?"ol":"ul";return"<"+n+(e&&1!==r?' start="'+r+'"':"")+">\n"+i+"</"+n+">\n"}listitem(t){let e="";if(t.task){let r=this.checkbox({checked:!!t.checked});t.loose?"paragraph"===t.tokens[0]?.type?(t.tokens[0].text=r+" "+t.tokens[0].text,t.tokens[0].tokens&&t.tokens[0].tokens.length>0&&"text"===t.tokens[0].tokens[0].type&&(t.tokens[0].tokens[0].text=r+" "+zv(t.tokens[0].tokens[0].text),t.tokens[0].tokens[0].escaped=!0)):t.tokens.unshift({type:"text",raw:r+" ",text:r+" ",escaped:!0}):e+=r+" "}return e+=this.parser.parse(t.tokens,!!t.loose),`<li>${e}</li>\n`}checkbox({checked:t}){return"<input "+(t?'checked="" ':"")+'disabled="" type="checkbox">'}paragraph({tokens:t}){return`<p>${this.parser.parseInline(t)}</p>\n`}table(t){let e="",r="";for(let e=0;e<t.header.length;e++)r+=this.tablecell(t.header[e]);e+=this.tablerow({text:r});let i="";for(let e=0;e<t.rows.length;e++){let n=t.rows[e];r="";for(let t=0;t<n.length;t++)r+=this.tablecell(n[t]);i+=this.tablerow({text:r})}return i&&(i=`<tbody>${i}</tbody>`),"<table>\n<thead>\n"+e+"</thead>\n"+i+"</table>\n"}tablerow({text:t}){return`<tr>\n${t}</tr>\n`}tablecell(t){let e=this.parser.parseInline(t.tokens),r=t.header?"th":"td";return(t.align?`<${r} align="${t.align}">`:`<${r}>`)+e+`</${r}>\n`}strong({tokens:t}){return`<strong>${this.parser.parseInline(t)}</strong>`}em({tokens:t}){return`<em>${this.parser.parseInline(t)}</em>`}codespan({text:t}){return`<code>${zv(t,!0)}</code>`}br(t){return"<br>"}del({tokens:t}){return`<del>${this.parser.parseInline(t)}</del>`}link({href:t,title:e,tokens:r}){let i=this.parser.parseInline(r),n=qv(t);if(null===n)return i;let a='<a href="'+(t=n)+'"';return e&&(a+=' title="'+zv(e)+'"'),a+=">"+i+"</a>",a}image({href:t,title:e,text:r,tokens:i}){i&&(r=this.parser.parseInline(i,this.parser.textRenderer));let n=qv(t);if(null===n)return zv(r);let a=`<img src="${t=n}" alt="${r}"`;return e&&(a+=` title="${zv(e)}"`),a+=">",a}text(t){return"tokens"in t&&t.tokens?this.parser.parseInline(t.tokens):"escaped"in t&&t.escaped?t.text:zv(t.text)}},Zv=class{static{s(this,"_")}strong({text:t}){return t}em({text:t}){return t}codespan({text:t}){return t}del({text:t}){return t}html({text:t}){return t}text({text:t}){return t}link({text:t}){return""+t}image({text:t}){return""+t}br(){return""}},Qv=class t{static{s(this,"a")}options;renderer;textRenderer;constructor(t){this.options=t||W_,this.options.renderer=this.options.renderer||new Xv,this.renderer=this.options.renderer,this.renderer.options=this.options,this.renderer.parser=this,this.textRenderer=new Zv}static parse(e,r){return new t(r).parse(e)}static parseInline(e,r){return new t(r).parseInline(e)}parse(t,e=!0){let r="";for(let i=0;i<t.length;i++){let n=t[i];if(this.options.extensions?.renderers?.[n.type]){let t=n,e=this.options.extensions.renderers[t.type].call({parser:this},t);if(!1!==e||!["space","hr","heading","code","table","blockquote","list","html","paragraph","text"].includes(t.type)){r+=e||"";continue}}let a=n;switch(a.type){case"space":r+=this.renderer.space(a);continue;case"hr":r+=this.renderer.hr(a);continue;case"heading":r+=this.renderer.heading(a);continue;case"code":r+=this.renderer.code(a);continue;case"table":r+=this.renderer.table(a);continue;case"blockquote":r+=this.renderer.blockquote(a);continue;case"list":r+=this.renderer.list(a);continue;case"html":r+=this.renderer.html(a);continue;case"paragraph":r+=this.renderer.paragraph(a);continue;case"text":{let n=a,o=this.renderer.text(n);for(;i+1<t.length&&"text"===t[i+1].type;)n=t[++i],o+="\n"+this.renderer.text(n);r+=e?this.renderer.paragraph({type:"paragraph",raw:o,text:o,tokens:[{type:"text",raw:o,text:o,escaped:!0}]}):o;continue}default:{let t='Token with "'+a.type+'" type was not found.';if(this.options.silent)return console.error(t),"";throw new Error(t)}}}return r}parseInline(t,e=this.renderer){let r="";for(let i=0;i<t.length;i++){let n=t[i];if(this.options.extensions?.renderers?.[n.type]){let t=this.options.extensions.renderers[n.type].call({parser:this},n);if(!1!==t||!["escape","html","link","image","strong","em","codespan","br","del","text"].includes(n.type)){r+=t||"";continue}}let a=n;switch(a.type){case"escape":case"text":r+=e.text(a);break;case"html":r+=e.html(a);break;case"link":r+=e.link(a);break;case"image":r+=e.image(a);break;case"strong":r+=e.strong(a);break;case"em":r+=e.em(a);break;case"codespan":r+=e.codespan(a);break;case"br":r+=e.br(a);break;case"del":r+=e.del(a);break;default:{let t='Token with "'+a.type+'" type was not found.';if(this.options.silent)return console.error(t),"";throw new Error(t)}}}return r}},Kv=class{static{s(this,"L")}options;block;constructor(t){this.options=t||W_}static passThroughHooks=new Set(["preprocess","postprocess","processAllTokens"]);preprocess(t){return t}postprocess(t){return t}processAllTokens(t){return t}provideLexer(){return this.block?Gv.lex:Gv.lexInline}provideParser(){return this.block?Qv.parse:Qv.parseInline}},Jv=class{static{s(this,"B")}defaults={async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null};options=this.setOptions;parse=this.parseMarkdown(!0);parseInline=this.parseMarkdown(!1);Parser=Qv;Renderer=Xv;TextRenderer=Zv;Lexer=Gv;Tokenizer=Vv;Hooks=Kv;constructor(...t){this.use(...t)}walkTokens(t,e){let r=[];for(let i of t)switch(r=r.concat(e.call(this,i)),i.type){case"table":{let t=i;for(let i of t.header)r=r.concat(this.walkTokens(i.tokens,e));for(let i of t.rows)for(let t of i)r=r.concat(this.walkTokens(t.tokens,e));break}case"list":{let t=i;r=r.concat(this.walkTokens(t.items,e));break}default:{let t=i;this.defaults.extensions?.childTokens?.[t.type]?this.defaults.extensions.childTokens[t.type].forEach(i=>{let n=t[i].flat(1/0);r=r.concat(this.walkTokens(n,e))}):t.tokens&&(r=r.concat(this.walkTokens(t.tokens,e)))}}return r}use(...t){let e=this.defaults.extensions||{renderers:{},childTokens:{}};return t.forEach(t=>{let r={...t};if(r.async=this.defaults.async||r.async||!1,t.extensions&&(t.extensions.forEach(t=>{if(!t.name)throw new Error("extension name required");if("renderer"in t){let r=e.renderers[t.name];e.renderers[t.name]=r?function(...e){let i=t.renderer.apply(this,e);return!1===i&&(i=r.apply(this,e)),i}:t.renderer}if("tokenizer"in t){if(!t.level||"block"!==t.level&&"inline"!==t.level)throw new Error("extension level must be 'block' or 'inline'");let r=e[t.level];r?r.unshift(t.tokenizer):e[t.level]=[t.tokenizer],t.start&&("block"===t.level?e.startBlock?e.startBlock.push(t.start):e.startBlock=[t.start]:"inline"===t.level&&(e.startInline?e.startInline.push(t.start):e.startInline=[t.start]))}"childTokens"in t&&t.childTokens&&(e.childTokens[t.name]=t.childTokens)}),r.extensions=e),t.renderer){let e=this.defaults.renderer||new Xv(this.defaults);for(let r in t.renderer){if(!(r in e))throw new Error(`renderer '${r}' does not exist`);if(["options","parser"].includes(r))continue;let i=r,n=t.renderer[i],a=e[i];e[i]=(...t)=>{let r=n.apply(e,t);return!1===r&&(r=a.apply(e,t)),r||""}}r.renderer=e}if(t.tokenizer){let e=this.defaults.tokenizer||new Vv(this.defaults);for(let r in t.tokenizer){if(!(r in e))throw new Error(`tokenizer '${r}' does not exist`);if(["options","rules","lexer"].includes(r))continue;let i=r,n=t.tokenizer[i],a=e[i];e[i]=(...t)=>{let r=n.apply(e,t);return!1===r&&(r=a.apply(e,t)),r}}r.tokenizer=e}if(t.hooks){let e=this.defaults.hooks||new Kv;for(let r in t.hooks){if(!(r in e))throw new Error(`hook '${r}' does not exist`);if(["options","block"].includes(r))continue;let i=r,n=t.hooks[i],a=e[i];Kv.passThroughHooks.has(r)?e[i]=t=>{if(this.defaults.async)return Promise.resolve(n.call(e,t)).then(t=>a.call(e,t));let r=n.call(e,t);return a.call(e,r)}:e[i]=(...t)=>{let r=n.apply(e,t);return!1===r&&(r=a.apply(e,t)),r}}r.hooks=e}if(t.walkTokens){let e=this.defaults.walkTokens,i=t.walkTokens;r.walkTokens=function(t){let r=[];return r.push(i.call(this,t)),e&&(r=r.concat(e.call(this,t))),r}}this.defaults={...this.defaults,...r}}),this}setOptions(t){return this.defaults={...this.defaults,...t},this}lexer(t,e){return Gv.lex(t,e??this.defaults)}parser(t,e){return Qv.parse(t,e??this.defaults)}parseMarkdown(t){return(e,r)=>{let i={...r},n={...this.defaults,...i},a=this.onError(!!n.silent,!!n.async);if(!0===this.defaults.async&&!1===i.async)return a(new Error("marked(): The async option was set to true by an extension. Remove async: false from the parse options object to return a Promise."));if(typeof e>"u"||null===e)return a(new Error("marked(): input parameter is undefined or null"));if("string"!=typeof e)return a(new Error("marked(): input parameter is of type "+Object.prototype.toString.call(e)+", string expected"));n.hooks&&(n.hooks.options=n,n.hooks.block=t);let o=n.hooks?n.hooks.provideLexer():t?Gv.lex:Gv.lexInline,s=n.hooks?n.hooks.provideParser():t?Qv.parse:Qv.parseInline;if(n.async)return Promise.resolve(n.hooks?n.hooks.preprocess(e):e).then(t=>o(t,n)).then(t=>n.hooks?n.hooks.processAllTokens(t):t).then(t=>n.walkTokens?Promise.all(this.walkTokens(t,n.walkTokens)).then(()=>t):t).then(t=>s(t,n)).then(t=>n.hooks?n.hooks.postprocess(t):t).catch(a);try{n.hooks&&(e=n.hooks.preprocess(e));let t=o(e,n);n.hooks&&(t=n.hooks.processAllTokens(t)),n.walkTokens&&this.walkTokens(t,n.walkTokens);let r=s(t,n);return n.hooks&&(r=n.hooks.postprocess(r)),r}catch(t){return a(t)}}}onError(t,e){return r=>{if(r.message+="\nPlease report this to https://github.com/markedjs/marked.",t){let t="<p>An error occurred:</p><pre>"+zv(r.message+"",!0)+"</pre>";return e?Promise.resolve(t):t}if(e)return Promise.reject(r);throw r}}},tS=new Jv;function eS(t,e){return tS.parse(t,e)}function rS(t,{markdownAutoWrap:e}){let r=q_(t.replace(/<br\/>/g,"\n").replace(/\n{2,}/g,"\n"));return!1===e?r.replace(/ /g,"&nbsp;"):r}function iS(t,e={}){let r=rS(t,e),i=eS.lexer(r),n=[[]],a=0;function o(t,e="normal"){"text"===t.type?t.text.split("\n").forEach((t,r)=>{0!==r&&(a++,n.push([])),t.split(" ").forEach(t=>{(t=t.replace(/&#39;/g,"'"))&&n[a].push({content:t,type:e})})}):"strong"===t.type||"em"===t.type?t.tokens.forEach(e=>{o(e,t.type)}):"html"===t.type&&n[a].push({content:t.text,type:"normal"})}return s(o,"processNode"),i.forEach(t=>{"paragraph"===t.type?t.tokens?.forEach(t=>{o(t)}):"html"===t.type&&n[a].push({content:t.text,type:"normal"})}),n}function nS(t,{markdownAutoWrap:e}={}){let r=eS.lexer(t);function i(t){return"text"===t.type?!1===e?t.text.replace(/\n */g,"<br/>").replace(/ /g,"&nbsp;"):t.text.replace(/\n */g,"<br/>"):"strong"===t.type?`<strong>${t.tokens?.map(i).join("")}</strong>`:"em"===t.type?`<em>${t.tokens?.map(i).join("")}</em>`:"paragraph"===t.type?`<p>${t.tokens?.map(i).join("")}</p>`:"space"===t.type?"":"html"===t.type?`${t.text}`:"escape"===t.type?t.text:`Unsupported markdown: ${t.type}`}return s(i,"output"),r.map(i).join("")}function aS(t){return Intl.Segmenter?[...(new Intl.Segmenter).segment(t)].map(t=>t.segment):[...t]}function oS(t,e){return sS(t,[],aS(e.content),e.type)}function sS(t,e,r,i){if(0===r.length)return[{content:e.join(""),type:i},{content:"",type:i}];let[n,...a]=r,o=[...e,n];return t([{content:o.join(""),type:i}])?sS(t,o,a,i):(0===e.length&&n&&(e.push(n),r.shift()),[{content:e.join(""),type:i},{content:r.join(""),type:i}])}function lS(t,e){if(t.some(({content:t})=>t.includes("\n")))throw new Error("splitLineToFitWidth does not support newlines in the line");return hS(t,e)}function hS(t,e,r=[],i=[]){if(0===t.length)return i.length>0&&r.push(i),r.length>0?r:[];let n="";" "===t[0].content&&(n=" ",t.shift());let a=t.shift()??{content:" ",type:"normal"},o=[...i];if(""!==n&&o.push({content:n,type:"normal"}),o.push(a),e(o))return hS(t,e,r,o);if(i.length>0)r.push(i),t.unshift(a);else if(a.content){let[i,n]=oS(e,a);r.push([i]),n.content&&t.unshift(n)}return hS(t,e,r)}function cS(t,e){e&&t.attr("style",e)}async function uS(t,e,r,i,n=!1){let a=t.append("foreignObject");a.attr("width",10*r+"px"),a.attr("height",10*r+"px");let o=a.append("xhtml:div"),s=e.label;e.label&&zr(e.label)&&(s=await jr(e.label.replace(Wr.lineBreakRegex,"\n"),di()));let l=e.isNode?"nodeLabel":"edgeLabel",h=o.append("span");h.html(s),cS(h,e.labelStyle),h.attr("class",`${l} ${i}`),cS(o,e.labelStyle),o.style("display","table-cell"),o.style("white-space","nowrap"),o.style("line-height","1.5"),o.style("max-width",r+"px"),o.style("text-align","center"),o.attr("xmlns","http://www.w3.org/1999/xhtml"),n&&o.attr("class","labelBkg");let c=o.node().getBoundingClientRect();return c.width===r&&(o.style("display","table"),o.style("white-space","break-spaces"),o.style("width",r+"px"),c=o.node().getBoundingClientRect()),a.node()}function dS(t,e,r){return t.append("tspan").attr("class","text-outer-tspan").attr("x",0).attr("y",e*r-.1+"em").attr("dy",r+"em")}function pS(t,e,r){let i=t.append("text"),n=dS(i,1,e);yS(n,r);let a=n.node().getComputedTextLength();return i.remove(),a}function fS(t,e,r){let i=t.append("text"),n=dS(i,1,e);yS(n,[{content:r,type:"normal"}]);let a=n.node()?.getBoundingClientRect();return a&&i.remove(),a}function gS(t,e,r,i=!1){let n=e.append("g"),a=n.insert("rect").attr("class","background").attr("style","stroke: none"),o=n.append("text").attr("y","-10.1"),l=0;for(let e of r){let r=s(e=>pS(n,1.1,e)<=t,"checkWidth"),i=r(e)?[e]:lS(e,r);for(let t of i){yS(dS(o,l,1.1),t),l++}}if(i){let t=o.node().getBBox(),e=2;return a.attr("x",t.x-e).attr("y",t.y-e).attr("width",t.width+2*e).attr("height",t.height+2*e),n.node()}return o.node()}function yS(t,e){t.text(""),e.forEach((e,r)=>{let i=t.append("tspan").attr("font-style","em"===e.type?"italic":"normal").attr("class","text-inner-tspan").attr("font-weight","strong"===e.type?"bold":"normal");0===r?i.text(e.content):i.text(" "+e.content)})}async function mS(t){let e=[];t.replace(/(fa[bklrs]?):fa-([\w-]+)/g,(t,r,i)=>(e.push((async()=>{let e=`${r}:${i}`;return await P_(e)?await z_(e,void 0,{class:"label-icon"}):`<i class='${gi(t).replace(":"," ")}'></i>`})()),t));let r=await Promise.all(e);return t.replace(/(fa[bklrs]?):fa-([\w-]+)/g,()=>r.shift()??"")}s(eS,"k"),eS.options=eS.setOptions=function(t){return tS.setOptions(t),eS.defaults=tS.defaults,H_(eS.defaults),eS},eS.getDefaults=j_,eS.defaults=W_,eS.use=function(...t){return tS.use(...t),eS.defaults=tS.defaults,H_(eS.defaults),eS},eS.walkTokens=function(t,e){return tS.walkTokens(t,e)},eS.parseInline=tS.parseInline,eS.Parser=Qv,eS.parser=Qv.parse,eS.Renderer=Xv,eS.TextRenderer=Zv,eS.Lexer=Gv,eS.lexer=Gv.lex,eS.Tokenizer=Vv,eS.Hooks=Kv,eS.parse=eS,eS.options,eS.setOptions,eS.use,eS.walkTokens,eS.parseInline,Qv.parse,Gv.lex,s(rS,"preprocessMarkdown"),s(iS,"markdownToLines"),s(nS,"markdownToHTML"),s(aS,"splitTextToChars"),s(oS,"splitWordToFitWidth"),s(sS,"splitWordToFitWidthRecursion"),s(lS,"splitLineToFitWidth"),s(hS,"splitLineToFitWidthRecursion"),s(cS,"applyStyle"),s(uS,"addHtmlSpan"),s(dS,"createTspan"),s(pS,"computeWidthOfText"),s(fS,"computeDimensionOfText"),s(gS,"createFormattedText"),s(yS,"updateTextContentAndStyles"),s(mS,"replaceIconSubstring");var xS=s(async(t,e="",{style:r="",isTitle:i=!1,classes:n="",useHtmlLabels:a=!0,isNode:o=!0,width:s=200,addSvgBackground:l=!1}={},h)=>{if(y.debug("XYZ createText",e,r,i,n,a,o,"addSvgBackground: ",l),a){let i=nS(e,h),a=await mS(r_(i)),c=e.replace(/\\\\/g,"\\"),u={isNode:o,label:zr(e)?c:a,labelStyle:r.replace("fill:","color:")};return await uS(t,u,s,n,l)}{let i=gS(s,t,iS(e.replace(/<br\s*\/?>/g,"<br/>").replace("<br>","<br/>"),h),!!e&&l);if(o){/stroke:/.exec(r)&&(r=r.replace("stroke:","lineColor:"));let t=r.replace(/stroke:[^;]+;?/g,"").replace(/stroke-width:[^;]+;?/g,"").replace(/fill:[^;]+;?/g,"").replace(/color:/g,"fill:");ro(i).attr("style",t)}else{let t=r.replace(/stroke:[^;]+;?/g,"").replace(/stroke-width:[^;]+;?/g,"").replace(/fill:[^;]+;?/g,"").replace(/background:/g,"fill:");ro(i).select("rect").attr("style",t.replace(/background:/g,"fill:"));let e=r.replace(/stroke:[^;]+;?/g,"").replace(/stroke-width:[^;]+;?/g,"").replace(/fill:[^;]+;?/g,"").replace(/color:/g,"fill:");ro(i).select("text").attr("style",e)}return i}},"createText"),bS=s(async(t,e,r)=>{let i,n=e.useHtmlLabels||Lr(di()?.htmlLabels);i=r||"node default";let a,o=t.insert("g").attr("class",i).attr("id",e.domId||e.id),l=o.insert("g").attr("class","label").attr("style",n_(e.labelStyle));a=void 0===e.label?"":"string"==typeof e.label?e.label:e.label[0];let h=await xS(l,vr(r_(a),di()),{useHtmlLabels:n,width:e.width||di().flowchart?.wrappingWidth,cssClasses:"markdown-node-label",style:e.labelStyle,addSvgBackground:!!e.icon||!!e.img}),c=h.getBBox(),u=(e?.padding??0)/2;if(n){let t=h.children[0],e=ro(h),r=t.getElementsByTagName("img");if(r){let t=""===a.replace(/<img[^>]*>/g,"").trim();await Promise.all([...r].map(e=>new Promise(r=>{function i(){if(e.style.display="flex",e.style.flexDirection="column",t){let t=di().fontSize?di().fontSize:window.getComputedStyle(document.body).fontSize,r=5,[i=Wt.fontSize]=Kw(t),n=i*r+"px";e.style.minWidth=n,e.style.maxWidth=n}else e.style.width="100%";r(e)}s(i,"setupImage"),setTimeout(()=>{e.complete&&i()}),e.addEventListener("error",i),e.addEventListener("load",i)})))}c=t.getBoundingClientRect(),e.attr("width",c.width),e.attr("height",c.height)}return n?l.attr("transform","translate("+-c.width/2+", "+-c.height/2+")"):l.attr("transform","translate(0, "+-c.height/2+")"),e.centerLabel&&l.attr("transform","translate("+-c.width/2+", "+-c.height/2+")"),l.insert("rect",":first-child"),{shapeSvg:o,bbox:c,halfPadding:u,label:l}},"labelHelper"),CS=s(async(t,e,r)=>{let i=r.useHtmlLabels||Lr(di()?.flowchart?.htmlLabels),n=t.insert("g").attr("class","label").attr("style",r.labelStyle||""),a=await xS(n,vr(r_(e),di()),{useHtmlLabels:i,width:r.width||di()?.flowchart?.wrappingWidth,style:r.labelStyle,addSvgBackground:!!r.icon||!!r.img}),o=a.getBBox(),s=r.padding/2;if(Lr(di()?.flowchart?.htmlLabels)){let t=a.children[0],e=ro(a);o=t.getBoundingClientRect(),e.attr("width",o.width),e.attr("height",o.height)}return i?n.attr("transform","translate("+-o.width/2+", "+-o.height/2+")"):n.attr("transform","translate(0, "+-o.height/2+")"),r.centerLabel&&n.attr("transform","translate("+-o.width/2+", "+-o.height/2+")"),n.insert("rect",":first-child"),{shapeSvg:t,bbox:o,halfPadding:s,label:n}},"insertLabel"),kS=s((t,e)=>{let r=e.node().getBBox();t.width=r.width,t.height=r.height},"updateNodeBounds"),wS=s((t,e)=>("handDrawn"===t.look?"rough-node":"node")+" "+t.cssClasses+" "+(e||""),"getNodeClasses");function _S(t){let e=t.map((t,e)=>`${0===e?"M":"L"}${t.x},${t.y}`);return e.push("Z"),e.join(" ")}function vS(t,e,r,i,n,a){let o=[],s=r-t,l=i-e,h=s/a,c=2*Math.PI/h,u=e+l/2;for(let e=0;e<=50;e++){let r=t+e/50*s,i=u+n*Math.sin(c*(r-t));o.push({x:r,y:i})}return o}function SS(t,e,r,i,n,a){let o=[],s=n*Math.PI/180,l=(a*Math.PI/180-s)/(i-1);for(let n=0;n<i;n++){let i=s+n*l,a=t+r*Math.cos(i),h=e+r*Math.sin(i);o.push({x:-a,y:-h})}return o}function TS(t,e,r){if(t&&t.length){let[i,n]=e,a=Math.PI/180*r,o=Math.cos(a),s=Math.sin(a);for(let e of t){let[t,r]=e;e[0]=(t-i)*o-(r-n)*s+i,e[1]=(t-i)*s+(r-n)*o+n}}}function MS(t,e){return t[0]===e[0]&&t[1]===e[1]}function BS(t,e,r,i=1){let n=r,a=Math.max(e,.1),o=t[0]&&t[0][0]&&"number"==typeof t[0][0]?[t]:t,s=[0,0];if(n)for(let t of o)TS(t,s,n);let l=function(t,e,r){let i=[];for(let e of t){let t=[...e];MS(t[0],t[t.length-1])||t.push([t[0][0],t[0][1]]),t.length>2&&i.push(t)}let n=[];e=Math.max(e,.1);let a=[];for(let t of i)for(let e=0;e<t.length-1;e++){let r=t[e],i=t[e+1];if(r[1]!==i[1]){let t=Math.min(r[1],i[1]);a.push({ymin:t,ymax:Math.max(r[1],i[1]),x:t===r[1]?r[0]:i[0],islope:(i[0]-r[0])/(i[1]-r[1])})}}if(a.sort((t,e)=>t.ymin<e.ymin?-1:t.ymin>e.ymin?1:t.x<e.x?-1:t.x>e.x?1:t.ymax===e.ymax?0:(t.ymax-e.ymax)/Math.abs(t.ymax-e.ymax)),!a.length)return n;let o=[],s=a[0].ymin,l=0;for(;o.length||a.length;){if(a.length){let t=-1;for(let e=0;e<a.length&&!(a[e].ymin>s);e++)t=e;a.splice(0,t+1).forEach(t=>{o.push({s:s,edge:t})})}if(o=o.filter(t=>!(t.edge.ymax<=s)),o.sort((t,e)=>t.edge.x===e.edge.x?0:(t.edge.x-e.edge.x)/Math.abs(t.edge.x-e.edge.x)),(1!==r||l%e==0)&&o.length>1)for(let t=0;t<o.length;t+=2){let e=t+1;if(e>=o.length)break;let r=o[t].edge,i=o[e].edge;n.push([[Math.round(r.x),s],[Math.round(i.x),s]])}s+=r,o.forEach(t=>{t.edge.x=t.edge.x+r*t.edge.islope}),l++}return n}(o,a,i);if(n){for(let t of o)TS(t,s,-n);!function(t,e,r){let i=[];t.forEach(t=>i.push(...t)),TS(i,e,r)}(l,s,-n)}return l}function AS(t,e){var r;let i=e.hachureAngle+90,n=e.hachureGap;n<0&&(n=4*e.strokeWidth),n=Math.round(Math.max(n,.1));let a=1;return e.roughness>=1&&((null===(r=e.randomizer)||void 0===r?void 0:r.next())||Math.random())>.7&&(a=n),BS(t,n,i,a||1)}s(_S,"createPathFromPoints"),s(vS,"generateFullSineWavePoints"),s(SS,"generateCirclePoints"),s(TS,"t"),s(MS,"e"),s(BS,"s"),s(AS,"n");var FS=class{static{s(this,"o")}constructor(t){this.helper=t}fillPolygons(t,e){return this._fillPolygons(t,e)}_fillPolygons(t,e){let r=AS(t,e);return{type:"fillSketch",ops:this.renderLines(r,e)}}renderLines(t,e){let r=[];for(let i of t)r.push(...this.helper.doubleLineOps(i[0][0],i[0][1],i[1][0],i[1][1],e));return r}};function LS(t){let e=t[0],r=t[1];return Math.sqrt(Math.pow(e[0]-r[0],2)+Math.pow(e[1]-r[1],2))}s(LS,"a");var $S=class extends FS{static{s(this,"h")}fillPolygons(t,e){let r=e.hachureGap;r<0&&(r=4*e.strokeWidth),r=Math.max(r,.1);let i=AS(t,Object.assign({},e,{hachureGap:r})),n=Math.PI/180*e.hachureAngle,a=[],o=.5*r*Math.cos(n),s=.5*r*Math.sin(n);for(let[t,e]of i)LS([t,e])&&a.push([[t[0]-o,t[1]+s],[...e]],[[t[0]+o,t[1]-s],[...e]]);return{type:"fillSketch",ops:this.renderLines(a,e)}}},ES=class extends FS{static{s(this,"r")}fillPolygons(t,e){let r=this._fillPolygons(t,e),i=Object.assign({},e,{hachureAngle:e.hachureAngle+90}),n=this._fillPolygons(t,i);return r.ops=r.ops.concat(n.ops),r}},DS=class{static{s(this,"i")}constructor(t){this.helper=t}fillPolygons(t,e){let r=AS(t,e=Object.assign({},e,{hachureAngle:0}));return this.dotsOnLines(r,e)}dotsOnLines(t,e){let r=[],i=e.hachureGap;i<0&&(i=4*e.strokeWidth),i=Math.max(i,.1);let n=e.fillWeight;n<0&&(n=e.strokeWidth/2);let a=i/4;for(let o of t){let t=LS(o),s=t/i,l=Math.ceil(s)-1,h=t-l*i,c=(o[0][0]+o[1][0])/2-i/4,u=Math.min(o[0][1],o[1][1]);for(let t=0;t<l;t++){let o=u+h+t*i,s=c-a+2*Math.random()*a,l=o-a+2*Math.random()*a,d=this.helper.ellipse(s,l,n,n,e);r.push(...d.ops)}}return{type:"fillSketch",ops:r}}},OS=class{static{s(this,"c")}constructor(t){this.helper=t}fillPolygons(t,e){let r=AS(t,e);return{type:"fillSketch",ops:this.dashedLine(r,e)}}dashedLine(t,e){let r=e.dashOffset<0?e.hachureGap<0?4*e.strokeWidth:e.hachureGap:e.dashOffset,i=e.dashGap<0?e.hachureGap<0?4*e.strokeWidth:e.hachureGap:e.dashGap,n=[];return t.forEach(t=>{let a=LS(t),o=Math.floor(a/(r+i)),s=(a+i-o*(r+i))/2,l=t[0],h=t[1];l[0]>h[0]&&(l=t[1],h=t[0]);let c=Math.atan((h[1]-l[1])/(h[0]-l[0]));for(let t=0;t<o;t++){let a=t*(r+i),o=a+r,h=[l[0]+a*Math.cos(c)+s*Math.cos(c),l[1]+a*Math.sin(c)+s*Math.sin(c)],u=[l[0]+o*Math.cos(c)+s*Math.cos(c),l[1]+o*Math.sin(c)+s*Math.sin(c)];n.push(...this.helper.doubleLineOps(h[0],h[1],u[0],u[1],e))}}),n}},IS=class{static{s(this,"l")}constructor(t){this.helper=t}fillPolygons(t,e){let r=e.hachureGap<0?4*e.strokeWidth:e.hachureGap,i=e.zigzagOffset<0?r:e.zigzagOffset,n=AS(t,e=Object.assign({},e,{hachureGap:r+i}));return{type:"fillSketch",ops:this.zigzagLines(n,i,e)}}zigzagLines(t,e,r){let i=[];return t.forEach(t=>{let n=LS(t),a=Math.round(n/(2*e)),o=t[0],s=t[1];o[0]>s[0]&&(o=t[1],s=t[0]);let l=Math.atan((s[1]-o[1])/(s[0]-o[0]));for(let t=0;t<a;t++){let n=2*t*e,a=2*(t+1)*e,s=Math.sqrt(2*Math.pow(e,2)),h=[o[0]+n*Math.cos(l),o[1]+n*Math.sin(l)],c=[o[0]+a*Math.cos(l),o[1]+a*Math.sin(l)],u=[h[0]+s*Math.cos(l+Math.PI/4),h[1]+s*Math.sin(l+Math.PI/4)];i.push(...this.helper.doubleLineOps(h[0],h[1],u[0],u[1],r),...this.helper.doubleLineOps(u[0],u[1],c[0],c[1],r))}}),i}},NS={},RS=class{static{s(this,"p")}constructor(t){this.seed=t}next(){return this.seed?(2**31-1&(this.seed=Math.imul(48271,this.seed)))/2**31:Math.random()}},PS={A:7,a:7,C:6,c:6,H:1,h:1,L:2,l:2,M:2,m:2,Q:4,q:4,S:4,s:4,T:2,t:2,V:1,v:1,Z:0,z:0};function zS(t,e){return t.type===e}function qS(t){let e=[],r=function(t){let e=new Array;for(;""!==t;)if(t.match(/^([ \t\r\n,]+)/))t=t.substr(RegExp.$1.length);else if(t.match(/^([aAcChHlLmMqQsStTvVzZ])/))e[e.length]={type:0,text:RegExp.$1},t=t.substr(RegExp.$1.length);else{if(!t.match(/^(([-+]?[0-9]+(\.[0-9]*)?|[-+]?\.[0-9]+)([eE][-+]?[0-9]+)?)/))return[];e[e.length]={type:1,text:`${parseFloat(RegExp.$1)}`},t=t.substr(RegExp.$1.length)}return e[e.length]={type:2,text:""},e}(t),i="BOD",n=0,a=r[n];for(;!zS(a,2);){let o=0,s=[];if("BOD"===i){if("M"!==a.text&&"m"!==a.text)return qS("M0,0"+t);n++,o=PS[a.text],i=a.text}else zS(a,1)?o=PS[i]:(n++,o=PS[a.text],i=a.text);if(!(n+o<r.length))throw new Error("Path data ended short");for(let t=n;t<n+o;t++){let e=r[t];if(!zS(e,1))throw new Error("Param not a number: "+i+","+e.text);s[s.length]=+e.text}if("number"!=typeof PS[i])throw new Error("Bad segment: "+i);{let t={key:i,data:s};e.push(t),n+=o,a=r[n],"M"===i&&(i="L"),"m"===i&&(i="l")}}return e}function jS(t){let e=0,r=0,i=0,n=0,a=[];for(let{key:o,data:s}of t)switch(o){case"M":a.push({key:"M",data:[...s]}),[e,r]=s,[i,n]=s;break;case"m":e+=s[0],r+=s[1],a.push({key:"M",data:[e,r]}),i=e,n=r;break;case"L":a.push({key:"L",data:[...s]}),[e,r]=s;break;case"l":e+=s[0],r+=s[1],a.push({key:"L",data:[e,r]});break;case"C":a.push({key:"C",data:[...s]}),e=s[4],r=s[5];break;case"c":{let t=s.map((t,i)=>i%2?t+r:t+e);a.push({key:"C",data:t}),e=t[4],r=t[5];break}case"Q":a.push({key:"Q",data:[...s]}),e=s[2],r=s[3];break;case"q":{let t=s.map((t,i)=>i%2?t+r:t+e);a.push({key:"Q",data:t}),e=t[2],r=t[3];break}case"A":a.push({key:"A",data:[...s]}),e=s[5],r=s[6];break;case"a":e+=s[5],r+=s[6],a.push({key:"A",data:[s[0],s[1],s[2],s[3],s[4],e,r]});break;case"H":a.push({key:"H",data:[...s]}),e=s[0];break;case"h":e+=s[0],a.push({key:"H",data:[e]});break;case"V":a.push({key:"V",data:[...s]}),r=s[0];break;case"v":r+=s[0],a.push({key:"V",data:[r]});break;case"S":a.push({key:"S",data:[...s]}),e=s[2],r=s[3];break;case"s":{let t=s.map((t,i)=>i%2?t+r:t+e);a.push({key:"S",data:t}),e=t[2],r=t[3];break}case"T":a.push({key:"T",data:[...s]}),e=s[0],r=s[1];break;case"t":e+=s[0],r+=s[1],a.push({key:"T",data:[e,r]});break;case"Z":case"z":a.push({key:"Z",data:[]}),e=i,r=n}return a}function WS(t){let e=[],r="",i=0,n=0,a=0,o=0,s=0,l=0;for(let{key:h,data:c}of t){switch(h){case"M":e.push({key:"M",data:[...c]}),[i,n]=c,[a,o]=c;break;case"C":e.push({key:"C",data:[...c]}),i=c[4],n=c[5],s=c[2],l=c[3];break;case"L":e.push({key:"L",data:[...c]}),[i,n]=c;break;case"H":i=c[0],e.push({key:"L",data:[i,n]});break;case"V":n=c[0],e.push({key:"L",data:[i,n]});break;case"S":{let t=0,a=0;"C"===r||"S"===r?(t=i+(i-s),a=n+(n-l)):(t=i,a=n),e.push({key:"C",data:[t,a,...c]}),s=c[0],l=c[1],i=c[2],n=c[3];break}case"T":{let[t,a]=c,o=0,h=0;"Q"===r||"T"===r?(o=i+(i-s),h=n+(n-l)):(o=i,h=n);let u=i+2*(o-i)/3,d=n+2*(h-n)/3,p=t+2*(o-t)/3,f=a+2*(h-a)/3;e.push({key:"C",data:[u,d,p,f,t,a]}),s=o,l=h,i=t,n=a;break}case"Q":{let[t,r,a,o]=c,h=i+2*(t-i)/3,u=n+2*(r-n)/3,d=a+2*(t-a)/3,p=o+2*(r-o)/3;e.push({key:"C",data:[h,u,d,p,a,o]}),s=t,l=r,i=a,n=o;break}case"A":{let t=Math.abs(c[0]),r=Math.abs(c[1]),a=c[2],o=c[3],s=c[4],l=c[5],h=c[6];0===t||0===r?(e.push({key:"C",data:[i,n,l,h,l,h]}),i=l,n=h):(i!==l||n!==h)&&(US(i,n,l,h,t,r,a,o,s).forEach(function(t){e.push({key:"C",data:t})}),i=l,n=h);break}case"Z":e.push({key:"Z",data:[]}),i=a,n=o}r=h}return e}function HS(t,e,r){return[t*Math.cos(r)-e*Math.sin(r),t*Math.sin(r)+e*Math.cos(r)]}function US(t,e,r,i,n,a,o,s,l,h){let c=(u=o,Math.PI*u/180);var u;let d=[],p=0,f=0,g=0,y=0;if(h)[p,f,g,y]=h;else{[t,e]=HS(t,e,-c),[r,i]=HS(r,i,-c);let o=(t-r)/2,h=(e-i)/2,u=o*o/(n*n)+h*h/(a*a);u>1&&(u=Math.sqrt(u),n*=u,a*=u);let d=n*n,m=a*a,x=d*m-d*h*h-m*o*o,b=d*h*h+m*o*o,C=(s===l?-1:1)*Math.sqrt(Math.abs(x/b));g=C*n*h/a+(t+r)/2,y=C*-a*o/n+(e+i)/2,p=Math.asin(parseFloat(((e-y)/a).toFixed(9))),f=Math.asin(parseFloat(((i-y)/a).toFixed(9))),t<g&&(p=Math.PI-p),r<g&&(f=Math.PI-f),p<0&&(p=2*Math.PI+p),f<0&&(f=2*Math.PI+f),l&&p>f&&(p-=2*Math.PI),!l&&f>p&&(f-=2*Math.PI)}let m=f-p;if(Math.abs(m)>120*Math.PI/180){let t=f,e=r,s=i;f=l&&f>p?p+120*Math.PI/180*1:p+120*Math.PI/180*-1,d=US(r=g+n*Math.cos(f),i=y+a*Math.sin(f),e,s,n,a,o,0,l,[f,t,g,y])}m=f-p;let x=Math.cos(p),b=Math.sin(p),C=Math.cos(f),k=Math.sin(f),w=Math.tan(m/4),_=4/3*n*w,v=4/3*a*w,S=[t,e],T=[t+_*b,e-v*x],M=[r+_*k,i-v*C],B=[r,i];if(T[0]=2*S[0]-T[0],T[1]=2*S[1]-T[1],h)return[T,M,B].concat(d);{d=[T,M,B].concat(d);let t=[];for(let e=0;e<d.length;e+=3){let r=HS(d[e][0],d[e][1],c),i=HS(d[e+1][0],d[e+1][1],c),n=HS(d[e+2][0],d[e+2][1],c);t.push([r[0],r[1],i[0],i[1],n[0],n[1]])}return t}}s(zS,"k"),s(qS,"b"),s(jS,"y"),s(WS,"m"),s(HS,"w"),s(US,"x");var YS={randOffset:s(function(t,e){return oT(t,e)},"randOffset"),randOffsetWithRange:s(function(t,e,r){return aT(t,e,r)},"randOffsetWithRange"),ellipse:s(function(t,e,r,i,n){return KS(t,e,n,QS(r,i,n)).opset},"ellipse"),doubleLineOps:s(function(t,e,r,i,n){return sT(t,e,r,i,n,!0)},"doubleLineOps")};function VS(t,e,r,i,n){return{type:"path",ops:sT(t,e,r,i,n)}}function GS(t,e,r){let i=(t||[]).length;if(i>2){let n=[];for(let e=0;e<i-1;e++)n.push(...sT(t[e][0],t[e][1],t[e+1][0],t[e+1][1],r));return e&&n.push(...sT(t[i-1][0],t[i-1][1],t[0][0],t[0][1],r)),{type:"path",ops:n}}return 2===i?VS(t[0][0],t[0][1],t[1][0],t[1][1],r):{type:"path",ops:[]}}function XS(t,e,r,i,n){return function(t,e){return GS(t,!0,e)}([[t,e],[t+r,e],[t+r,e+i],[t,e+i]],n)}function ZS(t,e){if(t.length){let r="number"==typeof t[0][0]?[t]:t,i=hT(r[0],1*(1+.2*e.roughness),e),n=e.disableMultiStroke?[]:hT(r[0],1.5*(1+.22*e.roughness),iT(e));for(let t=1;t<r.length;t++){let a=r[t];if(a.length){let t=hT(a,1*(1+.2*e.roughness),e),r=e.disableMultiStroke?[]:hT(a,1.5*(1+.22*e.roughness),iT(e));for(let e of t)"move"!==e.op&&i.push(e);for(let t of r)"move"!==t.op&&n.push(t)}}return{type:"path",ops:i.concat(n)}}return{type:"path",ops:[]}}function QS(t,e,r){let i=Math.sqrt(2*Math.PI*Math.sqrt((Math.pow(t/2,2)+Math.pow(e/2,2))/2)),n=Math.ceil(Math.max(r.curveStepCount,r.curveStepCount/Math.sqrt(200)*i)),a=2*Math.PI/n,o=Math.abs(t/2),s=Math.abs(e/2),l=1-r.curveFitting;return o+=oT(o*l,r),s+=oT(s*l,r),{increment:a,rx:o,ry:s}}function KS(t,e,r,i){let[n,a]=uT(i.increment,t,e,i.rx,i.ry,1,i.increment*aT(.1,aT(.4,1,r),r),r),o=cT(n,null,r);if(!r.disableMultiStroke&&0!==r.roughness){let[n]=uT(i.increment,t,e,i.rx,i.ry,1.5,0,r),a=cT(n,null,r);o=o.concat(a)}return{estimatedPoints:a,opset:{type:"path",ops:o}}}function JS(t,e,r,i,n,a,o,s,l){let h=t,c=e,u=Math.abs(r/2),d=Math.abs(i/2);u+=oT(.01*u,l),d+=oT(.01*d,l);let p=n,f=a;for(;p<0;)p+=2*Math.PI,f+=2*Math.PI;f-p>2*Math.PI&&(p=0,f=2*Math.PI);let g=2*Math.PI/l.curveStepCount,y=Math.min(g/2,(f-p)/2),m=dT(y,h,c,u,d,p,f,1,l);if(!l.disableMultiStroke){let t=dT(y,h,c,u,d,p,f,1.5,l);m.push(...t)}return o&&(s?m.push(...sT(h,c,h+u*Math.cos(p),c+d*Math.sin(p),l),...sT(h,c,h+u*Math.cos(f),c+d*Math.sin(f),l)):m.push({op:"lineTo",data:[h,c]},{op:"lineTo",data:[h+u*Math.cos(p),c+d*Math.sin(p)]})),{type:"path",ops:m}}function tT(t,e){let r=WS(jS(qS(t))),i=[],n=[0,0],a=[0,0];for(let{key:t,data:o}of r)switch(t){case"M":a=[o[0],o[1]],n=[o[0],o[1]];break;case"L":i.push(...sT(a[0],a[1],o[0],o[1],e)),a=[o[0],o[1]];break;case"C":{let[t,r,n,s,l,h]=o;i.push(...pT(t,r,n,s,l,h,a,e)),a=[l,h];break}case"Z":i.push(...sT(a[0],a[1],n[0],n[1],e)),a=[n[0],n[1]]}return{type:"path",ops:i}}function eT(t,e){let r=[];for(let i of t)if(i.length){let t=e.maxRandomnessOffset||0,n=i.length;if(n>2){r.push({op:"move",data:[i[0][0]+oT(t,e),i[0][1]+oT(t,e)]});for(let a=1;a<n;a++)r.push({op:"lineTo",data:[i[a][0]+oT(t,e),i[a][1]+oT(t,e)]})}}return{type:"fillPath",ops:r}}function rT(t,e){return function(t,e){let r=t.fillStyle||"hachure";if(!NS[r])switch(r){case"zigzag":NS[r]||(NS[r]=new $S(e));break;case"cross-hatch":NS[r]||(NS[r]=new ES(e));break;case"dots":NS[r]||(NS[r]=new DS(e));break;case"dashed":NS[r]||(NS[r]=new OS(e));break;case"zigzag-line":NS[r]||(NS[r]=new IS(e));break;default:r="hachure",NS[r]||(NS[r]=new FS(e))}return NS[r]}(e,YS).fillPolygons(t,e)}function iT(t){let e=Object.assign({},t);return e.randomizer=void 0,t.seed&&(e.seed=t.seed+1),e}function nT(t){return t.randomizer||(t.randomizer=new RS(t.seed||0)),t.randomizer.next()}function aT(t,e,r,i=1){return r.roughness*i*(nT(r)*(e-t)+t)}function oT(t,e,r=1){return aT(-t,t,e,r)}function sT(t,e,r,i,n,a=!1){let o=a?n.disableMultiStrokeFill:n.disableMultiStroke,s=lT(t,e,r,i,n,!0,!1);if(o)return s;let l=lT(t,e,r,i,n,!0,!0);return s.concat(l)}function lT(t,e,r,i,n,a,o){let l=Math.pow(t-r,2)+Math.pow(e-i,2),h=Math.sqrt(l),c=1;c=h<200?1:h>500?.4:-.0016668*h+1.233334;let u=n.maxRandomnessOffset||0;u*u*100>l&&(u=h/10);let d=u/2,p=.2+.2*nT(n),f=n.bowing*n.maxRandomnessOffset*(i-e)/200,g=n.bowing*n.maxRandomnessOffset*(t-r)/200;f=oT(f,n,c),g=oT(g,n,c);let y=[],m=s(()=>oT(d,n,c),"M"),x=s(()=>oT(u,n,c),"k"),b=n.preserveVertices;return a&&(o?y.push({op:"move",data:[t+(b?0:m()),e+(b?0:m())]}):y.push({op:"move",data:[t+(b?0:oT(u,n,c)),e+(b?0:oT(u,n,c))]})),o?y.push({op:"bcurveTo",data:[f+t+(r-t)*p+m(),g+e+(i-e)*p+m(),f+t+2*(r-t)*p+m(),g+e+2*(i-e)*p+m(),r+(b?0:m()),i+(b?0:m())]}):y.push({op:"bcurveTo",data:[f+t+(r-t)*p+x(),g+e+(i-e)*p+x(),f+t+2*(r-t)*p+x(),g+e+2*(i-e)*p+x(),r+(b?0:x()),i+(b?0:x())]}),y}function hT(t,e,r){if(!t.length)return[];let i=[];i.push([t[0][0]+oT(e,r),t[0][1]+oT(e,r)]),i.push([t[0][0]+oT(e,r),t[0][1]+oT(e,r)]);for(let n=1;n<t.length;n++)i.push([t[n][0]+oT(e,r),t[n][1]+oT(e,r)]),n===t.length-1&&i.push([t[n][0]+oT(e,r),t[n][1]+oT(e,r)]);return cT(i,null,r)}function cT(t,e,r){let i=t.length,n=[];if(i>3){let a=[],o=1-r.curveTightness;n.push({op:"move",data:[t[1][0],t[1][1]]});for(let e=1;e+2<i;e++){let r=t[e];a[0]=[r[0],r[1]],a[1]=[r[0]+(o*t[e+1][0]-o*t[e-1][0])/6,r[1]+(o*t[e+1][1]-o*t[e-1][1])/6],a[2]=[t[e+1][0]+(o*t[e][0]-o*t[e+2][0])/6,t[e+1][1]+(o*t[e][1]-o*t[e+2][1])/6],a[3]=[t[e+1][0],t[e+1][1]],n.push({op:"bcurveTo",data:[a[1][0],a[1][1],a[2][0],a[2][1],a[3][0],a[3][1]]})}if(e&&2===e.length){let t=r.maxRandomnessOffset;n.push({op:"lineTo",data:[e[0]+oT(t,r),e[1]+oT(t,r)]})}}else 3===i?(n.push({op:"move",data:[t[1][0],t[1][1]]}),n.push({op:"bcurveTo",data:[t[1][0],t[1][1],t[2][0],t[2][1],t[2][0],t[2][1]]})):2===i&&n.push(...lT(t[0][0],t[0][1],t[1][0],t[1][1],r,!0,!0));return n}function uT(t,e,r,i,n,a,o,s){let l=[],h=[];if(0===s.roughness){t/=4,h.push([e+i*Math.cos(-t),r+n*Math.sin(-t)]);for(let a=0;a<=2*Math.PI;a+=t){let t=[e+i*Math.cos(a),r+n*Math.sin(a)];l.push(t),h.push(t)}h.push([e+i*Math.cos(0),r+n*Math.sin(0)]),h.push([e+i*Math.cos(t),r+n*Math.sin(t)])}else{let c=oT(.5,s)-Math.PI/2;h.push([oT(a,s)+e+.9*i*Math.cos(c-t),oT(a,s)+r+.9*n*Math.sin(c-t)]);let u=2*Math.PI+c-.01;for(let o=c;o<u;o+=t){let t=[oT(a,s)+e+i*Math.cos(o),oT(a,s)+r+n*Math.sin(o)];l.push(t),h.push(t)}h.push([oT(a,s)+e+i*Math.cos(c+2*Math.PI+.5*o),oT(a,s)+r+n*Math.sin(c+2*Math.PI+.5*o)]),h.push([oT(a,s)+e+.98*i*Math.cos(c+o),oT(a,s)+r+.98*n*Math.sin(c+o)]),h.push([oT(a,s)+e+.9*i*Math.cos(c+.5*o),oT(a,s)+r+.9*n*Math.sin(c+.5*o)])}return[h,l]}function dT(t,e,r,i,n,a,o,s,l){let h=a+oT(.1,l),c=[];c.push([oT(s,l)+e+.9*i*Math.cos(h-t),oT(s,l)+r+.9*n*Math.sin(h-t)]);for(let a=h;a<=o;a+=t)c.push([oT(s,l)+e+i*Math.cos(a),oT(s,l)+r+n*Math.sin(a)]);return c.push([e+i*Math.cos(o),r+n*Math.sin(o)]),c.push([e+i*Math.cos(o),r+n*Math.sin(o)]),cT(c,null,l)}function pT(t,e,r,i,n,a,o,s){let l=[],h=[s.maxRandomnessOffset||1,(s.maxRandomnessOffset||1)+.3],c=[0,0],u=s.disableMultiStroke?1:2,d=s.preserveVertices;for(let p=0;p<u;p++)0===p?l.push({op:"move",data:[o[0],o[1]]}):l.push({op:"move",data:[o[0]+(d?0:oT(h[0],s)),o[1]+(d?0:oT(h[0],s))]}),c=d?[n,a]:[n+oT(h[p],s),a+oT(h[p],s)],l.push({op:"bcurveTo",data:[t+oT(h[p],s),e+oT(h[p],s),r+oT(h[p],s),i+oT(h[p],s),c[0],c[1]]});return l}function fT(t){return[...t]}function gT(t,e=0){let r=t.length;if(r<3)throw new Error("A curve must have at least three points.");let i=[];if(3===r)i.push(fT(t[0]),fT(t[1]),fT(t[2]),fT(t[2]));else{let r=[];r.push(t[0],t[0]);for(let e=1;e<t.length;e++)r.push(t[e]),e===t.length-1&&r.push(t[e]);let n=[],a=1-e;i.push(fT(r[0]));for(let t=1;t+2<r.length;t++){let e=r[t];n[0]=[e[0],e[1]],n[1]=[e[0]+(a*r[t+1][0]-a*r[t-1][0])/6,e[1]+(a*r[t+1][1]-a*r[t-1][1])/6],n[2]=[r[t+1][0]+(a*r[t][0]-a*r[t+2][0])/6,r[t+1][1]+(a*r[t][1]-a*r[t+2][1])/6],n[3]=[r[t+1][0],r[t+1][1]],i.push(n[1],n[2],n[3])}}return i}function yT(t,e){return Math.pow(t[0]-e[0],2)+Math.pow(t[1]-e[1],2)}function mT(t,e,r){let i=yT(e,r);if(0===i)return yT(t,e);let n=((t[0]-e[0])*(r[0]-e[0])+(t[1]-e[1])*(r[1]-e[1]))/i;return n=Math.max(0,Math.min(1,n)),yT(t,xT(e,r,n))}function xT(t,e,r){return[t[0]+(e[0]-t[0])*r,t[1]+(e[1]-t[1])*r]}function bT(t,e,r,i){let n=i||[];if(function(t,e){let r=t[e+0],i=t[e+1],n=t[e+2],a=t[e+3],o=3*i[0]-2*r[0]-a[0];o*=o;let s=3*i[1]-2*r[1]-a[1];s*=s;let l=3*n[0]-2*a[0]-r[0];l*=l;let h=3*n[1]-2*a[1]-r[1];return h*=h,o<l&&(o=l),s<h&&(s=h),o+s}(t,e)<r){let r=t[e+0];n.length?(a=n[n.length-1],o=r,Math.sqrt(yT(a,o))>1&&n.push(r)):n.push(r),n.push(t[e+3])}else{let i=t[e+0],a=t[e+1],o=t[e+2],s=t[e+3],l=xT(i,a,.5),h=xT(a,o,.5),c=xT(o,s,.5),u=xT(l,h,.5),d=xT(h,c,.5),p=xT(u,d,.5);bT([i,l,u,p],0,r,n),bT([p,d,c,s],0,r,n)}var a,o;return n}function CT(t,e){return kT(t,0,t.length,e)}function kT(t,e,r,i,n){let a=n||[],o=t[e],s=t[r-1],l=0,h=1;for(let i=e+1;i<r-1;++i){let e=mT(t[i],o,s);e>l&&(l=e,h=i)}return Math.sqrt(l)>i?(kT(t,e,h+1,i,a),kT(t,h,r,i,a)):(a.length||a.push(o),a.push(s)),a}function wT(t,e=.15,r){let i=[],n=(t.length-1)/3;for(let r=0;r<n;r++)bT(t,3*r,e,i);return r&&r>0?kT(i,0,i.length,r):i}s(VS,"v"),s(GS,"S"),s(XS,"O"),s(ZS,"L"),s(QS,"T"),s(KS,"D"),s(JS,"A"),s(tT,"_"),s(eT,"I"),s(rT,"C"),s(iT,"z"),s(nT,"W"),s(aT,"E"),s(oT,"G"),s(sT,"$"),s(lT,"R"),s(hT,"j"),s(cT,"q"),s(uT,"F"),s(dT,"V"),s(pT,"Z"),s(fT,"Q"),s(gT,"H"),s(yT,"N"),s(mT,"B"),s(xT,"J"),s(bT,"K"),s(CT,"U"),s(kT,"X"),s(wT,"Y");var _T="none",vT=class{static{s(this,"et")}constructor(t){this.defaultOptions={maxRandomnessOffset:2,roughness:1,bowing:1,stroke:"#000",strokeWidth:1,curveTightness:0,curveFitting:.95,curveStepCount:9,fillStyle:"hachure",fillWeight:-1,hachureAngle:-41,hachureGap:-1,dashOffset:-1,dashGap:-1,zigzagOffset:-1,seed:0,disableMultiStroke:!1,disableMultiStrokeFill:!1,preserveVertices:!1,fillShapeRoughnessGain:.8},this.config=t||{},this.config.options&&(this.defaultOptions=this._o(this.config.options))}static newSeed(){return Math.floor(Math.random()*2**31)}_o(t){return t?Object.assign({},this.defaultOptions,t):this.defaultOptions}_d(t,e,r){return{shape:t,sets:e||[],options:r||this.defaultOptions}}line(t,e,r,i,n){let a=this._o(n);return this._d("line",[VS(t,e,r,i,a)],a)}rectangle(t,e,r,i,n){let a=this._o(n),o=[],s=XS(t,e,r,i,a);if(a.fill){let n=[[t,e],[t+r,e],[t+r,e+i],[t,e+i]];"solid"===a.fillStyle?o.push(eT([n],a)):o.push(rT([n],a))}return a.stroke!==_T&&o.push(s),this._d("rectangle",o,a)}ellipse(t,e,r,i,n){let a=this._o(n),o=[],s=QS(r,i,a),l=KS(t,e,a,s);if(a.fill)if("solid"===a.fillStyle){let r=KS(t,e,a,s).opset;r.type="fillPath",o.push(r)}else o.push(rT([l.estimatedPoints],a));return a.stroke!==_T&&o.push(l.opset),this._d("ellipse",o,a)}circle(t,e,r,i){let n=this.ellipse(t,e,r,r,i);return n.shape="circle",n}linearPath(t,e){let r=this._o(e);return this._d("linearPath",[GS(t,!1,r)],r)}arc(t,e,r,i,n,a,o=!1,s){let l=this._o(s),h=[],c=JS(t,e,r,i,n,a,o,!0,l);if(o&&l.fill)if("solid"===l.fillStyle){let o=Object.assign({},l);o.disableMultiStroke=!0;let s=JS(t,e,r,i,n,a,!0,!1,o);s.type="fillPath",h.push(s)}else h.push(function(t,e,r,i,n,a,o){let s=t,l=e,h=Math.abs(r/2),c=Math.abs(i/2);h+=oT(.01*h,o),c+=oT(.01*c,o);let u=n,d=a;for(;u<0;)u+=2*Math.PI,d+=2*Math.PI;d-u>2*Math.PI&&(u=0,d=2*Math.PI);let p=(d-u)/o.curveStepCount,f=[];for(let t=u;t<=d;t+=p)f.push([s+h*Math.cos(t),l+c*Math.sin(t)]);return f.push([s+h*Math.cos(d),l+c*Math.sin(d)]),f.push([s,l]),rT([f],o)}(t,e,r,i,n,a,l));return l.stroke!==_T&&h.push(c),this._d("arc",h,l)}curve(t,e){let r=this._o(e),i=[],n=ZS(t,r);if(r.fill&&r.fill!==_T)if("solid"===r.fillStyle){let e=ZS(t,Object.assign(Object.assign({},r),{disableMultiStroke:!0,roughness:r.roughness?r.roughness+r.fillShapeRoughnessGain:0}));i.push({type:"fillPath",ops:this._mergedShape(e.ops)})}else{let e=[],n=t;if(n.length){let t="number"==typeof n[0][0]?[n]:n;for(let i of t)i.length<3?e.push(...i):3===i.length?e.push(...wT(gT([i[0],i[0],i[1],i[2]]),10,(1+r.roughness)/2)):e.push(...wT(gT(i),10,(1+r.roughness)/2))}e.length&&i.push(rT([e],r))}return r.stroke!==_T&&i.push(n),this._d("curve",i,r)}polygon(t,e){let r=this._o(e),i=[],n=GS(t,!0,r);return r.fill&&("solid"===r.fillStyle?i.push(eT([t],r)):i.push(rT([t],r))),r.stroke!==_T&&i.push(n),this._d("polygon",i,r)}path(t,e){let r=this._o(e),i=[];if(!t)return this._d("path",i,r);t=(t||"").replace(/\n/g," ").replace(/(-\s)/g,"-").replace("/(ss)/g"," ");let n=r.fill&&"transparent"!==r.fill&&r.fill!==_T,a=r.stroke!==_T,o=!!(r.simplification&&r.simplification<1),l=function(t,e,r){let i=WS(jS(qS(t))),n=[],a=[],o=[0,0],l=[],h=s(()=>{l.length>=4&&a.push(...wT(l,1)),l=[]},"i"),c=s(()=>{h(),a.length&&(n.push(a),a=[])},"c");for(let{key:t,data:e}of i)switch(t){case"M":c(),o=[e[0],e[1]],a.push(o);break;case"L":h(),a.push([e[0],e[1]]);break;case"C":if(!l.length){let t=a.length?a[a.length-1]:o;l.push([t[0],t[1]])}l.push([e[0],e[1]]),l.push([e[2],e[3]]),l.push([e[4],e[5]]);break;case"Z":h(),a.push([o[0],o[1]])}if(c(),!r)return n;let u=[];for(let t of n){let e=CT(t,r);e.length&&u.push(e)}return u}(t,0,o?4-4*(r.simplification||1):(1+r.roughness)/2),h=tT(t,r);if(n)if("solid"===r.fillStyle)if(1===l.length){let e=tT(t,Object.assign(Object.assign({},r),{disableMultiStroke:!0,roughness:r.roughness?r.roughness+r.fillShapeRoughnessGain:0}));i.push({type:"fillPath",ops:this._mergedShape(e.ops)})}else i.push(eT(l,r));else i.push(rT(l,r));return a&&(o?l.forEach(t=>{i.push(GS(t,!1,r))}):i.push(h)),this._d("path",i,r)}opsToPath(t,e){let r="";for(let i of t.ops){let t="number"==typeof e&&e>=0?i.data.map(t=>+t.toFixed(e)):i.data;switch(i.op){case"move":r+=`M${t[0]} ${t[1]} `;break;case"bcurveTo":r+=`C${t[0]} ${t[1]}, ${t[2]} ${t[3]}, ${t[4]} ${t[5]} `;break;case"lineTo":r+=`L${t[0]} ${t[1]} `}}return r.trim()}toPaths(t){let e=t.sets||[],r=t.options||this.defaultOptions,i=[];for(let t of e){let e=null;switch(t.type){case"path":e={d:this.opsToPath(t),stroke:r.stroke,strokeWidth:r.strokeWidth,fill:_T};break;case"fillPath":e={d:this.opsToPath(t),stroke:_T,strokeWidth:0,fill:r.fill||_T};break;case"fillSketch":e=this.fillSketch(t,r)}e&&i.push(e)}return i}fillSketch(t,e){let r=e.fillWeight;return r<0&&(r=e.strokeWidth/2),{d:this.opsToPath(t),stroke:e.fill||_T,strokeWidth:r,fill:_T}}_mergedShape(t){return t.filter((t,e)=>0===e||"move"!==t.op)}},ST=class{static{s(this,"st")}constructor(t,e){this.canvas=t,this.ctx=this.canvas.getContext("2d"),this.gen=new vT(e)}draw(t){let e=t.sets||[],r=t.options||this.getDefaultOptions(),i=this.ctx,n=t.options.fixedDecimalPlaceDigits;for(let a of e)switch(a.type){case"path":i.save(),i.strokeStyle="none"===r.stroke?"transparent":r.stroke,i.lineWidth=r.strokeWidth,r.strokeLineDash&&i.setLineDash(r.strokeLineDash),r.strokeLineDashOffset&&(i.lineDashOffset=r.strokeLineDashOffset),this._drawToContext(i,a,n),i.restore();break;case"fillPath":{i.save(),i.fillStyle=r.fill||"";let e="curve"===t.shape||"polygon"===t.shape||"path"===t.shape?"evenodd":"nonzero";this._drawToContext(i,a,n,e),i.restore();break}case"fillSketch":this.fillSketch(i,a,r)}}fillSketch(t,e,r){let i=r.fillWeight;i<0&&(i=r.strokeWidth/2),t.save(),r.fillLineDash&&t.setLineDash(r.fillLineDash),r.fillLineDashOffset&&(t.lineDashOffset=r.fillLineDashOffset),t.strokeStyle=r.fill||"",t.lineWidth=i,this._drawToContext(t,e,r.fixedDecimalPlaceDigits),t.restore()}_drawToContext(t,e,r,i="nonzero"){t.beginPath();for(let i of e.ops){let e="number"==typeof r&&r>=0?i.data.map(t=>+t.toFixed(r)):i.data;switch(i.op){case"move":t.moveTo(e[0],e[1]);break;case"bcurveTo":t.bezierCurveTo(e[0],e[1],e[2],e[3],e[4],e[5]);break;case"lineTo":t.lineTo(e[0],e[1])}}"fillPath"===e.type?t.fill(i):t.stroke()}get generator(){return this.gen}getDefaultOptions(){return this.gen.defaultOptions}line(t,e,r,i,n){let a=this.gen.line(t,e,r,i,n);return this.draw(a),a}rectangle(t,e,r,i,n){let a=this.gen.rectangle(t,e,r,i,n);return this.draw(a),a}ellipse(t,e,r,i,n){let a=this.gen.ellipse(t,e,r,i,n);return this.draw(a),a}circle(t,e,r,i){let n=this.gen.circle(t,e,r,i);return this.draw(n),n}linearPath(t,e){let r=this.gen.linearPath(t,e);return this.draw(r),r}polygon(t,e){let r=this.gen.polygon(t,e);return this.draw(r),r}arc(t,e,r,i,n,a,o=!1,s){let l=this.gen.arc(t,e,r,i,n,a,o,s);return this.draw(l),l}curve(t,e){let r=this.gen.curve(t,e);return this.draw(r),r}path(t,e){let r=this.gen.path(t,e);return this.draw(r),r}},TT="http://www.w3.org/2000/svg",MT=class{static{s(this,"ot")}constructor(t,e){this.svg=t,this.gen=new vT(e)}draw(t){let e=t.sets||[],r=t.options||this.getDefaultOptions(),i=this.svg.ownerDocument||window.document,n=i.createElementNS(TT,"g"),a=t.options.fixedDecimalPlaceDigits;for(let o of e){let e=null;switch(o.type){case"path":e=i.createElementNS(TT,"path"),e.setAttribute("d",this.opsToPath(o,a)),e.setAttribute("stroke",r.stroke),e.setAttribute("stroke-width",r.strokeWidth+""),e.setAttribute("fill","none"),r.strokeLineDash&&e.setAttribute("stroke-dasharray",r.strokeLineDash.join(" ").trim()),r.strokeLineDashOffset&&e.setAttribute("stroke-dashoffset",`${r.strokeLineDashOffset}`);break;case"fillPath":e=i.createElementNS(TT,"path"),e.setAttribute("d",this.opsToPath(o,a)),e.setAttribute("stroke","none"),e.setAttribute("stroke-width","0"),e.setAttribute("fill",r.fill||""),"curve"!==t.shape&&"polygon"!==t.shape||e.setAttribute("fill-rule","evenodd");break;case"fillSketch":e=this.fillSketch(i,o,r)}e&&n.appendChild(e)}return n}fillSketch(t,e,r){let i=r.fillWeight;i<0&&(i=r.strokeWidth/2);let n=t.createElementNS(TT,"path");return n.setAttribute("d",this.opsToPath(e,r.fixedDecimalPlaceDigits)),n.setAttribute("stroke",r.fill||""),n.setAttribute("stroke-width",i+""),n.setAttribute("fill","none"),r.fillLineDash&&n.setAttribute("stroke-dasharray",r.fillLineDash.join(" ").trim()),r.fillLineDashOffset&&n.setAttribute("stroke-dashoffset",`${r.fillLineDashOffset}`),n}get generator(){return this.gen}getDefaultOptions(){return this.gen.defaultOptions}opsToPath(t,e){return this.gen.opsToPath(t,e)}line(t,e,r,i,n){let a=this.gen.line(t,e,r,i,n);return this.draw(a)}rectangle(t,e,r,i,n){let a=this.gen.rectangle(t,e,r,i,n);return this.draw(a)}ellipse(t,e,r,i,n){let a=this.gen.ellipse(t,e,r,i,n);return this.draw(a)}circle(t,e,r,i){let n=this.gen.circle(t,e,r,i);return this.draw(n)}linearPath(t,e){let r=this.gen.linearPath(t,e);return this.draw(r)}polygon(t,e){let r=this.gen.polygon(t,e);return this.draw(r)}arc(t,e,r,i,n,a,o=!1,s){let l=this.gen.arc(t,e,r,i,n,a,o,s);return this.draw(l)}curve(t,e){let r=this.gen.curve(t,e);return this.draw(r)}path(t,e){let r=this.gen.path(t,e);return this.draw(r)}},BT={canvas:s((t,e)=>new ST(t,e),"canvas"),svg:s((t,e)=>new MT(t,e),"svg"),generator:s(t=>new vT(t),"generator"),newSeed:s(()=>vT.newSeed(),"newSeed")},AT=s((t,e)=>{var r,i,n=t.x,a=t.y,o=e.x-n,s=e.y-a,l=t.width/2,h=t.height/2;return Math.abs(s)*l>Math.abs(o)*h?(s<0&&(h=-h),r=0===s?0:h*o/s,i=h):(o<0&&(l=-l),r=l,i=0===o?0:l*s/o),{x:n+r,y:a+i}},"intersectRect"),FT=AT;function LT(t,e){e&&t.attr("style",e)}async function $T(t){let e=ro(document.createElementNS("http://www.w3.org/2000/svg","foreignObject")),r=e.append("xhtml:div"),i=t.label;t.label&&zr(t.label)&&(i=await jr(t.label.replace(Wr.lineBreakRegex,"\n"),di()));let n=t.isNode?"nodeLabel":"edgeLabel";return r.html('<span class="'+n+'" '+(t.labelStyle?'style="'+t.labelStyle+'"':"")+">"+i+"</span>"),LT(r,t.labelStyle),r.style("display","inline-block"),r.style("padding-right","1px"),r.style("white-space","nowrap"),r.attr("xmlns","http://www.w3.org/1999/xhtml"),e.node()}s(LT,"applyStyle"),s($T,"addHtmlLabel");var ET=s(async(t,e,r,i)=>{let n=t||"";if("object"==typeof n&&(n=n[0]),Lr(di().flowchart.htmlLabels)){n=n.replace(/\\n|\n/g,"<br />"),y.info("vertexText"+n);let t={isNode:i,label:r_(n).replace(/fa[blrs]?:fa-[\w-]+/g,t=>`<i class='${t.replace(":"," ")}'></i>`),labelStyle:e&&e.replace("fill:","color:")};return await $T(t)}{let t=document.createElementNS("http://www.w3.org/2000/svg","text");t.setAttribute("style",e.replace("color:","fill:"));let i=[];i="string"==typeof n?n.split(/\\n|\n|<br\s*\/?>/gi):Array.isArray(n)?n:[];for(let e of i){let i=document.createElementNS("http://www.w3.org/2000/svg","tspan");i.setAttributeNS("http://www.w3.org/XML/1998/namespace","xml:space","preserve"),i.setAttribute("dy","1em"),i.setAttribute("x","0"),r?i.setAttribute("class","title-row"):i.setAttribute("class","row"),i.textContent=e.trim(),t.appendChild(i)}return t}},"createLabel"),DT=ET,OT=s((t,e,r,i,n)=>["M",t+n,e,"H",t+r-n,"A",n,n,0,0,1,t+r,e+n,"V",e+i-n,"A",n,n,0,0,1,t+r-n,e+i,"H",t+n,"A",n,n,0,0,1,t,e+i-n,"V",e+n,"A",n,n,0,0,1,t+n,e,"Z"].join(" "),"createRoundedRectPathD"),IT=s(async(t,e)=>{y.info("Creating subgraph rect for ",e.id,e);let r=di(),{themeVariables:i,handDrawnSeed:n}=r,{clusterBkg:a,clusterBorder:o}=i,{labelStyles:s,nodeStyles:l,borderStyles:h,backgroundStyles:c}=ax(e),u=t.insert("g").attr("class","cluster "+e.cssClasses).attr("id",e.id).attr("data-look",e.look),d=Lr(r.flowchart.htmlLabels),p=u.insert("g").attr("class","cluster-label "),f=await xS(p,e.label,{style:e.labelStyle,useHtmlLabels:d,isNode:!0}),g=f.getBBox();if(Lr(r.flowchart.htmlLabels)){let t=f.children[0],e=ro(f);g=t.getBoundingClientRect(),e.attr("width",g.width),e.attr("height",g.height)}let m=e.width<=g.width+e.padding?g.width+e.padding:e.width;e.width<=g.width+e.padding?e.diff=(m-e.width)/2-e.padding:e.diff=-e.padding;let x,b=e.height,C=e.x-m/2,k=e.y-b/2;if(y.trace("Data ",e,JSON.stringify(e)),"handDrawn"===e.look){let t=BT.svg(u),r=ox(e,{roughness:.7,fill:a,stroke:o,fillWeight:3,seed:n}),i=t.path(OT(C,k,m,b,0),r);x=u.insert(()=>(y.debug("Rough node insert CXC",i),i),":first-child"),x.select("path:nth-child(2)").attr("style",h.join(";")),x.select("path").attr("style",c.join(";").replace("fill","stroke"))}else x=u.insert("rect",":first-child"),x.attr("style",l).attr("rx",e.rx).attr("ry",e.ry).attr("x",C).attr("y",k).attr("width",m).attr("height",b);let{subGraphTitleTopMargin:w}=tx(r);if(p.attr("transform",`translate(${e.x-g.width/2}, ${e.y-e.height/2+w})`),s){let t=p.select("span");t&&t.attr("style",s)}let _=x.node().getBBox();return e.offsetX=0,e.width=_.width,e.height=_.height,e.offsetY=g.height-e.padding/2,e.intersect=function(t){return FT(e,t)},{cluster:u,labelBBox:g}},"rect"),NT=s((t,e)=>{let r=t.insert("g").attr("class","note-cluster").attr("id",e.id),i=r.insert("rect",":first-child"),n=0*e.padding,a=n/2;i.attr("rx",e.rx).attr("ry",e.ry).attr("x",e.x-e.width/2-a).attr("y",e.y-e.height/2-a).attr("width",e.width+n).attr("height",e.height+n).attr("fill","none");let o=i.node().getBBox();return e.width=o.width,e.height=o.height,e.intersect=function(t){return FT(e,t)},{cluster:r,labelBBox:{width:0,height:0}}},"noteGroup"),RT=s(async(t,e)=>{let r=di(),{themeVariables:i,handDrawnSeed:n}=r,{altBackground:a,compositeBackground:o,compositeTitleBackground:s,nodeBorder:l}=i,h=t.insert("g").attr("class",e.cssClasses).attr("id",e.id).attr("data-id",e.id).attr("data-look",e.look),c=h.insert("g",":first-child"),u=h.insert("g").attr("class","cluster-label"),d=h.append("rect"),p=u.node().appendChild(await DT(e.label,e.labelStyle,void 0,!0)),f=p.getBBox();if(Lr(r.flowchart.htmlLabels)){let t=p.children[0],e=ro(p);f=t.getBoundingClientRect(),e.attr("width",f.width),e.attr("height",f.height)}let g=0*e.padding,y=g/2,m=(e.width<=f.width+e.padding?f.width+e.padding:e.width)+g;e.width<=f.width+e.padding?e.diff=(m-e.width)/2-e.padding:e.diff=-e.padding;let x=e.height+g,b=e.height+g-f.height-6,C=e.x-m/2,k=e.y-x/2;e.width=m;let w,_=e.y-e.height/2-y+f.height+2;if("handDrawn"===e.look){let t=e.cssClasses.includes("statediagram-cluster-alt"),r=BT.svg(h),i=e.rx||e.ry?r.path(OT(C,k,m,x,10),{roughness:.7,fill:s,fillStyle:"solid",stroke:l,seed:n}):r.rectangle(C,k,m,x,{seed:n});w=h.insert(()=>i,":first-child");let c=r.rectangle(C,_,m,b,{fill:t?a:o,fillStyle:t?"hachure":"solid",stroke:l,seed:n});w=h.insert(()=>i,":first-child"),d=h.insert(()=>c)}else w=c.insert("rect",":first-child"),w.attr("class","outer").attr("x",C).attr("y",k).attr("width",m).attr("height",x).attr("data-look",e.look),d.attr("class","inner").attr("x",C).attr("y",_).attr("width",m).attr("height",b);u.attr("transform",`translate(${e.x-f.width/2}, ${k+1-(Lr(r.flowchart.htmlLabels)?0:3)})`);let v=w.node().getBBox();return e.height=v.height,e.offsetX=0,e.offsetY=f.height-e.padding/2,e.labelBBox=f,e.intersect=function(t){return FT(e,t)},{cluster:h,labelBBox:f}},"roundedWithTitle"),PT=s(async(t,e)=>{y.info("Creating subgraph rect for ",e.id,e);let r=di(),{themeVariables:i,handDrawnSeed:n}=r,{clusterBkg:a,clusterBorder:o}=i,{labelStyles:s,nodeStyles:l,borderStyles:h,backgroundStyles:c}=ax(e),u=t.insert("g").attr("class","cluster "+e.cssClasses).attr("id",e.id).attr("data-look",e.look),d=Lr(r.flowchart.htmlLabels),p=u.insert("g").attr("class","cluster-label "),f=await xS(p,e.label,{style:e.labelStyle,useHtmlLabels:d,isNode:!0,width:e.width}),g=f.getBBox();if(Lr(r.flowchart.htmlLabels)){let t=f.children[0],e=ro(f);g=t.getBoundingClientRect(),e.attr("width",g.width),e.attr("height",g.height)}let m=e.width<=g.width+e.padding?g.width+e.padding:e.width;e.width<=g.width+e.padding?e.diff=(m-e.width)/2-e.padding:e.diff=-e.padding;let x,b=e.height,C=e.x-m/2,k=e.y-b/2;if(y.trace("Data ",e,JSON.stringify(e)),"handDrawn"===e.look){let t=BT.svg(u),r=ox(e,{roughness:.7,fill:a,stroke:o,fillWeight:4,seed:n}),i=t.path(OT(C,k,m,b,e.rx),r);x=u.insert(()=>(y.debug("Rough node insert CXC",i),i),":first-child"),x.select("path:nth-child(2)").attr("style",h.join(";")),x.select("path").attr("style",c.join(";").replace("fill","stroke"))}else x=u.insert("rect",":first-child"),x.attr("style",l).attr("rx",e.rx).attr("ry",e.ry).attr("x",C).attr("y",k).attr("width",m).attr("height",b);let{subGraphTitleTopMargin:w}=tx(r);if(p.attr("transform",`translate(${e.x-g.width/2}, ${e.y-e.height/2+w})`),s){let t=p.select("span");t&&t.attr("style",s)}let _=x.node().getBBox();return e.offsetX=0,e.width=_.width,e.height=_.height,e.offsetY=g.height-e.padding/2,e.intersect=function(t){return FT(e,t)},{cluster:u,labelBBox:g}},"kanbanSection"),zT=s((t,e)=>{let r=di(),{themeVariables:i,handDrawnSeed:n}=r,{nodeBorder:a}=i,o=t.insert("g").attr("class",e.cssClasses).attr("id",e.id).attr("data-look",e.look),s=o.insert("g",":first-child"),l=0*e.padding,h=e.width+l;e.diff=-e.padding;let c,u=e.height+l,d=e.x-h/2,p=e.y-u/2;if(e.width=h,"handDrawn"===e.look){let t=BT.svg(o).rectangle(d,p,h,u,{fill:"lightgrey",roughness:.5,strokeLineDash:[5],stroke:a,seed:n});c=o.insert(()=>t,":first-child")}else c=s.insert("rect",":first-child"),c.attr("class","divider").attr("x",d).attr("y",p).attr("width",h).attr("height",u).attr("data-look",e.look);let f=c.node().getBBox();return e.height=f.height,e.offsetX=0,e.offsetY=0,e.intersect=function(t){return FT(e,t)},{cluster:o,labelBBox:{}}},"divider"),qT={rect:IT,squareRect:IT,roundedWithTitle:RT,noteGroup:NT,divider:zT,kanbanSection:PT},jT=new Map,WT=s(async(t,e)=>{let r=e.shape||"rect",i=await qT[r](t,e);return jT.set(e.id,i),i},"insertCluster"),HT=s(()=>{jT=new Map},"clear");function UT(t,e){return t.intersect(e)}s(UT,"intersectNode");var YT=UT;function VT(t,e,r,i){var n=t.x,a=t.y,o=n-i.x,s=a-i.y,l=Math.sqrt(e*e*s*s+r*r*o*o),h=Math.abs(e*r*o/l);i.x<n&&(h=-h);var c=Math.abs(e*r*s/l);return i.y<a&&(c=-c),{x:n+h,y:a+c}}s(VT,"intersectEllipse");var GT=VT;function XT(t,e,r){return GT(t,e,e,r)}s(XT,"intersectCircle");var ZT=XT;function QT(t,e,r,i){var n,a,o,s,l,h,c,u,d,p,f,g,y;if(n=e.y-t.y,o=t.x-e.x,l=e.x*t.y-t.x*e.y,d=n*r.x+o*r.y+l,p=n*i.x+o*i.y+l,!(0!==d&&0!==p&&KT(d,p)||(a=i.y-r.y,s=r.x-i.x,h=i.x*r.y-r.x*i.y,c=a*t.x+s*t.y+h,u=a*e.x+s*e.y+h,0!==c&&0!==u&&KT(c,u)||(f=n*s-a*o,0===f))))return g=Math.abs(f/2),{x:(y=o*h-s*l)<0?(y-g)/f:(y+g)/f,y:(y=a*l-n*h)<0?(y-g)/f:(y+g)/f}}function KT(t,e){return t*e>0}s(QT,"intersectLine"),s(KT,"sameSign");var JT=QT;function tM(t,e,r){let i=t.x,n=t.y,a=[],o=Number.POSITIVE_INFINITY,s=Number.POSITIVE_INFINITY;"function"==typeof e.forEach?e.forEach(function(t){o=Math.min(o,t.x),s=Math.min(s,t.y)}):(o=Math.min(o,e.x),s=Math.min(s,e.y));let l=i-t.width/2-o,h=n-t.height/2-s;for(let i=0;i<e.length;i++){let n=e[i],o=e[i<e.length-1?i+1:0],s=JT(t,r,{x:l+n.x,y:h+n.y},{x:l+o.x,y:h+o.y});s&&a.push(s)}return a.length?(a.length>1&&a.sort(function(t,e){let i=t.x-r.x,n=t.y-r.y,a=Math.sqrt(i*i+n*n),o=e.x-r.x,s=e.y-r.y,l=Math.sqrt(o*o+s*s);return a<l?-1:a===l?0:1}),a[0]):t}s(tM,"intersectPolygon");var eM={node:YT,circle:ZT,ellipse:GT,polygon:tM,rect:FT};function rM(t,e){let{labelStyles:r}=ax(e);e.labelStyle=r;let i=wS(e),n=i;i||(n="anchor");let a=t.insert("g").attr("class",n).attr("id",e.domId||e.id),{cssStyles:o}=e,s=BT.svg(a),l=ox(e,{fill:"black",stroke:"none",fillStyle:"solid"});"handDrawn"!==e.look&&(l.roughness=0);let h=s.circle(0,0,2,l),c=a.insert(()=>h,":first-child");return c.attr("class","anchor").attr("style",n_(o)),kS(e,c),e.intersect=function(t){return y.info("Circle intersect",e,1,t),eM.circle(e,1,t)},a}function iM(t,e,r,i,n,a,o){let s=(t+r)/2,l=(e+i)/2,h=Math.atan2(i-e,r-t),c=(r-t)/2/n,u=(i-e)/2/a,d=Math.sqrt(c**2+u**2);if(d>1)throw new Error("The given radii are too small to create an arc between the points.");let p=Math.sqrt(1-d**2),f=s+p*a*Math.sin(h)*(o?-1:1),g=l-p*n*Math.cos(h)*(o?-1:1),y=Math.atan2((e-g)/a,(t-f)/n),m=Math.atan2((i-g)/a,(r-f)/n)-y;o&&m<0&&(m+=2*Math.PI),!o&&m>0&&(m-=2*Math.PI);let x=[];for(let t=0;t<20;t++){let e=y+t/19*m,r=f+n*Math.cos(e),i=g+a*Math.sin(e);x.push({x:r,y:i})}return x}async function nM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await bS(t,e,wS(e)),o=a.width+e.padding+20,s=a.height+e.padding,l=s/2,h=l/(2.5+s/50),{cssStyles:c}=e,u=[{x:o/2,y:-s/2},{x:-o/2,y:-s/2},...iM(-o/2,-s/2,-o/2,s/2,h,l,!1),{x:o/2,y:s/2},...iM(o/2,s/2,o/2,-s/2,h,l,!0)],d=BT.svg(n),p=ox(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=_S(u),g=d.path(f,p),y=n.insert(()=>g,":first-child");return y.attr("class","basic label-container"),c&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",c),i&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",i),y.attr("transform",`translate(${h/2}, 0)`),kS(e,y),e.intersect=function(t){return eM.polygon(e,u,t)},n}function aM(t,e,r,i){return t.insert("polygon",":first-child").attr("points",i.map(function(t){return t.x+","+t.y}).join(" ")).attr("class","label-container").attr("transform","translate("+-e/2+","+r/2+")")}async function oM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await bS(t,e,wS(e)),s=o.height+e.padding,l=o.width+e.padding+12,h=-s,c=[{x:12,y:h},{x:l,y:h},{x:l,y:0},{x:0,y:0},{x:0,y:h+12},{x:12,y:h}],{cssStyles:u}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=_S(c),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-l/2}, ${s/2})`),u&&n.attr("style",u)}else n=aM(a,l,s,c);return i&&n.attr("style",i),kS(e,n),e.intersect=function(t){return eM.polygon(e,c,t)},a}function sM(t,e){let{nodeStyles:r}=ax(e);e.label="";let i=t.insert("g").attr("class",wS(e)).attr("id",e.domId??e.id),{cssStyles:n}=e,a=Math.max(28,e.width??0),o=[{x:0,y:a/2},{x:a/2,y:0},{x:0,y:-a/2},{x:-a/2,y:0}],s=BT.svg(i),l=ox(e,{});"handDrawn"!==e.look&&(l.roughness=0,l.fillStyle="solid");let h=_S(o),c=s.path(h,l),u=i.insert(()=>c,":first-child");return n&&"handDrawn"!==e.look&&u.selectAll("path").attr("style",n),r&&"handDrawn"!==e.look&&u.selectAll("path").attr("style",r),e.width=28,e.height=28,e.intersect=function(t){return eM.polygon(e,o,t)},i}async function lM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,halfPadding:s}=await bS(t,e,wS(e)),l=o.width/2+s,{cssStyles:h}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=t.circle(0,0,2*l,r);n=a.insert(()=>i,":first-child"),n.attr("class","basic label-container").attr("style",n_(h))}else n=a.insert("circle",":first-child").attr("class","basic label-container").attr("style",i).attr("r",l).attr("cx",0).attr("cy",0);return kS(e,n),e.intersect=function(t){return y.info("Circle intersect",e,l,t),eM.circle(e,l,t)},a}function hM(t){let e=Math.cos(Math.PI/4),r=Math.sin(Math.PI/4),i=2*t;return`M ${-i/2*e},${i/2*r} L ${i/2*e},${-i/2*r}\n                   M ${i/2*e},${i/2*r} L ${-i/2*e},${-i/2*r}`}function cM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r,e.label="";let n=t.insert("g").attr("class",wS(e)).attr("id",e.domId??e.id),a=Math.max(30,e?.width??0),{cssStyles:o}=e,s=BT.svg(n),l=ox(e,{});"handDrawn"!==e.look&&(l.roughness=0,l.fillStyle="solid");let h=s.circle(0,0,2*a,l),c=hM(a),u=s.path(c,l),d=n.insert(()=>h,":first-child");return d.insert(()=>u),o&&"handDrawn"!==e.look&&d.selectAll("path").attr("style",o),i&&"handDrawn"!==e.look&&d.selectAll("path").attr("style",i),kS(e,d),e.intersect=function(t){return y.info("crossedCircle intersect",e,{radius:a,point:t}),eM.circle(e,a,t)},n}function uM(t,e,r,i=100,n=0,a=180){let o=[],s=n*Math.PI/180,l=(a*Math.PI/180-s)/(i-1);for(let n=0;n<i;n++){let i=s+n*l,a=t+r*Math.cos(i),h=e+r*Math.sin(i);o.push({x:-a,y:-h})}return o}async function dM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=a.width+(e.padding??0),l=a.height+(e.padding??0),h=Math.max(5,.1*l),{cssStyles:c}=e,u=[...uM(s/2,-l/2,h,30,-90,0),{x:-s/2-h,y:h},...uM(s/2+2*h,-h,h,20,-180,-270),...uM(s/2+2*h,h,h,20,-90,-180),{x:-s/2-h,y:-l/2},...uM(s/2,l/2,h,20,0,90)],d=[{x:s/2,y:-l/2-h},{x:-s/2,y:-l/2-h},...uM(s/2,-l/2,h,20,-90,0),{x:-s/2-h,y:-h},...uM(s/2+.1*s,-h,h,20,-180,-270),...uM(s/2+.1*s,h,h,20,-90,-180),{x:-s/2-h,y:l/2},...uM(s/2,l/2,h,20,0,90),{x:-s/2,y:l/2+h},{x:s/2,y:l/2+h}],p=BT.svg(n),f=ox(e,{fill:"none"});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=_S(u).replace("Z",""),y=p.path(g,f),m=_S(d),x=p.path(m,{...f}),b=n.insert("g",":first-child");return b.insert(()=>x,":first-child").attr("stroke-opacity",0),b.insert(()=>y,":first-child"),b.attr("class","text"),c&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",c),i&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",i),b.attr("transform",`translate(${h}, 0)`),o.attr("transform",`translate(${-s/2+h-(a.x-(a.left??0))},${-l/2+(e.padding??0)/2-(a.y-(a.top??0))})`),kS(e,b),e.intersect=function(t){return eM.polygon(e,d,t)},n}function pM(t,e,r,i=100,n=0,a=180){let o=[],s=n*Math.PI/180,l=(a*Math.PI/180-s)/(i-1);for(let n=0;n<i;n++){let i=s+n*l,a=t+r*Math.cos(i),h=e+r*Math.sin(i);o.push({x:a,y:h})}return o}async function fM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=a.width+(e.padding??0),l=a.height+(e.padding??0),h=Math.max(5,.1*l),{cssStyles:c}=e,u=[...pM(s/2,-l/2,h,20,-90,0),{x:s/2+h,y:-h},...pM(s/2+2*h,-h,h,20,-180,-270),...pM(s/2+2*h,h,h,20,-90,-180),{x:s/2+h,y:l/2},...pM(s/2,l/2,h,20,0,90)],d=[{x:-s/2,y:-l/2-h},{x:s/2,y:-l/2-h},...pM(s/2,-l/2,h,20,-90,0),{x:s/2+h,y:-h},...pM(s/2+2*h,-h,h,20,-180,-270),...pM(s/2+2*h,h,h,20,-90,-180),{x:s/2+h,y:l/2},...pM(s/2,l/2,h,20,0,90),{x:s/2,y:l/2+h},{x:-s/2,y:l/2+h}],p=BT.svg(n),f=ox(e,{fill:"none"});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=_S(u).replace("Z",""),y=p.path(g,f),m=_S(d),x=p.path(m,{...f}),b=n.insert("g",":first-child");return b.insert(()=>x,":first-child").attr("stroke-opacity",0),b.insert(()=>y,":first-child"),b.attr("class","text"),c&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",c),i&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",i),b.attr("transform",`translate(${-h}, 0)`),o.attr("transform",`translate(${-s/2+(e.padding??0)/2-(a.x-(a.left??0))},${-l/2+(e.padding??0)/2-(a.y-(a.top??0))})`),kS(e,b),e.intersect=function(t){return eM.polygon(e,d,t)},n}function gM(t,e,r,i=100,n=0,a=180){let o=[],s=n*Math.PI/180,l=(a*Math.PI/180-s)/(i-1);for(let n=0;n<i;n++){let i=s+n*l,a=t+r*Math.cos(i),h=e+r*Math.sin(i);o.push({x:-a,y:-h})}return o}async function yM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=a.width+(e.padding??0),l=a.height+(e.padding??0),h=Math.max(5,.1*l),{cssStyles:c}=e,u=[...gM(s/2,-l/2,h,30,-90,0),{x:-s/2-h,y:h},...gM(s/2+2*h,-h,h,20,-180,-270),...gM(s/2+2*h,h,h,20,-90,-180),{x:-s/2-h,y:-l/2},...gM(s/2,l/2,h,20,0,90)],d=[...gM(-s/2+h+h/2,-l/2,h,20,-90,-180),{x:s/2-h/2,y:h},...gM(-s/2-h/2,-h,h,20,0,90),...gM(-s/2-h/2,h,h,20,-90,0),{x:s/2-h/2,y:-h},...gM(-s/2+h+h/2,l/2,h,30,-180,-270)],p=[{x:s/2,y:-l/2-h},{x:-s/2,y:-l/2-h},...gM(s/2,-l/2,h,20,-90,0),{x:-s/2-h,y:-h},...gM(s/2+2*h,-h,h,20,-180,-270),...gM(s/2+2*h,h,h,20,-90,-180),{x:-s/2-h,y:l/2},...gM(s/2,l/2,h,20,0,90),{x:-s/2,y:l/2+h},{x:s/2-h-h/2,y:l/2+h},...gM(-s/2+h+h/2,-l/2,h,20,-90,-180),{x:s/2-h/2,y:h},...gM(-s/2-h/2,-h,h,20,0,90),...gM(-s/2-h/2,h,h,20,-90,0),{x:s/2-h/2,y:-h},...gM(-s/2+h+h/2,l/2,h,30,-180,-270)],f=BT.svg(n),g=ox(e,{fill:"none"});"handDrawn"!==e.look&&(g.roughness=0,g.fillStyle="solid");let y=_S(u).replace("Z",""),m=f.path(y,g),x=_S(d).replace("Z",""),b=f.path(x,g),C=_S(p),k=f.path(C,{...g}),w=n.insert("g",":first-child");return w.insert(()=>k,":first-child").attr("stroke-opacity",0),w.insert(()=>m,":first-child"),w.insert(()=>b,":first-child"),w.attr("class","text"),c&&"handDrawn"!==e.look&&w.selectAll("path").attr("style",c),i&&"handDrawn"!==e.look&&w.selectAll("path").attr("style",i),w.attr("transform",`translate(${h-h/4}, 0)`),o.attr("transform",`translate(${-s/2+(e.padding??0)/2-(a.x-(a.left??0))},${-l/2+(e.padding??0)/2-(a.y-(a.top??0))})`),kS(e,w),e.intersect=function(t){return eM.polygon(e,p,t)},n}async function mM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await bS(t,e,wS(e)),o=Math.max(80,1.25*(a.width+2*(e.padding??0)),e?.width??0),s=Math.max(20,a.height+2*(e.padding??0),e?.height??0),l=s/2,{cssStyles:h}=e,c=BT.svg(n),u=ox(e,{});"handDrawn"!==e.look&&(u.roughness=0,u.fillStyle="solid");let d=o-l,p=s/4,f=[{x:d,y:0},{x:p,y:0},{x:0,y:s/2},{x:p,y:s},{x:d,y:s},...SS(-d,-s/2,l,50,270,90)],g=_S(f),y=c.path(g,u),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container"),h&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",h),i&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",i),m.attr("transform",`translate(${-o/2}, ${-s/2})`),kS(e,m),e.intersect=function(t){return eM.polygon(e,f,t)},n}s(rM,"anchor"),s(iM,"generateArcPoints"),s(nM,"bowTieRect"),s(aM,"insertPolygonShape"),s(oM,"card"),s(sM,"choice"),s(lM,"circle"),s(hM,"createLine"),s(cM,"crossedCircle"),s(uM,"generateCirclePoints"),s(dM,"curlyBraceLeft"),s(pM,"generateCirclePoints"),s(fM,"curlyBraceRight"),s(gM,"generateCirclePoints"),s(yM,"curlyBraces"),s(mM,"curvedTrapezoid");var xM=s((t,e,r,i,n,a)=>[`M${t},${e+a}`,`a${n},${a} 0,0,0 ${r},0`,`a${n},${a} 0,0,0 ${-r},0`,`l0,${i}`,`a${n},${a} 0,0,0 ${r},0`,"l0,"+-i].join(" "),"createCylinderPathD"),bM=s((t,e,r,i,n,a)=>[`M${t},${e+a}`,`M${t+r},${e+a}`,`a${n},${a} 0,0,0 ${-r},0`,`l0,${i}`,`a${n},${a} 0,0,0 ${r},0`,"l0,"+-i].join(" "),"createOuterCylinderPathD"),CM=s((t,e,r,i,n,a)=>[`M${t-r/2},${-i/2}`,`a${n},${a} 0,0,0 ${r},0`].join(" "),"createInnerCylinderPathD");async function kM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,label:s}=await bS(t,e,wS(e)),l=Math.max(o.width+e.padding,e.width??0),h=l/2,c=h/(2.5+l/50),u=Math.max(o.height+c+e.padding,e.height??0),{cssStyles:d}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=bM(0,0,l,u,h,c),i=CM(0,c,l,u,h,c),o=t.path(r,ox(e,{})),s=t.path(i,ox(e,{fill:"none"}));n=a.insert(()=>s,":first-child"),n=a.insert(()=>o,":first-child"),n.attr("class","basic label-container"),d&&n.attr("style",d)}else{let t=xM(0,0,l,u,h,c);n=a.insert("path",":first-child").attr("d",t).attr("class","basic label-container").attr("style",n_(d)).attr("style",i)}return n.attr("label-offset-y",c),n.attr("transform",`translate(${-l/2}, ${-(u/2+c)})`),kS(e,n),s.attr("transform",`translate(${-o.width/2-(o.x-(o.left??0))}, ${-o.height/2+(e.padding??0)/1.5-(o.y-(o.top??0))})`),e.intersect=function(t){let r=eM.rect(e,t),i=r.x-(e.x??0);if(0!=h&&(Math.abs(i)<(e.width??0)/2||Math.abs(i)==(e.width??0)/2&&Math.abs(r.y-(e.y??0))>(e.height??0)/2-c)){let n=c*c*(1-i*i/(h*h));n>0&&(n=Math.sqrt(n)),n=c-n,t.y-(e.y??0)>0&&(n=-n),r.y+=n}return r},a}async function wM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=a.width+e.padding,l=a.height+e.padding,h=.2*l,c=-s/2,u=-l/2-h/2,{cssStyles:d}=e,p=BT.svg(n),f=ox(e,{});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=[{x:c,y:u+h},{x:-c,y:u+h},{x:-c,y:-u},{x:c,y:-u},{x:c,y:u},{x:-c,y:u},{x:-c,y:u+h}],y=p.polygon(g.map(t=>[t.x,t.y]),f),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container"),d&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",d),i&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",i),o.attr("transform",`translate(${c+(e.padding??0)/2-(a.x-(a.left??0))}, ${u+h+(e.padding??0)/2-(a.y-(a.top??0))})`),kS(e,m),e.intersect=function(t){return eM.rect(e,t)},n}async function _M(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,halfPadding:s}=await bS(t,e,wS(e)),l=o.width/2+s+5,h=o.width/2+s,{cssStyles:c}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{roughness:.2,strokeWidth:2.5}),i=ox(e,{roughness:.2,strokeWidth:1.5}),o=t.circle(0,0,2*l,r),s=t.circle(0,0,2*h,i);n=a.insert("g",":first-child"),n.attr("class",n_(e.cssClasses)).attr("style",n_(c)),n.node()?.appendChild(o),n.node()?.appendChild(s)}else{n=a.insert("g",":first-child");let t=n.insert("circle",":first-child"),e=n.insert("circle");n.attr("class","basic label-container").attr("style",i),t.attr("class","outer-circle").attr("style",i).attr("r",l).attr("cx",0).attr("cy",0),e.attr("class","inner-circle").attr("style",i).attr("r",h).attr("cx",0).attr("cy",0)}return kS(e,n),e.intersect=function(t){return y.info("DoubleCircle intersect",e,l,t),eM.circle(e,l,t)},a}function vM(t,e,{config:{themeVariables:r}}){let{labelStyles:i,nodeStyles:n}=ax(e);e.label="",e.labelStyle=i;let a=t.insert("g").attr("class",wS(e)).attr("id",e.domId??e.id),{cssStyles:o}=e,s=BT.svg(a),{nodeBorder:l}=r,h=ox(e,{fillStyle:"solid"});"handDrawn"!==e.look&&(h.roughness=0);let c=s.circle(0,0,14,h),u=a.insert(()=>c,":first-child");return u.selectAll("path").attr("style",`fill: ${l} !important;`),o&&o.length>0&&"handDrawn"!==e.look&&u.selectAll("path").attr("style",o),n&&"handDrawn"!==e.look&&u.selectAll("path").attr("style",n),kS(e,u),e.intersect=function(t){return y.info("filledCircle intersect",e,{radius:7,point:t}),eM.circle(e,7,t)},a}async function SM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=a.width+(e.padding??0),l=s+a.height,h=s+a.height,c=[{x:0,y:-l},{x:h,y:-l},{x:h/2,y:0}],{cssStyles:u}=e,d=BT.svg(n),p=ox(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=_S(c),g=d.path(f,p),m=n.insert(()=>g,":first-child").attr("transform",`translate(${-l/2}, ${l/2})`);return u&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",u),i&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",i),e.width=s,e.height=l,kS(e,m),o.attr("transform",`translate(${-a.width/2-(a.x-(a.left??0))}, ${-l/2+(e.padding??0)/2+(a.y-(a.top??0))})`),e.intersect=function(t){return y.info("Triangle intersect",e,c,t),eM.polygon(e,c,t)},n}function TM(t,e,{dir:r,config:{state:i,themeVariables:n}}){let{nodeStyles:a}=ax(e);e.label="";let o=t.insert("g").attr("class",wS(e)).attr("id",e.domId??e.id),{cssStyles:s}=e,l=Math.max(70,e?.width??0),h=Math.max(10,e?.height??0);"LR"===r&&(l=Math.max(10,e?.width??0),h=Math.max(70,e?.height??0));let c=-1*l/2,u=-1*h/2,d=BT.svg(o),p=ox(e,{stroke:n.lineColor,fill:n.lineColor});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=d.rectangle(c,u,l,h,p),g=o.insert(()=>f,":first-child");s&&"handDrawn"!==e.look&&g.selectAll("path").attr("style",s),a&&"handDrawn"!==e.look&&g.selectAll("path").attr("style",a),kS(e,g);let y=i?.padding??0;return e.width&&e.height&&(e.width+=y/2||0,e.height+=y/2||0),e.intersect=function(t){return eM.rect(e,t)},o}async function MM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await bS(t,e,wS(e)),o=Math.max(80,a.width+2*(e.padding??0),e?.width??0),s=Math.max(50,a.height+2*(e.padding??0),e?.height??0),l=s/2,{cssStyles:h}=e,c=BT.svg(n),u=ox(e,{});"handDrawn"!==e.look&&(u.roughness=0,u.fillStyle="solid");let d=[{x:-o/2,y:-s/2},{x:o/2-l,y:-s/2},...SS(-o/2+l,0,l,50,90,270),{x:o/2-l,y:s/2},{x:-o/2,y:s/2}],p=_S(d),f=c.path(p,u),g=n.insert(()=>f,":first-child");return g.attr("class","basic label-container"),h&&"handDrawn"!==e.look&&g.selectChildren("path").attr("style",h),i&&"handDrawn"!==e.look&&g.selectChildren("path").attr("style",i),kS(e,g),e.intersect=function(t){return y.info("Pill intersect",e,{radius:l,point:t}),eM.polygon(e,d,t)},n}s(kM,"cylinder"),s(wM,"dividedRectangle"),s(_M,"doublecircle"),s(vM,"filledCircle"),s(SM,"flippedTriangle"),s(TM,"forkJoin"),s(MM,"halfRoundedRectangle");var BM=s((t,e,r,i,n)=>[`M${t+n},${e}`,`L${t+r-n},${e}`,`L${t+r},${e-i/2}`,`L${t+r-n},${e-i}`,`L${t+n},${e-i}`,`L${t},${e-i/2}`,"Z"].join(" "),"createHexagonPathD");async function AM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await bS(t,e,wS(e)),s=o.height+e.padding,l=s/4,h=o.width+2*l+e.padding,c=[{x:l,y:0},{x:h-l,y:0},{x:h,y:-s/2},{x:h-l,y:-s},{x:l,y:-s},{x:0,y:-s/2}],{cssStyles:u}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=BM(0,0,h,s,l),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-h/2}, ${s/2})`),u&&n.attr("style",u)}else n=aM(a,h,s,c);return i&&n.attr("style",i),e.width=h,e.height=s,kS(e,n),e.intersect=function(t){return eM.polygon(e,c,t)},a}async function FM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.label="",e.labelStyle=r;let{shapeSvg:n}=await bS(t,e,wS(e)),a=Math.max(30,e?.width??0),o=Math.max(30,e?.height??0),{cssStyles:s}=e,l=BT.svg(n),h=ox(e,{});"handDrawn"!==e.look&&(h.roughness=0,h.fillStyle="solid");let c=[{x:0,y:0},{x:a,y:0},{x:0,y:o},{x:a,y:o}],u=_S(c),d=l.path(u,h),p=n.insert(()=>d,":first-child");return p.attr("class","basic label-container"),s&&"handDrawn"!==e.look&&p.selectChildren("path").attr("style",s),i&&"handDrawn"!==e.look&&p.selectChildren("path").attr("style",i),p.attr("transform",`translate(${-a/2}, ${-o/2})`),kS(e,p),e.intersect=function(t){return y.info("Pill intersect",e,{points:c}),eM.polygon(e,c,t)},n}async function LM(t,e,{config:{themeVariables:r,flowchart:i}}){let{labelStyles:n}=ax(e);e.labelStyle=n;let a=e.assetHeight??48,o=e.assetWidth??48,s=Math.max(a,o),l=i?.wrappingWidth;e.width=Math.max(s,l??0);let{shapeSvg:h,bbox:c,label:u}=await bS(t,e,"icon-shape default"),d="t"===e.pos,p=s,f=s,{nodeBorder:g}=r,{stylesMap:m}=rx(e),x=-f/2,b=-p/2,C=e.label?8:0,k=BT.svg(h),w=ox(e,{stroke:"none",fill:"none"});"handDrawn"!==e.look&&(w.roughness=0,w.fillStyle="solid");let _=k.rectangle(x,b,f,p,w),v=Math.max(f,c.width),S=p+c.height+C,T=k.rectangle(-v/2,-S/2,v,S,{...w,fill:"transparent",stroke:"none"}),M=h.insert(()=>_,":first-child"),B=h.insert(()=>T);if(e.icon){let t=h.append("g");t.html(`<g>${await z_(e.icon,{height:s,width:s,fallbackPrefix:""})}</g>`);let r=t.node().getBBox(),i=r.width,n=r.height,a=r.x,o=r.y;t.attr("transform",`translate(${-i/2-a},${d?c.height/2+C/2-n/2-o:-c.height/2-C/2-n/2-o})`),t.attr("style",`color: ${m.get("stroke")??g};`)}return u.attr("transform",`translate(${-c.width/2-(c.x-(c.left??0))},${d?-S/2:S/2-c.height})`),M.attr("transform",`translate(0,${d?c.height/2+C/2:-c.height/2-C/2})`),kS(e,B),e.intersect=function(t){if(y.info("iconSquare intersect",e,t),!e.label)return eM.rect(e,t);let r=e.x??0,i=e.y??0,n=e.height??0,a=[];return a=d?[{x:r-c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2+c.height+C},{x:r+f/2,y:i-n/2+c.height+C},{x:r+f/2,y:i+n/2},{x:r-f/2,y:i+n/2},{x:r-f/2,y:i-n/2+c.height+C},{x:r-c.width/2,y:i-n/2+c.height+C}]:[{x:r-f/2,y:i-n/2},{x:r+f/2,y:i-n/2},{x:r+f/2,y:i-n/2+p},{x:r+c.width/2,y:i-n/2+p},{x:r+c.width/2/2,y:i+n/2},{x:r-c.width/2,y:i+n/2},{x:r-c.width/2,y:i-n/2+p},{x:r-f/2,y:i-n/2+p}],eM.polygon(e,a,t)},h}async function $M(t,e,{config:{themeVariables:r,flowchart:i}}){let{labelStyles:n}=ax(e);e.labelStyle=n;let a=e.assetHeight??48,o=e.assetWidth??48,s=Math.max(a,o),l=i?.wrappingWidth;e.width=Math.max(s,l??0);let{shapeSvg:h,bbox:c,label:u}=await bS(t,e,"icon-shape default"),d=e.label?8:0,p="t"===e.pos,{nodeBorder:f,mainBkg:g}=r,{stylesMap:m}=rx(e),x=BT.svg(h),b=ox(e,{});"handDrawn"!==e.look&&(b.roughness=0,b.fillStyle="solid");let C=m.get("fill");b.stroke=C??g;let k=h.append("g");e.icon&&k.html(`<g>${await z_(e.icon,{height:s,width:s,fallbackPrefix:""})}</g>`);let w=k.node().getBBox(),_=w.width,v=w.height,S=w.x,T=w.y,M=Math.max(_,v)*Math.SQRT2+40,B=x.circle(0,0,M,b),A=Math.max(M,c.width),F=M+c.height+d,L=x.rectangle(-A/2,-F/2,A,F,{...b,fill:"transparent",stroke:"none"}),$=h.insert(()=>B,":first-child"),E=h.insert(()=>L);return k.attr("transform",`translate(${-_/2-S},${p?c.height/2+d/2-v/2-T:-c.height/2-d/2-v/2-T})`),k.attr("style",`color: ${m.get("stroke")??f};`),u.attr("transform",`translate(${-c.width/2-(c.x-(c.left??0))},${p?-F/2:F/2-c.height})`),$.attr("transform",`translate(0,${p?c.height/2+d/2:-c.height/2-d/2})`),kS(e,E),e.intersect=function(t){return y.info("iconSquare intersect",e,t),eM.rect(e,t)},h}async function EM(t,e,{config:{themeVariables:r,flowchart:i}}){let{labelStyles:n}=ax(e);e.labelStyle=n;let a=e.assetHeight??48,o=e.assetWidth??48,s=Math.max(a,o),l=i?.wrappingWidth;e.width=Math.max(s,l??0);let{shapeSvg:h,bbox:c,halfPadding:u,label:d}=await bS(t,e,"icon-shape default"),p="t"===e.pos,f=s+2*u,g=s+2*u,{nodeBorder:m,mainBkg:x}=r,{stylesMap:b}=rx(e),C=-g/2,k=-f/2,w=e.label?8:0,_=BT.svg(h),v=ox(e,{});"handDrawn"!==e.look&&(v.roughness=0,v.fillStyle="solid");let S=b.get("fill");v.stroke=S??x;let T=_.path(OT(C,k,g,f,5),v),M=Math.max(g,c.width),B=f+c.height+w,A=_.rectangle(-M/2,-B/2,M,B,{...v,fill:"transparent",stroke:"none"}),F=h.insert(()=>T,":first-child").attr("class","icon-shape2"),L=h.insert(()=>A);if(e.icon){let t=h.append("g");t.html(`<g>${await z_(e.icon,{height:s,width:s,fallbackPrefix:""})}</g>`);let r=t.node().getBBox(),i=r.width,n=r.height,a=r.x,o=r.y;t.attr("transform",`translate(${-i/2-a},${p?c.height/2+w/2-n/2-o:-c.height/2-w/2-n/2-o})`),t.attr("style",`color: ${b.get("stroke")??m};`)}return d.attr("transform",`translate(${-c.width/2-(c.x-(c.left??0))},${p?-B/2:B/2-c.height})`),F.attr("transform",`translate(0,${p?c.height/2+w/2:-c.height/2-w/2})`),kS(e,L),e.intersect=function(t){if(y.info("iconSquare intersect",e,t),!e.label)return eM.rect(e,t);let r=e.x??0,i=e.y??0,n=e.height??0,a=[];return a=p?[{x:r-c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2+c.height+w},{x:r+g/2,y:i-n/2+c.height+w},{x:r+g/2,y:i+n/2},{x:r-g/2,y:i+n/2},{x:r-g/2,y:i-n/2+c.height+w},{x:r-c.width/2,y:i-n/2+c.height+w}]:[{x:r-g/2,y:i-n/2},{x:r+g/2,y:i-n/2},{x:r+g/2,y:i-n/2+f},{x:r+c.width/2,y:i-n/2+f},{x:r+c.width/2/2,y:i+n/2},{x:r-c.width/2,y:i+n/2},{x:r-c.width/2,y:i-n/2+f},{x:r-g/2,y:i-n/2+f}],eM.polygon(e,a,t)},h}async function DM(t,e,{config:{themeVariables:r,flowchart:i}}){let{labelStyles:n}=ax(e);e.labelStyle=n;let a=e.assetHeight??48,o=e.assetWidth??48,s=Math.max(a,o),l=i?.wrappingWidth;e.width=Math.max(s,l??0);let{shapeSvg:h,bbox:c,halfPadding:u,label:d}=await bS(t,e,"icon-shape default"),p="t"===e.pos,f=s+2*u,g=s+2*u,{nodeBorder:m,mainBkg:x}=r,{stylesMap:b}=rx(e),C=-g/2,k=-f/2,w=e.label?8:0,_=BT.svg(h),v=ox(e,{});"handDrawn"!==e.look&&(v.roughness=0,v.fillStyle="solid");let S=b.get("fill");v.stroke=S??x;let T=_.path(OT(C,k,g,f,.1),v),M=Math.max(g,c.width),B=f+c.height+w,A=_.rectangle(-M/2,-B/2,M,B,{...v,fill:"transparent",stroke:"none"}),F=h.insert(()=>T,":first-child"),L=h.insert(()=>A);if(e.icon){let t=h.append("g");t.html(`<g>${await z_(e.icon,{height:s,width:s,fallbackPrefix:""})}</g>`);let r=t.node().getBBox(),i=r.width,n=r.height,a=r.x,o=r.y;t.attr("transform",`translate(${-i/2-a},${p?c.height/2+w/2-n/2-o:-c.height/2-w/2-n/2-o})`),t.attr("style",`color: ${b.get("stroke")??m};`)}return d.attr("transform",`translate(${-c.width/2-(c.x-(c.left??0))},${p?-B/2:B/2-c.height})`),F.attr("transform",`translate(0,${p?c.height/2+w/2:-c.height/2-w/2})`),kS(e,L),e.intersect=function(t){if(y.info("iconSquare intersect",e,t),!e.label)return eM.rect(e,t);let r=e.x??0,i=e.y??0,n=e.height??0,a=[];return a=p?[{x:r-c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2},{x:r+c.width/2,y:i-n/2+c.height+w},{x:r+g/2,y:i-n/2+c.height+w},{x:r+g/2,y:i+n/2},{x:r-g/2,y:i+n/2},{x:r-g/2,y:i-n/2+c.height+w},{x:r-c.width/2,y:i-n/2+c.height+w}]:[{x:r-g/2,y:i-n/2},{x:r+g/2,y:i-n/2},{x:r+g/2,y:i-n/2+f},{x:r+c.width/2,y:i-n/2+f},{x:r+c.width/2/2,y:i+n/2},{x:r-c.width/2,y:i+n/2},{x:r-c.width/2,y:i-n/2+f},{x:r-g/2,y:i-n/2+f}],eM.polygon(e,a,t)},h}async function OM(t,e,{config:{flowchart:r}}){let i=new Image;i.src=e?.img??"",await i.decode();let n=Number(i.naturalWidth.toString().replace("px","")),a=Number(i.naturalHeight.toString().replace("px",""));e.imageAspectRatio=n/a;let{labelStyles:o}=ax(e);e.labelStyle=o;let s=r?.wrappingWidth;e.defaultWidth=r?.wrappingWidth;let l=Math.max(e.label?s??0:0,e?.assetWidth??n),h="on"===e.constraint&&e?.assetHeight?e.assetHeight*e.imageAspectRatio:l,c="on"===e.constraint?h/e.imageAspectRatio:e?.assetHeight??a;e.width=Math.max(h,s??0);let{shapeSvg:u,bbox:d,label:p}=await bS(t,e,"image-shape default"),f="t"===e.pos,g=-h/2,m=-c/2,x=e.label?8:0,b=BT.svg(u),C=ox(e,{});"handDrawn"!==e.look&&(C.roughness=0,C.fillStyle="solid");let k=b.rectangle(g,m,h,c,C),w=Math.max(h,d.width),_=c+d.height+x,v=b.rectangle(-w/2,-_/2,w,_,{...C,fill:"none",stroke:"none"}),S=u.insert(()=>k,":first-child"),T=u.insert(()=>v);if(e.img){let t=u.append("image");t.attr("href",e.img),t.attr("width",h),t.attr("height",c),t.attr("preserveAspectRatio","none"),t.attr("transform",`translate(${-h/2},${f?_/2-c:-_/2})`)}return p.attr("transform",`translate(${-d.width/2-(d.x-(d.left??0))},${f?-c/2-d.height/2-x/2:c/2-d.height/2+x/2})`),S.attr("transform",`translate(0,${f?d.height/2+x/2:-d.height/2-x/2})`),kS(e,T),e.intersect=function(t){if(y.info("iconSquare intersect",e,t),!e.label)return eM.rect(e,t);let r=e.x??0,i=e.y??0,n=e.height??0,a=[];return a=f?[{x:r-d.width/2,y:i-n/2},{x:r+d.width/2,y:i-n/2},{x:r+d.width/2,y:i-n/2+d.height+x},{x:r+h/2,y:i-n/2+d.height+x},{x:r+h/2,y:i+n/2},{x:r-h/2,y:i+n/2},{x:r-h/2,y:i-n/2+d.height+x},{x:r-d.width/2,y:i-n/2+d.height+x}]:[{x:r-h/2,y:i-n/2},{x:r+h/2,y:i-n/2},{x:r+h/2,y:i-n/2+c},{x:r+d.width/2,y:i-n/2+c},{x:r+d.width/2/2,y:i+n/2},{x:r-d.width/2,y:i+n/2},{x:r-d.width/2,y:i-n/2+c},{x:r-h/2,y:i-n/2+c}],eM.polygon(e,a,t)},u}async function IM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await bS(t,e,wS(e)),s=Math.max(o.width+2*(e.padding??0),e?.width??0),l=Math.max(o.height+2*(e.padding??0),e?.height??0),h=[{x:0,y:0},{x:s,y:0},{x:s+3*l/6,y:-l},{x:-3*l/6,y:-l}],{cssStyles:c}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=_S(h),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${l/2})`),c&&n.attr("style",c)}else n=aM(a,s,l,h);return i&&n.attr("style",i),e.width=s,e.height=l,kS(e,n),e.intersect=function(t){return eM.polygon(e,h,t)},a}async function NM(t,e,r){let{labelStyles:i,nodeStyles:n}=ax(e);e.labelStyle=i;let a,{shapeSvg:o,bbox:s}=await bS(t,e,wS(e)),l=Math.max(s.width+2*r.labelPaddingX,e?.width||0),h=Math.max(s.height+2*r.labelPaddingY,e?.height||0),c=-l/2,u=-h/2,{rx:d,ry:p}=e,{cssStyles:f}=e;if(r?.rx&&r.ry&&(d=r.rx,p=r.ry),"handDrawn"===e.look){let t=BT.svg(o),r=ox(e,{}),i=d||p?t.path(OT(c,u,l,h,d||0),r):t.rectangle(c,u,l,h,r);a=o.insert(()=>i,":first-child"),a.attr("class","basic label-container").attr("style",n_(f))}else a=o.insert("rect",":first-child"),a.attr("class","basic label-container").attr("style",n).attr("rx",n_(d)).attr("ry",n_(p)).attr("x",c).attr("y",u).attr("width",l).attr("height",h);return kS(e,a),e.intersect=function(t){return eM.rect(e,t)},o}async function RM(t,e){let{shapeSvg:r,bbox:i,label:n}=await bS(t,e,"label"),a=r.insert("rect",":first-child");return a.attr("width",.1).attr("height",.1),r.attr("class","label edgeLabel"),n.attr("transform",`translate(${-i.width/2-(i.x-(i.left??0))}, ${-i.height/2-(i.y-(i.top??0))})`),kS(e,a),e.intersect=function(t){return eM.rect(e,t)},r}async function PM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await bS(t,e,wS(e)),s=Math.max(o.width+(e.padding??0),e?.width??0),l=Math.max(o.height+(e.padding??0),e?.height??0),h=[{x:0,y:0},{x:s+3*l/6,y:0},{x:s,y:-l},{x:-3*l/6,y:-l}],{cssStyles:c}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=_S(h),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${l/2})`),c&&n.attr("style",c)}else n=aM(a,s,l,h);return i&&n.attr("style",i),e.width=s,e.height=l,kS(e,n),e.intersect=function(t){return eM.polygon(e,h,t)},a}async function zM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await bS(t,e,wS(e)),s=Math.max(o.width+(e.padding??0),e?.width??0),l=Math.max(o.height+(e.padding??0),e?.height??0),h=[{x:-3*l/6,y:0},{x:s,y:0},{x:s+3*l/6,y:-l},{x:0,y:-l}],{cssStyles:c}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=_S(h),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${l/2})`),c&&n.attr("style",c)}else n=aM(a,s,l,h);return i&&n.attr("style",i),e.width=s,e.height=l,kS(e,n),e.intersect=function(t){return eM.polygon(e,h,t)},a}function qM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.label="",e.labelStyle=r;let n=t.insert("g").attr("class",wS(e)).attr("id",e.domId??e.id),{cssStyles:a}=e,o=Math.max(35,e?.width??0),s=Math.max(35,e?.height??0),l=[{x:o,y:0},{x:0,y:s+3.5},{x:o-14,y:s+3.5},{x:0,y:2*s},{x:o,y:s-3.5},{x:14,y:s-3.5}],h=BT.svg(n),c=ox(e,{});"handDrawn"!==e.look&&(c.roughness=0,c.fillStyle="solid");let u=_S(l),d=h.path(u,c),p=n.insert(()=>d,":first-child");return a&&"handDrawn"!==e.look&&p.selectAll("path").attr("style",a),i&&"handDrawn"!==e.look&&p.selectAll("path").attr("style",i),p.attr("transform",`translate(-${o/2},${-s})`),kS(e,p),e.intersect=function(t){return y.info("lightningBolt intersect",e,t),eM.polygon(e,l,t)},n}s(AM,"hexagon"),s(FM,"hourglass"),s(LM,"icon"),s($M,"iconCircle"),s(EM,"iconRounded"),s(DM,"iconSquare"),s(OM,"imageSquare"),s(IM,"inv_trapezoid"),s(NM,"drawRect"),s(RM,"labelRect"),s(PM,"lean_left"),s(zM,"lean_right"),s(qM,"lightningBolt");var jM=s((t,e,r,i,n,a,o)=>[`M${t},${e+a}`,`a${n},${a} 0,0,0 ${r},0`,`a${n},${a} 0,0,0 ${-r},0`,`l0,${i}`,`a${n},${a} 0,0,0 ${r},0`,"l0,"+-i,`M${t},${e+a+o}`,`a${n},${a} 0,0,0 ${r},0`].join(" "),"createCylinderPathD"),WM=s((t,e,r,i,n,a,o)=>[`M${t},${e+a}`,`M${t+r},${e+a}`,`a${n},${a} 0,0,0 ${-r},0`,`l0,${i}`,`a${n},${a} 0,0,0 ${r},0`,"l0,"+-i,`M${t},${e+a+o}`,`a${n},${a} 0,0,0 ${r},0`].join(" "),"createOuterCylinderPathD"),HM=s((t,e,r,i,n,a)=>[`M${t-r/2},${-i/2}`,`a${n},${a} 0,0,0 ${r},0`].join(" "),"createInnerCylinderPathD");async function UM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,label:s}=await bS(t,e,wS(e)),l=Math.max(o.width+(e.padding??0),e.width??0),h=l/2,c=h/(2.5+l/50),u=Math.max(o.height+c+(e.padding??0),e.height??0),d=.1*u,{cssStyles:p}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=WM(0,0,l,u,h,c,d),i=HM(0,c,l,u,h,c),o=ox(e,{}),s=t.path(r,o),f=t.path(i,o);a.insert(()=>f,":first-child").attr("class","line"),n=a.insert(()=>s,":first-child"),n.attr("class","basic label-container"),p&&n.attr("style",p)}else{let t=jM(0,0,l,u,h,c,d);n=a.insert("path",":first-child").attr("d",t).attr("class","basic label-container").attr("style",n_(p)).attr("style",i)}return n.attr("label-offset-y",c),n.attr("transform",`translate(${-l/2}, ${-(u/2+c)})`),kS(e,n),s.attr("transform",`translate(${-o.width/2-(o.x-(o.left??0))}, ${-o.height/2+c-(o.y-(o.top??0))})`),e.intersect=function(t){let r=eM.rect(e,t),i=r.x-(e.x??0);if(0!=h&&(Math.abs(i)<(e.width??0)/2||Math.abs(i)==(e.width??0)/2&&Math.abs(r.y-(e.y??0))>(e.height??0)/2-c)){let n=c*c*(1-i*i/(h*h));n>0&&(n=Math.sqrt(n)),n=c-n,t.y-(e.y??0)>0&&(n=-n),r.y+=n}return r},a}async function YM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=l/4,c=l+h,{cssStyles:u}=e,d=BT.svg(n),p=ox(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=[{x:-s/2-s/2*.1,y:-c/2},{x:-s/2-s/2*.1,y:c/2},...vS(-s/2-s/2*.1,c/2,s/2+s/2*.1,c/2,h,.8),{x:s/2+s/2*.1,y:-c/2},{x:-s/2-s/2*.1,y:-c/2},{x:-s/2,y:-c/2},{x:-s/2,y:c/2*1.1},{x:-s/2,y:-c/2}],g=d.polygon(f.map(t=>[t.x,t.y]),p),y=n.insert(()=>g,":first-child");return y.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",i),y.attr("transform",`translate(0,${-h/2})`),o.attr("transform",`translate(${-s/2+(e.padding??0)+s/2*.1/2-(a.x-(a.left??0))},${-l/2+(e.padding??0)-h/2-(a.y-(a.top??0))})`),kS(e,y),e.intersect=function(t){return eM.polygon(e,f,t)},n}async function VM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=-s/2,c=-l/2,{cssStyles:u}=e,d=BT.svg(n),p=ox(e,{}),f=[{x:h-5,y:c+5},{x:h-5,y:c+l+5},{x:h+s-5,y:c+l+5},{x:h+s-5,y:c+l},{x:h+s,y:c+l},{x:h+s,y:c+l-5},{x:h+s+5,y:c+l-5},{x:h+s+5,y:c-5},{x:h+5,y:c-5},{x:h+5,y:c},{x:h,y:c},{x:h,y:c+5}],g=[{x:h,y:c+5},{x:h+s-5,y:c+5},{x:h+s-5,y:c+l},{x:h+s,y:c+l},{x:h+s,y:c},{x:h,y:c}];"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let y=_S(f),m=d.path(y,p),x=_S(g),b=d.path(x,{...p,fill:"none"}),C=n.insert(()=>b,":first-child");return C.insert(()=>m,":first-child"),C.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&C.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&C.selectAll("path").attr("style",i),o.attr("transform",`translate(${-a.width/2-5-(a.x-(a.left??0))}, ${-a.height/2+5-(a.y-(a.top??0))})`),kS(e,C),e.intersect=function(t){return eM.polygon(e,f,t)},n}async function GM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=l/4,c=l+h,u=-s/2,d=-c/2,{cssStyles:p}=e,f=vS(u-5,d+c+5,u+s-5,d+c+5,h,.8),g=f?.[f.length-1],y=[{x:u-5,y:d+5},{x:u-5,y:d+c+5},...f,{x:u+s-5,y:g.y-5},{x:u+s,y:g.y-5},{x:u+s,y:g.y-10},{x:u+s+5,y:g.y-10},{x:u+s+5,y:d-5},{x:u+5,y:d-5},{x:u+5,y:d},{x:u,y:d},{x:u,y:d+5}],m=[{x:u,y:d+5},{x:u+s-5,y:d+5},{x:u+s-5,y:g.y-5},{x:u+s,y:g.y-5},{x:u+s,y:d},{x:u,y:d}],x=BT.svg(n),b=ox(e,{});"handDrawn"!==e.look&&(b.roughness=0,b.fillStyle="solid");let C=_S(y),k=x.path(C,b),w=_S(m),_=x.path(w,b),v=n.insert(()=>k,":first-child");return v.insert(()=>_),v.attr("class","basic label-container"),p&&"handDrawn"!==e.look&&v.selectAll("path").attr("style",p),i&&"handDrawn"!==e.look&&v.selectAll("path").attr("style",i),v.attr("transform",`translate(0,${-h/2})`),o.attr("transform",`translate(${-a.width/2-5-(a.x-(a.left??0))}, ${-a.height/2+5-h/2-(a.y-(a.top??0))})`),kS(e,v),e.intersect=function(t){return eM.polygon(e,y,t)},n}async function XM(t,e,{config:{themeVariables:r}}){let{labelStyles:i,nodeStyles:n}=ax(e);e.labelStyle=i,e.useHtmlLabels||!1!==re().flowchart?.htmlLabels||(e.centerLabel=!0);let{shapeSvg:a,bbox:o,label:s}=await bS(t,e,wS(e)),l=Math.max(o.width+2*(e.padding??0),e?.width??0),h=Math.max(o.height+2*(e.padding??0),e?.height??0),c=-l/2,u=-h/2,{cssStyles:d}=e,p=BT.svg(a),f=ox(e,{fill:r.noteBkgColor,stroke:r.noteBorderColor});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=p.rectangle(c,u,l,h,f),y=a.insert(()=>g,":first-child");return y.attr("class","basic label-container"),d&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",d),n&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",n),s.attr("transform",`translate(${-o.width/2-(o.x-(o.left??0))}, ${-o.height/2-(o.y-(o.top??0))})`),kS(e,y),e.intersect=function(t){return eM.rect(e,t)},a}s(UM,"linedCylinder"),s(YM,"linedWaveEdgedRect"),s(VM,"multiRect"),s(GM,"multiWaveEdgedRectangle"),s(XM,"note");var ZM=s((t,e,r)=>[`M${t+r/2},${e}`,`L${t+r},${e-r/2}`,`L${t+r/2},${e-r}`,`L${t},${e-r/2}`,"Z"].join(" "),"createDecisionBoxPathD");async function QM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await bS(t,e,wS(e)),s=o.width+e.padding+(o.height+e.padding),l=[{x:s/2,y:0},{x:s,y:-s/2},{x:s/2,y:-s},{x:0,y:-s/2}],{cssStyles:h}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=ZM(0,0,s),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${s/2})`),h&&n.attr("style",h)}else n=aM(a,s,s,l);return i&&n.attr("style",i),kS(e,n),e.intersect=function(t){return y.debug("APA12 Intersect called SPLIT\npoint:",t,"\nnode:\n",e,"\nres:",eM.polygon(e,l,t)),eM.polygon(e,l,t)},a}async function KM(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=-Math.max(a.width+(e.padding??0),e?.width??0)/2,l=-Math.max(a.height+(e.padding??0),e?.height??0)/2,h=l/2,c=[{x:s+h,y:l},{x:s,y:0},{x:s+h,y:-l},{x:-s,y:-l},{x:-s,y:l}],{cssStyles:u}=e,d=BT.svg(n),p=ox(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=_S(c),g=d.path(f,p),y=n.insert(()=>g,":first-child");return y.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&y.selectAll("path").attr("style",i),y.attr("transform",`translate(${-h/2},0)`),o.attr("transform",`translate(${-h/2-a.width/2-(a.x-(a.left??0))}, ${-a.height/2-(a.y-(a.top??0))})`),kS(e,y),e.intersect=function(t){return eM.polygon(e,c,t)},n}async function JM(t,e){let r,{labelStyles:i,nodeStyles:n}=ax(e);e.labelStyle=i,r=e.cssClasses?"node "+e.cssClasses:"node default";let a=t.insert("g").attr("class",r).attr("id",e.domId||e.id),o=a.insert("g"),s=a.insert("g").attr("class","label").attr("style",n),l=e.description,h=e.label,c=s.node().appendChild(await DT(h,e.labelStyle,!0,!0)),u={width:0,height:0};if(Lr(di()?.flowchart?.htmlLabels)){let t=c.children[0],e=ro(c);u=t.getBoundingClientRect(),e.attr("width",u.width),e.attr("height",u.height)}y.info("Text 2",l);let d=l||[],p=c.getBBox(),f=s.node().appendChild(await DT(d.join?d.join("<br/>"):d,e.labelStyle,!0,!0)),g=f.children[0],m=ro(f);u=g.getBoundingClientRect(),m.attr("width",u.width),m.attr("height",u.height);let x=(e.padding||0)/2;ro(f).attr("transform","translate( "+(u.width>p.width?0:(p.width-u.width)/2)+", "+(p.height+x+5)+")"),ro(c).attr("transform","translate( "+(u.width<p.width?0:-(p.width-u.width)/2)+", 0)"),u=s.node().getBBox(),s.attr("transform","translate("+-u.width/2+", "+(-u.height/2-x+3)+")");let b,C,k=u.width+(e.padding||0),w=u.height+(e.padding||0),_=-u.width/2-x,v=-u.height/2-x;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=t.path(OT(_,v,k,w,e.rx||0),r),n=t.line(-u.width/2-x,-u.height/2-x+p.height+x,u.width/2+x,-u.height/2-x+p.height+x,r);C=a.insert(()=>(y.debug("Rough node insert CXC",i),n),":first-child"),b=a.insert(()=>(y.debug("Rough node insert CXC",i),i),":first-child")}else b=o.insert("rect",":first-child"),C=o.insert("line"),b.attr("class","outer title-state").attr("style",n).attr("x",-u.width/2-x).attr("y",-u.height/2-x).attr("width",u.width+(e.padding||0)).attr("height",u.height+(e.padding||0)),C.attr("class","divider").attr("x1",-u.width/2-x).attr("x2",u.width/2+x).attr("y1",-u.height/2-x+p.height+x).attr("y2",-u.height/2-x+p.height+x);return kS(e,b),e.intersect=function(t){return eM.rect(e,t)},a}async function tB(t,e){return NM(t,e,{rx:5,ry:5,labelPaddingX:1*(e?.padding||0),labelPaddingY:1*(e?.padding||0)})}async function eB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=e?.padding??0,l=Math.max(a.width+2*(e.padding??0),e?.width??0),h=Math.max(a.height+2*(e.padding??0),e?.height??0),c=-a.width/2-s,u=-a.height/2-s,{cssStyles:d}=e,p=BT.svg(n),f=ox(e,{});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=[{x:c,y:u},{x:c+l+8,y:u},{x:c+l+8,y:u+h},{x:c-8,y:u+h},{x:c-8,y:u},{x:c,y:u},{x:c,y:u+h}],y=p.polygon(g.map(t=>[t.x,t.y]),f),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container").attr("style",n_(d)),i&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",i),d&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",i),o.attr("transform",`translate(${-l/2+4+(e.padding??0)-(a.x-(a.left??0))},${-h/2+(e.padding??0)-(a.y-(a.top??0))})`),kS(e,m),e.intersect=function(t){return eM.rect(e,t)},n}async function rB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=-s/2,c=-l/2,{cssStyles:u}=e,d=BT.svg(n),p=ox(e,{});"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let f=[{x:h,y:c},{x:h,y:c+l},{x:h+s,y:c+l},{x:h+s,y:c-l/2}],g=_S(f),y=d.path(g,p),m=n.insert(()=>y,":first-child");return m.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",u),i&&"handDrawn"!==e.look&&m.selectChildren("path").attr("style",i),m.attr("transform",`translate(0, ${l/4})`),o.attr("transform",`translate(${-s/2+(e.padding??0)-(a.x-(a.left??0))}, ${-l/4+(e.padding??0)-(a.y-(a.top??0))})`),kS(e,m),e.intersect=function(t){return eM.polygon(e,f,t)},n}async function iB(t,e){return NM(t,e,{rx:0,ry:0,labelPaddingX:2*(e?.padding||0),labelPaddingY:1*(e?.padding||0)})}async function nB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await bS(t,e,wS(e)),s=o.height+e.padding,l=o.width+s/4+e.padding,{cssStyles:h}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=OT(-l/2,-s/2,l,s,s/2),o=t.path(i,r);n=a.insert(()=>o,":first-child"),n.attr("class","basic label-container").attr("style",n_(h))}else n=a.insert("rect",":first-child"),n.attr("class","basic label-container").attr("style",i).attr("rx",s/2).attr("ry",s/2).attr("x",-l/2).attr("y",-s/2).attr("width",l).attr("height",s);return kS(e,n),e.intersect=function(t){return eM.rect(e,t)},a}async function aB(t,e){return NM(t,e,{rx:5,ry:5})}function oB(t,e,{config:{themeVariables:r}}){let{labelStyles:i,nodeStyles:n}=ax(e);e.labelStyle=i;let{cssStyles:a}=e,{lineColor:o,stateBorder:s,nodeBorder:l}=r,h=t.insert("g").attr("class","node default").attr("id",e.domId||e.id),c=BT.svg(h),u=ox(e,{});"handDrawn"!==e.look&&(u.roughness=0,u.fillStyle="solid");let d=c.circle(0,0,14,{...u,stroke:o,strokeWidth:2}),p=s??l,f=c.circle(0,0,5,{...u,fill:p,stroke:p,strokeWidth:2,fillStyle:"solid"}),g=h.insert(()=>d,":first-child");return g.insert(()=>f),a&&g.selectAll("path").attr("style",a),n&&g.selectAll("path").attr("style",n),kS(e,g),e.intersect=function(t){return eM.circle(e,7,t)},h}function sB(t,e,{config:{themeVariables:r}}){let i,{lineColor:n}=r,a=t.insert("g").attr("class","node default").attr("id",e.domId||e.id);if("handDrawn"===e.look){let t=BT.svg(a).circle(0,0,14,ex(n));i=a.insert(()=>t),i.attr("class","state-start").attr("r",7).attr("width",14).attr("height",14)}else i=a.insert("circle",":first-child"),i.attr("class","state-start").attr("r",7).attr("width",14).attr("height",14);return kS(e,i),e.intersect=function(t){return eM.circle(e,7,t)},a}async function lB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await bS(t,e,wS(e)),o=(e?.padding||0)/2,s=a.width+e.padding,l=a.height+e.padding,h=-a.width/2-o,c=-a.height/2-o,u=[{x:0,y:0},{x:s,y:0},{x:s,y:-l},{x:0,y:-l},{x:0,y:0},{x:-8,y:0},{x:s+8,y:0},{x:s+8,y:-l},{x:-8,y:-l},{x:-8,y:0}];if("handDrawn"===e.look){let t=BT.svg(n),r=ox(e,{}),i=t.rectangle(h-8,c,s+16,l,r),a=t.line(h,c,h,c+l,r),o=t.line(h+s,c,h+s,c+l,r);n.insert(()=>a,":first-child"),n.insert(()=>o,":first-child");let u=n.insert(()=>i,":first-child"),{cssStyles:d}=e;u.attr("class","basic label-container").attr("style",n_(d)),kS(e,u)}else{let t=aM(n,s,l,u);i&&t.attr("style",i),kS(e,t)}return e.intersect=function(t){return eM.polygon(e,u,t)},n}async function hB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await bS(t,e,wS(e)),o=Math.max(a.width+2*(e.padding??0),e?.width??0),s=Math.max(a.height+2*(e.padding??0),e?.height??0),l=-o/2,h=-s/2,c=.2*s,u=.2*s,{cssStyles:d}=e,p=BT.svg(n),f=ox(e,{}),g=[{x:l-c/2,y:h},{x:l+o+c/2,y:h},{x:l+o+c/2,y:h+s},{x:l-c/2,y:h+s}],y=[{x:l+o-c/2,y:h+s},{x:l+o+c/2,y:h+s},{x:l+o+c/2,y:h+s-u}];"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let m=_S(g),x=p.path(m,f),b=_S(y),C=p.path(b,{...f,fillStyle:"solid"}),k=n.insert(()=>C,":first-child");return k.insert(()=>x,":first-child"),k.attr("class","basic label-container"),d&&"handDrawn"!==e.look&&k.selectAll("path").attr("style",d),i&&"handDrawn"!==e.look&&k.selectAll("path").attr("style",i),kS(e,k),e.intersect=function(t){return eM.polygon(e,g,t)},n}async function cB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=l/4,c=.2*s,u=.2*l,d=l+h,{cssStyles:p}=e,f=BT.svg(n),g=ox(e,{});"handDrawn"!==e.look&&(g.roughness=0,g.fillStyle="solid");let y=[{x:-s/2-s/2*.1,y:d/2},...vS(-s/2-s/2*.1,d/2,s/2+s/2*.1,d/2,h,.8),{x:s/2+s/2*.1,y:-d/2},{x:-s/2-s/2*.1,y:-d/2}],m=-s/2+s/2*.1,x=-d/2-.4*u,b=[{x:m+s-c,y:1.4*(x+l)},{x:m+s,y:x+l-u},{x:m+s,y:.9*(x+l)},...vS(m+s,1.3*(x+l),m+s-c,1.5*(x+l),.03*-l,.5)],C=_S(y),k=f.path(C,g),w=_S(b),_=f.path(w,{...g,fillStyle:"solid"}),v=n.insert(()=>_,":first-child");return v.insert(()=>k,":first-child"),v.attr("class","basic label-container"),p&&"handDrawn"!==e.look&&v.selectAll("path").attr("style",p),i&&"handDrawn"!==e.look&&v.selectAll("path").attr("style",i),v.attr("transform",`translate(0,${-h/2})`),o.attr("transform",`translate(${-s/2+(e.padding??0)-(a.x-(a.left??0))},${-l/2+(e.padding??0)-h/2-(a.y-(a.top??0))})`),kS(e,v),e.intersect=function(t){return eM.polygon(e,y,t)},n}async function uB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await bS(t,e,wS(e)),o=Math.max(a.width+e.padding,e?.width||0),s=Math.max(a.height+e.padding,e?.height||0),l=-o/2,h=-s/2,c=n.insert("rect",":first-child");return c.attr("class","text").attr("style",i).attr("rx",0).attr("ry",0).attr("x",l).attr("y",h).attr("width",o).attr("height",s),kS(e,c),e.intersect=function(t){return eM.rect(e,t)},n}s(QM,"question"),s(KM,"rect_left_inv_arrow"),s(JM,"rectWithTitle"),s(tB,"roundedRect"),s(eB,"shadedProcess"),s(rB,"slopedRect"),s(iB,"squareRect"),s(nB,"stadium"),s(aB,"state"),s(oB,"stateEnd"),s(sB,"stateStart"),s(lB,"subroutine"),s(hB,"taggedRect"),s(cB,"taggedWaveEdgedRectangle"),s(uB,"text");var dB=s((t,e,r,i,n,a)=>`M${t},${e}\n    a${n},${a} 0,0,1 0,${-i}\n    l${r},0\n    a${n},${a} 0,0,1 0,${i}\n    M${r},${-i}\n    a${n},${a} 0,0,0 0,${i}\n    l${-r},0`,"createCylinderPathD"),pB=s((t,e,r,i,n,a)=>[`M${t},${e}`,`M${t+r},${e}`,`a${n},${a} 0,0,0 0,${-i}`,`l${-r},0`,`a${n},${a} 0,0,0 0,${i}`,`l${r},0`].join(" "),"createOuterCylinderPathD"),fB=s((t,e,r,i,n,a)=>[`M${t+r/2},${-i/2}`,`a${n},${a} 0,0,0 0,${i}`].join(" "),"createInnerCylinderPathD");async function gB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o,label:s,halfPadding:l}=await bS(t,e,wS(e)),h="neo"===e.look?2*l:l,c=o.height+h,u=c/2,d=u/(2.5+c/50),p=o.width+d+h,{cssStyles:f}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=pB(0,0,p,c,d,u),i=fB(0,0,p,c,d,u),o=t.path(r,ox(e,{})),s=t.path(i,ox(e,{fill:"none"}));n=a.insert(()=>s,":first-child"),n=a.insert(()=>o,":first-child"),n.attr("class","basic label-container"),f&&n.attr("style",f)}else{let t=dB(0,0,p,c,d,u);n=a.insert("path",":first-child").attr("d",t).attr("class","basic label-container").attr("style",n_(f)).attr("style",i),n.attr("class","basic label-container"),f&&n.selectAll("path").attr("style",f),i&&n.selectAll("path").attr("style",i)}return n.attr("label-offset-x",d),n.attr("transform",`translate(${-p/2}, ${c/2} )`),s.attr("transform",`translate(${-o.width/2-d-(o.x-(o.left??0))}, ${-o.height/2-(o.y-(o.top??0))})`),kS(e,n),e.intersect=function(t){let r=eM.rect(e,t),i=r.y-(e.y??0);if(0!=u&&(Math.abs(i)<(e.height??0)/2||Math.abs(i)==(e.height??0)/2&&Math.abs(r.x-(e.x??0))>(e.width??0)/2-d)){let n=d*d*(1-i*i/(u*u));0!=n&&(n=Math.sqrt(Math.abs(n))),n=d-n,t.x-(e.x??0)>0&&(n=-n),r.x+=n}return r},a}async function yB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,{shapeSvg:a,bbox:o}=await bS(t,e,wS(e)),s=o.width+e.padding,l=o.height+e.padding,h=[{x:-3*l/6,y:0},{x:s+3*l/6,y:0},{x:s,y:-l},{x:0,y:-l}],{cssStyles:c}=e;if("handDrawn"===e.look){let t=BT.svg(a),r=ox(e,{}),i=_S(h),o=t.path(i,r);n=a.insert(()=>o,":first-child").attr("transform",`translate(${-s/2}, ${l/2})`),c&&n.attr("style",c)}else n=aM(a,s,l,h);return i&&n.attr("style",i),e.width=s,e.height=l,kS(e,n),e.intersect=function(t){return eM.polygon(e,h,t)},a}async function mB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await bS(t,e,wS(e)),o=Math.max(60,a.width+2*(e.padding??0),e?.width??0),s=Math.max(20,a.height+2*(e.padding??0),e?.height??0),{cssStyles:l}=e,h=BT.svg(n),c=ox(e,{});"handDrawn"!==e.look&&(c.roughness=0,c.fillStyle="solid");let u=[{x:-o/2*.8,y:-s/2},{x:o/2*.8,y:-s/2},{x:o/2,y:-s/2*.6},{x:o/2,y:s/2},{x:-o/2,y:s/2},{x:-o/2,y:-s/2*.6}],d=_S(u),p=h.path(d,c),f=n.insert(()=>p,":first-child");return f.attr("class","basic label-container"),l&&"handDrawn"!==e.look&&f.selectChildren("path").attr("style",l),i&&"handDrawn"!==e.look&&f.selectChildren("path").attr("style",i),kS(e,f),e.intersect=function(t){return eM.polygon(e,u,t)},n}async function xB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=Lr(di().flowchart?.htmlLabels),l=a.width+(e.padding??0),h=l+a.height,c=l+a.height,u=[{x:0,y:0},{x:c,y:0},{x:c/2,y:-h}],{cssStyles:d}=e,p=BT.svg(n),f=ox(e,{});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=_S(u),m=p.path(g,f),x=n.insert(()=>m,":first-child").attr("transform",`translate(${-h/2}, ${h/2})`);return d&&"handDrawn"!==e.look&&x.selectChildren("path").attr("style",d),i&&"handDrawn"!==e.look&&x.selectChildren("path").attr("style",i),e.width=l,e.height=h,kS(e,x),o.attr("transform",`translate(${-a.width/2-(a.x-(a.left??0))}, ${h/2-(a.height+(e.padding??0)/(s?2:1)-(a.y-(a.top??0)))})`),e.intersect=function(t){return y.info("Triangle intersect",e,u,t),eM.polygon(e,u,t)},n}async function bB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=l/8,c=l+h,{cssStyles:u}=e,d=70-s,p=d>0?d/2:0,f=BT.svg(n),g=ox(e,{});"handDrawn"!==e.look&&(g.roughness=0,g.fillStyle="solid");let y=[{x:-s/2-p,y:c/2},...vS(-s/2-p,c/2,s/2+p,c/2,h,.8),{x:s/2+p,y:-c/2},{x:-s/2-p,y:-c/2}],m=_S(y),x=f.path(m,g),b=n.insert(()=>x,":first-child");return b.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",i),b.attr("transform",`translate(0,${-h/2})`),o.attr("transform",`translate(${-s/2+(e.padding??0)-(a.x-(a.left??0))},${-l/2+(e.padding??0)-h-(a.y-(a.top??0))})`),kS(e,b),e.intersect=function(t){return eM.polygon(e,y,t)},n}async function CB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a}=await bS(t,e,wS(e)),o=Math.max(a.width+2*(e.padding??0),e?.width??0),s=Math.max(a.height+2*(e.padding??0),e?.height??0),l=o/s,h=o,c=s;h>c*l?c=h/l:h=c*l,h=Math.max(h,100),c=Math.max(c,50);let u=Math.min(.2*c,c/4),d=c+2*u,{cssStyles:p}=e,f=BT.svg(n),g=ox(e,{});"handDrawn"!==e.look&&(g.roughness=0,g.fillStyle="solid");let y=[{x:-h/2,y:d/2},...vS(-h/2,d/2,h/2,d/2,u,1),{x:h/2,y:-d/2},...vS(h/2,-d/2,-h/2,-d/2,u,-1)],m=_S(y),x=f.path(m,g),b=n.insert(()=>x,":first-child");return b.attr("class","basic label-container"),p&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",p),i&&"handDrawn"!==e.look&&b.selectAll("path").attr("style",i),kS(e,b),e.intersect=function(t){return eM.polygon(e,y,t)},n}async function kB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let{shapeSvg:n,bbox:a,label:o}=await bS(t,e,wS(e)),s=Math.max(a.width+2*(e.padding??0),e?.width??0),l=Math.max(a.height+2*(e.padding??0),e?.height??0),h=-s/2,c=-l/2,{cssStyles:u}=e,d=BT.svg(n),p=ox(e,{}),f=[{x:h-5,y:c-5},{x:h-5,y:c+l},{x:h+s,y:c+l},{x:h+s,y:c-5}],g=`M${h-5},${c-5} L${h+s},${c-5} L${h+s},${c+l} L${h-5},${c+l} L${h-5},${c-5}\n                M${h-5},${c} L${h+s},${c}\n                M${h},${c-5} L${h},${c+l}`;"handDrawn"!==e.look&&(p.roughness=0,p.fillStyle="solid");let y=d.path(g,p),m=n.insert(()=>y,":first-child");return m.attr("transform","translate(2.5, 2.5)"),m.attr("class","basic label-container"),u&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",u),i&&"handDrawn"!==e.look&&m.selectAll("path").attr("style",i),o.attr("transform",`translate(${-a.width/2+2.5-(a.x-(a.left??0))}, ${-a.height/2+2.5-(a.y-(a.top??0))})`),kS(e,m),e.intersect=function(t){return eM.polygon(e,f,t)},n}async function wB(t,e){let r=e;if(r.alias&&(e.label=r.alias),"handDrawn"===e.look){let{themeVariables:r}=re(),{background:i}=r,n={...e,id:e.id+"-background",look:"default",cssStyles:["stroke: none",`fill: ${i}`]};await wB(t,n)}let i=re();e.useHtmlLabels=i.htmlLabels;let n=i.er?.diagramPadding??10,a=i.er?.entityPadding??6,{cssStyles:o}=e,{labelStyles:s,nodeStyles:l}=ax(e);if(0===r.attributes.length&&e.label){let r={rx:0,ry:0,labelPaddingX:n,labelPaddingY:1.5*n};Uw(e.label,i)+2*r.labelPaddingX<i.er.minEntityWidth&&(e.width=i.er.minEntityWidth);let a=await NM(t,e,r);if(!Lr(i.htmlLabels)){let t=a.select("text"),e=t.node()?.getBBox();t.attr("transform",`translate(${-e.width/2}, 0)`)}return a}i.htmlLabels||(n*=1.25,a*=1.25);let h=wS(e);h||(h="node default");let c=t.insert("g").attr("class",h).attr("id",e.domId||e.id),u=await _B(c,e.label??"",i,0,0,["name"],s);u.height+=a;let d=0,p=[],f=[],g=0,y=0,m=0,x=0,b=!0,C=!0;for(let t of r.attributes){let e=await _B(c,t.type,i,0,d,["attribute-type"],s);g=Math.max(g,e.width+n);let r=await _B(c,t.name,i,0,d,["attribute-name"],s);y=Math.max(y,r.width+n);let o=await _B(c,t.keys.join(),i,0,d,["attribute-keys"],s);m=Math.max(m,o.width+n);let l=await _B(c,t.comment,i,0,d,["attribute-comment"],s);x=Math.max(x,l.width+n);let h=Math.max(e.height,r.height,o.height,l.height)+a;f.push({yOffset:d,rowHeight:h}),d+=h}let k=4;m<=n&&(b=!1,m=0,k--),x<=n&&(C=!1,x=0,k--);let w=c.node().getBBox();if(u.width+2*n-(g+y+m+x)>0){let t=u.width+2*n-(g+y+m+x);g+=t/k,y+=t/k,m>0&&(m+=t/k),x>0&&(x+=t/k)}let _=g+y+m+x,v=BT.svg(c),S=ox(e,{});"handDrawn"!==e.look&&(S.roughness=0,S.fillStyle="solid");let T=0;f.length>0&&(T=f.reduce((t,e)=>t+(e?.rowHeight??0),0));let M=Math.max(w.width+2*n,e?.width||0,_),B=Math.max((T??0)+u.height,e?.height||0),A=-M/2,F=-B/2;c.selectAll("g:not(:first-child)").each((t,e,r)=>{let i=ro(r[e]),o=i.attr("transform"),s=0,l=0;if(o){let t=RegExp(/translate\(([^,]+),([^)]+)\)/).exec(o);t&&(s=parseFloat(t[1]),l=parseFloat(t[2]),i.attr("class").includes("attribute-name")?s+=g:i.attr("class").includes("attribute-keys")?s+=g+y:i.attr("class").includes("attribute-comment")&&(s+=g+y+m))}i.attr("transform",`translate(${A+n/2+s}, ${l+F+u.height+a/2})`)}),c.select(".name").attr("transform","translate("+-u.width/2+", "+(F+a/2)+")");let L=v.rectangle(A,F,M,B,S),$=c.insert(()=>L,":first-child").attr("style",o.join("")),{themeVariables:E}=re(),{rowEven:D,rowOdd:O,nodeBorder:I}=E;p.push(0);for(let[t,e]of f.entries()){let r=(t+1)%2==0&&0!==e.yOffset,i=v.rectangle(A,u.height+F+e?.yOffset,M,e?.rowHeight,{...S,fill:r?D:O,stroke:I});c.insert(()=>i,"g.label").attr("style",o.join("")).attr("class","row-rect-"+(r?"even":"odd"))}let N=v.line(A,u.height+F,M+A,u.height+F,S);c.insert(()=>N).attr("class","divider"),N=v.line(g+A,u.height+F,g+A,B+F,S),c.insert(()=>N).attr("class","divider"),b&&(N=v.line(g+y+A,u.height+F,g+y+A,B+F,S),c.insert(()=>N).attr("class","divider")),C&&(N=v.line(g+y+m+A,u.height+F,g+y+m+A,B+F,S),c.insert(()=>N).attr("class","divider"));for(let t of p)N=v.line(A,u.height+F+t,M+A,u.height+F+t,S),c.insert(()=>N).attr("class","divider");if(kS(e,$),l&&"handDrawn"!==e.look){let t=l.split(";")?.filter(t=>t.includes("stroke"))?.map(t=>`${t}`).join("; ");c.selectAll("path").attr("style",t??""),c.selectAll(".row-rect-even path").attr("style",l)}return e.intersect=function(t){return eM.rect(e,t)},c}async function _B(t,e,r,i=0,n=0,a=[],o=""){let s=t.insert("g").attr("class",`label ${a.join(" ")}`).attr("transform",`translate(${i}, ${n})`).attr("style",o);e!==Dr(e)&&(e=(e=Dr(e)).replaceAll("<","&lt;").replaceAll(">","&gt;"));let l=s.node().appendChild(await xS(s,e,{width:Uw(e,r)+100,style:o,useHtmlLabels:r.htmlLabels},r));if(e.includes("&lt;")||e.includes("&gt;")){let t=l.children[0];for(t.textContent=t.textContent.replaceAll("&lt;","<").replaceAll("&gt;",">");t.childNodes[0];)t=t.childNodes[0],t.textContent=t.textContent.replaceAll("&lt;","<").replaceAll("&gt;",">")}let h=l.getBBox();if(Lr(r.htmlLabels)){let t=l.children[0];t.style.textAlign="start";let e=ro(l);h=t.getBoundingClientRect(),e.attr("width",h.width),e.attr("height",h.height)}return h}async function vB(t,e,r,i,n=r.class.padding??12){let a=i?0:3,o=t.insert("g").attr("class",wS(e)).attr("id",e.domId||e.id),s=null,l=null,h=null,c=null,u=0,d=0,p=0;if(s=o.insert("g").attr("class","annotation-group text"),e.annotations.length>0){let t=e.annotations[0];await SB(s,{text:`«${t}»`},0),u=s.node().getBBox().height}l=o.insert("g").attr("class","label-group text"),await SB(l,e,0,["font-weight: bolder"]);let f=l.node().getBBox();d=f.height,h=o.insert("g").attr("class","members-group text");let g=0;for(let t of e.members){g+=await SB(h,t,g,[t.parseClassifier()])+a}p=h.node().getBBox().height,p<=0&&(p=n/2),c=o.insert("g").attr("class","methods-group text");let y=0;for(let t of e.methods){y+=await SB(c,t,y,[t.parseClassifier()])+a}let m=o.node().getBBox();if(null!==s){let t=s.node().getBBox();s.attr("transform",`translate(${-t.width/2})`)}return l.attr("transform",`translate(${-f.width/2}, ${u})`),m=o.node().getBBox(),h.attr("transform",`translate(0, ${u+d+2*n})`),m=o.node().getBBox(),c.attr("transform",`translate(0, ${u+d+(p?p+4*n:2*n)})`),m=o.node().getBBox(),{shapeSvg:o,bbox:m}}async function SB(t,e,r,i=[]){let n=t.insert("g").attr("class","label").attr("style",i.join("; ")),a=re(),o="useHtmlLabels"in e?e.useHtmlLabels:Lr(a.htmlLabels)??!0,l="";l="text"in e?e.text:e.label,!o&&l.startsWith("\\")&&(l=l.substring(1)),zr(l)&&(o=!0);let h,c=await xS(n,gi(r_(l)),{width:Uw(l,a)+50,classes:"markdown-node-label",useHtmlLabels:o},a),u=1;if(o){let t=c.children[0],e=ro(c);u=t.innerHTML.split("<br>").length,t.innerHTML.includes("</math>")&&(u+=t.innerHTML.split("<mrow>").length-1);let r=t.getElementsByTagName("img");if(r){let t=""===l.replace(/<img[^>]*>/g,"").trim();await Promise.all([...r].map(e=>new Promise(r=>{function i(){if(e.style.display="flex",e.style.flexDirection="column",t){let t=a.fontSize?.toString()??window.getComputedStyle(document.body).fontSize,r=5*parseInt(t,10)+"px";e.style.minWidth=r,e.style.maxWidth=r}else e.style.width="100%";r(e)}s(i,"setupImage"),setTimeout(()=>{e.complete&&i()}),e.addEventListener("error",i),e.addEventListener("load",i)})))}h=t.getBoundingClientRect(),e.attr("width",h.width),e.attr("height",h.height)}else{i.includes("font-weight: bolder")&&ro(c).selectAll("tspan").attr("font-weight",""),u=c.children.length;let t=c.children[0];(""===c.textContent||c.textContent.includes("&gt"))&&(t.textContent=l[0]+l.substring(1).replaceAll("&gt;",">").replaceAll("&lt;","<").trim()," "===l[1]&&(t.textContent=t.textContent[0]+" "+t.textContent.substring(1))),"undefined"===t.textContent&&(t.textContent=""),h=c.getBBox()}return n.attr("transform","translate(0,"+(-h.height/(2*u)+r)+")"),h.height}async function TB(t,e){let r=di(),i=r.class.padding??12,n=i,a=e.useHtmlLabels??Lr(r.htmlLabels)??!0,o=e;o.annotations=o.annotations??[],o.members=o.members??[],o.methods=o.methods??[];let{shapeSvg:s,bbox:l}=await vB(t,e,r,a,n),{labelStyles:h,nodeStyles:c}=ax(e);e.labelStyle=h,e.cssStyles=o.styles||"";let u=o.styles?.join(";")||c||"";e.cssStyles||(e.cssStyles=u.replaceAll("!important","").split(";"));let d=0===o.members.length&&0===o.methods.length&&!r.class?.hideEmptyMembersBox,p=BT.svg(s),f=ox(e,{});"handDrawn"!==e.look&&(f.roughness=0,f.fillStyle="solid");let g=l.width,y=l.height;0===o.members.length&&0===o.methods.length?y+=n:o.members.length>0&&0===o.methods.length&&(y+=2*n);let m=-g/2,x=-y/2,b=p.rectangle(m-i,x-i-(d?i:0===o.members.length&&0===o.methods.length?-i/2:0),g+2*i,y+2*i+(d?2*i:0===o.members.length&&0===o.methods.length?-i:0),f),C=s.insert(()=>b,":first-child");C.attr("class","basic label-container");let k=C.node().getBBox();s.selectAll(".text").each((t,e,r)=>{let n=ro(r[e]),l=n.attr("transform"),h=0;if(l){let t=RegExp(/translate\(([^,]+),([^)]+)\)/).exec(l);t&&(h=parseFloat(t[2]))}let c=h+x+i-(d?i:0===o.members.length&&0===o.methods.length?-i/2:0);a||(c-=4);let u=m;(n.attr("class").includes("label-group")||n.attr("class").includes("annotation-group"))&&(u=-n.node()?.getBBox().width/2||0,s.selectAll("text").each(function(t,e,r){"middle"===window.getComputedStyle(r[e]).textAnchor&&(u=0)})),n.attr("transform",`translate(${u}, ${c})`)});let w=s.select(".annotation-group").node().getBBox().height-(d?i/2:0)||0,_=s.select(".label-group").node().getBBox().height-(d?i/2:0)||0,v=s.select(".members-group").node().getBBox().height-(d?i/2:0)||0;if(o.members.length>0||o.methods.length>0||d){let t=p.line(k.x,w+_+x+i,k.x+k.width,w+_+x+i,f);s.insert(()=>t).attr("class","divider").attr("style",u)}if(d||o.members.length>0||o.methods.length>0){let t=p.line(k.x,w+_+v+x+2*n+i,k.x+k.width,w+_+v+x+i+2*n,f);s.insert(()=>t).attr("class","divider").attr("style",u)}if("handDrawn"!==o.look&&s.selectAll("path").attr("style",u),C.select(":nth-child(2)").attr("style",u),s.selectAll(".divider").select("path").attr("style",u),e.labelStyle?s.selectAll("span").attr("style",e.labelStyle):s.selectAll("span").attr("style",u),!a){let t=RegExp(/color\s*:\s*([^;]*)/),e=t.exec(u);if(e){let t=e[0].replace("color","fill");s.selectAll("tspan").attr("style",t)}else if(h){let e=t.exec(h);if(e){let t=e[0].replace("color","fill");s.selectAll("tspan").attr("style",t)}}}return kS(e,C),e.intersect=function(t){return eM.rect(e,t)},s}async function MB(t,e){let{labelStyles:r,nodeStyles:i}=ax(e);e.labelStyle=r;let n,a=e,o=e,s="verifyMethod"in e,l=wS(e),h=t.insert("g").attr("class",l).attr("id",e.domId??e.id);n=s?await BB(h,`&lt;&lt;${a.type}&gt;&gt;`,0,e.labelStyle):await BB(h,"&lt;&lt;Element&gt;&gt;",0,e.labelStyle);let c=n,u=await BB(h,a.name,c,e.labelStyle+"; font-weight: bold;");if(c+=u+20,s){c+=await BB(h,""+(a.requirementId?`id: ${a.requirementId}`:""),c,e.labelStyle),c+=await BB(h,""+(a.text?`Text: ${a.text}`:""),c,e.labelStyle),c+=await BB(h,""+(a.risk?`Risk: ${a.risk}`:""),c,e.labelStyle),await BB(h,""+(a.verifyMethod?`Verification: ${a.verifyMethod}`:""),c,e.labelStyle)}else{c+=await BB(h,""+(o.type?`Type: ${o.type}`:""),c,e.labelStyle),await BB(h,""+(o.docRef?`Doc Ref: ${o.docRef}`:""),c,e.labelStyle)}let d=(h.node()?.getBBox().width??200)+20,p=(h.node()?.getBBox().height??200)+20,f=-d/2,g=-p/2,y=BT.svg(h),m=ox(e,{});"handDrawn"!==e.look&&(m.roughness=0,m.fillStyle="solid");let x=y.rectangle(f,g,d,p,m),b=h.insert(()=>x,":first-child");if(b.attr("class","basic label-container").attr("style",i),h.selectAll(".label").each((t,e,r)=>{let i=ro(r[e]),n=i.attr("transform"),a=0,o=0;if(n){let t=RegExp(/translate\(([^,]+),([^)]+)\)/).exec(n);t&&(a=parseFloat(t[1]),o=parseFloat(t[2]))}let s=o-p/2,l=f+10;(0===e||1===e)&&(l=a),i.attr("transform",`translate(${l}, ${s+20})`)}),c>n+u+20){let t=y.line(f,g+n+u+20,f+d,g+n+u+20,m);h.insert(()=>t).attr("style",i)}return kS(e,b),e.intersect=function(t){return eM.rect(e,t)},h}async function BB(t,e,r,i=""){if(""===e)return 0;let n,a=t.insert("g").attr("class","label").attr("style",i),o=di(),s=o.htmlLabels??!0,l=await xS(a,gi(r_(e)),{width:Uw(e,o)+50,classes:"markdown-node-label",useHtmlLabels:s,style:i},o);if(s){let t=l.children[0],e=ro(l);n=t.getBoundingClientRect(),e.attr("width",n.width),e.attr("height",n.height)}else{let t=l.children[0];for(let e of t.children)e.textContent=e.textContent.replaceAll("&gt;",">").replaceAll("&lt;","<"),i&&e.setAttribute("style",i);n=l.getBBox(),n.height+=6}return a.attr("transform",`translate(${-n.width/2},${-n.height/2+r})`),n.height}s(gB,"tiltedCylinder"),s(yB,"trapezoid"),s(mB,"trapezoidalPentagon"),s(xB,"triangle"),s(bB,"waveEdgedRectangle"),s(CB,"waveRectangle"),s(kB,"windowPane"),s(wB,"erBox"),s(_B,"addText"),s(vB,"textHelper"),s(SB,"addText"),s(TB,"classBox"),s(MB,"requirementBox"),s(BB,"addText");var AB=s(t=>{switch(t){case"Very High":return"red";case"High":return"orange";case"Medium":return null;case"Low":return"blue";case"Very Low":return"lightblue"}},"colorFromPriority");async function FB(t,e,{config:r}){let{labelStyles:i,nodeStyles:n}=ax(e);e.labelStyle=i||"";let a=e.width;e.width=(e.width??200)-10;let o,{shapeSvg:s,bbox:l,label:h}=await bS(t,e,wS(e)),c=e.padding||10,u="";"ticket"in e&&e.ticket&&r?.kanban?.ticketBaseUrl&&(u=r?.kanban?.ticketBaseUrl.replace("#TICKET#",e.ticket),o=s.insert("svg:a",":first-child").attr("class","kanban-ticket-link").attr("xlink:href",u).attr("target","_blank"));let d,p,f={useHtmlLabels:e.useHtmlLabels,labelStyle:e.labelStyle||"",width:e.width,img:e.img,padding:e.padding||8,centerLabel:!1};({label:d,bbox:p}=o?await CS(o,"ticket"in e&&e.ticket||"",f):await CS(s,"ticket"in e&&e.ticket||"",f));let{label:g,bbox:y}=await CS(s,"assigned"in e&&e.assigned||"",f);e.width=a;let m=e?.width||0,x=Math.max(p.height,y.height)/2,b=Math.max(l.height+20,e?.height||0)+x,C=-m/2,k=-b/2;h.attr("transform","translate("+(c-m/2)+", "+(-x-l.height/2)+")"),d.attr("transform","translate("+(c-m/2)+", "+(-x+l.height/2)+")"),g.attr("transform","translate("+(c+m/2-y.width-20)+", "+(-x+l.height/2)+")");let w,{rx:_,ry:v}=e,{cssStyles:S}=e;if("handDrawn"===e.look){let t=BT.svg(s),r=ox(e,{}),i=_||v?t.path(OT(C,k,m,b,_||0),r):t.rectangle(C,k,m,b,r);w=s.insert(()=>i,":first-child"),w.attr("class","basic label-container").attr("style",S||null)}else{w=s.insert("rect",":first-child"),w.attr("class","basic label-container __APA__").attr("style",n).attr("rx",_??5).attr("ry",v??5).attr("x",C).attr("y",k).attr("width",m).attr("height",b);let t="priority"in e&&e.priority;if(t){let e=s.append("line"),r=C+2,i=k+Math.floor((_??0)/2),n=k+b-Math.floor((_??0)/2);e.attr("x1",r).attr("y1",i).attr("x2",r).attr("y2",n).attr("stroke-width","4").attr("stroke",AB(t))}}return kS(e,w),e.height=b,e.intersect=function(t){return eM.rect(e,t)},s}s(FB,"kanbanItem");var LB=[{semanticName:"Process",name:"Rectangle",shortName:"rect",description:"Standard process shape",aliases:["proc","process","rectangle"],internalAliases:["squareRect"],handler:iB},{semanticName:"Event",name:"Rounded Rectangle",shortName:"rounded",description:"Represents an event",aliases:["event"],internalAliases:["roundedRect"],handler:tB},{semanticName:"Terminal Point",name:"Stadium",shortName:"stadium",description:"Terminal point",aliases:["terminal","pill"],handler:nB},{semanticName:"Subprocess",name:"Framed Rectangle",shortName:"fr-rect",description:"Subprocess",aliases:["subprocess","subproc","framed-rectangle","subroutine"],handler:lB},{semanticName:"Database",name:"Cylinder",shortName:"cyl",description:"Database storage",aliases:["db","database","cylinder"],handler:kM},{semanticName:"Start",name:"Circle",shortName:"circle",description:"Starting point",aliases:["circ"],handler:lM},{semanticName:"Decision",name:"Diamond",shortName:"diam",description:"Decision-making step",aliases:["decision","diamond","question"],handler:QM},{semanticName:"Prepare Conditional",name:"Hexagon",shortName:"hex",description:"Preparation or condition step",aliases:["hexagon","prepare"],handler:AM},{semanticName:"Data Input/Output",name:"Lean Right",shortName:"lean-r",description:"Represents input or output",aliases:["lean-right","in-out"],internalAliases:["lean_right"],handler:zM},{semanticName:"Data Input/Output",name:"Lean Left",shortName:"lean-l",description:"Represents output or input",aliases:["lean-left","out-in"],internalAliases:["lean_left"],handler:PM},{semanticName:"Priority Action",name:"Trapezoid Base Bottom",shortName:"trap-b",description:"Priority action",aliases:["priority","trapezoid-bottom","trapezoid"],handler:yB},{semanticName:"Manual Operation",name:"Trapezoid Base Top",shortName:"trap-t",description:"Represents a manual task",aliases:["manual","trapezoid-top","inv-trapezoid"],internalAliases:["inv_trapezoid"],handler:IM},{semanticName:"Stop",name:"Double Circle",shortName:"dbl-circ",description:"Represents a stop point",aliases:["double-circle"],internalAliases:["doublecircle"],handler:_M},{semanticName:"Text Block",name:"Text Block",shortName:"text",description:"Text block",handler:uB},{semanticName:"Card",name:"Notched Rectangle",shortName:"notch-rect",description:"Represents a card",aliases:["card","notched-rectangle"],handler:oM},{semanticName:"Lined/Shaded Process",name:"Lined Rectangle",shortName:"lin-rect",description:"Lined process shape",aliases:["lined-rectangle","lined-process","lin-proc","shaded-process"],handler:eB},{semanticName:"Start",name:"Small Circle",shortName:"sm-circ",description:"Small starting point",aliases:["start","small-circle"],internalAliases:["stateStart"],handler:sB},{semanticName:"Stop",name:"Framed Circle",shortName:"fr-circ",description:"Stop point",aliases:["stop","framed-circle"],internalAliases:["stateEnd"],handler:oB},{semanticName:"Fork/Join",name:"Filled Rectangle",shortName:"fork",description:"Fork or join in process flow",aliases:["join"],internalAliases:["forkJoin"],handler:TM},{semanticName:"Collate",name:"Hourglass",shortName:"hourglass",description:"Represents a collate operation",aliases:["hourglass","collate"],handler:FM},{semanticName:"Comment",name:"Curly Brace",shortName:"brace",description:"Adds a comment",aliases:["comment","brace-l"],handler:dM},{semanticName:"Comment Right",name:"Curly Brace",shortName:"brace-r",description:"Adds a comment",handler:fM},{semanticName:"Comment with braces on both sides",name:"Curly Braces",shortName:"braces",description:"Adds a comment",handler:yM},{semanticName:"Com Link",name:"Lightning Bolt",shortName:"bolt",description:"Communication link",aliases:["com-link","lightning-bolt"],handler:qM},{semanticName:"Document",name:"Document",shortName:"doc",description:"Represents a document",aliases:["doc","document"],handler:bB},{semanticName:"Delay",name:"Half-Rounded Rectangle",shortName:"delay",description:"Represents a delay",aliases:["half-rounded-rectangle"],handler:MM},{semanticName:"Direct Access Storage",name:"Horizontal Cylinder",shortName:"h-cyl",description:"Direct access storage",aliases:["das","horizontal-cylinder"],handler:gB},{semanticName:"Disk Storage",name:"Lined Cylinder",shortName:"lin-cyl",description:"Disk storage",aliases:["disk","lined-cylinder"],handler:UM},{semanticName:"Display",name:"Curved Trapezoid",shortName:"curv-trap",description:"Represents a display",aliases:["curved-trapezoid","display"],handler:mM},{semanticName:"Divided Process",name:"Divided Rectangle",shortName:"div-rect",description:"Divided process shape",aliases:["div-proc","divided-rectangle","divided-process"],handler:wM},{semanticName:"Extract",name:"Triangle",shortName:"tri",description:"Extraction process",aliases:["extract","triangle"],handler:xB},{semanticName:"Internal Storage",name:"Window Pane",shortName:"win-pane",description:"Internal storage",aliases:["internal-storage","window-pane"],handler:kB},{semanticName:"Junction",name:"Filled Circle",shortName:"f-circ",description:"Junction point",aliases:["junction","filled-circle"],handler:vM},{semanticName:"Loop Limit",name:"Trapezoidal Pentagon",shortName:"notch-pent",description:"Loop limit step",aliases:["loop-limit","notched-pentagon"],handler:mB},{semanticName:"Manual File",name:"Flipped Triangle",shortName:"flip-tri",description:"Manual file operation",aliases:["manual-file","flipped-triangle"],handler:SM},{semanticName:"Manual Input",name:"Sloped Rectangle",shortName:"sl-rect",description:"Manual input step",aliases:["manual-input","sloped-rectangle"],handler:rB},{semanticName:"Multi-Document",name:"Stacked Document",shortName:"docs",description:"Multiple documents",aliases:["documents","st-doc","stacked-document"],handler:GM},{semanticName:"Multi-Process",name:"Stacked Rectangle",shortName:"st-rect",description:"Multiple processes",aliases:["procs","processes","stacked-rectangle"],handler:VM},{semanticName:"Stored Data",name:"Bow Tie Rectangle",shortName:"bow-rect",description:"Stored data",aliases:["stored-data","bow-tie-rectangle"],handler:nM},{semanticName:"Summary",name:"Crossed Circle",shortName:"cross-circ",description:"Summary",aliases:["summary","crossed-circle"],handler:cM},{semanticName:"Tagged Document",name:"Tagged Document",shortName:"tag-doc",description:"Tagged document",aliases:["tag-doc","tagged-document"],handler:cB},{semanticName:"Tagged Process",name:"Tagged Rectangle",shortName:"tag-rect",description:"Tagged process",aliases:["tagged-rectangle","tag-proc","tagged-process"],handler:hB},{semanticName:"Paper Tape",name:"Flag",shortName:"flag",description:"Paper tape",aliases:["paper-tape"],handler:CB},{semanticName:"Odd",name:"Odd",shortName:"odd",description:"Odd shape",internalAliases:["rect_left_inv_arrow"],handler:KM},{semanticName:"Lined Document",name:"Lined Document",shortName:"lin-doc",description:"Lined document",aliases:["lined-document"],handler:YM}],$B=s(()=>{let t=[...Object.entries({state:aB,choice:sM,note:XM,rectWithTitle:JM,labelRect:RM,iconSquare:DM,iconCircle:$M,icon:LM,iconRounded:EM,imageSquare:OM,anchor:rM,kanbanItem:FB,classBox:TB,erBox:wB,requirementBox:MB}),...LB.flatMap(t=>[t.shortName,..."aliases"in t?t.aliases:[],..."internalAliases"in t?t.internalAliases:[]].map(e=>[e,t.handler]))];return Object.fromEntries(t)},"generateShapeMap"),EB=$B();function DB(t){return t in EB}s(DB,"isValidShape");var OB=new Map;async function IB(t,e,r){let i,n;"rect"===e.shape&&(e.rx&&e.ry?e.shape="roundedRect":e.shape="squareRect");let a=e.shape?EB[e.shape]:void 0;if(!a)throw new Error(`No such shape: ${e.shape}. Please check your syntax.`);if(e.link){let o;"sandbox"===r.config.securityLevel?o="_top":e.linkTarget&&(o=e.linkTarget||"_blank"),i=t.insert("svg:a").attr("xlink:href",e.link).attr("target",o??null),n=await a(i,e,r)}else n=await a(t,e,r),i=n;return e.tooltip&&n.attr("title",e.tooltip),OB.set(e.id,i),e.haveCallback&&i.attr("class",i.attr("class")+" clickable"),i}s(IB,"insertNode");var NB=s((t,e)=>{OB.set(e.id,t)},"setNodeElem"),RB=s(()=>{OB.clear()},"clear"),PB=s(t=>{let e=OB.get(t.id);y.trace("Transforming node",t.diff,t,"translate("+(t.x-t.width/2-5)+", "+t.width/2+")");let r=t.diff||0;return t.clusterNode?e.attr("transform","translate("+(t.x+r-t.width/2)+", "+(t.y-t.height/2-8)+")"):e.attr("transform","translate("+t.x+", "+t.y+")"),r},"positionNode"),zB=s((t,e,r,i,n,a)=>{e.arrowTypeStart&&jB(t,"start",e.arrowTypeStart,r,i,n,a),e.arrowTypeEnd&&jB(t,"end",e.arrowTypeEnd,r,i,n,a)},"addEdgeMarkers"),qB={arrow_cross:{type:"cross",fill:!1},arrow_point:{type:"point",fill:!0},arrow_barb:{type:"barb",fill:!0},arrow_circle:{type:"circle",fill:!1},aggregation:{type:"aggregation",fill:!1},extension:{type:"extension",fill:!1},composition:{type:"composition",fill:!0},dependency:{type:"dependency",fill:!0},lollipop:{type:"lollipop",fill:!1},only_one:{type:"onlyOne",fill:!1},zero_or_one:{type:"zeroOrOne",fill:!1},one_or_more:{type:"oneOrMore",fill:!1},zero_or_more:{type:"zeroOrMore",fill:!1},requirement_arrow:{type:"requirement_arrow",fill:!1},requirement_contains:{type:"requirement_contains",fill:!1}},jB=s((t,e,r,i,n,a,o)=>{let s=qB[r];if(!s)return void y.warn(`Unknown arrow type: ${r}`);let l=`${n}_${a}-${s.type}${"start"===e?"Start":"End"}`;if(o&&""!==o.trim()){let r=`${l}_${o.replace(/[^\dA-Za-z]/g,"_")}`;if(!document.getElementById(r)){let t=document.getElementById(l);if(t){let e=t.cloneNode(!0);e.id=r,e.querySelectorAll("path, circle, line").forEach(t=>{t.setAttribute("stroke",o),s.fill&&t.setAttribute("fill",o)}),t.parentNode?.appendChild(e)}}t.attr(`marker-${e}`,`url(${i}#${r})`)}else t.attr(`marker-${e}`,`url(${i}#${l})`)},"addEdgeMarker"),WB=new Map,HB=new Map,UB=s(()=>{WB.clear(),HB.clear()},"clear"),YB=s(t=>t?t.reduce((t,e)=>t+";"+e,""):"","getLabelStyles"),VB=s(async(t,e)=>{let r=Lr(di().flowchart.htmlLabels),i=await xS(t,e.label,{style:YB(e.labelStyle),useHtmlLabels:r,addSvgBackground:!0,isNode:!1});y.info("abc82",e,e.labelType);let n=t.insert("g").attr("class","edgeLabel"),a=n.insert("g").attr("class","label");a.node().appendChild(i);let o,s=i.getBBox();if(r){let t=i.children[0],e=ro(i);s=t.getBoundingClientRect(),e.attr("width",s.width),e.attr("height",s.height)}if(a.attr("transform","translate("+-s.width/2+", "+-s.height/2+")"),WB.set(e.id,n),e.width=s.width,e.height=s.height,e.startLabelLeft){let r=await DT(e.startLabelLeft,YB(e.labelStyle)),i=t.insert("g").attr("class","edgeTerminals"),n=i.insert("g").attr("class","inner");o=n.node().appendChild(r);let a=r.getBBox();n.attr("transform","translate("+-a.width/2+", "+-a.height/2+")"),HB.get(e.id)||HB.set(e.id,{}),HB.get(e.id).startLeft=i,GB(o,e.startLabelLeft)}if(e.startLabelRight){let r=await DT(e.startLabelRight,YB(e.labelStyle)),i=t.insert("g").attr("class","edgeTerminals"),n=i.insert("g").attr("class","inner");o=i.node().appendChild(r),n.node().appendChild(r);let a=r.getBBox();n.attr("transform","translate("+-a.width/2+", "+-a.height/2+")"),HB.get(e.id)||HB.set(e.id,{}),HB.get(e.id).startRight=i,GB(o,e.startLabelRight)}if(e.endLabelLeft){let r=await DT(e.endLabelLeft,YB(e.labelStyle)),i=t.insert("g").attr("class","edgeTerminals"),n=i.insert("g").attr("class","inner");o=n.node().appendChild(r);let a=r.getBBox();n.attr("transform","translate("+-a.width/2+", "+-a.height/2+")"),i.node().appendChild(r),HB.get(e.id)||HB.set(e.id,{}),HB.get(e.id).endLeft=i,GB(o,e.endLabelLeft)}if(e.endLabelRight){let r=await DT(e.endLabelRight,YB(e.labelStyle)),i=t.insert("g").attr("class","edgeTerminals"),n=i.insert("g").attr("class","inner");o=n.node().appendChild(r);let a=r.getBBox();n.attr("transform","translate("+-a.width/2+", "+-a.height/2+")"),i.node().appendChild(r),HB.get(e.id)||HB.set(e.id,{}),HB.get(e.id).endRight=i,GB(o,e.endLabelRight)}return i},"insertEdgeLabel");function GB(t,e){di().flowchart.htmlLabels&&t&&(t.style.width=9*e.length+"px",t.style.height="12px")}s(GB,"setTerminalWidth");var XB=s((t,e)=>{y.debug("Moving label abc88 ",t.id,t.label,WB.get(t.id),e);let r=e.updatedPath?e.updatedPath:e.originalPath,i=di(),{subGraphTitleTotalMargin:n}=tx(i);if(t.label){let i=WB.get(t.id),a=t.x,o=t.y;if(r){let i=t_.calcLabelPosition(r);y.debug("Moving label "+t.label+" from (",a,",",o,") to (",i.x,",",i.y,") abc88"),e.updatedPath&&(a=i.x,o=i.y)}i.attr("transform",`translate(${a}, ${o+n/2})`)}if(t.startLabelLeft){let e=HB.get(t.id).startLeft,i=t.x,n=t.y;if(r){let e=t_.calcTerminalLabelPosition(t.arrowTypeStart?10:0,"start_left",r);i=e.x,n=e.y}e.attr("transform",`translate(${i}, ${n})`)}if(t.startLabelRight){let e=HB.get(t.id).startRight,i=t.x,n=t.y;if(r){let e=t_.calcTerminalLabelPosition(t.arrowTypeStart?10:0,"start_right",r);i=e.x,n=e.y}e.attr("transform",`translate(${i}, ${n})`)}if(t.endLabelLeft){let e=HB.get(t.id).endLeft,i=t.x,n=t.y;if(r){let e=t_.calcTerminalLabelPosition(t.arrowTypeEnd?10:0,"end_left",r);i=e.x,n=e.y}e.attr("transform",`translate(${i}, ${n})`)}if(t.endLabelRight){let e=HB.get(t.id).endRight,i=t.x,n=t.y;if(r){let e=t_.calcTerminalLabelPosition(t.arrowTypeEnd?10:0,"end_right",r);i=e.x,n=e.y}e.attr("transform",`translate(${i}, ${n})`)}},"positionEdgeLabel"),ZB=s((t,e)=>{let r=t.x,i=t.y,n=Math.abs(e.x-r),a=Math.abs(e.y-i),o=t.width/2,s=t.height/2;return n>=o||a>=s},"outsideNode"),QB=s((t,e,r)=>{y.debug(`intersection calc abc89:\n  outsidePoint: ${JSON.stringify(e)}\n  insidePoint : ${JSON.stringify(r)}\n  node        : x:${t.x} y:${t.y} w:${t.width} h:${t.height}`);let i=t.x,n=t.y,a=Math.abs(i-r.x),o=t.width/2,s=r.x<e.x?o-a:o+a,l=t.height/2,h=Math.abs(e.y-r.y),c=Math.abs(e.x-r.x);if(Math.abs(n-e.y)*o>Math.abs(i-e.x)*l){let t=r.y<e.y?e.y-l-n:n-l-e.y;s=c*t/h;let i={x:r.x<e.x?r.x+s:r.x-c+s,y:r.y<e.y?r.y+h-t:r.y-h+t};return 0===s&&(i.x=e.x,i.y=e.y),0===c&&(i.x=e.x),0===h&&(i.y=e.y),y.debug(`abc89 top/bottom calc, Q ${h}, q ${t}, R ${c}, r ${s}`,i),i}{s=r.x<e.x?e.x-o-i:i-o-e.x;let t=h*s/c,n=r.x<e.x?r.x+c-s:r.x-c+s,a=r.y<e.y?r.y+t:r.y-t;return y.debug(`sides calc abc89, Q ${h}, q ${t}, R ${c}, r ${s}`,{_x:n,_y:a}),0===s&&(n=e.x,a=e.y),0===c&&(n=e.x),0===h&&(a=e.y),{x:n,y:a}}},"intersection"),KB=s((t,e)=>{y.warn("abc88 cutPathAtIntersect",t,e);let r=[],i=t[0],n=!1;return t.forEach(t=>{if(y.info("abc88 checking point",t,e),ZB(e,t)||n)y.warn("abc88 outside",t,i),i=t,n||r.push(t);else{let a=QB(e,i,t);y.debug("abc88 inside",t,i,a),y.debug("abc88 intersection",a,e);let o=!1;r.forEach(t=>{o=o||t.x===a.x&&t.y===a.y}),r.some(t=>t.x===a.x&&t.y===a.y)?y.warn("abc88 no intersect",a,r):r.push(a),n=!0}}),y.debug("returning points",r),r},"cutPathAtIntersect");function JB(t){let e=[],r=[];for(let i=1;i<t.length-1;i++){let n=t[i-1],a=t[i],o=t[i+1];(n.x===a.x&&a.y===o.y&&Math.abs(a.x-o.x)>5&&Math.abs(a.y-n.y)>5||n.y===a.y&&a.x===o.x&&Math.abs(a.x-n.x)>5&&Math.abs(a.y-o.y)>5)&&(e.push(a),r.push(i))}return{cornerPoints:e,cornerPointPositions:r}}s(JB,"extractCornerPoints");var tA=s(function(t,e,r){let i=e.x-t.x,n=e.y-t.y,a=r/Math.sqrt(i*i+n*n);return{x:e.x-a*i,y:e.y-a*n}},"findAdjacentPoint"),eA=s(function(t){let{cornerPointPositions:e}=JB(t),r=[];for(let i=0;i<t.length;i++)if(e.includes(i)){let e=t[i-1],n=t[i+1],a=t[i],o=tA(e,a,5),s=tA(n,a,5),l=s.x-o.x,h=s.y-o.y;r.push(o);let c=2*Math.sqrt(2),u={x:a.x,y:a.y};if(Math.abs(n.x-e.x)>10&&Math.abs(n.y-e.y)>=10){y.debug("Corner point fixing",Math.abs(n.x-e.x),Math.abs(n.y-e.y));let t=5;u=a.x===o.x?{x:l<0?o.x-t+c:o.x+t-c,y:h<0?o.y-c:o.y+c}:{x:l<0?o.x-c:o.x+c,y:h<0?o.y-t+c:o.y+t-c}}else y.debug("Corner point skipping fixing",Math.abs(n.x-e.x),Math.abs(n.y-e.y));r.push(u,s)}else r.push(t[i]);return r},"fixCorners"),rA=s(function(t,e,r,i,n,a,o){let{handDrawnSeed:s}=di(),l=e.points,h=!1,c=n;var u=a;let d=[];for(let t in e.cssCompiledStyles)nx(t)||d.push(e.cssCompiledStyles[t]);u.intersect&&c.intersect&&(l=l.slice(1,e.points.length-1),l.unshift(c.intersect(l[0])),y.debug("Last point APA12",e.start,"--\x3e",e.end,l[l.length-1],u,u.intersect(l[l.length-1])),l.push(u.intersect(l[l.length-1]))),e.toCluster&&(y.info("to cluster abc88",r.get(e.toCluster)),l=KB(e.points,r.get(e.toCluster).node),h=!0),e.fromCluster&&(y.debug("from cluster abc88",r.get(e.fromCluster),JSON.stringify(l,null,2)),l=KB(l.reverse(),r.get(e.fromCluster).node).reverse(),h=!0);let p=l.filter(t=>!Number.isNaN(t.y));p=eA(p);let f=ud;switch(f=Ku,e.curve){case"linear":f=Ku;break;case"basis":default:f=ud;break;case"cardinal":f=kd;break;case"bumpX":f=sd;break;case"bumpY":f=ld;break;case"catmullRom":f=Bd;break;case"monotoneX":f=jd;break;case"monotoneY":f=Wd;break;case"natural":f=Yd;break;case"step":f=Gd;break;case"stepAfter":f=Zd;break;case"stepBefore":f=Xd}let g,{x:m,y:x}=Jm(e),b=rd().x(m).y(x).curve(f);switch(e.thickness){case"normal":default:g="edge-thickness-normal";break;case"thick":g="edge-thickness-thick";break;case"invisible":g="edge-thickness-invisible"}switch(e.pattern){case"solid":default:g+=" edge-pattern-solid";break;case"dotted":g+=" edge-pattern-dotted";break;case"dashed":g+=" edge-pattern-dashed"}let C,k=b(p),w=Array.isArray(e.style)?e.style:e.style?[e.style]:[],_=w.find(t=>t?.startsWith("stroke:"));if("handDrawn"===e.look){let r=BT.svg(t);Object.assign([],p),g+=" transition",C=ro(r.path(k,{roughness:.3,seed:s})).select("path").attr("id",e.id).attr("class"," "+g+(e.classes?" "+e.classes:"")).attr("style",w?w.reduce((t,e)=>t+";"+e,""):"");let i=C.attr("d");C.attr("d",i),t.node().appendChild(C.node())}else{let r=d.join(";"),i=w?w.reduce((t,e)=>t+e+";",""):"",n="";e.animate&&(n=" edge-animation-fast"),e.animation&&(n=" edge-animation-"+e.animation);let a=r?r+";"+i+";":i;C=t.append("path").attr("d",k).attr("id",e.id).attr("class"," "+g+(e.classes?" "+e.classes:"")+(n??"")).attr("style",a),_=a.match(/stroke:([^;]+)/)?.[1]}let v="";(di().flowchart.arrowMarkerAbsolute||di().state.arrowMarkerAbsolute)&&(v=Fr(!0)),y.info("arrowTypeStart",e.arrowTypeStart),y.info("arrowTypeEnd",e.arrowTypeEnd),zB(C,e,v,o,i,_);let S={};return h&&(S.updatedPath=l),S.originalPath=e.points,S},"insertEdge"),iA=s((t,e,r,i)=>{e.forEach(e=>{bA[e](t,r,i)})},"insertMarkers"),nA=s((t,e,r)=>{y.trace("Making markers for ",r),t.append("defs").append("marker").attr("id",r+"_"+e+"-extensionStart").attr("class","marker extension "+e).attr("refX",18).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("path").attr("d","M 1,7 L18,13 V 1 Z"),t.append("defs").append("marker").attr("id",r+"_"+e+"-extensionEnd").attr("class","marker extension "+e).attr("refX",1).attr("refY",7).attr("markerWidth",20).attr("markerHeight",28).attr("orient","auto").append("path").attr("d","M 1,1 V 13 L18,7 Z")},"extension"),aA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-compositionStart").attr("class","marker composition "+e).attr("refX",18).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L1,7 L9,1 Z"),t.append("defs").append("marker").attr("id",r+"_"+e+"-compositionEnd").attr("class","marker composition "+e).attr("refX",1).attr("refY",7).attr("markerWidth",20).attr("markerHeight",28).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L1,7 L9,1 Z")},"composition"),oA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-aggregationStart").attr("class","marker aggregation "+e).attr("refX",18).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L1,7 L9,1 Z"),t.append("defs").append("marker").attr("id",r+"_"+e+"-aggregationEnd").attr("class","marker aggregation "+e).attr("refX",1).attr("refY",7).attr("markerWidth",20).attr("markerHeight",28).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L1,7 L9,1 Z")},"aggregation"),sA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-dependencyStart").attr("class","marker dependency "+e).attr("refX",6).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("path").attr("d","M 5,7 L9,13 L1,7 L9,1 Z"),t.append("defs").append("marker").attr("id",r+"_"+e+"-dependencyEnd").attr("class","marker dependency "+e).attr("refX",13).attr("refY",7).attr("markerWidth",20).attr("markerHeight",28).attr("orient","auto").append("path").attr("d","M 18,7 L9,13 L14,7 L9,1 Z")},"dependency"),lA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-lollipopStart").attr("class","marker lollipop "+e).attr("refX",13).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("circle").attr("stroke","black").attr("fill","transparent").attr("cx",7).attr("cy",7).attr("r",6),t.append("defs").append("marker").attr("id",r+"_"+e+"-lollipopEnd").attr("class","marker lollipop "+e).attr("refX",1).attr("refY",7).attr("markerWidth",190).attr("markerHeight",240).attr("orient","auto").append("circle").attr("stroke","black").attr("fill","transparent").attr("cx",7).attr("cy",7).attr("r",6)},"lollipop"),hA=s((t,e,r)=>{t.append("marker").attr("id",r+"_"+e+"-pointEnd").attr("class","marker "+e).attr("viewBox","0 0 10 10").attr("refX",5).attr("refY",5).attr("markerUnits","userSpaceOnUse").attr("markerWidth",8).attr("markerHeight",8).attr("orient","auto").append("path").attr("d","M 0 0 L 10 5 L 0 10 z").attr("class","arrowMarkerPath").style("stroke-width",1).style("stroke-dasharray","1,0"),t.append("marker").attr("id",r+"_"+e+"-pointStart").attr("class","marker "+e).attr("viewBox","0 0 10 10").attr("refX",4.5).attr("refY",5).attr("markerUnits","userSpaceOnUse").attr("markerWidth",8).attr("markerHeight",8).attr("orient","auto").append("path").attr("d","M 0 5 L 10 10 L 10 0 z").attr("class","arrowMarkerPath").style("stroke-width",1).style("stroke-dasharray","1,0")},"point"),cA=s((t,e,r)=>{t.append("marker").attr("id",r+"_"+e+"-circleEnd").attr("class","marker "+e).attr("viewBox","0 0 10 10").attr("refX",11).attr("refY",5).attr("markerUnits","userSpaceOnUse").attr("markerWidth",11).attr("markerHeight",11).attr("orient","auto").append("circle").attr("cx","5").attr("cy","5").attr("r","5").attr("class","arrowMarkerPath").style("stroke-width",1).style("stroke-dasharray","1,0"),t.append("marker").attr("id",r+"_"+e+"-circleStart").attr("class","marker "+e).attr("viewBox","0 0 10 10").attr("refX",-1).attr("refY",5).attr("markerUnits","userSpaceOnUse").attr("markerWidth",11).attr("markerHeight",11).attr("orient","auto").append("circle").attr("cx","5").attr("cy","5").attr("r","5").attr("class","arrowMarkerPath").style("stroke-width",1).style("stroke-dasharray","1,0")},"circle"),uA=s((t,e,r)=>{t.append("marker").attr("id",r+"_"+e+"-crossEnd").attr("class","marker cross "+e).attr("viewBox","0 0 11 11").attr("refX",12).attr("refY",5.2).attr("markerUnits","userSpaceOnUse").attr("markerWidth",11).attr("markerHeight",11).attr("orient","auto").append("path").attr("d","M 1,1 l 9,9 M 10,1 l -9,9").attr("class","arrowMarkerPath").style("stroke-width",2).style("stroke-dasharray","1,0"),t.append("marker").attr("id",r+"_"+e+"-crossStart").attr("class","marker cross "+e).attr("viewBox","0 0 11 11").attr("refX",-1).attr("refY",5.2).attr("markerUnits","userSpaceOnUse").attr("markerWidth",11).attr("markerHeight",11).attr("orient","auto").append("path").attr("d","M 1,1 l 9,9 M 10,1 l -9,9").attr("class","arrowMarkerPath").style("stroke-width",2).style("stroke-dasharray","1,0")},"cross"),dA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-barbEnd").attr("refX",19).attr("refY",7).attr("markerWidth",20).attr("markerHeight",14).attr("markerUnits","userSpaceOnUse").attr("orient","auto").append("path").attr("d","M 19,7 L9,13 L14,7 L9,1 Z")},"barb"),pA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-onlyOneStart").attr("class","marker onlyOne "+e).attr("refX",0).attr("refY",9).attr("markerWidth",18).attr("markerHeight",18).attr("orient","auto").append("path").attr("d","M9,0 L9,18 M15,0 L15,18"),t.append("defs").append("marker").attr("id",r+"_"+e+"-onlyOneEnd").attr("class","marker onlyOne "+e).attr("refX",18).attr("refY",9).attr("markerWidth",18).attr("markerHeight",18).attr("orient","auto").append("path").attr("d","M3,0 L3,18 M9,0 L9,18")},"only_one"),fA=s((t,e,r)=>{let i=t.append("defs").append("marker").attr("id",r+"_"+e+"-zeroOrOneStart").attr("class","marker zeroOrOne "+e).attr("refX",0).attr("refY",9).attr("markerWidth",30).attr("markerHeight",18).attr("orient","auto");i.append("circle").attr("fill","white").attr("cx",21).attr("cy",9).attr("r",6),i.append("path").attr("d","M9,0 L9,18");let n=t.append("defs").append("marker").attr("id",r+"_"+e+"-zeroOrOneEnd").attr("class","marker zeroOrOne "+e).attr("refX",30).attr("refY",9).attr("markerWidth",30).attr("markerHeight",18).attr("orient","auto");n.append("circle").attr("fill","white").attr("cx",9).attr("cy",9).attr("r",6),n.append("path").attr("d","M21,0 L21,18")},"zero_or_one"),gA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-oneOrMoreStart").attr("class","marker oneOrMore "+e).attr("refX",18).attr("refY",18).attr("markerWidth",45).attr("markerHeight",36).attr("orient","auto").append("path").attr("d","M0,18 Q 18,0 36,18 Q 18,36 0,18 M42,9 L42,27"),t.append("defs").append("marker").attr("id",r+"_"+e+"-oneOrMoreEnd").attr("class","marker oneOrMore "+e).attr("refX",27).attr("refY",18).attr("markerWidth",45).attr("markerHeight",36).attr("orient","auto").append("path").attr("d","M3,9 L3,27 M9,18 Q27,0 45,18 Q27,36 9,18")},"one_or_more"),yA=s((t,e,r)=>{let i=t.append("defs").append("marker").attr("id",r+"_"+e+"-zeroOrMoreStart").attr("class","marker zeroOrMore "+e).attr("refX",18).attr("refY",18).attr("markerWidth",57).attr("markerHeight",36).attr("orient","auto");i.append("circle").attr("fill","white").attr("cx",48).attr("cy",18).attr("r",6),i.append("path").attr("d","M0,18 Q18,0 36,18 Q18,36 0,18");let n=t.append("defs").append("marker").attr("id",r+"_"+e+"-zeroOrMoreEnd").attr("class","marker zeroOrMore "+e).attr("refX",39).attr("refY",18).attr("markerWidth",57).attr("markerHeight",36).attr("orient","auto");n.append("circle").attr("fill","white").attr("cx",9).attr("cy",18).attr("r",6),n.append("path").attr("d","M21,18 Q39,0 57,18 Q39,36 21,18")},"zero_or_more"),mA=s((t,e,r)=>{t.append("defs").append("marker").attr("id",r+"_"+e+"-requirement_arrowEnd").attr("refX",20).attr("refY",10).attr("markerWidth",20).attr("markerHeight",20).attr("orient","auto").append("path").attr("d","M0,0\n      L20,10\n      M20,10\n      L0,20")},"requirement_arrow"),xA=s((t,e,r)=>{let i=t.append("defs").append("marker").attr("id",r+"_"+e+"-requirement_containsStart").attr("refX",0).attr("refY",10).attr("markerWidth",20).attr("markerHeight",20).attr("orient","auto").append("g");i.append("circle").attr("cx",10).attr("cy",10).attr("r",9).attr("fill","none"),i.append("line").attr("x1",1).attr("x2",19).attr("y1",10).attr("y2",10),i.append("line").attr("y1",1).attr("y2",19).attr("x1",10).attr("x2",10)},"requirement_contains"),bA={extension:nA,composition:aA,aggregation:oA,dependency:sA,lollipop:lA,point:hA,circle:cA,cross:uA,barb:dA,only_one:pA,zero_or_one:fA,one_or_more:gA,zero_or_more:yA,requirement_arrow:mA,requirement_contains:xA},CA=iA,kA={common:Wr,getConfig:re,insertCluster:WT,insertEdge:rA,insertEdgeLabel:VB,insertMarkers:CA,insertNode:IB,interpolateToCurve:Sw,labelHelper:bS,log:y,positionEdgeLabel:XB},wA={},_A=s(t=>{for(let e of t)wA[e.name]=e},"registerLayoutLoaders");s(()=>{_A([{name:"dagre",loader:s(async()=>await import("./dagre-6U6BRBRP-DNm7ISCW.js"),"loader")}])},"registerDefaultLayoutLoaders")();var vA=s(async(t,e)=>{if(!(t.layoutAlgorithm in wA))throw new Error(`Unknown layout algorithm: ${t.layoutAlgorithm}`);let r=wA[t.layoutAlgorithm];return(await r.loader()).render(t,e,kA,{algorithm:r.algorithm})},"render"),SA=s((t="",{fallback:e="dagre"}={})=>{if(t in wA)return t;if(e in wA)return y.warn(`Layout algorithm ${t} is not registered. Using ${e} as fallback.`),e;throw new Error(`Both layout algorithms ${t} and ${e} are not registered.`)},"getRegisteredLayoutAlgorithm"),TA=FC(Object.keys,Object),MA=Object.prototype.hasOwnProperty;function BA(t){if(!DC(t))return TA(t);var e=[];for(var r in Object(t))MA.call(t,r)&&"constructor"!=r&&e.push(r);return e}s(BA,"baseKeys");var AA=BA,FA=Vx(ux,"DataView"),LA=Vx(ux,"Promise"),$A=Vx(ux,"Set"),EA=Vx(ux,"WeakMap"),DA="[object Map]",OA="[object Promise]",IA="[object Set]",NA="[object WeakMap]",RA="[object DataView]",PA=Ox(FA),zA=Ox(Tb),qA=Ox(LA),jA=Ox($A),WA=Ox(EA),HA=vx;(FA&&HA(new FA(new ArrayBuffer(1)))!=RA||Tb&&HA(new Tb)!=DA||LA&&HA(LA.resolve())!=OA||$A&&HA(new $A)!=IA||EA&&HA(new EA)!=NA)&&(HA=s(function(t){var e=vx(t),r="[object Object]"==e?t.constructor:void 0,i=r?Ox(r):"";if(i)switch(i){case PA:return RA;case zA:return DA;case qA:return OA;case jA:return IA;case WA:return NA}return e},"getTag"));var UA=HA,YA=Object.prototype.hasOwnProperty;function VA(t){if(null==t)return!0;if(ZC(t)&&(YC(t)||"string"==typeof t||"function"==typeof t.splice||nk(t)||wk(t)||UC(t)))return!t.length;var e=UA(t);if("[object Map]"==e||"[object Set]"==e)return!t.size;if(DC(t))return!AA(t).length;for(var r in t)if(YA.call(t,r))return!1;return!0}s(VA,"isEmpty");var GA=VA,XA=s(t=>/^\s*C4Context|C4Container|C4Component|C4Dynamic|C4Deployment/.test(t),"detector"),ZA=s(async()=>{let{diagram:t}=await import("./c4Diagram-7DG5U6WC-Bwz-3eBe.js");return{id:"c4",diagram:t}},"loader"),QA={id:"c4",detector:XA,loader:ZA},KA="flowchart",JA=s((t,e)=>"dagre-wrapper"!==e?.flowchart?.defaultRenderer&&"elk"!==e?.flowchart?.defaultRenderer&&/^\s*graph/.test(t),"detector"),tF=s(async()=>{let{diagram:t}=await import("./flowDiagram-TII6K2WN-Da6QJytK.js");return{id:KA,diagram:t}},"loader"),eF={id:KA,detector:JA,loader:tF},rF="flowchart-v2",iF=s((t,e)=>"dagre-d3"!==e?.flowchart?.defaultRenderer&&("elk"===e?.flowchart?.defaultRenderer&&(e.layout="elk"),!(!/^\s*graph/.test(t)||"dagre-wrapper"!==e?.flowchart?.defaultRenderer)||/^\s*flowchart/.test(t)),"detector"),nF=s(async()=>{let{diagram:t}=await import("./flowDiagram-TII6K2WN-Da6QJytK.js");return{id:rF,diagram:t}},"loader"),aF={id:rF,detector:iF,loader:nF},oF=s(t=>/^\s*erDiagram/.test(t),"detector"),sF=s(async()=>{let{diagram:t}=await import("./erDiagram-7EWP3MN6-DP6hvXq9.js");return{id:"er",diagram:t}},"loader"),lF={id:"er",detector:oF,loader:sF},hF="gitGraph",cF=s(t=>/^\s*gitGraph/.test(t),"detector"),uF=s(async()=>{let{diagram:t}=await import("./gitGraphDiagram-BR4W45RK-8zCVA5kZ.js");return{id:hF,diagram:t}},"loader"),dF={id:hF,detector:cF,loader:uF},pF="gantt",fF=s(t=>/^\s*gantt/.test(t),"detector"),gF=s(async()=>{let{diagram:t}=await import("./ganttDiagram-V4MQRLY5-BjKgl7xV.js");return{id:pF,diagram:t}},"loader"),yF={id:pF,detector:fF,loader:gF},mF="info",xF=s(t=>/^\s*info/.test(t),"detector"),bF=s(async()=>{let{diagram:t}=await import("./infoDiagram-5IAHN54X-Bslo4WLC.js");return{id:mF,diagram:t}},"loader"),CF={id:mF,detector:xF,loader:bF},kF=s(t=>/^\s*pie/.test(t),"detector"),wF=s(async()=>{let{diagram:t}=await import("./pieDiagram-F7MUPDZA-CGf9hk6i.js");return{id:"pie",diagram:t}},"loader"),_F={id:"pie",detector:kF,loader:wF},vF="quadrantChart",SF=s(t=>/^\s*quadrantChart/.test(t),"detector"),TF=s(async()=>{let{diagram:t}=await import("./quadrantDiagram-FAAURWXW-CYt-I1EN.js");return{id:vF,diagram:t}},"loader"),MF={id:vF,detector:SF,loader:TF},BF="xychart",AF=s(t=>/^\s*xychart-beta/.test(t),"detector"),FF=s(async()=>{let{diagram:t}=await import("./xychartDiagram-EWIAYKFP-BPuz0iWH.js");return{id:BF,diagram:t}},"loader"),LF={id:BF,detector:AF,loader:FF},$F="requirement",EF=s(t=>/^\s*requirement(Diagram)?/.test(t),"detector"),DF=s(async()=>{let{diagram:t}=await import("./requirementDiagram-JQNWQ3I6-H6mBmTSg.js");return{id:$F,diagram:t}},"loader"),OF={id:$F,detector:EF,loader:DF},IF="sequence",NF=s(t=>/^\s*sequenceDiagram/.test(t),"detector"),RF=s(async()=>{let{diagram:t}=await import("./sequenceDiagram-WYCSWKTZ-DpmzzP5a.js");return{id:IF,diagram:t}},"loader"),PF={id:IF,detector:NF,loader:RF},zF="class",qF=s((t,e)=>"dagre-wrapper"!==e?.class?.defaultRenderer&&/^\s*classDiagram/.test(t),"detector"),jF=s(async()=>{let{diagram:t}=await import("./classDiagram-JB6VT5OV-B9MhSVQt.js");return{id:zF,diagram:t}},"loader"),WF={id:zF,detector:qF,loader:jF},HF="classDiagram",UF=s((t,e)=>!(!/^\s*classDiagram/.test(t)||"dagre-wrapper"!==e?.class?.defaultRenderer)||/^\s*classDiagram-v2/.test(t),"detector"),YF=s(async()=>{let{diagram:t}=await import("./classDiagram-v2-HHH2ILUC-B9MhSVQt.js");return{id:HF,diagram:t}},"loader"),VF={id:HF,detector:UF,loader:YF},GF="state",XF=s((t,e)=>"dagre-wrapper"!==e?.state?.defaultRenderer&&/^\s*stateDiagram/.test(t),"detector"),ZF=s(async()=>{let{diagram:t}=await import("./stateDiagram-T7ICYWBR-C2utLBdW.js");return{id:GF,diagram:t}},"loader"),QF={id:GF,detector:XF,loader:ZF},KF="stateDiagram",JF=s((t,e)=>!!(/^\s*stateDiagram-v2/.test(t)||/^\s*stateDiagram/.test(t)&&"dagre-wrapper"===e?.state?.defaultRenderer),"detector"),tL=s(async()=>{let{diagram:t}=await import("./stateDiagram-v2-SPWBS5Y2-BE7IYmOw.js");return{id:KF,diagram:t}},"loader"),eL={id:KF,detector:JF,loader:tL},rL="journey",iL=s(t=>/^\s*journey/.test(t),"detector"),nL=s(async()=>{let{diagram:t}=await import("./journeyDiagram-TPMWLR2G-DxY619dD.js");return{id:rL,diagram:t}},"loader"),aL={id:rL,detector:iL,loader:nL},oL=s((t,e,r)=>{y.debug("rendering svg for syntax error\n");let i=Xf(e),n=i.append("g");i.attr("viewBox","0 0 2412 512"),Yr(i,100,512,!0),n.append("path").attr("class","error-icon").attr("d","m411.313,123.313c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32-9.375,9.375-20.688-20.688c-12.484-12.5-32.766-12.5-45.25,0l-16,16c-1.261,1.261-2.304,2.648-3.31,4.051-21.739-8.561-45.324-13.426-70.065-13.426-105.867,0-192,86.133-192,192s86.133,192 192,192 192-86.133 192-192c0-24.741-4.864-48.327-13.426-70.065 1.402-1.007 2.79-2.049 4.051-3.31l16-16c12.5-12.492 12.5-32.758 0-45.25l-20.688-20.688 9.375-9.375 32.001-31.999zm-219.313,100.687c-52.938,0-96,43.063-96,96 0,8.836-7.164,16-16,16s-16-7.164-16-16c0-70.578 57.422-128 128-128 8.836,0 16,7.164 16,16s-7.164,16-16,16z"),n.append("path").attr("class","error-icon").attr("d","m459.02,148.98c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l16,16c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16.001-16z"),n.append("path").attr("class","error-icon").attr("d","m340.395,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16-16c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l15.999,16z"),n.append("path").attr("class","error-icon").attr("d","m400,64c8.844,0 16-7.164 16-16v-32c0-8.836-7.156-16-16-16-8.844,0-16,7.164-16,16v32c0,8.836 7.156,16 16,16z"),n.append("path").attr("class","error-icon").attr("d","m496,96.586h-32c-8.844,0-16,7.164-16,16 0,8.836 7.156,16 16,16h32c8.844,0 16-7.164 16-16 0-8.836-7.156-16-16-16z"),n.append("path").attr("class","error-icon").attr("d","m436.98,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688l32-32c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32c-6.251,6.25-6.251,16.375-0.001,22.625z"),n.append("text").attr("class","error-text").attr("x",1440).attr("y",250).attr("font-size","150px").style("text-anchor","middle").text("Syntax error in text"),n.append("text").attr("class","error-text").attr("x",1250).attr("y",400).attr("font-size","100px").style("text-anchor","middle").text(`mermaid version ${r}`)},"draw"),sL={draw:oL},lL=sL,hL={db:{},renderer:sL,parser:{parse:s(()=>{},"parse")}},cL="flowchart-elk",uL=s((t,e={})=>!!(/^\s*flowchart-elk/.test(t)||/^\s*flowchart|graph/.test(t)&&"elk"===e?.flowchart?.defaultRenderer)&&(e.layout="elk",!0),"detector"),dL=s(async()=>{let{diagram:t}=await import("./flowDiagram-TII6K2WN-Da6QJytK.js");return{id:cL,diagram:t}},"loader"),pL={id:cL,detector:uL,loader:dL},fL="timeline",gL=s(t=>/^\s*timeline/.test(t),"detector"),yL=s(async()=>{let{diagram:t}=await import("./timeline-definition-S3ZD2X45-CYBDdyMa.js");return{id:fL,diagram:t}},"loader"),mL={id:fL,detector:gL,loader:yL},xL="mindmap",bL=s(t=>/^\s*mindmap/.test(t),"detector"),CL=s(async()=>{let{diagram:t}=await import("./mindmap-definition-5EMXWA7H-B1H1CjeI.js");return{id:xL,diagram:t}},"loader"),kL={id:xL,detector:bL,loader:CL},wL="kanban",_L=s(t=>/^\s*kanban/.test(t),"detector"),vL=s(async()=>{let{diagram:t}=await import("./kanban-definition-5Q5KOTBN-D_1XRxho.js");return{id:wL,diagram:t}},"loader"),SL={id:wL,detector:_L,loader:vL},TL="sankey",ML=s(t=>/^\s*sankey-beta/.test(t),"detector"),BL=s(async()=>{let{diagram:t}=await import("./sankeyDiagram-QN7AKWH4-CCWimPyt.js");return{id:TL,diagram:t}},"loader"),AL={id:TL,detector:ML,loader:BL},FL="packet",LL=s(t=>/^\s*packet(-beta)?/.test(t),"detector"),$L=s(async()=>{let{diagram:t}=await import("./diagram-N7FPYD76-VtQ5TULk.js");return{id:FL,diagram:t}},"loader"),EL={id:FL,detector:LL,loader:$L},DL="radar",OL=s(t=>/^\s*radar-beta/.test(t),"detector"),IL=s(async()=>{let{diagram:t}=await import("./diagram-Z5LGQPMA-BIE2wWFE.js");return{id:DL,diagram:t}},"loader"),NL={id:DL,detector:OL,loader:IL},RL="block",PL=s(t=>/^\s*block-beta/.test(t),"detector"),zL=s(async()=>{let{diagram:t}=await import("./blockDiagram-CF3J3ZPZ-CTAppzfM.js");return{id:RL,diagram:t}},"loader"),qL={id:RL,detector:PL,loader:zL},jL="architecture",WL=s(t=>/^\s*architecture/.test(t),"detector"),HL=s(async()=>{let{diagram:t}=await import("./architectureDiagram-KNYM2FM5-c302dij-.js");return{id:jL,diagram:t}},"loader"),UL={id:jL,detector:WL,loader:HL},YL="treemap",VL=s(t=>/^\s*treemap/.test(t),"detector"),GL=s(async()=>{let{diagram:t}=await import("./diagram-HJ6MONWM-DGmX6HOo.js");return{id:YL,diagram:t}},"loader"),XL={id:YL,detector:VL,loader:GL},ZL=!1,QL=s(()=>{ZL||(ZL=!0,bi("error",hL,t=>"error"===t.toLowerCase().trim()),bi("---",{db:{clear:s(()=>{},"clear")},styles:{},renderer:{draw:s(()=>{},"draw")},parser:{parse:s(()=>{throw new Error("Diagrams beginning with --- are not valid. If you were trying to use a YAML front-matter, please ensure that you've correctly opened and closed the YAML front-matter with un-indented `---` blocks")},"parse")},init:s(()=>null,"init")},t=>t.toLowerCase().trimStart().startsWith("---")),S(pL,kL,UL),S(QA,SL,VF,WF,lF,yF,CF,_F,OF,PF,aF,eF,mL,dF,eL,QF,aL,MF,AL,EL,LF,qL,NL,XL))},"addDiagrams"),KL=s(async()=>{y.debug("Loading registered diagrams");let t=(await Promise.allSettled(Object.entries(_).map(async([t,{detector:e,loader:r}])=>{if(r)try{Ci(t)}catch{try{let{diagram:t,id:i}=await r();bi(i,t,e)}catch(e){throw y.error(`Failed to load external diagram with key ${t}. Removing from detectors.`),delete _[t],e}}}))).filter(t=>"rejected"===t.status);if(t.length>0){y.error(`Failed to load ${t.length} external diagrams`);for(let e of t)y.error(e);throw new Error(`Failed to load ${t.length} external diagrams`)}},"loadRegisteredDiagrams"),JL="comm",t$="rule",e$="decl",r$=Math.abs,i$=String.fromCharCode;function n$(t){return t.trim()}function a$(t,e,r){return t.replace(e,r)}function o$(t,e,r){return t.indexOf(e,r)}function s$(t,e){return 0|t.charCodeAt(e)}function l$(t,e,r){return t.slice(e,r)}function h$(t){return t.length}function c$(t){return t.length}function u$(t,e){return e.push(t),t}s(n$,"trim"),s(a$,"replace"),s(o$,"indexof"),s(s$,"charat"),s(l$,"substr"),s(h$,"strlen"),s(c$,"sizeof"),s(u$,"append");var d$=1,p$=1,f$=0,g$=0,y$=0,m$="";function x$(t,e,r,i,n,a,o,s){return{value:t,root:e,parent:r,type:i,props:n,children:a,line:d$,column:p$,length:o,return:"",siblings:s}}function b$(){return y$}function C$(){return y$=g$>0?s$(m$,--g$):0,p$--,10===y$&&(p$=1,d$--),y$}function k$(){return y$=g$<f$?s$(m$,g$++):0,p$++,10===y$&&(p$=1,d$++),y$}function w$(){return s$(m$,g$)}function _$(){return g$}function v$(t,e){return l$(m$,t,e)}function S$(t){switch(t){case 0:case 9:case 10:case 13:case 32:return 5;case 33:case 43:case 44:case 47:case 62:case 64:case 126:case 59:case 123:case 125:return 4;case 58:return 3;case 34:case 39:case 40:case 91:return 2;case 41:case 93:return 1}return 0}function T$(t){return d$=p$=1,f$=h$(m$=t),g$=0,[]}function M$(t){return m$="",t}function B$(t){return n$(v$(g$-1,L$(91===t?t+2:40===t?t+1:t)))}function A$(t){for(;(y$=w$())&&y$<33;)k$();return S$(t)>2||S$(y$)>3?"":" "}function F$(t,e){for(;--e&&k$()&&!(y$<48||y$>102||y$>57&&y$<65||y$>70&&y$<97););return v$(t,_$()+(e<6&&32==w$()&&32==k$()))}function L$(t){for(;k$();)switch(y$){case t:return g$;case 34:case 39:34!==t&&39!==t&&L$(y$);break;case 40:41===t&&L$(t);break;case 92:k$()}return g$}function $$(t,e){for(;k$()&&t+y$!==57&&(t+y$!==84||47!==w$()););return"/*"+v$(e,g$-1)+"*"+i$(47===t?t:k$())}function E$(t){for(;!S$(w$());)k$();return v$(t,g$)}function D$(t){return M$(O$("",null,null,null,[""],t=T$(t),0,[0],t))}function O$(t,e,r,i,n,a,o,s,l){for(var h=0,c=0,u=o,d=0,p=0,f=0,g=1,y=1,m=1,x=0,b="",C=n,k=a,w=i,_=b;y;)switch(f=x,x=k$()){case 40:if(108!=f&&58==s$(_,u-1)){-1!=o$(_+=a$(B$(x),"&","&\f"),"&\f",r$(h?s[h-1]:0))&&(m=-1);break}case 34:case 39:case 91:_+=B$(x);break;case 9:case 10:case 13:case 32:_+=A$(f);break;case 92:_+=F$(_$()-1,7);continue;case 47:switch(w$()){case 42:case 47:u$(N$($$(k$(),_$()),e,r,l),l),(5==S$(f||1)||5==S$(w$()||1))&&h$(_)&&" "!==l$(_,-1,void 0)&&(_+=" ");break;default:_+="/"}break;case 123*g:s[h++]=h$(_)*m;case 125*g:case 59:case 0:switch(x){case 0:case 125:y=0;case 59+c:-1==m&&(_=a$(_,/\f/g,"")),p>0&&(h$(_)-u||0===g&&47===f)&&u$(p>32?R$(_+";",i,r,u-1,l):R$(a$(_," ","")+";",i,r,u-2,l),l);break;case 59:_+=";";default:if(u$(w=I$(_,e,r,h,c,n,s,b,C=[],k=[],u,a),a),123===x)if(0===c)O$(_,e,w,w,C,a,u,s,k);else{switch(d){case 99:if(110===s$(_,3))break;case 108:if(97===s$(_,2))break;default:c=0;case 100:case 109:case 115:}c?O$(t,w,w,i&&u$(I$(t,w,w,0,0,n,s,b,n,C=[],u,k),k),n,k,u,s,i?C:k):O$(_,w,w,w,[""],k,0,s,k)}}h=c=p=0,g=m=1,b=_="",u=o;break;case 58:u=1+h$(_),p=f;default:if(g<1)if(123==x)--g;else if(125==x&&0==g++&&125==C$())continue;switch(_+=i$(x),x*g){case 38:m=c>0?1:(_+="\f",-1);break;case 44:s[h++]=(h$(_)-1)*m,m=1;break;case 64:45===w$()&&(_+=B$(k$())),d=w$(),c=u=h$(b=_+=E$(_$())),x++;break;case 45:45===f&&2==h$(_)&&(g=0)}}return a}function I$(t,e,r,i,n,a,o,s,l,h,c,u){for(var d=n-1,p=0===n?a:[""],f=c$(p),g=0,y=0,m=0;g<i;++g)for(var x=0,b=l$(t,d+1,d=r$(y=o[g])),C=t;x<f;++x)(C=n$(y>0?p[x]+" "+b:a$(b,/&\f/g,p[x])))&&(l[m++]=C);return x$(t,e,r,0===n?t$:s,l,h,c,u)}function N$(t,e,r,i){return x$(t,e,r,JL,i$(b$()),l$(t,2,-2),0,i)}function R$(t,e,r,i,n){return x$(t,e,r,e$,l$(t,0,i),l$(t,i+1,-1),i,n)}function P$(t,e){for(var r="",i=0;i<t.length;i++)r+=e(t[i],i,t,e)||"";return r}function z$(t,e,r,i){switch(t.type){case"@layer":if(t.children.length)break;case"@import":case"@namespace":case e$:return t.return=t.return||t.value;case JL:return"";case"@keyframes":return t.return=t.value+"{"+P$(t.children,i)+"}";case t$:if(!h$(t.value=t.props.join(",")))return""}return h$(r=P$(t.children,i))?t.return=t.value+"{"+r+"}":""}s(x$,"node"),s(b$,"char"),s(C$,"prev"),s(k$,"next"),s(w$,"peek"),s(_$,"caret"),s(v$,"slice"),s(S$,"token"),s(T$,"alloc"),s(M$,"dealloc"),s(B$,"delimit"),s(A$,"whitespace"),s(F$,"escaping"),s(L$,"delimiter"),s($$,"commenter"),s(E$,"identifier"),s(D$,"compile"),s(O$,"parse"),s(I$,"ruleset"),s(N$,"comment"),s(R$,"declaration"),s(P$,"serialize"),s(z$,"stringify");function q$(t,e){t.attr("role","graphics-document document"),""!==e&&t.attr("aria-roledescription",e)}function j$(t,e,r,i){if(void 0!==t.insert){if(r){let e=`chart-desc-${i}`;t.attr("aria-describedby",e),t.insert("desc",":first-child").attr("id",e).text(r)}if(e){let r=`chart-title-${i}`;t.attr("aria-labelledby",r),t.insert("title",":first-child").attr("id",r).text(e)}}}s(q$,"setA11yDiagramInfo"),s(j$,"addSVGa11yTitleDescription");var W$=class t{constructor(t,e,r,i,n){this.type=t,this.text=e,this.db=r,this.parser=i,this.renderer=n}static{s(this,"Diagram")}static async fromText(e,r={}){let i=re(),n=v(e,i);e=e_(e)+"\n";try{Ci(n)}catch{let t=M(n);if(!t)throw new w(`Diagram ${n} not found.`);let{id:e,diagram:r}=await t();bi(e,r)}let{db:a,parser:o,renderer:s,init:l}=Ci(n);return o.parser&&(o.parser.yy=a),a.clear?.(),l?.(i),r.title&&a.setDiagramTitle?.(r.title),await o.parse(e),new t(n,e,a,o,s)}async render(t,e){await this.renderer.draw(this.text,t,e,this)}getParser(){return this.parser}getType(){return this.type}},H$=[],U$=s(()=>{H$.forEach(t=>{t()}),H$=[]},"attachFunctions"),Y$=s(t=>t.replace(/^\s*%%(?!{)[^\n]+\n?/gm,"").trimStart(),"cleanupComments");function V$(t){let e=t.match(b);if(!e)return{text:t,metadata:{}};let r=Xm(e[1],{schema:Gm})??{};r="object"!=typeof r||Array.isArray(r)?{}:r;let i={};return r.displayMode&&(i.displayMode=r.displayMode.toString()),r.title&&(i.title=r.title.toString()),r.config&&(i.config=r.config),{text:t.slice(e[0].length),metadata:i}}s(V$,"extractFrontMatter");var G$=s(t=>t.replace(/\r\n?/g,"\n").replace(/<(\w+)([^>]*)>/g,(t,e,r)=>"<"+e+r.replace(/="([^"]*)"/g,"='$1'")+">"),"cleanupText"),X$=s(t=>{let{text:e,metadata:r}=V$(t),{displayMode:i,title:n,config:a={}}=r;return i&&(a.gantt||(a.gantt={}),a.gantt.displayMode=i),{title:n,config:a,text:e}},"processFrontmatter"),Z$=s(t=>{let e=t_.detectInit(t)??{},r=t_.detectDirective(t,"wrap");return Array.isArray(r)?e.wrap=r.some(({type:t})=>"wrap"===t):"wrap"===r?.type&&(e.wrap=!0),{text:_w(t),directive:e}},"processDirectives");function Q$(t){let e=G$(t),r=X$(e),i=Z$(r.text),n=Jw(r.config,i.directive);return{code:t=Y$(i.text),title:r.title,config:n}}function K$(t){let e=(new TextEncoder).encode(t),r=Array.from(e,t=>String.fromCodePoint(t)).join("");return btoa(r)}s(Q$,"preprocessDiagram"),s(K$,"toBase64");var J$=["foreignobject"],tE=["dominant-baseline"];function eE(t){let e=Q$(t);return ae(),ne(e.config??{}),e}async function rE(t,e){QL();try{let{code:e,config:r}=eE(t);return{diagramType:(await pE(e)).type,config:r}}catch(t){if(e?.suppressErrors)return!1;throw t}}s(eE,"processAndSetConfigs"),s(rE,"parse");var iE=s((t,e,r=[])=>`\n.${t} ${e} { ${r.join(" !important; ")} !important; }`,"cssImportantStyles"),nE=s((t,e=new Map)=>{let r="";if(void 0!==t.themeCSS&&(r+=`\n${t.themeCSS}`),void 0!==t.fontFamily&&(r+=`\n:root { --mermaid-font-family: ${t.fontFamily}}`),void 0!==t.altFontFamily&&(r+=`\n:root { --mermaid-alt-font-family: ${t.altFontFamily}}`),e instanceof Map){let i=t.htmlLabels??t.flowchart?.htmlLabels?["> *","span"]:["rect","polygon","ellipse","circle","path"];e.forEach(t=>{GA(t.styles)||i.forEach(e=>{r+=iE(t.id,e,t.styles)}),GA(t.textStyles)||(r+=iE(t.id,"tspan",(t?.textStyles||[]).map(t=>t.replace("color","fill"))))})}return r},"createCssStyles"),aE=s((t,e,r,i)=>{let n=nE(t,r);return P$(D$(`${i}{${Qr(e,n,t.themeVariables)}}`),z$)},"createUserStyles"),oE=s((t="",e,r)=>{let i=t;return!r&&!e&&(i=i.replace(/marker-end="url\([\d+./:=?A-Za-z-]*?#/g,'marker-end="url(#')),i=r_(i),i=i.replace(/<br>/g,"<br/>"),i},"cleanUpSvgCode"),sE=s((t="",e)=>`<iframe style="width:100%;height:${e?.viewBox?.baseVal?.height?e.viewBox.baseVal.height+"px":"100%"};border:0;margin:0;" src="data:text/html;charset=UTF-8;base64,${K$(`<body style="margin:0">${t}</body>`)}" sandbox="allow-top-navigation-by-user-activation allow-popups">\n  The "iframe" tag is not supported by your browser.\n</iframe>`,"putIntoIFrame"),lE=s((t,e,r,i,n)=>{let a=t.append("div");a.attr("id",r),i&&a.attr("style",i);let o=a.append("svg").attr("id",e).attr("width","100%").attr("xmlns","http://www.w3.org/2000/svg");return n&&o.attr("xmlns:xlink",n),o.append("g"),t},"appendDivSvgG");function hE(t,e){return t.append("iframe").attr("id",e).attr("style","width: 100%; height: 100%;").attr("sandbox","")}s(hE,"sandboxedIframe");var cE=s((t,e,r,i)=>{t.getElementById(e)?.remove(),t.getElementById(r)?.remove(),t.getElementById(i)?.remove()},"removeExistingElements"),uE=s(async function(e,r,i){QL();let n=eE(r);r=n.code;let a=re();y.debug(a),r.length>(a?.maxTextSize??5e4)&&(r="graph TB;a[Maximum text size in diagram exceeded];style a fill:#faa");let o,l,h="#"+e,c="i"+e,u="#"+c,d="d"+e,p="#"+d,f=s(()=>{let t=ro(m?u:p).node();t&&"remove"in t&&t.remove()},"removeTempElements"),g=ro("body"),m="sandbox"===a.securityLevel,x="loose"===a.securityLevel,b=a.fontFamily;if(void 0!==i){if(i&&(i.innerHTML=""),m){let t=hE(ro(i),c);g=ro(t.nodes()[0].contentDocument.body),g.node().style.margin=0}else g=ro(i);lE(g,e,d,`font-family: ${b}`,"http://www.w3.org/1999/xlink")}else{if(cE(document,e,d,c),m){let t=hE(ro("body"),c);g=ro(t.nodes()[0].contentDocument.body),g.node().style.margin=0}else g=ro("body");lE(g,e,d)}try{o=await W$.fromText(r,{title:n.title})}catch(t){if(a.suppressErrorRendering)throw f(),t;o=await W$.fromText("error"),l=t}let C=g.select(p).node(),k=o.type,w=C.firstChild,_=w.firstChild,v=o.renderer.getClasses?.(r,o),S=aE(a,k,v,h),T=document.createElement("style");T.innerHTML=S,w.insertBefore(T,_);try{await o.renderer.draw(r,e,t.version,o)}catch(i){throw a.suppressErrorRendering?f():lL.draw(r,e,t.version),i}let M=g.select(`${p} svg`),B=o.db.getAccTitle?.(),A=o.db.getAccDescription?.();fE(k,M,B,A),g.select(`[id="${e}"]`).selectAll("foreignobject > *").attr("xmlns","http://www.w3.org/1999/xhtml");let F=g.select(p).node().innerHTML;if(y.debug("config.arrowMarkerAbsolute",a.arrowMarkerAbsolute),F=oE(F,m,Lr(a.arrowMarkerAbsolute)),m){let t=g.select(p+" svg").node();F=sE(F,t)}else x||(F=mr.sanitize(F,{ADD_TAGS:J$,ADD_ATTR:tE,HTML_INTEGRATION_POINTS:{foreignobject:!0}}));if(U$(),l)throw l;return f(),{diagramType:k,svg:F,bindFunctions:o.db.bindFunctions}},"render");function dE(t={}){let e=A({},t);e?.fontFamily&&!e.themeVariables?.fontFamily&&(e.themeVariables||(e.themeVariables={}),e.themeVariables.fontFamily=e.fontFamily),Kt(e),e?.theme&&e.theme in Rt?e.themeVariables=Rt[e.theme].getThemeVariables(e.themeVariables):e&&(e.themeVariables=Rt.default.getThemeVariables(e.themeVariables));let r="object"==typeof e?Qt(e):te();m(r.logLevel),QL()}s(dE,"initialize");var pE=s((t,e={})=>{let{code:r}=Q$(t);return W$.fromText(r,e)},"getDiagramFromText");function fE(t,e,r,i){q$(e,t),j$(e,r,i,e.attr("id"))}s(fE,"addA11yInfo");var gE=Object.freeze({render:uE,parse:rE,getDiagramFromText:pE,initialize:dE,getConfig:re,setConfig:ee,getSiteConfig:te,updateSiteConfig:Jt,reset:s(()=>{ae()},"reset"),globalReset:s(()=>{ae(Yt)},"globalReset"),defaultConfig:Yt});m(re().logLevel),ae(re());var yE=s((t,e,r)=>{y.warn(t),Zw(t)?(r&&r(t.str,t.hash),e.push({...t,message:t.str,error:t})):(r&&r(t),t instanceof Error&&e.push({str:t.message,message:t.message,hash:t.name,error:t}))},"handleError"),mE=s(async function(t={querySelector:".mermaid"}){try{await xE(t)}catch(e){if(Zw(e)&&y.error(e.str),FE.parseError&&FE.parseError(e),!t.suppressErrors)throw y.error("Use the suppressErrors option to suppress these errors"),e}},"run"),xE=s(async function({postRenderCallback:t,querySelector:e,nodes:r}={querySelector:".mermaid"}){let i,n=gE.getConfig();if(y.debug((t?"":"No ")+"Callback function found"),r)i=r;else{if(!e)throw new Error("Nodes and querySelector are both undefined");i=document.querySelectorAll(e)}y.debug(`Found ${i.length} diagrams`),void 0!==n?.startOnLoad&&(y.debug("Start On Load: "+n?.startOnLoad),gE.updateSiteConfig({startOnLoad:n?.startOnLoad}));let a,o=new t_.InitIDGenerator(n.deterministicIds,n.deterministicIDSeed),s=[];for(let e of Array.from(i)){if(y.info("Rendering diagram: "+e.id),e.getAttribute("data-processed"))continue;e.setAttribute("data-processed","true");let r=`mermaid-${o.next()}`;a=e.innerHTML,a=q_(t_.entityDecode(a)).trim().replace(/<br\s*\/?>/gi,"<br/>");let i=t_.detectInit(a);i&&y.debug("Detected early reinit: ",i);try{let{svg:i,bindFunctions:n}=await BE(r,a,e);e.innerHTML=i,t&&await t(r),n&&n(e)}catch(t){yE(t,s,FE.parseError)}}if(s.length>0)throw s[0]},"runThrowsErrors"),bE=s(function(t){gE.initialize(t)},"initialize"),CE=s(async function(t,e,r){y.warn("mermaid.init is deprecated. Please use run instead."),t&&bE(t);let i={postRenderCallback:r,querySelector:".mermaid"};"string"==typeof e?i.querySelector=e:e&&(e instanceof HTMLElement?i.nodes=[e]:i.nodes=e),await mE(i)},"init"),kE=s(async(t,{lazyLoad:e=!0}={})=>{QL(),S(...t),!1===e&&await KL()},"registerExternalDiagrams"),wE=s(function(){if(FE.startOnLoad){let{startOnLoad:t}=gE.getConfig();t&&FE.run().catch(t=>y.error("Mermaid failed to initialize",t))}},"contentLoaded");typeof document<"u"&&window.addEventListener("load",wE,!1);var _E=s(function(t){FE.parseError=t},"setParseErrorHandler"),vE=[],SE=!1,TE=s(async()=>{if(!SE){for(SE=!0;vE.length>0;){let t=vE.shift();if(t)try{await t()}catch(t){y.error("Error executing queue",t)}}SE=!1}},"executeQueue"),ME=s(async(t,e)=>new Promise((r,i)=>{let n=s(()=>new Promise((n,a)=>{gE.parse(t,e).then(t=>{n(t),r(t)},t=>{y.error("Error parsing",t),FE.parseError?.(t),a(t),i(t)})}),"performCall");vE.push(n),TE().catch(i)}),"parse"),BE=s((t,e,r)=>new Promise((i,n)=>{let a=s(()=>new Promise((a,o)=>{gE.render(t,e,r).then(t=>{a(t),i(t)},t=>{y.error("Error parsing",t),FE.parseError?.(t),o(t),n(t)})}),"performCall");vE.push(a),TE().catch(n)}),"render"),AE=s(()=>Object.keys(_).map(t=>({id:t})),"getRegisteredDiagramsMetadata"),FE={startOnLoad:!0,mermaidAPI:gE,parse:ME,render:BE,init:CE,run:mE,registerExternalDiagrams:kE,registerLayoutLoaders:_A,initialize:bE,parseError:void 0,contentLoaded:wE,setParseErrorHandler:_E,detectType:v,registerIconPacks:N_,getRegisteredDiagramsMetadata:AE},LE=FE;/*! Check if previously processed */
/*!
 * Wait for document loaded before starting the execution
 */export{jw as $,gs as A,Vh as B,tn as C,vr as D,Eh as E,xh as F,vh as G,_h as H,t_ as I,hi as J,si as K,Jw as L,A as M,wh as N,re as O,kh as P,li as Q,Ch as R,vA as S,bh as T,fh as U,SA as V,Hw as W,ni as X,Yr as Y,oi as Z,dh as _,Uw as a,cw as a$,ch as a0,hh as a1,lh as a2,Ji as a3,p as a4,l as a5,Xf as a6,t as a7,Kw as a8,Zu as a9,Lr as aA,tx as aB,mS as aC,r_ as aD,Ow as aE,z_ as aF,N_ as aG,D_ as aH,el as aI,Sl as aJ,ql as aK,ax as aL,nx as aM,CA as aN,RB as aO,UB as aP,HT as aQ,kS as aR,NB as aS,VB as aT,rA as aU,XB as aV,yw as aW,Yb as aX,YC as aY,Bx as aZ,GA as a_,Hl as aa,ad as ab,Et as ac,mu as ad,fS as ae,rd as af,qr as ag,zr as ah,xw as ai,Fr as aj,jr as ak,Dr as al,ud as am,Nw as an,xr as ao,Vr as ap,dt as aq,yt as ar,xt as as,Kr as at,xS as au,WT as av,IB as aw,PB as ax,bu as ay,Jm as az,Wr as b,Nk as b0,AA as b1,ZC as b2,Kk as b3,Tx as b4,SC as b5,UA as b6,nk as b7,xC as b8,IC as b9,lC as bA,dC as bB,lw as bC,iw as bD,u as bE,LE as bF,nC as ba,yk as bb,Hk as bc,Mk as bd,$A as be,jb as bf,Ak as bg,_C as bh,kC as bi,Ck as bj,RC as bk,LC as bl,dx as bm,vx as bn,GC as bo,Dk as bp,UC as bq,wk as br,db as bs,bC as bt,Hb as bu,fw as bv,DC as bw,dw as bx,KC as by,ux as bz,Gm as c,pi as d,DB as e,lx as f,Xm as g,di as h,i_ as i,ai as j,ro as k,ii as l,s as m,ot as n,h as o,fi as p,d as q,yi as r,nt as s,y as t,Wt as u,yu as v,Pw as w,_i as x,wi as y,nh as z};
//# sourceMappingURL=index-Bd_j0xvv.js.map
