"""Generated by Django 4.1.5 on 2023-01-11 08:12."""

from django.db import migrations


def rename_search_timestamp(apps, _schema_editor):
    """Rename the search_index_uuid timestamp to its new name."""
    ts_model = apps.get_model("codex", "timestamp")
    ts_model.objects.filter(name="xapian_index_uuid").update(name="search_index_uuid")


class Migration(migrations.Migration):
    """Run migrations."""

    dependencies = [
        ("codex", "0019_delete_queuejob"),
    ]

    operations = [
        migrations.RunPython(rename_search_timestamp),
        migrations.AlterUniqueTogether(
            name="searchresult",
            unique_together=None,
        ),
        migrations.RemoveField(
            model_name="searchresult",
            name="comic",
        ),
        migrations.RemoveField(
            model_name="searchresult",
            name="query",
        ),
        migrations.DeleteModel(
            name="SearchQuery",
        ),
        migrations.DeleteModel(
            name="SearchResult",
        ),
        migrations.AlterModelOptions(
            name="librarianstatus",
            options={"verbose_name_plural": "LibrarianStatuses"},
        ),
        migrations.AlterModelOptions(
            name="library",
            options={"verbose_name_plural": "Libraries"},
        ),
    ]
