# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: create_workflow_run.sql
import dataclasses
from typing import Any, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


CREATE_WORKFLOW_RUN = """-- name: create_workflow_run \\:one
SELECT result FROM trigger_workflow_run(
    :p1\\:\\:UUID, 
    :p2, 
    :p3\\:\\:JSON, 
    :p4, 
    :p5, 
    :p6
) AS result
"""


@dataclasses.dataclass()
class CreateWorkflowRunParams:
    workflow_run_id: uuid.UUID
    workflow_name: str
    args: Any
    queue: str
    timeout_seconds: int
    idempotency_key: str


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def create_workflow_run(self, arg: CreateWorkflowRunParams) -> Optional[Optional[Any]]:
        row = self._conn.execute(sqlalchemy.text(CREATE_WORKFLOW_RUN), {
            "p1": arg.workflow_run_id,
            "p2": arg.workflow_name,
            "p3": arg.args,
            "p4": arg.queue,
            "p5": arg.timeout_seconds,
            "p6": arg.idempotency_key,
        }).first()
        if row is None:
            return None
        return row[0]


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def create_workflow_run(self, arg: CreateWorkflowRunParams) -> Optional[Optional[Any]]:
        row = (await self._conn.execute(sqlalchemy.text(CREATE_WORKFLOW_RUN), {
            "p1": arg.workflow_run_id,
            "p2": arg.workflow_name,
            "p3": arg.args,
            "p4": arg.queue,
            "p5": arg.timeout_seconds,
            "p6": arg.idempotency_key,
        })).first()
        if row is None:
            return None
        return row[0]
