# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: disconnect_executor.sql
import dataclasses
from typing import Any, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


DISCONNECT_EXECUTOR = """-- name: disconnect_executor \\:exec
UPDATE hyrex_executor
SET stopped        = CURRENT_TIMESTAMP,
    last_heartbeat = CURRENT_TIMESTAMP,
    stats          = :p1,
    status         = 'SHUTDOWN'\\:\\:executor_status
WHERE id = :p2
"""


@dataclasses.dataclass()
class DisconnectExecutorParams:
    stats: Optional[Any]
    id: uuid.UUID


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def disconnect_executor(self, arg: DisconnectExecutorParams) -> None:
        self._conn.execute(sqlalchemy.text(DISCONNECT_EXECUTOR), {"p1": arg.stats, "p2": arg.id})


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def disconnect_executor(self, arg: DisconnectExecutorParams) -> None:
        await self._conn.execute(sqlalchemy.text(DISCONNECT_EXECUTOR), {"p1": arg.stats, "p2": arg.id})
