# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_project_stats.sql
import dataclasses
import datetime
from typing import AsyncIterator, Iterator, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_PROJECT_STATS = """-- name: get_project_stats \\:many
SELECT 
    timepoint,
    queued,
    running,
    waiting,
    failed,
    success,
    lost,
    queued + running + waiting + failed + lost as total,
    queued_delta,
    success_delta,
    failed_delta,
    lost_delta
FROM hyrex_stats_task_status_counts
WHERE timepoint >= NOW() - make_interval(mins => :p1\\:\\:int)
ORDER BY timepoint DESC
"""


@dataclasses.dataclass()
class GetProjectStatsParams:
    minutes: int


@dataclasses.dataclass()
class GetProjectStatsRow:
    timepoint: datetime.datetime
    queued: Optional[int]
    running: Optional[int]
    waiting: Optional[int]
    failed: Optional[int]
    success: Optional[int]
    lost: Optional[int]
    total: int
    queued_delta: Optional[int]
    success_delta: Optional[int]
    failed_delta: Optional[int]
    lost_delta: Optional[int]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_project_stats(self, arg: GetProjectStatsParams) -> Iterator[GetProjectStatsRow]:
        result = self._conn.execute(sqlalchemy.text(GET_PROJECT_STATS), {"p1": arg.minutes})
        for row in result:
            yield GetProjectStatsRow(
                timepoint=row[0],
                queued=row[1],
                running=row[2],
                waiting=row[3],
                failed=row[4],
                success=row[5],
                lost=row[6],
                total=row[7],
                queued_delta=row[8],
                success_delta=row[9],
                failed_delta=row[10],
                lost_delta=row[11],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_project_stats(self, arg: GetProjectStatsParams) -> AsyncIterator[GetProjectStatsRow]:
        result = await self._conn.stream(sqlalchemy.text(GET_PROJECT_STATS), {"p1": arg.minutes})
        async for row in result:
            yield GetProjectStatsRow(
                timepoint=row[0],
                queued=row[1],
                running=row[2],
                waiting=row[3],
                failed=row[4],
                success=row[5],
                lost=row[6],
                total=row[7],
                queued_delta=row[8],
                success_delta=row[9],
                failed_delta=row[10],
                lost_delta=row[11],
            )
