# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_task_by_name.sql
import dataclasses
import datetime
from typing import Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_TASK_BY_NAME = """-- name: get_task_by_name \\:one
SELECT 
    task_name,
    cron_expr,
    source_code,
    last_updated
FROM hyrex_task_def
WHERE task_name = :p1
"""


@dataclasses.dataclass()
class GetTaskByNameParams:
    task_name: str


@dataclasses.dataclass()
class GetTaskByNameRow:
    task_name: str
    cron_expr: Optional[str]
    source_code: Optional[str]
    last_updated: Optional[datetime.datetime]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_task_by_name(self, arg: GetTaskByNameParams) -> Optional[GetTaskByNameRow]:
        row = self._conn.execute(sqlalchemy.text(GET_TASK_BY_NAME), {"p1": arg.task_name}).first()
        if row is None:
            return None
        return GetTaskByNameRow(
            task_name=row[0],
            cron_expr=row[1],
            source_code=row[2],
            last_updated=row[3],
        )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_task_by_name(self, arg: GetTaskByNameParams) -> Optional[GetTaskByNameRow]:
        row = (await self._conn.execute(sqlalchemy.text(GET_TASK_BY_NAME), {"p1": arg.task_name})).first()
        if row is None:
            return None
        return GetTaskByNameRow(
            task_name=row[0],
            cron_expr=row[1],
            source_code=row[2],
            last_updated=row[3],
        )
