# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_workflow_by_name.sql
import dataclasses
from typing import Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_WORKFLOW_BY_NAME = """-- name: get_workflow_by_name \\:one
SELECT 
    workflow_name,
    cron_expr,
    source_code,
    dag_structure,
    last_updated
FROM hyrex_workflow
WHERE workflow_name = :p1
"""


@dataclasses.dataclass()
class GetWorkflowByNameParams:
    workflow_name: str


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_workflow_by_name(self, arg: GetWorkflowByNameParams) -> Optional[models.HyrexWorkflow]:
        row = self._conn.execute(sqlalchemy.text(GET_WORKFLOW_BY_NAME), {"p1": arg.workflow_name}).first()
        if row is None:
            return None
        return models.HyrexWorkflow(
            workflow_name=row[0],
            cron_expr=row[1],
            source_code=row[2],
            dag_structure=row[3],
            last_updated=row[4],
        )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_workflow_by_name(self, arg: GetWorkflowByNameParams) -> Optional[models.HyrexWorkflow]:
        row = (await self._conn.execute(sqlalchemy.text(GET_WORKFLOW_BY_NAME), {"p1": arg.workflow_name})).first()
        if row is None:
            return None
        return models.HyrexWorkflow(
            workflow_name=row[0],
            cron_expr=row[1],
            source_code=row[2],
            dag_structure=row[3],
            last_updated=row[4],
        )
