# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_workflow_runs_paginated.sql
import dataclasses
import datetime
from typing import Any, AsyncIterator, Iterator, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_WORKFLOW_RUNS_PAGINATED = """-- name: get_workflow_runs_paginated \\:many
SELECT 
    ROW_NUMBER() OVER (ORDER BY queued DESC) as row_number,
    id,
    parent_id,
    workflow_name,
    args,
    queue,
    timeout_seconds,
    status,
    scheduled_start,
    queued,
    started,
    finished,
    last_heartbeat,
    idempotency_key
FROM hyrex_workflow_run
ORDER BY queued DESC
LIMIT :p1 OFFSET :p2
"""


@dataclasses.dataclass()
class GetWorkflowRunsPaginatedParams:
    limit: int
    offset: int


@dataclasses.dataclass()
class GetWorkflowRunsPaginatedRow:
    row_number: int
    id: uuid.UUID
    parent_id: Optional[uuid.UUID]
    workflow_name: str
    args: Any
    queue: str
    timeout_seconds: Optional[int]
    status: Any
    scheduled_start: Optional[datetime.datetime]
    queued: Optional[datetime.datetime]
    started: Optional[datetime.datetime]
    finished: Optional[datetime.datetime]
    last_heartbeat: Optional[datetime.datetime]
    idempotency_key: Optional[str]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_workflow_runs_paginated(self, arg: GetWorkflowRunsPaginatedParams) -> Iterator[GetWorkflowRunsPaginatedRow]:
        result = self._conn.execute(sqlalchemy.text(GET_WORKFLOW_RUNS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        for row in result:
            yield GetWorkflowRunsPaginatedRow(
                row_number=row[0],
                id=row[1],
                parent_id=row[2],
                workflow_name=row[3],
                args=row[4],
                queue=row[5],
                timeout_seconds=row[6],
                status=row[7],
                scheduled_start=row[8],
                queued=row[9],
                started=row[10],
                finished=row[11],
                last_heartbeat=row[12],
                idempotency_key=row[13],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_workflow_runs_paginated(self, arg: GetWorkflowRunsPaginatedParams) -> AsyncIterator[GetWorkflowRunsPaginatedRow]:
        result = await self._conn.stream(sqlalchemy.text(GET_WORKFLOW_RUNS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        async for row in result:
            yield GetWorkflowRunsPaginatedRow(
                row_number=row[0],
                id=row[1],
                parent_id=row[2],
                workflow_name=row[3],
                args=row[4],
                queue=row[5],
                timeout_seconds=row[6],
                status=row[7],
                scheduled_start=row[8],
                queued=row[9],
                started=row[10],
                finished=row[11],
                last_heartbeat=row[12],
                idempotency_key=row[13],
            )
