# Token Storage Migration - Complete Checklist

**Date:** 2024  
**Status:** Pre-Implementation Checklist

---

## Pre-Migration Checklist

### Domain Configuration ⚠️ CRITICAL

- [ ] **Determine domain strategy**
  - [ ] Option 1: Same domain (recommended)
  - [ ] Option 2: Subdomain cookies
  - [ ] Option 3: Next.js API proxy

- [ ] **Verify domain setup**
  - [ ] Test cookie setting in chosen solution
  - [ ] Test cookie reading in chosen solution
  - [ ] Verify CORS configuration
  - [ ] Test in all browsers

- [ ] **Document domain configuration**
  - [ ] Document chosen approach
  - [ ] Document domain settings
  - [ ] Document CORS settings

### Infrastructure

- [ ] **CORS Configuration**
  - [ ] `allow_credentials=True` ✅ (already done)
  - [ ] Allowed origins configured
  - [ ] Headers configured

- [ ] **Environment Variables**
  - [ ] Frontend URL configured
  - [ ] Backend URL configured
  - [ ] Domain settings configured

### Code Preparation

- [ ] **Review current implementation**
  - [ ] Understand OAuth flow
  - [ ] Understand token refresh flow
  - [ ] Understand middleware logic

- [ ] **Create feature flags**
  - [ ] Cookie-based auth flag
  - [ ] Fallback to header flag

---

## Phase 0: Domain Verification

- [ ] Create `api/utils/domain_config.py`
- [ ] Implement `get_cookie_domain()`
- [ ] Implement `should_use_subdomain_cookies()`
- [ ] Write domain verification tests
- [ ] Test cookie setting/reading
- [ ] Verify CORS works
- [ ] Test in all browsers
- [ ] Document domain configuration

---

## Phase 1: Cookie Utilities

- [ ] Create `api/utils/cookies.py`
- [ ] Implement `set_auth_cookie()`
- [ ] Implement `clear_auth_cookie()`
- [ ] Implement `get_auth_token_from_cookie()`
- [ ] Implement `validate_token_size()`
- [ ] Add domain support
- [ ] Write unit tests
- [ ] Test token size validation
- [ ] Test cookie setting
- [ ] Test cookie clearing

---

## Phase 2: Update Middleware

- [ ] Update `api/middleware/auth.py`
- [ ] Add cookie reading logic
- [ ] Update `_extract_jwt_user()` to accept direct token
- [ ] Update `dispatch()` to check cookies first
- [ ] Add fallback to header
- [ ] Add error handling
- [ ] Add logging
- [ ] Write unit tests
- [ ] Test cookie reading
- [ ] Test header fallback
- [ ] Test error cases

---

## Phase 3: Update OAuth Callbacks

- [ ] Update `api/auth/oauth.py`
- [ ] Set cookie instead of URL token
- [ ] Remove token from redirect URL
- [ ] Update `api/routers/v1/oauth.py`
- [ ] Test OAuth flow end-to-end
- [ ] Verify cookie is set
- [ ] Verify redirect works
- [ ] Test in all browsers

---

## Phase 4: Update Token Refresh

- [ ] Update `api/routers/v1/auth.py`
- [ ] Set cookie instead of returning token
- [ ] Update response model
- [ ] Add error handling
- [ ] Test token refresh flow
- [ ] Verify cookie is updated
- [ ] Test backward compatibility

---

## Phase 5: Add Logout Endpoint

- [ ] Create `/v1/auth/logout` endpoint
- [ ] Clear authentication cookie
- [ ] Add audit logging
- [ ] Test logout flow
- [ ] Verify cookie is cleared
- [ ] Test in different browsers

---

## Phase 6: Update Dependencies

- [ ] Update `api/dependencies/auth.py`
- [ ] Add cookie support to `get_current_user()`
- [ ] Ensure backward compatibility
- [ ] Test with cookies
- [ ] Test with headers
- [ ] Test with API keys

---

## Phase 7: Testing

### Unit Tests

- [ ] Cookie utilities tests
- [ ] Middleware tests
- [ ] OAuth callback tests
- [ ] Token refresh tests
- [ ] Logout tests
- [ ] Dependency tests

### Integration Tests

- [ ] OAuth flow with cookies
- [ ] Token refresh with cookies
- [ ] Logout with cookies
- [ ] Cookie fallback to header
- [ ] Multi-tab scenarios

### E2E Tests

- [ ] Complete auth flow
- [ ] Token refresh flow
- [ ] Logout flow
- [ ] Error handling
- [ ] Browser compatibility

### Browser Testing

- [ ] Chrome
- [ ] Firefox
- [ ] Safari
- [ ] Edge
- [ ] Mobile browsers

---

## Phase 8: Documentation

- [ ] Update API documentation
- [ ] Update OpenAPI spec
- [ ] Update migration guide
- [ ] Update developer docs
- [ ] Create troubleshooting guide

---

## Phase 9: Deployment

### Staging

- [ ] Deploy to staging
- [ ] Test in staging
- [ ] Monitor error rates
- [ ] Monitor cookie acceptance
- [ ] Verify functionality

### Production

- [ ] Enable feature flag
- [ ] Gradual rollout
- [ ] Monitor metrics
- [ ] Monitor error rates
- [ ] User feedback

---

## Phase 10: Post-Deployment

### Monitoring

- [ ] Cookie acceptance rate
- [ ] Token refresh success rate
- [ ] Error rates
- [ ] Performance metrics
- [ ] User sessions

### Optimization

- [ ] Token size monitoring
- [ ] Cookie performance
- [ ] Database queries
- [ ] Cache usage

---

## Phase 2: Refresh Token Pattern (Future)

### Database

- [ ] Create refresh_tokens collection
- [ ] Create indexes
- [ ] Write migration script

### Models

- [ ] Create RefreshToken model
- [ ] Implement token creation
- [ ] Implement token validation
- [ ] Implement token rotation

### Endpoints

- [ ] Update refresh endpoint
- [ ] Add token rotation
- [ ] Add token revocation
- [ ] Update logout endpoint

### Testing

- [ ] Refresh token tests
- [ ] Token rotation tests
- [ ] Token revocation tests
- [ ] Integration tests

---

## Risk Mitigation

### High Risk Items

- [ ] **Domain Configuration** ⚠️⚠️⚠️
  - [ ] Verify before migration
  - [ ] Test thoroughly
  - [ ] Have rollback plan

- [ ] **Cookie Size** ⚠️
  - [ ] Monitor token size
  - [ ] Add validation
  - [ ] Have fallback plan

- [ ] **Safari Compatibility** ⚠️
  - [ ] Test in Safari
  - [ ] Monitor acceptance
  - [ ] Have fallback plan

### Medium Risk Items

- [ ] **Token Refresh** ⚠️
  - [ ] Test thoroughly
  - [ ] Monitor success rate
  - [ ] Have rollback plan

- [ ] **Multi-Tab Scenarios** ⚠️
  - [ ] Test thoroughly
  - [ ] Monitor behavior
  - [ ] Have fallback plan

---

## Success Criteria

### Phase 1 Complete

- [ ] All cookies set correctly
- [ ] All cookies read correctly
- [ ] Backward compatibility maintained
- [ ] All tests passing
- [ ] No increase in error rates

### Phase 2 Complete (Future)

- [ ] Refresh tokens implemented
- [ ] Token rotation working
- [ ] Token revocation working
- [ ] All tests passing
- [ ] Performance acceptable

---

## Rollback Plan

### Quick Rollback

- [ ] Feature flag to disable cookies
- [ ] Revert to header-based auth
- [ ] Clear cookies if needed
- [ ] Monitor for issues

### Full Rollback

- [ ] Revert code changes
- [ ] Deploy previous version
- [ ] Clear cookies
- [ ] Monitor for issues

---

## Notes

- Domain configuration is **CRITICAL** - verify before migration
- Test thoroughly in all browsers
- Monitor metrics closely after deployment
- Have rollback plan ready
- Refresh token pattern can be added later

---

**Last Updated:** 2024  
**Status:** Ready for Review

