"""Constants for MCP server configuration."""

MAX_REQUEST_SIZE_BYTES = 10 * 1024 * 1024
GLOBAL_TOOL_TIMEOUT_SECONDS = 300.0
MAX_RATE_LIMIT_CALLS = 100
RATE_LIMIT_WINDOW_SECONDS = 60
MAX_CONCURRENT_TOOLS = 5
REQUEST_DEDUPLICATION_TTL_SECONDS = 60
MAX_REQUEST_ID_LENGTH = 100
MAX_CACHE_SIZE = 10000
RATE_LIMITER_CLEANUP_THRESHOLD = 100
RATE_LIMITER_MAX_IDENTIFIERS = 10000
CONCURRENT_LIMITER_TIMEOUT_SECONDS = 0.1
MONGODB_CIRCUIT_BREAKER_FAILURE_THRESHOLD = 5
MONGODB_CIRCUIT_BREAKER_RECOVERY_TIMEOUT_SECONDS = 60
MONGODB_HEALTH_CHECK_TIMEOUT_SECONDS = 2.0
MONGODB_PING_TIMEOUT_SECONDS = 5.0
MONGODB_MAX_RETRIES = 3
MONGODB_RETRY_DELAY_SECONDS = 1.0
RESOURCE_OPERATION_TIMEOUT_SECONDS = 30.0

INDEXING_TIMEOUT_SECONDS = 120.0
API_TIMEOUT_SECONDS = 30.0
DOCUMENT_INDEXING_TIMEOUT_SECONDS = 60.0
WEB_SEARCH_TIMEOUT_SECONDS = 30.0

MAX_QUERY_LENGTH = 10000
MAX_INFRASTRUCTURE_CODE_LENGTH = 1000000
MAX_REPOSITORY_URL_LENGTH = 500
MAX_CONTENT_URL_LENGTH = 2000
MAX_DOCUMENTATION_LENGTH = 5000000
MAX_PATTERN_LENGTH = 10000
MAX_ISSUE_DESCRIPTION_LENGTH = 50000
MAX_SUBJECT_LENGTH = 500
MAX_DESCRIPTION_LENGTH = 5000

MAX_SEARCH_RESULTS = 50000
PERFORMANCE_WARNING_THRESHOLD = 10000
MAX_ARRAY_LENGTH = 1000

TOOL_TIMEOUTS: dict[str, float] = {
    "wistx_index_repository": 600.0,
    "wistx_index_resource": 600.0,
    "wistx_calculate_infrastructure_cost": 60.0,
    "wistx_regex_search": 120.0,
    "wistx_search_codebase": 90.0,
    "wistx_design_architecture": 180.0,
    "wistx_troubleshoot_issue": 120.0,
    "wistx_generate_documentation": 180.0,
    "wistx_manage_integration": 120.0,
    "wistx_manage_infrastructure": 180.0,
    "wistx_research_knowledge_base": 90.0,
}

