# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.file_content_encoding import FileContentEncoding
from ..types.response_file_find_result import ResponseFileFindResult
from ..types.response_file_list_result import ResponseFileListResult
from ..types.response_file_read_result import ResponseFileReadResult
from ..types.response_file_replace_result import ResponseFileReplaceResult
from ..types.response_file_search_result import ResponseFileSearchResult
from ..types.response_file_upload_result import ResponseFileUploadResult
from ..types.response_file_write_result import ResponseFileWriteResult
from ..types.response_str_replace_editor_result import ResponseStrReplaceEditorResult
from .raw_client import AsyncRawFileClient, RawFileClient
from .types.command import Command

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FileClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFileClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFileClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFileClient
        """
        return self._raw_client

    def read_file(
        self,
        *,
        file: str,
        start_line: typing.Optional[int] = OMIT,
        end_line: typing.Optional[int] = OMIT,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileReadResult:
        """
        Read file content

        Parameters
        ----------
        file : str
            Absolute file path

        start_line : typing.Optional[int]
            Start line (0-based)

        end_line : typing.Optional[int]
            End line (not inclusive)

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileReadResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.read_file(
            file="file",
        )
        """
        _response = self._raw_client.read_file(
            file=file, start_line=start_line, end_line=end_line, sudo=sudo, request_options=request_options
        )
        return _response.data

    def write_file(
        self,
        *,
        file: str,
        content: str,
        encoding: typing.Optional[FileContentEncoding] = OMIT,
        append: typing.Optional[bool] = OMIT,
        leading_newline: typing.Optional[bool] = OMIT,
        trailing_newline: typing.Optional[bool] = OMIT,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileWriteResult:
        """
        Write file content (supports both text and binary files)

        For binary files, set encoding to 'base64' and provide base64-encoded content.
        For text files, use default 'utf-8' encoding.

        Parameters
        ----------
        file : str
            Absolute file path

        content : str
            Content to write (text or base64 encoded for binary)

        encoding : typing.Optional[FileContentEncoding]
            Content encoding: utf-8 for text, base64 for binary data

        append : typing.Optional[bool]
            Whether to use append mode

        leading_newline : typing.Optional[bool]
            Whether to add leading newline (only for text mode)

        trailing_newline : typing.Optional[bool]
            Whether to add trailing newline (only for text mode)

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileWriteResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.write_file(
            file="file",
            content="content",
        )
        """
        _response = self._raw_client.write_file(
            file=file,
            content=content,
            encoding=encoding,
            append=append,
            leading_newline=leading_newline,
            trailing_newline=trailing_newline,
            sudo=sudo,
            request_options=request_options,
        )
        return _response.data

    def replace_in_file(
        self,
        *,
        file: str,
        old_str: str,
        new_str: str,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileReplaceResult:
        """
        Replace string in file

        Parameters
        ----------
        file : str
            Absolute file path

        old_str : str
            Original string to replace

        new_str : str
            New string to replace with

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileReplaceResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.replace_in_file(
            file="file",
            old_str="old_str",
            new_str="new_str",
        )
        """
        _response = self._raw_client.replace_in_file(
            file=file, old_str=old_str, new_str=new_str, sudo=sudo, request_options=request_options
        )
        return _response.data

    def search_in_file(
        self,
        *,
        file: str,
        regex: str,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileSearchResult:
        """
        Search in file content

        Parameters
        ----------
        file : str
            Absolute file path

        regex : str
            Regular expression pattern

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileSearchResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.search_in_file(
            file="file",
            regex="regex",
        )
        """
        _response = self._raw_client.search_in_file(file=file, regex=regex, sudo=sudo, request_options=request_options)
        return _response.data

    def find_files(
        self, *, path: str, glob: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseFileFindResult:
        """
        Find files by name pattern

        Parameters
        ----------
        path : str
            Directory path to search

        glob : str
            Filename pattern (glob syntax)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileFindResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.find_files(
            path="path",
            glob="glob",
        )
        """
        _response = self._raw_client.find_files(path=path, glob=glob, request_options=request_options)
        return _response.data

    def upload_file(
        self,
        *,
        file: core.File,
        path: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileUploadResult:
        """
        Upload file using streaming

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        path : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileUploadResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.upload_file()
        """
        _response = self._raw_client.upload_file(file=file, path=path, request_options=request_options)
        return _response.data

    def download_file(
        self, *, path: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Download file using FileResponse

        Parameters
        ----------
        path : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.download_file(
            path="path",
        )
        """
        _response = self._raw_client.download_file(path=path, request_options=request_options)
        return _response.data

    def list_path(
        self,
        *,
        path: str,
        recursive: typing.Optional[bool] = OMIT,
        show_hidden: typing.Optional[bool] = OMIT,
        file_types: typing.Optional[typing.Sequence[str]] = OMIT,
        max_depth: typing.Optional[int] = OMIT,
        include_size: typing.Optional[bool] = OMIT,
        include_permissions: typing.Optional[bool] = OMIT,
        sort_by: typing.Optional[str] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileListResult:
        """
        List path contents with flexible options

        Parameters
        ----------
        path : str
            Directory path to list

        recursive : typing.Optional[bool]
            Whether to list recursively

        show_hidden : typing.Optional[bool]
            Whether to show hidden files

        file_types : typing.Optional[typing.Sequence[str]]
            Filter by file extensions (e.g., ['.py', '.txt'])

        max_depth : typing.Optional[int]
            Maximum depth for recursive listing

        include_size : typing.Optional[bool]
            Whether to include file size information

        include_permissions : typing.Optional[bool]
            Whether to include file permissions

        sort_by : typing.Optional[str]
            Sort by: name, size, modified, type

        sort_desc : typing.Optional[bool]
            Sort in descending order

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileListResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.list_path(
            path="path",
        )
        """
        _response = self._raw_client.list_path(
            path=path,
            recursive=recursive,
            show_hidden=show_hidden,
            file_types=file_types,
            max_depth=max_depth,
            include_size=include_size,
            include_permissions=include_permissions,
            sort_by=sort_by,
            sort_desc=sort_desc,
            request_options=request_options,
        )
        return _response.data

    def str_replace_editor(
        self,
        *,
        command: Command,
        path: str,
        file_text: typing.Optional[str] = OMIT,
        old_str: typing.Optional[str] = OMIT,
        new_str: typing.Optional[str] = OMIT,
        insert_line: typing.Optional[int] = OMIT,
        view_range: typing.Optional[typing.Sequence[int]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseStrReplaceEditorResult:
        """
        An filesystem editor tool that allows the agent to
        - view
        - create
        - navigate
        - edit files
        The tool parameters are defined by Anthropic and are not editable.

        Parameters
        ----------
        command : Command
            The commands to run. Allowed options are: `view`, `create`, `str_replace`, `insert`, `undo_edit`.

        path : str
            Absolute path to file or directory, e.g. `/workspace/file.py` or `/workspace`.

        file_text : typing.Optional[str]
            Required parameter of `create` command, with the content of the file to be created.

        old_str : typing.Optional[str]
            Required parameter of `str_replace` command containing the string in `path` to replace.

        new_str : typing.Optional[str]
            Optional parameter of `str_replace` command containing the new string (if not given, no string will be added). Required parameter of `insert` command containing the string to insert.

        insert_line : typing.Optional[int]
            Required parameter of `insert` command. The `new_str` will be inserted AFTER the line `insert_line` of `path`.

        view_range : typing.Optional[typing.Sequence[int]]
            Optional parameter of `view` command when `path` points to a file. If none is given, the full file is shown. If provided, the file will be shown in the indicated line number range, e.g. [11, 12] will show lines 11 and 12. Indexing at 1 to start. Setting `[start_line, -1]` shows all lines from `start_line` to the end of the file.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseStrReplaceEditorResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.file.str_replace_editor(
            command="view",
            path="path",
        )
        """
        _response = self._raw_client.str_replace_editor(
            command=command,
            path=path,
            file_text=file_text,
            old_str=old_str,
            new_str=new_str,
            insert_line=insert_line,
            view_range=view_range,
            request_options=request_options,
        )
        return _response.data


class AsyncFileClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFileClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFileClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFileClient
        """
        return self._raw_client

    async def read_file(
        self,
        *,
        file: str,
        start_line: typing.Optional[int] = OMIT,
        end_line: typing.Optional[int] = OMIT,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileReadResult:
        """
        Read file content

        Parameters
        ----------
        file : str
            Absolute file path

        start_line : typing.Optional[int]
            Start line (0-based)

        end_line : typing.Optional[int]
            End line (not inclusive)

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileReadResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.read_file(
                file="file",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.read_file(
            file=file, start_line=start_line, end_line=end_line, sudo=sudo, request_options=request_options
        )
        return _response.data

    async def write_file(
        self,
        *,
        file: str,
        content: str,
        encoding: typing.Optional[FileContentEncoding] = OMIT,
        append: typing.Optional[bool] = OMIT,
        leading_newline: typing.Optional[bool] = OMIT,
        trailing_newline: typing.Optional[bool] = OMIT,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileWriteResult:
        """
        Write file content (supports both text and binary files)

        For binary files, set encoding to 'base64' and provide base64-encoded content.
        For text files, use default 'utf-8' encoding.

        Parameters
        ----------
        file : str
            Absolute file path

        content : str
            Content to write (text or base64 encoded for binary)

        encoding : typing.Optional[FileContentEncoding]
            Content encoding: utf-8 for text, base64 for binary data

        append : typing.Optional[bool]
            Whether to use append mode

        leading_newline : typing.Optional[bool]
            Whether to add leading newline (only for text mode)

        trailing_newline : typing.Optional[bool]
            Whether to add trailing newline (only for text mode)

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileWriteResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.write_file(
                file="file",
                content="content",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.write_file(
            file=file,
            content=content,
            encoding=encoding,
            append=append,
            leading_newline=leading_newline,
            trailing_newline=trailing_newline,
            sudo=sudo,
            request_options=request_options,
        )
        return _response.data

    async def replace_in_file(
        self,
        *,
        file: str,
        old_str: str,
        new_str: str,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileReplaceResult:
        """
        Replace string in file

        Parameters
        ----------
        file : str
            Absolute file path

        old_str : str
            Original string to replace

        new_str : str
            New string to replace with

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileReplaceResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.replace_in_file(
                file="file",
                old_str="old_str",
                new_str="new_str",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.replace_in_file(
            file=file, old_str=old_str, new_str=new_str, sudo=sudo, request_options=request_options
        )
        return _response.data

    async def search_in_file(
        self,
        *,
        file: str,
        regex: str,
        sudo: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileSearchResult:
        """
        Search in file content

        Parameters
        ----------
        file : str
            Absolute file path

        regex : str
            Regular expression pattern

        sudo : typing.Optional[bool]
            Whether to use sudo privileges

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileSearchResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.search_in_file(
                file="file",
                regex="regex",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_in_file(
            file=file, regex=regex, sudo=sudo, request_options=request_options
        )
        return _response.data

    async def find_files(
        self, *, path: str, glob: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseFileFindResult:
        """
        Find files by name pattern

        Parameters
        ----------
        path : str
            Directory path to search

        glob : str
            Filename pattern (glob syntax)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileFindResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.find_files(
                path="path",
                glob="glob",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find_files(path=path, glob=glob, request_options=request_options)
        return _response.data

    async def upload_file(
        self,
        *,
        file: core.File,
        path: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileUploadResult:
        """
        Upload file using streaming

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        path : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileUploadResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.upload_file()


        asyncio.run(main())
        """
        _response = await self._raw_client.upload_file(file=file, path=path, request_options=request_options)
        return _response.data

    async def download_file(
        self, *, path: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Download file using FileResponse

        Parameters
        ----------
        path : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.download_file(
                path="path",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.download_file(path=path, request_options=request_options)
        return _response.data

    async def list_path(
        self,
        *,
        path: str,
        recursive: typing.Optional[bool] = OMIT,
        show_hidden: typing.Optional[bool] = OMIT,
        file_types: typing.Optional[typing.Sequence[str]] = OMIT,
        max_depth: typing.Optional[int] = OMIT,
        include_size: typing.Optional[bool] = OMIT,
        include_permissions: typing.Optional[bool] = OMIT,
        sort_by: typing.Optional[str] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseFileListResult:
        """
        List path contents with flexible options

        Parameters
        ----------
        path : str
            Directory path to list

        recursive : typing.Optional[bool]
            Whether to list recursively

        show_hidden : typing.Optional[bool]
            Whether to show hidden files

        file_types : typing.Optional[typing.Sequence[str]]
            Filter by file extensions (e.g., ['.py', '.txt'])

        max_depth : typing.Optional[int]
            Maximum depth for recursive listing

        include_size : typing.Optional[bool]
            Whether to include file size information

        include_permissions : typing.Optional[bool]
            Whether to include file permissions

        sort_by : typing.Optional[str]
            Sort by: name, size, modified, type

        sort_desc : typing.Optional[bool]
            Sort in descending order

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseFileListResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.list_path(
                path="path",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_path(
            path=path,
            recursive=recursive,
            show_hidden=show_hidden,
            file_types=file_types,
            max_depth=max_depth,
            include_size=include_size,
            include_permissions=include_permissions,
            sort_by=sort_by,
            sort_desc=sort_desc,
            request_options=request_options,
        )
        return _response.data

    async def str_replace_editor(
        self,
        *,
        command: Command,
        path: str,
        file_text: typing.Optional[str] = OMIT,
        old_str: typing.Optional[str] = OMIT,
        new_str: typing.Optional[str] = OMIT,
        insert_line: typing.Optional[int] = OMIT,
        view_range: typing.Optional[typing.Sequence[int]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseStrReplaceEditorResult:
        """
        An filesystem editor tool that allows the agent to
        - view
        - create
        - navigate
        - edit files
        The tool parameters are defined by Anthropic and are not editable.

        Parameters
        ----------
        command : Command
            The commands to run. Allowed options are: `view`, `create`, `str_replace`, `insert`, `undo_edit`.

        path : str
            Absolute path to file or directory, e.g. `/workspace/file.py` or `/workspace`.

        file_text : typing.Optional[str]
            Required parameter of `create` command, with the content of the file to be created.

        old_str : typing.Optional[str]
            Required parameter of `str_replace` command containing the string in `path` to replace.

        new_str : typing.Optional[str]
            Optional parameter of `str_replace` command containing the new string (if not given, no string will be added). Required parameter of `insert` command containing the string to insert.

        insert_line : typing.Optional[int]
            Required parameter of `insert` command. The `new_str` will be inserted AFTER the line `insert_line` of `path`.

        view_range : typing.Optional[typing.Sequence[int]]
            Optional parameter of `view` command when `path` points to a file. If none is given, the full file is shown. If provided, the file will be shown in the indicated line number range, e.g. [11, 12] will show lines 11 and 12. Indexing at 1 to start. Setting `[start_line, -1]` shows all lines from `start_line` to the end of the file.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseStrReplaceEditorResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.file.str_replace_editor(
                command="view",
                path="path",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.str_replace_editor(
            command=command,
            path=path,
            file_text=file_text,
            old_str=old_str,
            new_str=new_str,
            insert_line=insert_line,
            view_range=view_range,
            request_options=request_options,
        )
        return _response.data
