# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.response_call_tool_result import ResponseCallToolResult
from ..types.response_list_str import ResponseListStr
from ..types.response_list_tools_result import ResponseListToolsResult
from .raw_client import AsyncRawMcpClient, RawMcpClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class McpClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMcpClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMcpClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMcpClient
        """
        return self._raw_client

    def list_mcp_tools(
        self, server_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseListToolsResult:
        """
        List all available tools from the specified MCP server

        Args:
            server_name: The name of the MCP server as defined in mcp-servers.json

        Returns:
            Response containing the list of available tools with their descriptions and parameters

        Parameters
        ----------
        server_name : str
            Name of the MCP server

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseListToolsResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.mcp.list_mcp_tools(
            server_name="server_name",
        )
        """
        _response = self._raw_client.list_mcp_tools(server_name, request_options=request_options)
        return _response.data

    def execute_mcp_tool(
        self,
        server_name: str,
        tool_name: str,
        *,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseCallToolResult:
        """
        Execute a specific tool on the specified MCP server

        Args:
            server_name: The name of the MCP server as defined in mcp-servers.json
            tool_name: The name of the tool to execute
            arguments: Tool arguments dictionary

        Returns:
            Response containing the tool execution results

        Parameters
        ----------
        server_name : str
            Name of the MCP server

        tool_name : str
            Name of the tool to execute

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseCallToolResult
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.mcp.execute_mcp_tool(
            server_name="server_name",
            tool_name="tool_name",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.execute_mcp_tool(
            server_name, tool_name, request=request, request_options=request_options
        )
        return _response.data

    def list_mcp_servers(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseListStr:
        """
        List all configured MCP servers

        Returns:
            Response containing the list of configured and filtered MCP servers

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseListStr
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.mcp.list_mcp_servers()
        """
        _response = self._raw_client.list_mcp_servers(request_options=request_options)
        return _response.data


class AsyncMcpClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMcpClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMcpClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMcpClient
        """
        return self._raw_client

    async def list_mcp_tools(
        self, server_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ResponseListToolsResult:
        """
        List all available tools from the specified MCP server

        Args:
            server_name: The name of the MCP server as defined in mcp-servers.json

        Returns:
            Response containing the list of available tools with their descriptions and parameters

        Parameters
        ----------
        server_name : str
            Name of the MCP server

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseListToolsResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.mcp.list_mcp_tools(
                server_name="server_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_mcp_tools(server_name, request_options=request_options)
        return _response.data

    async def execute_mcp_tool(
        self,
        server_name: str,
        tool_name: str,
        *,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResponseCallToolResult:
        """
        Execute a specific tool on the specified MCP server

        Args:
            server_name: The name of the MCP server as defined in mcp-servers.json
            tool_name: The name of the tool to execute
            arguments: Tool arguments dictionary

        Returns:
            Response containing the tool execution results

        Parameters
        ----------
        server_name : str
            Name of the MCP server

        tool_name : str
            Name of the tool to execute

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseCallToolResult
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.mcp.execute_mcp_tool(
                server_name="server_name",
                tool_name="tool_name",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_mcp_tool(
            server_name, tool_name, request=request, request_options=request_options
        )
        return _response.data

    async def list_mcp_servers(self, *, request_options: typing.Optional[RequestOptions] = None) -> ResponseListStr:
        """
        List all configured MCP servers

        Returns:
            Response containing the list of configured and filtered MCP servers

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResponseListStr
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.mcp.list_mcp_servers()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_mcp_servers(request_options=request_options)
        return _response.data
