# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.response import Response
from ..types.sandbox_response import SandboxResponse
from .raw_client import AsyncRawSandboxClient, RawSandboxClient


class SandboxClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSandboxClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSandboxClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSandboxClient
        """
        return self._raw_client

    def get_sandbox_context(self, *, request_options: typing.Optional[RequestOptions] = None) -> SandboxResponse:
        """
        Get sandbox environment information

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SandboxResponse
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.sandbox.get_sandbox_context()
        """
        _response = self._raw_client.get_sandbox_context(request_options=request_options)
        return _response.data

    def python_packages(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Get installed packages by language

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.sandbox.python_packages()
        """
        _response = self._raw_client.python_packages(request_options=request_options)
        return _response.data

    def nodejs_packages(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Get installed packages by language

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.sandbox.nodejs_packages()
        """
        _response = self._raw_client.nodejs_packages(request_options=request_options)
        return _response.data


class AsyncSandboxClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSandboxClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSandboxClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSandboxClient
        """
        return self._raw_client

    async def get_sandbox_context(self, *, request_options: typing.Optional[RequestOptions] = None) -> SandboxResponse:
        """
        Get sandbox environment information

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SandboxResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.sandbox.get_sandbox_context()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_sandbox_context(request_options=request_options)
        return _response.data

    async def python_packages(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Get installed packages by language

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.sandbox.python_packages()


        asyncio.run(main())
        """
        _response = await self._raw_client.python_packages(request_options=request_options)
        return _response.data

    async def nodejs_packages(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Get installed packages by language

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.sandbox.nodejs_packages()


        asyncio.run(main())
        """
        _response = await self._raw_client.nodejs_packages(request_options=request_options)
        return _response.data
