# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.response import Response
from ..types.response_active_shell_sessions_result import ResponseActiveShellSessionsResult
from ..types.response_shell_command_result import ResponseShellCommandResult
from ..types.response_shell_create_session_response import ResponseShellCreateSessionResponse
from ..types.response_shell_kill_result import ResponseShellKillResult
from ..types.response_shell_view_result import ResponseShellViewResult
from ..types.response_shell_wait_result import ResponseShellWaitResult
from ..types.response_shell_write_result import ResponseShellWriteResult
from ..types.response_str import ResponseStr

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawShellClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def exec_command(
        self,
        *,
        command: str,
        id: typing.Optional[str] = OMIT,
        exec_dir: typing.Optional[str] = OMIT,
        async_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseShellCommandResult]:
        """
        Execute command in the specified shell session
        Supports SSE streaming if Accept header contains 'text/event-stream'

        Parameters
        ----------
        command : str
            Shell command to execute

        id : typing.Optional[str]
            Unique identifier of the target shell session, if not provided, one will be automatically created

        exec_dir : typing.Optional[str]
            Working directory for command execution (must use absolute path)

        async_mode : typing.Optional[bool]
            Whether to execute command asynchronously (default: False for async, False for synchronous execution)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseShellCommandResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/exec",
            method="POST",
            json={
                "id": id,
                "exec_dir": exec_dir,
                "command": command,
                "async_mode": async_mode,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellCommandResult,
                    parse_obj_as(
                        type_=ResponseShellCommandResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def view_shell(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseShellViewResult]:
        """
        View output of the specified shell session
        Supports SSE streaming if Accept header contains 'text/event-stream'

        Parameters
        ----------
        id : str
            Unique identifier of the target shell session

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseShellViewResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/view",
            method="POST",
            json={
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellViewResult,
                    parse_obj_as(
                        type_=ResponseShellViewResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def wait_for_process(
        self, *, id: str, seconds: typing.Optional[int] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseShellWaitResult]:
        """
        Wait for the process in the specified shell session to return

        Parameters
        ----------
        id : str
            Unique identifier of the target shell session

        seconds : typing.Optional[int]
            Wait time (seconds)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseShellWaitResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/wait",
            method="POST",
            json={
                "id": id,
                "seconds": seconds,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellWaitResult,
                    parse_obj_as(
                        type_=ResponseShellWaitResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def write_to_process(
        self, *, id: str, input: str, press_enter: bool, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseShellWriteResult]:
        """
        Write input to the process in the specified shell session

        Parameters
        ----------
        id : str
            Unique identifier of the target shell session

        input : str
            Input content to write to the process

        press_enter : bool
            Whether to press enter key after input

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseShellWriteResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/write",
            method="POST",
            json={
                "id": id,
                "input": input,
                "press_enter": press_enter,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellWriteResult,
                    parse_obj_as(
                        type_=ResponseShellWriteResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def kill_process(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseShellKillResult]:
        """
        Terminate the process in the specified shell session

        Parameters
        ----------
        id : str
            Unique identifier of the target shell session

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseShellKillResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/kill",
            method="POST",
            json={
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellKillResult,
                    parse_obj_as(
                        type_=ResponseShellKillResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_session(
        self, *, exec_dir: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseShellCreateSessionResponse]:
        """
        Create a new shell session and return its ID

        Parameters
        ----------
        exec_dir : typing.Optional[str]
            Working directory for the new session (must use absolute path)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseShellCreateSessionResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/sessions/create",
            method="POST",
            json={
                "exec_dir": exec_dir,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellCreateSessionResponse,
                    parse_obj_as(
                        type_=ResponseShellCreateSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_terminal_url(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[ResponseStr]:
        """
        Create a new shell session and return the terminal URL

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseStr]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/terminal-url",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseStr,
                    parse_obj_as(
                        type_=ResponseStr,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_sessions(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseActiveShellSessionsResult]:
        """
        List all active shell sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseActiveShellSessionsResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/sessions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseActiveShellSessionsResult,
                    parse_obj_as(
                        type_=ResponseActiveShellSessionsResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cleanup_all_sessions(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Response]:
        """
        Cleanup all active shell sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Response]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/shell/sessions",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Response,
                    parse_obj_as(
                        type_=Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cleanup_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Response]:
        """
        Manually cleanup a specific shell session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Response]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/shell/sessions/{jsonable_encoder(session_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Response,
                    parse_obj_as(
                        type_=Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawShellClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def exec_command(
        self,
        *,
        command: str,
        id: typing.Optional[str] = OMIT,
        exec_dir: typing.Optional[str] = OMIT,
        async_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseShellCommandResult]:
        """
        Execute command in the specified shell session
        Supports SSE streaming if Accept header contains 'text/event-stream'

        Parameters
        ----------
        command : str
            Shell command to execute

        id : typing.Optional[str]
            Unique identifier of the target shell session, if not provided, one will be automatically created

        exec_dir : typing.Optional[str]
            Working directory for command execution (must use absolute path)

        async_mode : typing.Optional[bool]
            Whether to execute command asynchronously (default: False for async, False for synchronous execution)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseShellCommandResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/exec",
            method="POST",
            json={
                "id": id,
                "exec_dir": exec_dir,
                "command": command,
                "async_mode": async_mode,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellCommandResult,
                    parse_obj_as(
                        type_=ResponseShellCommandResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def view_shell(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseShellViewResult]:
        """
        View output of the specified shell session
        Supports SSE streaming if Accept header contains 'text/event-stream'

        Parameters
        ----------
        id : str
            Unique identifier of the target shell session

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseShellViewResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/view",
            method="POST",
            json={
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellViewResult,
                    parse_obj_as(
                        type_=ResponseShellViewResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def wait_for_process(
        self, *, id: str, seconds: typing.Optional[int] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseShellWaitResult]:
        """
        Wait for the process in the specified shell session to return

        Parameters
        ----------
        id : str
            Unique identifier of the target shell session

        seconds : typing.Optional[int]
            Wait time (seconds)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseShellWaitResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/wait",
            method="POST",
            json={
                "id": id,
                "seconds": seconds,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellWaitResult,
                    parse_obj_as(
                        type_=ResponseShellWaitResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def write_to_process(
        self, *, id: str, input: str, press_enter: bool, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseShellWriteResult]:
        """
        Write input to the process in the specified shell session

        Parameters
        ----------
        id : str
            Unique identifier of the target shell session

        input : str
            Input content to write to the process

        press_enter : bool
            Whether to press enter key after input

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseShellWriteResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/write",
            method="POST",
            json={
                "id": id,
                "input": input,
                "press_enter": press_enter,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellWriteResult,
                    parse_obj_as(
                        type_=ResponseShellWriteResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def kill_process(
        self, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseShellKillResult]:
        """
        Terminate the process in the specified shell session

        Parameters
        ----------
        id : str
            Unique identifier of the target shell session

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseShellKillResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/kill",
            method="POST",
            json={
                "id": id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellKillResult,
                    parse_obj_as(
                        type_=ResponseShellKillResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_session(
        self, *, exec_dir: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseShellCreateSessionResponse]:
        """
        Create a new shell session and return its ID

        Parameters
        ----------
        exec_dir : typing.Optional[str]
            Working directory for the new session (must use absolute path)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseShellCreateSessionResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/sessions/create",
            method="POST",
            json={
                "exec_dir": exec_dir,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseShellCreateSessionResponse,
                    parse_obj_as(
                        type_=ResponseShellCreateSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_terminal_url(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseStr]:
        """
        Create a new shell session and return the terminal URL

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseStr]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/terminal-url",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseStr,
                    parse_obj_as(
                        type_=ResponseStr,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_sessions(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseActiveShellSessionsResult]:
        """
        List all active shell sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseActiveShellSessionsResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/sessions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseActiveShellSessionsResult,
                    parse_obj_as(
                        type_=ResponseActiveShellSessionsResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cleanup_all_sessions(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Response]:
        """
        Cleanup all active shell sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Response]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/shell/sessions",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Response,
                    parse_obj_as(
                        type_=Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cleanup_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Response]:
        """
        Manually cleanup a specific shell session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Response]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/shell/sessions/{jsonable_encoder(session_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Response,
                    parse_obj_as(
                        type_=Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
