# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class FileInfo(UniversalBaseModel):
    """
    File information
    """

    name: str = pydantic.Field()
    """
    File name
    """

    path: str = pydantic.Field()
    """
    Full file path
    """

    is_directory: bool = pydantic.Field()
    """
    Whether it's a directory
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    File size in bytes
    """

    modified_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last modified time (ISO format)
    """

    permissions: typing.Optional[str] = pydantic.Field(default=None)
    """
    File permissions
    """

    extension: typing.Optional[str] = pydantic.Field(default=None)
    """
    File extension
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
