# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .file_info import FileInfo


class FileListResult(UniversalBaseModel):
    """
    File list result
    """

    path: str = pydantic.Field()
    """
    Listed directory path
    """

    files: typing.Optional[typing.List[FileInfo]] = pydantic.Field(default=None)
    """
    List of files and directories
    """

    total_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of items
    """

    directory_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of directories
    """

    file_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of files
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
