# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class JupyterInfoResponse(UniversalBaseModel):
    """
    Jupyter service information response model
    """

    default_kernel: str = pydantic.Field()
    """
    Default kernel name
    """

    available_kernels: typing.List[str] = pydantic.Field()
    """
    List of available kernel names
    """

    active_sessions: int = pydantic.Field()
    """
    Number of active sessions
    """

    session_timeout_seconds: int = pydantic.Field()
    """
    Session timeout in seconds
    """

    max_sessions: int = pydantic.Field()
    """
    Maximum number of concurrent sessions
    """

    description: str = pydantic.Field()
    """
    Service description
    """

    kernel_detection: str = pydantic.Field()
    """
    Kernel detection strategy
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
