# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .node_js_output import NodeJsOutput


class NodeJsExecuteResponse(UniversalBaseModel):
    language: typing.Literal["javascript"] = pydantic.Field(default="javascript")
    """
    Language that was executed (always 'javascript')
    """

    status: str = pydantic.Field()
    """
    Execution status: ok, error, or timeout
    """

    execution_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Execution count
    """

    outputs: typing.Optional[typing.List[NodeJsOutput]] = pydantic.Field(default=None)
    """
    List of execution outputs
    """

    code: str = pydantic.Field()
    """
    Code that was executed
    """

    stdout: typing.Optional[str] = pydantic.Field(default=None)
    """
    Standard output
    """

    stderr: typing.Optional[str] = pydantic.Field(default=None)
    """
    Standard error
    """

    exit_code: int = pydantic.Field()
    """
    Process exit code
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
