# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SessionInfo(UniversalBaseModel):
    """
    Active session information
    """

    kernel_name: str = pydantic.Field()
    """
    Kernel name
    """

    last_used: float = pydantic.Field()
    """
    Last used timestamp
    """

    age_seconds: int = pydantic.Field()
    """
    Age of session in seconds
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
