# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .bash_command_status import BashCommandStatus
from .console_record import ConsoleRecord


class ShellCommandResult(UniversalBaseModel):
    """
    Shell command execution result model
    """

    session_id: str = pydantic.Field()
    """
    Shell session ID
    """

    command: str = pydantic.Field()
    """
    Executed command
    """

    status: BashCommandStatus = pydantic.Field()
    """
    Command execution status
    """

    output: typing.Optional[str] = pydantic.Field(default=None)
    """
    Command execution output, only has value when status is completed
    """

    console: typing.Optional[typing.List[ConsoleRecord]] = pydantic.Field(default=None)
    """
    Console command records
    """

    exit_code: typing.Optional[int] = pydantic.Field(default=None)
    """
    Command execution exit code, only has value when status is completed
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
