# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class StrReplaceEditorResult(UniversalBaseModel):
    """
    String replace editor result based on openhands_aci CLIResult
    """

    output: str = pydantic.Field()
    """
    Command execution output
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message if any
    """

    path: str = pydantic.Field()
    """
    File path that was operated on
    """

    prev_exist: bool = pydantic.Field()
    """
    Whether the file existed before operation
    """

    old_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Previous file content
    """

    new_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    New file content after operation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
