# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Optional

import httpx

from ..types import model_list_params
from .._types import Body, Omit, Query, Headers, NotGiven, SequenceNotStr, omit, not_given
from .._utils import maybe_transform, async_maybe_transform
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from .._base_client import make_request_options
from ..types.model_list_response import ModelListResponse

__all__ = ["ModelsResource", "AsyncModelsResource"]


class ModelsResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> ModelsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Not-Diamond/not-diamond-python#accessing-raw-response-data-eg-headers
        """
        return ModelsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> ModelsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Not-Diamond/not-diamond-python#with_streaming_response
        """
        return ModelsResourceWithStreamingResponse(self)

    def list(
        self,
        *,
        openrouter_only: bool | Omit = omit,
        provider: Optional[SequenceNotStr[str]] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> ModelListResponse:
        """
        List all supported text generation models with optional filtering.

        including pricing, context length, latency, and OpenRouter availability.

        **Note:** Image generation models are excluded from this endpoint.

        **Examples:**

        - Get all models: `/v2/models`
        - OpenRouter only: `/v2/models?openrouter_only=true`
        - Specific provider: `/v2/models?provider=openai`
        - Multiple providers: `/v2/models?provider=openai&provider=anthropic`

        **Query Parameters:**

        - **provider**: Filter by provider name(s). Can specify multiple times for
          multiple providers (e.g., `?provider=openai&provider=anthropic`)
        - **openrouter_only**: Return only models that have OpenRouter support (default:
          false)

        **Returns:**

        - **models**: List of active text generation model objects with metadata
        - **total**: Total number of active models returned
        - **deprecated_models**: List of deprecated text generation model objects with
          metadata (respects the same filters as active models)

        **Caching:**

        - Response is cacheable for 1 hour (model list rarely changes)

        Args:
          openrouter_only: Return only OpenRouter-supported models

          provider: Filter by provider name(s). Can specify multiple providers (e.g., 'openai',
              'anthropic')

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get(
            "/v2/models",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "openrouter_only": openrouter_only,
                        "provider": provider,
                    },
                    model_list_params.ModelListParams,
                ),
            ),
            cast_to=ModelListResponse,
        )


class AsyncModelsResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncModelsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Not-Diamond/not-diamond-python#accessing-raw-response-data-eg-headers
        """
        return AsyncModelsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncModelsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Not-Diamond/not-diamond-python#with_streaming_response
        """
        return AsyncModelsResourceWithStreamingResponse(self)

    async def list(
        self,
        *,
        openrouter_only: bool | Omit = omit,
        provider: Optional[SequenceNotStr[str]] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> ModelListResponse:
        """
        List all supported text generation models with optional filtering.

        including pricing, context length, latency, and OpenRouter availability.

        **Note:** Image generation models are excluded from this endpoint.

        **Examples:**

        - Get all models: `/v2/models`
        - OpenRouter only: `/v2/models?openrouter_only=true`
        - Specific provider: `/v2/models?provider=openai`
        - Multiple providers: `/v2/models?provider=openai&provider=anthropic`

        **Query Parameters:**

        - **provider**: Filter by provider name(s). Can specify multiple times for
          multiple providers (e.g., `?provider=openai&provider=anthropic`)
        - **openrouter_only**: Return only models that have OpenRouter support (default:
          false)

        **Returns:**

        - **models**: List of active text generation model objects with metadata
        - **total**: Total number of active models returned
        - **deprecated_models**: List of deprecated text generation model objects with
          metadata (respects the same filters as active models)

        **Caching:**

        - Response is cacheable for 1 hour (model list rarely changes)

        Args:
          openrouter_only: Return only OpenRouter-supported models

          provider: Filter by provider name(s). Can specify multiple providers (e.g., 'openai',
              'anthropic')

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return await self._get(
            "/v2/models",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=await async_maybe_transform(
                    {
                        "openrouter_only": openrouter_only,
                        "provider": provider,
                    },
                    model_list_params.ModelListParams,
                ),
            ),
            cast_to=ModelListResponse,
        )


class ModelsResourceWithRawResponse:
    def __init__(self, models: ModelsResource) -> None:
        self._models = models

        self.list = to_raw_response_wrapper(
            models.list,
        )


class AsyncModelsResourceWithRawResponse:
    def __init__(self, models: AsyncModelsResource) -> None:
        self._models = models

        self.list = async_to_raw_response_wrapper(
            models.list,
        )


class ModelsResourceWithStreamingResponse:
    def __init__(self, models: ModelsResource) -> None:
        self._models = models

        self.list = to_streamed_response_wrapper(
            models.list,
        )


class AsyncModelsResourceWithStreamingResponse:
    def __init__(self, models: AsyncModelsResource) -> None:
        self._models = models

        self.list = async_to_streamed_response_wrapper(
            models.list,
        )
