"""add_relationships

Revision ID: 080cfe381209
Revises: 823842136f4e
Create Date: 2025-06-27 22:16:56.124086

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '080cfe381209'
down_revision: Union[str, None] = '823842136f4e'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('PlotLogs', schema=None) as batch_op:
        batch_op.create_foreign_key(batch_op.f('fk_PlotLogs_run_id_RecentRuns'), 'RecentRuns', ['run_id'], ['run_id'])

    with op.batch_alter_table('RecentRunErrorLogs', schema=None) as batch_op:
        batch_op.create_foreign_key(batch_op.f('fk_RecentRunErrorLogs_run_id_RecentRuns'), 'RecentRuns', ['run_id'], ['run_id'])

    with op.batch_alter_table('RecentRunMethodAndStates', schema=None) as batch_op:
        batch_op.create_foreign_key(batch_op.f('fk_RecentRunMethodAndStates_run_id_RecentRuns'), 'RecentRuns', ['run_id'], ['run_id'])

    with op.batch_alter_table('RecentRunPlotConfigurations', schema=None) as batch_op:
        batch_op.create_foreign_key(batch_op.f('fk_RecentRunPlotConfigurations_run_id_RecentRuns'), 'RecentRuns', ['run_id'], ['run_id'])

    with op.batch_alter_table('RecentRunRunLogs', schema=None) as batch_op:
        batch_op.create_foreign_key(batch_op.f('fk_RecentRunRunLogs_run_id_RecentRuns'), 'RecentRuns', ['run_id'], ['run_id'])

    with op.batch_alter_table('WebPushSubscriptions', schema=None) as batch_op:
        batch_op.create_foreign_key(batch_op.f('fk_WebPushSubscriptions_user_id_WebPushNotificationPreferences'), 'WebPushNotificationPreferences', ['user_id'], ['user_id'])

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('WebPushSubscriptions', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_WebPushSubscriptions_user_id_WebPushNotificationPreferences'), type_='foreignkey')

    with op.batch_alter_table('RecentRunRunLogs', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_RecentRunRunLogs_run_id_RecentRuns'), type_='foreignkey')

    with op.batch_alter_table('RecentRunPlotConfigurations', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_RecentRunPlotConfigurations_run_id_RecentRuns'), type_='foreignkey')

    with op.batch_alter_table('RecentRunMethodAndStates', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_RecentRunMethodAndStates_run_id_RecentRuns'), type_='foreignkey')

    with op.batch_alter_table('RecentRunErrorLogs', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_RecentRunErrorLogs_run_id_RecentRuns'), type_='foreignkey')

    with op.batch_alter_table('PlotLogs', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_PlotLogs_run_id_RecentRuns'), type_='foreignkey')

    # ### end Alembic commands ###
