---
search:
  exclude: true
---
# 複数のエージェントのオーケストレーション

オーケストレーションとは、アプリ内でのエージェントの流れのことです。どのエージェントを、どの順序で実行し、次に何をするかをどのように決めるかということです。エージェントをオーケストレーションする主な方法は 2 つあります。

1. LLM に意思決定させる: LLM の知性を使って計画・推論し、それに基づいて取るべき手順を決めます。
2. コードでオーケストレーションする: コードでエージェントの流れを決定します。

これらのパターンは組み合わせて使えます。どれもトレードオフがあります。以下で説明します。

## LLM によるオーケストレーション

エージェントとは、instructions、tools、ハンドオフを備えた LLM です。つまり、オープンエンドなタスクが与えられたとき、LLM はツールを使ってアクションを実行したりデータを取得したり、ハンドオフを使ってサブエージェントにタスクを委任したりしながら、タスクに取り組む計画を自律的に立てられます。たとえば、リサーチ用のエージェントには、次のようなツールを備えることができます。

-   Web 検索でオンライン情報を見つける
-   ファイル検索と取得で社内データや接続を横断して検索する
-   コンピュータ操作でコンピュータ上のアクションを実行する
-   コード実行でデータ分析を行う
-   計画やレポート作成などに長けた専門エージェントへのハンドオフ

このパターンは、タスクがオープンエンドで、LLM の知性に依拠したい場合に有効です。ここで重要な戦術は次のとおりです。

1. 良いプロンプトに投資する。利用可能なツール、その使い方、順守すべきパラメーターを明確にします。
2. アプリを監視して反復する。問題が起きる箇所を確認し、プロンプトを改善します。
3. エージェントに内省と改善を許可する。たとえばループで実行して自己批評させる、あるいはエラーメッセージを与えて改善させます。
4. 何でもできる汎用エージェントに期待するのではなく、1 つのタスクに特化して優れた専門エージェントを用意します。
5. [evals](https://platform.openai.com/docs/guides/evals) に投資する。これによりエージェントを訓練してタスク遂行能力を向上できます。

## コードによるオーケストレーション

LLM によるオーケストレーションは強力ですが、コードによるオーケストレーションは、速度・コスト・性能の面でタスクをより決定的かつ予測可能にします。代表的なパターンは次のとおりです。

-   [structured outputs](https://platform.openai.com/docs/guides/structured-outputs) を使って、コードで検査できる 適切な形式のデータ を生成する。たとえば、エージェントにタスクをいくつかの カテゴリー に分類させ、その カテゴリー に基づいて次のエージェントを選ぶ、といった使い方です。
-   あるエージェントの出力を次のエージェントの入力に変換して、複数のエージェントを連結する。ブログ記事の執筆のようなタスクを、リサーチ → アウトライン作成 → 本文執筆 → 批評 → 改善、という一連のステップに分解できます。
-   タスクを実行するエージェントと、それを評価してフィードバックするエージェントを `while` ループで回し、評価者が一定の基準を満たしたと判断するまで続ける。
-   `asyncio.gather` のような Python の基本コンポーネントを使って、複数のエージェントを並列に実行する。互いに依存しない複数のタスクがある場合、速度向上に有用です。

[`examples/agent_patterns`](https://github.com/openai/openai-agents-python/tree/main/examples/agent_patterns) にも多数の例があります。