---
search:
  exclude: true
---
# リリースプロセス/変更履歴

このプロジェクトは、`0.Y.Z` という形式を用いた、やや修正したセマンティックバージョニングに従います。先頭の `0` は、この SDK がまだ急速に進化中であることを示します。各コンポーネントは次のように増分します。

## マイナー (`Y`) バージョン

ベータではないパブリックインターフェースに対する、 **破壊的変更** がある場合にマイナーバージョン `Y` を上げます。たとえば、`0.0.x` から `0.1.x` への移行には破壊的変更が含まれる可能性があります。

破壊的変更を避けたい場合は、プロジェクトで `0.0.x` バージョンに固定することをおすすめします。

## パッチ (`Z`) バージョン

後方互換性を壊さない変更には `Z` を増分します。

- バグ修正
- 新機能
- 非公開インターフェースの変更
- ベータ機能の更新

## 破壊的変更の変更履歴

### 0.6.0

このバージョンでは、デフォルトのハンドオフ履歴が、raw な user/assistant のターンを公開するのではなく、1 つの assistant メッセージにまとめられるようになり、下流の エージェント に簡潔で予測可能な要約を提供します。
- 既存の単一メッセージのハンドオフ書き起こしは、デフォルトで `<CONVERSATION HISTORY>` ブロックの前に「For context, here is the conversation so far between the user and the previous agent:」で始まるようになり、下流の エージェント が明確にラベル付けされた要約を受け取れるようになりました

### 0.5.0

このバージョンは目に見える破壊的変更を導入しませんが、新機能と内部的な重要な更新をいくつか含みます。

- `RealtimeRunner` が [SIP protocol connections](https://platform.openai.com/docs/guides/realtime-sip) を扱えるようサポートを追加
- Python 3.14 互換性のために、`Runner#run_sync` の内部ロジックを大幅に改訂

### 0.4.0

このバージョンでは、[openai](https://pypi.org/project/openai/) パッケージの v1.x バージョンはサポートされなくなりました。この SDK と併せて openai v2.x を使用してください。

### 0.3.0

このバージョンでは、Realtime API のサポートが gpt-realtime モデルとその API インターフェース（GA 版）に移行します。

### 0.2.0

このバージョンでは、以前は `Agent` を引数に取っていた箇所の一部が、代わりに `AgentBase` を引数に取るようになりました。たとえば、MCP サーバーの `list_tools()` 呼び出しなどです。これは純粋に型に関する変更であり、引き続き `Agent` オブジェクトを受け取ります。更新するには、`Agent` を `AgentBase` に置き換えて型エラーを修正するだけです。

### 0.1.0

このバージョンでは、[`MCPServer.list_tools()`][agents.mcp.server.MCPServer] に 2 つの新しいパラメーター `run_context` と `agent` が追加されました。`MCPServer` をサブクラス化しているすべてのクラスに、これらのパラメーターを追加する必要があります。