---
search:
  exclude: true
---
# 멀티 에이전트 오케스트레이션

오케스트레이션은 앱에서 에이전트의 흐름을 의미합니다. 어떤 에이전트가 어떤 순서로 실행되며, 다음에 무엇을 할지 어떻게 결정하는가를 포함합니다. 에이전트를 오케스트레이션하는 주요 방식은 두 가지입니다:

1. LLM 이 결정을 내리도록 허용: LLM 의 지능을 활용해 계획·추론하고 그에 따라 다음 단계를 결정
2. 코드로 오케스트레이션: 코드로 에이전트의 흐름을 정의

이 패턴들은 조합해서 사용할 수 있습니다. 각 방식의 트레이드오프는 아래에 설명합니다.

## LLM 기반 오케스트레이션

에이전트는 instructions, tools, 핸드오프로 구성된 LLM 입니다. 이는 개방형 과제가 주어졌을 때, LLM 이 도구를 사용해 행동하고 데이터를 수집하며, 핸드오프를 통해 하위 에이전트에 작업을 위임하는 방식으로 과제를 자율적으로 계획하고 수행함을 의미합니다. 예를 들어, 리서치 에이전트는 다음과 같은 도구를 갖출 수 있습니다:

- 웹 검색을 통한 온라인 정보 탐색
- 파일 검색 및 검색을 통한 독점 데이터와 연결 탐색
- 컴퓨터 사용을 통한 컴퓨터 상의 행동 수행
- 데이터 분석을 위한 코드 실행
- 기획, 보고서 작성 등 특화된 에이전트로의 핸드오프

이 패턴은 과제가 개방형이고 LLM 의 지능에 의존하고자 할 때 적합합니다. 중요한 전술은 다음과 같습니다:

1. 좋은 프롬프트에 투자하세요. 사용 가능한 도구, 사용 방법, 운영해야 할 매개변수를 명확히 하세요.
2. 앱을 모니터링하고 반복 개선하세요. 문제가 생기는 지점을 파악하고 프롬프트를 개선하세요.
3. 에이전트가 자기 점검하고 개선하도록 하세요. 예를 들어 루프에서 실행하며 스스로 비판하게 하거나, 에러 메시지를 제공해 개선하게 하세요.
4. 모든 일을 잘하는 범용 에이전트보다는 하나의 작업에 특화된 에이전트를 두세요.
5. [평가(evals)](https://platform.openai.com/docs/guides/evals)에 투자하세요. 이를 통해 에이전트를 훈련해 성능을 향상할 수 있습니다.

## 코드 기반 오케스트레이션

LLM 기반 오케스트레이션이 강력하긴 하지만, 코드 기반 오케스트레이션은 속도, 비용, 성능 측면에서 더 결정적이고 예측 가능하게 만듭니다. 일반적인 패턴은 다음과 같습니다:

- [structured outputs](https://platform.openai.com/docs/guides/structured-outputs)를 사용해 코드로 검사할 수 있는 적절한 형식의 데이터를 생성. 예를 들어, 에이전트에 작업을 몇 개의 카테고리로 분류하게 하고, 해당 카테고리에 따라 다음 에이전트를 선택할 수 있습니다.
- 한 에이전트의 출력을 다음 에이전트의 입력으로 변환해 여러 에이전트를 체이닝. 예를 들어, 블로그 글쓰기를 연구 → 개요 작성 → 본문 작성 → 비판 → 개선의 단계로 분해할 수 있습니다.
- 작업을 수행하는 에이전트와 평가·피드백을 제공하는 에이전트를 함께 `while` 루프로 실행하고, 평가자가 출력이 특정 기준을 통과했다고 말할 때까지 반복
- 여러 에이전트를 병렬 실행 (예: 파이썬 기본 구성 요소인 `asyncio.gather` 사용). 상호 의존하지 않는 여러 작업을 빠르게 처리할 때 유용

[`examples/agent_patterns`](https://github.com/openai/openai-agents-python/tree/main/examples/agent_patterns)에 다양한 code examples 가 있습니다.