---
search:
  exclude: true
---
# 编排多个智能体

编排是指你在应用中安排智能体的运行流程：哪些智能体运行、以什么顺序运行、以及它们如何决定下一步该做什么。编排智能体主要有两种方式：

1. 让 LLM 做决定：利用 LLM 的智能进行规划、推理，并据此决定采取哪些步骤。
2. 通过代码进行编排：使用你的代码来确定智能体的流程。

你可以混合使用这些模式。每种方式都有取舍，详见下文。

## 通过 LLM 编排

一个智能体是配备了指令、工具和任务转移的 LLM。这意味着对于一个开放式任务，LLM 可以自主规划如何完成该任务，使用工具执行操作和获取数据，并通过任务转移将子任务委派给子智能体。例如，一个研究型智能体可以配备如下工具：

- 网络检索，用于在线查找信息
- 文件检索与读取，用于搜索专有数据和连接
- 计算机操作，用于在计算机上执行操作
- 代码执行，用于数据分析
- 任务转移至擅长规划、撰写报告等工作的专业智能体

当任务是开放式且你希望依赖 LLM 的智能时，这种模式非常适合。这里最重要的策略是：

1. 投入精力编写优质提示词。明确可用工具、如何使用它们以及必须遵循的约束。
2. 监控你的应用并持续迭代。找出问题所在，并迭代你的提示词。
3. 允许智能体自省和改进。例如，在循环中运行它，让它自我批评；或者提供错误信息并让它改进。
4. 使用在单一任务上表现出色的专业智能体，而非期望一个通用智能体在所有方面都表现良好。
5. 投入到[评测（evals）](https://platform.openai.com/docs/guides/evals)。这可帮助你训练智能体，持续改进并更好地完成任务。

## 通过代码编排

尽管通过 LLM 编排功能强大，但通过代码编排能让速度、成本和性能更具确定性与可预测性。常见模式包括：

- 使用[structured outputs](https://platform.openai.com/docs/guides/structured-outputs)生成可由你的代码检查的格式良好的数据。例如，你可以让一个智能体将任务分类到几个目录中，然后根据该目录选择下一个智能体。
- 将多个智能体串联起来，把一个的输出转换为下一个的输入。你可以把撰写博客帖子这样的任务分解为一系列步骤 - 做研究、写大纲、写正文、进行批判性审阅，然后改进。
- 在一个执行任务的智能体外，配上一个用于评估并提供反馈的智能体，将其置于 `while` 循环中运行，直到评估者认为输出符合某些标准。
- 并行运行多个智能体，例如通过 Python 基本组件如 `asyncio.gather`。当你有多个彼此独立的任务时，这有助于提升速度。

我们在[examples/agent_patterns](https://github.com/openai/openai-agents-python/tree/main/examples/agent_patterns)中提供了若干代码示例。