# coding: utf-8

"""
    zrok

    zrok client access

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from zrok_api.models.environment import Environment
from zrok_api.models.frontend import Frontend
from zrok_api.models.share import Share
from typing import Optional, Set
from typing_extensions import Self

class EnvironmentAndResources(BaseModel):
    """
    EnvironmentAndResources
    """ # noqa: E501
    environment: Optional[Environment] = None
    frontends: Optional[List[Frontend]] = None
    shares: Optional[List[Share]] = None
    __properties: ClassVar[List[str]] = ["environment", "frontends", "shares"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EnvironmentAndResources from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in frontends (list)
        _items = []
        if self.frontends:
            for _item_frontends in self.frontends:
                if _item_frontends:
                    _items.append(_item_frontends.to_dict())
            _dict['frontends'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shares (list)
        _items = []
        if self.shares:
            for _item_shares in self.shares:
                if _item_shares:
                    _items.append(_item_shares.to_dict())
            _dict['shares'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EnvironmentAndResources from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "environment": Environment.from_dict(obj["environment"]) if obj.get("environment") is not None else None,
            "frontends": [Frontend.from_dict(_item) for _item in obj["frontends"]] if obj.get("frontends") is not None else None,
            "shares": [Share.from_dict(_item) for _item in obj["shares"]] if obj.get("shares") is not None else None
        })
        return _obj


