# coding: utf-8

"""
    zrok

    zrok client access

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from zrok_api.models.auth_user import AuthUser
from zrok_api.models.name_selection import NameSelection
from typing import Optional, Set
from typing_extensions import Self

class ShareRequest(BaseModel):
    """
    ShareRequest
    """ # noqa: E501
    env_zid: Optional[StrictStr] = Field(default=None, alias="envZId")
    share_mode: Optional[StrictStr] = Field(default=None, alias="shareMode")
    name_selections: Optional[List[NameSelection]] = Field(default=None, alias="nameSelections")
    private_share_token: Optional[StrictStr] = Field(default=None, alias="privateShareToken")
    backend_mode: Optional[StrictStr] = Field(default=None, alias="backendMode")
    target: Optional[StrictStr] = None
    auth_scheme: Optional[StrictStr] = Field(default=None, alias="authScheme")
    basic_auth_users: Optional[List[AuthUser]] = Field(default=None, alias="basicAuthUsers")
    oauth_provider: Optional[StrictStr] = Field(default=None, alias="oauthProvider")
    oauth_email_domains: Optional[List[StrictStr]] = Field(default=None, alias="oauthEmailDomains")
    oauth_refresh_interval: Optional[StrictStr] = Field(default=None, alias="oauthRefreshInterval")
    permission_mode: Optional[StrictStr] = Field(default=None, alias="permissionMode")
    access_grants: Optional[List[StrictStr]] = Field(default=None, alias="accessGrants")
    __properties: ClassVar[List[str]] = ["envZId", "shareMode", "nameSelections", "privateShareToken", "backendMode", "target", "authScheme", "basicAuthUsers", "oauthProvider", "oauthEmailDomains", "oauthRefreshInterval", "permissionMode", "accessGrants"]

    @field_validator('share_mode')
    def share_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['public', 'private']):
            raise ValueError("must be one of enum values ('public', 'private')")
        return value

    @field_validator('backend_mode')
    def backend_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['proxy', 'web', 'tcpTunnel', 'udpTunnel', 'caddy', 'drive', 'socks', 'vpn']):
            raise ValueError("must be one of enum values ('proxy', 'web', 'tcpTunnel', 'udpTunnel', 'caddy', 'drive', 'socks', 'vpn')")
        return value

    @field_validator('permission_mode')
    def permission_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['open', 'closed']):
            raise ValueError("must be one of enum values ('open', 'closed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShareRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in name_selections (list)
        _items = []
        if self.name_selections:
            for _item_name_selections in self.name_selections:
                if _item_name_selections:
                    _items.append(_item_name_selections.to_dict())
            _dict['nameSelections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in basic_auth_users (list)
        _items = []
        if self.basic_auth_users:
            for _item_basic_auth_users in self.basic_auth_users:
                if _item_basic_auth_users:
                    _items.append(_item_basic_auth_users.to_dict())
            _dict['basicAuthUsers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShareRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "envZId": obj.get("envZId"),
            "shareMode": obj.get("shareMode"),
            "nameSelections": [NameSelection.from_dict(_item) for _item in obj["nameSelections"]] if obj.get("nameSelections") is not None else None,
            "privateShareToken": obj.get("privateShareToken"),
            "backendMode": obj.get("backendMode"),
            "target": obj.get("target"),
            "authScheme": obj.get("authScheme"),
            "basicAuthUsers": [AuthUser.from_dict(_item) for _item in obj["basicAuthUsers"]] if obj.get("basicAuthUsers") is not None else None,
            "oauthProvider": obj.get("oauthProvider"),
            "oauthEmailDomains": obj.get("oauthEmailDomains"),
            "oauthRefreshInterval": obj.get("oauthRefreshInterval"),
            "permissionMode": obj.get("permissionMode"),
            "accessGrants": obj.get("accessGrants")
        })
        return _obj


