from enum import Enum

from aiogram.types import ReactionTypeEmoji


class Emoji(Enum):
    THUMBS_UP = "👍"
    THUMBS_DOWN = "👎"
    HEART = "❤"
    FIRE = "🔥"
    FACE_WITH_OPEN_MOUTH = "😮"
    PARTY_POPPER = "🎉"
    STAR_STRUCK = "🤩"
    CRYING_FACE = "😢"
    PILE_OF_POO = "💩"
    CLAPPING_HANDS = "👏"
    OK_HAND = "👌"
    PRAYING_HANDS = "🙏"
    SMILING_FACE_WITH_HEARTS = "🥰"
    THINKING_FACE = "🤔"
    EXPLODING_HEAD = "🤯"
    SCREAM = "😱"
    ENRAGED_FACE = "🤬"
    SMILING_FACE_WITH_HEART_EYES = "😍"
    GRINNING_FACE_WITH_SMILING_EYES = "😁"
    CLOWN_FACE = "🤡"
    YAWNING_FACE = "🥱"
    WOOZY_FACE = "🥴"
    WHALE = "🐳"
    HEART_ON_FIRE = "❤‍🔥"
    NEW_MOON_FACE = "🌚"
    HOT_DOG = "🌭"
    HUNDRED_POINTS = "💯"
    ROLLING_ON_THE_FLOOR_LAUGHING = "🤣"
    HIGH_VOLTAGE = "⚡"
    BANANA = "🍌"
    TROPHY = "🏆"
    BROKEN_HEART = "💔"
    FACE_WITH_RAISED_EYEBROW = "🤨"
    NEUTRAL_FACE = "😐"
    STRAWBERRY = "🍓"
    BOTTLE_WITH_POPPING_CORK = "🍾"
    KISS_MARK = "💋"
    MIDDLE_FINGER = "🖕"
    SMILING_FACE_WITH_HORNS = "😈"
    SLEEPING_FACE = "😴"
    LOUDLY_CRYING_FACE = "😭"
    NERD_FACE = "🤓"
    GHOST = "👻"
    MAN_TECHNOLOGIST = "👨‍💻"
    EYES = "👀"
    JACK_O_LANTERN = "🎃"
    SEE_NO_EVIL_MONKEY = "🙈"
    SMILING_FACE_WITH_HALO = "😇"
    FEARFUL_FACE = "😨"
    HANDSHAKE = "🤝"
    WRITING_HAND = "✍"
    HUGGING_FACE = "🤗"
    SALUTING_FACE = "🫡"
    SANTA_CLAUS = "🎅"
    CHRISTMAS_TREE = "🎄"
    SNOWMAN = "☃"
    NAIL_POLISH = "💅"
    ZANY_FACE = "🤪"
    MOAI = "🗿"
    COOL_BUTTON = "🆒"
    HEART_WITH_ARROW = "💘"
    HEAR_NO_EVIL_MONKEY = "🙉"
    UNICORN = "🦄"
    FACE_BLOWING_A_KISS = "😘"
    PILL = "💊"
    SPEAK_NO_EVIL_MONKEY = "🙊"
    SMILING_FACE_WITH_SUNGLASSES = "😎"
    ALIEN_MONSTER = "👾"
    MAN_SHRUGGING = "🤷‍♂"
    PERSON_SHRUGGING = "🤷"
    WOMAN_SHRUGGING = "🤷‍♀"
    POUTING_FACE = "😡"

    def as_reaction(self) -> ReactionTypeEmoji:
        """Convert enum value to aiogram's ReactionTypeEmoji."""
        return ReactionTypeEmoji(emoji=self.value)
    # ...