"""
Generated by qenerate plugin=pydantic_v2. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    ConfigDict,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.user import User


DEFINITION = """
fragment User on User_v1 {
  name
  org_username
  github_username
  pagerduty_username
  tag_on_merge_requests
}

query OpenshiftGroupsManagedRoles {
  roles: roles_v1 {
    name
    users {
      ...User
    }
    expirationDate
    access {
      cluster {
        name
        auth {
          service
        }
      }
      group
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid'
    )


class ClusterAuthV1(ConfiguredBaseModel):
    service: str = Field(..., alias="service")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    auth: list[ClusterAuthV1] = Field(..., alias="auth")


class AccessV1(ConfiguredBaseModel):
    cluster: Optional[ClusterV1] = Field(..., alias="cluster")
    group: Optional[str] = Field(..., alias="group")


class RoleV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    users: list[User] = Field(..., alias="users")
    expiration_date: Optional[str] = Field(..., alias="expirationDate")
    access: Optional[list[AccessV1]] = Field(..., alias="access")


class OpenshiftGroupsManagedRolesQueryData(ConfiguredBaseModel):
    roles: Optional[list[RoleV1]] = Field(..., alias="roles")


def query(query_func: Callable, **kwargs: Any) -> OpenshiftGroupsManagedRolesQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        OpenshiftGroupsManagedRolesQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return OpenshiftGroupsManagedRolesQueryData(**raw_data)
