"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)


DEFINITION = """
query AcsPolicy {
  acs_policies: acs_policy_v1 {
   	name
    description
    severity
    integrations {
      notifiers {
        jira {
          escalationPolicy {
            name
            channels {
              jiraBoard {
                name
                server {
                  serverUrl
                }
                severityPriorityMappings {
                  name
                  mappings {
                    severity
                    priority
                  }
                }
                issueType
                issueSecurityId
                disable {
                  integrations
                }
              }
              jiraComponent
              jiraLabels
            }
          }
        }
      }
    }
    categories
    scope {
      level
      ... on AcsPolicyScopeCluster_v1 {
				clusters {
          name
        }        
      }
      ... on AcsPolicyScopeNamespace_v1 {
       	namespaces {
          name
          cluster {
            name
          }
        }
      }
    }
	  conditions {
      policyField
      ... on AcsPolicyConditionsCvss_v1 {
        comparison
        score
      }
      ... on AcsPolicyConditionsSeverity_v1 {
        comparison
        level
      }
      ... on AcsPolicyConditionsCve_v1 {
        fixable
      }
      ... on AcsPolicyConditionsImageTag_v1 {
        tags
        negate
      }
      ... on AcsPolicyConditionsImageAge_v1 {
        days
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class JiraServerV1(ConfiguredBaseModel):
    server_url: str = Field(..., alias="serverUrl")


class SeverityPriorityMappingV1(ConfiguredBaseModel):
    severity: str = Field(..., alias="severity")
    priority: str = Field(..., alias="priority")


class JiraSeverityPriorityMappingsV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    mappings: list[SeverityPriorityMappingV1] = Field(..., alias="mappings")


class DisableJiraBoardAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class JiraBoardV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    server: JiraServerV1 = Field(..., alias="server")
    severity_priority_mappings: JiraSeverityPriorityMappingsV1 = Field(..., alias="severityPriorityMappings")
    issue_type: Optional[str] = Field(..., alias="issueType")
    issue_security_id: Optional[str] = Field(..., alias="issueSecurityId")
    disable: Optional[DisableJiraBoardAutomationsV1] = Field(..., alias="disable")


class AppEscalationPolicyChannelsV1(ConfiguredBaseModel):
    jira_board: list[JiraBoardV1] = Field(..., alias="jiraBoard")
    jira_component: Optional[str] = Field(..., alias="jiraComponent")
    jira_labels: Optional[list[str]] = Field(..., alias="jiraLabels")


class AppEscalationPolicyV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    channels: AppEscalationPolicyChannelsV1 = Field(..., alias="channels")


class AcsPolicyIntegrationNotifierJiraV1(ConfiguredBaseModel):
    escalation_policy: AppEscalationPolicyV1 = Field(..., alias="escalationPolicy")


class AcsPolicyIntegrationNotifiersV1(ConfiguredBaseModel):
    jira: Optional[AcsPolicyIntegrationNotifierJiraV1] = Field(..., alias="jira")


class AcsPolicyIntegrationsV1(ConfiguredBaseModel):
    notifiers: Optional[AcsPolicyIntegrationNotifiersV1] = Field(..., alias="notifiers")


class AcsPolicyScopeV1(ConfiguredBaseModel):
    level: str = Field(..., alias="level")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class AcsPolicyScopeClusterV1(AcsPolicyScopeV1):
    clusters: list[ClusterV1] = Field(..., alias="clusters")


class NamespaceV1_ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    cluster: NamespaceV1_ClusterV1 = Field(..., alias="cluster")


class AcsPolicyScopeNamespaceV1(AcsPolicyScopeV1):
    namespaces: list[NamespaceV1] = Field(..., alias="namespaces")


class AcsPolicyConditionsV1(ConfiguredBaseModel):
    policy_field: str = Field(..., alias="policyField")


class AcsPolicyConditionsCvssV1(AcsPolicyConditionsV1):
    comparison: str = Field(..., alias="comparison")
    score: int = Field(..., alias="score")


class AcsPolicyConditionsSeverityV1(AcsPolicyConditionsV1):
    comparison: str = Field(..., alias="comparison")
    level: str = Field(..., alias="level")


class AcsPolicyConditionsCveV1(AcsPolicyConditionsV1):
    fixable: bool = Field(..., alias="fixable")


class AcsPolicyConditionsImageTagV1(AcsPolicyConditionsV1):
    tags: list[str] = Field(..., alias="tags")
    negate: Optional[bool] = Field(..., alias="negate")


class AcsPolicyConditionsImageAgeV1(AcsPolicyConditionsV1):
    days: int = Field(..., alias="days")


class AcsPolicyV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    description: Optional[str] = Field(..., alias="description")
    severity: str = Field(..., alias="severity")
    integrations: Optional[AcsPolicyIntegrationsV1] = Field(..., alias="integrations")
    categories: list[str] = Field(..., alias="categories")
    scope: Union[AcsPolicyScopeClusterV1, AcsPolicyScopeNamespaceV1, AcsPolicyScopeV1] = Field(..., alias="scope")
    conditions: list[Union[AcsPolicyConditionsCvssV1, AcsPolicyConditionsSeverityV1, AcsPolicyConditionsImageTagV1, AcsPolicyConditionsCveV1, AcsPolicyConditionsImageAgeV1, AcsPolicyConditionsV1]] = Field(..., alias="conditions")


class AcsPolicyQueryData(ConfiguredBaseModel):
    acs_policies: Optional[list[AcsPolicyV1]] = Field(..., alias="acs_policies")


def query(query_func: Callable, **kwargs: Any) -> AcsPolicyQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        AcsPolicyQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return AcsPolicyQueryData(**raw_data)
