"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)


DEFINITION = """
query SloDocuments {
  slo_document_v1 {
    name
    labels
    app {
      name
      parentApp {
        name
      }
    }
    namespaces {
      namespace {
        cluster {
          name
        }
        environment {
          product {
            name
          }
        }
      }
    }
    slos {
      name
      dashboard
      SLIType
      SLISpecification
      SLOTarget
      SLOTargetUnit
      SLOParameters {
        window
      }
      SLODetails
      expr
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class AppV1_AppV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class AppV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    parent_app: Optional[AppV1_AppV1] = Field(..., alias="parentApp")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class ProductV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class EnvironmentV1(ConfiguredBaseModel):
    product: ProductV1 = Field(..., alias="product")


class NamespaceV1(ConfiguredBaseModel):
    cluster: ClusterV1 = Field(..., alias="cluster")
    environment: EnvironmentV1 = Field(..., alias="environment")


class SLONamespacesV1(ConfiguredBaseModel):
    namespace: NamespaceV1 = Field(..., alias="namespace")


class SLODocumentSLOSLOParametersV1(ConfiguredBaseModel):
    window: str = Field(..., alias="window")


class SLODocumentSLOV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    dashboard: str = Field(..., alias="dashboard")
    sli_type: str = Field(..., alias="SLIType")
    sli_specification: str = Field(..., alias="SLISpecification")
    slo_target: float = Field(..., alias="SLOTarget")
    slo_target_unit: str = Field(..., alias="SLOTargetUnit")
    slo_parameters: SLODocumentSLOSLOParametersV1 = Field(..., alias="SLOParameters")
    slo_details: str = Field(..., alias="SLODetails")
    expr: str = Field(..., alias="expr")


class SLODocumentV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    labels: Optional[Json] = Field(..., alias="labels")
    app: AppV1 = Field(..., alias="app")
    namespaces: list[SLONamespacesV1] = Field(..., alias="namespaces")
    slos: Optional[list[SLODocumentSLOV1]] = Field(..., alias="slos")


class SloDocumentsQueryData(ConfiguredBaseModel):
    slo_document_v1: Optional[list[SLODocumentV1]] = Field(..., alias="slo_document_v1")


def query(query_func: Callable, **kwargs: Any) -> SloDocumentsQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        SloDocumentsQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return SloDocumentsQueryData(**raw_data)
