# coding=utf-8
# ======================================
# File:     test_loop.py
# Author:   Jackie PENG
# Contact:  jackie.pengzhao@gmail.com
# Created:  2020-02-12
# Desc:
#   Unittest for all qteasy backtest
#   functionalities.
# ======================================
import unittest

import qteasy as qt
import pandas as pd
import numpy as np

from qteasy.core import apply_loop, process_loop_results

from qteasy.history import stack_dataframes, dataframe_to_hp


class TestLoop(unittest.TestCase):
    """通过一个假设但精心设计的例子来测试loop_step以及loop方法的正确性"""

    def setUp(self):
        # 精心设计的模拟股票名称、交易日期、以及股票价格
        self.shares = ['share1', 'share2', 'share3', 'share4', 'share5', 'share6', 'share7']
        self.dates = ['2016/07/01', '2016/07/04', '2016/07/05', '2016/07/06', '2016/07/07',
                      '2016/07/08', '2016/07/11', '2016/07/12', '2016/07/13', '2016/07/14',
                      '2016/07/15', '2016/07/18', '2016/07/19', '2016/07/20', '2016/07/21',
                      '2016/07/22', '2016/07/25', '2016/07/26', '2016/07/27', '2016/07/28',
                      '2016/07/29', '2016/08/01', '2016/08/02', '2016/08/03', '2016/08/04',
                      '2016/08/05', '2016/08/08', '2016/08/09', '2016/08/10', '2016/08/11',
                      '2016/08/12', '2016/08/15', '2016/08/16', '2016/08/17', '2016/08/18',
                      '2016/08/19', '2016/08/22', '2016/08/23', '2016/08/24', '2016/08/25',
                      '2016/08/26', '2016/08/29', '2016/08/30', '2016/08/31', '2016/09/01',
                      '2016/09/02', '2016/09/05', '2016/09/06', '2016/09/07', '2016/09/08',
                      '2016/09/09', '2016/09/12', '2016/09/13', '2016/09/14', '2016/09/15',
                      '2016/09/16', '2016/09/19', '2016/09/20', '2016/09/21', '2016/09/22',
                      '2016/09/23', '2016/09/26', '2016/09/27', '2016/09/28', '2016/09/29',
                      '2016/09/30', '2016/10/10', '2016/10/11', '2016/10/12', '2016/10/13',
                      '2016/10/14', '2016/10/17', '2016/10/18', '2016/10/19', '2016/10/20',
                      '2016/10/21', '2016/10/23', '2016/10/24', '2016/10/25', '2016/10/26',
                      '2016/10/27', '2016/10/29', '2016/10/30', '2016/10/31', '2016/11/01',
                      '2016/11/02', '2016/11/05', '2016/11/06', '2016/11/07', '2016/11/08',
                      '2016/11/09', '2016/11/12', '2016/11/13', '2016/11/14', '2016/11/15',
                      '2016/11/16', '2016/11/19', '2016/11/20', '2016/11/21', '2016/11/22']
        self.dates = [pd.Timestamp(date_text) for date_text in self.dates]
        self.prices = np.array([[5.35, 5.09, 5.03, 4.98, 4.50, 5.09, 4.75],
                                [5.66, 4.84, 5.21, 5.44, 4.35, 5.06, 4.48],
                                [5.79, 4.60, 5.02, 5.45, 4.07, 4.76, 4.56],
                                [5.56, 4.63, 5.50, 5.74, 3.88, 4.62, 4.62],
                                [5.88, 4.64, 5.07, 5.46, 3.74, 4.63, 4.62],
                                [6.25, 4.51, 5.11, 5.45, 3.98, 4.25, 4.59],
                                [5.93, 4.96, 5.15, 5.24, 4.08, 4.13, 4.33],
                                [6.39, 4.65, 5.02, 5.47, 4.00, 3.91, 3.88],
                                [6.31, 4.26, 5.10, 5.58, 4.28, 3.77, 3.47],
                                [5.86, 3.77, 5.24, 5.36, 4.01, 3.43, 3.51],
                                [5.61, 3.39, 4.93, 5.38, 4.14, 3.68, 3.83],
                                [5.31, 3.76, 4.96, 5.30, 4.49, 3.63, 3.67],
                                [5.40, 4.06, 5.40, 5.77, 4.49, 3.94, 3.79],
                                [5.03, 3.87, 5.74, 5.75, 4.46, 4.40, 4.18],
                                [5.38, 3.91, 5.53, 6.15, 4.13, 4.03, 4.02],
                                [5.79, 4.13, 5.79, 6.04, 3.79, 3.93, 4.41],
                                [6.27, 4.27, 5.68, 6.01, 4.23, 3.50, 4.65],
                                [6.59, 4.57, 5.90, 5.71, 4.57, 3.39, 4.89],
                                [6.91, 5.04, 5.75, 5.23, 4.92, 3.30, 4.41],
                                [6.71, 5.31, 6.11, 5.47, 5.28, 3.25, 4.66],
                                [6.33, 5.40, 5.77, 5.79, 5.67, 2.94, 4.37],
                                [6.07, 5.21, 5.85, 5.82, 6.00, 2.71, 4.58],
                                [5.98, 5.06, 5.61, 5.61, 5.89, 2.55, 4.76],
                                [6.46, 4.69, 5.75, 5.31, 5.55, 2.21, 4.37],
                                [6.95, 5.12, 5.50, 5.24, 5.39, 2.29, 4.16],
                                [6.77, 5.27, 5.14, 5.41, 5.26, 2.21, 4.02],
                                [6.70, 5.72, 5.31, 5.60, 5.31, 2.04, 3.77],
                                [6.28, 6.10, 5.68, 5.28, 5.22, 2.39, 3.38],
                                [6.61, 6.27, 5.73, 4.99, 4.90, 2.30, 3.07],
                                [6.25, 6.49, 6.04, 5.09, 4.57, 2.41, 2.90],
                                [6.47, 6.16, 6.27, 5.39, 4.96, 2.40, 2.50],
                                [6.45, 6.26, 6.60, 5.58, 4.82, 2.79, 2.76],
                                [6.88, 6.39, 6.10, 5.33, 4.39, 2.67, 2.29],
                                [7.00, 6.58, 6.25, 5.48, 4.63, 2.27, 2.17],
                                [6.59, 6.20, 6.73, 5.10, 5.05, 2.09, 1.84],
                                [6.59, 5.70, 6.91, 5.39, 4.68, 2.55, 1.83],
                                [6.64, 5.20, 7.01, 5.30, 5.02, 2.22, 2.21],
                                [6.38, 5.37, 7.36, 5.04, 4.84, 2.59, 2.00],
                                [6.10, 5.40, 7.72, 5.51, 4.60, 2.59, 1.76],
                                [6.35, 5.22, 7.68, 5.43, 4.66, 2.95, 1.27],
                                [6.52, 5.38, 7.62, 5.23, 4.41, 2.69, 1.40],
                                [6.87, 5.53, 7.74, 4.99, 4.87, 2.20, 1.11],
                                [6.84, 6.03, 7.53, 5.43, 4.42, 2.69, 1.60],
                                [7.09, 5.77, 7.46, 5.40, 4.08, 2.65, 1.23],
                                [6.88, 5.66, 7.84, 5.60, 4.16, 2.63, 1.59],
                                [6.84, 6.08, 8.11, 5.66, 4.10, 2.14, 1.50],
                                [6.98, 5.62, 8.04, 6.01, 4.43, 2.39, 1.80],
                                [7.02, 5.63, 7.65, 5.64, 4.07, 1.95, 1.55],
                                [7.13, 6.11, 7.52, 5.67, 3.97, 2.32, 1.35],
                                [7.59, 6.03, 7.67, 5.30, 4.16, 2.69, 1.51],
                                [7.61, 6.27, 7.47, 4.91, 4.12, 2.51, 1.08],
                                [7.21, 6.28, 7.44, 5.37, 4.04, 2.62, 1.06],
                                [7.48, 6.52, 7.59, 5.75, 3.84, 2.16, 1.43],
                                [7.66, 7.00, 7.94, 6.08, 3.46, 2.35, 1.43],
                                [7.51, 7.34, 8.25, 6.58, 3.18, 2.31, 1.74],
                                [7.12, 7.34, 7.77, 6.78, 3.10, 1.96, 1.44],
                                [6.97, 7.68, 8.03, 7.20, 3.55, 2.35, 1.83],
                                [6.67, 8.09, 7.87, 7.65, 3.66, 2.58, 1.71],
                                [6.20, 7.68, 7.58, 8.00, 3.66, 2.40, 2.12],
                                [6.34, 7.58, 7.33, 7.92, 3.29, 2.20, 2.45],
                                [6.22, 7.46, 7.22, 8.30, 2.80, 2.31, 2.85],
                                [5.98, 7.59, 6.86, 8.46, 2.88, 2.16, 2.79],
                                [6.37, 7.19, 7.18, 7.99, 3.04, 2.16, 2.91],
                                [6.56, 7.40, 7.54, 8.19, 3.45, 2.20, 3.26],
                                [6.26, 7.48, 7.24, 8.61, 3.88, 1.73, 3.14],
                                [6.69, 7.93, 6.85, 8.66, 3.58, 1.93, 3.53],
                                [7.13, 8.23, 6.60, 8.91, 3.60, 2.25, 3.65],
                                [6.83, 8.35, 6.65, 9.08, 3.97, 2.69, 3.69],
                                [7.31, 8.44, 6.74, 9.34, 4.05, 2.59, 3.50],
                                [7.43, 8.35, 7.19, 8.96, 4.40, 2.14, 3.25],
                                [7.54, 8.58, 7.14, 8.98, 4.06, 1.68, 3.64],
                                [7.18, 8.82, 6.88, 8.50, 3.60, 1.98, 4.00],
                                [7.21, 9.09, 7.14, 8.65, 3.61, 2.14, 3.63],
                                [7.45, 9.02, 7.30, 8.94, 4.10, 1.89, 3.78],
                                [7.37, 8.87, 6.95, 8.63, 3.74, 1.97, 3.42],
                                [6.88, 9.22, 7.02, 8.65, 4.02, 1.99, 3.76],
                                [7.08, 9.04, 7.38, 8.40, 3.95, 2.37, 3.62],
                                [6.75, 8.60, 7.50, 8.38, 3.81, 2.14, 3.67],
                                [6.60, 8.48, 7.60, 8.23, 3.71, 2.35, 3.61],
                                [6.21, 8.71, 7.15, 8.04, 3.94, 1.86, 3.39],
                                [6.36, 8.79, 7.30, 7.91, 4.43, 2.14, 3.43],
                                [6.82, 8.93, 7.80, 7.57, 4.07, 2.39, 3.33],
                                [6.45, 9.36, 8.15, 7.73, 4.04, 2.53, 3.03],
                                [6.85, 9.68, 8.40, 7.74, 4.34, 2.47, 3.28],
                                [6.48, 10.16, 8.87, 8.07, 4.80, 2.93, 3.46],
                                [6.10, 10.56, 8.53, 7.99, 5.18, 3.09, 3.25],
                                [5.64, 10.63, 8.94, 7.92, 4.90, 2.93, 2.95],
                                [6.01, 10.55, 8.52, 8.40, 5.40, 3.22, 2.87],
                                [6.21, 10.65, 8.80, 8.80, 5.73, 3.06, 2.63],
                                [6.61, 10.55, 8.92, 8.47, 5.62, 2.90, 2.40],
                                [7.02, 10.19, 9.20, 8.07, 5.20, 2.68, 2.53],
                                [7.04, 10.48, 8.71, 7.87, 4.85, 2.46, 2.96],
                                [6.77, 10.36, 8.25, 8.02, 5.18, 2.41, 3.26],
                                [7.09, 10.03, 8.19, 8.39, 4.72, 2.74, 2.97],
                                [6.65, 10.24, 7.80, 8.69, 4.62, 3.15, 3.16],
                                [7.07, 10.01, 7.69, 8.81, 4.55, 3.40, 3.58],
                                [6.80, 10.14, 7.23, 8.99, 4.37, 3.82, 3.23],
                                [6.79, 10.31, 6.98, 9.10, 4.26, 4.02, 3.62],
                                [6.48, 9.88, 7.07, 8.90, 4.25, 3.76, 3.13],
                                [6.39, 10.05, 6.95, 8.87, 4.59, 4.10, 2.93]])

        # 精心设计的模拟PT持股仓位目标信号：
        self.pt_signals = np.array([[0.000, 0.000, 0.000, 0.000, 0.250, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.250, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.250, 0.100, 0.150],
                                    [0.200, 0.200, 0.000, 0.000, 0.250, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.250, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.200, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.100, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.050, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.050, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.050, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.050, 0.000, 0.062, 0.100, 0.150],
                                    [0.133, 0.200, 0.050, 0.000, 0.062, 0.100, 0.000],
                                    [0.133, 0.200, 0.050, 0.000, 0.262, 0.100, 0.000],
                                    [0.133, 0.200, 0.050, 0.000, 0.262, 0.100, 0.000],
                                    [0.133, 0.200, 0.050, 0.000, 0.262, 0.100, 0.000],
                                    [0.066, 0.200, 0.050, 0.150, 0.262, 0.100, 0.000],
                                    [0.066, 0.200, 0.050, 0.150, 0.262, 0.100, 0.000],
                                    [0.066, 0.200, 0.050, 0.150, 0.262, 0.100, 0.000],
                                    [0.066, 0.200, 0.050, 0.150, 0.262, 0.100, 0.000],
                                    [0.066, 0.200, 0.050, 0.150, 0.262, 0.100, 0.000],
                                    [0.066, 0.200, 0.250, 0.150, 0.000, 0.300, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.386, 0.136, 0.170, 0.102, 0.000, 0.204, 0.000],
                                    [0.460, 0.119, 0.149, 0.089, 0.000, 0.179, 0.000],
                                    [0.460, 0.119, 0.149, 0.089, 0.000, 0.179, 0.000],
                                    [0.460, 0.119, 0.149, 0.089, 0.000, 0.179, 0.000],
                                    [0.446, 0.116, 0.145, 0.087, 0.000, 0.087, 0.116],
                                    [0.446, 0.116, 0.145, 0.087, 0.000, 0.087, 0.116],
                                    [0.446, 0.116, 0.145, 0.087, 0.000, 0.087, 0.116],
                                    [0.446, 0.116, 0.145, 0.087, 0.000, 0.087, 0.116],
                                    [0.446, 0.116, 0.145, 0.087, 0.000, 0.087, 0.116],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.400, 0.208, 0.130, 0.078, 0.000, 0.078, 0.104],
                                    [0.370, 0.193, 0.120, 0.072, 0.072, 0.072, 0.096],
                                    [0.000, 0.222, 0.138, 0.222, 0.083, 0.222, 0.111],
                                    [0.000, 0.222, 0.138, 0.222, 0.083, 0.222, 0.111],
                                    [0.121, 0.195, 0.121, 0.195, 0.073, 0.195, 0.097],
                                    [0.121, 0.195, 0.121, 0.195, 0.073, 0.195, 0.097],
                                    [0.121, 0.195, 0.121, 0.195, 0.073, 0.195, 0.097],
                                    [0.121, 0.195, 0.121, 0.195, 0.073, 0.195, 0.097],
                                    [0.121, 0.195, 0.121, 0.195, 0.073, 0.195, 0.097],
                                    [0.121, 0.195, 0.121, 0.195, 0.073, 0.195, 0.097],
                                    [0.121, 0.195, 0.121, 0.195, 0.073, 0.195, 0.097],
                                    [0.121, 0.195, 0.121, 0.195, 0.073, 0.195, 0.097],
                                    [0.200, 0.320, 0.200, 0.000, 0.120, 0.000, 0.160],
                                    [0.200, 0.320, 0.200, 0.000, 0.120, 0.000, 0.160],
                                    [0.200, 0.320, 0.200, 0.000, 0.120, 0.000, 0.160],
                                    [0.200, 0.320, 0.200, 0.000, 0.120, 0.000, 0.160],
                                    [0.200, 0.320, 0.200, 0.000, 0.120, 0.000, 0.160],
                                    [0.200, 0.320, 0.200, 0.000, 0.120, 0.000, 0.160],
                                    [0.200, 0.320, 0.200, 0.000, 0.120, 0.000, 0.160],
                                    [0.200, 0.320, 0.200, 0.000, 0.120, 0.000, 0.160],
                                    [0.047, 0.380, 0.238, 0.000, 0.142, 0.000, 0.190],
                                    [0.047, 0.380, 0.238, 0.000, 0.142, 0.000, 0.190],
                                    [0.043, 0.434, 0.217, 0.000, 0.130, 0.000, 0.173],
                                    [0.043, 0.434, 0.217, 0.000, 0.130, 0.000, 0.173],
                                    [0.043, 0.434, 0.217, 0.000, 0.130, 0.000, 0.173],
                                    [0.043, 0.434, 0.217, 0.000, 0.130, 0.000, 0.173],
                                    [0.043, 0.434, 0.217, 0.000, 0.130, 0.000, 0.173],
                                    [0.043, 0.434, 0.217, 0.000, 0.130, 0.000, 0.173],
                                    [0.045, 0.454, 0.227, 0.000, 0.000, 0.000, 0.272],
                                    [0.045, 0.454, 0.227, 0.000, 0.000, 0.000, 0.272],
                                    [0.050, 0.000, 0.250, 0.000, 0.000, 0.000, 0.300],
                                    [0.050, 0.000, 0.250, 0.000, 0.000, 0.000, 0.300],
                                    [0.050, 0.000, 0.250, 0.000, 0.000, 0.000, 0.300],
                                    [0.050, 0.000, 0.250, 0.000, 0.000, 0.000, 0.300],
                                    [0.050, 0.000, 0.250, 0.000, 0.000, 0.000, 0.300],
                                    [0.050, 0.000, 0.250, 0.000, 0.000, 0.000, 0.300],
                                    [0.050, 0.000, 0.250, 0.000, 0.000, 0.000, 0.300],
                                    [0.050, 0.000, 0.250, 0.000, 0.000, 0.000, 0.300],
                                    [0.000, 0.000, 0.400, 0.000, 0.000, 0.000, 0.300],
                                    [0.000, 0.000, 0.400, 0.000, 0.000, 0.000, 0.300],
                                    [0.000, 0.000, 0.400, 0.000, 0.000, 0.000, 0.300]])

        # 精心设计的模拟PS比例交易信号，与模拟PT信号高度相似
        self.ps_signals = np.array([[0.000, 0.000, 0.000, 0.000, 0.250, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.100, 0.150],
                                    [0.200, 0.200, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.100, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, -0.750, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [-0.333, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, -0.500, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, -1.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.200, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [-0.500, 0.000, 0.000, 0.150, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.200, 0.000, -1.000, 0.200, 0.000],
                                    [0.500, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.200, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, -0.500, 0.200],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.200, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.150, 0.000, 0.000],
                                    [-1.000, 0.000, 0.000, 0.250, 0.000, 0.250, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.250, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, -1.000, 0.000, -1.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [-0.800, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.100, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, -1.000, 0.000, 0.100],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, -1.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [-1.000, 0.000, 0.150, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000],
                                    [0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000]])

        # 精心设计的模拟VS股票交易信号，与模拟PS信号类似
        self.vs_signals = np.array([[000, 000, 000, 000, 500, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 300, 300],
                                    [400, 400, 000, 000, 000, 000, 000],
                                    [000, 000, 250, 000, 000, 000, 000],
                                    [000, 000, 000, 000, -400, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [-200, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, -200, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, -300],
                                    [000, 000, 000, 000, 500, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [-200, 000, 000, 300, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 400, 000, -300, 600, 000],
                                    [500, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [600, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, -400, 600],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 500, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 300, 000, 000],
                                    [-500, 000, 000, 500, 000, 200, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [500, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, -700, 000, -600, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [-400, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 300, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, -600, 000, 300],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, -300, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [-200, 000, 700, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000],
                                    [000, 000, 000, 000, 000, 000, 000]],
                                   dtype='float')

        # 精心设计的模拟多价格交易信号，模拟50个交易日对三只股票的操作
        self.multi_shares = ['000010', '000030', '000039']
        self.multi_dates = ['2016/07/01', '2016/07/04', '2016/07/05', '2016/07/06', '2016/07/07',
                            '2016/07/08', '2016/07/11', '2016/07/12', '2016/07/13', '2016/07/14',
                            '2016/07/15', '2016/07/18', '2016/07/19', '2016/07/20', '2016/07/21',
                            '2016/07/22', '2016/07/25', '2016/07/26', '2016/07/27', '2016/07/28',
                            '2016/07/29', '2016/08/01', '2016/08/02', '2016/08/03', '2016/08/04',
                            '2016/08/05', '2016/08/08', '2016/08/09', '2016/08/10', '2016/08/11',
                            '2016/08/12', '2016/08/15', '2016/08/16', '2016/08/17', '2016/08/18',
                            '2016/08/19', '2016/08/22', '2016/08/23', '2016/08/24', '2016/08/25',
                            '2016/08/26', '2016/08/29', '2016/08/30', '2016/08/31', '2016/09/01',
                            '2016/09/02', '2016/09/05', '2016/09/06', '2016/09/07', '2016/09/08']
        self.multi_dates = [pd.Timestamp(date_text) for date_text in self.multi_dates]

        # 精心设计的模拟交易价格包括开盘价、最高价和收盘价
        self.multi_prices_open = np.array([[10.02, 9.88, 7.26],
                                           [10.00, 9.88, 7.00],
                                           [9.98, 9.89, 6.88],
                                           [9.97, 9.75, 6.91],
                                           [9.99, 9.74, np.nan],
                                           [10.01, 9.80, 6.81],
                                           [10.04, 9.62, 6.63],
                                           [10.06, 9.65, 6.45],
                                           [10.06, 9.58, 6.16],
                                           [10.11, 9.67, 6.24],
                                           [10.11, 9.81, 5.96],
                                           [10.07, 9.80, 5.97],
                                           [10.06, 10.00, 5.96],
                                           [10.09, 9.95, 6.20],
                                           [10.03, 10.10, 6.35],
                                           [10.02, 10.06, 6.11],
                                           [10.06, 10.14, 6.37],
                                           [10.08, 9.90, 5.58],
                                           [9.99, 10.20, 5.65],
                                           [10.00, 10.29, 5.65],
                                           [10.03, 9.86, 5.19],
                                           [10.02, 9.48, 5.42],
                                           [10.06, 10.01, 6.30],
                                           [10.03, 10.24, 6.15],
                                           [9.97, 10.26, 6.05],
                                           [9.94, 10.24, 5.89],
                                           [9.83, 10.12, 5.22],
                                           [9.78, 10.65, 5.20],
                                           [9.77, 10.64, 5.07],
                                           [9.91, 10.56, 6.04],
                                           [9.92, 10.42, 6.12],
                                           [9.97, 10.43, 5.85],
                                           [9.91, 10.29, 5.67],
                                           [9.90, 10.30, 6.02],
                                           [9.88, 10.44, 6.04],
                                           [9.91, 10.60, 7.07],
                                           [9.63, 10.67, 7.64],
                                           [9.64, 10.46, 7.99],
                                           [9.57, 10.39, 7.59],
                                           [9.55, 10.90, 8.73],
                                           [9.58, 11.01, 8.72],
                                           [9.61, 11.01, 8.97],
                                           [9.62, np.nan, 8.58],
                                           [9.55, np.nan, 8.71],
                                           [9.57, 10.82, 8.77],
                                           [9.61, 11.02, 8.40],
                                           [9.63, 10.96, 7.95],
                                           [9.64, 11.55, 7.76],
                                           [9.61, 11.74, 8.25],
                                           [9.56, 11.80, 7.51]])
        self.multi_prices_high = np.array([[10.07, 9.91, 7.41],
                                           [10.00, 10.04, 7.31],
                                           [10.00, 9.93, 7.14],
                                           [10.00, 10.04, 7.00],
                                           [10.03, 9.84, np.nan],
                                           [10.03, 9.88, 6.82],
                                           [10.04, 9.99, 6.96],
                                           [10.09, 9.70, 6.85],
                                           [10.10, 9.67, 6.50],
                                           [10.14, 9.71, 6.34],
                                           [10.11, 9.85, 6.04],
                                           [10.10, 9.90, 6.02],
                                           [10.09, 10.00, 6.12],
                                           [10.09, 10.20, 6.38],
                                           [10.10, 10.11, 6.43],
                                           [10.05, 10.18, 6.46],
                                           [10.07, 10.21, 6.43],
                                           [10.09, 10.26, 6.27],
                                           [10.10, 10.38, 5.77],
                                           [10.00, 10.47, 6.01],
                                           [10.04, 10.42, 5.67],
                                           [10.04, 10.07, 5.67],
                                           [10.06, 10.24, 6.35],
                                           [10.09, 10.27, 6.32],
                                           [10.05, 10.38, 6.43],
                                           [9.97, 10.43, 6.36],
                                           [9.96, 10.39, 5.79],
                                           [9.86, 10.65, 5.47],
                                           [9.77, 10.84, 5.65],
                                           [9.92, 10.65, 6.04],
                                           [9.94, 10.73, 6.14],
                                           [9.97, 10.63, 6.23],
                                           [9.97, 10.51, 5.83],
                                           [9.92, 10.35, 6.25],
                                           [9.92, 10.46, 6.27],
                                           [9.92, 10.63, 7.12],
                                           [9.93, 10.74, 7.82],
                                           [9.64, 10.76, 8.14],
                                           [9.58, 10.54, 8.27],
                                           [9.60, 11.02, 8.92],
                                           [9.58, 11.12, 8.76],
                                           [9.62, 11.17, 9.15],
                                           [9.62, np.nan, 8.90],
                                           [9.64, np.nan, 9.01],
                                           [9.59, 10.92, 9.16],
                                           [9.62, 11.15, 9.00],
                                           [9.63, 11.11, 8.27],
                                           [9.70, 11.55, 7.99],
                                           [9.66, 11.95, 8.33],
                                           [9.64, 11.93, 8.25]])
        self.multi_prices_close = np.array([[10.04, 9.68, 6.64],
                                            [10.00, 9.87, 7.26],
                                            [10.00, 9.86, 7.03],
                                            [9.99, 9.87, 6.87],
                                            [9.97, 9.79, np.nan],
                                            [9.99, 9.82, 6.64],
                                            [10.03, 9.80, 6.85],
                                            [10.03, 9.66, 6.70],
                                            [10.06, 9.62, 6.39],
                                            [10.06, 9.58, 6.22],
                                            [10.11, 9.69, 5.92],
                                            [10.09, 9.78, 5.91],
                                            [10.07, 9.75, 6.11],
                                            [10.06, 9.96, 5.91],
                                            [10.09, 9.90, 6.23],
                                            [10.03, 10.04, 6.28],
                                            [10.03, 10.06, 6.28],
                                            [10.06, 10.08, 6.27],
                                            [10.08, 10.24, 5.70],
                                            [10.00, 10.24, 5.56],
                                            [9.99, 10.24, 5.67],
                                            [10.03, 9.86, 5.16],
                                            [10.03, 10.13, 5.69],
                                            [10.06, 10.12, 6.32],
                                            [10.03, 10.10, 6.14],
                                            [9.97, 10.25, 6.25],
                                            [9.94, 10.24, 5.79],
                                            [9.83, 10.22, 5.26],
                                            [9.77, 10.75, 5.05],
                                            [9.84, 10.64, 5.45],
                                            [9.91, 10.56, 6.06],
                                            [9.93, 10.60, 6.21],
                                            [9.96, 10.42, 5.69],
                                            [9.91, 10.25, 5.46],
                                            [9.91, 10.24, 6.02],
                                            [9.88, 10.49, 6.69],
                                            [9.91, 10.57, 7.43],
                                            [9.64, 10.63, 7.72],
                                            [9.56, 10.48, 8.16],
                                            [9.57, 10.37, 7.83],
                                            [9.55, 10.96, 8.70],
                                            [9.57, 11.02, 8.71],
                                            [9.61, np.nan, 8.88],
                                            [9.61, np.nan, 8.54],
                                            [9.55, 10.88, 8.87],
                                            [9.57, 10.87, 8.87],
                                            [9.63, 11.01, 8.18],
                                            [9.64, 11.01, 7.80],
                                            [9.65, 11.58, 7.97],
                                            [9.62, 11.80, 8.25]])
        # 精心设计的多重交易信号，交易信号包括三组，分别作用于开盘价、最高价和收盘价
        # 此时的关键是股票交割期的处理，交割期不为0时，以交易日为单位交割
        self.multi_signals = []
        # multisignal的第一组信号为开盘价信号
        self.multi_signals.append(
                pd.DataFrame(np.array([[0.000, 0.000, 0.000],
                                       [0.000, -0.500, 0.000],
                                       [0.000, -0.500, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.150, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.300, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.300],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.350, 0.250],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.100, 0.000, 0.350],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.200, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.050, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000]]),
                             columns=self.multi_shares,
                             index=self.multi_dates
                             )
        )
        # 第二组信号为最高价信号
        self.multi_signals.append(
                pd.DataFrame(np.array([[0.000, 0.150, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, -0.200, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.200],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000]]),
                             columns=self.multi_shares,
                             index=self.multi_dates
                             )
        )
        # 第三组信号为收盘价信号
        self.multi_signals.append(
                pd.DataFrame(np.array([[0.000, 0.200, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [-0.500, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, -0.800],
                                       [0.000, 0.000, 0.000],
                                       [0.000, -1.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [-0.750, 0.000, 0.000],
                                       [0.000, 0.000, -0.850],
                                       [0.000, 0.000, 0.000],
                                       [0.000, -0.700, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, -1.000],
                                       [0.000, 0.000, 0.000],
                                       [0.000, 0.000, 0.000],
                                       [-1.000, 0.000, 0.000],
                                       [0.000, -1.000, 0.000],
                                       [0.000, 0.000, 0.000]]),
                             columns=self.multi_shares,
                             index=self.multi_dates
                             )
        )

        # 交易回测所需的价格也有三组，分别是开盘价、最高价和收盘价
        self.multi_histories = []
        # multisignal的第一组信号为开盘价信号
        self.multi_histories.append(
                pd.DataFrame(self.multi_prices_open,
                             columns=self.multi_shares,
                             index=self.multi_dates
                             )
        )
        # 第二组信号为最高价信号
        self.multi_histories.append(
                pd.DataFrame(self.multi_prices_high,
                             columns=self.multi_shares,
                             index=self.multi_dates
                             )
        )
        # 第三组信号为收盘价信号
        self.multi_histories.append(
                pd.DataFrame(self.multi_prices_close,
                             columns=self.multi_shares,
                             index=self.multi_dates
                             )
        )

        # 将上面生成的数据转化成符合要求的交易信号HistoryPanel
        self.pt_signal_hp = dataframe_to_hp(
                pd.DataFrame(self.pt_signals, index=self.dates, columns=self.shares),
                htypes='close'
        )
        self.ps_signal_hp = dataframe_to_hp(
                pd.DataFrame(self.ps_signals, index=self.dates, columns=self.shares),
                htypes='close'
        )
        self.vs_signal_hp = dataframe_to_hp(
                pd.DataFrame(self.vs_signals, index=self.dates, columns=self.shares),
                htypes='close'
        )
        self.multi_signal_hp = stack_dataframes(
                self.multi_signals,
                dataframe_as='htypes',
                htypes='open, high, close'
        )
        # 将生成的数据组装成符合要求的交易历史价格清单
        self.history_list = dataframe_to_hp(
                pd.DataFrame(self.prices, index=self.dates, columns=self.shares),
                htypes='close'
        )
        # 将生成的数据组装成符合要求的多重交易历史价格清单
        self.multi_history_list = stack_dataframes(
                self.multi_histories,
                dataframe_as='htypes',
                htypes='open, high, close'
        )

        # 精心设计的交易员Operator对象，承载交易信号后用于apply_loop的测试
        self.op_pt_batch = qt.Operator(['all'], signal_type='pt', op_type='batch')
        self.op_ps_batch = qt.Operator(['all'], signal_type='ps', op_type='batch')
        self.op_vs_batch = qt.Operator(['all'], signal_type='vs', op_type='batch')
        self.op_multi_batch = qt.Operator(['all'], signal_type='ps', op_type='batch')
        # 不调用交易员Operator对象的create_signal()方法，直接设置相应交易员的交易信号列表
        # 注意，正常情况下应该使用operator.assign_hist_data()来设置分配历史数据，同时使用
        # operator.create_signal()方法来生成交易清单，这里直接设置的方法仅限测试时使用
        self.op_pt_batch._op_list = self.pt_signal_hp.values
        self.op_pt_batch._op_list_hdates = {hdate: idx for hdate, idx in zip(self.dates, range(len(self.dates)))}
        self.op_pt_batch._op_list_shares = {share: idx for share, idx in zip(self.shares, range(7))}
        self.op_pt_batch._op_list_price_types = {price: idx for price, idx in zip(['close'], range(1))}
        self.op_ps_batch._op_list = self.ps_signal_hp.values
        self.op_ps_batch._op_list_hdates = {hdate: idx for hdate, idx in zip(self.dates, range(len(self.dates)))}
        self.op_ps_batch._op_list_shares = {share: idx for share, idx in zip(self.shares, range(7))}
        self.op_ps_batch._op_list_price_types = {price: idx for price, idx in zip(['close'], range(1))}
        self.op_vs_batch._op_list = self.vs_signal_hp.values
        self.op_vs_batch._op_list_hdates = {hdate: idx for hdate, idx in zip(self.dates, range(len(self.dates)))}
        self.op_vs_batch._op_list_shares = {share: idx for share, idx in zip(self.shares, range(7))}
        self.op_vs_batch._op_list_price_types = {price: idx for price, idx in zip(['close'], range(1))}
        self.op_multi_batch._op_list = self.multi_signal_hp.values
        self.op_multi_batch._op_list_hdates = {hdate: idx for hdate, idx in zip(self.multi_dates,
                                                                                range(len(self.multi_dates)))}
        self.op_multi_batch._op_list_shares = {share: idx for share, idx in zip(self.multi_shares, range(3))}
        self.op_multi_batch._op_list_price_types = {price: idx for price, idx in zip(['open', 'high', 'close'],
                                                                                     range(3))}

        # 设置回测参数
        self.cash = qt.CashPlan(['2016/07/01', '2016/08/12', '2016/09/23'], [10000, 10000, 10000])
        self.rate = qt.set_cost(buy_fix=0,
                                sell_fix=0,
                                buy_rate=0,
                                sell_rate=0,
                                buy_min=0,
                                sell_min=0,
                                slipage=0)
        self.rate2 = qt.set_cost(buy_fix=0,
                                 sell_fix=0,
                                 buy_rate=0,
                                 sell_rate=0,
                                 buy_min=10,
                                 sell_min=5,
                                 slipage=0)

        # 模拟PT信号回测结果
        # PT信号，先卖后买，交割期为0
        self.pt_res_sb00 = np.array(
                [[0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 0.0000, 7500.0000, 0.0000, 10000.0000],
                 [0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 0.0000, 7500.0000, 0.0000, 9916.6667],
                 [0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 321.0892, 6035.8333, 0.0000, 9761.1111],
                 [348.0151, 417.9188, 0.0000, 0.0000, 555.5556, 0.0000, 321.0892, 2165.9050, 0.0000, 9674.8209],
                 [348.0151, 417.9188, 0.0000, 0.0000, 555.5556, 0.0000, 321.0892, 2165.9050, 0.0000, 9712.5872],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9910.7240],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9919.3782],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9793.0692],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9513.8217],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9123.5935],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9000.5995],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9053.4865],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9248.7142],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9161.1372],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9197.3369],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9504.6981],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9875.2461],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 10241.5400],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 10449.2398],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 10628.3269],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 10500.7893],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 0.0000, 5233.1396, 0.0000, 10449.2776],
                 [348.0151, 417.9188, 0.0000, 0.0000, 459.8694, 0.0000, 0.0000, 3433.8551, 0.0000, 10338.2857],
                 [348.0151, 417.9188, 0.0000, 0.0000, 459.8694, 0.0000, 0.0000, 3433.8551, 0.0000, 10194.3474],
                 [348.0151, 417.9188, 0.0000, 0.0000, 459.8694, 0.0000, 0.0000, 3433.8551, 0.0000, 10471.0008],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10411.2629],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10670.0618],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10652.4799],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10526.1488],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10458.6614],
                 [101.4983, 417.9188, 821.7315, 288.6672, 0.0000, 2576.1284, 0.0000, 4487.0722, 0.0000, 20609.0270],
                 [1216.3282, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 21979.4972],
                 [1216.3282, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 21880.9628],
                 [1216.3282, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 21630.0454],
                 [1216.3282, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 20968.0007],
                 [1216.3282, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 21729.9339],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 21107.6400],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 21561.1745],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 21553.0916],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 22316.9366],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 22084.2862],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 21777.3543],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 22756.8225],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 22843.4697],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 0.0000, 2172.0393, 0.0000, 22762.1766],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 1448.0262, 0.0000, 0.0000, 22257.0973],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 1448.0262, 0.0000, 0.0000, 23136.5259],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 1448.0262, 0.0000, 0.0000, 21813.7852],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 1448.0262, 0.0000, 0.0000, 22395.3204],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 1448.0262, 0.0000, 0.0000, 23717.6858],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 1607.1030, 1448.0262, 0.0000, 0.0000, 22715.4263],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 22498.3254],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 23341.1733],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 24162.3941],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 24847.1508],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 23515.9755],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 24555.8997],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 24390.6372],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 24073.3309],
                 [1216.3282, 417.9188, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 2455.7405, 0.0000, 24394.6500],
                 [2076.3314, 903.0334, 511.8829, 288.6672, 0.0000, 669.7975, 1448.0262, 3487.5655, 0.0000, 34904.8150],
                 [0.0000, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 4608.8037, 0.0000, 34198.4475],
                 [0.0000, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 4608.8037, 0.0000, 33753.0190],
                 [644.7274, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 379.3918, 0.0000, 34953.8178],
                 [644.7274, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 379.3918, 0.0000, 33230.2498],
                 [644.7274, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 379.3918, 0.0000, 35026.7819],
                 [644.7274, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 379.3918, 0.0000, 36976.2649],
                 [644.7274, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 379.3918, 0.0000, 38673.8147],
                 [644.7274, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 379.3918, 0.0000, 38717.3429],
                 [644.7274, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 379.3918, 0.0000, 36659.0854],
                 [644.7274, 903.0334, 511.8829, 897.4061, 0.0000, 3514.8404, 1448.0262, 379.3918, 0.0000, 35877.9607],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 36874.4840],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 37010.2695],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 38062.3510],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 36471.1357],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 37534.9927],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 37520.2569],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 36747.7952],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 36387.9409],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 35925.9715],
                 [644.7274, 1337.8498, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 2853.5665, 0.0000, 36950.7028],
                 [644.7274, 1657.3981, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 0.0000, 0.0000, 37383.2463],
                 [644.7274, 1657.3981, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 0.0000, 0.0000, 37761.2724],
                 [644.7274, 1657.3981, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 0.0000, 0.0000, 39548.2653],
                 [644.7274, 1657.3981, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 0.0000, 0.0000, 41435.1291],
                 [644.7274, 1657.3981, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 0.0000, 0.0000, 41651.6261],
                 [644.7274, 1657.3981, 1071.9327, 0.0000, 1229.1495, 0.0000, 1448.0262, 0.0000, 0.0000, 41131.9920],
                 [644.7274, 1657.3981, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 0.0000, 0.0000, 41286.4702],
                 [644.7274, 1657.3981, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 0.0000, 0.0000, 40978.7259],
                 [644.7274, 0.0000, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 17485.5497, 0.0000, 40334.5453],
                 [644.7274, 0.0000, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 17485.5497, 0.0000, 41387.9172],
                 [644.7274, 0.0000, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 17485.5497, 0.0000, 42492.6707],
                 [644.7274, 0.0000, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 17485.5497, 0.0000, 42953.7188],
                 [644.7274, 0.0000, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 17485.5497, 0.0000, 42005.1092],
                 [644.7274, 0.0000, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 17485.5497, 0.0000, 42017.9106],
                 [644.7274, 0.0000, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 17485.5497, 0.0000, 43750.2824],
                 [644.7274, 0.0000, 1071.9327, 0.0000, 0.0000, 0.0000, 3760.7116, 17485.5497, 0.0000, 41766.8679],
                 [0.0000, 0.0000, 2461.8404, 0.0000, 0.0000, 0.0000, 3760.7116, 12161.6930, 0.0000, 42959.1150],
                 [0.0000, 0.0000, 2461.8404, 0.0000, 0.0000, 0.0000, 3760.7116, 12161.6930, 0.0000, 41337.9320],
                 [0.0000, 0.0000, 2461.8404, 0.0000, 0.0000, 0.0000, 3760.7116, 12161.6930, 0.0000, 40290.3688]])
        # PT信号，先买后卖，交割期为0
        self.pt_res_bs00 = np.array(
                [[0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 0.0000, 7500.0000, 0.0000, 10000.0000],
                 [0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 0.0000, 7500.0000, 0.0000, 9916.6667],
                 [0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 321.0892, 6035.8333, 0.0000, 9761.1111],
                 [348.0151, 417.9188, 0.0000, 0.0000, 555.5556, 0.0000, 321.0892, 2165.9050, 0.0000, 9674.8209],
                 [348.0151, 417.9188, 0.0000, 0.0000, 555.5556, 0.0000, 321.0892, 2165.9050, 0.0000, 9712.5872],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9910.7240],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9919.3782],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9793.0692],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9513.8217],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9123.5935],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9000.5995],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9053.4865],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9248.7142],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9161.1372],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9197.3369],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9504.6981],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 9875.2461],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 10241.5400],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 10449.2398],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 10628.3269],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 321.0892, 3762.5512, 0.0000, 10500.7893],
                 [348.0151, 417.9188, 0.0000, 0.0000, 154.3882, 0.0000, 0.0000, 5233.1396, 0.0000, 10449.2776],
                 [348.0151, 417.9188, 0.0000, 0.0000, 459.8694, 0.0000, 0.0000, 3433.8551, 0.0000, 10338.2857],
                 [348.0151, 417.9188, 0.0000, 0.0000, 459.8694, 0.0000, 0.0000, 3433.8551, 0.0000, 10194.3474],
                 [348.0151, 417.9188, 0.0000, 0.0000, 459.8694, 0.0000, 0.0000, 3433.8551, 0.0000, 10471.0008],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10411.2629],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10670.0618],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10652.4799],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10526.1488],
                 [101.4983, 417.9188, 0.0000, 288.6672, 459.8694, 0.0000, 0.0000, 3541.0848, 0.0000, 10458.6614],
                 [101.4983, 417.9188, 821.7315, 288.6672, 0.0000, 2576.1284, 0.0000, 4487.0722, 0.0000, 20609.0270],
                 [797.1684, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 2703.5808, 0.0000, 21979.4972],
                 [1190.1307, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 21700.7241],
                 [1190.1307, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 21446.6630],
                 [1190.1307, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 20795.3593],
                 [1190.1307, 417.9188, 821.7315, 288.6672, 0.0000, 1607.1030, 0.0000, 0.0000, 0.0000, 21557.2924],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 20933.6887],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 21392.5581],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 21390.2918],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 22147.7562],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 21910.9053],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 21594.2980],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 22575.4380],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 22655.8312],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 0.0000, 2201.6110, 0.0000, 22578.4365],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 1467.7407, 0.0000, 0.0000, 22073.2661],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 1467.7407, 0.0000, 0.0000, 22955.2367],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 1467.7407, 0.0000, 0.0000, 21628.1647],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 1467.7407, 0.0000, 0.0000, 22203.4237],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 1607.1030, 1467.7407, 0.0000, 0.0000, 23516.2598],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 22505.8428],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 22199.1042],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 23027.9302],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 23848.5806],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 24540.8871],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 23205.6838],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 24267.6685],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 24115.3796],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 23814.3667],
                 [1190.1307, 417.9188, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 2278.3728, 0.0000, 24133.6611],
                 [2061.6837, 896.6628, 507.6643, 288.6672, 0.0000, 699.3848, 1467.7407, 3285.8830, 0.0000, 34658.5742],
                 [0.0000, 896.6628, 507.6643, 466.6033, 0.0000, 1523.7106, 1467.7407, 12328.8684, 0.0000, 33950.7917],
                 [0.0000, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 4380.3797, 0.0000, 33711.4045],
                 [644.1423, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 154.8061, 0.0000, 34922.0959],
                 [644.1423, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 154.8061, 0.0000, 33237.1081],
                 [644.1423, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 154.8061, 0.0000, 35031.8071],
                 [644.1423, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 154.8061, 0.0000, 36976.3376],
                 [644.1423, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 154.8061, 0.0000, 38658.5245],
                 [644.1423, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 154.8061, 0.0000, 38712.2854],
                 [644.1423, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 154.8061, 0.0000, 36655.3125],
                 [644.1423, 896.6628, 507.6643, 936.6623, 0.0000, 3464.7832, 1467.7407, 154.8061, 0.0000, 35904.3692],
                 [644.1423, 902.2617, 514.8253, 0.0000, 15.5990, 0.0000, 1467.7407, 14821.9004, 0.0000, 36873.9080],
                 [644.1423, 902.2617, 514.8253, 0.0000, 1220.8683, 0.0000, 1467.7407, 10470.8781, 0.0000, 36727.7895],
                 [644.1423, 1338.1812, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 2753.1120, 0.0000, 37719.9840],
                 [644.1423, 1338.1812, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 2753.1120, 0.0000, 36138.1277],
                 [644.1423, 1338.1812, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 2753.1120, 0.0000, 37204.0760],
                 [644.1423, 1338.1812, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 2753.1120, 0.0000, 37173.1201],
                 [644.1423, 1338.1812, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 2753.1120, 0.0000, 36398.2298],
                 [644.1423, 1338.1812, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 2753.1120, 0.0000, 36034.2178],
                 [644.1423, 1338.1812, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 2753.1120, 0.0000, 35583.6399],
                 [644.1423, 1338.1812, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 2753.1120, 0.0000, 36599.2645],
                 [644.1423, 1646.4805, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 0.0000, 0.0000, 37013.3408],
                 [644.1423, 1646.4805, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 0.0000, 0.0000, 37367.7449],
                 [644.1423, 1646.4805, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 0.0000, 0.0000, 39143.8273],
                 [644.1423, 1646.4805, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 0.0000, 0.0000, 41007.3074],
                 [644.1423, 1646.4805, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 0.0000, 0.0000, 41225.4657],
                 [644.1423, 1646.4805, 1033.4242, 0.0000, 1220.8683, 0.0000, 1467.7407, 0.0000, 0.0000, 40685.9525],
                 [644.1423, 1646.4805, 1033.4242, 0.0000, 0.0000, 0.0000, 1467.7407, 6592.6891, 0.0000, 40851.5435],
                 [644.1423, 1646.4805, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 0.0000, 0.0000, 41082.1210],
                 [644.1423, 0.0000, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 17370.3689, 0.0000, 40385.0135],
                 [644.1423, 0.0000, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 17370.3689, 0.0000, 41455.1513],
                 [644.1423, 0.0000, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 17370.3689, 0.0000, 42670.6769],
                 [644.1423, 0.0000, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 17370.3689, 0.0000, 43213.7233],
                 [644.1423, 0.0000, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 17370.3689, 0.0000, 42205.2480],
                 [644.1423, 0.0000, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 17370.3689, 0.0000, 42273.9386],
                 [644.1423, 0.0000, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 17370.3689, 0.0000, 44100.0777],
                 [644.1423, 0.0000, 1033.4242, 0.0000, 0.0000, 0.0000, 3974.4666, 17370.3689, 0.0000, 42059.7208],
                 [0.0000, 0.0000, 2483.9522, 0.0000, 0.0000, 0.0000, 3974.4666, 11619.4102, 0.0000, 43344.9653],
                 [0.0000, 0.0000, 2483.9522, 0.0000, 0.0000, 0.0000, 3974.4666, 11619.4102, 0.0000, 41621.0324],
                 [0.0000, 0.0000, 2483.9522, 0.0000, 0.0000, 0.0000, 3974.4666, 11619.4102, 0.0000, 40528.0648]])
        # PT信号，先卖后买，交割期为2天（股票）0天（现金）以便利用先卖的现金继续买入
        self.pt_res_sb20 = np.array(
                [[0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 0.000, 7500.000, 0.000, 10000.000],
                 [0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 0.000, 7500.000, 0.000, 9916.667],
                 [0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 321.089, 6035.833, 0.000, 9761.111],
                 [348.015, 417.919, 0.000, 0.000, 555.556, 0.000, 321.089, 2165.905, 0.000, 9674.821],
                 [348.015, 417.919, 0.000, 0.000, 555.556, 0.000, 321.089, 2165.905, 0.000, 9712.587],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9910.724],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9919.378],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9793.069],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9513.822],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9123.593],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9000.600],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9053.487],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9248.714],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9161.137],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9197.337],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9504.698],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9875.246],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 10241.540],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 10449.240],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 10628.327],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 10500.789],
                 [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 0.000, 5233.140, 0.000, 10449.278],
                 [348.015, 417.919, 0.000, 0.000, 459.869, 0.000, 0.000, 3433.855, 0.000, 10338.286],
                 [348.015, 417.919, 0.000, 0.000, 459.869, 0.000, 0.000, 3433.855, 0.000, 10194.347],
                 [348.015, 417.919, 0.000, 0.000, 459.869, 0.000, 0.000, 3433.855, 0.000, 10471.001],
                 [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10411.263],
                 [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10670.062],
                 [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10652.480],
                 [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10526.149],
                 [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10458.661],
                 [101.498, 417.919, 821.732, 288.667, 0.000, 2576.128, 0.000, 4487.072, 0.000, 20609.027],
                 [797.168, 417.919, 821.732, 288.667, 0.000, 2576.128, 0.000, 0.000, 0.000, 21979.497],
                 [1156.912, 417.919, 821.732, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21584.441],
                 [1156.912, 417.919, 821.732, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21309.576],
                 [1156.912, 417.919, 821.732, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 20664.323],
                 [1156.912, 417.919, 821.732, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21445.597],
                 [1156.912, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 2223.240, 0.000, 20806.458],
                 [1156.912, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 2223.240, 0.000, 21288.441],
                 [1156.912, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 2223.240, 0.000, 21294.365],
                 [1156.912, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 2223.240, 0.000, 22058.784],
                 [1156.912, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 2223.240, 0.000, 21805.540],
                 [1156.912, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 2223.240, 0.000, 21456.333],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22459.720],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22611.602],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22470.912],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21932.634],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22425.864],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21460.103],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22376.968],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 23604.295],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 22704.826],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 22286.293],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 23204.755],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 24089.017],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 24768.185],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 23265.196],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 24350.540],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 24112.706],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 23709.076],
                 [1481.947, 417.919, 504.579, 288.667, 0.000, 763.410, 1577.904, 0.000, 0.000, 24093.545],
                 [2060.275, 896.050, 504.579, 288.667, 0.000, 763.410, 1577.904, 2835.944, 0.000, 34634.888],
                 [578.327, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 732.036, 0.000, 33912.261],
                 [0.000, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 4415.981, 0.000, 33711.951],
                 [644.683, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 186.858, 0.000, 34951.433],
                 [644.683, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 186.858, 0.000, 33224.596],
                 [644.683, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 186.858, 0.000, 35065.209],
                 [644.683, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 186.858, 0.000, 37018.699],
                 [644.683, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 186.858, 0.000, 38706.035],
                 [644.683, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 186.858, 0.000, 38724.569],
                 [644.683, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 186.858, 0.000, 36647.268],
                 [644.683, 896.050, 504.579, 889.896, 0.000, 3485.427, 1577.904, 186.858, 0.000, 35928.930],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 36967.229],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 37056.598],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 38129.862],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 36489.333],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 37599.602],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 37566.823],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 36799.280],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 36431.196],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 35940.942],
                 [644.683, 1341.215, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 2367.759, 0.000, 36973.050],
                 [644.683, 1606.361, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 0.000, 0.000, 37393.292],
                 [644.683, 1606.361, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 0.000, 0.000, 37711.276],
                 [644.683, 1606.361, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 0.000, 0.000, 39515.991],
                 [644.683, 1606.361, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 0.000, 0.000, 41404.440],
                 [644.683, 1606.361, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 0.000, 0.000, 41573.523],
                 [644.683, 1606.361, 1074.629, 0.000, 1232.241, 0.000, 1577.904, 0.000, 0.000, 41011.613],
                 [644.683, 1606.361, 1074.629, 0.000, 0.000, 0.000, 3896.406, 0.000, 0.000, 41160.181],
                 [644.683, 1606.361, 1074.629, 0.000, 0.000, 0.000, 3896.406, 0.000, 0.000, 40815.512],
                 [644.683, 0.000, 1074.629, 0.000, 0.000, 0.000, 3896.406, 16947.110, 0.000, 40145.531],
                 [644.683, 0.000, 1074.629, 0.000, 0.000, 0.000, 3896.406, 16947.110, 0.000, 41217.281],
                 [644.683, 0.000, 1074.629, 0.000, 0.000, 0.000, 3896.406, 16947.110, 0.000, 42379.061],
                 [644.683, 0.000, 1074.629, 0.000, 0.000, 0.000, 3896.406, 16947.110, 0.000, 42879.589],
                 [644.683, 0.000, 1074.629, 0.000, 0.000, 0.000, 3896.406, 16947.110, 0.000, 41891.452],
                 [644.683, 0.000, 1074.629, 0.000, 0.000, 0.000, 3896.406, 16947.110, 0.000, 41929.003],
                 [644.683, 0.000, 1074.629, 0.000, 0.000, 0.000, 3896.406, 16947.110, 0.000, 43718.052],
                 [644.683, 0.000, 1074.629, 0.000, 0.000, 0.000, 3896.406, 16947.110, 0.000, 41685.916],
                 [0.000, 0.000, 2460.195, 0.000, 0.000, 0.000, 3896.406, 11653.255, 0.000, 42930.410],
                 [0.000, 0.000, 2460.195, 0.000, 0.000, 0.000, 3896.406, 11653.255, 0.000, 41242.589],
                 [0.000, 0.000, 2460.195, 0.000, 0.000, 0.000, 3896.406, 11653.255, 0.000, 40168.084]])
        # PT信号，先买后卖，交割期为2天（股票）1天（现金）
        self.pt_res_bs21 = np.array([
            [0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 0.000, 7500.000, 0.000, 10000.000],
            [0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 0.000, 7500.000, 0.000, 9916.667],
            [0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 321.089, 6035.833, 0.000, 9761.111],
            [348.015, 417.919, 0.000, 0.000, 555.556, 0.000, 321.089, 2165.905, 0.000, 9674.821],
            [348.015, 417.919, 0.000, 0.000, 555.556, 0.000, 321.089, 2165.905, 0.000, 9712.587],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9910.724],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9919.378],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9793.069],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9513.822],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9123.593],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9000.600],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9053.487],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9248.714],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9161.137],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9197.337],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9504.698],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 9875.246],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 10241.540],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 10449.240],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 10628.327],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 321.089, 3762.551, 0.000, 10500.789],
            [348.015, 417.919, 0.000, 0.000, 154.388, 0.000, 0.000, 5233.140, 0.000, 10449.278],
            [348.015, 417.919, 0.000, 0.000, 459.869, 0.000, 0.000, 3433.855, 0.000, 10338.286],
            [348.015, 417.919, 0.000, 0.000, 459.869, 0.000, 0.000, 3433.855, 0.000, 10194.347],
            [348.015, 417.919, 0.000, 0.000, 459.869, 0.000, 0.000, 3433.855, 0.000, 10471.001],
            [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10411.263],
            [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10670.062],
            [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10652.480],
            [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10526.149],
            [101.498, 417.919, 0.000, 288.667, 459.869, 0.000, 0.000, 3541.085, 0.000, 10458.661],
            [101.498, 417.919, 821.732, 288.667, 0.000, 2576.128, 0.000, 4487.072, 0.000, 20609.027],
            [797.168, 417.919, 821.732, 288.667, 0.000, 2576.128, 0.000, 0.000, 0.000, 21979.497],
            [797.168, 417.919, 821.732, 288.667, 0.000, 1649.148, 0.000, 2475.037, 0.000, 21584.441],
            [1150.745, 417.919, 821.732, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21266.406],
            [1150.745, 417.919, 821.732, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 20623.683],
            [1150.745, 417.919, 821.732, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21404.957],
            [1150.745, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 2230.202, 0.000, 20765.509],
            [1150.745, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 2230.202, 0.000, 21248.748],
            [1150.745, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 2230.202, 0.000, 21256.041],
            [1150.745, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 2230.202, 0.000, 22018.958],
            [1150.745, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 2230.202, 0.000, 21764.725],
            [1150.745, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 2230.202, 0.000, 21413.241],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22417.021],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22567.685],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22427.699],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21889.359],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22381.938],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 21416.358],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 1649.148, 0.000, 0.000, 0.000, 22332.786],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 0.000, 2386.698, 0.000, 23557.595],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 23336.992],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 22907.742],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 24059.201],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 24941.902],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 25817.514],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 24127.939],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 25459.688],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 25147.370],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 2209.906, 0.000, 0.000, 25005.842],
            [1476.798, 417.919, 503.586, 288.667, 0.000, 761.900, 1086.639, 2752.004, 0.000, 25598.700],
            [2138.154, 929.921, 503.586, 288.667, 0.000, 761.900, 1086.639, 4818.835, 0.000, 35944.098],
            [661.356, 929.921, 503.586, 553.843, 0.000, 1954.237, 1086.639, 8831.252, 0.000, 35237.243],
            [0.000, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 9460.955, 0.000, 35154.442],
            [667.098, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 5084.792, 0.000, 36166.632],
            [667.098, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 5084.792, 0.000, 34293.883],
            [667.098, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 5084.792, 0.000, 35976.901],
            [667.098, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 5084.792, 0.000, 37848.552],
            [667.098, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 5084.792, 0.000, 39512.574],
            [667.098, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 5084.792, 0.000, 39538.024],
            [667.098, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 5084.792, 0.000, 37652.984],
            [667.098, 929.921, 503.586, 553.843, 0.000, 3613.095, 1086.639, 5084.792, 0.000, 36687.909],
            [667.098, 1108.871, 745.260, 0.000, 512.148, 0.000, 1086.639, 11861.593, 0.000, 37749.277],
            [667.098, 1108.871, 745.260, 0.000, 512.148, 0.000, 1086.639, 11861.593, 0.000, 37865.518],
            [667.098, 1108.871, 745.260, 0.000, 512.148, 0.000, 1086.639, 11861.593, 0.000, 38481.190],
            [667.098, 1108.871, 745.260, 0.000, 512.148, 0.000, 1086.639, 11861.593, 0.000, 37425.087],
            [667.098, 1108.871, 745.260, 0.000, 512.148, 0.000, 1086.639, 11861.593, 0.000, 38051.341],
            [667.098, 1108.871, 745.260, 0.000, 512.148, 0.000, 1086.639, 11861.593, 0.000, 38065.478],
            [667.098, 1108.871, 745.260, 0.000, 512.148, 0.000, 1086.639, 11861.593, 0.000, 37429.495],
            [667.098, 1108.871, 745.260, 0.000, 512.148, 0.000, 1086.639, 11861.593, 0.000, 37154.479],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 1086.639, 7576.628, 0.000, 36692.717],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 1086.639, 7576.628, 0.000, 37327.055],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 1086.639, 7576.628, 0.000, 37937.630],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 1086.639, 7576.628, 0.000, 38298.645],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 1086.639, 7576.628, 0.000, 39689.369],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 1086.639, 7576.628, 0.000, 40992.397],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 1086.639, 7576.628, 0.000, 41092.265],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 1086.639, 7576.628, 0.000, 40733.622],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 3726.579, 0.000, 0.000, 40708.515],
            [667.098, 1600.830, 745.260, 0.000, 512.148, 0.000, 3726.579, 0.000, 0.000, 40485.321],
            [667.098, 0.000, 745.260, 0.000, 512.148, 0.000, 3726.579, 16888.760, 0.000, 39768.059],
            [667.098, 0.000, 745.260, 0.000, 512.148, 0.000, 3726.579, 16888.760, 0.000, 40519.595],
            [667.098, 0.000, 745.260, 0.000, 512.148, 0.000, 3726.579, 16888.760, 0.000, 41590.937],
            [667.098, 0.000, 1283.484, 0.000, 512.148, 0.000, 3726.579, 12448.413, 0.000, 42354.983],
            [667.098, 0.000, 1283.484, 0.000, 512.148, 0.000, 3726.579, 12448.413, 0.000, 41175.149],
            [667.098, 0.000, 1283.484, 0.000, 512.148, 0.000, 3726.579, 12448.413, 0.000, 41037.902],
            [667.098, 0.000, 1283.484, 0.000, 512.148, 0.000, 3726.579, 12448.413, 0.000, 42706.213],
            [667.098, 0.000, 1283.484, 0.000, 512.148, 0.000, 3726.579, 12448.413, 0.000, 40539.205],
            [0.000, 0.000, 2384.452, 0.000, 512.148, 0.000, 3726.579, 9293.252, 0.000, 41608.692],
            [0.000, 0.000, 2384.452, 0.000, 512.148, 0.000, 3726.579, 9293.252, 0.000, 39992.148],
            [0.000, 0.000, 2384.452, 0.000, 512.148, 0.000, 3726.579, 9293.252, 0.000, 39134.828]])
        # 模拟PS信号回测结果
        # PS信号，先卖后买，交割期为0
        self.ps_res_sb00 = np.array(
                [[0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 0.0000, 7500.0000, 0.0000, 10000.0000],
                 [0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 0.0000, 7500.0000, 0.0000, 9916.6667],
                 [0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 205.0654, 321.0892, 5059.7222, 0.0000, 9761.1111],
                 [346.9824, 416.6787, 0.0000, 0.0000, 555.5556, 205.0654, 321.0892, 1201.2775, 0.0000, 9646.1118],
                 [346.9824, 416.6787, 191.0372, 0.0000, 555.5556, 205.0654, 321.0892, 232.7189, 0.0000, 9685.5858],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9813.2184],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9803.1288],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9608.0198],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9311.5727],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 8883.6246],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 8751.3900],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 8794.1811],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9136.5704],
                 [231.4373, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 2472.2444, 0.0000, 9209.3588],
                 [231.4373, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 2472.2444, 0.0000, 9093.8294],
                 [231.4373, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 2472.2444, 0.0000, 9387.5537],
                 [231.4373, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 2472.2444, 0.0000, 9585.9589],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 321.0892, 3035.8041, 0.0000, 9928.7771],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 321.0892, 3035.8041, 0.0000, 10060.3806],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 321.0892, 3035.8041, 0.0000, 10281.0021],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 321.0892, 3035.8041, 0.0000, 10095.5613],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 0.0000, 4506.3926, 0.0000, 10029.9571],
                 [231.4373, 416.6787, 95.5186, 0.0000, 474.2238, 205.0654, 0.0000, 2531.2699, 0.0000, 9875.6133],
                 [231.4373, 416.6787, 95.5186, 0.0000, 474.2238, 205.0654, 0.0000, 2531.2699, 0.0000, 9614.9463],
                 [231.4373, 416.6787, 95.5186, 0.0000, 474.2238, 205.0654, 0.0000, 2531.2699, 0.0000, 9824.1722],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 9732.5743],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 9968.3391],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 10056.1579],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 9921.4925],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 9894.1621],
                 [115.7186, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 6179.7742, 0.0000, 20067.9370],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21133.5080],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20988.8485],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20596.7429],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 19910.7730],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20776.7070],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20051.7969],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20725.3884],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20828.8795],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21647.1811],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21310.1687],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20852.0993],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21912.3952],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21937.8282],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21962.4576],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 21389.4018],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 22027.4535],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 20939.9992],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 21250.0636],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 22282.7812],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 21407.0658],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 21160.2373],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 21826.7682],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 22744.9403],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 23466.1185],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 22017.8821],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 23191.4662],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 23099.0822],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 22684.7671],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 1339.2073, 0.0000, 0.0000, 22842.1346],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 1785.2055, 938.6967, 1339.2073, 5001.4246, 0.0000,
                  33323.8359],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 32820.2901],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 32891.2308],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 34776.5296],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 33909.0325],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 34560.1906],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 36080.4552],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 38618.4454],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 38497.9230],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 37110.0991],
                 [0.0000, 416.6787, 735.6442, 944.9611, 1785.2055, 3582.8836, 1339.2073, 0.0000, 0.0000, 35455.2467],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 35646.1860],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 35472.3020],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 36636.4694],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 35191.7035],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 36344.2242],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 36221.6005],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 35943.5708],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 35708.2608],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 35589.0286],
                 [0.0000, 416.6787, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 15126.2788, 0.0000, 36661.0285],
                 [0.0000, 823.2923, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 11495.2197, 0.0000, 36310.5909],
                 [0.0000, 823.2923, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 11495.2197, 0.0000, 36466.7637],
                 [0.0000, 823.2923, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 11495.2197, 0.0000, 37784.4918],
                 [0.0000, 823.2923, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 11495.2197, 0.0000, 39587.6766],
                 [0.0000, 823.2923, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 11495.2197, 0.0000, 40064.0191],
                 [0.0000, 823.2923, 735.6442, 0.0000, 1785.2055, 0.0000, 1339.2073, 11495.2197, 0.0000, 39521.6439],
                 [0.0000, 823.2923, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 17142.1018, 0.0000, 39932.2761],
                 [0.0000, 823.2923, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 17142.1018, 0.0000, 39565.2475],
                 [0.0000, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 25827.8351, 0.0000, 38943.1632],
                 [0.0000, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 25827.8351, 0.0000, 39504.1184],
                 [0.0000, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 25827.8351, 0.0000, 40317.8004],
                 [0.0000, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 25827.8351, 0.0000, 40798.5768],
                 [0.0000, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 25827.8351, 0.0000, 39962.5711],
                 [0.0000, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 25827.8351, 0.0000, 40194.4793],
                 [0.0000, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 25827.8351, 0.0000, 41260.4003],
                 [0.0000, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 2730.5758, 25827.8351, 0.0000, 39966.3024],
                 [0.0000, 0.0000, 1613.4518, 0.0000, 0.0000, 0.0000, 2730.5758, 19700.7377, 0.0000, 40847.3160],
                 [0.0000, 0.0000, 1613.4518, 0.0000, 0.0000, 0.0000, 2730.5758, 19700.7377, 0.0000, 39654.5445],
                 [0.0000, 0.0000, 1613.4518, 0.0000, 0.0000, 0.0000, 2730.5758, 19700.7377, 0.0000, 38914.8151]])
        # PS信号，先买后卖，交割期为0
        self.ps_res_bs00 = np.array(
                [[0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 0.0000, 7500.0000, 0.0000, 10000.0000],
                 [0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 0.0000, 0.0000, 7500.0000, 0.0000, 9916.6667],
                 [0.0000, 0.0000, 0.0000, 0.0000, 555.5556, 205.0654, 321.0892, 5059.7222, 0.0000, 9761.1111],
                 [346.9824, 416.6787, 0.0000, 0.0000, 555.5556, 205.0654, 321.0892, 1201.2775, 0.0000, 9646.1118],
                 [346.9824, 416.6787, 191.0372, 0.0000, 555.5556, 205.0654, 321.0892, 232.7189, 0.0000, 9685.5858],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9813.2184],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9803.1288],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9608.0198],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9311.5727],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 8883.6246],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 8751.3900],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 8794.1811],
                 [346.9824, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 1891.0523, 0.0000, 9136.5704],
                 [231.4373, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 2472.2444, 0.0000, 9209.3588],
                 [231.4373, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 2472.2444, 0.0000, 9093.8294],
                 [231.4373, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 2472.2444, 0.0000, 9387.5537],
                 [231.4373, 416.6787, 191.0372, 0.0000, 138.8889, 205.0654, 321.0892, 2472.2444, 0.0000, 9585.9589],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 321.0892, 3035.8041, 0.0000, 9928.7771],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 321.0892, 3035.8041, 0.0000, 10060.3806],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 321.0892, 3035.8041, 0.0000, 10281.0021],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 321.0892, 3035.8041, 0.0000, 10095.5613],
                 [231.4373, 416.6787, 95.5186, 0.0000, 138.8889, 205.0654, 0.0000, 4506.3926, 0.0000, 10029.9571],
                 [231.4373, 416.6787, 95.5186, 0.0000, 474.2238, 205.0654, 0.0000, 2531.2699, 0.0000, 9875.6133],
                 [231.4373, 416.6787, 95.5186, 0.0000, 474.2238, 205.0654, 0.0000, 2531.2699, 0.0000, 9614.9463],
                 [231.4373, 416.6787, 95.5186, 0.0000, 474.2238, 205.0654, 0.0000, 2531.2699, 0.0000, 9824.1722],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 9732.5743],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 9968.3391],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 10056.1579],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 9921.4925],
                 [115.7186, 416.6787, 95.5186, 269.8496, 474.2238, 205.0654, 0.0000, 1854.7990, 0.0000, 9894.1621],
                 [115.7186, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 6179.7742, 0.0000, 20067.9370],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21133.5080],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20988.8485],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20596.7429],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 19910.7730],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20776.7070],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20051.7969],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20725.3884],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20828.8795],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21647.1811],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21310.1687],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 20852.0993],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21912.3952],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21937.8282],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 1877.3934, 0.0000, 0.0000, 0.0000, 21962.4576],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 2008.8110, 0.0000, 21389.4018],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 2008.8110, 0.0000, 21625.6913],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 2008.8110, 0.0000, 20873.0389],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 2008.8110, 0.0000, 21450.9447],
                 [1073.8232, 416.6787, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 2008.8110, 0.0000, 22269.3892],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 21969.5329],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 21752.6924],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 22000.6088],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 23072.5655],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 23487.5201],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 22441.0460],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 23201.2700],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 23400.9485],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 22306.2008],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 0.0000, 938.6967, 0.0000, 0.0000, 0.0000, 21989.5913],
                 [1073.8232, 737.0632, 735.6442, 269.8496, 1708.7766, 938.6967, 0.0000, 5215.4255, 0.0000, 31897.1636],
                 [0.0000, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 6421.4626, 0.0000, 31509.5059],
                 [0.0000, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 6421.4626, 0.0000, 31451.7888],
                 [978.8815, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 0.0000, 0.0000, 32773.4592],
                 [978.8815, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 0.0000, 0.0000, 32287.0318],
                 [978.8815, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 0.0000, 0.0000, 32698.1938],
                 [978.8815, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 0.0000, 0.0000, 34031.5183],
                 [978.8815, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 0.0000, 0.0000, 35537.8336],
                 [978.8815, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 0.0000, 0.0000, 36212.6487],
                 [978.8815, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 0.0000, 0.0000, 36007.5294],
                 [978.8815, 737.0632, 735.6442, 578.0898, 1708.7766, 2145.9711, 0.0000, 0.0000, 0.0000, 34691.3797],
                 [978.8815, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 9162.7865, 0.0000, 33904.8810],
                 [978.8815, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 9162.7865, 0.0000, 34341.6098],
                 [978.8815, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 9162.7865, 0.0000, 35479.9505],
                 [978.8815, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 9162.7865, 0.0000, 34418.4455],
                 [978.8815, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 9162.7865, 0.0000, 34726.7182],
                 [978.8815, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 9162.7865, 0.0000, 34935.0407],
                 [978.8815, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 9162.7865, 0.0000, 34136.7505],
                 [978.8815, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 9162.7865, 0.0000, 33804.1575],
                 [195.7763, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 14025.8697, 0.0000, 33653.8970],
                 [195.7763, 737.0632, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 14025.8697, 0.0000, 34689.8757],
                 [195.7763, 1124.9219, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 10562.2913, 0.0000, 34635.7841],
                 [195.7763, 1124.9219, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 10562.2913, 0.0000, 35253.2755],
                 [195.7763, 1124.9219, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 10562.2913, 0.0000, 36388.1051],
                 [195.7763, 1124.9219, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 10562.2913, 0.0000, 37987.4204],
                 [195.7763, 1124.9219, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 10562.2913, 0.0000, 38762.2103],
                 [195.7763, 1124.9219, 735.6442, 0.0000, 1708.7766, 0.0000, 0.0000, 10562.2913, 0.0000, 38574.0544],
                 [195.7763, 1124.9219, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 15879.4935, 0.0000, 39101.9156],
                 [195.7763, 1124.9219, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 15879.4935, 0.0000, 39132.5587],
                 [195.7763, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 27747.4200, 0.0000, 38873.2941],
                 [195.7763, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 27747.4200, 0.0000, 39336.6594],
                 [195.7763, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 27747.4200, 0.0000, 39565.9568],
                 [195.7763, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 27747.4200, 0.0000, 39583.4317],
                 [195.7763, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 27747.4200, 0.0000, 39206.8350],
                 [195.7763, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 27747.4200, 0.0000, 39092.6551],
                 [195.7763, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 27747.4200, 0.0000, 39666.1834],
                 [195.7763, 0.0000, 735.6442, 0.0000, 0.0000, 0.0000, 1362.4361, 27747.4200, 0.0000, 38798.0749],
                 [0.0000, 0.0000, 1576.8381, 0.0000, 0.0000, 0.0000, 1362.4361, 23205.2077, 0.0000, 39143.5561],
                 [0.0000, 0.0000, 1576.8381, 0.0000, 0.0000, 0.0000, 1362.4361, 23205.2077, 0.0000, 38617.8779],
                 [0.0000, 0.0000, 1576.8381, 0.0000, 0.0000, 0.0000, 1362.4361, 23205.2077, 0.0000, 38156.1701]])
        # PS信号，先卖后买，交割期为2天（股票）1天（现金）
        self.ps_res_sb20 = np.array(
                [[0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 0.000, 7500.000, 0.000, 10000.000],
                 [0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 0.000, 7500.000, 0.000, 9916.667],
                 [0.000, 0.000, 0.000, 0.000, 555.556, 205.065, 321.089, 5059.722, 0.000, 9761.111],
                 [346.982, 416.679, 0.000, 0.000, 555.556, 205.065, 321.089, 1201.278, 0.000, 9646.112],
                 [346.982, 416.679, 191.037, 0.000, 555.556, 205.065, 321.089, 232.719, 0.000, 9685.586],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9813.218],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9803.129],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9608.020],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9311.573],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 8883.625],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 8751.390],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 8794.181],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9136.570],
                 [231.437, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 2472.244, 0.000, 9209.359],
                 [231.437, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 2472.244, 0.000, 9093.829],
                 [231.437, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 2472.244, 0.000, 9387.554],
                 [231.437, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 2472.244, 0.000, 9585.959],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 321.089, 3035.804, 0.000, 9928.777],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 321.089, 3035.804, 0.000, 10060.381],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 321.089, 3035.804, 0.000, 10281.002],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 321.089, 3035.804, 0.000, 10095.561],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 0.000, 4506.393, 0.000, 10029.957],
                 [231.437, 416.679, 95.519, 0.000, 474.224, 205.065, 0.000, 2531.270, 0.000, 9875.613],
                 [231.437, 416.679, 95.519, 0.000, 474.224, 205.065, 0.000, 2531.270, 0.000, 9614.946],
                 [231.437, 416.679, 95.519, 0.000, 474.224, 205.065, 0.000, 2531.270, 0.000, 9824.172],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 9732.574],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 9968.339],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 10056.158],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 9921.492],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 9894.162],
                 [115.719, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 6179.774, 0.000, 20067.937],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21133.508],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20988.848],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20596.743],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 19910.773],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20776.707],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20051.797],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20725.388],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20828.880],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21647.181],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21310.169],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20852.099],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21912.395],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21937.828],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21962.458],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 21389.402],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 22027.453],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 20939.999],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 21250.064],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 22282.781],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 21407.066],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 21160.237],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 21826.768],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 22744.940],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 23466.118],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 22017.882],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 23191.466],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 23099.082],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 22684.767],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 1339.207, 0.000, 0.000, 22842.135],
                 [1073.823, 416.679, 735.644, 269.850, 1785.205, 938.697, 1339.207, 5001.425, 0.000, 33323.836],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 32820.290],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 32891.231],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 34776.530],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 33909.032],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 34560.191],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 36080.455],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 38618.445],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 38497.923],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 37110.099],
                 [0.000, 416.679, 735.644, 944.961, 1785.205, 3582.884, 1339.207, 0.000, 0.000, 35455.247],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 35646.186],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 35472.302],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 36636.469],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 35191.704],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 36344.224],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 36221.601],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 35943.571],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 35708.261],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 35589.029],
                 [0.000, 416.679, 735.644, 0.000, 1785.205, 0.000, 1339.207, 15126.279, 0.000, 36661.029],
                 [0.000, 823.292, 735.644, 0.000, 1785.205, 0.000, 1339.207, 11495.220, 0.000, 36310.591],
                 [0.000, 823.292, 735.644, 0.000, 1785.205, 0.000, 1339.207, 11495.220, 0.000, 36466.764],
                 [0.000, 823.292, 735.644, 0.000, 1785.205, 0.000, 1339.207, 11495.220, 0.000, 37784.492],
                 [0.000, 823.292, 735.644, 0.000, 1785.205, 0.000, 1339.207, 11495.220, 0.000, 39587.677],
                 [0.000, 823.292, 735.644, 0.000, 1785.205, 0.000, 1339.207, 11495.220, 0.000, 40064.019],
                 [0.000, 823.292, 735.644, 0.000, 1785.205, 0.000, 1339.207, 11495.220, 0.000, 39521.644],
                 [0.000, 823.292, 735.644, 0.000, 0.000, 0.000, 2730.576, 17142.102, 0.000, 39932.276],
                 [0.000, 823.292, 735.644, 0.000, 0.000, 0.000, 2730.576, 17142.102, 0.000, 39565.248],
                 [0.000, 0.000, 735.644, 0.000, 0.000, 0.000, 2730.576, 25827.835, 0.000, 38943.163],
                 [0.000, 0.000, 735.644, 0.000, 0.000, 0.000, 2730.576, 25827.835, 0.000, 39504.118],
                 [0.000, 0.000, 735.644, 0.000, 0.000, 0.000, 2730.576, 25827.835, 0.000, 40317.800],
                 [0.000, 0.000, 735.644, 0.000, 0.000, 0.000, 2730.576, 25827.835, 0.000, 40798.577],
                 [0.000, 0.000, 735.644, 0.000, 0.000, 0.000, 2730.576, 25827.835, 0.000, 39962.571],
                 [0.000, 0.000, 735.644, 0.000, 0.000, 0.000, 2730.576, 25827.835, 0.000, 40194.479],
                 [0.000, 0.000, 735.644, 0.000, 0.000, 0.000, 2730.576, 25827.835, 0.000, 41260.400],
                 [0.000, 0.000, 735.644, 0.000, 0.000, 0.000, 2730.576, 25827.835, 0.000, 39966.302],
                 [0.000, 0.000, 1613.452, 0.000, 0.000, 0.000, 2730.576, 19700.738, 0.000, 40847.316],
                 [0.000, 0.000, 1613.452, 0.000, 0.000, 0.000, 2730.576, 19700.738, 0.000, 39654.544],
                 [0.000, 0.000, 1613.452, 0.000, 0.000, 0.000, 2730.576, 19700.738, 0.000, 38914.815]])
        # PS信号，先买后卖，交割期为2天（股票）1天（现金）
        self.ps_res_bs21 = np.array(
                [[0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 0.000, 7500.000, 0.000, 10000.000],
                 [0.000, 0.000, 0.000, 0.000, 555.556, 0.000, 0.000, 7500.000, 0.000, 9916.667],
                 [0.000, 0.000, 0.000, 0.000, 555.556, 205.065, 321.089, 5059.722, 0.000, 9761.111],
                 [346.982, 416.679, 0.000, 0.000, 555.556, 205.065, 321.089, 1201.278, 0.000, 9646.112],
                 [346.982, 416.679, 191.037, 0.000, 555.556, 205.065, 321.089, 232.719, 0.000, 9685.586],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9813.218],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9803.129],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9608.020],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9311.573],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 8883.625],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 8751.390],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 8794.181],
                 [346.982, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 1891.052, 0.000, 9136.570],
                 [231.437, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 2472.244, 0.000, 9209.359],
                 [231.437, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 2472.244, 0.000, 9093.829],
                 [231.437, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 2472.244, 0.000, 9387.554],
                 [231.437, 416.679, 191.037, 0.000, 138.889, 205.065, 321.089, 2472.244, 0.000, 9585.959],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 321.089, 3035.804, 0.000, 9928.777],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 321.089, 3035.804, 0.000, 10060.381],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 321.089, 3035.804, 0.000, 10281.002],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 321.089, 3035.804, 0.000, 10095.561],
                 [231.437, 416.679, 95.519, 0.000, 138.889, 205.065, 0.000, 4506.393, 0.000, 10029.957],
                 [231.437, 416.679, 95.519, 0.000, 474.224, 205.065, 0.000, 2531.270, 0.000, 9875.613],
                 [231.437, 416.679, 95.519, 0.000, 474.224, 205.065, 0.000, 2531.270, 0.000, 9614.946],
                 [231.437, 416.679, 95.519, 0.000, 474.224, 205.065, 0.000, 2531.270, 0.000, 9824.172],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 9732.574],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 9968.339],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 10056.158],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 9921.492],
                 [115.719, 416.679, 95.519, 269.850, 474.224, 205.065, 0.000, 1854.799, 0.000, 9894.162],
                 [115.719, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 6179.774, 0.000, 20067.937],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21133.508],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20988.848],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20596.743],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 19910.773],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20776.707],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20051.797],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20725.388],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20828.880],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21647.181],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21310.169],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 20852.099],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21912.395],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21937.828],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 1877.393, 0.000, 0.000, 0.000, 21962.458],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 0.000, 2008.811, 0.000, 21389.402],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 0.000, 2008.811, 0.000, 21625.691],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 0.000, 2008.811, 0.000, 20873.039],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 0.000, 2008.811, 0.000, 21450.945],
                 [1073.823, 416.679, 735.644, 269.850, 0.000, 938.697, 0.000, 2008.811, 0.000, 22269.389],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 21969.533],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 21752.692],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 22000.609],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 23072.566],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 23487.520],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 22441.046],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 23201.270],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 23400.948],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 22306.201],
                 [1073.823, 737.063, 735.644, 269.850, 0.000, 938.697, 0.000, 0.000, 0.000, 21989.591],
                 [1073.823, 737.063, 735.644, 269.850, 1708.777, 938.697, 0.000, 5215.425, 0.000, 31897.164],
                 [0.000, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 6421.463, 0.000, 31509.506],
                 [0.000, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 6421.463, 0.000, 31451.789],
                 [978.881, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 0.000, 0.000, 32773.459],
                 [978.881, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 0.000, 0.000, 32287.032],
                 [978.881, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 0.000, 0.000, 32698.194],
                 [978.881, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 0.000, 0.000, 34031.518],
                 [978.881, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 0.000, 0.000, 35537.834],
                 [978.881, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 0.000, 0.000, 36212.649],
                 [978.881, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 0.000, 0.000, 36007.529],
                 [978.881, 737.063, 735.644, 578.090, 1708.777, 2145.971, 0.000, 0.000, 0.000, 34691.380],
                 [978.881, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 9162.786, 0.000, 33904.881],
                 [978.881, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 9162.786, 0.000, 34341.610],
                 [978.881, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 9162.786, 0.000, 35479.951],
                 [978.881, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 9162.786, 0.000, 34418.445],
                 [978.881, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 9162.786, 0.000, 34726.718],
                 [978.881, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 9162.786, 0.000, 34935.041],
                 [978.881, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 9162.786, 0.000, 34136.751],
                 [978.881, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 9162.786, 0.000, 33804.157],
                 [195.776, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 14025.870, 0.000, 33653.897],
                 [195.776, 737.063, 735.644, 0.000, 1708.777, 0.000, 0.000, 14025.870, 0.000, 34689.876],
                 [195.776, 1124.922, 735.644, 0.000, 1708.777, 0.000, 0.000, 10562.291, 0.000, 34635.784],
                 [195.776, 1124.922, 735.644, 0.000, 1708.777, 0.000, 0.000, 10562.291, 0.000, 35253.275],
                 [195.776, 1124.922, 735.644, 0.000, 1708.777, 0.000, 0.000, 10562.291, 0.000, 36388.105],
                 [195.776, 1124.922, 735.644, 0.000, 1708.777, 0.000, 0.000, 10562.291, 0.000, 37987.420],
                 [195.776, 1124.922, 735.644, 0.000, 1708.777, 0.000, 0.000, 10562.291, 0.000, 38762.210],
                 [195.776, 1124.922, 735.644, 0.000, 1708.777, 0.000, 0.000, 10562.291, 0.000, 38574.054],
                 [195.776, 1124.922, 735.644, 0.000, 0.000, 0.000, 1362.436, 15879.494, 0.000, 39101.916],
                 [195.776, 1124.922, 735.644, 0.000, 0.000, 0.000, 1362.436, 15879.494, 0.000, 39132.559],
                 [195.776, 0.000, 735.644, 0.000, 0.000, 0.000, 1362.436, 27747.420, 0.000, 38873.294],
                 [195.776, 0.000, 735.644, 0.000, 0.000, 0.000, 1362.436, 27747.420, 0.000, 39336.659],
                 [195.776, 0.000, 735.644, 0.000, 0.000, 0.000, 1362.436, 27747.420, 0.000, 39565.957],
                 [195.776, 0.000, 735.644, 0.000, 0.000, 0.000, 1362.436, 27747.420, 0.000, 39583.432],
                 [195.776, 0.000, 735.644, 0.000, 0.000, 0.000, 1362.436, 27747.420, 0.000, 39206.835],
                 [195.776, 0.000, 735.644, 0.000, 0.000, 0.000, 1362.436, 27747.420, 0.000, 39092.655],
                 [195.776, 0.000, 735.644, 0.000, 0.000, 0.000, 1362.436, 27747.420, 0.000, 39666.183],
                 [195.776, 0.000, 735.644, 0.000, 0.000, 0.000, 1362.436, 27747.420, 0.000, 38798.075],
                 [0.000, 0.000, 1576.838, 0.000, 0.000, 0.000, 1362.436, 23205.208, 0.000, 39143.556],
                 [0.000, 0.000, 1576.838, 0.000, 0.000, 0.000, 1362.436, 23205.208, 0.000, 38617.878],
                 [0.000, 0.000, 1576.838, 0.000, 0.000, 0.000, 1362.436, 23205.208, 0.000, 38156.170]]
        )
        # 模拟VS信号回测结果
        # VS信号，先卖后买，交割期为0
        self.vs_res_sb00 = np.array(
                [[0.0000, 0.0000, 0.0000, 0.0000, 500.0000, 0.0000, 0.0000, 7750.0000, 0.0000, 10000.0000],
                 [0.0000, 0.0000, 0.0000, 0.0000, 500.0000, 0.0000, 0.0000, 7750.0000, 0.0000, 9925.0000],
                 [0.0000, 0.0000, 0.0000, 0.0000, 500.0000, 300.0000, 300.0000, 4954.0000, 0.0000, 9785.0000],
                 [400.0000, 400.0000, 0.0000, 0.0000, 500.0000, 300.0000, 300.0000, 878.0000, 0.0000, 9666.0000],
                 [400.0000, 400.0000, 173.1755, 0.0000, 500.0000, 300.0000, 300.0000, 0.0000, 0.0000, 9731.0000],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592.0000, 0.0000, 9830.9270],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592.0000, 0.0000, 9785.8540],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592.0000, 0.0000, 9614.3412],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592.0000, 0.0000, 9303.1953],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592.0000, 0.0000, 8834.4398],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592.0000, 0.0000, 8712.7554],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592.0000, 0.0000, 8717.9507],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592.0000, 0.0000, 9079.1479],
                 [200.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 2598.0000, 0.0000, 9166.0276],
                 [200.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 2598.0000, 0.0000, 9023.6607],
                 [200.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 2598.0000, 0.0000, 9291.6864],
                 [200.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 2598.0000, 0.0000, 9411.6371],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 300.0000, 3619.7357, 0.0000, 9706.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 300.0000, 3619.7357, 0.0000, 9822.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 300.0000, 3619.7357, 0.0000, 9986.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 300.0000, 3619.7357, 0.0000, 9805.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 0.0000, 4993.7357, 0.0000, 9704.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 600.0000, 300.0000, 0.0000, 2048.7357, 0.0000, 9567.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 600.0000, 300.0000, 0.0000, 2048.7357, 0.0000, 9209.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 600.0000, 300.0000, 0.0000, 2048.7357, 0.0000, 9407.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9329.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9545.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9652.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9414.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9367.7357],
                 [0.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 9319.7357, 0.0000, 19556.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 20094.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19849.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19802.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19487.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19749.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19392.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19671.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19756.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 20111.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19867.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19775.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 1990.7357, 0.0000, 20314.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 1990.7357, 0.0000, 20310.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 1990.7357, 0.0000, 20253.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 20044.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 20495.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 19798.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 20103.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 20864.7357],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 20425.7357],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 20137.8405],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 20711.3567],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 21470.3891],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 21902.9538],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 20962.9538],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 21833.5184],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 21941.8169],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 21278.5184],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0.0000, 0.0000, 21224.4700],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 600.0000, 500.0000, 600.0000, 9160.0000, 0.0000, 31225.2119],
                 [600.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 7488.0000, 0.0000, 30894.5748],
                 [600.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 7488.0000, 0.0000, 30764.3811],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208.0000, 0.0000, 31815.5828],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208.0000, 0.0000, 31615.4215],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208.0000, 0.0000, 32486.1394],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208.0000, 0.0000, 33591.2847],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208.0000, 0.0000, 34056.5428],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208.0000, 0.0000, 34756.4863],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208.0000, 0.0000, 34445.5428],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208.0000, 0.0000, 34433.9541],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346.0000, 0.0000,
                  33870.4703],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346.0000, 0.0000,
                  34014.3010],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346.0000, 0.0000,
                  34680.5671],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346.0000, 0.0000,
                  33890.9945],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346.0000, 0.0000,
                  34004.6640],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346.0000, 0.0000,
                  34127.7768],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346.0000, 0.0000,
                  33421.1638],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346.0000, 0.0000,
                  33120.9057],
                 [700.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 13830.0000, 0.0000, 32613.3171],
                 [700.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 13830.0000, 0.0000, 33168.1558],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151.0000, 0.0000,
                  33504.6236],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151.0000, 0.0000,
                  33652.1318],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151.0000, 0.0000,
                  34680.4867],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151.0000, 0.0000,
                  35557.5191],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151.0000, 0.0000,
                  35669.7128],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151.0000, 0.0000,
                  35211.4466],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13530.0000, 0.0000, 35550.6079],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13530.0000, 0.0000, 35711.6563],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695.0000, 0.0000, 35682.6079],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695.0000, 0.0000, 35880.8336],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695.0000, 0.0000, 36249.8740],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695.0000, 0.0000, 36071.6159],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695.0000, 0.0000, 35846.1562],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695.0000, 0.0000, 35773.3578],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695.0000, 0.0000, 36274.9465],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695.0000, 0.0000, 35739.3094],
                 [500.0000, 710.4842, 1100.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13167.0000, 0.0000, 36135.0917],
                 [500.0000, 710.4842, 1100.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13167.0000, 0.0000, 35286.5835],
                 [500.0000, 710.4842, 1100.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13167.0000, 0.0000, 35081.3658]])
        # VS信号，先买后卖，交割期为0
        self.vs_res_bs00 = np.array(
                [[0.0000, 0.0000, 0.0000, 0.0000, 500.0000, 0.0000, 0.0000, 7750, 0.0000, 10000],
                 [0.0000, 0.0000, 0.0000, 0.0000, 500.0000, 0.0000, 0.0000, 7750, 0.0000, 9925],
                 [0.0000, 0.0000, 0.0000, 0.0000, 500.0000, 300.0000, 300.0000, 4954, 0.0000, 9785],
                 [400.0000, 400.0000, 0.0000, 0.0000, 500.0000, 300.0000, 300.0000, 878, 0.0000, 9666],
                 [400.0000, 400.0000, 173.1755, 0.0000, 500.0000, 300.0000, 300.0000, 0, 0.0000, 9731],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592, 0.0000, 9830.927022],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592, 0.0000, 9785.854043],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592, 0.0000, 9614.341223],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592, 0.0000, 9303.195266],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592, 0.0000, 8834.439842],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592, 0.0000, 8712.755424],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592, 0.0000, 8717.95069],
                 [400.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 1592, 0.0000, 9079.147929],
                 [200.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 2598, 0.0000, 9166.027613],
                 [200.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 2598, 0.0000, 9023.66075],
                 [200.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 2598, 0.0000, 9291.686391],
                 [200.0000, 400.0000, 173.1755, 0.0000, 100.0000, 300.0000, 300.0000, 2598, 0.0000, 9411.637081],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 300.0000, 3619.7357, 0.0000, 9706.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 300.0000, 3619.7357, 0.0000, 9822.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 300.0000, 3619.7357, 0.0000, 9986.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 300.0000, 3619.7357, 0.0000, 9805.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 100.0000, 300.0000, 0.0000, 4993.7357, 0.0000, 9704.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 600.0000, 300.0000, 0.0000, 2048.7357, 0.0000, 9567.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 600.0000, 300.0000, 0.0000, 2048.7357, 0.0000, 9209.7357],
                 [200.0000, 400.0000, 0.0000, 0.0000, 600.0000, 300.0000, 0.0000, 2048.7357, 0.0000, 9407.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9329.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9545.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9652.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9414.7357],
                 [0.0000, 400.0000, 0.0000, 300.0000, 600.0000, 300.0000, 0.0000, 1779.7357, 0.0000, 9367.7357],
                 [0.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 9319.7357, 0.0000, 19556.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 20094.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19849.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19802.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19487.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19749.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19392.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19671.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19756.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 20111.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19867.7357],
                 [500.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 6094.7357, 0.0000, 19775.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 1990.7357, 0.0000, 20314.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 1990.7357, 0.0000, 20310.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 900.0000, 0.0000, 1990.7357, 0.0000, 20253.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 20044.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 20495.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 19798.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 20103.7357],
                 [1100.0000, 400.0000, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 1946.7357, 0.0000, 20864.7357],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 20425.7357],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 20137.84054],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 20711.35674],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 21470.38914],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 21902.95375],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 20962.95375],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 21833.51837],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 21941.81688],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 21278.51837],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 300.0000, 500.0000, 600.0000, 0, 0.0000, 21224.46995],
                 [1100.0000, 710.4842, 400.0000, 300.0000, 600.0000, 500.0000, 600.0000, 9160, 0.0000, 31225.21185],
                 [600.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 7488, 0.0000, 30894.57479],
                 [600.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 7488, 0.0000, 30764.38113],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208, 0.0000, 31815.5828],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208, 0.0000, 31615.42154],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208, 0.0000, 32486.13941],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208, 0.0000, 33591.28466],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208, 0.0000, 34056.54276],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208, 0.0000, 34756.48633],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208, 0.0000, 34445.54276],
                 [1100.0000, 710.4842, 400.0000, 800.0000, 600.0000, 700.0000, 600.0000, 4208, 0.0000, 34433.95412],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346, 0.0000, 33870.47032],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346, 0.0000, 34014.30104],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346, 0.0000, 34680.56715],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346, 0.0000, 33890.99452],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346, 0.0000, 34004.66398],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346, 0.0000, 34127.77683],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346, 0.0000, 33421.1638],
                 [1100.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11346, 0.0000, 33120.9057],
                 [700.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 13830, 0.0000, 32613.31706],
                 [700.0000, 710.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 13830, 0.0000, 33168.15579],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151, 0.0000, 33504.62357],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151, 0.0000, 33652.13176],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151, 0.0000, 34680.4867],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151, 0.0000, 35557.51909],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151, 0.0000, 35669.71276],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 600.0000, 100.0000, 600.0000, 11151, 0.0000, 35211.44665],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13530, 0.0000, 35550.60792],
                 [700.0000, 1010.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13530, 0.0000, 35711.65633],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695, 0.0000, 35682.60792],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695, 0.0000, 35880.83362],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695, 0.0000, 36249.87403],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695, 0.0000, 36071.61593],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695, 0.0000, 35846.15615],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695, 0.0000, 35773.35783],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695, 0.0000, 36274.94647],
                 [700.0000, 710.4842, 400.0000, 100.0000, 0.0000, 100.0000, 900.0000, 16695, 0.0000, 35739.30941],
                 [500.0000, 710.4842, 1100.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13167, 0.0000, 36135.09172],
                 [500.0000, 710.4842, 1100.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13167, 0.0000, 35286.58353],
                 [500.0000, 710.4842, 1100.0000, 100.0000, 0.0000, 100.0000, 900.0000, 13167, 0.0000, 35081.36584]])
        # VS信号，先卖后买，交割期为2天（股票）1天（现金）
        self.vs_res_sb20 = np.array(
                [[0.000, 0.000, 0.000, 0.000, 500.000, 0.000, 0.000, 7750.000, 0.000, 10000.000],
                 [0.000, 0.000, 0.000, 0.000, 500.000, 0.000, 0.000, 7750.000, 0.000, 9925.000],
                 [0.000, 0.000, 0.000, 0.000, 500.000, 300.000, 300.000, 4954.000, 0.000, 9785.000],
                 [400.000, 400.000, 0.000, 0.000, 500.000, 300.000, 300.000, 878.000, 0.000, 9666.000],
                 [400.000, 400.000, 173.176, 0.000, 500.000, 300.000, 300.000, 0.000, 0.000, 9731.000],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9830.927],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9785.854],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9614.341],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9303.195],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 8834.440],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 8712.755],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 8717.951],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9079.148],
                 [200.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 2598.000, 0.000, 9166.028],
                 [200.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 2598.000, 0.000, 9023.661],
                 [200.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 2598.000, 0.000, 9291.686],
                 [200.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 2598.000, 0.000, 9411.637],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 300.000, 3619.736, 0.000, 9706.736],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 300.000, 3619.736, 0.000, 9822.736],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 300.000, 3619.736, 0.000, 9986.736],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 300.000, 3619.736, 0.000, 9805.736],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 0.000, 4993.736, 0.000, 9704.736],
                 [200.000, 400.000, 0.000, 0.000, 600.000, 300.000, 0.000, 2048.736, 0.000, 9567.736],
                 [200.000, 400.000, 0.000, 0.000, 600.000, 300.000, 0.000, 2048.736, 0.000, 9209.736],
                 [200.000, 400.000, 0.000, 0.000, 600.000, 300.000, 0.000, 2048.736, 0.000, 9407.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9329.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9545.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9652.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9414.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9367.736],
                 [0.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 9319.736, 0.000, 19556.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 20094.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19849.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19802.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19487.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19749.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19392.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19671.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19756.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 20111.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19867.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19775.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 1990.736, 0.000, 20314.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 1990.736, 0.000, 20310.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 1990.736, 0.000, 20253.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 20044.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 20495.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 19798.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 20103.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 20864.736],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 20425.736],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 20137.841],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 20711.357],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21470.389],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21902.954],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 20962.954],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21833.518],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21941.817],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21278.518],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21224.470],
                 [1100.000, 710.484, 400.000, 300.000, 600.000, 500.000, 600.000, 9160.000, 0.000, 31225.212],
                 [600.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 7488.000, 0.000, 30894.575],
                 [600.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 7488.000, 0.000, 30764.381],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 31815.583],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 31615.422],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 32486.139],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 33591.285],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 34056.543],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 34756.486],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 34445.543],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 34433.954],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 33870.470],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 34014.301],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 34680.567],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 33890.995],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 34004.664],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 34127.777],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 33421.164],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 33120.906],
                 [700.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 13830.000, 0.000, 32613.317],
                 [700.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 13830.000, 0.000, 33168.156],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 33504.624],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 33652.132],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 34680.487],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 35557.519],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 35669.713],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 35211.447],
                 [700.000, 1010.484, 400.000, 100.000, 0.000, 100.000, 900.000, 13530.000, 0.000, 35550.608],
                 [700.000, 1010.484, 400.000, 100.000, 0.000, 100.000, 900.000, 13530.000, 0.000, 35711.656],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35682.608],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35880.834],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 36249.874],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 36071.616],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35846.156],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35773.358],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 36274.946],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35739.309],
                 [500.000, 710.484, 1100.000, 100.000, 0.000, 100.000, 900.000, 13167.000, 0.000, 36135.092],
                 [500.000, 710.484, 1100.000, 100.000, 0.000, 100.000, 900.000, 13167.000, 0.000, 35286.584],
                 [500.000, 710.484, 1100.000, 100.000, 0.000, 100.000, 900.000, 13167.000, 0.000, 35081.366]])
        # VS信号，先买后卖，交割期为2天（股票）1天（现金）
        self.vs_res_bs21 = np.array(
                [[0.000, 0.000, 0.000, 0.000, 500.000, 0.000, 0.000, 7750.000, 0.000, 10000.000],
                 [0.000, 0.000, 0.000, 0.000, 500.000, 0.000, 0.000, 7750.000, 0.000, 9925.000],
                 [0.000, 0.000, 0.000, 0.000, 500.000, 300.000, 300.000, 4954.000, 0.000, 9785.000],
                 [400.000, 400.000, 0.000, 0.000, 500.000, 300.000, 300.000, 878.000, 0.000, 9666.000],
                 [400.000, 400.000, 173.176, 0.000, 500.000, 300.000, 300.000, 0.000, 0.000, 9731.000],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9830.927],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9785.854],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9614.341],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9303.195],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 8834.440],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 8712.755],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 8717.951],
                 [400.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 1592.000, 0.000, 9079.148],
                 [200.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 2598.000, 0.000, 9166.028],
                 [200.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 2598.000, 0.000, 9023.661],
                 [200.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 2598.000, 0.000, 9291.686],
                 [200.000, 400.000, 173.176, 0.000, 100.000, 300.000, 300.000, 2598.000, 0.000, 9411.637],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 300.000, 3619.736, 0.000, 9706.736],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 300.000, 3619.736, 0.000, 9822.736],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 300.000, 3619.736, 0.000, 9986.736],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 300.000, 3619.736, 0.000, 9805.736],
                 [200.000, 400.000, 0.000, 0.000, 100.000, 300.000, 0.000, 4993.736, 0.000, 9704.736],
                 [200.000, 400.000, 0.000, 0.000, 600.000, 300.000, 0.000, 2048.736, 0.000, 9567.736],
                 [200.000, 400.000, 0.000, 0.000, 600.000, 300.000, 0.000, 2048.736, 0.000, 9209.736],
                 [200.000, 400.000, 0.000, 0.000, 600.000, 300.000, 0.000, 2048.736, 0.000, 9407.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9329.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9545.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9652.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9414.736],
                 [0.000, 400.000, 0.000, 300.000, 600.000, 300.000, 0.000, 1779.736, 0.000, 9367.736],
                 [0.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 9319.736, 0.000, 19556.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 20094.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19849.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19802.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19487.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19749.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19392.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19671.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19756.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 20111.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19867.736],
                 [500.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 6094.736, 0.000, 19775.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 1990.736, 0.000, 20314.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 1990.736, 0.000, 20310.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 900.000, 0.000, 1990.736, 0.000, 20253.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 20044.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 20495.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 19798.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 20103.736],
                 [1100.000, 400.000, 400.000, 300.000, 300.000, 500.000, 600.000, 1946.736, 0.000, 20864.736],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 20425.736],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 20137.841],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 20711.357],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21470.389],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21902.954],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 20962.954],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21833.518],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21941.817],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21278.518],
                 [1100.000, 710.484, 400.000, 300.000, 300.000, 500.000, 600.000, 0.000, 0.000, 21224.470],
                 [1100.000, 710.484, 400.000, 300.000, 600.000, 500.000, 600.000, 9160.000, 0.000, 31225.212],
                 [600.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 7488.000, 0.000, 30894.575],
                 [600.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 7488.000, 0.000, 30764.381],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 31815.583],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 31615.422],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 32486.139],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 33591.285],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 34056.543],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 34756.486],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 34445.543],
                 [1100.000, 710.484, 400.000, 800.000, 600.000, 700.000, 600.000, 4208.000, 0.000, 34433.954],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 33870.470],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 34014.301],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 34680.567],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 33890.995],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 34004.664],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 34127.777],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 33421.164],
                 [1100.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11346.000, 0.000, 33120.906],
                 [700.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 13830.000, 0.000, 32613.317],
                 [700.000, 710.484, 400.000, 100.000, 600.000, 100.000, 600.000, 13830.000, 0.000, 33168.156],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 33504.624],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 33652.132],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 34680.487],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 35557.519],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 35669.713],
                 [700.000, 1010.484, 400.000, 100.000, 600.000, 100.000, 600.000, 11151.000, 0.000, 35211.447],
                 [700.000, 1010.484, 400.000, 100.000, 0.000, 100.000, 900.000, 13530.000, 0.000, 35550.608],
                 [700.000, 1010.484, 400.000, 100.000, 0.000, 100.000, 900.000, 13530.000, 0.000, 35711.656],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35682.608],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35880.834],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 36249.874],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 36071.616],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35846.156],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35773.358],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 36274.946],
                 [700.000, 710.484, 400.000, 100.000, 0.000, 100.000, 900.000, 16695.000, 0.000, 35739.309],
                 [500.000, 710.484, 1100.000, 100.000, 0.000, 100.000, 900.000, 13167.000, 0.000, 36135.092],
                 [500.000, 710.484, 1100.000, 100.000, 0.000, 100.000, 900.000, 13167.000, 0.000, 35286.584],
                 [500.000, 710.484, 1100.000, 100.000, 0.000, 100.000, 900.000, 13167.000, 0.000, 35081.366]])

        # Multi信号处理结果，先卖后买，使用卖出的现金买进，交割期为2天（股票）0天（现金）
        self.multi_res = np.array(
                [[0.0000, 357.2545, 0.0000, 6506.9627, 0.0000, 9965.1867],
                 [0.0000, 357.2545, 0.0000, 6506.9627, 0.0000, 10033.0650],
                 [0.0000, 178.6273, 0.0000, 8273.5864, 0.0000, 10034.8513],
                 [0.0000, 178.6273, 0.0000, 8273.5864, 0.0000, 10036.6376],
                 [150.3516, 178.6273, 0.0000, 6771.5740, 0.0000, 10019.3404],
                 [150.3516, 178.6273, 0.0000, 6771.5740, 0.0000, 10027.7062],
                 [150.3516, 178.6273, 0.0000, 6771.5740, 0.0000, 10030.1477],
                 [150.3516, 178.6273, 0.0000, 6771.5740, 0.0000, 10005.1399],
                 [150.3516, 178.6273, 0.0000, 6771.5740, 0.0000, 10002.5054],
                 [150.3516, 489.4532, 0.0000, 3765.8877, 0.0000, 9967.3860],
                 [75.1758, 391.5625, 0.0000, 5490.1377, 0.0000, 10044.4059],
                 [75.1758, 391.5625, 0.0000, 5490.1377, 0.0000, 10078.1430],
                 [75.1758, 391.5625, 846.3525, 392.3025, 0.0000, 10138.2709],
                 [75.1758, 391.5625, 846.3525, 392.3025, 0.0000, 10050.4768],
                 [75.1758, 391.5625, 846.3525, 392.3025, 0.0000, 10300.0711],
                 [75.1758, 391.5625, 846.3525, 392.3025, 0.0000, 10392.6970],
                 [75.1758, 391.5625, 169.2705, 4644.3773, 0.0000, 10400.5282],
                 [75.1758, 391.5625, 169.2705, 4644.3773, 0.0000, 10408.9220],
                 [75.1758, 0.0000, 169.2705, 8653.9776, 0.0000, 10376.5914],
                 [75.1758, 0.0000, 169.2705, 8653.9776, 0.0000, 10346.8794],
                 [75.1758, 0.0000, 169.2705, 8653.9776, 0.0000, 10364.7474],
                 [75.1758, 381.1856, 645.5014, 2459.1665, 0.0000, 10302.4570],
                 [18.7939, 381.1856, 645.5014, 3024.6764, 0.0000, 10747.4929],
                 [18.7939, 381.1856, 96.8252, 6492.3097, 0.0000, 11150.9107],
                 [18.7939, 381.1856, 96.8252, 6492.3097, 0.0000, 11125.2946],
                 [18.7939, 114.3557, 96.8252, 9227.3166, 0.0000, 11191.9956],
                 [18.7939, 114.3557, 96.8252, 9227.3166, 0.0000, 11145.7486],
                 [18.7939, 114.3557, 96.8252, 9227.3166, 0.0000, 11090.0768],
                 [132.5972, 114.3557, 864.3802, 4223.9548, 0.0000, 11113.8733],
                 [132.5972, 114.3557, 864.3802, 4223.9548, 0.0000, 11456.3281],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 21983.7333],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 22120.6165],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 21654.5327],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 21429.6550],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 21912.5643],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 22516.3100],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 23169.0777],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 23390.8080],
                 [132.5972, 114.3557, 864.3802, 14223.9548, 0.0000, 23743.3742],
                 [132.5972, 559.9112, 864.3802, 9367.3999, 0.0000, 23210.7311],
                 [132.5972, 559.9112, 864.3802, 9367.3999, 0.0000, 24290.4375],
                 [132.5972, 559.9112, 864.3802, 9367.3999, 0.0000, 24335.3279],
                 [132.5972, 559.9112, 864.3802, 9367.3999, 0.0000, 24487.5764],
                 [132.5972, 559.9112, 864.3802, 9367.3999, 0.0000, 24193.6872],
                 [259.4270, 559.9112, 0.0000, 15820.6915, 0.0000, 24390.0527],
                 [259.4270, 559.9112, 0.0000, 15820.6915, 0.0000, 24389.6421],
                 [259.4270, 559.9112, 0.0000, 15820.6915, 0.0000, 24483.5953],
                 [0.0000, 559.9112, 0.0000, 18321.5674, 0.0000, 24486.1895],
                 [0.0000, 0.0000, 0.0000, 24805.3389, 0.0000, 24805.3389],
                 [0.0000, 0.0000, 0.0000, 24805.3389, 0.0000, 24805.3389]])

    def test_loop_step_pt_sb00(self):
        """ test loop step PT-signal, sell first"""
        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=10000,
                                                     own_amounts=np.zeros(7, dtype='float'),
                                                     available_cash=10000,
                                                     available_amounts=np.zeros(7, dtype='float'),
                                                     op=self.pt_signals[0],
                                                     prices=self.prices[0],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 1 result in complete looping: \n'
              f'cash_change:     +{c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = 10000 + c_g.sum() + c_s.sum()
        amounts = np.zeros(7, dtype='float') + a_p + a_s
        self.assertAlmostEqual(cash, 7500)
        self.assertTrue(np.allclose(amounts, np.array([0, 0, 0, 0, 555.5555556, 0, 0])))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=self.pt_res_sb00[2][7],
                                                     own_amounts=self.pt_res_sb00[2][0:7],
                                                     available_cash=self.pt_res_sb00[2][7],
                                                     available_amounts=self.pt_res_sb00[2][0:7],
                                                     op=self.pt_signals[3],
                                                     prices=self.prices[3],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 4 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.pt_res_sb00[2][7] + c_g.sum() + c_s.sum()
        amounts = self.pt_res_sb00[2][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_sb00[3][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_sb00[3][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=self.pt_res_sb00[30][7],
                                                     own_amounts=self.pt_res_sb00[30][0:7],
                                                     available_cash=self.pt_res_sb00[30][7],
                                                     available_amounts=self.pt_res_sb00[30][0:7],
                                                     op=self.pt_signals[31],
                                                     prices=self.prices[31],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 32 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.pt_res_sb00[30][7] + c_g.sum() + c_s.sum()
        amounts = self.pt_res_sb00[30][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_sb00[31][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_sb00[31][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=self.pt_res_sb00[59][7] + 10000,
                                                     own_amounts=self.pt_res_sb00[59][0:7],
                                                     available_cash=self.pt_res_sb00[59][7] + 10000,
                                                     available_amounts=self.pt_res_sb00[59][0:7],
                                                     op=self.pt_signals[60],
                                                     prices=self.prices[60],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 61 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.pt_res_sb00[59][7] + c_g.sum() + c_s.sum() + 10000
        amounts = self.pt_res_sb00[59][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_sb00[60][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_sb00[60][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.pt_signals[61],
                                                     prices=self.prices[61],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 62 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_sb00[61][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_sb00[61][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=self.pt_res_sb00[95][7],
                                                     own_amounts=self.pt_res_sb00[95][0:7],
                                                     available_cash=self.pt_res_sb00[95][7],
                                                     available_amounts=self.pt_res_sb00[95][0:7],
                                                     op=self.pt_signals[96],
                                                     prices=self.prices[96],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 97 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.pt_res_sb00[96][7] + c_g.sum() + c_s.sum()
        amounts = self.pt_res_sb00[96][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_sb00[96][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_sb00[96][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.pt_signals[97],
                                                     prices=self.prices[97],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 98 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_sb00[97][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_sb00[97][0:7]))

    def test_loop_step_pt_bs00(self):
        """ test loop step PT-signal, buy first"""
        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=10000.,
                                                     own_amounts=np.zeros(7, dtype='float'),
                                                     available_cash=10000.,
                                                     available_amounts=np.zeros(7, dtype='float'),
                                                     op=self.pt_signals[0],
                                                     prices=self.prices[0],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 1 result in complete looping: \n'
              f'cash_change:     +{c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = 10000 + c_g.sum() + c_s.sum()
        amounts = np.zeros(7, dtype='float') + a_p + a_s
        self.assertAlmostEqual(cash, 7500)
        self.assertTrue(np.allclose(amounts, np.array([0, 0, 0, 0, 555.5555556, 0, 0])))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=self.pt_res_bs00[2][7],
                                                     own_amounts=self.pt_res_bs00[2][0:7],
                                                     available_cash=self.pt_res_bs00[2][7],
                                                     available_amounts=self.pt_res_bs00[2][0:7],
                                                     op=self.pt_signals[3],
                                                     prices=self.prices[3],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 4 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.pt_res_bs00[2][7] + c_g.sum() + c_s.sum()
        amounts = self.pt_res_bs00[2][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_bs00[3][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_bs00[3][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=self.pt_res_bs00[30][7],
                                                     own_amounts=self.pt_res_bs00[30][0:7],
                                                     available_cash=self.pt_res_bs00[30][7],
                                                     available_amounts=self.pt_res_bs00[30][0:7],
                                                     op=self.pt_signals[31],
                                                     prices=self.prices[31],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 32 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.pt_res_bs00[30][7] + c_g.sum() + c_s.sum()
        amounts = self.pt_res_bs00[30][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_bs00[31][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_bs00[31][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=self.pt_res_bs00[59][7] + 10000,
                                                     own_amounts=self.pt_res_bs00[59][0:7],
                                                     available_cash=self.pt_res_bs00[59][7] + 10000,
                                                     available_amounts=self.pt_res_bs00[59][0:7],
                                                     op=self.pt_signals[60],
                                                     prices=self.prices[60],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 61 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.pt_res_bs00[59][7] + c_g.sum() + c_s.sum() + 10000
        amounts = self.pt_res_bs00[59][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_bs00[60][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_bs00[60][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.pt_signals[61],
                                                     prices=self.prices[61],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 62 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_bs00[61][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_bs00[61][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=self.pt_res_bs00[95][7],
                                                     own_amounts=self.pt_res_bs00[95][0:7],
                                                     available_cash=self.pt_res_bs00[95][7],
                                                     available_amounts=self.pt_res_bs00[95][0:7],
                                                     op=self.pt_signals[96],
                                                     prices=self.prices[96],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 97 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.pt_res_bs00[96][7] + c_g.sum() + c_s.sum()
        amounts = self.pt_res_bs00[96][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_bs00[96][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_bs00[96][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=0,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.pt_signals[97],
                                                     prices=self.prices[97],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 98 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.pt_res_bs00[97][7], 2)
        self.assertTrue(np.allclose(amounts, self.pt_res_bs00[97][0:7]))

    def test_loop_step_ps_sb00(self):
        """ test loop step PS-signal, sell first"""
        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=10000.,
                                                     own_amounts=np.zeros(7, dtype='float'),
                                                     available_cash=10000.,
                                                     available_amounts=np.zeros(7, dtype='float'),
                                                     op=self.ps_signals[0],
                                                     prices=self.prices[0],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 1 result in complete looping: \n'
              f'cash_change:     +{c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = 10000 + c_g.sum() + c_s.sum()
        amounts = np.zeros(7, dtype='float') + a_p + a_s
        self.assertAlmostEqual(cash, 7500)
        self.assertTrue(np.allclose(amounts, np.array([0, 0, 0, 0, 555.5555556, 0, 0])))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=self.ps_res_sb00[2][7],
                                                     own_amounts=self.ps_res_sb00[2][0:7],
                                                     available_cash=self.ps_res_sb00[2][7],
                                                     available_amounts=self.ps_res_sb00[2][0:7],
                                                     op=self.ps_signals[3],
                                                     prices=self.prices[3],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 4 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.ps_res_sb00[2][7] + c_g.sum() + c_s.sum()
        amounts = self.ps_res_sb00[2][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_sb00[3][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_sb00[3][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=self.ps_res_sb00[30][7],
                                                     own_amounts=self.ps_res_sb00[30][0:7],
                                                     available_cash=self.ps_res_sb00[30][7],
                                                     available_amounts=self.ps_res_sb00[30][0:7],
                                                     op=self.ps_signals[31],
                                                     prices=self.prices[31],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 32 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.ps_res_sb00[30][7] + c_g.sum() + c_s.sum()
        amounts = self.ps_res_sb00[30][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_sb00[31][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_sb00[31][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=self.ps_res_sb00[59][7] + 10000.,
                                                     own_amounts=self.ps_res_sb00[59][0:7],
                                                     available_cash=self.ps_res_sb00[59][7] + 10000.,
                                                     available_amounts=self.ps_res_sb00[59][0:7],
                                                     op=self.ps_signals[60],
                                                     prices=self.prices[60],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 61 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.ps_res_sb00[59][7] + c_g.sum() + c_s.sum() + 10000
        amounts = self.ps_res_sb00[59][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_sb00[60][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_sb00[60][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.ps_signals[61],
                                                     prices=self.prices[61],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 62 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_sb00[61][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_sb00[61][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=self.ps_res_sb00[95][7],
                                                     own_amounts=self.ps_res_sb00[95][0:7],
                                                     available_cash=self.ps_res_sb00[95][7],
                                                     available_amounts=self.ps_res_sb00[95][0:7],
                                                     op=self.ps_signals[96],
                                                     prices=self.prices[96],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 97 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.ps_res_sb00[96][7] + c_g.sum() + c_s.sum()
        amounts = self.ps_res_sb00[96][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_sb00[96][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_sb00[96][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.ps_signals[97],
                                                     prices=self.prices[97],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 98 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_sb00[97][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_sb00[97][0:7]))

    def test_loop_step_ps_bs00(self):
        """ test loop step PS-signal, buy first"""
        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=10000.,
                                                     own_amounts=np.zeros(7, dtype='float'),
                                                     available_cash=10000.,
                                                     available_amounts=np.zeros(7, dtype='float'),
                                                     op=self.ps_signals[0],
                                                     prices=self.prices[0],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 1 result in complete looping: \n'
              f'cash_change:     +{c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = 10000 + c_g.sum() + c_s.sum()
        amounts = np.zeros(7, dtype='float') + a_p + a_s
        self.assertAlmostEqual(cash, 7500)
        self.assertTrue(np.allclose(amounts, np.array([0, 0, 0, 0, 555.5555556, 0, 0])))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=self.ps_res_bs00[2][7],
                                                     own_amounts=self.ps_res_sb00[2][0:7],
                                                     available_cash=self.ps_res_bs00[2][7],
                                                     available_amounts=self.ps_res_bs00[2][0:7],
                                                     op=self.ps_signals[3],
                                                     prices=self.prices[3],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 4 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.ps_res_bs00[2][7] + c_g.sum() + c_s.sum()
        amounts = self.ps_res_bs00[2][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_bs00[3][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_bs00[3][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=self.ps_res_bs00[30][7],
                                                     own_amounts=self.ps_res_sb00[30][0:7],
                                                     available_cash=self.ps_res_bs00[30][7],
                                                     available_amounts=self.ps_res_bs00[30][0:7],
                                                     op=self.ps_signals[31],
                                                     prices=self.prices[31],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 32 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.ps_res_bs00[30][7] + c_g.sum() + c_s.sum()
        amounts = self.ps_res_bs00[30][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_bs00[31][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_bs00[31][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=self.ps_res_bs00[59][7] + 10000,
                                                     own_amounts=self.ps_res_bs00[59][0:7],
                                                     available_cash=self.ps_res_bs00[59][7] + 10000,
                                                     available_amounts=self.ps_res_bs00[59][0:7],
                                                     op=self.ps_signals[60],
                                                     prices=self.prices[60],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 61 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.ps_res_bs00[59][7] + c_g.sum() + c_s.sum() + 10000
        amounts = self.ps_res_bs00[59][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_bs00[60][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_bs00[60][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.ps_signals[61],
                                                     prices=self.prices[61],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 62 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_bs00[61][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_bs00[61][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=self.ps_res_bs00[95][7],
                                                     own_amounts=self.ps_res_bs00[95][0:7],
                                                     available_cash=self.ps_res_bs00[95][7],
                                                     available_amounts=self.ps_res_bs00[95][0:7],
                                                     op=self.ps_signals[96],
                                                     prices=self.prices[96],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 97 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.ps_res_bs00[96][7] + c_g.sum() + c_s.sum()
        amounts = self.ps_res_bs00[96][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_bs00[96][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_bs00[96][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=1,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.ps_signals[97],
                                                     prices=self.prices[97],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 98 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.ps_res_bs00[97][7], 2)
        self.assertTrue(np.allclose(amounts, self.ps_res_bs00[97][0:7]))

    def test_loop_step_vs_sb00(self):
        """test loop step of Volume Signal type of signals"""
        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=10000.,
                                                     own_amounts=np.zeros(7, dtype='float'),
                                                     available_cash=10000.,
                                                     available_amounts=np.zeros(7, dtype='float'),
                                                     op=self.vs_signals[0],
                                                     prices=self.prices[0],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 1 result in complete looping: \n'
              f'cash_change:     +{c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = 10000 + c_g.sum() + c_s.sum()
        amounts = np.zeros(7, dtype='float') + a_p + a_s
        self.assertAlmostEqual(cash, 7750)
        self.assertTrue(np.allclose(amounts, np.array([0, 0, 0, 0, 500., 0, 0])))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=self.vs_res_sb00[2][7],
                                                     own_amounts=self.vs_res_sb00[2][0:7],
                                                     available_cash=self.vs_res_sb00[2][7],
                                                     available_amounts=self.vs_res_sb00[2][0:7],
                                                     op=self.vs_signals[3],
                                                     prices=self.prices[3],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 4 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.vs_res_sb00[2][7] + c_g.sum() + c_s.sum()
        amounts = self.vs_res_sb00[2][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_sb00[3][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_sb00[3][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=self.vs_res_sb00[30][7],
                                                     own_amounts=self.vs_res_sb00[30][0:7],
                                                     available_cash=self.vs_res_sb00[30][7],
                                                     available_amounts=self.vs_res_sb00[30][0:7],
                                                     op=self.vs_signals[31],
                                                     prices=self.prices[31],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 32 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.vs_res_sb00[30][7] + c_g.sum() + c_s.sum()
        amounts = self.vs_res_sb00[30][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_sb00[31][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_sb00[31][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=self.vs_res_sb00[59][7] + 10000,
                                                     own_amounts=self.vs_res_sb00[59][0:7],
                                                     available_cash=self.vs_res_sb00[59][7] + 10000,
                                                     available_amounts=self.vs_res_sb00[59][0:7],
                                                     op=self.vs_signals[60],
                                                     prices=self.prices[60],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 61 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.vs_res_sb00[59][7] + c_g.sum() + c_s.sum() + 10000
        amounts = self.vs_res_sb00[59][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_sb00[60][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_sb00[60][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.vs_signals[61],
                                                     prices=self.prices[61],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 62 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_sb00[61][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_sb00[61][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=self.vs_res_sb00[95][7],
                                                     own_amounts=self.vs_res_sb00[95][0:7],
                                                     available_cash=self.vs_res_sb00[95][7],
                                                     available_amounts=self.vs_res_sb00[95][0:7],
                                                     op=self.vs_signals[96],
                                                     prices=self.prices[96],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 97 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.vs_res_sb00[96][7] + c_g.sum() + c_s.sum()
        amounts = self.vs_res_sb00[96][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_sb00[96][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_sb00[96][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.vs_signals[97],
                                                     prices=self.prices[97],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=True,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 98 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_sb00[97][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_sb00[97][0:7]))

    def test_loop_step_vs_bs00(self):
        """test loop step of Volume Signal type of signals"""
        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=10000.,
                                                     own_amounts=np.zeros(7, dtype='float'),
                                                     available_cash=10000.,
                                                     available_amounts=np.zeros(7, dtype='float'),
                                                     op=self.vs_signals[0],
                                                     prices=self.prices[0],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 1 result in complete looping: \n'
              f'cash_change:     +{c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = 10000 + c_g.sum() + c_s.sum()
        amounts = np.zeros(7, dtype='float') + a_p + a_s
        self.assertAlmostEqual(cash, 7750)
        self.assertTrue(np.allclose(amounts, np.array([0, 0, 0, 0, 500., 0, 0])))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=self.vs_res_bs00[2][7],
                                                     own_amounts=self.vs_res_bs00[2][0:7],
                                                     available_cash=self.vs_res_bs00[2][7],
                                                     available_amounts=self.vs_res_bs00[2][0:7],
                                                     op=self.vs_signals[3],
                                                     prices=self.prices[3],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 4 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.vs_res_bs00[2][7] + c_g.sum() + c_s.sum()
        amounts = self.vs_res_bs00[2][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_bs00[3][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_bs00[3][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=self.vs_res_bs00[30][7],
                                                     own_amounts=self.vs_res_bs00[30][0:7],
                                                     available_cash=self.vs_res_bs00[30][7],
                                                     available_amounts=self.vs_res_bs00[30][0:7],
                                                     op=self.vs_signals[31],
                                                     prices=self.prices[31],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 32 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.vs_res_bs00[30][7] + c_g.sum() + c_s.sum()
        amounts = self.vs_res_bs00[30][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_bs00[31][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_bs00[31][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=self.vs_res_bs00[59][7] + 10000,
                                                     own_amounts=self.vs_res_bs00[59][0:7],
                                                     available_cash=self.vs_res_bs00[59][7] + 10000,
                                                     available_amounts=self.vs_res_bs00[59][0:7],
                                                     op=self.vs_signals[60],
                                                     prices=self.prices[60],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 61 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.vs_res_bs00[59][7] + c_g.sum() + c_s.sum() + 10000
        amounts = self.vs_res_bs00[59][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_bs00[60][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_bs00[60][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.vs_signals[61],
                                                     prices=self.prices[61],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 62 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_bs00[61][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_bs00[61][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=self.vs_res_bs00[95][7],
                                                     own_amounts=self.vs_res_bs00[95][0:7],
                                                     available_cash=self.vs_res_bs00[95][7],
                                                     available_amounts=self.vs_res_bs00[95][0:7],
                                                     op=self.vs_signals[96],
                                                     prices=self.prices[96],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 97 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = self.vs_res_bs00[96][7] + c_g.sum() + c_s.sum()
        amounts = self.vs_res_bs00[96][0:7] + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_bs00[96][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_bs00[96][0:7]))

        c_g, c_s, a_p, a_s, fee = qt.core._loop_step(signal_type=2,
                                                     own_cash=cash,
                                                     own_amounts=amounts,
                                                     available_cash=cash,
                                                     available_amounts=amounts,
                                                     op=self.vs_signals[97],
                                                     prices=self.prices[97],
                                                     buy_fix=self.rate['buy_fix'],
                                                     sell_fix=self.rate['sell_fix'],
                                                     buy_rate=self.rate['buy_rate'],
                                                     sell_rate=self.rate['sell_rate'],
                                                     buy_min=self.rate['buy_min'],
                                                     sell_min=self.rate['sell_min'],
                                                     slipage=self.rate['slipage'],
                                                     pt_buy_threshold=0.1,
                                                     pt_sell_threshold=0.1,
                                                     maximize_cash_usage=False,
                                                     long_pos_limit=1.,
                                                     short_pos_limit=-1.,
                                                     allow_sell_short=False,
                                                     moq_buy=0,
                                                     moq_sell=0)
        print(f'day 98 result in complete looping: \n'
              f'cash_change:     + {c_g.sum():.2f} / {c_s.sum():.2f}\n'
              f'amount_changed:  \npurchased: {np.round(a_p, 2)}\nsold:{np.round(a_s, 2)}\n'
              f'----------------------------------\n')
        cash = cash + c_g.sum() + c_s.sum()
        amounts = amounts + a_p + a_s
        self.assertAlmostEqual(cash, self.vs_res_bs00[97][7], 2)
        self.assertTrue(np.allclose(amounts, self.vs_res_bs00[97][0:7]))

    def test_loop_pt(self):
        """ Test looping of PT proportion target signals, with
            stock delivery delay = 0 days
            cash delivery delay = 0 day
            buy-sell sequence = sell first
        """
        print('Test looping of PT proportion target signals, with:\n'
              'stock delivery delay = 0 days \n'
              'cash delivery delay = 0 day \n'
              'buy-sell sequence = sell first')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_pt_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                inflation_rate=0,
                pt_signal_timing='aggressive',
                trade_log=True,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_pt_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop, line by line comparison between test and target is:\n')
        for r, t in zip(res.values, self.pt_res_bs00):
            print(f'res: {np.round(r, 0)}\n'
                  f'target: {np.round(t, 0)}\n'
                  f'{"Check!" if np.allclose(r, t) else "<-Different!!"}\n')
        self.assertTrue(np.allclose(res, self.pt_res_bs00, atol=0.01))
        print(f'test assertion errors in apply_loop: detect moqs that are not compatible')
        self.assertRaises(AssertionError,
                          apply_loop,
                          self.op_pt_batch,
                          self.history_list,
                          0,
                          None,
                          self.cash,
                          self.rate,
                          0, 1,
                          0, 0.1, 0.1, 0, 0,
                          False)
        self.assertRaises(AssertionError,
                          apply_loop,
                          self.op_pt_batch,
                          self.history_list,
                          0,
                          None,
                          self.cash,
                          self.rate,
                          1, 5,
                          0, 0.1, 0.1, 0, 0,
                          False)
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_pt_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                inflation_rate=0,
                pt_signal_timing='aggressive',
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_pt_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        # print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_pt_with_delay(self):
        """ Test looping of PT proportion target signals, with:
            stock delivery delay = 2 days
            cash delivery delay = 1 day
            use_sell_cash = False

        """
        print('Test looping of PT proportion target signals, with:\n'
              'stock delivery delay = 2 days \n'
              'cash delivery delay = 1 day \n'
              'maximize_cash = False (buy and sell at the same time)')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_pt_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                inflation_rate=0,
                pt_signal_timing='aggressive',
                cash_delivery_period=1,
                stock_delivery_period=2,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_pt_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}\n'
              f'result comparison line by line:')
        for i in range(len(res)):
            print(np.around(res.values[i]))
            print(np.around(self.pt_res_bs21[i]))
            print()
        self.assertTrue(np.allclose(res, self.pt_res_bs21, atol=0.01))
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_pt_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                inflation_rate=0,
                pt_signal_timing='aggressive',
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_pt_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_pt_with_delay_use_cash(self):
        """ Test looping of PT proportion target signals, with:
            stock delivery delay = 2 days
            cash delivery delay = 0 day
            use sell cash = True    (sell stock first to use cash when possible
                                    (not possible when cash delivery period != 0))

        """
        print('Test looping of PT proportion target signals, with:\n'
              'stock delivery delay = 2 days \n'
              'cash delivery delay = 0 day \n'
              'maximize cash usage = True \n'
              'but not applicable because cash delivery period == 1')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_pt_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                cash_delivery_period=0,
                stock_delivery_period=2,
                inflation_rate=0,
                pt_signal_timing='aggressive',
                max_cash_usage=True,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_pt_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}\n'
              f'result comparison line by line:')
        for i in range(len(res)):
            print(np.around(res.values[i]))
            print(np.around(self.pt_res_sb20[i]))
            print()
        self.assertTrue(np.allclose(res, self.pt_res_sb20, atol=0.01))
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_ps_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                cash_delivery_period=1,
                stock_delivery_period=2,
                inflation_rate=0,
                pt_signal_timing='aggressive',
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_ps_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_ps(self):
        """ Test looping of PS Proportion Signal type of signals

        """
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_ps_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_ps_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')
        self.assertTrue(np.allclose(res, self.ps_res_bs00, atol=0.01))
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_ps_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_ps_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_ps_with_delay(self):
        """ Test looping of PT proportion target signals, with:
            stock delivery delay = 2 days
            cash delivery delay = 1 day
            use_sell_cash = False

        """
        print('Test looping of PS proportion target signals, with:\n'
              'stock delivery delay = 2 days \n'
              'cash delivery delay = 1 day \n'
              'maximize_cash = False (buy and sell at the same time)')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_ps_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                inflation_rate=0,
                cash_delivery_period=1,
                stock_delivery_period=2,
                max_cash_usage=False,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_ps_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}\n'
              f'result comparison line by line:')
        for i in range(len(res)):
            print(np.around(res.values[i]))
            print(np.around(self.ps_res_bs21[i]))
            self.assertTrue(np.allclose(res.values[i], self.ps_res_bs21[i], atol=0.01))
            print()
        self.assertTrue(np.allclose(res, self.ps_res_bs21, atol=0.01))
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_ps_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_ps_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_ps_with_delay_use_cash(self):
        """ Test looping of PT proportion target signals, with:
            stock delivery delay = 2 days
            cash delivery delay = 0 day
            use sell cash = True    (sell stock first to use cash when possible
                                    (not possible when cash delivery period != 0))

        """
        print('Test looping of PS proportion target signals, with:\n'
              'stock delivery delay = 2 days \n'
              'cash delivery delay = 1 day \n'
              'maximize cash usage = True \n'
              'but not applicable because cash delivery period == 1')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_ps_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                cash_delivery_period=0,
                stock_delivery_period=2,
                inflation_rate=0,
                max_cash_usage=True,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_ps_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}\n'
              f'result comparison line by line:')
        for i in range(len(res)):
            print(np.around(res.values[i]))
            print(np.around(self.ps_res_sb20[i]))
            print()
        self.assertTrue(np.allclose(res, self.ps_res_sb20, atol=0.01))
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_ps_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                cash_delivery_period=1,
                stock_delivery_period=2,
                inflation_rate=0,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_ps_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_vs(self):
        """ Test looping of VS Volume Signal type of signals

        """
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_vs_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_vs_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')
        self.assertTrue(np.allclose(res, self.vs_res_bs00, atol=0.01))
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_vs_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_vs_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_vs_with_delay(self):
        """ Test looping of PT proportion target signals, with:
            stock delivery delay = 2 days
            cash delivery delay = 1 day
            use_sell_cash = False

        """
        print('Test looping of VS proportion target signals, with:\n'
              'stock delivery delay = 2 days \n'
              'cash delivery delay = 1 day \n'
              'maximize_cash = False (buy and sell at the same time)')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_vs_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                inflation_rate=0,
                cash_delivery_period=1,
                stock_delivery_period=2,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_vs_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}\n'
              f'result comparison line by line:')
        for i in range(len(res)):
            print(np.around(res.values[i]))
            print(np.around(self.vs_res_bs21[i]))
            print()
        self.assertTrue(np.allclose(res, self.vs_res_bs21, atol=0.01))
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_vs_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_vs_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_vs_with_delay_use_cash(self):
        """ Test looping of PT proportion target signals, with:
            stock delivery delay = 2 days
            cash delivery delay = 0 day
            use sell cash = True    (sell stock first to use cash when possible
                                    (not possible when cash delivery period != 0))

        """
        print('Test looping of VS proportion target signals, with:\n'
              'stock delivery delay = 2 days \n'
              'cash delivery delay = 1 day \n'
              'maximize cash usage = True \n'
              'but not applicable because cash delivery period == 1')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_vs_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                cash_delivery_period=0,
                stock_delivery_period=2,
                inflation_rate=0,
                max_cash_usage=True,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_vs_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}\n'
              f'result comparison line by line:')
        for i in range(len(res)):
            print(np.around(res.values[i]))
            print(np.around(self.vs_res_sb20[i]))
            print()
        self.assertTrue(np.allclose(res, self.vs_res_sb20, atol=0.01))
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_vs_batch,
                trade_price_list=self.history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                cash_delivery_period=1,
                stock_delivery_period=2,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_vs_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')

    def test_loop_multiple_signal(self):
        """ Test looping of PS Proportion Signal type of signals

        """
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_multi_batch,
                trade_price_list=self.multi_history_list,
                cash_plan=self.cash,
                cost_rate=self.rate,
                moq_buy=0,
                moq_sell=0,
                cash_delivery_period=0,
                stock_delivery_period=2,
                max_cash_usage=True,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0, 1, 2]
        )
        res = process_loop_results(
                operator=self.op_multi_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}\n'
              f'result comparison line by line:')
        for i in range(len(res)):
            print(np.around(res.values[i]))
            print(np.around(self.multi_res[i]))
            self.assertTrue(np.allclose(res.values[i], self.multi_res[i]))
            print()

        self.assertTrue(np.allclose(res, self.multi_res, atol=0.1))
        print(f'test loop results with moq equal to 100')
        loop_results, op_log_matrix, op_summary_matrix, op_list_bt_indices = apply_loop(
                operator=self.op_multi_batch,
                trade_price_list=self.multi_history_list,
                cash_plan=self.cash,
                cost_rate=self.rate2,
                moq_buy=100,
                moq_sell=1,
                cash_delivery_period=0,
                stock_delivery_period=2,
                max_cash_usage=False,
                inflation_rate=0,
                trade_log=False,
                price_priority_list=[0]
        )
        res = process_loop_results(
                operator=self.op_multi_batch,
                loop_results=loop_results,
                op_log_matrix=op_log_matrix,
                op_summary_matrix=op_summary_matrix,
                op_list_bt_indices=op_list_bt_indices
        )
        self.assertIsInstance(res, pd.DataFrame)
        print(f'in test_loop:\nresult of loop test is \n{res}')


if __name__ == '__main__':
    unittest.main()