[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![CPP17](https://img.shields.io/badge/Language-C++17-blue.svg)]()
[![PyPi](https://img.shields.io/pypi/v/sciqlopplots.svg)](https://pypi.python.org/pypi/sciqlopplots)
[![Coverage](https://codecov.io/gh/SciQLop/CDFpp/coverage.svg?branch=main)](https://codecov.io/gh/SciQLop/SciQLopPlots/branch/main)

# SciQLopPlots - A High-Performance Plotting Library for Scientific Data


SciQLopPlots is a powerful and efficient plotting library designed for the [SciQLop](https://github.com/SciQLop/SciQLop) scientific data analysis platform. It provides interactive visualization capabilities optimized for handling large-scale scientific datasets with seamless integration into SciQLop's ecosystem.


## Key Features

- **High-Performance Rendering**: Optimized for smooth interaction with large non uniform 1D, 2D datasets.
- **Interactive Visualization**: Pan, zoom, and inspect data points in real time.
- **Multiple Plot Types**: Supports time series, spectrograms, parametric curves.
- **Customizable Styling**: Adjust colors, labels, axes, and plot layouts programmatically or via GUI.
- **Cross-Platform**: Works on Windows, Linux, and macOS.

## Installation 

SciQLopPlots can be installed as a stadalone Python package with pip.

```bash
python -m pip install SciQLopPlots
```

# How to contribute

Just fork the repository, make your changes and submit a pull request. We will be happy to review and merge your
changes.
Reports of bugs and feature requests are also welcome. Do not forget to star the project if you like it!

# Credits

The development of SciQLop is supported by the [CDPP](http://www.cdpp.eu/).<br />
We acknowledge support from the federation [Plas@Par](https://www.plasapar.sorbonne-universite.fr)

# Thanks

We would like to thank the developers of the following libraries that SciQLop depends on:

- [PySide6](https://doc.qt.io/qtforpython-6/index.html) for the GUI framework and Qt bindings.
- [QCustomPlot](https://www.qcustomplot.com/) for providing the plotting library.
