/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data.h"

GtinvData::GtinvData(){

    set_gtinv_info();
}

GtinvData::~GtinvData(){}

const vector2i& GtinvData::get_l_array() const{ return l_array_all; }
const vector3i& GtinvData::get_m_array() const{ return m_array_all; }
const vector2d& GtinvData::get_coeffs() const{ return coeffs_all; }

void GtinvData::set_gtinv_info(){

    l_array_all =
        {{0},
        {0, 0},
        {1, 1},
        {2, 2},
        {3, 3},
        {4, 4},
        {5, 5},
        {6, 6},
        {7, 7},
        {8, 8},
        {9, 9},
        {10, 10},
        {11, 11},
        {12, 12},
        {13, 13},
        {14, 14},
        {15, 15},
        {16, 16},
        {17, 17},
        {18, 18},
        {19, 19},
        {20, 20},
        {0, 0, 0},
        {0, 1, 1},
        {0, 2, 2},
        {0, 3, 3},
        {0, 4, 4},
        {0, 5, 5},
        {0, 6, 6},
        {0, 7, 7},
        {0, 8, 8},
        {0, 9, 9},
        {0, 10, 10},
        {1, 1, 2},
        {1, 2, 3},
        {1, 3, 4},
        {1, 4, 5},
        {1, 5, 6},
        {1, 6, 7},
        {1, 7, 8},
        {1, 8, 9},
        {1, 9, 10},
        {2, 2, 2},
        {2, 2, 4},
        {2, 3, 3},
        {2, 3, 5},
        {2, 4, 4},
        {2, 4, 6},
        {2, 5, 5},
        {2, 5, 7},
        {2, 6, 6},
        {2, 6, 8},
        {2, 7, 7},
        {2, 7, 9},
        {2, 8, 8},
        {2, 8, 10},
        {2, 9, 9},
        {2, 10, 10},
        {3, 3, 4},
        {3, 3, 6},
        {3, 4, 5},
        {3, 4, 7},
        {3, 5, 6},
        {3, 5, 8},
        {3, 6, 7},
        {3, 6, 9},
        {3, 7, 8},
        {3, 7, 10},
        {3, 8, 9},
        {3, 9, 10},
        {4, 4, 4},
        {4, 4, 6},
        {4, 4, 8},
        {4, 5, 5},
        {4, 5, 7},
        {4, 5, 9},
        {4, 6, 6},
        {4, 6, 8},
        {4, 6, 10},
        {4, 7, 7},
        {4, 7, 9},
        {4, 8, 8},
        {4, 8, 10},
        {4, 9, 9},
        {4, 10, 10},
        {5, 5, 6},
        {5, 5, 8},
        {5, 5, 10},
        {5, 6, 7},
        {5, 6, 9},
        {5, 7, 8},
        {5, 7, 10},
        {5, 8, 9},
        {5, 9, 10},
        {6, 6, 6},
        {6, 6, 8},
        {6, 6, 10},
        {6, 7, 7},
        {6, 7, 9},
        {6, 8, 8},
        {6, 8, 10},
        {6, 9, 9},
        {6, 10, 10},
        {7, 7, 8},
        {7, 7, 10},
        {7, 8, 9},
        {7, 9, 10},
        {8, 8, 8},
        {8, 8, 10},
        {8, 9, 9},
        {8, 10, 10},
        {9, 9, 10},
        {10, 10, 10},
        {0, 11, 11},
        {0, 12, 12},
        {1, 10, 11},
        {1, 11, 12},
        {2, 9, 11},
        {2, 10, 12},
        {2, 11, 11},
        {2, 12, 12},
        {3, 8, 11},
        {3, 9, 12},
        {3, 10, 11},
        {3, 11, 12},
        {4, 7, 11},
        {4, 8, 12},
        {4, 9, 11},
        {4, 10, 12},
        {4, 11, 11},
        {4, 12, 12},
        {5, 6, 11},
        {5, 7, 12},
        {5, 8, 11},
        {5, 9, 12},
        {5, 10, 11},
        {5, 11, 12},
        {6, 6, 12},
        {6, 7, 11},
        {6, 8, 12},
        {6, 9, 11},
        {6, 10, 12},
        {6, 11, 11},
        {6, 12, 12},
        {7, 7, 12},
        {7, 8, 11},
        {7, 9, 12},
        {7, 10, 11},
        {7, 11, 12},
        {8, 8, 12},
        {8, 9, 11},
        {8, 10, 12},
        {8, 11, 11},
        {8, 12, 12},
        {9, 9, 12},
        {9, 10, 11},
        {9, 11, 12},
        {10, 10, 12},
        {10, 11, 11},
        {10, 12, 12},
        {11, 11, 12},
        {12, 12, 12},
        {0, 0, 0, 0},
        {0, 0, 1, 1},
        {0, 0, 2, 2},
        {0, 1, 1, 2},
        {0, 2, 2, 2},
        {1, 1, 1, 1},
        {1, 1, 1, 1},
        {1, 1, 2, 2},
        {1, 1, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {2, 2, 2, 2},
        {0, 0, 3, 3},
        {0, 0, 4, 4},
        {0, 1, 2, 3},
        {0, 1, 3, 4},
        {0, 2, 2, 4},
        {0, 2, 3, 3},
        {0, 2, 4, 4},
        {0, 3, 3, 4},
        {0, 4, 4, 4},
        {1, 1, 1, 3},
        {1, 1, 2, 4},
        {1, 1, 3, 3},
        {1, 1, 3, 3},
        {1, 1, 4, 4},
        {1, 1, 4, 4},
        {1, 2, 2, 3},
        {1, 2, 2, 3},
        {1, 2, 3, 4},
        {1, 2, 3, 4},
        {1, 3, 3, 3},
        {1, 3, 3, 3},
        {1, 3, 4, 4},
        {1, 3, 4, 4},
        {2, 2, 2, 4},
        {2, 2, 2, 4},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 3, 3},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 2, 4, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 3, 3, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {2, 4, 4, 4},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 3, 3},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {3, 3, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {4, 4, 4, 4},
        {0, 0, 0, 0, 0},
        {0, 0, 0, 1, 1},
        {0, 1, 1, 1, 1},
        {0, 1, 1, 1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, 1},
        {0, 0, 1, 1, 1, 1},
        {0, 0, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1}};

    coeffs_all =
        {{1},
        {1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {0.447213595499958,
         -0.447213595499958,
         0.447213595499958,
         -0.447213595499958,
         0.447213595499958},
        {-0.377964473009227,
         0.377964473009227,
         -0.377964473009227,
         0.377964473009227,
         -0.377964473009228,
         0.377964473009227,
         -0.377964473009227},
        {-0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333},
        {0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764},
        {-0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615},
        {0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161},
        {-0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333},
        {0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562},
        {-0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235993},
        {-0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075},
        {0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2},
        {-0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875},
        {-0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052},
        {0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775},
        {0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698},
        {-0.169030850945704,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945704,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945704,
         0.169030850945704,
         -0.169030850945704,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945704,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945704,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945704,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703},
        {-0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357},
        {-0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087},
        {-0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606},
        {1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {-0.447213595499958,
         0.447213595499958,
         -0.447213595499958,
         0.447213595499958,
         -0.447213595499958},
        {-0.377964473009227,
         0.377964473009227,
         -0.377964473009227,
         0.377964473009227,
         -0.377964473009227,
         0.377964473009227,
         -0.377964473009227},
        {-0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333},
        {0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764},
        {0.277350098112614,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112614},
        {-0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161},
        {0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333},
        {0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870561,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562},
        {0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235993},
        {0.447213595499958,
         -0.316227766016838,
         0.182574185835055,
         -0.316227766016838,
         0.365148371670111,
         -0.316227766016838,
         0.182574185835055,
         -0.316227766016838,
         0.447213595499958},
        {-0.377964473009227,
         0.308606699924184,
         -0.239045721866879,
         0.169030850945703,
         -0.0975900072948533,
         0.218217890235993,
         -0.276026223736942,
         0.29277002188456,
         -0.276026223736942,
         0.218217890235992,
         -0.0975900072948533,
         0.169030850945703,
         -0.239045721866879,
         0.308606699924184,
         -0.377964473009227},
        {0.333333333333333,
         -0.288675134594813,
         0.243975018237133,
         -0.199204768222399,
         0.154303349962092,
         -0.109108945117996,
         0.0629940788348712,
         -0.166666666666667,
         0.218217890235993,
         -0.243975018237133,
         0.251976315339485,
         -0.243975018237133,
         0.218217890235993,
         -0.166666666666667,
         0.0629940788348712,
         -0.109108945117996,
         0.154303349962092,
         -0.199204768222399,
         0.243975018237133,
         -0.288675134594813,
         0.333333333333333},
        {-0.301511344577764,
         0.269679944985297,
         -0.237835356004225,
         0.205971460217775,
         -0.174077655955698,
         0.14213381090374,
         -0.110096376512636,
         0.0778498944161523,
         -0.0449466574975495,
         0.134839972492648,
         -0.179786629990198,
         0.205971460217775,
         -0.220192753025272,
         0.224733287487747,
         -0.220192753025272,
         0.205971460217775,
         -0.179786629990198,
         0.134839972492648,
         -0.0449466574975495,
         0.0778498944161523,
         -0.110096376512636,
         0.14213381090374,
         -0.174077655955698,
         0.205971460217775,
         -0.237835356004225,
         0.269679944985297,
         -0.301511344577764},
        {0.277350098112614,
         -0.253184841770917,
         0.229014306207172,
         -0.204836622599676,
         0.180648920932378,
         -0.156446554693686,
         0.132221471336986,
         -0.107958379271883,
         0.0836242010007091,
         -0.0591312395989083,
         0.0341394370999459,
         -0.11322770341446,
         0.152676204138115,
         -0.177393718796725,
         0.193121819834107,
         -0.201971633633391,
         0.204836622599676,
         -0.201971633633391,
         0.193121819834107,
         -0.177393718796725,
         0.152676204138115,
         -0.11322770341446,
         0.0341394370999459,
         -0.0591312395989083,
         0.0836242010007091,
         -0.107958379271883,
         0.132221471336986,
         -0.156446554693686,
         0.180648920932378,
         -0.204836622599676,
         0.229014306207172,
         -0.253184841770917,
         0.277350098112614},
        {0.258198889747161,
         -0.239045721866879,
         0.21989008243131,
         -0.200731263865499,
         0.181568259800641,
         -0.16239958858823,
         0.143222974807887,
         -0.124034734589209,
         0.104828483672192,
         -0.0855920985021826,
         0.0662993544131797,
         -0.0468807230938495,
         0.0270665980980382,
         -0.0975900072948538,
         0.132598708826359,
         -0.155485768402849,
         0.171184197004365,
         -0.181568259800641,
         0.187522892375398,
         -0.189466186686269,
         0.187522892375398,
         -0.181568259800641,
         0.171184197004365,
         -0.155485768402849,
         0.132598708826359,
         -0.0975900072948535,
         0.0270665980980383,
         -0.0468807230938493,
         0.0662993544131796,
         -0.0855920985021825,
         0.104828483672192,
         -0.124034734589209,
         0.143222974807887,
         -0.16239958858823,
         0.181568259800641,
         -0.200731263865498,
         0.21989008243131,
         -0.239045721866879,
         0.258198889747161},
        {0.242535625036333,
         -0.226871303243257,
         0.21120568916877,
         -0.195538472218761,
         0.179869233546125,
         -0.164197394357296,
         0.148522131446501,
         -0.132842232831015,
         0.117155837225801,
         -0.101459931239179,
         0.0857492925712544,
         -0.0700140042014004,
         0.0542326144546641,
         -0.0383482494423685,
         0.0221403721385024,
         -0.0857492925712544,
         0.117155837225801,
         -0.138266579688743,
         0.153392997769473,
         -0.164197394357296,
         0.171498585142509,
         -0.175733755838702,
         0.177122977108019,
         -0.175733755838702,
         0.171498585142509,
         -0.164197394357296,
         0.153392997769474,
         -0.138266579688743,
         0.117155837225801,
         -0.0857492925712544,
         0.0221403721385023,
         -0.0383482494423685,
         0.054232614454664,
         -0.0700140042014004,
         0.0857492925712546,
         -0.101459931239179,
         0.117155837225801,
         -0.132842232831014,
         0.148522131446501,
         -0.164197394357296,
         0.179869233546125,
         -0.195538472218761,
         0.21120568916877,
         -0.226871303243257,
         0.242535625036333},
        {0.229415733870562,
         -0.216295228174351,
         0.203173988892875,
         -0.190051864085337,
         0.17692865672356,
         -0.16380410662043,
         0.150677862904453,
         -0.137549440715733,
         0.12441815044836,
         -0.111282976814932,
         0.0981423606024253,
         -0.0849937774690733,
         0.0718328526534359,
         -0.0586512785898156,
         0.0454310850424254,
         -0.0321246283101619,
         0.0185471628024885,
         -0.0764719112901873,
         0.104918596715285,
         -0.12441815044836,
         0.13879425740726,
         -0.149532007013318,
         0.157377895072927,
         -0.162750693079001,
         0.165890867264479,
         -0.166924465222397,
         0.165890867264479,
         -0.162750693079001,
         0.157377895072927,
         -0.149532007013318,
         0.13879425740726,
         -0.12441815044836,
         0.104918596715285,
         -0.0764719112901875,
         0.0185471628024886,
         -0.0321246283101618,
         0.0454310850424256,
         -0.0586512785898156,
         0.0718328526534358,
         -0.0849937774690732,
         0.0981423606024251,
         -0.111282976814932,
         0.12441815044836,
         -0.137549440715733,
         0.150677862904452,
         -0.16380410662043,
         0.176928656723561,
         -0.190051864085337,
         0.203173988892875,
         -0.21629522817435,
         0.229415733870562},
        {0.218217890235993,
         -0.207019667802706,
         0.195821001584749,
         -0.184621810825757,
         0.173421993904824,
         -0.162221421130763,
         0.15101992432742,
         -0.139817281408455,
         0.128613192882607,
         -0.117407244890945,
         0.106198848810718,
         -0.0949871380291957,
         0.083770781658339,
         -0.0725476250110011,
         0.0613139339484963,
         -0.0500626174321758,
         0.0387783367164744,
         -0.027420424855354,
         0.0158311896715325,
         -0.0690065559342355,
         0.0949871380291955,
         -0.113057307977937,
         0.126649517372261,
         -0.13710212427677,
         0.145095250022002,
         -0.15101992432742,
         0.155113346865896,
         -0.157518348376271,
         0.158311896715326,
         -0.15751834837627,
         0.155113346865896,
         -0.15101992432742,
         0.145095250022002,
         -0.13710212427677,
         0.126649517372261,
         -0.113057307977937,
         0.0949871380291957,
         -0.0690065559342355,
         0.0158311896715325,
         -0.0274204248553539,
         0.038778336716474,
         -0.050062617432176,
         0.0613139339484964,
         -0.0725476250110011,
         0.0837707816583392,
         -0.0949871380291955,
         0.106198848810718,
         -0.117407244890945,
         0.128613192882607,
         -0.139817281408455,
         0.15101992432742,
         -0.162221421130763,
         0.173421993904824,
         -0.184621810825757,
         0.195821001584749,
         -0.207019667802706,
         0.218217890235993},
        {0.239045721866879,
         -0.29277002188456,
         0.239045721866879,
         -0.29277002188456,
         0.119522860933439,
         0.119522860933439,
         -0.29277002188456,
         0.239045721866879,
         0.119522860933439,
         -0.239045721866879,
         0.119522860933439,
         0.239045721866879,
         -0.29277002188456,
         0.119522860933439,
         0.119522860933439,
         -0.29277002188456,
         0.239045721866879,
         -0.29277002188456,
         0.239045721866879},
        {-0.333333333333333,
         0.235702260395516,
         -0.154303349962092,
         0.0890870806374748,
         -0.0398409536444798,
         0.235702260395516,
         -0.251976315339485,
         0.218217890235992,
         -0.159363814577919,
         0.0890870806374748,
         -0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092,
         0.0890870806374748,
         -0.159363814577919,
         0.218217890235992,
         -0.251976315339485,
         0.235702260395516,
         -0.0398409536444798,
         0.0890870806374748,
         -0.154303349962092,
         0.235702260395516,
         -0.333333333333333},
        {-0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092,
         0.243975018237133,
         -0.188982236504614,
         0.0690065559342354,
         0.0690065559342358,
         -0.188982236504614,
         0.243975018237133,
         -0.243975018237133,
         0.14638501094228,
         -0.195180014589706,
         0.14638501094228,
         -0.243975018237133,
         0.243975018237133,
         -0.188982236504614,
         0.0690065559342354,
         0.0690065559342354,
         -0.188982236504614,
         0.243975018237133,
         -0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092},
        {0.301511344577764,
         -0.233549683248457,
         0.174077655955698,
         -0.123091490979333,
         0.080582296402538,
         -0.0465242105199235,
         0.020806259464412,
         -0.190692517849118,
         0.220192753025272,
         -0.21320071635561,
         0.186096842079694,
         -0.147122471584125,
         0.101929438287525,
         -0.055048188256318,
         0.110096376512636,
         -0.165144564768954,
         0.197385508487931,
         -0.20806259464412,
         0.197385508487931,
         -0.165144564768954,
         0.110096376512636,
         -0.055048188256318,
         0.101929438287525,
         -0.147122471584125,
         0.186096842079694,
         -0.21320071635561,
         0.220192753025272,
         -0.190692517849118,
         0.020806259464412,
         -0.0465242105199235,
         0.080582296402538,
         -0.123091490979333,
         0.174077655955698,
         -0.233549683248457,
         0.301511344577764},
        {-0.110096376512636,
         0.165144564768954,
         -0.197385508487931,
         0.20806259464412,
         -0.197385508487931,
         0.165144564768954,
         -0.110096376512636,
         0.205971460217775,
         -0.194624736040381,
         0.132410224425712,
         -0.0465242105199236,
         -0.0465242105199236,
         0.132410224425712,
         -0.194624736040381,
         0.205971460217775,
         -0.237835356004225,
         0.0594588390010564,
         0.0679529588583502,
         -0.144400037573994,
         0.169882397145875,
         -0.144400037573993,
         0.0679529588583502,
         0.0594588390010564,
         -0.237835356004225,
         0.205971460217775,
         -0.194624736040381,
         0.132410224425712,
         -0.0465242105199236,
         -0.0465242105199236,
         0.132410224425712,
         -0.194624736040381,
         0.205971460217775,
         -0.110096376512636,
         0.165144564768954,
         -0.197385508487931,
         0.20806259464412,
         -0.197385508487931,
         0.165144564768954,
         -0.110096376512636},
        {0.277350098112614,
         -0.226455406828919,
         0.180648920932378,
         -0.139930052456288,
         0.104297703129124,
         -0.073749613144785,
         0.0482804549585269,
         -0.0278747336669028,
         0.0124659598667795,
         -0.160128153805087,
         0.193121819834107,
         -0.197890977967261,
         0.186573403275051,
         -0.164909148306051,
         0.136557748399784,
         -0.104297703129124,
         0.0705181180463927,
         -0.0373978796003382,
         0.0836242010007092,
         -0.129550055126259,
         0.161577306906713,
         -0.180648920932378,
         0.186989398001692,
         -0.180648920932378,
         0.161577306906713,
         -0.129550055126259,
         0.0836242010007092,
         -0.0373978796003382,
         0.0705181180463927,
         -0.104297703129124,
         0.136557748399784,
         -0.164909148306051,
         0.186573403275051,
         -0.197890977967261,
         0.193121819834107,
         -0.160128153805087,
         0.0124659598667795,
         -0.0278747336669028,
         0.0482804549585266,
         -0.0737496131447851,
         0.104297703129124,
         -0.139930052456288,
         0.180648920932378,
         -0.226455406828919,
         0.277350098112614},
        {0.0836242010007093,
         -0.129550055126259,
         0.161577306906713,
         -0.180648920932378,
         0.186989398001691,
         -0.180648920932379,
         0.161577306906713,
         -0.129550055126259,
         0.0836242010007092,
         -0.177393718796725,
         0.18511005987178,
         -0.152676204138115,
         0.098945488983631,
         -0.0341394370999461,
         -0.034139437099946,
         0.0989454889836308,
         -0.152676204138115,
         0.185110059871781,
         -0.177393718796725,
         0.229014306207172,
         -0.0916057224828689,
         -0.0152676204138115,
         0.0916057224828688,
         -0.137408583724304,
         0.152676204138115,
         -0.137408583724304,
         0.091605722482869,
         -0.0152676204138116,
         -0.0916057224828688,
         0.229014306207172,
         -0.177393718796725,
         0.185110059871781,
         -0.152676204138115,
         0.0989454889836307,
         -0.034139437099946,
         -0.0341394370999458,
         0.098945488983631,
         -0.152676204138115,
         0.185110059871781,
         -0.177393718796725,
         0.083624201000709,
         -0.129550055126259,
         0.161577306906713,
         -0.180648920932378,
         0.186989398001692,
         -0.180648920932378,
         0.161577306906713,
         -0.129550055126259,
         0.083624201000709},
        {-0.258198889747161,
         0.218217890235993,
         -0.18156825980064,
         0.14824986333222,
         -0.118262479197817,
         0.0916057224828689,
         -0.068278874199892,
         0.0482804549585267,
         -0.0316069770620507,
         0.0182482967150453,
         -0.00816088638568549,
         0.138013111868471,
         -0.171184197004365,
         0.181568259800641,
         -0.17879606250707,
         0.167248402001418,
         -0.149591518401353,
         0.127738077005317,
         -0.103227954818502,
         0.0774209661138763,
         -0.0516139774092511,
         0.0270665980980384,
         -0.0662993544131793,
         0.104828483672192,
         -0.134097046880302,
         0.154841932227753,
         -0.167248402001418,
         0.171378614099395,
         -0.167248402001418,
         0.154841932227753,
         -0.134097046880302,
         0.104828483672192,
         -0.0662993544131797,
         0.0270665980980382,
         -0.051613977409251,
         0.0774209661138764,
         -0.103227954818502,
         0.127738077005317,
         -0.149591518401353,
         0.167248402001418,
         -0.17879606250707,
         0.18156825980064,
         -0.171184197004365,
         0.138013111868471,
         -0.00816088638568549,
         0.0182482967150454,
         -0.0316069770620507,
         0.0482804549585269,
         -0.068278874199892,
         0.0916057224828691,
         -0.118262479197817,
         0.14824986333222,
         -0.18156825980064,
         0.218217890235993,
         -0.258198889747161},
        {0.0662993544131796,
         -0.104828483672192,
         0.134097046880302,
         -0.154841932227752,
         0.167248402001418,
         -0.171378614099395,
         0.167248402001418,
         -0.154841932227753,
         0.134097046880302,
         -0.104828483672192,
         0.0662993544131794,
         -0.155485768402848,
         0.172250775528965,
         -0.156446554693686,
         0.122413295785282,
         -0.0774209661138766,
         0.0264442942673973,
         0.0264442942673971,
         -0.0774209661138764,
         0.122413295785282,
         -0.156446554693686,
         0.172250775528964,
         -0.155485768402848,
         0.21989008243131,
         -0.109945041215655,
         0.0199900074937552,
         0.0499750187343884,
         -0.0999500374687776,
         0.129935048709411,
         -0.139930052456288,
         0.129935048709411,
         -0.0999500374687775,
         0.0499750187343884,
         0.0199900074937552,
         -0.109945041215655,
         0.21989008243131,
         -0.155485768402848,
         0.172250775528965,
         -0.156446554693686,
         0.122413295785282,
         -0.0774209661138764,
         0.0264442942673971,
         0.0264442942673972,
         -0.0774209661138764,
         0.122413295785282,
         -0.156446554693686,
         0.172250775528965,
         -0.155485768402848,
         0.0662993544131797,
         -0.104828483672192,
         0.134097046880302,
         -0.154841932227753,
         0.167248402001418,
         -0.171378614099395,
         0.167248402001418,
         -0.154841932227753,
         0.134097046880302,
         -0.104828483672192,
         0.0662993544131794},
        {0.242535625036333,
         -0.210042012604201,
         0.179869233546125,
         -0.152017248026265,
         0.126485995964683,
         -0.103275383240402,
         0.0823852554571632,
         -0.0638153444717274,
         0.0475651494154494,
         -0.0336336396998158,
         0.0220183856887538,
         -0.012712320904523,
         0.00568512273886108,
         -0.121267812518167,
         0.153392997769474,
         -0.166526551747686,
         0.168647994619577,
         -0.163292718633225,
         0.152547850854276,
         -0.137856900033614,
         0.120331367519237,
         -0.100900919099447,
         0.0803997768105297,
         -0.0596260703145076,
         0.0393876857238897,
         -0.0204980015422698,
         0.0542326144546641,
         -0.0869656553478673,
         0.113132514071518,
         -0.133327946454422,
         0.147703821464587,
         -0.156315031715672,
         0.159183436688109,
         -0.156315031715672,
         0.147703821464586,
         -0.133327946454422,
         0.113132514071518,
         -0.0869656553478674,
         0.0542326144546642,
         -0.0204980015422697,
         0.0393876857238896,
         -0.0596260703145075,
         0.0803997768105296,
         -0.100900919099447,
         0.120331367519237,
         -0.137856900033614,
         0.152547850854276,
         -0.163292718633225,
         0.168647994619577,
         -0.166526551747687,
         0.153392997769474,
         -0.121267812518167,
         0.00568512273886102,
         -0.0127123209045231,
         0.0220183856887537,
         -0.0336336396998156,
         0.0475651494154494,
         -0.0638153444717276,
         0.0823852554571633,
         -0.103275383240402,
         0.126485995964683,
         -0.152017248026265,
         0.179869233546125,
         -0.210042012604202,
         0.242535625036333},
        {0.054232614454664,
         -0.0869656553478674,
         0.113132514071518,
         -0.133327946454421,
         0.147703821464586,
         -0.156315031715672,
         0.159183436688108,
         -0.156315031715672,
         0.147703821464586,
         -0.133327946454421,
         0.113132514071518,
         -0.0869656553478675,
         0.054232614454664,
         -0.138266579688743,
         0.159437034804423,
         -0.153498313949248,
         0.131987933083438,
         -0.100499721013162,
         0.0626654242588657,
         -0.0212717814905757,
         -0.0212717814905756,
         0.0626654242588657,
         -0.100499721013161,
         0.131987933083438,
         -0.153498313949248,
         0.159437034804423,
         -0.138266579688744,
         0.211205689168769,
         -0.120688965239297,
         0.0440978911451279,
         0.018567533113738,
         -0.0673073075373005,
         0.102121432125559,
         -0.123009906878514,
         0.129972731796166,
         -0.123009906878514,
         0.102121432125559,
         -0.0673073075373005,
         0.018567533113738,
         0.0440978911451277,
         -0.120688965239297,
         0.211205689168769,
         -0.138266579688744,
         0.159437034804423,
         -0.153498313949248,
         0.131987933083438,
         -0.100499721013162,
         0.0626654242588658,
         -0.0212717814905758,
         -0.0212717814905757,
         0.0626654242588657,
         -0.100499721013162,
         0.131987933083438,
         -0.153498313949248,
         0.159437034804423,
         -0.138266579688743,
         0.054232614454664,
         -0.0869656553478674,
         0.113132514071518,
         -0.133327946454421,
         0.147703821464586,
         -0.156315031715672,
         0.159183436688108,
         -0.156315031715672,
         0.147703821464586,
         -0.133327946454422,
         0.113132514071518,
         -0.0869656553478675,
         0.0542326144546639},
        {-0.229415733870562,
         0.202325659555628,
         -0.176928656723561,
         0.153224711380059,
         -0.131213803631714,
         0.110895904418455,
         -0.0922709699122366,
         0.0753389314522264,
         -0.060099676407042,
         0.0465530091673856,
         -0.0346985643518151,
         0.0245355901506062,
         -0.016062314155081,
         0.00927358140124435,
         -0.00414727168161212,
         0.108147614087175,
         -0.13879425740726,
         0.15322471138006,
         -0.158249801440642,
         0.156830492040209,
         -0.150677862904453,
         0.140946234689939,
         -0.128498513240647,
         0.114031118451203,
         -0.0981423606024254,
         0.0813753465395004,
         -0.0642492566203232,
         0.047286172525836,
         -0.0310353394449238,
         0.0160623141550808,
         -0.0454310850424257,
         0.0736067704518187,
         -0.0969078163565821,
         0.11582699457751,
         -0.130490857063204,
         0.140946234689939,
         -0.147213540903638,
         0.149301780538032,
         -0.147213540903638,
         0.140946234689939,
         -0.130490857063205,
         0.11582699457751,
         -0.0969078163565823,
         0.0736067704518186,
         -0.0454310850424256,
         0.0160623141550808,
         -0.0310353394449238,
         0.0472861725258359,
         -0.0642492566203235,
         0.0813753465395005,
         -0.0981423606024254,
         0.114031118451203,
         -0.128498513240647,
         0.140946234689939,
         -0.150677862904453,
         0.156830492040209,
         -0.158249801440643,
         0.15322471138006,
         -0.138794257407261,
         0.108147614087175,
         -0.00414727168161188,
         0.00927358140124429,
         -0.0160623141550809,
         0.0245355901506061,
         -0.0346985643518151,
         0.0465530091673857,
         -0.0600996764070422,
         0.0753389314522265,
         -0.0922709699122369,
         0.110895904418455,
         -0.131213803631714,
         0.15322471138006,
         -0.176928656723561,
         0.202325659555628,
         -0.229415733870562},
        {-0.0454310850424255,
         0.0736067704518189,
         -0.0969078163565822,
         0.11582699457751,
         -0.130490857063205,
         0.14094623468994,
         -0.147213540903638,
         0.149301780538032,
         -0.147213540903638,
         0.140946234689939,
         -0.130490857063205,
         0.115826994577511,
         -0.0969078163565823,
         0.0736067704518188,
         -0.0454310850424256,
         0.12441815044836,
         -0.147651026387882,
         0.147825658059076,
         -0.134578806311986,
         0.112436199085566,
         -0.0842314860396877,
         0.0520478465277227,
         -0.0175953835769445,
         -0.0175953835769445,
         0.0520478465277226,
         -0.0842314860396878,
         0.112436199085566,
         -0.134578806311986,
         0.147825658059075,
         -0.147651026387882,
         0.12441815044836,
         -0.203173988892875,
         0.126983743058046,
         -0.0609521966678627,
         0.00507934972232151,
         0.0406347977785749,
         -0.076190245834828,
         0.101586994446438,
         -0.116825043613403,
         0.121904393335724,
         -0.116825043613403,
         0.101586994446437,
         -0.0761902458348279,
         0.0406347977785749,
         0.00507934972232137,
         -0.0609521966678628,
         0.126983743058046,
         -0.203173988892875,
         0.12441815044836,
         -0.147651026387882,
         0.147825658059076,
         -0.134578806311986,
         0.112436199085566,
         -0.0842314860396876,
         0.0520478465277227,
         -0.0175953835769445,
         -0.0175953835769444,
         0.0520478465277226,
         -0.0842314860396879,
         0.112436199085567,
         -0.134578806311986,
         0.147825658059075,
         -0.147651026387882,
         0.12441815044836,
         -0.0454310850424255,
         0.0736067704518188,
         -0.0969078163565825,
         0.11582699457751,
         -0.130490857063205,
         0.140946234689939,
         -0.147213540903638,
         0.149301780538032,
         -0.147213540903638,
         0.140946234689939,
         -0.130490857063205,
         0.115826994577511,
         -0.0969078163565822,
         0.0736067704518188,
         -0.0454310850424254},
        {-0.218217890235992,
         0.195180014589706,
         -0.173421993904824,
         0.152943822580374,
         -0.133745492997502,
         0.11582699457751,
         -0.0991883122823936,
         0.083829424144806,
         -0.0697502970338575,
         0.0569508790468381,
         -0.0454310850424255,
         0.0351907671538895,
         -0.026229649178821,
         0.0185471628024886,
         -0.0121419682098677,
         0.00701016861445886,
         -0.0031350427111331,
         0.0975900072948532,
         -0.126649517372261,
         0.141598465080958,
         -0.148377302419909,
         0.149532007013318,
         -0.146510846958762,
         0.140273456458659,
         -0.131522421393111,
         0.120811058305662,
         -0.108601065191622,
         0.0952970479489331,
         -0.0812695955571498,
         0.0668727464987509,
         -0.0524592983576421,
         0.0383962748205389,
         -0.0250803416890653,
         0.0129261122388246,
         -0.0387783367164741,
         0.0633247586861304,
         -0.0841220233735074,
         0.101586994446437,
         -0.11582699457751,
         0.126882115396262,
         -0.1347703776635,
         0.139500594067716,
         -0.141076922000992,
         0.139500594067716,
         -0.1347703776635,
         0.126882115396262,
         -0.11582699457751,
         0.101586994446437,
         -0.0841220233735073,
         0.0633247586861305,
         -0.0387783367164743,
         0.0129261122388245,
         -0.0250803416890651,
         0.0383962748205392,
         -0.0524592983576421,
         0.0668727464987509,
         -0.0812695955571496,
         0.0952970479489331,
         -0.108601065191621,
         0.120811058305663,
         -0.131522421393111,
         0.140273456458659,
         -0.146510846958762,
         0.149532007013318,
         -0.148377302419909,
         0.141598465080958,
         -0.126649517372261,
         0.0975900072948534,
         -0.00313504271113311,
         0.00701016861445889,
         -0.0121419682098675,
         0.0185471628024885,
         -0.026229649178821,
         0.0351907671538894,
         -0.0454310850424255,
         0.0569508790468382,
         -0.0697502970338575,
         0.083829424144806,
         -0.0991883122823934,
         0.11582699457751,
         -0.133745492997502,
         0.152943822580374,
         -0.173421993904824,
         0.195180014589707,
         -0.218217890235992},
        {-0.038778336716474,
         0.0633247586861304,
         -0.0841220233735077,
         0.101586994446437,
         -0.11582699457751,
         0.126882115396262,
         -0.1347703776635,
         0.139500594067715,
         -0.141076922000991,
         0.139500594067715,
         -0.1347703776635,
         0.126882115396262,
         -0.11582699457751,
         0.101586994446437,
         -0.0841220233735077,
         0.0633247586861305,
         -0.0387783367164741,
         0.113057307977937,
         -0.137102124276771,
         0.141181384749108,
         -0.133561650308543,
         0.118033421304695,
         -0.0969078163565817,
         0.0718328526534358,
         -0.044113961220055,
         0.0148708132936351,
         0.0148708132936352,
         -0.0441139612200551,
         0.0718328526534357,
         -0.0969078163565817,
         0.118033421304695,
         -0.133561650308543,
         0.141181384749108,
         -0.137102124276771,
         0.113057307977937,
         -0.195821001584749,
         0.130547334389833,
         -0.0729529221590246,
         0.0230377648923228,
         0.0191981374102691,
         -0.0537547847487548,
         0.0806321771231315,
         -0.0998303145334017,
         0.111349196979563,
         -0.115188824461617,
         0.111349196979563,
         -0.0998303145334013,
         0.0806321771231315,
         -0.0537547847487547,
         0.0191981374102689,
         0.0230377648923228,
         -0.0729529221590244,
         0.130547334389833,
         -0.195821001584749,
         0.113057307977937,
         -0.137102124276771,
         0.141181384749108,
         -0.133561650308543,
         0.118033421304696,
         -0.0969078163565815,
         0.0718328526534359,
         -0.0441139612200552,
         0.014870813293635,
         0.0148708132936351,
         -0.0441139612200553,
         0.0718328526534358,
         -0.0969078163565817,
         0.118033421304696,
         -0.133561650308543,
         0.141181384749108,
         -0.137102124276771,
         0.113057307977937,
         -0.038778336716474,
         0.0633247586861303,
         -0.0841220233735076,
         0.101586994446437,
         -0.115826994577511,
         0.126882115396262,
         -0.1347703776635,
         0.139500594067715,
         -0.141076922000991,
         0.139500594067715,
         -0.1347703776635,
         0.126882115396262,
         -0.115826994577511,
         0.101586994446437,
         -0.0841220233735075,
         0.0633247586861304,
         -0.0387783367164741},
        {-0.0336051406354977,
         0.0552188807225865,
         -0.0738669653394311,
         0.0899080070463526,
         -0.103434440432392,
         0.11448094709498,
         -0.123063320366541,
         0.12918957469315,
         -0.132863944399817,
         0.134088522769632,
         -0.132863944399817,
         0.12918957469315,
         -0.123063320366541,
         0.11448094709498,
         -0.103434440432392,
         0.0899080070463527,
         -0.073866965339431,
         0.0552188807225864,
         -0.0336051406354976,
         0.103577999752601,
         -0.127743744052502,
         0.13436527956102,
         -0.130676270060164,
         0.119932420766169,
         -0.104078898009667,
         0.0844714596864546,
         -0.0621563631046525,
         0.0380042401334497,
         -0.0127848390108049,
         -0.0127848390108049,
         0.0380042401334496,
         -0.0621563631046524,
         0.0844714596864546,
         -0.104078898009667,
         0.119932420766169,
         -0.130676270060164,
         0.13436527956102,
         -0.127743744052502,
         0.103577999752602,
         -0.189106689752547,
         0.132374682826783,
         -0.0816144661037309,
         0.0368260395833911,
         0.00199059673423772,
         -0.0348354428491533,
         0.0617084987613569,
         -0.0826097644708505,
         0.0975392399776294,
         -0.106496925281698,
         0.109482820383054,
         -0.106496925281698,
         0.0975392399776292,
         -0.0826097644708505,
         0.0617084987613569,
         -0.0348354428491533,
         0.0019905967342378,
         0.0368260395833909,
         -0.0816144661037309,
         0.132374682826783,
         -0.189106689752547,
         0.103577999752601,
         -0.127743744052502,
         0.13436527956102,
         -0.130676270060164,
         0.119932420766169,
         -0.104078898009667,
         0.0844714596864545,
         -0.0621563631046525,
         0.0380042401334497,
         -0.0127848390108048,
         -0.0127848390108049,
         0.0380042401334497,
         -0.0621563631046525,
         0.0844714596864546,
         -0.104078898009667,
         0.119932420766169,
         -0.130676270060164,
         0.13436527956102,
         -0.127743744052502,
         0.103577999752601,
         -0.0336051406354976,
         0.0552188807225864,
         -0.0738669653394312,
         0.0899080070463527,
         -0.103434440432392,
         0.11448094709498,
         -0.123063320366541,
         0.12918957469315,
         -0.132863944399817,
         0.134088522769632,
         -0.132863944399817,
         0.129189574693151,
         -0.123063320366541,
         0.11448094709498,
         -0.103434440432392,
         0.0899080070463526,
         -0.073866965339431,
         0.0552188807225863,
         -0.0336051406354974},
        {0.174077655955698,
         -0.21320071635561,
         0.197385508487931,
         -0.147122471584125,
         0.080582296402538,
         -0.224733287487747,
         0.100503781525921,
         0.0465242105199236,
         -0.151947435279517,
         0.188025358272589,
         -0.147122471584125,
         0.174077655955698,
         0.100503781525921,
         -0.169882397145875,
         0.10403129732206,
         0.0268607654675126,
         -0.151947435279517,
         0.197385508487931,
         -0.21320071635561,
         0.0465242105199236,
         0.10403129732206,
         -0.161164592805076,
         0.10403129732206,
         0.0465242105199236,
         -0.21320071635561,
         0.197385508487931,
         -0.151947435279517,
         0.0268607654675126,
         0.10403129732206,
         -0.169882397145875,
         0.100503781525921,
         0.174077655955698,
         -0.147122471584125,
         0.188025358272589,
         -0.151947435279517,
         0.0465242105199236,
         0.100503781525921,
         -0.224733287487747,
         0.080582296402538,
         -0.147122471584125,
         0.197385508487931,
         -0.21320071635561,
         0.174077655955698},
        {-0.277350098112614,
         0.196116135138184,
         -0.132221471336986,
         0.083624201000709,
         -0.0482804549585268,
         0.0241402274792635,
         -0.00912414835752283,
         0.196116135138184,
         -0.204836622599676,
         0.177393718796725,
         -0.136557748399784,
         0.0934946990008458,
         -0.0547448901451359,
         0.0241402274792634,
         -0.132221471336987,
         0.177393718796725,
         -0.186989398001692,
         0.17069718549973,
         -0.13686222536284,
         0.0934946990008458,
         -0.0482804549585266,
         0.0836242010007092,
         -0.136557748399784,
         0.17069718549973,
         -0.182482967150453,
         0.17069718549973,
         -0.136557748399784,
         0.083624201000709,
         -0.0482804549585268,
         0.0934946990008459,
         -0.13686222536284,
         0.17069718549973,
         -0.186989398001692,
         0.177393718796725,
         -0.132221471336986,
         0.0241402274792633,
         -0.0547448901451359,
         0.0934946990008458,
         -0.136557748399784,
         0.177393718796725,
         -0.204836622599676,
         0.196116135138184,
         -0.00912414835752269,
         0.0241402274792634,
         -0.0482804549585269,
         0.0836242010007091,
         -0.132221471336987,
         0.196116135138185,
         -0.277350098112614},
        {-0.132221471336986,
         0.177393718796725,
         -0.186989398001691,
         0.17069718549973,
         -0.13686222536284,
         0.0934946990008459,
         -0.0482804549585269,
         0.201971633633391,
         -0.136557748399784,
         0.0341394370999459,
         0.062329799333897,
         -0.131695737758544,
         0.16321772771371,
         -0.153311035167967,
         0.104297703129124,
         -0.180648920932378,
         -0.0403943267266782,
         0.137408583724304,
         -0.141036236092786,
         0.0819481953157404,
         0.00912414835752267,
         -0.101301333959432,
         0.163251727865669,
         -0.161577306906713,
         0.197890977967261,
         -0.0989454889836306,
         -0.0215916758543767,
         0.109641743972412,
         -0.141350698548044,
         0.109641743972412,
         -0.0215916758543764,
         -0.0989454889836307,
         0.197890977967261,
         -0.161577306906713,
         0.16325172786567,
         -0.101301333959431,
         0.00912414835752273,
         0.0819481953157407,
         -0.141036236092786,
         0.137408583724304,
         -0.0403943267266783,
         -0.180648920932378,
         0.104297703129124,
         -0.153311035167966,
         0.16321772771371,
         -0.131695737758545,
         0.0623297993338969,
         0.0341394370999459,
         -0.136557748399784,
         0.201971633633391,
         -0.0482804549585268,
         0.0934946990008459,
         -0.13686222536284,
         0.17069718549973,
         -0.186989398001691,
         0.177393718796725,
         -0.132221471336986},
        {-0.258198889747161,
         0.195180014589707,
         -0.143222974807886,
         0.101273936708367,
         -0.0682788741998921,
         0.0431833517087529,
         -0.0249319197335588,
         0.0124659598667794,
         -0.0047116899516014,
         0.169030850945704,
         -0.187522892375398,
         0.175411603861406,
         -0.149591518401353,
         0.118262479197817,
         -0.0863667034175062,
         0.0571262046997984,
         -0.0326435455427421,
         0.0141350698548045,
         -0.104828483672192,
         0.14824986333222,
         -0.167248402001418,
         0.167248402001418,
         -0.152676204138115,
         0.127738077005317,
         -0.0965609099170536,
         0.0632139541241015,
         -0.0316069770620509,
         0.0605227532668802,
         -0.103227954818502,
         0.136557748399784,
         -0.157683305597089,
         0.164909148306052,
         -0.157683305597089,
         0.136557748399784,
         -0.103227954818502,
         0.0605227532668803,
         -0.0316069770620506,
         0.0632139541241014,
         -0.0965609099170535,
         0.127738077005317,
         -0.152676204138115,
         0.167248402001418,
         -0.167248402001418,
         0.14824986333222,
         -0.104828483672192,
         0.0141350698548043,
         -0.032643545542742,
         0.0571262046997984,
         -0.0863667034175061,
         0.118262479197816,
         -0.149591518401354,
         0.175411603861406,
         -0.187522892375398,
         0.169030850945704,
         -0.00471168995160127,
         0.0124659598667794,
         -0.0249319197335588,
         0.0431833517087531,
         -0.0682788741998919,
         0.101273936708367,
         -0.143222974807886,
         0.195180014589707,
         -0.258198889747161},
        {0.104828483672192,
         -0.148249863332221,
         0.167248402001418,
         -0.167248402001418,
         0.152676204138115,
         -0.127738077005317,
         0.0965609099170536,
         -0.0632139541241014,
         0.0316069770620508,
         -0.18156825980064,
         0.14824986333222,
         -0.0774209661138763,
         0.0682788741998922,
         -0.118262479197817,
         0.144841364875581,
         -0.145986373720363,
         0.122413295785282,
         -0.0774209661138764,
         0.181568259800641,
         -0.0999500374687773,
         0.134097046880302,
         -0.118262479197817,
         0.0682788741998921,
         -0.0706753492740222,
         0.127738077005317,
         -0.154841932227753,
         0.134097046880302,
         -0.181568259800641,
         0.122413295785282,
         -0.0316069770620508,
         -0.0516139774092509,
         0.107958379271883,
         -0.127738077005317,
         0.107958379271883,
         -0.0516139774092506,
         -0.0316069770620509,
         0.122413295785282,
         -0.181568259800641,
         0.134097046880302,
         -0.154841932227753,
         0.127738077005317,
         -0.0706753492740223,
         0.068278874199892,
         -0.118262479197817,
         0.134097046880302,
         -0.0999500374687775,
         0.181568259800641,
         -0.0774209661138762,
         0.122413295785282,
         -0.145986373720362,
         0.144841364875581,
         -0.118262479197817,
         0.068278874199892,
         -0.0774209661138764,
         0.14824986333222,
         -0.18156825980064,
         0.0316069770620509,
         -0.0632139541241013,
         0.0965609099170535,
         -0.127738077005317,
         0.152676204138115,
         -0.167248402001418,
         0.167248402001418,
         -0.148249863332221,
         0.104828483672192},
        {0.242535625036333,
         -0.191741247211843,
         0.148522131446501,
         -0.112272178284768,
         0.0823852554571636,
         -0.0582551728035464,
         0.0392756294919232,
         -0.0248400891462719,
         0.0143414321552945,
         -0.00717071607764714,
         0.00271027592338665,
         -0.148522131446501,
         0.171498585142509,
         -0.168408267427152,
         0.152547850854276,
         -0.130262526429727,
         0.105387572883643,
         -0.0804910883411618,
         0.0573657286211777,
         -0.0372601337194079,
         0.0209937070298075,
         -0.00898896831620783,
         0.0857492925712547,
         -0.125524111313359,
         0.147703821464586,
         -0.155693498312987,
         0.152113858934032,
         -0.139414654563407,
         0.119989030075853,
         -0.0962052515818186,
         0.0704150340275467,
         -0.0449448415810387,
         0.0220183856887538,
         -0.0458349248514105,
         0.0803997768105293,
         -0.110091928443769,
         0.13277586148896,
         -0.146955949208651,
         0.151775451709656,
         -0.146955949208651,
         0.132775861488959,
         -0.110091928443769,
         0.080399776810529,
         -0.0458349248514105,
         0.0220183856887538,
         -0.0449448415810389,
         0.0704150340275465,
         -0.0962052515818187,
         0.119989030075852,
         -0.139414654563407,
         0.152113858934032,
         -0.155693498312986,
         0.147703821464586,
         -0.125524111313358,
         0.0857492925712541,
         -0.00898896831620785,
         0.0209937070298074,
         -0.0372601337194079,
         0.0573657286211774,
         -0.080491088341162,
         0.105387572883643,
         -0.130262526429726,
         0.152547850854276,
         -0.168408267427152,
         0.171498585142508,
         -0.148522131446501,
         0.00271027592338677,
         -0.0071707160776473,
         0.0143414321552944,
         -0.024840089146272,
         0.0392756294919232,
         -0.0582551728035463,
         0.0823852554571634,
         -0.112272178284768,
         0.148522131446501,
         -0.191741247211843,
         0.242535625036333},
        {-0.0857492925712544,
         0.125524111313358,
         -0.147703821464586,
         0.155693498312987,
         -0.152113858934032,
         0.139414654563407,
         -0.119989030075852,
         0.0962052515818188,
         -0.0704150340275463,
         0.0449448415810388,
         -0.0220183856887538,
         0.164197394357296,
         -0.149696237713024,
         0.100499721013161,
         -0.0401998884052649,
         -0.0191645448431338,
         0.070258381922429,
         -0.108433620215984,
         0.130918764973078,
         -0.136459095693748,
         0.125182282715638,
         -0.0986058822648918,
         0.0596260703145076,
         -0.179869233546125,
         0.0277544252912812,
         0.0673073075373006,
         -0.114410888140707,
         0.122653086996056,
         -0.101133611063933,
         0.0589570676753601,
         -0.00523675059892321,
         -0.0508974135707676,
         0.100280209165308,
         -0.13365993475644,
         0.141520356148795,
         -0.113132514071518,
         0.166526551747686,
         -0.131987933083438,
         0.0643198214484233,
         0.0066387930744477,
         -0.0657206984257101,
         0.104238212682548,
         -0.117564759366921,
         0.104238212682548,
         -0.0657206984257101,
         0.00663879307444769,
         0.0643198214484234,
         -0.131987933083438,
         0.166526551747686,
         -0.113132514071518,
         0.141520356148795,
         -0.13365993475644,
         0.100280209165308,
         -0.0508974135707677,
         -0.00523675059892317,
         0.0589570676753603,
         -0.101133611063933,
         0.122653086996056,
         -0.114410888140707,
         0.0673073075373003,
         0.0277544252912811,
         -0.179869233546125,
         0.0596260703145077,
         -0.0986058822648918,
         0.125182282715638,
         -0.136459095693748,
         0.130918764973078,
         -0.108433620215983,
         0.0702583819224292,
         -0.0191645448431339,
         -0.0401998884052647,
         0.100499721013161,
         -0.149696237713024,
         0.164197394357296,
         -0.0220183856887538,
         0.0449448415810388,
         -0.0704150340275465,
         0.0962052515818189,
         -0.119989030075852,
         0.139414654563407,
         -0.152113858934032,
         0.155693498312987,
         -0.147703821464586,
         0.125524111313359,
         -0.0857492925712543},
        {-0.229415733870562,
         0.187317162316339,
         -0.150677862904453,
         0.119121309936166,
         -0.0922709699122368,
         0.0697502970338579,
         -0.0511827251162098,
         0.0361916520092791,
         -0.0244004068069736,
         0.0154321722689424,
         -0.00890976881365469,
         0.00445488440682732,
         -0.00168378803714349,
         0.132453235706505,
         -0.157377895072927,
         0.159818007951653,
         -0.150677862904453,
         0.135070869402575,
         -0.116071510354346,
         0.0957541107531435,
         -0.0756018953632754,
         0.0567014215224567,
         -0.0398456974622789,
         0.025591362558105,
         -0.0142874152697395,
         0.00607098410493378,
         -0.0718328526534361,
         0.107749278980154,
         -0.130490857063205,
         0.142377197617095,
         -0.145089387942933,
         0.140169665503672,
         -0.129114816600118,
         0.113402843044913,
         -0.0945023692040943,
         0.073875900309256,
         -0.0529791537539751,
         0.0332521494052757,
         -0.016062314155081,
         0.0359164263267182,
         -0.0642492566203237,
         0.0900472462683838,
         -0.111689862913881,
         0.127956812790525,
         -0.138029544935371,
         0.141438195120055,
         -0.138029544935371,
         0.127956812790525,
         -0.111689862913881,
         0.0900472462683835,
         -0.0642492566203237,
         0.0359164263267179,
         -0.016062314155081,
         0.0332521494052756,
         -0.0529791537539752,
         0.0738759003092559,
         -0.0945023692040943,
         0.113402843044913,
         -0.129114816600119,
         0.140169665503672,
         -0.145089387942933,
         0.142377197617095,
         -0.130490857063205,
         0.107749278980154,
         -0.0718328526534361,
         0.00607098410493368,
         -0.0142874152697396,
         0.0255913625581049,
         -0.0398456974622791,
         0.0567014215224566,
         -0.0756018953632754,
         0.0957541107531433,
         -0.116071510354346,
         0.135070869402575,
         -0.150677862904453,
         0.159818007951653,
         -0.157377895072927,
         0.132453235706505,
         -0.00168378803714341,
         0.0044548844068272,
         -0.00890976881365478,
         0.0154321722689426,
         -0.0244004068069734,
         0.0361916520092791,
         -0.0511827251162098,
         0.0697502970338578,
         -0.0922709699122366,
         0.119121309936166,
         -0.150677862904453,
         0.187317162316339,
         -0.229415733870562},
        {0.0718328526534361,
         -0.107749278980154,
         0.130490857063205,
         -0.142377197617095,
         0.145089387942933,
         -0.140169665503672,
         0.129114816600119,
         -0.113402843044913,
         0.0945023692040945,
         -0.073875900309256,
         0.0529791537539749,
         -0.0332521494052756,
         0.0160623141550808,
         -0.149532007013319,
         0.146628196474538,
         -0.112436199085567,
         0.065761210696556,
         -0.0161210431047701,
         -0.0305875286812959,
         0.0704379071917126,
         -0.100802527151034,
         0.120034130257891,
         -0.127308926031096,
         0.122562344051601,
         -0.106492105886354,
         0.0806169390662778,
         -0.0472861725258359,
         0.176928656723561,
         -0.0472861725258357,
         -0.0406347977785744,
         0.092483759978428,
         -0.113910884471488,
         0.110567323238681,
         -0.0881057274967278,
         0.0521811318843134,
         -0.00845254886300573,
         -0.0374139571040259,
         0.0797388161694114,
         -0.112813798488615,
         0.130860412729762,
         -0.127885151680118,
         0.096907816356582,
         -0.15322471138006,
         0.134578806311986,
         -0.0841658255235068,
         0.025602438673126,
         0.0290178775885866,
         -0.0724028855971708,
         0.100071420078144,
         -0.109557554843521,
         0.100071420078144,
         -0.0724028855971707,
         0.0290178775885865,
         0.0256024386731262,
         -0.084165825523507,
         0.134578806311986,
         -0.15322471138006,
         0.096907816356582,
         -0.127885151680118,
         0.130860412729762,
         -0.112813798488616,
         0.0797388161694116,
         -0.0374139571040259,
         -0.00845254886300576,
         0.0521811318843132,
         -0.0881057274967277,
         0.110567323238681,
         -0.113910884471488,
         0.0924837599784279,
         -0.0406347977785747,
         -0.0472861725258356,
         0.176928656723561,
         -0.047286172525836,
         0.0806169390662778,
         -0.106492105886354,
         0.122562344051601,
         -0.127308926031096,
         0.120034130257891,
         -0.100802527151034,
         0.0704379071917128,
         -0.0305875286812959,
         -0.01612104310477,
         0.0657612106965556,
         -0.112436199085567,
         0.146628196474538,
         -0.149532007013318,
         0.0160623141550809,
         -0.0332521494052756,
         0.052979153753975,
         -0.0738759003092559,
         0.0945023692040943,
         -0.113402843044913,
         0.129114816600119,
         -0.140169665503672,
         0.145089387942933,
         -0.142377197617095,
         0.130490857063205,
         -0.107749278980154,
         0.0718328526534359},
        {-0.218217890235992,
         0.182574185835055,
         -0.15101992432742,
         0.123307251865302,
         -0.0991883122823937,
         0.0784152460201046,
         -0.0607401883849244,
         0.0459152665867786,
         -0.0336925944158751,
         0.0238242619872333,
         -0.0160623141550809,
         0.0101586994446438,
         -0.00586512785898146,
         0.00293256392949078,
         -0.00110840498017578,
         0.11952286093344,
         -0.145095250022002,
         0.15101992432742,
         -0.146510846958762,
         0.135819190194834,
         -0.121480376769849,
         0.105205092343994,
         -0.0882279224401105,
         0.0714727859616997,
         -0.0556414884074658,
         0.0412648322147197,
         -0.0287331410613745,
         0.0183138558698454,
         -0.0101586994446435,
         0.00429283402907436,
         -0.0613139339484967,
         0.0936585811581694,
         -0.11582699457751,
         0.129498516752407,
         -0.135819190194834,
         0.135819190194835,
         -0.130490857063204,
         0.120811058305662,
         -0.107749278980154,
         0.0922709699122369,
         -0.0753389314522261,
         0.0579134972887553,
         -0.0409510266551075,
         0.0253967486116093,
         -0.0121419682098677,
         0.0289036656508039,
         -0.0524592983576423,
         0.0747660035066594,
         -0.0945723450516714,
         0.110895904418455,
         -0.123027959882982,
         0.130490857063205,
         -0.133008597621102,
         0.130490857063205,
         -0.123027959882982,
         0.110895904418455,
         -0.0945723450516714,
         0.0747660035066594,
         -0.0524592983576421,
         0.0289036656508041,
         -0.0121419682098675,
         0.0253967486116093,
         -0.0409510266551074,
         0.057913497288755,
         -0.0753389314522263,
         0.092270969912237,
         -0.107749278980154,
         0.120811058305662,
         -0.130490857063205,
         0.135819190194835,
         -0.135819190194834,
         0.129498516752406,
         -0.115826994577511,
         0.0936585811581695,
         -0.0613139339484967,
         0.00429283402907471,
         -0.0101586994446437,
         0.0183138558698453,
         -0.0287331410613742,
         0.0412648322147197,
         -0.0556414884074658,
         0.0714727859616996,
         -0.0882279224401104,
         0.105205092343994,
         -0.121480376769849,
         0.135819190194834,
         -0.146510846958762,
         0.15101992432742,
         -0.145095250022003,
         0.119522860933439,
         -0.00110840498017576,
         0.00293256392949068,
         -0.00586512785898139,
         0.0101586994446437,
         -0.016062314155081,
         0.0238242619872331,
         -0.033692594415875,
         0.0459152665867784,
         -0.0607401883849243,
         0.0784152460201046,
         -0.0991883122823936,
         0.123307251865302,
         -0.15101992432742,
         0.182574185835055,
         -0.218217890235992},
        {0.0613139339484965,
         -0.0936585811581695,
         0.115826994577511,
         -0.129498516752407,
         0.135819190194834,
         -0.135819190194834,
         0.130490857063205,
         -0.120811058305662,
         0.107749278980154,
         -0.0922709699122368,
         0.0753389314522262,
         -0.0579134972887554,
         0.0409510266551075,
         -0.0253967486116092,
         0.0121419682098678,
         -0.13710212427677,
         0.141598465080957,
         -0.118033421304696,
         0.0819020533102148,
         -0.0409510266551074,
         0.0376694657261133,
         -0.069750297033858,
         0.0946372762951952,
         -0.111282976814931,
         0.119121309936166,
         -0.118033421304695,
         0.108346232462192,
         -0.0908621700848511,
         0.0669186598213577,
         -0.038396274820539,
         0.173421993904824,
         -0.0613139339484962,
         -0.0191981374102689,
         0.0718328526534367,
         -0.100309119748126,
         0.108346232462192,
         -0.0996640383319669,
         0.0779832028092538,
         -0.0470256406669968,
         0.0105152529216889,
         0.0278207442037327,
         -0.0642492566203238,
         0.095025932042668,
         -0.116382522918464,
         0.124492186843159,
         -0.115348697993742,
         0.0841220233735074,
         -0.141598465080958,
         0.133561650308543,
         -0.095990687051348,
         0.0481869424652423,
         -0.0424968887345362,
         0.0753389314522267,
         -0.095990687051347,
         0.103028016697786,
         -0.095990687051347,
         0.0753389314522265,
         -0.0424968887345361,
         0.0481869424652424,
         -0.095990687051348,
         0.133561650308543,
         -0.141598465080958,
         0.0841220233735073,
         -0.115348697993742,
         0.124492186843159,
         -0.116382522918464,
         0.0950259320426682,
         -0.0642492566203239,
         0.0278207442037327,
         0.0105152529216889,
         -0.0470256406669968,
         0.0779832028092539,
         -0.0996640383319668,
         0.108346232462192,
         -0.100309119748126,
         0.0718328526534366,
         -0.0191981374102689,
         -0.0613139339484962,
         0.173421993904824,
         -0.0383962748205388,
         0.0669186598213578,
         -0.0908621700848511,
         0.108346232462192,
         -0.118033421304695,
         0.119121309936167,
         -0.111282976814931,
         0.0946372762951953,
         -0.069750297033858,
         0.0376694657261134,
         -0.0409510266551076,
         0.0819020533102148,
         -0.118033421304696,
         0.141598465080957,
         -0.13710212427677,
         0.0121419682098677,
         -0.0253967486116095,
         0.0409510266551075,
         -0.0579134972887553,
         0.0753389314522263,
         -0.0922709699122366,
         0.107749278980154,
         -0.120811058305662,
         0.130490857063205,
         -0.135819190194834,
         0.135819190194834,
         -0.129498516752406,
         0.115826994577511,
         -0.0936585811581695,
         0.0613139339484966},
        {-0.0531343927492251,
         0.0823154472914375,
         -0.103434440432393,
         0.117765290957256,
         -0.12612760653351,
         0.12924233743772,
         -0.12779824364991,
         0.12247095437412,
         -0.113929892405108,
         0.102841202370571,
         -0.0898691110864762,
         0.0756765639201061,
         -0.0609254221457412,
         0.0462761800973873,
         -0.0323865795667821,
         0.0199059673423735,
         -0.00944222937462427,
         0.126485154304226,
         -0.135813558944418,
         0.11993242076617,
         -0.0919417248287931,
         0.0583025067446309,
         -0.0230276450741796,
         -0.0111234093449156,
         0.0421624859275641,
         -0.068638667365362,
         0.0895117772216728,
         -0.104080297700328,
         0.11194081294969,
         -0.112968535441253,
         0.107314629047924,
         -0.0954198751296217,
         0.0780470029439451,
         -0.056331894602292,
         0.031787280732722,
         -0.16969764190128,
         0.0715508082623559,
         0.00199059673423714,
         -0.0534874490767075,
         0.0855007517989823,
         -0.100591678825499,
         0.10132163832639,
         -0.0902523665277741,
         0.0699460705532736,
         -0.042965653066403,
         0.0118750791744868,
         0.0207599967947419,
         -0.0523711008891348,
         0.0803847595701173,
         -0.102217922356204,
         0.115267209156583,
         -0.116879378801926,
         0.104248496789412,
         -0.073866965339431,
         0.131447228194865,
         -0.130676270060164,
         0.102752204805253,
         -0.0638598966809842,
         0.0221899940282157,
         0.0171611524624716,
         -0.050765382368689,
         0.0762809184550988,
         -0.0921719247477718,
         0.0975637310403934,
         -0.0921719247477719,
         0.0762809184550986,
         -0.050765382368689,
         0.0171611524624715,
         0.0221899940282158,
         -0.0638598966809841,
         0.102752204805253,
         -0.130676270060164,
         0.131447228194865,
         -0.0738669653394311,
         0.104248496789412,
         -0.116879378801926,
         0.115267209156583,
         -0.102217922356204,
         0.080384759570117,
         -0.052371100889135,
         0.0207599967947419,
         0.0118750791744867,
         -0.0429656530664032,
         0.0699460705532735,
         -0.0902523665277741,
         0.10132163832639,
         -0.100591678825498,
         0.0855007517989822,
         -0.0534874490767074,
         0.00199059673423708,
         0.0715508082623562,
         -0.169697641901279,
         0.031787280732722,
         -0.0563318946022921,
         0.0780470029439452,
         -0.0954198751296217,
         0.107314629047925,
         -0.112968535441253,
         0.11194081294969,
         -0.104080297700328,
         0.0895117772216728,
         -0.068638667365362,
         0.0421624859275642,
         -0.0111234093449156,
         -0.0230276450741796,
         0.0583025067446309,
         -0.0919417248287933,
         0.11993242076617,
         -0.135813558944418,
         0.126485154304226,
         -0.00944222937462429,
         0.0199059673423736,
         -0.0323865795667821,
         0.0462761800973873,
         -0.0609254221457414,
         0.075676563920106,
         -0.0898691110864761,
         0.102841202370571,
         -0.113929892405108,
         0.12247095437412,
         -0.12779824364991,
         0.12924233743772,
         -0.12612760653351,
         0.117765290957256,
         -0.103434440432393,
         0.0823154472914374,
         -0.0531343927492252},
        {0.104297703129124,
         -0.164909148306052,
         0.186989398001692,
         -0.164909148306052,
         0.104297703129124,
         -0.164909148306051,
         0.156446554693686,
         -0.062329799333897,
         -0.0623297993338971,
         0.156446554693686,
         -0.164909148306051,
         0.186989398001692,
         -0.0623297993338973,
         -0.0819481953157406,
         0.141350698548044,
         -0.0819481953157402,
         -0.0623297993338971,
         0.186989398001692,
         -0.164909148306051,
         -0.0623297993338974,
         0.141350698548044,
         -0.067048523440151,
         -0.0670485234401512,
         0.141350698548044,
         -0.0623297993338969,
         -0.164909148306051,
         0.104297703129124,
         0.156446554693686,
         -0.0819481953157405,
         -0.0670485234401512,
         0.134097046880302,
         -0.0670485234401514,
         -0.0819481953157401,
         0.156446554693686,
         0.104297703129124,
         -0.164909148306052,
         -0.0623297993338973,
         0.141350698548044,
         -0.0670485234401512,
         -0.0670485234401512,
         0.141350698548044,
         -0.0623297993338973,
         -0.164909148306051,
         0.186989398001692,
         -0.0623297993338972,
         -0.0819481953157406,
         0.141350698548044,
         -0.0819481953157402,
         -0.0623297993338972,
         0.186989398001692,
         -0.164909148306051,
         0.156446554693686,
         -0.0623297993338971,
         -0.0623297993338971,
         0.156446554693686,
         -0.164909148306051,
         0.104297703129124,
         -0.164909148306051,
         0.186989398001692,
         -0.164909148306051,
         0.104297703129124},
        {-0.143222974807886,
         0.175411603861406,
         -0.167248402001418,
         0.136557748399784,
         -0.0965609099170534,
         0.0571262046997986,
         -0.0249319197335588,
         0.189466186686268,
         -0.0877058019307032,
         -0.0264442942673973,
         0.107958379271883,
         -0.144841364875581,
         0.140345893053447,
         -0.105960658867625,
         0.0571262046997984,
         -0.143222974807887,
         -0.0877058019307031,
         0.139930052456288,
         -0.0903244604661889,
         0.0856893070496976,
         -0.137125558534574,
         0.140345893053447,
         -0.0965609099170534,
         0.175411603861406,
         -0.0264442942673973,
         -0.0903244604661892,
         0.127738077005317,
         -0.0903244604661891,
         0.0062329799333896,
         0.0856893070496978,
         -0.14484136487558,
         0.136557748399784,
         -0.167248402001418,
         0.107958379271882,
         -0.090324460466189,
         0.124659598667795,
         -0.0903244604661892,
         0.107958379271883,
         -0.167248402001418,
         0.136557748399784,
         -0.14484136487558,
         0.0856893070496976,
         0.00623297993338951,
         -0.090324460466189,
         0.127738077005317,
         -0.0903244604661889,
         -0.0264442942673973,
         0.175411603861406,
         -0.0965609099170537,
         0.140345893053447,
         -0.137125558534574,
         0.0856893070496976,
         -0.090324460466189,
         0.139930052456288,
         -0.0877058019307033,
         -0.143222974807887,
         0.0571262046997986,
         -0.105960658867625,
         0.140345893053447,
         -0.144841364875581,
         0.107958379271882,
         -0.0264442942673974,
         -0.087705801930703,
         0.189466186686268,
         -0.024931919733559,
         0.0571262046997985,
         -0.0965609099170536,
         0.136557748399784,
         -0.167248402001418,
         0.175411603861406,
         -0.143222974807887},
        {-0.242535625036333,
         0.171498585142509,
         -0.117155837225801,
         0.0766964988847373,
         -0.0475651494154493,
         0.0274617518190544,
         -0.0143414321552944,
         0.00641368343878773,
         -0.00213789447959599,
         0.171498585142509,
         -0.177122977108019,
         0.153392997769474,
         -0.120331367519237,
         0.0868416842864843,
         -0.0573657286211776,
         0.0339380227338527,
         -0.0171031558367679,
         0.00641368343878796,
         -0.117155837225801,
         0.153392997769474,
         -0.159183436688109,
         0.145313931758787,
         -0.119989030075853,
         0.0897915681430309,
         -0.0598610454286873,
         0.0339380227338527,
         -0.0143414321552943,
         0.0766964988847371,
         -0.120331367519237,
         0.145313931758788,
         -0.151775451709656,
         0.141972935005097,
         -0.119722090857375,
         0.089791568143031,
         -0.0573657286211775,
         0.0274617518190545,
         -0.0475651494154496,
         0.0868416842864845,
         -0.119989030075852,
         0.141972935005097,
         -0.149652613571718,
         0.141972935005097,
         -0.119989030075853,
         0.0868416842864844,
         -0.0475651494154492,
         0.0274617518190545,
         -0.0573657286211775,
         0.089791568143031,
         -0.119722090857375,
         0.141972935005097,
         -0.151775451709656,
         0.145313931758788,
         -0.120331367519237,
         0.0766964988847374,
         -0.0143414321552945,
         0.0339380227338527,
         -0.0598610454286874,
         0.0897915681430309,
         -0.119989030075853,
         0.145313931758788,
         -0.159183436688109,
         0.153392997769474,
         -0.117155837225801,
         0.00641368343878798,
         -0.0171031558367679,
         0.0339380227338526,
         -0.0573657286211775,
         0.0868416842864844,
         -0.120331367519237,
         0.153392997769474,
         -0.177122977108019,
         0.171498585142509,
         -0.00213789447959577,
         0.0064136834387879,
         -0.0143414321552943,
         0.0274617518190547,
         -0.0475651494154493,
         0.0766964988847369,
         -0.117155837225801,
         0.171498585142509,
         -0.242535625036333},
        {-0.0682788741998919,
         0.118262479197817,
         -0.152676204138115,
         0.164909148306051,
         -0.152676204138115,
         0.118262479197817,
         -0.0682788741998917,
         0.127738077005317,
         -0.152676204138115,
         0.118262479197817,
         -0.0440738237789955,
         -0.0440738237789955,
         0.118262479197817,
         -0.152676204138115,
         0.127738077005317,
         -0.167248402001418,
         0.107958379271883,
         -0.0903244604661894,
         0.124659598667795,
         -0.0903244604661891,
         0.107958379271883,
         -0.167248402001418,
         0.167248402001418,
         -0.107958379271883,
         0.116608377046907,
         -0.0482804549585271,
         -0.0482804549585269,
         0.116608377046907,
         -0.107958379271883,
         0.167248402001418,
         -0.118262479197816,
         -0.118262479197816,
         0.118262479197817,
         -0.0197104131996364,
         -0.0788416527985439,
         0.118262479197816,
         -0.0788416527985437,
         -0.0197104131996363,
         0.118262479197817,
         -0.118262479197816,
         -0.118262479197816,
         0.167248402001418,
         -0.107958379271883,
         0.116608377046906,
         -0.0482804549585268,
         -0.0482804549585269,
         0.116608377046907,
         -0.107958379271883,
         0.167248402001418,
         -0.167248402001418,
         0.107958379271883,
         -0.0903244604661892,
         0.124659598667795,
         -0.0903244604661891,
         0.107958379271883,
         -0.167248402001418,
         0.127738077005317,
         -0.152676204138115,
         0.118262479197817,
         -0.0440738237789956,
         -0.0440738237789954,
         0.118262479197817,
         -0.152676204138115,
         0.127738077005317,
         -0.0682788741998919,
         0.118262479197817,
         -0.152676204138115,
         0.164909148306051,
         -0.152676204138115,
         0.118262479197817,
         -0.0682788741998921},
        {-0.117155837225801,
         0.153392997769474,
         -0.159183436688108,
         0.145313931758788,
         -0.119989030075852,
         0.0897915681430308,
         -0.0598610454286871,
         0.0339380227338529,
         -0.0143414321552944,
         0.175733755838701,
         -0.110701860692512,
         0.0212717814905756,
         0.0562798437673706,
         -0.108433620215983,
         0.131987933083437,
         -0.129602965095844,
         0.107470405323867,
         -0.0737573595460609,
         0.0372601337194078,
         -0.148522131446501,
         -0.0502096445253434,
         0.123009906878514,
         -0.11370245477722,
         0.0589570676753604,
         0.0117097303204046,
         -0.0759328836843853,
         0.1184941395162,
         -0.131307826053597,
         0.11336601796096,
         -0.0704150340275465,
         0.168408267427152,
         -0.0626654242588656,
         -0.0426699928675471,
         0.104238212682548,
         -0.113378976298769,
         0.0777470834551721,
         -0.0138551397628189,
         -0.0573827992148068,
         0.114065808195287,
         -0.136459095693748,
         0.110091928443769,
         -0.147703821464586,
         0.124554798650389,
         -0.0508974135707676,
         -0.0306632717490141,
         0.0910803268696636,
         -0.113126742446176,
         0.0910803268696639,
         -0.0306632717490141,
         -0.0508974135707677,
         0.124554798650389,
         -0.147703821464586,
         0.110091928443769,
         -0.136459095693748,
         0.114065808195287,
         -0.0573827992148069,
         -0.0138551397628191,
         0.077747083455172,
         -0.113378976298769,
         0.104238212682548,
         -0.0426699928675469,
         -0.0626654242588656,
         0.168408267427152,
         -0.0704150340275465,
         0.113366017960959,
         -0.131307826053597,
         0.1184941395162,
         -0.075932883684385,
         0.0117097303204047,
         0.0589570676753604,
         -0.113702454777221,
         0.123009906878514,
         -0.0502096445253433,
         -0.148522131446501,
         0.0372601337194077,
         -0.073757359546061,
         0.107470405323867,
         -0.129602965095844,
         0.131987933083438,
         -0.108433620215983,
         0.0562798437673707,
         0.0212717814905758,
         -0.110701860692512,
         0.175733755838702,
         -0.0143414321552943,
         0.0339380227338528,
         -0.059861045428687,
         0.0897915681430308,
         -0.119989030075853,
         0.145313931758788,
         -0.159183436688109,
         0.153392997769474,
         -0.117155837225801},
        {-0.229415733870562,
         0.170996392014192,
         -0.12441815044836,
         0.0879769178847232,
         -0.0600996764070424,
         0.0393444737682317,
         -0.0244004068069733,
         0.0140875814383426,
         -0.00735699946461511,
         0.00329015018266177,
         -0.00109671672755407,
         0.152943822580374,
         -0.16589086726448,
         0.152380491669656,
         -0.128498513240647,
         0.101586994446437,
         -0.0756018953632756,
         0.0527109031505536,
         -0.033980524970587,
         0.0197409010959703,
         -0.00980933261948667,
         0.00363739788660285,
         -0.0981423606024251,
         0.134386961871886,
         -0.147213540903638,
         0.143665705306872,
         -0.129114816600118,
         0.108025205882598,
         -0.0840975087224334,
         0.0603094490392804,
         -0.0389295819580129,
         0.0215191361000199,
         -0.00890976881365473,
         0.0600996764070421,
         -0.098142360602425,
         0.12441815044836,
         -0.138029544935371,
         0.139459941117976,
         -0.130283300295807,
         0.112828647745045,
         -0.0899040184915941,
         0.0645574083000593,
         -0.0398456974622788,
         0.0185471628024884,
         -0.0346985643518152,
         0.0655741229470529,
         -0.0945023692040942,
         0.117865162600046,
         -0.132969836554383,
         0.138186307671793,
         -0.132969836554384,
         0.117865162600046,
         -0.0945023692040942,
         0.0655741229470529,
         -0.0346985643518151,
         0.0185471628024886,
         -0.0398456974622787,
         0.0645574083000593,
         -0.0899040184915942,
         0.112828647745045,
         -0.130283300295807,
         0.139459941117976,
         -0.13802954493537,
         0.12441815044836,
         -0.0981423606024251,
         0.0600996764070422,
         -0.0089097688136548,
         0.0215191361000197,
         -0.0389295819580131,
         0.0603094490392804,
         -0.0840975087224336,
         0.108025205882598,
         -0.129114816600119,
         0.143665705306872,
         -0.147213540903638,
         0.134386961871886,
         -0.0981423606024252,
         0.00363739788660269,
         -0.00980933261948664,
         0.0197409010959703,
         -0.0339805249705873,
         0.0527109031505537,
         -0.0756018953632755,
         0.101586994446437,
         -0.128498513240647,
         0.152380491669656,
         -0.16589086726448,
         0.152943822580375,
         -0.0010967167275539,
         0.00329015018266187,
         -0.00735699946461504,
         0.0140875814383423,
         -0.0244004068069732,
         0.0393444737682318,
         -0.0600996764070422,
         0.0879769178847231,
         -0.12441815044836,
         0.170996392014193,
         -0.229415733870562},
        {-0.0475651494154496,
         0.0868416842864844,
         -0.119989030075853,
         0.141972935005097,
         -0.149652613571718,
         0.141972935005097,
         -0.119989030075853,
         0.0868416842864844,
         -0.0475651494154496,
         0.100900919099447,
         -0.135928736541608,
         0.130918764973078,
         -0.0929431030422719,
         0.033463341695687,
         0.033463341695687,
         -0.0929431030422717,
         0.130918764973078,
         -0.135928736541608,
         0.100900919099447,
         -0.147703821464586,
         0.124554798650389,
         -0.0508974135707676,
         -0.0306632717490137,
         0.0910803268696639,
         -0.113126742446176,
         0.0910803268696639,
         -0.0306632717490139,
         -0.0508974135707676,
         0.124554798650389,
         -0.147703821464586,
         0.163292718633225,
         -0.0401998884052647,
         -0.0657206984257101,
         0.111418385070434,
         -0.095763082626331,
         0.0370294185988122,
         0.0370294185988123,
         -0.0957630826263312,
         0.111418385070434,
         -0.06572069842571,
         -0.0401998884052646,
         0.163292718633225,
         -0.126485995964683,
         -0.0843239973097883,
         0.122653086996056,
         -0.0689923614352815,
         -0.0140539995516311,
         0.0817687246640375,
         -0.107321451121549,
         0.0817687246640375,
         -0.014053999551631,
         -0.0689923614352815,
         0.122653086996056,
         -0.0843239973097884,
         -0.126485995964683,
         0.163292718633225,
         -0.0401998884052649,
         -0.0657206984257101,
         0.111418385070434,
         -0.095763082626331,
         0.0370294185988122,
         0.0370294185988123,
         -0.0957630826263309,
         0.111418385070434,
         -0.0657206984257102,
         -0.0401998884052647,
         0.163292718633225,
         -0.147703821464586,
         0.124554798650389,
         -0.0508974135707675,
         -0.0306632717490139,
         0.091080326869664,
         -0.113126742446176,
         0.0910803268696638,
         -0.0306632717490139,
         -0.0508974135707677,
         0.124554798650389,
         -0.147703821464586,
         0.100900919099447,
         -0.135928736541608,
         0.130918764973078,
         -0.0929431030422716,
         0.0334633416956869,
         0.033463341695687,
         -0.0929431030422716,
         0.130918764973078,
         -0.135928736541608,
         0.100900919099447,
         -0.0475651494154495,
         0.0868416842864845,
         -0.119989030075852,
         0.141972935005097,
         -0.149652613571718,
         0.141972935005096,
         -0.119989030075853,
         0.0868416842864846,
         -0.0475651494154496},
        {-0.0981423606024249,
         0.134386961871886,
         -0.147213540903637,
         0.143665705306872,
         -0.129114816600119,
         0.108025205882598,
         -0.0840975087224335,
         0.0603094490392808,
         -0.0389295819580131,
         0.0215191361000198,
         -0.00890976881365468,
         0.162750693079001,
         -0.121444975231353,
         0.0520478465277226,
         0.0160623141550808,
         -0.0704379071917123,
         0.106078646340041,
         -0.122231035057133,
         0.120828124425017,
         -0.105541535818741,
         0.0811032957458608,
         -0.0527422693557402,
         0.0255913625581048,
         -0.150677862904453,
         -0.0217484761772008,
         0.101586994446437,
         -0.11590651878501,
         0.0881057274967275,
         -0.0379132835836201,
         -0.0186119000422583,
         0.0690800964505699,
         -0.1047694586204,
         0.120622637445762,
         -0.115236548871748,
         0.0908231583746313,
         -0.0529791537539749,
         0.159818007951653,
         -0.0842314860396876,
         -0.0055420249008795,
         0.0724028855971708,
         -0.104340528422402,
         0.101028557817556,
         -0.0688184284781709,
         0.0180208947262358,
         0.0389527474357897,
         -0.0891013040407762,
         0.120252411853642,
         -0.122562344051601,
         0.0900472462683836,
         -0.130490857063204,
         0.127875544562073,
         -0.0797388161694113,
         0.0145820321475462,
         0.0466680260423008,
         -0.0892797474008006,
         0.10445902991252,
         -0.0892797474008008,
         0.0466680260423008,
         0.0145820321475462,
         -0.0797388161694114,
         0.127875544562073,
         -0.130490857063205,
         0.0900472462683835,
         -0.122562344051601,
         0.120252411853641,
         -0.0891013040407765,
         0.0389527474357897,
         0.0180208947262358,
         -0.0688184284781713,
         0.101028557817556,
         -0.104340528422402,
         0.0724028855971706,
         -0.00554202490087946,
         -0.0842314860396878,
         0.159818007951653,
         -0.052979153753975,
         0.0908231583746311,
         -0.115236548871748,
         0.120622637445762,
         -0.1047694586204,
         0.06908009645057,
         -0.0186119000422583,
         -0.0379132835836201,
         0.0881057274967277,
         -0.11590651878501,
         0.101586994446437,
         -0.0217484761772006,
         -0.150677862904453,
         0.025591362558105,
         -0.05274226935574,
         0.0811032957458607,
         -0.105541535818741,
         0.120828124425016,
         -0.122231035057133,
         0.106078646340041,
         -0.0704379071917124,
         0.0160623141550807,
         0.0520478465277224,
         -0.121444975231353,
         0.162750693079001,
         -0.00890976881365479,
         0.0215191361000199,
         -0.0389295819580132,
         0.0603094490392806,
         -0.0840975087224336,
         0.108025205882598,
         -0.129114816600119,
         0.143665705306872,
         -0.147213540903637,
         0.134386961871886,
         -0.0981423606024251},
        {0.218217890235993,
         -0.169030850945703,
         0.128613192882607,
         -0.0958626140296006,
         0.0697502970338577,
         -0.0493209080224167,
         0.0336925944158748,
         -0.0220569806100277,
         0.0136791586790205,
         -0.00789766594562017,
         0.00412442152600387,
         -0.00184449738000162,
         0.000614832460000478,
         -0.138013111868471,
         0.155113346865896,
         -0.148509723064221,
         0.131522421393111,
         -0.110284903050138,
         0.0882279224401105,
         -0.0673851888317501,
         0.0489400458900737,
         -0.0335069588741643,
         0.0212984211772708,
         -0.0122350114725185,
         0.00602410321720622,
         -0.0022168099603517,
         0.0837707816583393,
         -0.118469775551818,
         0.1347703776635,
         -0.137549440715733,
         0.130490857063205,
         -0.116714570734214,
         0.0988944203407531,
         -0.0792919367954371,
         0.0597685461934182,
         -0.0417905200599491,
         0.026430645598479,
         -0.0143665705306872,
         0.00586512785898155,
         -0.0483650833406677,
         0.0812695955571501,
         -0.106545338634436,
         0.123027959882982,
         -0.130490857063205,
         0.129483190577223,
         -0.121120434121582,
         0.106917225763856,
         -0.0886510803711074,
         0.06824363348828,
         -0.0476485239744667,
         0.0287331410613744,
         -0.0131148245894106,
         0.0262296491788212,
         -0.0507934972232185,
         0.0753389314522262,
         -0.0972621422785119,
         0.114448052633531,
         -0.125371560179847,
         0.129114816600119,
         -0.125371560179847,
         0.114448052633531,
         -0.0972621422785119,
         0.0753389314522264,
         -0.0507934972232185,
         0.0262296491788212,
         -0.0131148245894106,
         0.0287331410613744,
         -0.0476485239744666,
         0.06824363348828,
         -0.0886510803711073,
         0.106917225763856,
         -0.121120434121582,
         0.129483190577224,
         -0.130490857063205,
         0.123027959882982,
         -0.106545338634435,
         0.0812695955571498,
         -0.0483650833406677,
         0.00586512785898155,
         -0.0143665705306872,
         0.0264306455984789,
         -0.0417905200599491,
         0.0597685461934182,
         -0.0792919367954372,
         0.0988944203407531,
         -0.116714570734214,
         0.130490857063205,
         -0.137549440715733,
         0.1347703776635,
         -0.118469775551819,
         0.0837707816583389,
         -0.00221680996035191,
         0.00602410321720611,
         -0.0122350114725185,
         0.0212984211772709,
         -0.0335069588741642,
         0.0489400458900739,
         -0.0673851888317501,
         0.0882279224401105,
         -0.110284903050138,
         0.131522421393112,
         -0.148509723064221,
         0.155113346865896,
         -0.138013111868471,
         0.000614832460000666,
         -0.00184449738000166,
         0.00412442152600409,
         -0.00789766594562008,
         0.0136791586790205,
         -0.0220569806100277,
         0.0336925944158749,
         -0.0493209080224167,
         0.0697502970338578,
         -0.0958626140296003,
         0.128613192882607,
         -0.169030850945703,
         0.218217890235992},
        {-0.0346985643518149,
         0.0655741229470531,
         -0.0945023692040942,
         0.117865162600046,
         -0.132969836554384,
         0.138186307671792,
         -0.132969836554384,
         0.117865162600046,
         -0.094502369204094,
         0.0655741229470529,
         -0.0346985643518152,
         0.0813753465395006,
         -0.118033421304695,
         0.127308926031096,
         -0.111372110170683,
         0.075386811299101,
         -0.0265939673108766,
         -0.0265939673108766,
         0.0753868112991011,
         -0.111372110170683,
         0.127308926031096,
         -0.118033421304695,
         0.0813753465395004,
         -0.130490857063205,
         0.127875544562073,
         -0.0797388161694112,
         0.0145820321475462,
         0.0466680260423007,
         -0.0892797474008006,
         0.10445902991252,
         -0.0892797474008005,
         0.0466680260423008,
         0.0145820321475464,
         -0.0797388161694114,
         0.127875544562072,
         -0.130490857063205,
         0.156830492040209,
         -0.0657612106965558,
         -0.0290178775885868,
         0.0884643283617799,
         -0.10362998999258,
         0.0796946290876208,
         -0.0296113516439556,
         -0.0296113516439557,
         0.0796946290876207,
         -0.10362998999258,
         0.0884643283617799,
         -0.0290178775885868,
         -0.0657612106965557,
         0.156830492040209,
         -0.131213803631713,
         -0.0562344872707345,
         0.113910884471488,
         -0.0922822355212049,
         0.0326395975067902,
         0.0329017629486117,
         -0.081402369685608,
         0.0990985370085666,
         -0.081402369685608,
         0.0329017629486117,
         0.0326395975067902,
         -0.0922822355212051,
         0.113910884471488,
         -0.0562344872707344,
         -0.131213803631713,
         0.156830492040209,
         -0.0657612106965559,
         -0.0290178775885868,
         0.0884643283617799,
         -0.10362998999258,
         0.0796946290876205,
         -0.0296113516439557,
         -0.0296113516439555,
         0.0796946290876205,
         -0.10362998999258,
         0.0884643283617799,
         -0.0290178775885869,
         -0.0657612106965556,
         0.156830492040209,
         -0.130490857063204,
         0.127875544562073,
         -0.0797388161694114,
         0.0145820321475462,
         0.0466680260423009,
         -0.0892797474008006,
         0.104459029912521,
         -0.0892797474008002,
         0.0466680260423007,
         0.0145820321475461,
         -0.0797388161694113,
         0.127875544562073,
         -0.130490857063204,
         0.0813753465395005,
         -0.118033421304695,
         0.127308926031096,
         -0.111372110170683,
         0.075386811299101,
         -0.0265939673108766,
         -0.0265939673108768,
         0.075386811299101,
         -0.111372110170683,
         0.127308926031096,
         -0.118033421304696,
         0.0813753465395005,
         -0.0346985643518151,
         0.0655741229470533,
         -0.0945023692040944,
         0.117865162600046,
         -0.132969836554384,
         0.138186307671793,
         -0.132969836554384,
         0.117865162600046,
         -0.094502369204094,
         0.065574122947053,
         -0.0346985643518151},
        {0.0837707816583392,
         -0.118469775551819,
         0.1347703776635,
         -0.137549440715733,
         0.130490857063205,
         -0.116714570734214,
         0.0988944203407532,
         -0.0792919367954373,
         0.0597685461934182,
         -0.041790520059949,
         0.026430645598479,
         -0.0143665705306872,
         0.00586512785898143,
         -0.15101992432742,
         0.125656172487508,
         -0.0718328526534363,
         0.0137549440715731,
         0.0376694657261134,
         -0.0771994321350967,
         0.102791088036026,
         -0.114448052633531,
         0.113560237767495,
         -0.102462341357029,
         0.0841017993022032,
         -0.0617608310665324,
         0.0387941743061549,
         -0.0183138558698452,
         0.15101992432742,
         -0.0806321771231316,
         0.108623688057233,
         -0.0996640383319669,
         0.0673851888317497,
         -0.023361610917279,
         -0.0228896105267063,
         0.0639085736587206,
         -0.0942921300800371,
         0.110692896616163,
         -0.111816711180672,
         0.0984149741214597,
         -0.0732554234793811,
         0.0409510266551076,
         -0.15101992432742,
         0.0969078163565817,
         -0.0219452989779321,
         -0.0424968887345367,
         0.0842314860396878,
         -0.0998099594032764,
         0.0908403255911866,
         -0.0621132952209164,
         0.0204148450065646,
         0.0263554515752771,
         -0.0699289152444595,
         0.102371912493733,
         -0.116825043613403,
         0.108346232462192,
         -0.0747660035066592,
         0.11582699457751,
         -0.125107452955456,
         0.0950259320426689,
         -0.0454310850424252,
         -0.00853045418603547,
         0.0552836616193404,
         -0.0866128520460856,
         0.0976016272278939,
         -0.0866128520460857,
         0.0552836616193406,
         -0.00853045418603551,
         -0.0454310850424252,
         0.0950259320426689,
         -0.125107452955456,
         0.11582699457751,
         -0.0747660035066592,
         0.108346232462192,
         -0.116825043613403,
         0.102371912493733,
         -0.0699289152444596,
         0.0263554515752772,
         0.0204148450065646,
         -0.0621132952209164,
         0.0908403255911867,
         -0.0998099594032765,
         0.0842314860396878,
         -0.0424968887345364,
         -0.0219452989779323,
         0.096907816356582,
         -0.15101992432742,
         0.0409510266551075,
         -0.0732554234793811,
         0.0984149741214596,
         -0.111816711180672,
         0.110692896616162,
         -0.0942921300800371,
         0.0639085736587207,
         -0.0228896105267064,
         -0.023361610917279,
         0.0673851888317497,
         -0.0996640383319668,
         0.108623688057234,
         -0.0806321771231317,
         0.15101992432742,
         -0.0183138558698452,
         0.0387941743061546,
         -0.0617608310665323,
         0.0841017993022032,
         -0.102462341357029,
         0.113560237767495,
         -0.114448052633531,
         0.102791088036026,
         -0.0771994321350967,
         0.0376694657261134,
         0.0137549440715734,
         -0.0718328526534361,
         0.125656172487509,
         -0.15101992432742,
         0.00586512785898157,
         -0.0143665705306872,
         0.0264306455984792,
         -0.0417905200599491,
         0.0597685461934183,
         -0.0792919367954374,
         0.0988944203407532,
         -0.116714570734214,
         0.130490857063205,
         -0.137549440715732,
         0.1347703776635,
         -0.118469775551818,
         0.0837707816583392},
        {-0.0262296491788212,
         0.0507934972232184,
         -0.0753389314522262,
         0.0972621422785118,
         -0.114448052633531,
         0.125371560179847,
         -0.129114816600119,
         0.125371560179847,
         -0.114448052633532,
         0.0972621422785118,
         -0.0753389314522264,
         0.0507934972232185,
         -0.0262296491788212,
         0.0668727464987512,
         -0.102009395413687,
         0.118033421304695,
         -0.115082118718973,
         0.0953733771946092,
         -0.0626857800899237,
         0.0218243873196166,
         0.0218243873196163,
         -0.0626857800899238,
         0.0953733771946091,
         -0.115082118718972,
         0.118033421304695,
         -0.102009395413687,
         0.066872746498751,
         -0.115826994577511,
         0.125107452955456,
         -0.0950259320426689,
         0.0454310850424253,
         0.00853045418603539,
         -0.0552836616193406,
         0.0866128520460855,
         -0.0976016272278936,
         0.0866128520460855,
         -0.0552836616193406,
         0.00853045418603547,
         0.0454310850424254,
         -0.0950259320426689,
         0.125107452955456,
         -0.115826994577511,
         0.149532007013318,
         -0.0819020533102148,
         0.0622090752241798,
         -0.093552572543374,
         0.0934464436691142,
         -0.0673655515913998,
         0.0244004068069733,
         0.0244004068069731,
         -0.0673655515913998,
         0.0934464436691143,
         -0.0935525725433736,
         0.0622090752241799,
         -0.0819020533102147,
         0.149532007013318,
         -0.133745492997502,
         -0.0334363732493758,
         0.100309119748126,
         -0.100309119748127,
         0.0617286890757702,
         -0.00771608613447078,
         -0.0437244880953368,
         0.079732890056203,
         -0.0925930336136543,
         0.0797328900562031,
         -0.0437244880953369,
         -0.00771608613447082,
         0.0617286890757702,
         -0.100309119748127,
         0.100309119748126,
         -0.0334363732493756,
         -0.133745492997502,
         0.149532007013318,
         -0.0819020533102147,
         0.0622090752241801,
         -0.0935525725433737,
         0.0934464436691141,
         -0.0673655515913998,
         0.0244004068069731,
         0.024400406806973,
         -0.0673655515913997,
         0.0934464436691144,
         -0.0935525725433739,
         0.06220907522418,
         -0.0819020533102146,
         0.149532007013318,
         -0.11582699457751,
         0.125107452955456,
         -0.095025932042669,
         0.0454310850424254,
         0.00853045418603533,
         -0.0552836616193408,
         0.0866128520460856,
         -0.0976016272278938,
         0.0866128520460856,
         -0.0552836616193408,
         0.00853045418603538,
         0.0454310850424255,
         -0.095025932042669,
         0.125107452955456,
         -0.11582699457751,
         0.066872746498751,
         -0.102009395413687,
         0.118033421304695,
         -0.115082118718972,
         0.0953733771946094,
         -0.0626857800899238,
         0.0218243873196163,
         0.0218243873196164,
         -0.0626857800899237,
         0.0953733771946091,
         -0.115082118718972,
         0.118033421304695,
         -0.102009395413687,
         0.0668727464987512,
         -0.0262296491788211,
         0.0507934972232185,
         -0.0753389314522266,
         0.0972621422785119,
         -0.114448052633531,
         0.125371560179847,
         -0.129114816600119,
         0.125371560179847,
         -0.114448052633531,
         0.097262142278512,
         -0.0753389314522264,
         0.0507934972232185,
         -0.026229649178821},
        {0.0725954008640629,
         -0.105200730396178,
         0.123063320366542,
         -0.129720129593753,
         0.12779824364991,
         -0.119544310592356,
         0.106923681923142,
         -0.091648870219836,
         0.075189892866205,
         -0.0587786430798472,
         0.0434109048866426,
         -0.0298472393241456,
         0.0186130239153332,
         -0.00999679745746628,
         0.00403931615561308,
         -0.140580389278883,
         0.126261747910866,
         -0.0844714596864548,
         0.0355253205704956,
         0.0111234093449159,
         -0.0505166913628581,
         0.0801927614423567,
         -0.0992862760714896,
         0.108029998376372,
         -0.107436508279763,
         0.0990713827005229,
         -0.0848761157015401,
         0.0670179643603152,
         -0.0477514970840835,
         0.0292763354111513,
         -0.0135482782598459,
         0.150286757708826,
         -0.0168025703177483,
         -0.0617084987613569,
         0.0974325425090735,
         -0.101321638326391,
         0.0830938567648801,
         -0.0512332759681524,
         0.012990006350449,
         0.0256197655877732,
         -0.0598136958469582,
         0.0860431231041579,
         -0.101992732929231,
         0.106579788977455,
         -0.0999521620628003,
         0.0834824192203982,
         -0.0597453396127749,
         0.0323865795667822,
         -0.142574536956527,
         0.104078898009667,
         -0.0419484119531376,
         -0.0171611524624721,
         0.0618968364467101,
         -0.0876992577767617,
         0.0939276726082797,
         -0.0824636204856445,
         0.0568720386741567,
         -0.0218159134744827,
         -0.0174030785288194,
         0.0552429711582656,
         -0.0862999211295604,
         0.105700209721364,
         -0.109541462525017,
         0.0954198751296218,
         -0.0629481958308288,
         0.103434440432393,
         -0.119642978197896,
         0.102217922356204,
         -0.0654833449225881,
         0.0205965518990415,
         0.023502491837356,
         -0.0599127407243178,
         0.0837210308528111,
         -0.0919839677553636,
         0.0837210308528112,
         -0.0599127407243177,
         0.0235024918373562,
         0.0205965518990414,
         -0.0654833449225883,
         0.102217922356204,
         -0.119642978197896,
         0.103434440432393,
         -0.0629481958308289,
         0.0954198751296219,
         -0.109541462525017,
         0.105700209721364,
         -0.0862999211295605,
         0.0552429711582656,
         -0.0174030785288193,
         -0.0218159134744828,
         0.0568720386741568,
         -0.0824636204856447,
         0.0939276726082795,
         -0.0876992577767618,
         0.06189683644671,
         -0.0171611524624722,
         -0.0419484119531376,
         0.104078898009667,
         -0.142574536956528,
         0.0323865795667821,
         -0.0597453396127749,
         0.0834824192203981,
         -0.0999521620628002,
         0.106579788977455,
         -0.101992732929231,
         0.0860431231041581,
         -0.0598136958469582,
         0.0256197655877733,
         0.012990006350449,
         -0.0512332759681524,
         0.0830938567648801,
         -0.101321638326391,
         0.0974325425090734,
         -0.0617084987613568,
         -0.0168025703177483,
         0.150286757708826,
         -0.0135482782598459,
         0.0292763354111513,
         -0.0477514970840835,
         0.0670179643603151,
         -0.0848761157015401,
         0.0990713827005229,
         -0.107436508279762,
         0.108029998376373,
         -0.0992862760714896,
         0.0801927614423568,
         -0.0505166913628583,
         0.0111234093449159,
         0.0355253205704956,
         -0.0844714596864548,
         0.126261747910866,
         -0.140580389278883,
         0.00403931615561316,
         -0.00999679745746632,
         0.0186130239153332,
         -0.0298472393241457,
         0.0434109048866424,
         -0.0587786430798474,
         0.0751898928662051,
         -0.0916488702198359,
         0.106923681923142,
         -0.119544310592356,
         0.12779824364991,
         -0.129720129593753,
         0.123063320366542,
         -0.105200730396178,
         0.0725954008640629},
        {0.02039754673061,
         -0.0402245046125971,
         0.0609254221457414,
         -0.080596757759629,
         0.0976075208680206,
         -0.110676525559855,
         0.118885659240627,
         -0.121683351642838,
         0.118885659240627,
         -0.110676525559856,
         0.0976075208680206,
         -0.0805967577596292,
         0.0609254221457413,
         -0.0402245046125973,
         0.02039754673061,
         -0.0558609823106042,
         0.0883893691659766,
         -0.107314629047925,
         0.111927147465546,
         -0.103004212002366,
         0.0824934115551101,
         -0.0531672831223833,
         0.0183444554832802,
         0.0183444554832802,
         -0.0531672831223834,
         0.08249341155511,
         -0.103004212002366,
         0.111927147465546,
         -0.107314629047925,
         0.0883893691659766,
         -0.0558609823106043,
         0.103434440432393,
         -0.119642978197896,
         0.102217922356204,
         -0.065483344922588,
         0.0205965518990416,
         0.0235024918373562,
         -0.059912740724318,
         0.0837210308528112,
         -0.0919839677553636,
         0.0837210308528111,
         -0.059912740724318,
         0.0235024918373561,
         0.0205965518990415,
         -0.0654833449225882,
         0.102217922356205,
         -0.119642978197896,
         0.103434440432393,
         -0.142157041076471,
         0.0919417248287932,
         -0.0221899940282159,
         -0.037786270551331,
         0.0766805420555024,
         -0.0913881332186114,
         0.0835477159357167,
         -0.0577796037448278,
         0.0205682404741136,
         0.0205682404741138,
         -0.0577796037448275,
         0.083547715935717,
         -0.0913881332186114,
         0.0766805420555025,
         -0.0377862705513308,
         -0.0221899940282157,
         0.0919417248287931,
         -0.142157041076471,
         0.134862010569529,
         0.0149846678410593,
         -0.0855007517989817,
         0.0998243313529364,
         -0.0780084178784527,
         0.0370209440779101,
         0.00925523601947718,
         -0.0500223470576524,
         0.0775676923537164,
         -0.0872636538979297,
         0.0775676923537163,
         -0.0500223470576523,
         0.00925523601947724,
         0.0370209440779101,
         -0.0780084178784528,
         0.0998243313529363,
         -0.0855007517989822,
         0.0149846678410593,
         0.134862010569529,
         -0.142157041076471,
         0.0919417248287931,
         -0.0221899940282159,
         -0.0377862705513311,
         0.0766805420555025,
         -0.0913881332186111,
         0.083547715935717,
         -0.0577796037448277,
         0.0205682404741139,
         0.0205682404741138,
         -0.0577796037448278,
         0.083547715935717,
         -0.0913881332186113,
         0.0766805420555026,
         -0.037786270551331,
         -0.0221899940282159,
         0.0919417248287931,
         -0.142157041076471,
         0.103434440432393,
         -0.119642978197896,
         0.102217922356204,
         -0.0654833449225881,
         0.0205965518990417,
         0.0235024918373562,
         -0.0599127407243181,
         0.0837210308528111,
         -0.0919839677553636,
         0.0837210308528112,
         -0.0599127407243179,
         0.023502491837356,
         0.0205965518990417,
         -0.0654833449225878,
         0.102217922356204,
         -0.119642978197896,
         0.103434440432393,
         -0.0558609823106043,
         0.0883893691659767,
         -0.107314629047925,
         0.111927147465546,
         -0.103004212002366,
         0.0824934115551101,
         -0.0531672831223835,
         0.0183444554832803,
         0.0183444554832804,
         -0.0531672831223834,
         0.08249341155511,
         -0.103004212002367,
         0.111927147465546,
         -0.107314629047925,
         0.0883893691659765,
         -0.0558609823106043,
         0.02039754673061,
         -0.0402245046125971,
         0.0609254221457414,
         -0.080596757759629,
         0.0976075208680206,
         -0.110676525559856,
         0.118885659240627,
         -0.121683351642838,
         0.118885659240627,
         -0.110676525559856,
         0.0976075208680203,
         -0.0805967577596291,
         0.0609254221457413,
         -0.0402245046125971,
         0.0203975467306101},
        {-0.0162328251185892,
         0.0324656502371783,
         -0.0499635814945698,
         0.0673084701929911,
         -0.0832399734830287,
         0.0967161093115549,
         -0.106923681923142,
         0.113281035444729,
         -0.115438963354368,
         0.113281035444729,
         -0.106923681923142,
         0.0967161093115549,
         -0.0832399734830288,
         0.0673084701929913,
         -0.0499635814945699,
         0.0324656502371783,
         -0.0162328251185892,
         0.0473264111919649,
         -0.076999050350902,
         0.096825702671714,
         -0.105770453160414,
         0.103889766655843,
         -0.0921297680024361,
         0.0720879316466458,
         -0.0458244351099179,
         0.0157092531474473,
         0.0157092531474472,
         -0.0458244351099179,
         0.0720879316466458,
         -0.0921297680024358,
         0.103889766655843,
         -0.105770453160414,
         0.0968257026717142,
         -0.0769990503509019,
         0.047326411191965,
         -0.0929472264247648,
         0.113131761267519,
         -0.104601075918279,
         0.0780151405205122,
         -0.0417597609625958,
         0.00275937825164704,
         0.0333702280347471,
         -0.0622781190746284,
         0.0808623851364088,
         -0.0872636538979309,
         0.0808623851364089,
         -0.0622781190746284,
         0.0333702280347473,
         0.00275937825164696,
         -0.0417597609625957,
         0.0780151405205121,
         -0.10460107591828,
         0.11313176126752,
         -0.0929472264247647,
         0.135049189022647,
         -0.0979749792325485,
         0.0389313090528863,
         0.016704020668219,
         -0.0582565129117294,
         0.0815987568701474,
         -0.0863822028484558,
         0.0746857484587202,
         -0.0501991983285119,
         0.0176499430368075,
         0.0176499430368076,
         -0.0501991983285121,
         0.0746857484587202,
         -0.0863822028484558,
         0.0815987568701475,
         -0.0582565129117294,
         0.0167040206682189,
         0.0389313090528863,
         -0.0979749792325483,
         0.135049189022647,
         -0.135049189022647,
         0.0710785205382357,
         -0.0947713607176483,
         0.0857123335902247,
         -0.0565840771343608,
         0.0181180542548443,
         0.0209054472171275,
         -0.0536573145239623,
         0.0752596099816613,
         -0.0827855709798274,
         0.0752596099816613,
         -0.0536573145239625,
         0.0209054472171274,
         0.0181180542548442,
         -0.0565840771343611,
         0.0857123335902247,
         -0.0947713607176481,
         0.0710785205382355,
         -0.135049189022647,
         0.135049189022647,
         -0.0979749792325485,
         0.0389313090528864,
         0.016704020668219,
         -0.0582565129117293,
         0.0815987568701474,
         -0.0863822028484559,
         0.0746857484587201,
         -0.050199198328512,
         0.0176499430368075,
         0.0176499430368074,
         -0.050199198328512,
         0.0746857484587203,
         -0.0863822028484558,
         0.0815987568701475,
         -0.0582565129117293,
         0.0167040206682188,
         0.0389313090528863,
         -0.0979749792325484,
         0.135049189022647,
         -0.092947226424765,
         0.11313176126752,
         -0.104601075918279,
         0.0780151405205121,
         -0.0417597609625958,
         0.00275937825164713,
         0.0333702280347472,
         -0.0622781190746283,
         0.0808623851364089,
         -0.0872636538979308,
         0.0808623851364087,
         -0.0622781190746281,
         0.0333702280347471,
         0.00275937825164708,
         -0.0417597609625957,
         0.0780151405205122,
         -0.104601075918279,
         0.11313176126752,
         -0.0929472264247649,
         0.047326411191965,
         -0.0769990503509021,
         0.0968257026717142,
         -0.105770453160414,
         0.103889766655843,
         -0.092129768002436,
         0.0720879316466458,
         -0.0458244351099179,
         0.015709253147447,
         0.0157092531474471,
         -0.045824435109918,
         0.0720879316466459,
         -0.0921297680024359,
         0.103889766655843,
         -0.105770453160414,
         0.096825702671714,
         -0.0769990503509019,
         0.0473264111919649,
         -0.0162328251185891,
         0.0324656502371781,
         -0.04996358149457,
         0.0673084701929909,
         -0.0832399734830288,
         0.0967161093115552,
         -0.106923681923142,
         0.113281035444729,
         -0.115438963354368,
         0.113281035444729,
         -0.106923681923142,
         0.0967161093115551,
         -0.0832399734830288,
         0.0673084701929909,
         -0.0499635814945698,
         0.0324656502371782,
         -0.016232825118589},
        {-0.0823852554571635,
         0.130262526429727,
         -0.152113858934032,
         0.146955949208651,
         -0.119989030075852,
         0.0804910883411619,
         -0.0392756294919234,
         0.137856900033614,
         -0.135372788459142,
         0.0702583819224289,
         0.0175645954806071,
         -0.0929431030422716,
         0.131987933083438,
         -0.125682014374155,
         0.0804910883411618,
         -0.159183436688109,
         0.0562798437673706,
         0.0589570676753606,
         -0.11337897629877,
         0.091080326869664,
         -0.013855139762819,
         -0.0759328836843851,
         0.131987933083438,
         -0.119989030075852,
         0.137856900033614,
         0.0562798437673707,
         -0.117564759366921,
         0.0608455435736125,
         0.0370294185988124,
         -0.102618935020607,
         0.0942615107806161,
         -0.0138551397628191,
         -0.0929431030422714,
         0.146955949208651,
         -0.0823852554571635,
         -0.135372788459142,
         0.0589570676753605,
         0.0608455435736129,
         -0.107321451121549,
         0.0619620686948477,
         0.0314205035935393,
         -0.102618935020607,
         0.0910803268696638,
         0.0175645954806071,
         -0.152113858934032,
         0.130262526429726,
         0.0702583819224288,
         -0.11337897629877,
         0.0370294185988124,
         0.0619620686948476,
         -0.104735011978463,
         0.0619620686948474,
         0.0370294185988123,
         -0.11337897629877,
         0.0702583819224289,
         0.130262526429727,
         -0.152113858934032,
         0.0175645954806069,
         0.0910803268696639,
         -0.102618935020607,
         0.0314205035935393,
         0.0619620686948475,
         -0.107321451121549,
         0.0608455435736128,
         0.0589570676753603,
         -0.135372788459142,
         -0.0823852554571634,
         0.146955949208651,
         -0.0929431030422716,
         -0.0138551397628191,
         0.0942615107806161,
         -0.102618935020607,
         0.0370294185988124,
         0.0608455435736127,
         -0.117564759366921,
         0.0562798437673705,
         0.137856900033614,
         -0.119989030075852,
         0.131987933083437,
         -0.0759328836843849,
         -0.013855139762819,
         0.091080326869664,
         -0.11337897629877,
         0.0589570676753604,
         0.0562798437673706,
         -0.159183436688108,
         0.0804910883411618,
         -0.125682014374155,
         0.131987933083438,
         -0.0929431030422717,
         0.017564595480607,
         0.0702583819224288,
         -0.135372788459142,
         0.137856900033614,
         -0.0392756294919233,
         0.080491088341162,
         -0.119989030075853,
         0.146955949208651,
         -0.152113858934032,
         0.130262526429727,
         -0.0823852554571633},
        {-0.12441815044836,
         0.152380491669656,
         -0.147213540903638,
         0.12441815044836,
         -0.0945023692040945,
         0.0645574083000595,
         -0.0389295819580133,
         0.0197409010959703,
         -0.00735699946461499,
         0.166924465222397,
         -0.0786889475364631,
         -0.0175953835769445,
         0.0861994231841232,
         -0.120034130257891,
         0.12345737815154,
         -0.105541535818741,
         0.0765127944319959,
         -0.0456133966806129,
         0.0197409010959704,
         -0.12441815044836,
         -0.0786889475364633,
         0.121904393335725,
         -0.0806321771231318,
         0.00845254886300564,
         0.0597685461934183,
         -0.1047694586204,
         0.11978135052132,
         -0.107412192183379,
         0.0765127944319958,
         -0.0389295819580133,
         0.152380491669656,
         -0.0175953835769447,
         -0.0806321771231319,
         0.109557554843522,
         -0.0801879193228919,
         0.0180208947262357,
         0.049549268504284,
         -0.100055192718764,
         0.11978135052132,
         -0.105541535818741,
         0.0645574083000595,
         -0.147213540903638,
         0.0861994231841232,
         0.00845254886300554,
         -0.0801879193228917,
         0.104459029912521,
         -0.0797819019326298,
         0.0205995985009222,
         0.0495492685042839,
         -0.1047694586204,
         0.12345737815154,
         -0.0945023692040941,
         0.12441815044836,
         -0.120034130257891,
         0.0597685461934184,
         0.0180208947262356,
         -0.07978190193263,
         0.10299799250461,
         -0.0797819019326301,
         0.0180208947262357,
         0.0597685461934183,
         -0.120034130257891,
         0.12441815044836,
         -0.0945023692040944,
         0.12345737815154,
         -0.104769458620399,
         0.0495492685042839,
         0.0205995985009221,
         -0.0797819019326301,
         0.104459029912521,
         -0.0801879193228919,
         0.00845254886300567,
         0.0861994231841232,
         -0.147213540903638,
         0.0645574083000593,
         -0.105541535818741,
         0.11978135052132,
         -0.100055192718764,
         0.0495492685042838,
         0.0180208947262356,
         -0.0801879193228918,
         0.109557554843522,
         -0.0806321771231317,
         -0.0175953835769446,
         0.152380491669656,
         -0.0389295819580131,
         0.0765127944319962,
         -0.107412192183379,
         0.11978135052132,
         -0.1047694586204,
         0.0597685461934185,
         0.00845254886300559,
         -0.0806321771231319,
         0.121904393335725,
         -0.0786889475364633,
         -0.12441815044836,
         0.0197409010959705,
         -0.0456133966806129,
         0.0765127944319961,
         -0.105541535818741,
         0.12345737815154,
         -0.120034130257891,
         0.0861994231841231,
         -0.0175953835769445,
         -0.0786889475364632,
         0.166924465222397,
         -0.00735699946461494,
         0.0197409010959704,
         -0.0389295819580132,
         0.0645574083000595,
         -0.0945023692040944,
         0.12441815044836,
         -0.147213540903637,
         0.152380491669656,
         -0.12441815044836},
        {-0.218217890235993,
         0.154303349962092,
         -0.106198848810719,
         0.0707992325404791,
         -0.0454310850424255,
         0.0278207442037329,
         -0.016062314155081,
         0.00858566805814897,
         -0.0041244215260041,
         0.00168378803714346,
         -0.000507681195063209,
         0.154303349962092,
         -0.158311896715326,
         0.13710212427677,
         -0.108601065191622,
         0.0803115707754045,
         -0.0556414884074657,
         0.035916426326718,
         -0.0212984211772707,
         0.0112951935322615,
         -0.00507681195063111,
         0.00168378803714348,
         -0.106198848810719,
         0.137102124276771,
         -0.141076922000992,
         0.128785020872233,
         -0.107749278980154,
         0.0834622326111985,
         -0.0597685461934183,
         0.0391276981584006,
         -0.0228456537778394,
         0.0112951935322616,
         -0.00412442152600413,
         0.0707992325404788,
         -0.108601065191621,
         0.128785020872233,
         -0.133008597621102,
         0.12441815044836,
         -0.106917225763856,
         0.0845254886300549,
         -0.0609217434075713,
         0.0391276981584007,
         -0.0212984211772708,
         0.0085856680581489,
         -0.0454310850424255,
         0.0803115707754046,
         -0.107749278980154,
         0.12441815044836,
         -0.129114816600119,
         0.122489070039388,
         -0.10661305096325,
         0.0845254886300549,
         -0.0597685461934182,
         0.0359164263267179,
         -0.0160623141550808,
         0.0278207442037327,
         -0.0556414884074656,
         0.0834622326111986,
         -0.106917225763856,
         0.122489070039388,
         -0.1279356611559,
         0.122489070039388,
         -0.106917225763856,
         0.0834622326111988,
         -0.0556414884074657,
         0.0278207442037326,
         -0.0160623141550808,
         0.0359164263267182,
         -0.0597685461934185,
         0.0845254886300553,
         -0.10661305096325,
         0.122489070039388,
         -0.129114816600119,
         0.12441815044836,
         -0.107749278980154,
         0.0803115707754045,
         -0.0454310850424256,
         0.00858566805814893,
         -0.0212984211772707,
         0.0391276981584006,
         -0.0609217434075715,
         0.084525488630055,
         -0.106917225763855,
         0.12441815044836,
         -0.133008597621102,
         0.128785020872233,
         -0.108601065191622,
         0.0707992325404791,
         -0.00412442152600405,
         0.0112951935322615,
         -0.0228456537778395,
         0.0391276981584006,
         -0.0597685461934184,
         0.0834622326111987,
         -0.107749278980153,
         0.128785020872233,
         -0.141076922000991,
         0.13710212427677,
         -0.106198848810719,
         0.00168378803714352,
         -0.00507681195063098,
         0.0112951935322615,
         -0.0212984211772708,
         0.035916426326718,
         -0.0556414884074657,
         0.0803115707754043,
         -0.108601065191621,
         0.13710212427677,
         -0.158311896715326,
         0.154303349962092,
         -0.000507681195063078,
         0.00168378803714349,
         -0.00412442152600392,
         0.00858566805814899,
         -0.0160623141550809,
         0.0278207442037328,
         -0.0454310850424255,
         0.0707992325404792,
         -0.106198848810718,
         0.154303349962092,
         -0.218217890235992},
        {-0.0600996764070419,
         0.101586994446437,
         -0.129114816600119,
         0.139459941117976,
         -0.132969836554383,
         0.112828647745046,
         -0.0840975087224336,
         0.0527109031505537,
         -0.0244004068069734,
         0.114031118451202,
         -0.132063092780369,
         0.100802527151034,
         -0.0408296900131294,
         -0.0265939673108769,
         0.0832522861779386,
         -0.116528926317777,
         0.120828124425016,
         -0.0980074569502011,
         0.0567014215224565,
         -0.147213540903637,
         0.0861994231841231,
         0.00845254886300557,
         -0.0801879193228917,
         0.10445902991252,
         -0.0797819019326304,
         0.0205995985009222,
         0.0495492685042835,
         -0.1047694586204,
         0.12345737815154,
         -0.094502369204094,
         0.140946234689939,
         0.0160623141550809,
         -0.100071420078144,
         0.0931699428313753,
         -0.0296113516439556,
         -0.0452320867794605,
         0.0930788855880687,
         -0.0921516189538838,
         0.0414480578703421,
         0.0389527474357897,
         -0.111372110170684,
         0.127956812790525,
         -0.0922709699122365,
         -0.113901758093677,
         0.0881057274967274,
         0.00782553963167993,
         -0.0814023696856083,
         0.0949675993808286,
         -0.0511827251162093,
         -0.021491170999057,
         0.0833243892685616,
         -0.0978800917801476,
         0.0466680260423008,
         0.0558449314569403,
         -0.145089387942933,
         0.135070869402576,
         0.0305875286812961,
         -0.104340528422402,
         0.0796946290876209,
         -0.00456913075556785,
         -0.0668521876645099,
         0.0953576116969908,
         -0.0668521876645099,
         -0.00456913075556777,
         0.079694629087621,
         -0.104340528422402,
         0.0305875286812961,
         0.135070869402576,
         -0.145089387942933,
         0.0558449314569402,
         0.0466680260423008,
         -0.0978800917801477,
         0.0833243892685616,
         -0.0214911709990571,
         -0.0511827251162092,
         0.0949675993808285,
         -0.0814023696856084,
         0.00782553963167999,
         0.0881057274967274,
         -0.113901758093676,
         -0.0922709699122365,
         0.127956812790525,
         -0.111372110170683,
         0.0389527474357895,
         0.0414480578703421,
         -0.0921516189538839,
         0.0930788855880684,
         -0.0452320867794604,
         -0.0296113516439557,
         0.0931699428313753,
         -0.100071420078144,
         0.0160623141550809,
         0.140946234689939,
         -0.0945023692040943,
         0.12345737815154,
         -0.104769458620399,
         0.0495492685042835,
         0.0205995985009221,
         -0.0797819019326302,
         0.104459029912521,
         -0.0801879193228918,
         0.00845254886300567,
         0.0861994231841231,
         -0.147213540903638,
         0.0567014215224564,
         -0.098007456950201,
         0.120828124425016,
         -0.116528926317777,
         0.0832522861779386,
         -0.0265939673108767,
         -0.0408296900131294,
         0.100802527151034,
         -0.132063092780368,
         0.114031118451202,
         -0.0244004068069735,
         0.0527109031505536,
         -0.0840975087224335,
         0.112828647745046,
         -0.132969836554384,
         0.139459941117976,
         -0.129114816600119,
         0.101586994446437,
         -0.0600996764070418},
        {-0.106198848810718,
         0.137102124276771,
         -0.141076922000991,
         0.128785020872233,
         -0.107749278980154,
         0.0834622326111987,
         -0.0597685461934183,
         0.0391276981584007,
         -0.0228456537778392,
         0.0112951935322615,
         -0.00412442152600398,
         0.15751834837627,
         -0.0949871380291956,
         0.0148708132936349,
         0.0515140083488931,
         -0.0946372762951955,
         0.114031118451203,
         -0.113560237767495,
         0.0989861166240974,
         -0.0765016772790008,
         0.0517834818964356,
         -0.02936750318388,
         0.0122350114725183,
         -0.128613192882607,
         -0.0525061161254233,
         0.111349196979563,
         -0.0971357456789407,
         0.0470256406669971,
         0.0124418150448359,
         -0.0639085736587209,
         0.0977583611400897,
         -0.110676829312075,
         0.104210763124088,
         -0.0833243892685604,
         0.0549441476920755,
         -0.0264306455984791,
         0.148509723064221,
         -0.0441139612200556,
         -0.0488704793362297,
         0.0959906870513473,
         -0.0963738849304854,
         0.0621132952209165,
         -0.00976016272278945,
         -0.0443098376851428,
         0.0866931606883229,
         -0.108643775743502,
         0.106949041632962,
         -0.0841017993022034,
         0.0476485239744665,
         -0.1347703776635,
         0.101077783247625,
         -0.0278207442037325,
         -0.0424968887345365,
         0.0866128520460851,
         -0.0956296739094701,
         0.0715711656172983,
         -0.0241775673739389,
         -0.0322367564985845,
         0.0819020533102153,
         -0.110692896616162,
         0.109176483932956,
         -0.0753389314522266,
         0.106545338634435,
         -0.119121309936167,
         0.0849937774690731,
         -0.0263554515752771,
         -0.0345073862338431,
         0.0791005751795972,
         -0.0953576116969908,
         0.0791005751795973,
         -0.034507386233843,
         -0.0263554515752772,
         0.0849937774690733,
         -0.119121309936167,
         0.106545338634435,
         -0.0753389314522265,
         0.109176483932955,
         -0.110692896616162,
         0.0819020533102151,
         -0.0322367564985845,
         -0.0241775673739389,
         0.0715711656172982,
         -0.0956296739094698,
         0.0866128520460851,
         -0.0424968887345364,
         -0.0278207442037326,
         0.101077783247625,
         -0.1347703776635,
         0.0476485239744663,
         -0.0841017993022033,
         0.106949041632962,
         -0.108643775743502,
         0.0866931606883228,
         -0.0443098376851428,
         -0.00976016272278931,
         0.0621132952209165,
         -0.0963738849304852,
         0.0959906870513471,
         -0.0488704793362299,
         -0.0441139612200554,
         0.148509723064221,
         -0.026430645598479,
         0.0549441476920756,
         -0.0833243892685604,
         0.104210763124088,
         -0.110676829312075,
         0.0977583611400897,
         -0.0639085736587209,
         0.012441815044836,
         0.0470256406669973,
         -0.0971357456789408,
         0.111349196979563,
         -0.0525061161254234,
         -0.128613192882607,
         0.0122350114725184,
         -0.0293675031838798,
         0.0517834818964356,
         -0.0765016772790009,
         0.0989861166240973,
         -0.113560237767495,
         0.114031118451203,
         -0.0946372762951952,
         0.0515140083488929,
         0.014870813293635,
         -0.0949871380291956,
         0.15751834837627,
         -0.00412442152600415,
         0.0112951935322615,
         -0.0228456537778392,
         0.0391276981584009,
         -0.0597685461934182,
         0.0834622326111988,
         -0.107749278980154,
         0.128785020872233,
         -0.141076922000991,
         0.137102124276771,
         -0.106198848810718},
        {-0.0454310850424254,
         0.0803115707754045,
         -0.107749278980154,
         0.12441815044836,
         -0.129114816600119,
         0.122489070039388,
         -0.10661305096325,
         0.0845254886300552,
         -0.0597685461934182,
         0.035916426326718,
         -0.0160623141550808,
         0.0952970479489329,
         -0.122115849510841,
         0.111282976814931,
         -0.073606770451819,
         0.0218243873196166,
         0.0316265418903323,
         -0.076286089357592,
         0.1047694586204,
         -0.113402843044913,
         0.102462341357028,
         -0.0760207456341352,
         0.04126483221472,
         -0.1347703776635,
         0.101077783247625,
         -0.0278207442037326,
         -0.0424968887345366,
         0.0866128520460853,
         -0.0956296739094695,
         0.0715711656172983,
         -0.0241775673739385,
         -0.0322367564985844,
         0.0819020533102153,
         -0.110692896616163,
         0.109176483932956,
         -0.0753389314522264,
         0.140273456458659,
         -0.0137549440715734,
         -0.0753389314522267,
         0.0981423606024251,
         -0.0673655515913998,
         0.00912979623696005,
         0.0492571122517114,
         -0.0859646839962254,
         0.0884065252007264,
         -0.0550602042916804,
         -0.00430382722000429,
         0.0699289152444596,
         -0.115082118718973,
         0.110895904418455,
         -0.0991883122823936,
         -0.0927821703332648,
         0.0996640383319665,
         -0.0307569899707454,
         -0.0437244880953368,
         0.0859342467738892,
         -0.0836770427400706,
         0.0436900891535829,
         0.0150773622598202,
         -0.068188533415118,
         0.0924529599386622,
         -0.0726842753958177,
         0.00853045418603532,
         0.0784152460201044,
         -0.135819190194834,
         0.135819190194834,
         -0.084231486039688,
         0.0934464436691147,
         -0.0491048714691375,
         -0.0151965527490724,
         0.0681267684265229,
         -0.0882839935753793,
         0.068126768426523,
         -0.0151965527490724,
         -0.0491048714691375,
         0.0934464436691147,
         -0.084231486039688,
         0.135819190194834,
         -0.135819190194834,
         0.0784152460201047,
         0.00853045418603542,
         -0.0726842753958175,
         0.0924529599386621,
         -0.0681885334151178,
         0.0150773622598202,
         0.0436900891535827,
         -0.0836770427400706,
         0.0859342467738892,
         -0.0437244880953367,
         -0.0307569899707454,
         0.0996640383319667,
         -0.0927821703332649,
         -0.0991883122823935,
         0.110895904418455,
         -0.115082118718973,
         0.0699289152444596,
         -0.00430382722000427,
         -0.0550602042916805,
         0.0884065252007264,
         -0.0859646839962252,
         0.0492571122517114,
         0.00912979623696004,
         -0.0673655515913996,
         0.098142360602425,
         -0.0753389314522267,
         -0.0137549440715734,
         0.140273456458659,
         -0.0753389314522263,
         0.109176483932956,
         -0.110692896616162,
         0.0819020533102152,
         -0.0322367564985844,
         -0.0241775673739384,
         0.0715711656172983,
         -0.0956296739094694,
         0.0866128520460854,
         -0.0424968887345365,
         -0.0278207442037325,
         0.101077783247625,
         -0.1347703776635,
         0.0412648322147198,
         -0.0760207456341352,
         0.102462341357028,
         -0.113402843044913,
         0.1047694586204,
         -0.0762860893575919,
         0.0316265418903324,
         0.0218243873196166,
         -0.0736067704518189,
         0.111282976814931,
         -0.122115849510841,
         0.0952970479489328,
         -0.016062314155081,
         0.0359164263267179,
         -0.059768546193418,
         0.0845254886300551,
         -0.10661305096325,
         0.122489070039388,
         -0.129114816600119,
         0.12441815044836,
         -0.107749278980154,
         0.0803115707754044,
         -0.0454310850424254},
        {0.092031467870977,
         -0.123473170937156,
         0.132863944399817,
         -0.12784839010805,
         0.113929892405108,
         -0.0953205868026814,
         0.0751898928662049,
         -0.0558140205685406,
         0.0387000602018604,
         -0.0247016578060423,
         0.0141312639662446,
         -0.00687023100933292,
         0.00247356587275816,
         -0.148396282986015,
         0.104121720022592,
         -0.0380042401334497,
         -0.0228702152876408,
         0.0686386673653622,
         -0.0966727193994061,
         0.108029998376373,
         -0.105681533049564,
         0.0934588425722696,
         -0.0753667411533045,
         0.0551139424321573,
         -0.0357901857519841,
         0.0196511203841002,
         -0.00797701024942848,
         0.130873220089121,
         0.0312846833692469,
         -0.0975392399776292,
         0.101582214219418,
         -0.0699460705532743,
         0.0227390454168125,
         0.0256197655877728,
         -0.0656652931307364,
         0.0921513271014775,
         -0.103315240997655,
         0.100142469182892,
         -0.0856303460707727,
         0.0640499855033926,
         -0.0402003530015261,
         0.0186130239153333,
         -0.143364429632299,
         0.0621563631046528,
         0.0218965640766104,
         -0.076280918455099,
         0.094882483854973,
         -0.0824636204856441,
         0.0485348671456553,
         -0.00407026922248807,
         -0.0405096233699009,
         0.0766415127391448,
         -0.0984481812624721,
         0.103204503887996,
         -0.0914888230838053,
         0.0670179643603151,
         -0.0360439658233229,
         0.123063320366542,
         -0.107418472543291,
         0.0523711008891351,
         0.00999679745746631,
         -0.0599127407243178,
         0.08687347405026,
         -0.0877825065385291,
         0.0652831088381555,
         -0.0261417774103227,
         -0.0203513461124415,
         0.0639746973946276,
         -0.0951621223473311,
         0.106579788977455,
         -0.0946657498596745,
         0.0609254221457412,
         -0.0917259832921406,
         0.112968535441253,
         -0.096472592571329,
         0.0552429711582656,
         -0.00386735078418204,
         -0.0439770148965804,
         0.0773618886797764,
         -0.089291168686082,
         0.0773618886797764,
         -0.0439770148965803,
         -0.00386735078418211,
         0.0552429711582657,
         -0.096472592571329,
         0.112968535441254,
         -0.0917259832921408,
         0.0609254221457413,
         -0.0946657498596745,
         0.106579788977455,
         -0.095162122347331,
         0.0639746973946277,
         -0.0203513461124417,
         -0.0261417774103226,
         0.0652831088381556,
         -0.087782506538529,
         0.0868734740502603,
         -0.0599127407243178,
         0.00999679745746642,
         0.052371100889135,
         -0.107418472543291,
         0.123063320366542,
         -0.0360439658233228,
         0.0670179643603154,
         -0.0914888230838053,
         0.103204503887996,
         -0.0984481812624722,
         0.0766415127391448,
         -0.040509623369901,
         -0.00407026922248803,
         0.0485348671456551,
         -0.0824636204856441,
         0.0948824838549729,
         -0.0762809184550989,
         0.0218965640766105,
         0.0621563631046527,
         -0.143364429632299,
         0.018613023915333,
         -0.0402003530015261,
         0.0640499855033929,
         -0.0856303460707727,
         0.100142469182892,
         -0.103315240997655,
         0.0921513271014775,
         -0.0656652931307365,
         0.0256197655877729,
         0.0227390454168125,
         -0.0699460705532743,
         0.101582214219418,
         -0.0975392399776292,
         0.0312846833692471,
         0.130873220089121,
         -0.00797701024942852,
         0.0196511203841003,
         -0.035790185751984,
         0.0551139424321574,
         -0.0753667411533045,
         0.0934588425722696,
         -0.105681533049564,
         0.108029998376373,
         -0.0966727193994061,
         0.0686386673653623,
         -0.0228702152876408,
         -0.0380042401334497,
         0.104121720022591,
         -0.148396282986015,
         0.00247356587275811,
         -0.00687023100933286,
         0.0141312639662446,
         -0.0247016578060424,
         0.0387000602018605,
         -0.0558140205685406,
         0.0751898928662049,
         -0.0953205868026816,
         0.113929892405108,
         -0.127848390108049,
         0.132863944399817,
         -0.123473170937156,
         0.0920314678709771},
        {0.0353295872871769,
         -0.0645027063484485,
         0.0898691110864764,
         -0.108527262216607,
         0.118885659240627,
         -0.120572064880105,
         0.114221646768613,
         -0.101246668550439,
         0.0836016850603437,
         -0.0635470578684543,
         0.0434109048866424,
         -0.0253465077145106,
         0.0110621228766216,
         -0.0805638544074683,
         0.110599102307596,
         -0.111940812949691,
         0.0902427888358345,
         -0.0531672831223835,
         0.00898691110864764,
         0.0345373796217161,
         -0.0709383821097491,
         0.0955646860161939,
         -0.105895467743102,
         0.101675292589527,
         -0.0848761157015402,
         0.0594685568795227,
         -0.0308948278485624,
         0.123063320366542,
         -0.107418472543291,
         0.0523711008891352,
         0.00999679745746658,
         -0.059912740724318,
         0.0868734740502605,
         -0.0877825065385285,
         0.0652831088381549,
         -0.0261417774103223,
         -0.0203513461124413,
         0.0639746973946273,
         -0.0951621223473309,
         0.106579788977454,
         -0.0946657498596744,
         0.0609254221457414,
         -0.137588974938211,
         0.0355253205704956,
         0.0507653823686893,
         -0.0898702457903117,
         0.0835477159357171,
         -0.0460442178341837,
         -0.00456962124247291,
         0.0511523706259751,
         -0.0803620518174732,
         0.0843722237920326,
         -0.0617426659103372,
         0.0175726323583926,
         0.0370402208009439,
         -0.0862999211295605,
         0.111927147465546,
         -0.0963315506939027,
         0.104007488808801,
         0.0735444006308874,
         -0.101321638326391,
         0.0560050128896789,
         0.00925523601947709,
         -0.0614088986672929,
         0.0840751195374801,
         -0.0741114604382662,
         0.0381825098157658,
         0.0106723359374509,
         -0.0564726935972654,
         0.0837343479108539,
         -0.0809140044262648,
         0.0438735563718572,
         0.0205965518990419,
         -0.0910247594804559,
         0.12612760653351,
         -0.134273090679114,
         0.0230276450741794,
         0.0618968364467098,
         -0.0913881332186123,
         0.0727076908010356,
         -0.0256846810442772,
         -0.0274774577121419,
         0.0677784362900637,
         -0.0826675587017555,
         0.0677784362900636,
         -0.027477457712142,
         -0.025684681044277,
         0.0727076908010357,
         -0.0913881332186123,
         0.0618968364467098,
         0.0230276450741794,
         -0.134273090679114,
         0.12612760653351,
         -0.091024759480456,
         0.0205965518990417,
         0.0438735563718573,
         -0.0809140044262649,
         0.0837343479108539,
         -0.0564726935972653,
         0.0106723359374509,
         0.0381825098157656,
         -0.0741114604382661,
         0.0840751195374802,
         -0.0614088986672932,
         0.0092552360194772,
         0.0560050128896789,
         -0.101321638326391,
         0.0735444006308875,
         0.104007488808801,
         -0.0963315506939026,
         0.111927147465546,
         -0.0862999211295607,
         0.0370402208009439,
         0.0175726323583926,
         -0.0617426659103374,
         0.0843722237920325,
         -0.0803620518174731,
         0.0511523706259753,
         -0.00456962124247289,
         -0.0460442178341837,
         0.0835477159357169,
         -0.0898702457903116,
         0.0507653823686895,
         0.0355253205704956,
         -0.137588974938211,
         0.0609254221457415,
         -0.0946657498596746,
         0.106579788977455,
         -0.0951621223473309,
         0.0639746973946275,
         -0.0203513461124413,
         -0.0261417774103221,
         0.0652831088381549,
         -0.0877825065385283,
         0.0868734740502607,
         -0.0599127407243181,
         0.00999679745746661,
         0.0523711008891351,
         -0.107418472543291,
         0.123063320366541,
         -0.0308948278485626,
         0.0594685568795228,
         -0.08487611570154,
         0.101675292589527,
         -0.105895467743102,
         0.095564686016194,
         -0.0709383821097489,
         0.0345373796217161,
         0.00898691110864762,
         -0.0531672831223834,
         0.0902427888358345,
         -0.11194081294969,
         0.110599102307596,
         -0.0805638544074682,
         0.0110621228766216,
         -0.0253465077145107,
         0.0434109048866425,
         -0.0635470578684547,
         0.0836016850603439,
         -0.101246668550439,
         0.114221646768613,
         -0.120572064880104,
         0.118885659240627,
         -0.108527262216607,
         0.0898691110864765,
         -0.0645027063484487,
         0.0353295872871772},
        {0.0281160778557767,
         -0.052600365198089,
         0.0753605852376712,
         -0.0939911634753796,
         0.106923681923142,
         -0.113409690835931,
         0.113409690835931,
         -0.107467826312283,
         0.0965831661431314,
         -0.0820799081414007,
         0.065477115532837,
         -0.0483580546557775,
         0.0322387031038518,
         -0.0184331837179328,
         0.0078999358791139,
         -0.0688700443150183,
         0.0994053465609429,
         -0.107933672010026,
         0.0972900971953141,
         -0.0720879316466458,
         0.0378032302786435,
         -0.0362273968594828,
         0.066648716567615,
         -0.088167964619771,
         0.0989920938661321,
         -0.0987104657168963,
         0.0882893245734565,
         -0.0699775822022646,
         0.0471061163829025,
         -0.0236998076373422,
         0.112464311423107,
         -0.108893101296094,
         0.0684154515958093,
         -0.0155788836474024,
         -0.0333702280347471,
         0.0683886167441801,
         -0.084530592672126,
         0.0810069220256653,
         -0.0602860324400518,
         0.0272092246003402,
         0.0118885659240623,
         -0.0500553420521211,
         0.0805967577596295,
         -0.0979482113309786,
         0.0985398606521682,
         -0.0816326707508443,
         0.0499635814945697,
         -0.133859305132245,
         0.0513327002339341,
         0.0288464872255669,
         -0.0760171684397888,
         0.0863822028484562,
         -0.067017964360315,
         0.0294297748578196,
         0.0139439315525745,
         -0.0518859554776098,
         0.0757842886207873,
         -0.0804929399667093,
         0.0647866521363425,
         -0.0314617527108147,
         -0.0129058100227255,
         0.058570084256389,
         -0.093659307022064,
         0.105770453160415,
         -0.0841012396737772,
         0.107326212393534,
         0.0565658806337604,
         -0.0975697035377839,
         0.0712177538167015,
         -0.0181180542548433,
         -0.0341565125049831,
         0.0691788172051459,
         -0.079778015802424,
         0.0661499503034551,
         -0.0339673312116066,
         -0.0075104595172421,
         0.0473282580642932,
         -0.0747273488788425,
         0.0810404843750363,
         -0.061593264545703,
         0.0176218577443751,
         0.0417597609625961,
         -0.0974003409668816,
         0.116793927158657,
         -0.131447228194865,
         0.0402080830954346,
         0.0408193690322228,
         -0.0815987568701483,
         0.0817615933808844,
         -0.0523866759380708,
         0.00846089706144872,
         0.0352437154887485,
         -0.0666775625834951,
         0.0780509848323145,
         -0.0666775625834951,
         0.0352437154887484,
         0.00846089706144869,
         -0.0523866759380707,
         0.0817615933808845,
         -0.0815987568701482,
         0.0408193690322227,
         0.0402080830954346,
         -0.131447228194865,
         0.116793927158657,
         -0.0974003409668815,
         0.0417597609625961,
         0.0176218577443751,
         -0.061593264545703,
         0.0810404843750363,
         -0.0747273488788426,
         0.0473282580642931,
         -0.00751045951724215,
         -0.0339673312116067,
         0.0661499503034552,
         -0.0797780158024239,
         0.0691788172051458,
         -0.0341565125049832,
         -0.0181180542548434,
         0.0712177538167014,
         -0.097569703537784,
         0.0565658806337602,
         0.107326212393534,
         -0.0841012396737773,
         0.105770453160415,
         -0.093659307022064,
         0.058570084256389,
         -0.0129058100227256,
         -0.0314617527108146,
         0.0647866521363426,
         -0.0804929399667092,
         0.0757842886207874,
         -0.0518859554776097,
         0.0139439315525746,
         0.0294297748578194,
         -0.0670179643603153,
         0.0863822028484561,
         -0.0760171684397886,
         0.0288464872255669,
         0.0513327002339342,
         -0.133859305132246,
         0.0499635814945699,
         -0.0816326707508446,
         0.0985398606521683,
         -0.0979482113309786,
         0.0805967577596292,
         -0.050055342052121,
         0.0118885659240624,
         0.0272092246003403,
         -0.0602860324400517,
         0.0810069220256652,
         -0.084530592672126,
         0.0683886167441797,
         -0.0333702280347471,
         -0.0155788836474026,
         0.0684154515958095,
         -0.108893101296094,
         0.112464311423107,
         -0.0236998076373421,
         0.0471061163829024,
         -0.0699775822022646,
         0.0882893245734566,
         -0.0987104657168964,
         0.098992093866132,
         -0.088167964619771,
         0.0666487165676153,
         -0.0362273968594827,
         0.0378032302786436,
         -0.0720879316466458,
         0.0972900971953142,
         -0.107933672010026,
         0.0994053465609431,
         -0.0688700443150182,
         0.00789993587911393,
         -0.0184331837179327,
         0.0322387031038518,
         -0.0483580546557776,
         0.0654771155328368,
         -0.0820799081414004,
         0.0965831661431314,
         -0.107467826312283,
         0.113409690835931,
         -0.113409690835931,
         0.106923681923142,
         -0.0939911634753795,
         0.075360585237671,
         -0.0526003651980888,
         0.0281160778557768},
        {0.0511827251162099,
         -0.0957541107531435,
         0.129114816600119,
         -0.141438195120055,
         0.129114816600119,
         -0.0957541107531435,
         0.0511827251162099,
         -0.0957541107531434,
         0.127956812790525,
         -0.106078646340041,
         0.0408296900131294,
         0.0408296900131295,
         -0.106078646340041,
         0.127956812790525,
         -0.0957541107531435,
         0.129114816600119,
         -0.106078646340041,
         0.0186119000422579,
         0.0688184284781719,
         -0.104459029912521,
         0.0688184284781717,
         0.0186119000422578,
         -0.106078646340041,
         0.129114816600119,
         -0.141438195120055,
         0.0408296900131293,
         0.0688184284781714,
         -0.100038962727138,
         0.0452320867794608,
         0.0452320867794607,
         -0.100038962727137,
         0.0688184284781713,
         0.0408296900131295,
         -0.141438195120055,
         0.129114816600119,
         0.0408296900131293,
         -0.104459029912521,
         0.0452320867794606,
         0.0511827251162093,
         -0.0953576116969899,
         0.0511827251162093,
         0.0452320867794608,
         -0.10445902991252,
         0.0408296900131294,
         0.129114816600119,
         -0.0957541107531436,
         -0.106078646340041,
         0.0688184284781714,
         0.0452320867794607,
         -0.0953576116969901,
         0.0465297501056457,
         0.0465297501056458,
         -0.0953576116969899,
         0.0452320867794606,
         0.0688184284781713,
         -0.106078646340041,
         -0.0957541107531436,
         0.05118272511621,
         0.127956812790525,
         0.018611900042258,
         -0.100038962727137,
         0.0511827251162094,
         0.0465297501056458,
         -0.093059500211292,
         0.0465297501056457,
         0.0511827251162094,
         -0.100038962727137,
         0.0186119000422579,
         0.127956812790525,
         0.05118272511621,
         -0.0957541107531437,
         -0.106078646340041,
         0.0688184284781715,
         0.0452320867794608,
         -0.0953576116969899,
         0.0465297501056459,
         0.0465297501056457,
         -0.09535761169699,
         0.0452320867794608,
         0.0688184284781712,
         -0.106078646340041,
         -0.0957541107531438,
         0.129114816600119,
         0.0408296900131295,
         -0.10445902991252,
         0.0452320867794608,
         0.0511827251162093,
         -0.09535761169699,
         0.0511827251162093,
         0.0452320867794609,
         -0.10445902991252,
         0.0408296900131295,
         0.129114816600119,
         -0.141438195120055,
         0.0408296900131294,
         0.0688184284781716,
         -0.100038962727138,
         0.0452320867794607,
         0.0452320867794608,
         -0.100038962727138,
         0.0688184284781714,
         0.0408296900131295,
         -0.141438195120055,
         0.129114816600119,
         -0.106078646340041,
         0.0186119000422579,
         0.0688184284781718,
         -0.104459029912521,
         0.0688184284781717,
         0.0186119000422579,
         -0.106078646340042,
         0.129114816600119,
         -0.0957541107531435,
         0.127956812790525,
         -0.106078646340041,
         0.0408296900131294,
         0.0408296900131295,
         -0.106078646340041,
         0.127956812790525,
         -0.0957541107531435,
         0.0511827251162099,
         -0.0957541107531434,
         0.129114816600119,
         -0.141438195120055,
         0.129114816600119,
         -0.0957541107531435,
         0.05118272511621},
        {0.0697502970338573,
         -0.110284903050138,
         0.130490857063205,
         -0.130490857063205,
         0.114448052633531,
         -0.0886510803711072,
         0.0597685461934182,
         -0.0335069588741643,
         0.0136791586790205,
         -0.120811058305662,
         0.120811058305662,
         -0.0697502970338577,
         0.0626857800899237,
         -0.10236545023242,
         0.113402843044913,
         -0.0989861166240975,
         0.0683957933951028,
         -0.0335069588741642,
         0.141076922000991,
         -0.051514008348893,
         -0.047025640666997,
         0.0963738849304853,
         -0.0866128520460854,
         0.0345073862338428,
         0.0322367564985844,
         -0.0866931606883228,
         0.110676829312075,
         -0.0989861166240974,
         0.0597685461934183,
         -0.120811058305662,
         -0.0515140083488931,
         0.103028016697786,
         -0.0556414884074656,
         -0.0244004068069731,
         0.0816593800262595,
         -0.0884065252007261,
         0.0457251404426216,
         0.0236276377183084,
         -0.0866931606883226,
         0.113402843044913,
         -0.088651080371107,
         0.0697502970338576,
         0.120811058305662,
         -0.0470256406669972,
         -0.0556414884074656,
         0.0925930336136547,
         -0.0567014215224567,
         -0.0150773622598208,
         0.0750784794904546,
         -0.0882927514736784,
         0.0457251404426216,
         0.0322367564985845,
         -0.10236545023242,
         0.114448052633531,
         -0.110284903050138,
         -0.0697502970338575,
         0.096373884930485,
         -0.0244004068069733,
         -0.0567014215224566,
         0.088283993575381,
         -0.0569870728090215,
         -0.0124355987991089,
         0.0750784794904547,
         -0.0884065252007261,
         0.0345073862338426,
         0.0626857800899237,
         -0.130490857063205,
         0.130490857063205,
         -0.0866128520460854,
         0.0816593800262591,
         -0.0150773622598207,
         -0.0569870728090215,
         0.0870491915937668,
         -0.0569870728090214,
         -0.0150773622598207,
         0.081659380026259,
         -0.0866128520460853,
         0.130490857063205,
         -0.130490857063205,
         0.0626857800899236,
         0.0345073862338427,
         -0.0884065252007261,
         0.0750784794904546,
         -0.012435598799109,
         -0.0569870728090215,
         0.0882839935753808,
         -0.0567014215224565,
         -0.0244004068069732,
         0.0963738849304852,
         -0.0697502970338575,
         -0.110284903050138,
         0.114448052633531,
         -0.10236545023242,
         0.0322367564985843,
         0.0457251404426215,
         -0.0882927514736783,
         0.0750784794904546,
         -0.0150773622598208,
         -0.0567014215224566,
         0.0925930336136547,
         -0.0556414884074657,
         -0.0470256406669971,
         0.120811058305662,
         0.0697502970338574,
         -0.0886510803711073,
         0.113402843044913,
         -0.0866931606883226,
         0.0236276377183084,
         0.0457251404426215,
         -0.0884065252007261,
         0.0816593800262593,
         -0.0244004068069731,
         -0.0556414884074655,
         0.103028016697786,
         -0.0515140083488931,
         -0.120811058305662,
         0.0597685461934181,
         -0.0989861166240974,
         0.110676829312075,
         -0.0866931606883228,
         0.0322367564985845,
         0.0345073862338427,
         -0.0866128520460853,
         0.0963738849304853,
         -0.0470256406669971,
         -0.0515140083488932,
         0.141076922000991,
         -0.0335069588741641,
         0.0683957933951026,
         -0.0989861166240972,
         0.113402843044913,
         -0.10236545023242,
         0.0626857800899234,
         -0.0697502970338577,
         0.120811058305662,
         -0.120811058305662,
         0.0136791586790204,
         -0.033506958874164,
         0.0597685461934181,
         -0.088651080371107,
         0.114448052633531,
         -0.130490857063205,
         0.130490857063205,
         -0.110284903050138,
         0.0697502970338576},
        {-0.11145564251507,
         0.136504726557987,
         -0.132863944399817,
         0.114351076438204,
         -0.0898691110864765,
         0.0651163573299636,
         -0.0434109048866425,
         0.0263109816195336,
         -0.0141312639662446,
         0.00637794062043443,
         -0.00210656445576765,
         0.150911653367635,
         -0.0719443078836193,
         -0.0127848390108053,
         0.0730714413802357,
         -0.104080297700328,
         0.110219497349189,
         -0.0990713827005223,
         0.0784850369901856,
         -0.0551139424321573,
         0.0337580194749178,
         -0.0172036097221034,
         0.00637794062043448,
         -0.11145564251507,
         -0.0719443078836193,
         0.109482820383054,
         -0.0734433086234724,
         0.0118750791744872,
         0.0461832195627368,
         -0.0860431231041581,
         0.103268818362078,
         -0.100142469182892,
         0.082692158481709,
         -0.0582816166095742,
         0.0337580194749178,
         -0.0141312639662445,
         0.136504726557987,
         -0.0127848390108053,
         -0.0734433086234723,
         0.0975637310403932,
         -0.0727197115816088,
         0.0218159134744824,
         0.0333243582838081,
         -0.0766415127391445,
         0.0994222548202482,
         -0.100061811648968,
         0.0826921584817091,
         -0.0551139424321571,
         0.0263109816195336,
         -0.132863944399817,
         0.0730714413802357,
         0.0118750791744871,
         -0.0727197115816087,
         0.0919839677553638,
         -0.0719888416593998,
         0.0261417774103221,
         0.0279467355859234,
         -0.0737297559518712,
         0.099422254820248,
         -0.100142469182892,
         0.0784850369901857,
         -0.0434109048866425,
         0.114351076438204,
         -0.104080297700329,
         0.0461832195627368,
         0.0218159134744823,
         -0.0719888416593999,
         0.0892911686860821,
         -0.0715922059045617,
         0.0273853379249811,
         0.0279467355859234,
         -0.0766415127391447,
         0.103268818362078,
         -0.0990713827005226,
         0.0651163573299637,
         -0.0898691110864764,
         0.110219497349189,
         -0.0860431231041581,
         0.033324358283808,
         0.0261417774103222,
         -0.0715922059045617,
         0.0884757071422455,
         -0.0715922059045617,
         0.0261417774103222,
         0.033324358283808,
         -0.086043123104158,
         0.110219497349189,
         -0.0898691110864764,
         0.0651163573299638,
         -0.0990713827005226,
         0.103268818362078,
         -0.0766415127391447,
         0.0279467355859235,
         0.027385337924981,
         -0.0715922059045617,
         0.0892911686860819,
         -0.0719888416593998,
         0.0218159134744824,
         0.0461832195627368,
         -0.104080297700329,
         0.114351076438204,
         -0.0434109048866425,
         0.0784850369901855,
         -0.100142469182892,
         0.0994222548202482,
         -0.0737297559518715,
         0.0279467355859234,
         0.0261417774103222,
         -0.0719888416593998,
         0.0919839677553638,
         -0.0727197115816085,
         0.0118750791744871,
         0.0730714413802355,
         -0.132863944399817,
         0.0263109816195334,
         -0.0551139424321573,
         0.082692158481709,
         -0.100061811648968,
         0.0994222548202481,
         -0.0766415127391446,
         0.033324358283808,
         0.0218159134744823,
         -0.0727197115816087,
         0.0975637310403931,
         -0.0734433086234725,
         -0.0127848390108053,
         0.136504726557987,
         -0.0141312639662447,
         0.0337580194749176,
         -0.0582816166095741,
         0.0826921584817089,
         -0.100142469182892,
         0.103268818362078,
         -0.086043123104158,
         0.0461832195627366,
         0.0118750791744872,
         -0.0734433086234725,
         0.109482820383054,
         -0.0719443078836195,
         -0.11145564251507,
         0.00637794062043443,
         -0.0172036097221032,
         0.0337580194749178,
         -0.0551139424321572,
         0.0784850369901855,
         -0.0990713827005225,
         0.110219497349189,
         -0.104080297700329,
         0.0730714413802358,
         -0.0127848390108053,
         -0.0719443078836192,
         0.150911653367635,
         -0.0021065644557677,
         0.00637794062043433,
         -0.0141312639662445,
         0.0263109816195337,
         -0.0434109048866425,
         0.0651163573299637,
         -0.0898691110864763,
         0.114351076438204,
         -0.132863944399817,
         0.136504726557987,
         -0.11145564251507},
        {-0.0336925944158749,
         0.06738518883175,
         -0.0988944203407531,
         0.121120434121582,
         -0.129114816600119,
         0.121120434121582,
         -0.0988944203407533,
         0.0673851888317502,
         -0.0336925944158749,
         0.0714727859617,
         -0.109176483932955,
         0.114448052633531,
         -0.0856450803076293,
         0.0316265418903323,
         0.0316265418903324,
         -0.0856450803076291,
         0.114448052633531,
         -0.109176483932955,
         0.0714727859616997,
         -0.107749278980154,
         0.114031118451203,
         -0.0639085736587207,
         -0.00976016272278948,
         0.0715711656172986,
         -0.0953576116969901,
         0.0715711656172987,
         -0.0097601627227895,
         -0.0639085736587209,
         0.114031118451203,
         -0.107749278980154,
         0.130490857063205,
         -0.0736067704518193,
         -0.0204148450065646,
         0.0833432557401472,
         -0.0859646839962253,
         0.0355376836544169,
         0.0355376836544166,
         -0.0859646839962252,
         0.0833432557401475,
         -0.0204148450065646,
         -0.0736067704518193,
         0.130490857063205,
         -0.130490857063205,
         0.0866128520460854,
         -0.081659380026259,
         0.0150773622598214,
         0.0569870728090214,
         -0.0870491915937658,
         0.0569870728090215,
         0.0150773622598214,
         -0.081659380026259,
         0.0866128520460853,
         -0.130490857063204,
         0.105205092343994,
         0.0771994321350969,
         -0.0908403255911861,
         0.00912979623695994,
         0.0681267684265238,
         -0.0842850173358695,
         0.0367849973230753,
         0.0367849973230753,
         -0.0842850173358695,
         0.0681267684265237,
         0.00912979623695994,
         -0.0908403255911863,
         0.0771994321350968,
         0.105205092343994,
         -0.0607401883849242,
         -0.12148037676985,
         0.0233616109172787,
         0.0747571549352915,
         -0.0836770427400702,
         0.0212378281066169,
         0.0530945702665437,
         -0.0849513124264685,
         0.0530945702665436,
         0.0212378281066169,
         -0.0836770427400702,
         0.0747571549352917,
         0.0233616109172787,
         -0.12148037676985,
         -0.0607401883849243,
         0.105205092343994,
         0.0771994321350967,
         -0.0908403255911861,
         0.00912979623696002,
         0.0681267684265236,
         -0.0842850173358695,
         0.0367849973230754,
         0.0367849973230755,
         -0.0842850173358695,
         0.0681267684265234,
         0.00912979623696004,
         -0.090840325591186,
         0.0771994321350968,
         0.105205092343994,
         -0.130490857063205,
         0.0866128520460854,
         -0.0816593800262588,
         0.0150773622598212,
         0.0569870728090215,
         -0.0870491915937657,
         0.0569870728090215,
         0.0150773622598213,
         -0.0816593800262591,
         0.0866128520460853,
         -0.130490857063205,
         0.130490857063205,
         -0.0736067704518193,
         -0.0204148450065644,
         0.0833432557401474,
         -0.0859646839962251,
         0.0355376836544167,
         0.0355376836544168,
         -0.085964683996225,
         0.0833432557401475,
         -0.0204148450065644,
         -0.0736067704518192,
         0.130490857063205,
         -0.107749278980154,
         0.114031118451203,
         -0.0639085736587209,
         -0.00976016272278945,
         0.0715711656172988,
         -0.0953576116969904,
         0.0715711656172986,
         -0.0097601627227894,
         -0.0639085736587207,
         0.114031118451203,
         -0.107749278980154,
         0.0714727859616996,
         -0.109176483932956,
         0.114448052633531,
         -0.085645080307629,
         0.0316265418903323,
         0.0316265418903323,
         -0.0856450803076291,
         0.114448052633531,
         -0.109176483932955,
         0.0714727859616997,
         -0.033692594415875,
         0.06738518883175,
         -0.0988944203407532,
         0.121120434121582,
         -0.129114816600119,
         0.121120434121582,
         -0.0988944203407533,
         0.0673851888317501,
         -0.033692594415875},
        {0.0542414781655111,
         -0.0904024636091848,
         0.113929892405108,
         -0.123058348412502,
         0.118885659240627,
         -0.104418471172916,
         0.083601685060344,
         -0.060506457425641,
         0.0387000602018603,
         -0.020800657348138,
         0.00820388989416684,
         -0.103864523120867,
         0.118101283910949,
         -0.0895117772216726,
         0.0379766308017028,
         0.0183444554832806,
         -0.0656311191533342,
         0.0955646860161942,
         -0.105328222788388,
         0.0968217907591954,
         -0.0753667411533047,
         0.0481037323488234,
         -0.0222162388558718,
         0.132863944399816,
         -0.0730714413802357,
         -0.011875079174487,
         0.0727197115816083,
         -0.0919839677553641,
         0.0719888416593996,
         -0.0261417774103217,
         -0.0279467355859231,
         0.0737297559518711,
         -0.099422254820248,
         0.100142469182892,
         -0.0784850369901856,
         0.0434109048866425,
         -0.123689600850734,
         -0.0228702152876408,
         0.0921719247477723,
         -0.0788598249310411,
         0.0205682404741143,
         0.0421523494961333,
         -0.0803620518174734,
         0.0812380406751381,
         -0.0473203965184257,
         -0.00729735333361682,
         0.0625038180802577,
         -0.0984481812624717,
         0.101675292589527,
         -0.0699979808565971,
         0.0771340181150449,
         0.10689770119577,
         -0.069946070553274,
         -0.0192481543532443,
         0.0775676923537156,
         -0.0803069148972137,
         0.0381825098157657,
         0.0214334234921218,
         -0.0690579824784571,
         0.0834201297684549,
         -0.0575624421329896,
         0.000725216804880159,
         0.0639746973946274,
         -0.106010568005546,
         0.0976075208680202,
         -0.114984605255294,
         -0.042162485927564,
         0.0948824838549731,
         -0.0577796037448273,
         -0.0128265514838186,
         0.0677784362900633,
         -0.0806920821664054,
         0.0499196022253792,
         0.00666154171817843,
         -0.0607734278725513,
         0.0846182854502418,
         -0.0617426659103371,
         -0.00386735078418183,
         0.0824934115551103,
         -0.119544310592355,
         0.12779824364991,
         -0.0295795456716792,
         -0.059912740724318,
         0.0877215416772395,
         -0.0564726935972652,
         -0.00435696290172034,
         0.0591590913433584,
         -0.0807669009883807,
         0.0591590913433582,
         -0.0043569629017203,
         -0.0564726935972651,
         0.0877215416772395,
         -0.059912740724318,
         -0.0295795456716793,
         0.12779824364991,
         -0.119544310592356,
         0.0824934115551104,
         -0.00386735078418163,
         -0.061742665910337,
         0.0846182854502414,
         -0.0607734278725514,
         0.00666154171817848,
         0.049919602225379,
         -0.0806920821664054,
         0.0677784362900635,
         -0.0128265514838186,
         -0.0577796037448271,
         0.094882483854973,
         -0.0421624859275642,
         -0.114984605255294,
         0.0976075208680205,
         -0.106010568005546,
         0.0639746973946275,
         0.000725216804880194,
         -0.0575624421329895,
         0.0834201297684552,
         -0.0690579824784572,
         0.0214334234921218,
         0.0381825098157658,
         -0.0803069148972136,
         0.0775676923537153,
         -0.0192481543532445,
         -0.069946070553274,
         0.10689770119577,
         0.077134018115045,
         -0.0699979808565972,
         0.101675292589527,
         -0.0984481812624717,
         0.062503818080258,
         -0.00729735333361681,
         -0.0473203965184256,
         0.0812380406751381,
         -0.0803620518174734,
         0.0421523494961333,
         0.0205682404741142,
         -0.078859824931041,
         0.0921719247477722,
         -0.0228702152876408,
         -0.123689600850734,
         0.0434109048866425,
         -0.0784850369901853,
         0.100142469182892,
         -0.0994222548202479,
         0.0737297559518711,
         -0.0279467355859231,
         -0.0261417774103218,
         0.0719888416593997,
         -0.0919839677553641,
         0.0727197115816085,
         -0.0118750791744873,
         -0.0730714413802354,
         0.132863944399816,
         -0.0222162388558718,
         0.0481037323488234,
         -0.0753667411533046,
         0.0968217907591951,
         -0.105328222788388,
         0.0955646860161938,
         -0.0656311191533343,
         0.0183444554832805,
         0.0379766308017027,
         -0.0895117772216723,
         0.118101283910949,
         -0.103864523120867,
         0.00820388989416681,
         -0.0208006573481381,
         0.0387000602018602,
         -0.0605064574256407,
         0.0836016850603437,
         -0.104418471172916,
         0.118885659240627,
         -0.123058348412502,
         0.113929892405107,
         -0.0904024636091849,
         0.054241478165511},
        {0.0232041047050925,
         -0.0485348671456553,
         0.075189892866205,
         -0.0984466787300015,
         0.114221646768614,
         -0.119796673783487,
         0.114221646768614,
         -0.0984466787300012,
         0.075189892866205,
         -0.0485348671456552,
         0.0232041047050923,
         -0.0544184492006793,
         0.0904290486600783,
         -0.107436508279762,
         0.100476720733421,
         -0.0709383821097493,
         0.025540736667659,
         0.025540736667659,
         -0.0709383821097493,
         0.100476720733421,
         -0.107436508279762,
         0.0904290486600783,
         -0.0544184492006794,
         0.0898691110864761,
         -0.110219497349189,
         0.0860431231041576,
         -0.0333243582838079,
         -0.0261417774103223,
         0.0715922059045624,
         -0.0884757071422452,
         0.0715922059045624,
         -0.0261417774103223,
         -0.0333243582838081,
         0.0860431231041577,
         -0.110219497349189,
         0.0898691110864761,
         -0.118318182686717,
         0.0902427888358349,
         -0.0174030785288194,
         -0.0509037981071258,
         0.0843722237920321,
         -0.0739401123164324,
         0.0289604732245776,
         0.0289604732245776,
         -0.0739401123164325,
         0.0843722237920325,
         -0.0509037981071257,
         -0.0174030785288193,
         0.090242788835835,
         -0.118318182686717,
         0.12779824364991,
         -0.0295795456716795,
         -0.0599127407243179,
         0.0877215416772392,
         -0.0564726935972651,
         -0.00435696290171982,
         0.0591590913433589,
         -0.0807669009883809,
         0.059159091343359,
         -0.00435696290171982,
         -0.0564726935972652,
         0.0877215416772391,
         -0.0599127407243179,
         -0.0295795456716793,
         0.12779824364991,
         -0.110676525559856,
         -0.050516691362858,
         0.0939276726082793,
         -0.0460442178341834,
         -0.0274774577121427,
         0.0749283620116624,
         -0.0737736296575991,
         0.0301000468236693,
         0.0301000468236693,
         -0.0737736296575992,
         0.0749283620116624,
         -0.0274774577121425,
         -0.0460442178341834,
         0.0939276726082794,
         -0.050516691362858,
         -0.110676525559856,
         0.0683110346242033,
         0.11100543126433,
         -0.0512332759681526,
         -0.0426943966401273,
         0.0840751195374796,
         -0.0610858290389507,
         0.00131367374277311,
         0.0558311340678599,
         -0.0788204245663885,
         0.0558311340678601,
         0.00131367374277302,
         -0.0610858290389508,
         0.0840751195374796,
         -0.0426943966401271,
         -0.0512332759681526,
         0.11100543126433,
         0.0683110346242031,
         -0.110676525559856,
         -0.050516691362858,
         0.0939276726082793,
         -0.0460442178341835,
         -0.0274774577121427,
         0.0749283620116623,
         -0.073773629657599,
         0.0301000468236693,
         0.0301000468236693,
         -0.0737736296575994,
         0.0749283620116624,
         -0.0274774577121426,
         -0.0460442178341834,
         0.0939276726082794,
         -0.050516691362858,
         -0.110676525559855,
         0.12779824364991,
         -0.0295795456716793,
         -0.0599127407243178,
         0.0877215416772392,
         -0.0564726935972652,
         -0.00435696290171974,
         0.0591590913433589,
         -0.0807669009883808,
         0.0591590913433589,
         -0.00435696290171979,
         -0.0564726935972655,
         0.0877215416772392,
         -0.0599127407243178,
         -0.0295795456716793,
         0.12779824364991,
         -0.118318182686717,
         0.0902427888358348,
         -0.0174030785288192,
         -0.0509037981071258,
         0.0843722237920324,
         -0.0739401123164324,
         0.0289604732245776,
         0.0289604732245776,
         -0.0739401123164323,
         0.0843722237920324,
         -0.0509037981071258,
         -0.0174030785288192,
         0.0902427888358348,
         -0.118318182686717,
         0.0898691110864762,
         -0.110219497349189,
         0.0860431231041577,
         -0.0333243582838082,
         -0.0261417774103223,
         0.0715922059045626,
         -0.0884757071422451,
         0.0715922059045625,
         -0.0261417774103222,
         -0.033324358283808,
         0.0860431231041576,
         -0.110219497349189,
         0.0898691110864762,
         -0.0544184492006793,
         0.0904290486600785,
         -0.107436508279762,
         0.100476720733421,
         -0.0709383821097496,
         0.025540736667659,
         0.025540736667659,
         -0.0709383821097498,
         0.100476720733421,
         -0.107436508279762,
         0.0904290486600784,
         -0.0544184492006792,
         0.0232041047050923,
         -0.0485348671456553,
         0.0751898928662049,
         -0.0984466787300014,
         0.114221646768614,
         -0.119796673783488,
         0.114221646768614,
         -0.0984466787300016,
         0.0751898928662049,
         -0.0485348671456553,
         0.0232041047050923},
        {0.0431665847301717,
         -0.0747667179418839,
         0.0985345383447483,
         -0.112186507018355,
         0.115438963354368,
         -0.109515016478554,
         0.0965831661431314,
         -0.0792611497871731,
         0.0602031650023388,
         -0.0417742938818727,
         0.0258129369312473,
         -0.0134803666629713,
         0.00518859554776092,
         -0.0898584117458722,
         0.111455642515071,
         -0.098035626084059,
         0.0619328357730291,
         -0.0157092531474469,
         -0.0298062121716608,
         0.0666487165676157,
         -0.0901255142069045,
         0.0987201375643018,
         -0.0936493677814159,
         0.0781863725920591,
         -0.0568382164655908,
         0.0344498259164824,
         -0.0152748117033062,
         0.124157238060637,
         -0.0856766339287157,
         0.0154190960014323,
         0.0463214896840549,
         -0.0808623851364091,
         0.0838778370140442,
         -0.0602860324400524,
         0.020095344146684,
         0.0249652330070317,
         -0.064072119773049,
         0.0892016670002503,
         -0.0962967622197165,
         0.0857046849146065,
         -0.0618754151494962,
         0.0322387031038517,
         -0.124157238060638,
         0.0761256869367768,
         -0.0861953670269939,
         0.0501991983285122,
         0.00392220956373539,
         -0.0518859554776092,
         0.0778289332164143,
         -0.0755505179225036,
         0.047666112373758,
         -0.00346143861378767,
         -0.0440276094568058,
         0.0813031092003281,
         -0.0976980239202575,
         0.0882893245734567,
         -0.0558390717459995,
         0.0827714920404252,
         0.092541341400737,
         -0.0822251395875708,
         0.0103593938507761,
         0.0536573145239622,
         -0.0801432434401667,
         0.066149950303454,
         -0.0244592739777072,
         -0.0254391826405524,
         0.0643901175075797,
         -0.0786342573201664,
         0.0628900451424085,
         -0.0214561198438233,
         -0.0326627868137396,
         0.0805967577596294,
         -0.102371631534332,
         0.0832399734830288,
         -0.117056566621426,
         -0.0189890825900157,
         0.0849217590032642,
         -0.0746857484587202,
         0.0222721244597259,
         0.0352437154887488,
         -0.0711844718136277,
         0.0735696392346901,
         -0.0445875653655165,
         -0.00275558529005778,
         0.049616437925926,
         -0.07706061636236,
         0.0718382605321351,
         -0.0314617527108149,
         -0.0322387031038521,
         0.0921297680024363,
         -0.108531647067913,
         0.123063320366542,
         -0.050240390158447,
         -0.0333702280347471,
         0.078293993252212,
         -0.0747273488788425,
         0.0353987932051896,
         0.0170372899767638,
         -0.0595950522245381,
         0.0757660690535999,
         -0.059595052224538,
         0.0170372899767638,
         0.0353987932051894,
         -0.0747273488788425,
         0.078293993252212,
         -0.0333702280347471,
         -0.0502403901584469,
         0.123063320366542,
         -0.108531647067913,
         0.0921297680024364,
         -0.0322387031038521,
         -0.0314617527108149,
         0.0718382605321348,
         -0.0770606163623602,
         0.0496164379259259,
         -0.00275558529005786,
         -0.0445875653655165,
         0.0735696392346899,
         -0.0711844718136275,
         0.0352437154887488,
         0.0222721244597257,
         -0.0746857484587203,
         0.0849217590032642,
         -0.0189890825900157,
         -0.117056566621426,
         0.0832399734830287,
         -0.102371631534332,
         0.0805967577596293,
         -0.0326627868137397,
         -0.0214561198438235,
         0.0628900451424086,
         -0.0786342573201662,
         0.0643901175075795,
         -0.0254391826405522,
         -0.024459273977707,
         0.066149950303454,
         -0.0801432434401668,
         0.0536573145239622,
         0.0103593938507761,
         -0.0822251395875708,
         0.092541341400737,
         0.0827714920404252,
         -0.0558390717459996,
         0.0882893245734566,
         -0.0976980239202575,
         0.0813031092003282,
         -0.0440276094568058,
         -0.00346143861378756,
         0.0476661123737579,
         -0.0755505179225037,
         0.0778289332164144,
         -0.0518859554776092,
         0.00392220956373537,
         0.0501991983285123,
         -0.0861953670269939,
         0.0761256869367769,
         -0.124157238060638,
         0.0322387031038516,
         -0.0618754151494963,
         0.0857046849146065,
         -0.0962967622197165,
         0.0892016670002505,
         -0.0640721197730491,
         0.0249652330070318,
         0.0200953441466841,
         -0.0602860324400524,
         0.0838778370140444,
         -0.0808623851364092,
         0.0463214896840548,
         0.0154190960014323,
         -0.0856766339287154,
         0.124157238060637,
         -0.015274811703306,
         0.0344498259164826,
         -0.056838216465591,
         0.078186372592059,
         -0.093649367781416,
         0.098720137564302,
         -0.0901255142069046,
         0.0666487165676156,
         -0.0298062121716609,
         -0.0157092531474469,
         0.0619328357730289,
         -0.098035626084059,
         0.11145564251507,
         -0.0898584117458722,
         0.00518859554776096,
         -0.0134803666629713,
         0.0258129369312475,
         -0.0417742938818728,
         0.0602031650023385,
         -0.0792611497871731,
         0.0965831661431313,
         -0.109515016478554,
         0.115438963354368,
         -0.112186507018355,
         0.0985345383447484,
         -0.0747667179418841,
         0.0431665847301716},
        {-0.0165710452999834,
         0.0357975492302538,
         -0.0575910733275199,
         0.0788598249310415,
         -0.0965831661431322,
         0.108291346603002,
         -0.112379241337699,
         0.108291346603002,
         -0.0965831661431315,
         0.0788598249310417,
         -0.0575910733275198,
         0.035797549230254,
         -0.0165710452999833,
         0.0422480416726224,
         -0.074416110064091,
         0.0957011096202908,
         -0.10078437832316,
         0.0881679646197706,
         -0.0599838449108542,
         0.0212376803646901,
         0.02123768036469,
         -0.0599838449108544,
         0.0881679646197706,
         -0.10078437832316,
         0.0957011096202908,
         -0.0744161100640911,
         0.0422480416726223,
         -0.0753605852376712,
         0.101906110803918,
         -0.0944902163393613,
         0.0602088493878614,
         -0.0118885659240624,
         -0.0359476444345903,
         0.0704704848464722,
         -0.0829975702283018,
         0.0704704848464722,
         -0.0359476444345904,
         -0.0118885659240624,
         0.0602088493878613,
         -0.0944902163393614,
         0.101906110803918,
         -0.075360585237671,
         0.106575961711488,
         -0.097290097195315,
         0.0438735563718574,
         0.0187730450409071,
         -0.0647866521363425,
         0.0804232309902942,
         -0.0640946252129303,
         0.024230070296514,
         0.0242300702965141,
         -0.0640946252129303,
         0.0804232309902942,
         -0.0647866521363426,
         0.0187730450409071,
         0.0438735563718575,
         -0.0972900971953147,
         0.106575961711488,
         -0.123063320366542,
         0.050240390158447,
         0.0333702280347472,
         -0.0782939932522117,
         0.0747273488788423,
         -0.0353987932051895,
         -0.0170372899767634,
         0.0595950522245384,
         -0.0757660690536,
         0.0595950522245384,
         -0.0170372899767632,
         -0.0353987932051897,
         0.0747273488788424,
         -0.0782939932522117,
         0.033370228034747,
         0.0502403901584469,
         -0.123063320366542,
         0.113458775318141,
         0.0275177949876423,
         -0.0871893667044784,
         0.0670179643603155,
         -0.00846089706144772,
         -0.0475572657646046,
         0.0747021093876778,
         -0.0647031995580695,
         0.0252553563511994,
         0.0252553563511996,
         -0.0647031995580693,
         0.0747021093876779,
         -0.0475572657646041,
         -0.00846089706144767,
         0.0670179643603153,
         -0.0871893667044783,
         0.0275177949876424,
         0.113458775318141,
         -0.0742762037360524,
         -0.0990349383147372,
         0.0684506191293032,
         0.0131075653651851,
         -0.0691788172051464,
         0.0757325998877393,
         -0.0408351074838465,
         -0.0119872606331181,
         0.0566874194425997,
         -0.0739401123164325,
         0.0566874194425999,
         -0.0119872606331179,
         -0.0408351074838464,
         0.0757325998877392,
         -0.0691788172051464,
         0.0131075653651852,
         0.0684506191293031,
         -0.0990349383147373,
         -0.0742762037360524,
         0.113458775318141,
         0.0275177949876422,
         -0.0871893667044783,
         0.0670179643603153,
         -0.00846089706144768,
         -0.0475572657646045,
         0.0747021093876779,
         -0.0647031995580692,
         0.0252553563511994,
         0.0252553563511995,
         -0.0647031995580693,
         0.0747021093876783,
         -0.0475572657646044,
         -0.00846089706144768,
         0.0670179643603154,
         -0.0871893667044783,
         0.0275177949876423,
         0.113458775318141,
         -0.123063320366542,
         0.0502403901584472,
         0.033370228034747,
         -0.0782939932522116,
         0.0747273488788424,
         -0.0353987932051895,
         -0.0170372899767634,
         0.0595950522245382,
         -0.0757660690536,
         0.0595950522245381,
         -0.0170372899767632,
         -0.0353987932051894,
         0.0747273488788423,
         -0.0782939932522116,
         0.0333702280347471,
         0.0502403901584469,
         -0.123063320366542,
         0.106575961711488,
         -0.0972900971953145,
         0.0438735563718574,
         0.018773045040907,
         -0.0647866521363426,
         0.080423230990294,
         -0.0640946252129304,
         0.0242300702965138,
         0.0242300702965141,
         -0.0640946252129303,
         0.0804232309902941,
         -0.0647866521363425,
         0.0187730450409071,
         0.0438735563718574,
         -0.0972900971953148,
         0.106575961711488,
         -0.0753605852376709,
         0.101906110803918,
         -0.0944902163393615,
         0.0602088493878615,
         -0.0118885659240622,
         -0.0359476444345904,
         0.0704704848464719,
         -0.0829975702283019,
         0.0704704848464722,
         -0.0359476444345902,
         -0.0118885659240624,
         0.0602088493878615,
         -0.0944902163393612,
         0.101906110803918,
         -0.075360585237671,
         0.0422480416726224,
         -0.0744161100640914,
         0.0957011096202908,
         -0.100784378323159,
         0.0881679646197708,
         -0.0599838449108542,
         0.02123768036469,
         0.0212376803646902,
         -0.0599838449108539,
         0.088167964619771,
         -0.10078437832316,
         0.0957011096202908,
         -0.0744161100640911,
         0.0422480416726223,
         -0.0165710452999833,
         0.0357975492302536,
         -0.0575910733275197,
         0.0788598249310418,
         -0.0965831661431317,
         0.108291346603002,
         -0.112379241337699,
         0.108291346603002,
         -0.0965831661431317,
         0.0788598249310416,
         -0.0575910733275198,
         0.0357975492302538,
         -0.0165710452999833},
        {-0.0121919492659908,
         0.0269880301584246,
         -0.0446473881685945,
         0.0631409418725624,
         -0.0803069148972141,
         0.0941682048141732,
         -0.103156099952978,
         0.106267030787815,
         -0.103156099952978,
         0.0941682048141733,
         -0.0803069148972141,
         0.0631409418725621,
         -0.0446473881685944,
         0.0269880301584245,
         -0.0121919492659909,
         0.033389028164709,
         -0.0613849814044848,
         0.083412800225434,
         -0.094711412808843,
         0.0928357535604655,
         -0.077756835995552,
         0.051578049976489,
         -0.0180485577671664,
         -0.0180485577671665,
         0.0515780499764892,
         -0.0777568359955519,
         0.0928357535604654,
         -0.0947114128088433,
         0.083412800225434,
         -0.0613849814044849,
         0.0333890281647091,
         -0.063670378492635,
         0.0923220488143202,
         -0.0953736678036668,
         0.0752415791069843,
         -0.0391792845323915,
         -0.00316126492729715,
         0.0419389185070224,
         -0.0688703404532031,
         0.078483403569712,
         -0.0688703404532033,
         0.0419389185070224,
         -0.00316126492729721,
         -0.0391792845323917,
         0.0752415791069841,
         -0.0953736678036669,
         0.0923220488143201,
         -0.063670378492635,
         0.0958586394337839,
         -0.0987746280566599,
         0.0612870005257403,
         -0.00803384263423681,
         -0.0403317483363108,
         0.0699775822022637,
         -0.0748314434269499,
         0.05607658637064,
         -0.0206821928168731,
         -0.020682192816873,
         0.0560765863706399,
         -0.0748314434269499,
         0.0699775822022637,
         -0.0403317483363108,
         -0.00803384263423682,
         0.0612870005257399,
         -0.09877462805666,
         0.095858639433784,
         -0.117402377025102,
         0.0643039302013743,
         0.0101200171800078,
         -0.0623583190330955,
         0.0775854503268511,
         -0.0588159984335256,
         0.0189675895637855,
         0.0254428826162295,
         -0.0591590913433578,
         0.0716452175415214,
         -0.0591590913433578,
         0.0254428826162295,
         0.0189675895637855,
         -0.0588159984335255,
         0.077585450326851,
         -0.0623583190330952,
         0.0101200171800079,
         0.0643039302013741,
         -0.117402377025102,
         0.11442968244554,
         0.00830160169218724,
         -0.0758706063916949,
         0.0764295831029395,
         -0.0350728748052882,
         -0.0176607966317386,
         0.0576396784648555,
         -0.0714958959543523,
         0.0570788389597913,
         -0.021601845873509,
         -0.021601845873509,
         0.0570788389597912,
         -0.0714958959543522,
         0.0576396784648553,
         -0.0176607966317387,
         -0.0350728748052882,
         0.0764295831029396,
         -0.075870606391695,
         0.00830160169218734,
         0.11442968244554,
         -0.0789639828221494,
         -0.0868603811043647,
         0.0781327830029681,
         -0.0112211975589381,
         -0.0488452129036092,
         0.0742579250223761,
         -0.0621933041175054,
         0.0244592770320621,
         0.0209755719075565,
         -0.0565704818112867,
         0.0699185730251858,
         -0.0565704818112867,
         0.0209755719075568,
         0.0244592770320621,
         -0.0621933041175055,
         0.0742579250223764,
         -0.0488452129036094,
         -0.0112211975589381,
         0.078132783002968,
         -0.0868603811043648,
         -0.0789639828221495,
         0.11442968244554,
         0.00830160169218726,
         -0.0758706063916951,
         0.0764295831029397,
         -0.0350728748052882,
         -0.0176607966317384,
         0.0576396784648554,
         -0.0714958959543523,
         0.0570788389597912,
         -0.021601845873509,
         -0.0216018458735089,
         0.0570788389597913,
         -0.0714958959543524,
         0.0576396784648554,
         -0.0176607966317386,
         -0.0350728748052883,
         0.0764295831029395,
         -0.0758706063916951,
         0.00830160169218734,
         0.11442968244554,
         -0.117402377025102,
         0.0643039302013743,
         0.0101200171800079,
         -0.0623583190330953,
         0.0775854503268514,
         -0.0588159984335255,
         0.0189675895637855,
         0.0254428826162294,
         -0.0591590913433579,
         0.0716452175415212,
         -0.0591590913433579,
         0.0254428826162296,
         0.0189675895637855,
         -0.0588159984335257,
         0.0775854503268512,
         -0.0623583190330954,
         0.010120017180008,
         0.0643039302013743,
         -0.117402377025102,
         0.0958586394337838,
         -0.0987746280566599,
         0.06128700052574,
         -0.0080338426342369,
         -0.0403317483363108,
         0.0699775822022637,
         -0.0748314434269498,
         0.0560765863706401,
         -0.0206821928168727,
         -0.020682192816873,
         0.0560765863706399,
         -0.0748314434269498,
         0.0699775822022637,
         -0.0403317483363108,
         -0.00803384263423686,
         0.0612870005257402,
         -0.0987746280566597,
         0.0958586394337839,
         -0.0636703784926347,
         0.0923220488143203,
         -0.0953736678036669,
         0.075241579106984,
         -0.0391792845323915,
         -0.00316126492729712,
         0.0419389185070225,
         -0.0688703404532034,
         0.078483403569712,
         -0.0688703404532033,
         0.0419389185070225,
         -0.00316126492729715,
         -0.0391792845323916,
         0.075241579106984,
         -0.0953736678036668,
         0.0923220488143202,
         -0.0636703784926347,
         0.0333890281647088,
         -0.0613849814044851,
         0.0834128002254341,
         -0.0947114128088432,
         0.0928357535604655,
         -0.077756835995552,
         0.051578049976489,
         -0.0180485577671665,
         -0.0180485577671665,
         0.051578049976489,
         -0.0777568359955522,
         0.0928357535604656,
         -0.094711412808843,
         0.0834128002254342,
         -0.061384981404485,
         0.0333890281647088,
         -0.012191949265991,
         0.0269880301584244,
         -0.0446473881685946,
         0.0631409418725621,
         -0.0803069148972141,
         0.0941682048141732,
         -0.103156099952978,
         0.106267030787815,
         -0.103156099952978,
         0.0941682048141731,
         -0.0803069148972141,
         0.0631409418725621,
         -0.0446473881685945,
         0.0269880301584244,
         -0.0121919492659909},
        {0.0418317946577231,
         -0.0782601217415403,
         0.106923681923142,
         -0.12124005927086,
         0.118885659240627,
         -0.101807596214252,
         0.0751898928662049,
         -0.0458244351099179,
         0.0202066765451432,
         -0.0821560137749421,
         0.111800173916486,
         -0.099286276071489,
         0.0529134998923476,
         0.00898691110864767,
         -0.0656311191533343,
         0.100476720733421,
         -0.105681533049564,
         0.0837133742584509,
         -0.045824435109918,
         0.113929892405108,
         -0.0966727193994061,
         0.0256197655877729,
         0.0485348671456554,
         -0.0877825065385287,
         0.0773618886797761,
         -0.0261417774103222,
         -0.0405096233699013,
         0.0921513271014773,
         -0.105681533049564,
         0.0751898928662047,
         -0.125954235171101,
         0.0379766308017026,
         0.0568720386741572,
         -0.0882061243119361,
         0.0511523706259755,
         0.0185781522356321,
         -0.0739401123164319,
         0.0812380406751384,
         -0.0348620683251369,
         -0.0405096233699013,
         0.100476720733421,
         -0.101807596214252,
         0.113929892405107,
         0.0379766308017027,
         -0.0919839677553638,
         0.0421523494961334,
         0.0381825098157663,
         -0.0806920821664052,
         0.0591590913433579,
         0.00666154171817914,
         -0.0690579824784579,
         0.0812380406751384,
         -0.0261417774103221,
         -0.0656311191533345,
         0.118885659240627,
         -0.0821560137749422,
         -0.0966727193994063,
         0.056872038674157,
         0.0421523494961334,
         -0.0826675587017561,
         0.0435696290172038,
         0.0301000468236688,
         -0.0769208580841724,
         0.0610641324166416,
         0.00666154171817975,
         -0.0739401123164322,
         0.0773618886797761,
         0.00898691110864757,
         -0.12124005927086,
         0.041831794657723,
         0.111800173916486,
         0.025619765587773,
         -0.0882061243119362,
         0.0381825098157662,
         0.0435696290172031,
         -0.0788204245663895,
         0.0440619568364593,
         0.0277564238257458,
         -0.0769208580841735,
         0.0591590913433581,
         0.0185781522356319,
         -0.0877825065385284,
         0.0529134998923476,
         0.106923681923142,
         -0.0782601217415401,
         -0.0992862760714892,
         0.0485348671456553,
         0.051152370625975,
         -0.0806920821664046,
         0.0301000468236686,
         0.0440619568364601,
         -0.0777179867120914,
         0.0440619568364603,
         0.0301000468236688,
         -0.0806920821664047,
         0.0511523706259751,
         0.0485348671456554,
         -0.099286276071489,
         -0.07826012174154,
         0.106923681923142,
         0.0529134998923477,
         -0.0877825065385286,
         0.018578152235632,
         0.059159091343358,
         -0.0769208580841734,
         0.0277564238257458,
         0.0440619568364593,
         -0.0788204245663895,
         0.0435696290172032,
         0.0381825098157661,
         -0.0882061243119362,
         0.0256197655877732,
         0.111800173916486,
         0.041831794657723,
         -0.12124005927086,
         0.00898691110864763,
         0.0773618886797762,
         -0.0739401123164324,
         0.00666154171817966,
         0.0610641324166417,
         -0.0769208580841726,
         0.0301000468236687,
         0.0435696290172038,
         -0.0826675587017558,
         0.0421523494961333,
         0.0568720386741571,
         -0.0966727193994061,
         -0.0821560137749422,
         0.118885659240627,
         -0.0656311191533346,
         -0.0261417774103221,
         0.0812380406751384,
         -0.0690579824784577,
         0.00666154171817898,
         0.0591590913433581,
         -0.0806920821664053,
         0.0381825098157659,
         0.0421523494961333,
         -0.0919839677553639,
         0.0379766308017027,
         0.113929892405107,
         -0.101807596214252,
         0.100476720733421,
         -0.0405096233699013,
         -0.0348620683251369,
         0.0812380406751386,
         -0.073940112316432,
         0.0185781522356319,
         0.0511523706259756,
         -0.0882061243119361,
         0.056872038674157,
         0.0379766308017027,
         -0.125954235171101,
         0.0751898928662048,
         -0.105681533049564,
         0.0921513271014772,
         -0.0405096233699014,
         -0.0261417774103222,
         0.0773618886797761,
         -0.0877825065385286,
         0.0485348671456553,
         0.0256197655877729,
         -0.0966727193994064,
         0.113929892405108,
         -0.0458244351099181,
         0.083713374258451,
         -0.105681533049564,
         0.100476720733421,
         -0.0656311191533343,
         0.00898691110864759,
         0.0529134998923476,
         -0.0992862760714891,
         0.111800173916486,
         -0.0821560137749422,
         0.0202066765451432,
         -0.045824435109918,
         0.0751898928662046,
         -0.101807596214252,
         0.118885659240627,
         -0.12124005927086,
         0.106923681923142,
         -0.0782601217415398,
         0.0418317946577228},
        {0.0613849814044851,
         -0.0970581776826271,
         0.115701027172567,
         -0.11782415888943,
         0.106923681923142,
         -0.0878467687812182,
         0.0654771155328368,
         -0.0438735563718569,
         0.0258129369312473,
         -0.0126652047907988,
         0.00451835023542909,
         -0.108823940856411,
         0.110053628937151,
         -0.0673280907939595,
         0.00841601134924488,
         0.0458244351099185,
         -0.0830688583724417,
         0.0989920938661319,
         -0.095456661942342,
         0.0781863725920592,
         -0.0544346427583063,
         0.0309829730429426,
         -0.0126652047907989,
         0.128052784147594,
         -0.0477224550103547,
         -0.0396810867483101,
         0.0849013426647072,
         -0.0808623851364094,
         0.0415303779031476,
         0.0118885659240623,
         -0.0598136958469578,
         0.0892016670002506,
         -0.0952984707919893,
         0.0809827388349983,
         -0.0544346427583063,
         0.0258129369312472,
         -0.108823940856411,
         -0.0477224550103546,
         0.0928992536595436,
         -0.0514579843971916,
         -0.017649943036807,
         0.0687450449062445,
         -0.0804929399667085,
         0.0536413841993993,
         -0.00346143861378781,
         -0.0491453957937176,
         0.0856003934712067,
         -0.095298470791989,
         0.078186372592059,
         -0.0438735563718568,
         0.0613849814044852,
         0.110053628937151,
         -0.0396810867483099,
         -0.0514579843971917,
         0.0827855709798268,
         -0.0523581923387579,
         -0.00751045951724258,
         0.0596124243433229,
         -0.0786342573201656,
         0.0578122000251078,
         -0.00789469986190366,
         -0.0491453957937174,
         0.0892016670002505,
         -0.095456661942342,
         0.0654771155328369,
         -0.0970581776826273,
         -0.0673280907939593,
         0.0849013426647072,
         -0.0176499430368071,
         -0.0523581923387579,
         0.0780509848323148,
         -0.0525732166206943,
         -0.00275558529005937,
         0.0554880833977799,
         -0.077854650210471,
         0.0578122000251075,
         -0.00346143861378791,
         -0.0598136958469577,
         0.0989920938661317,
         -0.0878467687812182,
         0.115701027172567,
         0.00841601134924492,
         -0.0808623851364094,
         0.0687450449062446,
         -0.00751045951724261,
         -0.0525732166206944,
         0.0757660690536008,
         -0.0526093122079336,
         -0.00134060941051179,
         0.0554880833977798,
         -0.0786342573201654,
         0.0536413841993994,
         0.0118885659240624,
         -0.0830688583724418,
         0.106923681923142,
         -0.11782415888943,
         0.0458244351099184,
         0.0415303779031475,
         -0.0804929399667087,
         0.0596124243433227,
         -0.00275558529005863,
         -0.0526093122079338,
         0.0750741269886684,
         -0.0526093122079337,
         -0.00275558529005871,
         0.0596124243433226,
         -0.0804929399667087,
         0.0415303779031475,
         0.0458244351099184,
         -0.11782415888943,
         0.106923681923142,
         -0.0830688583724417,
         0.0118885659240624,
         0.0536413841993995,
         -0.0786342573201655,
         0.0554880833977798,
         -0.00134060941051162,
         -0.0526093122079337,
         0.0757660690536007,
         -0.0525732166206945,
         -0.00751045951724268,
         0.0687450449062447,
         -0.0808623851364096,
         0.00841601134924495,
         0.115701027172567,
         -0.0878467687812182,
         0.0989920938661319,
         -0.0598136958469577,
         -0.00346143861378783,
         0.0578122000251074,
         -0.0778546502104709,
         0.0554880833977799,
         -0.00275558529005933,
         -0.0525732166206943,
         0.0780509848323147,
         -0.052358192338758,
         -0.017649943036807,
         0.0849013426647074,
         -0.0673280907939596,
         -0.0970581776826272,
         0.0654771155328369,
         -0.0954566619423421,
         0.0892016670002505,
         -0.0491453957937176,
         -0.00789469986190362,
         0.0578122000251074,
         -0.0786342573201656,
         0.0596124243433231,
         -0.00751045951724267,
         -0.0523581923387579,
         0.0827855709798267,
         -0.0514579843971918,
         -0.0396810867483101,
         0.110053628937151,
         0.0613849814044852,
         -0.0438735563718568,
         0.0781863725920591,
         -0.0952984707919891,
         0.0856003934712066,
         -0.0491453957937175,
         -0.00346143861378785,
         0.0536413841993994,
         -0.0804929399667085,
         0.0687450449062447,
         -0.0176499430368071,
         -0.0514579843971919,
         0.0928992536595438,
         -0.0477224550103545,
         -0.108823940856411,
         0.0258129369312473,
         -0.0544346427583063,
         0.0809827388349981,
         -0.0952984707919892,
         0.0892016670002505,
         -0.0598136958469578,
         0.0118885659240623,
         0.0415303779031474,
         -0.0808623851364095,
         0.0849013426647072,
         -0.0396810867483101,
         -0.0477224550103544,
         0.128052784147593,
         -0.0126652047907989,
         0.0309829730429425,
         -0.0544346427583063,
         0.0781863725920591,
         -0.0954566619423419,
         0.098992093866132,
         -0.0830688583724416,
         0.0458244351099183,
         0.00841601134924505,
         -0.0673280907939596,
         0.110053628937151,
         -0.108823940856411,
         0.00451835023542907,
         -0.012665204790799,
         0.0258129369312471,
         -0.0438735563718568,
         0.0654771155328366,
         -0.0878467687812183,
         0.106923681923142,
         -0.11782415888943,
         0.115701027172567,
         -0.0970581776826272,
         0.0613849814044851},
        {0.0298738767585628,
         -0.0589120794447148,
         0.0857296680618839,
         -0.104996971284896,
         0.113409690835931,
         -0.110121752514666,
         0.0965831661431314,
         -0.0759912287447932,
         0.0524984856424476,
         -0.030310014817715,
         0.012779824364991,
         -0.0648633738994421,
         0.097857622076872,
         -0.102608767899176,
         0.0793702498385212,
         -0.0362273968594825,
         -0.014490958743793,
         0.059983844910854,
         -0.090125514206905,
         0.0995900486867779,
         -0.0887386370150376,
         0.063187707027388,
         -0.0320407153371206,
         0.0985345383447481,
         -0.101942557651244,
         0.0564585911251977,
         0.00733778219331203,
         -0.0602860324400523,
         0.0832199614684391,
         -0.0704704848464715,
         0.0290934779188478,
         0.0249652330070323,
         -0.0725045395495549,
         0.0972256140613861,
         -0.0911136682551931,
         0.0575910733275196,
         -0.118423776802054,
         0.0619328357730292,
         0.0226250645215258,
         -0.0754248139759961,
         0.0757842886207881,
         -0.0336259423339526,
         -0.024230070296515,
         0.068252688366875,
         -0.0777168130030198,
         0.0476661123737574,
         0.00962407717662294,
         -0.0688344984833264,
         0.10078437832316,
         -0.0847717646106344,
         0.115701027172567,
         0.00841601134924504,
         -0.0808623851364093,
         0.0687450449062445,
         -0.00751045951724262,
         -0.0525732166206941,
         0.0757660690535997,
         -0.0526093122079328,
         -0.00134060941051175,
         0.0554880833977797,
         -0.0786342573201664,
         0.0536413841993998,
         0.0118885659240623,
         -0.0830688583724419,
         0.106923681923142,
         -0.0896216302756888,
         -0.0771340181150448,
         0.0755237551973743,
         0.00392220956373552,
         -0.0666775625834943,
         0.0710919643387908,
         -0.0252553563512005,
         -0.035072874805289,
         0.0713803700750642,
         -0.0619523379790653,
         0.0116944372026732,
         0.0496164379259258,
         -0.0804232309902943,
         0.0494960469330666,
         0.0378032302786438,
         -0.117129025041624,
         0.0487838364648459,
         0.109235374992529,
         -0.00540046146837782,
         -0.0750533700248185,
         0.066149950303455,
         -0.00267937921955783,
         -0.0566874194425982,
         0.0719976309692018,
         -0.0376499903080156,
         -0.0216158218369954,
         0.0670514376386311,
         -0.067229079327154,
         0.0170372899767639,
         0.0530052840027726,
         -0.0845305926721261,
         0.0239088621184711,
         0.110430303840935,
         -0.0860465995237511,
         -0.0811627854105608,
         0.0699979808565973,
         0.0139439315525749,
         -0.0711844718136275,
         0.0647031995580689,
         -0.0110681722982922,
         -0.0475627305820478,
         0.0722401123768075,
         -0.0475627305820478,
         -0.0110681722982921,
         0.0647031995580688,
         -0.0711844718136275,
         0.0139439315525749,
         0.0699979808565973,
         -0.0811627854105607,
         -0.0860465995237515,
         0.110430303840935,
         0.0239088621184712,
         -0.084530592672126,
         0.0530052840027727,
         0.0170372899767639,
         -0.0672290793271542,
         0.0670514376386311,
         -0.0216158218369954,
         -0.0376499903080156,
         0.0719976309692018,
         -0.0566874194425984,
         -0.00267937921955792,
         0.066149950303455,
         -0.0750533700248183,
         -0.00540046146837789,
         0.109235374992529,
         0.0487838364648458,
         -0.117129025041625,
         0.0378032302786438,
         0.0494960469330666,
         -0.0804232309902942,
         0.0496164379259258,
         0.0116944372026733,
         -0.0619523379790653,
         0.0713803700750643,
         -0.0350728748052889,
         -0.0252553563512006,
         0.0710919643387906,
         -0.0666775625834942,
         0.00392220956373553,
         0.0755237551973742,
         -0.0771340181150449,
         -0.089621630275689,
         0.106923681923142,
         -0.0830688583724419,
         0.0118885659240623,
         0.0536413841993997,
         -0.0786342573201664,
         0.0554880833977799,
         -0.00134060941051169,
         -0.0526093122079327,
         0.0757660690536001,
         -0.0525732166206941,
         -0.00751045951724261,
         0.0687450449062443,
         -0.0808623851364093,
         0.00841601134924505,
         0.115701027172567,
         -0.0847717646106345,
         0.100784378323159,
         -0.0688344984833263,
         0.00962407717662283,
         0.0476661123737576,
         -0.0777168130030197,
         0.0682526883668748,
         -0.0242300702965151,
         -0.0336259423339524,
         0.0757842886207882,
         -0.0754248139759962,
         0.0226250645215258,
         0.0619328357730293,
         -0.118423776802054,
         0.0575910733275194,
         -0.0911136682551931,
         0.0972256140613862,
         -0.0725045395495548,
         0.0249652330070321,
         0.0290934779188475,
         -0.0704704848464716,
         0.0832199614684389,
         -0.0602860324400524,
         0.00733778219331192,
         0.0564585911251977,
         -0.101942557651244,
         0.0985345383447479,
         -0.0320407153371207,
         0.0631877070273881,
         -0.0887386370150373,
         0.0995900486867777,
         -0.0901255142069048,
         0.059983844910854,
         -0.014490958743793,
         -0.0362273968594825,
         0.0793702498385214,
         -0.102608767899175,
         0.0978576220768719,
         -0.0648633738994422,
         0.012779824364991,
         -0.0303100148177149,
         0.0524984856424478,
         -0.0759912287447935,
         0.0965831661431315,
         -0.110121752514666,
         0.113409690835931,
         -0.104996971284895,
         0.0857296680618838,
         -0.0589120794447149,
         0.029873876758563},
        {0.0219793491131929,
         -0.0450442616461448,
         0.0685470880485742,
         -0.0884939101477137,
         0.101807596214252,
         -0.106776707720442,
         0.103156099952978,
         -0.0920299482469907,
         0.075502534101898,
         -0.0562762662417803,
         0.0371748779812823,
         -0.0206677246844161,
         0.00843756327019058,
         -0.0518797782104316,
         0.0840651099988373,
         -0.0976458208580636,
         0.0897492056146838,
         -0.0630982902763826,
         0.0243366703285676,
         0.0180485577671671,
         -0.0556990585091637,
         0.0820025593808798,
         -0.0932023515404,
         0.08891122720763,
         -0.0719950741897487,
         0.0478364873234939,
         -0.0229969210510588,
         0.0851256530758746,
         -0.100103466142523,
         0.0738821627401349,
         -0.0243919182324232,
         -0.0277480734373722,
         0.0654028363080936,
         -0.0784834035697132,
         0.065075000477694,
         -0.0306344821800405,
         -0.0142005293113489,
         0.0566405177223643,
         -0.0850579824707033,
         0.0920299482469907,
         -0.0765383797175903,
         0.0446473881685942,
         -0.109896745565965,
         0.076138698762688,
         -0.00590506419554779,
         -0.0532275293548817,
         0.0769068187463662,
         -0.0620465784506201,
         0.0206821928168742,
         0.0277480734373728,
         -0.0638112879390042,
         0.0739630927749118,
         -0.0541586937834248,
         0.0108009229367551,
         0.041057716440747,
         -0.0820388989416683,
         0.0947114128088431,
         -0.0705937190952061,
         0.114783407191697,
         -0.0148184741491459,
         -0.0633091132853514,
         0.0774109261308923,
         -0.0400915391542922,
         -0.0159540204988571,
         0.0591590913433573,
         -0.0705513331897968,
         0.0475825613861662,
         -0.00222162388558743,
         -0.0448369725059871,
         0.0720090751800384,
         -0.0648668774711036,
         0.0225641999754244,
         0.0391792845323918,
         -0.0903037888878278,
         0.0951885514095137,
         -0.09465282238393,
         -0.0580763206912503,
         0.0822701051467931,
         -0.0258010825393798,
         -0.0402015609266783,
         0.0713910054417884,
         -0.0570788389597906,
         0.0118318182686725,
         0.0379118746654468,
         -0.0669844804889455,
         0.0614105592424253,
         -0.0234353285402016,
         -0.029079770144565,
         0.0688344984833267,
         -0.0699775822022644,
         0.0219018858810581,
         0.0571131308457078,
         -0.111007972841776,
         0.0546478324829196,
         0.103686971902417,
         -0.0288464872255673,
         -0.0550733761726464,
         0.0747246195613274,
         -0.036869528539188,
         -0.0209755719075563,
         0.0617896556971247,
         -0.0653639489354304,
         0.0328611051358186,
         0.0172086246208308,
         -0.0584191117581202,
         0.0680920935718691,
         -0.0380152782516419,
         -0.0189675895637844,
         0.0696913741227168,
         -0.0719769416937573,
         0.111007972841776,
         -0.0914433139503787,
         -0.0629356049324473,
         0.0793147267468439,
         -0.0166594248350597,
         -0.0480916170653301,
         0.0714958959543514,
         -0.0479284904827324,
         -0.00226706056967485,
         0.0491138323564646,
         -0.0678717308095017,
         0.0491138323564646,
         -0.00226706056967501,
         -0.0479284904827321,
         0.0714958959543515,
         -0.0480916170653298,
         -0.0166594248350598,
         0.0793147267468438,
         -0.0629356049324472,
         -0.0914433139503787,
         0.111007972841776,
         -0.0719769416937574,
         0.0696913741227168,
         -0.0189675895637843,
         -0.0380152782516419,
         0.0680920935718686,
         -0.0584191117581203,
         0.0172086246208308,
         0.0328611051358187,
         -0.0653639489354305,
         0.0617896556971245,
         -0.0209755719075563,
         -0.0368695285391881,
         0.0747246195613273,
         -0.0550733761726466,
         -0.0288464872255672,
         0.103686971902417,
         0.0546478324829196,
         -0.111007972841776,
         0.0571131308457079,
         0.0219018858810581,
         -0.0699775822022642,
         0.0688344984833265,
         -0.0290797701445649,
         -0.0234353285402014,
         0.0614105592424255,
         -0.0669844804889457,
         0.0379118746654466,
         0.0118318182686727,
         -0.0570788389597907,
         0.0713910054417886,
         -0.0402015609266784,
         -0.0258010825393799,
         0.082270105146793,
         -0.0580763206912504,
         -0.0946528223839298,
         0.0951885514095136,
         -0.0903037888878276,
         0.0391792845323918,
         0.0225641999754244,
         -0.0648668774711036,
         0.0720090751800384,
         -0.0448369725059871,
         -0.00222162388558731,
         0.0475825613861662,
         -0.070551333189797,
         0.0591590913433574,
         -0.0159540204988573,
         -0.0400915391542921,
         0.0774109261308923,
         -0.0633091132853514,
         -0.0148184741491458,
         0.114783407191697,
         -0.0705937190952062,
         0.0947114128088432,
         -0.0820388989416684,
         0.041057716440747,
         0.0108009229367551,
         -0.0541586937834249,
         0.0739630927749118,
         -0.0638112879390042,
         0.0277480734373729,
         0.0206821928168741,
         -0.06204657845062,
         0.0769068187463664,
         -0.0532275293548817,
         -0.00590506419554779,
         0.0761386987626878,
         -0.109896745565965,
         0.0446473881685941,
         -0.0765383797175902,
         0.0920299482469906,
         -0.0850579824707032,
         0.0566405177223642,
         -0.0142005293113489,
         -0.0306344821800406,
         0.0650750004776941,
         -0.0784834035697128,
         0.0654028363080934,
         -0.0277480734373723,
         -0.0243919182324231,
         0.0738821627401349,
         -0.100103466142523,
         0.085125653075875,
         -0.0229969210510589,
         0.047836487323494,
         -0.0719950741897487,
         0.0889112272076299,
         -0.0932023515404,
         0.0820025593808798,
         -0.0556990585091637,
         0.0180485577671672,
         0.0243366703285676,
         -0.0630982902763827,
         0.0897492056146839,
         -0.0976458208580637,
         0.0840651099988372,
         -0.0518797782104316,
         0.00843756327019056,
         -0.0206677246844159,
         0.0371748779812824,
         -0.0562762662417802,
         0.0755025341018978,
         -0.0920299482469907,
         0.103156099952978,
         -0.106776707720442,
         0.101807596214252,
         -0.0884939101477137,
         0.0685470880485741,
         -0.0450442616461448,
         0.0219793491131928},
        {-0.0264567499461736,
         0.0561232418852887,
         -0.0857296680618836,
         0.107467826312283,
         -0.115438963354368,
         0.107467826312283,
         -0.0857296680618836,
         0.0561232418852886,
         -0.0264567499461738,
         0.0561232418852887,
         -0.0925986248116078,
         0.102466551936304,
         -0.0793702498385213,
         0.0298062121716611,
         0.0298062121716611,
         -0.0793702498385211,
         0.102466551936304,
         -0.0925986248116078,
         0.0561232418852886,
         -0.0857296680618836,
         0.102466551936304,
         -0.066141874865434,
         0.060286032440052,
         -0.0843046989922662,
         0.0602860324400521,
         -0.066141874865434,
         0.102466551936304,
         -0.0857296680618836,
         0.107467826312283,
         -0.0793702498385212,
         0.0661418748654342,
         -0.0778289332164141,
         0.0336259423339523,
         0.0336259423339524,
         -0.0778289332164139,
         0.0661418748654342,
         -0.0793702498385211,
         0.107467826312283,
         -0.115438963354368,
         0.0298062121716611,
         0.060286032440052,
         -0.0778289332164139,
         0.0254391826405522,
         0.0445875653655166,
         -0.0757660690536003,
         0.0445875653655165,
         0.0254391826405524,
         -0.0778289332164141,
         0.0602860324400521,
         0.0298062121716611,
         -0.115438963354368,
         0.107467826312283,
         0.0298062121716611,
         -0.0843046989922663,
         0.0336259423339524,
         0.0445875653655165,
         -0.0742824133104118,
         0.035072874805289,
         0.035072874805289,
         -0.0742824133104117,
         0.0445875653655166,
         0.0336259423339524,
         -0.0843046989922662,
         0.0298062121716611,
         0.107467826312283,
         -0.0857296680618838,
         -0.0793702498385212,
         0.060286032440052,
         0.0336259423339524,
         -0.0757660690536001,
         0.0350728748052889,
         0.0376499903080177,
         -0.0722401123768073,
         0.0376499903080175,
         0.035072874805289,
         -0.0757660690536002,
         0.0336259423339524,
         0.0602860324400519,
         -0.0793702498385212,
         -0.0857296680618838,
         0.0561232418852885,
         0.102466551936305,
         -0.0778289332164141,
         0.044587565365516,
         0.0350728748052894,
         -0.0722401123768068,
         0.0356148556967728,
         0.0356148556967729,
         -0.0722401123768069,
         0.0350728748052894,
         0.0445875653655161,
         -0.0778289332164139,
         0.102466551936305,
         0.0561232418852888,
         -0.0264567499461737,
         -0.0925986248116079,
         -0.0661418748654342,
         0.0661418748654341,
         0.0254391826405524,
         -0.0742824133104118,
         0.0376499903080176,
         0.0356148556967718,
         -0.071229711393544,
         0.0356148556967717,
         0.0376499903080178,
         -0.0742824133104117,
         0.0254391826405524,
         0.0661418748654342,
         -0.0661418748654341,
         -0.0925986248116079,
         -0.0264567499461736,
         0.0561232418852888,
         0.102466551936305,
         -0.0778289332164139,
         0.044587565365516,
         0.0350728748052895,
         -0.0722401123768067,
         0.0356148556967726,
         0.0356148556967727,
         -0.0722401123768069,
         0.0350728748052894,
         0.0445875653655159,
         -0.077828933216414,
         0.102466551936305,
         0.0561232418852888,
         -0.0857296680618838,
         -0.0793702498385212,
         0.060286032440052,
         0.0336259423339524,
         -0.0757660690536003,
         0.0350728748052888,
         0.0376499903080178,
         -0.0722401123768074,
         0.0376499903080176,
         0.0350728748052889,
         -0.0757660690536001,
         0.0336259423339526,
         0.060286032440052,
         -0.0793702498385211,
         -0.085729668061884,
         0.107467826312283,
         0.029806212171661,
         -0.0843046989922663,
         0.0336259423339524,
         0.0445875653655166,
         -0.0742824133104117,
         0.0350728748052888,
         0.035072874805289,
         -0.0742824133104117,
         0.0445875653655165,
         0.0336259423339525,
         -0.0843046989922661,
         0.0298062121716612,
         0.107467826312283,
         -0.115438963354368,
         0.0298062121716609,
         0.0602860324400519,
         -0.077828933216414,
         0.0254391826405523,
         0.0445875653655165,
         -0.0757660690536002,
         0.0445875653655166,
         0.0254391826405522,
         -0.0778289332164139,
         0.060286032440052,
         0.0298062121716611,
         -0.115438963354368,
         0.107467826312283,
         -0.0793702498385212,
         0.0661418748654342,
         -0.0778289332164141,
         0.0336259423339524,
         0.0336259423339523,
         -0.0778289332164139,
         0.0661418748654341,
         -0.0793702498385212,
         0.107467826312283,
         -0.0857296680618838,
         0.102466551936305,
         -0.0661418748654342,
         0.0602860324400519,
         -0.0843046989922663,
         0.0602860324400521,
         -0.0661418748654341,
         0.102466551936305,
         -0.0857296680618837,
         0.0561232418852886,
         -0.0925986248116079,
         0.102466551936304,
         -0.0793702498385213,
         0.0298062121716611,
         0.0298062121716611,
         -0.0793702498385213,
         0.102466551936305,
         -0.092598624811608,
         0.0561232418852886,
         -0.0264567499461736,
         0.0561232418852886,
         -0.0857296680618838,
         0.107467826312283,
         -0.115438963354368,
         0.107467826312283,
         -0.0857296680618837,
         0.0561232418852887,
         -0.0264567499461738},
        {-0.0358921268038776,
         0.0671480206913782,
         -0.0924288746692087,
         0.106727671342324,
         -0.108285821957098,
         0.0983554821576439,
         -0.0803069148972138,
         0.0584980751624757,
         -0.0371748779812822,
         0.0195928810266157,
         -0.00747243162976715,
         0.0728972541446911,
         -0.100321544238141,
         0.0925892024127221,
         -0.0566008951098047,
         0.00647131561942063,
         0.0423735303067146,
         -0.0777568359955517,
         0.0932905695928426,
         -0.08891122720763,
         0.0697545088811508,
         -0.043900535824882,
         0.0195928810266158,
         -0.103092285471181,
         0.0892805381522404,
         -0.02852416998937,
         -0.0365357206901179,
         0.0751898928662055,
         -0.0752942508523971,
         0.0419389185070223,
         0.00860431231041546,
         -0.0566405177223639,
         0.0861625445677422,
         -0.0896691795572056,
         0.0697545088811507,
         -0.037174877981282,
         0.114710505687238,
         -0.0355702178187763,
         -0.0491657916821987,
         0.0795107812256783,
         -0.0519579693297239,
         -0.00518859554776027,
         0.0560765863706399,
         -0.0748488325079423,
         0.0541586937834259,
         -0.00504593836968026,
         -0.0497717321054138,
         0.0861625445677421,
         -0.08891122720763,
         0.0584980751624758,
         -0.103092285471181,
         -0.0355702178187765,
         0.0832197475142011,
         -0.0394745922673518,
         -0.0306404100061827,
         0.0705513331897959,
         -0.0591590913433582,
         0.00985984855722497,
         0.0448369725059862,
         -0.0726307775522936,
         0.0571107274560776,
         -0.00504593836968025,
         -0.0566405177223642,
         0.0932905695928428,
         -0.080306914897214,
         0.0728972541446914,
         0.0892805381522403,
         -0.0491657916821987,
         -0.0394745922673519,
         0.074159845675492,
         -0.0408236514580402,
         -0.0216018458735105,
         0.064805537620532,
         -0.0614105592424248,
         0.0160206910891184,
         0.041231810242822,
         -0.0726307775522936,
         0.0541586937834258,
         0.00860431231041538,
         -0.0777568359955518,
         0.0983554821576438,
         -0.0358921268038777,
         -0.100321544238141,
         -0.0285241699893703,
         0.0795107812256781,
         -0.0306404100061826,
         -0.04082365145804,
         0.0699185730251856,
         -0.041364385633748,
         -0.017208624620831,
         0.0620576256470848,
         -0.0619144335037847,
         0.0160206910891184,
         0.0448369725059864,
         -0.0748488325079421,
         0.0419389185070223,
         0.0423735303067145,
         -0.108285821957098,
         0.0671480206913779,
         0.092589202412722,
         -0.0365357206901177,
         -0.0519579693297238,
         0.0705513331897959,
         -0.0216018458735105,
         -0.041364385633748,
         0.067871730809503,
         -0.0415627771107041,
         -0.0158789172132531,
         0.062057625647084,
         -0.0614105592424248,
         0.00985984855722491,
         0.0560765863706406,
         -0.0752942508523973,
         0.00647131561942065,
         0.106727671342324,
         -0.0924288746692088,
         -0.0566008951098046,
         0.0751898928662055,
         -0.00518859554776028,
         -0.0591590913433581,
         0.0648055376205324,
         -0.0172086246208319,
         -0.0415627771107033,
         0.067251884667904,
         -0.0415627771107032,
         -0.017208624620832,
         0.0648055376205324,
         -0.0591590913433581,
         -0.0051885955477603,
         0.0751898928662056,
         -0.0566008951098046,
         -0.0924288746692089,
         0.106727671342324,
         0.00647131561942062,
         -0.0752942508523972,
         0.0560765863706404,
         0.00985984855722501,
         -0.061410559242425,
         0.0620576256470836,
         -0.015878917213253,
         -0.0415627771107041,
         0.0678717308095033,
         -0.041364385633748,
         -0.0216018458735107,
         0.070551333189796,
         -0.0519579693297238,
         -0.0365357206901179,
         0.0925892024127221,
         0.0671480206913778,
         -0.108285821957098,
         0.0423735303067146,
         0.0419389185070223,
         -0.0748488325079423,
         0.0448369725059862,
         0.0160206910891184,
         -0.0619144335037847,
         0.0620576256470848,
         -0.017208624620831,
         -0.0413643856337482,
         0.0699185730251857,
         -0.0408236514580401,
         -0.0306404100061828,
         0.0795107812256782,
         -0.02852416998937,
         -0.100321544238141,
         -0.0358921268038776,
         0.0983554821576437,
         -0.0777568359955516,
         0.00860431231041544,
         0.0541586937834259,
         -0.0726307775522935,
         0.041231810242822,
         0.0160206910891183,
         -0.0614105592424249,
         0.0648055376205318,
         -0.0216018458735106,
         -0.04082365145804,
         0.0741598456754921,
         -0.0394745922673519,
         -0.0491657916821987,
         0.0892805381522402,
         0.0728972541446912,
         -0.080306914897214,
         0.0932905695928428,
         -0.0566405177223641,
         -0.00504593836968026,
         0.0571107274560776,
         -0.0726307775522934,
         0.0448369725059862,
         0.00985984855722502,
         -0.0591590913433583,
         0.0705513331897961,
         -0.0306404100061828,
         -0.0394745922673519,
         0.0832197475142011,
         -0.0355702178187764,
         -0.103092285471181,
         0.0584980751624758,
         -0.0889112272076299,
         0.0861625445677422,
         -0.0497717321054138,
         -0.00504593836968032,
         0.0541586937834259,
         -0.0748488325079423,
         0.0560765863706399,
         -0.00518859554776032,
         -0.0519579693297237,
         0.0795107812256783,
         -0.0491657916821987,
         -0.0355702178187764,
         0.114710505687238,
         -0.037174877981282,
         0.0697545088811506,
         -0.0896691795572054,
         0.0861625445677421,
         -0.056640517722364,
         0.0086043123104155,
         0.0419389185070221,
         -0.0752942508523972,
         0.0751898928662056,
         -0.0365357206901178,
         -0.0285241699893701,
         0.0892805381522404,
         -0.103092285471181,
         0.0195928810266157,
         -0.0439005358248821,
         0.0697545088811507,
         -0.0889112272076301,
         0.0932905695928428,
         -0.0777568359955517,
         0.0423735303067146,
         0.00647131561942056,
         -0.0566008951098048,
         0.0925892024127222,
         -0.100321544238141,
         0.0728972541446914,
         -0.00747243162976709,
         0.0195928810266157,
         -0.0371748779812821,
         0.0584980751624756,
         -0.0803069148972139,
         0.0983554821576439,
         -0.108285821957098,
         0.106727671342324,
         -0.092428874669209,
         0.0671480206913781,
         -0.0358921268038776},
        {-0.017467415452592,
         0.0390583283432255,
         -0.0635470578684545,
         0.0860431231041581,
         -0.101807596214252,
         0.107467826312283,
         -0.101807596214252,
         0.0860431231041578,
         -0.0635470578684545,
         0.0390583283432255,
         -0.0174674154525917,
         0.0409647203611097,
         -0.0741079674979818,
         0.0937782726845256,
         -0.0917222774164022,
         0.0666487165676159,
         -0.0243366703285675,
         -0.0243366703285675,
         0.0666487165676159,
         -0.0917222774164021,
         0.0937782726845258,
         -0.0741079674979817,
         0.0409647203611098,
         -0.0685470880485739,
         0.0951934078443735,
         -0.0835347769383324,
         0.0402464699833544,
         0.015565786643283,
         -0.0610845577285515,
         0.0784834035697123,
         -0.0610845577285514,
         0.0155657866432829,
         0.0402464699833544,
         -0.0835347769383324,
         0.0951934078443735,
         -0.0685470880485738,
         0.0934139349035914,
         -0.0897492056146842,
         0.0352671858479085,
         0.0303876334206495,
         -0.0708897108298449,
         0.0683241700987258,
         -0.0277480734373725,
         -0.0277480734373724,
         0.0683241700987258,
         -0.0708897108298448,
         0.0303876334206494,
         0.0352671858479085,
         -0.0897492056146841,
         0.0934139349035915,
         -0.1083824626028,
         0.054959939644027,
         0.0277480734373727,
         -0.0734145016764436,
         0.0606200296354302,
         -0.00763740585165374,
         -0.047582561386167,
         0.0705343716958161,
         -0.047582561386167,
         -0.00763740585165365,
         0.0606200296354301,
         -0.0734145016764436,
         0.0277480734373726,
         0.0549599396440267,
         -0.108382462602801,
         0.1083824626028,
         -0.0730100109857035,
         0.0620465784506196,
         -0.0561232418852885,
         0.0669844804889477,
         -0.0291209202873926,
         -0.0291209202873925,
         0.0669844804889477,
         -0.0561232418852886,
         0.0620465784506194,
         -0.0730100109857033,
         0.1083824626028,
         -0.0924288746692087,
         -0.0566008951098048,
         0.0751898928662057,
         -0.00518859554776036,
         -0.0591590913433577,
         0.0648055376205317,
         -0.0172086246208308,
         -0.0415627771107044,
         0.067251884667904,
         -0.0415627771107044,
         -0.017208624620831,
         0.0648055376205319,
         -0.059159091343358,
         -0.00518859554776044,
         0.0751898928662059,
         -0.0566008951098049,
         -0.0924288746692088,
         0.0644166453276695,
         0.093739988023741,
         -0.0301653361166202,
         -0.0570745510253711,
         0.0672518846679033,
         -0.0118318182686711,
         -0.0491138323564634,
         0.0659788632192786,
         -0.0296552936719457,
         -0.0296552936719454,
         0.0659788632192786,
         -0.0491138323564634,
         -0.0118318182686712,
         0.0672518846679032,
         -0.0570745510253712,
         -0.0301653361166202,
         0.0937399880237411,
         0.0644166453276694,
         -0.0322083226638346,
         -0.0966249679915043,
         -0.0397867515259135,
         0.0767315922285477,
         -0.0142095541163967,
         -0.0539963056423116,
         0.0653639489354305,
         -0.0198933757629573,
         -0.0397867515259141,
         0.0663112525431891,
         -0.0397867515259141,
         -0.019893375762957,
         0.0653639489354303,
         -0.0539963056423115,
         -0.0142095541163966,
         0.0767315922285474,
         -0.0397867515259135,
         -0.0966249679915047,
         -0.0322083226638347,
         0.0644166453276697,
         0.0937399880237409,
         -0.0301653361166202,
         -0.0570745510253711,
         0.0672518846679032,
         -0.0118318182686712,
         -0.0491138323564634,
         0.0659788632192786,
         -0.0296552936719457,
         -0.0296552936719455,
         0.0659788632192786,
         -0.0491138323564633,
         -0.0118318182686711,
         0.0672518846679031,
         -0.0570745510253712,
         -0.0301653361166204,
         0.093739988023741,
         0.0644166453276697,
         -0.0924288746692087,
         -0.0566008951098047,
         0.0751898928662057,
         -0.0051885955477605,
         -0.0591590913433576,
         0.0648055376205317,
         -0.017208624620831,
         -0.0415627771107044,
         0.0672518846679041,
         -0.0415627771107043,
         -0.0172086246208309,
         0.0648055376205318,
         -0.0591590913433576,
         -0.00518859554776047,
         0.0751898928662058,
         -0.0566008951098047,
         -0.0924288746692088,
         0.108382462602801,
         -0.0730100109857035,
         0.0620465784506197,
         -0.0561232418852887,
         0.0669844804889476,
         -0.0291209202873926,
         -0.0291209202873925,
         0.0669844804889479,
         -0.0561232418852885,
         0.0620465784506195,
         -0.0730100109857034,
         0.1083824626028,
         -0.108382462602801,
         0.054959939644027,
         0.0277480734373726,
         -0.0734145016764436,
         0.0606200296354301,
         -0.00763740585165341,
         -0.0475825613861671,
         0.0705343716958162,
         -0.0475825613861672,
         -0.00763740585165367,
         0.0606200296354302,
         -0.0734145016764438,
         0.0277480734373726,
         0.054959939644027,
         -0.1083824626028,
         0.0934139349035914,
         -0.0897492056146842,
         0.0352671858479084,
         0.0303876334206494,
         -0.0708897108298451,
         0.0683241700987259,
         -0.0277480734373724,
         -0.0277480734373722,
         0.068324170098726,
         -0.070889710829845,
         0.0303876334206494,
         0.0352671858479083,
         -0.0897492056146843,
         0.0934139349035914,
         -0.068547088048574,
         0.0951934078443735,
         -0.0835347769383326,
         0.0402464699833544,
         0.015565786643283,
         -0.0610845577285515,
         0.0784834035697125,
         -0.0610845577285516,
         0.015565786643283,
         0.0402464699833545,
         -0.0835347769383326,
         0.0951934078443734,
         -0.0685470880485738,
         0.0409647203611097,
         -0.0741079674979819,
         0.0937782726845259,
         -0.0917222774164023,
         0.0666487165676158,
         -0.0243366703285675,
         -0.0243366703285674,
         0.0666487165676158,
         -0.0917222774164022,
         0.0937782726845257,
         -0.074107967497982,
         0.0409647203611098,
         -0.0174674154525915,
         0.0390583283432254,
         -0.0635470578684546,
         0.0860431231041578,
         -0.101807596214252,
         0.107467826312283,
         -0.101807596214252,
         0.0860431231041579,
         -0.0635470578684546,
         0.0390583283432255,
         -0.0174674154525915},
        {-0.0119492991418807,
         0.0277676619452128,
         -0.0472436950651113,
         0.0674284723318768,
         -0.0849768722124841,
         0.0968885413984642,
         -0.101103036910291,
         0.0968885413984647,
         -0.0849768722124839,
         0.0674284723318768,
         -0.0472436950651113,
         0.0277676619452129,
         -0.0119492991418808,
         0.0304648547491037,
         -0.0587827793623954,
         0.0810811724801585,
         -0.0900067361457958,
         0.0817690334112838,
         -0.0570042188347284,
         0.0204258979993773,
         0.0204258979993774,
         -0.0570042188347284,
         0.0817690334112837,
         -0.0900067361457961,
         0.0810811724801587,
         -0.0587827793623954,
         0.0304648547491037,
         -0.0550619417076894,
         0.0845731291197501,
         -0.087682872801495,
         0.0635679701167031,
         -0.0210665592656789,
         -0.0253703717583094,
         0.0607032508978114,
         -0.0738352185973924,
         0.0607032508978113,
         -0.0253703717583094,
         -0.0210665592656789,
         0.0635679701167031,
         -0.0876828728014949,
         0.0845731291197499,
         -0.0550619417076895,
         0.0806024293938335,
         -0.0911912390471832,
         0.057531938828583,
         -0.00251249540439535,
         -0.0467920237706154,
         0.0701326837851755,
         -0.0602033358639247,
         0.0234607312672745,
         0.0234607312672745,
         -0.0602033358639248,
         0.0701326837851755,
         -0.0467920237706157,
         -0.0025124954043952,
         0.0575319388285831,
         -0.0911912390471834,
         0.0806024293938336,
         -0.0999750093710957,
         0.0699825065597666,
         -0.00102572195364268,
         -0.0550746786825789,
         0.0703076318288134,
         -0.0439651505349604,
         -0.00470373897341678,
         0.0488374066016982,
         -0.0663569686827393,
         0.0488374066016982,
         -0.00470373897341683,
         -0.0439651505349605,
         0.0703076318288131,
         -0.0550746786825788,
         -0.00102572195364255,
         0.0699825065597665,
         -0.0999750093710956,
         0.106431524928398,
         -0.0230882394290547,
         -0.0544374004285563,
         0.0713595876300578,
         -0.0339328257822448,
         -0.0221988211825901,
         0.0602149853152236,
         -0.0601146919416709,
         0.0247297821259049,
         0.024729782125905,
         -0.0601146919416709,
         0.0602149853152236,
         -0.0221988211825901,
         -0.0339328257822448,
         0.0713595876300577,
         -0.0544374004285564,
         -0.0230882394290544,
         0.106431524928398,
         -0.0962709365598687,
         -0.035153175723993,
         0.0774526592079891,
         -0.0340895640431059,
         -0.031084096948402,
         0.065224810476796,
         -0.0511046297488741,
         0.0042331491045905,
         0.0435354701495336,
         -0.0632688871747348,
         0.0435354701495338,
         0.00423314910459048,
         -0.051104629748874,
         0.065224810476796,
         -0.031084096948402,
         -0.0340895640431058,
         0.0774526592079891,
         -0.035153175723993,
         -0.0962709365598686,
         0.0709313090846489,
         0.0823343682082007,
         -0.050437722340499,
         -0.0315841733043667,
         0.0688450941115713,
         -0.04394473910703,
         -0.011666611459129,
         0.0552097426476724,
         -0.0597343803871729,
         0.0252355559903729,
         0.0252355559903729,
         -0.0597343803871729,
         0.0552097426476724,
         -0.011666611459129,
         -0.04394473910703,
         0.0688450941115711,
         -0.0315841733043669,
         -0.050437722340499,
         0.0823343682082007,
         0.070931309084649,
         -0.0373840823541474,
         -0.0971986141207833,
         -0.0161341829107375,
         0.0743746480519345,
         -0.041874801844367,
         -0.0234373890919974,
         0.0627427586507233,
         -0.0527428059714699,
         0.00680552335115901,
         0.0419673939988051,
         -0.0623839640522753,
         0.0419673939988052,
         0.00680552335115887,
         -0.0527428059714704,
         0.062742758650723,
         -0.0234373890919973,
         -0.0418748018443671,
         0.0743746480519348,
         -0.0161341829107374,
         -0.0971986141207831,
         -0.0373840823541474,
         0.0709313090846491,
         0.0823343682082006,
         -0.0504377223404989,
         -0.0315841733043669,
         0.0688450941115713,
         -0.0439447391070301,
         -0.011666611459129,
         0.0552097426476725,
         -0.0597343803871731,
         0.025235555990373,
         0.0252355559903727,
         -0.0597343803871728,
         0.0552097426476724,
         -0.0116666114591291,
         -0.0439447391070301,
         0.0688450941115712,
         -0.0315841733043669,
         -0.050437722340499,
         0.0823343682082009,
         0.0709313090846489,
         -0.0962709365598685,
         -0.0351531757239929,
         0.0774526592079892,
         -0.0340895640431058,
         -0.0310840969484021,
         0.0652248104767962,
         -0.0511046297488742,
         0.00423314910459052,
         0.0435354701495336,
         -0.0632688871747348,
         0.0435354701495336,
         0.00423314910459048,
         -0.051104629748874,
         0.0652248104767961,
         -0.0310840969484019,
         -0.034089564043106,
         0.0774526592079892,
         -0.035153175723993,
         -0.0962709365598688,
         0.106431524928397,
         -0.0230882394290547,
         -0.0544374004285563,
         0.0713595876300578,
         -0.0339328257822447,
         -0.0221988211825901,
         0.0602149853152235,
         -0.060114691941671,
         0.024729782125905,
         0.0247297821259049,
         -0.0601146919416709,
         0.0602149853152235,
         -0.02219882118259,
         -0.0339328257822448,
         0.0713595876300578,
         -0.0544374004285564,
         -0.0230882394290548,
         0.106431524928398,
         -0.0999750093710957,
         0.0699825065597667,
         -0.0010257219536427,
         -0.0550746786825787,
         0.0703076318288131,
         -0.0439651505349603,
         -0.00470373897341674,
         0.048837406601698,
         -0.0663569686827394,
         0.0488374066016981,
         -0.00470373897341675,
         -0.0439651505349604,
         0.0703076318288131,
         -0.0550746786825788,
         -0.00102572195364262,
         0.0699825065597666,
         -0.0999750093710956,
         0.0806024293938336,
         -0.0911912390471832,
         0.0575319388285832,
         -0.00251249540439528,
         -0.0467920237706157,
         0.0701326837851755,
         -0.0602033358639245,
         0.0234607312672744,
         0.0234607312672745,
         -0.0602033358639245,
         0.0701326837851756,
         -0.0467920237706156,
         -0.0025124954043952,
         0.057531938828583,
         -0.0911912390471832,
         0.0806024293938336,
         -0.0550619417076896,
         0.0845731291197497,
         -0.0876828728014951,
         0.0635679701167031,
         -0.0210665592656789,
         -0.0253703717583094,
         0.0607032508978114,
         -0.0738352185973923,
         0.0607032508978112,
         -0.0253703717583095,
         -0.0210665592656789,
         0.063567970116703,
         -0.0876828728014952,
         0.0845731291197499,
         -0.0550619417076896,
         0.0304648547491036,
         -0.0587827793623953,
         0.0810811724801583,
         -0.090006736145796,
         0.0817690334112839,
         -0.0570042188347282,
         0.0204258979993774,
         0.0204258979993775,
         -0.0570042188347283,
         0.0817690334112837,
         -0.090006736145796,
         0.0810811724801585,
         -0.0587827793623955,
         0.0304648547491037,
         -0.0119492991418807,
         0.0277676619452129,
         -0.0472436950651113,
         0.0674284723318765,
         -0.084976872212484,
         0.0968885413984645,
         -0.101103036910292,
         0.0968885413984643,
         -0.084976872212484,
         0.0674284723318766,
         -0.0472436950651113,
         0.0277676619452129,
         -0.0119492991418807},
        {-0.0220334189344121,
         0.0467399398237409,
         -0.0719312496553813,
         0.0918252377531346,
         -0.102058045783879,
         0.100774245675637,
         -0.0888745308726208,
         0.0695408362094625,
         -0.047243695065111,
         0.0265076628675869,
         -0.0107228775957293,
         0.0487177223027719,
         -0.0812884198856601,
         0.0929316058296548,
         -0.078444660886508,
         0.0419943956134322,
         0.00537893130371355,
         -0.0500751252693309,
         0.0804102898371336,
         -0.090006736145796,
         0.0792916485093916,
         -0.054805818822617,
         0.0265076628675868,
         -0.0765750272560644,
         0.0934119683565367,
         -0.0652605537065204,
         0.010510522358539,
         0.043376947665484,
         -0.0728711230069852,
         0.0670941067416543,
         -0.0303625045149251,
         -0.0210665592656788,
         0.0662033904228243,
         -0.0878154616173132,
         0.0792916485093916,
         -0.047243695065111,
         0.0976143895581431,
         -0.0741434513245292,
         0.00524929945167877,
         0.0548271446374686,
         -0.0719063556419507,
         0.0426685683437066,
         0.011025734215928,
         -0.0571639395703935,
         0.0701326837851759,
         -0.0424178017646781,
         -0.0124048976107461,
         0.0662033904228243,
         -0.0900067361457959,
         0.0695408362094627,
         -0.105435591193283,
         0.0281788470440876,
         0.0527939664145745,
         -0.0713788922665893,
         0.0296989876621426,
         0.0307721973240736,
         -0.0656109374897907,
         0.0535461843089994,
         -0.00470373897341725,
         -0.0482764066606665,
         0.0698388727068264,
         -0.0424178017646782,
         -0.0210665592656787,
         0.0804102898371335,
         -0.0888745308726209,
         0.0976143895581432,
         0.0281788470440876,
         -0.0764910173270358,
         0.03182218674058,
         0.0370525918670986,
         -0.0666419453392907,
         0.0395034182011224,
         0.0175946507870909,
         -0.060114691941669,
         0.0568030446496133,
         -0.00932119424988255,
         -0.0482764066606663,
         0.0701326837851757,
         -0.0303625045149252,
         -0.050075125269331,
         0.100774245675637,
         -0.0765750272560643,
         -0.0741434513245293,
         0.0527939664145746,
         0.03182218674058,
         -0.0681636535795334,
         0.033260457250353,
         0.02915145441475,
         -0.0631789526770006,
         0.0435354701495337,
         0.0117894610486207,
         -0.058134816769003,
         0.0568030446496129,
         -0.00470373897341723,
         -0.0571639395703935,
         0.0670941067416542,
         0.00537893130371355,
         -0.102058045783879,
         0.048717722302772,
         0.0934119683565367,
         0.00524929945167877,
         -0.0713788922665892,
         0.0370525918670987,
         0.0332604572503537,
         -0.0642653089020537,
         0.0339092594693364,
         0.025235555990374,
         -0.0614314811871671,
         0.0446436145652268,
         0.0117894610486218,
         -0.0601146919416685,
         0.0535461843089985,
         0.0110257342159281,
         -0.0728711230069849,
         0.0419943956134321,
         0.0918252377531346,
         -0.0220334189344123,
         -0.0812884198856602,
         -0.0652605537065202,
         0.0548271446374685,
         0.0296989876621424,
         -0.0666419453392915,
         0.0291514544147501,
         0.0339092594693358,
         -0.0623839640522762,
         0.0341691043380221,
         0.0240388693812759,
         -0.0614314811871673,
         0.0435354701495323,
         0.017594650787091,
         -0.0656109374897906,
         0.0426685683437065,
         0.0433769476654838,
         -0.0784446608865079,
         -0.0719312496553814,
         0.0467399398237409,
         0.0929316058296549,
         0.0105105223585391,
         -0.0719063556419508,
         0.0307721973240737,
         0.0395034182011213,
         -0.0631789526769997,
         0.0252355559903744,
         0.0341691043380228,
         -0.0618142355518515,
         0.0341691043380227,
         0.0252355559903744,
         -0.0631789526770002,
         0.0395034182011214,
         0.0307721973240737,
         -0.0719063556419508,
         0.010510522358539,
         0.092931605829655,
         0.0467399398237408,
         -0.0719312496553812,
         -0.078444660886508,
         0.0433769476654839,
         0.0426685683437064,
         -0.0656109374897904,
         0.0175946507870909,
         0.0435354701495322,
         -0.0614314811871674,
         0.0240388693812759,
         0.0341691043380222,
         -0.0623839640522762,
         0.0339092594693356,
         0.02915145441475,
         -0.0666419453392916,
         0.0296989876621423,
         0.0548271446374687,
         -0.0652605537065204,
         -0.08128841988566,
         -0.0220334189344123,
         0.0918252377531347,
         0.0419943956134322,
         -0.072871123006985,
         0.011025734215928,
         0.0535461843089985,
         -0.0601146919416685,
         0.0117894610486219,
         0.0446436145652269,
         -0.0614314811871672,
         0.0252355559903742,
         0.0339092594693366,
         -0.0642653089020537,
         0.0332604572503538,
         0.0370525918670988,
         -0.0713788922665892,
         0.00524929945167877,
         0.0934119683565367,
         0.0487177223027718,
         -0.102058045783879,
         0.00537893130371356,
         0.0670941067416542,
         -0.0571639395703935,
         -0.00470373897341714,
         0.056803044649613,
         -0.058134816769003,
         0.0117894610486208,
         0.0435354701495337,
         -0.0631789526770007,
         0.02915145441475,
         0.0332604572503528,
         -0.0681636535795331,
         0.03182218674058,
         0.0527939664145746,
         -0.0741434513245292,
         -0.0765750272560643,
         0.100774245675637,
         -0.0500751252693309,
         -0.0303625045149254,
         0.0701326837851759,
         -0.0482764066606667,
         -0.00932119424988259,
         0.0568030446496133,
         -0.0601146919416692,
         0.0175946507870909,
         0.0395034182011223,
         -0.0666419453392907,
         0.0370525918670987,
         0.03182218674058,
         -0.0764910173270358,
         0.0281788470440875,
         0.0976143895581431,
         -0.0888745308726207,
         0.0804102898371335,
         -0.0210665592656789,
         -0.042417801764678,
         0.0698388727068263,
         -0.0482764066606664,
         -0.00470373897341706,
         0.0535461843089993,
         -0.0656109374897905,
         0.0307721973240737,
         0.0296989876621424,
         -0.071378892266589,
         0.0527939664145745,
         0.0281788470440876,
         -0.105435591193283,
         0.0695408362094625,
         -0.0900067361457959,
         0.0662033904228242,
         -0.0124048976107462,
         -0.042417801764678,
         0.0701326837851758,
         -0.0571639395703935,
         0.011025734215928,
         0.0426685683437065,
         -0.0719063556419508,
         0.0548271446374688,
         0.00524929945167884,
         -0.0741434513245293,
         0.0976143895581431,
         -0.0472436950651111,
         0.0792916485093916,
         -0.0878154616173131,
         0.0662033904228242,
         -0.0210665592656787,
         -0.0303625045149253,
         0.0670941067416542,
         -0.072871123006985,
         0.043376947665484,
         0.010510522358539,
         -0.0652605537065201,
         0.0934119683565368,
         -0.0765750272560645,
         0.0265076628675869,
         -0.0548058188226171,
         0.0792916485093917,
         -0.090006736145796,
         0.0804102898371335,
         -0.0500751252693309,
         0.00537893130371348,
         0.0419943956134323,
         -0.078444660886508,
         0.0929316058296549,
         -0.0812884198856601,
         0.0487177223027718,
         -0.0107228775957294,
         0.0265076628675868,
         -0.0472436950651111,
         0.0695408362094626,
         -0.0888745308726208,
         0.100774245675637,
         -0.102058045783879,
         0.0918252377531347,
         -0.0719312496553813,
         0.0467399398237409,
         -0.0220334189344122},
        {-0.0140842010540194,
         0.0330303792941474,
         -0.0556844122765082,
         0.0772775651575082,
         -0.0927709516143943,
         0.0983984534755009,
         -0.0927709516143944,
         0.0772775651575081,
         -0.0556844122765082,
         0.0330303792941475,
         -0.0140842010540193,
         0.0330303792941473,
         -0.0633789047430876,
         0.083869644985103,
         -0.0847211352923921,
         0.0628644659577348,
         -0.0231927379035986,
         -0.0231927379035984,
         0.0628644659577347,
         -0.084721135292392,
         0.0838696449851029,
         -0.0633789047430879,
         0.0330303792941476,
         -0.055684412276508,
         0.083869644985103,
         -0.0793162901463198,
         0.0428482511582117,
         0.0093332637583542,
         -0.0539679011500206,
         0.0713857410440316,
         -0.0539679011500206,
         0.00933326375835424,
         0.0428482511582114,
         -0.0793162901463198,
         0.0838696449851029,
         -0.055684412276508,
         0.077277565157508,
         -0.0847211352923923,
         0.0428482511582116,
         0.0181612066222881,
         -0.061282130874107,
         0.0635353430452619,
         -0.0264950850909031,
         -0.026495085090903,
         0.0635353430452619,
         -0.0612821308741069,
         0.0181612066222882,
         0.0428482511582117,
         -0.0847211352923922,
         0.0772775651575079,
         -0.0927709516143942,
         0.0628644659577346,
         0.00933326375835424,
         -0.061282130874107,
         0.0597815468887339,
         -0.0136007444152381,
         -0.0403277657959634,
         0.063614174488484,
         -0.0403277657959634,
         -0.0136007444152381,
         0.0597815468887339,
         -0.061282130874107,
         0.00933326375835417,
         0.0628644659577347,
         -0.0927709516143942,
         0.0983984534755011,
         -0.0231927379035984,
         -0.0539679011500207,
         0.063535343045262,
         -0.0136007444152381,
         -0.0438332604010926,
         0.0612823975030547,
         -0.0278966609383612,
         -0.0278966609383613,
         0.0612823975030548,
         -0.0438332604010927,
         -0.0136007444152381,
         0.063535343045262,
         -0.0539679011500207,
         -0.0231927379035985,
         0.0983984534755008,
         -0.0927709516143943,
         -0.0231927379035986,
         0.0713857410440314,
         -0.026495085090903,
         -0.0403277657959634,
         0.0612823975030547,
         -0.0239169791892552,
         -0.0333888221491059,
         0.0599760188805233,
         -0.0333888221491056,
         -0.0239169791892553,
         0.0612823975030548,
         -0.0403277657959633,
         -0.0264950850909031,
         0.0713857410440314,
         -0.0231927379035985,
         -0.0927709516143941,
         0.0772775651575081,
         0.0628644659577348,
         -0.0539679011500206,
         -0.0264950850909031,
         0.0636141744884828,
         -0.0278966609383601,
         -0.0333888221491059,
         0.0592909980904129,
         -0.0285659583729343,
         -0.0285659583729341,
         0.0592909980904125,
         -0.0333888221491055,
         -0.0278966609383601,
         0.0636141744884829,
         -0.0264950850909029,
         -0.0539679011500207,
         0.0628644659577346,
         0.0772775651575081,
         -0.0556844122765083,
         -0.0847211352923921,
         0.00933326375835435,
         0.0635353430452619,
         -0.0403277657959633,
         -0.02789666093836,
         0.0599760188805214,
         -0.0285659583729343,
         -0.0299125756131821,
         0.0582202415232116,
         -0.0299125756131822,
         -0.0285659583729342,
         0.0599760188805218,
         -0.02789666093836,
         -0.040327765795963,
         0.0635353430452621,
         0.00933326375835427,
         -0.0847211352923923,
         -0.0556844122765084,
         0.0330303792941476,
         0.0838696449851029,
         0.0428482511582118,
         -0.0612821308741071,
         -0.013600744415238,
         0.0612823975030547,
         -0.0333888221491046,
         -0.0285659583729357,
         0.0582202415232102,
         -0.0288442693412817,
         -0.0288442693412817,
         0.0582202415232103,
         -0.028565958372936,
         -0.0333888221491045,
         0.0612823975030547,
         -0.0136007444152379,
         -0.0612821308741071,
         0.0428482511582116,
         0.0838696449851029,
         0.0330303792941474,
         -0.0140842010540194,
         -0.0633789047430875,
         -0.0793162901463196,
         0.0181612066222882,
         0.0597815468887339,
         -0.0438332604010925,
         -0.023916979189255,
         0.0592909980904125,
         -0.0299125756131811,
         -0.0288442693412778,
         0.0576885386825597,
         -0.0288442693412777,
         -0.0299125756131813,
         0.0592909980904133,
         -0.0239169791892551,
         -0.0438332604010928,
         0.059781546888734,
         0.0181612066222881,
         -0.0793162901463197,
         -0.0633789047430878,
         -0.0140842010540194,
         0.0330303792941475,
         0.0838696449851032,
         0.0428482511582118,
         -0.0612821308741071,
         -0.013600744415238,
         0.0612823975030546,
         -0.0333888221491047,
         -0.0285659583729356,
         0.0582202415232104,
         -0.0288442693412816,
         -0.0288442693412816,
         0.0582202415232105,
         -0.0285659583729361,
         -0.0333888221491047,
         0.0612823975030547,
         -0.0136007444152379,
         -0.0612821308741072,
         0.0428482511582115,
         0.0838696449851028,
         0.0330303792941473,
         -0.0556844122765081,
         -0.084721135292392,
         0.00933326375835431,
         0.063535343045262,
         -0.0403277657959632,
         -0.02789666093836,
         0.0599760188805216,
         -0.0285659583729346,
         -0.0299125756131821,
         0.0582202415232116,
         -0.0299125756131818,
         -0.0285659583729342,
         0.0599760188805216,
         -0.0278966609383601,
         -0.0403277657959633,
         0.0635353430452619,
         0.00933326375835427,
         -0.0847211352923921,
         -0.0556844122765082,
         0.0772775651575081,
         0.0628644659577346,
         -0.0539679011500205,
         -0.0264950850909029,
         0.063614174488483,
         -0.0278966609383601,
         -0.0333888221491057,
         0.0592909980904128,
         -0.0285659583729344,
         -0.0285659583729342,
         0.0592909980904126,
         -0.0333888221491057,
         -0.0278966609383599,
         0.0636141744884829,
         -0.0264950850909031,
         -0.0539679011500207,
         0.0628644659577347,
         0.077277565157508,
         -0.0927709516143942,
         -0.0231927379035982,
         0.0713857410440313,
         -0.0264950850909031,
         -0.0403277657959632,
         0.0612823975030549,
         -0.0239169791892549,
         -0.0333888221491057,
         0.0599760188805231,
         -0.0333888221491057,
         -0.0239169791892551,
         0.0612823975030546,
         -0.0403277657959632,
         -0.0264950850909031,
         0.0713857410440314,
         -0.0231927379035984,
         -0.0927709516143942,
         0.0983984534755008,
         -0.0231927379035986,
         -0.0539679011500205,
         0.063535343045262,
         -0.0136007444152381,
         -0.0438332604010929,
         0.0612823975030548,
         -0.0278966609383613,
         -0.0278966609383611,
         0.0612823975030548,
         -0.0438332604010927,
         -0.013600744415238,
         0.0635353430452619,
         -0.0539679011500207,
         -0.0231927379035984,
         0.0983984534755011,
         -0.0927709516143942,
         0.0628644659577347,
         0.00933326375835421,
         -0.061282130874107,
         0.0597815468887337,
         -0.0136007444152379,
         -0.0403277657959632,
         0.063614174488484,
         -0.0403277657959632,
         -0.013600744415238,
         0.059781546888734,
         -0.0612821308741071,
         0.00933326375835425,
         0.0628644659577346,
         -0.0927709516143943,
         0.0772775651575079,
         -0.0847211352923922,
         0.0428482511582116,
         0.018161206622288,
         -0.0612821308741071,
         0.0635353430452619,
         -0.0264950850909031,
         -0.0264950850909031,
         0.0635353430452619,
         -0.0612821308741072,
         0.0181612066222881,
         0.0428482511582114,
         -0.0847211352923923,
         0.0772775651575079,
         -0.0556844122765082,
         0.0838696449851029,
         -0.0793162901463198,
         0.0428482511582116,
         0.00933326375835426,
         -0.0539679011500205,
         0.0713857410440315,
         -0.0539679011500205,
         0.00933326375835426,
         0.0428482511582114,
         -0.0793162901463197,
         0.0838696449851029,
         -0.0556844122765082,
         0.0330303792941476,
         -0.0633789047430876,
         0.0838696449851029,
         -0.0847211352923923,
         0.0628644659577346,
         -0.0231927379035986,
         -0.0231927379035986,
         0.0628644659577348,
         -0.0847211352923922,
         0.0838696449851028,
         -0.0633789047430877,
         0.0330303792941473,
         -0.0140842010540194,
         0.0330303792941474,
         -0.0556844122765081,
         0.0772775651575081,
         -0.0927709516143942,
         0.0983984534755009,
         -0.0927709516143944,
         0.0772775651575078,
         -0.0556844122765082,
         0.0330303792941476,
         -0.0140842010540194},
        {-0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075},
        {0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2},
        {-0.208514414057075,
         0.198810693121886,
         -0.189106689752548,
         0.179402358117862,
         -0.16969764190128,
         0.159992471119682,
         -0.150286757708826,
         0.140580389278883,
         -0.130873220089121,
         0.121165057680465,
         -0.111455642515071,
         0.10174461594456,
         -0.0920314678709771,
         0.0823154472914374,
         -0.0725954008640628,
         0.0628694613461931,
         -0.0531343927492252,
         0.0433840500094135,
         -0.0336051406354974,
         0.0237624228260878,
         -0.0137192412152397,
         0.0628694613461932,
         -0.0867681000188265,
         0.103577999752601,
         -0.116411621952358,
         0.126485154304226,
         -0.13442056254199,
         0.140580389278884,
         -0.145190801728125,
         0.148396282986016,
         -0.150286757708826,
         0.150911653367635,
         -0.150286757708825,
         0.148396282986016,
         -0.145190801728125,
         0.140580389278884,
         -0.13442056254199,
         0.126485154304226,
         -0.116411621952358,
         0.103577999752601,
         -0.0867681000188266,
         0.0628694613461931,
         -0.0137192412152397,
         0.023762422826088,
         -0.0336051406354974,
         0.0433840500094134,
         -0.0531343927492249,
         0.0628694613461931,
         -0.0725954008640628,
         0.0823154472914373,
         -0.0920314678709772,
         0.10174461594456,
         -0.11145564251507,
         0.121165057680465,
         -0.130873220089121,
         0.140580389278883,
         -0.150286757708826,
         0.159992471119682,
         -0.16969764190128,
         0.179402358117862,
         -0.189106689752548,
         0.198810693121886,
         -0.208514414057075},
        {-0.2,
         0.191485421551268,
         -0.182970655760877,
         0.174455675197729,
         -0.165940446799622,
         0.157424930349841,
         -0.148909076430815,
         0.140392823632607,
         -0.131876094679158,
         0.123358790948792,
         -0.114840784554536,
         0.106321906614239,
         -0.0978019293843655,
         0.0892805381522404,
         -0.080757285308725,
         0.0722315118514616,
         -0.0637022057270608,
         0.0551677284367371,
         -0.0466252404120155,
         0.038069349381344,
         -0.0294883912309794,
         0.0208514414057075,
         -0.0120385853085769,
         0.0577350269189626,
         -0.079854940950469,
         0.0955533085905908,
         -0.107676380411633,
         0.117337615205138,
         -0.125108648434245,
         0.131325461398749,
         -0.1362010449214,
         0.139875721236047,
         -0.142442462322384,
         0.143960542098033,
         -0.144463023702923,
         0.143960542098033,
         -0.142442462322384,
         0.139875721236047,
         -0.1362010449214,
         0.131325461398749,
         -0.125108648434244,
         0.117337615205138,
         -0.107676380411633,
         0.0955533085905911,
         -0.0798549409504691,
         0.0577350269189627,
         -0.0120385853085769,
         0.0208514414057075,
         -0.0294883912309794,
         0.0380693493813443,
         -0.0466252404120154,
         0.055167728436737,
         -0.0637022057270607,
         0.0722315118514616,
         -0.0807572853087249,
         0.0892805381522405,
         -0.0978019293843654,
         0.106321906614239,
         -0.114840784554536,
         0.123358790948792,
         -0.131876094679158,
         0.140392823632607,
         -0.148909076430815,
         0.157424930349841,
         -0.165940446799621,
         0.17445567519773,
         -0.182970655760877,
         0.191485421551268,
         -0.2},
        {0.208514414057075,
         -0.18860838403858,
         0.16969764190128,
         -0.151782185165071,
         0.134862010569529,
         -0.118937113759046,
         0.104007488808801,
         -0.0900731274922472,
         0.0771340181150447,
         -0.065190143594237,
         0.0542414781655109,
         -0.0442879814666055,
         0.0353295872871767,
         -0.0273661806383234,
         0.0203975467306101,
         -0.0144232436127838,
         0.00944222937462438,
         -0.00545147367118952,
         0.00243797314126603,
         -0.0889108448948776,
         0.116411621952358,
         -0.131447228194865,
         0.139284885592489,
         -0.142157041076471,
         0.141318349148707,
         -0.137588974938211,
         0.131560223340114,
         -0.123689600850734,
         0.114351076438204,
         -0.103864523120868,
         0.0925145760085928,
         -0.0805638544074685,
         0.0682632479554486,
         -0.0558609823106044,
         0.0436117893695162,
         -0.0317872807327219,
         0.0206868880864784,
         -0.0106268785498449,
         0.0336051406354976,
         -0.0552188807225864,
         0.0738669653394313,
         -0.0899080070463526,
         0.103434440432392,
         -0.11448094709498,
         0.123063320366542,
         -0.12918957469315,
         0.132863944399817,
         -0.134088522769632,
         0.132863944399817,
         -0.12918957469315,
         0.123063320366541,
         -0.11448094709498,
         0.103434440432392,
         -0.0899080070463527,
         0.0738669653394312,
         -0.0552188807225863,
         0.0336051406354975,
         -0.0106268785498451,
         0.0206868880864785,
         -0.031787280732722,
         0.0436117893695162,
         -0.0558609823106042,
         0.0682632479554488,
         -0.0805638544074686,
         0.0925145760085928,
         -0.103864523120867,
         0.114351076438204,
         -0.123689600850735,
         0.131560223340113,
         -0.13758897493821,
         0.141318349148708,
         -0.142157041076471,
         0.139284885592489,
         -0.131447228194865,
         0.116411621952358,
         -0.0889108448948773,
         0.00243797314126606,
         -0.0054514736711895,
         0.00944222937462445,
         -0.0144232436127836,
         0.0203975467306101,
         -0.0273661806383235,
         0.0353295872871768,
         -0.0442879814666057,
         0.0542414781655109,
         -0.065190143594237,
         0.0771340181150447,
         -0.0900731274922473,
         0.104007488808801,
         -0.118937113759046,
         0.134862010569529,
         -0.151782185165071,
         0.16969764190128,
         -0.188608384038579,
         0.208514414057075},
        {0.2,
         -0.182574185835055,
         0.165940446799622,
         -0.150098781703166,
         0.135049189022648,
         -0.120791666784343,
         0.107326212393534,
         -0.09465282238393,
         0.0827714920404253,
         -0.0716822148161495,
         0.061384981404485,
         -0.0518797782104316,
         0.0431665847301715,
         -0.035245368842512,
         0.0281160778557767,
         -0.0217786202592189,
         0.0162328251185891,
         -0.0114783407191696,
         0.00751433788544125,
         -0.00433840500094129,
         0.00194019369920604,
         -0.0816496580927729,
         0.107676380411633,
         -0.122555142062052,
         0.131016957881031,
         -0.135049189022648,
         0.135758113521024,
         -0.133859305132245,
         0.129862600948713,
         -0.124157238060638,
         0.117056566621426,
         -0.108823940856412,
         0.0996889572558453,
         -0.0898584117458724,
         0.0795242772487542,
         -0.0688700443150183,
         0.0580763206912502,
         -0.0473264111919651,
         0.0368125871483909,
         -0.0267437245383535,
         0.0173536200037654,
         -0.00889108448948772,
         0.0294883912309796,
         -0.0486984753557674,
         0.0655084789405155,
         -0.08023117361506,
         0.0929472264247644,
         -0.103686971902417,
         0.112464311423107,
         -0.119286415873131,
         0.124157238060638,
         -0.127078984584318,
         0.128052784147594,
         -0.127078984584318,
         0.124157238060638,
         -0.119286415873132,
         0.112464311423107,
         -0.103686971902417,
         0.0929472264247644,
         -0.08023117361506,
         0.0655084789405153,
         -0.0486984753557674,
         0.0294883912309796,
         -0.0088910844894878,
         0.0173536200037653,
         -0.0267437245383534,
         0.0368125871483909,
         -0.0473264111919648,
         0.0580763206912503,
         -0.0688700443150185,
         0.0795242772487542,
         -0.0898584117458724,
         0.0996889572558455,
         -0.108823940856411,
         0.117056566621426,
         -0.124157238060638,
         0.129862600948713,
         -0.133859305132245,
         0.135758113521024,
         -0.135049189022647,
         0.131016957881031,
         -0.122555142062052,
         0.107676380411633,
         -0.0816496580927729,
         0.00194019369920602,
         -0.00433840500094122,
         0.00751433788544118,
         -0.0114783407191697,
         0.0162328251185892,
         -0.021778620259219,
         0.0281160778557766,
         -0.0352453688425121,
         0.0431665847301716,
         -0.0518797782104315,
         0.0613849814044851,
         -0.0716822148161496,
         0.082771492040425,
         -0.0946528223839297,
         0.107326212393534,
         -0.120791666784344,
         0.135049189022648,
         -0.150098781703166,
         0.165940446799622,
         -0.182574185835055,
         0.2},
        {-0.0294883912309793,
         0.0486984753557671,
         -0.0655084789405153,
         0.0802311736150602,
         -0.0929472264247645,
         0.103686971902417,
         -0.112464311423107,
         0.119286415873132,
         -0.124157238060638,
         0.127078984584318,
         -0.128052784147594,
         0.127078984584318,
         -0.124157238060638,
         0.119286415873131,
         -0.112464311423107,
         0.103686971902417,
         -0.0929472264247646,
         0.0802311736150601,
         -0.0655084789405155,
         0.0486984753557674,
         -0.0294883912309795,
         0.0955533085905911,
         -0.119451976557767,
         0.127743744052502,
         -0.126856623985998,
         0.11964090823227,
         -0.107772477155804,
         0.0923988604210823,
         -0.0743881498489145,
         0.0544465506480475,
         -0.0331824176365019,
         0.0111455642515072,
         0.0111455642515074,
         -0.0331824176365019,
         0.0544465506480477,
         -0.0743881498489144,
         0.0923988604210824,
         -0.107772477155804,
         0.11964090823227,
         -0.126856623985998,
         0.127743744052502,
         -0.119451976557767,
         0.0955533085905912,
         -0.182970655760877,
         0.133069567826092,
         -0.0879209644565252,
         0.0475248456521757,
         -0.0118812114130437,
         -0.0190099382608698,
         0.045148603369567,
         -0.0665347839130466,
         0.0831684798913068,
         -0.0950496913043527,
         0.102178418152177,
         -0.104554660434787,
         0.102178418152177,
         -0.0950496913043525,
         0.0831684798913067,
         -0.0665347839130468,
         0.0451486033695668,
         -0.0190099382608698,
         -0.011881211413044,
         0.0475248456521757,
         -0.0879209644565252,
         0.133069567826092,
         -0.182970655760877,
         0.095553308590591,
         -0.119451976557767,
         0.127743744052502,
         -0.126856623985997,
         0.11964090823227,
         -0.107772477155804,
         0.0923988604210824,
         -0.0743881498489144,
         0.0544465506480477,
         -0.033182417636502,
         0.0111455642515073,
         0.0111455642515073,
         -0.0331824176365021,
         0.0544465506480476,
         -0.0743881498489144,
         0.0923988604210825,
         -0.107772477155804,
         0.11964090823227,
         -0.126856623985998,
         0.127743744052502,
         -0.119451976557767,
         0.0955533085905911,
         -0.0294883912309794,
         0.0486984753557674,
         -0.0655084789405155,
         0.0802311736150601,
         -0.0929472264247645,
         0.103686971902417,
         -0.112464311423107,
         0.119286415873131,
         -0.124157238060638,
         0.127078984584318,
         -0.128052784147594,
         0.127078984584318,
         -0.124157238060638,
         0.119286415873131,
         -0.112464311423106,
         0.103686971902417,
         -0.0929472264247644,
         0.0802311736150602,
         -0.0655084789405156,
         0.0486984753557673,
         -0.0294883912309795},
        {0.0261488180184245,
         -0.0433629090391994,
         0.0585975066149906,
         -0.0721285445691049,
         0.0840272115327143,
         -0.0943203110164195,
         0.103020167739045,
         -0.110133191887854,
         0.115662986393248,
         -0.119611659505074,
         0.121980437173918,
         -0.12276996280897,
         0.121980437173918,
         -0.119611659505074,
         0.115662986393248,
         -0.110133191887855,
         0.103020167739045,
         -0.0943203110164194,
         0.0840272115327145,
         -0.072128544569105,
         0.0585975066149906,
         -0.0433629090391994,
         0.0261488180184243,
         -0.0886749562348232,
         0.112089707663561,
         -0.121476730532822,
         0.122618525767479,
         -0.118048041162471,
         0.109235374992529,
         -0.0971729715461465,
         0.0825998939158907,
         -0.0661069030509841,
         0.0481929109971861,
         -0.0292987533074958,
         0.00982946374365937,
         0.00982946374365957,
         -0.029298753307496,
         0.0481929109971859,
         -0.0661069030509841,
         0.0825998939158906,
         -0.0971729715461463,
         0.109235374992529,
         -0.118048041162471,
         0.122618525767479,
         -0.121476730532822,
         0.112089707663561,
         -0.0886749562348233,
         0.177349912469647,
         -0.133012434352236,
         0.0925303891145986,
         -0.0559037767567368,
         0.0231325972786493,
         0.00578314931966218,
         -0.030843463038199,
         0.0520483438769619,
         -0.0693977918359487,
         0.0828918069151618,
         -0.0925303891145973,
         0.0983135384342618,
         -0.100241254874148,
         0.0983135384342616,
         -0.0925303891145975,
         0.0828918069151618,
         -0.0693977918359484,
         0.052048343876962,
         -0.0308434630381991,
         0.00578314931966222,
         0.0231325972786493,
         -0.0559037767567364,
         0.0925303891145986,
         -0.133012434352236,
         0.177349912469646,
         -0.0886749562348233,
         0.112089707663561,
         -0.121476730532822,
         0.122618525767479,
         -0.118048041162471,
         0.109235374992529,
         -0.0971729715461468,
         0.0825998939158905,
         -0.0661069030509845,
         0.0481929109971861,
         -0.0292987533074959,
         0.00982946374365942,
         0.00982946374365937,
         -0.0292987533074959,
         0.0481929109971859,
         -0.0661069030509843,
         0.0825998939158906,
         -0.0971729715461466,
         0.109235374992529,
         -0.118048041162471,
         0.122618525767479,
         -0.121476730532822,
         0.112089707663561,
         -0.0886749562348233,
         0.0261488180184242,
         -0.0433629090391993,
         0.0585975066149907,
         -0.0721285445691051,
         0.0840272115327146,
         -0.0943203110164196,
         0.103020167739046,
         -0.110133191887854,
         0.115662986393248,
         -0.119611659505074,
         0.121980437173918,
         -0.12276996280897,
         0.121980437173918,
         -0.119611659505074,
         0.115662986393248,
         -0.110133191887854,
         0.103020167739046,
         -0.0943203110164194,
         0.0840272115327144,
         -0.0721285445691052,
         0.0585975066149905,
         -0.0433629090391993,
         0.0261488180184245},
        {0.208514414057075,
         -0.177821689789755,
         0.150286757708826,
         -0.125738922692386,
         0.104007488808801,
         -0.0849217590032647,
         0.068311034624203,
         -0.0540046146837768,
         0.0418317946577229,
         -0.031621864445673,
         0.0232041047050925,
         -0.0164077797883333,
         0.0110621228766216,
         -0.00699630080935583,
         0.00403931615561304,
         -0.00201965807780655,
         0.000763359001036961,
         -0.108893101296094,
         0.13442056254199,
         -0.142574536956527,
         0.141318349148708,
         -0.134273090679113,
         0.12357931139425,
         -0.110676525559856,
         0.0966063916252862,
         -0.0821560137749424,
         0.0679346624232152,
         -0.0544184492006794,
         0.0419778048561338,
         -0.0308948278485627,
         0.0213740520290352,
         -0.0135482782598458,
         0.00747936017240506,
         -0.0031474097915413,
         0.053134392749225,
         -0.0823154472914372,
         0.103434440432393,
         -0.117765290957257,
         0.126127606533509,
         -0.12924233743772,
         0.12779824364991,
         -0.12247095437412,
         0.113929892405108,
         -0.102841202370571,
         0.0898691110864763,
         -0.0756765639201061,
         0.0609254221457412,
         -0.0462761800973872,
         0.0323865795667822,
         -0.0199059673423732,
         0.00944222937462423,
         -0.0237624228260878,
         0.0436117893695163,
         -0.0629481958308289,
         0.0807863231122613,
         -0.0963315506939029,
         0.108986708380599,
         -0.118318182686717,
         0.124031156818979,
         -0.125954235171101,
         0.124031156818979,
         -0.118318182686717,
         0.108986708380599,
         -0.0963315506939028,
         0.0807863231122616,
         -0.0629481958308287,
         0.0436117893695163,
         -0.0237624228260877,
         0.00944222937462413,
         -0.0199059673423734,
         0.032386579566782,
         -0.0462761800973872,
         0.0609254221457411,
         -0.0756765639201058,
         0.0898691110864763,
         -0.102841202370571,
         0.113929892405108,
         -0.12247095437412,
         0.12779824364991,
         -0.12924233743772,
         0.12612760653351,
         -0.117765290957256,
         0.103434440432393,
         -0.0823154472914371,
         0.053134392749225,
         -0.0031474097915414,
         0.00747936017240526,
         -0.013548278259846,
         0.0213740520290352,
         -0.0308948278485625,
         0.0419778048561337,
         -0.0544184492006795,
         0.0679346624232156,
         -0.0821560137749422,
         0.0966063916252861,
         -0.110676525559855,
         0.12357931139425,
         -0.134273090679114,
         0.141318349148707,
         -0.142574536956527,
         0.13442056254199,
         -0.108893101296094,
         0.000763359001036998,
         -0.00201965807780664,
         0.00403931615561299,
         -0.00699630080935571,
         0.0110621228766218,
         -0.0164077797883338,
         0.0232041047050925,
         -0.0316218644456729,
         0.0418317946577229,
         -0.0540046146837765,
         0.068311034624203,
         -0.0849217590032647,
         0.104007488808801,
         -0.125738922692386,
         0.150286757708826,
         -0.177821689789755,
         0.208514414057075},
        {-0.2,
         0.173205080756888,
         -0.148909076430815,
         0.126990087067608,
         -0.107326212393534,
         0.0897955517089757,
         -0.0742762037360524,
         0.060646266394778,
         -0.0487838364648459,
         0.0385670090575225,
         -0.0298738767585631,
         0.0225825281715857,
         -0.0165710452999832,
         0.0117174985029676,
         -0.00789993587911397,
         0.00499635814945703,
         -0.00288464872255689,
         0.00144232436127842,
         -0.000545147367118896,
         0.1,
         -0.125108648434245,
         0.134693327563464,
         -0.135758113521024,
         0.131447228194865,
         -0.12360307436176,
         0.113458775318141,
         -0.101906110803917,
         0.089621630275689,
         -0.0771340181150449,
         0.0648633738994425,
         -0.0531455777599267,
         0.0422480416726224,
         -0.0323801016030074,
         0.0236998076373419,
         -0.016318037384488,
         0.0103002561968133,
         -0.00566533762477454,
         0.00237624228260884,
         -0.0466252404120157,
         0.0730477130336512,
         -0.0929472264247646,
         0.107326212393534,
         -0.116793927158658,
         0.121874274893428,
         -0.123063320366542,
         0.120845781611202,
         -0.115701027172567,
         0.108105623165737,
         -0.0985345383447488,
         0.0874617555238114,
         -0.0753605852376708,
         0.0627037971284764,
         -0.0499635814945699,
         0.0376112177805136,
         -0.0261159160485917,
         0.0159403178247676,
         -0.00751433788544136,
         0.0198810693121885,
         -0.0368125871483909,
         0.0536631061967668,
         -0.0696424427962446,
         0.0841012396737774,
         -0.0965388110702333,
         0.106575961711488,
         -0.113934495540093,
         0.118423776802055,
         -0.11993242076617,
         0.118423776802055,
         -0.113934495540093,
         0.106575961711488,
         -0.0965388110702332,
         0.0841012396737774,
         -0.0696424427962445,
         0.0536631061967669,
         -0.0368125871483909,
         0.0198810693121886,
         -0.00751433788544138,
         0.0159403178247675,
         -0.0261159160485917,
         0.0376112177805137,
         -0.0499635814945697,
         0.0627037971284763,
         -0.0753605852376708,
         0.0874617555238116,
         -0.0985345383447485,
         0.108105623165737,
         -0.115701027172567,
         0.120845781611202,
         -0.123063320366542,
         0.121874274893428,
         -0.116793927158657,
         0.107326212393534,
         -0.0929472264247646,
         0.073047713033651,
         -0.0466252404120157,
         0.00237624228260874,
         -0.00566533762477449,
         0.0103002561968134,
         -0.0163180373844881,
         0.0236998076373419,
         -0.0323801016030076,
         0.0422480416726223,
         -0.0531455777599266,
         0.0648633738994425,
         -0.0771340181150452,
         0.0896216302756891,
         -0.101906110803918,
         0.113458775318141,
         -0.12360307436176,
         0.131447228194865,
         -0.135758113521024,
         0.134693327563464,
         -0.125108648434245,
         0.1,
         -0.000545147367118994,
         0.00144232436127824,
         -0.00288464872255671,
         0.00499635814945703,
         -0.00789993587911403,
         0.0117174985029677,
         -0.0165710452999833,
         0.0225825281715859,
         -0.0298738767585629,
         0.0385670090575224,
         -0.048783836464846,
         0.0606462663947781,
         -0.0742762037360523,
         0.0897955517089759,
         -0.107326212393534,
         0.126990087067608,
         -0.148909076430815,
         0.173205080756888,
         -0.2},
        {0.0466252404120159,
         -0.0730477130336509,
         0.0929472264247648,
         -0.107326212393534,
         0.116793927158657,
         -0.121874274893428,
         0.123063320366542,
         -0.120845781611202,
         0.115701027172567,
         -0.108105623165737,
         0.0985345383447481,
         -0.0874617555238114,
         0.075360585237671,
         -0.0627037971284762,
         0.0499635814945696,
         -0.0376112177805138,
         0.0261159160485917,
         -0.0159403178247675,
         0.00751433788544142,
         -0.117337615205138,
         0.129862600948713,
         -0.119640908232271,
         0.097974979232549,
         -0.0703641454170108,
         0.040208083095435,
         -0.00985295114570956,
         -0.0189890825900159,
         0.0450365637461236,
         -0.0673280907939599,
         0.0851576491879145,
         -0.0980356260840589,
         0.105665817277909,
         -0.107933672010026,
         0.104903692446907,
         -0.096825702671714,
         0.0841512850454623,
         -0.0675630935705769,
         0.0480173442533384,
         -0.0267437245383535,
         0.165940446799622,
         -0.0791090040330685,
         0.0118812114130441,
         0.0375716894272061,
         -0.0710785205382363,
         0.0904681869647283,
         -0.0975697035377841,
         0.0942122327658061,
         -0.0822251395875704,
         0.0634380724473147,
         -0.0396810867483093,
         0.0127848390108053,
         0.0154190960014323,
         -0.0430976835134962,
         0.0684154515958089,
         -0.0895326066299585,
         0.104601075918278,
         -0.111755210259386,
         0.109086244827494,
         -0.0945533448762735,
         0.0655084789405154,
         -0.122555142062052,
         0.126856623985997,
         -0.106268785498451,
         0.0746473775339009,
         -0.0389313090528856,
         0.00344781468108001,
         0.0288464872255671,
         -0.055860982310605,
         0.0761256869367765,
         -0.088659802008235,
         0.0928992536595426,
         -0.0886598020082352,
         0.0761256869367765,
         -0.055860982310605,
         0.028846487225567,
         0.00344781468107993,
         -0.0389313090528856,
         0.0746473775339011,
         -0.10626878549845,
         0.126856623985998,
         -0.122555142062052,
         0.0655084789405154,
         -0.0945533448762735,
         0.109086244827494,
         -0.111755210259386,
         0.104601075918278,
         -0.0895326066299585,
         0.0684154515958091,
         -0.0430976835134964,
         0.0154190960014324,
         0.0127848390108052,
         -0.0396810867483093,
         0.0634380724473147,
         -0.0822251395875705,
         0.0942122327658062,
         -0.097569703537784,
         0.0904681869647282,
         -0.0710785205382361,
         0.0375716894272061,
         0.0118812114130439,
         -0.0791090040330684,
         0.165940446799622,
         -0.0267437245383535,
         0.0480173442533381,
         -0.067563093570577,
         0.0841512850454623,
         -0.0968257026717137,
         0.104903692446907,
         -0.107933672010026,
         0.10566581727791,
         -0.0980356260840587,
         0.0851576491879147,
         -0.0673280907939599,
         0.0450365637461236,
         -0.018989082590016,
         -0.0098529511457096,
         0.040208083095435,
         -0.0703641454170108,
         0.0979749792325488,
         -0.119640908232271,
         0.129862600948713,
         -0.117337615205138,
         0.00751433788544133,
         -0.0159403178247675,
         0.0261159160485917,
         -0.0376112177805136,
         0.0499635814945696,
         -0.0627037971284764,
         0.0753605852376709,
         -0.0874617555238114,
         0.0985345383447482,
         -0.108105623165737,
         0.115701027172567,
         -0.120845781611202,
         0.123063320366542,
         -0.121874274893428,
         0.116793927158657,
         -0.107326212393534,
         0.0929472264247646,
         -0.0730477130336511,
         0.0466252404120159},
        {0.0413449115297363,
         -0.0653720450460613,
         0.0840272115327152,
         -0.0981226431885827,
         0.108125886555354,
         -0.11442968244554,
         0.117402377025102,
         -0.117402377025102,
         0.114783407191697,
         -0.109896745565965,
         0.103092285471181,
         -0.0947190826807277,
         0.0851256530758749,
         -0.0746601366789442,
         0.0636703784926346,
         -0.0525039391496377,
         0.0415080084609348,
         -0.0310291042511929,
         0.0214121161809917,
         -0.0129966615864026,
         0.00609597463299547,
         -0.109388353885649,
         0.124034734589209,
         -0.118048041162472,
         0.101340630121396,
         -0.0786731384349308,
         0.0529706500093358,
         -0.0262519695748188,
         0.0246594315548691,
         -0.0468601297596284,
         0.0659380473395782,
         -0.0813956927556482,
         0.0928797020958919,
         -0.100167084494127,
         0.103157803295062,
         -0.101872605588216,
         0.0964558953020623,
         -0.0871842563632694,
         0.0744821623216877,
         -0.0589473161686072,
         0.0413857460202126,
         -0.022809048515134,
         0.162249148918527,
         -0.0847318545736321,
         0.0231325972786495,
         0.0238940716053833,
         -0.057693634852283,
         0.0796116186009969,
         -0.0909936047528788,
         0.0931852478808797,
         -0.0875322986906951,
         0.0753806372011361,
         -0.0580763206912495,
         0.0369656546990477,
         -0.0133953011342621,
         -0.0112875516858609,
         0.0357349113008493,
         -0.0585975066149898,
         0.0785239320534723,
         -0.0941589968723318,
         0.104140258564539,
         -0.107089877687036,
         0.101592240670543,
         -0.086116001282196,
         0.0585975066149909,
         -0.114727473442037,
         0.122618525767479,
         -0.107679517789598,
         0.0819746924246201,
         -0.0514782186738534,
         0.0199101777747942,
         0.0101673440968415,
         -0.0369068576923704,
         0.0589595955805022,
         -0.075358225832363,
         0.08544932592822,
         -0.0888543756323411,
         0.0854493259282199,
         -0.0753582258323632,
         0.0589595955805025,
         -0.0369068576923705,
         0.0101673440968416,
         0.0199101777747941,
         -0.0514782186738535,
         0.0819746924246202,
         -0.107679517789598,
         0.122618525767479,
         -0.114727473442037,
         0.0585975066149909,
         -0.0861160012821958,
         0.101592240670544,
         -0.107089877687037,
         0.104140258564539,
         -0.0941589968723316,
         0.0785239320534724,
         -0.0585975066149897,
         0.0357349113008493,
         -0.0112875516858607,
         -0.013395301134262,
         0.0369656546990476,
         -0.0580763206912497,
         0.0753806372011361,
         -0.0875322986906951,
         0.0931852478808798,
         -0.0909936047528786,
         0.0796116186009971,
         -0.0576936348522829,
         0.0238940716053833,
         0.0231325972786497,
         -0.0847318545736322,
         0.162249148918527,
         -0.0228090485151341,
         0.0413857460202126,
         -0.058947316168607,
         0.0744821623216877,
         -0.0871842563632695,
         0.0964558953020623,
         -0.101872605588216,
         0.103157803295062,
         -0.100167084494127,
         0.092879702095892,
         -0.0813956927556482,
         0.0659380473395784,
         -0.0468601297596283,
         0.0246594315548692,
         -0.0262519695748188,
         0.0529706500093358,
         -0.0786731384349311,
         0.101340630121396,
         -0.118048041162471,
         0.124034734589209,
         -0.109388353885649,
         0.00609597463299538,
         -0.0129966615864026,
         0.0214121161809918,
         -0.031029104251193,
         0.0415080084609346,
         -0.0525039391496379,
         0.0636703784926346,
         -0.0746601366789441,
         0.0851256530758749,
         -0.0947190826807275,
         0.103092285471181,
         -0.109896745565964,
         0.114783407191697,
         -0.117402377025102,
         0.117402377025102,
         -0.11442968244554,
         0.108125886555354,
         -0.0981226431885832,
         0.0840272115327148,
         -0.0653720450460615,
         0.0413449115297362},
        {-0.208514414057075,
         0.166336959782615,
         -0.130873220089121,
         0.10137396037394,
         -0.077134018115045,
         0.0574923026276471,
         -0.0418317946577232,
         0.029579545671679,
         -0.0202066765451432,
         0.0132283749730868,
         -0.00820388989416671,
         0.00473651803879927,
         -0.00247356587275822,
         0.00110621228766223,
         -0.00036873742922068,
         0.125738922692386,
         -0.145190801728126,
         0.143364429632299,
         -0.131560223340114,
         0.114984605255294,
         -0.0966063916252862,
         0.07826012174154,
         -0.0610992468132238,
         0.0458244351099181,
         -0.0328155595766672,
         0.0222162388558719,
         -0.0139926016187112,
         0.00797701024942859,
         -0.00390235014719723,
         0.00142811392249519,
         -0.0725954008640628,
         0.105200730396178,
         -0.123063320366542,
         0.129720129593753,
         -0.12779824364991,
         0.119544310592355,
         -0.106923681923142,
         0.0916488702198361,
         -0.075189892866205,
         0.0587786430798473,
         -0.0434109048866424,
         0.0298472393241457,
         -0.0186130239153331,
         0.00999679745746633,
         -0.00403931615561313,
         0.0397621386243772,
         -0.0682632479554488,
         0.0917259832921405,
         -0.108986708380599,
         0.119544310592355,
         -0.123464833082144,
         0.12124005927086,
         -0.113676432931181,
         0.101807596214252,
         -0.0868218097732852,
         0.0699979808565973,
         -0.0526455817156777,
         0.0360439658233228,
         -0.0213740520290354,
         0.00961549574185587,
         -0.02039754673061,
         0.0402245046125974,
         -0.0609254221457413,
         0.0805967577596292,
         -0.0976075208680203,
         0.110676525559856,
         -0.118885659240627,
         0.121683351642838,
         -0.118885659240627,
         0.110676525559856,
         -0.0976075208680204,
         0.0805967577596294,
         -0.0609254221457415,
         0.0402245046125971,
         -0.02039754673061,
         0.00961549574185578,
         -0.0213740520290354,
         0.0360439658233227,
         -0.0526455817156778,
         0.0699979808565973,
         -0.0868218097732853,
         0.101807596214252,
         -0.113676432931181,
         0.12124005927086,
         -0.123464833082144,
         0.119544310592356,
         -0.108986708380599,
         0.0917259832921404,
         -0.0682632479554489,
         0.0397621386243772,
         -0.00403931615561302,
         0.00999679745746632,
         -0.0186130239153332,
         0.0298472393241457,
         -0.0434109048866424,
         0.0587786430798471,
         -0.0751898928662049,
         0.0916488702198362,
         -0.106923681923142,
         0.119544310592355,
         -0.12779824364991,
         0.129720129593753,
         -0.123063320366542,
         0.105200730396178,
         -0.0725954008640629,
         0.00142811392249523,
         -0.00390235014719719,
         0.00797701024942856,
         -0.0139926016187112,
         0.022216238855872,
         -0.0328155595766671,
         0.0458244351099182,
         -0.061099246813224,
         0.0782601217415401,
         -0.0966063916252861,
         0.114984605255294,
         -0.131560223340114,
         0.1433644296323,
         -0.145190801728125,
         0.125738922692386,
         -0.000368737429220699,
         0.00110621228766218,
         -0.00247356587275813,
         0.00473651803879927,
         -0.0082038898941667,
         0.0132283749730869,
         -0.0202066765451432,
         0.0295795456716791,
         -0.0418317946577229,
         0.057492302627647,
         -0.0771340181150452,
         0.10137396037394,
         -0.130873220089121,
         0.166336959782615,
         -0.208514414057075},
        {0.2,
         -0.163299316185545,
         0.131876094679158,
         -0.105200730396178,
         0.0827714920404253,
         -0.0641145220426613,
         0.0487838364648458,
         -0.0363613248462094,
         0.0264567499461737,
         -0.0187077472950962,
         0.012779824364991,
         -0.00836635893154456,
         0.0051885955477609,
         -0.00299563703621595,
         0.00156442042007567,
         -0.000699630080935659,
         0.000233210026978555,
         -0.115470053837925,
         0.1362010449214,
         -0.137740088630036,
         0.129862600948713,
         -0.117056566621426,
         0.101906110803918,
         -0.0860465995237514,
         0.0705513331897965,
         -0.0561232418852884,
         0.0432036917470211,
         -0.0320407153371208,
         0.0227352865862363,
         -0.0152748117033061,
         0.00955876665830791,
         -0.00541931130393837,
         0.00263847026427541,
         -0.000961549574185549,
         0.0637022057270609,
         -0.0940943937793926,
         0.112464311423107,
         -0.121475340026357,
         0.123063320366541,
         -0.118890462604571,
         0.110430303840936,
         -0.0989920938661319,
         0.0857296680618837,
         -0.071645217541522,
         0.0575910733275195,
         -0.0442706102239424,
         0.0322387031038519,
         -0.0219018858810584,
         0.0135181374477392,
         -0.00719557813400163,
         0.00288464872255681,
         -0.0332673919565228,
         0.0580763206912504,
         -0.0795242772487545,
         0.096538811070233,
         -0.108531647067913,
         0.115340690634633,
         -0.117129025041625,
         0.114306224082512,
         -0.107467826312283,
         0.0973466813142704,
         -0.0847717646106345,
         0.0706314596587652,
         -0.0558390717459996,
         0.041298592072721,
         -0.0278683542793228,
         0.016318037384488,
         -0.00725954008640627,
         0.0162328251185891,
         -0.0324656502371784,
         0.0499635814945698,
         -0.0673084701929911,
         0.0832399734830289,
         -0.0967161093115552,
         0.106923681923142,
         -0.113281035444729,
         0.115438963354368,
         -0.113281035444729,
         0.106923681923142,
         -0.0967161093115552,
         0.0832399734830289,
         -0.0673084701929912,
         0.0499635814945699,
         -0.0324656502371784,
         0.0162328251185892,
         -0.00725954008640626,
         0.0163180373844881,
         -0.0278683542793228,
         0.041298592072721,
         -0.0558390717459997,
         0.0706314596587653,
         -0.0847717646106344,
         0.0973466813142707,
         -0.107467826312283,
         0.114306224082512,
         -0.117129025041624,
         0.115340690634633,
         -0.108531647067913,
         0.0965388110702332,
         -0.0795242772487545,
         0.0580763206912506,
         -0.033267391956523,
         0.00288464872255675,
         -0.00719557813400168,
         0.0135181374477391,
         -0.0219018858810584,
         0.0322387031038518,
         -0.0442706102239422,
         0.0575910733275197,
         -0.0716452175415218,
         0.0857296680618837,
         -0.0989920938661319,
         0.110430303840936,
         -0.118890462604571,
         0.123063320366541,
         -0.121475340026357,
         0.112464311423107,
         -0.0940943937793926,
         0.0637022057270607,
         -0.000961549574185607,
         0.00263847026427541,
         -0.00541931130393849,
         0.0095587666583083,
         -0.0152748117033061,
         0.0227352865862361,
         -0.0320407153371205,
         0.0432036917470212,
         -0.0561232418852886,
         0.0705513331897966,
         -0.0860465995237512,
         0.101906110803917,
         -0.117056566621426,
         0.129862600948713,
         -0.137740088630036,
         0.1362010449214,
         -0.115470053837925,
         0.000233210026978555,
         -0.000699630080935522,
         0.00156442042007552,
         -0.00299563703621599,
         0.00518859554776099,
         -0.0083663589315446,
         0.0127798243649909,
         -0.0187077472950961,
         0.0264567499461736,
         -0.0363613248462094,
         0.0487838364648457,
         -0.064114522042661,
         0.0827714920404253,
         -0.105200730396178,
         0.131876094679158,
         -0.163299316185545,
         0.2},
        {-0.0637022057270606,
         0.0940943937793929,
         -0.112464311423107,
         0.121475340026357,
         -0.123063320366542,
         0.118890462604571,
         -0.110430303840935,
         0.0989920938661318,
         -0.0857296680618838,
         0.0716452175415218,
         -0.0575910733275195,
         0.0442706102239421,
         -0.0322387031038517,
         0.0219018858810583,
         -0.0135181374477391,
         0.00719557813400182,
         -0.00288464872255669,
         0.131325461398749,
         -0.12484509505868,
         0.0923988604210823,
         -0.0513327002339339,
         0.0098529511457096,
         0.0275177949876421,
         -0.0582679814381199,
         0.0811627854105607,
         -0.0958486827374322,
         0.102608767899176,
         -0.102194698737011,
         0.0957011096202905,
         -0.0844646989949636,
         0.0699775822022644,
         -0.0538078759071259,
         0.0375214568648992,
         -0.0225964149933613,
         0.0103002561968135,
         -0.148909076430815,
         0.0299318505696587,
         0.0451486033695668,
         -0.0850150283987609,
         0.0975697035377841,
         -0.089934446690226,
         0.0684506191293029,
         -0.0386791326702764,
         0.00540046146837739,
         0.0273853379249809,
         -0.0564585911251978,
         0.0793799403641465,
         -0.094490216339361,
         0.100910170005894,
         -0.0985398606521681,
         0.0880570921923647,
         -0.0709127369301871,
         0.0493129914669889,
         -0.0261159160485915,
         0.134693327563464,
         -0.107772477155803,
         0.0563992650122376,
         -0.00344781468107894,
         -0.040819369032223,
         0.0715954782824064,
         -0.0871893667044784,
         0.0879282215282312,
         -0.0755237551973739,
         0.0526493633779916,
         -0.0226250645215255,
         -0.0108396978147249,
         0.0438735563718569,
         -0.0726599887815969,
         0.0936593070220638,
         -0.103852965144147,
         0.101031854308481,
         -0.0841512850454626,
         0.0536631061967669,
         -0.0929472264247643,
         0.11313176126752,
         -0.104601075918279,
         0.078015140520512,
         -0.0417597609625957,
         0.00275937825164705,
         0.0333702280347472,
         -0.0622781190746283,
         0.0808623851364087,
         -0.0872636538979309,
         0.0808623851364087,
         -0.0622781190746281,
         0.0333702280347471,
         0.00275937825164703,
         -0.0417597609625957,
         0.0780151405205122,
         -0.104601075918279,
         0.11313176126752,
         -0.0929472264247644,
         0.053663106196767,
         -0.0841512850454623,
         0.101031854308481,
         -0.103852965144148,
         0.0936593070220635,
         -0.0726599887815972,
         0.0438735563718569,
         -0.010839697814725,
         -0.0226250645215255,
         0.0526493633779917,
         -0.0755237551973737,
         0.0879282215282312,
         -0.0871893667044785,
         0.0715954782824063,
         -0.0408193690322231,
         -0.00344781468107896,
         0.0563992650122375,
         -0.107772477155803,
         0.134693327563464,
         -0.0261159160485916,
         0.0493129914669888,
         -0.070912736930187,
         0.0880570921923646,
         -0.0985398606521681,
         0.100910170005894,
         -0.0944902163393612,
         0.0793799403641463,
         -0.0564585911251978,
         0.0273853379249809,
         0.00540046146837742,
         -0.0386791326702764,
         0.068450619129303,
         -0.0899344466902261,
         0.0975697035377843,
         -0.0850150283987611,
         0.0451486033695669,
         0.0299318505696586,
         -0.148909076430815,
         0.0103002561968133,
         -0.0225964149933613,
         0.0375214568648993,
         -0.0538078759071258,
         0.0699775822022647,
         -0.0844646989949636,
         0.0957011096202905,
         -0.102194698737011,
         0.102608767899176,
         -0.0958486827374326,
         0.0811627854105607,
         -0.0582679814381196,
         0.0275177949876422,
         0.00985295114570949,
         -0.0513327002339341,
         0.0923988604210824,
         -0.12484509505868,
         0.131325461398749,
         -0.00288464872255675,
         0.0071955781340017,
         -0.0135181374477391,
         0.0219018858810585,
         -0.0322387031038517,
         0.044270610223942,
         -0.0575910733275195,
         0.0716452175415217,
         -0.085729668061884,
         0.0989920938661317,
         -0.110430303840935,
         0.118890462604571,
         -0.123063320366542,
         0.121475340026357,
         -0.112464311423107,
         0.094094393779393,
         -0.0637022057270607},
        {-0.0564879030490883,
         0.0847318545736325,
         -0.103020167739046,
         0.113421471757929,
         -0.117402377025102,
         0.116222423690617,
         -0.111007972841776,
         0.102773412491922,
         -0.0924288746692088,
         0.0807835179828969,
         -0.0685470880485741,
         0.056330722230163,
         -0.0446473881685945,
         0.0339121257268508,
         -0.0244421636055693,
         0.01645691680258,
         -0.010077762226439,
         0.00532704605590821,
         -0.00212234594975446,
         0.123112530461749,
         -0.122299897617557,
         0.0971729715461462,
         -0.0627672826066158,
         0.0262519695748186,
         0.00830160169218678,
         -0.0384850901986859,
         0.062935604932447,
         -0.0810101949664963,
         0.0925892024127224,
         -0.097944810292372,
         0.0976458208580636,
         -0.0924838754920881,
         0.0834128002254339,
         -0.0714959398408669,
         0.0578579279227345,
         -0.0436379905069772,
         0.0299416504168225,
         -0.0177853350377522,
         0.00801168026750698,
         -0.147147618575435,
         0.0402980349884655,
         0.0308434630381995,
         -0.0726535469693911,
         0.0909936047528793,
         -0.0912097418857718,
         0.0781327830029685,
         -0.0560782742895155,
         0.0288464872255671,
         0.000277575452747542,
         -0.0285241699893709,
         0.0536387950747831,
         -0.0738821627401351,
         0.0880301447023042,
         -0.0953736678036667,
         0.0957184958275825,
         -0.0893847330744625,
         0.0772055590003796,
         -0.0605234527376003,
         0.0411758946976256,
         -0.0214121161809917,
         0.12743357579271,
         -0.109235374992529,
         0.0667788994813717,
         -0.0199101777747936,
         -0.0221869637811622,
         0.0548292693079082,
         -0.0758706063916955,
         0.0848061062594847,
         -0.0822701051467927,
         0.0697123441284551,
         -0.049165791682198,
         0.023065262720449,
         0.00590506419554788,
         -0.034948570051343,
         0.0612870005257398,
         -0.0822932268976484,
         0.0956344970071498,
         -0.0994370137557108,
         0.092486827907665,
         -0.0744821623216876,
         0.0462554575910635,
         -0.0840272115327149,
         0.106387552459446,
         -0.104140258564539,
         0.0854312507390971,
         -0.0566878886064812,
         0.0233254870749147,
         0.0101200171800083,
         -0.0399539579865405,
         0.063309113285351,
         -0.0781399022327733,
         0.0832197475142004,
         -0.0781399022327735,
         0.063309113285351,
         -0.0399539579865404,
         0.0101200171800083,
         0.0233254870749148,
         -0.0566878886064811,
         0.0854312507390971,
         -0.104140258564539,
         0.106387552459445,
         -0.0840272115327149,
         0.0462554575910635,
         -0.0744821623216876,
         0.0924868279076649,
         -0.0994370137557105,
         0.0956344970071498,
         -0.0822932268976484,
         0.0612870005257397,
         -0.0349485700513431,
         0.0059050641955479,
         0.0230652627204489,
         -0.0491657916821981,
         0.0697123441284553,
         -0.0822701051467927,
         0.0848061062594848,
         -0.0758706063916957,
         0.0548292693079082,
         -0.0221869637811622,
         -0.0199101777747936,
         0.0667788994813718,
         -0.109235374992529,
         0.12743357579271,
         -0.0214121161809917,
         0.0411758946976257,
         -0.0605234527376003,
         0.0772055590003797,
         -0.0893847330744626,
         0.0957184958275825,
         -0.0953736678036667,
         0.0880301447023041,
         -0.073882162740135,
         0.0536387950747832,
         -0.0285241699893708,
         0.000277575452747478,
         0.0288464872255671,
         -0.0560782742895154,
         0.0781327830029686,
         -0.0912097418857718,
         0.0909936047528792,
         -0.0726535469693909,
         0.0308434630381996,
         0.0402980349884656,
         -0.147147618575435,
         0.00801168026750693,
         -0.0177853350377523,
         0.0299416504168226,
         -0.0436379905069772,
         0.0578579279227346,
         -0.071495939840867,
         0.083412800225434,
         -0.0924838754920883,
         0.0976458208580638,
         -0.097944810292372,
         0.0925892024127222,
         -0.0810101949664965,
         0.0629356049324472,
         -0.0384850901986858,
         0.00830160169218668,
         0.0262519695748185,
         -0.0627672826066157,
         0.0971729715461465,
         -0.122299897617557,
         0.123112530461749,
         -0.00212234594975456,
         0.0053270460559082,
         -0.0100777622264391,
         0.0164569168025802,
         -0.0244421636055694,
         0.0339121257268509,
         -0.0446473881685946,
         0.056330722230163,
         -0.0685470880485741,
         0.0807835179828965,
         -0.0924288746692088,
         0.102773412491922,
         -0.111007972841776,
         0.116222423690617,
         -0.117402377025102,
         0.113421471757929,
         -0.103020167739046,
         0.0847318545736325,
         -0.0564879030490883},
        {0.0131688103001718,
         -0.0266352302795411,
         0.0415080084609345,
         -0.0567107358789644,
         0.0712605400950066,
         -0.0843166081177662,
         0.0951885514095134,
         -0.10333862342208,
         0.1083824626028,
         -0.11008937804608,
         0.1083824626028,
         -0.10333862342208,
         0.0951885514095135,
         -0.0843166081177661,
         0.0712605400950066,
         -0.0567107358789643,
         0.0415080084609344,
         -0.0266352302795412,
         0.0131688103001718,
         -0.0405889993084107,
         0.0674992769016034,
         -0.0871842563632696,
         0.0985177810550669,
         -0.101196657844226,
         0.0956060470594707,
         -0.082646806970072,
         0.0636005261638775,
         -0.0400228767533715,
         0.0136549067870363,
         0.0136549067870363,
         -0.0400228767533715,
         0.0636005261638777,
         -0.0826468069700719,
         0.0956060470594708,
         -0.101196657844226,
         0.0985177810550673,
         -0.0871842563632696,
         0.0674992769016035,
         -0.0405889993084109,
         0.0840272115327149,
         -0.106387552459446,
         0.104140258564539,
         -0.0854312507390973,
         0.056687888606481,
         -0.0233254870749147,
         -0.0101200171800084,
         0.0399539579865404,
         -0.0633091132853511,
         0.0781399022327735,
         -0.0832197475142002,
         0.0781399022327735,
         -0.063309113285351,
         0.0399539579865405,
         -0.0101200171800084,
         -0.0233254870749147,
         0.0566878886064811,
         -0.0854312507390971,
         0.104140258564539,
         -0.106387552459445,
         0.0840272115327149,
         -0.128353685761577,
         0.101340630121396,
         -0.0514782186738537,
         0.000896854854720803,
         0.0406003663662815,
         -0.068573985082392,
         0.0816555375031386,
         -0.0804644787012011,
         0.0669774537762859,
         -0.0441036860807936,
         0.0153654642006694,
         0.0153654642006694,
         -0.0441036860807937,
         0.0669774537762855,
         -0.0804644787012009,
         0.0816555375031387,
         -0.0685739850823921,
         0.0406003663662815,
         0.000896854854720805,
         -0.0514782186738538,
         0.101340630121396,
         -0.128353685761577,
         0.134618481321994,
         -0.0122380437565445,
         -0.0576936348522827,
         0.0874145982610343,
         -0.0878746750939882,
         0.0687354788431501,
         -0.0383704078682651,
         0.00386464539680485,
         0.0289848404760279,
         -0.0556692967872895,
         0.0729681857063168,
         -0.0789491845347027,
         0.0729681857063167,
         -0.0556692967872894,
         0.0289848404760279,
         0.00386464539680476,
         -0.038370407868265,
         0.0687354788431501,
         -0.0878746750939882,
         0.0874145982610344,
         -0.0576936348522829,
         -0.0122380437565446,
         0.134618481321994,
         -0.128353685761577,
         0.101340630121396,
         -0.0514782186738537,
         0.000896854854720883,
         0.0406003663662819,
         -0.0685739850823921,
         0.0816555375031387,
         -0.0804644787012009,
         0.0669774537762857,
         -0.0441036860807938,
         0.0153654642006694,
         0.0153654642006695,
         -0.0441036860807936,
         0.0669774537762855,
         -0.0804644787012009,
         0.0816555375031387,
         -0.0685739850823923,
         0.0406003663662818,
         0.000896854854720907,
         -0.0514782186738536,
         0.101340630121396,
         -0.128353685761577,
         0.0840272115327148,
         -0.106387552459445,
         0.104140258564539,
         -0.0854312507390972,
         0.0566878886064813,
         -0.0233254870749148,
         -0.0101200171800084,
         0.0399539579865404,
         -0.0633091132853511,
         0.0781399022327737,
         -0.0832197475142,
         0.0781399022327736,
         -0.0633091132853512,
         0.0399539579865404,
         -0.0101200171800083,
         -0.0233254870749148,
         0.0566878886064811,
         -0.0854312507390972,
         0.104140258564539,
         -0.106387552459446,
         0.0840272115327149,
         -0.0405889993084109,
         0.0674992769016034,
         -0.0871842563632696,
         0.0985177810550668,
         -0.101196657844226,
         0.0956060470594707,
         -0.0826468069700721,
         0.0636005261638773,
         -0.0400228767533715,
         0.0136549067870364,
         0.0136549067870366,
         -0.0400228767533717,
         0.0636005261638772,
         -0.0826468069700721,
         0.0956060470594707,
         -0.101196657844226,
         0.0985177810550668,
         -0.0871842563632693,
         0.0674992769016033,
         -0.0405889993084108,
         0.013168810300172,
         -0.026635230279541,
         0.0415080084609346,
         -0.0567107358789645,
         0.0712605400950066,
         -0.084316608117766,
         0.0951885514095135,
         -0.10333862342208,
         0.1083824626028,
         -0.11008937804608,
         0.1083824626028,
         -0.10333862342208,
         0.0951885514095135,
         -0.0843166081177662,
         0.0712605400950068,
         -0.0567107358789644,
         0.0415080084609345,
         -0.0266352302795412,
         0.0131688103001719},
        {-0.0108577056997409,
         0.022163198951395,
         -0.0348904005125301,
         0.0482080161255929,
         -0.0613407484536854,
         0.0736088981444225,
         -0.0844351969360309,
         0.0933466224455268,
         -0.0999750093710956,
         0.104057288902059,
         -0.105435591193282,
         0.104057288902059,
         -0.0999750093710959,
         0.0933466224455267,
         -0.0844351969360308,
         0.0736088981444227,
         -0.0613407484536855,
         0.0482080161255929,
         -0.03489040051253,
         0.022163198951395,
         -0.010857705699741,
         0.0351829876098231,
         -0.0595526434310079,
         0.0785628895306684,
         -0.0911045870486504,
         0.0967025589816723,
         -0.0954238102282508,
         0.087747630624174,
         -0.0744648443311664,
         0.0565997035496416,
         -0.0353465035377445,
         0.0120155007517495,
         0.0120155007517495,
         -0.0353465035377445,
         0.0565997035496417,
         -0.0744648443311661,
         0.0877476306241739,
         -0.095423810228251,
         0.0967025589816722,
         -0.0911045870486504,
         0.0785628895306685,
         -0.0595526434310082,
         0.0351829876098232,
         -0.0763907308943845,
         0.0998082452693903,
         -0.102019820825795,
         0.0893943081195657,
         -0.0669479254488495,
         0.0389660755220934,
         -0.00912004361935687,
         -0.0194994734720396,
         0.0443701770718822,
         -0.0635330096627203,
         0.0755897464064119,
         -0.0797018153235719,
         0.0755897464064119,
         -0.0635330096627202,
         0.0443701770718823,
         -0.0194994734720396,
         -0.00912004361935693,
         0.0389660755220934,
         -0.0669479254488497,
         0.0893943081195657,
         -0.102019820825795,
         0.0998082452693902,
         -0.0763907308943843,
         0.122119025104063,
         -0.102909821106085,
         0.0608334919735114,
         -0.0153513209286289,
         -0.0246318593042721,
         0.0547032281712253,
         -0.0729938708261191,
         0.0792822070494633,
         -0.074486742536118,
         0.0603354867114943,
         -0.0391261869132765,
         0.0135366802605776,
         0.0135366802605777,
         -0.0391261869132764,
         0.0603354867114943,
         -0.0744867425361178,
         0.0792822070494633,
         -0.072993870826119,
         0.0547032281712253,
         -0.0246318593042723,
         -0.0153513209286289,
         0.0608334919735113,
         -0.102909821106085,
         0.122119025104062,
         -0.133774689500069,
         0.0222957815833448,
         0.0455609449746613,
         -0.0790486801591318,
         0.0865393577661849,
         -0.0755236554028716,
         0.0526109944871823,
         -0.0235295402480366,
         -0.00687379827470793,
         0.0346333682302533,
         -0.0566647729568811,
         0.0707648719819195,
         -0.0756117810217793,
         0.0707648719819194,
         -0.0566647729568811,
         0.0346333682302534,
         -0.00687379827470796,
         -0.0235295402480365,
         0.0526109944871825,
         -0.0755236554028715,
         0.0865393577661848,
         -0.079048680159132,
         0.0455609449746615,
         0.0222957815833449,
         -0.133774689500069,
         0.122119025104063,
         -0.102909821106085,
         0.0608334919735113,
         -0.0153513209286289,
         -0.0246318593042723,
         0.0547032281712254,
         -0.0729938708261192,
         0.0792822070494634,
         -0.074486742536118,
         0.0603354867114944,
         -0.0391261869132765,
         0.0135366802605777,
         0.0135366802605777,
         -0.0391261869132763,
         0.0603354867114944,
         -0.074486742536118,
         0.0792822070494634,
         -0.0729938708261194,
         0.0547032281712252,
         -0.0246318593042724,
         -0.0153513209286289,
         0.0608334919735113,
         -0.102909821106085,
         0.122119025104063,
         -0.0763907308943844,
         0.0998082452693903,
         -0.102019820825795,
         0.0893943081195658,
         -0.0669479254488497,
         0.0389660755220933,
         -0.0091200436193568,
         -0.0194994734720396,
         0.0443701770718824,
         -0.0635330096627203,
         0.075589746406412,
         -0.0797018153235717,
         0.0755897464064119,
         -0.06353300966272,
         0.0443701770718821,
         -0.0194994734720397,
         -0.0091200436193571,
         0.0389660755220933,
         -0.0669479254488496,
         0.0893943081195658,
         -0.102019820825795,
         0.0998082452693903,
         -0.0763907308943843,
         0.035182987609823,
         -0.0595526434310082,
         0.0785628895306683,
         -0.0911045870486504,
         0.0967025589816722,
         -0.095423810228251,
         0.0877476306241737,
         -0.0744648443311666,
         0.0565997035496417,
         -0.0353465035377445,
         0.0120155007517495,
         0.0120155007517496,
         -0.0353465035377443,
         0.0565997035496417,
         -0.0744648443311665,
         0.0877476306241737,
         -0.095423810228251,
         0.0967025589816723,
         -0.0911045870486503,
         0.0785628895306683,
         -0.0595526434310083,
         0.0351829876098231,
         -0.010857705699741,
         0.0221631989513949,
         -0.0348904005125302,
         0.048208016125593,
         -0.0613407484536855,
         0.0736088981444228,
         -0.0844351969360309,
         0.0933466224455267,
         -0.0999750093710959,
         0.104057288902059,
         -0.105435591193283,
         0.104057288902059,
         -0.0999750093710958,
         0.0933466224455268,
         -0.0844351969360309,
         0.0736088981444229,
         -0.0613407484536855,
         0.0482080161255929,
         -0.0348904005125302,
         0.0221631989513948,
         -0.0108577056997409},
        {-0.208514414057075,
         0.153998100701803,
         -0.111455642515071,
         0.07881104062391,
         -0.0542414781655109,
         0.0361609854436739,
         -0.0232041047050924,
         0.0142095541163975,
         -0.00820388989416696,
         0.00438516360325565,
         -0.00210656445576776,
         0.000860001337819158,
         -0.000259300159704493,
         0.140580389278884,
         -0.150286757708826,
         0.136504726557987,
         -0.114351076438204,
         0.0904024636091852,
         -0.0679346624232153,
         0.0485348671456553,
         -0.0328155595766671,
         0.020800657348138,
         -0.012162255556028,
         0.0063779406204344,
         -0.00284049093269725,
         0.000934920021550563,
         -0.0920314678709774,
         0.123473170937156,
         -0.132863944399817,
         0.127848390108049,
         -0.113929892405108,
         0.0953205868026817,
         -0.0751898928662049,
         0.0558140205685406,
         -0.0387000602018601,
         0.0247016578060424,
         -0.0141312639662446,
         0.00687023100933273,
         -0.00247356587275807,
         0.0582058109761793,
         -0.092514576008593,
         0.114351076438204,
         -0.124031156818978,
         0.123058348412502,
         -0.113676432931181,
         0.0984466787300015,
         -0.0799385006181495,
         0.0605064574256405,
         -0.042131289115355,
         0.0263109816195337,
         -0.0139926016187114,
         0.0055310614383109,
         -0.0353295872871771,
         0.0645027063484486,
         -0.0898691110864765,
         0.108527262216607,
         -0.118885659240627,
         0.120572064880105,
         -0.114221646768614,
         0.101246668550439,
         -0.0836016850603438,
         0.0635470578684548,
         -0.0434109048866428,
         0.0253465077145107,
         -0.0110621228766216,
         0.0203975467306099,
         -0.0419778048561338,
         0.0651163573299638,
         -0.0868218097732852,
         0.104418471172916,
         -0.11584189289831,
         0.119796673783488,
         -0.11584189289831,
         0.104418471172916,
         -0.0868218097732852,
         0.065116357329964,
         -0.0419778048561339,
         0.0203975467306099,
         -0.0110621228766216,
         0.0253465077145108,
         -0.0434109048866427,
         0.0635470578684548,
         -0.0836016850603438,
         0.101246668550439,
         -0.114221646768614,
         0.120572064880105,
         -0.118885659240627,
         0.108527262216607,
         -0.0898691110864764,
         0.0645027063484486,
         -0.0353295872871772,
         0.00553106143831101,
         -0.0139926016187113,
         0.0263109816195337,
         -0.0421312891153549,
         0.0605064574256407,
         -0.0799385006181494,
         0.0984466787300016,
         -0.113676432931181,
         0.123058348412501,
         -0.124031156818979,
         0.114351076438204,
         -0.0925145760085931,
         0.0582058109761791,
         -0.00247356587275803,
         0.00687023100933276,
         -0.0141312639662446,
         0.0247016578060423,
         -0.0387000602018605,
         0.0558140205685406,
         -0.075189892866205,
         0.0953205868026819,
         -0.113929892405108,
         0.12784839010805,
         -0.132863944399817,
         0.123473170937156,
         -0.0920314678709775,
         0.000934920021550677,
         -0.00284049093269721,
         0.00637794062043445,
         -0.012162255556028,
         0.020800657348138,
         -0.032815559576667,
         0.0485348671456553,
         -0.0679346624232154,
         0.0904024636091851,
         -0.114351076438204,
         0.136504726557987,
         -0.150286757708826,
         0.140580389278884,
         -0.000259300159704493,
         0.000860001337819146,
         -0.00210656445576783,
         0.00438516360325552,
         -0.00820388989416667,
         0.0142095541163976,
         -0.0232041047050924,
         0.0361609854436741,
         -0.054241478165511,
         0.07881104062391,
         -0.111455642515071,
         0.153998100701804,
         -0.208514414057075},
        {0.2,
         -0.152752523165194,
         0.114840784554537,
         -0.0848155403763252,
         0.0613849814044852,
         -0.0434057366141216,
         0.029873876758563,
         -0.019915917839042,
         0.012779824364991,
         -0.00782601217415405,
         0.00451835023542908,
         -0.00241515979063229,
         0.00116020523525463,
         -0.000473651803879973,
         0.000142811392249601,
         -0.129099444873581,
         0.142442462322384,
         -0.134105144283581,
         0.117056566621426,
         -0.0970581776826271,
         0.0771340181150449,
         -0.058912079444715,
         0.0432036917470212,
         -0.0303100148177152,
         0.0202066765451432,
         -0.0126652047907989,
         0.00733778219331228,
         -0.00381870292582652,
         0.00168976718096739,
         -0.000553106143831045,
         0.0807572853087249,
         -0.111582224773372,
         0.124157238060638,
         -0.124157238060637,
         0.115701027172567,
         -0.10203871477778,
         0.0857296680618837,
         -0.068736652664877,
         0.0524984856424479,
         -0.0379956143723967,
         0.0258129369312473,
         -0.0162013844051329,
         0.00913881332186118,
         -0.00439014391559691,
         0.00156442042007566,
         -0.0486984753557673,
         0.0795242772487545,
         -0.101373960373941,
         0.113934495540093,
         -0.117824158889429,
         0.114306224082512,
         -0.104996971284896,
         0.0916488702198359,
         -0.0759912287447935,
         0.0596124243433222,
         -0.0438735563718569,
         0.0298472393241457,
         -0.0182776266437224,
         0.00955876665830808,
         -0.00372406548737368,
         0.0281160778557765,
         -0.0526003651980889,
         0.0753605852376709,
         -0.0939911634753798,
         0.106923681923142,
         -0.113409690835931,
         0.113409690835931,
         -0.107467826312283,
         0.0965831661431316,
         -0.0820799081414006,
         0.0654771155328367,
         -0.0483580546557774,
         0.0322387031038517,
         -0.0184331837179327,
         0.00789993587911403,
         -0.0153998100701803,
         0.0323801016030075,
         -0.0514810804416213,
         0.0706314596587654,
         -0.0878467687812182,
         0.10143671120655,
         -0.110121752514666,
         0.113106622661619,
         -0.110121752514666,
         0.10143671120655,
         -0.0878467687812183,
         0.0706314596587654,
         -0.0514810804416211,
         0.0323801016030077,
         -0.0153998100701803,
         0.00789993587911398,
         -0.0184331837179326,
         0.0322387031038518,
         -0.0483580546557775,
         0.065477115532837,
         -0.0820799081414005,
         0.0965831661431317,
         -0.107467826312283,
         0.113409690835931,
         -0.113409690835931,
         0.106923681923142,
         -0.0939911634753796,
         0.0753605852376708,
         -0.0526003651980888,
         0.0281160778557766,
         -0.00372406548737351,
         0.00955876665830807,
         -0.0182776266437225,
         0.0298472393241457,
         -0.0438735563718571,
         0.0596124243433223,
         -0.0759912287447935,
         0.091648870219836,
         -0.104996971284896,
         0.114306224082512,
         -0.11782415888943,
         0.113934495540093,
         -0.101373960373941,
         0.0795242772487543,
         -0.0486984753557676,
         0.00156442042007569,
         -0.0043901439155969,
         0.00913881332186128,
         -0.016201384405133,
         0.0258129369312475,
         -0.0379956143723967,
         0.0524984856424477,
         -0.0687366526648771,
         0.0857296680618839,
         -0.10203871477778,
         0.115701027172567,
         -0.124157238060637,
         0.124157238060638,
         -0.111582224773372,
         0.0807572853087251,
         -0.000553106143831102,
         0.00168976718096739,
         -0.00381870292582659,
         0.00733778219331209,
         -0.0126652047907989,
         0.0202066765451434,
         -0.0303100148177151,
         0.0432036917470214,
         -0.0589120794447151,
         0.0771340181150449,
         -0.0970581776826272,
         0.117056566621426,
         -0.134105144283581,
         0.142442462322384,
         -0.129099444873581,
         0.000142811392249489,
         -0.000473651803879883,
         0.00116020523525453,
         -0.00241515979063206,
         0.00451835023542916,
         -0.00782601217415406,
         0.0127798243649909,
         -0.0199159178390421,
         0.0298738767585628,
         -0.0434057366141215,
         0.0613849814044854,
         -0.0848155403763253,
         0.114840784554537,
         -0.152752523165194,
         0.2},
        {-0.0807572853087251,
         0.111582224773372,
         -0.124157238060638,
         0.124157238060638,
         -0.115701027172567,
         0.10203871477778,
         -0.085729668061884,
         0.0687366526648769,
         -0.0524984856424479,
         0.0379956143723967,
         -0.0258129369312475,
         0.0162013844051329,
         -0.00913881332186123,
         0.00439014391559693,
         -0.00156442042007562,
         0.139875721236047,
         -0.108893101296093,
         0.0544465506480477,
         -0.0450365637461238,
         0.0771340181150449,
         -0.0958486827374325,
         0.102466551936305,
         -0.0992128122981509,
         0.0887386370150377,
         -0.0737666116182331,
         0.056838216465591,
         -0.0401335586436029,
         0.0253465077145108,
         -0.0136046123001698,
         0.00541931130393835,
         -0.131876094679158,
         -0.0140580389278887,
         0.083168479891307,
         -0.0994053465609437,
         0.0822251395875709,
         -0.0469955817376897,
         0.00540046146837802,
         0.0341555173121018,
         -0.0661418748654344,
         0.0874974760707462,
         -0.0972256140613865,
         0.0959890176335777,
         -0.0857046849146065,
         0.0691382679788854,
         -0.0494970770598533,
         0.0300175822169432,
         -0.013518137447739,
         0.137740088630036,
         -0.074388149848915,
         0.0558609823106052,
         -0.0849217590032646,
         0.0879282215282312,
         -0.0699979808565972,
         0.0381870292582645,
         -0.0375949464331022,
         0.0688344984833266,
         -0.0896031953006358,
         0.0976980239202574,
         -0.0929371949532057,
         0.0771181518147404,
         -0.0538078759071261,
         0.027868354279323,
         -0.112464311423107,
         0.108893101296094,
         -0.0684154515958092,
         0.0155788836474023,
         0.0333702280347473,
         -0.0683886167441796,
         0.0845305926721256,
         -0.081006922025665,
         0.0602860324400523,
         -0.0272092246003398,
         -0.0118885659240626,
         0.0500553420521214,
         -0.0805967577596289,
         0.0979482113309787,
         -0.0985398606521684,
         0.0816326707508446,
         -0.0499635814945698,
         0.0795242772487547,
         -0.104903692446907,
         0.100065854468778,
         -0.0726599887815967,
         0.0322387031038519,
         0.0113981027906962,
         -0.0494960469330664,
         0.0752346354425338,
         -0.0843046989922656,
         0.0752346354425339,
         -0.0494960469330664,
         0.0113981027906962,
         0.0322387031038519,
         -0.0726599887815965,
         0.100065854468778,
         -0.104903692446907,
         0.0795242772487548,
         -0.0499635814945698,
         0.0816326707508445,
         -0.0985398606521684,
         0.0979482113309788,
         -0.0805967577596288,
         0.0500553420521215,
         -0.0118885659240627,
         -0.0272092246003399,
         0.0602860324400524,
         -0.0810069220256649,
         0.0845305926721258,
         -0.0683886167441795,
         0.0333702280347474,
         0.0155788836474023,
         -0.0684154515958092,
         0.108893101296094,
         -0.112464311423107,
         0.0278683542793229,
         -0.0538078759071261,
         0.0771181518147404,
         -0.0929371949532055,
         0.0976980239202575,
         -0.0896031953006357,
         0.0688344984833268,
         -0.0375949464331023,
         0.0381870292582647,
         -0.0699979808565972,
         0.0879282215282311,
         -0.0849217590032645,
         0.055860982310605,
         -0.0743881498489148,
         0.137740088630037,
         -0.013518137447739,
         0.0300175822169432,
         -0.0494970770598534,
         0.0691382679788855,
         -0.0857046849146065,
         0.0959890176335777,
         -0.0972256140613864,
         0.0874974760707463,
         -0.0661418748654344,
         0.0341555173121016,
         0.00540046146837803,
         -0.0469955817376896,
         0.0822251395875707,
         -0.099405346560944,
         0.083168479891307,
         -0.0140580389278887,
         -0.131876094679158,
         0.00541931130393842,
         -0.0136046123001699,
         0.0253465077145108,
         -0.0401335586436031,
         0.0568382164655908,
         -0.073766611618233,
         0.0887386370150377,
         -0.0992128122981509,
         0.102466551936305,
         -0.0958486827374325,
         0.0771340181150448,
         -0.0450365637461238,
         0.0544465506480479,
         -0.108893101296094,
         0.139875721236047,
         -0.00156442042007551,
         0.00439014391559682,
         -0.00913881332186122,
         0.0162013844051329,
         -0.0258129369312474,
         0.0379956143723968,
         -0.0524984856424478,
         0.068736652664877,
         -0.0857296680618841,
         0.10203871477778,
         -0.115701027172567,
         0.124157238060638,
         -0.124157238060638,
         0.111582224773373,
         -0.080757285308725},
        {0.0716114874039432,
         -0.101273936708367,
         0.115662986393249,
         -0.119116371002829,
         0.114783407191697,
         -0.105200730396178,
         0.0924288746692088,
         -0.0781166566864506,
         0.0635470578684544,
         -0.0496770202861017,
         0.0371748779812821,
         -0.0264567499461738,
         0.0177224277074613,
         -0.0109909830848569,
         0.00613616173032963,
         -0.00292139732154087,
         0.00103286992830087,
         -0.132045058354705,
         0.110940039245046,
         -0.0661069030509841,
         0.0180087025571418,
         0.0246594315548694,
         -0.0580763206912504,
         0.0810101949664966,
         -0.0937399880237408,
         0.0974388220649636,
         -0.0937782726845257,
         0.0846552397932031,
         -0.0719950741897483,
         0.0576066532204944,
         -0.0430756805271369,
         0.0296880753997794,
         -0.0183784616945296,
         0.00970018296070357,
         -0.00380903608902829,
         0.132045058354705,
         -0.0693977918359487,
         0.0937058399085055,
         -0.0875322986906956,
         0.0627726645815543,
         -0.0288464872255676,
         -0.00706591745743523,
         0.0397867515259137,
         -0.0659040147967494,
         0.0835347769383329,
         -0.0920884356683676,
         0.0920299482469905,
         -0.0846430076143434,
         0.0717930922448568,
         -0.0556901893463342,
         0.0386505132563172,
         -0.02285421653417,
         0.0100777622264389,
         -0.132045058354705,
         0.0825998939158907,
         -0.0174368512726543,
         -0.0369068576923706,
         0.0714698226016971,
         -0.0848061062594843,
         0.0793147267468439,
         -0.0593655809461959,
         0.0301653361166199,
         0.00299563703621608,
         -0.0352671858479086,
         0.0626080973932321,
         -0.0820388989416682,
         0.0918003428282733,
         -0.0914288097819116,
         0.0817524675377343,
         -0.0648046661039454,
         0.0436379905069773,
         -0.0219639735610396,
         0.103020167739045,
         -0.107601055897055,
         0.0785239320534728,
         -0.0348737025453067,
         -0.0101200171800085,
         0.047520997330728,
         -0.0719769416937577,
         0.0811510578705964,
         -0.0751898928662047,
         0.0562031326615107,
         -0.027748073437372,
         -0.00568382164655908,
         0.0391792845323913,
         -0.0679148650565051,
         0.0876676928917898,
         -0.0953244380617205,
         0.0893847330744634,
         -0.0704414262150613,
         0.0415080084609349,
         -0.0694561829206046,
         0.0964558953020627,
         -0.0992522974377461,
         0.0822932268976476,
         -0.0518496588971079,
         0.0148794014325464,
         0.0219018858810582,
         -0.052681726987163,
         0.0730100109857025,
         -0.0801017883428016,
         0.0730100109857027,
         -0.0526817269871627,
         0.0219018858810582,
         0.0148794014325463,
         -0.051849658897108,
         0.0822932268976475,
         -0.099252297437746,
         0.0964558953020625,
         -0.0694561829206045,
         0.0415080084609349,
         -0.0704414262150614,
         0.0893847330744631,
         -0.0953244380617206,
         0.0876676928917897,
         -0.0679148650565052,
         0.0391792845323914,
         -0.005683821646559,
         -0.027748073437372,
         0.0562031326615108,
         -0.0751898928662047,
         0.0811510578705962,
         -0.0719769416937577,
         0.0475209973307281,
         -0.0101200171800085,
         -0.0348737025453067,
         0.0785239320534729,
         -0.107601055897055,
         0.103020167739046,
         -0.0219639735610396,
         0.0436379905069773,
         -0.0648046661039453,
         0.0817524675377341,
         -0.0914288097819115,
         0.0918003428282734,
         -0.0820388989416681,
         0.0626080973932323,
         -0.0352671858479087,
         0.00299563703621613,
         0.0301653361166198,
         -0.0593655809461956,
         0.079314726746844,
         -0.0848061062594843,
         0.0714698226016972,
         -0.0369068576923705,
         -0.0174368512726542,
         0.0825998939158908,
         -0.132045058354705,
         0.010077762226439,
         -0.02285421653417,
         0.038650513256317,
         -0.0556901893463342,
         0.0717930922448567,
         -0.0846430076143436,
         0.0920299482469906,
         -0.0920884356683675,
         0.0835347769383328,
         -0.0659040147967494,
         0.0397867515259137,
         -0.00706591745743526,
         -0.0288464872255674,
         0.0627726645815544,
         -0.0875322986906956,
         0.0937058399085055,
         -0.069397791835949,
         0.132045058354705,
         -0.00380903608902829,
         0.00970018296070362,
         -0.0183784616945296,
         0.0296880753997795,
         -0.0430756805271369,
         0.0576066532204944,
         -0.0719950741897483,
         0.0846552397932031,
         -0.0937782726845258,
         0.0974388220649633,
         -0.0937399880237409,
         0.0810101949664968,
         -0.0580763206912502,
         0.0246594315548693,
         0.018008702557142,
         -0.0661069030509842,
         0.110940039245046,
         -0.132045058354705,
         0.00103286992830093,
         -0.00292139732154079,
         0.00613616173032953,
         -0.0109909830848569,
         0.0177224277074612,
         -0.0264567499461738,
         0.0371748779812823,
         -0.0496770202861016,
         0.0635470578684545,
         -0.0781166566864509,
         0.0924288746692085,
         -0.105200730396178,
         0.114783407191697,
         -0.119116371002829,
         0.115662986393249,
         -0.101273936708367,
         0.0716114874039431},
        {0.022809048515134,
         -0.043495148910936,
         0.0636703784926348,
         -0.0813719726057181,
         0.0951885514095133,
         -0.104273833646461,
         0.108285821957098,
         -0.107314629047924,
         0.101807596214252,
         -0.092493578124574,
         0.0803069148972139,
         -0.0663112525431891,
         0.051623240090901,
         -0.0373360216236722,
         0.0244421636055692,
         -0.013754373772675,
         0.00581228375755129,
         -0.0594787215760984,
         0.0891915727565603,
         -0.101872605588216,
         0.0987746280566591,
         -0.0826468069700721,
         0.0571131308457079,
         -0.0261195230215945,
         -0.00647131561942088,
         0.0371748779812823,
         -0.0630982902763828,
         0.0820899294964394,
         -0.0928357535604652,
         0.0949081721512523,
         -0.0887698063654355,
         0.0757312740717174,
         -0.0578579279227349,
         0.0378111283841335,
         -0.0185629457058574,
         0.103020167739046,
         -0.107601055897055,
         0.0785239320534728,
         -0.0348737025453069,
         -0.0101200171800082,
         0.0475209973307274,
         -0.0719769416937573,
         0.0811510578705964,
         -0.0751898928662049,
         0.0562031326615112,
         -0.0277480734373722,
         -0.00568382164655874,
         0.0391792845323918,
         -0.0679148650565052,
         0.0876676928917898,
         -0.09532443806172,
         0.0893847330744628,
         -0.0704414262150614,
         0.0415080084609346,
         -0.129630868320603,
         0.0627672826066153,
         0.0101673440968415,
         -0.0604868595680039,
         0.0816555375031385,
         -0.0764295831029389,
         0.0518649065548098,
         -0.0166594248350599,
         -0.0204873382727857,
         0.0519579693297228,
         -0.0719431199389033,
         0.0769068187463656,
         -0.0658408533364933,
         0.0403317483363108,
         -0.00444607157048807,
         -0.0355759819114606,
         0.071847222154789,
         -0.0956344970071503,
         0.0985177810550668,
         -0.0738640424038963,
         0.109558079905309,
         0.0417838122157167,
         -0.0909936047528784,
         0.079378494766406,
         -0.0383704078682637,
         -0.00936931531529483,
         0.0488452129036084,
         -0.0716229661947369,
         0.0747246195613266,
         -0.0595237308569667,
         0.0306404100061832,
         0.00516382884049115,
         -0.0400915391542917,
         0.0664154052401935,
         -0.0775854503268517,
         0.0693386275527255,
         -0.0408138451374909,
         -0.00431904095418717,
         0.056687888606482,
         -0.0998824155345605,
         0.108125886555354,
         -0.12793627429597,
         0.0529706500093354,
         0.0221869637811614,
         -0.0685739850823936,
         0.0817595237761195,
         -0.0673262266388163,
         0.0350728748052885,
         0.00411626242498471,
         -0.0402015609266778,
         0.065236608420944,
         -0.0741598456754926,
         0.0652366084209442,
         -0.040201560926678,
         0.00411626242498469,
         0.0350728748052885,
         -0.0673262266388161,
         0.0817595237761195,
         -0.0685739850823936,
         0.0221869637811614,
         0.0529706500093354,
         -0.12793627429597,
         0.108125886555354,
         -0.0998824155345606,
         0.0566878886064821,
         -0.00431904095418713,
         -0.0408138451374907,
         0.0693386275527255,
         -0.0775854503268517,
         0.0664154052401931,
         -0.0400915391542917,
         0.00516382884049111,
         0.0306404100061833,
         -0.0595237308569667,
         0.0747246195613264,
         -0.0716229661947369,
         0.0488452129036085,
         -0.0093693153152948,
         -0.0383704078682636,
         0.0793784947664059,
         -0.0909936047528784,
         0.0417838122157166,
         0.109558079905309,
         -0.0738640424038962,
         0.0985177810550669,
         -0.0956344970071504,
         0.071847222154789,
         -0.0355759819114606,
         -0.00444607157048801,
         0.0403317483363108,
         -0.065840853336493,
         0.0769068187463656,
         -0.0719431199389033,
         0.0519579693297228,
         -0.0204873382727857,
         -0.0166594248350599,
         0.0518649065548098,
         -0.076429583102939,
         0.0816555375031384,
         -0.0604868595680039,
         0.0101673440968415,
         0.0627672826066153,
         -0.129630868320602,
         0.0415080084609346,
         -0.0704414262150614,
         0.089384733074463,
         -0.0953244380617202,
         0.0876676928917895,
         -0.067914865056505,
         0.0391792845323918,
         -0.00568382164655875,
         -0.0277480734373721,
         0.0562031326615114,
         -0.075189892866205,
         0.0811510578705966,
         -0.0719769416937573,
         0.0475209973307272,
         -0.0101200171800082,
         -0.0348737025453069,
         0.0785239320534727,
         -0.107601055897055,
         0.103020167739046,
         -0.0185629457058573,
         0.0378111283841335,
         -0.0578579279227348,
         0.0757312740717175,
         -0.0887698063654354,
         0.0949081721512523,
         -0.0928357535604652,
         0.0820899294964397,
         -0.0630982902763828,
         0.0371748779812824,
         -0.00647131561942096,
         -0.0261195230215946,
         0.0571131308457078,
         -0.0826468069700719,
         0.0987746280566589,
         -0.101872605588216,
         0.0891915727565605,
         -0.0594787215760983,
         0.00581228375755133,
         -0.013754373772675,
         0.0244421636055696,
         -0.0373360216236722,
         0.0516232400909009,
         -0.0663112525431893,
         0.080306914897214,
         -0.092493578124574,
         0.101807596214252,
         -0.107314629047924,
         0.108285821957098,
         -0.104273833646461,
         0.0951885514095135,
         -0.0813719726057182,
         0.0636703784926347,
         -0.0434951489109359,
         0.022809048515134},
        {0.0188060979255815,
         -0.0364178520364616,
         0.0542294871234355,
         -0.0706435541089096,
         0.0844351969360308,
         -0.0947782734958237,
         0.101211076403513,
         -0.103592839361993,
         0.102058045783879,
         -0.0969700631136847,
         0.0888745308726207,
         -0.0784526438571577,
         0.0664743801022167,
         -0.0537516849716423,
         0.0410915929212561,
         -0.0292492102080579,
         0.0188802840042547,
         -0.0104921312292115,
         0.00438419418496076,
         -0.0518448341285596,
         0.0801192744802153,
         -0.0950875019633972,
         0.0971004764764355,
         -0.0877476306241734,
         0.0694219596207092,
         -0.044913443152957,
         0.0171077943696161,
         0.0112362210347655,
         -0.0376525191259939,
         0.0600901503231972,
         -0.0770009135842656,
         0.0873972889745314,
         -0.0908836492031974,
         0.0876620648986797,
         -0.0785125471595588,
         0.0647458868129573,
         -0.0481245766702735,
         0.0307405604117316,
         -0.0148027432804348,
         0.0946552838077528,
         -0.104764201290754,
         0.0845426041417469,
         -0.0490666637341108,
         0.00912004361935642,
         0.027576419843291,
         -0.0558782993297755,
         0.0728539852021145,
         -0.0774526592079883,
         0.070182671449246,
         -0.0527939664145741,
         0.0279622916957101,
         0.00102572195364316,
         -0.0305870006107293,
         0.0571561409273644,
         -0.077499191299425,
         0.0890268675841977,
         -0.0901063660604208,
         0.0803686801557629,
         -0.0609969987422855,
         0.0348904005125303,
         -0.125217170616776,
         0.0709914628558143,
         -0.00540519760510146,
         -0.0451808626207756,
         0.0729938708261197,
         -0.0781880865477245,
         0.0648462621076818,
         -0.0388961827418897,
         0.00683408051642679,
         0.0251265401652244,
         -0.0516438525758601,
         0.068654444556092,
         -0.0736403597478711,
         0.0657795244648467,
         -0.0459910159760425,
         0.0168783234953282,
         0.0174336864026267,
         -0.0515808807844224,
         0.079385580617745,
         -0.0944680328156531,
         0.0911045870486507,
         -0.0652739624026046,
         0.110993158730611,
         0.0289821433484155,
         -0.0830801906096356,
         0.0827344693716215,
         -0.0526109944871821,
         0.0112864458762392,
         0.0280736866441788,
         -0.0570369467126347,
         0.0712257376208538,
         -0.06963912307208,
         0.0539745893038105,
         -0.0279497469253618,
         -0.00337606425694121,
         0.0342803321797232,
         -0.0590562106191143,
         0.0726918705082931,
         -0.0715508449864065,
         0.054054443111474,
         -0.0213688821944838,
         -0.0218954480275741,
         0.0669479254488502,
         -0.099938589928201,
         0.100215045753516,
         -0.124094123979535,
         0.0624138458465681,
         0.00622362812027055,
         -0.0547032281712258,
         0.0765053971501745,
         -0.0737666537871292,
         0.0526719141296406,
         -0.0210105420710491,
         -0.0133300395786987,
         0.0433607456937561,
         -0.0636615909502929,
         0.0708169212934191,
         -0.0636615909502929,
         0.0433607456937562,
         -0.0133300395786988,
         -0.0210105420710492,
         0.0526719141296406,
         -0.0737666537871292,
         0.0765053971501745,
         -0.054703228171226,
         0.00622362812027067,
         0.0624138458465682,
         -0.124094123979535,
         0.100215045753516,
         -0.099938589928201,
         0.0669479254488502,
         -0.021895448027574,
         -0.0213688821944838,
         0.0540544431114741,
         -0.0715508449864063,
         0.0726918705082933,
         -0.059056210619114,
         0.0342803321797233,
         -0.00337606425694117,
         -0.0279497469253617,
         0.0539745893038105,
         -0.0696391230720802,
         0.0712257376208536,
         -0.0570369467126346,
         0.0280736866441789,
         0.0112864458762393,
         -0.0526109944871821,
         0.0827344693716217,
         -0.0830801906096356,
         0.0289821433484155,
         0.110993158730611,
         -0.0652739624026048,
         0.0911045870486506,
         -0.0944680328156532,
         0.0793855806177449,
         -0.0515808807844224,
         0.0174336864026269,
         0.0168783234953283,
         -0.0459910159760424,
         0.0657795244648465,
         -0.0736403597478711,
         0.068654444556092,
         -0.0516438525758601,
         0.0251265401652244,
         0.00683408051642685,
         -0.0388961827418896,
         0.0648462621076817,
         -0.0781880865477246,
         0.0729938708261199,
         -0.0451808626207757,
         -0.00540519760510152,
         0.0709914628558143,
         -0.125217170616776,
         0.0348904005125303,
         -0.0609969987422854,
         0.0803686801557629,
         -0.0901063660604208,
         0.0890268675841978,
         -0.077499191299425,
         0.0571561409273645,
         -0.0305870006107292,
         0.00102572195364294,
         0.0279622916957102,
         -0.0527939664145739,
         0.0701826714492461,
         -0.0774526592079883,
         0.0728539852021143,
         -0.0558782993297755,
         0.027576419843291,
         0.00912004361935638,
         -0.0490666637341106,
         0.084542604141747,
         -0.104764201290754,
         0.0946552838077527,
         -0.0148027432804347,
         0.0307405604117317,
         -0.0481245766702734,
         0.0647458868129571,
         -0.0785125471595588,
         0.0876620648986798,
         -0.0908836492031975,
         0.0873972889745316,
         -0.0770009135842656,
         0.0600901503231972,
         -0.0376525191259937,
         0.0112362210347655,
         0.0171077943696159,
         -0.044913443152957,
         0.0694219596207092,
         -0.0877476306241735,
         0.0971004764764355,
         -0.0950875019633973,
         0.0801192744802151,
         -0.0518448341285596,
         0.0043841941849607,
         -0.0104921312292115,
         0.0188802840042547,
         -0.0292492102080578,
         0.0410915929212559,
         -0.0537516849716421,
         0.0664743801022167,
         -0.0784526438571576,
         0.0888745308726208,
         -0.0969700631136844,
         0.102058045783879,
         -0.103592839361993,
         0.101211076403513,
         -0.0947782734958237,
         0.0844351969360306,
         -0.0706435541089095,
         0.0542294871234355,
         -0.0364178520364614,
         0.0188060979255815},
        {0.2,
         -0.14142135623731,
         0.0978019293843654,
         -0.0659380473395786,
         0.0431665847301716,
         -0.0273009453115975,
         0.016571045299983,
         -0.00956729746469884,
         0.00518859554776081,
         -0.00259429777388024,
         0.00116020523525466,
         -0.00043851636032552,
         0.000121622555560231,
         -0.14142135623731,
         0.144463023702923,
         -0.125108648434245,
         0.0996889572558457,
         -0.0747667179418839,
         0.0531455777599266,
         -0.0357975492302539,
         0.0227352865862362,
         -0.0134803666629715,
         0.0073377821933122,
         -0.00356252375234606,
         0.00145947066672331,
         -0.000438516360325545,
         0.0978019293843654,
         -0.125108648434245,
         0.128052784147595,
         -0.116895664048295,
         0.0985345383447483,
         -0.0777250920317895,
         0.0575910733275195,
         -0.0399892299405696,
         0.0258129369312475,
         -0.0152538153886346,
         0.00802708866697854,
         -0.00356252375234606,
         0.00116020523525467,
         -0.0659380473395788,
         0.099688957255846,
         -0.116895664048295,
         0.11993242076617,
         -0.112186507018355,
         0.0973466813142705,
         -0.0788598249310415,
         0.0596124243433221,
         -0.041774293881873,
         0.026756962223262,
         -0.0152538153886346,
         0.00733778219331218,
         -0.00259429777388042,
         0.0431665847301717,
         -0.0747667179418839,
         0.0985345383447485,
         -0.112186507018355,
         0.115438963354368,
         -0.109515016478555,
         0.0965831661431314,
         -0.0792611497871732,
         0.0602031650023391,
         -0.041774293881873,
         0.0258129369312474,
         -0.0134803666629715,
         0.00518859554776082,
         -0.0273009453115975,
         0.0531455777599266,
         -0.0777250920317896,
         0.0973466813142706,
         -0.109515016478554,
         0.113106622661619,
         -0.108291346603002,
         0.0963250640037424,
         -0.0792611497871732,
         0.0596124243433222,
         -0.0399892299405696,
         0.0227352865862361,
         -0.00956729746469884,
         0.0165710452999832,
         -0.0357975492302539,
         0.0575910733275196,
         -0.0788598249310415,
         0.0965831661431313,
         -0.108291346603001,
         0.1123792413377,
         -0.108291346603002,
         0.0965831661431314,
         -0.0788598249310415,
         0.0575910733275196,
         -0.035797549230254,
         0.0165710452999832,
         -0.00956729746469881,
         0.0227352865862363,
         -0.0399892299405694,
         0.0596124243433221,
         -0.079261149787173,
         0.0963250640037423,
         -0.108291346603001,
         0.113106622661619,
         -0.109515016478555,
         0.0973466813142704,
         -0.0777250920317896,
         0.0531455777599267,
         -0.0273009453115974,
         0.00518859554776097,
         -0.0134803666629714,
         0.0258129369312474,
         -0.0417742938818729,
         0.0602031650023389,
         -0.0792611497871731,
         0.0965831661431315,
         -0.109515016478555,
         0.115438963354368,
         -0.112186507018355,
         0.0985345383447483,
         -0.074766717941884,
         0.0431665847301718,
         -0.00259429777388047,
         0.00733778219331226,
         -0.0152538153886346,
         0.0267569622232618,
         -0.0417742938818729,
         0.0596124243433221,
         -0.0788598249310416,
         0.0973466813142705,
         -0.112186507018355,
         0.11993242076617,
         -0.116895664048295,
         0.0996889572558458,
         -0.0659380473395786,
         0.00116020523525464,
         -0.00356252375234608,
         0.00802708866697848,
         -0.0152538153886347,
         0.0258129369312474,
         -0.0399892299405696,
         0.0575910733275196,
         -0.0777250920317898,
         0.0985345383447484,
         -0.116895664048295,
         0.128052784147594,
         -0.125108648434245,
         0.0978019293843654,
         -0.000438516360325491,
         0.00145947066672337,
         -0.0035625237523459,
         0.00733778219331214,
         -0.0134803666629714,
         0.0227352865862364,
         -0.0357975492302538,
         0.0531455777599265,
         -0.074766717941884,
         0.0996889572558458,
         -0.125108648434245,
         0.144463023702923,
         -0.14142135623731,
         0.00012162255556039,
         -0.000438516360325583,
         0.0011602052352546,
         -0.00259429777388035,
         0.00518859554776078,
         -0.00956729746469885,
         0.0165710452999833,
         -0.0273009453115975,
         0.0431665847301717,
         -0.0659380473395786,
         0.0978019293843653,
         -0.14142135623731,
         0.2},
        {0.097801929384365,
         -0.125108648434245,
         0.128052784147594,
         -0.116895664048295,
         0.0985345383447484,
         -0.0777250920317894,
         0.0575910733275195,
         -0.0399892299405695,
         0.0258129369312473,
         -0.0152538153886346,
         0.00802708866697851,
         -0.00356252375234609,
         0.00116020523525468,
         -0.143960542098033,
         0.0842700971600382,
         -0.0111455642515073,
         -0.047722455010355,
         0.0851576491879151,
         -0.101942557651244,
         0.102194698737011,
         -0.0911136682551932,
         0.0737666116182327,
         -0.0544346427583064,
         0.0363031274543976,
         -0.0213789482903931,
         0.0105623897121574,
         -0.00381870292582646,
         0.114840784554537,
         0.0523492880356486,
         -0.102178418152178,
         0.0858960366795794,
         -0.0396810867483099,
         -0.0125265328080404,
         0.0564585911251973,
         -0.0852152119150326,
         0.097225614061386,
         -0.0944728856049135,
         0.0809827388349982,
         -0.061576095787849,
         0.0408849863444251,
         -0.0226294425112752,
         0.00913881332186118,
         -0.134105144283582,
         0.0331824176365026,
         0.0504077109532454,
         -0.088659802008235,
         0.0849013426647071,
         -0.0526493633779915,
         0.00733778219331228,
         0.0375949464331028,
         -0.0725045395495547,
         0.0921127275557968,
         -0.0952984707919893,
         0.0843758496278734,
         -0.0640420214762191,
         0.0401335586436028,
         -0.0182776266437223,
         0.124157238060638,
         -0.0856766339287157,
         0.0154190960014323,
         0.0463214896840548,
         -0.0808623851364092,
         0.0838778370140444,
         -0.0602860324400524,
         0.020095344146684,
         0.024965233007032,
         -0.0640721197730489,
         0.0892016670002504,
         -0.0962967622197167,
         0.0857046849146064,
         -0.0618754151494961,
         0.0322387031038517,
         -0.10137396037394,
         0.10566581727791,
         -0.0670730676062302,
         0.0108396978147249,
         0.0415303779031475,
         -0.0752346354425334,
         0.0832199614684395,
         -0.065766658914137,
         0.0290934779188472,
         0.0166622901117587,
         -0.059813695846958,
         0.0896031953006352,
         -0.0985593141969588,
         0.0844646989949638,
         -0.0514810804416209,
         0.0753605852376712,
         -0.101906110803918,
         0.0944902163393615,
         -0.0602088493878616,
         0.0118885659240625,
         0.0359476444345904,
         -0.0704704848464717,
         0.0829975702283016,
         -0.0704704848464718,
         0.0359476444345904,
         0.0118885659240625,
         -0.0602088493878616,
         0.0944902163393617,
         -0.101906110803918,
         0.0753605852376712,
         -0.0514810804416209,
         0.0844646989949639,
         -0.0985593141969586,
         0.089603195300635,
         -0.0598136958469581,
         0.0166622901117588,
         0.0290934779188473,
         -0.0657666589141369,
         0.0832199614684394,
         -0.0752346354425333,
         0.0415303779031476,
         0.010839697814725,
         -0.0670730676062301,
         0.10566581727791,
         -0.10137396037394,
         0.0322387031038515,
         -0.0618754151494962,
         0.0857046849146066,
         -0.0962967622197166,
         0.0892016670002507,
         -0.0640721197730489,
         0.024965233007032,
         0.0200953441466839,
         -0.0602860324400525,
         0.0838778370140443,
         -0.0808623851364092,
         0.0463214896840546,
         0.0154190960014324,
         -0.0856766339287155,
         0.124157238060638,
         -0.0182776266437224,
         0.0401335586436029,
         -0.0640420214762193,
         0.0843758496278732,
         -0.0952984707919893,
         0.0921127275557967,
         -0.0725045395495549,
         0.0375949464331028,
         0.00733778219331223,
         -0.0526493633779914,
         0.0849013426647071,
         -0.0886598020082351,
         0.0504077109532456,
         0.0331824176365025,
         -0.134105144283582,
         0.00913881332186099,
         -0.0226294425112754,
         0.0408849863444253,
         -0.0615760957878491,
         0.0809827388349983,
         -0.0944728856049135,
         0.0972256140613859,
         -0.0852152119150324,
         0.0564585911251973,
         -0.0125265328080404,
         -0.0396810867483097,
         0.0858960366795791,
         -0.102178418152178,
         0.0523492880356486,
         0.114840784554537,
         -0.00381870292582665,
         0.0105623897121574,
         -0.021378948290393,
         0.0363031274543978,
         -0.0544346427583065,
         0.073766611618233,
         -0.0911136682551932,
         0.102194698737011,
         -0.101942557651244,
         0.085157649187915,
         -0.0477224550103547,
         -0.0111455642515072,
         0.084270097160038,
         -0.143960542098033,
         0.00116020523525462,
         -0.00356252375234599,
         0.00802708866697854,
         -0.0152538153886345,
         0.0258129369312472,
         -0.0399892299405694,
         0.0575910733275199,
         -0.0777250920317894,
         0.0985345383447483,
         -0.116895664048295,
         0.128052784147594,
         -0.125108648434245,
         0.0978019293843651},
        {0.0867258180783985,
         -0.114727473442036,
         0.121980437173918,
         -0.116303783465153,
         0.103092285471181,
         -0.086253194297777,
         0.068547088048574,
         -0.0518167280211928,
         0.0371748779812823,
         -0.0251675113672993,
         0.0159173317917688,
         -0.00924935781245719,
         0.00479925611062667,
         -0.00210461302926669,
         0.000678378203748001,
         -0.137125558534574,
         0.0919866211007796,
         -0.0292987533074958,
         -0.0260063165868502,
         0.0659380473395789,
         -0.0892805381522401,
         0.0979448102923724,
         -0.0951934078443735,
         0.0846552397932036,
         -0.0697545088811508,
         0.053388353860221,
         -0.0377676060549825,
         0.0243704478192555,
         -0.0139762786080735,
         0.00675616671492392,
         -0.00239842914039697,
         0.116941069240937,
         0.0358057437019722,
         -0.0925303891145981,
         0.0907293584937433,
         -0.0580763206912501,
         0.0140580389278884,
         0.02852416998937,
         -0.0621874335205422,
         0.0835347769383327,
         -0.0921570298111396,
         0.0896691795572058,
         -0.0788811585781063,
         0.0631030307662488,
         -0.0455844788742277,
         0.0290882544698936,
         -0.0155960777312544,
         0.0061361617303297,
         -0.130744090092123,
         0.0481929109971866,
         0.0298923216487251,
         -0.0753582258323632,
         0.0861513003528166,
         -0.0697123441284547,
         0.036535720690118,
         0.0029956370362161,
         -0.040246469983355,
         0.0690974489870231,
         -0.0861625445677426,
         0.0906355550917337,
         -0.0838822946888021,
         0.0688624316079023,
         -0.0494472366102397,
         0.0296880753997796,
         -0.0130648860005023,
         0.115662986393248,
         -0.0925413414007361,
         0.0357349113008495,
         0.0220560660972777,
         -0.0633091132853515,
         0.0809502540075189,
         -0.0751898928662055,
         0.0509258296156699,
         -0.0155657866432826,
         -0.0227648705760915,
         0.0566405177223643,
         -0.0803813765867366,
         0.0907296409223359,
         -0.0871557301182573,
         0.0717930922448567,
         -0.0489933225018833,
         0.0244421636055693,
         -0.0900435127857121,
         0.103157803295062,
         -0.0791025981863418,
         0.0349485700513432,
         0.0132191211244739,
         -0.0526817269871625,
         0.0752942508523975,
         -0.0777337507620602,
         0.0610845577285512,
         -0.029971344804665,
         -0.00860431231041538,
         0.0465989874592519,
         -0.0763243725123829,
         0.0918003428282733,
         -0.0899504592331622,
         0.0714959398408669,
         -0.0412631213180249,
         0.0636703784926348,
         -0.0923220488143199,
         0.0953736678036672,
         -0.0752415791069846,
         0.0391792845323916,
         0.00316126492729716,
         -0.0419389185070226,
         0.0688703404532031,
         -0.078483403569712,
         0.0688703404532032,
         -0.0419389185070227,
         0.00316126492729712,
         0.0391792845323918,
         -0.0752415791069846,
         0.0953736678036671,
         -0.0923220488143198,
         0.0636703784926348,
         -0.0412631213180252,
         0.0714959398408671,
         -0.0899504592331623,
         0.0918003428282733,
         -0.0763243725123829,
         0.0465989874592519,
         -0.00860431231041548,
         -0.0299713448046649,
         0.0610845577285512,
         -0.07773375076206,
         0.0752942508523976,
         -0.0526817269871623,
         0.0132191211244739,
         0.0349485700513432,
         -0.0791025981863416,
         0.103157803295063,
         -0.0900435127857121,
         0.0244421636055694,
         -0.0489933225018834,
         0.0717930922448568,
         -0.0871557301182573,
         0.0907296409223359,
         -0.0803813765867367,
         0.0566405177223643,
         -0.0227648705760915,
         -0.0155657866432825,
         0.0509258296156699,
         -0.0751898928662054,
         0.0809502540075189,
         -0.0633091132853513,
         0.0220560660972776,
         0.0357349113008495,
         -0.092541341400736,
         0.115662986393248,
         -0.0130648860005021,
         0.0296880753997795,
         -0.0494472366102395,
         0.0688624316079021,
         -0.0838822946888018,
         0.0906355550917337,
         -0.0861625445677427,
         0.0690974489870231,
         -0.0402464699833548,
         0.00299563703621614,
         0.0365357206901181,
         -0.0697123441284547,
         0.0861513003528167,
         -0.0753582258323631,
         0.0298923216487251,
         0.0481929109971866,
         -0.130744090092123,
         0.00613616173032961,
         -0.0155960777312544,
         0.0290882544698936,
         -0.045584478874228,
         0.0631030307662487,
         -0.0788811585781061,
         0.0896691795572056,
         -0.0921570298111396,
         0.0835347769383327,
         -0.062187433520542,
         0.0285241699893701,
         0.0140580389278884,
         -0.0580763206912502,
         0.0907293584937435,
         -0.0925303891145981,
         0.035805743701972,
         0.116941069240937,
         -0.00239842914039698,
         0.00675616671492372,
         -0.0139762786080736,
         0.0243704478192555,
         -0.0377676060549823,
         0.0533883538602211,
         -0.069754508881151,
         0.0846552397932033,
         -0.0951934078443739,
         0.0979448102923724,
         -0.0892805381522403,
         0.065938047339579,
         -0.0260063165868502,
         -0.0292987533074958,
         0.0919866211007795,
         -0.137125558534574,
         0.000678378203748041,
         -0.00210461302926666,
         0.00479925611062658,
         -0.00924935781245747,
         0.0159173317917689,
         -0.0251675113672994,
         0.0371748779812823,
         -0.0518167280211927,
         0.068547088048574,
         -0.086253194297777,
         0.103092285471181,
         -0.116303783465153,
         0.121980437173918,
         -0.114727473442036,
         0.0867258180783989},
        {-0.0350187081709492,
         0.0624651519348431,
         -0.0851256530758748,
         0.100722031037067,
         -0.1083824626028,
         0.108382462602801,
         -0.101807596214252,
         0.0902427888358346,
         -0.075502534101898,
         0.0594050761521544,
         -0.0435914083882297,
         0.0293893215399236,
         -0.0177224277074613,
         0.00906339683764846,
         -0.00342564200941527,
         0.0783042119544696,
         -0.103452120022374,
         0.100167084494127,
         -0.0761386987626877,
         0.0400228767533714,
         -0.0371748779812824,
         0.0666487165676159,
         -0.0856118265380553,
         0.0932023515404001,
         -0.0902427888358346,
         0.0788598249310415,
         -0.0620284969761138,
         0.0430756805271369,
         -0.0251732248935297,
         0.0108328311981083,
         -0.115662986393248,
         0.0925413414007362,
         -0.0357349113008495,
         -0.0220560660972775,
         0.0633091132853514,
         -0.0809502540075188,
         0.0751898928662053,
         -0.0509258296156701,
         0.0155657866432824,
         0.0227648705760915,
         -0.0566405177223642,
         0.0803813765867366,
         -0.0907296409223355,
         0.0871557301182573,
         -0.0717930922448567,
         0.0489933225018834,
         -0.0244421636055694,
         0.123132651820136,
         -0.018008702557142,
         -0.0589595955805025,
         0.0842279936864344,
         -0.0669774537762857,
         0.0258010825393791,
         0.0204873382727853,
         -0.0570745510253706,
         0.0748909259053971,
         -0.070889710829844,
         0.0473888570604976,
         -0.0108009229367552,
         -0.0300175822169439,
         0.0656119930800294,
         -0.0878042183944812,
         0.0914288097819118,
         -0.0757312740717174,
         0.0450691227987948,
         -0.0870679330874997,
         -0.0787559087244566,
         0.0875322986906957,
         -0.0326213616832032,
         -0.0289848404760281,
         0.0679224877258239,
         -0.0747246195613262,
         0.0530981898077836,
         -0.0142095541163967,
         -0.0280216186116283,
         0.0606200296354294,
         -0.0742440703995999,
         0.064866877471104,
         -0.0344493705110652,
         -0.00939404076156337,
         0.0547349409840114,
         -0.0876676928917901,
         0.0956060470594706,
         -0.0712605400950072,
         0.117402377025102,
         -0.0714698226016968,
         0.0804644787012011,
         -0.0463757447616426,
         -0.00411626242498506,
         0.0480916170653294,
         -0.0708925877889519,
         0.067251884667905,
         -0.0404133530902863,
         0.0408700156427245,
         -0.0688344984833269,
         0.0735687151568555,
         -0.050765382368689,
         0.0044460715704888,
         0.0518496588971081,
         -0.0956060470594706,
         0.0982258758769856,
         -0.117402377025102,
         0.0643039302013742,
         0.010120017180008,
         -0.0623583190330955,
         0.0775854503268511,
         -0.0588159984335264,
         0.0189675895637855,
         0.0254428826162295,
         -0.0591590913433583,
         0.0716452175415203,
         -0.0591590913433583,
         0.0254428826162296,
         0.0189675895637854,
         -0.0588159984335263,
         0.0775854503268514,
         -0.0623583190330955,
         0.0101200171800079,
         0.0643039302013743,
         -0.117402377025102,
         0.0982258758769855,
         -0.0956060470594705,
         0.0518496588971081,
         0.00444607157048881,
         -0.050765382368689,
         0.0735687151568555,
         -0.0688344984833269,
         0.0408700156427246,
         -0.0404133530902862,
         0.067251884667905,
         -0.0708925877889519,
         0.0480916170653294,
         -0.00411626242498503,
         -0.0463757447616424,
         0.0804644787012012,
         -0.0714698226016968,
         0.117402377025102,
         -0.071260540095007,
         0.0956060470594707,
         -0.0876676928917902,
         0.0547349409840115,
         -0.0093940407615634,
         -0.0344493705110651,
         0.064866877471104,
         -0.0742440703996001,
         0.0606200296354294,
         -0.0280216186116283,
         -0.0142095541163967,
         0.0530981898077838,
         -0.0747246195613262,
         0.067922487725824,
         -0.028984840476028,
         -0.0326213616832032,
         0.0875322986906956,
         -0.0787559087244567,
         -0.0870679330874998,
         0.0450691227987949,
         -0.0757312740717176,
         0.0914288097819119,
         -0.0878042183944812,
         0.0656119930800292,
         -0.0300175822169438,
         -0.0108009229367551,
         0.0473888570604976,
         -0.0708897108298442,
         0.0748909259053972,
         -0.0570745510253706,
         0.0204873382727852,
         0.0258010825393791,
         -0.0669774537762858,
         0.0842279936864343,
         -0.0589595955805024,
         -0.018008702557142,
         0.123132651820136,
         -0.0244421636055693,
         0.0489933225018833,
         -0.0717930922448569,
         0.0871557301182572,
         -0.0907296409223356,
         0.0803813765867368,
         -0.0566405177223642,
         0.0227648705760916,
         0.0155657866432825,
         -0.05092582961567,
         0.0751898928662051,
         -0.0809502540075189,
         0.0633091132853512,
         -0.0220560660972775,
         -0.0357349113008496,
         0.092541341400736,
         -0.115662986393248,
         0.0108328311981082,
         -0.0251732248935295,
         0.043075680527137,
         -0.0620284969761139,
         0.0788598249310417,
         -0.0902427888358348,
         0.0932023515403999,
         -0.0856118265380551,
         0.0666487165676159,
         -0.0371748779812823,
         0.0400228767533714,
         -0.0761386987626878,
         0.100167084494127,
         -0.103452120022374,
         0.0783042119544696,
         -0.00342564200941529,
         0.00906339683764846,
         -0.0177224277074611,
         0.0293893215399236,
         -0.0435914083882299,
         0.0594050761521545,
         -0.0755025341018978,
         0.0902427888358344,
         -0.101807596214252,
         0.108382462602801,
         -0.1083824626028,
         0.100722031037067,
         -0.0851256530758749,
         0.0624651519348428,
         -0.0350187081709493},
        {0.0288729823452855,
         -0.0527146124432046,
         0.0737349443517195,
         -0.0898492439233978,
         0.0999750093710952,
         -0.103897077430747,
         0.102058045783879,
         -0.0953582600618388,
         0.084976872212484,
         -0.0722164549359229,
         0.0583718655760457,
         -0.0446235860247097,
         0.0319556136852728,
         -0.0210979043691613,
         0.0124932617458098,
         -0.00628813718249112,
         0.00234345036531564,
         -0.0687314456458129,
         0.0952759808440117,
         -0.098722047839128,
         0.0838418290998802,
         -0.0565997035496416,
         0.0230882394290547,
         0.0112362210347656,
         -0.0419943956134324,
         0.0660931228319321,
         -0.0817690334112836,
         0.0885122246639692,
         -0.0869025588000208,
         0.0783835877599026,
         -0.0649945456663011,
         0.0490781672200033,
         -0.0329805283718425,
         0.0187573647575648,
         -0.00788922951243739,
         0.107681480536226,
         -0.0957168715877568,
         0.0504867180141001,
         0.00141315374119608,
         -0.0443701770718826,
         0.0704718484790249,
         -0.0774526592079886,
         0.0670121125123073,
         -0.0433769476654834,
         0.0120780866862407,
         0.0210665592656791,
         -0.0507665829926444,
         0.0728721340569508,
         -0.0847860463961243,
         0.0856751696109275,
         -0.076480626983543,
         0.0597256603330035,
         -0.0391148430300224,
         0.0188802840042547,
         -0.121191507887035,
         0.0321044147195764,
         0.0425140908921907,
         -0.0771915747469417,
         0.0744867425361182,
         -0.0463617817074367,
         0.0068340805164272,
         0.0315841733043668,
         -0.0596191519239453,
         0.0719063556419497,
         -0.0669784087140508,
         0.0467920237706149,
         -0.015942908060139,
         -0.0193202927215513,
         0.0521915974898688,
         -0.0764304543233473,
         0.0874302765407045,
         -0.0831433382176759,
         0.0647458868129573,
         -0.0368044490722113,
         0.0903308166437043,
         0.0659683012181601,
         -0.0883593705392987,
         0.048525320838743,
         0.00687379827470815,
         -0.0508401576040164,
         0.0712257376208529,
         -0.0664681659229373,
         0.0418748018443669,
         -0.00645506621368756,
         -0.0296989876621414,
         0.0574838696851854,
         -0.0703076318288135,
         0.0650646663032151,
         -0.0425624068254465,
         0.00740014201971209,
         0.0326994869619316,
         -0.0681045351481495,
         0.0890268675841986,
         -0.0877837333332201,
         0.0613407484536859,
         -0.116616582836794,
         0.0153789395193449,
         0.0571183386648273,
         -0.0792822070494636,
         0.0610304110344814,
         -0.0210105420710485,
         -0.0223740077721293,
         0.0550401530186064,
         -0.0688450941115716,
         0.0617503813364993,
         -0.0370525918671005,
         0.00200568103736509,
         0.033932825782244,
         -0.0610453896431584,
         0.0713215333751625,
         -0.06028484021881,
         0.0285025751133667,
         0.0174336864026254,
         -0.0647336509842906,
         0.0954238102282507,
         -0.0888911895735595,
         0.111431003265844,
         -0.0736088981444225,
         0.0091200436193573,
         0.0446789065987011,
         -0.0715508449864057,
         0.0691435200870762,
         -0.0438138483398093,
         0.00641950083992933,
         0.0310840969484013,
         -0.0582790201767686,
         0.0681636535795341,
         -0.0582790201767685,
         0.0310840969484011,
         0.0064195008399293,
         -0.0438138483398094,
         0.0691435200870764,
         -0.0715508449864055,
         0.044678906598701,
         0.00912004361935731,
         -0.0736088981444226,
         0.111431003265844,
         -0.0888911895735595,
         0.0954238102282508,
         -0.0647336509842908,
         0.0174336864026254,
         0.0285025751133667,
         -0.06028484021881,
         0.0713215333751623,
         -0.0610453896431585,
         0.0339328257822439,
         0.00200568103736506,
         -0.0370525918671004,
         0.0617503813364989,
         -0.0688450941115716,
         0.0550401530186063,
         -0.0223740077721294,
         -0.0210105420710485,
         0.0610304110344814,
         -0.0792822070494636,
         0.0571183386648274,
         0.0153789395193449,
         -0.116616582836794,
         0.0613407484536861,
         -0.0877837333332203,
         0.0890268675841987,
         -0.0681045351481495,
         0.0326994869619315,
         0.00740014201971202,
         -0.0425624068254465,
         0.0650646663032152,
         -0.0703076318288137,
         0.0574838696851852,
         -0.0296989876621416,
         -0.00645506621368761,
         0.041874801844367,
         -0.0664681659229371,
         0.0712257376208528,
         -0.0508401576040165,
         0.00687379827470803,
         0.0485253208387429,
         -0.0883593705392987,
         0.0659683012181599,
         0.0903308166437043,
         -0.0368044490722113,
         0.0647458868129573,
         -0.0831433382176758,
         0.0874302765407044,
         -0.0764304543233472,
         0.0521915974898689,
         -0.0193202927215513,
         -0.015942908060139,
         0.0467920237706151,
         -0.0669784087140509,
         0.0719063556419498,
         -0.0596191519239454,
         0.0315841733043668,
         0.00683408051642722,
         -0.0463617817074369,
         0.0744867425361181,
         -0.0771915747469415,
         0.0425140908921906,
         0.0321044147195763,
         -0.121191507887035,
         0.0188802840042547,
         -0.0391148430300225,
         0.0597256603330034,
         -0.0764806269835431,
         0.0856751696109276,
         -0.0847860463961243,
         0.0728721340569507,
         -0.0507665829926445,
         0.021066559265679,
         0.0120780866862407,
         -0.0433769476654833,
         0.0670121125123075,
         -0.0774526592079888,
         0.0704718484790249,
         -0.0443701770718827,
         0.00141315374119604,
         0.0504867180141002,
         -0.0957168715877567,
         0.107681480536226,
         -0.0078892295124374,
         0.0187573647575646,
         -0.0329805283718426,
         0.0490781672200033,
         -0.064994545666301,
         0.0783835877599025,
         -0.0869025588000203,
         0.0885122246639692,
         -0.0817690334112836,
         0.066093122831932,
         -0.0419943956134324,
         0.0112362210347658,
         0.0230882394290547,
         -0.0565997035496416,
         0.0838418290998801,
         -0.0987220478391279,
         0.0952759808440116,
         -0.0687314456458132,
         0.00234345036531565,
         -0.00628813718249107,
         0.0124932617458099,
         -0.0210979043691612,
         0.0319556136852726,
         -0.0446235860247095,
         0.0583718655760457,
         -0.0722164549359228,
         0.0849768722124839,
         -0.0953582600618388,
         0.102058045783879,
         -0.103897077430747,
         0.0999750093710954,
         -0.0898492439233978,
         0.0737349443517195,
         -0.0527146124432047,
         0.0288729823452856},
        {-0.0091963633065658,
         0.0207497940662633,
         -0.035073553479686,
         0.0508264077301752,
         -0.0664743801022165,
         0.0805044721819548,
         -0.0915813174206374,
         0.0986664610960721,
         -0.101103036910292,
         0.098666461096072,
         -0.0915813174206374,
         0.0805044721819547,
         -0.0664743801022167,
         0.0508264077301752,
         -0.0350735534796861,
         0.0207497940662633,
         -0.00919636330656597,
         0.026811776024053,
         -0.0509397331946769,
         0.0720930045104956,
         -0.0862695347723567,
         0.0908836492031977,
         -0.0849555407823651,
         0.069032015384249,
         -0.0449655342132696,
         0.0156005372865992,
         0.0156005372865992,
         -0.0449655342132697,
         0.0690320153842488,
         -0.0849555407823652,
         0.0908836492031977,
         -0.0862695347723567,
         0.0720930045104956,
         -0.0509397331946769,
         0.0268117760240531,
         -0.0542294871234354,
         0.0828727622561641,
         -0.0922804000523036,
         0.0824245466730365,
         -0.0571561409273644,
         0.0226939791825748,
         0.0138348992951481,
         -0.0456146182646563,
         0.0670941067416544,
         -0.0746695413349585,
         0.0670941067416543,
         -0.0456146182646566,
         0.013834899295148,
         0.0226939791825749,
         -0.0571561409273643,
         0.0824245466730364,
         -0.0922804000523035,
         0.082872762256164,
         -0.0542294871234357,
         0.0863140839799597,
         -0.0971004764764359,
         0.0721002754931348,
         -0.0287551612345312,
         -0.016878323495328,
         0.0524885225772496,
         -0.0706452694660738,
         0.0689504654262059,
         -0.0495085490921266,
         0.0179350436991593,
         0.0179350436991593,
         -0.0495085490921267,
         0.0689504654262062,
         -0.0706452694660736,
         0.0524885225772495,
         -0.016878323495328,
         -0.028755161234531,
         0.072100275493135,
         -0.0971004764764358,
         0.0863140839799598,
         -0.111431003265845,
         0.0736088981444229,
         -0.00912004361935729,
         -0.0446789065987011,
         0.0715508449864054,
         -0.069143520087076,
         0.0438138483398092,
         -0.00641950083992871,
         -0.0310840969484013,
         0.0582790201767685,
         -0.0681636535795342,
         0.0582790201767684,
         -0.0310840969484012,
         -0.00641950083992873,
         0.0438138483398092,
         -0.069143520087076,
         0.0715508449864056,
         -0.0446789065987011,
         -0.00912004361935713,
         0.0736088981444227,
         -0.111431003265844,
         0.114182800426659,
         -0.00751267670759745,
         -0.0628555629352025,
         0.0781880865477263,
         -0.0526719141296394,
         0.00837297122181482,
         0.0345255358169669,
         -0.0619211072880827,
         0.0671565543134662,
         -0.0507002983850863,
         0.0187614281724239,
         0.0187614281724237,
         -0.0507002983850863,
         0.0671565543134661,
         -0.0619211072880828,
         0.0345255358169669,
         0.00837297122181482,
         -0.0526719141296395,
         0.0781880865477262,
         -0.0628555629352026,
         -0.00751267670759745,
         0.114182800426658,
         -0.0826394437835705,
         -0.0751267670759729,
         0.0826394437835706,
         -0.0300507068303898,
         -0.0280736866441806,
         0.0640554540331964,
         -0.0694282971274863,
         0.0482858106655468,
         -0.0116527895681297,
         -0.027120065142597,
         0.0559380417392311,
         -0.0665209145007079,
         0.0559380417392311,
         -0.027120065142597,
         -0.0116527895681297,
         0.0482858106655469,
         -0.0694282971274866,
         0.0640554540331966,
         -0.0280736866441805,
         -0.0300507068303898,
         0.0826394437835705,
         -0.0751267670759729,
         -0.0826394437835706,
         0.114182800426659,
         -0.00751267670759733,
         -0.0628555629352026,
         0.0781880865477261,
         -0.0526719141296394,
         0.00837297122181481,
         0.0345255358169669,
         -0.0619211072880827,
         0.0671565543134664,
         -0.0507002983850863,
         0.0187614281724239,
         0.0187614281724238,
         -0.0507002983850863,
         0.0671565543134659,
         -0.0619211072880826,
         0.034525535816967,
         0.00837297122181465,
         -0.0526719141296396,
         0.0781880865477262,
         -0.0628555629352027,
         -0.00751267670759734,
         0.114182800426659,
         -0.111431003265844,
         0.0736088981444228,
         -0.00912004361935723,
         -0.0446789065987013,
         0.0715508449864055,
         -0.0691435200870759,
         0.043813848339809,
         -0.00641950083992855,
         -0.0310840969484011,
         0.0582790201767685,
         -0.0681636535795341,
         0.0582790201767685,
         -0.0310840969484011,
         -0.00641950083992873,
         0.043813848339809,
         -0.0691435200870759,
         0.0715508449864056,
         -0.0446789065987011,
         -0.00912004361935713,
         0.0736088981444229,
         -0.111431003265844,
         0.0863140839799599,
         -0.0971004764764357,
         0.0721002754931349,
         -0.028755161234531,
         -0.0168783234953281,
         0.0524885225772496,
         -0.0706452694660739,
         0.0689504654262061,
         -0.0495085490921267,
         0.0179350436991592,
         0.0179350436991593,
         -0.0495085490921266,
         0.068950465426206,
         -0.0706452694660739,
         0.0524885225772495,
         -0.016878323495328,
         -0.0287551612345309,
         0.0721002754931349,
         -0.0971004764764358,
         0.0863140839799598,
         -0.0542294871234358,
         0.082872762256164,
         -0.0922804000523037,
         0.0824245466730364,
         -0.0571561409273645,
         0.0226939791825748,
         0.0138348992951483,
         -0.0456146182646565,
         0.067094106741654,
         -0.0746695413349585,
         0.0670941067416541,
         -0.0456146182646563,
         0.0138348992951481,
         0.0226939791825748,
         -0.0571561409273643,
         0.0824245466730364,
         -0.0922804000523037,
         0.082872762256164,
         -0.0542294871234356,
         0.0268117760240531,
         -0.0509397331946771,
         0.0720930045104956,
         -0.0862695347723567,
         0.0908836492031976,
         -0.0849555407823649,
         0.0690320153842488,
         -0.0449655342132696,
         0.0156005372865992,
         0.0156005372865992,
         -0.0449655342132695,
         0.0690320153842489,
         -0.0849555407823651,
         0.0908836492031977,
         -0.0862695347723567,
         0.0720930045104957,
         -0.050939733194677,
         0.0268117760240531,
         -0.00919636330656581,
         0.0207497940662633,
         -0.0350735534796859,
         0.0508264077301753,
         -0.0664743801022164,
         0.0805044721819547,
         -0.0915813174206374,
         0.0986664610960723,
         -0.101103036910292,
         0.0986664610960722,
         -0.0915813174206376,
         0.0805044721819546,
         -0.0664743801022166,
         0.0508264077301752,
         -0.0350735534796859,
         0.0207497940662632,
         -0.00919636330656584},
        {0.00708507063825465,
         -0.0162339362519559,
         0.0279135051183461,
         -0.0412309795617176,
         0.0550972140146518,
         -0.0683738444725144,
         0.0799834021619956,
         -0.0889973140730595,
         0.0947038873698095,
         -0.0966567502975172,
         0.0947038873698094,
         -0.0889973140730595,
         0.0799834021619955,
         -0.0683738444725145,
         0.055097214014652,
         -0.0412309795617176,
         0.0279135051183462,
         -0.0162339362519559,
         0.00708507063825476,
         -0.0218376543272411,
         0.042584162694713,
         -0.0621865991447937,
         0.0773653307339562,
         -0.0857111500393431,
         0.085888056625986,
         -0.0776419155295357,
         0.0617085344748052,
         -0.0396542123374338,
         0.0136693287165658,
         0.0136693287165658,
         -0.0396542123374339,
         0.0617085344748052,
         -0.0776419155295361,
         0.085888056625986,
         -0.085711150039343,
         0.0773653307339562,
         -0.0621865991447939,
         0.042584162694713,
         -0.0218376543272411,
         0.0465580354609401,
         -0.0741282296987102,
         0.0872466368973163,
         -0.084645102758637,
         0.0681109838281903,
         -0.0415310877001161,
         0.00990900036169198,
         0.0214882852385721,
         -0.0478332945704065,
         0.0652860333490728,
         -0.0713857410440306,
         0.0652860333490728,
         -0.0478332945704067,
         0.0214882852385722,
         0.00990900036169197,
         -0.0415310877001162,
         0.0681109838281903,
         -0.0846451027586369,
         0.0872466368973164,
         -0.0741282296987101,
         0.04655803546094,
         -0.0779064943682488,
         0.0936962389705568,
         -0.0782836216296622,
         0.0440631647970559,
         -0.00338101087388958,
         -0.0333630199042487,
         0.0588017957480389,
         -0.068993116139037,
         0.0633246408948678,
         -0.0440775639096255,
         0.0157536699873927,
         0.0157536699873928,
         -0.0440775639096255,
         0.0633246408948678,
         -0.0689931161390369,
         0.0588017957480389,
         -0.0333630199042486,
         -0.00338101087388954,
         0.044063164797056,
         -0.0782836216296621,
         0.0936962389705569,
         -0.0779064943682489,
         0.105485892036369,
         -0.0795129828546751,
         0.0245595675700902,
         0.0275855483338411,
         -0.0609823038584141,
         0.070481072832631,
         -0.058233662455788,
         0.0308235218795692,
         0.0031254925515837,
         -0.0348945156597757,
         0.0571790713900134,
         -0.0651659677567289,
         0.0571790713900135,
         -0.0348945156597757,
         0.00312549255158369,
         0.0308235218795693,
         -0.058233662455788,
         0.0704810728326307,
         -0.060982303858414,
         0.0275855483338412,
         0.0245595675700901,
         -0.0795129828546752,
         0.105485892036369,
         -0.113121016754247,
         0.0204272551558342,
         0.0496779800157744,
         -0.0751639173667257,
         0.0629747205074399,
         -0.0286700064443596,
         -0.0116081775432225,
         0.0448709771566788,
         -0.062888256360291,
         0.0625377786612028,
         -0.0453466792992675,
         0.0164990352353357,
         0.0164990352353357,
         -0.0453466792992675,
         0.0625377786612027,
         -0.062888256360291,
         0.0448709771566786,
         -0.0116081775432225,
         -0.0286700064443596,
         0.0629747205074398,
         -0.075163917366726,
         0.0496779800157745,
         0.0204272551558342,
         -0.113121016754247,
         0.0855114509675739,
         0.0641335882256808,
         -0.0836525063813222,
         0.0440231877016858,
         0.00912572796887091,
         -0.0499380113852144,
         0.0673400452751702,
         -0.0606380608457905,
         0.0357024094220776,
         -0.00173886921823731,
         -0.0313530127585501,
         0.0550345436719242,
         -0.0635954726875552,
         0.0550345436719241,
         -0.0313530127585502,
         -0.00173886921823727,
         0.0357024094220773,
         -0.0606380608457905,
         0.0673400452751704,
         -0.0499380113852144,
         0.00912572796887083,
         0.0440231877016859,
         -0.0836525063813223,
         0.064133588225681,
         0.085511450967574,
         -0.113121016754247,
         0.0204272551558341,
         0.0496779800157744,
         -0.0751639173667259,
         0.0629747205074399,
         -0.0286700064443597,
         -0.0116081775432227,
         0.0448709771566785,
         -0.0628882563602909,
         0.0625377786612029,
         -0.0453466792992674,
         0.0164990352353357,
         0.0164990352353355,
         -0.0453466792992675,
         0.0625377786612026,
         -0.062888256360291,
         0.0448709771566788,
         -0.0116081775432225,
         -0.0286700064443595,
         0.0629747205074398,
         -0.0751639173667258,
         0.0496779800157744,
         0.0204272551558341,
         -0.113121016754247,
         0.105485892036369,
         -0.0795129828546752,
         0.0245595675700902,
         0.0275855483338413,
         -0.0609823038584141,
         0.0704810728326306,
         -0.058233662455788,
         0.0308235218795693,
         0.0031254925515837,
         -0.0348945156597758,
         0.0571790713900135,
         -0.065165967756729,
         0.0571790713900135,
         -0.0348945156597756,
         0.00312549255158363,
         0.0308235218795693,
         -0.0582336624557881,
         0.0704810728326306,
         -0.0609823038584141,
         0.0275855483338413,
         0.0245595675700902,
         -0.0795129828546754,
         0.105485892036369,
         -0.0779064943682491,
         0.0936962389705569,
         -0.0782836216296621,
         0.0440631647970559,
         -0.00338101087388953,
         -0.0333630199042487,
         0.0588017957480389,
         -0.0689931161390368,
         0.0633246408948678,
         -0.0440775639096255,
         0.0157536699873927,
         0.0157536699873926,
         -0.0440775639096253,
         0.0633246408948678,
         -0.0689931161390369,
         0.0588017957480389,
         -0.0333630199042485,
         -0.00338101087388963,
         0.0440631647970559,
         -0.078283621629662,
         0.0936962389705569,
         -0.0779064943682488,
         0.04655803546094,
         -0.0741282296987103,
         0.0872466368973164,
         -0.0846451027586369,
         0.0681109838281902,
         -0.0415310877001163,
         0.00990900036169177,
         0.0214882852385722,
         -0.0478332945704065,
         0.0652860333490728,
         -0.0713857410440305,
         0.0652860333490728,
         -0.0478332945704066,
         0.0214882852385723,
         0.00990900036169182,
         -0.0415310877001163,
         0.0681109838281902,
         -0.0846451027586368,
         0.0872466368973163,
         -0.0741282296987101,
         0.04655803546094,
         -0.0218376543272413,
         0.042584162694713,
         -0.0621865991447939,
         0.0773653307339561,
         -0.0857111500393433,
         0.0858880566259858,
         -0.077641915529536,
         0.0617085344748052,
         -0.0396542123374339,
         0.0136693287165657,
         0.0136693287165658,
         -0.0396542123374338,
         0.0617085344748049,
         -0.0776419155295358,
         0.085888056625986,
         -0.0857111500393433,
         0.077365330733956,
         -0.0621865991447942,
         0.0425841626947131,
         -0.0218376543272412,
         0.00708507063825489,
         -0.0162339362519557,
         0.0279135051183461,
         -0.0412309795617175,
         0.0550972140146519,
         -0.0683738444725144,
         0.0799834021619954,
         -0.0889973140730594,
         0.0947038873698094,
         -0.0966567502975175,
         0.0947038873698096,
         -0.0889973140730595,
         0.0799834021619954,
         -0.0683738444725145,
         0.055097214014652,
         -0.0412309795617175,
         0.0279135051183462,
         -0.0162339362519557,
         0.00708507063825468},
        {0.101835015443463,
         -0.124721912892465,
         0.121980437173918,
         -0.106170342878434,
         0.0851256530758745,
         -0.0637022057270607,
         0.0446473881685942,
         -0.0292285765520944,
         0.0177224277074612,
         -0.00979644051330783,
         0.00479925611062663,
         -0.00197196971144527,
         0.000590747590248788,
         -0.138777733297743,
         0.0666666666666667,
         0.00982946374365948,
         -0.0642057883124099,
         0.0928797020958923,
         -0.100103466142523,
         0.0924838754920881,
         -0.0765383797175905,
         0.0576066532204945,
         -0.0394709836566603,
         0.0243704478192556,
         -0.0132299900606911,
         0.00599186841537968,
         -0.00197196971144523,
         0.101835015443463,
         0.0666666666666667,
         -0.100241254874148,
         0.06786365036054,
         -0.0133953011342622,
         -0.0378876330722915,
         0.0738821627401345,
         -0.0912662010319317,
         0.0920299482469902,
         -0.0808347243053072,
         0.063103030766249,
         -0.0437435791498476,
         0.0264148565354066,
         -0.013229990060691,
         0.00479925611062666,
         -0.124721912892465,
         0.00982946374365938,
         0.06786365036054,
         -0.0888543756323413,
         0.066976505671312,
         -0.0230652627204486,
         -0.0243919182324226,
         0.0626080973932324,
         -0.0850579824707035,
         0.0906355550917333,
         -0.0821543233045921,
         0.0646446648757873,
         -0.0437435791498478,
         0.0243704478192555,
         -0.00979644051330782,
         0.121980437173918,
         -0.0642057883124101,
         -0.0133953011342621,
         0.0669765056713121,
         -0.0832197475142009,
         0.0660536268276479,
         -0.0277480734373726,
         -0.0173039639909482,
         0.0566405177223642,
         -0.081986794205423,
         0.0900468112564815,
         -0.0821543233045924,
         0.0631030307662489,
         -0.0394709836566602,
         0.0177224277074612,
         -0.106170342878434,
         0.0928797020958924,
         -0.0378876330722913,
         -0.0230652627204486,
         0.0660536268276479,
         -0.0801017883428008,
         0.0654028363080939,
         -0.0299713448046642,
         -0.0142005293113486,
         0.0547707408673447,
         -0.081986794205423,
         0.0906355550917334,
         -0.0808347243053071,
         0.0576066532204945,
         -0.0292285765520943,
         0.0851256530758747,
         -0.100103466142523,
         0.0738821627401347,
         -0.0243919182324227,
         -0.0277480734373727,
         0.0654028363080938,
         -0.0784834035697131,
         0.0650750004776944,
         -0.0306344821800407,
         -0.0142005293113487,
         0.0566405177223643,
         -0.0850579824707034,
         0.0920299482469906,
         -0.0765383797175904,
         0.0446473881685943,
         -0.0637022057270608,
         0.0924838754920883,
         -0.0912662010319315,
         0.0626080973932323,
         -0.0173039639909483,
         -0.0299713448046642,
         0.0650750004776943,
         -0.0779786819128289,
         0.0650750004776944,
         -0.0299713448046642,
         -0.0173039639909482,
         0.0626080973932323,
         -0.0912662010319316,
         0.0924838754920883,
         -0.0637022057270607,
         0.0446473881685943,
         -0.0765383797175904,
         0.0920299482469905,
         -0.0850579824707034,
         0.0566405177223642,
         -0.0142005293113486,
         -0.0306344821800406,
         0.0650750004776943,
         -0.0784834035697132,
         0.0654028363080938,
         -0.0277480734373726,
         -0.0243919182324228,
         0.0738821627401347,
         -0.100103466142524,
         0.0851256530758749,
         -0.0292285765520944,
         0.0576066532204944,
         -0.0808347243053073,
         0.0906355550917333,
         -0.0819867942054228,
         0.0547707408673448,
         -0.0142005293113488,
         -0.0299713448046642,
         0.0654028363080937,
         -0.0801017883428009,
         0.066053626827648,
         -0.0230652627204486,
         -0.0378876330722916,
         0.0928797020958922,
         -0.106170342878434,
         0.0177224277074612,
         -0.0394709836566603,
         0.0631030307662489,
         -0.0821543233045924,
         0.0900468112564816,
         -0.0819867942054229,
         0.0566405177223642,
         -0.0173039639909483,
         -0.0277480734373726,
         0.0660536268276481,
         -0.0832197475142008,
         0.066976505671312,
         -0.0133953011342621,
         -0.0642057883124102,
         0.121980437173918,
         -0.00979644051330786,
         0.0243704478192554,
         -0.0437435791498478,
         0.0646446648757871,
         -0.0821543233045925,
         0.0906355550917335,
         -0.0850579824707032,
         0.0626080973932323,
         -0.0243919182324227,
         -0.0230652627204485,
         0.0669765056713122,
         -0.0888543756323414,
         0.0678636503605402,
         0.00982946374365936,
         -0.124721912892465,
         0.00479925611062657,
         -0.0132299900606911,
         0.0264148565354066,
         -0.0437435791498477,
         0.0631030307662489,
         -0.0808347243053074,
         0.0920299482469907,
         -0.0912662010319317,
         0.0738821627401346,
         -0.0378876330722916,
         -0.0133953011342622,
         0.0678636503605402,
         -0.100241254874148,
         0.0666666666666668,
         0.101835015443463,
         -0.00197196971144524,
         0.00599186841537968,
         -0.013229990060691,
         0.0243704478192555,
         -0.0394709836566604,
         0.0576066532204944,
         -0.0765383797175902,
         0.0924838754920883,
         -0.100103466142524,
         0.0928797020958924,
         -0.06420578831241,
         0.00982946374365946,
         0.0666666666666667,
         -0.138777733297743,
         0.000590747590248789,
         -0.00197196971144529,
         0.00479925611062658,
         -0.00979644051330789,
         0.0177224277074611,
         -0.0292285765520942,
         0.0446473881685943,
         -0.0637022057270608,
         0.0851256530758748,
         -0.106170342878434,
         0.121980437173918,
         -0.124721912892465,
         0.101835015443463},
        {-0.0497983049462868,
         0.0822391939658614,
         -0.103092285471181,
         0.111352395024161,
         -0.1083824626028,
         0.0969402215794765,
         -0.080306914897214,
         0.0616475609455789,
         -0.0435914083882298,
         0.0280038214560611,
         -0.015917331791769,
         0.00758829019203065,
         -0.00264190353868064,
         0.0959736947320222,
         -0.107825827229441,
         0.0813956927556484,
         -0.0355702178187762,
         -0.013654906787037,
         0.0549599396440269,
         -0.0820899294964395,
         0.0932905695928425,
         -0.0902427888358347,
         0.0768039100173577,
         -0.0577649335670532,
         0.0377676060549824,
         -0.0204762742020575,
         0.00805053263544057,
         -0.121980437173918,
         0.0642057883124097,
         0.0133953011342623,
         -0.0669765056713124,
         0.0832197475142009,
         -0.0660536268276483,
         0.0277480734373725,
         0.0173039639909481,
         -0.056640517722364,
         0.0819867942054229,
         -0.090046811256481,
         0.0821543233045919,
         -0.0631030307662486,
         0.0394709836566603,
         -0.0177224277074612,
         0.111352395024161,
         0.0260063165868501,
         -0.0854493259282207,
         0.0691730376139091,
         -0.01536546420067,
         -0.0394745922673517,
         0.0719431199389026,
         -0.0734145016764444,
         0.0473888570604968,
         -0.00504593836968066,
         -0.0395489464343279,
         0.0736893077360301,
         -0.0891544890224376,
         0.0838822946888025,
         -0.0620284969761138,
         0.0323565780971035,
         -0.0671480206913781,
         -0.100212042792842,
         0.0580763206912502,
         0.0245842950053334,
         -0.072968185706316,
         0.0703218973523089,
         -0.0306404100061826,
         -0.0208693657977443,
         0.0606200296354307,
         -0.0738282565659795,
         0.0571107274560783,
         -0.0175497877926638,
         -0.0307124771417205,
         0.0712920820160524,
         -0.090729640922336,
         0.0829249406279415,
         -0.051623240090901,
         0.101229450021965,
         0.046860129759628,
         -0.0861513003528167,
         0.0441036860807937,
         0.0208633151276458,
         -0.0652366084209444,
         0.0705513331897959,
         -0.0404133530902868,
         -0.00763740585165371,
         0.0514701626882844,
         -0.0726307775522934,
         0.0621588630589272,
         -0.0231815621118455,
         -0.030017582216943,
         0.0763243725123827,
         -0.0949081721512528,
         0.0737327348717307,
         -0.114783407191697,
         0.0148184741491459,
         0.0633091132853512,
         -0.0774109261308922,
         0.0400915391542919,
         0.0159540204988572,
         -0.0591590913433575,
         0.0705513331897972,
         -0.0475825613861662,
         0.00222162388558728,
         0.0448369725059871,
         -0.0720090751800376,
         0.0648668774711029,
         -0.0225641999754239,
         -0.0391792845323917,
         0.0903037888878278,
         -0.0951885514095135,
         0.110891306521744,
         -0.0636005261638778,
         -0.0132191211244736,
         0.0658408533364935,
         -0.0732119785273663,
         0.0408700156427242,
         0.00985984855722565,
         -0.0535401160268595,
         0.0705343716958159,
         -0.0535401160268596,
         0.00985984855722551,
         0.0408700156427242,
         -0.0732119785273662,
         0.0658408533364935,
         -0.0132191211244737,
         -0.0636005261638778,
         0.110891306521744,
         -0.0951885514095136,
         0.0903037888878278,
         -0.0391792845323918,
         -0.022564199975424,
         0.0648668774711028,
         -0.0720090751800375,
         0.044836972505987,
         0.00222162388558723,
         -0.0475825613861663,
         0.0705513331897974,
         -0.0591590913433576,
         0.0159540204988571,
         0.040091539154292,
         -0.0774109261308922,
         0.0633091132853516,
         0.0148184741491458,
         -0.114783407191697,
         0.0737327348717307,
         -0.0949081721512527,
         0.0763243725123831,
         -0.0300175822169426,
         -0.0231815621118457,
         0.062158863058927,
         -0.0726307775522933,
         0.0514701626882845,
         -0.00763740585165392,
         -0.0404133530902867,
         0.0705513331897957,
         -0.0652366084209445,
         0.0208633151276458,
         0.0441036860807937,
         -0.0861513003528166,
         0.0468601297596278,
         0.101229450021964,
         -0.051623240090901,
         0.0829249406279413,
         -0.0907296409223359,
         0.0712920820160523,
         -0.0307124771417206,
         -0.0175497877926639,
         0.0571107274560781,
         -0.0738282565659793,
         0.0606200296354307,
         -0.0208693657977441,
         -0.0306404100061824,
         0.0703218973523092,
         -0.0729681857063158,
         0.0245842950053334,
         0.0580763206912501,
         -0.100212042792842,
         -0.0671480206913782,
         0.0323565780971035,
         -0.0620284969761136,
         0.0838822946888023,
         -0.0891544890224376,
         0.0736893077360301,
         -0.0395489464343279,
         -0.00504593836968063,
         0.0473888570604968,
         -0.0734145016764443,
         0.0719431199389028,
         -0.0394745922673519,
         -0.0153654642006701,
         0.069173037613909,
         -0.0854493259282208,
         0.0260063165868499,
         0.111352395024161,
         -0.0177224277074613,
         0.0394709836566603,
         -0.0631030307662485,
         0.0821543233045921,
         -0.090046811256481,
         0.0819867942054227,
         -0.0566405177223639,
         0.017303963990948,
         0.0277480734373725,
         -0.0660536268276481,
         0.083219747514201,
         -0.0669765056713122,
         0.0133953011342624,
         0.0642057883124097,
         -0.121980437173918,
         0.00805053263544046,
         -0.0204762742020575,
         0.0377676060549821,
         -0.0577649335670528,
         0.0768039100173575,
         -0.0902427888358347,
         0.0932905695928424,
         -0.0820899294964397,
         0.0549599396440268,
         -0.0136549067870369,
         -0.0355702178187759,
         0.0813956927556482,
         -0.107825827229441,
         0.0959736947320223,
         -0.00264190353868057,
         0.00758829019203062,
         -0.0159173317917689,
         0.028003821456061,
         -0.0435914083882298,
         0.061647560945579,
         -0.0803069148972141,
         0.0969402215794762,
         -0.108382462602801,
         0.111352395024161,
         -0.103092285471181,
         0.0822391939658616,
         -0.0497983049462867},
        {0.0410587841367627,
         -0.0701212232599282,
         0.091309900436414,
         -0.103011460460346,
         0.105435591193283,
         -0.100024984385149,
         0.0888745308726207,
         -0.0742734136527075,
         0.0583718655760457,
         -0.042960529840756,
         0.0293476289438508,
         -0.0183184314741313,
         0.0101612375332392,
         -0.00474377151630856,
         0.00162180880977407,
         -0.0849997585237562,
         0.103037254374763,
         -0.0884212251989843,
         0.0540697533828711,
         -0.0120155007517492,
         -0.0281788470440875,
         0.0600901503231973,
         -0.0804102898371337,
         0.0885122246639691,
         -0.0858029550762954,
         0.0749980494821613,
         -0.0594123177089145,
         0.0423336507607623,
         -0.0265265101373971,
         0.0138943518744473,
         -0.00530861545252555,
         0.115491929381143,
         -0.0748596992345795,
         0.00803142376245964,
         0.0472260003478581,
         -0.0755897464064126,
         0.0754058742138562,
         -0.0527939664145747,
         0.017322688190541,
         0.021066559265679,
         -0.0540789503269227,
         0.076191599639151,
         -0.0850403109648135,
         0.0812204308062677,
         -0.0676534134435583,
         0.0486697561601109,
         -0.0289561186598019,
         0.0124932617458098,
         -0.112237980744053,
         -0.0078582304553712,
         0.0742520069482922,
         -0.0767281103552494,
         0.0391261869132772,
         0.0107985352009158,
         -0.0516438525758591,
         0.0713788922665888,
         -0.0669784087140511,
         0.0424178017646777,
         -0.00599639578349435,
         -0.0324095326080788,
         0.0637690442636778,
         -0.0817336280777376,
         0.0837271366711077,
         -0.0712064345871691,
         0.0490781672200034,
         -0.0242825360831763,
         0.0717876536908171,
         0.0898010125629183,
         -0.0695188499619844,
         -0.00134063535184798,
         0.0566647729568812,
         -0.0733625267393812,
         0.0539745893038099,
         -0.0135518125622022,
         -0.0296989876621418,
         0.0605028197633319,
         -0.0698388727068256,
         0.0559984338045788,
         -0.0238793995538374,
         -0.0169814978073477,
         0.0551373853782619,
         -0.080218775992773,
         0.0856751696109279,
         -0.0707530725341428,
         0.0410915929212562,
         -0.103616552957213,
         -0.028807393101983,
         0.0811846267616456,
         -0.0603354867114945,
         0.00666762183157905,
         0.0433607456937569,
         -0.0681168476070256,
         0.0617503813364996,
         -0.0307721973240737,
         -0.0110952777246218,
         0.0482764066606658,
         -0.0679617159417663,
         0.0633893132615356,
         -0.0354370264850514,
         -0.00762548657826287,
         0.0521915974898685,
         -0.0829546312403739,
         0.0876620648986796,
         -0.0620469446474056,
         0.112265704094048,
         -0.0325715843548456,
         -0.0443701770718826,
         0.0750779071594231,
         -0.0590562106191143,
         0.0156316291462428,
         0.0310840969484005,
         -0.0615551026200762,
         0.0656109374897915,
         -0.0435875039224248,
         0.00470373897341822,
         0.0364523411855878,
         -0.0644582336498147,
         0.0677437092010793,
         -0.0425624068254469,
         -0.00461685874662876,
         0.0571561409273647,
         -0.0915472071639095,
         0.084435196936031,
         -0.103411574412343,
         0.0744648443311667,
         -0.0102164923565227,
         -0.0459910159760428,
         0.0711076232436402,
         -0.0610453896431582,
         0.0255438501169854,
         0.0184955218602641,
         -0.053546184309,
         0.0667864681094778,
         -0.053546184309,
         0.018495521860264,
         0.0255438501169854,
         -0.0610453896431583,
         0.07110762324364,
         -0.0459910159760428,
         -0.0102164923565227,
         0.0744648443311669,
         -0.103411574412343,
         0.0844351969360309,
         -0.0915472071639096,
         0.0571561409273649,
         -0.00461685874662867,
         -0.0425624068254468,
         0.0677437092010793,
         -0.0644582336498146,
         0.0364523411855877,
         0.00470373897341819,
         -0.0435875039224246,
         0.0656109374897915,
         -0.0615551026200762,
         0.0310840969484004,
         0.0156316291462428,
         -0.0590562106191147,
         0.0750779071594232,
         -0.0443701770718825,
         -0.0325715843548458,
         0.112265704094048,
         -0.0620469446474056,
         0.0876620648986796,
         -0.0829546312403739,
         0.0521915974898686,
         -0.0076254865782628,
         -0.0354370264850513,
         0.0633893132615359,
         -0.0679617159417662,
         0.048276406660666,
         -0.0110952777246218,
         -0.0307721973240738,
         0.0617503813364998,
         -0.0681168476070254,
         0.0433607456937568,
         0.00666762183157902,
         -0.0603354867114943,
         0.0811846267616457,
         -0.0288073931019831,
         -0.103616552957213,
         0.0410915929212563,
         -0.0707530725341427,
         0.0856751696109281,
         -0.0802187759927731,
         0.0551373853782619,
         -0.0169814978073477,
         -0.0238793995538374,
         0.0559984338045788,
         -0.0698388727068255,
         0.0605028197633317,
         -0.0296989876621418,
         -0.0135518125622022,
         0.0539745893038098,
         -0.0733625267393811,
         0.0566647729568812,
         -0.00134063535184797,
         -0.0695188499619843,
         0.0898010125629181,
         0.0717876536908174,
         -0.024282536083176,
         0.0490781672200033,
         -0.071206434587169,
         0.0837271366711078,
         -0.0817336280777374,
         0.0637690442636777,
         -0.0324095326080787,
         -0.00599639578349426,
         0.0424178017646775,
         -0.066978408714051,
         0.0713788922665888,
         -0.0516438525758592,
         0.0107985352009159,
         0.0391261869132772,
         -0.0767281103552495,
         0.0742520069482921,
         -0.00785823045537121,
         -0.112237980744052,
         0.0124932617458099,
         -0.0289561186598019,
         0.0486697561601108,
         -0.067653413443558,
         0.0812204308062677,
         -0.0850403109648134,
         0.0761915996391509,
         -0.0540789503269226,
         0.0210665592656791,
         0.017322688190541,
         -0.0527939664145748,
         0.0754058742138562,
         -0.0755897464064128,
         0.0472260003478583,
         0.0080314237624596,
         -0.0748596992345795,
         0.115491929381143,
         -0.00530861545252557,
         0.0138943518744472,
         -0.0265265101373972,
         0.0423336507607623,
         -0.0594123177089144,
         0.0749980494821613,
         -0.0858029550762954,
         0.0885122246639692,
         -0.0804102898371335,
         0.0600901503231975,
         -0.0281788470440874,
         -0.012015500751749,
         0.054069753382871,
         -0.0884212251989843,
         0.103037254374763,
         -0.0849997585237561,
         0.00162180880977412,
         -0.00474377151630867,
         0.0101612375332392,
         -0.0183184314741314,
         0.0293476289438508,
         -0.0429605298407558,
         0.058371865576046,
         -0.0742734136527076,
         0.0888745308726207,
         -0.100024984385149,
         0.105435591193283,
         -0.103011460460346,
         0.091309900436414,
         -0.0701212232599281,
         0.0410587841367628},
        {0.0165789797248095,
         -0.0349912532798833,
         0.0550619417076898,
         -0.0738733467789151,
         0.0888745308726209,
         -0.098254490774447,
         0.101103036910292,
         -0.0974253241287506,
         0.0880428868315526,
         -0.0744098204042682,
         0.0583718655760455,
         -0.0418958556365357,
         0.0267966793021219,
         -0.0144877552600035,
         0.00577205985726372,
         -0.0420353857604416,
         0.0717953032889734,
         -0.0894669277875885,
         0.0911912390471831,
         -0.0770009135842655,
         0.0500751252693315,
         -0.0156005372865992,
         -0.0204258979993778,
         0.0522925595083551,
         -0.0754653315699024,
         0.087209654645889,
         -0.0869025588000205,
         0.0760176926943135,
         -0.0577873943010838,
         0.0365643347038184,
         -0.0168988609073008,
         0.0737349443517195,
         -0.0949097397952841,
         0.0824453904377855,
         -0.046472458360583,
         0.00102572195364239,
         0.0402631253745769,
         -0.0670941067416543,
         0.0740088806607205,
         -0.0607032508978108,
         0.0313954756725203,
         0.00649021582057165,
         -0.0440638700855121,
         0.0728721340569505,
         -0.0867002294934228,
         0.0830089381422089,
         -0.0637315103463798,
         0.0350735534796857,
         -0.101338987953727,
         0.0838418290998809,
         -0.0278433726215341,
         -0.0297608970069547,
         0.0657795244648471,
         -0.0713595876300575,
         0.0495085490921278,
         -0.011025734215928,
         -0.0299799965723387,
         0.0602033358639237,
         -0.0703688928107196,
         0.057243278872379,
         -0.024255476226167,
         -0.0193202927215512,
         0.0605365057901988,
         -0.0860749905151979,
         0.0862695347723569,
         -0.0590375877623325,
         0.112265704094048,
         -0.0325715843548458,
         -0.0443701770718828,
         0.0750779071594235,
         -0.0590562106191145,
         0.0156316291462427,
         0.0310840969484005,
         -0.0615551026200759,
         0.0656109374897909,
         -0.0435875039224243,
         0.00470373897341815,
         0.0364523411855884,
         -0.0644582336498154,
         0.0677437092010801,
         -0.0425624068254467,
         -0.0046168587466287,
         0.0571561409273648,
         -0.0915472071639095,
         0.0844351969360312,
         -0.097870971794279,
         -0.0406192600696392,
         0.0815964237765276,
         -0.0463617817074375,
         -0.0133300395786989,
         0.0573479400579923,
         -0.0671565543134651,
         0.0439447391070322,
         -0.00195599214108746,
         -0.0395034182011226,
         0.0633696820246418,
         -0.0602149853152241,
         0.0310134831636185,
         0.0130480554440164,
         -0.0537021451542373,
         0.071321533375163,
         -0.052488522577251,
         -0.00182629301872291,
         0.0694219596207089,
         -0.104098702067183,
         0.0595623766407538,
         0.0965438463509746,
         -0.0457736035819544,
         -0.0339845112076571,
         0.0712257376208539,
         -0.0568268651637742,
         0.0116527895681309,
         0.0357309793201246,
         -0.0627427586507234,
         0.0593690045090556,
         -0.0291514544147477,
         -0.0139198695302405,
         0.0511046297488755,
         -0.0656976653636931,
         0.049397937364597,
         -0.00675537452156287,
         -0.0438138483398088,
         0.0739648672582626,
         -0.0558782993297755,
         -0.0190057357764013,
         0.109729666666525,
         -0.0950286788820092,
         -0.0459032129123956,
         0.0807523085523097,
         -0.0388961827418902,
         -0.0223740077721295,
         0.0619211072880827,
         -0.0637471757376508,
         0.0331991692724031,
         0.0116666114591285,
         -0.0495993790850676,
         0.0642653089020532,
         -0.0495993790850676,
         0.0116666114591285,
         0.0331991692724031,
         -0.0637471757376508,
         0.0619211072880824,
         -0.0223740077721295,
         -0.03889618274189,
         0.0807523085523095,
         -0.0459032129123955,
         -0.0950286788820093,
         0.109729666666525,
         -0.0190057357764013,
         -0.0558782993297754,
         0.0739648672582626,
         -0.0438138483398089,
         -0.00675537452156278,
         0.0493979373645968,
         -0.0656976653636933,
         0.0511046297488755,
         -0.0139198695302402,
         -0.0291514544147477,
         0.0593690045090556,
         -0.0627427586507233,
         0.0357309793201244,
         0.0116527895681308,
         -0.056826865163774,
         0.0712257376208539,
         -0.033984511207657,
         -0.0457736035819545,
         0.0965438463509744,
         0.0595623766407538,
         -0.104098702067183,
         0.0694219596207088,
         -0.00182629301872298,
         -0.0524885225772513,
         0.0713215333751629,
         -0.0537021451542374,
         0.0130480554440164,
         0.0310134831636187,
         -0.060214985315224,
         0.0633696820246419,
         -0.0395034182011222,
         -0.00195599214108736,
         0.043944739107032,
         -0.0671565543134649,
         0.0573479400579925,
         -0.0133300395786987,
         -0.0463617817074375,
         0.0815964237765277,
         -0.0406192600696392,
         -0.0978709717942789,
         0.084435196936031,
         -0.0915472071639097,
         0.0571561409273646,
         -0.00461685874662873,
         -0.0425624068254466,
         0.0677437092010802,
         -0.0644582336498157,
         0.0364523411855887,
         0.00470373897341818,
         -0.0435875039224242,
         0.065610937489791,
         -0.0615551026200759,
         0.0310840969484006,
         0.0156316291462426,
         -0.0590562106191145,
         0.0750779071594234,
         -0.0443701770718831,
         -0.0325715843548458,
         0.112265704094048,
         -0.0590375877623325,
         0.0862695347723571,
         -0.0860749905151977,
         0.0605365057901988,
         -0.0193202927215512,
         -0.0242554762261669,
         0.057243278872379,
         -0.0703688928107198,
         0.0602033358639236,
         -0.0299799965723387,
         -0.011025734215928,
         0.0495085490921278,
         -0.0713595876300572,
         0.0657795244648471,
         -0.0297608970069548,
         -0.0278433726215343,
         0.0838418290998807,
         -0.101338987953727,
         0.0350735534796858,
         -0.0637315103463798,
         0.0830089381422088,
         -0.0867002294934226,
         0.0728721340569506,
         -0.0440638700855121,
         0.0064902158205715,
         0.0313954756725202,
         -0.0607032508978108,
         0.0740088806607206,
         -0.0670941067416542,
         0.040263125374577,
         0.00102572195364233,
         -0.0464724583605831,
         0.0824453904377854,
         -0.0949097397952841,
         0.0737349443517196,
         -0.0168988609073009,
         0.0365643347038186,
         -0.0577873943010838,
         0.0760176926943138,
         -0.0869025588000204,
         0.0872096546458893,
         -0.0754653315699025,
         0.0522925595083552,
         -0.0204258979993779,
         -0.015600537286599,
         0.0500751252693315,
         -0.0770009135842656,
         0.0911912390471829,
         -0.0894669277875884,
         0.071795303288973,
         -0.0420353857604417,
         0.00577205985726378,
         -0.0144877552600037,
         0.0267966793021219,
         -0.0418958556365354,
         0.0583718655760456,
         -0.074409820404268,
         0.0880428868315526,
         -0.0974253241287507,
         0.101103036910292,
         -0.0982544907744469,
         0.0888745308726208,
         -0.0738733467789151,
         0.0550619417076898,
         -0.0349912532798833,
         0.0165789797248093},
        {-0.012772792738256,
         0.0275923859103814,
         -0.0445657236262622,
         0.0615763961337164,
         -0.0766030921378043,
         0.0880102523408281,
         -0.0947038873698091,
         0.0961953789267287,
         -0.0925912672473506,
         0.0845238761656053,
         -0.0730369765671499,
         0.0594405079912214,
         -0.045148306831621,
         0.0315127253846154,
         -0.0196698582234922,
         0.0104083106366518,
         -0.00406827535360737,
         0.0344764017658805,
         -0.0613195414428044,
         0.0804596319350664,
         -0.0879662801910231,
         0.0825977920648367,
         -0.0655137201250604,
         0.0396542123374336,
         -0.00901941784474375,
         -0.0220455398207977,
         0.0494921141495442,
         -0.0700895633394215,
         0.0817940574607228,
         -0.0839460239475725,
         0.0772867665107775,
         -0.0637954110707407,
         0.046357001597933,
         -0.0282810032741121,
         0.0126798984673063,
         -0.0641440701393278,
         0.0883302810338057,
         -0.0854311973271781,
         0.0607891730006562,
         -0.0237170383347895,
         -0.0154944658484993,
         0.0478332945704071,
         -0.0669721319810553,
         0.0699235234462515,
         -0.0570700160803054,
         0.0317003234667083,
         0.000816170239226705,
         -0.0340838403086177,
         0.0618312710356739,
         -0.0790246141715056,
         0.0828102802526347,
         -0.0731517440304968,
         0.0530173189049296,
         -0.027913505118346,
         0.0931991731882389,
         -0.0872890232592498,
         0.0439546143037598,
         0.00845236522999079,
         -0.0495558059258289,
         0.0685158885227245,
         -0.0633246408948687,
         0.0387539692642465,
         -0.00372292700896707,
         -0.031397330484542,
         0.0571878077764819,
         -0.0670552276183287,
         0.0584192496183197,
         -0.033126366359983,
         -0.00293542977926452,
         0.0409877704979119,
         -0.0711820650465558,
         0.0849161840973471,
         -0.0773653307339561,
         0.0496724464061765,
         -0.108833186885656,
         0.0458881007431253,
         0.0263871987472968,
         -0.0667024018412439,
         0.0673850940812817,
         -0.0384420775167773,
         -0.00312549255158235,
         0.0405463557541951,
         -0.061684982780555,
         0.0611167999906896,
         -0.0403277657959635,
         0.0064841570727352,
         0.0297846034501968,
         -0.0571484127568663,
         0.0664431177802292,
         -0.0532005622565917,
         0.0194018947606408,
         0.0259843170925812,
         -0.0681109838281913,
         0.0894058421249195,
         -0.0748840305219658,
         0.0997472634053586,
         0.0251339478980794,
         -0.0765466435091584,
         0.0591740796136171,
         -0.00978897124760029,
         -0.0377620806301031,
         0.0628882563602909,
         -0.0594037787276906,
         0.0325932830718716,
         0.0053798410330494,
         -0.0403325391599838,
         0.0603195526163657,
         -0.058734897113959,
         0.0359238413137032,
         0.000852104370422041,
         -0.0390972542659045,
         0.0642539746567204,
         -0.0640340422027166,
         0.0333630199042508,
         0.0209035224035058,
         -0.0767665080822726,
         0.097060796852904,
         -0.0636671559392016,
         -0.0886642341380968,
         0.0574896634233478,
         0.0144248008796,
         -0.0611655364911248,
         0.0652201182844462,
         -0.0357024094220773,
         -0.0075094734612908,
         0.044485789762854,
         -0.061571874110209,
         0.0540923907148144,
         -0.026196646316417,
         -0.0113915028089645,
         0.0449555548131079,
         -0.061936366387454,
         0.0548863075864183,
         -0.0244630925949252,
         -0.0193024428218156,
         0.058233662455787,
         -0.0705095913764659,
         0.0392556055151599,
         0.0337922320026912,
         -0.107304748337997,
         0.0972531871246499,
         0.0305712774436362,
         -0.0773430328929719,
         0.0535889927243467,
         -0.0009457044687097,
         -0.0448709771566772,
         0.0641736133483514,
         -0.0534178590518697,
         0.021021846648459,
         0.018354195802514,
         -0.0494823984985229,
         0.0612127679420058,
         -0.0494823984985229,
         0.0183541958025139,
         0.021021846648459,
         -0.0534178590518696,
         0.0641736133483515,
         -0.0448709771566772,
         -0.000945704468709694,
         0.0535889927243468,
         -0.0773430328929719,
         0.0305712774436363,
         0.0972531871246499,
         -0.107304748337997,
         0.0337922320026913,
         0.03925560551516,
         -0.070509591376466,
         0.058233662455787,
         -0.0193024428218155,
         -0.0244630925949253,
         0.0548863075864182,
         -0.0619363663874541,
         0.044955554813108,
         -0.0113915028089643,
         -0.0261966463164168,
         0.0540923907148145,
         -0.0615718741102091,
         0.044485789762854,
         -0.00750947346129092,
         -0.0357024094220772,
         0.0652201182844462,
         -0.0611655364911248,
         0.0144248008796,
         0.0574896634233477,
         -0.0886642341380968,
         -0.0636671559392015,
         0.0970607968529039,
         -0.0767665080822726,
         0.0209035224035059,
         0.0333630199042509,
         -0.0640340422027165,
         0.0642539746567203,
         -0.0390972542659043,
         0.000852104370422054,
         0.0359238413137032,
         -0.0587348971139589,
         0.0603195526163659,
         -0.0403325391599837,
         0.00537984103304934,
         0.0325932830718715,
         -0.0594037787276904,
         0.0628882563602909,
         -0.0377620806301032,
         -0.0097889712476002,
         0.0591740796136169,
         -0.0765466435091584,
         0.0251339478980794,
         0.0997472634053587,
         -0.0748840305219659,
         0.0894058421249195,
         -0.0681109838281914,
         0.0259843170925811,
         0.0194018947606408,
         -0.0532005622565916,
         0.0664431177802291,
         -0.0571484127568662,
         0.0297846034501968,
         0.00648415707273519,
         -0.0403277657959635,
         0.0611167999906897,
         -0.0616849827805551,
         0.0405463557541952,
         -0.00312549255158234,
         -0.0384420775167773,
         0.0673850940812817,
         -0.066702401841244,
         0.0263871987472967,
         0.0458881007431256,
         -0.108833186885656,
         0.0496724464061765,
         -0.0773653307339559,
         0.0849161840973474,
         -0.0711820650465559,
         0.0409877704979118,
         -0.00293542977926456,
         -0.0331263663599828,
         0.0584192496183198,
         -0.0670552276183289,
         0.0571878077764819,
         -0.0313973304845419,
         -0.00372292700896703,
         0.0387539692642466,
         -0.0633246408948685,
         0.0685158885227245,
         -0.049555805925829,
         0.0084523652299908,
         0.0439546143037598,
         -0.0872890232592498,
         0.0931991731882385,
         -0.027913505118346,
         0.0530173189049296,
         -0.0731517440304967,
         0.0828102802526344,
         -0.0790246141715056,
         0.061831271035674,
         -0.0340838403086177,
         0.000816170239226693,
         0.0317003234667083,
         -0.0570700160803054,
         0.0699235234462515,
         -0.0669721319810554,
         0.0478332945704069,
         -0.0154944658484991,
         -0.0237170383347895,
         0.0607891730006563,
         -0.085431197327178,
         0.0883302810338055,
         -0.064144070139328,
         0.0126798984673061,
         -0.0282810032741122,
         0.0463570015979331,
         -0.0637954110707407,
         0.0772867665107773,
         -0.0839460239475726,
         0.0817940574607227,
         -0.0700895633394212,
         0.0494921141495442,
         -0.0220455398207977,
         -0.00901941784474372,
         0.0396542123374335,
         -0.0655137201250604,
         0.0825977920648365,
         -0.0879662801910231,
         0.0804596319350663,
         -0.0613195414428043,
         0.0344764017658803,
         -0.00406827535360748,
         0.0104083106366518,
         -0.0196698582234922,
         0.0315127253846155,
         -0.0451483068316209,
         0.0594405079912214,
         -0.0730369765671499,
         0.0845238761656053,
         -0.0925912672473507,
         0.0961953789267285,
         -0.0947038873698093,
         0.0880102523408282,
         -0.0766030921378042,
         0.0615763961337163,
         -0.0445657236262623,
         0.0275923859103813,
         -0.0127727927382561},
        {-0.0553636532358264,
         0.0875376219064817,
         -0.104854674424299,
         0.107985352009161,
         -0.0999750093710958,
         0.0848316084905884,
         -0.0664743801022164,
         0.0481106241656188,
         -0.0319556136852726,
         0.0192029339468617,
         -0.0101612375332391,
         0.00448483914073055,
         -0.00143629802343592,
         0.0998082452693907,
         -0.101709525543122,
         0.0645335910551979,
         -0.0129067182110398,
         -0.0353465035377451,
         0.0699825065597665,
         -0.087397288974532,
         0.0888301269073845,
         -0.0783835877599025,
         0.0612482595634392,
         -0.0423336507607622,
         0.0253832914963223,
         -0.0125676077050644,
         0.00448483914073058,
         -0.118094708404978,
         0.0446356042274655,
         0.0346804262855811,
         -0.0765750272560643,
         0.0755897464064127,
         -0.0438828419175333,
         -0.00102572195364263,
         0.0434208832582004,
         -0.0728721340569511,
         0.0851117172707747,
         -0.0812204308062677,
         0.0658808469689957,
         -0.0453152026394045,
         0.0253832914963222,
         -0.010161237533239,
         0.0998082452693906,
         0.0446356042274656,
         -0.0853015932974899,
         0.0480504482519298,
         0.0135366802605778,
         -0.059985005622658,
         0.073640359747871,
         -0.0550746786825793,
         0.015942908060139,
         0.0282397888463706,
         -0.0637690442636774,
         0.0822198450538304,
         -0.0816535426323343,
         0.0658808469689956,
         -0.0423336507607624,
         0.0192029339468616,
         -0.0553636532358266,
         -0.101709525543122,
         0.0346804262855809,
         0.0480504482519297,
         -0.0756117810217786,
         0.0488071947790717,
         0.00337606425694182,
         -0.0498241205545246,
         0.0703076318288135,
         -0.0592954986504607,
         0.0238793995538374,
         0.0214226390063779,
         -0.0607554063913404,
         0.0822198450538304,
         -0.0812204308062676,
         0.061248259563439,
         -0.0319556136852726,
         0.0875376219064817,
         0.0645335910551979,
         -0.0765750272560645,
         0.0135366802605777,
         0.0488071947790717,
         -0.0708169212934198,
         0.0489238190666793,
         -0.00200568103736572,
         -0.0439651505349614,
         0.067961715941765,
         -0.0607250090298495,
         0.0262124389277055,
         0.0214226390063779,
         -0.0637690442636774,
         0.0851117172707748,
         -0.0783835877599024,
         0.0481106241656187,
         -0.104854674424299,
         -0.0129067182110397,
         0.0755897464064126,
         -0.0599850056226581,
         0.00337606425694188,
         0.0489238190666794,
         -0.0681636535795333,
         0.048882689325011,
         -0.00470373897341651,
         -0.0412751419793319,
         0.0671469325956319,
         -0.0607250090298494,
         0.0238793995538374,
         0.0282397888463708,
         -0.0728721340569511,
         0.0888301269073845,
         -0.0664743801022165,
         0.107985352009161,
         -0.0353465035377451,
         -0.0438828419175333,
         0.0736403597478709,
         -0.0498241205545244,
         -0.00200568103736579,
         0.048882689325011,
         -0.0667864681094794,
         0.0488374066016976,
         -0.00552974739022926,
         -0.0412751419793317,
         0.0679617159417648,
         -0.059295498650461,
         0.0159429080601391,
         0.0434208832582003,
         -0.0873972889745318,
         0.0848316084905883,
         -0.0999750093710957,
         0.0699825065597663,
         -0.00102572195364264,
         -0.0550746786825793,
         0.0703076318288135,
         -0.0439651505349613,
         -0.00470373897341646,
         0.0488374066016976,
         -0.0663569686827396,
         0.0488374066016975,
         -0.00470373897341655,
         -0.0439651505349612,
         0.0703076318288137,
         -0.0550746786825792,
         -0.00102572195364266,
         0.0699825065597663,
         -0.0999750093710959,
         0.0848316084905884,
         -0.0873972889745317,
         0.0434208832582003,
         0.015942908060139,
         -0.059295498650461,
         0.0679617159417651,
         -0.0412751419793317,
         -0.00552974739022937,
         0.0488374066016975,
         -0.0667864681094796,
         0.0488826893250109,
         -0.00200568103736573,
         -0.0498241205545245,
         0.0736403597478709,
         -0.0438828419175333,
         -0.0353465035377451,
         0.107985352009161,
         -0.0664743801022162,
         0.0888301269073845,
         -0.072872134056951,
         0.0282397888463706,
         0.0238793995538375,
         -0.0607250090298495,
         0.067146932595632,
         -0.0412751419793317,
         -0.00470373897341647,
         0.048882689325011,
         -0.0681636535795332,
         0.0489238190666794,
         0.00337606425694183,
         -0.0599850056226581,
         0.0755897464064123,
         -0.0129067182110397,
         -0.104854674424299,
         0.0481106241656189,
         -0.0783835877599022,
         0.0851117172707747,
         -0.0637690442636775,
         0.0214226390063778,
         0.0262124389277056,
         -0.0607250090298495,
         0.0679617159417652,
         -0.0439651505349613,
         -0.00200568103736571,
         0.0489238190666795,
         -0.0708169212934198,
         0.0488071947790719,
         0.0135366802605777,
         -0.0765750272560644,
         0.0645335910551977,
         0.0875376219064815,
         -0.0319556136852726,
         0.0612482595634391,
         -0.0812204308062679,
         0.0822198450538304,
         -0.0607554063913403,
         0.0214226390063778,
         0.0238793995538374,
         -0.0592954986504608,
         0.0703076318288136,
         -0.0498241205545244,
         0.0033760642569419,
         0.0488071947790715,
         -0.0756117810217789,
         0.0480504482519296,
         0.0346804262855808,
         -0.101709525543121,
         -0.0553636532358267,
         0.0192029339468616,
         -0.0423336507607623,
         0.0658808469689954,
         -0.0816535426323343,
         0.0822198450538301,
         -0.0637690442636773,
         0.0282397888463707,
         0.0159429080601391,
         -0.0550746786825792,
         0.0736403597478711,
         -0.0599850056226582,
         0.0135366802605777,
         0.0480504482519297,
         -0.0853015932974897,
         0.0446356042274656,
         0.0998082452693906,
         -0.0101612375332392,
         0.0253832914963222,
         -0.0453152026394044,
         0.0658808469689955,
         -0.0812204308062677,
         0.0851117172707746,
         -0.0728721340569508,
         0.0434208832582003,
         -0.00102572195364266,
         -0.0438828419175333,
         0.0755897464064126,
         -0.0765750272560646,
         0.0346804262855811,
         0.0446356042274656,
         -0.118094708404978,
         0.0044848391407305,
         -0.0125676077050646,
         0.0253832914963223,
         -0.0423336507607623,
         0.0612482595634391,
         -0.0783835877599023,
         0.0888301269073844,
         -0.0873972889745321,
         0.0699825065597663,
         -0.0353465035377451,
         -0.0129067182110396,
         0.0645335910551978,
         -0.101709525543122,
         0.0998082452693905,
         -0.00143629802343592,
         0.00448483914073058,
         -0.0101612375332391,
         0.0192029339468616,
         -0.0319556136852727,
         0.0481106241656188,
         -0.0664743801022163,
         0.0848316084905886,
         -0.0999750093710958,
         0.107985352009161,
         -0.104854674424299,
         0.0875376219064816,
         -0.0553636532358267},
        {0.027073360521154,
         -0.0529018024234539,
         0.0765750272560646,
         -0.0937848719085361,
         0.102058045783879,
         -0.100917696631779,
         0.0915813174206373,
         -0.076426712130862,
         0.0583718655760455,
         -0.0402804140685907,
         0.0244761366298156,
         -0.0124221097446057,
         0.00458716802871717,
         -0.0597763614926783,
         0.0894669277875876,
         -0.0938736413291743,
         0.0741434513245291,
         -0.0376525191259934,
         -0.00537893130371346,
         0.04496553421327,
         -0.0735557792998116,
         0.0872096546458892,
         -0.0858029550762952,
         0.0724229333687234,
         -0.0521941690192786,
         0.0308143673857067,
         -0.0130754406428596,
         0.0913099004364139,
         -0.0930716686157348,
         0.0512219499425981,
         0.00577205985726423,
         -0.0527939664145748,
         0.0745326584676341,
         -0.0670941067416546,
         0.0362006942710087,
         0.00649021582057122,
         -0.0476604286652141,
         0.0761915996391507,
         -0.0858946447828221,
         0.076679013449318,
         -0.05401702811106,
         0.0267966793021219,
         -0.109136205317077,
         0.0540697533828715,
         0.0232679171539337,
         -0.0693848653302596,
         0.0686544445560932,
         -0.0318221867405804,
         -0.0179350436991581,
         0.057163939570394,
         -0.0703688928107192,
         0.053708832532517,
         -0.0145125637634421,
         -0.0324095326080787,
         0.0703016165038255,
         -0.0863025695931481,
         0.0760176926943137,
         -0.0452946550495677,
         0.104854674424299,
         0.0129067182110399,
         -0.0755897464064126,
         0.0599850056226581,
         -0.00337606425694204,
         -0.0489238190666796,
         0.0681636535795338,
         -0.0488826893250117,
         0.00470373897341647,
         0.0412751419793318,
         -0.0671469325956321,
         0.0607250090298488,
         -0.0238793995538369,
         -0.028239788846371,
         0.0728721340569509,
         -0.0888301269073846,
         0.0664743801022165,
         -0.0789317314153268,
         -0.0750367781444289,
         0.0647912112054964,
         0.0107985352009154,
         -0.0636615909502924,
         0.0620222607626593,
         -0.0187614281724227,
         -0.0332604572503527,
         0.0633696820246437,
         -0.0568030446496121,
         0.0186939581377032,
         0.0303578330010093,
         -0.0642770445955255,
         0.063389313261536,
         -0.0242554762261686,
         -0.036187870029854,
         0.0849555407823651,
         -0.086671987729345,
         0.0412207523559141,
         0.09942819573871,
         0.00460451088085329,
         -0.0720719953290748,
         0.0539745893038105,
         0.00691541600071404,
         -0.0559380417392316,
         0.0628459656442742,
         -0.0291514544147501,
         -0.0212261329367444,
         0.0581348167690025,
         -0.0606855036911384,
         0.0269440553065557,
         0.0249282451925507,
         -0.0644582336498145,
         0.0635671967263198,
         -0.0138348992951477,
         -0.0603506258437812,
         0.101211076403513,
         -0.0735281423349816,
         -0.0802257804665575,
         0.0554183334004984,
         0.025126540165225,
         -0.0681168476070268,
         0.0507002983850863,
         0.00191234183508826,
         -0.0495993790850663,
         0.0631789526770014,
         -0.0369923428609718,
         -0.0117894610486203,
         0.0538183963806026,
         -0.0630327469656858,
         0.0310134831636175,
         0.0255438501169855,
         -0.068950465426207,
         0.0587606930270816,
         0.0171077943696162,
         -0.105459527171978,
         0.0962709365598684,
         0.0351531757239928,
         -0.0774526592079891,
         0.034089564043106,
         0.0310840969484022,
         -0.0652248104767965,
         0.0511046297488749,
         -0.00423314910459175,
         -0.0435354701495324,
         0.0632688871747334,
         -0.0435354701495325,
         -0.0042331491045917,
         0.0511046297488748,
         -0.0652248104767963,
         0.0310840969484022,
         0.0340895640431059,
         -0.0774526592079889,
         0.0351531757239928,
         0.0962709365598687,
         -0.105459527171977,
         0.0171077943696161,
         0.0587606930270813,
         -0.068950465426207,
         0.0255438501169855,
         0.0310134831636174,
         -0.063032746965686,
         0.0538183963806025,
         -0.0117894610486204,
         -0.0369923428609718,
         0.0631789526770014,
         -0.0495993790850663,
         0.0019123418350882,
         0.0507002983850867,
         -0.0681168476070269,
         0.0251265401652252,
         0.0554183334004985,
         -0.0802257804665573,
         -0.0735281423349817,
         0.101211076403513,
         -0.0603506258437813,
         -0.0138348992951478,
         0.0635671967263198,
         -0.0644582336498144,
         0.0249282451925508,
         0.0269440553065557,
         -0.0606855036911384,
         0.0581348167690024,
         -0.0212261329367444,
         -0.02915145441475,
         0.062845965644274,
         -0.0559380417392316,
         0.00691541600071423,
         0.0539745893038106,
         -0.0720719953290747,
         0.00460451088085335,
         0.0994281957387099,
         0.0412207523559142,
         -0.0866719877293452,
         0.0849555407823651,
         -0.0361878700298542,
         -0.0242554762261687,
         0.0633893132615359,
         -0.0642770445955256,
         0.0303578330010088,
         0.0186939581377032,
         -0.0568030446496121,
         0.0633696820246435,
         -0.0332604572503522,
         -0.0187614281724227,
         0.062022260762659,
         -0.0636615909502926,
         0.0107985352009153,
         0.0647912112054963,
         -0.0750367781444289,
         -0.0789317314153267,
         0.0664743801022164,
         -0.0888301269073844,
         0.0728721340569508,
         -0.0282397888463711,
         -0.023879399553837,
         0.0607250090298488,
         -0.0671469325956321,
         0.0412751419793318,
         0.00470373897341647,
         -0.0488826893250115,
         0.0681636535795337,
         -0.0489238190666797,
         -0.00337606425694202,
         0.0599850056226583,
         -0.0755897464064126,
         0.0129067182110399,
         0.104854674424299,
         -0.0452946550495679,
         0.0760176926943137,
         -0.0863025695931483,
         0.0703016165038255,
         -0.0324095326080788,
         -0.0145125637634419,
         0.0537088325325168,
         -0.0703688928107193,
         0.057163939570394,
         -0.0179350436991581,
         -0.0318221867405804,
         0.0686544445560932,
         -0.0693848653302597,
         0.0232679171539336,
         0.0540697533828714,
         -0.109136205317077,
         0.0267966793021219,
         -0.05401702811106,
         0.0766790134493177,
         -0.0858946447828218,
         0.0761915996391506,
         -0.047660428665214,
         0.00649021582057131,
         0.0362006942710087,
         -0.0670941067416546,
         0.0745326584676342,
         -0.0527939664145748,
         0.00577205985726414,
         0.0512219499425982,
         -0.0930716686157346,
         0.0913099004364141,
         -0.0130754406428597,
         0.0308143673857066,
         -0.0521941690192789,
         0.0724229333687236,
         -0.0858029550762954,
         0.0872096546458893,
         -0.0735557792998119,
         0.0449655342132699,
         -0.00537893130371336,
         -0.0376525191259932,
         0.074143451324529,
         -0.0938736413291743,
         0.0894669277875875,
         -0.0597763614926786,
         0.0045871680287172,
         -0.0124221097446056,
         0.0244761366298154,
         -0.0402804140685907,
         0.0583718655760455,
         -0.076426712130862,
         0.0915813174206374,
         -0.100917696631779,
         0.102058045783879,
         -0.0937848719085363,
         0.0765750272560647,
         -0.0529018024234539,
         0.027073360521154},
        {0.020857883199369,
         -0.0421480656795851,
         0.063374624913595,
         -0.0810690925820788,
         0.0927709516143944,
         -0.0972989949063422,
         0.0947038873698094,
         -0.0860397625606065,
         0.07303697656715,
         -0.057740799841135,
         0.0421679180818405,
         -0.0280205241851772,
         0.016485830723229,
         -0.00813655070721484,
         0.00293220933970087,
         -0.0494688135598245,
         0.078765555219245,
         -0.0901087021531762,
         0.0819092092441382,
         -0.0574948606264749,
         0.023192737903599,
         0.0136693287165659,
         -0.0464029106793816,
         0.0700895633394216,
         -0.0821665986380439,
         0.0825040398880584,
         -0.0730567349812996,
         0.0572076537818962,
         -0.0389377231553942,
         0.0219646750162329,
         -0.0089780208766127,
         0.0807822342682958,
         -0.092179691571692,
         0.0653280842656619,
         -0.018853843840886,
         -0.0279714943590146,
         0.0605600617417998,
         -0.0713857410440317,
         0.0600295450124444,
         -0.0317003234667081,
         -0.00505126774824752,
         0.0408289111188011,
         -0.0676271046137496,
         0.0804662731419952,
         -0.0782130844206777,
         0.0635002305217949,
         -0.0417839830907357,
         0.0196698582234921,
         -0.102788770624136,
         0.0661544316414024,
         0.000838864239478831,
         -0.0530933653805256,
         0.0706790698041571,
         -0.0539511910380217,
         0.0157536699873946,
         0.0264950850909033,
         -0.0571878077764822,
         0.0666462256914573,
         -0.0528211931523679,
         0.0208145319181545,
         0.0192802096471973,
         -0.055558743889495,
         0.0777641609157799,
         -0.0802596601806573,
         0.0637954110707407,
         -0.0353953359398526,
         0.104746827911099,
         -0.00581926821728266,
         -0.0632613684065375,
         0.0689038771714922,
         -0.0295486523223624,
         -0.0217157286513037,
         0.0571790713900118,
         -0.0630579444105227,
         0.0403277657959634,
         -0.000881169116535345,
         -0.0384925384074748,
         0.0623261716369831,
         -0.0614166205455,
         0.0355178378349084,
         0.00668499453762889,
         -0.050287307234967,
         0.079024614171506,
         -0.0812196453314159,
         0.0550972140146521,
         -0.083359874678271,
         -0.060727068210742,
         0.0724421918547551,
         -0.0132142611342111,
         -0.0453386065539415,
         0.0659002664640821,
         -0.0453466792992653,
         0.00174076358300465,
         0.0403325391599861,
         -0.0612823975030553,
         0.053036410209406,
         -0.020388015801971,
         -0.0220063055905643,
         0.0555310352422318,
         -0.0646216547114807,
         0.0429650222081116,
         0.0029354297792645,
         -0.0543387217118477,
         0.0858880566259854,
         -0.0759462684082314,
         0.0458881007431255,
         0.0963468002759714,
         -0.0148286106201949,
         -0.0590292088758083,
         0.064823860081614,
         -0.0211469649968773,
         -0.0313530127585501,
         0.0604702751602432,
         -0.0540923907148165,
         0.0195401264194463,
         0.023916979189255,
         -0.0549340173468143,
         0.0589691204232358,
         -0.0338342237917025,
         -0.00936322252797377,
         0.0501178773855111,
         -0.0664431177802283,
         0.0449374690956471,
         0.00990900036169249,
         -0.0710719761719195,
         0.093483394126858,
         -0.0783688515097004,
         -0.0671773575303357,
         0.0662446524975682,
         0.000772164465268877,
         -0.0548722756260563,
         0.0625377786612037,
         -0.0294849137742754,
         -0.0183541958025123,
         0.0533121846345118,
         -0.0585853362886316,
         0.0333888221491057,
         0.00876109513073908,
         -0.046790970157889,
         0.0612629781596949,
         -0.043121977020942,
         -0.000852104370423157,
         0.0483218237945886,
         -0.0689931161390374,
         0.039719587685851,
         0.0349782832175453,
         -0.102405927430852,
         0.0980462109172262,
         0.0161917988291708,
         -0.0722211166249701,
         0.0524162620400651,
         0.00312549255158317,
         -0.0497645691869744,
         0.0619363663874538,
         -0.0381165191385462,
         -0.00519742021630186,
         0.0444110178746729,
         -0.059976018880522,
         0.0444110178746728,
         -0.00519742021630202,
         -0.0381165191385461,
         0.0619363663874538,
         -0.0497645691869745,
         0.00312549255158312,
         0.052416262040065,
         -0.07222111662497,
         0.0161917988291709,
         0.0980462109172262,
         -0.102405927430852,
         0.0349782832175453,
         0.0397195876858509,
         -0.0689931161390372,
         0.0483218237945886,
         -0.000852104370423152,
         -0.0431219770209419,
         0.0612629781596949,
         -0.046790970157889,
         0.008761095130739,
         0.0333888221491058,
         -0.0585853362886315,
         0.0533121846345116,
         -0.0183541958025124,
         -0.0294849137742755,
         0.0625377786612038,
         -0.0548722756260564,
         0.000772164465268865,
         0.0662446524975681,
         -0.0671773575303358,
         -0.0783688515097003,
         0.0934833941268582,
         -0.0710719761719196,
         0.00990900036169243,
         0.044937469095647,
         -0.0664431177802283,
         0.050117877385511,
         -0.009363222527974,
         -0.0338342237917025,
         0.0589691204232357,
         -0.0549340173468146,
         0.0239169791892551,
         0.0195401264194462,
         -0.0540923907148166,
         0.0604702751602436,
         -0.0313530127585499,
         -0.0211469649968771,
         0.064823860081614,
         -0.0590292088758085,
         -0.0148286106201949,
         0.0963468002759716,
         0.0458881007431254,
         -0.0759462684082312,
         0.0858880566259856,
         -0.0543387217118476,
         0.00293542977926456,
         0.0429650222081116,
         -0.0646216547114809,
         0.0555310352422319,
         -0.022006305590564,
         -0.0203880158019711,
         0.0530364102094061,
         -0.0612823975030554,
         0.0403325391599861,
         0.00174076358300468,
         -0.0453466792992653,
         0.0659002664640822,
         -0.0453386065539416,
         -0.0132142611342112,
         0.072442191854755,
         -0.0607270682107418,
         -0.083359874678271,
         0.055097214014652,
         -0.0812196453314158,
         0.0790246141715061,
         -0.0502873072349668,
         0.00668499453762884,
         0.0355178378349084,
         -0.0614166205454998,
         0.062326171636983,
         -0.0384925384074749,
         -0.0008811691165354,
         0.0403277657959635,
         -0.0630579444105228,
         0.0571790713900118,
         -0.0217157286513038,
         -0.0295486523223623,
         0.0689038771714921,
         -0.0632613684065375,
         -0.00581926821728261,
         0.104746827911099,
         -0.0353953359398526,
         0.0637954110707408,
         -0.0802596601806574,
         0.0777641609157799,
         -0.0555587438894949,
         0.0192802096471971,
         0.0208145319181546,
         -0.052821193152368,
         0.066646225691457,
         -0.057187807776482,
         0.0264950850909031,
         0.0157536699873946,
         -0.0539511910380218,
         0.0706790698041571,
         -0.0530933653805257,
         0.000838864239478812,
         0.0661544316414024,
         -0.102788770624136,
         0.0196698582234922,
         -0.0417839830907358,
         0.0635002305217949,
         -0.0782130844206776,
         0.0804662731419955,
         -0.0676271046137495,
         0.040828911118801,
         -0.00505126774824761,
         -0.0317003234667083,
         0.0600295450124445,
         -0.0713857410440318,
         0.0605600617417997,
         -0.0279714943590147,
         -0.0188538438408859,
         0.0653280842656618,
         -0.0921796915716921,
         0.080782234268296,
         -0.00897802087661269,
         0.0219646750162329,
         -0.0389377231553942,
         0.0572076537818959,
         -0.0730567349812999,
         0.0825040398880581,
         -0.082166598638044,
         0.0700895633394215,
         -0.0464029106793815,
         0.0136693287165659,
         0.0231927379035988,
         -0.0574948606264749,
         0.0819092092441383,
         -0.0901087021531761,
         0.0787655552192449,
         -0.0494688135598244,
         0.00293220933970081,
         -0.00813655070721483,
         0.0164858307232288,
         -0.0280205241851772,
         0.0421679180818403,
         -0.057740799841135,
         0.0730369765671498,
         -0.0860397625606065,
         0.0947038873698094,
         -0.097298994906342,
         0.0927709516143942,
         -0.081069092582079,
         0.063374624913595,
         -0.042148065679585,
         0.0208578831993691},
        {-0.0084221301223375,
         0.0201556068789529,
         -0.035460341202954,
         0.0525961857562485,
         -0.0693161479445301,
         0.083307641877217,
         -0.0925912672473508,
         0.0958410669348908,
         -0.0925912672473505,
         0.0833076418772172,
         -0.0693161479445302,
         0.0525961857562487,
         -0.0354603412029541,
         0.0201556068789531,
         -0.00842213012233741,
         0.0230649532512402,
         -0.0466857085583856,
         0.0684217085627119,
         -0.0824023865579236,
         0.0844647478784352,
         -0.0730656353779714,
         0.0494921141495444,
         -0.0174981047652005,
         -0.0174981047652005,
         0.0494921141495444,
         -0.0730656353779714,
         0.0844647478784352,
         -0.0824023865579237,
         0.0684217085627116,
         -0.0466857085583855,
         0.0230649532512401,
         -0.044565723626262,
         0.0736197711882229,
         -0.0849835004805988,
         0.0747713381623696,
         -0.0460194155497993,
         0.00696653498923561,
         0.0317003234667088,
         -0.059767406008872,
         0.069992419060802,
         -0.0597674060088718,
         0.0317003234667086,
         0.00696653498923573,
         -0.0460194155497993,
         0.0747713381623695,
         -0.0849835004805987,
         0.0736197711882231,
         -0.0445657236262622,
         0.0694506641741878,
         -0.0879662801910232,
         0.0700285628375793,
         -0.0279330455513429,
         -0.0196180271499398,
         0.0550151799653195,
         -0.0670552276183299,
         0.0533841118075456,
         -0.0202050709929932,
         -0.0202050709929933,
         0.0533841118075457,
         -0.0670552276183299,
         0.0550151799653196,
         -0.0196180271499397,
         -0.0279330455513428,
         0.0700285628375793,
         -0.0879662801910231,
         0.0694506641741878,
         -0.0913683929402563,
         0.0780273734081564,
         -0.0237170383347897,
         -0.0327894008748134,
         0.0643072887690511,
         -0.0611774152349801,
         0.0297846034501975,
         0.0133556658836947,
         -0.0491492650948157,
         0.0629033792799113,
         -0.0491492650948154,
         0.0133556658836945,
         0.0297846034501975,
         -0.0611774152349803,
         0.0643072887690514,
         -0.0327894008748136,
         -0.0237170383347896,
         0.0780273734081564,
         -0.0913683929402562,
         0.102831733539544,
         -0.0402373159620191,
         -0.034359149634764,
         0.0685158885227253,
         -0.0540409867965168,
         0.00989447513982303,
         0.0359238413137011,
         -0.0605031691758679,
         0.0540123772603637,
         -0.0213672155186196,
         -0.0213672155186196,
         0.0540123772603635,
         -0.0605031691758681,
         0.0359238413137012,
         0.0098944751398232,
         -0.0540409867965169,
         0.0685158885227254,
         -0.0343591496347638,
         -0.0402373159620192,
         0.102831733539544,
         -0.0980462109172261,
         -0.0161917988291708,
         0.0722211166249701,
         -0.0524162620400649,
         -0.00312549255158292,
         0.0497645691869741,
         -0.0619363663874532,
         0.0381165191385453,
         0.0051974202163034,
         -0.0444110178746729,
         0.0599760188805206,
         -0.044411017874673,
         0.00519742021630335,
         0.0381165191385453,
         -0.061936366387453,
         0.0497645691869741,
         -0.00312549255158297,
         -0.0524162620400648,
         0.07222111662497,
         -0.0161917988291709,
         -0.0980462109172263,
         0.0759462684082312,
         0.0699565664350918,
         -0.0627105672105166,
         -0.00742930682215633,
         0.0583893445877687,
         -0.0594037787276899,
         0.0210218466484583,
         0.0272053183959456,
         -0.0569891281809884,
         0.0540127216778458,
         -0.0218378406832362,
         -0.0218378406832364,
         0.0540127216778458,
         -0.0569891281809883,
         0.0272053183959453,
         0.0210218466484582,
         -0.0594037787276897,
         0.0583893445877687,
         -0.00742930682215618,
         -0.0627105672105168,
         0.0699565664350917,
         0.0759462684082313,
         -0.0419808794229543,
         -0.0954110895976233,
         0.00381644358390433,
         0.0648795409263822,
         -0.0576483846621441,
         0.00542336719817842,
         0.0444857897628545,
         -0.061340764290534,
         0.0402676152753824,
         0.00281211632498385,
         -0.043008837911498,
         0.0591371521283083,
         -0.0430088379114983,
         0.00281211632498396,
         0.0402676152753823,
         -0.0613407642905343,
         0.044485789762854,
         0.00542336719817833,
         -0.0576483846621439,
         0.0648795409263821,
         0.00381644358390439,
         -0.0954110895976232,
         -0.0419808794229542,
         0.0759462684082314,
         0.0699565664350918,
         -0.0627105672105167,
         -0.00742930682215628,
         0.0583893445877687,
         -0.0594037787276897,
         0.0210218466484581,
         0.0272053183959455,
         -0.0569891281809884,
         0.0540127216778466,
         -0.0218378406832362,
         -0.0218378406832363,
         0.054012721677846,
         -0.0569891281809883,
         0.0272053183959453,
         0.0210218466484581,
         -0.0594037787276896,
         0.0583893445877687,
         -0.0074293068221562,
         -0.0627105672105167,
         0.0699565664350917,
         0.0759462684082313,
         -0.0980462109172261,
         -0.0161917988291709,
         0.0722211166249697,
         -0.0524162620400649,
         -0.00312549255158288,
         0.049764569186974,
         -0.0619363663874531,
         0.0381165191385453,
         0.00519742021630344,
         -0.0444110178746729,
         0.0599760188805204,
         -0.0444110178746726,
         0.00519742021630338,
         0.0381165191385452,
         -0.061936366387453,
         0.0497645691869741,
         -0.00312549255158282,
         -0.0524162620400651,
         0.0722211166249701,
         -0.0161917988291709,
         -0.0980462109172261,
         0.102831733539544,
         -0.040237315962019,
         -0.0343591496347637,
         0.0685158885227254,
         -0.0540409867965169,
         0.0098944751398231,
         0.0359238413137013,
         -0.060503169175868,
         0.0540123772603636,
         -0.0213672155186196,
         -0.0213672155186195,
         0.0540123772603633,
         -0.0605031691758681,
         0.0359238413137013,
         0.00989447513982297,
         -0.0540409867965168,
         0.0685158885227256,
         -0.0343591496347639,
         -0.0402373159620191,
         0.102831733539544,
         -0.0913683929402561,
         0.0780273734081564,
         -0.0237170383347897,
         -0.0327894008748135,
         0.0643072887690513,
         -0.0611774152349803,
         0.0297846034501974,
         0.0133556658836946,
         -0.0491492650948156,
         0.0629033792799111,
         -0.0491492650948156,
         0.0133556658836946,
         0.0297846034501975,
         -0.0611774152349801,
         0.0643072887690513,
         -0.0327894008748136,
         -0.0237170383347898,
         0.0780273734081565,
         -0.0913683929402561,
         0.0694506641741879,
         -0.0879662801910232,
         0.070028562837579,
         -0.0279330455513428,
         -0.0196180271499398,
         0.0550151799653197,
         -0.0670552276183297,
         0.0533841118075457,
         -0.0202050709929932,
         -0.0202050709929932,
         0.0533841118075458,
         -0.0670552276183298,
         0.0550151799653196,
         -0.0196180271499399,
         -0.0279330455513428,
         0.0700285628375792,
         -0.0879662801910229,
         0.0694506641741878,
         -0.044565723626262,
         0.0736197711882231,
         -0.084983500480599,
         0.0747713381623697,
         -0.0460194155497995,
         0.00696653498923573,
         0.0317003234667088,
         -0.0597674060088719,
         0.0699924190608023,
         -0.0597674060088717,
         0.0317003234667087,
         0.00696653498923577,
         -0.0460194155497995,
         0.0747713381623697,
         -0.0849835004805991,
         0.073619771188223,
         -0.0445657236262621,
         0.0230649532512401,
         -0.0466857085583854,
         0.068421708562712,
         -0.0824023865579236,
         0.0844647478784354,
         -0.0730656353779715,
         0.0494921141495442,
         -0.0174981047652005,
         -0.0174981047652004,
         0.0494921141495443,
         -0.0730656353779714,
         0.0844647478784352,
         -0.0824023865579237,
         0.0684217085627118,
         -0.0466857085583855,
         0.0230649532512402,
         -0.00842213012233746,
         0.0201556068789529,
         -0.0354603412029543,
         0.0525961857562487,
         -0.0693161479445302,
         0.0833076418772174,
         -0.0925912672473504,
         0.0958410669348906,
         -0.0925912672473505,
         0.0833076418772173,
         -0.0693161479445301,
         0.0525961857562486,
         -0.0354603412029543,
         0.020155606878953,
         -0.00842213012233745},
        {0.00608919001805738,
         -0.0149154084910895,
         0.026934062629838,
         -0.0411424602579711,
         0.056067722404025,
         -0.0700285628375786,
         0.0813922676408948,
         -0.0888062446305966,
         0.091380871835801,
         -0.0888062446305966,
         0.0813922676408947,
         -0.0700285628375785,
         0.0560677224040248,
         -0.0411424602579711,
         0.026934062629838,
         -0.0149154084910896,
         0.0060891900180574,
         -0.0177528870369325,
         0.0372885212277235,
         -0.0571780821241656,
         0.0729377863992239,
         -0.0808021878895139,
         0.0784948113656346,
         -0.0655877583591329,
         0.0435059970635478,
         -0.0152301453059669,
         -0.0152301453059668,
         0.0435059970635477,
         -0.065587758359133,
         0.0784948113656346,
         -0.080802187889514,
         0.072937786399224,
         -0.0571780821241655,
         0.0372885212277236,
         -0.0177528870369326,
         0.0363825918842179,
         -0.0635146595383297,
         0.0790973320350616,
         -0.0782850472881714,
         0.061024130304112,
         -0.0314717731575871,
         -0.00345145616623492,
         0.0358439749736371,
         -0.0585757011635069,
         0.0667351531052759,
         -0.0585757011635068,
         0.035843974973637,
         -0.00345145616623476,
         -0.0314717731575871,
         0.0610241303041118,
         -0.0782850472881714,
         0.0790973320350616,
         -0.0635146595383297,
         0.0363825918842178,
         -0.0599406454658724,
         0.0825079630093699,
         -0.0758629482861548,
         0.0458019874755834,
         -0.00461299065024872,
         -0.033898419844012,
         0.0585018404649755,
         -0.0631021396446118,
         0.0476637412012891,
         -0.017656461882238,
         -0.017656461882238,
         0.0476637412012891,
         -0.0631021396446119,
         0.0585018404649754,
         -0.0338984198440121,
         -0.00461299065024884,
         0.0458019874755835,
         -0.0758629482861547,
         0.08250796300937,
         -0.0599406454658723,
         0.0831227195044657,
         -0.081443299527373,
         0.040488018175446,
         0.0113956407454205,
         -0.0505368296728344,
         0.0639706704719446,
         -0.0504850213950436,
         0.0182307684678057,
         0.0194937103819899,
         -0.0489320408664307,
         0.0599760188805216,
         -0.0489320408664308,
         0.0194937103819899,
         0.0182307684678058,
         -0.0504850213950434,
         0.0639706704719449,
         -0.050536829672834,
         0.0113956407454204,
         0.0404880181754461,
         -0.0814432995273731,
         0.0831227195044658,
         -0.0983521280753255,
         0.052571423788283,
         0.015502467122385,
         -0.0589780440378921,
         0.0626019826987646,
         -0.0338601699890876,
         -0.00835365638358303,
         0.0439525608862892,
         -0.0588799113949259,
         0.0487010188569916,
         -0.0187181491570596,
         -0.0187181491570597,
         0.0487010188569915,
         -0.0588799113949262,
         0.0439525608862892,
         -0.00835365638358299,
         -0.0338601699890873,
         0.0626019826987645,
         -0.0589780440378921,
         0.0155024671223849,
         0.052571423788283,
         -0.0983521280753257,
         0.0983521280753259,
         -0.0629713191344316,
         0.0620098684895416,
         -0.0199608621487925,
         -0.0284520789734871,
         0.0568401499603981,
         -0.0547187436612576,
         0.0268474787397616,
         0.0120978510046523,
         -0.0446420369603871,
         0.057184890254465,
         -0.0446420369603871,
         0.0120978510046523,
         0.0268474787397615,
         -0.0547187436612578,
         0.056840149960398,
         -0.028452078973487,
         -0.0199608621487925,
         0.0620098684895415,
         -0.0629713191344317,
         0.0983521280753262,
         -0.0797285117005995,
         -0.0575891093780124,
         0.0689816239315694,
         -0.0129702945539586,
         -0.0424552546995646,
         0.0620302631187659,
         -0.0429181836359914,
         0.00222262597128635,
         0.0369698079623231,
         -0.0564506624774742,
         0.0489339803757607,
         -0.0191530532955789,
         -0.019153053295579,
         0.0489339803757607,
         -0.0564506624774745,
         0.036969807962323,
         0.00222262597128624,
         -0.0429181836359915,
         0.062030263118766,
         -0.0424552546995646,
         -0.0129702945539587,
         0.0689816239315695,
         -0.0575891093780128,
         -0.0797285117005994,
         0.0460312776924294,
         0.092062555384859,
         -0.0200135989967085,
         -0.0520353573914414,
         0.0640435167894681,
         -0.0280190385953892,
         -0.0212776157754465,
         0.0537207130964309,
         -0.0553379110339305,
         0.0291963091246108,
         0.00991385708815167,
         -0.0433731247606697,
         0.0563850621888675,
         -0.0433731247606692,
         0.00991385708815183,
         0.0291963091246111,
         -0.0553379110339305,
         0.0537207130964306,
         -0.0212776157754466,
         -0.0280190385953891,
         0.0640435167894682,
         -0.0520353573914414,
         -0.0200135989967085,
         0.0920625553848588,
         0.0460312776924294,
         -0.0797285117005993,
         -0.0575891093780125,
         0.0689816239315694,
         -0.0129702945539587,
         -0.0424552546995646,
         0.0620302631187658,
         -0.0429181836359914,
         0.00222262597128625,
         0.036969807962323,
         -0.056450662477474,
         0.0489339803757608,
         -0.0191530532955788,
         -0.0191530532955788,
         0.0489339803757609,
         -0.0564506624774743,
         0.0369698079623231,
         0.00222262597128625,
         -0.0429181836359915,
         0.0620302631187658,
         -0.0424552546995646,
         -0.0129702945539586,
         0.0689816239315695,
         -0.0575891093780126,
         -0.0797285117005993,
         0.0983521280753261,
         -0.0629713191344316,
         0.0620098684895415,
         -0.0199608621487924,
         -0.0284520789734872,
         0.0568401499603979,
         -0.0547187436612577,
         0.0268474787397616,
         0.0120978510046523,
         -0.0446420369603871,
         0.057184890254465,
         -0.0446420369603875,
         0.0120978510046522,
         0.0268474787397616,
         -0.0547187436612576,
         0.056840149960398,
         -0.028452078973487,
         -0.0199608621487926,
         0.0620098684895416,
         -0.0629713191344315,
         0.0983521280753261,
         -0.0983521280753257,
         0.0525714237882831,
         0.0155024671223848,
         -0.0589780440378921,
         0.0626019826987644,
         -0.0338601699890875,
         -0.00835365638358301,
         0.0439525608862891,
         -0.0588799113949259,
         0.0487010188569916,
         -0.0187181491570597,
         -0.0187181491570595,
         0.0487010188569916,
         -0.0588799113949262,
         0.0439525608862889,
         -0.00835365638358297,
         -0.0338601699890873,
         0.0626019826987644,
         -0.0589780440378922,
         0.015502467122385,
         0.0525714237882832,
         -0.0983521280753257,
         0.0831227195044657,
         -0.0814432995273728,
         0.040488018175446,
         0.0113956407454204,
         -0.050536829672834,
         0.0639706704719445,
         -0.0504850213950435,
         0.0182307684678056,
         0.0194937103819899,
         -0.0489320408664307,
         0.0599760188805216,
         -0.0489320408664306,
         0.0194937103819899,
         0.0182307684678057,
         -0.0504850213950436,
         0.0639706704719445,
         -0.050536829672834,
         0.0113956407454204,
         0.0404880181754461,
         -0.081443299527373,
         0.0831227195044659,
         -0.0599406454658723,
         0.0825079630093697,
         -0.0758629482861548,
         0.0458019874755834,
         -0.00461299065024868,
         -0.0338984198440122,
         0.0585018404649755,
         -0.0631021396446118,
         0.0476637412012891,
         -0.0176564618822381,
         -0.017656461882238,
         0.0476637412012892,
         -0.0631021396446119,
         0.0585018404649755,
         -0.033898419844012,
         -0.00461299065024884,
         0.0458019874755834,
         -0.0758629482861548,
         0.0825079630093697,
         -0.0599406454658723,
         0.036382591884218,
         -0.0635146595383298,
         0.0790973320350615,
         -0.0782850472881714,
         0.0610241303041122,
         -0.0314717731575871,
         -0.00345145616623475,
         0.0358439749736371,
         -0.0585757011635067,
         0.0667351531052759,
         -0.0585757011635066,
         0.035843974973637,
         -0.00345145616623479,
         -0.0314717731575872,
         0.0610241303041121,
         -0.0782850472881713,
         0.0790973320350615,
         -0.0635146595383297,
         0.0363825918842179,
         -0.0177528870369326,
         0.0372885212277235,
         -0.0571780821241653,
         0.072937786399224,
         -0.0808021878895139,
         0.0784948113656346,
         -0.0655877583591329,
         0.0435059970635478,
         -0.0152301453059669,
         -0.0152301453059669,
         0.0435059970635478,
         -0.0655877583591331,
         0.0784948113656345,
         -0.0808021878895139,
         0.072937786399224,
         -0.0571780821241655,
         0.0372885212277235,
         -0.0177528870369327,
         0.00608919001805753,
         -0.0149154084910895,
         0.026934062629838,
         -0.0411424602579709,
         0.0560677224040247,
         -0.0700285628375784,
         0.0813922676408945,
         -0.0888062446305965,
         0.0913808718358008,
         -0.0888062446305967,
         0.0813922676408948,
         -0.0700285628375784,
         0.0560677224040249,
         -0.041142460257971,
         0.0269340626298379,
         -0.0149154084910895,
         0.00608919001805744},
        {0.0317573297691648,
         -0.0594125237575059,
         0.0821751340487505,
         -0.0959598826399256,
         0.0993279151325206,
         -0.0931778437055957,
         0.0799834021619949,
         -0.0629306042884492,
         0.0451483068316209,
         -0.0291431067447217,
         0.0164858307232289,
         -0.00774622191009548,
         0.00263126075105672,
         -0.0661081536143041,
         0.0916755144548551,
         -0.0867185730526392,
         0.057219418852207,
         -0.0148069313533099,
         -0.0280941769405304,
         0.0617085344748052,
         -0.0806156918603825,
         0.0839460239475723,
         -0.0744909058127032,
         0.0572076537818958,
         -0.0375746954527037,
         0.0201729990914345,
         -0.00774622191009553,
         0.0948559524319825,
         -0.0833129378081768,
         0.0296718722875937,
         0.0287670509026992,
         -0.0658475251459392,
         0.071102297767056,
         -0.0478332945704065,
         0.00791953691296063,
         0.034083840308618,
         -0.065875462867804,
         0.0804662731419952,
         -0.0771063104587753,
         0.0603126238820641,
         -0.0375746954527037,
         0.0164858307232289,
         -0.1060521788542,
         0.0335366436002819,
         0.0437344208169758,
         -0.0728485856709372,
         0.0511027392020009,
         -0.00231811502246747,
         -0.0440775639096248,
         0.0667756910440381,
         -0.0584192496183201,
         0.024940124525883,
         0.0192802096471968,
         -0.0579222726693445,
         0.0786927541284158,
         -0.0771063104587754,
         0.0572076537818959,
         -0.0291431067447217,
         0.0948559524319825,
         0.0335366436002818,
         -0.076603092137804,
         0.037191119612791,
         0.0257300325322534,
         -0.0631659759175323,
         0.0571790713900133,
         -0.0179087266729531,
         -0.0297846034501977,
         0.0609931590487639,
         -0.0614166205455005,
         0.0316747285496002,
         0.0147041041970812,
         -0.0579222726693446,
         0.0804662731419951,
         -0.0744909058127033,
         0.0451483068316208,
         -0.0661081536143042,
         -0.0833129378081769,
         0.0437344208169759,
         0.0371911196127909,
         -0.0679013838359955,
         0.0384415887520674,
         0.0164990352353367,
         -0.0564071869934039,
         0.0587348971139618,
         -0.0256676906598168,
         -0.0220063055905631,
         0.0576598109212697,
         -0.0619894076940105,
         0.0316747285496002,
         0.0192802096471969,
         -0.0658754628678041,
         0.0839460239475723,
         -0.0629306042884494,
         0.0317573297691647,
         0.0916755144548553,
         0.0296718722875939,
         -0.0728485856709373,
         0.0257300325322534,
         0.0384415887520674,
         -0.0635954726875557,
         0.0389441145089035,
         0.0113915028089621,
         -0.052233487530372,
         0.0589691204232352,
         -0.0289149388824488,
         -0.0195538789147166,
         0.0576598109212687,
         -0.0614166205455,
         0.0249401245258821,
         0.0340838403086179,
         -0.0806156918603826,
         0.0799834021619949,
         -0.0594125237575057,
         -0.0867185730526392,
         0.0287670509026992,
         0.0511027392020011,
         -0.0631659759175325,
         0.0164990352353367,
         0.0389441145089036,
         -0.0612127679420029,
         0.0391518179260357,
         0.00876109513074241,
         -0.0502491830187658,
         0.0589582984954925,
         -0.0289149388824488,
         -0.0220063055905625,
         0.0609931590487627,
         -0.0584192496183194,
         0.00791953691296064,
         0.0617085344748053,
         -0.0931778437055956,
         0.0821751340487506,
         0.0572194188522072,
         -0.0658475251459394,
         -0.00231811502246741,
         0.0571790713900133,
         -0.0564071869934038,
         0.0113915028089618,
         0.0391518179260357,
         -0.0599760188805236,
         0.0392271489559563,
         0.0079453756012288,
         -0.0502491830187659,
         0.058969120423235,
         -0.0256676906598178,
         -0.0297846034501969,
         0.0667756910440373,
         -0.0478332945704066,
         -0.0280941769405305,
         0.0993279151325205,
         -0.0959598826399257,
         -0.01480693135331,
         0.0711022977670561,
         -0.0440775639096245,
         -0.017908726672953,
         0.0587348971139616,
         -0.0522334875303714,
         0.00876109513074189,
         0.0392271489559565,
         -0.0595903170092213,
         0.0392271489559566,
         0.00876109513074196,
         -0.0522334875303714,
         0.0587348971139618,
         -0.017908726672953,
         -0.0440775639096248,
         0.071102297767056,
         -0.01480693135331,
         -0.0959598826399259,
         0.0993279151325204,
         -0.0280941769405304,
         -0.0478332945704065,
         0.0667756910440374,
         -0.0297846034501969,
         -0.0256676906598179,
         0.058969120423235,
         -0.0502491830187659,
         0.00794537560122868,
         0.0392271489559563,
         -0.0599760188805236,
         0.0391518179260358,
         0.0113915028089618,
         -0.0564071869934038,
         0.0571790713900132,
         -0.00231811502246735,
         -0.0658475251459393,
         0.0572194188522071,
         0.0821751340487506,
         -0.0931778437055957,
         0.0617085344748055,
         0.00791953691296067,
         -0.0584192496183195,
         0.0609931590487627,
         -0.0220063055905625,
         -0.0289149388824489,
         0.0589582984954924,
         -0.0502491830187658,
         0.0087610951307423,
         0.0391518179260358,
         -0.061212767942003,
         0.0389441145089037,
         0.0164990352353367,
         -0.0631659759175323,
         0.0511027392020009,
         0.0287670509026993,
         -0.0867185730526393,
         -0.0594125237575057,
         0.0799834021619951,
         -0.0806156918603824,
         0.034083840308618,
         0.0249401245258822,
         -0.0614166205454999,
         0.0576598109212685,
         -0.0195538789147162,
         -0.0289149388824488,
         0.0589691204232352,
         -0.052233487530372,
         0.0113915028089621,
         0.0389441145089036,
         -0.0635954726875556,
         0.0384415887520674,
         0.0257300325322535,
         -0.0728485856709374,
         0.0296718722875937,
         0.0916755144548552,
         0.0317573297691649,
         -0.0629306042884493,
         0.0839460239475724,
         -0.0658754628678038,
         0.0192802096471967,
         0.0316747285496004,
         -0.0619894076940106,
         0.0576598109212695,
         -0.0220063055905634,
         -0.0256676906598169,
         0.0587348971139619,
         -0.0564071869934036,
         0.0164990352353367,
         0.0384415887520674,
         -0.0679013838359957,
         0.0371911196127909,
         0.0437344208169759,
         -0.0833129378081768,
         -0.0661081536143042,
         0.0451483068316208,
         -0.0744909058127033,
         0.0804662731419953,
         -0.0579222726693446,
         0.0147041041970811,
         0.0316747285496004,
         -0.0614166205455006,
         0.0609931590487638,
         -0.0297846034501977,
         -0.017908726672953,
         0.0571790713900131,
         -0.0631659759175323,
         0.0257300325322533,
         0.0371911196127909,
         -0.0766030921378041,
         0.0335366436002816,
         0.0948559524319825,
         -0.0291431067447219,
         0.0572076537818957,
         -0.0771063104587753,
         0.0786927541284158,
         -0.0579222726693447,
         0.0192802096471969,
         0.0249401245258828,
         -0.0584192496183203,
         0.066775691044038,
         -0.0440775639096247,
         -0.0023181150224674,
         0.0511027392020009,
         -0.0728485856709375,
         0.0437344208169758,
         0.0335366436002818,
         -0.106052178854199,
         0.016485830723229,
         -0.0375746954527036,
         0.0603126238820641,
         -0.0771063104587753,
         0.0804662731419953,
         -0.065875462867804,
         0.034083840308618,
         0.00791953691296069,
         -0.0478332945704064,
         0.071102297767056,
         -0.0658475251459393,
         0.0287670509026992,
         0.0296718722875938,
         -0.0833129378081768,
         0.0948559524319827,
         -0.00774622191009554,
         0.0201729990914345,
         -0.0375746954527037,
         0.0572076537818957,
         -0.0744909058127032,
         0.0839460239475724,
         -0.0806156918603825,
         0.0617085344748054,
         -0.0280941769405305,
         -0.0148069313533098,
         0.0572194188522073,
         -0.0867185730526392,
         0.0916755144548552,
         -0.0661081536143041,
         0.00263126075105671,
         -0.0077462219100956,
         0.016485830723229,
         -0.0291431067447217,
         0.0451483068316209,
         -0.0629306042884492,
         0.0799834021619948,
         -0.0931778437055957,
         0.0993279151325206,
         -0.0959598826399256,
         0.0821751340487506,
         -0.0594125237575059,
         0.0317573297691648},
        {0.0155296406175992,
         -0.034408199123883,
         0.0556844122765084,
         -0.0753970506456558,
         0.0898792498866984,
         -0.09661729050804,
         0.0947038873698091,
         -0.0848945966996838,
         0.0693161479445298,
         -0.0509217832265956,
         0.0328192617430588,
         -0.0176089572961608,
         0.00685427733142321,
         -0.0373286103575219,
         0.0671138671357127,
         -0.0850961590225152,
         0.0847211352923922,
         -0.0652320890923007,
         0.0312629508354099,
         0.00901941784474404,
         -0.0464029106793811,
         0.0730656353779712,
         -0.0844191331708488,
         0.0800035516527196,
         -0.0632897591524415,
         0.0404602390859488,
         -0.0184203168414182,
         0.0633746249135948,
         -0.087351626833414,
         0.0770710620952073,
         -0.0393436190030623,
         -0.0093332637583541,
         0.0504123210138646,
         -0.0699235234462524,
         0.0624105359684418,
         -0.0317003234667094,
         -0.0111631930225662,
         0.051929775477305,
         -0.0778754463107879,
         0.0819300719507619,
         -0.0649875952638792,
         0.035460341202954,
         -0.0867792790965118,
         0.0819092092441381,
         -0.0317355667428053,
         -0.0271526384669023,
         0.0636352312543484,
         -0.0635353430452617,
         0.0313973304845437,
         0.0149441248147182,
         -0.0533841118075443,
         0.0666462256914579,
         -0.0486697686812992,
         0.00657453067541013,
         0.0422418537079468,
         -0.0770093033000531,
         0.0824023865579236,
         -0.0560677224040249,
         0.100204080292906,
         -0.0477704209245231,
         -0.0279714943590144,
         0.0674836764071146,
         -0.054816335353457,
         0.00809033803999179,
         0.0403277657959627,
         -0.0629465673243271,
         0.0491492650948143,
         -0.00781423511579636,
         -0.0384925384074757,
         0.0645973188618235,
         -0.0547214922067173,
         0.0108791147521018,
         0.0460194155497997,
         -0.0841638580193134,
         0.0766030921378042,
         -0.0987622197936324,
         -0.00510687280918729,
         0.0687195023104561,
         -0.0539511910380221,
         -0.00350081555275348,
         0.0521067273517941,
         -0.0603195526163632,
         0.0278966609383622,
         0.0213672155186201,
         -0.0564158968686971,
         0.0561939930917406,
         -0.0203880158019694,
         -0.0302061502124604,
         0.0638502511144543,
         -0.0550151799653209,
         0.00175739545995485,
         0.0655137201250604,
         -0.0924692566638419,
         0.0821751340487504,
         0.0572194188522074,
         -0.0658475251459392,
         -0.00231811502246691,
         0.0571790713900128,
         -0.0564071869934033,
         0.0113915028089622,
         0.0391518179260356,
         -0.0599760188805249,
         0.0392271489559547,
         0.00794537560122777,
         -0.0502491830187665,
         0.0589691204232357,
         -0.0256676906598177,
         -0.0297846034501969,
         0.0667756910440374,
         -0.0478332945704059,
         -0.0280941769405306,
         0.0993279151325207,
         -0.0552703960333439,
         -0.0879320644277012,
         0.0187851110041903,
         0.0579135646599634,
         -0.0569809946170003,
         0.00174076358300296,
         0.0494823984985234,
         -0.0575477631157599,
         0.0218378406832371,
         0.0285659583729369,
         -0.0578090917630996,
         0.0459520738730062,
         -0.000703245281475475,
         -0.0467909701578883,
         0.0605031691758671,
         -0.0244810436544385,
         -0.0387539692642477,
         0.0716056619848561,
         -0.0193868239247309,
         -0.0944796928966853,
         0.0263491274552907,
         0.0854178847788043,
         0.0460324969659466,
         -0.0664201602325927,
         0.000508990905621769,
         0.0558644342483389,
         -0.0540923907148163,
         0.00673733999390715,
         0.0430088379114965,
         -0.058068567967556,
         0.0299125756131807,
         0.0198946050770793,
         -0.0555150585837482,
         0.0502327753193101,
         -0.00519742021630276,
         -0.0473107207125622,
         0.0616849827805553,
         -0.0143693125096218,
         -0.0596751520013659,
         0.0630579968342816,
         0.0780140388146376,
         -0.0532937343191503,
         -0.0882628093977293,
         0.0138634585023909,
         0.0605934864863596,
         -0.0531784846178221,
         -0.00537984103304958,
         0.0533121846345105,
         -0.0540127216778467,
         0.0127221858231431,
         0.0367201364925798,
         -0.0582202415232074,
         0.0367201364925796,
         0.0127221858231429,
         -0.0540127216778467,
         0.0533121846345107,
         -0.00537984103304961,
         -0.0531784846178218,
         0.0605934864863597,
         0.0138634585023909,
         -0.0882628093977295,
         -0.0532937343191503,
         0.0780140388146379,
         0.0630579968342817,
         -0.0596751520013658,
         -0.0143693125096218,
         0.0616849827805553,
         -0.0473107207125624,
         -0.00519742021630293,
         0.0502327753193102,
         -0.055515058583748,
         0.0198946050770791,
         0.0299125756131811,
         -0.0580685679675559,
         0.0430088379114965,
         0.006737339993907,
         -0.0540923907148164,
         0.0558644342483388,
         0.000508990905621813,
         -0.0664201602325927,
         0.0460324969659467,
         0.0854178847788043,
         0.0263491274552908,
         -0.0944796928966852,
         -0.0193868239247308,
         0.071605661984856,
         -0.0387539692642477,
         -0.0244810436544386,
         0.060503169175867,
         -0.0467909701578884,
         -0.000703245281475476,
         0.0459520738730057,
         -0.0578090917630997,
         0.0285659583729368,
         0.0218378406832372,
         -0.05754776311576,
         0.0494823984985234,
         0.00174076358300298,
         -0.0569809946170003,
         0.0579135646599634,
         0.0187851110041903,
         -0.0879320644277013,
         -0.0552703960333441,
         0.0993279151325205,
         -0.0280941769405305,
         -0.0478332945704061,
         0.0667756910440373,
         -0.0297846034501969,
         -0.0256676906598177,
         0.0589691204232356,
         -0.0502491830187666,
         0.00794537560122769,
         0.0392271489559547,
         -0.0599760188805252,
         0.0391518179260356,
         0.0113915028089623,
         -0.0564071869934034,
         0.0571790713900128,
         -0.00231811502246684,
         -0.0658475251459392,
         0.0572194188522071,
         0.0821751340487506,
         -0.0924692566638418,
         0.0655137201250604,
         0.00175739545995478,
         -0.0550151799653208,
         0.0638502511144546,
         -0.0302061502124607,
         -0.0203880158019696,
         0.0561939930917405,
         -0.0564158968686972,
         0.0213672155186199,
         0.0278966609383621,
         -0.0603195526163632,
         0.0521067273517941,
         -0.0035008155527535,
         -0.0539511910380222,
         0.0687195023104561,
         -0.00510687280918744,
         -0.0987622197936323,
         0.0766030921378044,
         -0.0841638580193136,
         0.0460194155497997,
         0.0108791147521018,
         -0.054721492206717,
         0.0645973188618235,
         -0.0384925384074756,
         -0.00781423511579631,
         0.0491492650948142,
         -0.0629465673243271,
         0.0403277657959626,
         0.00809033803999194,
         -0.0548163353534569,
         0.0674836764071145,
         -0.0279714943590144,
         -0.0477704209245231,
         0.100204080292906,
         -0.0560677224040251,
         0.0824023865579238,
         -0.0770093033000532,
         0.0422418537079467,
         0.00657453067541014,
         -0.0486697686812991,
         0.0666462256914578,
         -0.0533841118075446,
         0.0149441248147181,
         0.0313973304845435,
         -0.0635353430452619,
         0.0636352312543483,
         -0.0271526384669023,
         -0.031735566742805,
         0.0819092092441383,
         -0.0867792790965118,
         0.0354603412029539,
         -0.064987595263879,
         0.0819300719507617,
         -0.0778754463107879,
         0.0519297754773049,
         -0.0111631930225661,
         -0.0317003234667091,
         0.0624105359684417,
         -0.0699235234462525,
         0.0504123210138645,
         -0.00933326375835419,
         -0.0393436190030622,
         0.0770710620952072,
         -0.087351626833414,
         0.0633746249135946,
         -0.0184203168414182,
         0.040460239085949,
         -0.0632897591524411,
         0.0800035516527198,
         -0.0844191331708489,
         0.0730656353779715,
         -0.0464029106793808,
         0.00901941784474411,
         0.0312629508354098,
         -0.0652320890923008,
         0.0847211352923923,
         -0.0850961590225152,
         0.0671138671357126,
         -0.0373286103575218,
         0.00685427733142323,
         -0.0176089572961607,
         0.032819261743059,
         -0.0509217832265954,
         0.06931614794453,
         -0.0848945966996839,
         0.0947038873698092,
         -0.0966172905080398,
         0.0898792498866986,
         -0.0753970506456559,
         0.0556844122765082,
         -0.034408199123883,
         0.0155296406175993},
        {-0.0112279116160768,
         0.0257263774384732,
         -0.0432485346557197,
         0.0611626642628818,
         -0.0766714572492581,
         0.0874189113621436,
         -0.0919048098330657,
         0.0896899106204102,
         -0.081392267640895,
         0.0685018007486422,
         -0.0530612666969419,
         0.0372755490508732,
         -0.0231173141659606,
         0.0119949853299907,
         -0.00453367830900332,
         0.0289903431345032,
         -0.0551007212488243,
         0.0751004872435221,
         -0.0828146389002509,
         0.075500831906955,
         -0.054214907344405,
         0.0231578353437119,
         0.0115789176718563,
         -0.043505997063548,
         0.0671451951158652,
         -0.0790990662044057,
         0.0786096030260078,
         -0.0675299970006948,
         0.0497328874503233,
         -0.0300730197422741,
         0.0130876019606114,
         -0.0526166154271516,
         0.0791594702347466,
         -0.0804825032311226,
         0.057299892809504,
         -0.0185955598063953,
         -0.022659500235969,
         0.0539906461665755,
         -0.0668705714901249,
         0.0585757011635069,
         -0.0323319400803221,
         -0.00402951769109611,
         0.0404457843214656,
         -0.0674196544624007,
         0.0785840992616723,
         -0.0724193008926762,
         0.0526383132646094,
         -0.0269340626298378,
         0.076701238356324,
         -0.0837125225361528,
         0.0497612425910635,
         0.00153766355008372,
         -0.0451978931253486,
         0.0644169087597246,
         -0.054612722622964,
         0.0225741534158109,
         0.0176564618822381,
         -0.0503348045912128,
         0.0633105251438186,
         -0.0517417557017963,
         0.0194034892969508,
         0.0226596874573742,
         -0.0597911924968739,
         0.0787818134615395,
         -0.0729377863992239,
         0.0453367830900336,
         -0.0939394483062919,
         0.0606376531403632,
         0.00531146878003661,
         -0.0543646161723432,
         0.0636785816929725,
         -0.0364688931996135,
         -0.00778882290177863,
         0.0456584733844899,
         -0.059976018880522,
         0.0455887885485672,
         -0.00994828925548349,
         -0.0307359549693115,
         0.0581320193446747,
         -0.0590395223864299,
         0.0309900900534759,
         0.0157563626923068,
         -0.0610241303041126,
         0.0823583564257086,
         -0.0656992404217946,
         0.0978826641629716,
         -0.0137513271682277,
         -0.0555671077175867,
         0.063608924153409,
         -0.02382138128616,
         -0.0271823080861708,
         0.0571543346069422,
         -0.0522490124192663,
         0.0187181491570581,
         0.0238950178799925,
         -0.05338812248422,
         0.0549985090318899,
         -0.0276479697515672,
         -0.0155139168699273,
         0.0524303041535068,
         -0.0617826007653322,
         0.0338984198440126,
         0.0212648361905199,
         -0.0736635533932161,
         0.0838424101589312,
         -0.0858487755552709,
         -0.0407216497636871,
         0.0702489478686808,
         -0.021625282813895,
         -0.0374651919981222,
         0.0606879066418228,
         -0.039780083452809,
         -0.00518870653732375,
         0.0446420369603902,
         -0.0565176810992838,
         0.0357873419884629,
         0.00511477207579402,
         -0.043486551482537,
         0.0576902956071417,
         -0.0381574496288929,
         -0.00634259095790528,
         0.0504850213950416,
         -0.063411683374494,
         0.0270271351144061,
         0.044527446780218,
         -0.0949328355102891,
         0.0607042513516939,
         0.0803041763004701,
         -0.0366855329323629,
         -0.0398847426089655,
         0.0629099136404195,
         -0.0291984826968428,
         -0.0231529778623703,
         0.0550752949131025,
         -0.0489339803757601,
         0.0123985159726014,
         0.0306631208504274,
         -0.0548192373063615,
         0.0462896714892982,
         -0.00969091151400142,
         -0.0340526018848698,
         0.0579792317091437,
         -0.0439525608862876,
         -0.00392150892680236,
         0.0548210357641557,
         -0.0629713191344305,
         0.094932835510289,
         -0.0303521256758471,
         -0.0871798437002497,
         -0.0277677416932317,
         0.0688363075200591,
         -0.0246530532907934,
         -0.0356267901747081,
         0.0593532214672371,
         -0.0366095580173474,
         -0.00991385708814942,
         0.0475270162755536,
         -0.0537417844862263,
         0.0265760836488903,
         0.0167265125159941,
         -0.0500358202424341,
         0.0525847428417763,
         -0.0209509165220519,
         -0.0268474787397614,
         0.0586060239366979,
         -0.0462538827516304,
         -0.0103993710913844,
         0.0671276517465917,
         -0.047466417755145,
         -0.0822142472051999,
         0.0587766386322753,
         0.0812956234321218,
         -0.0324257363848949,
         -0.0438475985094389,
         0.0616133900668448,
         -0.0230896999243216,
         -0.0293880070072394,
         0.0564506624774749,
         -0.0436945765093851,
         0.00323247235662768,
         0.0381140948226753,
         -0.0552458525911305,
         0.038114094822675,
         0.00323247235662769,
         -0.0436945765093855,
         0.0564506624774755,
         -0.0293880070072394,
         -0.0230896999243214,
         0.0616133900668449,
         -0.0438475985094388,
         -0.0324257363848949,
         0.0812956234321218,
         0.0587766386322752,
         -0.0822142472052002,
         -0.047466417755145,
         0.0671276517465917,
         -0.0103993710913843,
         -0.0462538827516304,
         0.0586060239366979,
         -0.0268474787397615,
         -0.0209509165220519,
         0.0525847428417764,
         -0.0500358202424341,
         0.0167265125159942,
         0.0265760836488905,
         -0.0537417844862258,
         0.0475270162755538,
         -0.00991385708814938,
         -0.0366095580173474,
         0.0593532214672371,
         -0.0356267901747081,
         -0.0246530532907932,
         0.0688363075200593,
         -0.0277677416932317,
         -0.0871798437002497,
         -0.0303521256758471,
         0.0949328355102891,
         -0.0629713191344305,
         0.0548210357641557,
         -0.00392150892680239,
         -0.0439525608862876,
         0.0579792317091439,
         -0.0340526018848697,
         -0.00969091151400179,
         0.0462896714892978,
         -0.0548192373063619,
         0.0306631208504274,
         0.0123985159726012,
         -0.0489339803757602,
         0.0550752949131024,
         -0.0231529778623701,
         -0.0291984826968424,
         0.0629099136404195,
         -0.0398847426089656,
         -0.0366855329323629,
         0.0803041763004702,
         0.060704251351694,
         -0.0949328355102891,
         0.0445274467802182,
         0.0270271351144061,
         -0.0634116833744939,
         0.0504850213950416,
         -0.00634259095790531,
         -0.0381574496288931,
         0.0576902956071415,
         -0.043486551482537,
         0.00511477207579406,
         0.035787341988463,
         -0.0565176810992841,
         0.0446420369603902,
         -0.00518870653732372,
         -0.039780083452809,
         0.0606879066418229,
         -0.0374651919981221,
         -0.0216252828138952,
         0.070248947868681,
         -0.0407216497636871,
         -0.0858487755552709,
         0.0838424101589311,
         -0.0736635533932162,
         0.02126483619052,
         0.0338984198440127,
         -0.061782600765332,
         0.0524303041535068,
         -0.0155139168699274,
         -0.0276479697515672,
         0.0549985090318899,
         -0.05338812248422,
         0.0238950178799925,
         0.0187181491570582,
         -0.0522490124192661,
         0.0571543346069423,
         -0.0271823080861706,
         -0.0238213812861602,
         0.0636089241534089,
         -0.0555671077175864,
         -0.0137513271682278,
         0.0978826641629717,
         -0.0656992404217945,
         0.0823583564257084,
         -0.0610241303041125,
         0.0157563626923069,
         0.030990090053476,
         -0.0590395223864301,
         0.0581320193446748,
         -0.0307359549693115,
         -0.00994828925548326,
         0.0455887885485671,
         -0.0599760188805221,
         0.0456584733844898,
         -0.00778882290177851,
         -0.0364688931996136,
         0.0636785816929723,
         -0.0543646161723431,
         0.00531146878003664,
         0.0606376531403632,
         -0.093939448306292,
         0.0453367830900335,
         -0.072937786399224,
         0.0787818134615394,
         -0.0597911924968738,
         0.0226596874573742,
         0.0194034892969507,
         -0.0517417557017965,
         0.0633105251438185,
         -0.0503348045912129,
         0.0176564618822381,
         0.0225741534158108,
         -0.0546127226229639,
         0.0644169087597247,
         -0.0451978931253486,
         0.00153766355008369,
         0.0497612425910637,
         -0.0837125225361528,
         0.0767012383563242,
         -0.0269340626298379,
         0.0526383132646092,
         -0.0724193008926762,
         0.078584099261672,
         -0.067419654462401,
         0.0404457843214655,
         -0.00402951769109612,
         -0.032331940080322,
         0.0585757011635068,
         -0.066870571490125,
         0.0539906461665757,
         -0.022659500235969,
         -0.0185955598063953,
         0.0572998928095042,
         -0.0804825032311227,
         0.0791594702347465,
         -0.0526166154271517,
         0.0130876019606113,
         -0.030073019742274,
         0.0497328874503232,
         -0.0675299970006948,
         0.0786096030260079,
         -0.0790990662044057,
         0.0671451951158651,
         -0.0435059970635478,
         0.0115789176718565,
         0.0231578353437118,
         -0.0542149073444052,
         0.0755008319069552,
         -0.0828146389002508,
         0.0751004872435221,
         -0.0551007212488242,
         0.0289903431345031,
         -0.00453367830900332,
         0.0119949853299907,
         -0.0231173141659605,
         0.037275549050873,
         -0.0530612666969419,
         0.0685018007486421,
         -0.0813922676408948,
         0.0896899106204104,
         -0.0919048098330658,
         0.0874189113621437,
         -0.0766714572492584,
         0.0611626642628818,
         -0.0432485346557201,
         0.0257263774384732,
         -0.0112279116160769},
        {-0.0190503876756476,
         0.0404119749290493,
         -0.0624924428375963,
         0.0806773967912763,
         -0.0914795692859133,
         0.093291221776787,
         -0.0864970693114394,
         0.0731033661501106,
         -0.0560677224040249,
         0.0385288569432674,
         -0.0231173141659604,
         0.0114833555837882,
         -0.00411170086871722,
         0.0434415677327698,
         -0.073040289414194,
         0.0852699749106408,
         -0.0756821066742662,
         0.0472398464483427,
         -0.00818218141902853,
         -0.0312603142804115,
         0.0620302631187672,
         -0.0784948113656345,
         0.0794017844713585,
         -0.0675299970006945,
         0.0483192301361182,
         -0.0279595659072774,
         0.0114833555837882,
         -0.0697632539933075,
         0.0863096431555294,
         -0.0633909773700914,
         0.0163882698819767,
         0.032149410417508,
         -0.0628391832037622,
         0.0658871542568986,
         -0.0426921550067277,
         0.00345145616623493,
         0.0375942605128439,
         -0.0674196544624008,
         0.0783452973904665,
         -0.06994219582997,
         0.0483192301361183,
         -0.0231173141659603,
         0.0900639736311062,
         -0.0697632539933078,
         0.00831236801664639,
         0.0469048488125784,
         -0.0663249474734304,
         0.0459372964482895,
         -0.00187529070966068,
         -0.0413970855548619,
         0.0631021396446118,
         -0.0541701859443151,
         0.0194034892969513,
         0.0259379240027158,
         -0.0632192042341024,
         0.0783452973904663,
         -0.0675299970006946,
         0.0385288569432674,
         -0.0976880951638162,
         0.0267529866604667,
         0.0473998485217801,
         -0.066196154709697,
         0.0314543279100268,
         0.0220046563744414,
         -0.0570938434184298,
         0.0547234608789137,
         -0.0194937103819892,
         -0.0267963295545193,
         0.0581320193446744,
         -0.057333822821845,
         0.0239327298655727,
         0.0259379240027157,
         -0.0674196544624008,
         0.0794017844713587,
         -0.0560677224040248,
         0.0900639736311062,
         0.0267529866604668,
         -0.0705615880357175,
         0.0302126669812915,
         0.0319674221245898,
         -0.0607341079998635,
         0.040680767218981,
         0.00748325898945948,
         -0.0487010188569922,
         0.056706073369613,
         -0.0276479697515673,
         -0.019843201212018,
         0.0561295965855431,
         -0.057333822821845,
         0.0194034892969513,
         0.0375942605128438,
         -0.0784948113656342,
         0.0731033661501106,
         -0.0697632539933075,
         -0.0697632539933076,
         0.04739984852178,
         0.0302126669812916,
         -0.0625461628190093,
         0.0315905827617988,
         0.0237904356343906,
         -0.0564071869934049,
         0.0446420369603882,
         -0.000515933480600406,
         -0.0434865514825354,
         0.0568725045148804,
         -0.0300048082382572,
         -0.019843201212018,
         0.0581320193446745,
         -0.054170185944315,
         0.00345145616623482,
         0.0620302631187671,
         -0.0864970693114394,
         0.0434415677327698,
         0.0863096431555295,
         0.00831236801664638,
         -0.066196154709697,
         0.0319674221245898,
         0.0315905827617991,
         -0.0585798486651622,
         0.0322393927239044,
         0.019153053295582,
         -0.0535677113756828,
         0.0462896714892997,
         -0.00407436025644967,
         -0.0417501002966785,
         0.0568725045148804,
         -0.0276479697515672,
         -0.0267963295545192,
         0.0631021396446119,
         -0.0426921550067278,
         -0.0312603142804115,
         0.093291221776787,
         -0.0190503876756476,
         -0.073040289414194,
         -0.0633909773700914,
         0.0469048488125784,
         0.0314543279100267,
         -0.0607341079998636,
         0.0237904356343908,
         0.0322393927239052,
         -0.0563850621888688,
         0.0325539308330187,
         0.0167265125159982,
         -0.0521764744289373,
         0.0467401521249717,
         -0.00407436025644635,
         -0.0434865514825381,
         0.0567060733696139,
         -0.0194937103819892,
         -0.0413970855548617,
         0.0658871542568983,
         -0.00818218141902864,
         -0.0914795692859131,
         0.0404119749290492,
         0.085269974910641,
         0.0163882698819767,
         -0.0663249474734303,
         0.0220046563744413,
         0.0406807672189809,
         -0.0564071869934049,
         0.0191530532955816,
         0.0325539308330154,
         -0.0552458525911302,
         0.0326838871614514,
         0.0159681658505228,
         -0.0521764744289373,
         0.0462896714892997,
         -0.00051593348060042,
         -0.0487010188569933,
         0.0547234608789136,
         -0.00187529070966067,
         -0.0628391832037623,
         0.0472398464483429,
         0.0806773967912764,
         -0.0624924428375961,
         -0.0756821066742661,
         0.032149410417508,
         0.0459372964482896,
         -0.0570938434184299,
         0.00748325898946067,
         0.0446420369603852,
         -0.053567711375678,
         0.0167265125159974,
         0.032683887161453,
         -0.0548905701111686,
         0.032683887161453,
         0.0167265125159971,
         -0.0535677113756784,
         0.044642036960385,
         0.00748325898946064,
         -0.0570938434184299,
         0.0459372964482897,
         0.032149410417508,
         -0.0756821066742661,
         -0.0624924428375962,
         0.0806773967912764,
         0.0472398464483428,
         -0.0628391832037622,
         -0.00187529070966064,
         0.0547234608789136,
         -0.0487010188569934,
         -0.000515933480600422,
         0.0462896714892995,
         -0.0521764744289374,
         0.0159681658505225,
         0.0326838871614511,
         -0.0552458525911303,
         0.0325539308330155,
         0.0191530532955815,
         -0.0564071869934048,
         0.040680767218981,
         0.0220046563744414,
         -0.0663249474734304,
         0.0163882698819767,
         0.085269974910641,
         0.0404119749290491,
         -0.0914795692859133,
         -0.00818218141902861,
         0.0658871542568983,
         -0.0413970855548618,
         -0.0194937103819892,
         0.0567060733696136,
         -0.0434865514825378,
         -0.00407436025644609,
         0.0467401521249717,
         -0.0521764744289374,
         0.0167265125159983,
         0.0325539308330188,
         -0.0563850621888689,
         0.0322393927239051,
         0.0237904356343907,
         -0.0607341079998637,
         0.0314543279100268,
         0.0469048488125785,
         -0.0633909773700914,
         -0.0730402894141938,
         -0.0190503876756475,
         0.0932912217767871,
         -0.0312603142804114,
         -0.0426921550067277,
         0.0631021396446118,
         -0.0267963295545192,
         -0.0276479697515671,
         0.0568725045148803,
         -0.0417501002966782,
         -0.00407436025644975,
         0.0462896714892996,
         -0.0535677113756823,
         0.019153053295582,
         0.0322393927239047,
         -0.0585798486651622,
         0.0315905827617988,
         0.0319674221245896,
         -0.066196154709697,
         0.00831236801664637,
         0.0863096431555294,
         0.0434415677327697,
         -0.0864970693114394,
         0.0620302631187673,
         0.00345145616623487,
         -0.0541701859443151,
         0.0581320193446743,
         -0.0198432012120181,
         -0.0300048082382572,
         0.0568725045148802,
         -0.0434865514825354,
         -0.000515933480600335,
         0.0446420369603884,
         -0.0564071869934049,
         0.0237904356343906,
         0.0315905827617989,
         -0.0625461628190091,
         0.0302126669812916,
         0.0473998485217798,
         -0.0697632539933078,
         -0.0697632539933075,
         0.0731033661501106,
         -0.0784948113656345,
         0.0375942605128439,
         0.0194034892969512,
         -0.0573338228218448,
         0.0561295965855431,
         -0.0198432012120179,
         -0.0276479697515674,
         0.0567060733696128,
         -0.0487010188569921,
         0.00748325898945949,
         0.0406807672189809,
         -0.0607341079998638,
         0.0319674221245899,
         0.0302126669812916,
         -0.0705615880357177,
         0.0267529866604666,
         0.0900639736311063,
         -0.0560677224040248,
         0.0794017844713588,
         -0.067419654462401,
         0.0259379240027158,
         0.0239327298655728,
         -0.0573338228218448,
         0.0581320193446743,
         -0.0267963295545191,
         -0.0194937103819893,
         0.0547234608789137,
         -0.0570938434184299,
         0.0220046563744414,
         0.0314543279100268,
         -0.0661961547096973,
         0.0473998485217799,
         0.0267529866604667,
         -0.0976880951638163,
         0.0385288569432675,
         -0.0675299970006945,
         0.0783452973904666,
         -0.0632192042341021,
         0.0259379240027157,
         0.0194034892969514,
         -0.054170185944315,
         0.0631021396446117,
         -0.0413970855548618,
         -0.00187529070966064,
         0.0459372964482896,
         -0.0663249474734304,
         0.0469048488125784,
         0.00831236801664642,
         -0.0697632539933076,
         0.0900639736311063,
         -0.0231173141659604,
         0.0483192301361184,
         -0.0699421958299702,
         0.0783452973904662,
         -0.0674196544624009,
         0.0375942605128439,
         0.0034514561662348,
         -0.0426921550067277,
         0.0658871542568984,
         -0.0628391832037621,
         0.032149410417508,
         0.0163882698819768,
         -0.0633909773700915,
         0.0863096431555294,
         -0.0697632539933078,
         0.0114833555837883,
         -0.0279595659072775,
         0.0483192301361182,
         -0.0675299970006944,
         0.0794017844713587,
         -0.0784948113656342,
         0.0620302631187671,
         -0.0312603142804115,
         -0.00818218141902856,
         0.0472398464483428,
         -0.0756821066742664,
         0.0852699749106408,
         -0.073040289414194,
         0.0434415677327697,
         -0.0041117008687172,
         0.0114833555837882,
         -0.0231173141659605,
         0.0385288569432675,
         -0.0560677224040248,
         0.0731033661501107,
         -0.0864970693114394,
         0.0932912217767871,
         -0.0914795692859132,
         0.0806773967912763,
         -0.0624924428375963,
         0.0404119749290492,
         -0.0190503876756476},
        {0.0093158233509924,
         -0.0228190137438356,
         0.040453787640626,
         -0.059546363096536,
         0.0766714572492582,
         -0.0885325729640404,
         0.0927709516143938,
         -0.0885325729640404,
         0.0766714572492582,
         -0.0595463630965362,
         0.040453787640626,
         -0.0228190137438356,
         0.00931582335099219,
         -0.0237507825259466,
         0.0488525897925542,
         -0.070859769672514,
         0.0817460181441935,
         -0.0763665993530603,
         0.0542149073444052,
         -0.0196014411180295,
         -0.0196014411180295,
         0.0542149073444053,
         -0.0763665993530605,
         0.0817460181441934,
         -0.0708597696725141,
         0.0488525897925543,
         -0.0237507825259467,
         0.0432485346557198,
         -0.0722865431258734,
         0.0807077209407369,
         -0.0633171017983609,
         0.0256420049783505,
         0.0188041146620644,
         -0.0539906461665759,
         0.0673031220963486,
         -0.0539906461665759,
         0.0188041146620644,
         0.0256420049783505,
         -0.063317101798361,
         0.0807077209407371,
         -0.0722865431258733,
         0.0432485346557197,
         -0.0644711089449635,
         0.0828146389002508,
         -0.0614739266510167,
         0.0139211030691268,
         0.0350251842001277,
         -0.0622798161872421,
         0.056628290643331,
         -0.02257415341581,
         -0.02257415341581,
         0.0566282906433311,
         -0.0622798161872421,
         0.0350251842001278,
         0.0139211030691268,
         -0.0614739266510168,
         0.0828146389002509,
         -0.0644711089449635,
         0.0827407961402261,
         -0.07334187695069,
         0.0185955598063954,
         0.0384964661372541,
         -0.0635164533932784,
         0.0464774096988516,
         -0.00202111514219938,
         -0.0419469308604757,
         0.0599760188805203,
         -0.0419469308604756,
         -0.00202111514219936,
         0.0464774096988515,
         -0.0635164533932786,
         0.0384964661372541,
         0.0185955598063954,
         -0.0733418769506902,
         0.0827407961402261,
         -0.093427512896609,
         0.0433896395482552,
         0.0303664220047178,
         -0.0644169087597257,
         0.0434461949774619,
         0.00766805864339369,
         -0.0498842150780964,
         0.0558634704346387,
         -0.0238950178799919,
         -0.023895017879992,
         0.0558634704346386,
         -0.0498842150780961,
         0.00766805864339364,
         0.043446194977462,
         -0.0644169087597258,
         0.0303664220047179,
         0.0433896395482554,
         -0.0934275128966089,
         0.0934275128966091,
         -0.0635159286005299,
         0.0495881594837213,
         0.0077888229017808,
         -0.0526620545181353,
         0.0522495127784993,
         -0.0120058508025221,
         -0.0357873419884641,
         0.0565459328786528,
         -0.0357873419884643,
         -0.012005850802522,
         0.0522495127784993,
         -0.0526620545181351,
         0.00778882290178083,
         0.0495881594837211,
         -0.0635159286005299,
         0.0934275128966089,
         -0.0822751241089176,
         -0.0442662864820207,
         0.0647992083104464,
         -0.00331324827194432,
         -0.0522877010676017,
         0.0522490124192645,
         -0.00645239228599958,
         -0.041923365412289,
         0.0548192373063635,
         -0.0245478092184628,
         -0.0245478092184626,
         0.0548192373063636,
         -0.0419233654122891,
         -0.0064523922859995,
         0.0522490124192645,
         -0.0522877010676017,
         -0.00331324827194423,
         0.0647992083104465,
         -0.0442662864820207,
         -0.0822751241089175,
         0.0624924428375962,
         0.0756821066742664,
         -0.032149410417508,
         -0.0459372964482896,
         0.0570938434184304,
         -0.00748325898946179,
         -0.0446420369603849,
         0.0535677113756785,
         -0.0167265125159936,
         -0.0326838871614515,
         0.0548905701111734,
         -0.0326838871614518,
         -0.0167265125159937,
         0.053567711375679,
         -0.0446420369603849,
         -0.00748325898946183,
         0.0570938434184303,
         -0.0459372964482898,
         -0.032149410417508,
         0.0756821066742664,
         0.0624924428375962,
         -0.0389708850601402,
         -0.084615167602025,
         -0.0202268938203132,
         0.0658975782025802,
         -0.0169497999009445,
         -0.0444987319439784,
         0.0543292592587828,
         -0.0123985159726058,
         -0.0381140948226732,
         0.054200095202422,
         -0.0248251943982885,
         -0.0248251943982888,
         0.054200095202422,
         -0.0381140948226728,
         -0.0123985159726054,
         0.0543292592587826,
         -0.0444987319439783,
         -0.0169497999009446,
         0.0658975782025801,
         -0.0202268938203132,
         -0.084615167602025,
         -0.03897088506014,
         0.0174283096275608,
         0.0697132385102432,
         0.0672234799920202,
         -0.0398361362915663,
         -0.0394430165255323,
         0.0581817253732118,
         -0.0119708822873072,
         -0.0418711091981053,
         0.0537417844862257,
         -0.0181297586218623,
         -0.0317270775882498,
         0.054389275865576,
         -0.0317270775882501,
         -0.0181297586218627,
         0.0537417844862257,
         -0.0418711091981054,
         -0.0119708822873075,
         0.0581817253732116,
         -0.0394430165255323,
         -0.0398361362915663,
         0.0672234799920203,
         0.0697132385102434,
         0.0174283096275608,
         -0.03897088506014,
         -0.0846151676020249,
         -0.0202268938203134,
         0.0658975782025801,
         -0.0169497999009444,
         -0.0444987319439784,
         0.0543292592587826,
         -0.0123985159726059,
         -0.0381140948226731,
         0.0542000952024221,
         -0.0248251943982885,
         -0.0248251943982888,
         0.0542000952024219,
         -0.038114094822673,
         -0.0123985159726055,
         0.0543292592587825,
         -0.0444987319439783,
         -0.0169497999009445,
         0.0658975782025802,
         -0.0202268938203132,
         -0.0846151676020249,
         -0.0389708850601401,
         0.0624924428375962,
         0.0756821066742663,
         -0.0321494104175081,
         -0.0459372964482897,
         0.0570938434184304,
         -0.00748325898946157,
         -0.0446420369603848,
         0.0535677113756786,
         -0.0167265125159936,
         -0.0326838871614515,
         0.0548905701111733,
         -0.0326838871614518,
         -0.0167265125159936,
         0.0535677113756788,
         -0.0446420369603852,
         -0.00748325898946181,
         0.0570938434184304,
         -0.0459372964482898,
         -0.0321494104175081,
         0.0756821066742663,
         0.0624924428375962,
         -0.0822751241089175,
         -0.0442662864820207,
         0.0647992083104463,
         -0.00331324827194435,
         -0.0522877010676018,
         0.0522490124192647,
         -0.00645239228599946,
         -0.0419233654122891,
         0.0548192373063637,
         -0.024547809218463,
         -0.0245478092184628,
         0.0548192373063637,
         -0.0419233654122892,
         -0.00645239228599969,
         0.0522490124192643,
         -0.0522877010676015,
         -0.00331324827194436,
         0.0647992083104466,
         -0.0442662864820206,
         -0.0822751241089174,
         0.0934275128966092,
         -0.0635159286005298,
         0.0495881594837212,
         0.00778882290178085,
         -0.052662054518135,
         0.0522495127784992,
         -0.012005850802522,
         -0.0357873419884641,
         0.0565459328786528,
         -0.0357873419884643,
         -0.012005850802522,
         0.0522495127784993,
         -0.0526620545181351,
         0.00778882290178088,
         0.0495881594837213,
         -0.0635159286005298,
         0.0934275128966091,
         -0.0934275128966091,
         0.0433896395482554,
         0.0303664220047178,
         -0.0644169087597257,
         0.043446194977462,
         0.00766805864339368,
         -0.0498842150780962,
         0.0558634704346387,
         -0.0238950178799922,
         -0.0238950178799922,
         0.0558634704346386,
         -0.049884215078096,
         0.00766805864339373,
         0.043446194977462,
         -0.0644169087597257,
         0.0303664220047177,
         0.0433896395482553,
         -0.093427512896609,
         0.082740796140226,
         -0.0733418769506898,
         0.0185955598063956,
         0.038496466137254,
         -0.0635164533932783,
         0.0464774096988515,
         -0.00202111514219942,
         -0.0419469308604757,
         0.0599760188805202,
         -0.0419469308604756,
         -0.00202111514219936,
         0.0464774096988516,
         -0.0635164533932784,
         0.0384964661372541,
         0.0185955598063954,
         -0.0733418769506901,
         0.0827407961402259,
         -0.0644711089449635,
         0.0828146389002509,
         -0.0614739266510168,
         0.0139211030691267,
         0.0350251842001275,
         -0.0622798161872421,
         0.0566282906433312,
         -0.0225741534158098,
         -0.02257415341581,
         0.0566282906433312,
         -0.0622798161872421,
         0.0350251842001277,
         0.0139211030691267,
         -0.0614739266510168,
         0.0828146389002508,
         -0.0644711089449634,
         0.0432485346557198,
         -0.0722865431258735,
         0.0807077209407369,
         -0.063317101798361,
         0.0256420049783506,
         0.0188041146620644,
         -0.0539906461665759,
         0.0673031220963485,
         -0.0539906461665758,
         0.0188041146620644,
         0.0256420049783505,
         -0.0633171017983609,
         0.080707720940737,
         -0.0722865431258734,
         0.0432485346557197,
         -0.0237507825259467,
         0.0488525897925541,
         -0.0708597696725142,
         0.0817460181441937,
         -0.0763665993530605,
         0.0542149073444052,
         -0.0196014411180294,
         -0.0196014411180295,
         0.0542149073444054,
         -0.0763665993530603,
         0.0817460181441937,
         -0.0708597696725142,
         0.0488525897925542,
         -0.0237507825259466,
         0.00931582335099223,
         -0.0228190137438358,
         0.0404537876406256,
         -0.0595463630965362,
         0.0766714572492585,
         -0.0885325729640403,
         0.0927709516143941,
         -0.0885325729640405,
         0.0766714572492584,
         -0.0595463630965361,
         0.0404537876406258,
         -0.0228190137438356,
         0.00931582335099227},
        {-0.00634479073816443,
         0.0160720784083102,
         -0.0295975270267668,
         0.0455036000160274,
         -0.0616121656798997,
         0.0754591839317864,
         -0.0848088012288531,
         0.0881099807040881,
         -0.0848088012288531,
         0.0754591839317863,
         -0.0616121656798998,
         0.0455036000160272,
         -0.0295975270267667,
         0.0160720784083102,
         -0.00634479073816435,
         0.0173759250497127,
         -0.0376478376077105,
         0.0582868806812926,
         -0.0733180607860907,
         0.0777121915063587,
         -0.0688844953506182,
         0.047409561159496,
         -0.016894317592013,
         -0.0168943175920131,
         0.047409561159496,
         -0.0688844953506183,
         0.0777121915063587,
         -0.0733180607860908,
         0.0582868806812925,
         -0.0376478376077107,
         0.0173759250497126,
         -0.0338249670603118,
         0.0609896836500453,
         -0.0759165606115433,
         0.0717371397114048,
         -0.0484480493934396,
         0.0126065821453474,
         0.0251181991160034,
         -0.0534420940718123,
         0.0639216983984675,
         -0.053442094071812,
         0.0251181991160033,
         0.0126065821453473,
         -0.0484480493934396,
         0.0717371397114047,
         -0.0759165606115431,
         0.0609896836500453,
         -0.0338249670603119,
         0.0536796847464529,
         -0.0770457583040435,
         0.0702366719526508,
         -0.0372166541984365,
         -0.00712608315151875,
         0.0445023750176561,
         -0.0607351141839632,
         0.0507014738630004,
         -0.0195719430710401,
         -0.0195719430710401,
         0.0507014738630006,
         -0.060735114183963,
         0.0445023750176562,
         -0.00712608315151874,
         -0.0372166541984365,
         0.0702366719526509,
         -0.0770457583040435,
         0.0536796847464526,
         -0.0730702802166896,
         0.0770686715412204,
         -0.038840904878066,
         -0.0139211030691285,
         0.052087998130641,
         -0.0587631870612949,
         0.0343704501282919,
         0.00637398439804672,
         -0.0426340449547538,
         0.056962721350922,
         -0.0426340449547537,
         0.00637398439804667,
         0.0343704501282919,
         -0.0587631870612946,
         0.0520879981306409,
         -0.0139211030691285,
         -0.0388409048780659,
         0.0770686715412204,
         -0.0730702802166894,
         0.0872264514788796,
         -0.0566981744070307,
         -0.00779786959329288,
         0.0539561234928736,
         -0.0570595431028774,
         0.0232944609263998,
         0.0221518715078673,
         -0.0520353573914438,
         0.0508416778767191,
         -0.0207998449471882,
         -0.0207998449471883,
         0.050841677876719,
         -0.0520353573914437,
         0.0221518715078674,
         0.0232944609263998,
         -0.0570595431028777,
         0.0539561234928735,
         -0.00779786959329282,
         -0.0566981744070307,
         0.0872264514788796,
         -0.091944752962474,
         0.0187681441070256,
         0.0497612425910623,
         -0.0596490873351673,
         0.0200486798281819,
         0.0300730197422732,
         -0.0551937911510206,
         0.0422972835466501,
         -0.00297054050043946,
         -0.037102038958853,
         0.0537049687227701,
         -0.0371020389588527,
         -0.00297054050043963,
         0.0422972835466502,
         -0.0551937911510205,
         0.0300730197422733,
         0.0200486798281819,
         -0.0596490873351675,
         0.0497612425910623,
         0.0187681441070256,
         -0.0919447529624741,
         0.0851243003612804,
         0.0265421639367296,
         -0.06652828571406,
         0.0267990539469342,
         0.0316063741063314,
         -0.0567062298413809,
         0.0358494189509635,
         0.00956142558514977,
         -0.0460796045907773,
         0.0504117439596599,
         -0.0214208721803779,
         -0.0214208721803776,
         0.0504117439596596,
         -0.0460796045907771,
         0.00956142558515009,
         0.0358494189509631,
         -0.0567062298413808,
         0.0316063741063315,
         0.0267990539469343,
         -0.0665282857140597,
         0.0265421639367297,
         0.0851243003612804,
         -0.0678123591662367,
         -0.0647462860388079,
         0.047584162167049,
         0.0249403587675809,
         -0.0588738731399064,
         0.0338534550321538,
         0.0171860320906093,
         -0.050942323106375,
         0.0451389162381522,
         -0.00751980110626574,
         -0.0343074428340151,
         0.0521327742053816,
         -0.0343074428340151,
         -0.00751980110626607,
         0.0451389162381522,
         -0.0509423231063755,
         0.0171860320906091,
         0.0338534550321539,
         -0.0588738731399065,
         0.0249403587675811,
         0.047584162167049,
         -0.064746286038808,
         -0.067812359166237,
         0.0442563804315865,
         0.0825815527475462,
         0.000290082625436914,
         -0.0611971221046353,
         0.0384918256961918,
         0.0200855002078335,
         -0.0540667204826254,
         0.0402600916482648,
         0.00396908191926302,
         -0.0431423754321666,
         0.0500945853483733,
         -0.0216885450611199,
         -0.02168854506112,
         0.0500945853483738,
         -0.0431423754321666,
         0.00396908191926329,
         0.0402600916482648,
         -0.0540667204826254,
         0.0200855002078335,
         0.0384918256961917,
         -0.0611971221046355,
         0.000290082625436896,
         0.0825815527475461,
         0.0442563804315865,
         -0.0206721272630405,
         -0.0740751226925619,
         -0.0536276924649893,
         0.0532531974058744,
         0.0167773786482635,
         -0.0571479460206548,
         0.0374179694852725,
         0.0130994429624469,
         -0.0493072020987948,
         0.0458381952354392,
         -0.00889327214062415,
         -0.0334443798054224,
         0.0516566658380737,
         -0.0334443798054227,
         -0.00889327214062408,
         0.0458381952354386,
         -0.0493072020987953,
         0.0130994429624467,
         0.0374179694852724,
         -0.0571479460206546,
         0.0167773786482635,
         0.0532531974058742,
         -0.0536276924649891,
         -0.0740751226925618,
         -0.0206721272630404,
         0.0442563804315865,
         0.0825815527475462,
         0.000290082625437036,
         -0.0611971221046356,
         0.0384918256961918,
         0.0200855002078334,
         -0.0540667204826254,
         0.0402600916482647,
         0.003969081919263,
         -0.0431423754321667,
         0.0500945853483734,
         -0.02168854506112,
         -0.0216885450611199,
         0.0500945853483738,
         -0.0431423754321667,
         0.00396908191926326,
         0.0402600916482648,
         -0.0540667204826256,
         0.0200855002078337,
         0.0384918256961917,
         -0.0611971221046354,
         0.000290082625436913,
         0.0825815527475461,
         0.0442563804315867,
         -0.067812359166237,
         -0.064746286038808,
         0.047584162167049,
         0.0249403587675807,
         -0.0588738731399064,
         0.0338534550321539,
         0.0171860320906092,
         -0.050942323106375,
         0.0451389162381525,
         -0.00751980110626583,
         -0.0343074428340152,
         0.0521327742053816,
         -0.0343074428340152,
         -0.00751980110626604,
         0.0451389162381523,
         -0.0509423231063754,
         0.0171860320906092,
         0.0338534550321538,
         -0.0588738731399063,
         0.0249403587675807,
         0.047584162167049,
         -0.0647462860388081,
         -0.0678123591662369,
         0.0851243003612805,
         0.0265421639367296,
         -0.0665282857140599,
         0.0267990539469343,
         0.0316063741063314,
         -0.0567062298413808,
         0.0358494189509634,
         0.00956142558514973,
         -0.0460796045907772,
         0.0504117439596601,
         -0.0214208721803779,
         -0.0214208721803777,
         0.0504117439596595,
         -0.0460796045907769,
         0.0095614255851502,
         0.0358494189509632,
         -0.0567062298413809,
         0.0316063741063314,
         0.0267990539469343,
         -0.0665282857140598,
         0.0265421639367295,
         0.0851243003612804,
         -0.0919447529624741,
         0.0187681441070257,
         0.0497612425910622,
         -0.0596490873351674,
         0.0200486798281818,
         0.0300730197422731,
         -0.0551937911510208,
         0.0422972835466503,
         -0.00297054050043948,
         -0.0371020389588529,
         0.05370496872277,
         -0.0371020389588527,
         -0.0029705405004396,
         0.0422972835466505,
         -0.0551937911510207,
         0.0300730197422735,
         0.0200486798281818,
         -0.0596490873351675,
         0.0497612425910623,
         0.0187681441070256,
         -0.0919447529624743,
         0.0872264514788798,
         -0.0566981744070306,
         -0.00779786959329283,
         0.0539561234928736,
         -0.0570595431028775,
         0.0232944609263999,
         0.0221518715078673,
         -0.0520353573914439,
         0.0508416778767192,
         -0.0207998449471882,
         -0.0207998449471883,
         0.0508416778767192,
         -0.0520353573914439,
         0.0221518715078675,
         0.0232944609263998,
         -0.0570595431028775,
         0.0539561234928735,
         -0.00779786959329288,
         -0.0566981744070305,
         0.0872264514788795,
         -0.0730702802166897,
         0.0770686715412206,
         -0.0388409048780659,
         -0.0139211030691285,
         0.0520879981306409,
         -0.0587631870612948,
         0.0343704501282919,
         0.00637398439804663,
         -0.0426340449547538,
         0.056962721350922,
         -0.0426340449547536,
         0.00637398439804658,
         0.0343704501282919,
         -0.0587631870612948,
         0.052087998130641,
         -0.0139211030691286,
         -0.0388409048780661,
         0.0770686715412204,
         -0.0730702802166896,
         0.0536796847464526,
         -0.0770457583040436,
         0.0702366719526509,
         -0.0372166541984367,
         -0.00712608315151887,
         0.0445023750176562,
         -0.0607351141839631,
         0.0507014738630004,
         -0.0195719430710401,
         -0.0195719430710401,
         0.0507014738630005,
         -0.0607351141839631,
         0.0445023750176559,
         -0.00712608315151882,
         -0.0372166541984367,
         0.0702366719526509,
         -0.0770457583040434,
         0.0536796847464525,
         -0.0338249670603118,
         0.0609896836500454,
         -0.0759165606115432,
         0.0717371397114048,
         -0.0484480493934396,
         0.0126065821453473,
         0.0251181991160035,
         -0.0534420940718121,
         0.0639216983984674,
         -0.0534420940718121,
         0.0251181991160035,
         0.0126065821453473,
         -0.0484480493934396,
         0.071737139711405,
         -0.0759165606115431,
         0.0609896836500455,
         -0.0338249670603119,
         0.0173759250497126,
         -0.0376478376077105,
         0.0582868806812926,
         -0.0733180607860907,
         0.0777121915063585,
         -0.0688844953506181,
         0.0474095611594959,
         -0.016894317592013,
         -0.016894317592013,
         0.0474095611594961,
         -0.068884495350618,
         0.0777121915063586,
         -0.0733180607860907,
         0.0582868806812927,
         -0.0376478376077106,
         0.0173759250497126,
         -0.00634479073816447,
         0.0160720784083102,
         -0.0295975270267668,
         0.0455036000160273,
         -0.0616121656798997,
         0.0754591839317863,
         -0.0848088012288532,
         0.0881099807040881,
         -0.0848088012288532,
         0.0754591839317863,
         -0.0616121656798999,
         0.0455036000160273,
         -0.0295975270267668,
         0.0160720784083103,
         -0.0063447907381644},
        {-0.0118700165664939,
         0.0278376563864244,
         -0.0471564083264862,
         0.0661820823977375,
         -0.0810561659946443,
         0.0887925810802999,
         -0.0880102523408285,
         0.0791859405482222,
         -0.064416908759725,
         0.046797799256487,
         -0.0295975270267667,
         0.0154568043807148,
         -0.00580455261013738,
         0.0288543742765044,
         -0.0557902258213651,
         0.0752559538726611,
         -0.0792022255747279,
         0.0646604518165047,
         -0.0345624653101954,
         -0.00354603412029516,
         0.0401187963644754,
         -0.0665924689067077,
         0.0778244761935947,
         -0.0733180607860902,
         0.0569510515893362,
         -0.0353550022617461,
         0.015456804380715,
         -0.0499772422675141,
         0.0763414985720102,
         -0.0750280537931156,
         0.0460722080352434,
         -0.00175013846215485,
         -0.0399092973013959,
         0.0629358623077833,
         -0.0593718088633361,
         0.0315842640133091,
         0.00938192442285168,
         -0.0484480493934397,
         0.0723238715782073,
         -0.0744038107299433,
         0.0569510515893363,
         -0.0295975270267666,
         0.0706784938247243,
         -0.0790209583696913,
         0.0435940677214991,
         0.010353958773579,
         -0.0519174968609637,
         0.0610043140573452,
         -0.0361915591884274,
         -0.00723831183768735,
         0.0462346283319214,
         -0.0611626642628831,
         0.0445023750176565,
         -0.0037800850733428,
         -0.0422149280737262,
         0.0723238715782072,
         -0.0733180607860906,
         0.046797799256487,
         -0.0858004372769146,
         0.0595768270501811,
         0.00534584757764363,
         -0.0541665659104994,
         0.0575364367459163,
         -0.0208437086253902,
         -0.0273808333442597,
         0.0559199811132252,
         -0.0484138869380964,
         0.0106069511890007,
         0.0343704501282913,
         -0.0592350179926694,
         0.0476306589779231,
         -0.00378008507334282,
         -0.0484480493934399,
         0.0778244761935949,
         -0.0644169087597251,
         0.0913415406145038,
         -0.0221535776447203,
         -0.0487655393003953,
         0.0595128347362786,
         -0.0168203167212065,
         -0.0354057448022874,
         0.0566186559920109,
         -0.0348100141570916,
         -0.0114568167094304,
         0.0489914089940029,
         -0.0520353573914426,
         0.0181006968222067,
         0.0303558660424884,
         -0.0592350179926693,
         0.0445023750176567,
         0.00938192442285164,
         -0.0665924689067077,
         0.0791859405482222,
         -0.0858004372769144,
         -0.0221535776447202,
         0.0659773757342717,
         -0.0253237488752605,
         -0.0353122806765305,
         0.0566256239302173,
         -0.0269784436420607,
         -0.0233284922972481,
         0.0531292224630926,
         -0.0408381800946335,
         -0.00297054050043937,
         0.0449707224916489,
         -0.0527408871131605,
         0.0181006968222066,
         0.0343704501282911,
         -0.0611626642628834,
         0.031584264013309,
         0.0401187963644754,
         -0.0880102523408283,
         0.0706784938247243,
         0.0595768270501811,
         -0.0487655393003954,
         -0.0253237488752598,
         0.0584826929200886,
         -0.0266935751133161,
         -0.0280633550146977,
         0.0539408453966609,
         -0.0319714157806654,
         -0.0162452698541026,
         0.0504117439596551,
         -0.0430658526607278,
         -0.000333275747948976,
         0.044970722491649,
         -0.0520353573914424,
         0.0106069511890007,
         0.0462346283319215,
         -0.0593718088633362,
         -0.00354603412029521,
         0.0887925810802997,
         -0.049977242267514,
         -0.0790209583696913,
         0.0053458475776437,
         0.0595128347362784,
         -0.0353122806765312,
         -0.0266935751133162,
         0.054774060412042,
         -0.0273870302060174,
         -0.023892511278112,
         0.0520611140007867,
         -0.0343074428340041,
         -0.0129792256443676,
         0.049435902612656,
         -0.0430658526607277,
         -0.00297054050043944,
         0.0489914089940029,
         -0.0484138869380965,
         -0.00723831183768738,
         0.0629358623077832,
         -0.0345624653101954,
         -0.0810561659946443,
         0.0288543742765045,
         0.0763414985720103,
         0.0435940677214991,
         -0.0541665659104992,
         -0.0168203167212066,
         0.056625623930218,
         -0.0280633550146978,
         -0.0273870302060175,
         0.0527218637986353,
         -0.0277440800624462,
         -0.0216885450611261,
         0.0511119406061259,
         -0.0349939535348078,
         -0.0129792256443677,
         0.0504117439596552,
         -0.0408381800946335,
         -0.0114568167094303,
         0.0559199811132252,
         -0.0361915591884275,
         -0.0399092973013959,
         0.0646604518165047,
         0.0661820823977377,
         -0.0118700165664939,
         -0.0557902258213653,
         -0.0750280537931156,
         0.0103539587735791,
         0.0575364367459162,
         -0.0354057448022874,
         -0.0269784436420607,
         0.053940845396661,
         -0.0238925112781121,
         -0.027744080062446,
         0.0516566658380863,
         -0.0278977880534067,
         -0.0209963721208756,
         0.0511119406061257,
         -0.0343074428340042,
         -0.0162452698541027,
         0.0531292224630926,
         -0.0348100141570916,
         -0.0273808333442599,
         0.0610043140573451,
         -0.00175013846215481,
         -0.0792022255747281,
         -0.0471564083264866,
         0.0278376563864241,
         0.0752559538726612,
         0.0460722080352436,
         -0.0519174968609636,
         -0.0208437086253902,
         0.0566186559920106,
         -0.023328492297248,
         -0.0319714157806636,
         0.0520611140007834,
         -0.0216885450611218,
         -0.0278977880534064,
         0.051324465184369,
         -0.0278977880534067,
         -0.0216885450611216,
         0.0520611140007835,
         -0.0319714157806635,
         -0.023328492297248,
         0.056618655992011,
         -0.0208437086253903,
         -0.0519174968609637,
         0.0460722080352435,
         0.0752559538726612,
         0.0278376563864243,
         -0.0471564083264864,
         -0.0792022255747281,
         -0.00175013846215485,
         0.0610043140573451,
         -0.0273808333442598,
         -0.0348100141570917,
         0.0531292224630927,
         -0.0162452698541026,
         -0.0343074428340043,
         0.0511119406061265,
         -0.0209963721208757,
         -0.0278977880534063,
         0.0516566658380862,
         -0.027744080062446,
         -0.0238925112781119,
         0.053940845396661,
         -0.0269784436420607,
         -0.0354057448022873,
         0.0575364367459162,
         0.010353958773579,
         -0.0750280537931156,
         -0.0557902258213652,
         -0.011870016566494,
         0.0661820823977377,
         0.0646604518165047,
         -0.039909297301396,
         -0.0361915591884275,
         0.0559199811132252,
         -0.0114568167094303,
         -0.0408381800946336,
         0.0504117439596553,
         -0.0129792256443677,
         -0.0349939535348078,
         0.0511119406061264,
         -0.0216885450611266,
         -0.0277440800624462,
         0.0527218637986351,
         -0.0273870302060175,
         -0.0280633550146976,
         0.0566256239302178,
         -0.0168203167212065,
         -0.0541665659104992,
         0.0435940677214992,
         0.0763414985720102,
         0.0288543742765046,
         -0.0810561659946444,
         -0.0345624653101953,
         0.0629358623077833,
         -0.00723831183768729,
         -0.0484138869380966,
         0.048991408994003,
         -0.00297054050043934,
         -0.0430658526607276,
         0.049435902612656,
         -0.0129792256443678,
         -0.0343074428340045,
         0.0520611140007868,
         -0.0238925112781122,
         -0.0273870302060176,
         0.0547740604120419,
         -0.0266935751133162,
         -0.0353122806765311,
         0.0595128347362785,
         0.00534584757764378,
         -0.0790209583696912,
         -0.0499772422675141,
         0.0887925810802999,
         -0.00354603412029512,
         -0.0593718088633361,
         0.0462346283319216,
         0.0106069511890007,
         -0.0520353573914424,
         0.0449707224916485,
         -0.000333275747949103,
         -0.0430658526607277,
         0.0504117439596551,
         -0.0162452698541027,
         -0.0319714157806653,
         0.053940845396661,
         -0.0280633550146978,
         -0.0266935751133162,
         0.0584826929200888,
         -0.0253237488752598,
         -0.0487655393003955,
         0.0595768270501811,
         0.0706784938247243,
         -0.0880102523408283,
         0.0401187963644755,
         0.0315842640133091,
         -0.0611626642628832,
         0.0343704501282912,
         0.0181006968222064,
         -0.0527408871131608,
         0.0449707224916486,
         -0.00297054050043944,
         -0.0408381800946334,
         0.0531292224630926,
         -0.023328492297248,
         -0.0269784436420609,
         0.056625623930217,
         -0.0353122806765306,
         -0.0253237488752606,
         0.0659773757342719,
         -0.0221535776447202,
         -0.0858004372769146,
         0.0791859405482222,
         -0.0665924689067076,
         0.00938192442285175,
         0.0445023750176566,
         -0.0592350179926692,
         0.0303558660424883,
         0.0181006968222065,
         -0.0520353573914425,
         0.0489914089940031,
         -0.0114568167094303,
         -0.0348100141570916,
         0.0566186559920106,
         -0.0354057448022873,
         -0.0168203167212065,
         0.0595128347362784,
         -0.0487655393003954,
         -0.0221535776447203,
         0.0913415406145036,
         -0.0644169087597251,
         0.0778244761935949,
         -0.0484480493934398,
         -0.00378008507334281,
         0.0476306589779229,
         -0.0592350179926694,
         0.0343704501282912,
         0.0106069511890006,
         -0.0484138869380963,
         0.0559199811132253,
         -0.0273808333442598,
         -0.0208437086253904,
         0.0575364367459161,
         -0.0541665659104992,
         0.00534584757764376,
         0.0595768270501811,
         -0.0858004372769145,
         0.046797799256487,
         -0.0733180607860905,
         0.0723238715782073,
         -0.0422149280737263,
         -0.00378008507334286,
         0.0445023750176567,
         -0.0611626642628832,
         0.0462346283319214,
         -0.00723831183768719,
         -0.0361915591884276,
         0.0610043140573449,
         -0.0519174968609639,
         0.010353958773579,
         0.0435940677214992,
         -0.0790209583696914,
         0.0706784938247245,
         -0.0295975270267666,
         0.0569510515893361,
         -0.0744038107299434,
         0.0723238715782073,
         -0.0484480493934398,
         0.00938192442285174,
         0.0315842640133091,
         -0.059371808863336,
         0.0629358623077832,
         -0.0399092973013958,
         -0.0017501384621549,
         0.0460722080352436,
         -0.0750280537931156,
         0.0763414985720103,
         -0.0499772422675141,
         0.0154568043807148,
         -0.0353550022617459,
         0.0569510515893362,
         -0.0733180607860905,
         0.0778244761935948,
         -0.0665924689067077,
         0.0401187963644754,
         -0.00354603412029515,
         -0.0345624653101954,
         0.0646604518165047,
         -0.0792022255747281,
         0.0752559538726611,
         -0.0557902258213652,
         0.0288543742765044,
         -0.00580455261013745,
         0.0154568043807148,
         -0.0295975270267666,
         0.0467977992564868,
         -0.0644169087597251,
         0.0791859405482223,
         -0.0880102523408283,
         0.0887925810802999,
         -0.0810561659946446,
         0.0661820823977377,
         -0.0471564083264865,
         0.0278376563864244,
         -0.0118700165664938},
        {-0.00764132640913017,
         0.0194816362349434,
         -0.0356456775720244,
         0.0537378808656326,
         -0.0703594019295089,
         0.0820524576002101,
         -0.0862629766783917,
         0.0820524576002099,
         -0.0703594019295086,
         0.0537378808656326,
         -0.0356456775720245,
         0.0194816362349434,
         -0.00764132640913012,
         0.0194816362349434,
         -0.0420272952502162,
         0.063323461736558,
         -0.0752330332118856,
         0.0718102638894545,
         -0.0517033900004071,
         0.0188241247762352,
         0.0188241247762351,
         -0.0517033900004071,
         0.0718102638894545,
         -0.0752330332118854,
         0.063323461736558,
         -0.0420272952502161,
         0.0194816362349434,
         -0.0356456775720245,
         0.063323461736558,
         -0.0745859903847713,
         0.0618040047503041,
         -0.0280096052068142,
         -0.0143994702606091,
         0.0490268107997341,
         -0.0623090522228751,
         0.0490268107997342,
         -0.0143994702606092,
         -0.0280096052068141,
         0.0618040047503041,
         -0.0745859903847714,
         0.0633234617365579,
         -0.0356456775720245,
         0.0537378808656326,
         -0.0752330332118857,
         0.061804004750304,
         -0.0204322423548482,
         -0.026938942133122,
         0.0561854588639113,
         -0.0534927873541925,
         0.021703194535981,
         0.0217031945359811,
         -0.0534927873541925,
         0.0561854588639111,
         -0.0269389421331218,
         -0.0204322423548482,
         0.0618040047503039,
         -0.0752330332118855,
         0.0537378808656326,
         -0.0703594019295085,
         0.0718102638894544,
         -0.0280096052068142,
         -0.0269389421331219,
         0.0571438322769734,
         -0.0466826753446879,
         0.00602866514888345,
         0.0370988650303508,
         -0.0552310716626357,
         0.0370988650303508,
         0.00602866514888335,
         -0.0466826753446878,
         0.0571438322769733,
         -0.0269389421331219,
         -0.0280096052068142,
         0.0718102638894544,
         -0.0703594019295087,
         0.0820524576002101,
         -0.0517033900004071,
         -0.0143994702606092,
         0.0561854588639112,
         -0.046682675344688,
         0.00116281054051764,
         0.0423620810650817,
         -0.0522038045263826,
         0.0230129465260972,
         0.0230129465260976,
         -0.052203804526383,
         0.0423620810650817,
         0.00116281054051763,
         -0.0466826753446879,
         0.0561854588639113,
         -0.0143994702606091,
         -0.0517033900004072,
         0.08205245760021,
         -0.086262976678392,
         0.018824124776235,
         0.049026810799734,
         -0.0534927873541927,
         0.00602866514888352,
         0.0423620810650817,
         -0.0507177740267304,
         0.0161391527321521,
         0.0306212856916939,
         -0.0517286380776757,
         0.0306212856916941,
         0.0161391527321519,
         -0.0507177740267303,
         0.0423620810650816,
         0.00602866514888333,
         -0.0534927873541925,
         0.0490268107997341,
         0.0188241247762351,
         -0.0862629766783917,
         0.0820524576002102,
         0.0188241247762352,
         -0.0623090522228751,
         0.0217031945359811,
         0.0370988650303509,
         -0.0522038045263829,
         0.016139152732152,
         0.0327597826716314,
         -0.0506204737391295,
         0.0237050399587888,
         0.0237050399587891,
         -0.0506204737391297,
         0.0327597826716312,
         0.016139152732152,
         -0.052203804526383,
         0.0370988650303508,
         0.021703194535981,
         -0.0623090522228752,
         0.0188241247762351,
         0.0820524576002101,
         -0.0703594019295085,
         -0.0517033900004072,
         0.0490268107997341,
         0.021703194535981,
         -0.0552310716626357,
         0.0230129465260971,
         0.0306212856916939,
         -0.0506204737391295,
         0.021455165913059,
         0.0268630131808037,
         -0.0497905430180672,
         0.0268630131808036,
         0.021455165913059,
         -0.0506204737391297,
         0.0306212856916942,
         0.0230129465260975,
         -0.0552310716626358,
         0.0217031945359809,
         0.0490268107997342,
         -0.0517033900004073,
         -0.0703594019295085,
         0.0537378808656328,
         0.0718102638894545,
         -0.0143994702606091,
         -0.0534927873541925,
         0.0370988650303509,
         0.0230129465260975,
         -0.0517286380776755,
         0.0237050399587888,
         0.0268630131808036,
         -0.0494150765038993,
         0.0240734177731493,
         0.0240734177731491,
         -0.0494150765038995,
         0.0268630131808036,
         0.023705039958789,
         -0.0517286380776756,
         0.023012946526097,
         0.0370988650303508,
         -0.0534927873541923,
         -0.0143994702606091,
         0.0718102638894545,
         0.0537378808656326,
         -0.0356456775720245,
         -0.0752330332118855,
         -0.0280096052068142,
         0.0561854588639112,
         0.00602866514888334,
         -0.0522038045263829,
         0.0306212856916942,
         0.0237050399587889,
         -0.0497905430180671,
         0.0240734177731494,
         0.0248649111070618,
         -0.048784569764162,
         0.0248649111070618,
         0.024073417773149,
         -0.0497905430180673,
         0.0237050399587889,
         0.0306212856916939,
         -0.0522038045263827,
         0.00602866514888349,
         0.0561854588639113,
         -0.0280096052068139,
         -0.0752330332118856,
         -0.0356456775720244,
         0.0194816362349433,
         0.0633234617365581,
         0.0618040047503039,
         -0.026938942133122,
         -0.046682675344688,
         0.0423620810650817,
         0.0161391527321521,
         -0.0506204737391296,
         0.0268630131808036,
         0.0240734177731491,
         -0.048784569764162,
         0.0242354196866188,
         0.0242354196866184,
         -0.048784569764162,
         0.0240734177731494,
         0.0268630131808036,
         -0.0506204737391295,
         0.0161391527321521,
         0.0423620810650819,
         -0.0466826753446879,
         -0.0269389421331219,
         0.061804004750304,
         0.063323461736558,
         0.0194816362349432,
         -0.00764132640913018,
         -0.0420272952502161,
         -0.0745859903847716,
         -0.0204322423548484,
         0.0571438322769733,
         0.00116281054051758,
         -0.0507177740267302,
         0.0327597826716313,
         0.0214551659130591,
         -0.0494150765038996,
         0.0248649111070618,
         0.0242354196866184,
         -0.0484708393732366,
         0.0242354196866189,
         0.0248649111070618,
         -0.0494150765038989,
         0.0214551659130591,
         0.0327597826716315,
         -0.0507177740267302,
         0.00116281054051759,
         0.0571438322769733,
         -0.0204322423548483,
         -0.0745859903847714,
         -0.042027295250216,
         -0.00764132640913014,
         0.0194816362349433,
         0.0633234617365581,
         0.0618040047503041,
         -0.0269389421331221,
         -0.0466826753446879,
         0.0423620810650818,
         0.0161391527321521,
         -0.0506204737391298,
         0.0268630131808037,
         0.0240734177731491,
         -0.0487845697641622,
         0.024235419686619,
         0.0242354196866184,
         -0.0487845697641622,
         0.0240734177731495,
         0.0268630131808036,
         -0.0506204737391296,
         0.0161391527321521,
         0.0423620810650817,
         -0.0466826753446878,
         -0.026938942133122,
         0.0618040047503039,
         0.0633234617365581,
         0.0194816362349433,
         -0.0356456775720245,
         -0.0752330332118856,
         -0.0280096052068143,
         0.0561854588639113,
         0.0060286651488833,
         -0.0522038045263829,
         0.030621285691694,
         0.0237050399587891,
         -0.0497905430180671,
         0.0240734177731496,
         0.0248649111070618,
         -0.0487845697641621,
         0.0248649111070617,
         0.024073417773149,
         -0.0497905430180673,
         0.0237050399587889,
         0.0306212856916938,
         -0.0522038045263829,
         0.00602866514888337,
         0.0561854588639112,
         -0.0280096052068142,
         -0.0752330332118855,
         -0.0356456775720245,
         0.0537378808656329,
         0.0718102638894545,
         -0.0143994702606092,
         -0.0534927873541926,
         0.0370988650303509,
         0.0230129465260976,
         -0.0517286380776757,
         0.0237050399587888,
         0.0268630131808037,
         -0.0494150765038989,
         0.0240734177731495,
         0.0240734177731489,
         -0.0494150765038994,
         0.0268630131808036,
         0.0237050399587892,
         -0.0517286380776758,
         0.023012946526097,
         0.0370988650303507,
         -0.0534927873541926,
         -0.0143994702606093,
         0.0718102638894542,
         0.0537378808656327,
         -0.0703594019295086,
         -0.0517033900004071,
         0.0490268107997342,
         0.021703194535981,
         -0.0552310716626357,
         0.0230129465260971,
         0.0306212856916939,
         -0.0506204737391295,
         0.0214551659130591,
         0.0268630131808037,
         -0.0497905430180672,
         0.0268630131808037,
         0.021455165913059,
         -0.0506204737391296,
         0.030621285691694,
         0.0230129465260977,
         -0.0552310716626357,
         0.021703194535981,
         0.0490268107997342,
         -0.0517033900004071,
         -0.0703594019295086,
         0.0820524576002102,
         0.0188241247762353,
         -0.0623090522228752,
         0.0217031945359809,
         0.0370988650303509,
         -0.0522038045263829,
         0.016139152732152,
         0.0327597826716316,
         -0.0506204737391295,
         0.0237050399587889,
         0.0237050399587891,
         -0.0506204737391296,
         0.0327597826716312,
         0.016139152732152,
         -0.0522038045263828,
         0.0370988650303508,
         0.0217031945359811,
         -0.062309052222875,
         0.0188241247762352,
         0.0820524576002101,
         -0.0862629766783918,
         0.0188241247762352,
         0.0490268107997342,
         -0.0534927873541925,
         0.0060286651488834,
         0.0423620810650818,
         -0.0507177740267302,
         0.0161391527321522,
         0.0306212856916941,
         -0.0517286380776757,
         0.0306212856916939,
         0.016139152732152,
         -0.0507177740267302,
         0.0423620810650817,
         0.0060286651488834,
         -0.0534927873541926,
         0.049026810799734,
         0.0188241247762352,
         -0.0862629766783917,
         0.0820524576002101,
         -0.0517033900004073,
         -0.0143994702606092,
         0.0561854588639113,
         -0.0466826753446878,
         0.00116281054051753,
         0.0423620810650817,
         -0.0522038045263829,
         0.023012946526097,
         0.0230129465260977,
         -0.0522038045263828,
         0.0423620810650817,
         0.00116281054051763,
         -0.0466826753446879,
         0.0561854588639113,
         -0.0143994702606091,
         -0.0517033900004073,
         0.0820524576002103,
         -0.0703594019295088,
         0.0718102638894544,
         -0.0280096052068141,
         -0.0269389421331219,
         0.0571438322769732,
         -0.0466826753446878,
         0.00602866514888356,
         0.0370988650303508,
         -0.0552310716626357,
         0.0370988650303508,
         0.00602866514888345,
         -0.0466826753446879,
         0.0571438322769734,
         -0.0269389421331221,
         -0.0280096052068141,
         0.0718102638894542,
         -0.0703594019295089,
         0.0537378808656325,
         -0.0752330332118854,
         0.0618040047503041,
         -0.0204322423548482,
         -0.0269389421331219,
         0.0561854588639113,
         -0.0534927873541926,
         0.0217031945359811,
         0.0217031945359811,
         -0.0534927873541927,
         0.0561854588639113,
         -0.0269389421331218,
         -0.0204322423548482,
         0.0618040047503041,
         -0.0752330332118855,
         0.0537378808656326,
         -0.0356456775720244,
         0.0633234617365581,
         -0.0745859903847711,
         0.0618040047503041,
         -0.0280096052068141,
         -0.0143994702606092,
         0.0490268107997343,
         -0.0623090522228751,
         0.0490268107997342,
         -0.0143994702606092,
         -0.0280096052068141,
         0.0618040047503042,
         -0.0745859903847712,
         0.0633234617365581,
         -0.0356456775720244,
         0.0194816362349434,
         -0.042027295250216,
         0.0633234617365581,
         -0.0752330332118854,
         0.0718102638894544,
         -0.0517033900004072,
         0.0188241247762352,
         0.0188241247762352,
         -0.0517033900004072,
         0.0718102638894544,
         -0.0752330332118856,
         0.0633234617365581,
         -0.042027295250216,
         0.0194816362349434,
         -0.00764132640913025,
         0.0194816362349434,
         -0.0356456775720245,
         0.0537378808656325,
         -0.0703594019295087,
         0.0820524576002102,
         -0.0862629766783919,
         0.08205245760021,
         -0.0703594019295087,
         0.0537378808656326,
         -0.0356456775720245,
         0.0194816362349434,
         -0.00764132640913023},
        {1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {-0.447213595499958,
         0.447213595499958,
         -0.447213595499958,
         0.447213595499958,
         -0.447213595499958},
        {0.447213595499958,
         -0.316227766016838,
         0.182574185835055,
         -0.316227766016838,
         0.365148371670111,
         -0.316227766016838,
         0.182574185835055,
         -0.316227766016838,
         0.447213595499958},
        {0.239045721866879,
         -0.29277002188456,
         0.239045721866879,
         -0.29277002188456,
         0.119522860933439,
         0.119522860933439,
         -0.29277002188456,
         0.239045721866879,
         0.119522860933439,
         -0.239045721866879,
         0.119522860933439,
         0.239045721866879,
         -0.29277002188456,
         0.119522860933439,
         0.119522860933439,
         -0.29277002188456,
         0.239045721866879,
         -0.29277002188456,
         0.239045721866879},
        {-0.330554641960247,
         0.140294070099267,
         0.190260571860981,
         -0.252764426053122,
         0.112470355953854,
         -0.302730927814835,
         0.190260571860979,
         0.140294070099266,
         0.112470355953855,
         -0.4430249979141,
         0.112470355953855,
         0.140294070099266,
         0.190260571860979,
         -0.302730927814835,
         0.112470355953856,
         -0.252764426053122,
         0.190260571860979,
         0.140294070099266,
         -0.330554641960247},
        {0.229574054183946,
         -0.32102255280716,
         0.0914484986232151,
         0.0860043829612314,
         0.235018169845929,
         -0.326466668469144,
         0.0914484986232149,
         -0.32102255280716,
         0.235018169845929,
         -0.00544411566198335,
         0.235018169845929,
         -0.321022552807161,
         0.0914484986232151,
         -0.326466668469144,
         0.235018169845929,
         0.0860043829612313,
         0.0914484986232149,
         -0.32102255280716,
         0.229574054183945},
        {0.139550865339032,
         -0.170914206622238,
         0.139550865339032,
         -0.195563787977642,
         0.140838383153849,
         -0.0421610199521685,
         -0.0461454010297642,
         0.343688452212849,
         -0.20540397157933,
         0.124090893153224,
         -0.0997492169345304,
         0.132378942923249,
         -0.0461454010297643,
         -0.0421610199521685,
         0.140838383153849,
         -0.195563787977642,
         -0.0671194909458113,
         0.238033697568049,
         -0.295005099775462,
         0.238033697568049,
         -0.0671194909458113,
         -0.195563787977642,
         0.140838383153849,
         -0.0421610199521685,
         -0.0461454010297643,
         0.132378942923249,
         -0.0997492169345304,
         0.124090893153224,
         -0.20540397157933,
         0.343688452212849,
         -0.0461454010297643,
         -0.0421610199521685,
         0.140838383153849,
         -0.195563787977642,
         0.139550865339032,
         -0.170914206622238,
         0.139550865339032},
        {0.0418771008407753,
         -0.0512887644834881,
         0.0418771008407753,
         -0.178651996724072,
         0.189191534770729,
         -0.159579952789784,
         0.106118730394164,
         0.0633031632216659,
         0.0630228751344417,
         -0.172252658662721,
         0.26438618736317,
         -0.33942346123579,
         0.106118730394163,
         -0.159579952789784,
         0.189191534770729,
         -0.178651996724072,
         0.18934891349055,
         -0.138060149007062,
         0.120963894179232,
         -0.138060149007062,
         0.18934891349055,
         -0.178651996724072,
         0.189191534770729,
         -0.159579952789784,
         0.106118730394163,
         -0.33942346123579,
         0.26438618736317,
         -0.172252658662721,
         0.0630228751344417,
         0.0633031632216663,
         0.106118730394163,
         -0.159579952789784,
         0.189191534770729,
         -0.178651996724072,
         0.0418771008407754,
         -0.0512887644834879,
         0.0418771008407751},
        {0.0314224920209405,
         -0.153438999343136,
         0.122016507322196,
         0.147843754324332,
         0.00685274764096061,
         -0.127611752341,
         -0.0437451845398178,
         -0.127494189462783,
         0.120641441821822,
         0.0291084275752915,
         0.0483431784978582,
         -0.00459799395804068,
         0.108696563742554,
         -0.207199888508264,
         0.178091460932972,
         0.122016507322196,
         -0.153438999343136,
         0.00685274764096045,
         0.0230296244927333,
         0.00685274764096054,
         -0.127494189462783,
         -8.8767175767699e-05,
         -0.0285361023357705,
         0.120641441821822,
         -0.00459799395804075,
         0.204491033174629,
         -0.100303696214347,
         0.0303364737844088,
         -0.207199888508263,
         -0.0437451845398175,
         -0.127494189462783,
         0.120641441821822,
         0.0291084275752916,
         -0.127611752341,
         0.00685274764096049,
         0.147843754324331,
         0.120641441821822,
         -0.0285361023357703,
         -8.87671757679324e-05,
         -0.127494189462783,
         0.108696563742554,
         -0.100303696214347,
         0.128928565725885,
         -0.100303696214347,
         0.108696563742554,
         -0.127494189462783,
         -8.87671757678279e-05,
         -0.0285361023357702,
         0.120641441821822,
         0.147843754324331,
         0.00685274764096057,
         -0.127611752341,
         0.0291084275752915,
         0.120641441821822,
         -0.127494189462783,
         -0.0437451845398174,
         -0.207199888508263,
         0.0303364737844085,
         -0.100303696214347,
         0.204491033174628,
         -0.00459799395804067,
         0.120641441821822,
         -0.0285361023357705,
         -8.87671757676123e-05,
         -0.127494189462783,
         0.00685274764096064,
         0.0230296244927332,
         0.00685274764096047,
         -0.153438999343136,
         0.122016507322196,
         0.178091460932972,
         -0.207199888508263,
         0.108696563742554,
         -0.00459799395804062,
         0.0483431784978581,
         0.0291084275752914,
         0.120641441821822,
         -0.127494189462783,
         -0.0437451845398174,
         -0.127611752341,
         0.00685274764096041,
         0.147843754324331,
         0.122016507322196,
         -0.153438999343136,
         0.0314224920209404},
        {0.279560907994314,
         -0.0988080568027534,
         -0.180752851191561,
         0.0299181452211407,
         0.0843725659002002,
         0.111862939609948,
         0.0404865442198233,
         -0.0862277823147385,
         0.00185521641453844,
         -0.1133777174693,
         -0.136221291039088,
         0.0957347468192648,
         -0.0253300573783005,
         0.023815279518949,
         0.089562437950351,
         -0.180752851191561,
         -0.0988080568027535,
         0.0843725659002,
         0.176226040621896,
         0.0843725659002002,
         -0.0862277823147382,
         -0.0276459784321134,
         -0.217469973771395,
         0.0018552164145382,
         0.0957347468192645,
         -0.0306142568776422,
         0.128664924750719,
         0.0872902711613236,
         0.0238152795189494,
         0.0404865442198233,
         -0.0862277823147384,
         0.00185521641453819,
         -0.1133777174693,
         0.111862939609949,
         0.0843725659002001,
         0.0299181452211408,
         0.00185521641453829,
         -0.217469973771395,
         -0.0276459784321133,
         -0.0862277823147383,
         -0.0253300573783006,
         0.12866492475072,
         0.116451027452789,
         0.12866492475072,
         -0.0253300573783007,
         -0.0862277823147384,
         -0.0276459784321131,
         -0.217469973771395,
         0.00185521641453839,
         0.0299181452211407,
         0.0843725659002001,
         0.111862939609949,
         -0.1133777174693,
         0.00185521641453813,
         -0.0862277823147384,
         0.0404865442198234,
         0.0238152795189492,
         0.0872902711613236,
         0.12866492475072,
         -0.0306142568776418,
         0.0957347468192648,
         0.00185521641453843,
         -0.217469973771395,
         -0.0276459784321132,
         -0.0862277823147384,
         0.0843725659002002,
         0.176226040621896,
         0.0843725659002,
         -0.0988080568027534,
         -0.180752851191561,
         0.0895624379503511,
         0.0238152795189492,
         -0.0253300573783008,
         0.0957347468192651,
         -0.136221291039088,
         -0.1133777174693,
         0.0018552164145385,
         -0.0862277823147388,
         0.0404865442198233,
         0.111862939609949,
         0.0843725659002002,
         0.029918145221141,
         -0.180752851191561,
         -0.0988080568027535,
         0.279560907994315},
        {-0.0323047669213212,
         0.0826418876615202,
         -0.0503371207401988,
         -0.179049122373357,
         0.118074266278367,
         -0.0460701139716375,
         0.235042168013193,
         -0.0685771954809846,
         -0.0494970707973819,
         0.0864843030436375,
         -0.126637778133198,
         -0.108404389879995,
         0.164397435519831,
         -0.123983246447831,
         0.0374989434041937,
         -0.0503371207401989,
         0.0826418876615203,
         0.118074266278367,
         -0.176915618989076,
         0.118074266278367,
         -0.0685771954809852,
         0.118427838765357,
         -0.0379194544881171,
         -0.049497070797382,
         -0.108404389879995,
         -0.0426482096734433,
         -0.0197865834520766,
         0.0981202270121937,
         -0.123983246447831,
         0.235042168013193,
         -0.0685771954809848,
         -0.0494970707973821,
         0.0864843030436376,
         -0.0460701139716377,
         0.118074266278367,
         -0.179049122373357,
         -0.049497070797382,
         -0.0379194544881169,
         0.118427838765357,
         -0.0685771954809851,
         0.164397435519831,
         -0.0197865834520767,
         -0.0607218008251629,
         -0.0197865834520766,
         0.164397435519831,
         -0.0685771954809849,
         0.118427838765357,
         -0.0379194544881169,
         -0.0494970707973819,
         -0.179049122373357,
         0.118074266278367,
         -0.0460701139716377,
         0.0864843030436377,
         -0.0494970707973822,
         -0.0685771954809848,
         0.235042168013193,
         -0.123983246447831,
         0.0981202270121934,
         -0.0197865834520765,
         -0.0426482096734434,
         -0.108404389879994,
         -0.049497070797382,
         -0.0379194544881172,
         0.118427838765356,
         -0.0685771954809848,
         0.118074266278367,
         -0.176915618989076,
         0.118074266278367,
         0.0826418876615201,
         -0.0503371207401988,
         0.0374989434041934,
         -0.123983246447831,
         0.164397435519831,
         -0.108404389879995,
         -0.126637778133199,
         0.0864843030436374,
         -0.0494970707973819,
         -0.0685771954809848,
         0.235042168013193,
         -0.0460701139716378,
         0.118074266278366,
         -0.179049122373357,
         -0.0503371207401987,
         0.08264188766152,
         -0.0323047669213212},
        {0.16449148857074,
         -0.0736354021527284,
         -0.0908560864180115,
         0.0128994469443231,
         0.0743860496505641,
         0.030120131209606,
         -0.0673333253841183,
         0.0666676134490924,
         -0.141053663099657,
         0.0850497024385948,
         0.248885408599695,
         -0.181552083215576,
         0.127118204775781,
         -0.0119483711275803,
         -0.0731013313110144,
         -0.0908560864180118,
         -0.0736354021527287,
         0.0743860496505641,
         0.0733875557581317,
         0.0743860496505642,
         0.0666676134490924,
         -0.185654197416624,
         0.0515306864500869,
         -0.141053663099656,
         -0.181552083215577,
         0.167234590940002,
         -0.036014271963173,
         0.0996534191612868,
         -0.0119483711275804,
         -0.0673333253841182,
         0.0666676134490926,
         -0.141053663099657,
         0.0850497024385948,
         0.030120131209606,
         0.0743860496505643,
         0.0128994469443231,
         -0.141053663099657,
         0.0515306864500868,
         -0.185654197416624,
         0.0666676134490926,
         0.127118204775781,
         -0.0360142719631727,
         0.17013778292971,
         -0.0360142719631728,
         0.127118204775781,
         0.0666676134490923,
         -0.185654197416624,
         0.0515306864500866,
         -0.141053663099656,
         0.0128994469443228,
         0.0743860496505643,
         0.0301201312096061,
         0.0850497024385949,
         -0.141053663099657,
         0.0666676134490926,
         -0.0673333253841182,
         -0.0119483711275803,
         0.0996534191612869,
         -0.0360142719631729,
         0.167234590940002,
         -0.181552083215577,
         -0.141053663099657,
         0.0515306864500871,
         -0.185654197416624,
         0.0666676134490924,
         0.0743860496505641,
         0.0733875557581316,
         0.0743860496505644,
         -0.0736354021527287,
         -0.0908560864180117,
         -0.0731013313110146,
         -0.0119483711275802,
         0.127118204775781,
         -0.181552083215576,
         0.248885408599695,
         0.0850497024385948,
         -0.141053663099657,
         0.0666676134490923,
         -0.0673333253841182,
         0.0301201312096061,
         0.0743860496505639,
         0.0128994469443229,
         -0.0908560864180119,
         -0.0736354021527286,
         0.16449148857074},
        {-0.377964473009227,
         0.377964473009227,
         -0.377964473009227,
         0.377964473009227,
         -0.377964473009227,
         0.377964473009227,
         -0.377964473009227},
        {0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333},
        {-0.377964473009227,
         0.308606699924184,
         -0.239045721866879,
         0.169030850945703,
         -0.0975900072948533,
         0.218217890235992,
         -0.276026223736942,
         0.29277002188456,
         -0.276026223736942,
         0.218217890235992,
         -0.0975900072948533,
         0.169030850945703,
         -0.239045721866879,
         0.308606699924184,
         -0.377964473009227},
        {0.333333333333333,
         -0.288675134594813,
         0.243975018237133,
         -0.199204768222399,
         0.154303349962091,
         -0.109108945117996,
         0.0629940788348712,
         -0.166666666666667,
         0.218217890235993,
         -0.243975018237133,
         0.251976315339485,
         -0.243975018237133,
         0.218217890235993,
         -0.166666666666667,
         0.0629940788348712,
         -0.109108945117996,
         0.154303349962092,
         -0.199204768222399,
         0.243975018237133,
         -0.288675134594813,
         0.333333333333333},
        {-0.333333333333334,
         0.235702260395516,
         -0.154303349962092,
         0.0890870806374748,
         -0.0398409536444798,
         0.235702260395516,
         -0.251976315339485,
         0.218217890235992,
         -0.159363814577919,
         0.0890870806374748,
         -0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092,
         0.0890870806374748,
         -0.159363814577919,
         0.218217890235992,
         -0.251976315339485,
         0.235702260395516,
         -0.0398409536444798,
         0.0890870806374748,
         -0.154303349962092,
         0.235702260395516,
         -0.333333333333334},
        {-0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092,
         0.243975018237133,
         -0.188982236504614,
         0.0690065559342354,
         0.0690065559342357,
         -0.188982236504614,
         0.243975018237133,
         -0.243975018237133,
         0.14638501094228,
         -0.195180014589706,
         0.14638501094228,
         -0.243975018237133,
         0.243975018237133,
         -0.188982236504614,
         0.0690065559342354,
         0.0690065559342354,
         -0.188982236504614,
         0.243975018237133,
         -0.154303349962092,
         0.218217890235992,
         -0.239045721866879,
         0.218217890235992,
         -0.154303349962092},
        {0.110096376512636,
         -0.165144564768954,
         0.197385508487931,
         -0.20806259464412,
         0.197385508487931,
         -0.165144564768954,
         0.110096376512636,
         -0.205971460217775,
         0.194624736040381,
         -0.132410224425712,
         0.0465242105199236,
         0.0465242105199236,
         -0.132410224425713,
         0.194624736040381,
         -0.205971460217775,
         0.237835356004225,
         -0.0594588390010564,
         -0.0679529588583502,
         0.144400037573994,
         -0.169882397145875,
         0.144400037573993,
         -0.0679529588583502,
         -0.0594588390010564,
         0.237835356004225,
         -0.205971460217775,
         0.194624736040381,
         -0.132410224425712,
         0.0465242105199236,
         0.0465242105199236,
         -0.132410224425712,
         0.194624736040381,
         -0.205971460217775,
         0.110096376512636,
         -0.165144564768954,
         0.197385508487931,
         -0.20806259464412,
         0.197385508487931,
         -0.165144564768954,
         0.110096376512636},
        {0.174077655955698,
         -0.21320071635561,
         0.197385508487931,
         -0.147122471584125,
         0.080582296402538,
         -0.224733287487747,
         0.100503781525921,
         0.0465242105199236,
         -0.151947435279517,
         0.188025358272589,
         -0.147122471584125,
         0.174077655955698,
         0.100503781525921,
         -0.169882397145875,
         0.10403129732206,
         0.0268607654675126,
         -0.151947435279517,
         0.197385508487931,
         -0.21320071635561,
         0.0465242105199236,
         0.10403129732206,
         -0.161164592805076,
         0.10403129732206,
         0.0465242105199236,
         -0.21320071635561,
         0.197385508487931,
         -0.151947435279517,
         0.0268607654675126,
         0.10403129732206,
         -0.169882397145875,
         0.100503781525921,
         0.174077655955698,
         -0.147122471584125,
         0.188025358272589,
         -0.151947435279517,
         0.0465242105199236,
         0.100503781525921,
         -0.224733287487747,
         0.080582296402538,
         -0.147122471584125,
         0.197385508487931,
         -0.21320071635561,
         0.174077655955698},
        {0.104297703129124,
         -0.164909148306052,
         0.186989398001692,
         -0.164909148306051,
         0.104297703129124,
         -0.164909148306051,
         0.156446554693686,
         -0.0623297993338971,
         -0.0623297993338969,
         0.156446554693686,
         -0.164909148306051,
         0.186989398001691,
         -0.0623297993338972,
         -0.0819481953157405,
         0.141350698548044,
         -0.0819481953157404,
         -0.0623297993338971,
         0.186989398001692,
         -0.164909148306051,
         -0.0623297993338969,
         0.141350698548044,
         -0.0670485234401512,
         -0.067048523440151,
         0.141350698548044,
         -0.062329799333897,
         -0.164909148306051,
         0.104297703129124,
         0.156446554693686,
         -0.0819481953157405,
         -0.067048523440151,
         0.134097046880302,
         -0.0670485234401512,
         -0.0819481953157405,
         0.156446554693686,
         0.104297703129124,
         -0.164909148306051,
         -0.0623297993338972,
         0.141350698548044,
         -0.0670485234401511,
         -0.0670485234401511,
         0.141350698548044,
         -0.0623297993338969,
         -0.164909148306051,
         0.186989398001691,
         -0.062329799333897,
         -0.0819481953157406,
         0.141350698548044,
         -0.0819481953157403,
         -0.0623297993338972,
         0.186989398001692,
         -0.164909148306051,
         0.156446554693686,
         -0.0623297993338972,
         -0.0623297993338971,
         0.156446554693686,
         -0.164909148306051,
         0.104297703129124,
         -0.164909148306051,
         0.186989398001692,
         -0.164909148306052,
         0.104297703129124},
        {-0.377964473009227,
         0.218217890235992,
         -0.0975900072948534,
         0.218217890235992,
         -0.195180014589707,
         0.119522860933439,
         -0.0975900072948533,
         0.119522860933439,
         -0.0975900072948533,
         0.218217890235992,
         -0.195180014589707,
         0.119522860933439,
         -0.195180014589706,
         0.239045721866879,
         -0.195180014589707,
         0.119522860933439,
         -0.195180014589707,
         0.218217890235992,
         -0.0975900072948534,
         0.119522860933439,
         -0.0975900072948533,
         0.119522860933439,
         -0.195180014589707,
         0.218217890235992,
         -0.0975900072948534,
         0.218217890235992,
         -0.377964473009227},
        {0.333333333333333,
         -0.235702260395516,
         0.154303349962092,
         -0.0890870806374748,
         0.0398409536444798,
         -0.166666666666667,
         0.17817416127495,
         -0.154303349962092,
         0.112687233963802,
         -0.0629940788348712,
         0.0629940788348712,
         -0.0890870806374748,
         0.0975900072948533,
         -0.0890870806374746,
         0.0629940788348712,
         -0.166666666666667,
         0.17817416127495,
         -0.154303349962092,
         0.112687233963802,
         -0.0629940788348712,
         0.125988157669742,
         -0.178174161274949,
         0.195180014589707,
         -0.178174161274949,
         0.125988157669742,
         -0.0629940788348712,
         0.112687233963802,
         -0.154303349962092,
         0.17817416127495,
         -0.166666666666667,
         0.0629940788348712,
         -0.0890870806374748,
         0.0975900072948533,
         -0.0890870806374748,
         0.0629940788348712,
         -0.0629940788348712,
         0.112687233963802,
         -0.154303349962092,
         0.17817416127495,
         -0.166666666666667,
         0.0398409536444798,
         -0.0890870806374748,
         0.154303349962092,
         -0.235702260395516,
         0.333333333333333},
        {0.00629761294187317,
         -0.0089061696329733,
         0.00975622001789405,
         -0.0089061696329733,
         0.00629761294187317,
         -0.106111607355935,
         0.133353567515703,
         -0.142098553960582,
         0.138115593816888,
         -0.122445781933975,
         0.0920297167219238,
         0.3218330294255,
         -0.260569464354407,
         0.200931935952964,
         -0.142920444221169,
         0.0865349891590232,
         -0.0317755707665266,
         -0.0213578109563213,
         0.0920297167219238,
         -0.122445781933975,
         0.138115593816888,
         -0.142098553960582,
         0.133353567515703,
         -0.106111607355935,
         -0.138042334212222,
         0.146172517560467,
         -0.151050627569414,
         0.152676664239063,
         -0.151050627569414,
         0.146172517560467,
         -0.138042334212222,
         -0.106111607355935,
         0.133353567515703,
         -0.142098553960582,
         0.138115593816888,
         -0.122445781933975,
         0.0920297167219238,
         -0.0213578109563213,
         -0.0317755707665265,
         0.0865349891590232,
         -0.142920444221169,
         0.200931935952964,
         -0.260569464354407,
         0.3218330294255,
         0.0920297167219239,
         -0.122445781933975,
         0.138115593816888,
         -0.142098553960582,
         0.133353567515703,
         -0.106111607355935,
         0.00629761294187297,
         -0.0089061696329733,
         0.00975622001789405,
         -0.00890616963297335,
         0.00629761294187315},
        {-0.131518899557005,
         0.185995811461902,
         -0.203748203078323,
         0.185995811461902,
         -0.131518899557005,
         0.190339347498884,
         -0.169794568934294,
         0.102820775502548,
         -0.0196409199107381,
         -0.0580028472539878,
         0.103745852236548,
         -0.0703012584195532,
         -0.0395912150963049,
         0.115525654765776,
         -0.15750206058886,
         0.165520432565556,
         -0.139580770695865,
         0.0796830749797875,
         0.103745852236548,
         -0.0580028472539878,
         -0.0196409199107381,
         0.102820775502548,
         -0.169794568934294,
         0.190339347498884,
         -0.259376162128021,
         0.0895859928960853,
         0.0122881086430765,
         -0.0462461424894635,
         0.0122881086430765,
         0.0895859928960853,
         -0.259376162128021,
         0.190339347498884,
         -0.169794568934294,
         0.102820775502548,
         -0.0196409199107381,
         -0.0580028472539878,
         0.103745852236548,
         0.0796830749797875,
         -0.139580770695865,
         0.165520432565556,
         -0.15750206058886,
         0.115525654765776,
         -0.039591215096305,
         -0.0703012584195531,
         0.103745852236547,
         -0.0580028472539878,
         -0.0196409199107381,
         0.102820775502548,
         -0.169794568934294,
         0.190339347498884,
         -0.131518899557005,
         0.185995811461902,
         -0.203748203078323,
         0.185995811461902,
         -0.131518899557005},
        {0.00461215195233148,
         -0.00691822792849727,
         0.00826886394603592,
         -0.00871614791050731,
         0.00826886394603601,
         -0.00691822792849718,
         0.00461215195233141,
         0.0588673996388299,
         -0.0801803258628643,
         0.0935307882045493,
         -0.101346395341074,
         0.104102683323086,
         -0.101375321324006,
         0.0917107057436931,
         -0.07107000671354,
         0.0254650717155998,
         -0.0548987715350147,
         0.0852040861454802,
         -0.116381015546997,
         0.148429559739564,
         -0.181349718723182,
         0.21514149249785,
         -0.249804881063569,
         0.28533988442034,
         -0.0710700067135399,
         0.0917107057436928,
         -0.101375321324005,
         0.104102683323086,
         -0.101346395341074,
         0.0935307882045493,
         -0.0801803258628645,
         0.0588673996388298,
         -0.143199870993259,
         0.149301174530614,
         -0.153659248485868,
         0.15627409285902,
         -0.157145707650071,
         0.15627409285902,
         -0.153659248485868,
         0.149301174530614,
         -0.143199870993259,
         0.0588673996388298,
         -0.0801803258628646,
         0.0935307882045492,
         -0.101346395341074,
         0.104102683323086,
         -0.101375321324006,
         0.0917107057436929,
         -0.0710700067135399,
         0.285339884420339,
         -0.249804881063569,
         0.21514149249785,
         -0.181349718723182,
         0.148429559739564,
         -0.116381015546997,
         0.0852040861454803,
         -0.0548987715350146,
         0.0254650717156,
         -0.07107000671354,
         0.0917107057436928,
         -0.101375321324005,
         0.104102683323086,
         -0.101346395341074,
         0.0935307882045491,
         -0.0801803258628643,
         0.05886739963883,
         0.00461215195233144,
         -0.00691822792849733,
         0.00826886394603591,
         -0.00871614791050725,
         0.00826886394603592,
         -0.0069182279284972,
         0.00461215195233134},
        {-0.0902367406649113,
         0.135355110997367,
         -0.161780301083685,
         0.170531410657417,
         -0.161780301083685,
         0.135355110997367,
         -0.0902367406649113,
         0.0741619485301488,
         -0.0529886659449172,
         0.00892407640077269,
         0.0445199645479619,
         -0.0984467315758572,
         0.144554193190903,
         -0.172603185717361,
         0.164582026390236,
         0.0839379983390505,
         -0.121018972604125,
         0.141046805803457,
         -0.144021497937048,
         0.129943049004898,
         -0.0988114590070049,
         0.0506267279433707,
         0.0146111441860054,
         -0.0969021573811231,
         0.164582026390236,
         -0.172603185717361,
         0.144554193190903,
         -0.0984467315758571,
         0.0445199645479619,
         0.00892407640077254,
         -0.0529886659449173,
         0.0741619485301487,
         -0.232261895399348,
         0.112889907939156,
         -0.0276242026104469,
         -0.0235352205867779,
         0.04058836165252,
         -0.0235352205867777,
         -0.0276242026104469,
         0.112889907939156,
         -0.232261895399348,
         0.0741619485301487,
         -0.0529886659449172,
         0.00892407640077262,
         0.0445199645479621,
         -0.0984467315758573,
         0.144554193190903,
         -0.172603185717361,
         0.164582026390236,
         -0.0969021573811231,
         0.0146111441860053,
         0.0506267279433706,
         -0.0988114590070047,
         0.129943049004898,
         -0.144021497937048,
         0.141046805803458,
         -0.121018972604124,
         0.0839379983390503,
         0.164582026390236,
         -0.172603185717361,
         0.144554193190903,
         -0.0984467315758571,
         0.044519964547962,
         0.00892407640077267,
         -0.0529886659449175,
         0.0741619485301488,
         -0.0902367406649111,
         0.135355110997367,
         -0.161780301083685,
         0.170531410657417,
         -0.161780301083685,
         0.135355110997367,
         -0.0902367406649111},
        {0.145701041627445,
         -0.145701041627445,
         0.0921494298003463,
         -0.108348503939194,
         -0.0106158983872236,
         0.100372469332096,
         -0.111152570289013,
         0.140794017205128,
         -0.00660932972387322,
         0.0133426043217803,
         -0.0804086997037832,
         0.125020720616843,
         -0.140794017205128,
         0.0941655198486589,
         -0.0760197236335629,
         0.110611598912157,
         -0.166797551415061,
         0.089045955058628,
         -0.10577719435635,
         0.118685779327821,
         -0.161890526992744,
         0.268372692211677,
         -0.0991336830807997,
         0.0150131474759861,
         0.0535303526645688,
         -0.0685256107039156,
         -0.0906344674673665,
         0.217500084007143,
         -0.173222414718888,
         0.0506040915660651,
         0.0557248406996792,
         0.00934700373369671,
         -0.171430622741334,
         0.238259404539961,
         -0.171430622741334,
         0.00934700373369696,
         0.0557248406996789,
         0.0506040915660651,
         -0.173222414718888,
         0.217500084007143,
         -0.0906344674673664,
         -0.0685256107039154,
         0.0535303526645686,
         0.015013147475986,
         -0.0991336830807999,
         0.268372692211677,
         -0.161890526992744,
         0.118685779327821,
         -0.10577719435635,
         0.0890459550586278,
         -0.166797551415061,
         0.110611598912157,
         -0.076019723633563,
         0.0941655198486589,
         -0.140794017205128,
         0.125020720616843,
         -0.0804086997037832,
         0.0133426043217801,
         -0.00660932972387323,
         0.140794017205128,
         -0.111152570289013,
         0.100372469332096,
         -0.0106158983872234,
         -0.108348503939193,
         0.0921494298003461,
         -0.145701041627445,
         0.145701041627445},
        {0.113561262045324,
         -0.113561262045324,
         0.0718224484052908,
         -0.222510158900342,
         0.129787776714498,
         -0.0287107311460163,
         -0.0248905615648688,
         0.171461582174879,
         0.0825123632940948,
         -0.164446981330156,
         0.136583128330383,
         -0.0612560210382478,
         -0.171461582174879,
         0.0445280243988999,
         0.0847955076389089,
         -0.156538334703715,
         0.146452245625916,
         0.108441826177749,
         -0.088317184408325,
         0.0134929708290343,
         0.0885519254963612,
         -0.191880102225093,
         0.117983008848512,
         -0.183547634059894,
         0.19296152629875,
         -0.140727780930213,
         0.0176967126096192,
         0.0176842714667482,
         0.0443446805003308,
         -0.131041706534831,
         0.167067715953013,
         -0.116690103233965,
         0.0232024728858455,
         0.0193721487907657,
         0.0232024728858451,
         -0.116690103233965,
         0.167067715953013,
         -0.131041706534831,
         0.0443446805003309,
         0.0176842714667482,
         0.0176967126096191,
         -0.140727780930214,
         0.19296152629875,
         -0.183547634059893,
         0.117983008848513,
         -0.191880102225093,
         0.0885519254963607,
         0.0134929708290341,
         -0.088317184408325,
         0.108441826177749,
         0.146452245625916,
         -0.156538334703714,
         0.0847955076389089,
         0.0445280243989001,
         -0.171461582174879,
         -0.061256021038248,
         0.136583128330383,
         -0.164446981330156,
         0.0825123632940949,
         0.171461582174879,
         -0.0248905615648689,
         -0.0287107311460164,
         0.129787776714498,
         -0.222510158900342,
         0.0718224484052913,
         -0.113561262045324,
         0.113561262045324},
        {0.00213215183529186,
         -0.0026113420253016,
         0.00241763293440539,
         -0.00180199719532426,
         0.000986994512439913,
         0.0876954631576592,
         -0.0995541674906814,
         0.0935650703044763,
         -0.077535243092759,
         0.0556315738166391,
         -0.030912065253534,
         -0.204573985520034,
         0.101219769522605,
         -0.0203728176926177,
         -0.0373854825371492,
         0.0714264718948124,
         -0.080976810521939,
         0.064599072548294,
         0.177166268413779,
         -0.182246441608904,
         0.147600729143969,
         -0.0938541610637202,
         0.0335772306946142,
         0.0217249932431757,
         -0.0565123665408225,
         -0.0946993538425133,
         0.140586493905574,
         -0.165418715962763,
         0.170105643236898,
         -0.154719134444523,
         0.119149037414282,
         -0.0632258156353152,
         -0.128787749798215,
         0.142923005691376,
         -0.131333996876542,
         0.106427881764468,
         -0.0746860353555293,
         0.0405951112251119,
         0.202439539045209,
         -0.128098823906318,
         0.0694956445037637,
         -0.0260198730336933,
         -0.00292229196855124,
         0.017874734564516,
         -0.0191526800148711,
         -0.0730307907835455,
         0.0934127636990735,
         -0.102958153029966,
         0.105825041436425,
         -0.102958153029966,
         0.0934127636990735,
         -0.0730307907835453,
         -0.0191526800148712,
         0.017874734564516,
         -0.00292229196855127,
         -0.0260198730336935,
         0.0694956445037637,
         -0.128098823906318,
         0.202439539045209,
         0.0405951112251121,
         -0.0746860353555297,
         0.106427881764468,
         -0.131333996876542,
         0.142923005691376,
         -0.128787749798215,
         -0.0632258156353154,
         0.119149037414282,
         -0.154719134444523,
         0.170105643236898,
         -0.165418715962762,
         0.140586493905574,
         -0.0946993538425133,
         -0.0565123665408227,
         0.0217249932431754,
         0.0335772306946141,
         -0.0938541610637202,
         0.147600729143969,
         -0.182246441608904,
         0.177166268413779,
         0.0645990725482938,
         -0.0809768105219391,
         0.0714264718948122,
         -0.0373854825371491,
         -0.0203728176926177,
         0.101219769522604,
         -0.204573985520034,
         -0.030912065253534,
         0.0556315738166392,
         -0.0775352430927587,
         0.0935650703044762,
         -0.0995541674906811,
         0.0876954631576591,
         0.000986994512440044,
         -0.00180199719532411,
         0.00241763293440538,
         -0.0026113420253016,
         0.00213215183529181},
        {-0.14199038197746,
         0.173901992113827,
         -0.161001959689469,
         0.120003775458778,
         -0.0657287748045574,
         0.19800030349185,
         -0.120968707127152,
         0.0190407357350443,
         0.060350356027819,
         -0.0963414658907828,
         0.0821631957996495,
         -0.117947311280878,
         -0.0693279249036595,
         0.137785398865415,
         -0.123494480977571,
         0.0626031622850277,
         0.00850127351603132,
         -0.052345155765343,
         0.102145367877311,
         -0.0214840595059508,
         -0.0635371646293621,
         0.11685638905376,
         -0.124805733895296,
         0.0881164891042747,
         -0.0234178346764504,
         -0.0545989957489833,
         0.0416504276692073,
         -0.0010366160024467,
         -0.0514568066030965,
         0.100848293835772,
         -0.132332609239357,
         0.131162311050786,
         0.0374854317005992,
         0.0290852042644969,
         -0.0926564415186193,
         0.129320987597372,
         -0.129392273106759,
         0.0916563303669101,
         -0.138655849807319,
         -0.00542686638066629,
         0.0347617172253728,
         0.00894893023891231,
         -0.08385037365836,
         0.147622998038268,
         -0.155825118083268,
         0.179053143956897,
         -0.0874615873456065,
         -0.000808134844430322,
         0.0347768314363475,
         -0.000808134844430577,
         -0.0874615873456065,
         0.179053143956897,
         -0.155825118083268,
         0.147622998038268,
         -0.0838503736583599,
         0.00894893023891193,
         0.0347617172253727,
         -0.00542686638066607,
         -0.138655849807319,
         0.0916563303669098,
         -0.129392273106759,
         0.129320987597372,
         -0.0926564415186192,
         0.029085204264497,
         0.0374854317005994,
         0.131162311050785,
         -0.132332609239357,
         0.100848293835772,
         -0.0514568066030963,
         -0.00103661600244668,
         0.0416504276692072,
         -0.0545989957489832,
         -0.0234178346764504,
         0.0881164891042749,
         -0.124805733895296,
         0.116856389053759,
         -0.0635371646293617,
         -0.0214840595059509,
         0.102145367877311,
         -0.0523451557653428,
         0.00850127351603135,
         0.0626031622850277,
         -0.123494480977571,
         0.137785398865415,
         -0.0693279249036592,
         -0.117947311280878,
         0.0821631957996497,
         -0.096341465890783,
         0.0603503560278191,
         0.0190407357350442,
         -0.120968707127152,
         0.198000303491849,
         -0.0657287748045574,
         0.120003775458778,
         -0.161001959689469,
         0.173901992113827,
         -0.14199038197746},
        {-0.124446632671581,
         0.160659911942875,
         -0.124446632671581,
         0.127264791889408,
         -0.0555329620310095,
         -0.0689136706405718,
         0.136726381684311,
         -0.118097938901699,
         0.00271756703434875,
         0.0525560164985192,
         0.0149324269357831,
         -0.135372359436795,
         0.117624265704226,
         0.0151634328223111,
         -0.0195876539444786,
         -0.0329683625540405,
         0.0151634328223109,
         0.136547445294031,
         -0.110812869792083,
         -0.0555329620310094,
         0.0389222536190216,
         -0.0193345996745429,
         0.0523029622285833,
         -0.0689136706405713,
         -0.124193578401645,
         0.143058799750063,
         -0.0552799077610741,
         0.0149324269357833,
         0.00271756703434872,
         -0.0552799077610737,
         0.160333220285159,
         -0.110812869792083,
         0.117445329313946,
         -0.117771247243983,
         0.126906919108849,
         -0.124193578401645,
         0.0844016646858089,
         -0.0475126820128577,
         -0.024336614859822,
         0.0680137104406626,
         -0.0476587829637249,
         -0.0904783293080254,
         0.160752304707313,
         -0.101403632138123,
         -0.0322080715283676,
         -0.0240444129580883,
         0.160752304707312,
         -0.0868323305346955,
         -0.0813696791196468,
         0.160752304707312,
         -0.0317697686757668,
         0.0677037835213752,
         -0.101610250084314,
         -0.0812663701465508,
         0.176095326918277,
         -0.081266370146551,
         -0.101610250084314,
         0.0677037835213753,
         -0.0317697686757666,
         0.160752304707312,
         -0.0813696791196467,
         -0.0868323305346957,
         0.160752304707312,
         -0.0240444129580883,
         -0.0322080715283674,
         -0.101403632138123,
         0.160752304707312,
         -0.0904783293080254,
         -0.0476587829637246,
         0.0680137104406627,
         -0.0243366148598222,
         -0.0475126820128576,
         0.084401664685809,
         -0.124193578401645,
         0.126906919108849,
         -0.117771247243984,
         0.117445329313946,
         -0.110812869792084,
         0.160333220285159,
         -0.0552799077610739,
         0.00271756703434887,
         0.0149324269357832,
         -0.0552799077610739,
         0.143058799750063,
         -0.124193578401645,
         -0.0689136706405715,
         0.0523029622285833,
         -0.0193345996745429,
         0.0389222536190216,
         -0.0555329620310095,
         -0.110812869792083,
         0.136547445294031,
         0.015163432822311,
         -0.0329683625540403,
         -0.0195876539444787,
         0.0151634328223111,
         0.117624265704226,
         -0.135372359436795,
         0.0149324269357833,
         0.0525560164985192,
         0.00271756703434878,
         -0.118097938901699,
         0.136726381684311,
         -0.0689136706405715,
         -0.0555329620310095,
         0.127264791889408,
         -0.124446632671581,
         0.160659911942875,
         -0.124446632671581},
        {-0.0829621066919146,
         0.107103619194689,
         -0.0829621066919144,
         0.147529334695133,
         -0.125675879281822,
         0.0427137725899079,
         0.0284598699749906,
         -0.163364657120396,
         0.0405729615949915,
         0.0812304267010869,
         -0.113145056372656,
         0.0540254486705623,
         0.12213067138104,
         0.0733624949387953,
         -0.124810039286409,
         0.0435796125853214,
         0.0733624949387952,
         -0.116008258059245,
         -0.0470429725669756,
         -0.125675879281822,
         0.0453112925761485,
         0.0794987467102597,
         -0.123078359295581,
         0.0427137725899079,
         0.121346679304754,
         0.0607322164359969,
         0.0786329067148464,
         -0.113145056372657,
         0.0405729615949913,
         0.0786329067148462,
         -0.156657889354962,
         -0.0470429725669759,
         -0.0223374566531958,
         0.100396851429255,
         -0.141406921373338,
         0.121346679304754,
         -0.0523134739172763,
         0.121880618939779,
         -0.169778813570894,
         0.15392088860804,
         0.00392288634679626,
         -0.0384104262576126,
         0.00387215417476586,
         0.0990791487592651,
         -0.190516735326985,
         0.0661366516150704,
         0.00387215417476574,
         0.0160239138473207,
         -0.052720873661118,
         0.00387215417476592,
         0.163356462451962,
         -0.096305249221621,
         -0.0677382764605093,
         0.0306878389487691,
         0.00424173237531417,
         0.030687838948769,
         -0.0677382764605092,
         -0.096305249221621,
         0.163356462451961,
         0.00387215417476602,
         -0.052720873661118,
         0.0160239138473208,
         0.00387215417476579,
         0.0661366516150705,
         -0.190516735326985,
         0.0990791487592649,
         0.00387215417476616,
         -0.0384104262576128,
         0.00392288634679637,
         0.15392088860804,
         -0.169778813570894,
         0.121880618939779,
         -0.0523134739172765,
         0.121346679304754,
         -0.141406921373338,
         0.100396851429255,
         -0.0223374566531953,
         -0.047042972566976,
         -0.156657889354962,
         0.0786329067148462,
         0.0405729615949913,
         -0.113145056372656,
         0.0786329067148462,
         0.0607322164359968,
         0.121346679304754,
         0.042713772589908,
         -0.123078359295581,
         0.0794987467102597,
         0.0453112925761487,
         -0.125675879281822,
         -0.047042972566976,
         -0.116008258059245,
         0.0733624949387952,
         0.0435796125853212,
         -0.124810039286409,
         0.0733624949387952,
         0.12213067138104,
         0.0540254486705623,
         -0.113145056372656,
         0.0812304267010873,
         0.0405729615949913,
         -0.163364657120396,
         0.0284598699749905,
         0.0427137725899079,
         -0.125675879281822,
         0.147529334695133,
         -0.0829621066919144,
         0.107103619194689,
         -0.0829621066919144},
        {-0.0738401778331153,
         0.116751572392261,
         -0.132383839596719,
         0.116751572392261,
         -0.0738401778331155,
         0.0656201959490605,
         -0.0398071700293545,
         -0.0288531769517985,
         0.105285022379321,
         -0.152035239440961,
         0.136599459297891,
         -0.0175841395517328,
         -0.0469894000918787,
         0.0898062744442841,
         -0.073158236795686,
         -0.0050437559189027,
         0.111725057748965,
         -0.176298597392576,
         -0.0329362227660769,
         0.0651066120162501,
         -0.0303202278190988,
         -0.0413661896684308,
         0.0980343162179488,
         -0.0890966418965213,
         -0.0126472752862578,
         0.172781226504902,
         0.0495573371810118,
         -0.00921886726524835,
         -0.0510581427674888,
         0.0758145051147329,
         -0.0437723923783553,
         -0.0321646624354342,
         0.104911765916086,
         -0.0932026642487118,
         -0.118410256785915,
         -0.0554067873603101,
         0.0496749592645501,
         -0.00575270352275622,
         -0.0481514569282547,
         0.0791032124077482,
         -0.0594079832552036,
         -0.0213043040842803,
         0.132386691703256,
         0.0362722567275634,
         -0.0528613555884137,
         0.0473778686552825,
         -0.0185729535541538,
         -0.0260926489414956,
         0.0700783348155716,
         -0.0866674336764221,
         0.119845631398123,
         -0.152572492502972,
         0.138231061504769,
         -0.0941031149725298,
         0.0418122257532983,
         -0.00309405900586235,
         -0.157541256483665,
         0.0997124254276062,
         -0.00425130526892785,
         -0.0657087456933843,
         0.0805851409550741,
         -0.0422461012700541,
         -0.0155827297860045,
         0.127200200104466,
         0.0166585010579333,
         -0.0854010214771506,
         0.0632538918342986,
         0.00634387361638662,
         -0.0614056509104468,
         0.0484013926261019,
         0.0432164031210024,
         -0.0555177435723824,
         -0.0838019377625083,
         0.0437711763508533,
         0.0360652082993421,
         -0.0719803244832741,
         0.0360652082993421,
         0.0437711763508531,
         -0.0838019377625083,
         -0.0555177435723823,
         0.0432164031210026,
         0.0484013926261019,
         -0.061405650910447,
         0.00634387361638653,
         0.0632538918342988,
         -0.0854010214771507,
         0.0166585010579332,
         0.127200200104466,
         -0.0155827297860043,
         -0.0422461012700541,
         0.0805851409550741,
         -0.0657087456933843,
         -0.00425130526892802,
         0.099712425427606,
         -0.157541256483665,
         -0.00309405900586229,
         0.0418122257532981,
         -0.09410311497253,
         0.138231061504769,
         -0.152572492502972,
         0.119845631398123,
         -0.0866674336764219,
         0.0700783348155715,
         -0.0260926489414959,
         -0.0185729535541538,
         0.0473778686552824,
         -0.0528613555884137,
         0.0362722567275634,
         0.132386691703256,
         -0.0213043040842802,
         -0.0594079832552034,
         0.079103212407748,
         -0.0481514569282548,
         -0.00575270352275615,
         0.0496749592645501,
         -0.0554067873603103,
         -0.118410256785915,
         -0.093202664248712,
         0.104911765916086,
         -0.0321646624354341,
         -0.0437723923783551,
         0.0758145051147332,
         -0.0510581427674888,
         -0.00921886726524851,
         0.049557337181012,
         0.172781226504902,
         -0.0126472752862579,
         -0.0890966418965214,
         0.0980343162179488,
         -0.0413661896684307,
         -0.030320227819099,
         0.06510661201625,
         -0.0329362227660769,
         -0.176298597392576,
         0.111725057748965,
         -0.0050437559189028,
         -0.0731582367956857,
         0.0898062744442839,
         -0.0469894000918788,
         -0.0175841395517324,
         0.136599459297891,
         -0.152035239440962,
         0.10528502237932,
         -0.0288531769517987,
         -0.0398071700293547,
         0.0656201959490604,
         -0.0738401778331155,
         0.116751572392261,
         -0.132383839596719,
         0.116751572392261,
         -0.0738401778331155},
        {0.0421153220157619,
         -0.0665901709806207,
         0.075506156646854,
         -0.0665901709806206,
         0.042115322015762,
         -0.0781228502687455,
         0.0870501333225552,
         -0.0604513099279556,
         0.0168578100624206,
         0.0223686829400808,
         -0.037214709154388,
         0.120685509746237,
         -0.0936842627208791,
         0.0384033204961525,
         0.00457709194884937,
         -0.0162624824966074,
         -0.00221087835602139,
         0.0292121253813794,
         -0.162860119080216,
         0.0676347276753249,
         0.010044200850582,
         -0.0419436972027265,
         0.0383982970243361,
         -0.0238309582851003,
         0.0228221043274486,
         -0.0442970621053283,
         0.17205654857244,
         0.027405547025278,
         -0.0900231373497369,
         0.081822081697085,
         -0.04933263354818,
         0.0195894405685842,
         -0.000131544608568836,
         -0.0209976182968893,
         0.0752502179281048,
         -0.192365069290985,
         0.122252409408325,
         -0.0407172059370229,
         -0.0192292156030719,
         0.0541126553187811,
         -0.0716408539331734,
         0.0813442682939671,
         -0.0841323013044575,
         0.125932498727338,
         -0.154537460632535,
         0.151597048083616,
         -0.133285312401754,
         0.109253099164013,
         -0.0836824817792702,
         0.0550775198740726,
         0.00213240393632215,
         -0.0244292876730242,
         0.0543673024147431,
         -0.0795360212970277,
         0.0876022706966669,
         -0.0687225749169429,
         -0.0354924528855624,
         0.0904533884827318,
         -0.125021612644515,
         0.120545810859711,
         -0.0761270320299465,
         0.00863710625401653,
         0.0463238293431525,
         0.0796203455578307,
         -0.125988803026479,
         0.101820131480662,
         -0.0269433410343577,
         -0.0597428228300133,
         0.115649607286995,
         -0.107694126153507,
         0.0312171802356633,
         -0.0957305127464347,
         0.0796459624061634,
         0.0114334795791087,
         -0.0979173357528743,
         0.13205131964123,
         -0.0979173357528744,
         0.0114334795791088,
         0.0796459624061634,
         -0.0957305127464348,
         0.0312171802356633,
         -0.107694126153507,
         0.115649607286995,
         -0.0597428228300136,
         -0.0269433410343579,
         0.101820131480662,
         -0.125988803026479,
         0.079620345557831,
         0.0463238293431528,
         0.00863710625401655,
         -0.0761270320299466,
         0.120545810859711,
         -0.125021612644515,
         0.0904533884827318,
         -0.0354924528855625,
         -0.0687225749169428,
         0.0876022706966668,
         -0.0795360212970278,
         0.0543673024147432,
         -0.0244292876730242,
         0.00213240393632212,
         0.0550775198740727,
         -0.0836824817792704,
         0.109253099164013,
         -0.133285312401754,
         0.151597048083616,
         -0.154537460632535,
         0.125932498727338,
         -0.0841323013044577,
         0.0813442682939672,
         -0.0716408539331733,
         0.0541126553187811,
         -0.019229215603072,
         -0.0407172059370229,
         0.122252409408325,
         -0.192365069290985,
         0.0752502179281047,
         -0.0209976182968893,
         -0.000131544608568717,
         0.0195894405685841,
         -0.0493326335481802,
         0.0818220816970852,
         -0.0900231373497369,
         0.0274055470252782,
         0.17205654857244,
         -0.0442970621053281,
         0.0228221043274485,
         -0.0238309582851002,
         0.0383982970243357,
         -0.0419436972027266,
         0.0100442008505819,
         0.0676347276753249,
         -0.162860119080216,
         0.0292121253813793,
         -0.00221087835602139,
         -0.0162624824966074,
         0.00457709194884921,
         0.0384033204961525,
         -0.093684262720879,
         0.120685509746237,
         -0.037214709154388,
         0.0223686829400806,
         0.0168578100624207,
         -0.0604513099279558,
         0.0870501333225549,
         -0.0781228502687455,
         0.042115322015762,
         -0.0665901709806208,
         0.0755061566468539,
         -0.0665901709806207,
         0.0421153220157621},
        {0.0047682083745901,
         -0.00412938958293287,
         0.00220725157654969,
         0.115491203700101,
         -0.103389948793713,
         0.069891861068664,
         -0.0339878476459756,
         -0.231232468438148,
         0.0634877301451885,
         0.0261221339076492,
         -0.0554337058455456,
         0.0434066177398231,
         0.20025319184722,
         -0.148602309084495,
         0.0707139621087443,
         -0.00836934103981342,
         -0.0200319005827246,
         -0.10703983350003,
         0.120510861719051,
         -0.0976307626346092,
         0.0572174540997882,
         -0.0175294380360605,
         -0.121331042452606,
         0.101704132555822,
         -0.0643737321272898,
         0.0293055599732864,
         0.167709576118739,
         -0.114459188960549,
         0.0758322348820316,
         -0.0463830321516636,
         0.0228371052840037,
         0.0182652930863707,
         0.0312322991613578,
         -0.0741278295673869,
         0.0907972242909834,
         -0.0725261804366747,
         -0.118997274665579,
         0.108115677213363,
         -0.050240156083449,
         -0.0184711380251619,
         0.0600235162623585,
         0.1065549146558,
         -0.149897703004087,
         0.148232238483333,
         -0.10384711135251,
         0.032794575656811,
         -0.0378679141668388,
         0.131852423928367,
         -0.152898657020289,
         0.125442272361828,
         -0.0721508059083078,
         -0.118464094479986,
         0.0677747650882673,
         -0.010834421948125,
         -0.0247601993571476,
         0.0308315213961102,
         0.0655955131328699,
         -0.0880837766306379,
         0.0947812131023201,
         -0.088083776630638,
         0.0655955131328698,
         0.0308315213961103,
         -0.0247601993571475,
         -0.0108344219481251,
         0.0677747650882674,
         -0.118464094479986,
         -0.0721508059083078,
         0.125442272361828,
         -0.152898657020289,
         0.131852423928367,
         -0.0378679141668391,
         0.0327945756568112,
         -0.10384711135251,
         0.148232238483333,
         -0.149897703004087,
         0.1065549146558,
         0.0600235162623589,
         -0.0184711380251615,
         -0.0502401560834491,
         0.108115677213363,
         -0.11899727466558,
         -0.0725261804366746,
         0.0907972242909833,
         -0.0741278295673873,
         0.0312322991613576,
         0.0182652930863709,
         0.0228371052840039,
         -0.0463830321516635,
         0.0758322348820315,
         -0.114459188960549,
         0.167709576118739,
         0.0293055599732866,
         -0.0643737321272902,
         0.101704132555822,
         -0.121331042452606,
         -0.0175294380360605,
         0.0572174540997882,
         -0.0976307626346092,
         0.12051086171905,
         -0.10703983350003,
         -0.0200319005827247,
         -0.00836934103981349,
         0.0707139621087442,
         -0.148602309084495,
         0.20025319184722,
         0.0434066177398232,
         -0.0554337058455458,
         0.0261221339076492,
         0.0634877301451884,
         -0.231232468438148,
         -0.0339878476459753,
         0.069891861068664,
         -0.103389948793713,
         0.1154912037001,
         0.00220725157654958,
         -0.0041293895829328,
         0.00476820837459011},
        {0.189185213705,
         -0.163839201088918,
         0.0875757367139272,
         -0.0335643236154645,
         -0.104706590599197,
         0.156122290597009,
         -0.114880351782232,
         0.0455355444790046,
         -0.00313093537429155,
         0.0705962322186114,
         -0.130896000177873,
         0.121461030961367,
         -0.0394349382939739,
         0.0231285395019044,
         -0.0541120221825761,
         0.101333067166238,
         -0.111844471825826,
         0.0210788611663747,
         -0.0208395685274472,
         0.0356139337712009,
         -0.0648240801984338,
         0.0832823541058416,
         -0.198139296612856,
         0.0378195168436817,
         0.0628170511878089,
         -0.0708958401112453,
         -0.0222051009512199,
         0.179540578548457,
         -0.0817842539882074,
         -0.0559908344408119,
         0.10812150112029,
         -0.0129683107687711,
         -0.108931489751684,
         0.0768304029682587,
         0.047124169104952,
         -0.134614178584641,
         0.0295686134140327,
         0.0380499488139728,
         -0.0387229280852138,
         -0.0499190745280001,
         0.153975599292967,
         -0.0238754484838528,
         0.00298070911277923,
         -0.000242217092871524,
         0.0542302859716377,
         -0.155807017714023,
         0.179910447237648,
         0.0443777671066683,
         -0.0538107536603226,
         -0.00519978830189629,
         0.041156666884538,
         -0.107985715730691,
         -0.0835370200982655,
         0.120814914639246,
         -0.0331801949718763,
         -0.0627877717983687,
         0.0791829974347827,
         0.0737945230118534,
         -0.148673723712829,
         0.0737945230118533,
         0.0791829974347826,
         -0.0627877717983689,
         -0.0331801949718764,
         0.120814914639245,
         -0.0835370200982656,
         -0.107985715730691,
         0.0411566668845381,
         -0.00519978830189617,
         -0.0538107536603224,
         0.044377767106668,
         0.179910447237648,
         -0.155807017714023,
         0.0542302859716375,
         -0.000242217092871617,
         0.00298070911277925,
         -0.0238754484838526,
         0.153975599292966,
         -0.0499190745280004,
         -0.038722928085214,
         0.038049948813973,
         0.0295686134140327,
         -0.134614178584641,
         0.0471241691049522,
         0.0768304029682587,
         -0.108931489751684,
         -0.0129683107687713,
         0.10812150112029,
         -0.0559908344408118,
         -0.0817842539882075,
         0.179540578548457,
         -0.0222051009512199,
         -0.0708958401112451,
         0.0628170511878088,
         0.0378195168436816,
         -0.198139296612856,
         0.0832823541058415,
         -0.0648240801984336,
         0.0356139337712006,
         -0.020839568527447,
         0.0210788611663747,
         -0.111844471825826,
         0.101333067166238,
         -0.0541120221825759,
         0.0231285395019042,
         -0.0394349382939739,
         0.121461030961367,
         -0.130896000177873,
         0.0705962322186113,
         -0.00313093537429159,
         0.0455355444790045,
         -0.114880351782232,
         0.156122290597009,
         -0.104706590599198,
         -0.0335643236154645,
         0.0875757367139273,
         -0.163839201088918,
         0.189185213705},
        {0.000346366691398352,
         -0.000447157475822257,
         0.000346366691398461,
         -0.0951488990381962,
         0.134278056245411,
         -0.133995249026137,
         0.0945489743306446,
         0.0974673529027823,
         -0.0426907533255232,
         -0.0572459579333606,
         0.147007120043317,
         -0.170805952368766,
         -0.0224768984952705,
         -0.0684498017205898,
         0.108051116251606,
         -0.0675721112014073,
         -0.0422651155265709,
         0.165044139503454,
         -0.0700841619862975,
         0.088436472757545,
         -0.0451450169927498,
         -0.0172383240613545,
         0.0562511006531983,
         -0.0295202945263761,
         -0.105237681080353,
         0.0945489743306446,
         -0.133995249026137,
         0.134278056245411,
         -0.0951488990381962,
         0.0454300868226005,
         -0.0637580084517789,
         0.0696645359109596,
         -0.0637580084517789,
         0.0454300868226004,
         -0.126580950183236,
         0.0384034567824636,
         0.0343178649597706,
         -0.0505271614877801,
         0.00633389665734029,
         0.0679309602896736,
         0.0976126281431692,
         0.0473206328113148,
         -0.0337763667575748,
         -0.0528733693254274,
         0.127614244439388,
         -0.105789653566662,
         -0.0968992823297404,
         -0.0224768984952703,
         -0.0684498017205901,
         0.108051116251606,
         -0.0675721112014072,
         -0.042265115526571,
         0.165044139503454,
         -0.170805952368767,
         0.147007120043317,
         -0.0572459579333607,
         -0.0426907533255233,
         0.0974673529027824,
         0.0679309602896736,
         0.00633389665734027,
         -0.0505271614877801,
         0.0343178649597705,
         0.0384034567824632,
         -0.126580950183236,
         0.0289683220400672,
         0.0296816678534956,
         -0.0643350728186468,
         0.0757967763118656,
         -0.0643350728186467,
         0.0296816678534958,
         0.0289683220400673,
         -0.126580950183236,
         0.0384034567824634,
         0.0343178649597705,
         -0.0505271614877802,
         0.00633389665734056,
         0.0679309602896733,
         0.0974673529027824,
         -0.0426907533255234,
         -0.0572459579333605,
         0.147007120043317,
         -0.170805952368766,
         0.165044139503454,
         -0.0422651155265711,
         -0.0675721112014072,
         0.108051116251606,
         -0.0684498017205901,
         -0.0224768984952704,
         -0.0968992823297405,
         -0.105789653566662,
         0.127614244439388,
         -0.0528733693254274,
         -0.0337763667575748,
         0.0473206328113147,
         0.0976126281431689,
         0.0679309602896735,
         0.00633389665734029,
         -0.0505271614877801,
         0.0343178649597705,
         0.0384034567824634,
         -0.126580950183236,
         0.0454300868226004,
         -0.0637580084517789,
         0.0696645359109598,
         -0.063758008451779,
         0.0454300868226004,
         -0.0951488990381961,
         0.134278056245411,
         -0.133995249026137,
         0.0945489743306446,
         -0.105237681080353,
         -0.0295202945263761,
         0.0562511006531983,
         -0.0172383240613546,
         -0.0451450169927499,
         0.0884364727575453,
         -0.0700841619862973,
         0.165044139503454,
         -0.042265115526571,
         -0.0675721112014071,
         0.108051116251606,
         -0.0684498017205899,
         -0.0224768984952702,
         -0.170805952368766,
         0.147007120043317,
         -0.0572459579333604,
         -0.0426907533255233,
         0.0974673529027823,
         0.0945489743306447,
         -0.133995249026137,
         0.134278056245411,
         -0.0951488990381961,
         0.000346366691398498,
         -0.000447157475822331,
         0.000346366691398438},
        {-0.0339251344681886,
         0.0437971602710472,
         -0.0339251344681887,
         0.0280643056790011,
         -0.0119891654090381,
         -0.0157105908917513,
         0.0306957508735081,
         -0.0423449621842431,
         0.0318205141401316,
         -0.0255708591790983,
         0.0344519593346386,
         -0.0460663876669563,
         -0.0176675358198801,
         0.0651536528505501,
         -0.0960203150067114,
         0.114101642933018,
         -0.128521286875376,
         0.135235031191107,
         0.185975612707773,
         -0.171550130117423,
         0.130343341939891,
         -0.0749059872230935,
         0.00902937296073716,
         0.0722546259076814,
         -0.182673566496875,
         0.0306957508735081,
         -0.0157105908917514,
         -0.0119891654090382,
         0.028064305679001,
         0.003252971949249,
         -0.0525777823188908,
         0.0751149389077245,
         -0.052577782318891,
         0.00325297194924902,
         0.0885914878534793,
         -0.0830495741303878,
         0.111577765145057,
         -0.14992870538466,
         0.154152815016015,
         -0.0927910565818534,
         -0.164337388822248,
         0.090171383559119,
         -0.0670482482333288,
         0.0435882085864164,
         -0.00344921857676002,
         -0.0346730396204248,
         0.0170451556130851,
         -0.0176675358198804,
         0.0651536528505497,
         -0.0960203150067112,
         0.114101642933018,
         -0.128521286875376,
         0.135235031191107,
         -0.0460663876669562,
         0.0344519593346386,
         -0.0255708591790984,
         0.0318205141401318,
         -0.0423449621842431,
         -0.0927910565818535,
         0.154152815016015,
         -0.14992870538466,
         0.111577765145056,
         -0.0830495741303879,
         0.0885914878534792,
         0.0757459009687683,
         -0.0715463322403945,
         0.0164699986781131,
         0.01064821123019,
         0.0164699986781132,
         -0.0715463322403943,
         0.0757459009687682,
         0.0885914878534793,
         -0.0830495741303882,
         0.111577765145057,
         -0.149928705384659,
         0.154152815016015,
         -0.0927910565818533,
         -0.0423449621842431,
         0.0318205141401316,
         -0.0255708591790982,
         0.0344519593346386,
         -0.0460663876669565,
         0.135235031191107,
         -0.128521286875376,
         0.114101642933018,
         -0.0960203150067113,
         0.0651536528505497,
         -0.0176675358198804,
         0.0170451556130848,
         -0.0346730396204247,
         -0.00344921857676003,
         0.0435882085864165,
         -0.0670482482333286,
         0.0901713835591189,
         -0.164337388822248,
         -0.0927910565818534,
         0.154152815016015,
         -0.14992870538466,
         0.111577765145057,
         -0.0830495741303878,
         0.0885914878534792,
         0.00325297194924909,
         -0.0525777823188909,
         0.0751149389077246,
         -0.0525777823188907,
         0.00325297194924919,
         0.028064305679001,
         -0.0119891654090382,
         -0.0157105908917513,
         0.030695750873508,
         -0.182673566496875,
         0.0722546259076816,
         0.00902937296073699,
         -0.0749059872230936,
         0.130343341939891,
         -0.171550130117423,
         0.185975612707774,
         0.135235031191107,
         -0.128521286875376,
         0.114101642933018,
         -0.0960203150067112,
         0.0651536528505499,
         -0.0176675358198804,
         -0.0460663876669566,
         0.0344519593346387,
         -0.0255708591790983,
         0.0318205141401317,
         -0.0423449621842431,
         0.030695750873508,
         -0.0157105908917515,
         -0.0119891654090382,
         0.028064305679001,
         -0.0339251344681887,
         0.0437971602710475,
         -0.0339251344681888},
        {0.13855880125565,
         -0.178878643244532,
         0.13855880125565,
         -0.131383542495843,
         0.0726716001875609,
         0.0404611872951215,
         -0.108607341114781,
         0.0870529707622184,
         0.00827205059904527,
         -0.0653527568735758,
         0.0310482519801077,
         0.054842557869779,
         -0.0391257784141794,
         -0.0365418080270454,
         0.0336220422550548,
         0.0125893352994862,
         -0.0334468677316637,
         -0.016573030317107,
         0.107703614984924,
         -0.0757575506836107,
         0.0988686193208284,
         -0.118280314467489,
         0.111011858343412,
         -0.089858201817323,
         0.103390024406852,
         -0.108607341114781,
         0.0404611872951217,
         0.0726716001875607,
         -0.131383542495843,
         0.120945291400756,
         0.0249092645177831,
         -0.0988381894323185,
         0.0249092645177832,
         0.120945291400756,
         -0.0897237358943569,
         -0.0761908994282558,
         0.058936611095568,
         0.0486839746654682,
         -0.0799814116822876,
         -0.0664159639047531,
         -0.0597845185329541,
         0.181454318728625,
         -0.0993260331677674,
         0.0382398606552761,
         -0.0799330854004193,
         0.16304007701684,
         -0.0830922905225586,
         -0.0391257784141795,
         -0.0365418080270454,
         0.033622042255055,
         0.0125893352994861,
         -0.0334468677316639,
         -0.0165730303171068,
         0.0548425578697793,
         0.0310482519801075,
         -0.0653527568735757,
         0.00827205059904524,
         0.0870529707622185,
         -0.0664159639047529,
         -0.0799814116822878,
         0.0486839746654679,
         0.0589366110955679,
         -0.0761908994282557,
         -0.0897237358943572,
         0.149508254427311,
         0.00663144537179875,
         0.114339106642173,
         -0.19043835262907,
         0.114339106642173,
         0.00663144537179864,
         0.149508254427311,
         -0.0897237358943572,
         -0.0761908994282558,
         0.0589366110955679,
         0.0486839746654678,
         -0.0799814116822876,
         -0.0664159639047529,
         0.0870529707622184,
         0.00827205059904516,
         -0.0653527568735759,
         0.0310482519801076,
         0.0548425578697793,
         -0.016573030317107,
         -0.0334468677316639,
         0.0125893352994862,
         0.033622042255055,
         -0.0365418080270455,
         -0.0391257784141795,
         -0.0830922905225582,
         0.163040077016841,
         -0.0799330854004194,
         0.038239860655276,
         -0.0993260331677674,
         0.181454318728625,
         -0.0597845185329543,
         -0.0664159639047528,
         -0.0799814116822879,
         0.0486839746654679,
         0.0589366110955676,
         -0.0761908994282558,
         -0.0897237358943573,
         0.120945291400756,
         0.0249092645177832,
         -0.0988381894323183,
         0.0249092645177831,
         0.120945291400756,
         -0.131383542495843,
         0.0726716001875608,
         0.0404611872951216,
         -0.108607341114781,
         0.103390024406853,
         -0.089858201817323,
         0.111011858343412,
         -0.118280314467489,
         0.0988686193208283,
         -0.075757550683611,
         0.107703614984924,
         -0.0165730303171069,
         -0.0334468677316639,
         0.0125893352994862,
         0.033622042255055,
         -0.0365418080270454,
         -0.0391257784141794,
         0.054842557869779,
         0.0310482519801077,
         -0.0653527568735755,
         0.0082720505990453,
         0.0870529707622184,
         -0.108607341114781,
         0.0404611872951215,
         0.0726716001875609,
         -0.131383542495843,
         0.13855880125565,
         -0.178878643244532,
         0.13855880125565},
        {0.0795069366532415,
         -0.102643013855324,
         0.0795069366532418,
         -0.0259568235208106,
         -0.0282086500781542,
         0.0931257920155632,
         -0.111753230316764,
         -0.0654470369831199,
         0.118512910839472,
         -0.107974062850418,
         0.0327165040435182,
         0.0558874051105971,
         0.113080823656842,
         -0.0805396786163355,
         -0.00357290849360112,
         0.0799221005273943,
         -0.0960926240359712,
         0.0311428286657194,
         -0.168247929373864,
         0.0759178234895612,
         -0.0249800582004453,
         0.0270428778810159,
         -0.073185924134707,
         0.133960235793889,
         -0.159388248919867,
         -0.111753230316764,
         0.093125792015563,
         -0.0282086500781539,
         -0.0259568235208104,
         0.125114460033994,
         -0.0644987781113086,
         0.0295976658640384,
         -0.0644987781113086,
         0.125114460033994,
         -0.035014307338487,
         -0.0264739017051103,
         0.0040070989154541,
         0.037403045096977,
         -0.00742551156737824,
         -0.126507766021977,
         0.0297527705474098,
         -0.0870685690932255,
         0.158512930464946,
         -0.159283557600378,
         0.0866925645215884,
         -0.020166476334901,
         0.1212462292309,
         0.113080823656842,
         -0.0805396786163355,
         -0.0035729084936011,
         0.0799221005273943,
         -0.0960926240359711,
         0.0311428286657192,
         0.0558874051105971,
         0.0327165040435181,
         -0.107974062850418,
         0.118512910839472,
         -0.06544703698312,
         -0.126507766021977,
         -0.0074255115673784,
         0.0374030450969771,
         0.00400709891545432,
         -0.0264739017051104,
         -0.0350143073384869,
         0.0052615367910772,
         0.156260536569387,
         -0.130002163959277,
         0.100720770318175,
         -0.130002163959277,
         0.156260536569387,
         0.00526153679107705,
         -0.0350143073384869,
         -0.0264739017051103,
         0.00400709891545407,
         0.037403045096977,
         -0.00742551156737839,
         -0.126507766021977,
         -0.0654470369831198,
         0.118512910839472,
         -0.107974062850418,
         0.0327165040435184,
         0.0558874051105972,
         0.0311428286657192,
         -0.096092624035971,
         0.0799221005273943,
         -0.0035729084936009,
         -0.0805396786163355,
         0.113080823656842,
         0.1212462292309,
         -0.0201664763349008,
         0.0866925645215886,
         -0.159283557600378,
         0.158512930464946,
         -0.0870685690932256,
         0.0297527705474099,
         -0.126507766021977,
         -0.00742551156737839,
         0.037403045096977,
         0.00400709891545399,
         -0.0264739017051102,
         -0.035014307338487,
         0.125114460033994,
         -0.0644987781113083,
         0.0295976658640386,
         -0.0644987781113085,
         0.125114460033994,
         -0.0259568235208104,
         -0.0282086500781541,
         0.0931257920155629,
         -0.111753230316764,
         -0.159388248919867,
         0.133960235793889,
         -0.073185924134707,
         0.027042877881016,
         -0.0249800582004452,
         0.075917823489561,
         -0.168247929373863,
         0.0311428286657194,
         -0.0960926240359711,
         0.0799221005273941,
         -0.00357290849360099,
         -0.0805396786163357,
         0.113080823656842,
         0.055887405110597,
         0.0327165040435181,
         -0.107974062850418,
         0.118512910839472,
         -0.0654470369831195,
         -0.111753230316764,
         0.0931257920155629,
         -0.0282086500781539,
         -0.0259568235208106,
         0.0795069366532417,
         -0.102643013855324,
         0.0795069366532417},
        {0.0674449076993872,
         -0.106639762454945,
         0.120918124854337,
         -0.106639762454945,
         0.0674449076993871,
         -0.0412476179637129,
         0.0175274588201674,
         0.0360520304711145,
         -0.0930533811730235,
         0.125544795952045,
         -0.109563780388315,
         -0.00398349138879312,
         0.0416967220853601,
         -0.0613115304066932,
         0.0438133781412762,
         0.00940241584679138,
         -0.076630342212179,
         0.114343572908746,
         0.00455597053004364,
         -0.00257717776306627,
         -0.0243746672644662,
         0.0610913838395516,
         -0.0850889593680325,
         0.0755725593466195,
         -0.0224061839529805,
         -0.057917956706704,
         -0.0259594877276126,
         0.0227379300709323,
         -0.0213603706117603,
         0.0328506989530068,
         -0.0601715963739605,
         0.0982245358302883,
         -0.133849781954033,
         0.145826391053617,
         -0.104872211113838,
         -0.109563780388315,
         0.125544795952045,
         -0.0930533811730235,
         0.0360520304711145,
         0.0175274588201675,
         -0.041247617963713,
         0.0923781717584571,
         -0.0319274951827409,
         -0.0383146813204666,
         0.0672579146774689,
         -0.0383146813204665,
         -0.0319274951827409,
         0.092378171758457,
         0.00187252844913154,
         -0.0796622120238198,
         0.0889420744204685,
         -0.042729654145009,
         -0.0137029612641579,
         0.0297806975307514,
         0.028293131174756,
         -0.142982516664052,
         0.0195163724142524,
         -0.0243595872771892,
         0.0778883062544726,
         -0.117748708522167,
         0.113831806550829,
         -0.0682734461055026,
         0.0154543062457232,
         -0.0219998993255159,
         0.186780570993396,
         0.00455597053004378,
         -0.0025771777630662,
         -0.0243746672644661,
         0.0610913838395517,
         -0.0850889593680326,
         0.0755725593466195,
         -0.0224061839529806,
         -0.057917956706704,
         0.114343572908746,
         -0.0766303422121789,
         0.00940241584679142,
         0.0438133781412761,
         -0.0613115304066932,
         0.0416967220853602,
         -0.00398349138879304,
         -0.142982516664052,
         0.028293131174756,
         0.0297806975307517,
         -0.0137029612641579,
         -0.0427296541450089,
         0.0889420744204686,
         -0.0796622120238198,
         0.0018725284491315,
         -0.0216785820225951,
         0.143883416544439,
         -0.110254459205704,
         0.0417098348607289,
         -0.0108004184221146,
         0.0417098348607288,
         -0.110254459205704,
         0.143883416544439,
         -0.021678582022595,
         0.00187252844913156,
         -0.07966221202382,
         0.0889420744204684,
         -0.0427296541450089,
         -0.0137029612641578,
         0.0297806975307515,
         0.0282931311747562,
         -0.142982516664052,
         -0.00398349138879295,
         0.0416967220853601,
         -0.0613115304066934,
         0.0438133781412761,
         0.00940241584679138,
         -0.076630342212179,
         0.114343572908746,
         -0.0579179567067038,
         -0.0224061839529805,
         0.0755725593466197,
         -0.0850889593680323,
         0.0610913838395518,
         -0.0243746672644661,
         -0.00257717776306619,
         0.00455597053004379,
         0.186780570993396,
         -0.0219998993255159,
         0.0154543062457233,
         -0.0682734461055026,
         0.113831806550829,
         -0.117748708522167,
         0.0778883062544728,
         -0.0243595872771892,
         0.0195163724142524,
         -0.142982516664052,
         0.0282931311747561,
         0.0297806975307515,
         -0.0137029612641577,
         -0.0427296541450092,
         0.0889420744204686,
         -0.0796622120238199,
         0.00187252844913148,
         0.092378171758457,
         -0.0319274951827408,
         -0.0383146813204667,
         0.0672579146774688,
         -0.0383146813204665,
         -0.0319274951827407,
         0.0923781717584568,
         -0.0412476179637129,
         0.0175274588201675,
         0.0360520304711145,
         -0.0930533811730237,
         0.125544795952045,
         -0.109563780388315,
         -0.104872211113838,
         0.145826391053617,
         -0.133849781954033,
         0.0982245358302883,
         -0.0601715963739607,
         0.0328506989530065,
         -0.0213603706117603,
         0.0227379300709324,
         -0.0259594877276126,
         -0.057917956706704,
         -0.0224061839529804,
         0.0755725593466195,
         -0.0850889593680326,
         0.0610913838395518,
         -0.0243746672644662,
         -0.00257717776306614,
         0.00455597053004365,
         0.114343572908746,
         -0.0766303422121789,
         0.00940241584679124,
         0.0438133781412761,
         -0.0613115304066932,
         0.04169672208536,
         -0.0039834913887928,
         -0.109563780388315,
         0.125544795952045,
         -0.0930533811730235,
         0.0360520304711146,
         0.0175274588201673,
         -0.0412476179637128,
         0.067444907699387,
         -0.106639762454945,
         0.120918124854337,
         -0.106639762454945,
         0.067444907699387},
        {-0.0234437901617499,
         0.0370678869490886,
         -0.0420310330688335,
         0.0370678869490886,
         -0.02344379016175,
         0.0416436670260186,
         -0.0492671559618469,
         0.0390718953039735,
         -0.0192582763018082,
         -0.000464633038416565,
         0.0107782414258949,
         -0.0982706512019462,
         0.111341503251647,
         -0.100825625596901,
         0.0837213718610289,
         -0.0688768748252667,
         0.057881017914995,
         -0.0448101658652944,
         0.170348918072436,
         -0.140245556276966,
         0.0861333895044937,
         -0.0325808623952976,
         -0.0132752215182665,
         0.0503193989645587,
         -0.0777951598683463,
         0.0881427527733645,
         -0.209414555747568,
         0.0889596806107569,
         -0.0139952775241955,
         -0.0266083916792775,
         0.0411789962955678,
         -0.0352421367493254,
         0.0115213445939452,
         0.0300619174884345,
         -0.0923882556869299,
         0.0107782414258949,
         -0.000464633038416463,
         -0.0192582763018082,
         0.0390718953039735,
         -0.049267155961847,
         0.0416436670260189,
         0.0320169180251779,
         -0.0850932639868551,
         0.128288662960208,
         -0.144568353881497,
         0.128288662960208,
         -0.0850932639868552,
         0.0320169180251777,
         -0.0247864097698985,
         0.0745497175684727,
         -0.0883393533906085,
         0.0665800162041906,
         -0.0248380034120648,
         -0.0159005207441273,
         0.0358661865577141,
         -0.0241202403532926,
         -0.0314951945260543,
         -0.0674940200814143,
         0.0936541769115321,
         -0.0832550966548996,
         0.0613583245170954,
         -0.0418171302186747,
         0.0272765079951715,
         -0.0091731765970964,
         -0.0322644207100609,
         0.170348918072436,
         -0.140245556276966,
         0.0861333895044936,
         -0.0325808623952975,
         -0.0132752215182664,
         0.0503193989645584,
         -0.0777951598683462,
         0.0881427527733643,
         -0.0448101658652945,
         0.0578810179149949,
         -0.0688768748252667,
         0.0837213718610288,
         -0.100825625596901,
         0.111341503251647,
         -0.0982706512019461,
         -0.0241202403532928,
         0.0358661865577142,
         -0.0159005207441272,
         -0.0248380034120647,
         0.0665800162041904,
         -0.0883393533906087,
         0.0745497175684728,
         -0.0247864097698985,
         0.0601160752318447,
         -0.0177616738111638,
         -0.0545225031295846,
         0.114705422521567,
         -0.137568464523483,
         0.114705422521567,
         -0.0545225031295845,
         -0.0177616738111639,
         0.0601160752318448,
         -0.0247864097698983,
         0.0745497175684729,
         -0.0883393533906087,
         0.0665800162041906,
         -0.0248380034120648,
         -0.0159005207441273,
         0.0358661865577142,
         -0.0241202403532927,
         -0.0982706512019462,
         0.111341503251647,
         -0.100825625596901,
         0.0837213718610289,
         -0.0688768748252669,
         0.0578810179149951,
         -0.0448101658652944,
         0.0881427527733644,
         -0.0777951598683463,
         0.0503193989645586,
         -0.0132752215182664,
         -0.0325808623952973,
         0.0861333895044935,
         -0.140245556276966,
         0.170348918072436,
         -0.0322644207100608,
         -0.00917317659709627,
         0.0272765079951716,
         -0.0418171302186747,
         0.0613583245170953,
         -0.0832550966548995,
         0.093654176911532,
         -0.0674940200814141,
         -0.0314951945260541,
         -0.0241202403532925,
         0.0358661865577143,
         -0.0159005207441272,
         -0.0248380034120648,
         0.0665800162041906,
         -0.0883393533906085,
         0.0745497175684728,
         -0.0247864097698985,
         0.0320169180251777,
         -0.0850932639868552,
         0.128288662960208,
         -0.144568353881497,
         0.128288662960207,
         -0.0850932639868553,
         0.0320169180251776,
         0.0416436670260188,
         -0.0492671559618469,
         0.0390718953039736,
         -0.0192582763018082,
         -0.000464633038416406,
         0.010778241425895,
         -0.0923882556869301,
         0.0300619174884345,
         0.0115213445939453,
         -0.0352421367493255,
         0.0411789962955679,
         -0.0266083916792775,
         -0.0139952775241955,
         0.0889596806107571,
         -0.209414555747568,
         0.0881427527733645,
         -0.0777951598683463,
         0.0503193989645584,
         -0.0132752215182663,
         -0.0325808623952973,
         0.0861333895044936,
         -0.140245556276966,
         0.170348918072436,
         -0.0448101658652945,
         0.057881017914995,
         -0.0688768748252666,
         0.083721371861029,
         -0.100825625596901,
         0.111341503251647,
         -0.0982706512019462,
         0.0107782414258948,
         -0.000464633038416467,
         -0.0192582763018081,
         0.0390718953039735,
         -0.0492671559618469,
         0.0416436670260188,
         -0.02344379016175,
         0.0370678869490885,
         -0.0420310330688334,
         0.0370678869490886,
         -0.0234437901617499},
        {-0.00566533951666284,
         0.00895768829540607,
         -0.0101570638078622,
         0.00895768829540596,
         -0.00566533951666273,
         0.0594407594958474,
         -0.0899780929386235,
         0.102756305096603,
         -0.0979682192996139,
         0.0779600929687544,
         -0.0467726752209737,
         -0.0953370033783966,
         0.0915282973239493,
         -0.0504927506996758,
         -0.00610234789577625,
         0.0594485991566281,
         -0.0924387680519845,
         0.0886300619975379,
         0.0846135386122072,
         -0.0293689235121565,
         -0.0266181067224128,
         0.0572099512900036,
         -0.0538675576937429,
         0.0185419135206586,
         0.0370171169493946,
         -0.0860043056219618,
         0.05829606944569,
         -0.118126876378572,
         0.133825226321552,
         -0.121277330477708,
         0.0956922624629281,
         -0.071601958305908,
         0.0628612164481532,
         -0.0826476977439788,
         0.143461925460508,
         -0.0467726752209738,
         0.0779600929687544,
         -0.0979682192996135,
         0.102756305096603,
         -0.0899780929386238,
         0.0594407594958477,
         -0.00932938641364387,
         0.00503639132505975,
         0.000404252194986617,
         -0.00268324451906275,
         0.000404252194986576,
         0.00503639132505962,
         -0.00932938641364389,
         0.0747292039962397,
         -0.0233645175011263,
         -0.0257281522606448,
         0.0506889695438213,
         -0.0464902430499669,
         0.0172968772814261,
         0.0254138793539062,
         -0.060478330853568,
         -0.177957683311453,
         0.0534094873132392,
         -0.0224154702238258,
         0.0498175217011044,
         -0.103166081751728,
         0.152720140731112,
         -0.171447239343439,
         0.135023468641649,
         -0.0218334700274494,
         0.084613538612207,
         -0.0293689235121568,
         -0.026618106722413,
         0.0572099512900039,
         -0.0538675576937428,
         0.0185419135206585,
         0.0370171169493947,
         -0.0860043056219619,
         0.088630061997538,
         -0.0924387680519846,
         0.0594485991566282,
         -0.00610234789577642,
         -0.0504927506996757,
         0.0915282973239494,
         -0.0953370033783967,
         -0.0604783308535681,
         0.0254138793539062,
         0.017296877281426,
         -0.0464902430499669,
         0.0506889695438214,
         -0.0257281522606448,
         -0.0233645175011263,
         0.0747292039962396,
         0.0916678312243427,
         -0.104009449392006,
         0.102667827132474,
         -0.0978000282536107,
         0.0955002910401321,
         -0.0978000282536107,
         0.102667827132474,
         -0.104009449392006,
         0.0916678312243429,
         0.0747292039962396,
         -0.0233645175011262,
         -0.0257281522606446,
         0.0506889695438214,
         -0.0464902430499668,
         0.0172968772814261,
         0.0254138793539062,
         -0.0604783308535681,
         -0.0953370033783966,
         0.0915282973239495,
         -0.0504927506996757,
         -0.00610234789577632,
         0.0594485991566283,
         -0.0924387680519849,
         0.0886300619975379,
         -0.0860043056219618,
         0.0370171169493946,
         0.0185419135206586,
         -0.053867557693743,
         0.0572099512900037,
         -0.0266181067224129,
         -0.0293689235121565,
         0.0846135386122074,
         -0.0218334700274494,
         0.135023468641648,
         -0.171447239343438,
         0.152720140731112,
         -0.103166081751728,
         0.0498175217011044,
         -0.0224154702238258,
         0.0534094873132389,
         -0.177957683311454,
         -0.0604783308535679,
         0.0254138793539061,
         0.0172968772814261,
         -0.046490243049967,
         0.0506889695438214,
         -0.0257281522606447,
         -0.0233645175011264,
         0.0747292039962398,
         -0.00932938641364368,
         0.00503639132505965,
         0.000404252194986568,
         -0.00268324451906289,
         0.000404252194986534,
         0.00503639132505966,
         -0.0093293864136438,
         0.0594407594958476,
         -0.0899780929386235,
         0.102756305096603,
         -0.0979682192996137,
         0.0779600929687544,
         -0.0467726752209736,
         0.143461925460508,
         -0.0826476977439786,
         0.0628612164481532,
         -0.0716019583059082,
         0.0956922624629283,
         -0.121277330477708,
         0.133825226321552,
         -0.118126876378572,
         0.0582960694456901,
         -0.0860043056219617,
         0.0370171169493948,
         0.0185419135206587,
         -0.0538675576937428,
         0.0572099512900041,
         -0.0266181067224128,
         -0.0293689235121566,
         0.0846135386122072,
         0.0886300619975381,
         -0.0924387680519845,
         0.059448599156628,
         -0.00610234789577627,
         -0.0504927506996757,
         0.0915282973239493,
         -0.0953370033783966,
         -0.0467726752209738,
         0.0779600929687545,
         -0.0979682192996136,
         0.102756305096603,
         -0.0899780929386237,
         0.0594407594958478,
         -0.00566533951666289,
         0.00895768829540614,
         -0.0101570638078621,
         0.00895768829540594,
         -0.0056653395166629},
        {-0.0622881531846615,
         0.0984862176545003,
         -0.111672874063366,
         0.0984862176545003,
         -0.0622881531846615,
         0.0766605539670172,
         -0.0771666031085551,
         0.0395886340372991,
         0.0130544636458991,
         -0.0549665234048265,
         0.0626199907468055,
         -0.0642078310252125,
         0.029921759334194,
         0.014754057183234,
         -0.0384086503274132,
         0.0292874208512894,
         0.00560279046990486,
         -0.0398888621609234,
         -0.0139290045354107,
         0.0740319537954265,
         -0.103532734788567,
         0.100614825886295,
         -0.0795775416986418,
         0.0594525036580216,
         -0.0556669524191069,
         0.068193650704248,
         0.112948735797675,
         -0.103099442235508,
         0.0635276984103702,
         -0.0147218991811812,
         -0.0302744188640311,
         0.0658625774081286,
         -0.0938887564048654,
         0.123643994078886,
         -0.171864186925727,
         0.0626199907468055,
         -0.0549665234048266,
         0.013054463645899,
         0.039588634037299,
         -0.077166603108555,
         0.0766605539670173,
         -0.0839833809274785,
         0.0274888537367174,
         0.0377726625555423,
         -0.0646320765577933,
         0.0377726625555423,
         0.0274888537367177,
         -0.0839833809274785,
         0.137181329490444,
         -0.0633403070743538,
         0.0378316252287827,
         -0.0686412205869174,
         0.121218537467245,
         -0.148784674029812,
         0.112703870932399,
         -0.00889459608428416,
         -0.0932501486733408,
         -0.0157030740281402,
         0.0175972947329985,
         0.00936640548647199,
         -0.0167663786415412,
         -0.0140395901729565,
         0.0719142827786227,
         -0.115941047913495,
         0.0754238012320459,
         -0.0139290045354107,
         0.0740319537954266,
         -0.103532734788566,
         0.100614825886295,
         -0.0795775416986421,
         0.0594525036580219,
         -0.055666952419107,
         0.0681936507042479,
         -0.0398888621609232,
         0.00560279046990492,
         0.0292874208512894,
         -0.0384086503274134,
         0.014754057183234,
         0.029921759334194,
         -0.0642078310252127,
         -0.00889459608428415,
         0.112703870932399,
         -0.148784674029812,
         0.121218537467245,
         -0.0686412205869174,
         0.0378316252287829,
         -0.0633403070743538,
         0.137181329490445,
         -0.0651532063448567,
         -0.0459463637533999,
         0.0136303254745033,
         0.0504284471181812,
         -0.0792262295866336,
         0.0504284471181813,
         0.0136303254745031,
         -0.0459463637533998,
         -0.065153206344857,
         0.137181329490444,
         -0.0633403070743537,
         0.0378316252287827,
         -0.0686412205869175,
         0.121218537467245,
         -0.148784674029812,
         0.112703870932398,
         -0.00889459608428414,
         -0.0642078310252127,
         0.0299217593341941,
         0.0147540571832339,
         -0.0384086503274134,
         0.0292874208512893,
         0.00560279046990469,
         -0.0398888621609232,
         0.0681936507042481,
         -0.055666952419107,
         0.0594525036580218,
         -0.0795775416986422,
         0.100614825886295,
         -0.103532734788567,
         0.0740319537954267,
         -0.0139290045354106,
         0.0754238012320457,
         -0.115941047913495,
         0.0719142827786226,
         -0.0140395901729564,
         -0.0167663786415413,
         0.00936640548647195,
         0.0175972947329987,
         -0.0157030740281401,
         -0.0932501486733409,
         -0.00889459608428409,
         0.112703870932399,
         -0.148784674029813,
         0.121218537467245,
         -0.0686412205869174,
         0.0378316252287828,
         -0.0633403070743538,
         0.137181329490445,
         -0.0839833809274785,
         0.0274888537367175,
         0.0377726625555422,
         -0.0646320765577934,
         0.0377726625555422,
         0.0274888537367175,
         -0.0839833809274785,
         0.0766605539670171,
         -0.077166603108555,
         0.0395886340372991,
         0.0130544636458991,
         -0.0549665234048264,
         0.0626199907468056,
         -0.171864186925727,
         0.123643994078886,
         -0.0938887564048654,
         0.0658625774081285,
         -0.0302744188640311,
         -0.0147218991811811,
         0.0635276984103702,
         -0.103099442235508,
         0.112948735797675,
         0.0681936507042479,
         -0.0556669524191071,
         0.0594525036580218,
         -0.0795775416986421,
         0.100614825886295,
         -0.103532734788566,
         0.0740319537954267,
         -0.0139290045354107,
         -0.0398888621609233,
         0.0056027904699047,
         0.0292874208512895,
         -0.0384086503274132,
         0.0147540571832338,
         0.0299217593341941,
         -0.0642078310252129,
         0.0626199907468056,
         -0.0549665234048265,
         0.0130544636458991,
         0.039588634037299,
         -0.0771666031085551,
         0.0766605539670171,
         -0.0622881531846614,
         0.0984862176545002,
         -0.111672874063366,
         0.0984862176545002,
         -0.0622881531846615},
        {-0.168817349124505,
         0.188743534211854,
         -0.123561647494187,
         0.168627176206953,
         -0.0603251562953437,
         -0.0725775849840141,
         0.113241038669936,
         -0.112902105874018,
         -0.0502546392877779,
         0.0975108176696168,
         -0.0185841343946091,
         -0.0698945567324847,
         0.0408663114956991,
         0.092586349891481,
         -0.0391915485346629,
         -0.0476174838508938,
         0.048065854336808,
         0.0278133381770654,
         0.000747520843860428,
         -0.05069817745769,
         -0.0428705233087591,
         0.0670034010839994,
         -0.0150162669189546,
         -0.0266135465070376,
         -0.00734415728583174,
         -0.000835753710734731,
         0.0433949096198886,
         -0.000390854479385245,
         -0.0470758046911682,
         0.0470828656821418,
         -0.0152569297095576,
         0.0161949508156115,
         0.000547129234540522,
         -0.0253699479613454,
         0.0181533420568786,
         0.0117229618492009,
         -0.0367550634440225,
         0.0410517032906277,
         -0.0495770567376638,
         0.085874956646024,
         0.0141969796146813,
         -0.112886300438442,
         0.123422455171103,
         -0.113556933131627,
         -0.0545290423287019,
         0.0734351309716522,
         0.0446530226857768,
         -0.142701662647405,
         0.107731375767198,
         0.0863470158106029,
         -0.00699411604663617,
         -0.0949916833665356,
         0.0439058858850803,
         0.108114865260279,
         -0.0513455494983316,
         -0.1163737457027,
         -0.0310775221857737,
         0.0495604356031209,
         0.0564860793586448,
         -0.0954467462625603,
         -0.0462805465394751,
         0.0623566213590927,
         0.0940184775317797,
         -0.0244931865292159,
         -0.0493818395491948,
         0.00121255822592034,
         0.0895739005818117,
         -0.0118668054067861,
         -0.0522542347028045,
         -0.0603647957362037,
         0.0601784501347292,
         0.00935714645521689,
         -0.0307389413622279,
         -0.0415694441473163,
         0.0378161268927405,
         0.0299110772773428,
         0.0280259742052697,
         -0.0608968723959939,
         0.0387934798629805,
         0.0038539852044293,
         0.00266337042602215,
         -0.00788859522538168,
         -0.0647083774595738,
         0.0506142116580252,
         0.0274493299809865,
         -0.0826358800188723,
         0.00752076221826969,
         0.0967664449518616,
         -0.0115291051698252,
         -0.0622064464077219,
         0.00449451508363857,
         0.120960707874747,
         -0.035117803299159,
         -0.0712936661981959,
         -0.0780558181985096,
         0.0763636510893588,
         0.0368646580587211,
         -0.0532935958997375,
         -0.121809863094102,
         0.0874768997220099,
         0.084922535445907,
         0.0183774037874078,
         -0.10053147408758,
         0.0183774037874079,
         0.084922535445907,
         0.0874768997220101,
         -0.121809863094102,
         -0.0532935958997373,
         0.0368646580587211,
         0.076363651089359,
         -0.0780558181985096,
         -0.0712936661981961,
         -0.0351178032991589,
         0.120960707874747,
         0.00449451508363851,
         -0.0622064464077219,
         -0.0115291051698252,
         0.0967664449518615,
         0.00752076221826966,
         -0.0826358800188723,
         0.0274493299809865,
         0.0506142116580252,
         -0.0647083774595737,
         -0.00788859522538167,
         0.00266337042602187,
         0.00385398520442928,
         0.0387934798629806,
         -0.0608968723959939,
         0.0280259742052697,
         0.0299110772773425,
         0.0378161268927405,
         -0.0415694441473162,
         -0.030738941362228,
         0.00935714645521685,
         0.0601784501347292,
         -0.0603647957362036,
         -0.0522542347028045,
         -0.0118668054067861,
         0.0895739005818116,
         0.00121255822592041,
         -0.0493818395491949,
         -0.0244931865292158,
         0.0940184775317797,
         0.0623566213590925,
         -0.046280546539475,
         -0.0954467462625602,
         0.0564860793586447,
         0.0495604356031212,
         -0.0310775221857738,
         -0.1163737457027,
         -0.0513455494983316,
         0.108114865260279,
         0.0439058858850803,
         -0.0949916833665355,
         -0.00699411604663614,
         0.086347015810603,
         0.107731375767198,
         -0.142701662647405,
         0.0446530226857768,
         0.0734351309716524,
         -0.054529042328702,
         -0.113556933131627,
         0.123422455171103,
         -0.112886300438442,
         0.0141969796146811,
         0.085874956646024,
         -0.0495770567376637,
         0.0410517032906276,
         -0.0367550634440224,
         0.011722961849201,
         0.0181533420568785,
         -0.0253699479613453,
         0.000547129234540393,
         0.0161949508156114,
         -0.0152569297095576,
         0.0470828656821416,
         -0.0470758046911682,
         -0.000390854479385195,
         0.0433949096198885,
         -0.000835753710735064,
         -0.00734415728583174,
         -0.0266135465070376,
         -0.0150162669189549,
         0.0670034010839993,
         -0.042870523308759,
         -0.0506981774576901,
         0.000747520843860421,
         0.0278133381770654,
         0.0480658543368079,
         -0.0476174838508936,
         -0.039191548534663,
         0.0925863498914809,
         0.0408663114956993,
         -0.0698945567324848,
         -0.018584134394609,
         0.0975108176696168,
         -0.050254639287778,
         -0.112902105874017,
         0.113241038669936,
         -0.0725775849840142,
         -0.0603251562953436,
         0.168627176206953,
         -0.123561647494187,
         0.188743534211854,
         -0.168817349124505},
        {0.049436169694151,
         -0.0552713179916682,
         0.0361835712081137,
         0.0588880971826752,
         -0.114935873831424,
         0.133322113997682,
         -0.0978641529827378,
         -0.116049909026904,
         0.0762926367231239,
         0.0265052862466541,
         -0.1191283105378,
         0.134449669128205,
         0.0965996017500775,
         0.0341298928498713,
         -0.102231397346408,
         0.061830110799902,
         0.0485559019268188,
         -0.130739428672654,
         -0.0458486810565953,
         -0.0786037442968551,
         0.0348341481265851,
         0.055029623551919,
         -0.0905191609973652,
         0.0263954726640237,
         0.0915088632557049,
         0.0512603837606269,
         0.0328744905392853,
         -0.0504670395736192,
         0.000179780780498786,
         0.0638674549747857,
         -0.0672780140161743,
         -0.0332953062922978,
         -0.0335577983907941,
         0.000394507972008005,
         0.0273629767227382,
         -0.0212937406188503,
         -0.0194876259116958,
         0.0605138487874587,
         -0.0235719492547956,
         -0.157748852652357,
         0.158245447427259,
         -0.104198051007386,
         0.0431016737522796,
         0.0814938411087293,
         -0.00483482298216981,
         -0.0376839779743938,
         0.025398104342674,
         0.00624730607926363,
         0.0161755991681227,
         -0.0271380762626927,
         -0.0115689819913896,
         0.0250393012837008,
         0.0176111685375789,
         -0.0741912667094567,
         -0.0388976217718333,
         -0.0544308869790374,
         0.0528842770933526,
         0.0144585456851082,
         -0.0582461668652342,
         0.00582984759443522,
         0.118842209246912,
         0.0800595760579603,
         0.0399973825114612,
         -0.089413095075563,
         0.0334495484946796,
         0.0596887774495548,
         -0.0616923837274433,
         -0.118552905439699,
         -0.0950625189866918,
         0.00957489872865971,
         0.0790236762565554,
         -0.0849442793970101,
         -0.00524008126652381,
         0.0925298687278473,
         0.0759562976804474,
         0.0707036687960248,
         -0.0441468116460865,
         -0.0243036353837454,
         0.0789244033632023,
         -0.059222786354102,
         -0.0567098817081052,
         0.141596725761029,
         -0.0368053498668719,
         -0.0695208303451698,
         0.111976540299492,
         -0.0849398360137697,
         -0.126090705208549,
         -0.05222840416528,
         0.0756139983598006,
         0.000156153810670514,
         -0.0753536091182037,
         0.0843745452557467,
         0.0388339450856627,
         0.0933340313142188,
         -0.0169745544368851,
         -0.0358203262668903,
         0.013921297861792,
         0.0337931696013141,
         -0.0395652206806926,
         -0.0138753464783618,
         -0.041693595718382,
         0.0144034854623077,
         0.00867014193245216,
         0.0144034854623077,
         -0.0416935957183821,
         -0.0138753464783618,
         -0.0395652206806925,
         0.0337931696013139,
         0.0139212978617919,
         -0.0358203262668902,
         -0.0169745544368852,
         0.0933340313142189,
         0.0388339450856628,
         0.0843745452557467,
         -0.0753536091182037,
         0.000156153810670539,
         0.0756139983598006,
         -0.05222840416528,
         -0.126090705208549,
         -0.0849398360137696,
         0.111976540299492,
         -0.0695208303451699,
         -0.0368053498668719,
         0.141596725761029,
         -0.0567098817081051,
         -0.0592227863541019,
         0.0789244033632023,
         -0.024303635383745,
         -0.0441468116460865,
         0.070703668796025,
         0.0759562976804474,
         0.0925298687278473,
         -0.00524008126652371,
         -0.0849442793970098,
         0.0790236762565553,
         0.00957489872865975,
         -0.0950625189866916,
         -0.118552905439699,
         -0.0616923837274435,
         0.0596887774495547,
         0.0334495484946797,
         -0.0894130950755631,
         0.0399973825114613,
         0.0800595760579603,
         0.118842209246912,
         0.00582984759443542,
         -0.0582461668652343,
         0.0144585456851083,
         0.0528842770933526,
         -0.0544308869790375,
         -0.0388976217718332,
         -0.0741912667094567,
         0.0176111685375789,
         0.0250393012837007,
         -0.0115689819913898,
         -0.0271380762626924,
         0.0161755991681227,
         0.00624730607926363,
         0.0253981043426741,
         -0.037683977974394,
         -0.00483482298216971,
         0.0814938411087293,
         0.0431016737522797,
         -0.104198051007386,
         0.158245447427259,
         -0.157748852652357,
         -0.0235719492547955,
         0.0605138487874585,
         -0.0194876259116959,
         -0.0212937406188502,
         0.0273629767227382,
         0.000394507972008012,
         -0.0335577983907942,
         -0.0332953062922977,
         -0.0672780140161744,
         0.0638674549747857,
         0.00017978078049873,
         -0.0504670395736191,
         0.0328744905392853,
         0.0512603837606271,
         0.091508863255705,
         0.0263954726640237,
         -0.0905191609973653,
         0.0550296235519189,
         0.034834148126585,
         -0.0786037442968551,
         -0.0458486810565954,
         -0.130739428672654,
         0.0485559019268189,
         0.0618301107999019,
         -0.102231397346408,
         0.0341298928498711,
         0.0965996017500772,
         0.134449669128205,
         -0.1191283105378,
         0.0265052862466541,
         0.076292636723124,
         -0.116049909026904,
         -0.0978641529827375,
         0.133322113997681,
         -0.114935873831424,
         0.0588880971826752,
         0.0361835712081135,
         -0.0552713179916681,
         0.0494361696941511},
        {-0.0248742849807494,
         0.0278102960543291,
         -0.0182061123954418,
         0.0216094848701587,
         -0.00492434307383811,
         -0.0140442828948449,
         0.0186197744023191,
         -0.0754588948310405,
         0.06825775588098,
         -0.0590325728593825,
         0.0544682723494662,
         -0.0429996701781809,
         0.140508257056759,
         -0.0646751126442702,
         -0.00331688311886027,
         0.050908117628939,
         -0.0781884175340996,
         0.0761329613175602,
         -0.158766788202878,
         -0.0345906953574811,
         0.0891119925965124,
         -0.0700514135488228,
         0.0148283332578463,
         0.0500792727948589,
         -0.0910755842406232,
         0.177506665495474,
         -0.0869709167863518,
         -0.00159586368549993,
         0.0507699802474272,
         -0.0498114725974302,
         -0.000199606481946204,
         0.0771035906389512,
         -0.116205390141745,
         0.11730389549789,
         -0.082072289426905,
         0.035765058601496,
         -0.000443380951943142,
         0.000505398414103497,
         -0.0672113560819739,
         0.0166174196204647,
         -0.00276332386887141,
         -0.0125297935978949,
         0.0158165233958759,
         0.0818822629720915,
         -0.129956202459312,
         0.124757256532088,
         -0.0791339506095096,
         0.0263533669102394,
         -0.124056451412658,
         0.100509672360368,
         -0.0197061426697458,
         -0.0490703489310824,
         0.0662951776643484,
         -0.0357159716042069,
         0.102905376503475,
         -0.0365355089848557,
         -0.0276054321732923,
         0.0401933327948128,
         -0.0158906951930153,
         -0.0051486821449504,
         -0.00375486042460099,
         -0.0137677595457879,
         0.0613279272973843,
         -0.0651791933008729,
         0.0506819088491498,
         -0.0335805904484236,
         0.00562578009663026,
         0.0484753351661783,
         -0.0832454231779054,
         0.0433491127122893,
         0.0161498899547564,
         -0.071052197808197,
         0.106524724269899,
         -0.0946777817828039,
         -0.0267241799285968,
         0.102841513733672,
         -0.132531800672027,
         0.121572319594128,
         -0.0751011880640824,
         3.03847497945056e-05,
         0.0816020223690442,
         -0.105382843170998,
         0.114675989169675,
         -0.104360315620473,
         0.0850196663335383,
         -0.0552302557276712,
         0.0544466431567094,
         -0.040521098166612,
         0.0475184948667677,
         -0.0505748679155134,
         0.03253809279156,
         -0.00200532400425748,
         -0.0214737276796658,
         0.0651596344887134,
         -0.0866223897552781,
         0.0466860369385175,
         0.0264759203622161,
         -0.0780405731466436,
         0.0671720519974625,
         -0.0628188323926812,
         0.00471658498009439,
         0.083149353884271,
         -0.122584856314029,
         0.0831493538842711,
         0.00471658498009451,
         -0.0628188323926812,
         0.0671720519974626,
         -0.0780405731466433,
         0.0264759203622163,
         0.0466860369385176,
         -0.0866223897552781,
         0.0651596344887134,
         -0.0214737276796657,
         -0.00200532400425759,
         0.0325380927915599,
         -0.0505748679155134,
         0.0475184948667677,
         -0.0405210981666119,
         0.0544466431567094,
         -0.0552302557276711,
         0.0850196663335382,
         -0.104360315620473,
         0.114675989169675,
         -0.105382843170998,
         0.0816020223690443,
         3.03847497944668e-05,
         -0.0751011880640823,
         0.121572319594128,
         -0.132531800672027,
         0.102841513733672,
         -0.0267241799285968,
         -0.094677781782804,
         0.106524724269899,
         -0.0710521978081971,
         0.0161498899547566,
         0.0433491127122894,
         -0.0832454231779055,
         0.0484753351661785,
         0.00562578009663012,
         -0.0335805904484236,
         0.0506819088491497,
         -0.0651791933008728,
         0.0613279272973844,
         -0.0137677595457879,
         -0.00375486042460111,
         -0.00514868214495045,
         -0.0158906951930153,
         0.0401933327948127,
         -0.0276054321732923,
         -0.0365355089848557,
         0.102905376503475,
         -0.0357159716042069,
         0.0662951776643483,
         -0.0490703489310825,
         -0.0197061426697456,
         0.100509672360368,
         -0.124056451412658,
         0.0263533669102392,
         -0.0791339506095095,
         0.124757256532088,
         -0.129956202459312,
         0.0818822629720915,
         0.015816523395876,
         -0.0125297935978948,
         -0.00276332386887141,
         0.0166174196204648,
         -0.0672113560819741,
         0.000505398414103551,
         -0.000443380951943173,
         0.0357650586014957,
         -0.0820722894269049,
         0.117303895497891,
         -0.116205390141745,
         0.0771035906389512,
         -0.00019960648194611,
         -0.0498114725974303,
         0.0507699802474273,
         -0.00159586368549982,
         -0.0869709167863519,
         0.177506665495474,
         -0.0910755842406233,
         0.0500792727948589,
         0.0148283332578462,
         -0.0700514135488228,
         0.0891119925965125,
         -0.0345906953574811,
         -0.158766788202878,
         0.07613296131756,
         -0.0781884175340995,
         0.0509081176289388,
         -0.0033168831188602,
         -0.0646751126442704,
         0.14050825705676,
         -0.0429996701781809,
         0.0544682723494662,
         -0.0590325728593824,
         0.0682577558809801,
         -0.0754588948310403,
         0.0186197744023187,
         -0.0140442828948449,
         -0.00492434307383802,
         0.0216094848701587,
         -0.018206112395442,
         0.0278102960543291,
         -0.0248742849807495},
        {-0.0298505352860599,
         0.0333739130321929,
         -0.021848354672414,
         0.0476504044183925,
         -0.0325082665568699,
         0.00562614512197341,
         0.0093658970507975,
         -0.0367317934554131,
         -0.0082876960659087,
         0.0351474153930112,
         -0.0303908176654026,
         0.0100230470598536,
         0.054675101043233,
         -0.0161415456531369,
         0.0226170830056945,
         -0.0471645154415485,
         0.0568909748392424,
         -0.0389242891061251,
         -0.0499312408232943,
         -0.0237213266000655,
         0.0349923475109205,
         -0.0470379030460097,
         0.0729688795949548,
         -0.0956643491975556,
         0.0870133867312525,
         0.0558248243408991,
         -0.0164977460675474,
         -0.0137850620147157,
         0.043938683338515,
         -0.0856315473420471,
         0.13512998290144,
         -0.16200307334339,
         -0.0365459261713976,
         0.0306247784459612,
         -0.0141045990894075,
         -0.0131408325359398,
         0.0601688417451935,
         -0.139315291932171,
         0.260949358955435,
         -0.00665694468257814,
         0.0292605747819464,
         -0.0425688061616861,
         0.0348765248609524,
         -0.0244548565228744,
         0.00202211922318102,
         -0.00365126192416566,
         0.0246464114067696,
         -0.0367906113779433,
         -0.0366219879848557,
         0.094259288322701,
         -0.0845461864981175,
         0.0551845116511687,
         -0.0428578002043216,
         0.0450066318127964,
         0.0195203963953858,
         -0.0107137019154597,
         -0.0695843938863817,
         0.115185296724359,
         -0.110875273576366,
         0.0861557496916908,
         -0.0681407204177488,
         0.0113992136064301,
         0.0151360059595579,
         0.0290381561399489,
         -0.0906790164692148,
         0.123490606737375,
         -0.117293732109426,
         0.0933622092506065,
         -0.0394737176458169,
         0.0192855608433607,
         -0.028005160823247,
         0.0661624751946163,
         -0.105698799991902,
         0.116233073178436,
         -0.0904894456052464,
         0.0400180763224198,
         -0.0461777570980078,
         0.0542994319652981,
         -0.0763395755454475,
         0.107711222113702,
         -0.122574813777148,
         0.0338691979769439,
         -0.0357160433137079,
         0.0139110880961514,
         0.0142083988218697,
         -0.026884919934501,
         0.0788498672057796,
         -0.0963098904036025,
         0.111223483428966,
         -0.0967371073408569,
         0.0471218085632827,
         0.00906684736040237,
         0.00901597865960221,
         -0.0642493261716975,
         0.0739901159257143,
         -0.0945010030226437,
         0.111377824918158,
         -0.088601981713353,
         0.0184117579873442,
         -0.0279474327942703,
         0.0847929713180604,
         -0.0834390574278832,
         0.0747421928407488,
         -0.0834390574278831,
         0.0847929713180603,
         -0.0279474327942702,
         0.0184117579873442,
         -0.088601981713353,
         0.111377824918159,
         -0.0945010030226436,
         0.0739901159257142,
         -0.0642493261716974,
         0.00901597865960209,
         0.00906684736040235,
         0.0471218085632827,
         -0.096737107340857,
         0.111223483428966,
         -0.0963098904036026,
         0.0788498672057795,
         -0.0268849199345011,
         0.0142083988218696,
         0.0139110880961514,
         -0.0357160433137078,
         0.0338691979769439,
         -0.122574813777148,
         0.107711222113702,
         -0.0763395755454476,
         0.0542994319652981,
         -0.0461777570980077,
         0.0400180763224199,
         -0.0904894456052465,
         0.116233073178436,
         -0.105698799991902,
         0.0661624751946166,
         -0.0280051608232469,
         0.0192855608433609,
         -0.039473717645817,
         0.0933622092506066,
         -0.117293732109426,
         0.123490606737375,
         -0.0906790164692148,
         0.0290381561399491,
         0.015136005959558,
         0.01139921360643,
         -0.0681407204177488,
         0.0861557496916908,
         -0.110875273576366,
         0.115185296724359,
         -0.0695843938863818,
         -0.0107137019154596,
         0.0195203963953861,
         0.0450066318127966,
         -0.0428578002043216,
         0.0551845116511689,
         -0.0845461864981175,
         0.0942592883227008,
         -0.0366219879848558,
         -0.036790611377943,
         0.0246464114067696,
         -0.00365126192416562,
         0.00202211922318115,
         -0.0244548565228742,
         0.0348765248609523,
         -0.0425688061616864,
         0.0292605747819467,
         -0.00665694468257822,
         0.260949358955435,
         -0.139315291932171,
         0.0601688417451937,
         -0.0131408325359398,
         -0.0141045990894073,
         0.0306247784459612,
         -0.0365459261713977,
         -0.16200307334339,
         0.13512998290144,
         -0.0856315473420473,
         0.043938683338515,
         -0.0137850620147159,
         -0.0164977460675477,
         0.0558248243408992,
         0.0870133867312526,
         -0.0956643491975555,
         0.0729688795949548,
         -0.0470379030460095,
         0.0349923475109205,
         -0.0237213266000654,
         -0.0499312408232942,
         -0.0389242891061251,
         0.0568909748392423,
         -0.0471645154415484,
         0.0226170830056946,
         -0.0161415456531369,
         0.0546751010432332,
         0.0100230470598536,
         -0.0303908176654024,
         0.0351474153930115,
         -0.00828769606590859,
         -0.0367317934554132,
         0.00936589705079738,
         0.0056261451219732,
         -0.0325082665568699,
         0.0476504044183927,
         -0.021848354672414,
         0.033373913032193,
         -0.02985053528606},
        {0.0543059120057697,
         -0.0718399689439118,
         0.0543059120057697,
         -0.00653649724683124,
         -0.044501166135523,
         0.0988070781412927,
         -0.102075326764708,
         -0.0391248919466793,
         0.0705088589600296,
         -0.0354483650224058,
         -0.0558771327672202,
         0.120742147332244,
         0.0539728508210126,
         -0.0266512322834256,
         -0.0480952158587619,
         0.0835435808811676,
         -0.0168878719975765,
         -0.10386523047571,
         -0.0427651944981445,
         -0.0211907784562277,
         0.0571821399641168,
         -0.0095784590326694,
         -0.0744566567758132,
         0.0791827804312668,
         0.0566950457130152,
         0.0290693709210154,
         0.0291625464840688,
         -0.00773939487542418,
         -0.0521172294171242,
         0.0616956884497935,
         0.0159269875817661,
         -0.09751226196786,
         0.0059488007695227,
         -0.0304907510108188,
         -0.0131133053707046,
         -0.0199539141696699,
         0.0276933090450943,
         0.0217494360435984,
         -0.0802791052376455,
         0.0643521176558797,
         0.0462163944639801,
         -0.0551395956182649,
         0.0403354722311087,
         -0.0173774456401142,
         0.0329231647201867,
         -0.054403541169492,
         0.0362066574321536,
         0.032634347995508,
         -0.101355990082245,
         0.0729428286992978,
         -0.0304907510108187,
         0.0319121311006221,
         -0.0475220421127433,
         0.0794911882164799,
         -0.107928841180507,
         0.104330390467006,
         -0.0551395956182649,
         -0.105956232856516,
         0.120534270646975,
         -0.0821341920091751,
         0.0291560755809167,
         0.0878120226581669,
         -0.0282647643881029,
         -0.0352792399833705,
         0.0392913898306134,
         0.00235949574107243,
         -0.0270077884414148,
         -0.0457958476094318,
         0.0453127012166431,
         0.00251118345602442,
         -0.00998552862413393,
         -0.0496562227875568,
         -0.0188678244776731,
         0.0306488505631236,
         0.0295409100639989,
         -0.0537792523512111,
         0.0112753354973581,
         0.00759196768790047,
         0.0935574501948758,
         0.0150052635028566,
         0.0402221111564848,
         -0.0709130226413931,
         0.0166541164982314,
         0.041408752956329,
         -0.0172610986345096,
         -0.0301068991552689,
         -0.119368641198051,
         0.0235703518035074,
         -0.0678509058865962,
         0.00418825112321523,
         0.0742090237138772,
         -0.0675556066569805,
         -0.0014442969578262,
         0.0121310385431568,
         0.0759760851360061,
         0.108555871192562,
         -0.0137953109020405,
         0.0943733270479572,
         -0.0780113370317097,
         -0.00877763317076535,
         0.0631398654027589,
         -0.0272670318511495,
         -0.0172350505664294,
         -0.123844224815284,
         -0.00776490590118016,
         -0.0698610408868829,
         0.108995220763274,
         -0.0717280474495497,
         0.00285589146622268,
         0.00640979591700276,
         0.0848546428417253,
         0.0195500818029339,
         0.0175479055049883,
         -0.0623637581036453,
         0.0727099509150455,
         -0.0313734722788245,
         -0.0305767072454442,
         0.0920521396397231,
         -0.053786423033656,
         -0.0179201316142493,
         0.0632242684371194,
         -0.0559559786158319,
         -0.119067007138064,
         0.020161886348514,
         0.0350642824504098,
         -0.00274904933970589,
         -0.0592072991642927,
         0.071543303077448,
         0.079458892404223,
         0.0617119374040013,
         -0.0639413397305319,
         0.010314999396991,
         -0.00886107977872317,
         0.0624193910086469,
         -0.0760391563841115,
         0.00142534028328057,
         -0.104733871256125,
         0.0287179051446382,
         0.0166145573910673,
         0.00305588460012727,
         -0.000668463887484514,
         -0.0662130858613644,
         0.075024959028017,
         -0.0603599637489828,
         0.0451113634970516,
         0.0537380030823974,
         -0.0430676803332469,
         0.0173312876607794,
         -0.043067680333247,
         0.0537380030823974,
         0.0451113634970515,
         -0.0603599637489828,
         0.075024959028017,
         -0.0662130858613643,
         -0.000668463887484654,
         0.00305588460012739,
         0.0166145573910674,
         0.0287179051446384,
         -0.104733871256125,
         0.0014253402832806,
         -0.0760391563841116,
         0.0624193910086469,
         -0.0088610797787233,
         0.0103149993969908,
         -0.0639413397305319,
         0.0617119374040013,
         0.079458892404223,
         0.071543303077448,
         -0.0592072991642926,
         -0.0027490493397059,
         0.0350642824504097,
         0.0201618863485138,
         -0.119067007138064,
         -0.0559559786158318,
         0.0632242684371195,
         -0.0179201316142492,
         -0.053786423033656,
         0.0920521396397231,
         -0.0305767072454443,
         -0.0313734722788245,
         0.0727099509150456,
         -0.0623637581036453,
         0.0175479055049884,
         0.0195500818029338,
         0.0848546428417253,
         0.00640979591700276,
         0.00285589146622286,
         -0.0717280474495496,
         0.108995220763274,
         -0.0698610408868827,
         -0.00776490590118006,
         -0.123844224815284,
         -0.0172350505664294,
         -0.0272670318511494,
         0.0631398654027589,
         -0.00877763317076547,
         -0.0780113370317096,
         0.0943733270479571,
         -0.0137953109020405,
         0.108555871192562,
         0.075976085136006,
         0.0121310385431568,
         -0.00144429695782615,
         -0.0675556066569805,
         0.0742090237138774,
         0.00418825112321494,
         -0.067850905886596,
         0.0235703518035072,
         -0.119368641198051,
         -0.0301068991552688,
         -0.0172610986345097,
         0.0414087529563292,
         0.0166541164982313,
         -0.0709130226413929,
         0.0402221111564849,
         0.0150052635028568,
         0.0935574501948757,
         0.00759196768790053,
         0.0112753354973581,
         -0.0537792523512112,
         0.029540910063999,
         0.0306488505631236,
         -0.018867824477673,
         -0.0496562227875571,
         -0.00998552862413407,
         0.00251118345602439,
         0.0453127012166431,
         -0.0457958476094316,
         -0.0270077884414149,
         0.0023594957410725,
         0.0392913898306134,
         -0.0352792399833706,
         -0.0282647643881029,
         0.0878120226581669,
         0.0291560755809168,
         -0.0821341920091748,
         0.120534270646975,
         -0.105956232856516,
         -0.0551395956182648,
         0.104330390467007,
         -0.107928841180507,
         0.0794911882164799,
         -0.0475220421127433,
         0.031912131100622,
         -0.0304907510108188,
         0.0729428286992976,
         -0.101355990082245,
         0.0326343479955079,
         0.0362066574321537,
         -0.0544035411694921,
         0.0329231647201869,
         -0.0173774456401144,
         0.0403354722311087,
         -0.0551395956182649,
         0.0462163944639803,
         0.0643521176558796,
         -0.0802791052376454,
         0.0217494360435982,
         0.0276933090450944,
         -0.0199539141696698,
         -0.0131133053707045,
         -0.0304907510108189,
         0.0059488007695229,
         -0.09751226196786,
         0.0159269875817661,
         0.0616956884497935,
         -0.0521172294171241,
         -0.0077393948754242,
         0.0291625464840688,
         0.0290693709210155,
         0.0566950457130151,
         0.0791827804312668,
         -0.0744566567758132,
         -0.00957845903266935,
         0.0571821399641167,
         -0.0211907784562278,
         -0.0427651944981443,
         -0.10386523047571,
         -0.0168878719975763,
         0.0835435808811676,
         -0.0480952158587622,
         -0.0266512322834252,
         0.0539728508210124,
         0.120742147332244,
         -0.0558771327672202,
         -0.0354483650224055,
         0.0705088589600295,
         -0.0391248919466793,
         -0.102075326764709,
         0.0988070781412929,
         -0.044501166135523,
         -0.00653649724683109,
         0.0543059120057696,
         -0.0718399689439116,
         0.0543059120057697},
        {0.0336214393744076,
         -0.0444769836523589,
         0.0336214393744076,
         -0.0482612494603808,
         0.0387704348161635,
         -0.00514899544175563,
         -0.0189816292884346,
         0.0189752769046113,
         0.0338410848912282,
         -0.0771426182670841,
         0.0725743816199281,
         -0.0300188986753251,
         0.0355431347894811,
         -0.0846615459154819,
         0.0628177183377406,
         0.0143248999293434,
         -0.0808351748641522,
         0.0796030813248942,
         -0.0849967189361555,
         0.0712964478456683,
         0.0159743475796012,
         -0.0830541299496415,
         0.0644671659879984,
         0.0268980740580572,
         -0.101841064623464,
         0.105567430651577,
         -0.00526097128635745,
         -0.0792501734897657,
         0.0666985769014725,
         0.016355553048169,
         -0.0799834059951755,
         0.0421856741932661,
         0.089833981813044,
         -0.086624331594357,
         -0.0717268143830083,
         0.0776921951023028,
         0.00155797838746321,
         -0.064833804297628,
         0.0493175642904511,
         0.0306658417047247,
         -0.0784999000497148,
         -0.0562510726698512,
         0.114593219442932,
         -0.0148975172113488,
         -0.0553797004526232,
         0.0512342986314497,
         0.00300955379250903,
         -0.0466663517016997,
         0.0222488273798639,
         0.074413174632524,
         -0.0866243315943571,
         0.0676812325371373,
         -0.0216009838967505,
         -0.0119109229550203,
         0.0105488459958765,
         0.0226681635266581,
         -0.056251072669851,
         -0.00307012980074663,
         -0.0191687530737763,
         0.0429427008486724,
         -0.0444777657490457,
         0.0724159419743764,
         -0.0773036712100929,
         0.0814206702424468,
         -0.0980074891842424,
         0.0986044303983148,
         -0.117828383953402,
         0.0770881994703072,
         -0.0329231709902815,
         -0.00251773169352844,
         0.0516491838215055,
         -0.101739337776826,
         0.114660066502878,
         -0.0203803154584846,
         -0.0177971661536389,
         0.0220704748940783,
         -0.0249556509080112,
         0.00803126669533424,
         0.0588599075744852,
         -0.0770416505174136,
         -0.0192752031378603,
         0.00810560770132692,
         0.00268541992960901,
         0.0123870412522125,
         -0.015626321333411,
         -0.00736445207771373,
         -0.0103477041607919,
         0.0344630646860248,
         0.0127030343946631,
         0.0131473472857547,
         0.0156674820521295,
         -0.0481814123725767,
         0.0284799454353021,
         0.0256961826935076,
         -0.0394431702297625,
         -0.00771789064037795,
         0.00955805525708496,
         0.0167104972425844,
         -0.0645090726165283,
         0.045638452102298,
         0.0290650078219327,
         -0.0823656765055287,
         0.0478655842164916,
         0.0513523508944359,
         -0.070810707543207,
         0.0394926219947605,
         0.0456968191981252,
         -0.104448352598068,
         0.0830465859070734,
         0.00805023534448429,
         -0.091127865828305,
         0.0880422398862195,
         -0.110928096274578,
         0.0735681515490688,
         0.00167894644409967,
         -0.0704226383418949,
         0.0872689205081162,
         -0.0780134626972608,
         0.126008925540326,
         -0.130331796846282,
         0.090148860898441,
         -0.0326536701735703,
         0.0477730130190906,
         -0.0602363486061305,
         0.0273495450201608,
         0.012530073661951,
         -0.0138176449135821,
         -0.0246168304913557,
         0.00548768679881347,
         0.0306130876779104,
         -0.0268193623580757,
         0.0231582602507462,
         -0.0310742480319807,
         0.00926982928723012,
         0.0742693517100577,
         -0.03448797845998,
         -0.0619067534760959,
         0.0488257300308978,
         -0.0143722774116823,
         -0.0196860742544455,
         0.0618242428963356,
         -0.0684305405085668,
         -0.0710177573285411,
         0.0260393755657657,
         0.095210932845979,
         -0.00859962749249527,
         -0.047546985735185,
         0.0604483980750466,
         -0.047546985735185,
         -0.00859962749249532,
         0.0952109328459789,
         0.0260393755657655,
         -0.0710177573285412,
         -0.0684305405085668,
         0.0618242428963357,
         -0.0196860742544455,
         -0.0143722774116825,
         0.048825730030898,
         -0.0619067534760961,
         -0.0344879784599801,
         0.0742693517100578,
         0.00926982928723001,
         -0.0310742480319809,
         0.0231582602507461,
         -0.0268193623580756,
         0.0306130876779103,
         0.00548768679881339,
         -0.0246168304913556,
         -0.0138176449135822,
         0.0125300736619511,
         0.0273495450201607,
         -0.0602363486061304,
         0.0477730130190906,
         -0.0326536701735703,
         0.090148860898441,
         -0.130331796846282,
         0.126008925540326,
         -0.0780134626972607,
         0.087268920508116,
         -0.0704226383418949,
         0.00167894644409971,
         0.0735681515490688,
         -0.110928096274578,
         0.0880422398862194,
         -0.0911278658283049,
         0.00805023534448436,
         0.0830465859070735,
         -0.104448352598068,
         0.0456968191981254,
         0.0394926219947604,
         -0.0708107075432072,
         0.0513523508944359,
         0.0478655842164917,
         -0.0823656765055286,
         0.0290650078219325,
         0.0456384521022981,
         -0.0645090726165284,
         0.0167104972425843,
         0.00955805525708496,
         -0.00771789064037791,
         -0.0394431702297625,
         0.0256961826935075,
         0.0284799454353021,
         -0.0481814123725767,
         0.0156674820521295,
         0.0131473472857546,
         0.0127030343946633,
         0.0344630646860246,
         -0.010347704160792,
         -0.00736445207771368,
         -0.0156263213334109,
         0.0123870412522125,
         0.00268541992960896,
         0.00810560770132691,
         -0.0192752031378603,
         -0.0770416505174138,
         0.0588599075744852,
         0.00803126669533424,
         -0.0249556509080113,
         0.0220704748940781,
         -0.0177971661536387,
         -0.0203803154584847,
         0.114660066502878,
         -0.101739337776826,
         0.0516491838215054,
         -0.00251773169352852,
         -0.0329231709902815,
         0.0770881994703073,
         -0.117828383953402,
         0.0986044303983147,
         -0.0980074891842424,
         0.0814206702424467,
         -0.0773036712100928,
         0.0724159419743765,
         -0.0444777657490457,
         0.0429427008486725,
         -0.0191687530737764,
         -0.00307012980074664,
         -0.0562510726698511,
         0.0226681635266581,
         0.0105488459958765,
         -0.0119109229550202,
         -0.0216009838967506,
         0.0676812325371373,
         -0.0866243315943573,
         0.0744131746325239,
         0.0222488273798639,
         -0.0466663517016995,
         0.00300955379250916,
         0.0512342986314497,
         -0.0553797004526233,
         -0.0148975172113487,
         0.114593219442932,
         -0.0562510726698511,
         -0.0784999000497151,
         0.0306658417047246,
         0.049317564290451,
         -0.0648338042976279,
         0.00155797838746332,
         0.0776921951023026,
         -0.0717268143830084,
         -0.0866243315943571,
         0.0898339818130441,
         0.0421856741932662,
         -0.0799834059951755,
         0.0163555530481691,
         0.0666985769014724,
         -0.0792501734897657,
         -0.00526097128635743,
         0.105567430651577,
         -0.101841064623465,
         0.0268980740580571,
         0.0644671659879985,
         -0.0830541299496413,
         0.015974347579601,
         0.0712964478456682,
         -0.0849967189361556,
         0.0796030813248941,
         -0.0808351748641525,
         0.0143248999293435,
         0.0628177183377408,
         -0.0846615459154819,
         0.0355431347894813,
         -0.0300188986753252,
         0.0725743816199281,
         -0.0771426182670844,
         0.0338410848912281,
         0.0189752769046114,
         -0.0189816292884345,
         -0.00514899544175574,
         0.0387704348161634,
         -0.0482612494603809,
         0.0336214393744076,
         -0.0444769836523588,
         0.0336214393744077},
        {-0.000890421773024286,
         0.00117791728668952,
         -0.000890421773024197,
         -0.0348608358787632,
         0.0531816755911689,
         -0.0540720973641929,
         0.0366416794248117,
         0.0588690976073748,
         -0.0469636650035143,
         7.01150897366308e-05,
         0.0476252718009099,
         -0.0607774950949088,
         -0.0769316150861221,
         0.0333359174626956,
         0.0134077484110815,
         -0.0134778635008181,
         -0.0339049102884221,
         0.0791019425689052,
         0.0936088432333842,
         -0.0187737009763181,
         -0.0174051777598396,
         0.0042136605092262,
         0.00948043415206033,
         0.0259730099992047,
         -0.100696108619993,
         -0.0978625174969477,
         -0.018548634889752,
         0.0434710395434213,
         -0.0274758308037527,
         0.0232621702945264,
         -0.0315488665868843,
         0.000445528615678731,
         0.120018081894389,
         0.0702295408846552,
         0.0765642353607665,
         -0.0555320603273295,
         0.012061020783908,
         0.014004840999674,
         -0.036073273434498,
         0.0676221400213824,
         -0.068127321986689,
         -0.111899800854894,
         -0.0929049499355201,
         -0.00633469447611168,
         0.0545613492108386,
         -0.061852414684517,
         0.0501351240421242,
         -0.021033424088155,
         -0.0437724788682054,
         0.148029522409852,
         0.0702295408846549,
         -0.0425965642723621,
         0.001131215450759,
         0.0380457366322321,
         -0.0735271437003352,
         0.1037815198154,
         -0.111899800854894,
         0.0511895367168742,
         -0.0761546818014898,
         0.0755250585276682,
         -0.0499302901692309,
         -0.0321827981802974,
         0.0243462685944617,
         0.00153465328047149,
         -0.0262136448485908,
         0.0317709957321073,
         0.03156129612093,
         -0.0489556887054708,
         0.0592701060031825,
         -0.0606565955497389,
         0.0513821885979405,
         -0.0318979494521289,
         -0.0461191366198778,
         0.0762356274634518,
         -0.0534272671505157,
         -0.00927329476648729,
         0.0723688027733667,
         -0.094130771753563,
         0.057362783957503,
         0.0437011316966597,
         -0.0510818533504296,
         -0.0231626603726403,
         0.0889377517479567,
         -0.0815488632480167,
         0.000755462720988732,
         0.0863124957232191,
         -0.0799834203262955,
         -0.0105808543053145,
         0.0106825478071816,
         0.0602866071279065,
         -0.0563634638766718,
         -0.0202867227881904,
         0.0914324272196596,
         -0.077356476513327,
         -0.0260448327803845,
         0.0676441248487102,
         -0.0337885031411858,
         -0.0274964683471414,
         -0.00985893711439768,
         0.0574302333068604,
         -0.0444477135233927,
         -0.0275753192027102,
         0.0828359183633906,
         -0.0223410792751456,
         0.0834482877403431,
         -0.0283963824866612,
         0.00760611955658357,
         -0.0276041383472651,
         0.0446625913268212,
         -0.0145638496311751,
         -0.0567840287227745,
         -0.0887387148930004,
         0.0931325029972584,
         -0.0832366697487611,
         0.0837044964016786,
         -0.0945058429381014,
         0.0906060911471299,
         -0.0562973855082294,
         0.0446825430545112,
         -0.000810299531988018,
         -0.0428897958551405,
         0.0544738348848447,
         0.0105468055882579,
         0.0674925424482911,
         -0.130384219430941,
         0.13003838663434,
         -0.0673142267575546,
         -0.00928071416350009,
         0.0252149193926615,
         -0.0791073756624193,
         0.0591078774658691,
         0.0184632880279175,
         -0.0930907473470574,
         0.106061246141485,
         -0.0441063871696413,
         -0.00933884054701539,
         0.0144720896349715,
         0.0233815921058201,
         -0.0529079925195876,
         0.0404713722664056,
         0.0102810965542542,
         -0.0607818946264051,
         0.0584059786108784,
         -0.0311438116955943,
         0.0080635248890081,
         0.00807994234484782,
         -0.0193533362686906,
         0.0235481159421277,
         -0.0193533362686906,
         0.00807994234484779,
         0.00806352488900818,
         -0.0311438116955944,
         0.0584059786108785,
         -0.060781894626405,
         0.010281096554254,
         0.0404713722664058,
         -0.0529079925195876,
         0.0233815921058201,
         0.0144720896349714,
         -0.00933884054701531,
         -0.0441063871696414,
         0.106061246141485,
         -0.0930907473470574,
         0.0184632880279175,
         0.0591078774658691,
         -0.0791073756624192,
         0.0252149193926615,
         -0.00928071416350017,
         -0.0673142267575544,
         0.13003838663434,
         -0.130384219430941,
         0.0674925424482912,
         0.0105468055882579,
         0.0544738348848446,
         -0.0428897958551404,
         -0.00081029953198818,
         0.0446825430545112,
         -0.0562973855082294,
         0.0906060911471297,
         -0.0945058429381013,
         0.0837044964016786,
         -0.083236669748761,
         0.0931325029972585,
         -0.0887387148930005,
         -0.0567840287227743,
         -0.0145638496311751,
         0.0446625913268215,
         -0.027604138347265,
         0.00760611955658359,
         -0.0283963824866612,
         0.0834482877403431,
         -0.0223410792751457,
         0.0828359183633905,
         -0.0275753192027101,
         -0.0444477135233928,
         0.0574302333068602,
         -0.00985893711439784,
         -0.0274964683471414,
         -0.0337885031411858,
         0.0676441248487104,
         -0.0260448327803847,
         -0.077356476513327,
         0.0914324272196596,
         -0.0202867227881903,
         -0.0563634638766719,
         0.0602866071279064,
         0.0106825478071818,
         -0.0105808543053145,
         -0.0799834203262954,
         0.0863124957232192,
         0.000755462720988794,
         -0.0815488632480167,
         0.0889377517479568,
         -0.0231626603726404,
         -0.0510818533504298,
         0.0437011316966598,
         0.0573627839575031,
         -0.0941307717535631,
         0.0723688027733668,
         -0.0092732947664872,
         -0.0534272671505157,
         0.0762356274634516,
         -0.0461191366198776,
         -0.0318979494521289,
         0.0513821885979405,
         -0.060656595549739,
         0.0592701060031824,
         -0.0489556887054708,
         0.03156129612093,
         0.0317709957321074,
         -0.0262136448485909,
         0.00153465328047142,
         0.0243462685944617,
         -0.0321827981802973,
         -0.0499302901692311,
         0.075525058527668,
         -0.0761546818014898,
         0.0511895367168742,
         -0.111899800854894,
         0.1037815198154,
         -0.073527143700335,
         0.0380457366322321,
         0.00113121545075905,
         -0.0425965642723622,
         0.0702295408846551,
         0.148029522409852,
         -0.0437724788682054,
         -0.021033424088155,
         0.050135124042124,
         -0.061852414684517,
         0.0545613492108385,
         -0.00633469447611149,
         -0.0929049499355203,
         -0.111899800854894,
         -0.0681273219866891,
         0.0676221400213826,
         -0.036073273434498,
         0.014004840999674,
         0.012061020783908,
         -0.0555320603273298,
         0.0765642353607667,
         0.070229540884655,
         0.120018081894389,
         0.000445528615678674,
         -0.0315488665868843,
         0.0232621702945264,
         -0.0274758308037526,
         0.0434710395434216,
         -0.018548634889752,
         -0.0978625174969475,
         -0.100696108619994,
         0.0259730099992048,
         0.00948043415206037,
         0.00421366050922624,
         -0.0174051777598395,
         -0.018773700976318,
         0.0936088432333842,
         0.0791019425689052,
         -0.0339049102884222,
         -0.0134778635008181,
         0.0134077484110814,
         0.0333359174626958,
         -0.0769316150861221,
         -0.0607774950949088,
         0.0476252718009099,
         7.01150897367036e-05,
         -0.0469636650035142,
         0.0588690976073748,
         0.0366416794248114,
         -0.0540720973641929,
         0.0531816755911688,
         -0.0348608358787632,
         -0.00089042177302434,
         0.00117791728668974,
         -0.000890421773024261},
        {-0.109413388162106,
         0.144740307588955,
         -0.109413388162106,
         0.110746388933641,
         -0.0567061952383555,
         -0.0527071929237502,
         0.10808038739057,
         -0.0862169733481692,
         -0.0101826974853005,
         0.0682522889048874,
         -0.0137094860242395,
         -0.081755899504639,
         0.0601296183491966,
         0.0342521856121964,
         -0.0293930985093973,
         -0.0388591903954903,
         0.0455178916834366,
         0.0487724139754483,
         -0.048652150811132,
         -0.0220950481933596,
         -0.0145305584506034,
         0.0462995997191698,
         -0.00506446656451045,
         -0.0412806549531924,
         -0.0238902017468864,
         0.0579935888659309,
         0.000207497926903775,
         0.0261733531915476,
         -0.0122725832370712,
         -0.0340270164820987,
         0.037345328783567,
         0.0105781467881129,
         0.0205579252582826,
         -0.0735025393834982,
         -0.0134878439153986,
         0.0132525633816206,
         -0.039425916573168,
         0.0510687113141122,
         -0.0187878490950559,
         -0.0185574796885111,
         0.00656298865996117,
         -0.0373998765473847,
         0.0972347199702335,
         -0.0600146954680997,
         0.0412403240919927,
         -0.00613791826602661,
         -0.0365892310970996,
         0.0551377614921413,
         -0.0439628652073457,
         0.0494753862044482,
         -0.0735025393834983,
         0.089011489901065,
         -0.100555026617305,
         0.0992768346493812,
         -0.0802541513965897,
         0.0542418278364869,
         -0.0373998765473846,
         0.0754818009522623,
         -0.0358557527063723,
         -0.0415111960156486,
         0.0792520964917795,
         -0.0863392663215163,
         -0.0172769570172326,
         0.0770053655417529,
         -0.0153918092474737,
         -0.0887238105928861,
         0.0652328305661661,
         0.0720385586366554,
         -0.0633827084886314,
         -0.0367040780025015,
         0.0497176149462371,
         0.0793498348833835,
         -0.0187646661893652,
         -0.112220307450078,
         0.0341363111284297,
         0.0412559166453539,
         0.0130601049590898,
         -0.0784493586793391,
         -0.0500417988684086,
         -0.0386577672309409,
         0.115211227270481,
         0.0153019696530771,
         -0.0452627526809305,
         -0.0166989744250421,
         0.00504683147412445,
         0.0977018851717576,
         -0.00127444343500082,
         0.0739071121926195,
         -0.053791475291867,
         -0.0840231919656165,
         0.0555552626833603,
         -0.00480404392690678,
         0.0367203627370442,
         -0.0596449470311316,
         -0.0627853986075032,
         0.0502638222520709,
         -0.0588865242564262,
         0.112717383880189,
         -0.0216315150514762,
         -0.0145510868790816,
         -0.00373001888869414,
         -0.023931900603121,
         0.10468662765219,
         -0.0489500270559107,
         0.00691238022392357,
         -0.0757244434519835,
         0.0630106052079913,
         -0.0448578355298895,
         0.0678222067996857,
         -0.0866035145373785,
         0.0225043207337153,
         0.0300411758723863,
         -0.0109145131373726,
         0.0142499060096558,
         -0.0311442309866049,
         0.0288533549299375,
         0.00262759039231997,
         -0.038114286237505,
         -0.00510517919699691,
         0.0292618292196559,
         -0.00184000747999963,
         -0.0422444380684146,
         0.0579884179205735,
         0.0211985449466798,
         -0.0101675313369167,
         -0.0537994233340974,
         0.0546059909895909,
         0.0407778999200144,
         -0.0804852216350814,
         -0.0124769223484032,
         -0.0534460772434232,
         0.101898055626361,
         -0.031553505047928,
         -0.0465185527110385,
         -0.0507630074479944,
         0.0992426048516831,
         0.00569288411624452,
         0.0811578125060476,
         -0.0518103769877193,
         -0.0674554026660451,
         0.0867747830169924,
         0.0152831457507904,
         0.0787669151341269,
         -0.0902971637257686,
         -0.0331405639283489,
         -0.0490871868764036,
         -0.0452952552339346,
         0.121897062879777,
         -0.0452952552339346,
         -0.0490871868764037,
         -0.0331405639283489,
         -0.0902971637257684,
         0.078766915134127,
         0.0152831457507904,
         0.0867747830169924,
         -0.0674554026660452,
         -0.0518103769877194,
         0.0811578125060478,
         0.00569288411624452,
         0.0992426048516831,
         -0.0507630074479945,
         -0.0465185527110383,
         -0.0315535050479279,
         0.101898055626361,
         -0.0534460772434231,
         -0.0124769223484031,
         -0.0804852216350813,
         0.0407778999200146,
         0.0546059909895908,
         -0.0537994233340974,
         -0.0101675313369165,
         0.0211985449466799,
         0.0579884179205735,
         -0.0422444380684146,
         -0.00184000747999962,
         0.0292618292196557,
         -0.00510517919699698,
         -0.0381142862375049,
         0.0026275903923201,
         0.0288533549299375,
         -0.0311442309866047,
         0.0142499060096558,
         -0.0109145131373727,
         0.0300411758723862,
         0.0225043207337153,
         -0.0866035145373783,
         0.0678222067996857,
         -0.0448578355298895,
         0.0630106052079913,
         -0.0757244434519835,
         0.0069123802239234,
         -0.0489500270559109,
         0.10468662765219,
         -0.023931900603121,
         -0.00373001888869407,
         -0.0145510868790816,
         -0.0216315150514762,
         0.112717383880189,
         -0.0588865242564262,
         0.0502638222520708,
         -0.062785398607503,
         -0.0596449470311315,
         0.0367203627370443,
         -0.00480404392690657,
         0.0555552626833605,
         -0.0840231919656165,
         -0.053791475291867,
         0.0739071121926193,
         -0.00127444343500062,
         0.0977018851717575,
         0.0050468314741243,
         -0.0166989744250421,
         -0.0452627526809306,
         0.015301969653077,
         0.115211227270481,
         -0.0386577672309409,
         -0.0500417988684086,
         -0.0784493586793392,
         0.0130601049590899,
         0.0412559166453539,
         0.0341363111284298,
         -0.112220307450077,
         -0.0187646661893653,
         0.0793498348833834,
         0.0497176149462371,
         -0.0367040780025016,
         -0.0633827084886314,
         0.0720385586366554,
         0.0652328305661664,
         -0.088723810592886,
         -0.0153918092474737,
         0.077005365541753,
         -0.0172769570172327,
         -0.0863392663215162,
         0.0792520964917796,
         -0.0415111960156485,
         -0.0358557527063723,
         0.0754818009522624,
         -0.0373998765473846,
         0.0542418278364868,
         -0.0802541513965899,
         0.0992768346493814,
         -0.100555026617305,
         0.0890114899010652,
         -0.0735025393834982,
         0.0494753862044483,
         -0.0439628652073456,
         0.0551377614921412,
         -0.0365892310970995,
         -0.0061379182660267,
         0.0412403240919927,
         -0.0600146954680997,
         0.0972347199702335,
         -0.0373998765473848,
         0.00656298865996091,
         -0.0185574796885111,
         -0.0187878490950558,
         0.0510687113141123,
         -0.0394259165731679,
         0.0132525633816206,
         -0.0134878439153987,
         -0.073502539383498,
         0.0205579252582826,
         0.010578146788113,
         0.0373453287835669,
         -0.0340270164820986,
         -0.0122725832370712,
         0.0261733531915476,
         0.000207497926903641,
         0.057993588865931,
         -0.0238902017468864,
         -0.0412806549531926,
         -0.00506446656451045,
         0.0462995997191698,
         -0.0145305584506035,
         -0.0220950481933596,
         -0.0486521508111319,
         0.0487724139754482,
         0.0455178916834366,
         -0.0388591903954903,
         -0.0293930985093971,
         0.0342521856121963,
         0.0601296183491965,
         -0.0817558995046389,
         -0.0137094860242396,
         0.0682522889048873,
         -0.0101826974853005,
         -0.0862169733481691,
         0.108080387390571,
         -0.05270719292375,
         -0.0567061952383556,
         0.110746388933641,
         -0.109413388162105,
         0.144740307588955,
         -0.109413388162106},
        {-0.0535977507647971,
         -0.0388247116423502,
         0.0924224624071475,
         0.0584646335246738,
         -0.0253550301236848,
         -0.0727825405248232,
         -0.0661811968723215,
         0.0109128685411544,
         0.0168621753487759,
         0.0608591819901473,
         0.0305080148335438,
         0.050449497852244,
         -0.0672191045111225,
         0.0445001910446224,
         -0.092325568841897,
         0.0554150919210417,
         -0.110926253838304,
         0.071064125041322,
         -0.0097017586479235,
         -0.0317664773158179,
         0.116931776364264,
         -0.171923356678699,
         0.116508264757657,
         -0.0305851580030718,
         -0.0196647667127357,
         0.0265249460421178,
         -0.00191873851975019,
         -0.115013037844514,
         0.0924224624071473,
         -0.0388247116423502,
         -0.0253550301236848,
         -0.0208645476275908,
         -0.0253550301236848,
         0.0109128685411543,
         -0.0411645570827628,
         0.0816690265926776,
         0.0168621753487759,
         0.0504494978522439,
         -0.0205982939005297,
         0.0592047417749104,
         -0.147638672762998,
         0.0445001910446224,
         -0.110926253838304,
         0.0413507990132096,
         -0.0618112433511658,
         0.0501375862013572,
         0.0704031410090103,
         -0.0317664773158177,
         0.116508264757657,
         -0.0287181787543898,
         0.0732904864957657,
         -0.0671147240601155,
         0.0282057584872586,
         -0.0740026919739017,
         -0.0019187385197502,
         0.0554150919210416,
         -0.110926253838304,
         0.071064125041322,
         -0.00970175864792342,
         -0.0317664773158178,
         0.116931776364264,
         -0.0727825405248235,
         -0.0253550301236848,
         0.0584646335246738,
         0.0168621753487759,
         0.0816690265926777,
         -0.041164557082763,
         0.0109128685411545,
         -0.0672191045111224,
         0.0592047417749104,
         -0.105360014672688,
         0.0592047417749103,
         -0.0672191045111225,
         0.0710641250413218,
         -0.0618112433511658,
         0.0234535733195054,
         0.0278601537175383,
         0.0501375862013574,
         -0.0097017586479234,
         -0.0305851580030719,
         0.0732904864957658,
         -0.0469304609272261,
         0.0799025747591783,
         -0.153531873378955,
         0.0282057584872588,
         0.0265249460421178,
         -0.110926253838304,
         0.0413507990132095,
         -0.0618112433511657,
         0.0501375862013573,
         0.0704031410090104,
         -0.0317664773158177,
         0.0305080148335436,
         0.0504494978522439,
         -0.0672191045111226,
         0.0445001910446227,
         -0.0923255688418969,
         0.0608591819901473,
         0.016862175348776,
         0.0109128685411545,
         -0.0661811968723215,
         0.0445001910446227,
         -0.147638672762998,
         0.0592047417749105,
         -0.0205982939005296,
         0.050449497852244,
         -0.0097017586479235,
         0.0501375862013573,
         0.0278601537175383,
         0.0234535733195054,
         -0.0618112433511656,
         0.071064125041322,
         -0.0196647667127358,
         -0.0671147240601153,
         0.0799025747591785,
         -0.131216301796222,
         0.0799025747591785,
         -0.0671147240601153,
         -0.019664766712736,
         0.071064125041322,
         -0.0618112433511658,
         0.0234535733195053,
         0.0278601537175383,
         0.0501375862013572,
         -0.00970175864792346,
         0.0504494978522438,
         -0.0205982939005296,
         0.0592047417749104,
         -0.147638672762999,
         0.0445001910446226,
         -0.0661811968723214,
         0.0109128685411545,
         0.0168621753487759,
         0.0608591819901474,
         -0.092325568841897,
         0.0445001910446226,
         -0.0672191045111224,
         0.050449497852244,
         0.0305080148335438,
         -0.0317664773158178,
         0.0704031410090104,
         0.0501375862013574,
         -0.0618112433511658,
         0.0413507990132096,
         -0.110926253838304,
         0.0265249460421177,
         0.0282057584872587,
         -0.153531873378955,
         0.0799025747591786,
         -0.0469304609272259,
         0.0732904864957657,
         -0.0305851580030715,
         -0.00970175864792341,
         0.0501375862013573,
         0.0278601537175383,
         0.0234535733195052,
         -0.0618112433511657,
         0.071064125041322,
         -0.0672191045111225,
         0.0592047417749103,
         -0.105360014672689,
         0.0592047417749105,
         -0.0672191045111225,
         0.0109128685411544,
         -0.041164557082763,
         0.0816690265926776,
         0.0168621753487759,
         0.0584646335246739,
         -0.0253550301236848,
         -0.0727825405248233,
         0.116931776364264,
         -0.0317664773158178,
         -0.00970175864792337,
         0.0710641250413221,
         -0.110926253838304,
         0.0554150919210416,
         -0.00191873851975029,
         -0.0740026919739015,
         0.0282057584872588,
         -0.0671147240601152,
         0.0732904864957656,
         -0.0287181787543897,
         0.116508264757657,
         -0.031766477315818,
         0.0704031410090104,
         0.0501375862013572,
         -0.0618112433511658,
         0.0413507990132094,
         -0.110926253838304,
         0.0445001910446225,
         -0.147638672762998,
         0.0592047417749104,
         -0.0205982939005294,
         0.0504494978522441,
         0.016862175348776,
         0.0816690265926777,
         -0.041164557082763,
         0.0109128685411544,
         -0.0253550301236849,
         -0.0208645476275908,
         -0.0253550301236849,
         -0.0388247116423501,
         0.0924224624071473,
         -0.115013037844514,
         -0.00191873851975025,
         0.0265249460421177,
         -0.0196647667127359,
         -0.0305851580030717,
         0.116508264757657,
         -0.171923356678699,
         0.116931776364264,
         -0.0317664773158179,
         -0.00970175864792352,
         0.0710641250413221,
         -0.110926253838304,
         0.0554150919210417,
         -0.0923255688418968,
         0.0445001910446226,
         -0.0672191045111225,
         0.050449497852244,
         0.0305080148335437,
         0.0608591819901475,
         0.0168621753487761,
         0.0109128685411544,
         -0.0661811968723215,
         -0.0727825405248234,
         -0.0253550301236847,
         0.0584646335246739,
         0.0924224624071473,
         -0.0388247116423501,
         -0.0535977507647971},
        {0.00641440806980907,
         -0.0474424439677582,
         0.0410280358979489,
         0.0452550263371674,
         0.00282394401815939,
         -0.0432154535285397,
         -0.0354598795959514,
         -0.0138524293668623,
         0.0107589536871068,
         0.0356077244179142,
         0.0592690478903648,
         -0.0336712487107828,
         0.0520595809974799,
         -0.058282631764752,
         0.00560431972834047,
         -0.103194662418713,
         0.0567077245134063,
         -0.0284489510907797,
         -0.0190747269868653,
         0.0706172839621342,
         -0.0603042326762896,
         -0.00172461988247592,
         0.104919282301189,
         -0.148844896829537,
         0.168961343063472,
         -0.155473474261777,
         0.100773561313828,
         -0.0404693286375386,
         0.0410280358979489,
         -0.0474424439677581,
         0.00282394401815934,
         0.00276871201882465,
         0.00282394401815928,
         -0.0138524293668622,
         -0.0293104289057199,
         0.0243542992563044,
         0.0107589536871069,
         -0.0336712487107829,
         0.10266850966721,
         -0.0696297055682334,
         0.0316009056533444,
         -0.0582826317647521,
         0.0567077245134062,
         -0.0848600688487851,
         0.00657346760007961,
         0.0262445552191054,
         -0.0143467530157465,
         0.0706172839621343,
         0.104919282301189,
         -0.0749339774297227,
         0.11586843175016,
         -0.101752712992213,
         0.0912826902852509,
         -0.131635850217454,
         0.100773561313828,
         -0.103194662418713,
         0.0567077245134062,
         -0.0284489510907798,
         -0.0190747269868653,
         0.0706172839621344,
         -0.0603042326762896,
         -0.0432154535285395,
         0.00282394401815925,
         0.0452550263371673,
         0.0107589536871071,
         0.0243542992563044,
         -0.0293104289057199,
         -0.0138524293668623,
         0.0520595809974799,
         -0.0696297055682334,
         0.0812316504737445,
         -0.0696297055682334,
         0.0520595809974799,
         -0.0284489510907799,
         0.0065734676000797,
         -0.033593861814067,
         0.0159251453605966,
         0.0262445552191054,
         -0.0190747269868652,
         -0.148844896829537,
         0.11586843175016,
         -0.0382092358725604,
         0.0658023702106393,
         -0.105685407079892,
         0.0912826902852508,
         -0.155473474261778,
         0.0567077245134064,
         -0.0848600688487851,
         0.00657346760007961,
         0.0262445552191054,
         -0.0143467530157465,
         0.0706172839621343,
         0.0592690478903649,
         -0.0336712487107829,
         0.0520595809974801,
         -0.0582826317647523,
         0.00560431972834069,
         0.0356077244179142,
         0.010758953687107,
         -0.0138524293668622,
         -0.0354598795959515,
         -0.0582826317647521,
         0.0316009056533445,
         -0.0696297055682334,
         0.10266850966721,
         -0.0336712487107829,
         -0.0190747269868653,
         0.0262445552191054,
         0.0159251453605967,
         -0.033593861814067,
         0.0065734676000797,
         -0.0284489510907798,
         0.168961343063472,
         -0.101752712992213,
         0.0658023702106391,
         -0.048133653757169,
         0.0658023702106392,
         -0.101752712992213,
         0.168961343063472,
         -0.0284489510907799,
         0.00657346760007983,
         -0.0335938618140669,
         0.0159251453605967,
         0.0262445552191055,
         -0.0190747269868654,
         -0.0336712487107828,
         0.10266850966721,
         -0.0696297055682334,
         0.0316009056533445,
         -0.058282631764752,
         -0.0354598795959514,
         -0.0138524293668623,
         0.0107589536871069,
         0.0356077244179142,
         0.00560431972834043,
         -0.0582826317647522,
         0.05205958099748,
         -0.0336712487107828,
         0.0592690478903648,
         0.0706172839621343,
         -0.0143467530157467,
         0.0262445552191055,
         0.00657346760007975,
         -0.084860068848785,
         0.0567077245134064,
         -0.155473474261777,
         0.091282690285251,
         -0.105685407079892,
         0.0658023702106392,
         -0.0382092358725606,
         0.11586843175016,
         -0.148844896829537,
         -0.0190747269868653,
         0.0262445552191053,
         0.0159251453605967,
         -0.0335938618140669,
         0.00657346760007972,
         -0.0284489510907797,
         0.0520595809974799,
         -0.0696297055682335,
         0.0812316504737444,
         -0.0696297055682334,
         0.05205958099748,
         -0.0138524293668623,
         -0.0293104289057199,
         0.0243542992563043,
         0.0107589536871071,
         0.0452550263371674,
         0.00282394401815936,
         -0.0432154535285394,
         -0.0603042326762896,
         0.0706172839621343,
         -0.0190747269868653,
         -0.0284489510907798,
         0.0567077245134063,
         -0.103194662418713,
         0.100773561313828,
         -0.131635850217454,
         0.091282690285251,
         -0.101752712992213,
         0.11586843175016,
         -0.074933977429723,
         0.104919282301189,
         0.0706172839621344,
         -0.0143467530157466,
         0.0262445552191054,
         0.00657346760007956,
         -0.084860068848785,
         0.0567077245134063,
         -0.0582826317647522,
         0.0316009056533445,
         -0.0696297055682335,
         0.10266850966721,
         -0.0336712487107827,
         0.010758953687107,
         0.0243542992563045,
         -0.0293104289057197,
         -0.0138524293668623,
         0.0028239440181594,
         0.00276871201882487,
         0.00282394401815932,
         -0.0474424439677581,
         0.0410280358979489,
         -0.0404693286375384,
         0.100773561313828,
         -0.155473474261777,
         0.168961343063472,
         -0.148844896829537,
         0.104919282301189,
         -0.00172461988247581,
         -0.0603042326762897,
         0.0706172839621344,
         -0.0190747269868655,
         -0.0284489510907799,
         0.0567077245134062,
         -0.103194662418713,
         0.0056043197283404,
         -0.0582826317647521,
         0.0520595809974799,
         -0.0336712487107829,
         0.0592690478903648,
         0.0356077244179142,
         0.0107589536871069,
         -0.0138524293668623,
         -0.0354598795959514,
         -0.0432154535285395,
         0.00282394401815934,
         0.0452550263371675,
         0.0410280358979487,
         -0.0474424439677579,
         0.00641440806980926},
        {0.228259438887484,
         -0.144287466624427,
         -0.0839719722630574,
         0.0868712617154229,
         0.0741240018050016,
         0.0265557673540533,
         -0.0792673726747522,
         -0.0107535230080966,
         -0.0704452526742097,
         0.0232565485142801,
         0.0861248575840794,
         -0.00969794816253898,
         0.0224034641886473,
         0.0499937815035742,
         -0.0586074904326161,
         -0.0742004276420028,
         -0.01539437285956,
         0.0265616387101916,
         -0.0470131098808275,
         -0.00272096847382324,
         0.0607151435495509,
         0.0658847842857527,
         0.00831564335624996,
         0.00360878658582667,
         -0.0223907014372301,
         0.0556339902386316,
         -0.0535263371216968,
         -0.00718880642785394,
         -0.0839719722630574,
         -0.144287466624427,
         0.0741240018050017,
         0.132565764039144,
         0.0741240018050017,
         -0.0107535230080965,
         -0.167357158482421,
         -0.0226248104657263,
         -0.0704452526742099,
         -0.00969794816253914,
         0.108190120574748,
         0.0731438857502761,
         0.00566619938571506,
         0.0499937815035742,
         -0.0153943728595599,
         -0.0525358378619641,
         -0.053454213781943,
         -0.0355313134181957,
         -0.00858163820916459,
         -0.00272096847382334,
         0.00831564335624994,
         0.0857588341892138,
         -0.0212985663851728,
         0.0513134493372255,
         0.0143653425590619,
         -0.00367605123296286,
         -0.0535263371216969,
         -0.0742004276420027,
         -0.0153943728595599,
         0.0265616387101917,
         -0.0470131098808272,
         -0.00272096847382316,
         0.0607151435495507,
         0.0265557673540532,
         0.0741240018050017,
         0.0868712617154227,
         -0.0704452526742096,
         -0.0226248104657262,
         -0.167357158482422,
         -0.0107535230080964,
         0.0224034641886474,
         0.0731438857502763,
         0.109856856610135,
         0.0731438857502765,
         0.0224034641886475,
         0.0265616387101916,
         -0.0534542137819429,
         -0.129759075548614,
         -0.0468687080098655,
         -0.0355313134181956,
         -0.0470131098808272,
         0.0036087865858268,
         -0.0212985663851727,
         0.132390561611285,
         0.0461653117407855,
         0.0331388993639662,
         0.0143653425590619,
         0.0556339902386314,
         -0.0153943728595598,
         -0.0525358378619643,
         -0.053454213781943,
         -0.0355313134181958,
         -0.00858163820916466,
         -0.00272096847382319,
         0.0861248575840794,
         -0.00969794816253906,
         0.0224034641886475,
         0.0499937815035741,
         -0.0586074904326161,
         0.0232565485142801,
         -0.0704452526742097,
         -0.0107535230080963,
         -0.0792673726747522,
         0.0499937815035742,
         0.00566619938571506,
         0.0731438857502761,
         0.108190120574747,
         -0.00969794816253916,
         -0.0470131098808273,
         -0.0355313134181955,
         -0.0468687080098656,
         -0.129759075548614,
         -0.053454213781943,
         0.0265616387101917,
         -0.0223907014372302,
         0.0513134493372254,
         0.0461653117407856,
         0.130462471817694,
         0.0461653117407856,
         0.0513134493372255,
         -0.0223907014372303,
         0.0265616387101917,
         -0.053454213781943,
         -0.129759075548614,
         -0.0468687080098654,
         -0.0355313134181957,
         -0.0470131098808273,
         -0.00969794816253927,
         0.108190120574748,
         0.0731438857502762,
         0.00566619938571516,
         0.0499937815035742,
         -0.0792673726747521,
         -0.0107535230080966,
         -0.07044525267421,
         0.0232565485142802,
         -0.0586074904326162,
         0.0499937815035742,
         0.0224034641886474,
         -0.00969794816253922,
         0.0861248575840795,
         -0.00272096847382324,
         -0.00858163820916462,
         -0.0355313134181958,
         -0.053454213781943,
         -0.0525358378619642,
         -0.0153943728595599,
         0.0556339902386314,
         0.014365342559062,
         0.0331388993639661,
         0.0461653117407856,
         0.132390561611285,
         -0.0212985663851728,
         0.00360878658582677,
         -0.0470131098808273,
         -0.0355313134181957,
         -0.0468687080098654,
         -0.129759075548614,
         -0.053454213781943,
         0.0265616387101917,
         0.0224034641886474,
         0.0731438857502763,
         0.109856856610134,
         0.0731438857502761,
         0.0224034641886474,
         -0.0107535230080964,
         -0.167357158482422,
         -0.0226248104657263,
         -0.0704452526742097,
         0.0868712617154227,
         0.0741240018050018,
         0.0265557673540534,
         0.0607151435495506,
         -0.00272096847382323,
         -0.0470131098808271,
         0.0265616387101917,
         -0.0153943728595599,
         -0.0742004276420028,
         -0.0535263371216968,
         -0.00367605123296273,
         0.0143653425590619,
         0.0513134493372255,
         -0.0212985663851728,
         0.0857588341892139,
         0.00831564335624978,
         -0.00272096847382315,
         -0.00858163820916462,
         -0.0355313134181957,
         -0.053454213781943,
         -0.0525358378619642,
         -0.0153943728595599,
         0.0499937815035744,
         0.00566619938571497,
         0.0731438857502762,
         0.108190120574747,
         -0.00969794816253908,
         -0.0704452526742097,
         -0.0226248104657264,
         -0.167357158482422,
         -0.0107535230080963,
         0.0741240018050017,
         0.132565764039144,
         0.0741240018050016,
         -0.144287466624427,
         -0.0839719722630574,
         -0.00718880642785402,
         -0.0535263371216967,
         0.0556339902386315,
         -0.0223907014372301,
         0.00360878658582665,
         0.00831564335624995,
         0.0658847842857526,
         0.0607151435495507,
         -0.00272096847382321,
         -0.0470131098808273,
         0.0265616387101916,
         -0.0153943728595599,
         -0.0742004276420028,
         -0.058607490432616,
         0.0499937815035742,
         0.0224034641886474,
         -0.00969794816253912,
         0.0861248575840792,
         0.0232565485142802,
         -0.0704452526742097,
         -0.0107535230080965,
         -0.0792673726747522,
         0.0265557673540533,
         0.0741240018050019,
         0.0868712617154227,
         -0.0839719722630575,
         -0.144287466624427,
         0.228259438887484},
        {-0.037612386785419,
         -0.0151470500044742,
         0.0527594367898934,
         0.109434765080418,
         -0.121724916747027,
         0.0415282782860505,
         -0.142692791397436,
         0.047033951875289,
         0.0863090135502806,
         -0.102557967044975,
         0.121583489005734,
         0.0298530617345809,
         -0.0842255034666647,
         -0.00942199994041066,
         0.109220327095179,
         -0.0744854174011495,
         -0.0608033489876794,
         0.0367536698902409,
         0.0401333437196289,
         -0.0280354929319561,
         -0.0875041276495425,
         0.0503796184008457,
         0.0241057990003039,
         0.0229922726042801,
         -0.0489810418171612,
         0.0206024823213213,
         0.00111371712431529,
         0.0863904105252273,
         0.0527594367898932,
         -0.0151470500044744,
         -0.121724916747026,
         0.11953380500782,
         -0.121724916747026,
         0.047033951875289,
         -0.0188046259212156,
         -0.00644146401066095,
         0.0863090135502807,
         0.0298530617345808,
         0.0339581339799936,
         -0.0530321788421212,
         -0.00617669037246748,
         -0.00942199994041052,
         -0.0608033489876794,
         -0.0853053077814993,
         0.0331239285241791,
         0.0794646749680721,
         -0.0597019412520441,
         -0.0280354929319563,
         0.024105799000304,
         0.128876404408486,
         0.00352697497759745,
         -0.0597536156002813,
         -0.0411659355702739,
         0.122584076267955,
         0.00111371712431536,
         -0.0744854174011497,
         -0.0608033489876794,
         0.0367536698902411,
         0.0401333437196289,
         -0.0280354929319562,
         -0.0875041276495424,
         0.0415282782860504,
         -0.121724916747026,
         0.109434765080418,
         0.0863090135502807,
         -0.00644146401066095,
         -0.0188046259212155,
         0.047033951875289,
         -0.0842255034666649,
         -0.0530321788421212,
         0.0833399311828327,
         -0.0530321788421214,
         -0.0842255034666649,
         0.036753669890241,
         0.033123928524179,
         -0.0121497384208008,
         -0.0227786583862349,
         0.0794646749680721,
         0.0401333437196288,
         0.0229922726042801,
         0.00352697497759748,
         0.0454928871121383,
         -0.0635810201011401,
         0.0138186868126598,
         -0.041165935570274,
         0.0206024823213212,
         -0.0608033489876794,
         -0.085305307781499,
         0.0331239285241789,
         0.079464674968072,
         -0.0597019412520441,
         -0.0280354929319562,
         0.121583489005734,
         0.029853061734581,
         -0.084225503466665,
         -0.00942199994041048,
         0.109220327095179,
         -0.102557967044975,
         0.0863090135502805,
         0.0470339518752889,
         -0.142692791397436,
         -0.00942199994041068,
         -0.00617669037246746,
         -0.0530321788421212,
         0.0339581339799935,
         0.0298530617345807,
         0.0401333437196289,
         0.0794646749680722,
         -0.0227786583862348,
         -0.0121497384208009,
         0.0331239285241789,
         0.036753669890241,
         -0.0489810418171613,
         -0.0597536156002812,
         -0.0635810201011399,
         0.0985094169081759,
         -0.06358102010114,
         -0.0597536156002812,
         -0.0489810418171614,
         0.036753669890241,
         0.0331239285241788,
         -0.012149738420801,
         -0.0227786583862349,
         0.0794646749680721,
         0.0401333437196289,
         0.029853061734581,
         0.0339581339799934,
         -0.0530321788421214,
         -0.00617669037246736,
         -0.0094219999404107,
         -0.142692791397436,
         0.0470339518752891,
         0.0863090135502808,
         -0.102557967044975,
         0.109220327095179,
         -0.00942199994041054,
         -0.0842255034666649,
         0.0298530617345808,
         0.121583489005734,
         -0.0280354929319561,
         -0.0597019412520441,
         0.079464674968072,
         0.0331239285241789,
         -0.085305307781499,
         -0.0608033489876795,
         0.0206024823213212,
         -0.0411659355702741,
         0.0138186868126596,
         -0.06358102010114,
         0.0454928871121382,
         0.00352697497759739,
         0.02299227260428,
         0.0401333437196288,
         0.079464674968072,
         -0.022778658386235,
         -0.0121497384208008,
         0.0331239285241789,
         0.0367536698902411,
         -0.084225503466665,
         -0.0530321788421213,
         0.0833399311828325,
         -0.0530321788421212,
         -0.084225503466665,
         0.047033951875289,
         -0.0188046259212156,
         -0.00644146401066096,
         0.0863090135502806,
         0.109434765080418,
         -0.121724916747027,
         0.0415282782860504,
         -0.0875041276495422,
         -0.0280354929319563,
         0.0401333437196287,
         0.0367536698902408,
         -0.0608033489876793,
         -0.0744854174011495,
         0.00111371712431536,
         0.122584076267955,
         -0.0411659355702739,
         -0.0597536156002813,
         0.00352697497759738,
         0.128876404408486,
         0.0241057990003041,
         -0.0280354929319561,
         -0.0597019412520442,
         0.079464674968072,
         0.033123928524179,
         -0.0853053077814989,
         -0.0608033489876794,
         -0.00942199994041071,
         -0.00617669037246756,
         -0.0530321788421213,
         0.0339581339799937,
         0.0298530617345808,
         0.0863090135502805,
         -0.00644146401066096,
         -0.0188046259212155,
         0.0470339518752891,
         -0.121724916747027,
         0.11953380500782,
         -0.121724916747026,
         -0.0151470500044742,
         0.0527594367898934,
         0.0863904105252269,
         0.00111371712431527,
         0.0206024823213211,
         -0.048981041817161,
         0.0229922726042801,
         0.0241057990003041,
         0.0503796184008457,
         -0.0875041276495425,
         -0.0280354929319562,
         0.040133343719629,
         0.036753669890241,
         -0.0608033489876798,
         -0.0744854174011496,
         0.109220327095179,
         -0.00942199994041053,
         -0.0842255034666649,
         0.0298530617345807,
         0.121583489005734,
         -0.102557967044975,
         0.0863090135502806,
         0.0470339518752891,
         -0.142692791397436,
         0.0415282782860503,
         -0.121724916747026,
         0.109434765080418,
         0.0527594367898934,
         -0.0151470500044742,
         -0.0376123867854191},
        {0.00755889448885631,
         -0.0906549497751239,
         0.0830960552862678,
         0.0809039992990896,
         0.012588422934458,
         -0.0928470057623018,
         -0.0252045394662255,
         -0.0787709315124915,
         0.0649810051032555,
         0.0468984964054721,
         -0.0327315651951838,
         0.0819340249632322,
         -0.00346499526893511,
         -0.0618179116525145,
         -0.00318663187718822,
         0.0158159302059924,
         0.0218379908678873,
         -0.105856345381099,
         0.10901943883184,
         -0.0430889019746832,
         0.0365631518280507,
         0.10643696009875,
         -0.122252890304742,
         0.105337255315551,
         -0.0304855156649497,
         -0.0466028688141967,
         0.079979388765059,
         -0.11654254059311,
         0.0830960552862679,
         -0.090654949775124,
         0.012588422934458,
         -0.00869268963786766,
         0.0125884229344578,
         -0.0787709315124912,
         0.0142433362399143,
         -0.015301597078081,
         0.0649810051032557,
         0.0819340249632324,
         0.0207312498091346,
         0.0227029617456856,
         -0.0513717860625635,
         -0.0618179116525148,
         0.0218379908678871,
         -0.111333369109621,
         0.0357838261632327,
         -0.056036666257475,
         0.146237894185193,
         -0.0430889019746833,
         -0.122252890304742,
         0.0782442351167637,
         0.0161734990036654,
         0.0260122260078586,
         -0.0519463668926588,
         -0.0609150073416723,
         0.079979388765059,
         0.0158159302059923,
         0.0218379908678872,
         -0.1058563453811,
         0.10901943883184,
         -0.0430889019746832,
         0.0365631518280508,
         -0.0928470057623017,
         0.0125884229344579,
         0.0809039992990895,
         0.0649810051032555,
         -0.0153015970780811,
         0.0142433362399146,
         -0.0787709315124917,
         -0.00346499526893533,
         0.0227029617456859,
         -0.0238115877024114,
         0.0227029617456859,
         -0.00346499526893526,
         -0.1058563453811,
         0.0357838261632328,
         -0.0848003159166047,
         0.087887029835201,
         -0.0560366662574751,
         0.10901943883184,
         0.105337255315551,
         0.0161734990036654,
         0.0559606525390633,
         -0.00382635126153538,
         -0.0329064349793193,
         -0.0519463668926588,
         -0.0466028688141966,
         0.0218379908678872,
         -0.111333369109621,
         0.0357838261632328,
         -0.0560366662574751,
         0.146237894185193,
         -0.0430889019746832,
         -0.032731565195184,
         0.0819340249632322,
         -0.00346499526893524,
         -0.0618179116525147,
         -0.00318663187718837,
         0.0468984964054722,
         0.0649810051032554,
         -0.0787709315124915,
         -0.0252045394662256,
         -0.0618179116525147,
         -0.0513717860625633,
         0.0227029617456857,
         0.0207312498091344,
         0.0819340249632323,
         0.10901943883184,
         -0.0560366662574752,
         0.0878870298352009,
         -0.0848003159166045,
         0.0357838261632325,
         -0.1058563453811,
         -0.0304855156649498,
         0.0260122260078585,
         -0.00382635126153526,
         0.000739637342938961,
         -0.00382635126153542,
         0.0260122260078585,
         -0.0304855156649498,
         -0.1058563453811,
         0.0357838261632327,
         -0.0848003159166046,
         0.087887029835201,
         -0.0560366662574751,
         0.10901943883184,
         0.0819340249632322,
         0.0207312498091343,
         0.0227029617456857,
         -0.0513717860625635,
         -0.0618179116525145,
         -0.0252045394662255,
         -0.0787709315124915,
         0.0649810051032556,
         0.0468984964054722,
         -0.00318663187718806,
         -0.0618179116525146,
         -0.00346499526893526,
         0.0819340249632323,
         -0.0327315651951839,
         -0.0430889019746831,
         0.146237894185194,
         -0.0560366662574751,
         0.0357838261632328,
         -0.111333369109621,
         0.0218379908678872,
         -0.0466028688141966,
         -0.0519463668926589,
         -0.0329064349793195,
         -0.00382635126153543,
         0.0559606525390631,
         0.0161734990036654,
         0.105337255315551,
         0.10901943883184,
         -0.056036666257475,
         0.0878870298352007,
         -0.0848003159166045,
         0.0357838261632326,
         -0.1058563453811,
         -0.00346499526893515,
         0.0227029617456859,
         -0.0238115877024113,
         0.0227029617456858,
         -0.00346499526893513,
         -0.0787709315124916,
         0.0142433362399145,
         -0.015301597078081,
         0.0649810051032556,
         0.0809039992990894,
         0.0125884229344577,
         -0.0928470057623018,
         0.0365631518280507,
         -0.0430889019746831,
         0.10901943883184,
         -0.1058563453811,
         0.0218379908678872,
         0.0158159302059926,
         0.079979388765059,
         -0.0609150073416723,
         -0.0519463668926588,
         0.0260122260078585,
         0.0161734990036654,
         0.0782442351167641,
         -0.122252890304742,
         -0.0430889019746833,
         0.146237894185194,
         -0.056036666257475,
         0.0357838261632328,
         -0.111333369109621,
         0.0218379908678871,
         -0.0618179116525146,
         -0.0513717860625635,
         0.0227029617456859,
         0.0207312498091346,
         0.0819340249632322,
         0.0649810051032556,
         -0.0153015970780812,
         0.0142433362399145,
         -0.0787709315124916,
         0.0125884229344579,
         -0.00869268963786764,
         0.012588422934458,
         -0.0906549497751238,
         0.0830960552862678,
         -0.11654254059311,
         0.0799793887650591,
         -0.0466028688141967,
         -0.0304855156649498,
         0.105337255315551,
         -0.122252890304742,
         0.10643696009875,
         0.0365631518280507,
         -0.0430889019746832,
         0.109019438831841,
         -0.1058563453811,
         0.0218379908678872,
         0.0158159302059924,
         -0.0031866318771883,
         -0.0618179116525146,
         -0.00346499526893527,
         0.0819340249632322,
         -0.0327315651951839,
         0.0468984964054723,
         0.0649810051032557,
         -0.0787709315124913,
         -0.0252045394662257,
         -0.0928470057623019,
         0.012588422934458,
         0.0809039992990895,
         0.0830960552862677,
         -0.0906549497751239,
         0.0075588944888563},
        {0.12528704197393,
         -0.0826047880154116,
         -0.0426822539585186,
         0.0493071685019766,
         0.0429870419479612,
         0.00938463444508369,
         0.0194044061909706,
         -0.0971728408227781,
         0.0500828957121398,
         -0.0447985896245966,
         -0.084621579775794,
         0.0922310113832977,
         0.00541350291869323,
         -0.0550247251516202,
         0.0837069459122332,
         0.129568960998281,
         -0.0580268196434432,
         -0.0286658152653023,
         0.023723985825822,
         0.0285735349922147,
         -0.105839910945658,
         -0.168299444164851,
         0.0387304831665697,
         0.00621689805591765,
         0.0140528943064186,
         -0.0308282855606308,
         0.00869532052720625,
         0.0971445904184515,
         -0.0426822539585184,
         -0.0826047880154118,
         0.0429870419479613,
         0.0697910094515388,
         0.0429870419479613,
         -0.0971728408227783,
         0.032619948361527,
         -0.1357085773265,
         0.0500828957121397,
         0.0922310113832976,
         -0.0124156039747226,
         0.0531370084815458,
         0.0517873918408443,
         -0.0550247251516201,
         -0.0580268196434431,
         0.0290995346436258,
         -0.0897181645686969,
         0.0327532314633699,
         -0.0427785083926672,
         0.0285735349922148,
         0.0387304831665696,
         -0.0933871421273721,
         0.109234988706233,
         -0.00706409209017037,
         -0.039610772003501,
         0.0602563153627438,
         0.00869532052720649,
         0.129568960998281,
         -0.0580268196434429,
         -0.0286658152653023,
         0.0237239858258221,
         0.0285735349922149,
         -0.105839910945658,
         0.00938463444508373,
         0.0429870419479612,
         0.0493071685019769,
         0.0500828957121398,
         -0.1357085773265,
         0.0326199483615269,
         -0.0971728408227782,
         0.00541350291869314,
         0.0531370084815457,
         0.0448799525976017,
         0.053137008481546,
         0.00541350291869319,
         -0.0286658152653024,
         -0.0897181645686968,
         0.0524882527118228,
         -0.145875435615568,
         0.03275323146337,
         0.023723985825822,
         0.00621689805591755,
         0.109234988706233,
         -0.0400531982453871,
         0.0694660497872913,
         0.0465099129888169,
         -0.0396107720035011,
         -0.0308282855606306,
         -0.0580268196434429,
         0.0290995346436258,
         -0.0897181645686969,
         0.0327532314633699,
         -0.0427785083926671,
         0.0285735349922147,
         -0.0846215797757939,
         0.0922310113832976,
         0.00541350291869325,
         -0.0550247251516202,
         0.0837069459122333,
         -0.0447985896245965,
         0.0500828957121399,
         -0.0971728408227783,
         0.0194044061909706,
         -0.0550247251516203,
         0.0517873918408444,
         0.0531370084815457,
         -0.0124156039747224,
         0.0922310113832977,
         0.0237239858258221,
         0.03275323146337,
         -0.145875435615568,
         0.0524882527118228,
         -0.0897181645686969,
         -0.0286658152653023,
         0.0140528943064184,
         -0.0070640920901704,
         0.0694660497872914,
         0.0239211331164538,
         0.0694660497872914,
         -0.00706409209017054,
         0.0140528943064185,
         -0.0286658152653023,
         -0.0897181645686968,
         0.0524882527118228,
         -0.145875435615568,
         0.0327532314633699,
         0.0237239858258221,
         0.0922310113832978,
         -0.0124156039747225,
         0.0531370084815459,
         0.0517873918408445,
         -0.0550247251516202,
         0.0194044061909705,
         -0.0971728408227781,
         0.0500828957121397,
         -0.0447985896245966,
         0.0837069459122331,
         -0.0550247251516203,
         0.00541350291869312,
         0.0922310113832977,
         -0.084621579775794,
         0.0285735349922147,
         -0.0427785083926671,
         0.0327532314633698,
         -0.0897181645686969,
         0.0290995346436259,
         -0.058026819643443,
         -0.0308282855606307,
         -0.039610772003501,
         0.0465099129888168,
         0.0694660497872912,
         -0.0400531982453872,
         0.109234988706233,
         0.00621689805591744,
         0.023723985825822,
         0.0327532314633699,
         -0.145875435615568,
         0.0524882527118228,
         -0.0897181645686968,
         -0.0286658152653022,
         0.00541350291869318,
         0.0531370084815458,
         0.0448799525976018,
         0.0531370084815458,
         0.00541350291869307,
         -0.0971728408227781,
         0.0326199483615269,
         -0.1357085773265,
         0.0500828957121397,
         0.0493071685019767,
         0.0429870419479615,
         0.00938463444508374,
         -0.105839910945658,
         0.0285735349922146,
         0.0237239858258218,
         -0.0286658152653024,
         -0.0580268196434429,
         0.129568960998282,
         0.00869532052720639,
         0.0602563153627437,
         -0.0396107720035011,
         -0.00706409209017058,
         0.109234988706233,
         -0.093387142127372,
         0.0387304831665696,
         0.0285735349922146,
         -0.0427785083926672,
         0.0327532314633699,
         -0.0897181645686971,
         0.0290995346436259,
         -0.0580268196434429,
         -0.0550247251516203,
         0.0517873918408444,
         0.0531370084815457,
         -0.0124156039747225,
         0.0922310113832977,
         0.0500828957121396,
         -0.1357085773265,
         0.0326199483615269,
         -0.0971728408227781,
         0.0429870419479613,
         0.0697910094515388,
         0.0429870419479613,
         -0.0826047880154119,
         -0.0426822539585185,
         0.0971445904184514,
         0.00869532052720629,
         -0.0308282855606307,
         0.0140528943064184,
         0.00621689805591755,
         0.0387304831665698,
         -0.168299444164851,
         -0.105839910945658,
         0.0285735349922148,
         0.023723985825822,
         -0.0286658152653025,
         -0.0580268196434432,
         0.129568960998281,
         0.083706945912233,
         -0.0550247251516203,
         0.00541350291869303,
         0.0922310113832975,
         -0.0846215797757938,
         -0.0447985896245965,
         0.0500828957121398,
         -0.097172840822778,
         0.0194044061909705,
         0.00938463444508383,
         0.0429870419479612,
         0.0493071685019769,
         -0.0426822539585187,
         -0.0826047880154119,
         0.12528704197393},
        {-0.0427170584069785,
         0.0565093566425428,
         -0.0427170584069784,
         0.0630804132318202,
         -0.0576265620923433,
         0.0206325043369563,
         0.0109077022789538,
         -0.0554003968803577,
         0.0170696726920453,
         0.0293481446072539,
         -0.0412611914384826,
         0.0183829585349569,
         0.0186934249514313,
         0.0382944518943042,
         -0.0615740705576865,
         0.0376114108292912,
         0.00049281747476528,
         -0.01455106359018,
         -0.0001329436567879,
         -0.0226952608528272,
         -0.00832774820591411,
         0.0590532354545098,
         -0.08515649172538,
         0.0708652978520079,
         -0.0353626382310947,
         0.00571746174094488,
         -0.00741485542165593,
         0.0275886520375979,
         -0.0228738556415766,
         -0.0188830875993135,
         0.0781288025821657,
         -0.121723001702177,
         0.121900824542364,
         0.0579093130950462,
         -0.0628607802078701,
         0.0677149425274263,
         -0.0836432582079122,
         0.0961717849199206,
         -0.0858290918864305,
         0.040721406684154,
         0.0389650031897696,
         -0.144534213985727,
         0.0109077022789538,
         0.0206325043369562,
         -0.0576265620923432,
         0.0630804132318201,
         -0.0436469460490815,
         0.00493629360232481,
         0.0186210648738824,
         0.00493629360232481,
         -0.0436469460490816,
         0.0747103284601852,
         -0.0213504810706066,
         0.0101720523724161,
         -0.0409955338521083,
         0.0534085230607481,
         -0.0129842254014074,
         -0.0321899510608939,
         -0.0594051459219295,
         0.0656998309621989,
         -0.0420093423477142,
         0.0510079472921855,
         -0.0843163018545526,
         0.075213504030065,
         -0.00717813657828792,
         0.0490353921877294,
         0.0142551054483143,
         -0.0638618601805868,
         0.0640573676880525,
         -0.0536386094841156,
         0.0752346805117459,
         -0.103355965624733,
         -0.0645112692454783,
         0.0675852028030689,
         -0.104173510823254,
         0.077620066873148,
         -0.0199343857682598,
         -0.0150183202754323,
         0.00989049408150494,
         0.00621100545477608,
         0.00377526625778398,
         0.00571746174094505,
         -0.00741485542165615,
         0.0275886520375981,
         -0.0228738556415765,
         -0.0188830875993137,
         0.0781288025821659,
         -0.121723001702177,
         0.121900824542364,
         0.0183829585349569,
         -0.0412611914384829,
         0.029348144607254,
         0.0170696726920455,
         -0.0554003968803578,
         -0.0129842254014073,
         0.0534085230607481,
         -0.0409955338521084,
         0.0101720523724161,
         -0.0213504810706065,
         0.0747103284601853,
         -0.064972099192909,
         0.0284462675765706,
         -0.0610937834225324,
         0.0873729687946791,
         -0.0610937834225323,
         0.0284462675765708,
         -0.0649720991929089,
         0.0459509183876266,
         0.0547763533679934,
         -0.0382401610595128,
         0.0412217715797753,
         -0.0791954913426178,
         0.0863864156433894,
         -0.0365662768459242,
         0.0242269695291195,
         0.0709315897818104,
         -0.119184340742374,
         0.0270288214623011,
         -0.0064309889727029,
         0.0196578963996558,
         -0.00360873166390352,
         -0.0269456223391764,
         -0.00278549392066228,
         0.0886691197490298,
         -0.00717813657828787,
         0.0490353921877291,
         0.0142551054483142,
         -0.0638618601805869,
         0.0640573676880525,
         -0.0536386094841155,
         0.0752346805117461,
         -0.103355965624733,
         -0.000132943656787907,
         -0.0226952608528271,
         -0.00832774820591399,
         0.0590532354545098,
         -0.08515649172538,
         0.070865297852008,
         -0.0353626382310948,
         -0.0145510635901802,
         0.000492817474765386,
         0.0376114108292912,
         -0.0615740705576864,
         0.0382944518943042,
         0.0186934249514313,
         0.075213504030065,
         -0.0843163018545527,
         0.0510079472921854,
         -0.0420093423477146,
         0.065699830962199,
         -0.0594051459219296,
         -0.0321899510608939,
         0.0242269695291196,
         -0.0365662768459242,
         0.0863864156433892,
         -0.0791954913426178,
         0.0412217715797753,
         -0.0382401610595127,
         0.0547763533679934,
         0.0459509183876265,
         -0.108450357535796,
         0.0225003492246675,
         -0.0393596040871953,
         4.8351834984433e-05,
         0.0293659650120229,
         4.83518349843404e-05,
         -0.0393596040871953,
         0.0225003492246675,
         -0.108450357535796,
         0.0459509183876266,
         0.0547763533679934,
         -0.038240161059513,
         0.0412217715797752,
         -0.0791954913426179,
         0.0863864156433894,
         -0.0365662768459242,
         0.0242269695291196,
         -0.0321899510608938,
         -0.0594051459219296,
         0.0656998309621991,
         -0.0420093423477142,
         0.0510079472921855,
         -0.0843163018545527,
         0.0752135040300651,
         0.0186934249514313,
         0.0382944518943042,
         -0.0615740705576866,
         0.0376114108292912,
         0.000492817474765246,
         -0.0145510635901801,
         -0.0353626382310948,
         0.0708652978520081,
         -0.08515649172538,
         0.0590532354545099,
         -0.00832774820591398,
         -0.0226952608528271,
         -0.000132943656787943,
         -0.103355965624733,
         0.075234680511746,
         -0.0536386094841156,
         0.0640573676880527,
         -0.0638618601805869,
         0.0142551054483144,
         0.0490353921877293,
         -0.00717813657828789,
         0.0886691197490298,
         -0.00278549392066224,
         -0.0269456223391763,
         -0.00360873166390351,
         0.0196578963996557,
         -0.00643098897270306,
         0.0270288214623012,
         -0.119184340742374,
         0.0709315897818101,
         0.0242269695291197,
         -0.0365662768459242,
         0.0863864156433894,
         -0.0791954913426177,
         0.0412217715797754,
         -0.038240161059513,
         0.0547763533679934,
         0.0459509183876267,
         -0.0649720991929087,
         0.0284462675765707,
         -0.0610937834225323,
         0.0873729687946791,
         -0.0610937834225323,
         0.0284462675765708,
         -0.0649720991929089,
         0.0747103284601853,
         -0.0213504810706066,
         0.0101720523724161,
         -0.0409955338521084,
         0.053408523060748,
         -0.0129842254014073,
         -0.0554003968803577,
         0.0170696726920454,
         0.029348144607254,
         -0.0412611914384827,
         0.0183829585349569,
         0.121900824542364,
         -0.121723001702177,
         0.0781288025821659,
         -0.0188830875993135,
         -0.0228738556415765,
         0.0275886520375979,
         -0.00741485542165614,
         0.00571746174094494,
         0.00377526625778386,
         0.00621100545477603,
         0.00989049408150492,
         -0.0150183202754323,
         -0.0199343857682597,
         0.0776200668731479,
         -0.104173510823254,
         0.0675852028030687,
         -0.0645112692454783,
         -0.103355965624733,
         0.075234680511746,
         -0.0536386094841156,
         0.0640573676880524,
         -0.0638618601805866,
         0.0142551054483143,
         0.0490353921877294,
         -0.00717813657828807,
         0.075213504030065,
         -0.0843163018545526,
         0.0510079472921855,
         -0.0420093423477145,
         0.065699830962199,
         -0.0594051459219295,
         -0.0321899510608939,
         -0.0129842254014074,
         0.053408523060748,
         -0.0409955338521085,
         0.010172052372416,
         -0.0213504810706066,
         0.0747103284601852,
         -0.0436469460490817,
         0.00493629360232476,
         0.0186210648738824,
         0.00493629360232481,
         -0.0436469460490815,
         0.06308041323182,
         -0.0576265620923432,
         0.0206325043369562,
         0.0109077022789539,
         -0.144534213985727,
         0.0389650031897697,
         0.0407214066841538,
         -0.0858290918864305,
         0.0961717849199206,
         -0.0836432582079122,
         0.0677149425274265,
         -0.0628607802078701,
         0.057909313095046,
         0.121900824542364,
         -0.121723001702177,
         0.0781288025821659,
         -0.0188830875993134,
         -0.0228738556415764,
         0.0275886520375979,
         -0.00741485542165615,
         0.0057174617409451,
         -0.0353626382310948,
         0.0708652978520081,
         -0.08515649172538,
         0.05905323545451,
         -0.00832774820591392,
         -0.0226952608528272,
         -0.000132943656787981,
         -0.0145510635901801,
         0.000492817474765342,
         0.037611410829291,
         -0.0615740705576866,
         0.0382944518943041,
         0.0186934249514314,
         0.0183829585349568,
         -0.0412611914384829,
         0.0293481446072541,
         0.0170696726920454,
         -0.0554003968803578,
         0.0109077022789538,
         0.0206325043369562,
         -0.0576265620923433,
         0.0630804132318201,
         -0.0427170584069785,
         0.0565093566425429,
         -0.0427170584069786},
        {0.071625140505049,
         -0.0947511546982097,
         0.0716251405050491,
         -0.00889142807329942,
         -0.0486920491170533,
         0.110721240344056,
         -0.115166954380705,
         -0.0360325064756208,
         0.0669133139283373,
         -0.0347202738259477,
         -0.0519063366556259,
         0.114263784176651,
         0.0277011438139149,
         0.000331273387473163,
         -0.0623456384074645,
         0.0906946232752252,
         -0.0356740904299728,
         -0.0659460707954559,
         0.016174952157139,
         -0.0581892620534816,
         0.069242771201735,
         -0.0220832889043479,
         -0.0493017057575214,
         0.0688817980725394,
         0.00792354261508106,
         -0.0493975241040912,
         0.047262635802787,
         -0.00441188929867005,
         -0.0469599747964082,
         0.0625752181315742,
         -0.024502493848085,
         -0.0297322925598968,
         0.0157788848238566,
         -0.0109827877021378,
         0.0537622984603349,
         -0.0847029564759639,
         0.0872501619501856,
         -0.0615291244543189,
         0.0272552659428493,
         -0.0131087445238402,
         0.0325730989867401,
         -0.0462380140875888,
         -0.115166954380706,
         0.110721240344056,
         -0.0486920491170534,
         -0.00889142807329937,
         0.062751218247999,
         0.00821932295057484,
         -0.0499274739303241,
         0.00821932295057473,
         0.0627512182479991,
         0.0266107220589419,
         -0.0810281748107816,
         0.0460955503509073,
         0.0111639509731921,
         0.0132779009511741,
         -0.115354345960696,
         -0.0708546252248346,
         0.0497006982147995,
         0.015396947138365,
         -0.0178713954636307,
         -0.0413687558624816,
         0.0438660705732633,
         0.103016363748975,
         0.039064281858882,
         0.0210937319134427,
         -0.0318381351802778,
         -0.0189885460806193,
         0.04492718495826,
         0.0164260868702914,
         -0.0900718682588283,
         -0.0324738639834464,
         0.0680221353797339,
         -0.0689178194858729,
         0.0201497041954953,
         0.00612824612536936,
         0.0330197210689766,
         -0.0990618967240539,
         0.100965135860967,
         -0.00537615870777211,
         0.0280181272864573,
         -0.0493975241040911,
         0.047262635802787,
         -0.00441188929866988,
         -0.0469599747964081,
         0.062575218131574,
         -0.0245024938480848,
         -0.0297322925598967,
         0.0157788848238565,
         0.114263784176651,
         -0.0519063366556258,
         -0.0347202738259478,
         0.0669133139283373,
         -0.0360325064756208,
         -0.115354345960696,
         0.013277900951174,
         0.0111639509731921,
         0.0460955503509073,
         -0.0810281748107817,
         0.0266107220589418,
         0.041915323005945,
         0.0363454032980818,
         0.013818366371806,
         -0.0572445495320032,
         0.013818366371806,
         0.0363454032980817,
         0.0419153230059449,
         0.04104354643265,
         -0.0264132060152142,
         -0.0457043009908459,
         0.0254177076199499,
         0.0315607147013689,
         -0.0113926556780741,
         -0.0523243581956054,
         -0.0863172697145732,
         -0.102962291271203,
         0.00901922340975577,
         -0.00239280365618611,
         0.0634409539955463,
         -0.069702495959234,
         0.0134873543290652,
         -0.0164285722023268,
         0.140996137417812,
         0.00102737965716978,
         0.039064281858882,
         0.0210937319134425,
         -0.0318381351802778,
         -0.0189885460806196,
         0.04492718495826,
         0.0164260868702916,
         -0.0900718682588282,
         -0.0324738639834463,
         0.0161749521571389,
         -0.0581892620534816,
         0.0692427712017349,
         -0.0220832889043478,
         -0.0493017057575214,
         0.0688817980725395,
         0.00792354261508117,
         -0.0659460707954561,
         -0.0356740904299728,
         0.0906946232752253,
         -0.0623456384074645,
         0.000331273387473278,
         0.0277011438139149,
         0.103016363748975,
         0.0438660705732634,
         -0.0413687558624816,
         -0.0178713954636308,
         0.0153969471383651,
         0.0497006982147999,
         -0.0708546252248347,
         -0.086317269714573,
         -0.0523243581956055,
         -0.0113926556780742,
         0.0315607147013689,
         0.0254177076199498,
         -0.0457043009908457,
         -0.0264132060152141,
         0.0410435464326501,
         0.0694503759397955,
         -0.0140016155414581,
         0.0868984350949669,
         -0.0402789651934153,
         -0.00385633095531287,
         -0.0402789651934152,
         0.086898435094967,
         -0.014001615541458,
         0.0694503759397955,
         0.0410435464326501,
         -0.0264132060152141,
         -0.0457043009908457,
         0.0254177076199498,
         0.031560714701369,
         -0.0113926556780743,
         -0.0523243581956055,
         -0.086317269714573,
         -0.0708546252248347,
         0.0497006982147999,
         0.015396947138365,
         -0.0178713954636308,
         -0.0413687558624816,
         0.0438660705732633,
         0.103016363748975,
         0.027701143813915,
         0.000331273387473243,
         -0.0623456384074645,
         0.0906946232752251,
         -0.0356740904299728,
         -0.0659460707954559,
         0.00792354261508107,
         0.0688817980725396,
         -0.0493017057575214,
         -0.0220832889043479,
         0.0692427712017348,
         -0.0581892620534815,
         0.0161749521571389,
         -0.0324738639834465,
         -0.0900718682588282,
         0.0164260868702915,
         0.0449271849582601,
         -0.0189885460806195,
         -0.0318381351802778,
         0.0210937319134425,
         0.0390642818588818,
         0.00102737965716978,
         0.140996137417812,
         -0.0164285722023268,
         0.013487354329065,
         -0.069702495959234,
         0.0634409539955464,
         -0.00239280365618624,
         0.00901922340975598,
         -0.102962291271203,
         -0.0863172697145731,
         -0.0523243581956055,
         -0.0113926556780742,
         0.0315607147013691,
         0.0254177076199498,
         -0.0457043009908458,
         -0.0264132060152141,
         0.0410435464326501,
         0.0419153230059449,
         0.0363454032980817,
         0.0138183663718059,
         -0.0572445495320034,
         0.013818366371806,
         0.0363454032980817,
         0.0419153230059449,
         0.026610722058942,
         -0.0810281748107816,
         0.0460955503509074,
         0.0111639509731922,
         0.0132779009511741,
         -0.115354345960696,
         -0.0360325064756209,
         0.0669133139283374,
         -0.0347202738259478,
         -0.0519063366556257,
         0.114263784176651,
         0.0157788848238565,
         -0.0297322925598966,
         -0.0245024938480848,
         0.062575218131574,
         -0.0469599747964081,
         -0.00441188929866992,
         0.0472626358027869,
         -0.049397524104091,
         0.0280181272864573,
         -0.00537615870777207,
         0.100965135860967,
         -0.0990618967240539,
         0.0330197210689767,
         0.00612824612536957,
         0.0201497041954953,
         -0.0689178194858729,
         0.0680221353797339,
         -0.0324738639834461,
         -0.0900718682588282,
         0.0164260868702915,
         0.04492718495826,
         -0.0189885460806195,
         -0.031838135180278,
         0.0210937319134425,
         0.0390642818588817,
         0.103016363748975,
         0.0438660705732634,
         -0.0413687558624816,
         -0.0178713954636307,
         0.0153969471383651,
         0.0497006982147998,
         -0.0708546252248348,
         -0.115354345960696,
         0.0132779009511739,
         0.0111639509731921,
         0.0460955503509074,
         -0.0810281748107815,
         0.0266107220589418,
         0.0627512182479991,
         0.00821932295057489,
         -0.0499274739303241,
         0.0082193229505748,
         0.062751218247999,
         -0.00889142807329949,
         -0.0486920491170534,
         0.110721240344056,
         -0.115166954380706,
         -0.0462380140875886,
         0.0325730989867401,
         -0.01310874452384,
         0.0272552659428493,
         -0.0615291244543189,
         0.0872501619501859,
         -0.0847029564759637,
         0.0537622984603347,
         -0.0109827877021378,
         0.0157788848238564,
         -0.0297322925598967,
         -0.0245024938480847,
         0.0625752181315742,
         -0.0469599747964082,
         -0.00441188929866994,
         0.0472626358027871,
         -0.0493975241040911,
         0.00792354261508098,
         0.0688817980725396,
         -0.0493017057575214,
         -0.0220832889043479,
         0.0692427712017349,
         -0.0581892620534815,
         0.0161749521571389,
         -0.065946070795456,
         -0.0356740904299728,
         0.090694623275225,
         -0.0623456384074645,
         0.000331273387473178,
         0.027701143813915,
         0.114263784176651,
         -0.0519063366556257,
         -0.0347202738259476,
         0.0669133139283373,
         -0.0360325064756207,
         -0.115166954380706,
         0.110721240344056,
         -0.0486920491170533,
         -0.00889142807329939,
         0.0716251405050491,
         -0.0947511546982094,
         0.0716251405050491},
        {-0.0966481492887293,
         0.127853483846311,
         -0.0966481492887293,
         0.110866501492697,
         -0.082599999726255,
         -0.00109975278653556,
         0.0565330035328842,
         -0.0964099588182285,
         0.0284850126116927,
         0.0375107728678998,
         -0.0322616848350513,
         -0.0195707891122903,
         0.0622446595323851,
         0.0196601544616759,
         -0.0498703762947079,
         0.0192429585001113,
         0.00888997944805172,
         0.0095369513792215,
         0.000374465541790652,
         -0.0767955258464902,
         0.0735864433953516,
         -0.0368479302792468,
         0.0200514844631129,
         -0.0236624239930419,
         0.00798806113508631,
         -0.0747195438016613,
         0.098426000284359,
         -0.0467005285703765,
         -0.00562141714609677,
         0.0316768385192413,
         -0.044229828274971,
         0.0566439715691768,
         -0.0495699615819368,
         0.103518936304882,
         -0.0388099132134588,
         -0.0256250291658011,
         0.0525875919072054,
         -0.0495086149311421,
         0.032158495923705,
         -0.00662239266293944,
         -0.0304597912483002,
         0.0733886372428761,
         0.0565330035328844,
         -0.00109975278653558,
         -0.0825999997262552,
         0.110866501492697,
         -0.0779488908269202,
         -0.0217242058846571,
         0.0794272843060628,
         -0.0217242058846573,
         -0.0779488908269202,
         0.0879924556802986,
         0.0315146944136672,
         -0.0379547774100374,
         -0.0429036797282751,
         0.0689275796440815,
         0.0222439228990718,
         -0.108340487057759,
         0.000836965366082821,
         -0.0430478947619489,
         0.10515908647117,
         -0.0770694240013697,
         0.00622059043931394,
         -0.0278153087324302,
         0.095890510696547,
         0.00551393701900362,
         0.0432473766318398,
         -0.0529234316749972,
         -0.00835000383472688,
         0.0566365779565726,
         -0.0413663507572612,
         0.051792580290505,
         -0.0172402388496514,
         -0.0252595882162508,
         -0.0438354814949252,
         0.0385633529038864,
         0.00193814149323072,
         -0.0133839161661984,
         -0.00329439334765688,
         0.00117315678150835,
         -0.0161501759167752,
         -0.0747195438016613,
         0.0984260002843589,
         -0.0467005285703764,
         -0.00562141714609684,
         0.0316768385192412,
         -0.0442298282749711,
         0.0566439715691769,
         -0.0495699615819367,
         -0.0195707891122902,
         -0.0322616848350511,
         0.0375107728678999,
         0.0284850126116927,
         -0.0964099588182286,
         0.0222439228990718,
         0.0689275796440817,
         -0.0429036797282751,
         -0.0379547774100375,
         0.0315146944136672,
         0.0879924556802986,
         0.000626789860291423,
         -0.124188202838874,
         0.0635440777003311,
         -0.00671300354358013,
         0.0635440777003309,
         -0.124188202838874,
         0.000626789860291506,
         0.0231474015163364,
         0.0897395552666676,
         0.0125134783593096,
         -0.0329878802107493,
         -0.0361709527509339,
         0.0395900601461968,
         0.0618475374696938,
         -0.0238244119424932,
         -0.0685268412762085,
         -0.0670316701742916,
         -0.020711141168155,
         -0.0217407624601776,
         0.0847155820178145,
         -0.0507933381591812,
         -0.0237462233635326,
         0.0014474773977457,
         -0.0301745161870987,
         0.0958905106965469,
         0.00551393701900369,
         0.0432473766318399,
         -0.0529234316749972,
         -0.00835000383472685,
         0.0566365779565727,
         -0.0413663507572611,
         0.0517925802905049,
         0.00037446554179068,
         -0.0767955258464901,
         0.0735864433953515,
         -0.0368479302792467,
         0.0200514844631131,
         -0.0236624239930418,
         0.0079880611350861,
         0.00953695137922148,
         0.00888997944805179,
         0.0192429585001112,
         -0.0498703762947079,
         0.0196601544616758,
         0.0622446595323851,
         -0.02781530873243,
         0.006220590439314,
         -0.0770694240013697,
         0.10515908647117,
         -0.0430478947619491,
         0.000836965366082828,
         -0.108340487057759,
         -0.0238244119424932,
         0.0618475374696938,
         0.039590060146197,
         -0.0361709527509338,
         -0.0329878802107494,
         0.0125134783593096,
         0.0897395552666678,
         0.0231474015163367,
         0.0496270670807583,
         -0.0487979020334445,
         -0.0915444752879649,
         0.0490021142439823,
         0.00456808741676557,
         0.0490021142439823,
         -0.0915444752879647,
         -0.0487979020334446,
         0.0496270670807582,
         0.0231474015163365,
         0.0897395552666676,
         0.0125134783593096,
         -0.0329878802107494,
         -0.0361709527509338,
         0.0395900601461969,
         0.0618475374696937,
         -0.0238244119424932,
         -0.108340487057759,
         0.000836965366082625,
         -0.0430478947619489,
         0.10515908647117,
         -0.0770694240013699,
         0.006220590439314,
         -0.0278153087324301,
         0.0622446595323851,
         0.0196601544616757,
         -0.0498703762947079,
         0.0192429585001113,
         0.00888997944805204,
         0.00953695137922145,
         0.00798806113508624,
         -0.0236624239930418,
         0.020051484463113,
         -0.036847930279247,
         0.0735864433953515,
         -0.0767955258464902,
         0.000374465541790618,
         0.051792580290505,
         -0.0413663507572611,
         0.0566365779565726,
         -0.0083500038347268,
         -0.0529234316749972,
         0.0432473766318399,
         0.00551393701900362,
         0.095890510696547,
         -0.030174516187099,
         0.0014474773977457,
         -0.0237462233635327,
         -0.050793338159181,
         0.0847155820178145,
         -0.0217407624601777,
         -0.0207111411681552,
         -0.0670316701742916,
         -0.0685268412762087,
         -0.0238244119424931,
         0.0618475374696937,
         0.0395900601461969,
         -0.0361709527509338,
         -0.0329878802107493,
         0.0125134783593097,
         0.0897395552666677,
         0.0231474015163367,
         0.000626789860291392,
         -0.124188202838874,
         0.0635440777003309,
         -0.00671300354358037,
         0.0635440777003309,
         -0.124188202838874,
         0.000626789860291472,
         0.0879924556802985,
         0.0315146944136673,
         -0.0379547774100373,
         -0.042903679728275,
         0.0689275796440817,
         0.0222439228990718,
         -0.0964099588182285,
         0.0284850126116927,
         0.0375107728678999,
         -0.0322616848350511,
         -0.0195707891122902,
         -0.0495699615819367,
         0.0566439715691766,
         -0.044229828274971,
         0.0316768385192411,
         -0.00562141714609693,
         -0.0467005285703764,
         0.0984260002843587,
         -0.0747195438016612,
         -0.016150175916775,
         0.00117315678150843,
         -0.00329439334765689,
         -0.0133839161661984,
         0.00193814149323065,
         0.0385633529038864,
         -0.0438354814949252,
         -0.0252595882162509,
         -0.0172402388496513,
         0.051792580290505,
         -0.0413663507572613,
         0.0566365779565727,
         -0.00835000383472667,
         -0.0529234316749973,
         0.0432473766318397,
         0.00551393701900367,
         0.0958905106965469,
         -0.0278153087324301,
         0.0062205904393139,
         -0.0770694240013698,
         0.10515908647117,
         -0.0430478947619488,
         0.000836965366082766,
         -0.108340487057759,
         0.0222439228990718,
         0.0689275796440816,
         -0.042903679728275,
         -0.0379547774100374,
         0.0315146944136671,
         0.0879924556802986,
         -0.0779488908269202,
         -0.0217242058846571,
         0.0794272843060628,
         -0.0217242058846571,
         -0.0779488908269203,
         0.110866501492697,
         -0.0825999997262552,
         -0.00109975278653563,
         0.0565330035328845,
         0.0733886372428762,
         -0.0304597912483003,
         -0.00662239266293965,
         0.0321584959237049,
         -0.0495086149311421,
         0.0525875919072054,
         -0.0256250291658013,
         -0.038809913213459,
         0.103518936304882,
         -0.0495699615819366,
         0.0566439715691768,
         -0.0442298282749712,
         0.0316768385192413,
         -0.00562141714609675,
         -0.0467005285703764,
         0.0984260002843589,
         -0.0747195438016611,
         0.00798806113508615,
         -0.0236624239930418,
         0.020051484463113,
         -0.0368479302792468,
         0.0735864433953515,
         -0.0767955258464904,
         0.00037446554179078,
         0.00953695137922139,
         0.00888997944805173,
         0.0192429585001113,
         -0.049870376294708,
         0.019660154461676,
         0.062244659532385,
         -0.0195707891122902,
         -0.0322616848350512,
         0.0375107728678998,
         0.0284850126116927,
         -0.0964099588182286,
         0.0565330035328843,
         -0.00109975278653553,
         -0.082599999726255,
         0.110866501492697,
         -0.0966481492887292,
         0.127853483846311,
         -0.0966481492887292},
        {0.00628487037591333,
         -0.00831410201847159,
         0.00628487037591331,
         0.00165828988191032,
         -0.00793029222789873,
         0.0133731496329319,
         -0.0125440046919767,
         -0.00565803966692398,
         0.00709212176835454,
         -0.00133938998243131,
         -0.00878652628348908,
         0.0144270379362847,
         -0.0063000512855479,
         0.0168909107832974,
         -0.0267545286890886,
         0.0278481360302726,
         -0.016493408236619,
         -0.000743788251127067,
         0.0216784395817093,
         -0.0248017038710853,
         0.014005761320319,
         0.00708161248667529,
         -0.0282892809030076,
         0.0364442495954656,
         -0.0236888658329974,
         0.0142372828324164,
         -0.0430713871353437,
         0.069799627972324,
         -0.0840145462046048,
         0.0790070899935415,
         -0.0549491643430388,
         0.0212966680393562,
         0.00392197792375541,
         -0.0423215095048112,
         0.0299916608910743,
         -0.00179481920043747,
         -0.0385040147987196,
         0.084520676913542,
         -0.127794642305845,
         0.159519557131044,
         -0.173461499036857,
         0.170064966521804,
         -0.0125440046919766,
         0.0133731496329318,
         -0.00793029222789839,
         0.00165828988191017,
         0.00427688855004317,
         0.0026649510054542,
         -0.00658495698646073,
         0.00266495100545422,
         0.00427688855004312,
         0.0192397378277792,
         -0.0303023972380084,
         0.0293231138806194,
         -0.0236416795635,
         0.0227082219710007,
         -0.0252881716200086,
         -0.0197459343506804,
         0.0115111357529584,
         0.00323843291048592,
         -0.0119090959005878,
         0.0143576743326783,
         -0.0205683935499418,
         0.0347893943792866,
         -0.0514946165456344,
         0.0735306270538547,
         -0.0777966084856262,
         0.0712744262161864,
         -0.0659284391003759,
         0.0669184796110982,
         -0.0632636260274899,
         0.0311220885414887,
         0.0258817113531623,
         0.0193611715687631,
         -0.053309052185547,
         0.0709963865173225,
         -0.0753783545051458,
         0.0787228354737626,
         -0.0968760104356806,
         0.136401591236553,
         -0.174593676541876,
         0.0142372828324164,
         -0.0430713871353435,
         0.0697996279723238,
         -0.0840145462046049,
         0.0790070899935415,
         -0.0549491643430388,
         0.0212966680393564,
         0.00392197792375543,
         0.0144270379362846,
         -0.00878652628348913,
         -0.00133938998243128,
         0.0070921217683546,
         -0.00565803966692412,
         -0.0252881716200086,
         0.0227082219710007,
         -0.0236416795635001,
         0.0293231138806195,
         -0.0303023972380085,
         0.0192397378277793,
         -0.00418222966554548,
         0.0130356990567342,
         -0.00916239091721603,
         0.00542331692282081,
         -0.00916239091721589,
         0.0130356990567339,
         -0.00418222966554542,
         0.0797732307463399,
         -0.0783312748399503,
         0.0670219194853871,
         -0.0655800307625242,
         0.0698001500069724,
         -0.0692734879089762,
         0.0657806454977835,
         -0.0752559064124083,
         0.0201764738753674,
         -0.060305597570623,
         0.0706815439508358,
         -0.0674185437269355,
         0.067817987021695,
         -0.0752665043687317,
         0.0819499806082324,
         -0.0893835016794066,
         0.146757234309661,
         -0.0514946165456345,
         0.0735306270538545,
         -0.0777966084856262,
         0.0712744262161863,
         -0.0659284391003758,
         0.0669184796110981,
         -0.0632636260274897,
         0.0311220885414889,
         0.0216784395817093,
         -0.024801703871085,
         0.0140057613203191,
         0.00708161248667521,
         -0.0282892809030077,
         0.0364442495954654,
         -0.0236888658329975,
         -0.000743788251126989,
         -0.016493408236619,
         0.0278481360302726,
         -0.0267545286890888,
         0.0168909107832973,
         -0.00630005128554805,
         0.0347893943792867,
         -0.0205683935499417,
         0.0143576743326782,
         -0.0119090959005878,
         0.00323843291048584,
         0.0115111357529586,
         -0.0197459343506804,
         -0.0752559064124084,
         0.0657806454977835,
         -0.0692734879089761,
         0.0698001500069726,
         -0.0655800307625242,
         0.0670219194853873,
         -0.0783312748399502,
         0.07977323074634,
         -0.0853110440293124,
         0.0797784742189174,
         -0.0681588493091441,
         0.0699972472287295,
         -0.0732661375392812,
         0.0699972472287294,
         -0.0681588493091442,
         0.0797784742189175,
         -0.0853110440293124,
         0.0797732307463399,
         -0.0783312748399503,
         0.0670219194853872,
         -0.0655800307625242,
         0.0698001500069726,
         -0.0692734879089762,
         0.0657806454977834,
         -0.0752559064124084,
         -0.0197459343506805,
         0.0115111357529587,
         0.00323843291048585,
         -0.0119090959005877,
         0.0143576743326782,
         -0.0205683935499417,
         0.0347893943792867,
         -0.00630005128554796,
         0.0168909107832974,
         -0.0267545286890889,
         0.0278481360302727,
         -0.0164934082366191,
         -0.000743788251127,
         -0.0236888658329976,
         0.0364442495954654,
         -0.0282892809030076,
         0.00708161248667516,
         0.0140057613203191,
         -0.0248017038710852,
         0.0216784395817094,
         0.0311220885414889,
         -0.0632636260274898,
         0.066918479611098,
         -0.0659284391003759,
         0.0712744262161862,
         -0.0777966084856261,
         0.0735306270538545,
         -0.0514946165456344,
         0.146757234309661,
         -0.0893835016794065,
         0.0819499806082324,
         -0.0752665043687317,
         0.0678179870216951,
         -0.0674185437269355,
         0.0706815439508357,
         -0.0603055975706231,
         0.0201764738753674,
         -0.0752559064124084,
         0.0657806454977834,
         -0.0692734879089761,
         0.0698001500069725,
         -0.0655800307625242,
         0.0670219194853872,
         -0.0783312748399501,
         0.07977323074634,
         -0.00418222966554535,
         0.0130356990567341,
         -0.0091623909172162,
         0.00542331692282085,
         -0.00916239091721609,
         0.0130356990567339,
         -0.00418222966554534,
         0.0192397378277791,
         -0.0303023972380085,
         0.0293231138806194,
         -0.0236416795635001,
         0.0227082219710006,
         -0.0252881716200086,
         -0.00565803966692409,
         0.00709212176835461,
         -0.00133938998243118,
         -0.0087865262834892,
         0.0144270379362846,
         0.00392197792375533,
         0.0212966680393562,
         -0.0549491643430386,
         0.0790070899935415,
         -0.0840145462046049,
         0.069799627972324,
         -0.0430713871353434,
         0.0142372828324163,
         -0.174593676541875,
         0.136401591236554,
         -0.0968760104356804,
         0.0787228354737628,
         -0.0753783545051459,
         0.0709963865173223,
         -0.053309052185547,
         0.0193611715687631,
         0.0258817113531623,
         0.0311220885414888,
         -0.0632636260274898,
         0.0669184796110982,
         -0.0659284391003759,
         0.0712744262161862,
         -0.0777966084856261,
         0.0735306270538545,
         -0.0514946165456343,
         0.0347893943792867,
         -0.0205683935499419,
         0.0143576743326783,
         -0.0119090959005876,
         0.00323843291048575,
         0.0115111357529586,
         -0.0197459343506804,
         -0.0252881716200086,
         0.0227082219710006,
         -0.0236416795635002,
         0.0293231138806194,
         -0.0303023972380085,
         0.0192397378277791,
         0.00427688855004318,
         0.00266495100545415,
         -0.00658495698646084,
         0.00266495100545401,
         0.00427688855004311,
         0.00165828988191017,
         -0.00793029222789854,
         0.0133731496329318,
         -0.0125440046919766,
         0.170064966521804,
         -0.173461499036858,
         0.159519557131044,
         -0.127794642305845,
         0.0845206769135418,
         -0.0385040147987196,
         -0.00179481920043725,
         0.0299916608910742,
         -0.042321509504811,
         0.0039219779237553,
         0.0212966680393562,
         -0.0549491643430389,
         0.0790070899935416,
         -0.0840145462046049,
         0.069799627972324,
         -0.0430713871353435,
         0.0142372828324165,
         -0.0236888658329975,
         0.0364442495954654,
         -0.0282892809030077,
         0.00708161248667528,
         0.0140057613203191,
         -0.0248017038710851,
         0.0216784395817095,
         -0.000743788251126974,
         -0.016493408236619,
         0.0278481360302726,
         -0.0267545286890887,
         0.0168909107832972,
         -0.00630005128554792,
         0.0144270379362846,
         -0.00878652628348917,
         -0.00133938998243104,
         0.00709212176835457,
         -0.00565803966692399,
         -0.0125440046919767,
         0.0133731496329316,
         -0.00793029222789864,
         0.00165828988191026,
         0.00628487037591333,
         -0.00831410201847171,
         0.00628487037591347},
        {0.0188287437203047,
         -0.0249080866918476,
         0.0188287437203046,
         -0.0275707663961853,
         0.0250499792111475,
         -0.00874380882801678,
         -0.00504157437007595,
         -0.0246333520234836,
         0.0697738033262818,
         -0.100287152923365,
         0.0949622057505453,
         -0.0564944409361157,
         0.072762983603483,
         -0.0848788072123014,
         0.0368515891492724,
         0.0450325283236311,
         -0.111234324620342,
         0.11411116973794,
         -0.075204662401127,
         0.0236909026061738,
         0.0502664611860141,
         -0.0830746989635517,
         0.0439295329502886,
         0.0494076531524252,
         -0.126109815371641,
         0.0329001289395166,
         0.0405585890389614,
         -0.0660115843322932,
         0.0321159114153502,
         0.0266267715668086,
         -0.0563232441099444,
         0.0128461419632475,
         0.0968714764696894,
         0.0418212451940594,
         -0.0703135926434642,
         0.0437617634503721,
         -0.00564995746648882,
         -0.011940651670536,
         -0.0026434317501423,
         0.0351616718986517,
         -0.0435714458893274,
         -0.0403217136355301,
         -0.00504157437007577,
         -0.00874380882801693,
         0.0250499792111475,
         -0.0275707663961852,
         0.082138622992393,
         -0.101629450682461,
         0.104562071011735,
         -0.101629450682461,
         0.0821386229923929,
         -0.0579282563500188,
         0.0210919518121783,
         0.0150051819505794,
         -0.0350403334308138,
         0.049166777843799,
         -0.058233298280474,
         -0.0196737309901706,
         0.037443339102831,
         -0.00871448034901402,
         -0.02434208583169,
         0.0255697242485125,
         0.00144796024004171,
         -0.0193001324502859,
         0.07240313553198,
         -0.00655589612570395,
         -0.0427414448247526,
         0.0231474272234551,
         0.0412097579644506,
         -0.0829624284714388,
         0.0434582081995771,
         0.0675753865759409,
         -0.0798110417932661,
         -0.0296304720729574,
         0.00861938638406236,
         0.0613500116280557,
         -0.0953083235218076,
         0.0515845407934101,
         0.0427702425686335,
         -0.0879089061220591,
         -0.0715358323976134,
         0.0329001289395165,
         0.0405585890389613,
         -0.0660115843322933,
         0.03211591141535,
         0.0266267715668085,
         -0.0563232441099445,
         0.0128461419632476,
         0.0968714764696895,
         -0.0564944409361157,
         0.0949622057505455,
         -0.100287152923365,
         0.0697738033262817,
         -0.0246333520234838,
         -0.058233298280474,
         0.0491667778437989,
         -0.0350403334308137,
         0.0150051819505793,
         0.0210919518121784,
         -0.0579282563500186,
         0.0992704039172149,
         -0.019033039612904,
         -0.0366306308326323,
         0.0535453954030721,
         -0.0366306308326323,
         -0.0190330396129039,
         0.0992704039172148,
         -0.0560353886961208,
         -0.02545716659166,
         0.0148414869447679,
         0.0207598741120237,
         -0.0450235050846489,
         0.0530064865194766,
         -0.0322861611411632,
         -0.0511889024394929,
         0.0150517086598111,
         -0.0273718201546216,
         0.0564813201726357,
         -0.0367417514906878,
         0.00429351939291453,
         0.00144183837551219,
         0.0171150898278772,
         -0.0239528024616431,
         0.0110945692017613,
         0.0724031355319799,
         -0.00655589612570406,
         -0.0427414448247525,
         0.023147427223455,
         0.0412097579644508,
         -0.0829624284714389,
         0.0434582081995771,
         0.0675753865759408,
         -0.075204662401127,
         0.0236909026061741,
         0.0502664611860142,
         -0.0830746989635518,
         0.0439295329502888,
         0.049407653152425,
         -0.126109815371642,
         0.11411116973794,
         -0.111234324620343,
         0.045032528323631,
         0.0368515891492725,
         -0.0848788072123012,
         0.0727629836034832,
         -0.0193001324502857,
         0.00144796024004169,
         0.0255697242485124,
         -0.02434208583169,
         -0.00871448034901406,
         0.0374433391028311,
         -0.0196737309901703,
         -0.0511889024394929,
         -0.0322861611411632,
         0.0530064865194768,
         -0.0450235050846487,
         0.0207598741120238,
         0.0148414869447679,
         -0.02545716659166,
         -0.0560353886961208,
         0.0307009946215278,
         0.100621406035414,
         -0.0471614725926121,
         -0.00823616576381878,
         0.0270306934989184,
         -0.00823616576381869,
         -0.0471614725926122,
         0.100621406035414,
         0.0307009946215277,
         -0.0560353886961208,
         -0.02545716659166,
         0.014841486944768,
         0.0207598741120237,
         -0.045023505084649,
         0.0530064865194768,
         -0.0322861611411633,
         -0.0511889024394929,
         -0.0196737309901704,
         0.0374433391028312,
         -0.00871448034901402,
         -0.0243420858316898,
         0.0255697242485126,
         0.0014479602400416,
         -0.0193001324502858,
         0.0727629836034832,
         -0.084878807212301,
         0.0368515891492724,
         0.045032528323631,
         -0.111234324620342,
         0.11411116973794,
         -0.126109815371642,
         0.0494076531524251,
         0.0439295329502887,
         -0.0830746989635518,
         0.050266461186014,
         0.0236909026061742,
         -0.0752046624011272,
         0.0675753865759409,
         0.043458208199577,
         -0.082962428471439,
         0.0412097579644505,
         0.0231474272234551,
         -0.0427414448247529,
         -0.00655589612570405,
         0.0724031355319798,
         0.0110945692017614,
         -0.0239528024616431,
         0.0171150898278771,
         0.00144183837551204,
         0.00429351939291464,
         -0.0367417514906877,
         0.0564813201726358,
         -0.0273718201546216,
         0.0150517086598112,
         -0.0511889024394928,
         -0.0322861611411631,
         0.0530064865194768,
         -0.0450235050846488,
         0.0207598741120235,
         0.0148414869447678,
         -0.0254571665916602,
         -0.0560353886961207,
         0.0992704039172149,
         -0.0190330396129039,
         -0.0366306308326324,
         0.0535453954030724,
         -0.0366306308326323,
         -0.0190330396129041,
         0.0992704039172151,
         -0.0579282563500186,
         0.0210919518121785,
         0.0150051819505793,
         -0.0350403334308136,
         0.0491667778437992,
         -0.0582332982804739,
         -0.0246333520234838,
         0.0697738033262818,
         -0.100287152923365,
         0.0949622057505453,
         -0.0564944409361156,
         0.0968714764696895,
         0.0128461419632477,
         -0.0563232441099447,
         0.0266267715668085,
         0.03211591141535,
         -0.0660115843322932,
         0.0405585890389613,
         0.0329001289395166,
         -0.0715358323976134,
         -0.0879089061220591,
         0.0427702425686335,
         0.05158454079341,
         -0.0953083235218075,
         0.0613500116280555,
         0.00861938638406235,
         -0.0296304720729573,
         -0.0798110417932659,
         0.0675753865759407,
         0.0434582081995771,
         -0.0829624284714389,
         0.0412097579644506,
         0.0231474272234551,
         -0.0427414448247526,
         -0.00655589612570392,
         0.0724031355319798,
         -0.0193001324502858,
         0.00144796024004165,
         0.0255697242485125,
         -0.0243420858316898,
         -0.00871448034901418,
         0.0374433391028311,
         -0.0196737309901706,
         -0.0582332982804739,
         0.0491667778437991,
         -0.0350403334308136,
         0.0150051819505794,
         0.0210919518121784,
         -0.0579282563500187,
         0.0821386229923928,
         -0.101629450682461,
         0.104562071011735,
         -0.101629450682461,
         0.082138622992393,
         -0.0275707663961853,
         0.0250499792111475,
         -0.00874380882801681,
         -0.0050415743700758,
         -0.0403217136355302,
         -0.0435714458893274,
         0.0351616718986517,
         -0.00264343175014219,
         -0.0119406516705359,
         -0.00564995746648882,
         0.0437617634503722,
         -0.0703135926434644,
         0.0418212451940596,
         0.0968714764696896,
         0.0128461419632476,
         -0.0563232441099444,
         0.0266267715668086,
         0.03211591141535,
         -0.0660115843322932,
         0.0405585890389613,
         0.0329001289395165,
         -0.126109815371642,
         0.0494076531524252,
         0.0439295329502888,
         -0.0830746989635517,
         0.050266461186014,
         0.023690902606174,
         -0.0752046624011269,
         0.11411116973794,
         -0.111234324620342,
         0.045032528323631,
         0.0368515891492725,
         -0.0848788072123012,
         0.0727629836034832,
         -0.0564944409361156,
         0.0949622057505456,
         -0.100287152923365,
         0.0697738033262818,
         -0.0246333520234837,
         -0.00504157437007567,
         -0.00874380882801692,
         0.0250499792111475,
         -0.0275707663961855,
         0.0188287437203047,
         -0.0249080866918476,
         0.0188287437203047},
        {0.039087697587861,
         -0.0517081635697897,
         0.039087697587861,
         0.00647241964427956,
         -0.0435595685529511,
         0.0774105076394822,
         -0.0741742978173425,
         -0.0357423045393888,
         0.0492771604321649,
         -0.0190604932257382,
         -0.0408886107710381,
         0.078309377055708,
         0.0639548590778574,
         -0.0573463068842297,
         0.0229201610398865,
         -0.00735733349027496,
         0.0378277685463511,
         -0.0845825641193561,
         -0.0830582524583377,
         0.046258993031329,
         -0.0021977083488997,
         -0.0163976451182832,
         0.0212551380671407,
         -0.0470845879000807,
         0.100451099676275,
         0.0589077151400655,
         0.0149343670127672,
         -0.0560299652530051,
         0.0606988442274823,
         -0.049103958168854,
         0.0315544527206314,
         0.00726636819386931,
         -0.0903895323337358,
         0.07315970240102,
         -0.124175280191214,
         0.114398442006606,
         -0.082049526485098,
         0.0488034002872136,
         -0.0219080547353425,
         0.00369008296295471,
         -0.00844703757378684,
         0.0867266688109973,
         -0.0741742978173425,
         0.0774105076394823,
         -0.043559568552951,
         0.00647241964427945,
         0.0343261492760037,
         0.00435713887423573,
         -0.0271011726251952,
         0.00435713887423568,
         0.0343261492760039,
         -0.0251896075760906,
         0.0324042087805755,
         -0.0746723658143745,
         0.105876968129106,
         -0.0692683749444425,
         -0.0233548982740774,
         0.0066890417798332,
         -0.0345692526354438,
         0.048859662250215,
         -0.00376583590810269,
         -0.0744095837172644,
         0.0951914546700905,
         0.00444199097169756,
         0.0508240430934932,
         -0.00349570231561974,
         0.00568504318335577,
         -0.0446174613510196,
         0.0565158254235937,
         -0.00762012253012335,
         -0.0438188813813561,
         -0.036749204836016,
         -0.141180472787946,
         0.0333418873735365,
         -0.0401643178728344,
         0.0682758523900073,
         -0.0699726691072569,
         0.0569052912577503,
         -0.0694435590387267,
         0.101720318464792,
         0.0176461728386164,
         0.0589077151400655,
         0.014934367012767,
         -0.0560299652530051,
         0.0606988442274823,
         -0.0491039581688536,
         0.0315544527206313,
         0.00726636819386931,
         -0.0903895323337359,
         0.0783093770557079,
         -0.040888610771038,
         -0.0190604932257381,
         0.0492771604321648,
         -0.0357423045393887,
         -0.0233548982740773,
         -0.0692683749444426,
         0.105876968129106,
         -0.0746723658143747,
         0.0324042087805755,
         -0.0251896075760907,
         0.0264679267781913,
         0.0145725173402688,
         0.0137384172453003,
         -0.0377401006424907,
         0.0137384172453002,
         0.0145725173402689,
         0.0264679267781915,
         -0.0635895307002376,
         0.0442260084700883,
         -0.0344227584643702,
         -0.01135043939345,
         0.0432466437554165,
         0.000946420365382249,
         -0.0836845960644863,
         0.0350009023212534,
         0.0957220666885736,
         -0.0746641227134743,
         0.0366732028244656,
         -0.0128045192365414,
         0.0531458412657697,
         -0.126607270875967,
         0.131514225874923,
         -0.0170036307601772,
         0.0152233152143421,
         0.0508240430934933,
         -0.00349570231561958,
         0.00568504318335574,
         -0.0446174613510196,
         0.0565158254235937,
         -0.00762012253012334,
         -0.043818881381356,
         -0.0367492048360159,
         -0.0830582524583377,
         0.0462589930313288,
         -0.00219770834889974,
         -0.0163976451182831,
         0.0212551380671405,
         -0.0470845879000806,
         0.100451099676275,
         -0.0845825641193562,
         0.037827768546351,
         -0.00735733349027498,
         0.0229201610398864,
         -0.0573463068842298,
         0.0639548590778573,
         0.00444199097169758,
         0.0951914546700906,
         -0.0744095837172644,
         -0.00376583590810243,
         0.048859662250215,
         -0.0345692526354438,
         0.00668904177983302,
         0.0350009023212534,
         -0.0836845960644864,
         0.000946420365382286,
         0.0432466437554165,
         -0.0113504393934499,
         -0.0344227584643703,
         0.0442260084700884,
         -0.0635895307002377,
         -0.0438014322890307,
         0.0788152082763116,
         -0.042283654772782,
         0.0696169703725864,
         -0.0943236640328115,
         0.0696169703725864,
         -0.0422836547727821,
         0.0788152082763117,
         -0.0438014322890306,
         -0.0635895307002377,
         0.0442260084700884,
         -0.0344227584643703,
         -0.0113504393934499,
         0.0432466437554165,
         0.000946420365381903,
         -0.0836845960644863,
         0.0350009023212535,
         0.00668904177983304,
         -0.0345692526354436,
         0.048859662250215,
         -0.00376583590810261,
         -0.0744095837172644,
         0.0951914546700907,
         0.00444199097169764,
         0.0639548590778574,
         -0.0573463068842299,
         0.0229201610398864,
         -0.00735733349027513,
         0.037827768546351,
         -0.0845825641193563,
         0.100451099676275,
         -0.0470845879000806,
         0.0212551380671406,
         -0.0163976451182831,
         -0.00219770834889958,
         0.046258993031329,
         -0.0830582524583378,
         -0.036749204836016,
         -0.043818881381356,
         -0.00762012253012341,
         0.0565158254235937,
         -0.0446174613510195,
         0.00568504318335577,
         -0.0034957023156195,
         0.0508240430934932,
         0.015223315214342,
         -0.0170036307601771,
         0.131514225874923,
         -0.126607270875967,
         0.0531458412657697,
         -0.0128045192365414,
         0.0366732028244656,
         -0.0746641227134741,
         0.0957220666885735,
         0.0350009023212535,
         -0.0836845960644863,
         0.000946420365382326,
         0.0432466437554166,
         -0.0113504393934498,
         -0.0344227584643704,
         0.0442260084700882,
         -0.0635895307002377,
         0.0264679267781913,
         0.014572517340269,
         0.0137384172453003,
         -0.0377401006424905,
         0.0137384172453004,
         0.0145725173402688,
         0.0264679267781913,
         -0.0251896075760907,
         0.0324042087805756,
         -0.0746723658143748,
         0.105876968129106,
         -0.0692683749444426,
         -0.0233548982740774,
         -0.0357423045393889,
         0.0492771604321647,
         -0.0190604932257382,
         -0.040888610771038,
         0.0783093770557081,
         -0.0903895323337359,
         0.00726636819386947,
         0.0315544527206312,
         -0.0491039581688537,
         0.0606988442274823,
         -0.0560299652530051,
         0.0149343670127672,
         0.0589077151400656,
         0.0176461728386164,
         0.101720318464792,
         -0.0694435590387268,
         0.0569052912577501,
         -0.0699726691072571,
         0.0682758523900071,
         -0.0401643178728347,
         0.0333418873735368,
         -0.141180472787945,
         -0.0367492048360161,
         -0.043818881381356,
         -0.00762012253012341,
         0.0565158254235938,
         -0.0446174613510195,
         0.00568504318335563,
         -0.00349570231561953,
         0.0508240430934934,
         0.00444199097169769,
         0.0951914546700905,
         -0.0744095837172645,
         -0.00376583590810247,
         0.0488596622502152,
         -0.0345692526354438,
         0.00668904177983302,
         -0.0233548982740775,
         -0.0692683749444425,
         0.105876968129106,
         -0.0746723658143747,
         0.0324042087805757,
         -0.0251896075760906,
         0.0343261492760037,
         0.00435713887423552,
         -0.0271011726251953,
         0.00435713887423555,
         0.0343261492760037,
         0.00647241964427952,
         -0.0435595685529508,
         0.0774105076394824,
         -0.0741742978173425,
         0.0867266688109971,
         -0.0084470375737869,
         0.00369008296295461,
         -0.0219080547353424,
         0.0488034002872136,
         -0.0820495264850981,
         0.114398442006606,
         -0.124175280191214,
         0.0731597024010201,
         -0.090389532333736,
         0.00726636819386965,
         0.0315544527206313,
         -0.0491039581688539,
         0.0606988442274822,
         -0.0560299652530051,
         0.0149343670127671,
         0.0589077151400655,
         0.100451099676275,
         -0.0470845879000806,
         0.0212551380671406,
         -0.0163976451182831,
         -0.00219770834889942,
         0.0462589930313289,
         -0.0830582524583377,
         -0.0845825641193561,
         0.0378277685463512,
         -0.00735733349027508,
         0.0229201610398864,
         -0.0573463068842297,
         0.0639548590778574,
         0.0783093770557079,
         -0.0408886107710379,
         -0.0190604932257383,
         0.0492771604321647,
         -0.0357423045393888,
         -0.0741742978173424,
         0.0774105076394822,
         -0.0435595685529508,
         0.00647241964427955,
         0.039087697587861,
         -0.0517081635697898,
         0.0390876975878612},
        {-0.113000489986603,
         0.0857888677352439,
         0.0272116222513591,
         -0.0298492792875376,
         -0.0740011197379664,
         0.0287279661963476,
         -0.0263772695779195,
         0.0843398232981855,
         -0.000430440626625701,
         -0.0284410057785969,
         0.0480882572582409,
         -0.0343280856608353,
         -0.0618809792935589,
         0.0550276182911673,
         -0.00636151582428937,
         -0.0280482459279507,
         -0.031686040069649,
         0.0789019716932728,
         -0.0136736922234851,
         -0.0435873865926476,
         0.0339285996016999,
         -0.0102663861972452,
         0.0574719481877937,
         -0.0327635243982124,
         -0.0443661846023231,
         0.0550614617655532,
         -0.00471709839565718,
         -0.0307838673379284,
         0.0482819492635862,
         -0.0502898629118147,
         -0.00044860358828254,
         0.0293675822457213,
         0.00775183094087374,
         -0.0534217566046909,
         0.0512736506136548,
         -0.00797536932897037,
         -0.0478397386700317,
         -0.000442210593554297,
         0.038457773659895,
         -0.0381587046010401,
         0.0195850147472795,
         -0.0244877031092247,
         0.0601022075123524,
         -0.098861444179251,
         0.106836813508221,
         0.0272116222513591,
         0.085788867735244,
         -0.0740011197379664,
         -0.0151062102031165,
         -0.0740011197379663,
         0.0843398232981855,
         0.00123382412374554,
         0.0698119745270778,
         -0.000430440626625694,
         -0.0343280856608354,
         -0.0458549961685555,
         -0.0131592604022678,
         -0.0579196372886802,
         0.0550276182911674,
         -0.031686040069649,
         0.0562892402682882,
         0.0134782865476476,
         0.0416467780462017,
         -0.0117270787394002,
         -0.0435873865926477,
         0.0574719481877938,
         -0.00805964802801431,
         -0.0336929935887589,
         -0.0312931423011971,
         -0.00331149431146938,
         0.042064757435312,
         -0.00471709839565699,
         -0.0502898629118149,
         -0.00941430071834901,
         -0.0236311137312978,
         0.0804447242000277,
         -0.0226978038683974,
         -0.0101493393182297,
         -0.0299691492356587,
         0.0512736506136549,
         -0.000442210593554316,
         0.0186874966960647,
         0.0287423670886252,
         -0.00760261465093775,
         -0.0782759602865445,
         0.0923636171113976,
         -0.0477982367723881,
         0.0390081493411484,
         -0.0988614441792508,
         0.0482819492635862,
         -0.0502898629118148,
         -0.000448603588282612,
         0.0293675822457216,
         0.00775183094087384,
         -0.0534217566046909,
         0.051273650613655,
         -0.00797536932897033,
         0.0287279661963476,
         -0.0740011197379663,
         -0.0298492792875376,
         -0.000430440626625688,
         0.0698119745270777,
         0.00123382412374553,
         0.0843398232981857,
         -0.0618809792935589,
         -0.013159260402268,
         -0.0561245998814199,
         -0.0131592604022679,
         -0.0618809792935589,
         0.0789019716932729,
         0.0134782865476477,
         0.0446665612514037,
         0.0230634154506634,
         0.0416467780462018,
         -0.013673692223485,
         -0.0327635243982124,
         -0.0336929935887591,
         -0.0321280440834385,
         -0.025103489012079,
         -0.0340923491273036,
         -0.00331149431146942,
         0.0550614617655534,
         -0.000448603588282486,
         -0.0236311137312977,
         0.0751256422436325,
         -0.0156090207139094,
         0.0668942309940425,
         -0.0265984956341762,
         -0.0101493393182296,
         -0.0534217566046909,
         0.0384577736598951,
         0.0287423670886253,
         0.00746709797393679,
         -0.0617520568387372,
         0.00925518900522595,
         -0.0537262834984086,
         0.0892756550684667,
         -0.0477982367723883,
         0.0601022075123522,
         -0.0502898629118148,
         -0.00941430071834906,
         -0.0236311137312978,
         0.0804447242000277,
         -0.0226978038683973,
         -0.0101493393182297,
         -0.0299691492356587,
         0.0512736506136551,
         -0.0102663861972453,
         0.0574719481877937,
         -0.0327635243982126,
         -0.0443661846023231,
         0.0550614617655533,
         -0.00471709839565718,
         -0.0307838673379284,
         -0.0284410057785968,
         -0.000430440626625775,
         0.0843398232981856,
         -0.0263772695779195,
         0.0550276182911672,
         -0.0579196372886801,
         -0.013159260402268,
         -0.0458549961685554,
         -0.0343280856608354,
         -0.0136736922234848,
         0.0416467780462018,
         0.0230634154506634,
         0.0446665612514036,
         0.0134782865476476,
         0.0789019716932728,
         -0.0443661846023231,
         -0.031293142301197,
         -0.0251034890120787,
         -0.0412685758703407,
         -0.0251034890120788,
         -0.0312931423011971,
         -0.0443661846023231,
         0.0293675822457216,
         0.0804447242000277,
         -0.0156090207139094,
         0.0750427974153991,
         -0.00995896079650438,
         0.0668942309940423,
         -0.0226978038683974,
         0.00775183094087387,
         -0.0381587046010399,
         -0.00760261465093765,
         -0.0617520568387368,
         0.00307976709533817,
         -0.0633145472605269,
         0.00981206837705022,
         -0.0537262834984085,
         0.0923636171113975,
         -0.0244877031092247,
         -0.000448603588282635,
         -0.0236311137312977,
         0.0751256422436325,
         -0.0156090207139093,
         0.0668942309940425,
         -0.026598495634176,
         -0.0101493393182297,
         -0.0534217566046909,
         0.0574719481877938,
         -0.00805964802801414,
         -0.0336929935887589,
         -0.0312931423011972,
         -0.00331149431146933,
         0.0420647574353119,
         -0.00471709839565715,
         -0.0280482459279504,
         -0.0316860400696492,
         0.0789019716932726,
         -0.013673692223485,
         -0.0435873865926476,
         0.0339285996017,
         -0.0063615158242894,
         0.0550276182911673,
         -0.0618809792935589,
         -0.0343280856608353,
         0.0480882572582408,
         -0.0435873865926475,
         -0.0117270787394001,
         0.0416467780462018,
         0.0134782865476474,
         0.0562892402682882,
         -0.0316860400696491,
         0.0550614617655533,
         -0.00331149431146931,
         -0.0340923491273036,
         -0.0251034890120788,
         -0.0321280440834385,
         -0.0336929935887591,
         -0.0327635243982124,
         0.00775183094087369,
         -0.0226978038683974,
         0.0668942309940425,
         -0.00995896079650443,
         0.0750427974153991,
         -0.0156090207139094,
         0.0804447242000277,
         0.0293675822457216,
         0.0195850147472794,
         -0.0782759602865446,
         0.0092551890052261,
         -0.0633145472605268,
         -0.00176928935836752,
         -0.0633145472605268,
         0.00925518900522604,
         -0.0782759602865445,
         0.0195850147472796,
         0.0293675822457217,
         0.0804447242000276,
         -0.0156090207139096,
         0.0750427974153992,
         -0.00995896079650439,
         0.0668942309940425,
         -0.0226978038683975,
         0.00775183094087386,
         -0.0327635243982125,
         -0.033692993588759,
         -0.0321280440834385,
         -0.0251034890120789,
         -0.0340923491273035,
         -0.0033114943114694,
         0.0550614617655532,
         -0.0316860400696491,
         0.0562892402682882,
         0.0134782865476476,
         0.0416467780462018,
         -0.0117270787394001,
         -0.0435873865926476,
         0.0480882572582408,
         -0.0343280856608354,
         -0.0618809792935589,
         0.0550276182911674,
         -0.00636151582428943,
         0.0339285996016999,
         -0.0435873865926476,
         -0.0136736922234849,
         0.0789019716932728,
         -0.0316860400696491,
         -0.0280482459279506,
         -0.004717098395657,
         0.0420647574353118,
         -0.00331149431146925,
         -0.0312931423011971,
         -0.0336929935887589,
         -0.0080596480280142,
         0.0574719481877937,
         -0.053421756604691,
         -0.0101493393182297,
         -0.0265984956341763,
         0.0668942309940425,
         -0.0156090207139094,
         0.0751256422436324,
         -0.0236311137312976,
         -0.000448603588282587,
         -0.0244877031092246,
         0.0923636171113976,
         -0.0537262834984084,
         0.00981206837705017,
         -0.063314547260527,
         0.00307976709533845,
         -0.0617520568387371,
         -0.00760261465093771,
         -0.0381587046010399,
         0.00775183094087376,
         -0.0226978038683974,
         0.0668942309940422,
         -0.00995896079650451,
         0.0750427974153989,
         -0.0156090207139094,
         0.0804447242000276,
         0.0293675822457217,
         -0.0443661846023231,
         -0.031293142301197,
         -0.0251034890120788,
         -0.0412685758703406,
         -0.0251034890120788,
         -0.0312931423011969,
         -0.0443661846023231,
         0.0789019716932729,
         0.0134782865476475,
         0.0446665612514036,
         0.0230634154506634,
         0.0416467780462017,
         -0.013673692223485,
         -0.0343280856608352,
         -0.0458549961685556,
         -0.013159260402268,
         -0.0579196372886802,
         0.0550276182911674,
         -0.0263772695779196,
         0.0843398232981857,
         -0.000430440626625739,
         -0.0284410057785967,
         -0.0307838673379284,
         -0.00471709839565715,
         0.0550614617655532,
         -0.0443661846023232,
         -0.0327635243982126,
         0.0574719481877938,
         -0.0102663861972453,
         0.051273650613655,
         -0.0299691492356587,
         -0.0101493393182299,
         -0.0226978038683973,
         0.0804447242000277,
         -0.0236311137312977,
         -0.00941430071834912,
         -0.0502898629118147,
         0.0601022075123521,
         -0.0477982367723883,
         0.0892756550684666,
         -0.0537262834984087,
         0.00925518900522613,
         -0.0617520568387372,
         0.00746709797393699,
         0.0287423670886252,
         0.038457773659895,
         -0.0534217566046909,
         -0.0101493393182297,
         -0.0265984956341762,
         0.0668942309940425,
         -0.0156090207139095,
         0.0751256422436325,
         -0.0236311137312978,
         -0.000448603588282634,
         0.0550614617655533,
         -0.00331149431146946,
         -0.0340923491273036,
         -0.025103489012079,
         -0.0321280440834385,
         -0.0336929935887589,
         -0.0327635243982124,
         -0.013673692223485,
         0.0416467780462018,
         0.0230634154506634,
         0.0446665612514035,
         0.0134782865476476,
         0.078901971693273,
         -0.061880979293559,
         -0.013159260402268,
         -0.05612459988142,
         -0.0131592604022681,
         -0.061880979293559,
         0.0843398232981856,
         0.00123382412374543,
         0.0698119745270779,
         -0.000430440626625721,
         -0.0298492792875375,
         -0.0740011197379662,
         0.0287279661963477,
         -0.00797536932897047,
         0.051273650613655,
         -0.0534217566046909,
         0.00775183094087383,
         0.0293675822457217,
         -0.000448603588282505,
         -0.0502898629118146,
         0.0482819492635861,
         -0.0988614441792508,
         0.0390081493411483,
         -0.0477982367723881,
         0.0923636171113975,
         -0.0782759602865445,
         -0.00760261465093753,
         0.0287423670886252,
         0.0186874966960645,
         -0.000442210593554407,
         0.0512736506136551,
         -0.0299691492356586,
         -0.0101493393182297,
         -0.0226978038683972,
         0.0804447242000276,
         -0.0236311137312977,
         -0.00941430071834891,
         -0.0502898629118149,
         -0.0047170983956569,
         0.042064757435312,
         -0.00331149431146943,
         -0.0312931423011971,
         -0.0336929935887589,
         -0.00805964802801422,
         0.0574719481877938,
         -0.0435873865926475,
         -0.0117270787394,
         0.0416467780462019,
         0.0134782865476475,
         0.0562892402682882,
         -0.031686040069649,
         0.0550276182911673,
         -0.05791963728868,
         -0.0131592604022681,
         -0.0458549961685554,
         -0.0343280856608352,
         -0.000430440626625742,
         0.0698119745270778,
         0.00123382412374553,
         0.0843398232981856,
         -0.0740011197379665,
         -0.0151062102031165,
         -0.0740011197379663,
         0.0857888677352439,
         0.0272116222513591,
         0.106836813508221,
         -0.098861444179251,
         0.0601022075123522,
         -0.0244877031092247,
         0.0195850147472796,
         -0.03815870460104,
         0.038457773659895,
         -0.000442210593554142,
         -0.0478397386700317,
         -0.00797536932897034,
         0.051273650613655,
         -0.0534217566046912,
         0.00775183094087377,
         0.0293675822457216,
         -0.000448603588282613,
         -0.0502898629118148,
         0.0482819492635862,
         -0.0307838673379285,
         -0.00471709839565712,
         0.0550614617655532,
         -0.0443661846023233,
         -0.0327635243982127,
         0.0574719481877938,
         -0.0102663861972453,
         0.0339285996017,
         -0.0435873865926476,
         -0.013673692223485,
         0.0789019716932727,
         -0.031686040069649,
         -0.0280482459279505,
         -0.00636151582428935,
         0.0550276182911674,
         -0.0618809792935589,
         -0.0343280856608354,
         0.0480882572582408,
         -0.0284410057785968,
         -0.000430440626625849,
         0.0843398232981855,
         -0.0263772695779197,
         0.0287279661963476,
         -0.0740011197379664,
         -0.0298492792875373,
         0.0272116222513589,
         0.0857888677352439,
         -0.113000489986603},
        {0.0120307458604105,
         -0.0696781262544042,
         0.0576473803939938,
         0.0923739029071503,
         -0.0300236904173159,
         -0.0349516037412477,
         -0.0773192039957219,
         -0.0225820483671422,
         0.0566257133462613,
         -0.00279887182292686,
         0.0661432262167355,
         0.0176707724305136,
         0.00695393769768628,
         -0.0658215393622319,
         0.0444280685195425,
         -0.0664521142677456,
         0.000488394891601492,
         -0.021704356305082,
         0.0143742623612167,
         0.0537951686336886,
         -0.0784511205186033,
         0.0608125444302096,
         0.00845935475630394,
         -0.0106646505747172,
         0.0329458850603918,
         -0.0448918335201681,
         -0.013475375374444,
         0.0874347041015662,
         -0.0200278252750286,
         -0.0539531120881111,
         0.0527177239764681,
         -0.0461640225285349,
         0.0185995174597189,
         0.0199141510583131,
         -0.00567846640241563,
         -0.0831421869789868,
         -0.0492523065366288,
         0.0692801318116571,
         -0.028495412656476,
         -0.00664973666116945,
         0.0358464280902686,
         -0.0476097958008246,
         0.0343336950952825,
         -0.0300411779727032,
         0.11318336495169,
         0.0576473803939936,
         -0.0696781262544042,
         -0.0300236904173159,
         0.0517483550027161,
         -0.0300236904173161,
         -0.0225820483671422,
         -0.0187832212141312,
         -0.0102693571358389,
         0.0566257133462613,
         0.0176707724305136,
         0.0832523320989693,
         -0.0560306765417721,
         0.0219332935450744,
         -0.0658215393622319,
         0.00048839489160131,
         -0.0948553907917275,
         0.000510459326640661,
         0.0539151011122904,
         -0.0254127067756546,
         0.0537951686336889,
         0.008459354756304,
         0.0529908620057642,
         0.0496684906856376,
         -0.0384236866747896,
         -0.0265542730636464,
         0.0136065535826175,
         -0.013475375374444,
         -0.053953112088111,
         -0.00212831804309838,
         -0.0640673749992018,
         0.0249742192660424,
         -0.00935911673233387,
         0.0624625215287895,
         -0.0597097360753862,
         -0.00567846640241566,
         0.0692801318116571,
         0.0221209519849386,
         0.0207920852133415,
         0.000564879269215249,
         0.0077368812060888,
         -0.0116698500630351,
         -0.0566930167182384,
         0.120695269916204,
         -0.0300411779727035,
         -0.0200278252750287,
         -0.0539531120881111,
         0.0527177239764679,
         -0.0461640225285349,
         0.0185995174597188,
         0.0199141510583131,
         -0.00567846640241568,
         -0.0831421869789868,
         -0.0349516037412476,
         -0.0300236904173159,
         0.0923739029071504,
         0.0566257133462612,
         -0.0102693571358388,
         -0.0187832212141314,
         -0.0225820483671422,
         0.00695393769768614,
         -0.056030676541772,
         0.0925853937443539,
         -0.0560306765417721,
         0.00695393769768622,
         -0.0217043563050821,
         0.00051045932664046,
         -0.0203296322956875,
         -0.0228413494752566,
         0.0539151011122907,
         0.0143742623612169,
         -0.0106646505747171,
         0.0496684906856374,
         0.0348800741506922,
         -0.0157876952187879,
         -0.00728973768316359,
         -0.0265542730636464,
         -0.0448918335201681,
         0.052717723976468,
         -0.0640673749992018,
         -0.0397104881697234,
         -0.0387117880027928,
         0.0866470459344472,
         -0.0526939688142386,
         0.0624625215287893,
         0.0199141510583129,
         -0.028495412656476,
         0.0207920852133414,
         0.0539818077157309,
         0.0422307942541946,
         -0.0264004984920675,
         -0.0479697079577483,
         0.0455769106962554,
         -0.0566930167182383,
         0.0343336950952826,
         -0.053953112088111,
         -0.00212831804309842,
         -0.064067374999202,
         0.0249742192660425,
         -0.00935911673233387,
         0.0624625215287891,
         -0.0597097360753861,
         -0.00567846640241566,
         0.0608125444302099,
         0.00845935475630408,
         -0.0106646505747172,
         0.0329458850603916,
         -0.0448918335201679,
         -0.013475375374444,
         0.0874347041015662,
         -0.00279887182292682,
         0.0566257133462613,
         -0.0225820483671423,
         -0.077319203995722,
         -0.0658215393622318,
         0.0219332935450745,
         -0.0560306765417721,
         0.0832523320989692,
         0.0176707724305138,
         0.0143742623612167,
         0.0539151011122906,
         -0.0228413494752565,
         -0.0203296322956877,
         0.000510459326640569,
         -0.0217043563050822,
         0.0329458850603917,
         -0.0384236866747897,
         -0.0157876952187879,
         0.0598126737362508,
         -0.0157876952187879,
         -0.0384236866747897,
         0.0329458850603918,
         -0.0461640225285351,
         0.0249742192660424,
         -0.0387117880027926,
         0.0225674252767498,
         -0.067402576244225,
         0.0866470459344474,
         -0.00935911673233374,
         0.0185995174597188,
         -0.00664973666116949,
         0.000564879269215266,
         0.0422307942541944,
         0.0382855013776646,
         -0.0241276999384924,
         0.00932967087929143,
         -0.0479697079577483,
         -0.0116698500630352,
         -0.0476097958008246,
         0.0527177239764681,
         -0.064067374999202,
         -0.0397104881697233,
         -0.0387117880027927,
         0.0866470459344472,
         -0.0526939688142385,
         0.0624625215287894,
         0.0199141510583129,
         0.00845935475630403,
         0.0529908620057642,
         0.0496684906856375,
         -0.0384236866747896,
         -0.0265542730636464,
         0.0136065535826175,
         -0.0134753753744439,
         -0.0664521142677457,
         0.000488394891601345,
         -0.0217043563050821,
         0.0143742623612166,
         0.0537951686336885,
         -0.0784511205186033,
         0.0444280685195424,
         -0.0658215393622319,
         0.00695393769768622,
         0.0176707724305136,
         0.0661432262167355,
         0.0537951686336887,
         -0.0254127067756547,
         0.0539151011122907,
         0.000510459326640434,
         -0.0948553907917273,
         0.000488394891601124,
         -0.0448918335201682,
         -0.0265542730636463,
         -0.00728973768316367,
         -0.0157876952187878,
         0.0348800741506921,
         0.0496684906856375,
         -0.0106646505747171,
         0.0185995174597188,
         -0.00935911673233387,
         0.0866470459344472,
         -0.067402576244225,
         0.0225674252767497,
         -0.0387117880027929,
         0.0249742192660425,
         -0.0461640225285349,
         0.0358464280902686,
         0.00773688120608868,
         -0.0264004984920676,
         -0.0241276999384926,
         0.0689628509059675,
         -0.0241276999384926,
         -0.0264004984920676,
         0.00773688120608866,
         0.0358464280902685,
         -0.0461640225285349,
         0.0249742192660426,
         -0.0387117880027927,
         0.0225674252767498,
         -0.0674025762442249,
         0.086647045934447,
         -0.0093591167323339,
         0.0185995174597188,
         -0.010664650574717,
         0.0496684906856376,
         0.034880074150692,
         -0.0157876952187877,
         -0.00728973768316358,
         -0.0265542730636464,
         -0.0448918335201682,
         0.000488394891601269,
         -0.0948553907917275,
         0.00051045932664064,
         0.0539151011122904,
         -0.0254127067756545,
         0.0537951686336887,
         0.0661432262167355,
         0.0176707724305138,
         0.00695393769768624,
         -0.0658215393622318,
         0.0444280685195424,
         -0.0784511205186033,
         0.0537951686336887,
         0.0143742623612166,
         -0.021704356305082,
         0.000488394891601258,
         -0.0664521142677459,
         -0.0134753753744441,
         0.0136065535826175,
         -0.0265542730636463,
         -0.0384236866747895,
         0.0496684906856375,
         0.0529908620057644,
         0.00845935475630393,
         0.0199141510583128,
         0.0624625215287894,
         -0.0526939688142386,
         0.0866470459344471,
         -0.0387117880027926,
         -0.0397104881697236,
         -0.064067374999202,
         0.0527177239764679,
         -0.0476097958008246,
         -0.011669850063035,
         -0.0479697079577483,
         0.00932967087929148,
         -0.0241276999384926,
         0.0382855013776646,
         0.0422307942541944,
         0.000564879269215334,
         -0.00664973666116924,
         0.0185995174597188,
         -0.0093591167323339,
         0.0866470459344473,
         -0.0674025762442248,
         0.0225674252767498,
         -0.0387117880027927,
         0.0249742192660425,
         -0.0461640225285349,
         0.0329458850603916,
         -0.0384236866747896,
         -0.0157876952187879,
         0.0598126737362508,
         -0.0157876952187879,
         -0.0384236866747897,
         0.0329458850603916,
         -0.0217043563050821,
         0.00051045932664055,
         -0.0203296322956879,
         -0.0228413494752565,
         0.0539151011122905,
         0.0143742623612167,
         0.0176707724305136,
         0.0832523320989693,
         -0.056030676541772,
         0.0219332935450743,
         -0.0658215393622319,
         -0.0773192039957222,
         -0.0225820483671421,
         0.0566257133462612,
         -0.00279887182292691,
         0.0874347041015662,
         -0.013475375374444,
         -0.0448918335201681,
         0.0329458850603916,
         -0.010664650574717,
         0.00845935475630414,
         0.0608125444302097,
         -0.00567846640241568,
         -0.0597097360753861,
         0.062462521528789,
         -0.00935911673233381,
         0.0249742192660427,
         -0.0640673749992021,
         -0.00212831804309854,
         -0.053953112088111,
         0.0343336950952827,
         -0.0566930167182383,
         0.0455769106962556,
         -0.0479697079577483,
         -0.0264004984920675,
         0.0422307942541945,
         0.0539818077157308,
         0.0207920852133412,
         -0.0284954126564759,
         0.0199141510583129,
         0.0624625215287894,
         -0.0526939688142382,
         0.0866470459344471,
         -0.0387117880027927,
         -0.0397104881697233,
         -0.0640673749992019,
         0.0527177239764679,
         -0.0448918335201681,
         -0.0265542730636464,
         -0.00728973768316337,
         -0.0157876952187878,
         0.034880074150692,
         0.0496684906856376,
         -0.0106646505747169,
         0.0143742623612168,
         0.0539151011122906,
         -0.0228413494752567,
         -0.0203296322956876,
         0.000510459326640607,
         -0.0217043563050821,
         0.00695393769768617,
         -0.0560306765417722,
         0.092585393744354,
         -0.0560306765417721,
         0.00695393769768628,
         -0.0225820483671422,
         -0.0187832212141314,
         -0.0102693571358387,
         0.0566257133462613,
         0.0923739029071503,
         -0.0300236904173159,
         -0.0349516037412478,
         -0.0831421869789869,
         -0.00567846640241575,
         0.019914151058313,
         0.0185995174597189,
         -0.0461640225285348,
         0.0527177239764679,
         -0.053953112088111,
         -0.0200278252750285,
         -0.0300411779727034,
         0.120695269916204,
         -0.0566930167182382,
         -0.0116698500630351,
         0.00773688120608882,
         0.000564879269215484,
         0.0207920852133415,
         0.0221209519849386,
         0.0692801318116571,
         -0.00567846640241558,
         -0.0597097360753861,
         0.0624625215287894,
         -0.00935911673233392,
         0.0249742192660424,
         -0.064067374999202,
         -0.00212831804309842,
         -0.053953112088111,
         -0.013475375374444,
         0.0136065535826176,
         -0.0265542730636464,
         -0.0384236866747896,
         0.0496684906856375,
         0.0529908620057643,
         0.00845935475630392,
         0.0537951686336886,
         -0.0254127067756547,
         0.0539151011122903,
         0.000510459326640646,
         -0.0948553907917274,
         0.000488394891601291,
         -0.0658215393622319,
         0.0219332935450744,
         -0.0560306765417722,
         0.0832523320989692,
         0.0176707724305138,
         0.0566257133462613,
         -0.0102693571358388,
         -0.0187832212141313,
         -0.0225820483671423,
         -0.030023690417316,
         0.051748355002716,
         -0.030023690417316,
         -0.0696781262544042,
         0.0576473803939936,
         0.11318336495169,
         -0.0300411779727032,
         0.0343336950952824,
         -0.0476097958008246,
         0.0358464280902687,
         -0.00664973666116947,
         -0.0284954126564759,
         0.069280131811657,
         -0.0492523065366288,
         -0.0831421869789868,
         -0.00567846640241579,
         0.019914151058313,
         0.018599517459719,
         -0.0461640225285349,
         0.052717723976468,
         -0.0539531120881111,
         -0.0200278252750285,
         0.0874347041015662,
         -0.0134753753744439,
         -0.0448918335201681,
         0.0329458850603917,
         -0.0106646505747171,
         0.00845935475630416,
         0.0608125444302099,
         -0.0784511205186032,
         0.0537951686336887,
         0.0143742623612168,
         -0.0217043563050822,
         0.000488394891601356,
         -0.0664521142677458,
         0.0444280685195424,
         -0.0658215393622319,
         0.00695393769768625,
         0.0176707724305136,
         0.0661432262167354,
         -0.00279887182292673,
         0.0566257133462611,
         -0.0225820483671421,
         -0.077319203995722,
         -0.0349516037412478,
         -0.0300236904173158,
         0.0923739029071503,
         0.0576473803939936,
         -0.0696781262544042,
         0.0120307458604104},
        {-0.123071946925928,
         0.027348075197308,
         0.0957238717286201,
         -0.015848268931328,
         -0.0152128137526022,
         -0.0842240654626401,
         -0.00556504751990449,
         0.0321199746768495,
         -0.0148702652778801,
         0.0941375756478935,
         0.0434444418124141,
         -0.0598925811759561,
         0.0295210909791312,
         -0.0103605191576924,
         -0.08758500799187,
         -0.0801729346509729,
         0.0580728461975145,
         0.00217499930763981,
         -0.0332929614766747,
         0.038215409190165,
         0.0634154610406195,
         0.0964541830703848,
         -0.0244218726291176,
         -0.0366586972677266,
         0.0364666604992294,
         -0.00301083525573671,
         -0.0337352749219213,
         -0.0409252777593391,
         -0.0887805118999872,
         -0.010151312779879,
         0.0359323793847139,
         -0.00554612141565594,
         -0.0249640757252384,
         0.0262020471967564,
         0.00664368237680098,
         0.0359031259425625,
         0.0560131299354542,
         0.0327673819645329,
         -0.0250937107941353,
         0.0011387912043262,
         0.00236888396633605,
         0.0134197838281985,
         -0.0308878152927029,
         0.0258656634759261,
         -0.0617687894184885,
         0.09572387172862,
         0.0273480751973081,
         -0.0152128137526024,
         -0.102947285960463,
         -0.0152128137526022,
         0.0321199746768495,
         -0.012207032118481,
         0.126654124344925,
         -0.0148702652778798,
         -0.0598925811759561,
         0.0520835712359042,
         -0.0694961638824561,
         -0.0554507585910152,
         -0.0103605191576923,
         0.0580728461975145,
         -0.0405671881775377,
         0.0315098252552517,
         0.022064836262958,
         0.0435425597538024,
         0.0382154091901649,
         -0.0244218726291176,
         0.024984511498252,
         -0.0252740844412888,
         -0.00802304749529156,
         0.00660281255899834,
         -0.0732364160358639,
         -0.0337352749219212,
         -0.0101513127798791,
         -0.0463924495785128,
         0.0427355205404854,
         0.00466602198615879,
         -0.0201182319954409,
         0.0147260720990331,
         0.0827394244628616,
         0.00664368237680097,
         0.0327673819645328,
         0.0694420544836498,
         -0.0153759337347397,
         -0.0462681723547417,
         0.0458719734466558,
         -0.0132511851369965,
         -0.0172040211817908,
         -0.0705575550978475,
         0.0258656634759263,
         -0.0887805118999874,
         -0.010151312779879,
         0.0359323793847139,
         -0.00554612141565608,
         -0.0249640757252383,
         0.0262020471967564,
         0.00664368237680106,
         0.0359031259425625,
         -0.0842240654626402,
         -0.0152128137526023,
         -0.0158482689313279,
         -0.01487026527788,
         0.126654124344925,
         -0.0122070321184811,
         0.0321199746768496,
         0.0295210909791312,
         -0.0694961638824562,
         -0.0356458493524569,
         -0.0694961638824561,
         0.0295210909791312,
         0.00217499930763984,
         0.0315098252552517,
         -0.0109437729821223,
         0.107879477903235,
         0.022064836262958,
         -0.0332929614766749,
         -0.0366586972677266,
         -0.0252740844412888,
         0.0331140523562952,
         -0.0511585802217124,
         -0.0778069537881558,
         0.00660281255899838,
         -0.00301083525573651,
         0.035932379384714,
         0.0427355205404853,
         -0.0432337281988688,
         0.0329567222972046,
         0.0249144210548025,
         0.0486467493220557,
         0.0147260720990333,
         0.0262020471967563,
         -0.0250937107941353,
         -0.01537593373474,
         0.013310857813674,
         -0.0077663161144772,
         -0.027403049966118,
         0.0205992753459533,
         -0.082233199522292,
         -0.0172040211817906,
         -0.030887815292703,
         -0.0101513127798791,
         -0.0463924495785128,
         0.0427355205404854,
         0.00466602198615871,
         -0.0201182319954411,
         0.0147260720990332,
         0.0827394244628615,
         0.00664368237680093,
         0.0964541830703849,
         -0.0244218726291177,
         -0.0366586972677267,
         0.0364666604992294,
         -0.00301083525573685,
         -0.0337352749219212,
         -0.0409252777593389,
         0.0941375756478933,
         -0.0148702652778798,
         0.0321199746768496,
         -0.00556504751990469,
         -0.0103605191576923,
         -0.0554507585910152,
         -0.0694961638824561,
         0.0520835712359042,
         -0.0598925811759558,
         -0.0332929614766748,
         0.0220648362629578,
         0.107879477903236,
         -0.0109437729821225,
         0.0315098252552517,
         0.00217499930763971,
         0.0364666604992292,
         -0.00802304749529166,
         -0.0511585802217123,
         -0.043009826467429,
         -0.0511585802217124,
         -0.0080230474952917,
         0.0364666604992293,
         -0.00554612141565608,
         0.00466602198615875,
         0.0329567222972047,
         -0.0139276094602185,
         0.105470726535963,
         0.0249144210548026,
         -0.0201182319954411,
         -0.0249640757252384,
         0.00113879120432587,
         -0.0462681723547419,
         -0.00776631611447719,
         0.0162606087557382,
         -0.0335984912973666,
         -0.095508130373886,
         0.0205992753459531,
         -0.0132511851369965,
         0.0134197838281986,
         0.0359323793847137,
         0.0427355205404853,
         -0.0432337281988689,
         0.0329567222972048,
         0.0249144210548025,
         0.0486467493220558,
         0.0147260720990333,
         0.0262020471967564,
         -0.0244218726291176,
         0.024984511498252,
         -0.0252740844412888,
         -0.00802304749529149,
         0.00660281255899825,
         -0.0732364160358639,
         -0.0337352749219212,
         -0.0801729346509731,
         0.0580728461975147,
         0.0021749993076399,
         -0.0332929614766746,
         0.0382154091901649,
         0.0634154610406196,
         -0.08758500799187,
         -0.0103605191576923,
         0.0295210909791311,
         -0.0598925811759561,
         0.0434444418124142,
         0.0382154091901648,
         0.0435425597538025,
         0.0220648362629579,
         0.0315098252552518,
         -0.0405671881775377,
         0.0580728461975146,
         -0.00301083525573673,
         0.00660281255899844,
         -0.0778069537881559,
         -0.0511585802217124,
         0.0331140523562951,
         -0.0252740844412888,
         -0.0366586972677268,
         -0.0249640757252383,
         -0.0201182319954411,
         0.0249144210548025,
         0.105470726535964,
         -0.0139276094602185,
         0.0329567222972047,
         0.00466602198615871,
         -0.00554612141565604,
         0.00236888396633606,
         0.0458719734466556,
         -0.0274030499661181,
         -0.0335984912973666,
         -0.0579446257783783,
         -0.0335984912973668,
         -0.027403049966118,
         0.0458719734466557,
         0.00236888396633611,
         -0.00554612141565594,
         0.00466602198615869,
         0.0329567222972047,
         -0.0139276094602186,
         0.105470726535963,
         0.0249144210548025,
         -0.0201182319954411,
         -0.0249640757252384,
         -0.0366586972677268,
         -0.0252740844412889,
         0.033114052356295,
         -0.0511585802217126,
         -0.0778069537881559,
         0.00660281255899844,
         -0.00301083525573672,
         0.0580728461975146,
         -0.0405671881775378,
         0.0315098252552518,
         0.022064836262958,
         0.0435425597538025,
         0.0382154091901648,
         0.0434444418124141,
         -0.0598925811759562,
         0.0295210909791312,
         -0.0103605191576922,
         -0.0875850079918701,
         0.0634154610406197,
         0.0382154091901649,
         -0.0332929614766746,
         0.00217499930763995,
         0.0580728461975146,
         -0.0801729346509729,
         -0.0337352749219211,
         -0.073236416035864,
         0.00660281255899832,
         -0.00802304749529151,
         -0.0252740844412888,
         0.024984511498252,
         -0.0244218726291176,
         0.0262020471967564,
         0.0147260720990332,
         0.0486467493220556,
         0.0249144210548027,
         0.0329567222972048,
         -0.0432337281988689,
         0.0427355205404852,
         0.0359323793847139,
         0.0134197838281985,
         -0.0132511851369964,
         0.0205992753459531,
         -0.095508130373886,
         -0.0335984912973666,
         0.0162606087557382,
         -0.00776631611447705,
         -0.0462681723547417,
         0.00113879120432587,
         -0.0249640757252383,
         -0.020118231995441,
         0.0249144210548026,
         0.105470726535964,
         -0.0139276094602184,
         0.0329567222972045,
         0.00466602198615874,
         -0.00554612141565607,
         0.0364666604992292,
         -0.00802304749529177,
         -0.0511585802217124,
         -0.0430098264674291,
         -0.0511585802217123,
         -0.00802304749529162,
         0.0364666604992292,
         0.00217499930763978,
         0.0315098252552518,
         -0.0109437729821224,
         0.107879477903235,
         0.022064836262958,
         -0.0332929614766748,
         -0.0598925811759561,
         0.0520835712359042,
         -0.069496163882456,
         -0.0554507585910152,
         -0.0103605191576924,
         -0.00556504751990469,
         0.0321199746768496,
         -0.0148702652778799,
         0.0941375756478936,
         -0.040925277759339,
         -0.0337352749219212,
         -0.0030108352557368,
         0.0364666604992292,
         -0.0366586972677266,
         -0.0244218726291175,
         0.0964541830703849,
         0.00664368237680105,
         0.0827394244628617,
         0.0147260720990333,
         -0.0201182319954409,
         0.00466602198615856,
         0.0427355205404855,
         -0.0463924495785126,
         -0.0101513127798791,
         -0.0308878152927029,
         -0.0172040211817906,
         -0.0822331995222921,
         0.0205992753459534,
         -0.0274030499661181,
         -0.00776631611447716,
         0.0133108578136739,
         -0.01537593373474,
         -0.0250937107941351,
         0.0262020471967565,
         0.0147260720990333,
         0.0486467493220559,
         0.0249144210548025,
         0.0329567222972046,
         -0.0432337281988687,
         0.0427355205404852,
         0.035932379384714,
         -0.00301083525573686,
         0.00660281255899846,
         -0.0778069537881559,
         -0.0511585802217124,
         0.0331140523562952,
         -0.0252740844412888,
         -0.0366586972677268,
         -0.0332929614766747,
         0.0220648362629579,
         0.107879477903235,
         -0.0109437729821225,
         0.0315098252552518,
         0.00217499930763988,
         0.0295210909791313,
         -0.0694961638824561,
         -0.0356458493524571,
         -0.069496163882456,
         0.0295210909791312,
         0.0321199746768497,
         -0.0122070321184811,
         0.126654124344925,
         -0.01487026527788,
         -0.0158482689313282,
         -0.0152128137526023,
         -0.0842240654626403,
         0.0359031259425624,
         0.00664368237680125,
         0.0262020471967563,
         -0.0249640757252385,
         -0.00554612141565598,
         0.035932379384714,
         -0.0101513127798791,
         -0.0887805118999872,
         0.0258656634759263,
         -0.0705575550978476,
         -0.0172040211817906,
         -0.0132511851369964,
         0.0458719734466556,
         -0.0462681723547416,
         -0.0153759337347399,
         0.0694420544836501,
         0.032767381964533,
         0.006643682376801,
         0.0827394244628617,
         0.0147260720990333,
         -0.0201182319954412,
         0.00466602198615869,
         0.0427355205404854,
         -0.0463924495785127,
         -0.010151312779879,
         -0.0337352749219212,
         -0.0732364160358641,
         0.00660281255899856,
         -0.0080230474952916,
         -0.025274084441289,
         0.024984511498252,
         -0.0244218726291176,
         0.0382154091901649,
         0.0435425597538024,
         0.0220648362629579,
         0.0315098252552519,
         -0.0405671881775378,
         0.0580728461975146,
         -0.0103605191576923,
         -0.0554507585910154,
         -0.0694961638824561,
         0.0520835712359043,
         -0.0598925811759561,
         -0.01487026527788,
         0.126654124344925,
         -0.0122070321184812,
         0.0321199746768495,
         -0.0152128137526023,
         -0.102947285960463,
         -0.0152128137526021,
         0.027348075197308,
         0.09572387172862,
         -0.0617687894184884,
         0.025865663475926,
         -0.030887815292703,
         0.0134197838281984,
         0.00236888396633604,
         0.00113879120432617,
         -0.0250937107941353,
         0.0327673819645328,
         0.0560131299354541,
         0.0359031259425624,
         0.00664368237680106,
         0.0262020471967563,
         -0.0249640757252383,
         -0.00554612141565587,
         0.035932379384714,
         -0.0101513127798791,
         -0.0887805118999872,
         -0.0409252777593389,
         -0.0337352749219213,
         -0.00301083525573675,
         0.0364666604992293,
         -0.0366586972677268,
         -0.0244218726291177,
         0.0964541830703849,
         0.0634154610406196,
         0.038215409190165,
         -0.0332929614766749,
         0.0021749993076397,
         0.0580728461975147,
         -0.0801729346509731,
         -0.0875850079918702,
         -0.0103605191576924,
         0.0295210909791313,
         -0.0598925811759561,
         0.0434444418124141,
         0.0941375756478936,
         -0.0148702652778798,
         0.0321199746768497,
         -0.0055650475199047,
         -0.0842240654626402,
         -0.0152128137526021,
         -0.0158482689313282,
         0.09572387172862,
         0.027348075197308,
         -0.123071946925928},
        {-0.108902388819254,
         0.104533301095687,
         0.00436908772356796,
         -0.0629749198212266,
         -0.0549765708713122,
         0.0371892935508924,
         0.0457640954866651,
         0.0258162365018422,
         0.0365213354098481,
         -0.0615368504907911,
         -0.0410753069671811,
         -0.00741362559420927,
         -0.0224500431799356,
         -0.0186977906364358,
         0.0733623716156123,
         0.0229798420322707,
         0.0286114422570136,
         -0.0253362369308091,
         0.0490006602700509,
         -0.0222991030852922,
         -0.0592591805099302,
         0.0106803172324934,
         -0.0504902388971462,
         0.0279050519378792,
         -0.00407827051885564,
         -0.0426171208654745,
         0.0568108281326372,
         0.0213852950881722,
         -0.0257852459707288,
         0.0199819425063616,
         0.0278328457897933,
         -0.0539483380699818,
         0.0573604639905006,
         -0.0187608726821019,
         -0.0335569065064008,
         0.00398134187885112,
         -0.0657226152704396,
         0.0915078612411684,
         -0.106612789979404,
         0.0880575594528747,
         -0.0539376345964919,
         0.0176596918256812,
         -0.00515244337094668,
         0.0305190803379701,
         -0.0345004222168213,
         0.00436908772356798,
         0.104533301095687,
         -0.0549765708713123,
         -0.0361752215889488,
         -0.0549765708713123,
         0.0258162365018421,
         0.0969777322987686,
         -0.0192441294353589,
         0.0365213354098481,
         -0.00741362559420951,
         -0.0727664789407182,
         -0.0469682212981059,
         0.0363186501880724,
         -0.0186977906364356,
         0.0286114422570137,
         0.0075586159286156,
         0.0835424776072291,
         -0.0190669298376571,
         -0.00854059103935349,
         -0.0222991030852921,
         -0.0504902388971464,
         0.00751685397617303,
         -0.039646850318775,
         -0.0293792292305792,
         0.0159477752572088,
         0.00930091607518022,
         0.0568108281326372,
         0.0199819425063615,
         0.0386214158213143,
         -0.0141488474149549,
         0.0359576770593365,
         -0.00550676822790809,
         0.0170482248671914,
         -0.0622099225948368,
         -0.0335569065064008,
         0.0915078612411686,
         -0.0921562405623516,
         0.0384298960028022,
         -0.0445070159966079,
         0.0485425898104228,
         -0.0802132397295545,
         0.0776853670863906,
         0.00989119247546947,
         0.0305190803379703,
         -0.0257852459707287,
         0.0199819425063614,
         0.0278328457897937,
         -0.0539483380699816,
         0.0573604639905006,
         -0.0187608726821018,
         -0.033556906506401,
         0.00398134187885131,
         0.0371892935508925,
         -0.0549765708713124,
         -0.0629749198212267,
         0.0365213354098481,
         -0.019244129435359,
         0.0969777322987685,
         0.0258162365018422,
         -0.0224500431799356,
         -0.0469682212981061,
         -0.0244766458300515,
         -0.0469682212981059,
         -0.0224500431799354,
         -0.0253362369308091,
         0.083542477607229,
         0.0261710766432383,
         0.0397276468794253,
         -0.0190669298376571,
         0.049000660270051,
         0.0279050519378795,
         -0.0396468503187746,
         -0.0600239254884553,
         -0.0379935040075412,
         0.0122686938308417,
         0.0159477752572088,
         -0.0426171208654745,
         0.0278328457897935,
         -0.0141488474149547,
         0.0559134807654693,
         0.0392980245771123,
         0.0232759061380361,
         -0.0476930233008436,
         0.0170482248671915,
         -0.0187608726821019,
         -0.106612789979404,
         0.0384298960028019,
         -0.0610080268534725,
         0.017572656620726,
         -0.0849383872259791,
         0.0674642166775115,
         -0.0348063144745664,
         0.0776853670863908,
         -0.00515244337094676,
         0.0199819425063617,
         0.0386214158213144,
         -0.0141488474149547,
         0.0359576770593363,
         -0.00550676822790816,
         0.0170482248671915,
         -0.0622099225948369,
         -0.0335569065064009,
         0.0106803172324934,
         -0.0504902388971463,
         0.0279050519378791,
         -0.00407827051885565,
         -0.0426171208654745,
         0.056810828132637,
         0.0213852950881723,
         -0.0615368504907908,
         0.0365213354098481,
         0.0258162365018422,
         0.0457640954866651,
         -0.0186977906364359,
         0.0363186501880723,
         -0.0469682212981059,
         -0.0727664789407178,
         -0.00741362559420943,
         0.0490006602700509,
         -0.0190669298376571,
         0.0397276468794252,
         0.0261710766432384,
         0.0835424776072289,
         -0.025336236930809,
         -0.00407827051885566,
         -0.0293792292305793,
         -0.0379935040075408,
         -0.0258500538711417,
         -0.0379935040075409,
         -0.0293792292305792,
         -0.0040782705188556,
         -0.0539483380699817,
         0.0359576770593362,
         0.0392980245771123,
         0.0586488400703273,
         0.00324501648718405,
         0.0232759061380361,
         -0.00550676822790797,
         0.0573604639905005,
         0.0880575594528749,
         -0.0445070159966078,
         0.0175726566207259,
         -0.114909892455845,
         0.0189796728228333,
         -0.0443061527101637,
         0.0674642166775115,
         -0.0802132397295547,
         0.0176596918256812,
         0.0278328457897935,
         -0.0141488474149546,
         0.0559134807654693,
         0.0392980245771123,
         0.0232759061380361,
         -0.0476930233008435,
         0.0170482248671915,
         -0.018760872682102,
         -0.0504902388971463,
         0.00751685397617298,
         -0.0396468503187748,
         -0.0293792292305795,
         0.0159477752572086,
         0.00930091607518004,
         0.0568108281326372,
         0.0229798420322708,
         0.0286114422570136,
         -0.025336236930809,
         0.049000660270051,
         -0.0222991030852921,
         -0.0592591805099301,
         0.0733623716156124,
         -0.0186977906364358,
         -0.0224500431799355,
         -0.00741362559420912,
         -0.0410753069671809,
         -0.0222991030852921,
         -0.00854059103935358,
         -0.019066929837657,
         0.083542477607229,
         0.00755861592861559,
         0.0286114422570136,
         -0.0426171208654745,
         0.0159477752572086,
         0.0122686938308418,
         -0.0379935040075409,
         -0.0600239254884553,
         -0.039646850318775,
         0.0279050519378793,
         0.0573604639905005,
         -0.00550676822790804,
         0.0232759061380361,
         0.00324501648718413,
         0.0586488400703273,
         0.0392980245771121,
         0.0359576770593363,
         -0.0539483380699816,
         -0.053937634596492,
         0.0485425898104226,
         -0.0849383872259792,
         0.0189796728228332,
         -0.0808735293803445,
         0.0189796728228332,
         -0.084938387225979,
         0.0485425898104226,
         -0.053937634596492,
         -0.0539483380699816,
         0.0359576770593362,
         0.0392980245771121,
         0.0586488400703273,
         0.00324501648718414,
         0.0232759061380361,
         -0.00550676822790812,
         0.0573604639905006,
         0.0279050519378793,
         -0.039646850318775,
         -0.0600239254884554,
         -0.037993504007541,
         0.0122686938308417,
         0.0159477752572087,
         -0.0426171208654746,
         0.0286114422570136,
         0.00755861592861558,
         0.083542477607229,
         -0.0190669298376569,
         -0.00854059103935354,
         -0.022299103085292,
         -0.0410753069671809,
         -0.00741362559420908,
         -0.0224500431799354,
         -0.0186977906364357,
         0.0733623716156123,
         -0.0592591805099301,
         -0.022299103085292,
         0.049000660270051,
         -0.0253362369308089,
         0.0286114422570136,
         0.0229798420322708,
         0.0568108281326371,
         0.00930091607517988,
         0.0159477752572087,
         -0.0293792292305795,
         -0.039646850318775,
         0.00751685397617288,
         -0.0504902388971462,
         -0.0187608726821021,
         0.0170482248671916,
         -0.0476930233008435,
         0.023275906138036,
         0.0392980245771124,
         0.0559134807654693,
         -0.0141488474149547,
         0.0278328457897934,
         0.0176596918256813,
         -0.0802132397295546,
         0.0674642166775115,
         -0.0443061527101635,
         0.0189796728228334,
         -0.114909892455845,
         0.017572656620726,
         -0.0445070159966079,
         0.0880575594528749,
         0.0573604639905005,
         -0.00550676822790813,
         0.023275906138036,
         0.00324501648718418,
         0.0586488400703273,
         0.0392980245771124,
         0.0359576770593362,
         -0.0539483380699817,
         -0.00407827051885569,
         -0.0293792292305793,
         -0.0379935040075411,
         -0.0258500538711417,
         -0.037993504007541,
         -0.0293792292305792,
         -0.00407827051885553,
         -0.025336236930809,
         0.083542477607229,
         0.0261710766432382,
         0.0397276468794253,
         -0.0190669298376569,
         0.0490006602700511,
         -0.0074136255942094,
         -0.0727664789407181,
         -0.0469682212981058,
         0.0363186501880722,
         -0.0186977906364358,
         0.0457640954866649,
         0.0258162365018422,
         0.0365213354098482,
         -0.0615368504907911,
         0.0213852950881721,
         0.0568108281326368,
         -0.0426171208654745,
         -0.00407827051885573,
         0.0279050519378793,
         -0.0504902388971461,
         0.0106803172324936,
         -0.0335569065064009,
         -0.0622099225948368,
         0.0170482248671915,
         -0.00550676822790817,
         0.0359576770593362,
         -0.0141488474149547,
         0.0386214158213143,
         0.0199819425063615,
         -0.00515244337094675,
         0.0776853670863906,
         -0.0348063144745662,
         0.0674642166775117,
         -0.084938387225979,
         0.017572656620726,
         -0.0610080268534724,
         0.0384298960028018,
         -0.106612789979404,
         -0.0187608726821019,
         0.0170482248671914,
         -0.0476930233008436,
         0.0232759061380361,
         0.0392980245771125,
         0.0559134807654692,
         -0.0141488474149547,
         0.0278328457897934,
         -0.0426171208654746,
         0.0159477752572087,
         0.0122686938308418,
         -0.0379935040075411,
         -0.0600239254884554,
         -0.039646850318775,
         0.0279050519378793,
         0.0490006602700509,
         -0.0190669298376571,
         0.0397276468794253,
         0.0261710766432381,
         0.0835424776072289,
         -0.0253362369308089,
         -0.0224500431799356,
         -0.046968221298106,
         -0.0244766458300513,
         -0.0469682212981061,
         -0.0224500431799356,
         0.0258162365018422,
         0.0969777322987686,
         -0.019244129435359,
         0.0365213354098481,
         -0.0629749198212266,
         -0.0549765708713122,
         0.0371892935508926,
         0.00398134187885103,
         -0.0335569065064008,
         -0.0187608726821019,
         0.0573604639905005,
         -0.0539483380699817,
         0.0278328457897934,
         0.0199819425063617,
         -0.0257852459707287,
         0.0305190803379699,
         0.00989119247546958,
         0.0776853670863906,
         -0.0802132397295543,
         0.0485425898104227,
         -0.0445070159966079,
         0.038429896002802,
         -0.0921562405623513,
         0.0915078612411684,
         -0.0335569065064009,
         -0.0622099225948368,
         0.0170482248671914,
         -0.00550676822790796,
         0.0359576770593362,
         -0.0141488474149549,
         0.0386214158213143,
         0.0199819425063616,
         0.0568108281326371,
         0.00930091607517997,
         0.0159477752572088,
         -0.0293792292305795,
         -0.0396468503187751,
         0.00751685397617282,
         -0.0504902388971462,
         -0.0222991030852923,
         -0.00854059103935366,
         -0.0190669298376569,
         0.083542477607229,
         0.0075586159286156,
         0.0286114422570135,
         -0.0186977906364358,
         0.0363186501880724,
         -0.046968221298106,
         -0.072766478940718,
         -0.00741362559420949,
         0.0365213354098481,
         -0.019244129435359,
         0.0969777322987685,
         0.0258162365018422,
         -0.0549765708713123,
         -0.0361752215889488,
         -0.0549765708713123,
         0.104533301095687,
         0.00436908772356768,
         -0.0345004222168214,
         0.03051908033797,
         -0.00515244337094673,
         0.0176596918256814,
         -0.0539376345964919,
         0.0880575594528748,
         -0.106612789979404,
         0.0915078612411684,
         -0.06572261527044,
         0.00398134187885104,
         -0.0335569065064009,
         -0.0187608726821022,
         0.0573604639905003,
         -0.0539483380699816,
         0.0278328457897935,
         0.0199819425063615,
         -0.0257852459707287,
         0.0213852950881721,
         0.0568108281326371,
         -0.0426171208654745,
         -0.00407827051885558,
         0.0279050519378792,
         -0.0504902388971463,
         0.0106803172324936,
         -0.0592591805099302,
         -0.0222991030852921,
         0.049000660270051,
         -0.025336236930809,
         0.0286114422570137,
         0.0229798420322707,
         0.0733623716156122,
         -0.0186977906364358,
         -0.0224500431799354,
         -0.00741362559420933,
         -0.0410753069671809,
         -0.061536850490791,
         0.0365213354098481,
         0.025816236501842,
         0.045764095486665,
         0.0371892935508926,
         -0.0549765708713123,
         -0.0629749198212265,
         0.00436908772356764,
         0.104533301095687,
         -0.108902388819254},
        {-0.114963543030859,
         0.0460737915019357,
         0.0688897515289231,
         -0.0517830294232834,
         0.00755261185779254,
         -0.0745989894502705,
         0.0795034320260945,
         -0.0415806039042166,
         0.0330167470221954,
         0.0525878247688073,
         -0.0902959382658352,
         0.0170644506895801,
         0.0303490590434837,
         -0.0615680614245308,
         -0.0136487637242733,
         0.0889346110049661,
         0.00215244739261245,
         -0.0229685863705,
         -0.00902213076961318,
         0.0691165175936292,
         -0.0300643601827202,
         -0.0873598507469329,
         -0.00236214038705,
         0.000382651836579758,
         0.0225652359190203,
         -0.0128481176589843,
         -0.0548201793990119,
         0.0666111464487283,
         0.0762209599285968,
         0.014735367493209,
         -0.0143461958404543,
         0.0147847510054522,
         -0.0336641818882075,
         0.0426861535613558,
         0.0107012049228233,
         -0.0747004970071657,
         -0.0184281148515957,
         -0.0577928450770009,
         0.0466539542586647,
         -0.0370898236983619,
         0.0277391261352232,
         -0.0064480280686387,
         -0.0220094076389322,
         0.0139200570804949,
         0.0607804399266709,
         0.0688897515289231,
         0.0460737915019357,
         0.00755261185779244,
         -0.124954709393217,
         0.0075526118577924,
         -0.0415806039042165,
         0.104162768917251,
         0.0150827025546195,
         0.0330167470221953,
         0.0170644506895802,
         -0.0441137917691219,
         -0.0366571579234809,
         -0.00476529269076586,
         -0.0615680614245307,
         0.00215244739261244,
         0.0599113545143099,
         -0.0317812111749624,
         0.0501885423415362,
         0.00171360656812323,
         0.0691165175936291,
         -0.00236214038705003,
         -0.0887947185765643,
         0.0328951257721692,
         0.0141382218316392,
         -0.0578951407413725,
         0.00301181951375335,
         -0.054820179399012,
         0.0147353674932092,
         0.0714100023954194,
         0.0214980255625943,
         -0.0558111356546625,
         0.028126932450224,
         0.0363664651083455,
         0.00146275917252455,
         0.0107012049228234,
         -0.0577928450770012,
         -0.0379211737836839,
         -0.0446277194300716,
         0.0352323735511963,
         0.0021118751233917,
         -0.00435345710693359,
         -0.056176186180367,
         0.0466240764494054,
         0.0139200570804948,
         0.0762209599285968,
         0.0147353674932091,
         -0.0143461958404542,
         0.0147847510054524,
         -0.0336641818882073,
         0.0426861535613561,
         0.0107012049228234,
         -0.0747004970071658,
         -0.0745989894502707,
         0.00755261185779242,
         -0.0517830294232832,
         0.0330167470221953,
         0.0150827025546196,
         0.104162768917251,
         -0.0415806039042166,
         0.0303490590434837,
         -0.0366571579234809,
         -0.0776801613421762,
         -0.0366571579234809,
         0.0303490590434836,
         -0.0229685863704998,
         -0.0317812111749623,
         0.123664914734429,
         -0.0136561788469353,
         0.0501885423415363,
         -0.00902213076961322,
         0.000382651836579677,
         0.0328951257721692,
         -0.0612427371092468,
         -0.0377703588899326,
         0.00749754032001144,
         -0.0578951407413725,
         -0.0128481176589844,
         -0.0143461958404543,
         0.0214980255625944,
         0.0251010534385,
         0.0090859055778415,
         0.0168555682592872,
         0.024950413582123,
         0.0363664651083455,
         0.0426861535613558,
         0.0466539542586647,
         -0.0446277194300717,
         -0.0511587526728624,
         0.00709822279518424,
         0.0309770765731804,
         -0.0705003527100428,
         0.0134777315481897,
         -0.0561761861803671,
         -0.0220094076389321,
         0.0147353674932092,
         0.0714100023954193,
         0.0214980255625942,
         -0.0558111356546626,
         0.0281269324502241,
         0.0363664651083457,
         0.0014627591725243,
         0.0107012049228234,
         -0.0873598507469329,
         -0.00236214038704989,
         0.00038265183657995,
         0.0225652359190202,
         -0.0128481176589843,
         -0.0548201793990118,
         0.0666111464487283,
         0.0525878247688072,
         0.0330167470221954,
         -0.0415806039042166,
         0.0795034320260945,
         -0.0615680614245307,
         -0.00476529269076602,
         -0.036657157923481,
         -0.0441137917691218,
         0.0170644506895801,
         -0.00902213076961319,
         0.0501885423415363,
         -0.0136561788469351,
         0.123664914734429,
         -0.0317812111749624,
         -0.0229685863704999,
         0.0225652359190202,
         0.0141382218316391,
         -0.0377703588899325,
         -0.0701952818427683,
         -0.0377703588899325,
         0.0141382218316392,
         0.0225652359190204,
         0.0147847510054525,
         -0.0558111356546626,
         0.00908590557784149,
         0.0914788057435696,
         0.0145485847394515,
         0.0168555682592873,
         0.028126932450224,
         -0.0336641818882075,
         -0.0370898236983618,
         0.0352323735511965,
         0.00709822279518436,
         -0.0417766616440867,
         -0.0583217909688448,
         0.0277826101426575,
         -0.0705003527100429,
         -0.00435345710693357,
         -0.00644802806863839,
         -0.0143461958404543,
         0.0214980255625945,
         0.0251010534384997,
         0.00908590557784145,
         0.016855568259287,
         0.0249504135821231,
         0.0363664651083457,
         0.0426861535613559,
         -0.0023621403870499,
         -0.0887947185765642,
         0.0328951257721692,
         0.0141382218316393,
         -0.0578951407413725,
         0.00301181951375344,
         -0.0548201793990119,
         0.0889346110049662,
         0.00215244739261234,
         -0.0229685863704999,
         -0.00902213076961332,
         0.0691165175936293,
         -0.0300643601827203,
         -0.0136487637242735,
         -0.0615680614245308,
         0.0303490590434837,
         0.0170644506895801,
         -0.0902959382658353,
         0.0691165175936293,
         0.00171360656812311,
         0.0501885423415363,
         -0.0317812111749624,
         0.05991135451431,
         0.00215244739261247,
         -0.0128481176589841,
         -0.0578951407413725,
         0.00749754032001151,
         -0.0377703588899328,
         -0.0612427371092468,
         0.0328951257721691,
         0.00038265183657992,
         -0.0336641818882075,
         0.028126932450224,
         0.0168555682592872,
         0.0145485847394515,
         0.0914788057435696,
         0.00908590557784147,
         -0.0558111356546626,
         0.0147847510054525,
         0.0277391261352231,
         0.00211187512339172,
         0.0309770765731804,
         -0.058321790968845,
         -0.0477055995141761,
         -0.0583217909688451,
         0.0309770765731805,
         0.00211187512339183,
         0.0277391261352232,
         0.0147847510054525,
         -0.0558111356546625,
         0.0090859055778412,
         0.0914788057435696,
         0.0145485847394514,
         0.016855568259287,
         0.0281269324502239,
         -0.0336641818882077,
         0.000382651836579783,
         0.0328951257721692,
         -0.0612427371092468,
         -0.0377703588899325,
         0.00749754032001153,
         -0.0578951407413724,
         -0.0128481176589842,
         0.00215244739261248,
         0.0599113545143101,
         -0.0317812111749625,
         0.0501885423415363,
         0.00171360656812337,
         0.0691165175936293,
         -0.090295938265835,
         0.0170644506895802,
         0.0303490590434836,
         -0.0615680614245309,
         -0.0136487637242736,
         -0.0300643601827204,
         0.0691165175936292,
         -0.00902213076961345,
         -0.0229685863705,
         0.00215244739261239,
         0.088934611004966,
         -0.0548201793990119,
         0.00301181951375337,
         -0.0578951407413723,
         0.0141382218316391,
         0.0328951257721691,
         -0.0887947185765643,
         -0.00236214038705011,
         0.042686153561356,
         0.0363664651083458,
         0.0249504135821231,
         0.016855568259287,
         0.00908590557784139,
         0.0251010534384996,
         0.0214980255625943,
         -0.0143461958404544,
         -0.00644802806863837,
         -0.00435345710693364,
         -0.0705003527100429,
         0.0277826101426574,
         -0.0583217909688449,
         -0.0417766616440866,
         0.00709822279518445,
         0.0352323735511965,
         -0.0370898236983618,
         -0.0336641818882077,
         0.028126932450224,
         0.0168555682592871,
         0.0145485847394514,
         0.0914788057435695,
         0.00908590557784138,
         -0.0558111356546626,
         0.0147847510054523,
         0.0225652359190202,
         0.0141382218316391,
         -0.0377703588899325,
         -0.0701952818427683,
         -0.0377703588899325,
         0.0141382218316392,
         0.0225652359190202,
         -0.0229685863704999,
         -0.0317812111749623,
         0.123664914734429,
         -0.013656178846935,
         0.0501885423415363,
         -0.00902213076961325,
         0.0170644506895801,
         -0.0441137917691218,
         -0.036657157923481,
         -0.0047652926907659,
         -0.0615680614245307,
         0.0795034320260946,
         -0.0415806039042166,
         0.0330167470221952,
         0.0525878247688073,
         0.0666111464487282,
         -0.0548201793990117,
         -0.0128481176589844,
         0.0225652359190204,
         0.000382651836579675,
         -0.00236214038705002,
         -0.0873598507469329,
         0.0107012049228233,
         0.00146275917252432,
         0.0363664651083456,
         0.028126932450224,
         -0.0558111356546626,
         0.0214980255625943,
         0.0714100023954193,
         0.0147353674932093,
         -0.0220094076389322,
         -0.056176186180367,
         0.0134777315481899,
         -0.0705003527100429,
         0.0309770765731803,
         0.0070982227951845,
         -0.0511587526728623,
         -0.0446277194300715,
         0.0466539542586645,
         0.0426861535613558,
         0.0363664651083456,
         0.0249504135821232,
         0.0168555682592872,
         0.00908590557784152,
         0.0251010534384998,
         0.0214980255625944,
         -0.0143461958404544,
         -0.0128481176589843,
         -0.0578951407413725,
         0.00749754032001168,
         -0.0377703588899326,
         -0.0612427371092466,
         0.0328951257721691,
         0.000382651836579675,
         -0.00902213076961336,
         0.0501885423415363,
         -0.0136561788469351,
         0.123664914734429,
         -0.0317812111749624,
         -0.0229685863704999,
         0.0303490590434837,
         -0.036657157923481,
         -0.0776801613421763,
         -0.036657157923481,
         0.0303490590434837,
         -0.0415806039042166,
         0.10416276891725,
         0.0150827025546197,
         0.0330167470221954,
         -0.0517830294232834,
         0.00755261185779244,
         -0.0745989894502706,
         -0.0747004970071657,
         0.0107012049228235,
         0.0426861535613559,
         -0.0336641818882074,
         0.0147847510054524,
         -0.0143461958404543,
         0.0147353674932094,
         0.0762209599285967,
         0.0139200570804948,
         0.0466240764494053,
         -0.056176186180367,
         -0.00435345710693353,
         0.00211187512339197,
         0.0352323735511964,
         -0.0446277194300715,
         -0.037921173783684,
         -0.057792845077001,
         0.0107012049228233,
         0.00146275917252421,
         0.0363664651083457,
         0.0281269324502241,
         -0.0558111356546625,
         0.0214980255625943,
         0.0714100023954195,
         0.0147353674932091,
         -0.0548201793990117,
         0.00301181951375349,
         -0.0578951407413724,
         0.0141382218316391,
         0.0328951257721693,
         -0.0887947185765642,
         -0.00236214038705001,
         0.0691165175936293,
         0.00171360656812335,
         0.0501885423415364,
         -0.0317812111749624,
         0.0599113545143099,
         0.00215244739261248,
         -0.0615680614245307,
         -0.0047652926907659,
         -0.036657157923481,
         -0.0441137917691219,
         0.01706445068958,
         0.0330167470221952,
         0.0150827025546197,
         0.10416276891725,
         -0.0415806039042166,
         0.00755261185779256,
         -0.124954709393217,
         0.0075526118577926,
         0.0460737915019356,
         0.0688897515289231,
         0.0607804399266707,
         0.0139200570804949,
         -0.0220094076389322,
         -0.00644802806863847,
         0.0277391261352231,
         -0.0370898236983618,
         0.0466539542586648,
         -0.057792845077001,
         -0.0184281148515959,
         -0.0747004970071656,
         0.0107012049228234,
         0.0426861535613558,
         -0.0336641818882075,
         0.0147847510054524,
         -0.0143461958404542,
         0.0147353674932092,
         0.0762209599285969,
         0.0666111464487281,
         -0.0548201793990119,
         -0.0128481176589843,
         0.0225652359190201,
         0.000382651836579964,
         -0.00236214038704988,
         -0.0873598507469329,
         -0.0300643601827203,
         0.0691165175936292,
         -0.00902213076961333,
         -0.0229685863704999,
         0.00215244739261234,
         0.0889346110049663,
         -0.0136487637242735,
         -0.0615680614245308,
         0.0303490590434837,
         0.0170644506895801,
         -0.0902959382658351,
         0.0525878247688071,
         0.0330167470221954,
         -0.0415806039042165,
         0.0795034320260944,
         -0.0745989894502708,
         0.00755261185779257,
         -0.0517830294232834,
         0.0688897515289231,
         0.0460737915019358,
         -0.114963543030859},
        {-0.0139666929749375,
         -0.0554516972723542,
         0.0694183902472916,
         0.0695604834092142,
         -0.0186641697095632,
         -0.0553096041104321,
         -0.0612731089312931,
         -0.012431061716881,
         0.0335942409221706,
         0.0329134434956514,
         0.032373031852344,
         0.0456950340619523,
         -0.0369553377966757,
         -0.00281989471736842,
         -0.0311299854818995,
         0.0131817606754906,
         -0.0720284513621886,
         0.0314744537387834,
         0.00747989264068443,
         -0.00343823245785865,
         0.0333045146202898,
         -0.0552935444093029,
         0.0631676756007182,
         0.00617277391920832,
         -0.0379811287607774,
         0.0289360132770276,
         -0.0209478119285624,
         -0.0193393066679147,
         0.0686053340159693,
         -0.017609842402227,
         -0.0431999911907184,
         0.0400929141240763,
         -0.00831562192729002,
         -0.0163207140008256,
         0.0328677504463743,
         -0.00550637728501049,
         -0.120050829852267,
         0.0514454958362975,
         -0.0381337062296309,
         0.0669337003567764,
         -0.0922906856898995,
         0.0975499467801146,
         -0.0866694707795643,
         0.0618237868266387,
         -0.0563174095416282,
         0.0694183902472915,
         -0.0554516972723541,
         -0.0186641697095631,
         0.0107236827645668,
         -0.0186641697095631,
         -0.012431061716881,
         -0.0262235150943877,
         0.0296086184666804,
         0.0335942409221706,
         0.0456950340619524,
         0.00766950880924235,
         0.030435265004857,
         -0.0788461598445271,
         -0.0028198947173685,
         -0.0720284513621884,
         0.00926375676987006,
         -0.0547813224063414,
         0.0473366280687375,
         0.0410249533622561,
         -0.0034382324578587,
         0.0631676756007183,
         0.0059537072430187,
         0.0362600429718397,
         -0.0014598264280355,
         -0.0506824145980261,
         0.00355352611853022,
         -0.0209478119285626,
         -0.0176098424022272,
         -0.0161623371801081,
         -0.036174776136332,
         -0.00224366343880702,
         0.027649951386774,
         0.00354977148942182,
         0.00728107764313908,
         0.0328677504463743,
         0.0514454958362974,
         -0.0967551980406005,
         0.126229324827375,
         -0.0655261769035067,
         0.0420463750826293,
         -0.0599207230533385,
         0.067670594863183,
         -0.0997973564592477,
         0.061823786826639,
         0.0686053340159695,
         -0.0176098424022271,
         -0.0431999911907182,
         0.0400929141240763,
         -0.00831562192728988,
         -0.0163207140008255,
         0.0328677504463744,
         -0.00550637728501051,
         -0.0553096041104321,
         -0.0186641697095631,
         0.069560483409214,
         0.0335942409221705,
         0.0296086184666804,
         -0.0262235150943878,
         -0.0124310617168811,
         -0.0369553377966756,
         0.0304352650048572,
         -0.0378954500676634,
         0.030435265004857,
         -0.0369553377966755,
         0.0314744537387834,
         -0.0547813224063411,
         0.0232963482926174,
         -0.0122422789880197,
         0.0473366280687373,
         0.00747989264068452,
         0.00617277391920833,
         0.0362600429718396,
         0.0128734062917232,
         0.0101863162275323,
         -0.0370259735817242,
         -0.0506824145980261,
         0.0289360132770274,
         -0.0431999911907183,
         -0.036174776136332,
         -0.00827440738286951,
         -0.0368261225802032,
         0.0278611847706862,
         0.0529984832682702,
         0.00354977148942172,
         -0.0163207140008256,
         -0.0381337062296311,
         0.126229324827375,
         -0.0690486470514804,
         0.109226208231073,
         -0.0724126972950273,
         0.0228476475782535,
         -0.07897673503723,
         0.0676705948631832,
         -0.0866694707795644,
         -0.0176098424022272,
         -0.0161623371801081,
         -0.0361747761363319,
         -0.00224366343880709,
         0.0276499513867741,
         0.00354977148942172,
         0.00728107764313906,
         0.0328677504463745,
         -0.0552935444093026,
         0.0631676756007183,
         0.00617277391920838,
         -0.0379811287607777,
         0.0289360132770276,
         -0.0209478119285625,
         -0.0193393066679148,
         0.0329134434956516,
         0.0335942409221706,
         -0.012431061716881,
         -0.061273108931293,
         -0.00281989471736854,
         -0.0788461598445273,
         0.030435265004857,
         0.00766950880924216,
         0.0456950340619524,
         0.0074798926406845,
         0.0473366280687374,
         -0.01224227898802,
         0.0232963482926174,
         -0.0547813224063412,
         0.0314744537387833,
         -0.0379811287607775,
         -0.00145982642803549,
         0.0101863162275323,
         -0.0217913893865091,
         0.0101863162275323,
         -0.00145982642803539,
         -0.0379811287607776,
         0.0400929141240763,
         -0.00224366343880699,
         -0.0368261225802032,
         0.0152074152083643,
         -0.00307961389557629,
         0.0278611847706863,
         0.0276499513867741,
         -0.00831562192728992,
         0.0669337003567766,
         -0.0655261769035068,
         0.109226208231073,
         -0.0621336592662033,
         0.0818625714816388,
         -0.105214398241912,
         0.0228476475782534,
         -0.0599207230533386,
         0.0975499467801145,
         -0.0431999911907183,
         -0.0361747761363321,
         -0.00827440738286968,
         -0.0368261225802032,
         0.0278611847706863,
         0.0529984832682703,
         0.00354977148942189,
         -0.0163207140008257,
         0.0631676756007182,
         0.00595370724301876,
         0.0362600429718397,
         -0.00145982642803532,
         -0.0506824145980263,
         0.00355352611853003,
         -0.0209478119285626,
         0.0131817606754905,
         -0.0720284513621886,
         0.0314744537387834,
         0.00747989264068444,
         -0.00343823245785859,
         0.0333045146202898,
         -0.0311299854818994,
         -0.00281989471736864,
         -0.0369553377966755,
         0.0456950340619524,
         0.0323730318523441,
         -0.00343823245785872,
         0.041024953362256,
         0.0473366280687373,
         -0.0547813224063414,
         0.00926375676986995,
         -0.0720284513621884,
         0.0289360132770275,
         -0.0506824145980261,
         -0.0370259735817242,
         0.0101863162275323,
         0.0128734062917231,
         0.0362600429718397,
         0.00617277391920832,
         -0.00831562192728989,
         0.0276499513867741,
         0.0278611847706861,
         -0.00307961389557611,
         0.0152074152083645,
         -0.0368261225802032,
         -0.00224366343880711,
         0.0400929141240763,
         -0.0922906856898997,
         0.0420463750826294,
         -0.0724126972950273,
         0.0818625714816388,
         -0.0939903727944269,
         0.0818625714816388,
         -0.0724126972950273,
         0.0420463750826294,
         -0.0922906856898998,
         0.0400929141240762,
         -0.00224366343880691,
         -0.0368261225802032,
         0.0152074152083644,
         -0.00307961389557612,
         0.0278611847706863,
         0.0276499513867741,
         -0.00831562192728988,
         0.00617277391920827,
         0.0362600429718397,
         0.0128734062917231,
         0.0101863162275324,
         -0.0370259735817242,
         -0.0506824145980263,
         0.0289360132770274,
         -0.0720284513621884,
         0.00926375676986996,
         -0.0547813224063412,
         0.0473366280687373,
         0.041024953362256,
         -0.00343823245785871,
         0.0323730318523441,
         0.0456950340619524,
         -0.0369553377966755,
         -0.00281989471736857,
         -0.0311299854818993,
         0.0333045146202899,
         -0.0034382324578586,
         0.0074798926406843,
         0.0314744537387835,
         -0.0720284513621885,
         0.0131817606754906,
         -0.0209478119285626,
         0.00355352611853006,
         -0.0506824145980261,
         -0.00145982642803525,
         0.0362600429718396,
         0.00595370724301866,
         0.0631676756007183,
         -0.0163207140008256,
         0.00354977148942187,
         0.0529984832682703,
         0.0278611847706863,
         -0.0368261225802032,
         -0.00827440738286966,
         -0.0361747761363319,
         -0.0431999911907182,
         0.0975499467801145,
         -0.0599207230533385,
         0.0228476475782536,
         -0.105214398241912,
         0.0818625714816388,
         -0.0621336592662034,
         0.109226208231073,
         -0.0655261769035068,
         0.0669337003567766,
         -0.00831562192728992,
         0.0276499513867741,
         0.0278611847706863,
         -0.00307961389557622,
         0.0152074152083643,
         -0.0368261225802031,
         -0.00224366343880693,
         0.0400929141240762,
         -0.0379811287607775,
         -0.00145982642803544,
         0.0101863162275323,
         -0.0217913893865094,
         0.0101863162275322,
         -0.00145982642803535,
         -0.0379811287607775,
         0.0314744537387834,
         -0.0547813224063413,
         0.0232963482926174,
         -0.01224227898802,
         0.0473366280687372,
         0.00747989264068448,
         0.0456950340619522,
         0.00766950880924222,
         0.0304352650048571,
         -0.078846159844527,
         -0.00281989471736849,
         -0.0612731089312931,
         -0.0124310617168811,
         0.0335942409221706,
         0.0329134434956515,
         -0.019339306667915,
         -0.0209478119285624,
         0.0289360132770278,
         -0.0379811287607777,
         0.00617277391920827,
         0.0631676756007184,
         -0.0552935444093027,
         0.0328677504463744,
         0.00728107764313918,
         0.00354977148942183,
         0.0276499513867741,
         -0.00224366343880703,
         -0.0361747761363317,
         -0.016162337180108,
         -0.0176098424022271,
         -0.0866694707795643,
         0.0676705948631832,
         -0.0789767350372299,
         0.0228476475782535,
         -0.0724126972950272,
         0.109226208231073,
         -0.0690486470514803,
         0.126229324827375,
         -0.0381337062296311,
         -0.0163207140008255,
         0.00354977148942177,
         0.0529984832682702,
         0.0278611847706862,
         -0.0368261225802033,
         -0.00827440738286955,
         -0.036174776136332,
         -0.0431999911907183,
         0.0289360132770274,
         -0.0506824145980262,
         -0.0370259735817241,
         0.0101863162275323,
         0.0128734062917231,
         0.0362600429718397,
         0.00617277391920835,
         0.00747989264068448,
         0.0473366280687372,
         -0.0122422789880199,
         0.0232963482926172,
         -0.0547813224063412,
         0.0314744537387834,
         -0.0369553377966756,
         0.030435265004857,
         -0.0378954500676635,
         0.0304352650048571,
         -0.0369553377966756,
         -0.0124310617168811,
         -0.0262235150943876,
         0.0296086184666803,
         0.0335942409221706,
         0.0695604834092141,
         -0.0186641697095631,
         -0.0553096041104321,
         -0.00550637728501052,
         0.0328677504463742,
         -0.0163207140008259,
         -0.00831562192728999,
         0.0400929141240762,
         -0.0431999911907183,
         -0.0176098424022271,
         0.0686053340159694,
         0.0618237868266389,
         -0.0997973564592475,
         0.0676705948631831,
         -0.0599207230533386,
         0.0420463750826293,
         -0.0655261769035066,
         0.126229324827375,
         -0.0967551980406004,
         0.0514454958362976,
         0.0328677504463744,
         0.00728107764313907,
         0.00354977148942186,
         0.0276499513867743,
         -0.00224366343880707,
         -0.036174776136332,
         -0.0161623371801079,
         -0.0176098424022271,
         -0.0209478119285625,
         0.00355352611853001,
         -0.0506824145980262,
         -0.00145982642803522,
         0.0362600429718397,
         0.00595370724301856,
         0.0631676756007184,
         -0.00343823245785868,
         0.0410249533622561,
         0.0473366280687372,
         -0.0547813224063413,
         0.00926375676986973,
         -0.0720284513621885,
         -0.00281989471736848,
         -0.078846159844527,
         0.0304352650048571,
         0.00766950880924239,
         0.0456950340619522,
         0.0335942409221706,
         0.0296086184666803,
         -0.0262235150943876,
         -0.0124310617168811,
         -0.0186641697095631,
         0.0107236827645669,
         -0.0186641697095631,
         -0.0554516972723542,
         0.0694183902472915,
         -0.0563174095416284,
         0.0618237868266388,
         -0.0866694707795644,
         0.0975499467801146,
         -0.0922906856898995,
         0.0669337003567765,
         -0.0381337062296311,
         0.0514454958362975,
         -0.120050829852267,
         -0.00550637728501062,
         0.0328677504463743,
         -0.0163207140008255,
         -0.00831562192728989,
         0.0400929141240764,
         -0.0431999911907184,
         -0.0176098424022272,
         0.0686053340159694,
         -0.019339306667915,
         -0.0209478119285625,
         0.0289360132770276,
         -0.0379811287607775,
         0.00617277391920819,
         0.0631676756007185,
         -0.0552935444093027,
         0.0333045146202896,
         -0.00343823245785874,
         0.00747989264068439,
         0.0314744537387835,
         -0.0720284513621887,
         0.0131817606754906,
         -0.0311299854818993,
         -0.00281989471736841,
         -0.0369553377966756,
         0.0456950340619524,
         0.0323730318523441,
         0.0329134434956514,
         0.0335942409221705,
         -0.0124310617168813,
         -0.0612731089312931,
         -0.0553096041104322,
         -0.0186641697095631,
         0.069560483409214,
         0.0694183902472916,
         -0.0554516972723543,
         -0.0139666929749372},
        {0.0157380677900343,
         -0.0451675889328081,
         0.0294295211427744,
         0.00614069369210478,
         0.0516277296249359,
         -0.0684564163834778,
         0.0274294482461892,
         -0.0503552129074407,
         -0.00818512995361472,
         0.0739131696858876,
         -0.0507891503026879,
         0.0369349319807277,
         0.0183057147909155,
         -0.00751623843671634,
         -0.0691594831065021,
         0.0514143919043293,
         -0.000988593774539503,
         -0.0429640918248463,
         0.0236681741792709,
         -0.0122859768001256,
         0.0769298171001788,
         -0.0237865794000825,
         -0.0414417187563704,
         0.0506532878526454,
         -0.0104291617053202,
         -0.0125596300167195,
         0.0221636413735618,
         -0.0917055780158868,
         0.0105698773979642,
         0.0174840533250272,
         0.0216166657531931,
         -0.0674579673148395,
         0.0761836300239406,
         -0.0617659970055256,
         0.0349259947781715,
         0.065304007594578,
         -0.0513401975647227,
         0.0407703201667583,
         -0.0539870221688764,
         0.0395759116667477,
         0.00308825294126948,
         -0.0512710112003173,
         0.0924483425373343,
         -0.118849912958644,
         0.0535459053640658,
         0.0294295211427743,
         -0.0451675889328083,
         0.051627729624936,
         -0.0525589988811972,
         0.051627729624936,
         -0.0503552129074409,
         0.00109505899782532,
         0.0124370446426684,
         -0.00818512995361468,
         0.0369349319807275,
         -0.0102958840262748,
         0.0484977179690407,
         -0.0497512583070021,
         -0.00751623843671613,
         -0.000988593774539454,
         -0.00604700083445533,
         -0.00838670065885222,
         -0.0549381925693063,
         0.100469534539158,
         -0.0122859768001257,
         -0.0414417187563703,
         0.0123112902343298,
         -0.00673995125785224,
         0.0445876190263432,
         -0.00233040459364129,
         -0.0907494441763299,
         0.0221636413735619,
         0.0174840533250272,
         0.0628199290309311,
         -0.0538638003077089,
         0.0297485234910346,
         -0.0654520719461624,
         0.0722475108781831,
         0.0122573677182532,
         0.0349259947781714,
         0.0407703201667582,
         -0.0744694260684294,
         -0.00156720496461973,
         0.0346595012235051,
         -0.0168847370688468,
         0.0234631110609855,
         -0.0460020952663371,
         0.00734315712677473,
         -0.118849912958644,
         0.010569877397964,
         0.0174840533250272,
         0.0216166657531931,
         -0.0674579673148395,
         0.0761836300239407,
         -0.0617659970055254,
         0.0349259947781714,
         0.0653040075945778,
         -0.0684564163834778,
         0.0516277296249359,
         0.00614069369210483,
         -0.00818512995361472,
         0.0124370446426683,
         0.00109505899782522,
         -0.0503552129074408,
         0.0183057147909157,
         0.0484977179690408,
         -0.0685233468834497,
         0.0484977179690408,
         0.0183057147909156,
         -0.0429640918248462,
         -0.00838670065885217,
         -0.0346713346512975,
         0.0604237145680034,
         -0.0549381925693063,
         0.0236681741792709,
         0.0506532878526454,
         -0.00673995125785213,
         0.0241268079687432,
         0.0185112818096514,
         -0.0320204687935561,
         -0.00233040459364113,
         -0.0125596300167194,
         0.0216166657531932,
         -0.0538638003077088,
         0.0568203010273067,
         -0.0793816665188167,
         0.0235657061914937,
         0.0116138332920714,
         0.072247510878183,
         -0.0617659970055256,
         -0.0539870221688764,
         -0.00156720496461952,
         -0.000176915373578592,
         -0.00913997889271389,
         0.0595586396371725,
         -0.0271538992566217,
         -0.0481762495778187,
         -0.046002095266337,
         0.0924483425373345,
         0.0174840533250271,
         0.0628199290309311,
         -0.0538638003077089,
         0.0297485234910349,
         -0.0654520719461625,
         0.0722475108781831,
         0.0122573677182531,
         0.0349259947781713,
         -0.0237865794000824,
         -0.0414417187563703,
         0.0506532878526455,
         -0.0104291617053201,
         -0.0125596300167194,
         0.0221636413735618,
         -0.091705578015887,
         0.0739131696858875,
         -0.0081851299536147,
         -0.0503552129074408,
         0.0274294482461891,
         -0.00751623843671624,
         -0.0497512583070024,
         0.0484977179690409,
         -0.0102958840262747,
         0.0369349319807278,
         0.0236681741792707,
         -0.0549381925693062,
         0.0604237145680035,
         -0.0346713346512975,
         -0.00838670065885222,
         -0.0429640918248462,
         -0.0104291617053201,
         0.0445876190263431,
         0.0185112818096514,
         -0.0452649842259534,
         0.0185112818096515,
         0.0445876190263432,
         -0.0104291617053201,
         -0.0674579673148395,
         0.0297485234910349,
         -0.0793816665188169,
         0.0400362112751395,
         -0.0123325709275089,
         0.0235657061914939,
         -0.0654520719461624,
         0.0761836300239407,
         0.0395759116667478,
         0.0346595012235053,
         -0.00913997889271397,
         0.0359953014185372,
         -0.000723451495859457,
         -0.0093003694472674,
         -0.0271538992566216,
         0.0234631110609853,
         -0.0512710112003176,
         0.0216166657531932,
         -0.053863800307709,
         0.0568203010273066,
         -0.0793816665188168,
         0.0235657061914937,
         0.0116138332920715,
         0.0722475108781831,
         -0.0617659970055256,
         -0.0414417187563704,
         0.0123112902343297,
         -0.00673995125785221,
         0.0445876190263432,
         -0.00233040459364124,
         -0.0907494441763299,
         0.0221636413735618,
         0.0514143919043293,
         -0.000988593774539472,
         -0.0429640918248463,
         0.0236681741792708,
         -0.0122859768001257,
         0.0769298171001789,
         -0.0691594831065021,
         -0.00751623843671632,
         0.0183057147909156,
         0.0369349319807277,
         -0.0507891503026876,
         -0.0122859768001258,
         0.100469534539157,
         -0.0549381925693063,
         -0.0083867006588523,
         -0.00604700083445544,
         -0.000988593774539445,
         -0.0125596300167195,
         -0.00233040459364127,
         -0.0320204687935561,
         0.0185112818096514,
         0.0241268079687434,
         -0.00673995125785211,
         0.0506532878526455,
         0.0761836300239407,
         -0.0654520719461625,
         0.0235657061914936,
         -0.0123325709275089,
         0.0400362112751394,
         -0.079381666518817,
         0.0297485234910349,
         -0.0674579673148395,
         0.0030882529412693,
         -0.0168847370688468,
         0.0595586396371724,
         -0.000723451495859504,
         -0.0269801888517713,
         -0.000723451495859424,
         0.0595586396371724,
         -0.0168847370688466,
         0.00308825294126942,
         -0.0674579673148395,
         0.0297485234910348,
         -0.0793816665188169,
         0.0400362112751394,
         -0.0123325709275089,
         0.0235657061914935,
         -0.0654520719461624,
         0.0761836300239407,
         0.0506532878526453,
         -0.0067399512578522,
         0.0241268079687433,
         0.0185112818096515,
         -0.0320204687935561,
         -0.00233040459364113,
         -0.0125596300167195,
         -0.000988593774539382,
         -0.00604700083445546,
         -0.00838670065885213,
         -0.0549381925693064,
         0.100469534539157,
         -0.0122859768001257,
         -0.0507891503026877,
         0.0369349319807276,
         0.0183057147909156,
         -0.00751623843671641,
         -0.0691594831065023,
         0.0769298171001789,
         -0.0122859768001256,
         0.023668174179271,
         -0.0429640918248462,
         -0.000988593774539403,
         0.0514143919043292,
         0.0221636413735618,
         -0.0907494441763298,
         -0.00233040459364132,
         0.0445876190263431,
         -0.0067399512578523,
         0.0123112902343297,
         -0.0414417187563705,
         -0.0617659970055257,
         0.0722475108781831,
         0.0116138332920716,
         0.0235657061914936,
         -0.0793816665188167,
         0.0568203010273067,
         -0.0538638003077088,
         0.021616665753193,
         -0.0512710112003175,
         0.0234631110609853,
         -0.0271538992566216,
         -0.00930036944726753,
         -0.000723451495859376,
         0.0359953014185372,
         -0.00913997889271384,
         0.0346595012235053,
         0.0395759116667476,
         0.0761836300239407,
         -0.0654520719461625,
         0.0235657061914939,
         -0.0123325709275087,
         0.0400362112751394,
         -0.0793816665188169,
         0.0297485234910348,
         -0.0674579673148396,
         -0.0104291617053201,
         0.0445876190263433,
         0.0185112818096514,
         -0.0452649842259533,
         0.0185112818096514,
         0.0445876190263432,
         -0.0104291617053202,
         -0.0429640918248462,
         -0.00838670065885211,
         -0.0346713346512974,
         0.0604237145680034,
         -0.0549381925693062,
         0.0236681741792709,
         0.0369349319807277,
         -0.0102958840262749,
         0.0484977179690408,
         -0.0497512583070024,
         -0.0075162384367162,
         0.0274294482461893,
         -0.0503552129074408,
         -0.00818512995361468,
         0.0739131696858876,
         -0.0917055780158869,
         0.022163641373562,
         -0.0125596300167194,
         -0.0104291617053202,
         0.0506532878526455,
         -0.0414417187563703,
         -0.0237865794000823,
         0.0349259947781714,
         0.012257367718253,
         0.0722475108781832,
         -0.0654520719461625,
         0.0297485234910348,
         -0.0538638003077089,
         0.0628199290309314,
         0.0174840533250271,
         0.0924483425373345,
         -0.046002095266337,
         -0.0481762495778188,
         -0.0271538992566216,
         0.0595586396371725,
         -0.00913997889271398,
         -0.000176915373578656,
         -0.00156720496461996,
         -0.0539870221688762,
         -0.0617659970055256,
         0.0722475108781831,
         0.0116138332920716,
         0.0235657061914938,
         -0.0793816665188167,
         0.0568203010273068,
         -0.0538638003077089,
         0.0216166657531931,
         -0.0125596300167196,
         -0.00233040459364117,
         -0.0320204687935561,
         0.0185112818096514,
         0.0241268079687433,
         -0.00673995125785206,
         0.0506532878526454,
         0.0236681741792709,
         -0.0549381925693061,
         0.0604237145680036,
         -0.0346713346512976,
         -0.00838670065885217,
         -0.0429640918248462,
         0.0183057147909154,
         0.0484977179690409,
         -0.0685233468834497,
         0.0484977179690409,
         0.0183057147909156,
         -0.0503552129074407,
         0.00109505899782506,
         0.0124370446426684,
         -0.0081851299536146,
         0.00614069369210499,
         0.0516277296249358,
         -0.0684564163834779,
         0.0653040075945779,
         0.0349259947781714,
         -0.0617659970055253,
         0.0761836300239406,
         -0.0674579673148395,
         0.0216166657531931,
         0.0174840533250271,
         0.0105698773979642,
         -0.118849912958644,
         0.00734315712677465,
         -0.046002095266337,
         0.0234631110609853,
         -0.0168847370688468,
         0.0346595012235051,
         -0.00156720496461973,
         -0.0744694260684293,
         0.0407703201667583,
         0.0349259947781713,
         0.0122573677182532,
         0.072247510878183,
         -0.0654520719461625,
         0.0297485234910348,
         -0.0538638003077089,
         0.0628199290309311,
         0.017484053325027,
         0.0221636413735618,
         -0.0907494441763296,
         -0.00233040459364135,
         0.0445876190263432,
         -0.00673995125785218,
         0.0123112902343299,
         -0.0414417187563704,
         -0.0122859768001257,
         0.100469534539158,
         -0.0549381925693063,
         -0.00838670065885216,
         -0.00604700083445543,
         -0.000988593774539501,
         -0.00751623843671628,
         -0.0497512583070021,
         0.0484977179690409,
         -0.0102958840262748,
         0.0369349319807276,
         -0.00818512995361471,
         0.0124370446426685,
         0.00109505899782507,
         -0.0503552129074408,
         0.051627729624936,
         -0.0525589988811972,
         0.0516277296249359,
         -0.0451675889328084,
         0.0294295211427743,
         0.0535459053640657,
         -0.118849912958643,
         0.0924483425373346,
         -0.0512710112003175,
         0.00308825294126931,
         0.0395759116667477,
         -0.0539870221688764,
         0.0407703201667583,
         -0.0513401975647227,
         0.0653040075945779,
         0.0349259947781712,
         -0.0617659970055256,
         0.0761836300239406,
         -0.0674579673148394,
         0.0216166657531932,
         0.017484053325027,
         0.0105698773979641,
         -0.091705578015887,
         0.0221636413735617,
         -0.0125596300167194,
         -0.01042916170532,
         0.0506532878526456,
         -0.0414417187563704,
         -0.0237865794000825,
         0.0769298171001789,
         -0.0122859768001257,
         0.0236681741792708,
         -0.0429640918248462,
         -0.00098859377453951,
         0.0514143919043293,
         -0.0691594831065021,
         -0.0075162384367163,
         0.0183057147909155,
         0.0369349319807276,
         -0.0507891503026877,
         0.0739131696858877,
         -0.00818512995361471,
         -0.0503552129074407,
         0.0274294482461892,
         -0.068456416383478,
         0.0516277296249359,
         0.00614069369210488,
         0.0294295211427743,
         -0.0451675889328082,
         0.0157380677900339},
        {-0.0210041270679403,
         -0.00781756649231744,
         0.0288216935602577,
         0.0233785742671913,
         -0.0205852783609291,
         -0.0132606857853842,
         -0.0206049332156069,
         -0.00416046157737644,
         0.0275019732396869,
         -0.00507396304107404,
         0.00704754579282629,
         0.0214361116886537,
         -0.0193335632679899,
         -0.011939025074192,
         0.0126248654963352,
         0.00354698014507112,
         -0.0167514163467435,
         -0.00559928189866652,
         0.0259786469699386,
         -0.00979627038899628,
         -0.00642916009551705,
         0.021807400021876,
         -0.0380315702504205,
         0.0644507415761787,
         -0.062337764857212,
         0.034493287871506,
         -0.0195655970445942,
         0.0194728914585799,
         -0.0969531780580115,
         0.0994085203800372,
         -0.0746870968037825,
         0.0218869012337249,
         0.0302686147657852,
         -0.0575744844292471,
         0.0680311572316817,
         -0.0708996124411408,
         0.156608842899173,
         -0.0596556648411613,
         -0.0154901131949742,
         0.0652815110641623,
         -0.0791240028285062,
         0.059980449972889,
         -0.0215974603533911,
         -0.0298292606291698,
         0.100728873070311,
         0.0288216935602575,
         -0.00781756649231735,
         -0.0205852783609292,
         0.00622763653808885,
         -0.0205852783609292,
         -0.00416046157737644,
         0.0100938817049025,
         -0.000760510468117529,
         0.0275019732396869,
         0.0214361116886536,
         -0.00704784297528019,
         -0.000308869934485544,
         -0.0173017406803027,
         -0.011939025074192,
         -0.0167514163467435,
         -0.0144546995050348,
         0.00949627663036293,
         0.00371834304620412,
         0.0217416541438642,
         -0.00979627038899614,
         -0.0380315702504206,
         0.0799866900753032,
         -0.0656628294529064,
         0.06293759967891,
         -0.0798565316718628,
         0.0512668191644543,
         -0.0195655970445941,
         0.0994085203800369,
         -0.096265156209482,
         0.0472072104362376,
         -0.0270651005850069,
         0.00678311518879381,
         0.0475080590166127,
         -0.0801212576111701,
         0.0680311572316818,
         -0.0596556648411613,
         0.025103731335936,
         -0.0039843531625893,
         0.0121429047306516,
         -0.00334110872139624,
         -0.0214776054680609,
         0.0179624252777804,
         0.0107321113508289,
         -0.02982926062917,
         -0.0969531780580114,
         0.0994085203800371,
         -0.0746870968037825,
         0.0218869012337248,
         0.030268614765785,
         -0.0575744844292472,
         0.068031157231682,
         -0.070899612441141,
         -0.0132606857853842,
         -0.0205852783609291,
         0.0233785742671913,
         0.027501973239687,
         -0.000760510468117486,
         0.0100938817049024,
         -0.00416046157737629,
         -0.0193335632679899,
         -0.000308869934485542,
         -0.00898314565073613,
         -0.00030886993448559,
         -0.01933356326799,
         -0.00559928189866636,
         0.00949627663036257,
         -0.0039521529494343,
         0.0132076962782083,
         0.00371834304620411,
         0.0259786469699385,
         0.0644507415761788,
         -0.0656628294529063,
         0.0815865703262301,
         -0.0902087900252811,
         0.0692608871644216,
         -0.0798565316718629,
         0.0344932878715059,
         -0.0746870968037827,
         0.0472072104362379,
         -0.0550325429876493,
         0.0299187698909809,
         0.00763264631695265,
         -0.00968908333774099,
         0.0475080590166126,
         -0.0575744844292471,
         -0.0154901131949741,
         -0.00398435316258919,
         0.0467215641277662,
         -0.0333218674412429,
         0.0275827179210522,
         -0.0404988433357122,
         0.00828975686367442,
         0.0179624252777805,
         -0.0215974603533913,
         0.0994085203800371,
         -0.096265156209482,
         0.0472072104362376,
         -0.0270651005850071,
         0.0067831151887939,
         0.0475080590166124,
         -0.0801212576111702,
         0.0680311572316817,
         0.021807400021876,
         -0.0380315702504206,
         0.0644507415761789,
         -0.062337764857212,
         0.0344932878715058,
         -0.0195655970445942,
         0.0194728914585798,
         -0.00507396304107396,
         0.0275019732396869,
         -0.00416046157737633,
         -0.0206049332156069,
         -0.011939025074192,
         -0.017301740680303,
         -0.000308869934485475,
         -0.0070478429752801,
         0.0214361116886536,
         0.0259786469699384,
         0.00371834304620415,
         0.0132076962782087,
         -0.00395215294943437,
         0.00949627663036286,
         -0.00559928189866647,
         -0.0623377648572121,
         0.06293759967891,
         -0.0902087900252812,
         0.0858328704871484,
         -0.0902087900252811,
         0.0629375996789097,
         -0.062337764857212,
         0.0218869012337249,
         -0.027065100585007,
         0.0299187698909811,
         -0.0180353090589636,
         0.0177820110061456,
         0.00763264631695246,
         0.00678311518879401,
         0.0302686147657852,
         0.0652815110641623,
         0.0121429047306516,
         -0.033321867441243,
         0.0568172578802364,
         -0.0671653861150633,
         0.0421424110280978,
         -0.0404988433357121,
         -0.0214776054680609,
         0.0599804499728891,
         -0.0746870968037826,
         0.0472072104362379,
         -0.0550325429876494,
         0.0299187698909809,
         0.00763264631695264,
         -0.00968908333774109,
         0.0475080590166125,
         -0.0575744844292472,
         -0.0380315702504206,
         0.0799866900753032,
         -0.0656628294529063,
         0.06293759967891,
         -0.0798565316718628,
         0.0512668191644542,
         -0.0195655970445942,
         0.00354698014507115,
         -0.0167514163467436,
         -0.00559928189866656,
         0.0259786469699386,
         -0.00979627038899636,
         -0.0064291600955171,
         0.0126248654963353,
         -0.011939025074192,
         -0.0193335632679899,
         0.0214361116886536,
         0.00704754579282619,
         -0.0097962703889961,
         0.0217416541438644,
         0.00371834304620409,
         0.00949627663036266,
         -0.0144546995050348,
         -0.0167514163467437,
         0.0344932878715061,
         -0.0798565316718629,
         0.0692608871644215,
         -0.0902087900252811,
         0.0815865703262302,
         -0.0656628294529063,
         0.0644507415761788,
         0.0302686147657853,
         0.00678311518879404,
         0.00763264631695244,
         0.0177820110061454,
         -0.0180353090589636,
         0.0299187698909809,
         -0.027065100585007,
         0.0218869012337249,
         -0.0791240028285064,
         -0.0033411087213961,
         0.0275827179210522,
         -0.067165386115063,
         0.0674186841678815,
         -0.067165386115063,
         0.0275827179210522,
         -0.00334110872139607,
         -0.0791240028285064,
         0.0218869012337249,
         -0.027065100585007,
         0.0299187698909809,
         -0.0180353090589636,
         0.0177820110061457,
         0.00763264631695255,
         0.00678311518879402,
         0.0302686147657853,
         0.0644507415761789,
         -0.0656628294529063,
         0.0815865703262302,
         -0.0902087900252811,
         0.0692608871644215,
         -0.0798565316718627,
         0.0344932878715059,
         -0.0167514163467436,
         -0.0144546995050348,
         0.00949627663036279,
         0.00371834304620398,
         0.0217416541438645,
         -0.00979627038899616,
         0.00704754579282638,
         0.0214361116886537,
         -0.0193335632679899,
         -0.0119390250741919,
         0.0126248654963355,
         -0.00642916009551698,
         -0.00979627038899616,
         0.0259786469699387,
         -0.00559928189866665,
         -0.0167514163467434,
         0.00354698014507111,
         -0.0195655970445942,
         0.051266819164454,
         -0.0798565316718629,
         0.0629375996789099,
         -0.0656628294529064,
         0.0799866900753032,
         -0.0380315702504207,
         -0.0575744844292472,
         0.0475080590166126,
         -0.00968908333774104,
         0.00763264631695258,
         0.029918769890981,
         -0.0550325429876495,
         0.0472072104362378,
         -0.0746870968037826,
         0.0599804499728892,
         -0.0214776054680609,
         -0.0404988433357122,
         0.0421424110280978,
         -0.0671653861150632,
         0.0568172578802365,
         -0.033321867441243,
         0.0121429047306515,
         0.0652815110641623,
         0.0302686147657852,
         0.00678311518879416,
         0.00763264631695267,
         0.0177820110061455,
         -0.0180353090589634,
         0.0299187698909809,
         -0.027065100585007,
         0.0218869012337249,
         -0.0623377648572121,
         0.0629375996789097,
         -0.0902087900252813,
         0.0858328704871483,
         -0.0902087900252811,
         0.0629375996789099,
         -0.0623377648572121,
         -0.00559928189866651,
         0.00949627663036274,
         -0.00395215294943441,
         0.0132076962782084,
         0.00371834304620414,
         0.0259786469699387,
         0.0214361116886536,
         -0.00704784297528019,
         -0.000308869934485336,
         -0.0173017406803029,
         -0.011939025074192,
         -0.0206049332156069,
         -0.00416046157737628,
         0.0275019732396868,
         -0.005073963041074,
         0.0194728914585797,
         -0.0195655970445943,
         0.0344932878715059,
         -0.062337764857212,
         0.0644507415761788,
         -0.0380315702504206,
         0.0218074000218759,
         0.0680311572316817,
         -0.0801212576111703,
         0.0475080590166124,
         0.00678311518879386,
         -0.0270651005850068,
         0.0472072104362376,
         -0.0962651562094821,
         0.0994085203800372,
         -0.0215974603533912,
         0.0179624252777804,
         0.00828975686367424,
         -0.0404988433357121,
         0.0275827179210521,
         -0.033321867441243,
         0.0467215641277662,
         -0.00398435316258908,
         -0.0154901131949741,
         -0.0575744844292473,
         0.0475080590166125,
         -0.00968908333774126,
         0.00763264631695261,
         0.0299187698909807,
         -0.0550325429876493,
         0.0472072104362378,
         -0.0746870968037824,
         0.034493287871506,
         -0.0798565316718629,
         0.0692608871644214,
         -0.0902087900252812,
         0.0815865703262301,
         -0.0656628294529064,
         0.0644507415761788,
         0.0259786469699387,
         0.00371834304620431,
         0.0132076962782085,
         -0.00395215294943443,
         0.00949627663036266,
         -0.00559928189866663,
         -0.0193335632679899,
         -0.000308869934485445,
         -0.00898314565073619,
         -0.000308869934485494,
         -0.0193335632679898,
         -0.00416046157737653,
         0.0100938817049024,
         -0.000760510468117401,
         0.0275019732396869,
         0.0233785742671912,
         -0.0205852783609289,
         -0.0132606857853841,
         -0.0708996124411408,
         0.0680311572316817,
         -0.0575744844292472,
         0.0302686147657853,
         0.0218869012337248,
         -0.0746870968037827,
         0.099408520380037,
         -0.0969531780580114,
         -0.0298292606291699,
         0.010732111350829,
         0.0179624252777804,
         -0.0214776054680611,
         -0.00334110872139614,
         0.0121429047306515,
         -0.00398435316258928,
         0.0251037313359359,
         -0.0596556648411614,
         0.0680311572316818,
         -0.0801212576111702,
         0.0475080590166125,
         0.00678311518879375,
         -0.027065100585007,
         0.0472072104362378,
         -0.0962651562094821,
         0.0994085203800369,
         -0.019565597044594,
         0.0512668191644541,
         -0.0798565316718629,
         0.0629375996789099,
         -0.0656628294529062,
         0.0799866900753032,
         -0.0380315702504207,
         -0.00979627038899626,
         0.0217416541438644,
         0.0037183430462043,
         0.00949627663036283,
         -0.0144546995050347,
         -0.0167514163467435,
         -0.011939025074192,
         -0.0173017406803028,
         -0.000308869934485606,
         -0.00704784297528028,
         0.0214361116886538,
         0.027501973239687,
         -0.000760510468117462,
         0.0100938817049022,
         -0.00416046157737636,
         -0.020585278360929,
         0.006227636538089,
         -0.020585278360929,
         -0.00781756649231751,
         0.0288216935602577,
         0.100728873070311,
         -0.0298292606291698,
         -0.021597460353391,
         0.0599804499728891,
         -0.0791240028285064,
         0.0652815110641622,
         -0.0154901131949742,
         -0.0596556648411617,
         0.156608842899173,
         -0.0708996124411407,
         0.0680311572316818,
         -0.0575744844292471,
         0.0302686147657853,
         0.0218869012337249,
         -0.0746870968037826,
         0.0994085203800369,
         -0.0969531780580113,
         0.0194728914585797,
         -0.0195655970445942,
         0.034493287871506,
         -0.062337764857212,
         0.0644507415761788,
         -0.0380315702504206,
         0.0218074000218758,
         -0.00642916009551699,
         -0.00979627038899619,
         0.0259786469699386,
         -0.00559928189866656,
         -0.0167514163467436,
         0.00354698014507108,
         0.0126248654963354,
         -0.0119390250741922,
         -0.0193335632679899,
         0.0214361116886536,
         0.00704754579282626,
         -0.00507396304107403,
         0.0275019732396868,
         -0.00416046157737646,
         -0.0206049332156069,
         -0.0132606857853842,
         -0.0205852783609292,
         0.0233785742671913,
         0.0288216935602576,
         -0.00781756649231752,
         -0.0210041270679403},
        {1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {-0.221288179974227,
         0.0545140597182974,
         0.16677412025593,
         -0.26307320284771,
         0.208559143129412,
         -0.375333263385342,
         0.16677412025593,
         0.0545140597182974,
         0.208559143129412,
         -0.42984732310364,
         0.208559143129412,
         0.0545140597182972,
         0.166774120255929,
         -0.375333263385342,
         0.208559143129413,
         -0.26307320284771,
         0.16677412025593,
         0.0545140597182974,
         -0.221288179974227},
        {0.176688245674687,
         -0.353471044321463,
         0.176782798646776,
         0.287917424895051,
         0.0655536194264122,
         -0.242336418073188,
         0.176782798646776,
         -0.353471044321463,
         0.0655536194264122,
         0.111134626248275,
         0.0655536194264122,
         -0.353471044321463,
         0.176782798646776,
         -0.242336418073188,
         0.0655536194264121,
         0.28791742489505,
         0.176782798646776,
         -0.353471044321463,
         0.176688245674687},
        {1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {-0.221288179974227,
         0.0545140597182974,
         0.16677412025593,
         -0.26307320284771,
         0.208559143129412,
         -0.375333263385342,
         0.16677412025593,
         0.0545140597182974,
         0.208559143129412,
         -0.42984732310364,
         0.208559143129412,
         0.0545140597182972,
         0.166774120255929,
         -0.375333263385342,
         0.208559143129413,
         -0.26307320284771,
         0.16677412025593,
         0.0545140597182974,
         -0.221288179974227},
        {0.176688245674687,
         -0.353471044321463,
         0.176782798646776,
         0.287917424895051,
         0.0655536194264122,
         -0.242336418073188,
         0.176782798646776,
         -0.353471044321463,
         0.0655536194264122,
         0.111134626248275,
         0.0655536194264122,
         -0.353471044321463,
         0.176782798646776,
         -0.242336418073188,
         0.0655536194264121,
         0.28791742489505,
         0.176782798646776,
         -0.353471044321463,
         0.176688245674687},
        {0.0656777893398508,
         0.00736305638258405,
         -0.0725407855829161,
         -0.000500060139518738,
         -0.116633921293627,
         0.126440453521077,
         -0.0171695886100346,
         0.0896756051953912,
         -0.143575273133552,
         0.161244921883105,
         -0.0753618398389971,
         -0.0169424771231114,
         0.0266265276222576,
         0.167748331555379,
         -0.048358309377029,
         -0.0513912387219372,
         0.0557882561799154,
         0.0820533159031414,
         -0.0567885446639431,
         -0.0473867559683358,
         -0.00372765429341687,
         -0.148373817933897,
         0.117678429758185,
         -0.0453899481327963,
         0.0029099565585905,
         -0.0590664290863654,
         -0.125723308829475,
         0.0512318263079893,
         0.149853322360483,
         -0.0116735966011204,
         -0.0226157525837577,
         -0.153864097398983,
         0.0330947021846734,
         -0.0751197249105775,
         0.0591271554334049,
         -0.0950953745490387,
         0.0717530158210705,
         -0.1032418150122,
         0.138899626241855,
         0.011734459461565,
         0.00255759432209699,
         0.0762897848818973,
         0.0775122030389276,
         -0.102652852570171,
         0.0228196554146816,
         0.00232099411656204,
         0.0238054733661768,
         -0.0918042568225897,
         -0.058477466644337,
         -0.0129044149437157,
         0.0616978310889062,
         -0.0729230757923904,
         0.134562802952845,
         -0.103956317079643,
         0.0375802237408849,
         0.137531164197078,
         -0.0677422407825706,
         -0.0833740215356758,
         -0.0986853851402741,
         0.05098971137957,
         0.0413967803368123,
         0.0333368171130931,
         0.089430800031148,
         -0.0497267714218062,
         -0.0271721824556836,
         -0.0691216138185296,
         0.184026114440668,
         -0.105097968394688,
         -0.0375097136294474,
         0.0818167156976063,
         -0.00488682301332159,
         0.0818167156976063,
         -0.0375097136294476,
         -0.105097968394688,
         0.184026114440668,
         -0.0691216138185301,
         -0.0271721824556837,
         -0.0497267714218063,
         0.0894308000311479,
         0.033336817113093,
         0.0413967803368122,
         0.0509897113795699,
         -0.098685385140274,
         -0.0833740215356758,
         -0.0677422407825705,
         0.137531164197078,
         0.0375802237408852,
         -0.103956317079643,
         0.134562802952845,
         -0.0729230757923904,
         0.0616978310889063,
         -0.0129044149437156,
         -0.0584774666443368,
         -0.0918042568225897,
         0.023805473366177,
         0.00232099411656205,
         0.0228196554146817,
         -0.102652852570171,
         0.0775122030389277,
         0.0762897848818971,
         0.00255759432209725,
         0.011734459461565,
         0.138899626241855,
         -0.1032418150122,
         0.0717530158210706,
         -0.0950953745490388,
         0.0591271554334049,
         -0.0751197249105775,
         0.0330947021846736,
         -0.153864097398983,
         -0.0226157525837577,
         -0.0116735966011204,
         0.149853322360483,
         0.0512318263079894,
         -0.125723308829475,
         -0.0590664290863653,
         0.00290995655859091,
         -0.0453899481327964,
         0.117678429758185,
         -0.148373817933897,
         -0.00372765429341698,
         -0.0473867559683357,
         -0.0567885446639431,
         0.0820533159031414,
         0.0557882561799157,
         -0.0513912387219372,
         -0.0483583093770292,
         0.167748331555379,
         0.0266265276222576,
         -0.0169424771231114,
         -0.0753618398389969,
         0.161244921883105,
         -0.143575273133552,
         0.0896756051953911,
         -0.0171695886100345,
         0.126440453521077,
         -0.116633921293626,
         -0.000500060139518803,
         -0.0725407855829163,
         0.00736305638258415,
         0.0656777893398508},
        {-0.0422145519241407,
         0.100043009990846,
         0.0148154313285713,
         -0.0726438893952767,
         -0.02779166133965,
         -0.128199940992693,
         0.0559485923414974,
         0.162147424225058,
         -0.048762914560936,
         0.0654582116147154,
         -0.114278589805462,
         0.038905308563818,
         0.117587833165784,
         -0.0420103422496099,
         0.0659900607461053,
         -0.00974413868187957,
         -0.0790997788021484,
         -0.0406110218363458,
         0.00541121674771772,
         0.0874465135293417,
         -0.0176445099400819,
         -0.0884014443428655,
         0.0631648110601118,
         -0.0917247547796478,
         0.00535379891995556,
         0.0208553264172148,
         0.247372176122133,
         -0.0341231477810955,
         -0.0989704385355754,
         -0.0859025229777053,
         0.081120362194983,
         -0.0997377568251921,
         -0.175698404870043,
         -0.0296634290024794,
         0.149707719935366,
         -0.00587622803033231,
         0.144254234250267,
         0.015294581844488,
         -0.0499276941727926,
         0.0242162239018339,
         0.0640356674388676,
         -0.0167277284963064,
         -0.0855224994943343,
         -0.0358017509743127,
         0.0648741187298906,
         0.0564501317387565,
         -0.0115061879682486,
         -0.00272939184636752,
         -0.0302410064015861,
         -0.0526485610728293,
         -0.0736035742551871,
         -0.097863076751481,
         0.147202394463988,
         0.00177446103284348,
         0.0685450888030017,
         -0.0105124210617655,
         0.0544539611105005,
         0.0578494521520204,
         -0.0296820491765649,
         -0.118738308584078,
         -0.0375506234709939,
         -0.0910832440670609,
         0.0435063682766338,
         0.105405333857132,
         0.126096993216036,
         -0.19700248208824,
         -0.0232612930883101,
         0.0642721728442059,
         0.0990624198740509,
         -0.0481965575364572,
         -0.0729234832576592,
         -0.0481965575364571,
         0.0990624198740508,
         0.0642721728442061,
         -0.0232612930883102,
         -0.197002482088239,
         0.126096993216036,
         0.105405333857132,
         0.0435063682766341,
         -0.0910832440670612,
         -0.037550623470994,
         -0.118738308584078,
         -0.0296820491765647,
         0.0578494521520202,
         0.0544539611105006,
         -0.0105124210617655,
         0.0685450888030017,
         0.00177446103284373,
         0.147202394463988,
         -0.0978630767514811,
         -0.0736035742551873,
         -0.0526485610728291,
         -0.0302410064015859,
         -0.00272939184636758,
         -0.0115061879682485,
         0.0564501317387565,
         0.0648741187298906,
         -0.0358017509743127,
         -0.0855224994943343,
         -0.0167277284963061,
         0.0640356674388678,
         0.0242162239018339,
         -0.0499276941727927,
         0.0152945818444884,
         0.144254234250267,
         -0.00587622803033231,
         0.149707719935366,
         -0.0296634290024797,
         -0.175698404870043,
         -0.0997377568251921,
         0.081120362194983,
         -0.0859025229777052,
         -0.0989704385355754,
         -0.0341231477810954,
         0.247372176122133,
         0.020855326417215,
         0.00535379891995555,
         -0.091724754779648,
         0.0631648110601118,
         -0.0884014443428653,
         -0.0176445099400819,
         0.0874465135293417,
         0.00541121674771778,
         -0.040611021836346,
         -0.0790997788021485,
         -0.00974413868187956,
         0.0659900607461053,
         -0.0420103422496098,
         0.117587833165784,
         0.038905308563818,
         -0.114278589805462,
         0.0654582116147154,
         -0.0487629145609362,
         0.162147424225059,
         0.0559485923414977,
         -0.128199940992693,
         -0.0277916613396498,
         -0.0726438893952768,
         0.0148154313285712,
         0.100043009990846,
         -0.0422145519241404},
        {0.131604165007335,
         -0.111473087864395,
         -0.082885188745984,
         0.062754111603044,
         0.0367759747770813,
         0.0384216544349089,
         0.0362754586524049,
         0.0752952680990112,
         -0.0308317337879362,
         -0.0681978364675126,
         0.0290489889043613,
         0.113920369935424,
         -0.274573523847119,
         0.0309975145892172,
         -0.0220835601697785,
         0.0735101445405949,
         -0.00787063092516474,
         -0.00108099009449631,
         0.139390257797977,
         0.0389880376777171,
         -0.106761527044015,
         -0.0927193233744847,
         0.0373931914316373,
         -0.0404172675806217,
         0.0252946862006383,
         -0.0307751537498428,
         -0.012914564018868,
         -0.0881961242624872,
         0.0720616993769944,
         -0.155439300218539,
         0.129715054545603,
         0.0727967699245223,
         -0.0286940357239362,
         0.0106110851535869,
         0.171295779085297,
         -0.0323220589290951,
         -0.123860870142081,
         -0.00798584794159291,
         -0.0883261575804183,
         -0.00865521042785259,
         -0.00163879152592817,
         0.0977892334163566,
         -0.0699212452829598,
         0.066488904306346,
         0.0526124070239149,
         -0.049180066047301,
         -0.162639346196775,
         0.0802152472367409,
         0.0436995984980967,
         0.178020182345248,
         -0.0610666269316489,
         0.0154605515721375,
         0.0520438010253727,
         -0.133946532933508,
         -0.114185666889707,
         0.0337100936145296,
         -0.0209975991594357,
         -0.0812585707310145,
         0.0723396453957296,
         -0.0697582205117133,
         0.129804724005291,
         -0.0471319394747103,
         -0.032689674407519,
         0.0999526910251692,
         0.0493895612082806,
         0.0320190894605892,
         0.0623864961246202,
         -0.0192079563732195,
         -0.00835721723938377,
         -0.0486222646158689,
         -0.0554167267788618,
         -0.0486222646158692,
         -0.00835721723938366,
         -0.0192079563732196,
         0.0623864961246202,
         0.0320190894605894,
         0.0493895612082805,
         0.099952691025169,
         -0.0326896744075188,
         -0.0471319394747104,
         0.129804724005291,
         -0.0697582205117132,
         0.0723396453957294,
         -0.0812585707310144,
         -0.0209975991594355,
         0.0337100936145294,
         -0.114185666889707,
         -0.133946532933508,
         0.0520438010253726,
         0.0154605515721375,
         -0.061066626931649,
         0.178020182345248,
         0.0436995984980966,
         0.0802152472367408,
         -0.162639346196775,
         -0.0491800660473009,
         0.0526124070239148,
         0.066488904306346,
         -0.06992124528296,
         0.0977892334163565,
         -0.00163879152592826,
         -0.00865521042785263,
         -0.0883261575804183,
         -0.00798584794159315,
         -0.123860870142081,
         -0.0323220589290952,
         0.171295779085297,
         0.0106110851535869,
         -0.0286940357239362,
         0.0727967699245222,
         0.129715054545603,
         -0.155439300218539,
         0.0720616993769942,
         -0.0881961242624875,
         -0.012914564018868,
         -0.0307751537498425,
         0.0252946862006381,
         -0.0404172675806215,
         0.0373931914316372,
         -0.0927193233744845,
         -0.106761527044015,
         0.0389880376777171,
         0.139390257797977,
         -0.00108099009449632,
         -0.00787063092516497,
         0.0735101445405952,
         -0.0220835601697785,
         0.0309975145892172,
         -0.27457352384712,
         0.113920369935424,
         0.0290489889043611,
         -0.0681978364675125,
         -0.0308317337879364,
         0.0752952680990111,
         0.036275458652405,
         0.038421654434909,
         0.036775974777081,
         0.0627541116030439,
         -0.082885188745984,
         -0.111473087864395,
         0.131604165007335},
        {0.0721625887210373,
         -0.0199519537384464,
         -0.00166109334981312,
         -0.0505495416327779,
         0.102448241873179,
         -0.110184366312895,
         0.0276880781781619,
         0.133527176188297,
         -0.021681716525589,
         0.0445431799802051,
         0.11256857939766,
         -0.127936535266659,
         -0.0567946328520386,
         -0.061993534936164,
         0.0231318572211042,
         -0.053754947944154,
         -0.062957391425525,
         0.169423162820893,
         -0.00832404039192239,
         -0.0381316629327702,
         -0.0023230440042448,
         0.0876436507410448,
         0.0375405212835164,
         -0.00915060751327944,
         -0.158213435503817,
         -0.0270685320750032,
         -0.130731518963909,
         0.0272971114761596,
         -0.00913417190991034,
         0.0132644431069933,
         0.0873749806835059,
         -0.0214461759215568,
         0.0992273388673622,
         0.093497715032711,
         0.0225190960619347,
         -0.172175403626561,
         0.141566808447914,
         0.0271738522565973,
         -0.111796592134435,
         -0.136076836973792,
         0.0749811610392001,
         -0.166155832067666,
         0.0259140901708131,
         0.0337396311330315,
         0.105125493076407,
         -0.164779214380251,
         0.0574350398954345,
         0.0351815857637793,
         -0.0205027531985689,
         0.10866555618005,
         0.096568365137216,
         -0.068908691412959,
         -0.0955308113127129,
         0.0143304020444952,
         0.045867787372486,
         -0.127813276047096,
         -0.110986460616447,
         0.0666374833768057,
         -0.0630806506450877,
         0.0463679758411087,
         0.00420706862038725,
         0.0801564745024133,
         -0.0350610128282651,
         0.00711517330844271,
         0.177629483585191,
         -0.0720669753857013,
         0.0865648491655178,
         -0.0222339982195321,
         0.0245738118518518,
         -0.0703372125985585,
         -0.00416518975479865,
         -0.0703372125985582,
         0.0245738118518518,
         -0.0222339982195321,
         0.0865648491655179,
         -0.0720669753857011,
         0.177629483585191,
         0.0071151733084429,
         -0.035061012828265,
         0.0801564745024133,
         0.00420706862038725,
         0.0463679758411088,
         -0.0630806506450876,
         0.0666374833768059,
         -0.110986460616447,
         -0.127813276047096,
         0.045867787372486,
         0.0143304020444949,
         -0.0955308113127128,
         -0.0689086914129589,
         0.096568365137216,
         0.10866555618005,
         -0.0205027531985691,
         0.0351815857637794,
         0.0574350398954347,
         -0.164779214380251,
         0.105125493076407,
         0.0337396311330313,
         0.025914090170813,
         -0.166155832067666,
         0.0749811610392004,
         -0.136076836973792,
         -0.111796592134435,
         0.0271738522565972,
         0.141566808447914,
         -0.172175403626561,
         0.0225190960619348,
         0.0934977150327111,
         0.0992273388673626,
         -0.0214461759215569,
         0.0873749806835058,
         0.0132644431069934,
         -0.00913417190991059,
         0.0272971114761598,
         -0.13073151896391,
         -0.0270685320750032,
         -0.158213435503817,
         -0.00915060751327923,
         0.0375405212835163,
         0.0876436507410448,
         -0.00232304400424482,
         -0.0381316629327703,
         -0.00832404039192254,
         0.169423162820893,
         -0.0629573914255251,
         -0.0537549479441539,
         0.0231318572211043,
         -0.061993534936164,
         -0.0567946328520386,
         -0.127936535266659,
         0.11256857939766,
         0.0445431799802053,
         -0.0216817165255891,
         0.133527176188297,
         0.0276880781781617,
         -0.110184366312895,
         0.102448241873179,
         -0.0505495416327781,
         -0.00166109334981291,
         -0.0199519537384461,
         0.0721625887210375},
        {0.058672997208943,
         -0.13882488625018,
         0.148501846303151,
         -0.0683499572619136,
         -0.0035943615140656,
         0.0589650634903877,
         0.0834541842738573,
         -0.160236282584917,
         -0.0472306272086211,
         0.0321264001966768,
         0.135472649221917,
         -0.219057383187258,
         0.0249117367563978,
         0.00974132418477309,
         -0.0290900014509311,
         0.0227009142944208,
         0.0845074429428107,
         0.0151380953922274,
         0.00559921081886766,
         0.070178994880202,
         -0.0763259575509094,
         -0.0547894253372598,
         -0.0452646315823987,
         0.0154354905650298,
         0.130518264979366,
         -0.053161101580574,
         0.0252691511453658,
         -0.0147846872748452,
         -0.145957113092438,
         0.0849006268325414,
         0.148941443629561,
         -0.0278960672935213,
         -0.0787497924630389,
         0.0437393171329,
         0.060900135477868,
         0.0617243457109471,
         0.0177925359541699,
         -0.23030820525322,
         0.00450432052048457,
         -0.0127746892611982,
         0.0213454868440354,
         0.0112411535739741,
         0.00666397912059005,
         -0.044469180093174,
         0.0931259611532637,
         -0.0553207601806799,
         0.0118825396751642,
         -0.015234776703427,
         0.132677923579472,
         -0.0395520220924274,
         0.101019744943815,
         -0.0727730066610441,
         -0.0480593572248435,
         0.030624346246369,
         -0.125549696856524,
         -0.00353386520888254,
         0.156060644431789,
         -0.0499239889732257,
         -0.131016075035564,
         0.0769486448141717,
         0.0682653285925182,
         -0.170483124552056,
         0.127459422691117,
         -0.037128187180298,
         0.0496493134119052,
         0.0300661074090711,
         -0.00261488028174379,
         0.0279194748489949,
         0.000144401938815794,
         -0.0615281516324879,
         -0.0252087223642655,
         -0.0615281516324877,
         0.000144401938815932,
         0.0279194748489949,
         -0.00261488028174377,
         0.030066107409071,
         0.0496493134119055,
         -0.0371281871802981,
         0.127459422691117,
         -0.170483124552056,
         0.068265328592518,
         0.0769486448141717,
         -0.131016075035564,
         -0.0499239889732255,
         0.156060644431789,
         -0.00353386520888265,
         -0.125549696856524,
         0.030624346246369,
         -0.0480593572248433,
         -0.0727730066610441,
         0.101019744943815,
         -0.0395520220924274,
         0.132677923579472,
         -0.0152347767034269,
         0.0118825396751643,
         -0.05532076018068,
         0.0931259611532637,
         -0.0444691800931738,
         0.0066639791205902,
         0.0112411535739742,
         0.0213454868440355,
         -0.0127746892611982,
         0.00450432052048435,
         -0.23030820525322,
         0.0177925359541697,
         0.0617243457109468,
         0.0609001354778683,
         0.0437393171328998,
         -0.078749792463039,
         -0.0278960672935215,
         0.148941443629561,
         0.0849006268325413,
         -0.145957113092438,
         -0.0147846872748451,
         0.0252691511453658,
         -0.0531611015805743,
         0.130518264979367,
         0.0154354905650298,
         -0.0452646315823985,
         -0.0547894253372598,
         -0.0763259575509096,
         0.070178994880202,
         0.00559921081886753,
         0.0151380953922274,
         0.0845074429428107,
         0.0227009142944208,
         -0.0290900014509312,
         0.00974132418477326,
         0.0249117367563978,
         -0.219057383187257,
         0.135472649221917,
         0.0321264001966768,
         -0.0472306272086212,
         -0.160236282584917,
         0.0834541842738574,
         0.0589650634903877,
         -0.00359436151406536,
         -0.0683499572619135,
         0.148501846303151,
         -0.13882488625018,
         0.058672997208943},
        {-0.0273671160972317,
         -0.0474280123768137,
         0.0550375668197565,
         0.019757561654289,
         -0.0231837528252424,
         0.153560681666778,
         -0.082948916464722,
         -0.0540758156328586,
         -0.154522432853676,
         0.217713787664109,
         0.0285274613276757,
         0.0528018359610006,
         -0.0539621811914447,
         -0.0563983411340493,
         -0.0649925216329682,
         0.140291413816155,
         -0.0924254251865847,
         0.0495785440387965,
         -0.155665338317795,
         -0.0366904368085583,
         0.11627253076785,
         0.0164561614423436,
         -0.068333884667595,
         -0.105281143451688,
         0.1300450793771,
         0.0432326941053743,
         0.0627051232323085,
         -0.0171525688165449,
         -0.0740800157434394,
         -0.0357563679577473,
         0.000107100813291828,
         0.127935096121592,
         0.0608714945000444,
         -0.0671782765983036,
         0.0823926645219914,
         -0.0611190685725222,
         0.06208594709811,
         0.0457891286223407,
         -0.0343557049019067,
         -0.0614581480214333,
         0.0372770903299476,
         -0.0863713444994936,
         -0.0373906779429015,
         0.129566540853071,
         -0.138443530056539,
         0.0462676671463692,
         -0.0804722866835253,
         0.0615717356343876,
         0.127010106336105,
         -0.0961777144767523,
         -0.0296720466289083,
         0.0914636739996871,
         0.0301487603408342,
         -0.0818060110006022,
         -0.0936864