/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_order2.h"

GtinvDataOrder2::GtinvDataOrder2(){

    set_gtinv_info();
}

GtinvDataOrder2::~GtinvDataOrder2(){}

const vector2i& GtinvDataOrder2::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataOrder2::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataOrder2::get_coeffs() const{ return coeffs_all; }

void GtinvDataOrder2::set_gtinv_info(){

    l_array_all =
        {{0, 0},
        {1, 1},
        {2, 2},
        {3, 3},
        {4, 4},
        {5, 5},
        {6, 6},
        {7, 7},
        {8, 8},
        {9, 9},
        {10, 10},
        {11, 11},
        {12, 12},
        {13, 13},
        {14, 14},
        {15, 15},
        {16, 16},
        {17, 17},
        {18, 18},
        {19, 19},
        {20, 20}};

    coeffs_all =
        {{1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {0.447213595499958,
         -0.447213595499958,
         0.447213595499958,
         -0.447213595499958,
         0.447213595499958},
        {-0.377964473009227,
         0.377964473009227,
         -0.377964473009227,
         0.377964473009227,
         -0.377964473009228,
         0.377964473009227,
         -0.377964473009227},
        {-0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333,
         0.333333333333333,
         -0.333333333333333},
        {0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764,
         -0.301511344577764,
         0.301511344577764},
        {-0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615,
         0.277350098112615,
         -0.277350098112615},
        {0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161,
         -0.258198889747161,
         0.258198889747161},
        {-0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333},
        {0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562,
         -0.229415733870562,
         0.229415733870562},
        {-0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235992,
         0.218217890235992,
         -0.218217890235993},
        {-0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075,
         0.208514414057075,
         -0.208514414057075},
        {0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2},
        {-0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875,
         0.192450089729875,
         -0.192450089729875},
        {-0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052,
         0.185695338177052,
         -0.185695338177052},
        {0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775,
         -0.179605302026775,
         0.179605302026775},
        {0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698,
         -0.174077655955698,
         0.174077655955698},
        {-0.169030850945704,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945704,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945704,
         0.169030850945704,
         -0.169030850945704,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945704,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945704,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703,
         0.169030850945704,
         -0.169030850945703,
         0.169030850945703,
         -0.169030850945703},
        {-0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357,
         0.164398987305357,
         -0.164398987305357},
        {-0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087,
         0.160128153805087,
         -0.160128153805087},
        {-0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606,
         0.156173761888606,
         -0.156173761888606}};

    m_array_all = {
        {{0, 0}},
        {{-1, 1},
        {0, 0},
        {1, -1}},
        {{-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2}},
        {{-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3}},
        {{-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4}},
        {{-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5}},
        {{-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6}},
        {{-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7}},
        {{-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8}},
        {{-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9}},
        {{-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10}},
        {{-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11}},
        {{-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12}},
        {{-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13}},
        {{-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14}},
        {{-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15}},
        {{-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16}},
        {{-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17}},
        {{-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18}},
        {{-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19}},
        {{-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20}}
    };

}
