/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_order6.h"

GtinvDataOrder6::GtinvDataOrder6(){

    set_gtinv_info();
}

GtinvDataOrder6::~GtinvDataOrder6(){}

const vector2i& GtinvDataOrder6::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataOrder6::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataOrder6::get_coeffs() const{ return coeffs_all; }

void GtinvDataOrder6::set_gtinv_info(){

    l_array_all =
        {{0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, 1},
        {0, 0, 1, 1, 1, 1},
        {0, 0, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1}};

    coeffs_all =
        {{1},
        {-0.577350269189626,
         0.577350269189626,
         -0.577350269189626},
        {-0.221288179974227,
         0.0545140597182974,
         0.16677412025593,
         -0.26307320284771,
         0.208559143129412,
         -0.375333263385342,
         0.16677412025593,
         0.0545140597182974,
         0.208559143129412,
         -0.42984732310364,
         0.208559143129412,
         0.0545140597182972,
         0.166774120255929,
         -0.375333263385342,
         0.208559143129413,
         -0.26307320284771,
         0.16677412025593,
         0.0545140597182974,
         -0.221288179974227},
        {0.176688245674687,
         -0.353471044321463,
         0.176782798646776,
         0.287917424895051,
         0.0655536194264122,
         -0.242336418073188,
         0.176782798646776,
         -0.353471044321463,
         0.0655536194264122,
         0.111134626248275,
         0.0655536194264122,
         -0.353471044321463,
         0.176782798646776,
         -0.242336418073188,
         0.0655536194264121,
         0.28791742489505,
         0.176782798646776,
         -0.353471044321463,
         0.176688245674687},
        {0.0656777893398508,
         0.00736305638258405,
         -0.0725407855829161,
         -0.000500060139518738,
         -0.116633921293627,
         0.126440453521077,
         -0.0171695886100346,
         0.0896756051953912,
         -0.143575273133552,
         0.161244921883105,
         -0.0753618398389971,
         -0.0169424771231114,
         0.0266265276222576,
         0.167748331555379,
         -0.048358309377029,
         -0.0513912387219372,
         0.0557882561799154,
         0.0820533159031414,
         -0.0567885446639431,
         -0.0473867559683358,
         -0.00372765429341687,
         -0.148373817933897,
         0.117678429758185,
         -0.0453899481327963,
         0.0029099565585905,
         -0.0590664290863654,
         -0.125723308829475,
         0.0512318263079893,
         0.149853322360483,
         -0.0116735966011204,
         -0.0226157525837577,
         -0.153864097398983,
         0.0330947021846734,
         -0.0751197249105775,
         0.0591271554334049,
         -0.0950953745490387,
         0.0717530158210705,
         -0.1032418150122,
         0.138899626241855,
         0.011734459461565,
         0.00255759432209699,
         0.0762897848818973,
         0.0775122030389276,
         -0.102652852570171,
         0.0228196554146816,
         0.00232099411656204,
         0.0238054733661768,
         -0.0918042568225897,
         -0.058477466644337,
         -0.0129044149437157,
         0.0616978310889062,
         -0.0729230757923904,
         0.134562802952845,
         -0.103956317079643,
         0.0375802237408849,
         0.137531164197078,
         -0.0677422407825706,
         -0.0833740215356758,
         -0.0986853851402741,
         0.05098971137957,
         0.0413967803368123,
         0.0333368171130931,
         0.089430800031148,
         -0.0497267714218062,
         -0.0271721824556836,
         -0.0691216138185296,
         0.184026114440668,
         -0.105097968394688,
         -0.0375097136294474,
         0.0818167156976063,
         -0.00488682301332159,
         0.0818167156976063,
         -0.0375097136294476,
         -0.105097968394688,
         0.184026114440668,
         -0.0691216138185301,
         -0.0271721824556837,
         -0.0497267714218063,
         0.0894308000311479,
         0.033336817113093,
         0.0413967803368122,
         0.0509897113795699,
         -0.098685385140274,
         -0.0833740215356758,
         -0.0677422407825705,
         0.137531164197078,
         0.0375802237408852,
         -0.103956317079643,
         0.134562802952845,
         -0.0729230757923904,
         0.0616978310889063,
         -0.0129044149437156,
         -0.0584774666443368,
         -0.0918042568225897,
         0.023805473366177,
         0.00232099411656205,
         0.0228196554146817,
         -0.102652852570171,
         0.0775122030389277,
         0.0762897848818971,
         0.00255759432209725,
         0.011734459461565,
         0.138899626241855,
         -0.1032418150122,
         0.0717530158210706,
         -0.0950953745490388,
         0.0591271554334049,
         -0.0751197249105775,
         0.0330947021846736,
         -0.153864097398983,
         -0.0226157525837577,
         -0.0116735966011204,
         0.149853322360483,
         0.0512318263079894,
         -0.125723308829475,
         -0.0590664290863653,
         0.00290995655859091,
         -0.0453899481327964,
         0.117678429758185,
         -0.148373817933897,
         -0.00372765429341698,
         -0.0473867559683357,
         -0.0567885446639431,
         0.0820533159031414,
         0.0557882561799157,
         -0.0513912387219372,
         -0.0483583093770292,
         0.167748331555379,
         0.0266265276222576,
         -0.0169424771231114,
         -0.0753618398389969,
         0.161244921883105,
         -0.143575273133552,
         0.0896756051953911,
         -0.0171695886100345,
         0.126440453521077,
         -0.116633921293626,
         -0.000500060139518803,
         -0.0725407855829163,
         0.00736305638258415,
         0.0656777893398508},
        {-0.0422145519241407,
         0.100043009990846,
         0.0148154313285713,
         -0.0726438893952767,
         -0.02779166133965,
         -0.128199940992693,
         0.0559485923414974,
         0.162147424225058,
         -0.048762914560936,
         0.0654582116147154,
         -0.114278589805462,
         0.038905308563818,
         0.117587833165784,
         -0.0420103422496099,
         0.0659900607461053,
         -0.00974413868187957,
         -0.0790997788021484,
         -0.0406110218363458,
         0.00541121674771772,
         0.0874465135293417,
         -0.0176445099400819,
         -0.0884014443428655,
         0.0631648110601118,
         -0.0917247547796478,
         0.00535379891995556,
         0.0208553264172148,
         0.247372176122133,
         -0.0341231477810955,
         -0.0989704385355754,
         -0.0859025229777053,
         0.081120362194983,
         -0.0997377568251921,
         -0.175698404870043,
         -0.0296634290024794,
         0.149707719935366,
         -0.00587622803033231,
         0.144254234250267,
         0.015294581844488,
         -0.0499276941727926,
         0.0242162239018339,
         0.0640356674388676,
         -0.0167277284963064,
         -0.0855224994943343,
         -0.0358017509743127,
         0.0648741187298906,
         0.0564501317387565,
         -0.0115061879682486,
         -0.00272939184636752,
         -0.0302410064015861,
         -0.0526485610728293,
         -0.0736035742551871,
         -0.097863076751481,
         0.147202394463988,
         0.00177446103284348,
         0.0685450888030017,
         -0.0105124210617655,
         0.0544539611105005,
         0.0578494521520204,
         -0.0296820491765649,
         -0.118738308584078,
         -0.0375506234709939,
         -0.0910832440670609,
         0.0435063682766338,
         0.105405333857132,
         0.126096993216036,
         -0.19700248208824,
         -0.0232612930883101,
         0.0642721728442059,
         0.0990624198740509,
         -0.0481965575364572,
         -0.0729234832576592,
         -0.0481965575364571,
         0.0990624198740508,
         0.0642721728442061,
         -0.0232612930883102,
         -0.197002482088239,
         0.126096993216036,
         0.105405333857132,
         0.0435063682766341,
         -0.0910832440670612,
         -0.037550623470994,
         -0.118738308584078,
         -0.0296820491765647,
         0.0578494521520202,
         0.0544539611105006,
         -0.0105124210617655,
         0.0685450888030017,
         0.00177446103284373,
         0.147202394463988,
         -0.0978630767514811,
         -0.0736035742551873,
         -0.0526485610728291,
         -0.0302410064015859,
         -0.00272939184636758,
         -0.0115061879682485,
         0.0564501317387565,
         0.0648741187298906,
         -0.0358017509743127,
         -0.0855224994943343,
         -0.0167277284963061,
         0.0640356674388678,
         0.0242162239018339,
         -0.0499276941727927,
         0.0152945818444884,
         0.144254234250267,
         -0.00587622803033231,
         0.149707719935366,
         -0.0296634290024797,
         -0.175698404870043,
         -0.0997377568251921,
         0.081120362194983,
         -0.0859025229777052,
         -0.0989704385355754,
         -0.0341231477810954,
         0.247372176122133,
         0.020855326417215,
         0.00535379891995555,
         -0.091724754779648,
         0.0631648110601118,
         -0.0884014443428653,
         -0.0176445099400819,
         0.0874465135293417,
         0.00541121674771778,
         -0.040611021836346,
         -0.0790997788021485,
         -0.00974413868187956,
         0.0659900607461053,
         -0.0420103422496098,
         0.117587833165784,
         0.038905308563818,
         -0.114278589805462,
         0.0654582116147154,
         -0.0487629145609362,
         0.162147424225059,
         0.0559485923414977,
         -0.128199940992693,
         -0.0277916613396498,
         -0.0726438893952768,
         0.0148154313285712,
         0.100043009990846,
         -0.0422145519241404},
        {0.131604165007335,
         -0.111473087864395,
         -0.082885188745984,
         0.062754111603044,
         0.0367759747770813,
         0.0384216544349089,
         0.0362754586524049,
         0.0752952680990112,
         -0.0308317337879362,
         -0.0681978364675126,
         0.0290489889043613,
         0.113920369935424,
         -0.274573523847119,
         0.0309975145892172,
         -0.0220835601697785,
         0.0735101445405949,
         -0.00787063092516474,
         -0.00108099009449631,
         0.139390257797977,
         0.0389880376777171,
         -0.106761527044015,
         -0.0927193233744847,
         0.0373931914316373,
         -0.0404172675806217,
         0.0252946862006383,
         -0.0307751537498428,
         -0.012914564018868,
         -0.0881961242624872,
         0.0720616993769944,
         -0.155439300218539,
         0.129715054545603,
         0.0727967699245223,
         -0.0286940357239362,
         0.0106110851535869,
         0.171295779085297,
         -0.0323220589290951,
         -0.123860870142081,
         -0.00798584794159291,
         -0.0883261575804183,
         -0.00865521042785259,
         -0.00163879152592817,
         0.0977892334163566,
         -0.0699212452829598,
         0.066488904306346,
         0.0526124070239149,
         -0.049180066047301,
         -0.162639346196775,
         0.0802152472367409,
         0.0436995984980967,
         0.178020182345248,
         -0.0610666269316489,
         0.0154605515721375,
         0.0520438010253727,
         -0.133946532933508,
         -0.114185666889707,
         0.0337100936145296,
         -0.0209975991594357,
         -0.0812585707310145,
         0.0723396453957296,
         -0.0697582205117133,
         0.129804724005291,
         -0.0471319394747103,
         -0.032689674407519,
         0.0999526910251692,
         0.0493895612082806,
         0.0320190894605892,
         0.0623864961246202,
         -0.0192079563732195,
         -0.00835721723938377,
         -0.0486222646158689,
         -0.0554167267788618,
         -0.0486222646158692,
         -0.00835721723938366,
         -0.0192079563732196,
         0.0623864961246202,
         0.0320190894605894,
         0.0493895612082805,
         0.099952691025169,
         -0.0326896744075188,
         -0.0471319394747104,
         0.129804724005291,
         -0.0697582205117132,
         0.0723396453957294,
         -0.0812585707310144,
         -0.0209975991594355,
         0.0337100936145294,
         -0.114185666889707,
         -0.133946532933508,
         0.0520438010253726,
         0.0154605515721375,
         -0.061066626931649,
         0.178020182345248,
         0.0436995984980966,
         0.0802152472367408,
         -0.162639346196775,
         -0.0491800660473009,
         0.0526124070239148,
         0.066488904306346,
         -0.06992124528296,
         0.0977892334163565,
         -0.00163879152592826,
         -0.00865521042785263,
         -0.0883261575804183,
         -0.00798584794159315,
         -0.123860870142081,
         -0.0323220589290952,
         0.171295779085297,
         0.0106110851535869,
         -0.0286940357239362,
         0.0727967699245222,
         0.129715054545603,
         -0.155439300218539,
         0.0720616993769942,
         -0.0881961242624875,
         -0.012914564018868,
         -0.0307751537498425,
         0.0252946862006381,
         -0.0404172675806215,
         0.0373931914316372,
         -0.0927193233744845,
         -0.106761527044015,
         0.0389880376777171,
         0.139390257797977,
         -0.00108099009449632,
         -0.00787063092516497,
         0.0735101445405952,
         -0.0220835601697785,
         0.0309975145892172,
         -0.27457352384712,
         0.113920369935424,
         0.0290489889043611,
         -0.0681978364675125,
         -0.0308317337879364,
         0.0752952680990111,
         0.036275458652405,
         0.038421654434909,
         0.036775974777081,
         0.0627541116030439,
         -0.082885188745984,
         -0.111473087864395,
         0.131604165007335},
        {0.0721625887210373,
         -0.0199519537384464,
         -0.00166109334981312,
         -0.0505495416327779,
         0.102448241873179,
         -0.110184366312895,
         0.0276880781781619,
         0.133527176188297,
         -0.021681716525589,
         0.0445431799802051,
         0.11256857939766,
         -0.127936535266659,
         -0.0567946328520386,
         -0.061993534936164,
         0.0231318572211042,
         -0.053754947944154,
         -0.062957391425525,
         0.169423162820893,
         -0.00832404039192239,
         -0.0381316629327702,
         -0.0023230440042448,
         0.0876436507410448,
         0.0375405212835164,
         -0.00915060751327944,
         -0.158213435503817,
         -0.0270685320750032,
         -0.130731518963909,
         0.0272971114761596,
         -0.00913417190991034,
         0.0132644431069933,
         0.0873749806835059,
         -0.0214461759215568,
         0.0992273388673622,
         0.093497715032711,
         0.0225190960619347,
         -0.172175403626561,
         0.141566808447914,
         0.0271738522565973,
         -0.111796592134435,
         -0.136076836973792,
         0.0749811610392001,
         -0.166155832067666,
         0.0259140901708131,
         0.0337396311330315,
         0.105125493076407,
         -0.164779214380251,
         0.0574350398954345,
         0.0351815857637793,
         -0.0205027531985689,
         0.10866555618005,
         0.096568365137216,
         -0.068908691412959,
         -0.0955308113127129,
         0.0143304020444952,
         0.045867787372486,
         -0.127813276047096,
         -0.110986460616447,
         0.0666374833768057,
         -0.0630806506450877,
         0.0463679758411087,
         0.00420706862038725,
         0.0801564745024133,
         -0.0350610128282651,
         0.00711517330844271,
         0.177629483585191,
         -0.0720669753857013,
         0.0865648491655178,
         -0.0222339982195321,
         0.0245738118518518,
         -0.0703372125985585,
         -0.00416518975479865,
         -0.0703372125985582,
         0.0245738118518518,
         -0.0222339982195321,
         0.0865648491655179,
         -0.0720669753857011,
         0.177629483585191,
         0.0071151733084429,
         -0.035061012828265,
         0.0801564745024133,
         0.00420706862038725,
         0.0463679758411088,
         -0.0630806506450876,
         0.0666374833768059,
         -0.110986460616447,
         -0.127813276047096,
         0.045867787372486,
         0.0143304020444949,
         -0.0955308113127128,
         -0.0689086914129589,
         0.096568365137216,
         0.10866555618005,
         -0.0205027531985691,
         0.0351815857637794,
         0.0574350398954347,
         -0.164779214380251,
         0.105125493076407,
         0.0337396311330313,
         0.025914090170813,
         -0.166155832067666,
         0.0749811610392004,
         -0.136076836973792,
         -0.111796592134435,
         0.0271738522565972,
         0.141566808447914,
         -0.172175403626561,
         0.0225190960619348,
         0.0934977150327111,
         0.0992273388673626,
         -0.0214461759215569,
         0.0873749806835058,
         0.0132644431069934,
         -0.00913417190991059,
         0.0272971114761598,
         -0.13073151896391,
         -0.0270685320750032,
         -0.158213435503817,
         -0.00915060751327923,
         0.0375405212835163,
         0.0876436507410448,
         -0.00232304400424482,
         -0.0381316629327703,
         -0.00832404039192254,
         0.169423162820893,
         -0.0629573914255251,
         -0.0537549479441539,
         0.0231318572211043,
         -0.061993534936164,
         -0.0567946328520386,
         -0.127936535266659,
         0.11256857939766,
         0.0445431799802053,
         -0.0216817165255891,
         0.133527176188297,
         0.0276880781781617,
         -0.110184366312895,
         0.102448241873179,
         -0.0505495416327781,
         -0.00166109334981291,
         -0.0199519537384461,
         0.0721625887210375},
        {0.058672997208943,
         -0.13882488625018,
         0.148501846303151,
         -0.0683499572619136,
         -0.0035943615140656,
         0.0589650634903877,
         0.0834541842738573,
         -0.160236282584917,
         -0.0472306272086211,
         0.0321264001966768,
         0.135472649221917,
         -0.219057383187258,
         0.0249117367563978,
         0.00974132418477309,
         -0.0290900014509311,
         0.0227009142944208,
         0.0845074429428107,
         0.0151380953922274,
         0.00559921081886766,
         0.070178994880202,
         -0.0763259575509094,
         -0.0547894253372598,
         -0.0452646315823987,
         0.0154354905650298,
         0.130518264979366,
         -0.053161101580574,
         0.0252691511453658,
         -0.0147846872748452,
         -0.145957113092438,
         0.0849006268325414,
         0.148941443629561,
         -0.0278960672935213,
         -0.0787497924630389,
         0.0437393171329,
         0.060900135477868,
         0.0617243457109471,
         0.0177925359541699,
         -0.23030820525322,
         0.00450432052048457,
         -0.0127746892611982,
         0.0213454868440354,
         0.0112411535739741,
         0.00666397912059005,
         -0.044469180093174,
         0.0931259611532637,
         -0.0553207601806799,
         0.0118825396751642,
         -0.015234776703427,
         0.132677923579472,
         -0.0395520220924274,
         0.101019744943815,
         -0.0727730066610441,
         -0.0480593572248435,
         0.030624346246369,
         -0.125549696856524,
         -0.00353386520888254,
         0.156060644431789,
         -0.0499239889732257,
         -0.131016075035564,
         0.0769486448141717,
         0.0682653285925182,
         -0.170483124552056,
         0.127459422691117,
         -0.037128187180298,
         0.0496493134119052,
         0.0300661074090711,
         -0.00261488028174379,
         0.0279194748489949,
         0.000144401938815794,
         -0.0615281516324879,
         -0.0252087223642655,
         -0.0615281516324877,
         0.000144401938815932,
         0.0279194748489949,
         -0.00261488028174377,
         0.030066107409071,
         0.0496493134119055,
         -0.0371281871802981,
         0.127459422691117,
         -0.170483124552056,
         0.068265328592518,
         0.0769486448141717,
         -0.131016075035564,
         -0.0499239889732255,
         0.156060644431789,
         -0.00353386520888265,
         -0.125549696856524,
         0.030624346246369,
         -0.0480593572248433,
         -0.0727730066610441,
         0.101019744943815,
         -0.0395520220924274,
         0.132677923579472,
         -0.0152347767034269,
         0.0118825396751643,
         -0.05532076018068,
         0.0931259611532637,
         -0.0444691800931738,
         0.0066639791205902,
         0.0112411535739742,
         0.0213454868440355,
         -0.0127746892611982,
         0.00450432052048435,
         -0.23030820525322,
         0.0177925359541697,
         0.0617243457109468,
         0.0609001354778683,
         0.0437393171328998,
         -0.078749792463039,
         -0.0278960672935215,
         0.148941443629561,
         0.0849006268325413,
         -0.145957113092438,
         -0.0147846872748451,
         0.0252691511453658,
         -0.0531611015805743,
         0.130518264979367,
         0.0154354905650298,
         -0.0452646315823985,
         -0.0547894253372598,
         -0.0763259575509096,
         0.070178994880202,
         0.00559921081886753,
         0.0151380953922274,
         0.0845074429428107,
         0.0227009142944208,
         -0.0290900014509312,
         0.00974132418477326,
         0.0249117367563978,
         -0.219057383187257,
         0.135472649221917,
         0.0321264001966768,
         -0.0472306272086212,
         -0.160236282584917,
         0.0834541842738574,
         0.0589650634903877,
         -0.00359436151406536,
         -0.0683499572619135,
         0.148501846303151,
         -0.13882488625018,
         0.058672997208943},
        {-0.0273671160972317,
         -0.0474280123768137,
         0.0550375668197565,
         0.019757561654289,
         -0.0231837528252424,
         0.153560681666778,
         -0.082948916464722,
         -0.0540758156328586,
         -0.154522432853676,
         0.217713787664109,
         0.0285274613276757,
         0.0528018359610006,
         -0.0539621811914447,
         -0.0563983411340493,
         -0.0649925216329682,
         0.140291413816155,
         -0.0924254251865847,
         0.0495785440387965,
         -0.155665338317795,
         -0.0366904368085583,
         0.11627253076785,
         0.0164561614423436,
         -0.068333884667595,
         -0.105281143451688,
         0.1300450793771,
         0.0432326941053743,
         0.0627051232323085,
         -0.0171525688165449,
         -0.0740800157434394,
         -0.0357563679577473,
         0.000107100813291828,
         0.127935096121592,
         0.0608714945000444,
         -0.0671782765983036,
         0.0823926645219914,
         -0.0611190685725222,
         0.06208594709811,
         0.0457891286223407,
         -0.0343557049019067,
         -0.0614581480214333,
         0.0372770903299476,
         -0.0863713444994936,
         -0.0373906779429015,
         0.129566540853071,
         -0.138443530056539,
         0.0462676671463692,
         -0.0804722866835253,
         0.0615717356343876,
         0.127010106336105,
         -0.0961777144767523,
         -0.0296720466289083,
         0.0914636739996871,
         0.0301487603408342,
         -0.0818060110006022,
         -0.0936864920329772,
         -0.0101398614778854,
         -0.115941027476263,
         0.152244552319215,
         -0.0294837277476987,
         0.0785531691094345,
         -0.106424048915808,
         -0.0348342434259351,
         0.000815793160837032,
         -0.0407766782089469,
         0.0753799571833318,
         -0.0485252996216439,
         0.081692423387648,
         0.0972098050755314,
         -0.132987326851652,
         0.0585691208552182,
         0.00457551701813415,
         0.0585691208552183,
         -0.132987326851652,
         0.0972098050755313,
         0.0816924233876481,
         -0.0485252996216436,
         0.0753799571833317,
         -0.0407766782089469,
         0.000815793160836889,
         -0.0348342434259351,
         -0.106424048915808,
         0.0785531691094346,
         -0.0294837277476989,
         0.152244552319215,
         -0.115941027476263,
         -0.0101398614778855,
         -0.0936864920329772,
         -0.0818060110006018,
         0.0301487603408342,
         0.0914636739996873,
         -0.0296720466289083,
         -0.0961777144767523,
         0.127010106336105,
         0.0615717356343876,
         -0.0804722866835253,
         0.0462676671463693,
         -0.138443530056539,
         0.129566540853071,
         -0.0373906779429015,
         -0.0863713444994936,
         0.0372770903299475,
         -0.0614581480214334,
         -0.0343557049019067,
         0.0457891286223407,
         0.0620859470981101,
         -0.0611190685725221,
         0.0823926645219912,
         -0.0671782765983038,
         0.0608714945000444,
         0.127935096121592,
         0.000107100813291931,
         -0.0357563679577473,
         -0.0740800157434393,
         -0.0171525688165446,
         0.0627051232323082,
         0.0432326941053747,
         0.1300450793771,
         -0.105281143451688,
         -0.0683338846675951,
         0.0164561614423437,
         0.11627253076785,
         -0.0366904368085583,
         -0.155665338317795,
         0.0495785440387964,
         -0.0924254251865847,
         0.140291413816155,
         -0.0649925216329682,
         -0.056398341134049,
         -0.0539621811914446,
         0.0528018359610003,
         0.028527461327676,
         0.217713787664109,
         -0.154522432853675,
         -0.0540758156328588,
         -0.082948916464722,
         0.153560681666778,
         -0.0231837528252424,
         0.0197575616542889,
         0.0550375668197566,
         -0.0474280123768135,
         -0.0273671160972317},
        {0.0589126691285699,
         -0.0559579435677584,
         -0.0700528046446262,
         0.067098079083815,
         0.190829934187767,
         0.0307213894166132,
         -0.165593380036622,
         0.0420917657407507,
         -0.00276035051273719,
         0.101255651465545,
         -0.0290473020480355,
         -0.0532499291217721,
         0.0233845620412378,
         -0.0148606329052781,
         0.0673240034751545,
         0.0325418750459175,
         0.0667543703898226,
         -0.0107756400985785,
         -0.112248876072392,
         -0.105606594249571,
         -0.0703627070329182,
         -0.0998935704810195,
         0.107454771838822,
         0.0959594401848,
         -0.0089525656495536,
         -0.0849662155779528,
         0.00400389433379409,
         0.135749109706575,
         -0.110705701992333,
         -0.050948513343176,
         -0.0315506672416266,
         0.118871807192722,
         -0.126223918665515,
         0.137080657236999,
         -0.0531788847496763,
         -0.0236703097665382,
         -0.0352465205240447,
         0.0373730277030298,
         0.028623589403714,
         0.235507657892159,
         -0.00367714497707336,
         -0.0630408052270073,
         -0.0824352026614631,
         0.00232788556625186,
         0.0540147406079871,
         0.0260925764872241,
         0.0643900646378285,
         -0.149395310253622,
         -0.120011357714731,
         0.0279653553206172,
         0.121911369474648,
         -0.0387933314859468,
         0.0164907161721272,
         -0.0561048544769678,
         -0.115944729354809,
         0.0451261528817729,
         0.0270804153236557,
         0.0301775692939236,
         -0.0316217116137226,
         -0.0303788495784595,
         -0.0135290853748541,
         0.0399040406195195,
         -0.120775882011922,
         0.0838265669532136,
         0.0374440720751256,
         0.0721916744207397,
         -0.0300074931615685,
         0.179367142345209,
         -0.08439919234472,
         0.0189940813657186,
         -0.172874700494778,
         0.0189940813657185,
         -0.0843991923447201,
         0.179367142345209,
         -0.0300074931615685,
         0.0721916744207398,
         0.0374440720751257,
         0.0838265669532135,
         -0.120775882011922,
         0.0399040406195196,
         -0.0135290853748541,
         -0.0303788495784593,
         -0.0316217116137224,
         0.0301775692939236,
         0.0270804153236557,
         0.0451261528817729,
         -0.11594472935481,
         -0.0561048544769679,
         0.0164907161721276,
         -0.0387933314859468,
         0.121911369474648,
         0.0279653553206171,
         -0.120011357714731,
         -0.149395310253623,
         0.0643900646378285,
         0.0260925764872241,
         0.0540147406079871,
         0.00232788556625196,
         -0.0824352026614632,
         -0.0630408052270073,
         -0.00367714497707318,
         0.235507657892159,
         0.0286235894037141,
         0.0373730277030297,
         -0.0352465205240445,
         -0.0236703097665386,
         -0.0531788847496766,
         0.137080657236999,
         -0.126223918665515,
         0.118871807192722,
         -0.0315506672416266,
         -0.0509485133431761,
         -0.110705701992333,
         0.135749109706575,
         0.00400389433379392,
         -0.084966215577953,
         -0.00895256564955352,
         0.0959594401848001,
         0.107454771838823,
         -0.0998935704810193,
         -0.0703627070329182,
         -0.105606594249571,
         -0.112248876072391,
         -0.0107756400985784,
         0.0667543703898225,
         0.0325418750459175,
         0.0673240034751544,
         -0.0148606329052781,
         0.0233845620412379,
         -0.0532499291217724,
         -0.0290473020480354,
         0.101255651465545,
         -0.00276035051273745,
         0.0420917657407506,
         -0.165593380036622,
         0.0307213894166132,
         0.190829934187767,
         0.067098079083815,
         -0.0700528046446263,
         -0.0559579435677585,
         0.0589126691285699},
        {0.122685473713052,
         0.102953693146476,
         -0.0586982991004917,
         -0.166940867759036,
         -0.0816560542153893,
         0.0546176848654802,
         -0.0759153237965666,
         -0.1460013108643,
         0.150081925099312,
         0.0927742664562907,
         -0.108217458781831,
         0.00658858081601997,
         -0.0210565957472411,
         0.062783926217247,
         -0.11080622053771,
         0.0532860599558185,
         0.095534801083035,
         0.0673811377391465,
         0.0673302658113119,
         -0.060734870958582,
         0.0796069989567245,
         0.13288319624324,
         -0.0159597896124285,
         -0.041017945503548,
         -0.0824166864619751,
         -0.119086586764055,
         0.0556026613282499,
         0.0611927292295251,
         -0.00857793177594403,
         -0.062112709730527,
         -0.00566860031501821,
         0.0353031278382034,
         0.00697421423377292,
         -0.125360801779269,
         -0.0232390223428218,
         0.0658782994172341,
         0.014774374182161,
         -0.010183069009686,
         -0.117407767831676,
         0.00942847261761594,
         0.0443321841071934,
         0.00142161871535162,
         -0.119072646518034,
         0.0248219526060355,
         0.211672401989696,
         -0.117421708077697,
         -0.0705757554285803,
         0.065311989793225,
         -0.0840815651483332,
         0.0119331416262456,
         0.0866164384533086,
         0.109164808881757,
         0.00817610402106923,
         0.00683633549143317,
         0.087773240308491,
         0.0779643790552313,
         -0.0414995702444202,
         -0.112824496555797,
         0.0241590028438238,
         0.0783360722269635,
         -0.123769604791548,
         -0.0101691287636658,
         0.151242369273996,
         0.0845659263491975,
         -0.0400106721685281,
         -0.0472445224929072,
         -0.0815767979022741,
         0.101782951045272,
         -0.0703161833505205,
         -0.0943727544457433,
         -0.0597794869620607,
         -0.0943727544457433,
         -0.0703161833505203,
         0.101782951045272,
         -0.081576797902274,
         -0.0472445224929073,
         -0.0400106721685281,
         0.0845659263491974,
         0.151242369273996,
         -0.0101691287636659,
         -0.123769604791548,
         0.0783360722269637,
         0.0241590028438238,
         -0.112824496555797,
         -0.0414995702444202,
         0.0779643790552312,
         0.0877732403084912,
         0.0068363354914331,
         0.00817610402106924,
         0.109164808881757,
         0.0866164384533085,
         0.0119331416262458,
         -0.0840815651483329,
         0.0653119897932248,
         -0.0705757554285803,
         -0.117421708077697,
         0.211672401989696,
         0.0248219526060354,
         -0.119072646518034,
         0.00142161871535164,
         0.0443321841071935,
         0.00942847261761607,
         -0.117407767831676,
         -0.0101830690096862,
         0.0147743741821609,
         0.0658782994172342,
         -0.0232390223428219,
         -0.125360801779269,
         0.00697421423377282,
         0.0353031278382034,
         -0.00566860031501812,
         -0.0621127097305265,
         -0.00857793177594408,
         0.061192729229525,
         0.0556026613282501,
         -0.119086586764055,
         -0.082416686461975,
         -0.041017945503548,
         -0.0159597896124284,
         0.13288319624324,
         0.0796069989567244,
         -0.0607348709585818,
         0.0673302658113121,
         0.0673811377391464,
         0.0955348010830351,
         0.0532860599558185,
         -0.11080622053771,
         0.062783926217247,
         -0.0210565957472412,
         0.00658858081602013,
         -0.108217458781831,
         0.0927742664562907,
         0.150081925099312,
         -0.1460013108643,
         -0.0759153237965667,
         0.0546176848654803,
         -0.0816560542153893,
         -0.166940867759036,
         -0.0586982991004917,
         0.102953693146476,
         0.122685473713052},
        {-0.122930456391146,
         -0.0958586280755458,
         0.172933055993561,
         0.0458560284731311,
         -0.0302274615894814,
         0.000858751942541935,
         0.125227337722486,
         -0.0431291060767134,
         -0.13066270185939,
         -0.0404206643362272,
         0.0634390568906452,
         0.0158935014059676,
         0.0435978980945334,
         0.202794189295226,
         -0.0873752489101225,
         -0.0829993692002026,
         -0.0581500707178002,
         -0.0433012377716052,
         0.0368466804041433,
         -0.108615281166423,
         -0.0639514465393218,
         0.0998097664488569,
         0.0953220116851465,
         -0.0735985336681078,
         0.00146941034565676,
         0.0771725176001916,
         -0.140968788735453,
         0.0912789408115529,
         -0.0137492089667448,
         -0.0668248023935169,
         -0.0403476398240036,
         0.0104989506962146,
         -0.0442210006715246,
         -0.0176043998882477,
         -0.0132459986998854,
         0.0535633074699794,
         0.0607896705852158,
         0.138220871811203,
         -0.108135301685574,
         0.0997490439124573,
         0.0530872379254899,
         0.0284686085020794,
         -0.186312811661429,
         -0.0156597454191872,
         0.0466225295045695,
         0.155350027576047,
         -0.0658961010083819,
         0.0334765298234816,
         -0.0767080996301985,
         0.0094420690495657,
         0.00777463108013191,
         -0.0716538791990471,
         -0.0448251448356972,
         -0.0422820445410476,
         0.137983990813362,
         -0.0310484295936826,
         -0.0575394123146857,
         -0.0907453994907843,
         -0.0112081397181505,
         0.172322397590446,
         0.093910848595425,
         -0.125264457450418,
         -0.0832362501980432,
         -0.0102883768182311,
         0.10908137170535,
         0.024157478095108,
         -0.0909435291948915,
         0.0374173414528439,
         -0.0382389736674537,
         0.0589615518789517,
         0.0647905367268041,
         0.0589615518789518,
         -0.0382389736674539,
         0.037417341452844,
         -0.0909435291948915,
         0.0241574780951079,
         0.10908137170535,
         -0.0102883768182313,
         -0.0832362501980432,
         -0.125264457450418,
         0.0939108485954252,
         0.172322397590446,
         -0.0112081397181505,
         -0.0907453994907844,
         -0.0575394123146856,
         -0.0310484295936826,
         0.137983990813362,
         -0.0422820445410473,
         -0.0448251448356973,
         -0.0716538791990472,
         0.00777463108013178,
         0.00944206904956583,
         -0.0767080996301985,
         0.0334765298234816,
         -0.065896101008382,
         0.155350027576047,
         0.0466225295045693,
         -0.0156597454191871,
         -0.186312811661429,
         0.0284686085020794,
         0.0530872379254898,
         0.0997490439124576,
         -0.108135301685574,
         0.138220871811203,
         0.0607896705852157,
         0.0535633074699795,
         -0.0132459986998854,
         -0.0176043998882479,
         -0.0442210006715245,
         0.0104989506962148,
         -0.0403476398240036,
         -0.0668248023935167,
         -0.0137492089667446,
         0.0912789408115527,
         -0.140968788735454,
         0.0771725176001916,
         0.00146941034565674,
         -0.0735985336681076,
         0.0953220116851467,
         0.0998097664488569,
         -0.0639514465393215,
         -0.108615281166423,
         0.0368466804041435,
         -0.0433012377716051,
         -0.0581500707178006,
         -0.0829993692002027,
         -0.0873752489101225,
         0.202794189295226,
         0.0435978980945334,
         0.0158935014059673,
         0.0634390568906453,
         -0.0404206643362271,
         -0.130662701859389,
         -0.0431291060767131,
         0.125227337722485,
         0.000858751942541844,
         -0.0302274615894815,
         0.0458560284731311,
         0.172933055993561,
         -0.0958586280755458,
         -0.122930456391146},
        {-0.0409504722564761,
         0.0471424935890572,
         0.00296518054235747,
         -0.00915720187493805,
         -0.0412136667899855,
         -0.013916780693751,
         0.00798795389467957,
         0.000651081369460487,
         0.0103005187819333,
         -0.00913127080167447,
         0.00531791352488853,
         0.0124150483954281,
         0.0232175103361595,
         -0.00464215064009673,
         -0.158727107100121,
         0.110908850626272,
         0.155249492773664,
         -0.0119026146113285,
         -0.113066544476165,
         0.166775296189145,
         -0.120919478759063,
         -0.00853011524111261,
         0.0143987068458394,
         -0.0123760326077282,
         -0.147370458902012,
         0.134573847885568,
         -0.0402245933996984,
         0.177358429469427,
         -0.142451749594617,
         -0.197745252481331,
         0.00797177461647618,
         0.111262464641981,
         -0.00139074020390156,
         0.046257484243697,
         0.00686747349718125,
         -0.0241080556625848,
         0.00939347038723264,
         0.0356282862104857,
         -0.00758939055304844,
         -0.136831750446057,
         -0.0285528055391864,
         0.103214800054553,
         0.138494392189988,
         -0.100232237834057,
         -0.0267522194984626,
         -0.0115099348574696,
         0.0255702433186909,
         0.0268901637952551,
         -0.00128667615897486,
         0.122536213662458,
         -0.156882096235071,
         -0.158865754685482,
         0.00779411716197617,
         0.131355017152778,
         -0.111644848705409,
         0.154145191654369,
         0.0217958145654031,
         -0.0187703988287011,
         0.0135193495147232,
         0.136418858750618,
         -0.135743095865826,
         0.0395488305149065,
         -0.0363642842896221,
         0.00300747510729636,
         0.0300807113122386,
         -0.0317017187367356,
         -0.0214134305019754,
         -0.00201529824502596,
         -0.031604705470809,
         0.00514025607038858,
         0.0694302199019229,
         0.00514025607038855,
         -0.0316047054708091,
         -0.00201529824502575,
         -0.0214134305019755,
         -0.0317017187367356,
         0.0300807113122385,
         0.00300747510729637,
         -0.036364284289622,
         0.0395488305149067,
         -0.135743095865826,
         0.136418858750618,
         0.0135193495147231,
         -0.0187703988287011,
         0.0217958145654032,
         0.154145191654369,
         -0.111644848705409,
         0.131355017152778,
         0.00779411716197605,
         -0.158865754685482,
         -0.15688209623507,
         0.122536213662458,
         -0.00128667615897474,
         0.026890163795255,
         0.0255702433186908,
         -0.0115099348574695,
         -0.0267522194984623,
         -0.100232237834057,
         0.138494392189989,
         0.103214800054552,
         -0.0285528055391864,
         -0.136831750446058,
         -0.00758939055304855,
         0.0356282862104856,
         0.00939347038723262,
         -0.024108055662585,
         0.00686747349718113,
         0.0462574842436968,
         -0.00139074020390154,
         0.111262464641981,
         0.00797177461647613,
         -0.197745252481331,
         -0.142451749594617,
         0.177358429469426,
         -0.0402245933996988,
         0.134573847885568,
         -0.147370458902012,
         -0.0123760326077282,
         0.0143987068458397,
         -0.00853011524111245,
         -0.120919478759063,
         0.166775296189145,
         -0.113066544476165,
         -0.0119026146113284,
         0.155249492773664,
         0.110908850626272,
         -0.158727107100121,
         -0.00464215064009676,
         0.0232175103361594,
         0.0124150483954282,
         0.0053179135248886,
         -0.00913127080167453,
         0.0103005187819332,
         0.000651081369460541,
         0.00798795389467959,
         -0.0139167806937512,
         -0.0412136667899855,
         -0.00915720187493819,
         0.00296518054235739,
         0.0471424935890571,
         -0.0409504722564764},
        {0.17396807898217,
         -0.0855711993876581,
         0.10511235194415,
         -0.193509231538661,
         0.0995939798255307,
         -0.115866187356345,
         0.101843406918473,
         -0.0052617573630883,
         0.0160155927752847,
         0.0756502318449039,
         -0.157245287541515,
         -0.0518702655668605,
         0.0351474741262058,
         0.0477299045985492,
         0.0519662239599202,
         0.143120358370704,
         -0.113260034785559,
         0.00805172444835061,
         0.00718967459340074,
         0.0168298500656636,
         -0.164153734489743,
         0.0782331534649785,
         -0.0311630401342168,
         -0.0496469906652162,
         0.0402886386836693,
         -0.033192915773088,
         -0.0017116146041154,
         0.0932449202739569,
         0.065711981871674,
         0.061288317944775,
         -0.102662972651871,
         0.00180351665399133,
         -0.033060396822741,
         -0.0129578931716926,
         -0.0266865901205719,
         -0.0854641572905642,
         -0.110410289780121,
         0.0786583069613563,
         0.101417098532729,
         -0.0509223381570439,
         0.0671528849141213,
         0.109958742747315,
         -0.000624225187362376,
         0.0500985376980224,
         -0.118322720457663,
         0.0688484079470035,
         -0.227210165359458,
         -0.0156063215697146,
         -0.0617526850364219,
         0.044358810839934,
         0.0341166656371426,
         0.0134094402044988,
         0.0643295623708766,
         0.110669325100357,
         -0.000557642534848844,
         -0.0372836522542598,
         0.0428947912544555,
         0.0291702277968047,
         -0.12784664809816,
         -0.0510424740958657,
         -0.0584729088471005,
         0.111226997547082,
         0.0639044088744987,
         -0.0867345268270687,
         0.103841982407645,
         0.111334039644175,
         -0.0441406653735978,
         -0.0834655818013919,
         -0.0137386353078169,
         0.00974724748123262,
         -0.0865111093541936,
         0.00974724748123258,
         -0.0137386353078166,
         -0.083465581801392,
         -0.0441406653735979,
         0.111334039644175,
         0.103841982407645,
         -0.0867345268270684,
         0.0639044088744989,
         0.111226997547082,
         -0.0584729088471003,
         -0.0510424740958657,
         -0.12784664809816,
         0.0291702277968048,
         0.0428947912544555,
         -0.03728365225426,
         -0.000557642534848661,
         0.110669325100356,
         0.0643295623708768,
         0.0134094402044986,
         0.0341166656371425,
         0.0443588108399339,
         -0.0617526850364218,
         -0.0156063215697151,
         -0.227210165359458,
         0.0688484079470035,
         -0.118322720457663,
         0.0500985376980222,
         -0.000624225187362652,
         0.109958742747315,
         0.0671528849141211,
         -0.050922338157044,
         0.101417098532729,
         0.0786583069613562,
         -0.110410289780121,
         -0.0854641572905643,
         -0.0266865901205718,
         -0.0129578931716926,
         -0.0330603968227409,
         0.00180351665399123,
         -0.102662972651871,
         0.061288317944775,
         0.065711981871674,
         0.0932449202739567,
         -0.00171161460411562,
         -0.0331929157730881,
         0.0402886386836695,
         -0.0496469906652165,
         -0.0311630401342166,
         0.0782331534649784,
         -0.164153734489743,
         0.0168298500656634,
         0.00718967459340055,
         0.00805172444835059,
         -0.113260034785559,
         0.143120358370704,
         0.0519662239599203,
         0.0477299045985491,
         0.035147474126206,
         -0.0518702655668606,
         -0.157245287541515,
         0.0756502318449038,
         0.0160155927752846,
         -0.00526175736308842,
         0.101843406918473,
         -0.115866187356345,
         0.0995939798255307,
         -0.193509231538661,
         0.105112351944149,
         -0.085571199387658,
         0.17396807898217},
        {-0.0493742998219006,
         0.0619037037683187,
         0.08561383300388,
         -0.0981432369502981,
         0.0381916144654454,
         -0.0801560087695102,
         -0.0199393094642537,
         0.0179805166948379,
         -0.0234383409292076,
         0.141520887343759,
         0.0833114172649469,
         -0.0457830116118109,
         0.0118458941687646,
         -0.128637072323656,
         -0.0344540302647636,
         0.0178759815551543,
         0.0489264245857214,
         -0.0543032157130269,
         0.122724576939406,
         0.0213668018604273,
         0.0690786559977837,
         -0.0517973865898605,
         0.145040623763707,
         -0.212055951852392,
         -0.0151095546906988,
         -0.0521895124307736,
         -0.0463448709436186,
         -0.0139796439749632,
         -0.0229869023463649,
         0.00260170077014802,
         0.0571609548166257,
         -0.0460199466390254,
         0.12621754890236,
         0.048764394364915,
         -0.0790964307680707,
         0.00131255610543756,
         -0.0449660296791424,
         0.0275683054122016,
         -0.0317386006212378,
         0.118981109198578,
         -0.266565459961365,
         0.148722409598666,
         0.011912708159353,
         0.108299571932868,
         -0.0243714588808557,
         -0.0958408212113647,
         0.00954347842983132,
         0.135671642603434,
         0.0285417540898922,
         -0.0329074977379247,
         0.0383028610910787,
         -0.152520774284439,
         0.0902709605886526,
         -0.166102227332867,
         0.0205975924436376,
         -0.0873309609989752,
         0.113972878664533,
         -0.0215069646007354,
         0.0904743739728858,
         0.0205673789250684,
         -0.065893033983778,
         0.0916705260023282,
         0.0109052685865907,
         -0.0900463906425011,
         -0.00574511374405862,
         0.0310793783394473,
         -0.0885505244691447,
         0.0155067518256329,
         -0.00708195959419727,
         0.116421423036974,
         -0.0754719154465085,
         0.116421423036974,
         -0.00708195959419703,
         0.0155067518256329,
         -0.0885505244691449,
         0.0310793783394473,
         -0.00574511374405865,
         -0.0900463906425009,
         0.0109052685865905,
         0.0916705260023285,
         -0.065893033983778,
         0.0205673789250685,
         0.0904743739728859,
         -0.0215069646007352,
         0.113972878664533,
         -0.0873309609989751,
         0.0205975924436376,
         -0.166102227332867,
         0.0902709605886526,
         -0.152520774284439,
         0.0383028610910786,
         -0.0329074977379248,
         0.0285417540898922,
         0.135671642603434,
         0.00954347842983131,
         -0.0958408212113648,
         -0.0243714588808559,
         0.108299571932867,
         0.011912708159353,
         0.148722409598666,
         -0.266565459961365,
         0.118981109198578,
         -0.0317386006212379,
         0.0275683054122013,
         -0.0449660296791423,
         0.00131255610543774,
         -0.0790964307680708,
         0.0487643943649152,
         0.12621754890236,
         -0.0460199466390254,
         0.0571609548166258,
         0.00260170077014799,
         -0.0229869023463649,
         -0.013979643974963,
         -0.0463448709436189,
         -0.0521895124307739,
         -0.0151095546906987,
         -0.212055951852391,
         0.145040623763707,
         -0.0517973865898604,
         0.0690786559977836,
         0.0213668018604271,
         0.122724576939406,
         -0.054303215713027,
         0.0489264245857213,
         0.0178759815551545,
         -0.0344540302647637,
         -0.128637072323656,
         0.0118458941687644,
         -0.0457830116118106,
         0.0833114172649467,
         0.141520887343759,
         -0.0234383409292076,
         0.0179805166948379,
         -0.0199393094642538,
         -0.0801560087695101,
         0.0381916144654453,
         -0.098143236950298,
         0.08561383300388,
         0.0619037037683185,
         -0.0493742998219006},
        {-0.16646805042215,
         0.0559980006130003,
         0.0795802557163028,
         0.0308897940928476,
         0.142647520665459,
         -0.0859506766874531,
         -0.112694844591007,
         0.0237796645161279,
         -0.0174092435449775,
         0.0992142940431367,
         0.0695428256695843,
         0.105657091842691,
         -0.00873186709012446,
         -0.0430357099853602,
         -0.110479073851859,
         0.0279739575546353,
         -0.0999342131477475,
         0.0251759394406137,
         -0.0753078239979721,
         0.00697259289481842,
         -0.106584403574917,
         0.0825412663865971,
         0.106915891257897,
         0.0843893993533918,
         -0.00638671775497732,
         -0.108295869398556,
         0.017340090491119,
         -0.115239325663045,
         0.028356409502342,
         0.0932817562791047,
         -0.0836995224587502,
         0.0640749800465326,
         0.0714084162715293,
         -0.0457127967772881,
         0.0928664181894621,
         0.0614435650539136,
         -0.072061135333603,
         -0.0862139613208193,
         0.0832939792850425,
         -0.109478570322979,
         0.0310975611566315,
         0.121199639195574,
         -0.0659291142530794,
         -0.133527903215363,
         0.158529793328876,
         0.040927224139566,
         -0.0187692971368427,
         0.144310123419427,
         -0.155609811293099,
         0.0608514942100095,
         -0.00216690766947678,
         -0.00342570708468317,
         -0.118236745704786,
         -0.0547962641380121,
         -0.063669436872825,
         0.0766317275004648,
         -0.0203702542152716,
         0.10913887356554,
         -0.0709088488055219,
         1.62967838268305e-05,
         0.0264908189003969,
         -0.043847206175343,
         0.0505184820026298,
         -0.117141325636437,
         -0.0990046349740479,
         -0.0384016417344298,
         0.0199647110415639,
         0.075133774670872,
         0.16735895278293,
         0.0350056024235481,
         -0.1110302794552,
         0.035005602423548,
         0.16735895278293,
         0.0751337746708721,
         0.0199647110415639,
         -0.0384016417344298,
         -0.099004634974048,
         -0.117141325636437,
         0.05051848200263,
         -0.043847206175343,
         0.026490818900397,
         1.62967838266807e-05,
         -0.0709088488055217,
         0.10913887356554,
         -0.0203702542152718,
         0.0766317275004648,
         -0.063669436872825,
         -0.0547962641380121,
         -0.118236745704786,
         -0.003425707084683,
         -0.00216690766947683,
         0.0608514942100093,
         -0.155609811293099,
         0.144310123419427,
         -0.0187692971368427,
         0.0409272241395659,
         0.158529793328876,
         -0.133527903215362,
         -0.0659291142530796,
         0.121199639195574,
         0.0310975611566317,
         -0.109478570322979,
         0.0832939792850425,
         -0.0862139613208193,
         -0.0720611353336029,
         0.0614435650539134,
         0.0928664181894622,
         -0.0457127967772881,
         0.0714084162715292,
         0.0640749800465327,
         -0.0836995224587503,
         0.0932817562791047,
         0.028356409502342,
         -0.115239325663045,
         0.0173400904911193,
         -0.108295869398556,
         -0.0063867177549771,
         0.0843893993533916,
         0.106915891257897,
         0.0825412663865968,
         -0.106584403574918,
         0.00697259289481843,
         -0.0753078239979723,
         0.0251759394406136,
         -0.0999342131477477,
         0.0279739575546354,
         -0.110479073851859,
         -0.0430357099853603,
         -0.00873186709012439,
         0.105657091842691,
         0.0695428256695842,
         0.0992142940431368,
         -0.0174092435449777,
         0.023779664516128,
         -0.112694844591007,
         -0.0859506766874529,
         0.142647520665459,
         0.0308897940928476,
         0.0795802557163026,
         0.0559980006130004,
         -0.166468050422151},
        {0.0497283930718517,
         0.0435571186778521,
         -0.0564722800059268,
         -0.0368132317437768,
         -0.157220861522915,
         -0.000370798003071769,
         0.114034540848135,
         0.163869331734379,
         -0.10702625372538,
         0.0298049446210224,
         0.0111921864422942,
         -0.0260541166926491,
         -0.0348664628214968,
         0.0273059231790603,
         -0.0129989199501663,
         -0.0690563083490398,
         -0.0908637259712252,
         0.186389042619968,
         -0.0456530397056543,
         0.114945546818683,
         0.0149693915251717,
         -0.0403329184968524,
         -0.061242910368592,
         0.00129528634432563,
         -0.0326726872663017,
         0.0145528087403064,
         0.00572295780818422,
         0.0133836958328064,
         -0.0302988400832845,
         0.173245764814722,
         -0.160575343954879,
         0.225740646859661,
         -0.0817751540050416,
         0.0487462730177973,
         -0.0414946888340454,
         0.122885066956448,
         -0.0722761915419212,
         -0.0408873500094513,
         -0.107811415612085,
         0.0706085160106788,
         -0.10377890882432,
         0.0400632442813509,
         0.0112190913202194,
         0.0309176609162448,
         0.0623409459555337,
         -0.104477698191998,
         0.0327980036267242,
         0.0219513014934219,
         0.0863578196660029,
         0.0262848792813133,
         -0.0517221194331702,
         -0.0165333257572272,
         0.0139227228551162,
         0.0526613268284088,
         0.0426461127073035,
         0.0282169291496087,
         -0.123165615234455,
         0.0546054212489096,
         -0.145134771813483,
         -0.024170390742697,
         0.0626685003640514,
         -0.0442210674295386,
         0.0144771543677154,
         0.123029424811527,
         -0.0563279221508479,
         0.0351068808490575,
         -0.145221144332509,
         -0.0474773960425349,
         -0.0219652793729896,
         0.18569025325229,
         -0.165975970908617,
         0.18569025325229,
         -0.0219652793729897,
         -0.0474773960425348,
         -0.145221144332509,
         0.0351068808490574,
         -0.0563279221508478,
         0.123029424811527,
         0.0144771543677154,
         -0.0442210674295387,
         0.0626685003640516,
         -0.0241703907426969,
         -0.145134771813483,
         0.0546054212489097,
         -0.123165615234455,
         0.0282169291496086,
         0.0426461127073038,
         0.0526613268284088,
         0.0139227228551164,
         -0.0165333257572269,
         -0.0517221194331702,
         0.0262848792813134,
         0.0863578196660028,
         0.0219513014934219,
         0.0327980036267243,
         -0.104477698191998,
         0.0623409459555337,
         0.0309176609162447,
         0.0112190913202193,
         0.0400632442813509,
         -0.10377890882432,
         0.070608516010679,
         -0.107811415612085,
         -0.0408873500094512,
         -0.0722761915419211,
         0.122885066956448,
         -0.0414946888340456,
         0.0487462730177975,
         -0.0817751540050418,
         0.22574064685966,
         -0.160575343954879,
         0.173245764814722,
         -0.0302988400832846,
         0.0133836958328064,
         0.00572295780818404,
         0.0145528087403064,
         -0.0326726872663014,
         0.00129528634432538,
         -0.0612429103685922,
         -0.0403329184968524,
         0.0149693915251717,
         0.114945546818683,
         -0.0456530397056545,
         0.186389042619968,
         -0.0908637259712253,
         -0.0690563083490396,
         -0.0129989199501666,
         0.0273059231790604,
         -0.034866462821497,
         -0.0260541166926492,
         0.0111921864422944,
         0.0298049446210224,
         -0.107026253725381,
         0.163869331734379,
         0.114034540848135,
         -0.000370798003071557,
         -0.157220861522915,
         -0.0368132317437766,
         -0.0564722800059267,
         0.0435571186778521,
         0.0497283930718518}};

    m_array_all = {
        {{0, 0, 0, 0, 0, 0}},
        {{0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1}},
        {{0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1}},
        {{0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}},
        {{-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}}};

}
