/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_ver2_order2.h"

GtinvDataVer2Order2::GtinvDataVer2Order2(){

    set_gtinv_info();
}

GtinvDataVer2Order2::~GtinvDataVer2Order2(){}

const vector2i& GtinvDataVer2Order2::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataVer2Order2::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataVer2Order2::get_coeffs() const{ return coeffs_all; }

void GtinvDataVer2Order2::set_gtinv_info(){

    l_array_all = {
        {0, 0},
        {1, 1},
        {2, 2},
        {3, 3},
        {4, 4},
        {5, 5},
        {6, 6},
        {7, 7},
        {8, 8},
        {9, 9},
        {10, 10},
        {11, 11},
        {12, 12},
        {13, 13},
        {14, 14},
        {15, 15},
        {16, 16},
        {17, 17},
        {18, 18},
        {19, 19},
        {20, 20},
        {21, 21},
        {22, 22},
        {23, 23},
        {24, 24},
        {25, 25},
        {26, 26},
        {27, 27},
        {28, 28},
        {29, 29},
        {30, 30}
    };

    coeffs_all = {
        {1.0},
        {0.5773502691896256,
         -0.577350269189626,
         0.5773502691896256},
        {0.4472135954999581,
         -0.44721359549995765,
         0.4472135954999579,
         -0.44721359549995787,
         0.44721359549995787},
        {0.377964473009227,
         -0.3779644730092274,
         0.37796447300922725,
         -0.37796447300922725,
         0.37796447300922725,
         -0.3779644730092273,
         0.3779644730092273},
        {0.33333333333333354,
         -0.3333333333333329,
         0.3333333333333333,
         -0.3333333333333333,
         0.3333333333333333,
         -0.33333333333333326,
         0.33333333333333326,
         -0.33333333333333326,
         0.33333333333333326},
        {0.30151134457776363,
         -0.30151134457776363,
         0.30151134457776363,
         -0.30151134457776363,
         0.30151134457776363,
         -0.30151134457776363,
         0.30151134457776363,
         -0.30151134457776363,
         0.30151134457776363,
         -0.3015113445777637,
         0.3015113445777637},
        {0.27735009811261435,
         -0.2773500981126149,
         0.27735009811261463,
         -0.27735009811261463,
         0.27735009811261463,
         -0.2773500981126146,
         0.2773500981126146,
         -0.2773500981126146,
         0.2773500981126146,
         -0.2773500981126146,
         0.2773500981126146,
         -0.2773500981126146,
         0.2773500981126146},
        {0.25819888974716115,
         -0.2581988897471613,
         0.2581988897471612,
         -0.2581988897471612,
         0.25819888974716115,
         -0.25819888974716115,
         0.25819888974716115,
         -0.2581988897471612,
         0.2581988897471612,
         -0.2581988897471612,
         0.2581988897471612,
         -0.25819888974716115,
         0.25819888974716115,
         -0.2581988897471611,
         0.2581988897471611},
        {0.24253562503633302,
         -0.24253562503633286,
         0.24253562503633297,
         -0.24253562503633297,
         0.24253562503633297,
         -0.24253562503633297,
         0.24253562503633297,
         -0.24253562503633297,
         0.24253562503633302,
         -0.24253562503633302,
         0.24253562503633302,
         -0.24253562503633302,
         0.24253562503633302,
         -0.24253562503633302,
         0.24253562503633302,
         -0.24253562503633302,
         0.24253562503633302},
        {0.2294157338705618,
         -0.2294157338705619,
         0.2294157338705618,
         -0.2294157338705618,
         0.2294157338705618,
         -0.2294157338705618,
         0.2294157338705618,
         -0.2294157338705618,
         0.2294157338705618,
         -0.2294157338705618,
         0.2294157338705618,
         -0.2294157338705618,
         0.2294157338705618,
         -0.22941573387056174,
         0.22941573387056174,
         -0.22941573387056174,
         0.22941573387056174,
         -0.22941573387056174,
         0.22941573387056174},
        {0.21821789023599228,
         -0.21821789023599258,
         0.21821789023599236,
         -0.21821789023599236,
         0.21821789023599236,
         -0.21821789023599236,
         0.21821789023599236,
         -0.21821789023599236,
         0.21821789023599236,
         -0.21821789023599236,
         0.21821789023599236,
         -0.21821789023599236,
         0.21821789023599242,
         -0.21821789023599236,
         0.21821789023599242,
         -0.21821789023599242,
         0.21821789023599242,
         -0.21821789023599242,
         0.21821789023599242,
         -0.21821789023599242,
         0.21821789023599242},
        {0.2085144140570748,
         -0.20851441405707483,
         0.2085144140570748,
         -0.2085144140570748,
         0.2085144140570748,
         -0.20851441405707477,
         0.20851441405707474,
         -0.20851441405707474,
         0.20851441405707474,
         -0.20851441405707474,
         0.20851441405707474,
         -0.20851441405707477,
         0.2085144140570748,
         -0.2085144140570748,
         0.2085144140570748,
         -0.2085144140570748,
         0.20851441405707483,
         -0.20851441405707483,
         0.20851441405707485,
         -0.20851441405707485,
         0.20851441405707485,
         -0.20851441405707488,
         0.20851441405707488},
        {0.20000000000000012,
         -0.19999999999999996,
         0.2,
         -0.2,
         0.20000000000000004,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.2,
         0.2,
         -0.19999999999999998,
         0.19999999999999998,
         -0.19999999999999996,
         0.19999999999999996,
         -0.19999999999999996,
         0.19999999999999996,
         -0.19999999999999993,
         0.19999999999999993,
         -0.19999999999999993,
         0.19999999999999993,
         -0.19999999999999993,
         0.1999999999999999,
         -0.1999999999999999,
         0.1999999999999999},
        {0.19245008972987548,
         -0.19245008972987432,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987523,
         -0.19245008972987523,
         0.19245008972987526,
         -0.19245008972987526,
         0.19245008972987526,
         -0.19245008972987526,
         0.19245008972987526},
        {0.1856953381770519,
         -0.18569533817705175,
         0.1856953381770518,
         -0.1856953381770518,
         0.1856953381770518,
         -0.18569533817705178,
         0.1856953381770518,
         -0.18569533817705178,
         0.1856953381770518,
         -0.1856953381770518,
         0.1856953381770518,
         -0.1856953381770518,
         0.1856953381770518,
         -0.1856953381770518,
         0.1856953381770518,
         -0.1856953381770518,
         0.18569533817705183,
         -0.18569533817705183,
         0.18569533817705186,
         -0.18569533817705186,
         0.1856953381770519,
         -0.1856953381770519,
         0.1856953381770519,
         -0.18569533817705192,
         0.18569533817705192,
         -0.18569533817705194,
         0.18569533817705194,
         -0.18569533817705197,
         0.18569533817705197},
        {0.179605302026775,
         -0.17960530202677472,
         0.17960530202677497,
         -0.17960530202677497,
         0.17960530202677494,
         -0.1796053020267749,
         0.1796053020267749,
         -0.17960530202677494,
         0.17960530202677494,
         -0.1796053020267749,
         0.1796053020267749,
         -0.1796053020267749,
         0.1796053020267749,
         -0.17960530202677497,
         0.17960530202677497,
         -0.17960530202677497,
         0.17960530202677497,
         -0.17960530202677494,
         0.17960530202677494,
         -0.17960530202677494,
         0.1796053020267749,
         -0.1796053020267749,
         0.1796053020267749,
         -0.17960530202677488,
         0.17960530202677488,
         -0.17960530202677488,
         0.17960530202677488,
         -0.17960530202677488,
         0.17960530202677488,
         -0.17960530202677477,
         0.17960530202677477},
        {0.17407765595569785,
         -0.1740776559556979,
         0.1740776559556979,
         -0.1740776559556979,
         0.1740776559556979,
         -0.1740776559556979,
         0.1740776559556979,
         -0.1740776559556979,
         0.1740776559556979,
         -0.1740776559556979,
         0.1740776559556979,
         -0.1740776559556979,
         0.1740776559556979,
         -0.17407765595569785,
         0.17407765595569785,
         -0.17407765595569785,
         0.17407765595569785,
         -0.17407765595569785,
         0.17407765595569785,
         -0.17407765595569785,
         0.17407765595569785,
         -0.17407765595569782,
         0.17407765595569782,
         -0.17407765595569782,
         0.17407765595569782,
         -0.17407765595569782,
         0.17407765595569782,
         -0.17407765595569782,
         0.17407765595569782,
         -0.17407765595569782,
         0.17407765595569782,
         -0.17407765595569782,
         0.17407765595569782},
        {0.16903085094570322,
         -0.16903085094570325,
         0.1690308509457033,
         -0.16903085094570328,
         0.16903085094570328,
         -0.16903085094570328,
         0.16903085094570328,
         -0.16903085094570328,
         0.16903085094570328,
         -0.16903085094570328,
         0.16903085094570322,
         -0.16903085094570328,
         0.16903085094570328,
         -0.16903085094570328,
         0.16903085094570328,
         -0.1690308509457033,
         0.1690308509457033,
         -0.1690308509457033,
         0.1690308509457033,
         -0.1690308509457033,
         0.1690308509457033,
         -0.1690308509457033,
         0.1690308509457033,
         -0.1690308509457033,
         0.1690308509457033,
         -0.1690308509457033,
         0.1690308509457033,
         -0.1690308509457033,
         0.16903085094570333,
         -0.16903085094570333,
         0.16903085094570333,
         -0.16903085094570333,
         0.16903085094570336,
         -0.16903085094570333,
         0.16903085094570333},
        {0.1643989873053573,
         -0.16439898730535718,
         0.16439898730535724,
         -0.16439898730535726,
         0.16439898730535724,
         -0.16439898730535726,
         0.16439898730535724,
         -0.16439898730535726,
         0.16439898730535724,
         -0.16439898730535726,
         0.16439898730535724,
         -0.16439898730535726,
         0.16439898730535726,
         -0.16439898730535726,
         0.16439898730535726,
         -0.16439898730535726,
         0.16439898730535726,
         -0.16439898730535726,
         0.16439898730535732,
         -0.16439898730535732,
         0.16439898730535732,
         -0.16439898730535735,
         0.16439898730535735,
         -0.16439898730535735,
         0.16439898730535735,
         -0.16439898730535735,
         0.16439898730535737,
         -0.16439898730535735,
         0.16439898730535735,
         -0.16439898730535735,
         0.16439898730535735,
         -0.16439898730535732,
         0.16439898730535732,
         -0.16439898730535732,
         0.16439898730535732,
         -0.16439898730535726,
         0.16439898730535726},
        {0.16012815380508721,
         -0.1601281538050866,
         0.16012815380508705,
         -0.1601281538050871,
         0.1601281538050871,
         -0.1601281538050871,
         0.1601281538050871,
         -0.1601281538050871,
         0.1601281538050871,
         -0.1601281538050871,
         0.1601281538050871,
         -0.1601281538050871,
         0.1601281538050871,
         -0.16012815380508713,
         0.16012815380508713,
         -0.16012815380508713,
         0.16012815380508713,
         -0.16012815380508713,
         0.16012815380508713,
         -0.16012815380508713,
         0.16012815380508713,
         -0.16012815380508713,
         0.16012815380508713,
         -0.16012815380508716,
         0.16012815380508716,
         -0.16012815380508716,
         0.1601281538050872,
         -0.1601281538050872,
         0.1601281538050872,
         -0.1601281538050872,
         0.16012815380508716,
         -0.16012815380508716,
         0.16012815380508716,
         -0.16012815380508713,
         0.16012815380508713,
         -0.16012815380508713,
         0.16012815380508713,
         -0.1601281538050871,
         0.1601281538050871},
        {0.15617376188860604,
         -0.15617376188860632,
         0.15617376188860607,
         -0.15617376188860607,
         0.15617376188860607,
         -0.15617376188860607,
         0.15617376188860607,
         -0.15617376188860607,
         0.15617376188860607,
         -0.15617376188860613,
         0.15617376188860613,
         -0.15617376188860613,
         0.15617376188860613,
         -0.15617376188860613,
         0.15617376188860613,
         -0.15617376188860613,
         0.15617376188860613,
         -0.15617376188860613,
         0.15617376188860613,
         -0.15617376188860607,
         0.15617376188860607,
         -0.15617376188860607,
         0.15617376188860607,
         -0.15617376188860607,
         0.15617376188860604,
         -0.15617376188860604,
         0.15617376188860604,
         -0.15617376188860604,
         0.15617376188860604,
         -0.15617376188860604,
         0.15617376188860604,
         -0.15617376188860604,
         0.15617376188860604,
         -0.15617376188860604,
         0.15617376188860604,
         -0.15617376188860604,
         0.15617376188860607,
         -0.15617376188860607,
         0.15617376188860607,
         -0.15617376188860613,
         0.15617376188860613},
        {0.15249857033260467,
         -0.15249857033260517,
         0.1524985703326047,
         -0.1524985703326047,
         0.1524985703326047,
         -0.1524985703326047,
         0.1524985703326047,
         -0.1524985703326047,
         0.1524985703326047,
         -0.1524985703326047,
         0.15249857033260467,
         -0.15249857033260467,
         0.15249857033260467,
         -0.15249857033260467,
         0.15249857033260467,
         -0.15249857033260467,
         0.15249857033260467,
         -0.15249857033260467,
         0.15249857033260467,
         -0.15249857033260467,
         0.15249857033260467,
         -0.15249857033260467,
         0.15249857033260467,
         -0.15249857033260464,
         0.15249857033260464,
         -0.15249857033260464,
         0.15249857033260464,
         -0.15249857033260464,
         0.15249857033260464,
         -0.15249857033260464,
         0.15249857033260464,
         -0.15249857033260464,
         0.15249857033260464,
         -0.15249857033260464,
         0.15249857033260467,
         -0.15249857033260467,
         0.1524985703326047,
         -0.1524985703326047,
         0.1524985703326047,
         -0.15249857033260472,
         0.15249857033260472,
         -0.15249857033260472,
         0.15249857033260472},
        {0.14907119849998599,
         -0.14907119849998585,
         0.14907119849998596,
         -0.14907119849998596,
         0.14907119849998596,
         -0.14907119849998599,
         0.14907119849998599,
         -0.14907119849998599,
         0.14907119849998599,
         -0.14907119849998599,
         0.14907119849998599,
         -0.14907119849998599,
         0.14907119849998599,
         -0.14907119849998599,
         0.14907119849998599,
         -0.14907119849998599,
         0.14907119849998599,
         -0.14907119849998599,
         0.149071198499986,
         -0.149071198499986,
         0.149071198499986,
         -0.14907119849998604,
         0.14907119849998604,
         -0.14907119849998604,
         0.14907119849998604,
         -0.14907119849998604,
         0.14907119849998604,
         -0.14907119849998604,
         0.14907119849998604,
         -0.14907119849998604,
         0.14907119849998604,
         -0.14907119849998604,
         0.14907119849998604,
         -0.149071198499986,
         0.149071198499986,
         -0.149071198499986,
         0.149071198499986,
         -0.149071198499986,
         0.149071198499986,
         -0.14907119849998599,
         0.14907119849998599,
         -0.14907119849998596,
         0.14907119849998596,
         -0.14907119849998596,
         0.14907119849998596},
        {0.1458649914978946,
         -0.14586499149789445,
         0.14586499149789456,
         -0.14586499149789456,
         0.14586499149789456,
         -0.14586499149789456,
         0.14586499149789459,
         -0.14586499149789456,
         0.14586499149789459,
         -0.14586499149789459,
         0.14586499149789459,
         -0.14586499149789459,
         0.14586499149789459,
         -0.1458649914978946,
         0.1458649914978946,
         -0.1458649914978946,
         0.1458649914978946,
         -0.1458649914978946,
         0.1458649914978946,
         -0.1458649914978946,
         0.1458649914978946,
         -0.14586499149789459,
         0.14586499149789459,
         -0.1458649914978946,
         0.14586499149789459,
         -0.14586499149789459,
         0.14586499149789459,
         -0.14586499149789459,
         0.14586499149789459,
         -0.14586499149789459,
         0.14586499149789456,
         -0.14586499149789456,
         0.14586499149789456,
         -0.14586499149789456,
         0.14586499149789456,
         -0.14586499149789456,
         0.14586499149789453,
         -0.14586499149789453,
         0.14586499149789453,
         -0.14586499149789456,
         0.14586499149789456,
         -0.14586499149789456,
         0.14586499149789459,
         -0.14586499149789459,
         0.14586499149789459,
         -0.1458649914978946,
         0.1458649914978946},
        {0.1428571428571429,
         -0.14285714285714257,
         0.1428571428571428,
         -0.1428571428571428,
         0.1428571428571428,
         -0.1428571428571428,
         0.1428571428571428,
         -0.1428571428571428,
         0.1428571428571428,
         -0.14285714285714282,
         0.14285714285714282,
         -0.14285714285714282,
         0.14285714285714282,
         -0.14285714285714282,
         0.14285714285714282,
         -0.14285714285714282,
         0.14285714285714282,
         -0.14285714285714282,
         0.14285714285714282,
         -0.14285714285714282,
         0.14285714285714282,
         -0.14285714285714288,
         0.14285714285714288,
         -0.14285714285714288,
         0.14285714285714288,
         -0.14285714285714288,
         0.14285714285714288,
         -0.14285714285714288,
         0.14285714285714288,
         -0.14285714285714288,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429,
         -0.1428571428571429,
         0.1428571428571429},
        {0.14002800840280105,
         -0.1400280084028005,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.140028008402801,
         0.140028008402801,
         -0.14002800840280097,
         0.14002800840280097},
        {0.1373605639486891,
         -0.13736056394868912,
         0.13736056394868904,
         -0.13736056394868904,
         0.13736056394868904,
         -0.13736056394868904,
         0.13736056394868904,
         -0.13736056394868904,
         0.13736056394868904,
         -0.13736056394868904,
         0.13736056394868906,
         -0.13736056394868904,
         0.13736056394868906,
         -0.13736056394868906,
         0.13736056394868906,
         -0.13736056394868906,
         0.13736056394868906,
         -0.13736056394868912,
         0.13736056394868912,
         -0.13736056394868912,
         0.13736056394868912,
         -0.13736056394868912,
         0.13736056394868912,
         -0.13736056394868906,
         0.13736056394868906,
         -0.13736056394868906,
         0.13736056394868904,
         -0.13736056394868904,
         0.13736056394868904,
         -0.13736056394868904,
         0.13736056394868904,
         -0.13736056394868904,
         0.13736056394868904,
         -0.13736056394868904,
         0.13736056394868904,
         -0.13736056394868904,
         0.137360563948689,
         -0.137360563948689,
         0.137360563948689,
         -0.137360563948689,
         0.137360563948689,
         -0.13736056394868898,
         0.13736056394868898,
         -0.13736056394868898,
         0.13736056394868898,
         -0.13736056394868898,
         0.13736056394868898,
         -0.13736056394868898,
         0.13736056394868898,
         -0.13736056394868895,
         0.13736056394868895,
         -0.13736056394868895,
         0.13736056394868895},
        {0.13483997249264854,
         -0.13483997249264812,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264848,
         -0.13483997249264848,
         0.13483997249264845,
         -0.13483997249264845,
         0.13483997249264845,
         -0.13483997249264845,
         0.13483997249264842,
         -0.13483997249264842,
         0.13483997249264842,
         -0.13483997249264842,
         0.13483997249264842,
         -0.13483997249264842,
         0.1348399724926484,
         -0.1348399724926484,
         0.1348399724926484,
         -0.1348399724926484,
         0.13483997249264837,
         -0.13483997249264837,
         0.13483997249264837,
         -0.13483997249264837,
         0.13483997249264837,
         -0.13483997249264834,
         0.13483997249264834,
         -0.13483997249264834,
         0.13483997249264834,
         -0.13483997249264834,
         0.1348399724926483,
         -0.1348399724926483,
         0.1348399724926483},
        {0.13245323570650425,
         -0.13245323570650447,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.1324532357065043,
         0.1324532357065043,
         -0.13245323570650433,
         0.13245323570650433,
         -0.13245323570650433,
         0.13245323570650433,
         -0.13245323570650433,
         0.13245323570650436,
         -0.13245323570650436,
         0.13245323570650436,
         -0.13245323570650439,
         0.13245323570650439,
         -0.13245323570650439,
         0.13245323570650439,
         -0.13245323570650439,
         0.1324532357065044,
         -0.1324532357065044,
         0.1324532357065044,
         -0.1324532357065044,
         0.13245323570650447,
         -0.13245323570650447,
         0.13245323570650447,
         -0.13245323570650447,
         0.1324532357065045,
         -0.1324532357065045,
         0.1324532357065045,
         -0.1324532357065045,
         0.13245323570650452,
         -0.1324532357065045,
         0.13245323570650452,
         -0.13245323570650452,
         0.13245323570650452},
        {0.13018891098082386,
         -0.13018891098082397,
         0.1301889109808239,
         -0.13018891098082389,
         0.13018891098082389,
         -0.1301889109808239,
         0.1301889109808239,
         -0.13018891098082389,
         0.13018891098082389,
         -0.1301889109808239,
         0.1301889109808239,
         -0.1301889109808239,
         0.1301889109808239,
         -0.1301889109808239,
         0.13018891098082394,
         -0.1301889109808239,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082397,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082394,
         0.13018891098082394,
         -0.13018891098082394,
         0.1301889109808239,
         -0.1301889109808239,
         0.1301889109808239,
         -0.1301889109808239,
         0.13018891098082389,
         -0.13018891098082389,
         0.13018891098082389,
         -0.13018891098082389,
         0.13018891098082389,
         -0.13018891098082389,
         0.13018891098082389,
         -0.13018891098082386,
         0.13018891098082386,
         -0.13018891098082386,
         0.13018891098082386,
         -0.13018891098082386,
         0.13018891098082386,
         -0.13018891098082383,
         0.13018891098082383,
         -0.13018891098082386,
         0.13018891098082386},
        {0.12803687993289595,
         -0.12803687993289636,
         0.128036879932896,
         -0.12803687993289603,
         0.12803687993289603,
         -0.12803687993289603,
         0.128036879932896,
         -0.12803687993289603,
         0.12803687993289603,
         -0.12803687993289603,
         0.128036879932896,
         -0.128036879932896,
         0.128036879932896,
         -0.128036879932896,
         0.128036879932896,
         -0.128036879932896,
         0.128036879932896,
         -0.128036879932896,
         0.12803687993289598,
         -0.12803687993289598,
         0.12803687993289598,
         -0.12803687993289598,
         0.12803687993289598,
         -0.12803687993289598,
         0.12803687993289598,
         -0.12803687993289598,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289592,
         0.12803687993289592,
         -0.12803687993289592,
         0.12803687993289592,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289595,
         0.12803687993289595,
         -0.12803687993289592,
         0.12803687993289592,
         -0.12803687993289592,
         0.12803687993289592,
         -0.12803687993289595,
         0.12803687993289595}
    };

    m_array_all = {
        {
        {0, 0}
        },
        {
        {-1, 1},
        {0, 0},
        {1, -1}
        },
        {
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2}
        },
        {
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3}
        },
        {
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4}
        },
        {
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5}
        },
        {
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6}
        },
        {
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7}
        },
        {
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8}
        },
        {
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9}
        },
        {
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10}
        },
        {
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11}
        },
        {
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12}
        },
        {
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13}
        },
        {
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14}
        },
        {
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15}
        },
        {
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16}
        },
        {
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17}
        },
        {
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18}
        },
        {
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19}
        },
        {
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20}
        },
        {
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21}
        },
        {
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22}
        },
        {
        {-23, 23},
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22},
        {23, -23}
        },
        {
        {-24, 24},
        {-23, 23},
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22},
        {23, -23},
        {24, -24}
        },
        {
        {-25, 25},
        {-24, 24},
        {-23, 23},
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22},
        {23, -23},
        {24, -24},
        {25, -25}
        },
        {
        {-26, 26},
        {-25, 25},
        {-24, 24},
        {-23, 23},
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22},
        {23, -23},
        {24, -24},
        {25, -25},
        {26, -26}
        },
        {
        {-27, 27},
        {-26, 26},
        {-25, 25},
        {-24, 24},
        {-23, 23},
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22},
        {23, -23},
        {24, -24},
        {25, -25},
        {26, -26},
        {27, -27}
        },
        {
        {-28, 28},
        {-27, 27},
        {-26, 26},
        {-25, 25},
        {-24, 24},
        {-23, 23},
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22},
        {23, -23},
        {24, -24},
        {25, -25},
        {26, -26},
        {27, -27},
        {28, -28}
        },
        {
        {-29, 29},
        {-28, 28},
        {-27, 27},
        {-26, 26},
        {-25, 25},
        {-24, 24},
        {-23, 23},
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22},
        {23, -23},
        {24, -24},
        {25, -25},
        {26, -26},
        {27, -27},
        {28, -28},
        {29, -29}
        },
        {
        {-30, 30},
        {-29, 29},
        {-28, 28},
        {-27, 27},
        {-26, 26},
        {-25, 25},
        {-24, 24},
        {-23, 23},
        {-22, 22},
        {-21, 21},
        {-20, 20},
        {-19, 19},
        {-18, 18},
        {-17, 17},
        {-16, 16},
        {-15, 15},
        {-14, 14},
        {-13, 13},
        {-12, 12},
        {-11, 11},
        {-10, 10},
        {-9, 9},
        {-8, 8},
        {-7, 7},
        {-6, 6},
        {-5, 5},
        {-4, 4},
        {-3, 3},
        {-2, 2},
        {-1, 1},
        {0, 0},
        {1, -1},
        {2, -2},
        {3, -3},
        {4, -4},
        {5, -5},
        {6, -6},
        {7, -7},
        {8, -8},
        {9, -9},
        {10, -10},
        {11, -11},
        {12, -12},
        {13, -13},
        {14, -14},
        {15, -15},
        {16, -16},
        {17, -17},
        {18, -18},
        {19, -19},
        {20, -20},
        {21, -21},
        {22, -22},
        {23, -23},
        {24, -24},
        {25, -25},
        {26, -26},
        {27, -27},
        {28, -28},
        {29, -29},
        {30, -30}
        }
    };

}
